/***********************************************************************************

	Copyright (C) 2007-2011 Ahmet Öztürk (aoz_2@yahoo.com)

	This file is part of Lifeograph.

	Lifeograph is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Lifeograph is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_PANEL_DIARY_HEADER
#define LIFEOGRAPH_PANEL_DIARY_HEADER


#include "diary.hpp"
#include "widget_entrylist.hpp"


namespace LIFEO
{

class PanelDiary
{
	public:

								PanelDiary( void );

        //void                    update_toolbar( void );
		void					update_entry_list( void );
        void                    update_entry_list_style( void );
		void					update_calendar( void );
        void                    update_button_remove_filters( void );

		void					show( const DiaryElement* );
		void                    show_today( void );
		void					present_current_row( void );
		void					show_prev_session_elem( void );

		void					handle_calendar_monthchanged( void );
		void					handle_calendar_dayselected( void );
		void					select_date_in_calendar( const Date& );

		void					handle_filter_favorites_toggled( void );
		void					remove_filters( void );
		void					handle_login( void );
		void					handle_logout( void );

		void					handle_entry_filter_changed( void );
		void					go_prev_match( void );
		void					go_next_match( void );
		void					replace_match( void );
		void					replace_all_matches( void );

        void                    handle_entry_title_changed( DiaryElement* );

		Gtk::TreeRow			get_row( const Gtk::TreePath& );
		DiaryElement*           get_dragged_elem( void )
		{ return m_treeview_entries->get_dragged_elem(); }

		void					handle_treeview_row_expanded( const Gtk::TreeIter&,
															  const Gtk::TreePath& );

	protected:
        void                    handle_add_entry( void );
        void                    handle_add_topic( void );
        void                    handle_add_chapter( void );

		WidgetEntryList			*m_treeview_entries;

		Gtk::Calendar			*m_calendar;
		EntryIdletext			*m_entry_filter;
		EntryIdletext			*m_entry_replace;
        Gtk::Button             *m_button_match_prev;
        Gtk::Button             *m_button_match_next;
        Gtk::Box                *m_toolbar_replace;
        Gtk::Button             *m_button_replace;
        Gtk::Button             *m_button_replace_all;

		Gtk::RadioMenuItem		*m_menuitem_sort_by_date;
		Gtk::RadioMenuItem		*m_menuitem_sort_by_size;

		Gtk::ToggleButton       *m_togglebtn_filter_favorites;
		Gtk::Button             *m_button_remove_filters;

		Menubutton              *m_button_add;
        Gtk::ImageMenuItem      *m_menuitem_add_entry;
        Gtk::ImageMenuItem      *m_menuitem_add_topic;
        Gtk::ImageMenuItem      *m_menuitem_add_chapter;
        Gtk::Separator          *m_sprt_tb1;

        Glib::RefPtr< Gtk::Action > m_action_today;
        Glib::RefPtr< Gtk::Action > m_action_previous_list;
        Glib::RefPtr< Gtk::Action > m_action_next_list;
        Glib::RefPtr< Gtk::Action > m_action_focusfilter;
        Glib::RefPtr< Gtk::Action > m_action_previous_match;
        Glib::RefPtr< Gtk::Action > m_action_next_match;
        Glib::RefPtr< Gtk::Action > m_action_jump2current;
        Glib::RefPtr< Gtk::Action > m_action_show_prev_session_elem;

		// LISTING TMP VARIABLES
		void					add_chapter_category_to_list( const CategoryChapters* );
		Entryiter				l_itr_entry;
		Gtk::TreeRow			l_row_diary;
		Gtk::TreeRow			l_row_entry;
		Entry					*l_entry;

	friend class Lifeograph;
};

} // end of namespace LIFEO

#endif
