/***********************************************************************************

	Copyright (C) 2007-2011 Ahmet Öztürk (aoz_2@yahoo.com)

	This file is part of Lifeograph.

	Lifeograph is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Lifeograph is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#include "lifeobase.hpp"
#include "helpers.hpp"

using namespace LIFEO;

// STATIC MEMBERS
Lifeobase							*Lifeobase::base;
Settings							Lifeobase::settings;
Icons								*Lifeobase::icons = NULL;
Glib::RefPtr< Gtk::Builder >		Lifeobase::builder;
Glib::RefPtr< Gtk::ActionGroup >	Lifeobase::m_actions;
int									Lifeobase::m_internaloperation = 0;
int									Lifeobase::m_entrycount = 0;
sigc::connection					Lifeobase::m_connection_timeout;
SignalVoid							Lifeobase::m_signal_logout;
Lifeobase::LoginStatus              Lifeobase::loginstatus = Lifeobase::LOGGED_OUT;
std::set< std::string >             Lifeobase::stock_diaries;


Lifeobase::Lifeobase()
:   m_flag_open_directly( false )
{
	base = this;
	m_actions = Gtk::ActionGroup::create( "main actions" );

	drag_targets_tag.push_back( Gtk::TargetEntry( TARGET_ENTRY_TAG,
												  Gtk::TARGET_SAME_APP,
												  DRAG_TARGET_TAG_INFO ) );
	drag_targets_theme.push_back( Gtk::TargetEntry( TARGET_ENTRY_THEME,
													Gtk::TARGET_SAME_APP,
													DRAG_TARGET_THEME_INFO ) );
	drag_targets_entry.push_back( Gtk::TargetEntry( TARGET_ENTRY_ENTRY,
													Gtk::TARGET_SAME_APP,
													DRAG_TARGET_ENTRY_INFO ) );

	// ICONS
	icons = new Icons;
	Glib::RefPtr< Gtk::IconTheme > theme = Gtk::IconTheme::get_default();
	icons->diary_16 = Gdk::Pixbuf::create_from_file( ICONDIR "/diary-16.png" );
	icons->diary_32 = Gdk::Pixbuf::create_from_file( ICONDIR "/diary-32.png" );
	icons->entry_16 = Gdk::Pixbuf::create_from_file( ICONDIR "/entry-16.png" );
	icons->entry_32 = Gdk::Pixbuf::create_from_file( ICONDIR "/entry-32.png" );
	icons->entry_favorite_16 = Gdk::Pixbuf::create_from_file( ICONDIR "/favorite-16.png" );
	icons->tag_16 = Gdk::Pixbuf::create_from_file( ICONDIR "/tag-16.png" );
	icons->tag_32 = Gdk::Pixbuf::create_from_file( ICONDIR "/tag-32.png" );
	icons->tag_category_16 = Gdk::Pixbuf::create_from_file( ICONDIR "/category_tags-16.png" );
	icons->tag_category_32 = Gdk::Pixbuf::create_from_file( ICONDIR "/category_tags-32.png" );
	icons->chapter_16 = Gdk::Pixbuf::create_from_file( ICONDIR "/chapter-16.png" );
	icons->chapter_32 = Gdk::Pixbuf::create_from_file( ICONDIR "/chapter-32.png" );
	//icons->theme_16 = theme->load_icon( "gtk-select-color", 16 );
	icons->theme_32 = theme->load_icon( "gtk-select-color", 32 );
	icons->month_16 = Gdk::Pixbuf::create_from_file( ICONDIR "/month-16.png" );
	icons->month_32 = Gdk::Pixbuf::create_from_file( ICONDIR "/month-32.png" );
	icons->filter_16 = Gdk::Pixbuf::create_from_file( ICONDIR "/filter-16.png" );
}

bool
Lifeobase::load_gui( const std::string &path )
{
	builder = Gtk::Builder::create();
	try
	{
		builder->add_from_file( path );
	}
	catch( const Glib::FileError& ex )
	{
		std::cerr << "FileError: " << ex.what() << std::endl;
		return false;
	}
	catch( const Gtk::BuilderError& ex )
	{
		std::cerr << "BuilderError: " << ex.what() << std::endl;
		return false;
	}

	return true;
}

void
Lifeobase::create_action(	Glib::RefPtr< Gtk::Action >			&action,
							/*Glib::RefPtr< Gtk::ActionGroup >	&actiongroup,*/
							const Glib::ustring					&name,
							const Gtk::StockID					&stockid,
							const Glib::ustring					&label,
							const Glib::ustring					&tooltip,
							const Gtk::AccelKey					&accelkey,
							const Glib::SignalProxy0< void >::SlotType
																&slot,
							Gtk::Activatable					*widget_proxy )
{
	action  = Gtk::Action::create( name, stockid, label, tooltip );
	m_actions->add( action, accelkey );
	action->set_accel_group( base->get_accel_group() );
	action->connect_accelerator();
	if( widget_proxy != NULL )
	    widget_proxy->set_related_action( action );
	action->signal_activate().connect( slot );
}

void
Lifeobase::create_action(   Glib::RefPtr< Gtk::Action >         &action,
                            const Glib::ustring                 &name,
                            const Glib::ustring                 &icon_name,
                            const Glib::ustring                 &label,
                            const Glib::ustring                 &tooltip,
                            const Gtk::AccelKey                 &accelkey,
                            const Glib::SignalProxy0< void >::SlotType
                                                                &slot,
                            Gtk::Activatable                    *widget_proxy )
{
    action  = Gtk::Action::create_with_icon_name( name, icon_name, label, tooltip );
    m_actions->add( action, accelkey );
    action->set_accel_group( base->get_accel_group() );
    action->connect_accelerator();
    if( widget_proxy != NULL )
        widget_proxy->set_related_action( action );
    action->signal_activate().connect( slot );
}

// DIALOGEVENT =====================================================================================
HELPERS::DialogEvent::DialogEvent( const Glib::ustring &title )
:   Gtk::Dialog( title )
{
    set_transient_for( *Lifeobase::base );
    Lifeobase::signal_logout().connect( sigc::mem_fun( this, &DialogEvent::handle_logout ) );
}

HELPERS::DialogEvent::DialogEvent( BaseObjectType *cobject,
                          const Glib::RefPtr< Gtk::Builder >& )
:   Gtk::Dialog( cobject )
{
    set_transient_for( *Lifeobase::base );
    //Lifeobase::signal_logout().connect( sigc::mem_fun( this, &DialogEvent::handle_logout ) );
}

bool
HELPERS::DialogEvent::on_event( GdkEvent *event )
{
    return Lifeobase::base->on_event( event );
}

