/***********************************************************************************

	Copyright (C) 2009 Ahmet Öztürk (aoz_2@yahoo.com)

	This file is part of Lifeograph.

	Lifeograph is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Lifeograph is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_DIALOG_EXPORT_HEADER
#define LIFEOGRAPH_DIALOG_EXPORT_HEADER


#include <gtkmm.h>

#include "diary.hpp"
#include "gui_tag.hpp"


namespace LIFEO
{

// EXPORTERS =======================================================================================
class Diarysaver
{
	public:
	typedef sigc::signal< void, bool >
									Signal_void_bool;

		virtual Gtk::Widget*		draw_options( void ) = 0;
		virtual bool				is_ready( void ) = 0;
		virtual Result				save( const std::string&, bool ) = 0;

		Glib::ustring				get_name( void )
		{ return m_name; }

		Signal_void_bool			signal_updated( void )
		{ return m_signal_updated; }

	protected:
									Diarysaver( const Glib::ustring&, Diary* );

		Glib::ustring				m_name;
		Diary						*m_ptr2diary;

		Signal_void_bool			m_signal_updated;
};

class ExporterLifeograph : public Diarysaver
{
	public:
        explicit                    ExporterLifeograph( Diary* );
        Gtk::Widget*                draw_options( void );
        bool                        is_ready( void );
        Result                      save( const std::string&, bool );

        void                        handle_passphrase_changed( void );
        void                        handle_encryption_changed( void );

    private:
        Gtk::CheckButton            *m_check_encrypt;
        Gtk::Entry                  *m_entry_passphrase;
        Gtk::Entry                  *m_entry_confirm;
        std::string                 m_passphrase;

        bool                        m_flag_encrypted;
};

class ExporterText : public Diarysaver
{
	public:
		explicit					ExporterText( Diary* );
		Gtk::Widget*				draw_options( void )
		{ return NULL; }

		bool						is_ready( void )
		{ return true; }

		Result						save( const std::string&, bool );
};

// FILE SELECTION DIALOG ===========================================================================
class DialogSaveDiary : public Gtk::FileChooserDialog
{
	public:
									DialogSaveDiary();

        std::string                 get_filename( const std::string& = "" );
		std::string                 get_filename_default( void );
};

// FILE SAVE DIALOG ================================================================================
class DialogOpenDiary : public Gtk::FileChooserDialog
{
    public:
                                    DialogOpenDiary();

        // FILTERING
        static void                init_filters( void );

        static Glib::RefPtr< Gtk::FileFilter >
                                    filter_any;
        static Glib::RefPtr< Gtk::FileFilter >
                                    filter_diary;

    protected:
        static bool                 flag_filters_created;
};

// PASSWORD PROMPT DIALOG ==========================================================================
class DialogPasswordPrompt : public DialogEvent
{
	public:
									DialogPasswordPrompt(
											BaseObjectType*,
											const Glib::RefPtr< Gtk::Builder >& );

		Glib::ustring               get_password( void ) const
		{ return m_entry->get_text(); }

	protected:
		void						on_hide( void );
		void						handle_entry_changed( void );

		EntryIdletext				*m_entry;

	friend class DialogImport;
};

// IMPORT DIALOG ===================================================================================
class DialogImport : public DialogEvent
{
	public:
                                    DialogImport( BaseObjectType*,
                                                  const Glib::RefPtr< Gtk::Builder >& );

		void						on_show( void );
		void						on_response( int );

		void						handle_diary_changed( void );
		void						handle_parts_changed( void );

		void						set_ready( void );
		void						set_not_ready( const Glib::ustring& );

		bool						is_options_ready( void );

	private:
		Gtk::FileChooserButton		*m_file_chooser_button;
		Gtk::Label					*m_label_info;
		Gtk::Label					*m_label_entries;
		Gtk::Label					*m_label_tags;
		Gtk::Label					*m_label_themes;
		TagWidget					*m_tag_widget;
		Gtk::Entry					*m_entry_password;

		Gtk::CheckButton			*m_checkbutton_import_entries;
		Gtk::CheckButton			*m_checkbutton_import_tags;
		Gtk::CheckButton			*m_checkbutton_import_themes;

		DialogPasswordPrompt		*m_dialog_password;

		Diary						*m_diary;

		bool						m_option_import_entries;
		bool						m_option_import_tags;
		bool						m_option_import_themes;
		bool						m_flag_diary_is_ready;

};

// EXPORT DIALOG ===================================================================================
class DialogExport : public DialogEvent
{
	public:
                                    DialogExport( BaseObjectType*,
                                                  const Glib::RefPtr< Gtk::Builder >& );

		void						add_saver( Diarysaver* );

	protected:
		virtual void				on_response( int );

		void						handle_savetype_changed( void );
		void						handle_saver_updated( bool );

        Gtk::ComboBoxText           *m_combo_type;
        Gtk::ComboBoxText           *m_combo_extent;
        Gtk::Button                 *m_button_export;
        Gtk::Alignment              *m_align_options;
        Gtk::Frame                  *m_frame_options;
        Gtk::Widget                 *m_ptr2widget_options;

		std::vector< Diarysaver* >
									m_savers;
		Diarysaver                  *m_saver_cur;

		Diary						*m_ptr2diary;
		bool						m_flag_saverready;

	private:

};

} // end of namespace LIFEO

#endif

