/***********************************************************************************

	Copyright (C) 2007-2011 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_HEADER
#define LIFEOGRAPH_HEADER

#define LIFEOGRAPH_DEVELOPMENT_VERSION


#include <gtkmm.h>

#include "lifeobase.hpp"
#include "helpers.hpp"
#include "settings.hpp"
#include "panel_main.hpp"
#include "panel_diary.hpp"
#include "widget_textview.hpp"
#include "widget_panel_exp.hpp"
#include "dialog_export.hpp"
#include "view_entry.hpp"
#include "undo.hpp"


namespace LIFEO
{
	// LONG AND EPIC TEXT MESSAGES
	namespace STRING
	{
		const char		SLOGAN[]    = N_(	"Personal, digital diary" );

		const char      WRONG_PASSWORD[]
                                    = N_(	"Wrong password. Please retry..." );

		const char      ENTER_PASSWORD[]
                                    = N_(	"Please enter password for selected diary..." );

		const char      ENTER_PASSWORD_TIMEOUT[]
                                    = N_(	"Program logged out to protect your privacy. "
											"Please re-enter password..." );

		const char		INCOMPATIBLE_DB[]
									= N_(	"Selected diary is not compatible with "
											"this version of Lifeograph. "
											"Please select another file..." );

		const char		CORRUPT_DB[]
									= N_(	"Selected file is not a valid "
											"Lifeograph diary. "
											"Please select another file..." );

		const char		DIARY_LOCKED[]
									= N_( "Selected file is locked which means either it is "
										  "being edited by another instance of Lifeograph or "
										  "the last session with it did not finish correctly. "
										  "This file cannot be opened as long as the lock file "
										  "is there." );

		const char      FAILED_TO_OPEN_DB[]
                                    = N_(	"Failed to open diary. "
											"Please select anoter file..." );

		const char      DB_IS_NOT_ENCRYPTED[]
                                    = N_(	"Press Open to continue" );

		const char      SALUTATION[]    /*  TRANSLATORS: this is the message
                                            shown to the fist time users */
                                    = N_(	"Knowing others is intelligence;\n"
											"knowing yourself is true wisdom.\n"
											"Mastering others is strength;\n"
											"mastering yourself is true power.\n\n"
											"<i>--Lao Tzu</i>" );

		const char      CANNOT_WRITE[]
                                    = N_(	"Changes could not be written to diary!" );

		const char      CANNOT_WRITE_SUB[]
                                    = N_(	"Check if you have write permissions on the "
											"file and containing folder" );
	}


class Lifeograph : public Lifeobase
{
	public:
		enum				LoginStatus
		{
			LOGGED_OUT = 0, LOGGED_IN = 1, LOGGED_TIME_OUT = 2
		};

							Lifeograph( int, char** );
							~Lifeograph ();

		void                on_run( void );

		void				draw_welcomescreen( void );
		void				draw_loginscreen( void );
		void				draw_editscreen( void );
		void				create_actions( void );

		void				show_today( void );
		void				go_back( void );

		void				update_login_file( void );
		void				update_indices( void );
		void				update_entry_list();
		void				update_tag_list( void );
		void				update_tag_categories( void );
		void				update_button_filter_tag( void );
		void				update_button_remove_filters( void );
		void				update_tag_icon( const Tag* );
		void				update_theme_list( void );
		void				update_entryliststyle( void );
		void				update_calendar( void );
		void				update_title( void );
		void				update_toolbar( void );

		void				sync_entry( void );
		bool				confirm_dismiss_element( void );
		void				remove_element_from_history( DiaryElement* );
		bool				change_current_element( DiaryElement*, Gtk::Widget* );
		DiaryElement*		get_cur_elem( void );
		DiaryElement::Type	get_cur_elem_type( void );
		DiaryElement*		get_dragged_elem( void );
		Gtk::TreeRow		get_element_row( DiaryElement* );

		void				focus_filter( void );
		void				focus_tag( void );

		void                toggle_comments( void );

		void				initialize_new_diary( void );
		bool				write_backup( void );
		bool				finish_editing( bool = true );
		void				logout( bool );

		// SIGNAL HANDLERS
		bool				handle_idle( void );
		void				handle_filebutton_db_selectionchanged( void );
		void				handle_entry_password_changed( void );
		void				handle_button_opendb_clicked( void );
		void				handle_button_about_clicked( void );
		void				handle_button_quit_clicked( void );

		void				handle_textview_entry_changed( void );
		void				handle_textview_link_activated( const Date& );
		void				handle_entry_title_changed( DiaryElement* );
		void				handle_settings_changed( void );

		void				select_date_in_calendar( const Date& );

		void				handle_undo( void );
		void				handle_redo( void );

	protected:
		bool				on_delete_event( GdkEventAny* );
		bool				on_event( GdkEvent* );

		// WIDGETS
		Gtk::AboutDialog			*m_about_dialog;
		Gtk::Label					*m_label_login_info;
		FilebuttonRecent			*m_filebuttonrecent;
        EntryIdletext				*m_entry_password;
		Gtk::Button					*m_button_open_diary;

		Gtk::Menu					*m_menu_link;
		PanelMain					*m_panel_main;
		PanelDiary					*m_panel_diary;
		TagPanel					*m_panel_tag;
		WidgetPanelExp				*m_widget_panel_exp;

		Gtk::VBox					*m_vbox_login;
		Gtk::HPaned					*m_hpaned_entry;
		Gtk::HPaned					*m_hpaned_main;

        Gtk::Button                 *m_button_today;
        Gtk::Button                 *m_button_logout;

		sigc::connection			m_connection_backup;

		DiaryView					*m_diary_view;
		EntryView					*m_entry_view;
		TagView						*m_tag_view;
		CategoryTagsView			*m_category_tags_view;
		ChapterView					*m_chapter_view;
		ThemeView					*m_theme_view;

		// ACTIONS
		Glib::RefPtr< Gtk::Action >	m_action_undo;
		Glib::RefPtr< Gtk::Action >	m_action_redo;
		Glib::RefPtr< Gtk::Action >	m_action_previous_list;
		Glib::RefPtr< Gtk::Action >	m_action_next_list;
		Glib::RefPtr< Gtk::Action >	m_action_previous_browsing;
		Glib::RefPtr< Gtk::Action >	m_action_previous_match;
		Glib::RefPtr< Gtk::Action >	m_action_next_match;
		Glib::RefPtr< Gtk::Action >	m_action_today;
		Glib::RefPtr< Gtk::Action >	m_action_jump2current;
		Glib::RefPtr< Gtk::Action >	m_action_show_prev_session_elem;
		Glib::RefPtr< Gtk::Action >	m_action_focusfilter;
		Glib::RefPtr< Gtk::Action >	m_action_focustag;

		// VARIABLES
		const std::string			m_programpath;
		LoginStatus					m_loginstatus;
		bool						m_flag_firsttimeuser;
		bool						m_flag_ignore_locks;
        bool                        m_flag_open_directly;
        bool                        m_flag_force_welcome;
};

} // end of namespace LIFEO

#endif
