/***********************************************************************************

	Copyright (C) 2007-2011 Ahmet Öztürk (aoz_2@yahoo.com)

	This file is part of Lifeograph.

	Lifeograph is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Lifeograph is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_WIDGETCHART_HEADER
#define LIFEOGRAPH_WIDGETCHART_HEADER


#include <gtkmm/drawingarea.h>
#include <gtkmm/builder.h>

#include "helpers.hpp"


namespace LIFEO
{

class ChartPoint
{
	public:
									ChartPoint( Date, int );

		Date						date;
		int							value;

};


class ChartPoints : public std::vector< ChartPoint >
{
	public:
									ChartPoints( void );
		void						add( ChartPoint& );
		void						add( Date, int );

		int							value_min;
		int							value_max;
		unsigned int				current;
		bool						flag_use_current;
};


class WidgetChart : public Gtk::DrawingArea
{
	public:
		// CONSTANTS
		const static float			border_curve = 30.0;
		const static float			border_label = 10.0;
		const static float			offset_label = 5.0;
		const static float			label_height = 12.0;
		const static float			bar_height = 25.0;
		const static float			OVERVIEW_HEIGHT = 70.0;
		const static float			COLUMN_WIDTH_MIN = 45.0;
		// CALCULATED CONSTANTS
		const static float			label_y = 5.0 + 12.0;	// = offset_label + label_height;
		const static float			x_min = 30.0 + 10.0; // = border_curve + border_label
		const static float			y_min = 30.0;	// = border_curve;

									WidgetChart( BaseObjectType*,
												 const Glib::RefPtr< Gtk::Builder >& );
		void						set_points( ChartPoints* );

	protected:
		void						on_size_allocate( Gtk::Allocation& );
		bool						on_scroll_event( GdkEventScroll* );
		bool						on_button_press_event( GdkEventButton* );
		bool						on_button_release_event( GdkEventButton* );
		bool						on_motion_notify_event( GdkEventMotion* );
		bool						on_leave_notify_event( GdkEventCrossing* );
		bool						on_expose_event( GdkEventExpose* );

		void						update_col_geom( bool = false );

		// DATA
		ChartPoints					*m_points;
		// GEOMETRY
		int							m_width;
		int							m_height;
		unsigned int				m_col_count;
		unsigned int				m_col_start;

		float						x_max, y_max, y_mid, amplitude, length, column_count_max;
		float						step_x, coefficient;
		float						m_overview_height;

		Cairo::RefPtr< Cairo::ToyFontFace >
									m_font_main;

		bool						m_flag_button_pressed;
		bool						m_flag_pointer_hovered;
};

} // end of namespace LIFEO

#endif
