/***********************************************************************************

	Copyright (C) 2007-2011 Ahmet Öztürk (aoz_2@yahoo.com)

	This file is part of Lifeograph.

	Lifeograph is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Lifeograph is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_BASE_HEADER
#define LIFEOGRAPH_BASE_HEADER


#include <gtkmm.h>

#include "settings.hpp"
#include "diary.hpp"


namespace LIFEO
{
	const char			PROGRAM_NAME[]				= "Lifeograph";
	const int			PROGRAM_VERSION_INT			= 7040;
	const char			PROGRAM_VERSION_STRING[]	= "0.7.4";

	const int			BACKUP_INTERVAL				= 30;	// seconds
	const int			LOGOUT_COUNTDOWN			= 10;	// seconds

	const static int	MIN_FOLDER_SIZE				= 8;

	const static char	TARGET_ENTRY_TAG[]			= "GTK_TREE_MODEL_ROW_TAG";
	const static char	TARGET_ENTRY_THEME[]		= "GTK_TREE_MODEL_ROW_THEME";
	const static char	TARGET_ENTRY_ENTRY[]		= "GTK_TREE_MODEL_ROW_ENTRY";

enum DragTargetEntryInfo
{
	DRAG_TARGET_TAG_INFO = 100, DRAG_TARGET_THEME_INFO = 200, DRAG_TARGET_ENTRY_INFO = 300
};

struct Icons
{
	Glib::RefPtr< Gdk::Pixbuf >		diary_16;
	Glib::RefPtr< Gdk::Pixbuf >		diary_32;
	Glib::RefPtr< Gdk::Pixbuf >		entry_16;
	Glib::RefPtr< Gdk::Pixbuf >		entry_32;
	Glib::RefPtr< Gdk::Pixbuf >		entry_favorite_16;
	Glib::RefPtr< Gdk::Pixbuf >		tag_16;
	Glib::RefPtr< Gdk::Pixbuf >		tag_32;
	Glib::RefPtr< Gdk::Pixbuf >		tag_category_16;
	Glib::RefPtr< Gdk::Pixbuf >		tag_category_32;
	Glib::RefPtr< Gdk::Pixbuf >		chapter_16;
	Glib::RefPtr< Gdk::Pixbuf >		chapter_32;
	Glib::RefPtr< Gdk::Pixbuf >		theme_16;
	Glib::RefPtr< Gdk::Pixbuf >		theme_32;
	Glib::RefPtr< Gdk::Pixbuf >		month_16;
	Glib::RefPtr< Gdk::Pixbuf >		month_32;
	Glib::RefPtr< Gdk::Pixbuf >		filter_16;
};

// static Lifeograph base
class Lifeobase : public Gtk::Window
{
	public:
									Lifeobase();

		static Lifeobase			*base;
		static Settings				m_settings;
		static Icons				*icons;

		static Glib::RefPtr<Gdk::Pixbuf>
									pixbuf_background;

		static Glib::RefPtr< Gtk::Builder >
									builder;

		Gtk::Widget					*m_contentwidget;

		static void					create_action(
				Glib::RefPtr< Gtk::Action >&,
				/*Glib::RefPtr< Gtk::ActionGroup >&,*/
				const Glib::ustring&,
				const Gtk::StockID&,
				const Glib::ustring&,
				const Glib::ustring&,
				const Gtk::AccelKey&,
				const Glib::SignalProxy0< void >::SlotType&,
				Gtk::Widget* = NULL );

		void						set_header_texts( const Glib::ustring&,
													  const Glib::ustring&,
													  const Glib::ustring& = "" );
		static void					set_gelem_toolbar( Gtk::Widget* );

		virtual bool				on_event( GdkEvent* ) = 0;

		bool						load_gui( const std::string& );

		// communication functions
		virtual void				logout( bool ) = 0;
		virtual void				update_entry_list( void ) = 0;
		virtual void				update_tag_list( void ) = 0;
		virtual void				update_calendar( void ) = 0;
		virtual void				update_filter_tag( void ) = 0;
		virtual void				update_tag_icon( Tag* ) = 0;
		virtual void				update_tag_categories( void ) = 0;
		virtual void				select_date_in_calendar( const Date& ) = 0;
		virtual void				update_theme_list( void ) = 0;
		virtual void				sync_entry( void ) = 0;
		virtual bool				confirm_dismiss_element( void ) = 0;
		virtual void				remove_element_from_history( DiaryElement* ) = 0;
		virtual bool				change_current_element( DiaryElement*, Gtk::Widget* ) = 0;
		virtual void				handle_entry_title_changed( DiaryElement* ) = 0;
		virtual void				handle_settings_changed( void ) = 0;
		virtual DiaryElement*		get_cur_elem( void ) = 0;
		virtual DiaryElement::Type	get_cur_elem_type( void ) = 0;
		virtual DiaryElement*		get_dragged_elem( void ) = 0;
		virtual Gtk::TreeRow		get_element_row( DiaryElement* ) = 0;
		virtual void				focus_tag( void ) = 0;

		int							m_secondsremaining;
		static int					m_internaloperation;
		static int					m_entrycount;
		static bool					flag_allocate_gui_for_dairy;

		static Gtk::Button			*m_button_gui_elem;
		static Gtk::Image			*m_image_gui_elem;
		static Gtk::HBox			*m_hbox_gelem_header;
		static Gtk::Widget			*m_current_gelem_toolbar;
		Gtk::Label					*m_label_gui_elem;
		Gtk::Label					*m_label_gui_elem_extra;

		std::vector< Gtk::TargetEntry >
									drag_targets_tag;
		std::vector< Gtk::TargetEntry >
									drag_targets_theme;
		std::vector< Gtk::TargetEntry >
									drag_targets_entry;

		static SignalVoid			signal_logout( void )
		{ return m_signal_logout; }

	protected:
		static sigc::connection		m_connection_timeout;

		virtual bool				on_expose_event( GdkEventExpose* ) = 0;

		static Glib::RefPtr< Gtk::ActionGroup >
									m_actions;

		static SignalVoid			m_signal_logout;
};

class DialogEvent : public Gtk::Dialog
{
	public:
							DialogEvent( const Glib::ustring& );
							DialogEvent(	BaseObjectType*,
											const Glib::RefPtr< Gtk::Builder >& );

	protected:
		bool				on_event( GdkEvent* );
		void				handle_logout( void );

};

} // end of namespace LIFEO

#endif

