/***********************************************************************************

	Copyright (C) 2007-2011 Ahmet Öztürk (aoz_2@yahoo.com)

	This file is part of Lifeograph.

	Lifeograph is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Lifeograph is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_DIARY_TAG_GUI_HEADER
#define LIFEOGRAPH_DIARY_TAG_GUI_HEADER


namespace LIFEO
{

/*
// TAGWIDGET (A COMBOBOXENTRY FOR TAGS)
class Tagwidget : public Gtk::ComboBoxEntry
{
	public:
		enum OperationType
		{
			OT_EDIT,
			OT_CREATE
		};

									Tagwidget( OperationType, PoolTags* );

		void						set_model( const Glib::RefPtr< Gtk::TreeModel >& );
		void						set_text_column( const Gtk::TreeModelColumnBase& );

		bool						is_activatable( void ) const
		{ return m_flag_activatable; }

		virtual void				on_remove( Gtk::Widget* );
		virtual void				on_activate( void );
		SignalVoid					signal_activate( void )
		{ return m_signal_activate; }

		void						handle_icon_release(	Gtk::EntryIconPosition,
															const GdkEventButton* );

	protected:
		void						on_changed( void );
		bool						compare_text(	const Glib::ustring&,
													const Gtk::TreeModel::const_iterator& );

		EntryIdletext				m_entry;
		Glib::RefPtr< Gtk::TreeModel >
									m_model;
		Glib::RefPtr< Gtk::EntryCompletion >
									m_entrycompletion;
		bool						m_flag_activatable;
		bool						m_flag_empty;
		OperationType				m_operation;
		PoolTags					*m_ptr2tagpool;

		SignalVoid					m_signal_activate;
};
*/
class TagWidget : public EntryIdletext
{
	public:
									TagWidget( BaseObjectType*,
											   const Glib::RefPtr< Gtk::Builder >& );

		void						populate( const Tagset* );
		void						populate( void );

	protected:

		bool						compare_text( const Glib::ustring&,
												  const Gtk::TreeModel::const_iterator& );

		Glib::RefPtr< Gtk::EntryCompletion >
									m_completion;
		Glib::RefPtr< Gtk::ListStore >
									m_liststore;
};

// TAG PANEL
class TagPanel
{
	public:
		class Colrec : public Gtk::TreeModel::ColumnRecord
		{
			public:
				Colrec()
				{
					add( icon );
					add( name );
					add( ptr );
				}
				Gtk::TreeModelColumn< Glib::RefPtr< Gdk::Pixbuf > >		icon;
				Gtk::TreeModelColumn< Glib::ustring >					name;
				Gtk::TreeModelColumn< DiaryElement* >					ptr;
		};
		static Colrec				*colrec;

									TagPanel( void );

		void						populate_main( const Glib::ustring& = "" );
		void						update_tag_icon( const Tag* );

		Gtk::TreeRow				get_row( const Gtk::TreePath& );

	protected:
		void						handle_treeview_drag_begin(
											const Glib::RefPtr< Gdk::DragContext >& );
		void						handle_drag_data_get( const Glib::RefPtr<Gdk::DragContext>&,
														  Gtk::SelectionData&,
														  guint, guint );
		void						handle_treeview_button_press( GdkEventButton* );
		void						handle_treeview_button_release( GdkEventButton* );
		void						handle_treeview_row_expanded( const Gtk::TreeIter&,
																  const Gtk::TreePath& );
		void						handle_treeview_row_activated( const Gtk::TreePath&,
																   Gtk::TreeViewColumn* );

		void						handle_remove_filter( void );

		Gtk::HBox					*m_hbox_tagbar;
		Gtk::TreeView				*m_treeview_all_tags;
		Gtk::Button					*m_button_remove_filter;

		Glib::RefPtr< Gtk::TreeStore >
									m_treestore_all_tags;

		Entry						*m_ptr2entry;
		Tag							*m_tag_dragged;

		bool						m_flag_dragging;

	friend class Lifeograph;
};

} // end of namespace LIFEO

#endif

