/***********************************************************************************

	Copyright (C) 2007-2012 Ahmet Öztürk (aoz_2@yahoo.com)

	This file is part of Lifeograph.

	Lifeograph is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Lifeograph is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_BASE_HEADER
#define LIFEOGRAPH_BASE_HEADER


#include <gtkmm.h>

#include "settings.hpp"
#include "diary.hpp"
#include "panel_main.hpp"
#include "panel_diary.hpp"
#include "view_entry.hpp"


namespace LIFEO
{
    const static char   PROGRAM_NAME[]              = "Lifeograph";
//  const static int    PROGRAM_VERSION_INT         = 11000;
    const static char   PROGRAM_VERSION_STRING[]    = "0.11.0";

    const static int    BACKUP_INTERVAL             = 30;	// seconds
    const static int    LOGOUT_COUNTDOWN            = 10;	// seconds

    const static int    MAX_THUMBNAIL_WIDTH         = 192;  // TODO: make adjustable

    const static char   TARGET_ENTRY_TAG[]          = "GTK_TREE_MODEL_ROW_TAG";
    const static char   TARGET_ENTRY_THEME[]        = "GTK_TREE_MODEL_ROW_THEME";
    const static char   TARGET_ENTRY_ENTRY[]        = "GTK_TREE_MODEL_ROW_ENTRY";

    // GENERIC STRINGS
    namespace STRING
    {
        const static char OFF[] = N_( "Off" );
        // TRANSLATORS: title of an empty diary entry
        const static char EMPTY_ENTRY_TITLE[] = N_( "<empty entry>" );
    }

enum DragTargetEntryInfo
{
	DRAG_TARGET_TAG_INFO = 100, DRAG_TARGET_THEME_INFO = 200, DRAG_TARGET_ENTRY_INFO = 300
};

struct Icons
{
	Glib::RefPtr< Gdk::Pixbuf >		diary_16;
	Glib::RefPtr< Gdk::Pixbuf >		diary_32;
	Glib::RefPtr< Gdk::Pixbuf >		entry_16;
	Glib::RefPtr< Gdk::Pixbuf >		entry_32;
	Glib::RefPtr< Gdk::Pixbuf >		entry_favorite_16;
    Glib::RefPtr< Gdk::Pixbuf >     entry_favorite_32;
	Glib::RefPtr< Gdk::Pixbuf >		tag_16;
	Glib::RefPtr< Gdk::Pixbuf >		tag_32;
	Glib::RefPtr< Gdk::Pixbuf >		tag_category_16;
	Glib::RefPtr< Gdk::Pixbuf >		tag_category_32;
	Glib::RefPtr< Gdk::Pixbuf >		chapter_16;
	Glib::RefPtr< Gdk::Pixbuf >		chapter_32;
	Glib::RefPtr< Gdk::Pixbuf >		theme_16;
    Glib::RefPtr< Gdk::Pixbuf >     theme_default_16;
	Glib::RefPtr< Gdk::Pixbuf >		theme_32;
	Glib::RefPtr< Gdk::Pixbuf >		month_16;
	Glib::RefPtr< Gdk::Pixbuf >		month_32;
	Glib::RefPtr< Gdk::Pixbuf >		filter_16;
};

typedef std::set< std::string > LanguageList;

// static Lifeograph base
class Lifeobase : public Gtk::Window
{
	public:
        enum LoginStatus
        {
            LOGGED_OUT = 0, LOGGED_IN = 1, LOGGED_TIME_OUT = 2
        };

									Lifeobase();
		virtual                     ~Lifeobase() {}

		static Lifeobase			*base;
		static Settings				settings;
		static Icons				*icons;

		static Glib::RefPtr< Gtk::Builder >
									builder;

		static void                 create_action(
                bool,
                Glib::RefPtr< Gtk::Action >&,
                const Glib::ustring&,
                const Gtk::StockID&,
                const Glib::ustring&,
                const Glib::ustring&,
                const Gtk::AccelKey&,
                const Glib::SignalProxy0< void >::SlotType&,
                Gtk::Activatable* = NULL );

        static void                 create_action(
                bool,
                Glib::RefPtr< Gtk::Action >&,
                const Glib::ustring&,
                const Glib::ustring&,
                const Glib::ustring&,
                const Glib::ustring&,
                const Gtk::AccelKey&,
                const Glib::SignalProxy0< void >::SlotType&,
                Gtk::Activatable* = NULL );

        static void                 create_toggle_action(
                bool,
                Glib::RefPtr< Gtk::ToggleAction >&,
                const Glib::ustring&,
                const Glib::ustring&,
                const Glib::ustring&,
                const Glib::ustring&,
                const Gtk::AccelKey&,
                const Glib::SignalProxy0< void >::SlotType&,
                Gtk::Activatable* = NULL );

		virtual bool				on_event( GdkEvent* ) = 0;

		bool						load_gui( const std::string& );

		// communication functions
        virtual void                login( void ) = 0;
        virtual void                logout( bool ) = 0;
        virtual void                freeze_auto_logout( void ) = 0;
        virtual void                unfreeze_auto_logout( void ) = 0;
		virtual bool				confirm_dismiss_element( void ) = 0;
		virtual Gtk::TreeRow		get_element_row( const DiaryElement* ) = 0;

		int							m_secondsremaining;
		static int					m_internaloperation;
		static int					m_entrycount;

		static PanelMain            *panel_main;
		static PanelDiary           *panel_diary;
		static PanelExtra           *panel_extra;

		static EntryView            *view_entry;
        static TagView              *view_tag;

		std::vector< Gtk::TargetEntry >
									drag_targets_tag;
		std::vector< Gtk::TargetEntry >
									drag_targets_entry;

        static EnchantBroker        *s_enchant_broker;
        static LanguageList         s_lang_list;

        static std::set< std::string > stock_diaries;

        static Glib::RefPtr< Gdk::Pixbuf >
                                    get_thumbnail( const std::string& );

		static SignalVoid			signal_logout( void )
		{ return m_signal_logout; }

        static LoginStatus          loginstatus;

        bool                        m_flag_open_directly;
        bool                        m_flag_read_only; // for command-line supplied file

	protected:
        static void                 fill_lang_list_cb( const char* const l, const char* const,
                                                       const char* const, const char* const,
                                                       void* )
        { s_lang_list.insert( l ); }

		static sigc::connection		m_connection_timeout;

		static SignalVoid			m_signal_logout;

        static Glib::RefPtr< Gtk::ActionGroup >
                                    m_actions_read;
        static Glib::RefPtr< Gtk::ActionGroup >
                                    m_actions_edit;

        // POOL OF THUMBNAILS FOR IMAGE LINKS IN DIARY
        typedef std::map< std::string, Glib::RefPtr< Gdk::Pixbuf > > MapPixbufs;
        static MapPixbufs           map_thumbnails;
};

} // end of namespace LIFEO

#endif

