/***********************************************************************************

	Copyright (C) 2007-2011 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_DIALOG_PASSWORD_HEADER
#define LIFEOGRAPH_DIALOG_PASSWORD_HEADER


#include <gtkmm/dialog.h>
#include <gtkmm/entry.h>

#include "helpers.hpp"


namespace LIFEO
{

// PASSWORD ADD/CHANGE DIALOG ======================================================================
class DialogPassword : public DialogEvent
{
	public:
							DialogPassword(	const std::string&, const Glib::ustring& );

        void				on_response( int );
		
        void				authenticate( void );
        void				check_match( void );

		bool				is_passphrase_set( void ) const
		{
			return m_passphrase_is_set;
		}

		std::string			get_passphrase( void ) const
		{
			return m_passphrase_new;
		}

	protected:
        Gtk::Button         *m_button_authenticate;
		Gtk::Button         *m_button_change;
		Gtk::Entry	        *m_entry_current;
		Gtk::Entry	        *m_entry_confirm;
		Gtk::Entry	        *m_entry_new;
        Gtk::Image          *m_image_match;

		const std::string	m_passphrase_old;
		std::string			m_passphrase_new;
		bool				m_passphrase_is_set;

	private:

};

// PASSWORD PROMPT DIALOG ==========================================================================
class DialogPasswordPrompt : public DialogEvent
{
    public:
                                    DialogPasswordPrompt(
                                            BaseObjectType*,
                                            const Glib::RefPtr< Gtk::Builder >& );

        int                         run( void );
        int                         run_again( void );

        void                        set_message( const Glib::ustring& );
        void                        set_path( const Glib::ustring& );
        Glib::ustring               get_password( void ) const
        { return m_entry->get_text(); }

    protected:
        void                        on_hide( void );
        void                        handle_entry_changed( void );

        EntryClear                  *m_entry;
        Gtk::Label                  *m_label_msg;
        Gtk::Label                  *m_label_path;

    friend class DialogImport;
};

} // end of namespace LIFEO

#endif

