/* Copyright 2017 R. Thomas
 * Copyright 2017 Quarkslab
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "LIEF/PE/utils.hpp"
#include "LIEF/MachO/utils.hpp"
#include "LIEF/ELF/utils.hpp"

#include "pyLIEF.hpp"

void init_utils_functions(py::module& m) {

#if defined(LIEF_PE_MODULE)
    m.def("is_pe",
        static_cast<bool (*)(const std::string&)>(&LIEF::PE::is_pe),
        "Check if the given file is a ``PE`` (from filename)",
        "filename"_a);

    m.def("is_pe",
        static_cast<bool (*)(const std::vector<uint8_t>&)>(&LIEF::PE::is_pe),
        "Check if the given raw data is a ``PE``",
        "raw"_a);
#endif

#if defined(LIEF_ELF_MODULE)
    m.def("is_elf",
        static_cast<bool (*)(const std::string&)>(&LIEF::ELF::is_elf),
        "Check if the given file is an ``ELF``",
        "filename"_a);


    m.def("is_elf",
        static_cast<bool (*)(const std::vector<uint8_t>&)>(&LIEF::ELF::is_elf),
        "Check if the given raw data is an ``ELF``",
        "raw"_a);
#endif

#if defined(LIEF_MACHO_MODULE)
    m.def("is_macho",
        static_cast<bool (*)(const std::string&)>(&LIEF::MachO::is_macho),
        "Check if the given file is a ``MachO`` (from filename)",
        "filename"_a);


    m.def("is_macho",
        static_cast<bool (*)(const std::vector<uint8_t>&)>(&LIEF::MachO::is_macho),
        "Check if the given raw data is a ``MachO``",
        "raw"_a);

#endif

}
