/* Copyright 2017 R. Thomas
 * Copyright 2017 Quarkslab
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "pyPE.hpp"
#include "LIEF/PE/Structures.hpp"
#include "LIEF/PE/EnumToString.hpp"

#define PY_ENUM(x) LIEF::PE::to_string(x), x

void init_PE_Structures_enum(py::module& m) {

  py::enum_<LIEF::PE::PE_TYPE>(m, "PE_TYPE")
    .value(PY_ENUM(LIEF::PE::PE_TYPE::PE32))
    .value(PY_ENUM(LIEF::PE::PE_TYPE::PE32_PLUS))
    .export_values();

  py::enum_<LIEF::PE::MACHINE_TYPES>(m, "MACHINE_TYPES")
    .value(PY_ENUM(LIEF::PE::MACHINE_TYPES::MT_Invalid))
    .value(PY_ENUM(LIEF::PE::MACHINE_TYPES::IMAGE_FILE_MACHINE_UNKNOWN))
    .value(PY_ENUM(LIEF::PE::MACHINE_TYPES::IMAGE_FILE_MACHINE_AM33))
    .value(PY_ENUM(LIEF::PE::MACHINE_TYPES::IMAGE_FILE_MACHINE_AMD64))
    .value(PY_ENUM(LIEF::PE::MACHINE_TYPES::IMAGE_FILE_MACHINE_ARM))
    .value(PY_ENUM(LIEF::PE::MACHINE_TYPES::IMAGE_FILE_MACHINE_ARMNT))
    .value(PY_ENUM(LIEF::PE::MACHINE_TYPES::IMAGE_FILE_MACHINE_EBC))
    .value(PY_ENUM(LIEF::PE::MACHINE_TYPES::IMAGE_FILE_MACHINE_I386))
    .value(PY_ENUM(LIEF::PE::MACHINE_TYPES::IMAGE_FILE_MACHINE_IA64))
    .value(PY_ENUM(LIEF::PE::MACHINE_TYPES::IMAGE_FILE_MACHINE_M32R))
    .value(PY_ENUM(LIEF::PE::MACHINE_TYPES::IMAGE_FILE_MACHINE_MIPS16))
    .value(PY_ENUM(LIEF::PE::MACHINE_TYPES::IMAGE_FILE_MACHINE_MIPSFPU))
    .value(PY_ENUM(LIEF::PE::MACHINE_TYPES::IMAGE_FILE_MACHINE_MIPSFPU16))
    .value(PY_ENUM(LIEF::PE::MACHINE_TYPES::IMAGE_FILE_MACHINE_POWERPC))
    .value(PY_ENUM(LIEF::PE::MACHINE_TYPES::IMAGE_FILE_MACHINE_POWERPCFP))
    .value(PY_ENUM(LIEF::PE::MACHINE_TYPES::IMAGE_FILE_MACHINE_R4000))
    .value(PY_ENUM(LIEF::PE::MACHINE_TYPES::IMAGE_FILE_MACHINE_SH3))
    .value(PY_ENUM(LIEF::PE::MACHINE_TYPES::IMAGE_FILE_MACHINE_SH3DSP))
    .value(PY_ENUM(LIEF::PE::MACHINE_TYPES::IMAGE_FILE_MACHINE_SH4))
    .value(PY_ENUM(LIEF::PE::MACHINE_TYPES::IMAGE_FILE_MACHINE_SH5))
    .value(PY_ENUM(LIEF::PE::MACHINE_TYPES::IMAGE_FILE_MACHINE_THUMB))
    .value(PY_ENUM(LIEF::PE::MACHINE_TYPES::IMAGE_FILE_MACHINE_WCEMIPSV2))
    .export_values();

  py::enum_<LIEF::PE::HEADER_CHARACTERISTICS>(m, "HEADER_CHARACTERISTICS")
    .value(PY_ENUM(LIEF::PE::HEADER_CHARACTERISTICS::IMAGE_FILE_RELOCS_STRIPPED))
    .value(PY_ENUM(LIEF::PE::HEADER_CHARACTERISTICS::IMAGE_FILE_EXECUTABLE_IMAGE))
    .value(PY_ENUM(LIEF::PE::HEADER_CHARACTERISTICS::IMAGE_FILE_LINE_NUMS_STRIPPED))
    .value(PY_ENUM(LIEF::PE::HEADER_CHARACTERISTICS::IMAGE_FILE_LOCAL_SYMS_STRIPPED))
    .value(PY_ENUM(LIEF::PE::HEADER_CHARACTERISTICS::IMAGE_FILE_AGGRESSIVE_WS_TRIM))
    .value(PY_ENUM(LIEF::PE::HEADER_CHARACTERISTICS::IMAGE_FILE_LARGE_ADDRESS_AWARE))
    .value(PY_ENUM(LIEF::PE::HEADER_CHARACTERISTICS::IMAGE_FILE_BYTES_REVERSED_LO))
    .value(PY_ENUM(LIEF::PE::HEADER_CHARACTERISTICS::IMAGE_FILE_32BIT_MACHINE))
    .value(PY_ENUM(LIEF::PE::HEADER_CHARACTERISTICS::IMAGE_FILE_DEBUG_STRIPPED))
    .value(PY_ENUM(LIEF::PE::HEADER_CHARACTERISTICS::IMAGE_FILE_REMOVABLE_RUN_FROM_SWAP))
    .value(PY_ENUM(LIEF::PE::HEADER_CHARACTERISTICS::IMAGE_FILE_NET_RUN_FROM_SWAP))
    .value(PY_ENUM(LIEF::PE::HEADER_CHARACTERISTICS::IMAGE_FILE_SYSTEM))
    .value(PY_ENUM(LIEF::PE::HEADER_CHARACTERISTICS::IMAGE_FILE_DLL))
    .value(PY_ENUM(LIEF::PE::HEADER_CHARACTERISTICS::IMAGE_FILE_UP_SYSTEM_ONLY))
    .value(PY_ENUM(LIEF::PE::HEADER_CHARACTERISTICS::IMAGE_FILE_BYTES_REVERSED_HI))
    .export_values();

  py::enum_<LIEF::PE::SUBSYSTEM>(m, "SUBSYSTEM")
    .value(PY_ENUM(LIEF::PE::SUBSYSTEM::IMAGE_SUBSYSTEM_UNKNOWN))
    .value(PY_ENUM(LIEF::PE::SUBSYSTEM::IMAGE_SUBSYSTEM_NATIVE))
    .value(PY_ENUM(LIEF::PE::SUBSYSTEM::IMAGE_SUBSYSTEM_WINDOWS_GUI))
    .value(PY_ENUM(LIEF::PE::SUBSYSTEM::IMAGE_SUBSYSTEM_WINDOWS_CUI))
    .value(PY_ENUM(LIEF::PE::SUBSYSTEM::IMAGE_SUBSYSTEM_OS2_CUI))
    .value(PY_ENUM(LIEF::PE::SUBSYSTEM::IMAGE_SUBSYSTEM_POSIX_CUI))
    .value(PY_ENUM(LIEF::PE::SUBSYSTEM::IMAGE_SUBSYSTEM_NATIVE_WINDOWS))
    .value(PY_ENUM(LIEF::PE::SUBSYSTEM::IMAGE_SUBSYSTEM_WINDOWS_CE_GUI))
    .value(PY_ENUM(LIEF::PE::SUBSYSTEM::IMAGE_SUBSYSTEM_EFI_APPLICATION))
    .value(PY_ENUM(LIEF::PE::SUBSYSTEM::IMAGE_SUBSYSTEM_EFI_BOOT_SERVICE_DRIVER))
    .value(PY_ENUM(LIEF::PE::SUBSYSTEM::IMAGE_SUBSYSTEM_EFI_RUNTIME_DRIVER))
    .value(PY_ENUM(LIEF::PE::SUBSYSTEM::IMAGE_SUBSYSTEM_EFI_ROM))
    .value(PY_ENUM(LIEF::PE::SUBSYSTEM::IMAGE_SUBSYSTEM_XBOX))
    .value(PY_ENUM(LIEF::PE::SUBSYSTEM::IMAGE_SUBSYSTEM_WINDOWS_BOOT_APPLICATION))
    .export_values();

  py::enum_<LIEF::PE::DATA_DIRECTORY>(m, "DATA_DIRECTORY")
    .value(PY_ENUM(LIEF::PE::DATA_DIRECTORY::EXPORT_TABLE))
    .value(PY_ENUM(LIEF::PE::DATA_DIRECTORY::IMPORT_TABLE))
    .value(PY_ENUM(LIEF::PE::DATA_DIRECTORY::RESOURCE_TABLE))
    .value(PY_ENUM(LIEF::PE::DATA_DIRECTORY::EXCEPTION_TABLE))
    .value(PY_ENUM(LIEF::PE::DATA_DIRECTORY::CERTIFICATE_TABLE))
    .value(PY_ENUM(LIEF::PE::DATA_DIRECTORY::BASE_RELOCATION_TABLE))
    .value(PY_ENUM(LIEF::PE::DATA_DIRECTORY::DEBUG))
    .value(PY_ENUM(LIEF::PE::DATA_DIRECTORY::ARCHITECTURE))
    .value(PY_ENUM(LIEF::PE::DATA_DIRECTORY::GLOBAL_PTR))
    .value(PY_ENUM(LIEF::PE::DATA_DIRECTORY::TLS_TABLE))
    .value(PY_ENUM(LIEF::PE::DATA_DIRECTORY::LOAD_CONFIG_TABLE))
    .value(PY_ENUM(LIEF::PE::DATA_DIRECTORY::BOUND_IMPORT))
    .value(PY_ENUM(LIEF::PE::DATA_DIRECTORY::IAT))
    .value(PY_ENUM(LIEF::PE::DATA_DIRECTORY::DELAY_IMPORT_DESCRIPTOR))
    .value(PY_ENUM(LIEF::PE::DATA_DIRECTORY::CLR_RUNTIME_HEADER))
    .export_values();

  py::enum_<LIEF::PE::DLL_CHARACTERISTICS>(m, "DLL_CHARACTERISTICS", py::arithmetic())
    .value(PY_ENUM(LIEF::PE::DLL_CHARACTERISTICS::IMAGE_DLL_CHARACTERISTICS_HIGH_ENTROPY_VA))
    .value(PY_ENUM(LIEF::PE::DLL_CHARACTERISTICS::IMAGE_DLL_CHARACTERISTICS_DYNAMIC_BASE))
    .value(PY_ENUM(LIEF::PE::DLL_CHARACTERISTICS::IMAGE_DLL_CHARACTERISTICS_FORCE_INTEGRITY))
    .value(PY_ENUM(LIEF::PE::DLL_CHARACTERISTICS::IMAGE_DLL_CHARACTERISTICS_NX_COMPAT))
    .value(PY_ENUM(LIEF::PE::DLL_CHARACTERISTICS::IMAGE_DLL_CHARACTERISTICS_NO_ISOLATION))
    .value(PY_ENUM(LIEF::PE::DLL_CHARACTERISTICS::IMAGE_DLL_CHARACTERISTICS_NO_SEH))
    .value(PY_ENUM(LIEF::PE::DLL_CHARACTERISTICS::IMAGE_DLL_CHARACTERISTICS_NO_BIND))
    .value(PY_ENUM(LIEF::PE::DLL_CHARACTERISTICS::IMAGE_DLL_CHARACTERISTICS_APPCONTAINER))
    .value(PY_ENUM(LIEF::PE::DLL_CHARACTERISTICS::IMAGE_DLL_CHARACTERISTICS_WDM_DRIVER))
    .value(PY_ENUM(LIEF::PE::DLL_CHARACTERISTICS::IMAGE_DLL_CHARACTERISTICS_GUARD_CF))
    .value(PY_ENUM(LIEF::PE::DLL_CHARACTERISTICS::IMAGE_DLL_CHARACTERISTICS_TERMINAL_SERVER_AWARE))
    .export_values();


  py::enum_<LIEF::PE::SECTION_CHARACTERISTICS>(m, "SECTION_CHARACTERISTICS", py::arithmetic())
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_TYPE_NO_PAD))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_CNT_CODE))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_CNT_INITIALIZED_DATA))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_CNT_UNINITIALIZED_DATA))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_LNK_OTHER))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_LNK_INFO))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_LNK_REMOVE))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_LNK_COMDAT))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_GPREL))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_MEM_PURGEABLE))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_MEM_16BIT))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_MEM_LOCKED))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_MEM_PRELOAD))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_ALIGN_1BYTES))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_ALIGN_2BYTES))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_ALIGN_4BYTES))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_ALIGN_8BYTES))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_ALIGN_16BYTES))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_ALIGN_32BYTES))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_ALIGN_64BYTES))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_ALIGN_128BYTES))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_ALIGN_256BYTES))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_ALIGN_512BYTES))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_ALIGN_1024BYTES))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_ALIGN_2048BYTES))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_ALIGN_4096BYTES))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_ALIGN_8192BYTES))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_LNK_NRELOC_OVFL))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_MEM_DISCARDABLE))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_MEM_NOT_CACHED))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_MEM_NOT_PAGED))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_MEM_SHARED))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_MEM_EXECUTE))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_MEM_READ))
    .value(PY_ENUM(LIEF::PE::SECTION_CHARACTERISTICS::IMAGE_SCN_MEM_WRITE))
    .export_values();

  py::enum_<LIEF::PE::PE_SECTION_TYPES>(m, "SECTION_TYPES")
    .value(PY_ENUM(LIEF::PE::PE_SECTION_TYPES::TEXT))
    .value(PY_ENUM(LIEF::PE::PE_SECTION_TYPES::TLS))
    .value(PY_ENUM(LIEF::PE::PE_SECTION_TYPES::IMPORT))
    .value(PY_ENUM(LIEF::PE::PE_SECTION_TYPES::DATA))
    .value(PY_ENUM(LIEF::PE::PE_SECTION_TYPES::BSS))
    .value(PY_ENUM(LIEF::PE::PE_SECTION_TYPES::RESOURCE))
    .value(PY_ENUM(LIEF::PE::PE_SECTION_TYPES::RELOCATION))
    .value(PY_ENUM(LIEF::PE::PE_SECTION_TYPES::EXPORT))
    .value(PY_ENUM(LIEF::PE::PE_SECTION_TYPES::UNKNOWN))
    .export_values();


  py::enum_<LIEF::PE::SYMBOL_BASE_TYPES>(m, "SYMBOL_BASE_TYPES")
    .value(PY_ENUM(LIEF::PE::SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_NULL))
    .value(PY_ENUM(LIEF::PE::SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_VOID))
    .value(PY_ENUM(LIEF::PE::SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_CHAR))
    .value(PY_ENUM(LIEF::PE::SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_SHORT))
    .value(PY_ENUM(LIEF::PE::SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_INT))
    .value(PY_ENUM(LIEF::PE::SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_LONG))
    .value(PY_ENUM(LIEF::PE::SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_FLOAT))
    .value(PY_ENUM(LIEF::PE::SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_DOUBLE))
    .value(PY_ENUM(LIEF::PE::SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_STRUCT))
    .value(PY_ENUM(LIEF::PE::SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_UNION))
    .value(PY_ENUM(LIEF::PE::SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_ENUM))
    .value(PY_ENUM(LIEF::PE::SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_MOE))
    .value(PY_ENUM(LIEF::PE::SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_BYTE))
    .value(PY_ENUM(LIEF::PE::SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_WORD))
    .value(PY_ENUM(LIEF::PE::SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_UINT))
    .value(PY_ENUM(LIEF::PE::SYMBOL_BASE_TYPES::IMAGE_SYM_TYPE_DWORD))
    .export_values();


  py::enum_<LIEF::PE::SYMBOL_COMPLEX_TYPES>(m, "SYMBOL_COMPLEX_TYPES")
    .value(PY_ENUM(LIEF::PE::SYMBOL_COMPLEX_TYPES::IMAGE_SYM_DTYPE_NULL))
    .value(PY_ENUM(LIEF::PE::SYMBOL_COMPLEX_TYPES::IMAGE_SYM_DTYPE_POINTER))
    .value(PY_ENUM(LIEF::PE::SYMBOL_COMPLEX_TYPES::IMAGE_SYM_DTYPE_FUNCTION))
    .value(PY_ENUM(LIEF::PE::SYMBOL_COMPLEX_TYPES::IMAGE_SYM_DTYPE_ARRAY))
    .value(PY_ENUM(LIEF::PE::SYMBOL_COMPLEX_TYPES::SCT_COMPLEX_TYPE_SHIFT))
    .export_values();


  py::enum_<LIEF::PE::SYMBOL_SECTION_NUMBER>(m, "SYMBOL_SECTION_NUMBER")
    .value(PY_ENUM(LIEF::PE::SYMBOL_SECTION_NUMBER::IMAGE_SYM_DEBUG))
    .value(PY_ENUM(LIEF::PE::SYMBOL_SECTION_NUMBER::IMAGE_SYM_ABSOLUTE))
    .value(PY_ENUM(LIEF::PE::SYMBOL_SECTION_NUMBER::IMAGE_SYM_UNDEFINED))
    .export_values();


  py::enum_<LIEF::PE::SYMBOL_STORAGE_CLASS>(m, "SYMBOL_STORAGE_CLASS")
    .value(PY_ENUM(LIEF::PE::SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_END_OF_FUNCTION))
    .value(PY_ENUM(LIEF::PE::SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_NULL))
    .value(PY_ENUM(LIEF::PE::SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_AUTOMATIC))
    .value(PY_ENUM(LIEF::PE::SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_EXTERNAL))
    .value(PY_ENUM(LIEF::PE::SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_STATIC))
    .value(PY_ENUM(LIEF::PE::SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_REGISTER))
    .value(PY_ENUM(LIEF::PE::SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_EXTERNAL_DEF))
    .value(PY_ENUM(LIEF::PE::SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_LABEL))
    .value(PY_ENUM(LIEF::PE::SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_UNDEFINED_LABEL))
    .value(PY_ENUM(LIEF::PE::SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_MEMBER_OF_STRUCT))
    .value(PY_ENUM(LIEF::PE::SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_UNION_TAG))
    .value(PY_ENUM(LIEF::PE::SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_TYPE_DEFINITION))
    .value(PY_ENUM(LIEF::PE::SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_UNDEFINED_STATIC))
    .value(PY_ENUM(LIEF::PE::SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_ENUM_TAG))
    .value(PY_ENUM(LIEF::PE::SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_MEMBER_OF_ENUM))
    .value(PY_ENUM(LIEF::PE::SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_REGISTER_PARAM))
    .value(PY_ENUM(LIEF::PE::SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_BIT_FIELD))
    .value(PY_ENUM(LIEF::PE::SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_BLOCK))
    .value(PY_ENUM(LIEF::PE::SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_FUNCTION))
    .value(PY_ENUM(LIEF::PE::SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_END_OF_STRUCT))
    .value(PY_ENUM(LIEF::PE::SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_FILE))
    .value(PY_ENUM(LIEF::PE::SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_SECTION))
    .value(PY_ENUM(LIEF::PE::SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_WEAK_EXTERNAL))
    .value(PY_ENUM(LIEF::PE::SYMBOL_STORAGE_CLASS::IMAGE_SYM_CLASS_CLR_TOKEN))
    .export_values();


  py::enum_<LIEF::PE::RELOCATIONS_BASE_TYPES>(m, "RELOCATIONS_BASE_TYPES")
    .value(PY_ENUM(LIEF::PE::RELOCATIONS_BASE_TYPES::IMAGE_REL_BASED_ABSOLUTE))
    .value(PY_ENUM(LIEF::PE::RELOCATIONS_BASE_TYPES::IMAGE_REL_BASED_HIGH))
    .value(PY_ENUM(LIEF::PE::RELOCATIONS_BASE_TYPES::IMAGE_REL_BASED_LOW))
    .value(PY_ENUM(LIEF::PE::RELOCATIONS_BASE_TYPES::IMAGE_REL_BASED_HIGHLOW))
    .value(PY_ENUM(LIEF::PE::RELOCATIONS_BASE_TYPES::IMAGE_REL_BASED_HIGHADJ))
    .value(PY_ENUM(LIEF::PE::RELOCATIONS_BASE_TYPES::IMAGE_REL_BASED_MIPS_JMPADDR))
    .value(PY_ENUM(LIEF::PE::RELOCATIONS_BASE_TYPES::IMAGE_REL_BASED_SECTION))
    .value(PY_ENUM(LIEF::PE::RELOCATIONS_BASE_TYPES::IMAGE_REL_BASED_REL))
    .value(PY_ENUM(LIEF::PE::RELOCATIONS_BASE_TYPES::IMAGE_REL_BASED_MIPS_JMPADDR16))
    .value(PY_ENUM(LIEF::PE::RELOCATIONS_BASE_TYPES::IMAGE_REL_BASED_IA64_IMM64))
    .value(PY_ENUM(LIEF::PE::RELOCATIONS_BASE_TYPES::IMAGE_REL_BASED_DIR64))
    .value(PY_ENUM(LIEF::PE::RELOCATIONS_BASE_TYPES::IMAGE_REL_BASED_HIGH3ADJ))
    .export_values();


  py::enum_<LIEF::PE::DEBUG_TYPES>(m, "DEBUG_TYPES")
    .value(PY_ENUM(LIEF::PE::DEBUG_TYPES::IMAGE_DEBUG_TYPE_UNKNOWN))
    .value(PY_ENUM(LIEF::PE::DEBUG_TYPES::IMAGE_DEBUG_TYPE_COFF))
    .value(PY_ENUM(LIEF::PE::DEBUG_TYPES::IMAGE_DEBUG_TYPE_CODEVIEW))
    .value(PY_ENUM(LIEF::PE::DEBUG_TYPES::IMAGE_DEBUG_TYPE_FPO))
    .value(PY_ENUM(LIEF::PE::DEBUG_TYPES::IMAGE_DEBUG_TYPE_MISC))
    .value(PY_ENUM(LIEF::PE::DEBUG_TYPES::IMAGE_DEBUG_TYPE_EXCEPTION))
    .value(PY_ENUM(LIEF::PE::DEBUG_TYPES::IMAGE_DEBUG_TYPE_FIXUP))
    .value(PY_ENUM(LIEF::PE::DEBUG_TYPES::IMAGE_DEBUG_TYPE_OMAP_TO_SRC))
    .value(PY_ENUM(LIEF::PE::DEBUG_TYPES::IMAGE_DEBUG_TYPE_OMAP_FROM_SRC))
    .value(PY_ENUM(LIEF::PE::DEBUG_TYPES::IMAGE_DEBUG_TYPE_BORLAND))
    .value(PY_ENUM(LIEF::PE::DEBUG_TYPES::IMAGE_DEBUG_TYPE_CLSID))
    .export_values();


  py::enum_<LIEF::PE::RESOURCE_TYPES>(m, "RESOURCE_TYPES")
    .value(PY_ENUM(LIEF::PE::RESOURCE_TYPES::CURSOR))
    .value(PY_ENUM(LIEF::PE::RESOURCE_TYPES::BITMAP))
    .value(PY_ENUM(LIEF::PE::RESOURCE_TYPES::ICON))
    .value(PY_ENUM(LIEF::PE::RESOURCE_TYPES::MENU))
    .value(PY_ENUM(LIEF::PE::RESOURCE_TYPES::DIALOG))
    .value(PY_ENUM(LIEF::PE::RESOURCE_TYPES::STRING))
    .value(PY_ENUM(LIEF::PE::RESOURCE_TYPES::FONTDIR))
    .value(PY_ENUM(LIEF::PE::RESOURCE_TYPES::FONT))
    .value(PY_ENUM(LIEF::PE::RESOURCE_TYPES::ACCELERATOR))
    .value(PY_ENUM(LIEF::PE::RESOURCE_TYPES::RCDATA))
    .value(PY_ENUM(LIEF::PE::RESOURCE_TYPES::MESSAGETABLE))
    .value(PY_ENUM(LIEF::PE::RESOURCE_TYPES::GROUP_CURSOR))
    .value(PY_ENUM(LIEF::PE::RESOURCE_TYPES::GROUP_ICON))
    .value(PY_ENUM(LIEF::PE::RESOURCE_TYPES::VERSION))
    .value(PY_ENUM(LIEF::PE::RESOURCE_TYPES::DLGINCLUDE))
    .value(PY_ENUM(LIEF::PE::RESOURCE_TYPES::PLUGPLAY))
    .value(PY_ENUM(LIEF::PE::RESOURCE_TYPES::VXD))
    .value(PY_ENUM(LIEF::PE::RESOURCE_TYPES::ANICURSOR))
    .value(PY_ENUM(LIEF::PE::RESOURCE_TYPES::ANIICON))
    .value(PY_ENUM(LIEF::PE::RESOURCE_TYPES::HTML))
    .value(PY_ENUM(LIEF::PE::RESOURCE_TYPES::MANIFEST))
    .export_values();


  py::enum_<LIEF::PE::RESOURCE_LANGS>(m, "RESOURCE_LANGS")
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_NEUTRAL))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_INVARIANT))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_AFRIKAANS))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_ALBANIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_ARABIC))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_ARMENIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_ASSAMESE))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_AZERI))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_BASQUE))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_BELARUSIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_BENGALI))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_BULGARIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_CATALAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_CHINESE))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_CROATIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_CZECH))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_DANISH))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_DIVEHI))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_DUTCH))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_ENGLISH))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_ESTONIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_FAEROESE))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_FARSI))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_FINNISH))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_FRENCH))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_GALICIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_GEORGIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_GERMAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_GREEK))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_GUJARATI))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_HEBREW))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_HINDI))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_HUNGARIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_ICELANDIC))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_INDONESIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_ITALIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_JAPANESE))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_KANNADA))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_KASHMIRI))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_KAZAK))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_KONKANI))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_KOREAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_KYRGYZ))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_LATVIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_LITHUANIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_MACEDONIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_MALAY))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_MALAYALAM))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_MANIPURI))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_MARATHI))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_MONGOLIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_NEPALI))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_NORWEGIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_ORIYA))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_POLISH))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_PORTUGUESE))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_PUNJABI))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_ROMANIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_RUSSIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_SANSKRIT))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_SERBIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_SINDHI))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_SLOVAK))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_SLOVENIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_SPANISH))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_SWAHILI))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_SWEDISH))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_SYRIAC))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_TAMIL))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_TATAR))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_TELUGU))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_THAI))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_TURKISH))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_UKRAINIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_URDU))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_UZBEK))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_VIETNAMESE))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_GAELIC))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_MALTESE))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_MAORI))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_RHAETO_ROMANCE))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_SAAMI))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_SORBIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_SUTU))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_TSONGA))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_TSWANA))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_VENDA))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_XHOSA))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_ZULU))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_ESPERANTO))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_WALON))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_CORNISH))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_WELSH))
    .value(PY_ENUM(LIEF::PE::RESOURCE_LANGS::LANG_BRETON))
    .export_values();

  py::enum_<LIEF::PE::RESOURCE_SUBLANGS>(m, "RESOURCE_SUBLANGS")
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_NEUTRAL))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_DEFAULT))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_SYS_DEFAULT))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ARABIC_SAUDI_ARABIA))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ARABIC_IRAQ))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ARABIC_EGYPT))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ARABIC_LIBYA))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ARABIC_ALGERIA))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ARABIC_MOROCCO))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ARABIC_TUNISIA))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ARABIC_OMAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ARABIC_YEMEN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ARABIC_SYRIA))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ARABIC_JORDAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ARABIC_LEBANON))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ARABIC_KUWAIT))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ARABIC_UAE))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ARABIC_BAHRAIN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ARABIC_QATAR))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_AZERI_LATIN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_AZERI_CYRILLIC))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_CHINESE_TRADITIONAL))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_CHINESE_SIMPLIFIED))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_CHINESE_HONGKONG))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_CHINESE_SINGAPORE))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_CHINESE_MACAU))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_DUTCH))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_DUTCH_BELGIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ENGLISH_US))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ENGLISH_UK))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ENGLISH_AUS))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ENGLISH_CAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ENGLISH_NZ))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ENGLISH_EIRE))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ENGLISH_SOUTH_AFRICA))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ENGLISH_JAMAICA))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ENGLISH_CARIBBEAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ENGLISH_BELIZE))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ENGLISH_TRINIDAD))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ENGLISH_ZIMBABWE))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ENGLISH_PHILIPPINES))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_FRENCH))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_FRENCH_BELGIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_FRENCH_CANADIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_FRENCH_SWISS))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_FRENCH_LUXEMBOURG))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_FRENCH_MONACO))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_GERMAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_GERMAN_SWISS))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_GERMAN_AUSTRIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_GERMAN_LUXEMBOURG))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_GERMAN_LIECHTENSTEIN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ITALIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ITALIAN_SWISS))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_KASHMIRI_SASIA))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_KASHMIRI_INDIA))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_KOREAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_LITHUANIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_MALAY_MALAYSIA))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_MALAY_BRUNEI_DARUSSALAM))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_NEPALI_INDIA))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_NORWEGIAN_BOKMAL))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_NORWEGIAN_NYNORSK))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_PORTUGUESE))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_PORTUGUESE_BRAZILIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_SERBIAN_LATIN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_SERBIAN_CYRILLIC))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_SPANISH))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_SPANISH_MEXICAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_SPANISH_MODERN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_SPANISH_GUATEMALA))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_SPANISH_COSTA_RICA))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_SPANISH_PANAMA))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_SPANISH_DOMINICAN_REPUBLIC))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_SPANISH_VENEZUELA))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_SPANISH_COLOMBIA))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_SPANISH_PERU))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_SPANISH_ARGENTINA))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_SPANISH_ECUADOR))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_SPANISH_CHILE))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_SPANISH_URUGUAY))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_SPANISH_PARAGUAY))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_SPANISH_BOLIVIA))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_SPANISH_EL_SALVADOR))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_SPANISH_HONDURAS))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_SPANISH_NICARAGUA))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_SPANISH_PUERTO_RICO))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_SWEDISH))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_SWEDISH_FINLAND))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_URDU_PAKISTAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_URDU_INDIA))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_UZBEK_LATIN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_UZBEK_CYRILLIC))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_DUTCH_SURINAM))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ROMANIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_ROMANIAN_MOLDAVIA))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_RUSSIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_RUSSIAN_MOLDAVIA))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_CROATIAN))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_LITHUANIAN_CLASSIC))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_GAELIC))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_GAELIC_SCOTTISH))
    .value(PY_ENUM(LIEF::PE::RESOURCE_SUBLANGS::SUBLANG_GAELIC_MANX))
    .export_values();


  py::enum_<LIEF::PE::EXTENDED_WINDOW_STYLES>(m, "EXTENDED_WINDOW_STYLES")
    .value(PY_ENUM(LIEF::PE::EXTENDED_WINDOW_STYLES::WS_EX_DLGMODALFRAME))
    .value(PY_ENUM(LIEF::PE::EXTENDED_WINDOW_STYLES::WS_EX_NOPARENTNOTIFY))
    .value(PY_ENUM(LIEF::PE::EXTENDED_WINDOW_STYLES::WS_EX_TOPMOST))
    .value(PY_ENUM(LIEF::PE::EXTENDED_WINDOW_STYLES::WS_EX_ACCEPTFILES))
    .value(PY_ENUM(LIEF::PE::EXTENDED_WINDOW_STYLES::WS_EX_TRANSPARENT))
    .value(PY_ENUM(LIEF::PE::EXTENDED_WINDOW_STYLES::WS_EX_MDICHILD))
    .value(PY_ENUM(LIEF::PE::EXTENDED_WINDOW_STYLES::WS_EX_TOOLWINDOW))
    .value(PY_ENUM(LIEF::PE::EXTENDED_WINDOW_STYLES::WS_EX_WINDOWEDGE))
    .value(PY_ENUM(LIEF::PE::EXTENDED_WINDOW_STYLES::WS_EX_CLIENTEDGE))
    .value(PY_ENUM(LIEF::PE::EXTENDED_WINDOW_STYLES::WS_EX_CONTEXTHELP))
    .value(PY_ENUM(LIEF::PE::EXTENDED_WINDOW_STYLES::WS_EX_RIGHT))
    .value(PY_ENUM(LIEF::PE::EXTENDED_WINDOW_STYLES::WS_EX_LEFT))
    .value(PY_ENUM(LIEF::PE::EXTENDED_WINDOW_STYLES::WS_EX_RTLREADING))
    .value(PY_ENUM(LIEF::PE::EXTENDED_WINDOW_STYLES::WS_EX_LTRREADING))
    .value(PY_ENUM(LIEF::PE::EXTENDED_WINDOW_STYLES::WS_EX_LEFTSCROLLBAR))
    .value(PY_ENUM(LIEF::PE::EXTENDED_WINDOW_STYLES::WS_EX_RIGHTSCROLLBAR))
    .value(PY_ENUM(LIEF::PE::EXTENDED_WINDOW_STYLES::WS_EX_CONTROLPARENT))
    .value(PY_ENUM(LIEF::PE::EXTENDED_WINDOW_STYLES::WS_EX_STATICEDGE))
    .value(PY_ENUM(LIEF::PE::EXTENDED_WINDOW_STYLES::WS_EX_APPWINDOW))
    .export_values();



  py::enum_<LIEF::PE::WINDOW_STYLES>(m, "WINDOW_STYLES")
    .value(PY_ENUM(LIEF::PE::WINDOW_STYLES::WS_OVERLAPPED))
    .value(PY_ENUM(LIEF::PE::WINDOW_STYLES::WS_POPUP))
    .value(PY_ENUM(LIEF::PE::WINDOW_STYLES::WS_CHILD))
    .value(PY_ENUM(LIEF::PE::WINDOW_STYLES::WS_MINIMIZE))
    .value(PY_ENUM(LIEF::PE::WINDOW_STYLES::WS_VISIBLE))
    .value(PY_ENUM(LIEF::PE::WINDOW_STYLES::WS_DISABLED))
    .value(PY_ENUM(LIEF::PE::WINDOW_STYLES::WS_CLIPSIBLINGS))
    .value(PY_ENUM(LIEF::PE::WINDOW_STYLES::WS_CLIPCHILDREN))
    .value(PY_ENUM(LIEF::PE::WINDOW_STYLES::WS_MAXIMIZE))
    .value(PY_ENUM(LIEF::PE::WINDOW_STYLES::WS_CAPTION))
    .value(PY_ENUM(LIEF::PE::WINDOW_STYLES::WS_BORDER))
    .value(PY_ENUM(LIEF::PE::WINDOW_STYLES::WS_DLGFRAME))
    .value(PY_ENUM(LIEF::PE::WINDOW_STYLES::WS_VSCROLL))
    .value(PY_ENUM(LIEF::PE::WINDOW_STYLES::WS_HSCROLL))
    .value(PY_ENUM(LIEF::PE::WINDOW_STYLES::WS_SYSMENU))
    .value(PY_ENUM(LIEF::PE::WINDOW_STYLES::WS_THICKFRAME))
    .value(PY_ENUM(LIEF::PE::WINDOW_STYLES::WS_GROUP))
    .value(PY_ENUM(LIEF::PE::WINDOW_STYLES::WS_TABSTOP))
    .value(PY_ENUM(LIEF::PE::WINDOW_STYLES::WS_MINIMIZEBOX))
    .value(PY_ENUM(LIEF::PE::WINDOW_STYLES::WS_MAXIMIZEBOX))
    .export_values();


  py::enum_<LIEF::PE::DIALOG_BOX_STYLES>(m, "DIALOG_BOX_STYLES")
    .value(PY_ENUM(LIEF::PE::DIALOG_BOX_STYLES::DS_ABSALIGN))
    .value(PY_ENUM(LIEF::PE::DIALOG_BOX_STYLES::DS_SYSMODAL))
    .value(PY_ENUM(LIEF::PE::DIALOG_BOX_STYLES::DS_LOCALEDIT))
    .value(PY_ENUM(LIEF::PE::DIALOG_BOX_STYLES::DS_SETFONT))
    .value(PY_ENUM(LIEF::PE::DIALOG_BOX_STYLES::DS_MODALFRAME))
    .value(PY_ENUM(LIEF::PE::DIALOG_BOX_STYLES::DS_NOIDLEMSG))
    .value(PY_ENUM(LIEF::PE::DIALOG_BOX_STYLES::DS_SETFOREGROUND))
    .value(PY_ENUM(LIEF::PE::DIALOG_BOX_STYLES::DS_3DLOOK))
    .value(PY_ENUM(LIEF::PE::DIALOG_BOX_STYLES::DS_FIXEDSYS))
    .value(PY_ENUM(LIEF::PE::DIALOG_BOX_STYLES::DS_NOFAILCREATE))
    .value(PY_ENUM(LIEF::PE::DIALOG_BOX_STYLES::DS_CONTROL))
    .value(PY_ENUM(LIEF::PE::DIALOG_BOX_STYLES::DS_CENTER))
    .value(PY_ENUM(LIEF::PE::DIALOG_BOX_STYLES::DS_CENTERMOUSE))
    .value(PY_ENUM(LIEF::PE::DIALOG_BOX_STYLES::DS_CONTEXTHELP))
    .value(PY_ENUM(LIEF::PE::DIALOG_BOX_STYLES::DS_SHELLFONT))
    .export_values();


  py::enum_<LIEF::PE::FIXED_VERSION_OS>(m, "FIXED_VERSION_OS")
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_OS::VOS_UNKNOWN))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_OS::VOS_DOS))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_OS::VOS_NT))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_OS::VOS__WINDOWS16))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_OS::VOS__WINDOWS32))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_OS::VOS_OS216))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_OS::VOS_OS232))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_OS::VOS__PM16))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_OS::VOS__PM32))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_OS::VOS_DOS_WINDOWS16))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_OS::VOS_DOS_WINDOWS32))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_OS::VOS_NT_WINDOWS32))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_OS::VOS_OS216_PM16))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_OS::VOS_OS232_PM32))
    .export_values();

  py::enum_<LIEF::PE::FIXED_VERSION_FILE_FLAGS>(m, "FIXED_VERSION_FILE_FLAGS")
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_FILE_FLAGS::VS_FF_DEBUG))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_FILE_FLAGS::VS_FF_INFOINFERRED))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_FILE_FLAGS::VS_FF_PATCHED))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_FILE_FLAGS::VS_FF_PRERELEASE))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_FILE_FLAGS::VS_FF_PRIVATEBUILD))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_FILE_FLAGS::VS_FF_SPECIALBUILD))
    .export_values();


  py::enum_<LIEF::PE::FIXED_VERSION_FILE_TYPES>(m, "FIXED_VERSION_FILE_TYPES")
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_FILE_TYPES::VFT_APP))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_FILE_TYPES::VFT_DLL))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_FILE_TYPES::VFT_DRV))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_FILE_TYPES::VFT_FONT))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_FILE_TYPES::VFT_STATIC_LIB))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_FILE_TYPES::VFT_UNKNOWN))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_FILE_TYPES::VFT_VXD))
    .export_values();


  py::enum_<LIEF::PE::FIXED_VERSION_FILE_SUB_TYPES>(m, "FIXED_VERSION_FILE_SUB_TYPES")
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_FILE_SUB_TYPES::VFT2_DRV_COMM))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_FILE_SUB_TYPES::VFT2_DRV_DISPLAY))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_FILE_SUB_TYPES::VFT2_DRV_INSTALLABLE))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_FILE_SUB_TYPES::VFT2_DRV_KEYBOARD))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_FILE_SUB_TYPES::VFT2_DRV_LANGUAGE))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_FILE_SUB_TYPES::VFT2_DRV_MOUSE))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_FILE_SUB_TYPES::VFT2_DRV_NETWORK))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_FILE_SUB_TYPES::VFT2_DRV_PRINTER))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_FILE_SUB_TYPES::VFT2_DRV_SOUND))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_FILE_SUB_TYPES::VFT2_DRV_SYSTEM))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_FILE_SUB_TYPES::VFT2_DRV_VERSIONED_PRINTER))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_FILE_SUB_TYPES::VFT2_FONT_RASTER))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_FILE_SUB_TYPES::VFT2_FONT_TRUETYPE))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_FILE_SUB_TYPES::VFT2_FONT_VECTOR))
    .value(PY_ENUM(LIEF::PE::FIXED_VERSION_FILE_SUB_TYPES::VFT2_UNKNOWN))
    .export_values();

  py::enum_<LIEF::PE::CODE_PAGES>(m, "CODE_PAGES")
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM037))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM437))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM500))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_ASMO_708))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_DOS_720))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM737))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM775))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM850))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM852))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM855))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM857))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM00858))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM860))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM861))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_DOS_862))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM863))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM864))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM865))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_CP866))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM869))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM870))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_WINDOWS_874))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_CP875))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_SHIFT_JIS))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_GB2312))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_KS_C_5601_1987))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_BIG5))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM1026))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM01047))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM01140))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM01141))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM01142))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM01143))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM01144))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM01145))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM01146))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM01147))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM01148))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM01149))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_UTF_16))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_UNICODEFFFE))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_WINDOWS_1250))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_WINDOWS_1251))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_WINDOWS_1252))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_WINDOWS_1253))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_WINDOWS_1254))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_WINDOWS_1255))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_WINDOWS_1256))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_WINDOWS_1257))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_WINDOWS_1258))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_JOHAB))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_MACINTOSH))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_MAC_JAPANESE))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_MAC_CHINESETRAD))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_MAC_KOREAN))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_MAC_ARABIC))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_MAC_HEBREW))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_MAC_GREEK))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_MAC_CYRILLIC))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_MAC_CHINESESIMP))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_MAC_ROMANIAN))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_MAC_UKRAINIAN))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_MAC_THAI))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_MAC_CE))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_MAC_ICELANDIC))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_MAC_TURKISH))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_MAC_CROATIAN))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_UTF_32))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_UTF_32BE))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_CHINESE_CNS))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_CP20001))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_CHINESE_ETEN))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_CP20003))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_CP20004))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_CP20005))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_IA5))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_IA5_GERMAN))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_IA5_SWEDISH))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_IA5_NORWEGIAN))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_US_ASCII))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_CP20261))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_CP20269))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM273))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM277))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM278))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM280))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM284))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM285))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM290))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM297))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM420))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM423))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM424))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_EBCDIC_KOREANEXTENDED))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM_THAI))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_KOI8_R))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM871))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM880))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM905))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_IBM00924))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_EUC_JP_JIS))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_CP20936))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_CP20949))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_CP1025))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_KOI8_U))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_ISO_8859_1))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_ISO_8859_2))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_ISO_8859_3))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_ISO_8859_4))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_ISO_8859_5))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_ISO_8859_6))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_ISO_8859_7))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_ISO_8859_8))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_ISO_8859_9))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_ISO_8859_13))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_ISO_8859_15))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_EUROPA))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_ISO_8859_8_I))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_ISO_2022_JP))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_CSISO2022JP))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_ISO_2022_JP_JIS))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_ISO_2022_KR))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_CP50227))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_EUC_JP))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_EUC_CN))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_EUC_KR))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_HZ_GB_2312))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_GB18030))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_ISCII_DE))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_ISCII_BE))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_ISCII_TA))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_ISCII_TE))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_ISCII_AS))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_ISCII_OR))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_ISCII_KA))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_ISCII_MA))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_ISCII_GU))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_X_ISCII_PA))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_UTF_7))
    .value(PY_ENUM(LIEF::PE::CODE_PAGES::CP_UTF_8))
    .export_values();

  py::enum_<LIEF::PE::WIN_VERSION>(m, "WIN_VERSION")
    .value(PY_ENUM(LIEF::PE::WIN_VERSION::WIN_UNKNOWN))
    .value(PY_ENUM(LIEF::PE::WIN_VERSION::WIN_SEH))
    .value(PY_ENUM(LIEF::PE::WIN_VERSION::WIN8_1))
    .value(PY_ENUM(LIEF::PE::WIN_VERSION::WIN10_0_9879))
    .value(PY_ENUM(LIEF::PE::WIN_VERSION::WIN10_0_14286))
    .value(PY_ENUM(LIEF::PE::WIN_VERSION::WIN10_0_14383))
    .value(PY_ENUM(LIEF::PE::WIN_VERSION::WIN10_0_14901))
    .value(PY_ENUM(LIEF::PE::WIN_VERSION::WIN10_0_15002))
    .value(PY_ENUM(LIEF::PE::WIN_VERSION::WIN10_0_16237))
    .export_values();

  py::enum_<LIEF::PE::GUARD_CF_FLAGS>(m, "GUARD_CF_FLAGS")
    .value(PY_ENUM(LIEF::PE::GUARD_CF_FLAGS::GCF_INSTRUMENTED))
    .value(PY_ENUM(LIEF::PE::GUARD_CF_FLAGS::GCF_W_INSTRUMENTED))
    .value(PY_ENUM(LIEF::PE::GUARD_CF_FLAGS::GCF_FUNCTION_TABLE_PRESENT))
    .value(PY_ENUM(LIEF::PE::GUARD_CF_FLAGS::GCF_EXPORT_SUPPRESSION_INFO_PRESENT))
    .value(PY_ENUM(LIEF::PE::GUARD_CF_FLAGS::GCF_ENABLE_EXPORT_SUPPRESSION))
    .value(PY_ENUM(LIEF::PE::GUARD_CF_FLAGS::GCF_LONGJUMP_TABLE_PRESENT))
    .export_values();

  py::enum_<LIEF::PE::GUARD_RF_FLAGS>(m, "GUARD_RF_FLAGS")
    .value(PY_ENUM(LIEF::PE::GUARD_RF_FLAGS::GRF_INSTRUMENTED))
    .value(PY_ENUM(LIEF::PE::GUARD_RF_FLAGS::GRF_ENABLE))
    .value(PY_ENUM(LIEF::PE::GUARD_RF_FLAGS::GRF_STRICT))
    .export_values();
}
