/* Copyright 2017 R. Thomas
 * Copyright 2017 Quarkslab
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "pyELF.hpp"
#include "LIEF/ELF/Structures.hpp"
#include "LIEF/ELF/EnumToString.hpp"

#define PY_ENUM(x) to_string(x), x

void init_ELF_Structures_enum(py::module& m) {

  py::enum_<ELF_CLASS>(m, "ELF_CLASS")
    .value(PY_ENUM(ELF_CLASS::ELFCLASSNONE))
    .value(PY_ENUM(ELF_CLASS::ELFCLASS32))
    .value(PY_ENUM(ELF_CLASS::ELFCLASS64))
    .export_values();


  py::enum_<ELF_DATA>(m, "ELF_DATA")
    .value(PY_ENUM(ELF_DATA::ELFDATANONE))
    .value(PY_ENUM(ELF_DATA::ELFDATA2LSB))
    .value(PY_ENUM(ELF_DATA::ELFDATA2MSB))
    .export_values();

  py::enum_<OS_ABI>(m, "OS_ABI")
    .value(PY_ENUM(OS_ABI::ELFOSABI_SYSTEMV))
    .value(PY_ENUM(OS_ABI::ELFOSABI_HPUX))
    .value(PY_ENUM(OS_ABI::ELFOSABI_NETBSD))
    .value(PY_ENUM(OS_ABI::ELFOSABI_GNU))
    .value(PY_ENUM(OS_ABI::ELFOSABI_LINUX))
    .value(PY_ENUM(OS_ABI::ELFOSABI_HURD))
    .value(PY_ENUM(OS_ABI::ELFOSABI_SOLARIS))
    .value(PY_ENUM(OS_ABI::ELFOSABI_AIX))
    .value(PY_ENUM(OS_ABI::ELFOSABI_IRIX))
    .value(PY_ENUM(OS_ABI::ELFOSABI_FREEBSD))
    .value(PY_ENUM(OS_ABI::ELFOSABI_TRU64))
    .value(PY_ENUM(OS_ABI::ELFOSABI_MODESTO))
    .value(PY_ENUM(OS_ABI::ELFOSABI_OPENBSD))
    .value(PY_ENUM(OS_ABI::ELFOSABI_OPENVMS))
    .value(PY_ENUM(OS_ABI::ELFOSABI_NSK))
    .value(PY_ENUM(OS_ABI::ELFOSABI_AROS))
    .value(PY_ENUM(OS_ABI::ELFOSABI_FENIXOS))
    .value(PY_ENUM(OS_ABI::ELFOSABI_CLOUDABI))
    .value(PY_ENUM(OS_ABI::ELFOSABI_C6000_ELFABI))
    .value(PY_ENUM(OS_ABI::ELFOSABI_AMDGPU_HSA))
    .value(PY_ENUM(OS_ABI::ELFOSABI_C6000_LINUX))
    .value(PY_ENUM(OS_ABI::ELFOSABI_ARM))
    .value(PY_ENUM(OS_ABI::ELFOSABI_STANDALONE))
    .export_values();

  // Enum for the *e_type* of ElfXX_Ehdr
  py::enum_<E_TYPE>(m, "E_TYPE")
    .value(PY_ENUM(E_TYPE::ET_NONE))
    .value(PY_ENUM(E_TYPE::ET_REL))
    .value(PY_ENUM(E_TYPE::ET_EXEC))
    .value(PY_ENUM(E_TYPE::ET_DYN))
    .value(PY_ENUM(E_TYPE::ET_CORE))
    .value(PY_ENUM(E_TYPE::ET_LOPROC))
    .value(PY_ENUM(E_TYPE::ET_HIPROC))
    .export_values();

  //! Enum for the *e_version* of ElfXX_Ehdr;
  py::enum_<VERSION>(m, "VERSION")
    .value(PY_ENUM(VERSION::EV_NONE))
    .value(PY_ENUM(VERSION::EV_CURRENT))
    .export_values();

  // Enum for the *e_machine* of ElfXX_Ehdr
  py::enum_<ARCH>(m, "ARCH")
    .value(PY_ENUM(ARCH::EM_NONE))
    .value(PY_ENUM(ARCH::EM_M32))
    .value(PY_ENUM(ARCH::EM_SPARC))
    .value(PY_ENUM(ARCH::EM_386))
    .value(PY_ENUM(ARCH::EM_68K))
    .value(PY_ENUM(ARCH::EM_88K))
    .value(PY_ENUM(ARCH::EM_IAMCU))
    .value(PY_ENUM(ARCH::EM_860))
    .value(PY_ENUM(ARCH::EM_MIPS))
    .value(PY_ENUM(ARCH::EM_S370))
    .value(PY_ENUM(ARCH::EM_MIPS_RS3_LE))
    .value(PY_ENUM(ARCH::EM_PARISC))
    .value(PY_ENUM(ARCH::EM_VPP500))
    .value(PY_ENUM(ARCH::EM_NONE))
    .value(PY_ENUM(ARCH::EM_960))
    .value(PY_ENUM(ARCH::EM_PPC))
    .value(PY_ENUM(ARCH::EM_PPC64))
    .value(PY_ENUM(ARCH::EM_S390))
    .value(PY_ENUM(ARCH::EM_SPU))
    .value(PY_ENUM(ARCH::EM_V800))
    .value(PY_ENUM(ARCH::EM_FR20))
    .value(PY_ENUM(ARCH::EM_RH32))
    .value(PY_ENUM(ARCH::EM_RCE))
    .value(PY_ENUM(ARCH::EM_ARM))
    .value(PY_ENUM(ARCH::EM_ALPHA))
    .value(PY_ENUM(ARCH::EM_SH))
    .value(PY_ENUM(ARCH::EM_SPARCV9))
    .value(PY_ENUM(ARCH::EM_TRICORE))
    .value(PY_ENUM(ARCH::EM_ARC))
    .value(PY_ENUM(ARCH::EM_H8_300))
    .value(PY_ENUM(ARCH::EM_H8_300H))
    .value(PY_ENUM(ARCH::EM_H8S))
    .value(PY_ENUM(ARCH::EM_H8_500))
    .value(PY_ENUM(ARCH::EM_IA_64))
    .value(PY_ENUM(ARCH::EM_MIPS_X))
    .value(PY_ENUM(ARCH::EM_COLDFIRE))
    .value(PY_ENUM(ARCH::EM_68HC12))
    .value(PY_ENUM(ARCH::EM_MMA))
    .value(PY_ENUM(ARCH::EM_PCP))
    .value(PY_ENUM(ARCH::EM_NCPU))
    .value(PY_ENUM(ARCH::EM_NDR1))
    .value(PY_ENUM(ARCH::EM_STARCORE))
    .value(PY_ENUM(ARCH::EM_ME16))
    .value(PY_ENUM(ARCH::EM_ST100))
    .value(PY_ENUM(ARCH::EM_TINYJ))
    .value(PY_ENUM(ARCH::EM_X86_64))
    .value(PY_ENUM(ARCH::EM_PDSP))
    .value(PY_ENUM(ARCH::EM_PDP10))
    .value(PY_ENUM(ARCH::EM_PDP11))
    .value(PY_ENUM(ARCH::EM_FX66))
    .value(PY_ENUM(ARCH::EM_ST9PLUS))
    .value(PY_ENUM(ARCH::EM_ST7))
    .value(PY_ENUM(ARCH::EM_68HC16))
    .value(PY_ENUM(ARCH::EM_68HC11))
    .value(PY_ENUM(ARCH::EM_68HC08))
    .value(PY_ENUM(ARCH::EM_68HC05))
    .value(PY_ENUM(ARCH::EM_SVX))
    .value(PY_ENUM(ARCH::EM_ST19))
    .value(PY_ENUM(ARCH::EM_VAX))
    .value(PY_ENUM(ARCH::EM_CRIS))
    .value(PY_ENUM(ARCH::EM_JAVELIN))
    .value(PY_ENUM(ARCH::EM_FIREPATH))
    .value(PY_ENUM(ARCH::EM_ZSP))
    .value(PY_ENUM(ARCH::EM_MMIX))
    .value(PY_ENUM(ARCH::EM_HUANY))
    .value(PY_ENUM(ARCH::EM_PRISM))
    .value(PY_ENUM(ARCH::EM_AVR))
    .value(PY_ENUM(ARCH::EM_FR30))
    .value(PY_ENUM(ARCH::EM_D10V))
    .value(PY_ENUM(ARCH::EM_D30V))
    .value(PY_ENUM(ARCH::EM_V850))
    .value(PY_ENUM(ARCH::EM_M32R))
    .value(PY_ENUM(ARCH::EM_MN10300))
    .value(PY_ENUM(ARCH::EM_MN10200))
    .value(PY_ENUM(ARCH::EM_PJ))
    .value(PY_ENUM(ARCH::EM_OPENRISC))
    .value(PY_ENUM(ARCH::EM_ARC_COMPACT))
    .value(PY_ENUM(ARCH::EM_XTENSA))
    .value(PY_ENUM(ARCH::EM_VIDEOCORE))
    .value(PY_ENUM(ARCH::EM_TMM_GPP))
    .value(PY_ENUM(ARCH::EM_NS32K))
    .value(PY_ENUM(ARCH::EM_TPC))
    .value(PY_ENUM(ARCH::EM_SNP1K))
    .value(PY_ENUM(ARCH::EM_ST200))
    .value(PY_ENUM(ARCH::EM_IP2K))
    .value(PY_ENUM(ARCH::EM_MAX))
    .value(PY_ENUM(ARCH::EM_CR))
    .value(PY_ENUM(ARCH::EM_F2MC16))
    .value(PY_ENUM(ARCH::EM_MSP430))
    .value(PY_ENUM(ARCH::EM_BLACKFIN))
    .value(PY_ENUM(ARCH::EM_SE_C33))
    .value(PY_ENUM(ARCH::EM_SEP))
    .value(PY_ENUM(ARCH::EM_ARCA))
    .value(PY_ENUM(ARCH::EM_UNICORE))
    .value(PY_ENUM(ARCH::EM_EXCESS))
    .value(PY_ENUM(ARCH::EM_DXP))
    .value(PY_ENUM(ARCH::EM_ALTERA_NIOS2))
    .value(PY_ENUM(ARCH::EM_CRX))
    .value(PY_ENUM(ARCH::EM_XGATE))
    .value(PY_ENUM(ARCH::EM_C166))
    .value(PY_ENUM(ARCH::EM_M16C))
    .value(PY_ENUM(ARCH::EM_DSPIC30F))
    .value(PY_ENUM(ARCH::EM_CE))
    .value(PY_ENUM(ARCH::EM_M32C))
    .value(PY_ENUM(ARCH::EM_TSK3000))
    .value(PY_ENUM(ARCH::EM_RS08))
    .value(PY_ENUM(ARCH::EM_SHARC))
    .value(PY_ENUM(ARCH::EM_ECOG2))
    .value(PY_ENUM(ARCH::EM_SCORE7))
    .value(PY_ENUM(ARCH::EM_DSP24))
    .value(PY_ENUM(ARCH::EM_VIDEOCORE3))
    .value(PY_ENUM(ARCH::EM_LATTICEMICO32))
    .value(PY_ENUM(ARCH::EM_SE_C17))
    .value(PY_ENUM(ARCH::EM_TI_C6000))
    .value(PY_ENUM(ARCH::EM_TI_C2000))
    .value(PY_ENUM(ARCH::EM_TI_C5500))
    .value(PY_ENUM(ARCH::EM_MMDSP_PLUS))
    .value(PY_ENUM(ARCH::EM_CYPRESS_M8C))
    .value(PY_ENUM(ARCH::EM_R32C))
    .value(PY_ENUM(ARCH::EM_TRIMEDIA))
    .value(PY_ENUM(ARCH::EM_HEXAGON))
    .value(PY_ENUM(ARCH::EM_8051))
    .value(PY_ENUM(ARCH::EM_STXP7X))
    .value(PY_ENUM(ARCH::EM_NDS32))
    .value(PY_ENUM(ARCH::EM_ECOG1))
    .value(PY_ENUM(ARCH::EM_ECOG1X))
    .value(PY_ENUM(ARCH::EM_MAXQ30))
    .value(PY_ENUM(ARCH::EM_XIMO16))
    .value(PY_ENUM(ARCH::EM_MANIK))
    .value(PY_ENUM(ARCH::EM_CRAYNV2))
    .value(PY_ENUM(ARCH::EM_RX))
    .value(PY_ENUM(ARCH::EM_METAG))
    .value(PY_ENUM(ARCH::EM_MCST_ELBRUS))
    .value(PY_ENUM(ARCH::EM_ECOG16))
    .value(PY_ENUM(ARCH::EM_CR16))
    .value(PY_ENUM(ARCH::EM_ETPU))
    .value(PY_ENUM(ARCH::EM_SLE9X))
    .value(PY_ENUM(ARCH::EM_L10M))
    .value(PY_ENUM(ARCH::EM_K10M))
    .value(PY_ENUM(ARCH::EM_AARCH64))
    .value(PY_ENUM(ARCH::EM_AVR32))
    .value(PY_ENUM(ARCH::EM_STM8))
    .value(PY_ENUM(ARCH::EM_TILE64))
    .value(PY_ENUM(ARCH::EM_TILEPRO))
    .value(PY_ENUM(ARCH::EM_CUDA))
    .value(PY_ENUM(ARCH::EM_TILEGX))
    .value(PY_ENUM(ARCH::EM_CLOUDSHIELD))
    .value(PY_ENUM(ARCH::EM_COREA_1ST))
    .value(PY_ENUM(ARCH::EM_COREA_2ND))
    .value(PY_ENUM(ARCH::EM_ARC_COMPACT2))
    .value(PY_ENUM(ARCH::EM_OPEN8))
    .value(PY_ENUM(ARCH::EM_RL78))
    .value(PY_ENUM(ARCH::EM_VIDEOCORE5))
    .value(PY_ENUM(ARCH::EM_78KOR))
    .value(PY_ENUM(ARCH::EM_56800EX))
    .value(PY_ENUM(ARCH::EM_BA1))
    .value(PY_ENUM(ARCH::EM_BA2))
    .value(PY_ENUM(ARCH::EM_XCORE))
    .value(PY_ENUM(ARCH::EM_MCHP_PIC))
    .value(PY_ENUM(ARCH::EM_INTEL205))
    .value(PY_ENUM(ARCH::EM_INTEL206))
    .value(PY_ENUM(ARCH::EM_INTEL207))
    .value(PY_ENUM(ARCH::EM_INTEL208))
    .value(PY_ENUM(ARCH::EM_INTEL209))
    .value(PY_ENUM(ARCH::EM_KM32))
    .value(PY_ENUM(ARCH::EM_KMX32))
    .value(PY_ENUM(ARCH::EM_KMX16))
    .value(PY_ENUM(ARCH::EM_KMX8))
    .value(PY_ENUM(ARCH::EM_KVARC))
    .value(PY_ENUM(ARCH::EM_CDP))
    .value(PY_ENUM(ARCH::EM_COGE))
    .value(PY_ENUM(ARCH::EM_COOL))
    .value(PY_ENUM(ARCH::EM_NORC))
    .value(PY_ENUM(ARCH::EM_CSR_KALIMBA))
    .value(PY_ENUM(ARCH::EM_AMDGPU))
    .export_values();


  //! Enum for the *sh_type* of ElfXX_Shdr;
  py::enum_<ELF_SECTION_TYPES>(m, "SECTION_TYPES")
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_NULL))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_PROGBITS))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_SYMTAB))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_STRTAB))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_RELA))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_HASH))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_DYNAMIC))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_NOTE))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_NOBITS))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_REL))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_SHLIB))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_DYNSYM))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_INIT_ARRAY))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_FINI_ARRAY))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_PREINIT_ARRAY))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_GROUP))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_SYMTAB_SHNDX))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_LOOS))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_GNU_ATTRIBUTES))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_GNU_HASH))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_GNU_verdef))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_GNU_verneed))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_GNU_versym))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_HIOS))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_LOPROC))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_ARM_EXIDX))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_ARM_PREEMPTMAP))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_ARM_ATTRIBUTES))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_ARM_DEBUGOVERLAY))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_ARM_OVERLAYSECTION))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_HEX_ORDERED))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_X86_64_UNWIND))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_MIPS_REGINFO))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_MIPS_OPTIONS))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_MIPS_ABIFLAGS))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_HIPROC))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_LOUSER))
    .value(PY_ENUM(ELF_SECTION_TYPES::SHT_HIUSER))
    .export_values();


  //! Enum for the *sh_flags* field of ElfXX_Shdr;
  py::enum_<ELF_SECTION_FLAGS>(m, "SECTION_FLAGS", py::arithmetic())
    .value(PY_ENUM(ELF_SECTION_FLAGS::SHF_NONE))
    .value(PY_ENUM(ELF_SECTION_FLAGS::SHF_WRITE))
    .value(PY_ENUM(ELF_SECTION_FLAGS::SHF_ALLOC))
    .value(PY_ENUM(ELF_SECTION_FLAGS::SHF_EXECINSTR))
    .value(PY_ENUM(ELF_SECTION_FLAGS::SHF_MERGE))
    .value(PY_ENUM(ELF_SECTION_FLAGS::SHF_STRINGS))
    .value(PY_ENUM(ELF_SECTION_FLAGS::SHF_INFO_LINK))
    .value(PY_ENUM(ELF_SECTION_FLAGS::SHF_LINK_ORDER))
    .value(PY_ENUM(ELF_SECTION_FLAGS::SHF_OS_NONCONFORMING))
    .value(PY_ENUM(ELF_SECTION_FLAGS::SHF_GROUP))
    .value(PY_ENUM(ELF_SECTION_FLAGS::SHF_TLS))
    .value(PY_ENUM(ELF_SECTION_FLAGS::SHF_EXCLUDE))
    .value(PY_ENUM(ELF_SECTION_FLAGS::XCORE_SHF_CP_SECTION))
    .value(PY_ENUM(ELF_SECTION_FLAGS::XCORE_SHF_DP_SECTION))
    .value(PY_ENUM(ELF_SECTION_FLAGS::SHF_MASKOS))
    .value(PY_ENUM(ELF_SECTION_FLAGS::SHF_MASKPROC))
    .value(PY_ENUM(ELF_SECTION_FLAGS::SHF_HEX_GPREL))
    .value(PY_ENUM(ELF_SECTION_FLAGS::SHF_MIPS_NODUPES))
    .value(PY_ENUM(ELF_SECTION_FLAGS::SHF_MIPS_NAMES))
    .value(PY_ENUM(ELF_SECTION_FLAGS::SHF_MIPS_LOCAL))
    .value(PY_ENUM(ELF_SECTION_FLAGS::SHF_MIPS_NOSTRIP))
    .value(PY_ENUM(ELF_SECTION_FLAGS::SHF_MIPS_GPREL))
    .value(PY_ENUM(ELF_SECTION_FLAGS::SHF_MIPS_MERGE))
    .value(PY_ENUM(ELF_SECTION_FLAGS::SHF_MIPS_ADDR))
    .value(PY_ENUM(ELF_SECTION_FLAGS::SHF_MIPS_STRING))
    .export_values();


  //! Enum for the *p_type* field of ElfXX_Phdr
  py::enum_<SEGMENT_TYPES>(m, "SEGMENT_TYPES")
    .value(PY_ENUM(SEGMENT_TYPES::PT_NULL))
    .value(PY_ENUM(SEGMENT_TYPES::PT_LOAD))
    .value(PY_ENUM(SEGMENT_TYPES::PT_DYNAMIC))
    .value(PY_ENUM(SEGMENT_TYPES::PT_INTERP))
    .value(PY_ENUM(SEGMENT_TYPES::PT_NOTE))
    .value(PY_ENUM(SEGMENT_TYPES::PT_SHLIB))
    .value(PY_ENUM(SEGMENT_TYPES::PT_PHDR))
    .value(PY_ENUM(SEGMENT_TYPES::PT_TLS))
    .value(PY_ENUM(SEGMENT_TYPES::PT_LOOS))
    .value(PY_ENUM(SEGMENT_TYPES::PT_HIOS))
    .value(PY_ENUM(SEGMENT_TYPES::PT_LOPROC))
    .value(PY_ENUM(SEGMENT_TYPES::PT_HIPROC))
    .value(PY_ENUM(SEGMENT_TYPES::PT_GNU_EH_FRAME))
    .value(PY_ENUM(SEGMENT_TYPES::PT_SUNW_EH_FRAME))
    .value(PY_ENUM(SEGMENT_TYPES::PT_SUNW_UNWIND))
    .value(PY_ENUM(SEGMENT_TYPES::PT_GNU_STACK))
    .value(PY_ENUM(SEGMENT_TYPES::PT_GNU_RELRO))
    .value(PY_ENUM(SEGMENT_TYPES::PT_ARM_ARCHEXT))
    .value(PY_ENUM(SEGMENT_TYPES::PT_ARM_EXIDX))
    .value(PY_ENUM(SEGMENT_TYPES::PT_ARM_UNWIND))
    .value(PY_ENUM(SEGMENT_TYPES::PT_MIPS_REGINFO))
    .value(PY_ENUM(SEGMENT_TYPES::PT_MIPS_RTPROC))
    .value(PY_ENUM(SEGMENT_TYPES::PT_MIPS_OPTIONS))
    .value(PY_ENUM(SEGMENT_TYPES::PT_MIPS_ABIFLAGS))
    .export_values();

  //! Enum for the *p_flags* field of ElfXX_Phdr
  py::enum_<ELF_SEGMENT_FLAGS>(m, "SEGMENT_FLAGS", py::arithmetic())
    .value(PY_ENUM(ELF_SEGMENT_FLAGS::PF_X))
    .value(PY_ENUM(ELF_SEGMENT_FLAGS::PF_W))
    .value(PY_ENUM(ELF_SEGMENT_FLAGS::PF_R))
    .export_values();



  py::enum_<DYNAMIC_TAGS>(m, "DYNAMIC_TAGS")
    .value(PY_ENUM(DYNAMIC_TAGS::DT_NULL))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_NEEDED))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_PLTRELSZ))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_PLTGOT))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_HASH))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_STRTAB))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_SYMTAB))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_RELA))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_RELASZ))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_RELAENT))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_STRSZ))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_SYMENT))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_INIT))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_FINI))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_SONAME))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_RPATH))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_SYMBOLIC))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_REL))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_RELSZ))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_RELENT))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_PLTREL))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_DEBUG))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_TEXTREL))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_JMPREL))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_BIND_NOW))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_INIT_ARRAY))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_FINI_ARRAY))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_INIT_ARRAYSZ))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_FINI_ARRAYSZ))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_RUNPATH))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_FLAGS))
    //.value(PY_ENUM(DYNAMIC_TAGS::DT_ENCODING))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_PREINIT_ARRAY))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_PREINIT_ARRAYSZ))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_LOOS))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_HIOS))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_LOPROC))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_HIPROC))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_GNU_HASH))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_RELACOUNT))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_RELCOUNT))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_FLAGS_1))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_VERSYM))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_VERDEF))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_VERDEFNUM))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_VERNEED))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_VERNEEDNUM))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_RLD_VERSION))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_TIME_STAMP))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_ICHECKSUM))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_IVERSION))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_FLAGS))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_BASE_ADDRESS))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_MSYM))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_CONFLICT))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_LIBLIST))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_LOCAL_GOTNO))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_CONFLICTNO))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_LIBLISTNO))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_SYMTABNO))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_UNREFEXTNO))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_GOTSYM))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_HIPAGENO))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_RLD_MAP))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_DELTA_CLASS))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_DELTA_CLASS_NO))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_DELTA_INSTANCE))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_DELTA_INSTANCE_NO))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_DELTA_RELOC))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_DELTA_RELOC_NO))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_DELTA_SYM))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_DELTA_SYM_NO))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_DELTA_CLASSSYM))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_DELTA_CLASSSYM_NO))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_CXX_FLAGS))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_PIXIE_INIT))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_SYMBOL_LIB))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_LOCALPAGE_GOTIDX))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_LOCAL_GOTIDX))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_HIDDEN_GOTIDX))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_PROTECTED_GOTIDX))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_OPTIONS))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_INTERFACE))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_DYNSTR_ALIGN))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_INTERFACE_SIZE))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_RLD_TEXT_RESOLVE_ADDR))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_PERF_SUFFIX))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_COMPACT_SIZE))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_GP_VALUE))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_AUX_DYNAMIC))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_PLTGOT))
    .value(PY_ENUM(DYNAMIC_TAGS::DT_MIPS_RWPLT))
    .export_values();


  py::enum_<ELF_SYMBOL_TYPES>(m, "SYMBOL_TYPES")
    .value(PY_ENUM(ELF_SYMBOL_TYPES::STT_NOTYPE))
    .value(PY_ENUM(ELF_SYMBOL_TYPES::STT_OBJECT))
    .value(PY_ENUM(ELF_SYMBOL_TYPES::STT_FUNC))
    .value(PY_ENUM(ELF_SYMBOL_TYPES::STT_SECTION))
    .value(PY_ENUM(ELF_SYMBOL_TYPES::STT_FILE))
    .value(PY_ENUM(ELF_SYMBOL_TYPES::STT_COMMON))
    .value(PY_ENUM(ELF_SYMBOL_TYPES::STT_TLS))
    .value(PY_ENUM(ELF_SYMBOL_TYPES::STT_GNU_IFUNC))
    .value(PY_ENUM(ELF_SYMBOL_TYPES::STT_LOOS))
    .value(PY_ENUM(ELF_SYMBOL_TYPES::STT_HIOS))
    .value(PY_ENUM(ELF_SYMBOL_TYPES::STT_LOPROC))
    .value(PY_ENUM(ELF_SYMBOL_TYPES::STT_HIPROC))
    .export_values();


  py::enum_<SYMBOL_BINDINGS>(m, "SYMBOL_BINDINGS")
    .value(PY_ENUM(SYMBOL_BINDINGS::STB_LOCAL))
    .value(PY_ENUM(SYMBOL_BINDINGS::STB_GLOBAL))
    .value(PY_ENUM(SYMBOL_BINDINGS::STB_WEAK))
    .value(PY_ENUM(SYMBOL_BINDINGS::STB_GNU_UNIQUE))
    .value(PY_ENUM(SYMBOL_BINDINGS::STB_LOOS))
    .value(PY_ENUM(SYMBOL_BINDINGS::STB_HIOS))
    .value(PY_ENUM(SYMBOL_BINDINGS::STB_LOPROC))
    .value(PY_ENUM(SYMBOL_BINDINGS::STB_HIPROC))
    .export_values();


  py::enum_<RELOC_x86_64>(m, "RELOCATION_X86_64")
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_NONE))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_64))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_PC32))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_GOT32))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_PLT32))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_COPY))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_GLOB_DAT))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_JUMP_SLOT))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_RELATIVE))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_GOTPCREL))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_32))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_32S))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_16))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_PC16))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_8))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_PC8))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_DTPMOD64))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_DTPOFF64))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_TPOFF64))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_TLSGD))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_TLSLD))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_DTPOFF32))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_GOTTPOFF))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_TPOFF32))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_PC64))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_GOTOFF64))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_GOTPC32))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_GOT64))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_GOTPCREL64))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_GOTPC64))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_GOTPLT64))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_PLTOFF64))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_SIZE32))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_SIZE64))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_GOTPC32_TLSDESC))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_TLSDESC_CALL))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_TLSDESC))
    .value(PY_ENUM(RELOC_x86_64::R_X86_64_IRELATIVE))
    .export_values();


  py::enum_<RELOC_ARM>(m, "RELOCATION_ARM")
    .value(PY_ENUM(RELOC_ARM::R_ARM_NONE))
    .value(PY_ENUM(RELOC_ARM::R_ARM_PC24))
    .value(PY_ENUM(RELOC_ARM::R_ARM_ABS32))
    .value(PY_ENUM(RELOC_ARM::R_ARM_REL32))
    .value(PY_ENUM(RELOC_ARM::R_ARM_LDR_PC_G0))
    .value(PY_ENUM(RELOC_ARM::R_ARM_ABS16))
    .value(PY_ENUM(RELOC_ARM::R_ARM_ABS12))
    .value(PY_ENUM(RELOC_ARM::R_ARM_THM_ABS5))
    .value(PY_ENUM(RELOC_ARM::R_ARM_ABS8))
    .value(PY_ENUM(RELOC_ARM::R_ARM_SBREL32))
    .value(PY_ENUM(RELOC_ARM::R_ARM_THM_CALL))
    .value(PY_ENUM(RELOC_ARM::R_ARM_THM_PC8))
    .value(PY_ENUM(RELOC_ARM::R_ARM_BREL_ADJ))
    .value(PY_ENUM(RELOC_ARM::R_ARM_TLS_DESC))
    .value(PY_ENUM(RELOC_ARM::R_ARM_THM_SWI8))
    .value(PY_ENUM(RELOC_ARM::R_ARM_XPC25))
    .value(PY_ENUM(RELOC_ARM::R_ARM_THM_XPC22))
    .value(PY_ENUM(RELOC_ARM::R_ARM_TLS_DTPMOD32))
    .value(PY_ENUM(RELOC_ARM::R_ARM_TLS_DTPOFF32))
    .value(PY_ENUM(RELOC_ARM::R_ARM_TLS_TPOFF32))
    .value(PY_ENUM(RELOC_ARM::R_ARM_COPY))
    .value(PY_ENUM(RELOC_ARM::R_ARM_GLOB_DAT))
    .value(PY_ENUM(RELOC_ARM::R_ARM_JUMP_SLOT))
    .value(PY_ENUM(RELOC_ARM::R_ARM_RELATIVE))
    .value(PY_ENUM(RELOC_ARM::R_ARM_GOTOFF32))
    .value(PY_ENUM(RELOC_ARM::R_ARM_BASE_PREL))
    .value(PY_ENUM(RELOC_ARM::R_ARM_GOT_BREL))
    .value(PY_ENUM(RELOC_ARM::R_ARM_PLT32))
    .value(PY_ENUM(RELOC_ARM::R_ARM_CALL))
    .value(PY_ENUM(RELOC_ARM::R_ARM_JUMP24))
    .value(PY_ENUM(RELOC_ARM::R_ARM_THM_JUMP24))
    .value(PY_ENUM(RELOC_ARM::R_ARM_BASE_ABS))
    .value(PY_ENUM(RELOC_ARM::R_ARM_ALU_PCREL_7_0))
    .value(PY_ENUM(RELOC_ARM::R_ARM_ALU_PCREL_15_8))
    .value(PY_ENUM(RELOC_ARM::R_ARM_ALU_PCREL_23_15))
    .value(PY_ENUM(RELOC_ARM::R_ARM_LDR_SBREL_11_0_NC))
    .value(PY_ENUM(RELOC_ARM::R_ARM_ALU_SBREL_19_12_NC))
    .value(PY_ENUM(RELOC_ARM::R_ARM_ALU_SBREL_27_20_CK))
    .value(PY_ENUM(RELOC_ARM::R_ARM_TARGET1))
    .value(PY_ENUM(RELOC_ARM::R_ARM_SBREL31))
    .value(PY_ENUM(RELOC_ARM::R_ARM_V4BX))
    .value(PY_ENUM(RELOC_ARM::R_ARM_TARGET2))
    .value(PY_ENUM(RELOC_ARM::R_ARM_PREL31))
    .value(PY_ENUM(RELOC_ARM::R_ARM_MOVW_ABS_NC))
    .value(PY_ENUM(RELOC_ARM::R_ARM_MOVT_ABS))
    .value(PY_ENUM(RELOC_ARM::R_ARM_MOVW_PREL_NC))
    .value(PY_ENUM(RELOC_ARM::R_ARM_MOVT_PREL))
    .value(PY_ENUM(RELOC_ARM::R_ARM_THM_MOVW_ABS_NC))
    .value(PY_ENUM(RELOC_ARM::R_ARM_THM_MOVT_ABS))
    .value(PY_ENUM(RELOC_ARM::R_ARM_THM_MOVW_PREL_NC))
    .value(PY_ENUM(RELOC_ARM::R_ARM_THM_MOVT_PREL))
    .value(PY_ENUM(RELOC_ARM::R_ARM_THM_JUMP19))
    .value(PY_ENUM(RELOC_ARM::R_ARM_THM_JUMP6))
    .value(PY_ENUM(RELOC_ARM::R_ARM_THM_ALU_PREL_11_0))
    .value(PY_ENUM(RELOC_ARM::R_ARM_THM_PC12))
    .value(PY_ENUM(RELOC_ARM::R_ARM_ABS32_NOI))
    .value(PY_ENUM(RELOC_ARM::R_ARM_REL32_NOI))
    .value(PY_ENUM(RELOC_ARM::R_ARM_ALU_PC_G0_NC))
    .value(PY_ENUM(RELOC_ARM::R_ARM_ALU_PC_G0))
    .value(PY_ENUM(RELOC_ARM::R_ARM_ALU_PC_G1_NC))
    .value(PY_ENUM(RELOC_ARM::R_ARM_ALU_PC_G1))
    .value(PY_ENUM(RELOC_ARM::R_ARM_ALU_PC_G2))
    .value(PY_ENUM(RELOC_ARM::R_ARM_LDR_PC_G1))
    .value(PY_ENUM(RELOC_ARM::R_ARM_LDR_PC_G2))
    .value(PY_ENUM(RELOC_ARM::R_ARM_LDRS_PC_G0))
    .value(PY_ENUM(RELOC_ARM::R_ARM_LDRS_PC_G1))
    .value(PY_ENUM(RELOC_ARM::R_ARM_LDRS_PC_G2))
    .value(PY_ENUM(RELOC_ARM::R_ARM_LDC_PC_G0))
    .value(PY_ENUM(RELOC_ARM::R_ARM_LDC_PC_G1))
    .value(PY_ENUM(RELOC_ARM::R_ARM_LDC_PC_G2))
    .value(PY_ENUM(RELOC_ARM::R_ARM_ALU_SB_G0_NC))
    .value(PY_ENUM(RELOC_ARM::R_ARM_ALU_SB_G0))
    .value(PY_ENUM(RELOC_ARM::R_ARM_ALU_SB_G1_NC))
    .value(PY_ENUM(RELOC_ARM::R_ARM_ALU_SB_G1))
    .value(PY_ENUM(RELOC_ARM::R_ARM_ALU_SB_G2))
    .value(PY_ENUM(RELOC_ARM::R_ARM_LDR_SB_G0))
    .value(PY_ENUM(RELOC_ARM::R_ARM_LDR_SB_G1))
    .value(PY_ENUM(RELOC_ARM::R_ARM_LDR_SB_G2))
    .value(PY_ENUM(RELOC_ARM::R_ARM_LDRS_SB_G0))
    .value(PY_ENUM(RELOC_ARM::R_ARM_LDRS_SB_G1))
    .value(PY_ENUM(RELOC_ARM::R_ARM_LDRS_SB_G2))
    .value(PY_ENUM(RELOC_ARM::R_ARM_LDC_SB_G0))
    .value(PY_ENUM(RELOC_ARM::R_ARM_LDC_SB_G1))
    .value(PY_ENUM(RELOC_ARM::R_ARM_LDC_SB_G2))
    .value(PY_ENUM(RELOC_ARM::R_ARM_MOVW_BREL_NC))
    .value(PY_ENUM(RELOC_ARM::R_ARM_MOVT_BREL))
    .value(PY_ENUM(RELOC_ARM::R_ARM_MOVW_BREL))
    .value(PY_ENUM(RELOC_ARM::R_ARM_THM_MOVW_BREL_NC))
    .value(PY_ENUM(RELOC_ARM::R_ARM_THM_MOVT_BREL))
    .value(PY_ENUM(RELOC_ARM::R_ARM_THM_MOVW_BREL))
    .value(PY_ENUM(RELOC_ARM::R_ARM_TLS_GOTDESC))
    .value(PY_ENUM(RELOC_ARM::R_ARM_TLS_CALL))
    .value(PY_ENUM(RELOC_ARM::R_ARM_TLS_DESCSEQ))
    .value(PY_ENUM(RELOC_ARM::R_ARM_THM_TLS_CALL))
    .value(PY_ENUM(RELOC_ARM::R_ARM_PLT32_ABS))
    .value(PY_ENUM(RELOC_ARM::R_ARM_GOT_ABS))
    .value(PY_ENUM(RELOC_ARM::R_ARM_GOT_PREL))
    .value(PY_ENUM(RELOC_ARM::R_ARM_GOT_BREL12))
    .value(PY_ENUM(RELOC_ARM::R_ARM_GOTOFF12))
    .value(PY_ENUM(RELOC_ARM::R_ARM_GOTRELAX))
    .value(PY_ENUM(RELOC_ARM::R_ARM_GNU_VTENTRY))
    .value(PY_ENUM(RELOC_ARM::R_ARM_GNU_VTINHERIT))
    .value(PY_ENUM(RELOC_ARM::R_ARM_THM_JUMP11))
    .value(PY_ENUM(RELOC_ARM::R_ARM_THM_JUMP8))
    .value(PY_ENUM(RELOC_ARM::R_ARM_TLS_GD32))
    .value(PY_ENUM(RELOC_ARM::R_ARM_TLS_LDM32))
    .value(PY_ENUM(RELOC_ARM::R_ARM_TLS_LDO32))
    .value(PY_ENUM(RELOC_ARM::R_ARM_TLS_IE32))
    .value(PY_ENUM(RELOC_ARM::R_ARM_TLS_LE32))
    .value(PY_ENUM(RELOC_ARM::R_ARM_TLS_LDO12))
    .value(PY_ENUM(RELOC_ARM::R_ARM_TLS_LE12))
    .value(PY_ENUM(RELOC_ARM::R_ARM_TLS_IE12GP))
    .value(PY_ENUM(RELOC_ARM::R_ARM_PRIVATE_0))
    .value(PY_ENUM(RELOC_ARM::R_ARM_PRIVATE_1))
    .value(PY_ENUM(RELOC_ARM::R_ARM_PRIVATE_2))
    .value(PY_ENUM(RELOC_ARM::R_ARM_PRIVATE_3))
    .value(PY_ENUM(RELOC_ARM::R_ARM_PRIVATE_4))
    .value(PY_ENUM(RELOC_ARM::R_ARM_PRIVATE_5))
    .value(PY_ENUM(RELOC_ARM::R_ARM_PRIVATE_6))
    .value(PY_ENUM(RELOC_ARM::R_ARM_PRIVATE_7))
    .value(PY_ENUM(RELOC_ARM::R_ARM_PRIVATE_8))
    .value(PY_ENUM(RELOC_ARM::R_ARM_PRIVATE_9))
    .value(PY_ENUM(RELOC_ARM::R_ARM_PRIVATE_10))
    .value(PY_ENUM(RELOC_ARM::R_ARM_PRIVATE_11))
    .value(PY_ENUM(RELOC_ARM::R_ARM_PRIVATE_12))
    .value(PY_ENUM(RELOC_ARM::R_ARM_PRIVATE_13))
    .value(PY_ENUM(RELOC_ARM::R_ARM_PRIVATE_14))
    .value(PY_ENUM(RELOC_ARM::R_ARM_PRIVATE_15))
    .value(PY_ENUM(RELOC_ARM::R_ARM_ME_TOO))
    .value(PY_ENUM(RELOC_ARM::R_ARM_THM_TLS_DESCSEQ16))
    .value(PY_ENUM(RELOC_ARM::R_ARM_THM_TLS_DESCSEQ32))
    .value(PY_ENUM(RELOC_ARM::R_ARM_IRELATIVE))
    .value(PY_ENUM(RELOC_ARM::R_ARM_RXPC25))
    .value(PY_ENUM(RELOC_ARM::R_ARM_RSBREL32))
    .value(PY_ENUM(RELOC_ARM::R_ARM_THM_RPC22))
    .value(PY_ENUM(RELOC_ARM::R_ARM_RREL32))
    .value(PY_ENUM(RELOC_ARM::R_ARM_RPC24))
    .value(PY_ENUM(RELOC_ARM::R_ARM_RBASE))
    .export_values();


  py::enum_<RELOC_i386>(m, "RELOCATION_i386")
    .value(PY_ENUM(RELOC_i386::R_386_NONE))
    .value(PY_ENUM(RELOC_i386::R_386_32))
    .value(PY_ENUM(RELOC_i386::R_386_PC32))
    .value(PY_ENUM(RELOC_i386::R_386_GOT32))
    .value(PY_ENUM(RELOC_i386::R_386_PLT32))
    .value(PY_ENUM(RELOC_i386::R_386_COPY))
    .value(PY_ENUM(RELOC_i386::R_386_GLOB_DAT))
    .value(PY_ENUM(RELOC_i386::R_386_JUMP_SLOT))
    .value(PY_ENUM(RELOC_i386::R_386_RELATIVE))
    .value(PY_ENUM(RELOC_i386::R_386_GOTOFF))
    .value(PY_ENUM(RELOC_i386::R_386_GOTPC))
    .value(PY_ENUM(RELOC_i386::R_386_32PLT))
    .value(PY_ENUM(RELOC_i386::R_386_TLS_TPOFF))
    .value(PY_ENUM(RELOC_i386::R_386_TLS_IE))
    .value(PY_ENUM(RELOC_i386::R_386_TLS_GOTIE))
    .value(PY_ENUM(RELOC_i386::R_386_TLS_LE))
    .value(PY_ENUM(RELOC_i386::R_386_TLS_GD))
    .value(PY_ENUM(RELOC_i386::R_386_TLS_LDM))
    .value(PY_ENUM(RELOC_i386::R_386_16))
    .value(PY_ENUM(RELOC_i386::R_386_PC16))
    .value(PY_ENUM(RELOC_i386::R_386_8))
    .value(PY_ENUM(RELOC_i386::R_386_PC8))
    .value(PY_ENUM(RELOC_i386::R_386_TLS_GD_32))
    .value(PY_ENUM(RELOC_i386::R_386_TLS_GD_PUSH))
    .value(PY_ENUM(RELOC_i386::R_386_TLS_GD_CALL))
    .value(PY_ENUM(RELOC_i386::R_386_TLS_GD_POP))
    .value(PY_ENUM(RELOC_i386::R_386_TLS_LDM_32))
    .value(PY_ENUM(RELOC_i386::R_386_TLS_LDM_PUSH))
    .value(PY_ENUM(RELOC_i386::R_386_TLS_LDM_CALL))
    .value(PY_ENUM(RELOC_i386::R_386_TLS_LDM_POP))
    .value(PY_ENUM(RELOC_i386::R_386_TLS_LDO_32))
    .value(PY_ENUM(RELOC_i386::R_386_TLS_IE_32))
    .value(PY_ENUM(RELOC_i386::R_386_TLS_LE_32))
    .value(PY_ENUM(RELOC_i386::R_386_TLS_DTPMOD32))
    .value(PY_ENUM(RELOC_i386::R_386_TLS_DTPOFF32))
    .value(PY_ENUM(RELOC_i386::R_386_TLS_TPOFF32))
    .value(PY_ENUM(RELOC_i386::R_386_TLS_GOTDESC))
    .value(PY_ENUM(RELOC_i386::R_386_TLS_DESC_CALL))
    .value(PY_ENUM(RELOC_i386::R_386_TLS_DESC))
    .value(PY_ENUM(RELOC_i386::R_386_IRELATIVE))
    .value(PY_ENUM(RELOC_i386::R_386_NUM))
    .export_values();


  py::enum_<RELOC_AARCH64>(m, "RELOCATION_AARCH64")
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_NONE))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_ABS64))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_ABS32))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_ABS16))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_PREL64))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_PREL32))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_PREL16))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_MOVW_UABS_G0))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_MOVW_UABS_G0_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_MOVW_UABS_G1))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_MOVW_UABS_G1_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_MOVW_UABS_G2))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_MOVW_UABS_G2_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_MOVW_UABS_G3))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_MOVW_SABS_G0))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_MOVW_SABS_G1))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_MOVW_SABS_G2))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_LD_PREL_LO19))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_ADR_PREL_LO21))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_ADR_PREL_PG_HI21))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_ADR_PREL_PG_HI21_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_ADD_ABS_LO12_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_LDST8_ABS_LO12_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TSTBR14))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_CONDBR19))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_JUMP26))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_CALL26))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_LDST16_ABS_LO12_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_LDST32_ABS_LO12_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_LDST64_ABS_LO12_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_MOVW_PREL_G0))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_MOVW_PREL_G0_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_MOVW_PREL_G1))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_MOVW_PREL_G1_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_MOVW_PREL_G2))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_MOVW_PREL_G2_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_MOVW_PREL_G3))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_LDST128_ABS_LO12_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_MOVW_GOTOFF_G0))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_MOVW_GOTOFF_G0_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_MOVW_GOTOFF_G1))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_MOVW_GOTOFF_G1_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_MOVW_GOTOFF_G2))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_MOVW_GOTOFF_G2_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_MOVW_GOTOFF_G3))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_GOTREL64))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_GOTREL32))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_GOT_LD_PREL19))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_LD64_GOTOFF_LO15))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_ADR_GOT_PAGE))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_LD64_GOT_LO12_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_LD64_GOTPAGE_LO15))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSGD_ADR_PREL21))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSGD_ADR_PAGE21))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSGD_ADD_LO12_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSGD_MOVW_G1))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSGD_MOVW_G0_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLD_ADR_PREL21))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLD_ADR_PAGE21))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLD_ADD_LO12_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLD_MOVW_G1))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLD_MOVW_G0_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLD_LD_PREL19))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLD_MOVW_DTPREL_G2))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLD_MOVW_DTPREL_G1))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLD_MOVW_DTPREL_G1_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLD_MOVW_DTPREL_G0))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLD_MOVW_DTPREL_G0_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLD_ADD_DTPREL_HI12))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLD_ADD_DTPREL_LO12))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLD_ADD_DTPREL_LO12_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLD_LDST8_DTPREL_LO12))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLD_LDST8_DTPREL_LO12_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLD_LDST16_DTPREL_LO12))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLD_LDST16_DTPREL_LO12_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLD_LDST32_DTPREL_LO12))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLD_LDST32_DTPREL_LO12_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLD_LDST64_DTPREL_LO12))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLD_LDST64_DTPREL_LO12_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSIE_MOVW_GOTTPREL_G1))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSIE_MOVW_GOTTPREL_G0_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSIE_ADR_GOTTPREL_PAGE21))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSIE_LD64_GOTTPREL_LO12_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSIE_LD_GOTTPREL_PREL19))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLE_MOVW_TPREL_G2))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLE_MOVW_TPREL_G1))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLE_MOVW_TPREL_G1_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLE_MOVW_TPREL_G0))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLE_MOVW_TPREL_G0_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLE_ADD_TPREL_HI12))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLE_ADD_TPREL_LO12))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLE_ADD_TPREL_LO12_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLE_LDST8_TPREL_LO12))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLE_LDST8_TPREL_LO12_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLE_LDST16_TPREL_LO12))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLE_LDST16_TPREL_LO12_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLE_LDST32_TPREL_LO12))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLE_LDST32_TPREL_LO12_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLE_LDST64_TPREL_LO12))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLE_LDST64_TPREL_LO12_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSDESC_LD_PREL19))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSDESC_ADR_PREL21))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSDESC_ADR_PAGE21))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSDESC_LD64_LO12_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSDESC_ADD_LO12_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSDESC_OFF_G1))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSDESC_OFF_G0_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSDESC_LDR))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSDESC_ADD))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSDESC_CALL))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLE_LDST128_TPREL_LO12))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLE_LDST128_TPREL_LO12_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLD_LDST128_DTPREL_LO12))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSLD_LDST128_DTPREL_LO12_NC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_COPY))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_GLOB_DAT))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_JUMP_SLOT))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_RELATIVE))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLS_DTPREL64))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLS_DTPMOD64))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLS_TPREL64))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_TLSDESC))
    .value(PY_ENUM(RELOC_AARCH64::R_AARCH64_IRELATIVE))
    .export_values();


  py::enum_<DYNSYM_COUNT_METHODS>(m, "DYNSYM_COUNT_METHODS")
    .value(PY_ENUM(DYNSYM_COUNT_METHODS::COUNT_AUTO))
    .value(PY_ENUM(DYNSYM_COUNT_METHODS::COUNT_SECTION))
    .value(PY_ENUM(DYNSYM_COUNT_METHODS::COUNT_HASH))
    .value(PY_ENUM(DYNSYM_COUNT_METHODS::COUNT_RELOCATIONS))
    .export_values();


  py::enum_<NOTE_TYPES>(m, "NOTE_TYPES")
    .value(PY_ENUM(NOTE_TYPES::NT_GNU_ABI_TAG))
    .value(PY_ENUM(NOTE_TYPES::NT_GNU_HWCAP))
    .value(PY_ENUM(NOTE_TYPES::NT_GNU_BUILD_ID))
    .value(PY_ENUM(NOTE_TYPES::NT_GNU_GOLD_VERSION))
    .export_values();


  py::enum_<NOTE_ABIS>(m, "NOTE_ABIS")
    .value(PY_ENUM(NOTE_ABIS::ELF_NOTE_OS_LINUX))
    .value(PY_ENUM(NOTE_ABIS::ELF_NOTE_OS_GNU))
    .value(PY_ENUM(NOTE_ABIS::ELF_NOTE_OS_SOLARIS2))
    .value(PY_ENUM(NOTE_ABIS::ELF_NOTE_OS_FREEBSD))
    .value(PY_ENUM(NOTE_ABIS::ELF_NOTE_OS_NETBSD))
    .value(PY_ENUM(NOTE_ABIS::ELF_NOTE_OS_SYLLABLE))
    .export_values();


  py::enum_<RELOCATION_PURPOSES>(m, "RELOCATION_PURPOSES")
    .value(PY_ENUM(RELOCATION_PURPOSES::RELOC_PURPOSE_NONE))
    .value(PY_ENUM(RELOCATION_PURPOSES::RELOC_PURPOSE_PLTGOT))
    .value(PY_ENUM(RELOCATION_PURPOSES::RELOC_PURPOSE_DYNAMIC))
    .value(PY_ENUM(RELOCATION_PURPOSES::RELOC_PURPOSE_OBJECT))
    .export_values();


  py::enum_<ARM_EFLAGS>(m, "ARM_EFLAGS")
    .value(PY_ENUM(ARM_EFLAGS::EF_ARM_SOFT_FLOAT))
    .value(PY_ENUM(ARM_EFLAGS::EF_ARM_VFP_FLOAT))
    .value(PY_ENUM(ARM_EFLAGS::EF_ARM_EABI_UNKNOWN))
    .value(PY_ENUM(ARM_EFLAGS::EF_ARM_EABI_VER1))
    .value(PY_ENUM(ARM_EFLAGS::EF_ARM_EABI_VER2))
    .value(PY_ENUM(ARM_EFLAGS::EF_ARM_EABI_VER3))
    .value(PY_ENUM(ARM_EFLAGS::EF_ARM_EABI_VER4))
    .value(PY_ENUM(ARM_EFLAGS::EF_ARM_EABI_VER5))
    .export_values();


  py::enum_<PPC64_EFLAGS>(m, "PPC64_EFLAGS")
    .value(PY_ENUM(PPC64_EFLAGS::EF_PPC64_ABI))
    .export_values();

  py::enum_<MIPS_EFLAGS>(m, "MIPS_EFLAGS")
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_NOREORDER))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_PIC))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_CPIC))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_ABI2))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_32BITMODE))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_FP64))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_NAN2008))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_ABI_O32))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_ABI_O64))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_ABI_EABI32))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_ABI_EABI64))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_MACH_3900))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_MACH_4010))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_MACH_4100))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_MACH_4650))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_MACH_4120))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_MACH_4111))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_MACH_SB1))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_MACH_OCTEON))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_MACH_XLR))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_MACH_OCTEON2))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_MACH_OCTEON3))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_MACH_5400))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_MACH_5900))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_MACH_5500))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_MACH_9000))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_MACH_LS2E))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_MACH_LS2F))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_MACH_LS3A))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_MICROMIPS))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_ARCH_ASE_M16))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_ARCH_ASE_MDMX))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_ARCH_1))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_ARCH_2))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_ARCH_3))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_ARCH_4))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_ARCH_5))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_ARCH_32))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_ARCH_64))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_ARCH_32R2))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_ARCH_64R2))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_ARCH_32R6))
    .value(PY_ENUM(MIPS_EFLAGS::EF_MIPS_ARCH_64R6))
    .export_values();

  py::enum_<HEXAGON_EFLAGS>(m, "HEXAGON_EFLAGS")
    .value(PY_ENUM(HEXAGON_EFLAGS::EF_HEXAGON_MACH_V2))
    .value(PY_ENUM(HEXAGON_EFLAGS::EF_HEXAGON_MACH_V3))
    .value(PY_ENUM(HEXAGON_EFLAGS::EF_HEXAGON_MACH_V4))
    .value(PY_ENUM(HEXAGON_EFLAGS::EF_HEXAGON_MACH_V5))
    .value(PY_ENUM(HEXAGON_EFLAGS::EF_HEXAGON_ISA_MACH))
    .value(PY_ENUM(HEXAGON_EFLAGS::EF_HEXAGON_ISA_V2))
    .value(PY_ENUM(HEXAGON_EFLAGS::EF_HEXAGON_ISA_V3))
    .value(PY_ENUM(HEXAGON_EFLAGS::EF_HEXAGON_ISA_V4))
    .value(PY_ENUM(HEXAGON_EFLAGS::EF_HEXAGON_ISA_V5))
    .export_values();


  py::enum_<IDENTITY>(m, "IDENTITY")
    .value(PY_ENUM(IDENTITY::EI_MAG0))
    .value(PY_ENUM(IDENTITY::EI_MAG1))
    .value(PY_ENUM(IDENTITY::EI_MAG2))
    .value(PY_ENUM(IDENTITY::EI_MAG3))
    .value(PY_ENUM(IDENTITY::EI_CLASS))
    .value(PY_ENUM(IDENTITY::EI_DATA))
    .value(PY_ENUM(IDENTITY::EI_VERSION))
    .value(PY_ENUM(IDENTITY::EI_OSABI))
    .value(PY_ENUM(IDENTITY::EI_ABIVERSION))
    .value(PY_ENUM(IDENTITY::EI_PAD))
    .value(PY_ENUM(IDENTITY::EI_NIDENT))
    .export_values();


  py::enum_<SYMBOL_SECTION_INDEX>(m, "SYMBOL_SECTION_INDEX")
    .value(PY_ENUM(SYMBOL_SECTION_INDEX::SHN_UNDEF))
    .value(PY_ENUM(SYMBOL_SECTION_INDEX::SHN_LORESERVE))
    .value(PY_ENUM(SYMBOL_SECTION_INDEX::SHN_LOPROC))
    .value(PY_ENUM(SYMBOL_SECTION_INDEX::SHN_HIPROC))
    .value(PY_ENUM(SYMBOL_SECTION_INDEX::SHN_LOOS))
    .value(PY_ENUM(SYMBOL_SECTION_INDEX::SHN_HIOS))
    .value(PY_ENUM(SYMBOL_SECTION_INDEX::SHN_ABS))
    .value(PY_ENUM(SYMBOL_SECTION_INDEX::SHN_COMMON))
    .value(PY_ENUM(SYMBOL_SECTION_INDEX::SHN_XINDEX))
    .value(PY_ENUM(SYMBOL_SECTION_INDEX::SHN_HIRESERVE))
    .export_values();


  py::enum_<DYNAMIC_FLAGS>(m, "DYNAMIC_FLAGS")
    .value(PY_ENUM(DYNAMIC_FLAGS::DF_ORIGIN))
    .value(PY_ENUM(DYNAMIC_FLAGS::DF_SYMBOLIC))
    .value(PY_ENUM(DYNAMIC_FLAGS::DF_TEXTREL))
    .value(PY_ENUM(DYNAMIC_FLAGS::DF_BIND_NOW))
    .value(PY_ENUM(DYNAMIC_FLAGS::DF_STATIC_TLS))
    .export_values();

  py::enum_<DYNAMIC_FLAGS_1>(m, "DYNAMIC_FLAGS_1")
    .value(PY_ENUM(DYNAMIC_FLAGS_1::DF_1_NOW))
    .value(PY_ENUM(DYNAMIC_FLAGS_1::DF_1_GLOBAL))
    .value(PY_ENUM(DYNAMIC_FLAGS_1::DF_1_GROUP))
    .value(PY_ENUM(DYNAMIC_FLAGS_1::DF_1_NODELETE))
    .value(PY_ENUM(DYNAMIC_FLAGS_1::DF_1_LOADFLTR))
    .value(PY_ENUM(DYNAMIC_FLAGS_1::DF_1_INITFIRST))
    .value(PY_ENUM(DYNAMIC_FLAGS_1::DF_1_NOOPEN))
    .value(PY_ENUM(DYNAMIC_FLAGS_1::DF_1_ORIGIN))
    .value(PY_ENUM(DYNAMIC_FLAGS_1::DF_1_DIRECT))
    .value(PY_ENUM(DYNAMIC_FLAGS_1::DF_1_TRANS))
    .value(PY_ENUM(DYNAMIC_FLAGS_1::DF_1_INTERPOSE))
    .value(PY_ENUM(DYNAMIC_FLAGS_1::DF_1_NODEFLIB))
    .value(PY_ENUM(DYNAMIC_FLAGS_1::DF_1_NODUMP))
    .value(PY_ENUM(DYNAMIC_FLAGS_1::DF_1_CONFALT))
    .value(PY_ENUM(DYNAMIC_FLAGS_1::DF_1_ENDFILTEE))
    .value(PY_ENUM(DYNAMIC_FLAGS_1::DF_1_DISPRELDNE))
    .value(PY_ENUM(DYNAMIC_FLAGS_1::DF_1_DISPRELPND))
    .value(PY_ENUM(DYNAMIC_FLAGS_1::DF_1_NODIRECT))
    .value(PY_ENUM(DYNAMIC_FLAGS_1::DF_1_IGNMULDEF))
    .value(PY_ENUM(DYNAMIC_FLAGS_1::DF_1_NOKSYMS))
    .value(PY_ENUM(DYNAMIC_FLAGS_1::DF_1_NOHDR))
    .value(PY_ENUM(DYNAMIC_FLAGS_1::DF_1_EDITED))
    .value(PY_ENUM(DYNAMIC_FLAGS_1::DF_1_NORELOC))
    .value(PY_ENUM(DYNAMIC_FLAGS_1::DF_1_SYMINTPOSE))
    .value(PY_ENUM(DYNAMIC_FLAGS_1::DF_1_GLOBAUDIT))
    .value(PY_ENUM(DYNAMIC_FLAGS_1::DF_1_SINGLETON))
    .export_values();

}
