// Reconcile DEP-5 debian/copyright to licensecheck
//
// Copyright : 2023-2025 P Blackman
// License   : BSD-2-clause
//

unit compare;
{$mode delphi}

interface

procedure CompareLicenses;


implementation uses SysUtils, StrUtils, rstrings, support,
    exclude, gfdl, gpl, gpla, spdx, spdx2, dotzero,
    apache, ntprsa, eclipse, psf, andor, bsd0, options;


procedure CompareLicenses;
var F : tFileLic;
    Header,
    GotOne,
    MisMatch,
    FalsePositive : Boolean;
    last_Dep5,
    Last_Actual : String;
begin
    Header      := False;
    GotOne      := False;
    MisMatch    := False;
    Last_Dep5   := '';
    Last_Actual := '';

    for F in MyFiles do
        with F do
            if (Actual = '') then
                // Nothing to see here
            else
            begin
                MisMatch := not SameText(Dep5, Actual);
                FalsePositive := false;

                if MisMatch and not IgnoreFile (Fname) then
                    FalsePositive :=
                           CheckGPL     (Fname, Dep5, Actual)
                        or CheckGPLa    (Fname, Dep5, Actual)
                        or CheckSPDX    (Fname, Dep5, Actual)
                        or CheckSPDX2   (Fname, Dep5, Actual)
                        or CheckApache  (Fname, Dep5, Actual)
                        or CheckGFDL    (Fname, Dep5, Actual)
                        or CheckEclipse (Fname, Dep5, Actual)
                        or CheckPSF2    (Fname, Dep5, Actual)
                        or CheckBSD0    (Fname, Dep5, Actual)
                        or CheckDotZero (Dep5, Actual)
                        or CheckNTPRSA  (Dep5, Actual)
                        or CheckANDOR   (Dep5, Actual)
                        or ContainsStr (Actual, 'Autoconf-data');

                if not IgnoreFile (Fname)
                and (Option_Long or MisMatch and not FalsePositive) then
                begin
                   if not Header and not Option_Struct then
                    begin
                        Writeln ('d/copyright      | licensecheck');
                        Writeln;
                        Header := True;
                    end;

                    if Option_Terse and (Dep5 = last_Dep5) and (Actual = Last_Actual) then
                        // skip this file
                    else
                    if Option_Struct then
                    begin
                        Writeln (Dep5);
                        Writeln (Actual);
                        Writeln (FName);
                        Writeln;
                    end
                    else
                        Writeln (PadRight(Dep5,17), '| ', PadRight(Actual,17), ' ',FName);

                    Last_Dep5   := Dep5;
                    Last_Actual := Actual;
                    GotOne      := GotOne or (MisMatch and not FalsePositive);
                end;
            end;

    if GotOne then
    begin
        Writeln;
        Halt (3);
    end
    else
    if not Option_Struct then
        Writeln (rsNdf); // No differences found
end;

end.
