#ifndef LFORTRAN_ASR_H
#define LFORTRAN_ASR_H

// Generated by grammar/asdl_cpp.py

#include <libasr/alloc.h>
#include <libasr/location.h>
#include <libasr/colors.h>
#include <libasr/containers.h>
#include <libasr/exception.h>
#include <libasr/asr_scopes.h>
#include <libasr/string_utils.h>


namespace LCompilers::ASR {

enum asrType
{
    unit, symbol, stmt, expr, ttype, attribute, tbind, case_stmt, type_stmt, require_instantiation
};

struct asr_t
{
    asrType type;
    Location loc;
};


template <class T, class U>
inline bool is_a(const U &x)
{
    return T::class_type == x.type;
}

// Cast one level down

template <class T, class U>
static inline T* down_cast(const U *f)
{
    LCOMPILERS_ASSERT(f != nullptr);
    LCOMPILERS_ASSERT(is_a<T>(*f));
    return (T*)f;
}

// Cast two levels down

template <class T>
static inline T* down_cast2(const asr_t *f)
{
    typedef typename T::parent_type ptype;
    ptype *t = down_cast<ptype>(f);
    return down_cast<T>(t);
}

/******************************************************************************/
// Forward declarations

struct unit_t; // Sum
struct symbol_t; // Sum
struct stmt_t; // Sum
struct expr_t; // Sum
struct ttype_t; // Sum
enum cast_kindType // Simple Sum
{ // Types
    RealToInteger, IntegerToReal, LogicalToReal, RealToReal, IntegerToInteger, RealToComplex, IntegerToComplex, IntegerToLogical, RealToLogical, CharacterToLogical, CharacterToInteger, CharacterToList, ComplexToLogical, ComplexToComplex, ComplexToReal, ComplexToInteger, LogicalToInteger, RealToCharacter, IntegerToCharacter, LogicalToCharacter, UnsignedIntegerToInteger, UnsignedIntegerToUnsignedInteger, UnsignedIntegerToReal, UnsignedIntegerToLogical, IntegerToUnsignedInteger, RealToUnsignedInteger, CPtrToUnsignedInteger, UnsignedIntegerToCPtr, IntegerToSymbolicExpression, ListToArray
};
enum storage_typeType // Simple Sum
{ // Types
    Default, Save, Parameter
};
enum accessType // Simple Sum
{ // Types
    Public, Private
};
enum intentType // Simple Sum
{ // Types
    Local, In, Out, InOut, ReturnVar, Unspecified
};
enum deftypeType // Simple Sum
{ // Types
    Implementation, Interface
};
enum presenceType // Simple Sum
{ // Types
    Required, Optional
};
enum abiType // Simple Sum
{ // Types
    Source, LFortranModule, GFortranModule, BindC, BindPython, BindJS, Interactive, Intrinsic
};
struct dimension_t; // Product
struct alloc_arg_t; // Product
struct attribute_t; // Sum
struct attribute_arg_t; // Product
struct call_arg_t; // Product
struct tbind_t; // Sum
struct array_index_t; // Product
struct do_loop_head_t; // Product
struct case_stmt_t; // Sum
struct type_stmt_t; // Sum
enum enumtypeType // Simple Sum
{ // Types
    IntegerConsecutiveFromZero, IntegerUnique, IntegerNotUnique, NonInteger
};
struct require_instantiation_t; // Sum
enum array_physical_typeType // Simple Sum
{ // Types
    DescriptorArray, PointerToDataArray, UnboundedPointerToDataArray, FixedSizeArray, CharacterArraySinglePointer, NumPyArray, ISODescriptorArray, SIMDArray
};
enum binopType // Simple Sum
{ // Types
    Add, Sub, Mul, Div, Pow, BitAnd, BitOr, BitXor, BitLShift, BitRShift
};
enum logicalbinopType // Simple Sum
{ // Types
    And, Or, Xor, NEqv, Eqv
};
enum cmpopType // Simple Sum
{ // Types
    Eq, NotEq, Lt, LtE, Gt, GtE
};
enum integerbozType // Simple Sum
{ // Types
    Binary, Hex, Octal
};
enum arrayboundType // Simple Sum
{ // Types
    LBound, UBound
};
enum arraystorageType // Simple Sum
{ // Types
    RowMajor, ColMajor
};
enum string_format_kindType // Simple Sum
{ // Types
    FormatFortran, FormatC, FormatPythonPercent, FormatPythonFString, FormatPythonFormat
};


/******************************************************************************/
// Products declarations

struct dimension_t // Product
{
    Location loc;
    expr_t* m_start;
    expr_t* m_length;
};
struct alloc_arg_t // Product
{
    Location loc;
    expr_t* m_a;
    dimension_t* m_dims; size_t n_dims; // Sequence
    expr_t* m_len_expr;
    ttype_t* m_type;
};
struct attribute_arg_t // Product
{
    Location loc;
    char* m_arg;
};
struct call_arg_t // Product
{
    Location loc;
    expr_t* m_value;
};
struct array_index_t // Product
{
    Location loc;
    expr_t* m_left;
    expr_t* m_right;
    expr_t* m_step;
};
struct do_loop_head_t // Product
{
    Location loc;
    expr_t* m_v;
    expr_t* m_start;
    expr_t* m_end;
    expr_t* m_increment;
};


/******************************************************************************/
// Sums declarations

enum unitType // Types
{
    TranslationUnit
};

struct unit_t // Sum
{
    const static asrType class_type = asrType::unit;
    asr_t base;
    unitType type;
};

    struct TranslationUnit_t // Constructor
    {
        const static unitType class_type = unitType::TranslationUnit;
        typedef unit_t parent_type;
        unit_t base;
        SymbolTable* m_symtab;
        asr_t** m_items; size_t n_items; // Sequence
    };
    static inline asr_t* make_TranslationUnit_t(Allocator &al, const Location &a_loc, SymbolTable* a_symtab, asr_t** a_items, size_t n_items) {
        TranslationUnit_t *n;
        n = al.make_new<TranslationUnit_t>();
        n->base.type = unitType::TranslationUnit;
        n->base.base.type = asrType::unit;
        n->base.base.loc = a_loc;
        n->m_symtab = a_symtab;
        a_symtab->asr_owner = (asr_t*)n;
        n->m_items = a_items;
        n->n_items = n_items;
        return (asr_t*)n;
    }



enum symbolType // Types
{
    Program, Module, Function, GenericProcedure, CustomOperator, ExternalSymbol, StructType, EnumType, UnionType, Variable, ClassType, ClassProcedure, AssociateBlock, Block, Requirement, Template
};

struct symbol_t // Sum
{
    const static asrType class_type = asrType::symbol;
    asr_t base;
    symbolType type;
};

    struct Program_t // Constructor
    {
        const static symbolType class_type = symbolType::Program;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_symtab;
        char* m_name;
        char** m_dependencies; size_t n_dependencies; // Sequence
        stmt_t** m_body; size_t n_body; // Sequence
    };
    static inline asr_t* make_Program_t(Allocator &al, const Location &a_loc, SymbolTable* a_symtab, char* a_name, char** a_dependencies, size_t n_dependencies, stmt_t** a_body, size_t n_body) {
        Program_t *n;
        n = al.make_new<Program_t>();
        n->base.type = symbolType::Program;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_symtab = a_symtab;
        a_symtab->asr_owner = (asr_t*)n;
        n->m_name = a_name;
        n->m_dependencies = a_dependencies;
        n->n_dependencies = n_dependencies;
        n->m_body = a_body;
        n->n_body = n_body;
        return (asr_t*)n;
    }

    struct Module_t // Constructor
    {
        const static symbolType class_type = symbolType::Module;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_symtab;
        char* m_name;
        char** m_dependencies; size_t n_dependencies; // Sequence
        bool m_loaded_from_mod;
        bool m_intrinsic;
    };
    static inline asr_t* make_Module_t(Allocator &al, const Location &a_loc, SymbolTable* a_symtab, char* a_name, char** a_dependencies, size_t n_dependencies, bool a_loaded_from_mod, bool a_intrinsic) {
        Module_t *n;
        n = al.make_new<Module_t>();
        n->base.type = symbolType::Module;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_symtab = a_symtab;
        a_symtab->asr_owner = (asr_t*)n;
        n->m_name = a_name;
        n->m_dependencies = a_dependencies;
        n->n_dependencies = n_dependencies;
        n->m_loaded_from_mod = a_loaded_from_mod;
        n->m_intrinsic = a_intrinsic;
        return (asr_t*)n;
    }

    struct Function_t // Constructor
    {
        const static symbolType class_type = symbolType::Function;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_symtab;
        char* m_name;
        ttype_t* m_function_signature;
        char** m_dependencies; size_t n_dependencies; // Sequence
        expr_t** m_args; size_t n_args; // Sequence
        stmt_t** m_body; size_t n_body; // Sequence
        expr_t* m_return_var;
        accessType m_access;
        bool m_deterministic;
        bool m_side_effect_free;
        char* m_module_file;
    };
    static inline asr_t* make_Function_t(Allocator &al, const Location &a_loc, SymbolTable* a_symtab, char* a_name, ttype_t* a_function_signature, char** a_dependencies, size_t n_dependencies, expr_t** a_args, size_t n_args, stmt_t** a_body, size_t n_body, expr_t* a_return_var, accessType a_access, bool a_deterministic, bool a_side_effect_free, char* a_module_file) {
        Function_t *n;
        n = al.make_new<Function_t>();
        n->base.type = symbolType::Function;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_symtab = a_symtab;
        a_symtab->asr_owner = (asr_t*)n;
        n->m_name = a_name;
        n->m_function_signature = a_function_signature;
        n->m_dependencies = a_dependencies;
        n->n_dependencies = n_dependencies;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_return_var = a_return_var;
        n->m_access = a_access;
        n->m_deterministic = a_deterministic;
        n->m_side_effect_free = a_side_effect_free;
        n->m_module_file = a_module_file;
        return (asr_t*)n;
    }

    struct GenericProcedure_t // Constructor
    {
        const static symbolType class_type = symbolType::GenericProcedure;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_parent_symtab;
        char* m_name;
        symbol_t** m_procs; size_t n_procs; // Sequence
        accessType m_access;
    };
    static inline asr_t* make_GenericProcedure_t(Allocator &al, const Location &a_loc, SymbolTable* a_parent_symtab, char* a_name, symbol_t** a_procs, size_t n_procs, accessType a_access) {
        GenericProcedure_t *n;
        n = al.make_new<GenericProcedure_t>();
        n->base.type = symbolType::GenericProcedure;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_parent_symtab = a_parent_symtab;
        n->m_name = a_name;
        n->m_procs = a_procs;
        n->n_procs = n_procs;
        n->m_access = a_access;
        return (asr_t*)n;
    }

    struct CustomOperator_t // Constructor
    {
        const static symbolType class_type = symbolType::CustomOperator;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_parent_symtab;
        char* m_name;
        symbol_t** m_procs; size_t n_procs; // Sequence
        accessType m_access;
    };
    static inline asr_t* make_CustomOperator_t(Allocator &al, const Location &a_loc, SymbolTable* a_parent_symtab, char* a_name, symbol_t** a_procs, size_t n_procs, accessType a_access) {
        CustomOperator_t *n;
        n = al.make_new<CustomOperator_t>();
        n->base.type = symbolType::CustomOperator;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_parent_symtab = a_parent_symtab;
        n->m_name = a_name;
        n->m_procs = a_procs;
        n->n_procs = n_procs;
        n->m_access = a_access;
        return (asr_t*)n;
    }

    struct ExternalSymbol_t // Constructor
    {
        const static symbolType class_type = symbolType::ExternalSymbol;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_parent_symtab;
        char* m_name;
        symbol_t* m_external;
        char* m_module_name;
        char** m_scope_names; size_t n_scope_names; // Sequence
        char* m_original_name;
        accessType m_access;
    };
    static inline asr_t* make_ExternalSymbol_t(Allocator &al, const Location &a_loc, SymbolTable* a_parent_symtab, char* a_name, symbol_t* a_external, char* a_module_name, char** a_scope_names, size_t n_scope_names, char* a_original_name, accessType a_access) {
        ExternalSymbol_t *n;
        n = al.make_new<ExternalSymbol_t>();
        n->base.type = symbolType::ExternalSymbol;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_parent_symtab = a_parent_symtab;
        n->m_name = a_name;
        n->m_external = a_external;
        n->m_module_name = a_module_name;
        n->m_scope_names = a_scope_names;
        n->n_scope_names = n_scope_names;
        n->m_original_name = a_original_name;
        n->m_access = a_access;
        return (asr_t*)n;
    }

    struct StructType_t // Constructor
    {
        const static symbolType class_type = symbolType::StructType;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_symtab;
        char* m_name;
        char** m_dependencies; size_t n_dependencies; // Sequence
        char** m_members; size_t n_members; // Sequence
        abiType m_abi;
        accessType m_access;
        bool m_is_packed;
        bool m_is_abstract;
        call_arg_t* m_initializers; size_t n_initializers; // Sequence
        expr_t* m_alignment;
        symbol_t* m_parent;
    };
    static inline asr_t* make_StructType_t(Allocator &al, const Location &a_loc, SymbolTable* a_symtab, char* a_name, char** a_dependencies, size_t n_dependencies, char** a_members, size_t n_members, abiType a_abi, accessType a_access, bool a_is_packed, bool a_is_abstract, call_arg_t* a_initializers, size_t n_initializers, expr_t* a_alignment, symbol_t* a_parent) {
        StructType_t *n;
        n = al.make_new<StructType_t>();
        n->base.type = symbolType::StructType;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_symtab = a_symtab;
        a_symtab->asr_owner = (asr_t*)n;
        n->m_name = a_name;
        n->m_dependencies = a_dependencies;
        n->n_dependencies = n_dependencies;
        n->m_members = a_members;
        n->n_members = n_members;
        n->m_abi = a_abi;
        n->m_access = a_access;
        n->m_is_packed = a_is_packed;
        n->m_is_abstract = a_is_abstract;
        n->m_initializers = a_initializers;
        n->n_initializers = n_initializers;
        n->m_alignment = a_alignment;
        n->m_parent = a_parent;
        return (asr_t*)n;
    }

    struct EnumType_t // Constructor
    {
        const static symbolType class_type = symbolType::EnumType;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_symtab;
        char* m_name;
        char** m_dependencies; size_t n_dependencies; // Sequence
        char** m_members; size_t n_members; // Sequence
        abiType m_abi;
        accessType m_access;
        enumtypeType m_enum_value_type;
        ttype_t* m_type;
        symbol_t* m_parent;
    };
    static inline asr_t* make_EnumType_t(Allocator &al, const Location &a_loc, SymbolTable* a_symtab, char* a_name, char** a_dependencies, size_t n_dependencies, char** a_members, size_t n_members, abiType a_abi, accessType a_access, enumtypeType a_enum_value_type, ttype_t* a_type, symbol_t* a_parent) {
        EnumType_t *n;
        n = al.make_new<EnumType_t>();
        n->base.type = symbolType::EnumType;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_symtab = a_symtab;
        a_symtab->asr_owner = (asr_t*)n;
        n->m_name = a_name;
        n->m_dependencies = a_dependencies;
        n->n_dependencies = n_dependencies;
        n->m_members = a_members;
        n->n_members = n_members;
        n->m_abi = a_abi;
        n->m_access = a_access;
        n->m_enum_value_type = a_enum_value_type;
        n->m_type = a_type;
        n->m_parent = a_parent;
        return (asr_t*)n;
    }

    struct UnionType_t // Constructor
    {
        const static symbolType class_type = symbolType::UnionType;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_symtab;
        char* m_name;
        char** m_dependencies; size_t n_dependencies; // Sequence
        char** m_members; size_t n_members; // Sequence
        abiType m_abi;
        accessType m_access;
        call_arg_t* m_initializers; size_t n_initializers; // Sequence
        symbol_t* m_parent;
    };
    static inline asr_t* make_UnionType_t(Allocator &al, const Location &a_loc, SymbolTable* a_symtab, char* a_name, char** a_dependencies, size_t n_dependencies, char** a_members, size_t n_members, abiType a_abi, accessType a_access, call_arg_t* a_initializers, size_t n_initializers, symbol_t* a_parent) {
        UnionType_t *n;
        n = al.make_new<UnionType_t>();
        n->base.type = symbolType::UnionType;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_symtab = a_symtab;
        a_symtab->asr_owner = (asr_t*)n;
        n->m_name = a_name;
        n->m_dependencies = a_dependencies;
        n->n_dependencies = n_dependencies;
        n->m_members = a_members;
        n->n_members = n_members;
        n->m_abi = a_abi;
        n->m_access = a_access;
        n->m_initializers = a_initializers;
        n->n_initializers = n_initializers;
        n->m_parent = a_parent;
        return (asr_t*)n;
    }

    struct Variable_t // Constructor
    {
        const static symbolType class_type = symbolType::Variable;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_parent_symtab;
        char* m_name;
        char** m_dependencies; size_t n_dependencies; // Sequence
        intentType m_intent;
        expr_t* m_symbolic_value;
        expr_t* m_value;
        storage_typeType m_storage;
        ttype_t* m_type;
        symbol_t* m_type_declaration;
        abiType m_abi;
        accessType m_access;
        presenceType m_presence;
        bool m_value_attr;
    };
    static inline asr_t* make_Variable_t(Allocator &al, const Location &a_loc, SymbolTable* a_parent_symtab, char* a_name, char** a_dependencies, size_t n_dependencies, intentType a_intent, expr_t* a_symbolic_value, expr_t* a_value, storage_typeType a_storage, ttype_t* a_type, symbol_t* a_type_declaration, abiType a_abi, accessType a_access, presenceType a_presence, bool a_value_attr) {
        Variable_t *n;
        n = al.make_new<Variable_t>();
        n->base.type = symbolType::Variable;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_parent_symtab = a_parent_symtab;
        n->m_name = a_name;
        n->m_dependencies = a_dependencies;
        n->n_dependencies = n_dependencies;
        n->m_intent = a_intent;
        n->m_symbolic_value = a_symbolic_value;
        n->m_value = a_value;
        n->m_storage = a_storage;
        n->m_type = a_type;
        n->m_type_declaration = a_type_declaration;
        n->m_abi = a_abi;
        n->m_access = a_access;
        n->m_presence = a_presence;
        n->m_value_attr = a_value_attr;
        return (asr_t*)n;
    }

    struct ClassType_t // Constructor
    {
        const static symbolType class_type = symbolType::ClassType;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_symtab;
        char* m_name;
        abiType m_abi;
        accessType m_access;
    };
    static inline asr_t* make_ClassType_t(Allocator &al, const Location &a_loc, SymbolTable* a_symtab, char* a_name, abiType a_abi, accessType a_access) {
        ClassType_t *n;
        n = al.make_new<ClassType_t>();
        n->base.type = symbolType::ClassType;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_symtab = a_symtab;
        a_symtab->asr_owner = (asr_t*)n;
        n->m_name = a_name;
        n->m_abi = a_abi;
        n->m_access = a_access;
        return (asr_t*)n;
    }

    struct ClassProcedure_t // Constructor
    {
        const static symbolType class_type = symbolType::ClassProcedure;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_parent_symtab;
        char* m_name;
        char* m_self_argument;
        char* m_proc_name;
        symbol_t* m_proc;
        abiType m_abi;
        bool m_is_deferred;
        bool m_is_nopass;
    };
    static inline asr_t* make_ClassProcedure_t(Allocator &al, const Location &a_loc, SymbolTable* a_parent_symtab, char* a_name, char* a_self_argument, char* a_proc_name, symbol_t* a_proc, abiType a_abi, bool a_is_deferred, bool a_is_nopass) {
        ClassProcedure_t *n;
        n = al.make_new<ClassProcedure_t>();
        n->base.type = symbolType::ClassProcedure;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_parent_symtab = a_parent_symtab;
        n->m_name = a_name;
        n->m_self_argument = a_self_argument;
        n->m_proc_name = a_proc_name;
        n->m_proc = a_proc;
        n->m_abi = a_abi;
        n->m_is_deferred = a_is_deferred;
        n->m_is_nopass = a_is_nopass;
        return (asr_t*)n;
    }

    struct AssociateBlock_t // Constructor
    {
        const static symbolType class_type = symbolType::AssociateBlock;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_symtab;
        char* m_name;
        stmt_t** m_body; size_t n_body; // Sequence
    };
    static inline asr_t* make_AssociateBlock_t(Allocator &al, const Location &a_loc, SymbolTable* a_symtab, char* a_name, stmt_t** a_body, size_t n_body) {
        AssociateBlock_t *n;
        n = al.make_new<AssociateBlock_t>();
        n->base.type = symbolType::AssociateBlock;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_symtab = a_symtab;
        a_symtab->asr_owner = (asr_t*)n;
        n->m_name = a_name;
        n->m_body = a_body;
        n->n_body = n_body;
        return (asr_t*)n;
    }

    struct Block_t // Constructor
    {
        const static symbolType class_type = symbolType::Block;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_symtab;
        char* m_name;
        stmt_t** m_body; size_t n_body; // Sequence
    };
    static inline asr_t* make_Block_t(Allocator &al, const Location &a_loc, SymbolTable* a_symtab, char* a_name, stmt_t** a_body, size_t n_body) {
        Block_t *n;
        n = al.make_new<Block_t>();
        n->base.type = symbolType::Block;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_symtab = a_symtab;
        a_symtab->asr_owner = (asr_t*)n;
        n->m_name = a_name;
        n->m_body = a_body;
        n->n_body = n_body;
        return (asr_t*)n;
    }

    struct Requirement_t // Constructor
    {
        const static symbolType class_type = symbolType::Requirement;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_symtab;
        char* m_name;
        char** m_args; size_t n_args; // Sequence
        require_instantiation_t** m_requires; size_t n_requires; // Sequence
    };
    static inline asr_t* make_Requirement_t(Allocator &al, const Location &a_loc, SymbolTable* a_symtab, char* a_name, char** a_args, size_t n_args, require_instantiation_t** a_requires, size_t n_requires) {
        Requirement_t *n;
        n = al.make_new<Requirement_t>();
        n->base.type = symbolType::Requirement;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_symtab = a_symtab;
        a_symtab->asr_owner = (asr_t*)n;
        n->m_name = a_name;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_requires = a_requires;
        n->n_requires = n_requires;
        return (asr_t*)n;
    }

    struct Template_t // Constructor
    {
        const static symbolType class_type = symbolType::Template;
        typedef symbol_t parent_type;
        symbol_t base;
        SymbolTable* m_symtab;
        char* m_name;
        char** m_args; size_t n_args; // Sequence
        require_instantiation_t** m_requires; size_t n_requires; // Sequence
    };
    static inline asr_t* make_Template_t(Allocator &al, const Location &a_loc, SymbolTable* a_symtab, char* a_name, char** a_args, size_t n_args, require_instantiation_t** a_requires, size_t n_requires) {
        Template_t *n;
        n = al.make_new<Template_t>();
        n->base.type = symbolType::Template;
        n->base.base.type = asrType::symbol;
        n->base.base.loc = a_loc;
        n->m_symtab = a_symtab;
        a_symtab->asr_owner = (asr_t*)n;
        n->m_name = a_name;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_requires = a_requires;
        n->n_requires = n_requires;
        return (asr_t*)n;
    }



enum stmtType // Types
{
    Allocate, ReAlloc, Assign, Assignment, Associate, Cycle, ExplicitDeallocate, ImplicitDeallocate, DoConcurrentLoop, DoLoop, ErrorStop, Exit, ForAllSingle, GoTo, GoToTarget, If, IfArithmetic, Print, FileOpen, FileClose, FileRead, FileBackspace, FileRewind, FileInquire, FileWrite, Return, Select, Stop, Assert, SubroutineCall, IntrinsicImpureSubroutine, Where, WhileLoop, Nullify, Flush, ListAppend, AssociateBlockCall, SelectType, CPtrToPointer, BlockCall, SetInsert, SetRemove, ListInsert, ListRemove, ListClear, DictInsert, Expr
};

struct stmt_t // Sum
{
    const static asrType class_type = asrType::stmt;
    asr_t base;
    stmtType type;
};

    struct Allocate_t // Constructor
    {
        const static stmtType class_type = stmtType::Allocate;
        typedef stmt_t parent_type;
        stmt_t base;
        alloc_arg_t* m_args; size_t n_args; // Sequence
        expr_t* m_stat;
        expr_t* m_errmsg;
        expr_t* m_source;
    };
    static inline asr_t* make_Allocate_t(Allocator &al, const Location &a_loc, alloc_arg_t* a_args, size_t n_args, expr_t* a_stat, expr_t* a_errmsg, expr_t* a_source) {
        Allocate_t *n;
        n = al.make_new<Allocate_t>();
        n->base.type = stmtType::Allocate;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_stat = a_stat;
        n->m_errmsg = a_errmsg;
        n->m_source = a_source;
        return (asr_t*)n;
    }

    struct ReAlloc_t // Constructor
    {
        const static stmtType class_type = stmtType::ReAlloc;
        typedef stmt_t parent_type;
        stmt_t base;
        alloc_arg_t* m_args; size_t n_args; // Sequence
    };
    static inline asr_t* make_ReAlloc_t(Allocator &al, const Location &a_loc, alloc_arg_t* a_args, size_t n_args) {
        ReAlloc_t *n;
        n = al.make_new<ReAlloc_t>();
        n->base.type = stmtType::ReAlloc;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_args = a_args;
        n->n_args = n_args;
        return (asr_t*)n;
    }

    struct Assign_t // Constructor
    {
        const static stmtType class_type = stmtType::Assign;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        char* m_variable;
    };
    static inline asr_t* make_Assign_t(Allocator &al, const Location &a_loc, int64_t a_label, char* a_variable) {
        Assign_t *n;
        n = al.make_new<Assign_t>();
        n->base.type = stmtType::Assign;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_variable = a_variable;
        return (asr_t*)n;
    }

    struct Assignment_t // Constructor
    {
        const static stmtType class_type = stmtType::Assignment;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_target;
        expr_t* m_value;
        stmt_t* m_overloaded;
    };
    static inline asr_t* make_Assignment_t(Allocator &al, const Location &a_loc, expr_t* a_target, expr_t* a_value, stmt_t* a_overloaded) {
        Assignment_t *n;
        n = al.make_new<Assignment_t>();
        n->base.type = stmtType::Assignment;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_target = a_target;
        n->m_value = a_value;
        n->m_overloaded = a_overloaded;
        return (asr_t*)n;
    }

    struct Associate_t // Constructor
    {
        const static stmtType class_type = stmtType::Associate;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_target;
        expr_t* m_value;
    };
    static inline asr_t* make_Associate_t(Allocator &al, const Location &a_loc, expr_t* a_target, expr_t* a_value) {
        Associate_t *n;
        n = al.make_new<Associate_t>();
        n->base.type = stmtType::Associate;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_target = a_target;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct Cycle_t // Constructor
    {
        const static stmtType class_type = stmtType::Cycle;
        typedef stmt_t parent_type;
        stmt_t base;
        char* m_stmt_name;
    };
    static inline asr_t* make_Cycle_t(Allocator &al, const Location &a_loc, char* a_stmt_name) {
        Cycle_t *n;
        n = al.make_new<Cycle_t>();
        n->base.type = stmtType::Cycle;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_stmt_name = a_stmt_name;
        return (asr_t*)n;
    }

    struct ExplicitDeallocate_t // Constructor
    {
        const static stmtType class_type = stmtType::ExplicitDeallocate;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t** m_vars; size_t n_vars; // Sequence
    };
    static inline asr_t* make_ExplicitDeallocate_t(Allocator &al, const Location &a_loc, expr_t** a_vars, size_t n_vars) {
        ExplicitDeallocate_t *n;
        n = al.make_new<ExplicitDeallocate_t>();
        n->base.type = stmtType::ExplicitDeallocate;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_vars = a_vars;
        n->n_vars = n_vars;
        return (asr_t*)n;
    }

    struct ImplicitDeallocate_t // Constructor
    {
        const static stmtType class_type = stmtType::ImplicitDeallocate;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t** m_vars; size_t n_vars; // Sequence
    };
    static inline asr_t* make_ImplicitDeallocate_t(Allocator &al, const Location &a_loc, expr_t** a_vars, size_t n_vars) {
        ImplicitDeallocate_t *n;
        n = al.make_new<ImplicitDeallocate_t>();
        n->base.type = stmtType::ImplicitDeallocate;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_vars = a_vars;
        n->n_vars = n_vars;
        return (asr_t*)n;
    }

    struct DoConcurrentLoop_t // Constructor
    {
        const static stmtType class_type = stmtType::DoConcurrentLoop;
        typedef stmt_t parent_type;
        stmt_t base;
        do_loop_head_t m_head;
        expr_t** m_shared; size_t n_shared; // Sequence
        expr_t** m_local; size_t n_local; // Sequence
        stmt_t** m_body; size_t n_body; // Sequence
    };
    static inline asr_t* make_DoConcurrentLoop_t(Allocator &al, const Location &a_loc, do_loop_head_t a_head, expr_t** a_shared, size_t n_shared, expr_t** a_local, size_t n_local, stmt_t** a_body, size_t n_body) {
        DoConcurrentLoop_t *n;
        n = al.make_new<DoConcurrentLoop_t>();
        n->base.type = stmtType::DoConcurrentLoop;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_head = a_head;
        n->m_shared = a_shared;
        n->n_shared = n_shared;
        n->m_local = a_local;
        n->n_local = n_local;
        n->m_body = a_body;
        n->n_body = n_body;
        return (asr_t*)n;
    }

    struct DoLoop_t // Constructor
    {
        const static stmtType class_type = stmtType::DoLoop;
        typedef stmt_t parent_type;
        stmt_t base;
        char* m_name;
        do_loop_head_t m_head;
        stmt_t** m_body; size_t n_body; // Sequence
        stmt_t** m_orelse; size_t n_orelse; // Sequence
    };
    static inline asr_t* make_DoLoop_t(Allocator &al, const Location &a_loc, char* a_name, do_loop_head_t a_head, stmt_t** a_body, size_t n_body, stmt_t** a_orelse, size_t n_orelse) {
        DoLoop_t *n;
        n = al.make_new<DoLoop_t>();
        n->base.type = stmtType::DoLoop;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_head = a_head;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_orelse = a_orelse;
        n->n_orelse = n_orelse;
        return (asr_t*)n;
    }

    struct ErrorStop_t // Constructor
    {
        const static stmtType class_type = stmtType::ErrorStop;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_code;
    };
    static inline asr_t* make_ErrorStop_t(Allocator &al, const Location &a_loc, expr_t* a_code) {
        ErrorStop_t *n;
        n = al.make_new<ErrorStop_t>();
        n->base.type = stmtType::ErrorStop;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_code = a_code;
        return (asr_t*)n;
    }

    struct Exit_t // Constructor
    {
        const static stmtType class_type = stmtType::Exit;
        typedef stmt_t parent_type;
        stmt_t base;
        char* m_stmt_name;
    };
    static inline asr_t* make_Exit_t(Allocator &al, const Location &a_loc, char* a_stmt_name) {
        Exit_t *n;
        n = al.make_new<Exit_t>();
        n->base.type = stmtType::Exit;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_stmt_name = a_stmt_name;
        return (asr_t*)n;
    }

    struct ForAllSingle_t // Constructor
    {
        const static stmtType class_type = stmtType::ForAllSingle;
        typedef stmt_t parent_type;
        stmt_t base;
        do_loop_head_t m_head;
        stmt_t* m_assign_stmt;
    };
    static inline asr_t* make_ForAllSingle_t(Allocator &al, const Location &a_loc, do_loop_head_t a_head, stmt_t* a_assign_stmt) {
        ForAllSingle_t *n;
        n = al.make_new<ForAllSingle_t>();
        n->base.type = stmtType::ForAllSingle;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_head = a_head;
        n->m_assign_stmt = a_assign_stmt;
        return (asr_t*)n;
    }

    struct GoTo_t // Constructor
    {
        const static stmtType class_type = stmtType::GoTo;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_target_id;
        char* m_name;
    };
    static inline asr_t* make_GoTo_t(Allocator &al, const Location &a_loc, int64_t a_target_id, char* a_name) {
        GoTo_t *n;
        n = al.make_new<GoTo_t>();
        n->base.type = stmtType::GoTo;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_target_id = a_target_id;
        n->m_name = a_name;
        return (asr_t*)n;
    }

    struct GoToTarget_t // Constructor
    {
        const static stmtType class_type = stmtType::GoToTarget;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_id;
        char* m_name;
    };
    static inline asr_t* make_GoToTarget_t(Allocator &al, const Location &a_loc, int64_t a_id, char* a_name) {
        GoToTarget_t *n;
        n = al.make_new<GoToTarget_t>();
        n->base.type = stmtType::GoToTarget;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_id = a_id;
        n->m_name = a_name;
        return (asr_t*)n;
    }

    struct If_t // Constructor
    {
        const static stmtType class_type = stmtType::If;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_test;
        stmt_t** m_body; size_t n_body; // Sequence
        stmt_t** m_orelse; size_t n_orelse; // Sequence
    };
    static inline asr_t* make_If_t(Allocator &al, const Location &a_loc, expr_t* a_test, stmt_t** a_body, size_t n_body, stmt_t** a_orelse, size_t n_orelse) {
        If_t *n;
        n = al.make_new<If_t>();
        n->base.type = stmtType::If;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_test = a_test;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_orelse = a_orelse;
        n->n_orelse = n_orelse;
        return (asr_t*)n;
    }

    struct IfArithmetic_t // Constructor
    {
        const static stmtType class_type = stmtType::IfArithmetic;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_test;
        int64_t m_lt_label;
        int64_t m_eq_label;
        int64_t m_gt_label;
    };
    static inline asr_t* make_IfArithmetic_t(Allocator &al, const Location &a_loc, expr_t* a_test, int64_t a_lt_label, int64_t a_eq_label, int64_t a_gt_label) {
        IfArithmetic_t *n;
        n = al.make_new<IfArithmetic_t>();
        n->base.type = stmtType::IfArithmetic;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_test = a_test;
        n->m_lt_label = a_lt_label;
        n->m_eq_label = a_eq_label;
        n->m_gt_label = a_gt_label;
        return (asr_t*)n;
    }

    struct Print_t // Constructor
    {
        const static stmtType class_type = stmtType::Print;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t** m_values; size_t n_values; // Sequence
        expr_t* m_separator;
        expr_t* m_end;
    };
    static inline asr_t* make_Print_t(Allocator &al, const Location &a_loc, expr_t** a_values, size_t n_values, expr_t* a_separator, expr_t* a_end) {
        Print_t *n;
        n = al.make_new<Print_t>();
        n->base.type = stmtType::Print;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_values = a_values;
        n->n_values = n_values;
        n->m_separator = a_separator;
        n->m_end = a_end;
        return (asr_t*)n;
    }

    struct FileOpen_t // Constructor
    {
        const static stmtType class_type = stmtType::FileOpen;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t* m_newunit;
        expr_t* m_filename;
        expr_t* m_status;
        expr_t* m_form;
    };
    static inline asr_t* make_FileOpen_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t* a_newunit, expr_t* a_filename, expr_t* a_status, expr_t* a_form) {
        FileOpen_t *n;
        n = al.make_new<FileOpen_t>();
        n->base.type = stmtType::FileOpen;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_newunit = a_newunit;
        n->m_filename = a_filename;
        n->m_status = a_status;
        n->m_form = a_form;
        return (asr_t*)n;
    }

    struct FileClose_t // Constructor
    {
        const static stmtType class_type = stmtType::FileClose;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t* m_unit;
        expr_t* m_iostat;
        expr_t* m_iomsg;
        expr_t* m_err;
        expr_t* m_status;
    };
    static inline asr_t* make_FileClose_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t* a_unit, expr_t* a_iostat, expr_t* a_iomsg, expr_t* a_err, expr_t* a_status) {
        FileClose_t *n;
        n = al.make_new<FileClose_t>();
        n->base.type = stmtType::FileClose;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_unit = a_unit;
        n->m_iostat = a_iostat;
        n->m_iomsg = a_iomsg;
        n->m_err = a_err;
        n->m_status = a_status;
        return (asr_t*)n;
    }

    struct FileRead_t // Constructor
    {
        const static stmtType class_type = stmtType::FileRead;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t* m_unit;
        expr_t* m_fmt;
        expr_t* m_iomsg;
        expr_t* m_iostat;
        expr_t* m_size;
        expr_t* m_id;
        expr_t** m_values; size_t n_values; // Sequence
        stmt_t* m_overloaded;
    };
    static inline asr_t* make_FileRead_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t* a_unit, expr_t* a_fmt, expr_t* a_iomsg, expr_t* a_iostat, expr_t* a_size, expr_t* a_id, expr_t** a_values, size_t n_values, stmt_t* a_overloaded) {
        FileRead_t *n;
        n = al.make_new<FileRead_t>();
        n->base.type = stmtType::FileRead;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_unit = a_unit;
        n->m_fmt = a_fmt;
        n->m_iomsg = a_iomsg;
        n->m_iostat = a_iostat;
        n->m_size = a_size;
        n->m_id = a_id;
        n->m_values = a_values;
        n->n_values = n_values;
        n->m_overloaded = a_overloaded;
        return (asr_t*)n;
    }

    struct FileBackspace_t // Constructor
    {
        const static stmtType class_type = stmtType::FileBackspace;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t* m_unit;
        expr_t* m_iostat;
        expr_t* m_err;
    };
    static inline asr_t* make_FileBackspace_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t* a_unit, expr_t* a_iostat, expr_t* a_err) {
        FileBackspace_t *n;
        n = al.make_new<FileBackspace_t>();
        n->base.type = stmtType::FileBackspace;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_unit = a_unit;
        n->m_iostat = a_iostat;
        n->m_err = a_err;
        return (asr_t*)n;
    }

    struct FileRewind_t // Constructor
    {
        const static stmtType class_type = stmtType::FileRewind;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t* m_unit;
        expr_t* m_iostat;
        expr_t* m_err;
    };
    static inline asr_t* make_FileRewind_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t* a_unit, expr_t* a_iostat, expr_t* a_err) {
        FileRewind_t *n;
        n = al.make_new<FileRewind_t>();
        n->base.type = stmtType::FileRewind;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_unit = a_unit;
        n->m_iostat = a_iostat;
        n->m_err = a_err;
        return (asr_t*)n;
    }

    struct FileInquire_t // Constructor
    {
        const static stmtType class_type = stmtType::FileInquire;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t* m_unit;
        expr_t* m_file;
        expr_t* m_iostat;
        expr_t* m_err;
        expr_t* m_exist;
        expr_t* m_opened;
        expr_t* m_number;
        expr_t* m_named;
        expr_t* m_name;
        expr_t* m_access;
        expr_t* m_sequential;
        expr_t* m_direct;
        expr_t* m_form;
        expr_t* m_formatted;
        expr_t* m_unformatted;
        expr_t* m_recl;
        expr_t* m_nextrec;
        expr_t* m_blank;
        expr_t* m_position;
        expr_t* m_action;
        expr_t* m_read;
        expr_t* m_write;
        expr_t* m_readwrite;
        expr_t* m_delim;
        expr_t* m_pad;
        expr_t* m_flen;
        expr_t* m_blocksize;
        expr_t* m_convert;
        expr_t* m_carriagecontrol;
        expr_t* m_iolength;
    };
    static inline asr_t* make_FileInquire_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t* a_unit, expr_t* a_file, expr_t* a_iostat, expr_t* a_err, expr_t* a_exist, expr_t* a_opened, expr_t* a_number, expr_t* a_named, expr_t* a_name, expr_t* a_access, expr_t* a_sequential, expr_t* a_direct, expr_t* a_form, expr_t* a_formatted, expr_t* a_unformatted, expr_t* a_recl, expr_t* a_nextrec, expr_t* a_blank, expr_t* a_position, expr_t* a_action, expr_t* a_read, expr_t* a_write, expr_t* a_readwrite, expr_t* a_delim, expr_t* a_pad, expr_t* a_flen, expr_t* a_blocksize, expr_t* a_convert, expr_t* a_carriagecontrol, expr_t* a_iolength) {
        FileInquire_t *n;
        n = al.make_new<FileInquire_t>();
        n->base.type = stmtType::FileInquire;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_unit = a_unit;
        n->m_file = a_file;
        n->m_iostat = a_iostat;
        n->m_err = a_err;
        n->m_exist = a_exist;
        n->m_opened = a_opened;
        n->m_number = a_number;
        n->m_named = a_named;
        n->m_name = a_name;
        n->m_access = a_access;
        n->m_sequential = a_sequential;
        n->m_direct = a_direct;
        n->m_form = a_form;
        n->m_formatted = a_formatted;
        n->m_unformatted = a_unformatted;
        n->m_recl = a_recl;
        n->m_nextrec = a_nextrec;
        n->m_blank = a_blank;
        n->m_position = a_position;
        n->m_action = a_action;
        n->m_read = a_read;
        n->m_write = a_write;
        n->m_readwrite = a_readwrite;
        n->m_delim = a_delim;
        n->m_pad = a_pad;
        n->m_flen = a_flen;
        n->m_blocksize = a_blocksize;
        n->m_convert = a_convert;
        n->m_carriagecontrol = a_carriagecontrol;
        n->m_iolength = a_iolength;
        return (asr_t*)n;
    }

    struct FileWrite_t // Constructor
    {
        const static stmtType class_type = stmtType::FileWrite;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t* m_unit;
        expr_t* m_iomsg;
        expr_t* m_iostat;
        expr_t* m_id;
        expr_t** m_values; size_t n_values; // Sequence
        expr_t* m_separator;
        expr_t* m_end;
        stmt_t* m_overloaded;
    };
    static inline asr_t* make_FileWrite_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t* a_unit, expr_t* a_iomsg, expr_t* a_iostat, expr_t* a_id, expr_t** a_values, size_t n_values, expr_t* a_separator, expr_t* a_end, stmt_t* a_overloaded) {
        FileWrite_t *n;
        n = al.make_new<FileWrite_t>();
        n->base.type = stmtType::FileWrite;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_unit = a_unit;
        n->m_iomsg = a_iomsg;
        n->m_iostat = a_iostat;
        n->m_id = a_id;
        n->m_values = a_values;
        n->n_values = n_values;
        n->m_separator = a_separator;
        n->m_end = a_end;
        n->m_overloaded = a_overloaded;
        return (asr_t*)n;
    }

    struct Return_t // Constructor
    {
        const static stmtType class_type = stmtType::Return;
        typedef stmt_t parent_type;
        stmt_t base;
    };
    static inline asr_t* make_Return_t(Allocator &al, const Location &a_loc) {
        Return_t *n;
        n = al.make_new<Return_t>();
        n->base.type = stmtType::Return;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        return (asr_t*)n;
    }

    struct Select_t // Constructor
    {
        const static stmtType class_type = stmtType::Select;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_test;
        case_stmt_t** m_body; size_t n_body; // Sequence
        stmt_t** m_default; size_t n_default; // Sequence
        bool m_enable_fall_through;
    };
    static inline asr_t* make_Select_t(Allocator &al, const Location &a_loc, expr_t* a_test, case_stmt_t** a_body, size_t n_body, stmt_t** a_default, size_t n_default, bool a_enable_fall_through) {
        Select_t *n;
        n = al.make_new<Select_t>();
        n->base.type = stmtType::Select;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_test = a_test;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_default = a_default;
        n->n_default = n_default;
        n->m_enable_fall_through = a_enable_fall_through;
        return (asr_t*)n;
    }

    struct Stop_t // Constructor
    {
        const static stmtType class_type = stmtType::Stop;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_code;
    };
    static inline asr_t* make_Stop_t(Allocator &al, const Location &a_loc, expr_t* a_code) {
        Stop_t *n;
        n = al.make_new<Stop_t>();
        n->base.type = stmtType::Stop;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_code = a_code;
        return (asr_t*)n;
    }

    struct Assert_t // Constructor
    {
        const static stmtType class_type = stmtType::Assert;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_test;
        expr_t* m_msg;
    };
    static inline asr_t* make_Assert_t(Allocator &al, const Location &a_loc, expr_t* a_test, expr_t* a_msg) {
        Assert_t *n;
        n = al.make_new<Assert_t>();
        n->base.type = stmtType::Assert;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_test = a_test;
        n->m_msg = a_msg;
        return (asr_t*)n;
    }

    struct SubroutineCall_t // Constructor
    {
        const static stmtType class_type = stmtType::SubroutineCall;
        typedef stmt_t parent_type;
        stmt_t base;
        symbol_t* m_name;
        symbol_t* m_original_name;
        call_arg_t* m_args; size_t n_args; // Sequence
        expr_t* m_dt;
    };
    static inline asr_t* make_SubroutineCall_t(Allocator &al, const Location &a_loc, symbol_t* a_name, symbol_t* a_original_name, call_arg_t* a_args, size_t n_args, expr_t* a_dt) {
        SubroutineCall_t *n;
        n = al.make_new<SubroutineCall_t>();
        n->base.type = stmtType::SubroutineCall;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_original_name = a_original_name;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_dt = a_dt;
        return (asr_t*)n;
    }

    struct IntrinsicImpureSubroutine_t // Constructor
    {
        const static stmtType class_type = stmtType::IntrinsicImpureSubroutine;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_intrinsic_id;
        expr_t** m_args; size_t n_args; // Sequence
        int64_t m_overload_id;
    };
    static inline asr_t* make_IntrinsicImpureSubroutine_t(Allocator &al, const Location &a_loc, int64_t a_intrinsic_id, expr_t** a_args, size_t n_args, int64_t a_overload_id) {
        IntrinsicImpureSubroutine_t *n;
        n = al.make_new<IntrinsicImpureSubroutine_t>();
        n->base.type = stmtType::IntrinsicImpureSubroutine;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_intrinsic_id = a_intrinsic_id;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_overload_id = a_overload_id;
        return (asr_t*)n;
    }

    struct Where_t // Constructor
    {
        const static stmtType class_type = stmtType::Where;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_test;
        stmt_t** m_body; size_t n_body; // Sequence
        stmt_t** m_orelse; size_t n_orelse; // Sequence
    };
    static inline asr_t* make_Where_t(Allocator &al, const Location &a_loc, expr_t* a_test, stmt_t** a_body, size_t n_body, stmt_t** a_orelse, size_t n_orelse) {
        Where_t *n;
        n = al.make_new<Where_t>();
        n->base.type = stmtType::Where;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_test = a_test;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_orelse = a_orelse;
        n->n_orelse = n_orelse;
        return (asr_t*)n;
    }

    struct WhileLoop_t // Constructor
    {
        const static stmtType class_type = stmtType::WhileLoop;
        typedef stmt_t parent_type;
        stmt_t base;
        char* m_name;
        expr_t* m_test;
        stmt_t** m_body; size_t n_body; // Sequence
        stmt_t** m_orelse; size_t n_orelse; // Sequence
    };
    static inline asr_t* make_WhileLoop_t(Allocator &al, const Location &a_loc, char* a_name, expr_t* a_test, stmt_t** a_body, size_t n_body, stmt_t** a_orelse, size_t n_orelse) {
        WhileLoop_t *n;
        n = al.make_new<WhileLoop_t>();
        n->base.type = stmtType::WhileLoop;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_test = a_test;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_orelse = a_orelse;
        n->n_orelse = n_orelse;
        return (asr_t*)n;
    }

    struct Nullify_t // Constructor
    {
        const static stmtType class_type = stmtType::Nullify;
        typedef stmt_t parent_type;
        stmt_t base;
        symbol_t** m_vars; size_t n_vars; // Sequence
    };
    static inline asr_t* make_Nullify_t(Allocator &al, const Location &a_loc, symbol_t** a_vars, size_t n_vars) {
        Nullify_t *n;
        n = al.make_new<Nullify_t>();
        n->base.type = stmtType::Nullify;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_vars = a_vars;
        n->n_vars = n_vars;
        return (asr_t*)n;
    }

    struct Flush_t // Constructor
    {
        const static stmtType class_type = stmtType::Flush;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        expr_t* m_unit;
        expr_t* m_err;
        expr_t* m_iomsg;
        expr_t* m_iostat;
    };
    static inline asr_t* make_Flush_t(Allocator &al, const Location &a_loc, int64_t a_label, expr_t* a_unit, expr_t* a_err, expr_t* a_iomsg, expr_t* a_iostat) {
        Flush_t *n;
        n = al.make_new<Flush_t>();
        n->base.type = stmtType::Flush;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_unit = a_unit;
        n->m_err = a_err;
        n->m_iomsg = a_iomsg;
        n->m_iostat = a_iostat;
        return (asr_t*)n;
    }

    struct ListAppend_t // Constructor
    {
        const static stmtType class_type = stmtType::ListAppend;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_a;
        expr_t* m_ele;
    };
    static inline asr_t* make_ListAppend_t(Allocator &al, const Location &a_loc, expr_t* a_a, expr_t* a_ele) {
        ListAppend_t *n;
        n = al.make_new<ListAppend_t>();
        n->base.type = stmtType::ListAppend;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_a = a_a;
        n->m_ele = a_ele;
        return (asr_t*)n;
    }

    struct AssociateBlockCall_t // Constructor
    {
        const static stmtType class_type = stmtType::AssociateBlockCall;
        typedef stmt_t parent_type;
        stmt_t base;
        symbol_t* m_m;
    };
    static inline asr_t* make_AssociateBlockCall_t(Allocator &al, const Location &a_loc, symbol_t* a_m) {
        AssociateBlockCall_t *n;
        n = al.make_new<AssociateBlockCall_t>();
        n->base.type = stmtType::AssociateBlockCall;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_m = a_m;
        return (asr_t*)n;
    }

    struct SelectType_t // Constructor
    {
        const static stmtType class_type = stmtType::SelectType;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_selector;
        type_stmt_t** m_body; size_t n_body; // Sequence
        stmt_t** m_default; size_t n_default; // Sequence
    };
    static inline asr_t* make_SelectType_t(Allocator &al, const Location &a_loc, expr_t* a_selector, type_stmt_t** a_body, size_t n_body, stmt_t** a_default, size_t n_default) {
        SelectType_t *n;
        n = al.make_new<SelectType_t>();
        n->base.type = stmtType::SelectType;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_selector = a_selector;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_default = a_default;
        n->n_default = n_default;
        return (asr_t*)n;
    }

    struct CPtrToPointer_t // Constructor
    {
        const static stmtType class_type = stmtType::CPtrToPointer;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_cptr;
        expr_t* m_ptr;
        expr_t* m_shape;
        expr_t* m_lower_bounds;
    };
    static inline asr_t* make_CPtrToPointer_t(Allocator &al, const Location &a_loc, expr_t* a_cptr, expr_t* a_ptr, expr_t* a_shape, expr_t* a_lower_bounds) {
        CPtrToPointer_t *n;
        n = al.make_new<CPtrToPointer_t>();
        n->base.type = stmtType::CPtrToPointer;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_cptr = a_cptr;
        n->m_ptr = a_ptr;
        n->m_shape = a_shape;
        n->m_lower_bounds = a_lower_bounds;
        return (asr_t*)n;
    }

    struct BlockCall_t // Constructor
    {
        const static stmtType class_type = stmtType::BlockCall;
        typedef stmt_t parent_type;
        stmt_t base;
        int64_t m_label;
        symbol_t* m_m;
    };
    static inline asr_t* make_BlockCall_t(Allocator &al, const Location &a_loc, int64_t a_label, symbol_t* a_m) {
        BlockCall_t *n;
        n = al.make_new<BlockCall_t>();
        n->base.type = stmtType::BlockCall;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_label = a_label;
        n->m_m = a_m;
        return (asr_t*)n;
    }

    struct SetInsert_t // Constructor
    {
        const static stmtType class_type = stmtType::SetInsert;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_a;
        expr_t* m_ele;
    };
    static inline asr_t* make_SetInsert_t(Allocator &al, const Location &a_loc, expr_t* a_a, expr_t* a_ele) {
        SetInsert_t *n;
        n = al.make_new<SetInsert_t>();
        n->base.type = stmtType::SetInsert;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_a = a_a;
        n->m_ele = a_ele;
        return (asr_t*)n;
    }

    struct SetRemove_t // Constructor
    {
        const static stmtType class_type = stmtType::SetRemove;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_a;
        expr_t* m_ele;
    };
    static inline asr_t* make_SetRemove_t(Allocator &al, const Location &a_loc, expr_t* a_a, expr_t* a_ele) {
        SetRemove_t *n;
        n = al.make_new<SetRemove_t>();
        n->base.type = stmtType::SetRemove;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_a = a_a;
        n->m_ele = a_ele;
        return (asr_t*)n;
    }

    struct ListInsert_t // Constructor
    {
        const static stmtType class_type = stmtType::ListInsert;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_a;
        expr_t* m_pos;
        expr_t* m_ele;
    };
    static inline asr_t* make_ListInsert_t(Allocator &al, const Location &a_loc, expr_t* a_a, expr_t* a_pos, expr_t* a_ele) {
        ListInsert_t *n;
        n = al.make_new<ListInsert_t>();
        n->base.type = stmtType::ListInsert;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_a = a_a;
        n->m_pos = a_pos;
        n->m_ele = a_ele;
        return (asr_t*)n;
    }

    struct ListRemove_t // Constructor
    {
        const static stmtType class_type = stmtType::ListRemove;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_a;
        expr_t* m_ele;
    };
    static inline asr_t* make_ListRemove_t(Allocator &al, const Location &a_loc, expr_t* a_a, expr_t* a_ele) {
        ListRemove_t *n;
        n = al.make_new<ListRemove_t>();
        n->base.type = stmtType::ListRemove;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_a = a_a;
        n->m_ele = a_ele;
        return (asr_t*)n;
    }

    struct ListClear_t // Constructor
    {
        const static stmtType class_type = stmtType::ListClear;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_a;
    };
    static inline asr_t* make_ListClear_t(Allocator &al, const Location &a_loc, expr_t* a_a) {
        ListClear_t *n;
        n = al.make_new<ListClear_t>();
        n->base.type = stmtType::ListClear;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_a = a_a;
        return (asr_t*)n;
    }

    struct DictInsert_t // Constructor
    {
        const static stmtType class_type = stmtType::DictInsert;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_a;
        expr_t* m_key;
        expr_t* m_value;
    };
    static inline asr_t* make_DictInsert_t(Allocator &al, const Location &a_loc, expr_t* a_a, expr_t* a_key, expr_t* a_value) {
        DictInsert_t *n;
        n = al.make_new<DictInsert_t>();
        n->base.type = stmtType::DictInsert;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_a = a_a;
        n->m_key = a_key;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct Expr_t // Constructor
    {
        const static stmtType class_type = stmtType::Expr;
        typedef stmt_t parent_type;
        stmt_t base;
        expr_t* m_expression;
    };
    static inline asr_t* make_Expr_t(Allocator &al, const Location &a_loc, expr_t* a_expression) {
        Expr_t *n;
        n = al.make_new<Expr_t>();
        n->base.type = stmtType::Expr;
        n->base.base.type = asrType::stmt;
        n->base.base.loc = a_loc;
        n->m_expression = a_expression;
        return (asr_t*)n;
    }



enum exprType // Types
{
    IfExp, ComplexConstructor, NamedExpr, FunctionCall, IntrinsicElementalFunction, IntrinsicArrayFunction, IntrinsicImpureFunction, TypeInquiry, StructTypeConstructor, EnumTypeConstructor, UnionTypeConstructor, ImpliedDoLoop, IntegerConstant, IntegerBOZ, IntegerBitNot, IntegerUnaryMinus, IntegerCompare, IntegerBinOp, UnsignedIntegerConstant, UnsignedIntegerUnaryMinus, UnsignedIntegerBitNot, UnsignedIntegerCompare, UnsignedIntegerBinOp, RealConstant, RealUnaryMinus, RealCompare, RealBinOp, RealCopySign, ComplexConstant, ComplexUnaryMinus, ComplexCompare, ComplexBinOp, LogicalConstant, LogicalNot, LogicalCompare, LogicalBinOp, ListConstant, ListLen, ListConcat, ListCompare, ListCount, SetConstant, SetLen, TupleConstant, TupleLen, TupleCompare, TupleConcat, StringConstant, StringConcat, StringRepeat, StringLen, StringItem, StringSection, StringCompare, StringOrd, StringChr, StringFormat, CPtrCompare, SymbolicCompare, DictConstant, DictLen, Var, FunctionParam, ArrayConstructor, ArrayConstant, ArrayItem, ArraySection, ArraySize, ArrayBound, ArrayTranspose, ArrayPack, ArrayReshape, ArrayBroadcast, BitCast, StructInstanceMember, StructStaticMember, EnumStaticMember, UnionInstanceMember, EnumName, EnumValue, OverloadedCompare, OverloadedBinOp, OverloadedUnaryMinus, OverloadedStringConcat, Cast, ArrayPhysicalCast, ComplexRe, ComplexIm, DictItem, CLoc, PointerToCPtr, GetPointer, ListItem, TupleItem, ListSection, ListRepeat, DictPop, SetPop, IntegerBitLen, Ichar, Iachar, SizeOfType, PointerNullConstant, PointerAssociated, RealSqrt
};

struct expr_t // Sum
{
    const static asrType class_type = asrType::expr;
    asr_t base;
    exprType type;
};

    struct IfExp_t // Constructor
    {
        const static exprType class_type = exprType::IfExp;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_test;
        expr_t* m_body;
        expr_t* m_orelse;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_IfExp_t(Allocator &al, const Location &a_loc, expr_t* a_test, expr_t* a_body, expr_t* a_orelse, ttype_t* a_type, expr_t* a_value) {
        IfExp_t *n;
        n = al.make_new<IfExp_t>();
        n->base.type = exprType::IfExp;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_test = a_test;
        n->m_body = a_body;
        n->m_orelse = a_orelse;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ComplexConstructor_t // Constructor
    {
        const static exprType class_type = exprType::ComplexConstructor;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_re;
        expr_t* m_im;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ComplexConstructor_t(Allocator &al, const Location &a_loc, expr_t* a_re, expr_t* a_im, ttype_t* a_type, expr_t* a_value) {
        ComplexConstructor_t *n;
        n = al.make_new<ComplexConstructor_t>();
        n->base.type = exprType::ComplexConstructor;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_re = a_re;
        n->m_im = a_im;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct NamedExpr_t // Constructor
    {
        const static exprType class_type = exprType::NamedExpr;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_target;
        expr_t* m_value;
        ttype_t* m_type;
    };
    static inline asr_t* make_NamedExpr_t(Allocator &al, const Location &a_loc, expr_t* a_target, expr_t* a_value, ttype_t* a_type) {
        NamedExpr_t *n;
        n = al.make_new<NamedExpr_t>();
        n->base.type = exprType::NamedExpr;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_target = a_target;
        n->m_value = a_value;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct FunctionCall_t // Constructor
    {
        const static exprType class_type = exprType::FunctionCall;
        typedef expr_t parent_type;
        expr_t base;
        symbol_t* m_name;
        symbol_t* m_original_name;
        call_arg_t* m_args; size_t n_args; // Sequence
        ttype_t* m_type;
        expr_t* m_value;
        expr_t* m_dt;
    };
    static inline asr_t* make_FunctionCall_t(Allocator &al, const Location &a_loc, symbol_t* a_name, symbol_t* a_original_name, call_arg_t* a_args, size_t n_args, ttype_t* a_type, expr_t* a_value, expr_t* a_dt) {
        FunctionCall_t *n;
        n = al.make_new<FunctionCall_t>();
        n->base.type = exprType::FunctionCall;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_original_name = a_original_name;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_type = a_type;
        n->m_value = a_value;
        n->m_dt = a_dt;
        return (asr_t*)n;
    }

    struct IntrinsicElementalFunction_t // Constructor
    {
        const static exprType class_type = exprType::IntrinsicElementalFunction;
        typedef expr_t parent_type;
        expr_t base;
        int64_t m_intrinsic_id;
        expr_t** m_args; size_t n_args; // Sequence
        int64_t m_overload_id;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_IntrinsicElementalFunction_t(Allocator &al, const Location &a_loc, int64_t a_intrinsic_id, expr_t** a_args, size_t n_args, int64_t a_overload_id, ttype_t* a_type, expr_t* a_value) {
        IntrinsicElementalFunction_t *n;
        n = al.make_new<IntrinsicElementalFunction_t>();
        n->base.type = exprType::IntrinsicElementalFunction;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_intrinsic_id = a_intrinsic_id;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_overload_id = a_overload_id;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct IntrinsicArrayFunction_t // Constructor
    {
        const static exprType class_type = exprType::IntrinsicArrayFunction;
        typedef expr_t parent_type;
        expr_t base;
        int64_t m_arr_intrinsic_id;
        expr_t** m_args; size_t n_args; // Sequence
        int64_t m_overload_id;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_IntrinsicArrayFunction_t(Allocator &al, const Location &a_loc, int64_t a_arr_intrinsic_id, expr_t** a_args, size_t n_args, int64_t a_overload_id, ttype_t* a_type, expr_t* a_value) {
        IntrinsicArrayFunction_t *n;
        n = al.make_new<IntrinsicArrayFunction_t>();
        n->base.type = exprType::IntrinsicArrayFunction;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arr_intrinsic_id = a_arr_intrinsic_id;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_overload_id = a_overload_id;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct IntrinsicImpureFunction_t // Constructor
    {
        const static exprType class_type = exprType::IntrinsicImpureFunction;
        typedef expr_t parent_type;
        expr_t base;
        int64_t m_impure_intrinsic_id;
        expr_t** m_args; size_t n_args; // Sequence
        int64_t m_overload_id;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_IntrinsicImpureFunction_t(Allocator &al, const Location &a_loc, int64_t a_impure_intrinsic_id, expr_t** a_args, size_t n_args, int64_t a_overload_id, ttype_t* a_type, expr_t* a_value) {
        IntrinsicImpureFunction_t *n;
        n = al.make_new<IntrinsicImpureFunction_t>();
        n->base.type = exprType::IntrinsicImpureFunction;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_impure_intrinsic_id = a_impure_intrinsic_id;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_overload_id = a_overload_id;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct TypeInquiry_t // Constructor
    {
        const static exprType class_type = exprType::TypeInquiry;
        typedef expr_t parent_type;
        expr_t base;
        int64_t m_inquiry_id;
        ttype_t* m_arg_type;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_TypeInquiry_t(Allocator &al, const Location &a_loc, int64_t a_inquiry_id, ttype_t* a_arg_type, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        TypeInquiry_t *n;
        n = al.make_new<TypeInquiry_t>();
        n->base.type = exprType::TypeInquiry;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_inquiry_id = a_inquiry_id;
        n->m_arg_type = a_arg_type;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct StructTypeConstructor_t // Constructor
    {
        const static exprType class_type = exprType::StructTypeConstructor;
        typedef expr_t parent_type;
        expr_t base;
        symbol_t* m_dt_sym;
        call_arg_t* m_args; size_t n_args; // Sequence
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_StructTypeConstructor_t(Allocator &al, const Location &a_loc, symbol_t* a_dt_sym, call_arg_t* a_args, size_t n_args, ttype_t* a_type, expr_t* a_value) {
        StructTypeConstructor_t *n;
        n = al.make_new<StructTypeConstructor_t>();
        n->base.type = exprType::StructTypeConstructor;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_dt_sym = a_dt_sym;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct EnumTypeConstructor_t // Constructor
    {
        const static exprType class_type = exprType::EnumTypeConstructor;
        typedef expr_t parent_type;
        expr_t base;
        symbol_t* m_dt_sym;
        expr_t** m_args; size_t n_args; // Sequence
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_EnumTypeConstructor_t(Allocator &al, const Location &a_loc, symbol_t* a_dt_sym, expr_t** a_args, size_t n_args, ttype_t* a_type, expr_t* a_value) {
        EnumTypeConstructor_t *n;
        n = al.make_new<EnumTypeConstructor_t>();
        n->base.type = exprType::EnumTypeConstructor;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_dt_sym = a_dt_sym;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct UnionTypeConstructor_t // Constructor
    {
        const static exprType class_type = exprType::UnionTypeConstructor;
        typedef expr_t parent_type;
        expr_t base;
        symbol_t* m_dt_sym;
        expr_t** m_args; size_t n_args; // Sequence
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_UnionTypeConstructor_t(Allocator &al, const Location &a_loc, symbol_t* a_dt_sym, expr_t** a_args, size_t n_args, ttype_t* a_type, expr_t* a_value) {
        UnionTypeConstructor_t *n;
        n = al.make_new<UnionTypeConstructor_t>();
        n->base.type = exprType::UnionTypeConstructor;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_dt_sym = a_dt_sym;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ImpliedDoLoop_t // Constructor
    {
        const static exprType class_type = exprType::ImpliedDoLoop;
        typedef expr_t parent_type;
        expr_t base;
        expr_t** m_values; size_t n_values; // Sequence
        expr_t* m_var;
        expr_t* m_start;
        expr_t* m_end;
        expr_t* m_increment;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ImpliedDoLoop_t(Allocator &al, const Location &a_loc, expr_t** a_values, size_t n_values, expr_t* a_var, expr_t* a_start, expr_t* a_end, expr_t* a_increment, ttype_t* a_type, expr_t* a_value) {
        ImpliedDoLoop_t *n;
        n = al.make_new<ImpliedDoLoop_t>();
        n->base.type = exprType::ImpliedDoLoop;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_values = a_values;
        n->n_values = n_values;
        n->m_var = a_var;
        n->m_start = a_start;
        n->m_end = a_end;
        n->m_increment = a_increment;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct IntegerConstant_t // Constructor
    {
        const static exprType class_type = exprType::IntegerConstant;
        typedef expr_t parent_type;
        expr_t base;
        int64_t m_n;
        ttype_t* m_type;
    };
    static inline asr_t* make_IntegerConstant_t(Allocator &al, const Location &a_loc, int64_t a_n, ttype_t* a_type) {
        IntegerConstant_t *n;
        n = al.make_new<IntegerConstant_t>();
        n->base.type = exprType::IntegerConstant;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_n = a_n;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct IntegerBOZ_t // Constructor
    {
        const static exprType class_type = exprType::IntegerBOZ;
        typedef expr_t parent_type;
        expr_t base;
        int64_t m_v;
        integerbozType m_intboz_type;
        ttype_t* m_type;
    };
    static inline asr_t* make_IntegerBOZ_t(Allocator &al, const Location &a_loc, int64_t a_v, integerbozType a_intboz_type, ttype_t* a_type) {
        IntegerBOZ_t *n;
        n = al.make_new<IntegerBOZ_t>();
        n->base.type = exprType::IntegerBOZ;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_v = a_v;
        n->m_intboz_type = a_intboz_type;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct IntegerBitNot_t // Constructor
    {
        const static exprType class_type = exprType::IntegerBitNot;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_IntegerBitNot_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        IntegerBitNot_t *n;
        n = al.make_new<IntegerBitNot_t>();
        n->base.type = exprType::IntegerBitNot;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct IntegerUnaryMinus_t // Constructor
    {
        const static exprType class_type = exprType::IntegerUnaryMinus;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_IntegerUnaryMinus_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        IntegerUnaryMinus_t *n;
        n = al.make_new<IntegerUnaryMinus_t>();
        n->base.type = exprType::IntegerUnaryMinus;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct IntegerCompare_t // Constructor
    {
        const static exprType class_type = exprType::IntegerCompare;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        cmpopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_IntegerCompare_t(Allocator &al, const Location &a_loc, expr_t* a_left, cmpopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        IntegerCompare_t *n;
        n = al.make_new<IntegerCompare_t>();
        n->base.type = exprType::IntegerCompare;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct IntegerBinOp_t // Constructor
    {
        const static exprType class_type = exprType::IntegerBinOp;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        binopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_IntegerBinOp_t(Allocator &al, const Location &a_loc, expr_t* a_left, binopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        IntegerBinOp_t *n;
        n = al.make_new<IntegerBinOp_t>();
        n->base.type = exprType::IntegerBinOp;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct UnsignedIntegerConstant_t // Constructor
    {
        const static exprType class_type = exprType::UnsignedIntegerConstant;
        typedef expr_t parent_type;
        expr_t base;
        int64_t m_n;
        ttype_t* m_type;
    };
    static inline asr_t* make_UnsignedIntegerConstant_t(Allocator &al, const Location &a_loc, int64_t a_n, ttype_t* a_type) {
        UnsignedIntegerConstant_t *n;
        n = al.make_new<UnsignedIntegerConstant_t>();
        n->base.type = exprType::UnsignedIntegerConstant;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_n = a_n;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct UnsignedIntegerUnaryMinus_t // Constructor
    {
        const static exprType class_type = exprType::UnsignedIntegerUnaryMinus;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_UnsignedIntegerUnaryMinus_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        UnsignedIntegerUnaryMinus_t *n;
        n = al.make_new<UnsignedIntegerUnaryMinus_t>();
        n->base.type = exprType::UnsignedIntegerUnaryMinus;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct UnsignedIntegerBitNot_t // Constructor
    {
        const static exprType class_type = exprType::UnsignedIntegerBitNot;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_UnsignedIntegerBitNot_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        UnsignedIntegerBitNot_t *n;
        n = al.make_new<UnsignedIntegerBitNot_t>();
        n->base.type = exprType::UnsignedIntegerBitNot;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct UnsignedIntegerCompare_t // Constructor
    {
        const static exprType class_type = exprType::UnsignedIntegerCompare;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        cmpopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_UnsignedIntegerCompare_t(Allocator &al, const Location &a_loc, expr_t* a_left, cmpopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        UnsignedIntegerCompare_t *n;
        n = al.make_new<UnsignedIntegerCompare_t>();
        n->base.type = exprType::UnsignedIntegerCompare;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct UnsignedIntegerBinOp_t // Constructor
    {
        const static exprType class_type = exprType::UnsignedIntegerBinOp;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        binopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_UnsignedIntegerBinOp_t(Allocator &al, const Location &a_loc, expr_t* a_left, binopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        UnsignedIntegerBinOp_t *n;
        n = al.make_new<UnsignedIntegerBinOp_t>();
        n->base.type = exprType::UnsignedIntegerBinOp;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct RealConstant_t // Constructor
    {
        const static exprType class_type = exprType::RealConstant;
        typedef expr_t parent_type;
        expr_t base;
        double m_r;
        ttype_t* m_type;
    };
    static inline asr_t* make_RealConstant_t(Allocator &al, const Location &a_loc, double a_r, ttype_t* a_type) {
        RealConstant_t *n;
        n = al.make_new<RealConstant_t>();
        n->base.type = exprType::RealConstant;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_r = a_r;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct RealUnaryMinus_t // Constructor
    {
        const static exprType class_type = exprType::RealUnaryMinus;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_RealUnaryMinus_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        RealUnaryMinus_t *n;
        n = al.make_new<RealUnaryMinus_t>();
        n->base.type = exprType::RealUnaryMinus;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct RealCompare_t // Constructor
    {
        const static exprType class_type = exprType::RealCompare;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        cmpopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_RealCompare_t(Allocator &al, const Location &a_loc, expr_t* a_left, cmpopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        RealCompare_t *n;
        n = al.make_new<RealCompare_t>();
        n->base.type = exprType::RealCompare;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct RealBinOp_t // Constructor
    {
        const static exprType class_type = exprType::RealBinOp;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        binopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_RealBinOp_t(Allocator &al, const Location &a_loc, expr_t* a_left, binopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        RealBinOp_t *n;
        n = al.make_new<RealBinOp_t>();
        n->base.type = exprType::RealBinOp;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct RealCopySign_t // Constructor
    {
        const static exprType class_type = exprType::RealCopySign;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_target;
        expr_t* m_source;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_RealCopySign_t(Allocator &al, const Location &a_loc, expr_t* a_target, expr_t* a_source, ttype_t* a_type, expr_t* a_value) {
        RealCopySign_t *n;
        n = al.make_new<RealCopySign_t>();
        n->base.type = exprType::RealCopySign;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_target = a_target;
        n->m_source = a_source;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ComplexConstant_t // Constructor
    {
        const static exprType class_type = exprType::ComplexConstant;
        typedef expr_t parent_type;
        expr_t base;
        double m_re;
        double m_im;
        ttype_t* m_type;
    };
    static inline asr_t* make_ComplexConstant_t(Allocator &al, const Location &a_loc, double a_re, double a_im, ttype_t* a_type) {
        ComplexConstant_t *n;
        n = al.make_new<ComplexConstant_t>();
        n->base.type = exprType::ComplexConstant;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_re = a_re;
        n->m_im = a_im;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct ComplexUnaryMinus_t // Constructor
    {
        const static exprType class_type = exprType::ComplexUnaryMinus;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ComplexUnaryMinus_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        ComplexUnaryMinus_t *n;
        n = al.make_new<ComplexUnaryMinus_t>();
        n->base.type = exprType::ComplexUnaryMinus;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ComplexCompare_t // Constructor
    {
        const static exprType class_type = exprType::ComplexCompare;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        cmpopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ComplexCompare_t(Allocator &al, const Location &a_loc, expr_t* a_left, cmpopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        ComplexCompare_t *n;
        n = al.make_new<ComplexCompare_t>();
        n->base.type = exprType::ComplexCompare;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ComplexBinOp_t // Constructor
    {
        const static exprType class_type = exprType::ComplexBinOp;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        binopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ComplexBinOp_t(Allocator &al, const Location &a_loc, expr_t* a_left, binopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        ComplexBinOp_t *n;
        n = al.make_new<ComplexBinOp_t>();
        n->base.type = exprType::ComplexBinOp;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct LogicalConstant_t // Constructor
    {
        const static exprType class_type = exprType::LogicalConstant;
        typedef expr_t parent_type;
        expr_t base;
        bool m_value;
        ttype_t* m_type;
    };
    static inline asr_t* make_LogicalConstant_t(Allocator &al, const Location &a_loc, bool a_value, ttype_t* a_type) {
        LogicalConstant_t *n;
        n = al.make_new<LogicalConstant_t>();
        n->base.type = exprType::LogicalConstant;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_value = a_value;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct LogicalNot_t // Constructor
    {
        const static exprType class_type = exprType::LogicalNot;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_LogicalNot_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        LogicalNot_t *n;
        n = al.make_new<LogicalNot_t>();
        n->base.type = exprType::LogicalNot;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct LogicalCompare_t // Constructor
    {
        const static exprType class_type = exprType::LogicalCompare;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        cmpopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_LogicalCompare_t(Allocator &al, const Location &a_loc, expr_t* a_left, cmpopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        LogicalCompare_t *n;
        n = al.make_new<LogicalCompare_t>();
        n->base.type = exprType::LogicalCompare;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct LogicalBinOp_t // Constructor
    {
        const static exprType class_type = exprType::LogicalBinOp;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        logicalbinopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_LogicalBinOp_t(Allocator &al, const Location &a_loc, expr_t* a_left, logicalbinopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        LogicalBinOp_t *n;
        n = al.make_new<LogicalBinOp_t>();
        n->base.type = exprType::LogicalBinOp;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ListConstant_t // Constructor
    {
        const static exprType class_type = exprType::ListConstant;
        typedef expr_t parent_type;
        expr_t base;
        expr_t** m_args; size_t n_args; // Sequence
        ttype_t* m_type;
    };
    static inline asr_t* make_ListConstant_t(Allocator &al, const Location &a_loc, expr_t** a_args, size_t n_args, ttype_t* a_type) {
        ListConstant_t *n;
        n = al.make_new<ListConstant_t>();
        n->base.type = exprType::ListConstant;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct ListLen_t // Constructor
    {
        const static exprType class_type = exprType::ListLen;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ListLen_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        ListLen_t *n;
        n = al.make_new<ListLen_t>();
        n->base.type = exprType::ListLen;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ListConcat_t // Constructor
    {
        const static exprType class_type = exprType::ListConcat;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ListConcat_t(Allocator &al, const Location &a_loc, expr_t* a_left, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        ListConcat_t *n;
        n = al.make_new<ListConcat_t>();
        n->base.type = exprType::ListConcat;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ListCompare_t // Constructor
    {
        const static exprType class_type = exprType::ListCompare;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        cmpopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ListCompare_t(Allocator &al, const Location &a_loc, expr_t* a_left, cmpopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        ListCompare_t *n;
        n = al.make_new<ListCompare_t>();
        n->base.type = exprType::ListCompare;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ListCount_t // Constructor
    {
        const static exprType class_type = exprType::ListCount;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        expr_t* m_ele;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ListCount_t(Allocator &al, const Location &a_loc, expr_t* a_arg, expr_t* a_ele, ttype_t* a_type, expr_t* a_value) {
        ListCount_t *n;
        n = al.make_new<ListCount_t>();
        n->base.type = exprType::ListCount;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_ele = a_ele;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct SetConstant_t // Constructor
    {
        const static exprType class_type = exprType::SetConstant;
        typedef expr_t parent_type;
        expr_t base;
        expr_t** m_elements; size_t n_elements; // Sequence
        ttype_t* m_type;
    };
    static inline asr_t* make_SetConstant_t(Allocator &al, const Location &a_loc, expr_t** a_elements, size_t n_elements, ttype_t* a_type) {
        SetConstant_t *n;
        n = al.make_new<SetConstant_t>();
        n->base.type = exprType::SetConstant;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_elements = a_elements;
        n->n_elements = n_elements;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct SetLen_t // Constructor
    {
        const static exprType class_type = exprType::SetLen;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_SetLen_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        SetLen_t *n;
        n = al.make_new<SetLen_t>();
        n->base.type = exprType::SetLen;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct TupleConstant_t // Constructor
    {
        const static exprType class_type = exprType::TupleConstant;
        typedef expr_t parent_type;
        expr_t base;
        expr_t** m_elements; size_t n_elements; // Sequence
        ttype_t* m_type;
    };
    static inline asr_t* make_TupleConstant_t(Allocator &al, const Location &a_loc, expr_t** a_elements, size_t n_elements, ttype_t* a_type) {
        TupleConstant_t *n;
        n = al.make_new<TupleConstant_t>();
        n->base.type = exprType::TupleConstant;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_elements = a_elements;
        n->n_elements = n_elements;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct TupleLen_t // Constructor
    {
        const static exprType class_type = exprType::TupleLen;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_TupleLen_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        TupleLen_t *n;
        n = al.make_new<TupleLen_t>();
        n->base.type = exprType::TupleLen;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct TupleCompare_t // Constructor
    {
        const static exprType class_type = exprType::TupleCompare;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        cmpopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_TupleCompare_t(Allocator &al, const Location &a_loc, expr_t* a_left, cmpopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        TupleCompare_t *n;
        n = al.make_new<TupleCompare_t>();
        n->base.type = exprType::TupleCompare;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct TupleConcat_t // Constructor
    {
        const static exprType class_type = exprType::TupleConcat;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_TupleConcat_t(Allocator &al, const Location &a_loc, expr_t* a_left, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        TupleConcat_t *n;
        n = al.make_new<TupleConcat_t>();
        n->base.type = exprType::TupleConcat;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct StringConstant_t // Constructor
    {
        const static exprType class_type = exprType::StringConstant;
        typedef expr_t parent_type;
        expr_t base;
        char* m_s;
        ttype_t* m_type;
    };
    static inline asr_t* make_StringConstant_t(Allocator &al, const Location &a_loc, char* a_s, ttype_t* a_type) {
        StringConstant_t *n;
        n = al.make_new<StringConstant_t>();
        n->base.type = exprType::StringConstant;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_s = a_s;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct StringConcat_t // Constructor
    {
        const static exprType class_type = exprType::StringConcat;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_StringConcat_t(Allocator &al, const Location &a_loc, expr_t* a_left, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        StringConcat_t *n;
        n = al.make_new<StringConcat_t>();
        n->base.type = exprType::StringConcat;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct StringRepeat_t // Constructor
    {
        const static exprType class_type = exprType::StringRepeat;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_StringRepeat_t(Allocator &al, const Location &a_loc, expr_t* a_left, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        StringRepeat_t *n;
        n = al.make_new<StringRepeat_t>();
        n->base.type = exprType::StringRepeat;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct StringLen_t // Constructor
    {
        const static exprType class_type = exprType::StringLen;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_StringLen_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        StringLen_t *n;
        n = al.make_new<StringLen_t>();
        n->base.type = exprType::StringLen;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct StringItem_t // Constructor
    {
        const static exprType class_type = exprType::StringItem;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        expr_t* m_idx;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_StringItem_t(Allocator &al, const Location &a_loc, expr_t* a_arg, expr_t* a_idx, ttype_t* a_type, expr_t* a_value) {
        StringItem_t *n;
        n = al.make_new<StringItem_t>();
        n->base.type = exprType::StringItem;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_idx = a_idx;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct StringSection_t // Constructor
    {
        const static exprType class_type = exprType::StringSection;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        expr_t* m_start;
        expr_t* m_end;
        expr_t* m_step;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_StringSection_t(Allocator &al, const Location &a_loc, expr_t* a_arg, expr_t* a_start, expr_t* a_end, expr_t* a_step, ttype_t* a_type, expr_t* a_value) {
        StringSection_t *n;
        n = al.make_new<StringSection_t>();
        n->base.type = exprType::StringSection;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_start = a_start;
        n->m_end = a_end;
        n->m_step = a_step;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct StringCompare_t // Constructor
    {
        const static exprType class_type = exprType::StringCompare;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        cmpopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_StringCompare_t(Allocator &al, const Location &a_loc, expr_t* a_left, cmpopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        StringCompare_t *n;
        n = al.make_new<StringCompare_t>();
        n->base.type = exprType::StringCompare;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct StringOrd_t // Constructor
    {
        const static exprType class_type = exprType::StringOrd;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_StringOrd_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        StringOrd_t *n;
        n = al.make_new<StringOrd_t>();
        n->base.type = exprType::StringOrd;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct StringChr_t // Constructor
    {
        const static exprType class_type = exprType::StringChr;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_StringChr_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        StringChr_t *n;
        n = al.make_new<StringChr_t>();
        n->base.type = exprType::StringChr;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct StringFormat_t // Constructor
    {
        const static exprType class_type = exprType::StringFormat;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_fmt;
        expr_t** m_args; size_t n_args; // Sequence
        string_format_kindType m_kind;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_StringFormat_t(Allocator &al, const Location &a_loc, expr_t* a_fmt, expr_t** a_args, size_t n_args, string_format_kindType a_kind, ttype_t* a_type, expr_t* a_value) {
        StringFormat_t *n;
        n = al.make_new<StringFormat_t>();
        n->base.type = exprType::StringFormat;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_fmt = a_fmt;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_kind = a_kind;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct CPtrCompare_t // Constructor
    {
        const static exprType class_type = exprType::CPtrCompare;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        cmpopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_CPtrCompare_t(Allocator &al, const Location &a_loc, expr_t* a_left, cmpopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        CPtrCompare_t *n;
        n = al.make_new<CPtrCompare_t>();
        n->base.type = exprType::CPtrCompare;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct SymbolicCompare_t // Constructor
    {
        const static exprType class_type = exprType::SymbolicCompare;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        cmpopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_SymbolicCompare_t(Allocator &al, const Location &a_loc, expr_t* a_left, cmpopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        SymbolicCompare_t *n;
        n = al.make_new<SymbolicCompare_t>();
        n->base.type = exprType::SymbolicCompare;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct DictConstant_t // Constructor
    {
        const static exprType class_type = exprType::DictConstant;
        typedef expr_t parent_type;
        expr_t base;
        expr_t** m_keys; size_t n_keys; // Sequence
        expr_t** m_values; size_t n_values; // Sequence
        ttype_t* m_type;
    };
    static inline asr_t* make_DictConstant_t(Allocator &al, const Location &a_loc, expr_t** a_keys, size_t n_keys, expr_t** a_values, size_t n_values, ttype_t* a_type) {
        DictConstant_t *n;
        n = al.make_new<DictConstant_t>();
        n->base.type = exprType::DictConstant;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_keys = a_keys;
        n->n_keys = n_keys;
        n->m_values = a_values;
        n->n_values = n_values;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct DictLen_t // Constructor
    {
        const static exprType class_type = exprType::DictLen;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_DictLen_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        DictLen_t *n;
        n = al.make_new<DictLen_t>();
        n->base.type = exprType::DictLen;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct Var_t // Constructor
    {
        const static exprType class_type = exprType::Var;
        typedef expr_t parent_type;
        expr_t base;
        symbol_t* m_v;
    };
    static inline asr_t* make_Var_t(Allocator &al, const Location &a_loc, symbol_t* a_v) {
        Var_t *n;
        n = al.make_new<Var_t>();
        n->base.type = exprType::Var;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_v = a_v;
        return (asr_t*)n;
    }

    struct FunctionParam_t // Constructor
    {
        const static exprType class_type = exprType::FunctionParam;
        typedef expr_t parent_type;
        expr_t base;
        int64_t m_param_number;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_FunctionParam_t(Allocator &al, const Location &a_loc, int64_t a_param_number, ttype_t* a_type, expr_t* a_value) {
        FunctionParam_t *n;
        n = al.make_new<FunctionParam_t>();
        n->base.type = exprType::FunctionParam;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_param_number = a_param_number;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ArrayConstructor_t // Constructor
    {
        const static exprType class_type = exprType::ArrayConstructor;
        typedef expr_t parent_type;
        expr_t base;
        expr_t** m_args; size_t n_args; // Sequence
        ttype_t* m_type;
        expr_t* m_value;
        arraystorageType m_storage_format;
    };
    static inline asr_t* make_ArrayConstructor_t(Allocator &al, const Location &a_loc, expr_t** a_args, size_t n_args, ttype_t* a_type, expr_t* a_value, arraystorageType a_storage_format) {
        ArrayConstructor_t *n;
        n = al.make_new<ArrayConstructor_t>();
        n->base.type = exprType::ArrayConstructor;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_type = a_type;
        n->m_value = a_value;
        n->m_storage_format = a_storage_format;
        return (asr_t*)n;
    }

    struct ArrayConstant_t // Constructor
    {
        const static exprType class_type = exprType::ArrayConstant;
        typedef expr_t parent_type;
        expr_t base;
        int64_t m_n_data;
        void * m_data;
        ttype_t* m_type;
        arraystorageType m_storage_format;
    };
    static inline asr_t* make_ArrayConstant_t(Allocator &al, const Location &a_loc, int64_t a_n_data, void * a_data, ttype_t* a_type, arraystorageType a_storage_format) {
        ArrayConstant_t *n;
        n = al.make_new<ArrayConstant_t>();
        n->base.type = exprType::ArrayConstant;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_n_data = a_n_data;
        n->m_data = a_data;
        n->m_type = a_type;
        n->m_storage_format = a_storage_format;
        return (asr_t*)n;
    }

    struct ArrayItem_t // Constructor
    {
        const static exprType class_type = exprType::ArrayItem;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_v;
        array_index_t* m_args; size_t n_args; // Sequence
        ttype_t* m_type;
        arraystorageType m_storage_format;
        expr_t* m_value;
    };
    static inline asr_t* make_ArrayItem_t(Allocator &al, const Location &a_loc, expr_t* a_v, array_index_t* a_args, size_t n_args, ttype_t* a_type, arraystorageType a_storage_format, expr_t* a_value) {
        ArrayItem_t *n;
        n = al.make_new<ArrayItem_t>();
        n->base.type = exprType::ArrayItem;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_v = a_v;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_type = a_type;
        n->m_storage_format = a_storage_format;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ArraySection_t // Constructor
    {
        const static exprType class_type = exprType::ArraySection;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_v;
        array_index_t* m_args; size_t n_args; // Sequence
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ArraySection_t(Allocator &al, const Location &a_loc, expr_t* a_v, array_index_t* a_args, size_t n_args, ttype_t* a_type, expr_t* a_value) {
        ArraySection_t *n;
        n = al.make_new<ArraySection_t>();
        n->base.type = exprType::ArraySection;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_v = a_v;
        n->m_args = a_args;
        n->n_args = n_args;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ArraySize_t // Constructor
    {
        const static exprType class_type = exprType::ArraySize;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_v;
        expr_t* m_dim;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ArraySize_t(Allocator &al, const Location &a_loc, expr_t* a_v, expr_t* a_dim, ttype_t* a_type, expr_t* a_value) {
        ArraySize_t *n;
        n = al.make_new<ArraySize_t>();
        n->base.type = exprType::ArraySize;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_v = a_v;
        n->m_dim = a_dim;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ArrayBound_t // Constructor
    {
        const static exprType class_type = exprType::ArrayBound;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_v;
        expr_t* m_dim;
        ttype_t* m_type;
        arrayboundType m_bound;
        expr_t* m_value;
    };
    static inline asr_t* make_ArrayBound_t(Allocator &al, const Location &a_loc, expr_t* a_v, expr_t* a_dim, ttype_t* a_type, arrayboundType a_bound, expr_t* a_value) {
        ArrayBound_t *n;
        n = al.make_new<ArrayBound_t>();
        n->base.type = exprType::ArrayBound;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_v = a_v;
        n->m_dim = a_dim;
        n->m_type = a_type;
        n->m_bound = a_bound;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ArrayTranspose_t // Constructor
    {
        const static exprType class_type = exprType::ArrayTranspose;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_matrix;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ArrayTranspose_t(Allocator &al, const Location &a_loc, expr_t* a_matrix, ttype_t* a_type, expr_t* a_value) {
        ArrayTranspose_t *n;
        n = al.make_new<ArrayTranspose_t>();
        n->base.type = exprType::ArrayTranspose;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_matrix = a_matrix;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ArrayPack_t // Constructor
    {
        const static exprType class_type = exprType::ArrayPack;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_array;
        expr_t* m_mask;
        expr_t* m_vector;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ArrayPack_t(Allocator &al, const Location &a_loc, expr_t* a_array, expr_t* a_mask, expr_t* a_vector, ttype_t* a_type, expr_t* a_value) {
        ArrayPack_t *n;
        n = al.make_new<ArrayPack_t>();
        n->base.type = exprType::ArrayPack;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_array = a_array;
        n->m_mask = a_mask;
        n->m_vector = a_vector;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ArrayReshape_t // Constructor
    {
        const static exprType class_type = exprType::ArrayReshape;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_array;
        expr_t* m_shape;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ArrayReshape_t(Allocator &al, const Location &a_loc, expr_t* a_array, expr_t* a_shape, ttype_t* a_type, expr_t* a_value) {
        ArrayReshape_t *n;
        n = al.make_new<ArrayReshape_t>();
        n->base.type = exprType::ArrayReshape;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_array = a_array;
        n->m_shape = a_shape;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ArrayBroadcast_t // Constructor
    {
        const static exprType class_type = exprType::ArrayBroadcast;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_array;
        expr_t* m_shape;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ArrayBroadcast_t(Allocator &al, const Location &a_loc, expr_t* a_array, expr_t* a_shape, ttype_t* a_type, expr_t* a_value) {
        ArrayBroadcast_t *n;
        n = al.make_new<ArrayBroadcast_t>();
        n->base.type = exprType::ArrayBroadcast;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_array = a_array;
        n->m_shape = a_shape;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct BitCast_t // Constructor
    {
        const static exprType class_type = exprType::BitCast;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_source;
        expr_t* m_mold;
        expr_t* m_size;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_BitCast_t(Allocator &al, const Location &a_loc, expr_t* a_source, expr_t* a_mold, expr_t* a_size, ttype_t* a_type, expr_t* a_value) {
        BitCast_t *n;
        n = al.make_new<BitCast_t>();
        n->base.type = exprType::BitCast;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_source = a_source;
        n->m_mold = a_mold;
        n->m_size = a_size;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct StructInstanceMember_t // Constructor
    {
        const static exprType class_type = exprType::StructInstanceMember;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_v;
        symbol_t* m_m;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_StructInstanceMember_t(Allocator &al, const Location &a_loc, expr_t* a_v, symbol_t* a_m, ttype_t* a_type, expr_t* a_value) {
        StructInstanceMember_t *n;
        n = al.make_new<StructInstanceMember_t>();
        n->base.type = exprType::StructInstanceMember;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_v = a_v;
        n->m_m = a_m;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct StructStaticMember_t // Constructor
    {
        const static exprType class_type = exprType::StructStaticMember;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_v;
        symbol_t* m_m;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_StructStaticMember_t(Allocator &al, const Location &a_loc, expr_t* a_v, symbol_t* a_m, ttype_t* a_type, expr_t* a_value) {
        StructStaticMember_t *n;
        n = al.make_new<StructStaticMember_t>();
        n->base.type = exprType::StructStaticMember;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_v = a_v;
        n->m_m = a_m;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct EnumStaticMember_t // Constructor
    {
        const static exprType class_type = exprType::EnumStaticMember;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_v;
        symbol_t* m_m;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_EnumStaticMember_t(Allocator &al, const Location &a_loc, expr_t* a_v, symbol_t* a_m, ttype_t* a_type, expr_t* a_value) {
        EnumStaticMember_t *n;
        n = al.make_new<EnumStaticMember_t>();
        n->base.type = exprType::EnumStaticMember;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_v = a_v;
        n->m_m = a_m;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct UnionInstanceMember_t // Constructor
    {
        const static exprType class_type = exprType::UnionInstanceMember;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_v;
        symbol_t* m_m;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_UnionInstanceMember_t(Allocator &al, const Location &a_loc, expr_t* a_v, symbol_t* a_m, ttype_t* a_type, expr_t* a_value) {
        UnionInstanceMember_t *n;
        n = al.make_new<UnionInstanceMember_t>();
        n->base.type = exprType::UnionInstanceMember;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_v = a_v;
        n->m_m = a_m;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct EnumName_t // Constructor
    {
        const static exprType class_type = exprType::EnumName;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_v;
        ttype_t* m_enum_type;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_EnumName_t(Allocator &al, const Location &a_loc, expr_t* a_v, ttype_t* a_enum_type, ttype_t* a_type, expr_t* a_value) {
        EnumName_t *n;
        n = al.make_new<EnumName_t>();
        n->base.type = exprType::EnumName;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_v = a_v;
        n->m_enum_type = a_enum_type;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct EnumValue_t // Constructor
    {
        const static exprType class_type = exprType::EnumValue;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_v;
        ttype_t* m_enum_type;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_EnumValue_t(Allocator &al, const Location &a_loc, expr_t* a_v, ttype_t* a_enum_type, ttype_t* a_type, expr_t* a_value) {
        EnumValue_t *n;
        n = al.make_new<EnumValue_t>();
        n->base.type = exprType::EnumValue;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_v = a_v;
        n->m_enum_type = a_enum_type;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct OverloadedCompare_t // Constructor
    {
        const static exprType class_type = exprType::OverloadedCompare;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        cmpopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
        expr_t* m_overloaded;
    };
    static inline asr_t* make_OverloadedCompare_t(Allocator &al, const Location &a_loc, expr_t* a_left, cmpopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value, expr_t* a_overloaded) {
        OverloadedCompare_t *n;
        n = al.make_new<OverloadedCompare_t>();
        n->base.type = exprType::OverloadedCompare;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        n->m_overloaded = a_overloaded;
        return (asr_t*)n;
    }

    struct OverloadedBinOp_t // Constructor
    {
        const static exprType class_type = exprType::OverloadedBinOp;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        binopType m_op;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
        expr_t* m_overloaded;
    };
    static inline asr_t* make_OverloadedBinOp_t(Allocator &al, const Location &a_loc, expr_t* a_left, binopType a_op, expr_t* a_right, ttype_t* a_type, expr_t* a_value, expr_t* a_overloaded) {
        OverloadedBinOp_t *n;
        n = al.make_new<OverloadedBinOp_t>();
        n->base.type = exprType::OverloadedBinOp;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_op = a_op;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        n->m_overloaded = a_overloaded;
        return (asr_t*)n;
    }

    struct OverloadedUnaryMinus_t // Constructor
    {
        const static exprType class_type = exprType::OverloadedUnaryMinus;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
        expr_t* m_overloaded;
    };
    static inline asr_t* make_OverloadedUnaryMinus_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value, expr_t* a_overloaded) {
        OverloadedUnaryMinus_t *n;
        n = al.make_new<OverloadedUnaryMinus_t>();
        n->base.type = exprType::OverloadedUnaryMinus;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        n->m_overloaded = a_overloaded;
        return (asr_t*)n;
    }

    struct OverloadedStringConcat_t // Constructor
    {
        const static exprType class_type = exprType::OverloadedStringConcat;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
        expr_t* m_overloaded;
    };
    static inline asr_t* make_OverloadedStringConcat_t(Allocator &al, const Location &a_loc, expr_t* a_left, expr_t* a_right, ttype_t* a_type, expr_t* a_value, expr_t* a_overloaded) {
        OverloadedStringConcat_t *n;
        n = al.make_new<OverloadedStringConcat_t>();
        n->base.type = exprType::OverloadedStringConcat;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        n->m_overloaded = a_overloaded;
        return (asr_t*)n;
    }

    struct Cast_t // Constructor
    {
        const static exprType class_type = exprType::Cast;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        cast_kindType m_kind;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_Cast_t(Allocator &al, const Location &a_loc, expr_t* a_arg, cast_kindType a_kind, ttype_t* a_type, expr_t* a_value) {
        Cast_t *n;
        n = al.make_new<Cast_t>();
        n->base.type = exprType::Cast;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_kind = a_kind;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ArrayPhysicalCast_t // Constructor
    {
        const static exprType class_type = exprType::ArrayPhysicalCast;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        array_physical_typeType m_old;
        array_physical_typeType m_new;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ArrayPhysicalCast_t(Allocator &al, const Location &a_loc, expr_t* a_arg, array_physical_typeType a_old, array_physical_typeType a_new, ttype_t* a_type, expr_t* a_value) {
        ArrayPhysicalCast_t *n;
        n = al.make_new<ArrayPhysicalCast_t>();
        n->base.type = exprType::ArrayPhysicalCast;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_old = a_old;
        n->m_new = a_new;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ComplexRe_t // Constructor
    {
        const static exprType class_type = exprType::ComplexRe;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ComplexRe_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        ComplexRe_t *n;
        n = al.make_new<ComplexRe_t>();
        n->base.type = exprType::ComplexRe;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ComplexIm_t // Constructor
    {
        const static exprType class_type = exprType::ComplexIm;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ComplexIm_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        ComplexIm_t *n;
        n = al.make_new<ComplexIm_t>();
        n->base.type = exprType::ComplexIm;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct DictItem_t // Constructor
    {
        const static exprType class_type = exprType::DictItem;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_a;
        expr_t* m_key;
        expr_t* m_default;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_DictItem_t(Allocator &al, const Location &a_loc, expr_t* a_a, expr_t* a_key, expr_t* a_default, ttype_t* a_type, expr_t* a_value) {
        DictItem_t *n;
        n = al.make_new<DictItem_t>();
        n->base.type = exprType::DictItem;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_a = a_a;
        n->m_key = a_key;
        n->m_default = a_default;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct CLoc_t // Constructor
    {
        const static exprType class_type = exprType::CLoc;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_CLoc_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        CLoc_t *n;
        n = al.make_new<CLoc_t>();
        n->base.type = exprType::CLoc;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct PointerToCPtr_t // Constructor
    {
        const static exprType class_type = exprType::PointerToCPtr;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_PointerToCPtr_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        PointerToCPtr_t *n;
        n = al.make_new<PointerToCPtr_t>();
        n->base.type = exprType::PointerToCPtr;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct GetPointer_t // Constructor
    {
        const static exprType class_type = exprType::GetPointer;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_GetPointer_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        GetPointer_t *n;
        n = al.make_new<GetPointer_t>();
        n->base.type = exprType::GetPointer;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ListItem_t // Constructor
    {
        const static exprType class_type = exprType::ListItem;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_a;
        expr_t* m_pos;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ListItem_t(Allocator &al, const Location &a_loc, expr_t* a_a, expr_t* a_pos, ttype_t* a_type, expr_t* a_value) {
        ListItem_t *n;
        n = al.make_new<ListItem_t>();
        n->base.type = exprType::ListItem;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_a = a_a;
        n->m_pos = a_pos;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct TupleItem_t // Constructor
    {
        const static exprType class_type = exprType::TupleItem;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_a;
        expr_t* m_pos;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_TupleItem_t(Allocator &al, const Location &a_loc, expr_t* a_a, expr_t* a_pos, ttype_t* a_type, expr_t* a_value) {
        TupleItem_t *n;
        n = al.make_new<TupleItem_t>();
        n->base.type = exprType::TupleItem;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_a = a_a;
        n->m_pos = a_pos;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ListSection_t // Constructor
    {
        const static exprType class_type = exprType::ListSection;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_a;
        array_index_t m_section;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ListSection_t(Allocator &al, const Location &a_loc, expr_t* a_a, array_index_t a_section, ttype_t* a_type, expr_t* a_value) {
        ListSection_t *n;
        n = al.make_new<ListSection_t>();
        n->base.type = exprType::ListSection;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_a = a_a;
        n->m_section = a_section;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct ListRepeat_t // Constructor
    {
        const static exprType class_type = exprType::ListRepeat;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_left;
        expr_t* m_right;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_ListRepeat_t(Allocator &al, const Location &a_loc, expr_t* a_left, expr_t* a_right, ttype_t* a_type, expr_t* a_value) {
        ListRepeat_t *n;
        n = al.make_new<ListRepeat_t>();
        n->base.type = exprType::ListRepeat;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_left = a_left;
        n->m_right = a_right;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct DictPop_t // Constructor
    {
        const static exprType class_type = exprType::DictPop;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_a;
        expr_t* m_key;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_DictPop_t(Allocator &al, const Location &a_loc, expr_t* a_a, expr_t* a_key, ttype_t* a_type, expr_t* a_value) {
        DictPop_t *n;
        n = al.make_new<DictPop_t>();
        n->base.type = exprType::DictPop;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_a = a_a;
        n->m_key = a_key;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct SetPop_t // Constructor
    {
        const static exprType class_type = exprType::SetPop;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_a;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_SetPop_t(Allocator &al, const Location &a_loc, expr_t* a_a, ttype_t* a_type, expr_t* a_value) {
        SetPop_t *n;
        n = al.make_new<SetPop_t>();
        n->base.type = exprType::SetPop;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_a = a_a;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct IntegerBitLen_t // Constructor
    {
        const static exprType class_type = exprType::IntegerBitLen;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_a;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_IntegerBitLen_t(Allocator &al, const Location &a_loc, expr_t* a_a, ttype_t* a_type, expr_t* a_value) {
        IntegerBitLen_t *n;
        n = al.make_new<IntegerBitLen_t>();
        n->base.type = exprType::IntegerBitLen;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_a = a_a;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct Ichar_t // Constructor
    {
        const static exprType class_type = exprType::Ichar;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_Ichar_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        Ichar_t *n;
        n = al.make_new<Ichar_t>();
        n->base.type = exprType::Ichar;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct Iachar_t // Constructor
    {
        const static exprType class_type = exprType::Iachar;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_Iachar_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        Iachar_t *n;
        n = al.make_new<Iachar_t>();
        n->base.type = exprType::Iachar;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct SizeOfType_t // Constructor
    {
        const static exprType class_type = exprType::SizeOfType;
        typedef expr_t parent_type;
        expr_t base;
        ttype_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_SizeOfType_t(Allocator &al, const Location &a_loc, ttype_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        SizeOfType_t *n;
        n = al.make_new<SizeOfType_t>();
        n->base.type = exprType::SizeOfType;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct PointerNullConstant_t // Constructor
    {
        const static exprType class_type = exprType::PointerNullConstant;
        typedef expr_t parent_type;
        expr_t base;
        ttype_t* m_type;
    };
    static inline asr_t* make_PointerNullConstant_t(Allocator &al, const Location &a_loc, ttype_t* a_type) {
        PointerNullConstant_t *n;
        n = al.make_new<PointerNullConstant_t>();
        n->base.type = exprType::PointerNullConstant;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct PointerAssociated_t // Constructor
    {
        const static exprType class_type = exprType::PointerAssociated;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_ptr;
        expr_t* m_tgt;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_PointerAssociated_t(Allocator &al, const Location &a_loc, expr_t* a_ptr, expr_t* a_tgt, ttype_t* a_type, expr_t* a_value) {
        PointerAssociated_t *n;
        n = al.make_new<PointerAssociated_t>();
        n->base.type = exprType::PointerAssociated;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_ptr = a_ptr;
        n->m_tgt = a_tgt;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }

    struct RealSqrt_t // Constructor
    {
        const static exprType class_type = exprType::RealSqrt;
        typedef expr_t parent_type;
        expr_t base;
        expr_t* m_arg;
        ttype_t* m_type;
        expr_t* m_value;
    };
    static inline asr_t* make_RealSqrt_t(Allocator &al, const Location &a_loc, expr_t* a_arg, ttype_t* a_type, expr_t* a_value) {
        RealSqrt_t *n;
        n = al.make_new<RealSqrt_t>();
        n->base.type = exprType::RealSqrt;
        n->base.base.type = asrType::expr;
        n->base.base.loc = a_loc;
        n->m_arg = a_arg;
        n->m_type = a_type;
        n->m_value = a_value;
        return (asr_t*)n;
    }



enum ttypeType // Types
{
    Integer, UnsignedInteger, Real, Complex, Character, Logical, Set, List, Tuple, Struct, Enum, Union, Class, Dict, Pointer, Allocatable, CPtr, SymbolicExpression, TypeParameter, Array, FunctionType
};

struct ttype_t // Sum
{
    const static asrType class_type = asrType::ttype;
    asr_t base;
    ttypeType type;
};

    struct Integer_t // Constructor
    {
        const static ttypeType class_type = ttypeType::Integer;
        typedef ttype_t parent_type;
        ttype_t base;
        int64_t m_kind;
    };
    static inline asr_t* make_Integer_t(Allocator &al, const Location &a_loc, int64_t a_kind) {
        Integer_t *n;
        n = al.make_new<Integer_t>();
        n->base.type = ttypeType::Integer;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_kind = a_kind;
        return (asr_t*)n;
    }

    struct UnsignedInteger_t // Constructor
    {
        const static ttypeType class_type = ttypeType::UnsignedInteger;
        typedef ttype_t parent_type;
        ttype_t base;
        int64_t m_kind;
    };
    static inline asr_t* make_UnsignedInteger_t(Allocator &al, const Location &a_loc, int64_t a_kind) {
        UnsignedInteger_t *n;
        n = al.make_new<UnsignedInteger_t>();
        n->base.type = ttypeType::UnsignedInteger;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_kind = a_kind;
        return (asr_t*)n;
    }

    struct Real_t // Constructor
    {
        const static ttypeType class_type = ttypeType::Real;
        typedef ttype_t parent_type;
        ttype_t base;
        int64_t m_kind;
    };
    static inline asr_t* make_Real_t(Allocator &al, const Location &a_loc, int64_t a_kind) {
        Real_t *n;
        n = al.make_new<Real_t>();
        n->base.type = ttypeType::Real;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_kind = a_kind;
        return (asr_t*)n;
    }

    struct Complex_t // Constructor
    {
        const static ttypeType class_type = ttypeType::Complex;
        typedef ttype_t parent_type;
        ttype_t base;
        int64_t m_kind;
    };
    static inline asr_t* make_Complex_t(Allocator &al, const Location &a_loc, int64_t a_kind) {
        Complex_t *n;
        n = al.make_new<Complex_t>();
        n->base.type = ttypeType::Complex;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_kind = a_kind;
        return (asr_t*)n;
    }

    struct Character_t // Constructor
    {
        const static ttypeType class_type = ttypeType::Character;
        typedef ttype_t parent_type;
        ttype_t base;
        int64_t m_kind;
        int64_t m_len;
        expr_t* m_len_expr;
    };
    static inline asr_t* make_Character_t(Allocator &al, const Location &a_loc, int64_t a_kind, int64_t a_len, expr_t* a_len_expr) {
        Character_t *n;
        n = al.make_new<Character_t>();
        n->base.type = ttypeType::Character;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_kind = a_kind;
        n->m_len = a_len;
        n->m_len_expr = a_len_expr;
        return (asr_t*)n;
    }

    struct Logical_t // Constructor
    {
        const static ttypeType class_type = ttypeType::Logical;
        typedef ttype_t parent_type;
        ttype_t base;
        int64_t m_kind;
    };
    static inline asr_t* make_Logical_t(Allocator &al, const Location &a_loc, int64_t a_kind) {
        Logical_t *n;
        n = al.make_new<Logical_t>();
        n->base.type = ttypeType::Logical;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_kind = a_kind;
        return (asr_t*)n;
    }

    struct Set_t // Constructor
    {
        const static ttypeType class_type = ttypeType::Set;
        typedef ttype_t parent_type;
        ttype_t base;
        ttype_t* m_type;
    };
    static inline asr_t* make_Set_t(Allocator &al, const Location &a_loc, ttype_t* a_type) {
        Set_t *n;
        n = al.make_new<Set_t>();
        n->base.type = ttypeType::Set;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct List_t // Constructor
    {
        const static ttypeType class_type = ttypeType::List;
        typedef ttype_t parent_type;
        ttype_t base;
        ttype_t* m_type;
    };
    static inline asr_t* make_List_t(Allocator &al, const Location &a_loc, ttype_t* a_type) {
        List_t *n;
        n = al.make_new<List_t>();
        n->base.type = ttypeType::List;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct Tuple_t // Constructor
    {
        const static ttypeType class_type = ttypeType::Tuple;
        typedef ttype_t parent_type;
        ttype_t base;
        ttype_t** m_type; size_t n_type; // Sequence
    };
    static inline asr_t* make_Tuple_t(Allocator &al, const Location &a_loc, ttype_t** a_type, size_t n_type) {
        Tuple_t *n;
        n = al.make_new<Tuple_t>();
        n->base.type = ttypeType::Tuple;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_type = a_type;
        n->n_type = n_type;
        return (asr_t*)n;
    }

    struct Struct_t // Constructor
    {
        const static ttypeType class_type = ttypeType::Struct;
        typedef ttype_t parent_type;
        ttype_t base;
        symbol_t* m_derived_type;
    };
    static inline asr_t* make_Struct_t(Allocator &al, const Location &a_loc, symbol_t* a_derived_type) {
        Struct_t *n;
        n = al.make_new<Struct_t>();
        n->base.type = ttypeType::Struct;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_derived_type = a_derived_type;
        return (asr_t*)n;
    }

    struct Enum_t // Constructor
    {
        const static ttypeType class_type = ttypeType::Enum;
        typedef ttype_t parent_type;
        ttype_t base;
        symbol_t* m_enum_type;
    };
    static inline asr_t* make_Enum_t(Allocator &al, const Location &a_loc, symbol_t* a_enum_type) {
        Enum_t *n;
        n = al.make_new<Enum_t>();
        n->base.type = ttypeType::Enum;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_enum_type = a_enum_type;
        return (asr_t*)n;
    }

    struct Union_t // Constructor
    {
        const static ttypeType class_type = ttypeType::Union;
        typedef ttype_t parent_type;
        ttype_t base;
        symbol_t* m_union_type;
    };
    static inline asr_t* make_Union_t(Allocator &al, const Location &a_loc, symbol_t* a_union_type) {
        Union_t *n;
        n = al.make_new<Union_t>();
        n->base.type = ttypeType::Union;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_union_type = a_union_type;
        return (asr_t*)n;
    }

    struct Class_t // Constructor
    {
        const static ttypeType class_type = ttypeType::Class;
        typedef ttype_t parent_type;
        ttype_t base;
        symbol_t* m_class_type;
    };
    static inline asr_t* make_Class_t(Allocator &al, const Location &a_loc, symbol_t* a_class_type) {
        Class_t *n;
        n = al.make_new<Class_t>();
        n->base.type = ttypeType::Class;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_class_type = a_class_type;
        return (asr_t*)n;
    }

    struct Dict_t // Constructor
    {
        const static ttypeType class_type = ttypeType::Dict;
        typedef ttype_t parent_type;
        ttype_t base;
        ttype_t* m_key_type;
        ttype_t* m_value_type;
    };
    static inline asr_t* make_Dict_t(Allocator &al, const Location &a_loc, ttype_t* a_key_type, ttype_t* a_value_type) {
        Dict_t *n;
        n = al.make_new<Dict_t>();
        n->base.type = ttypeType::Dict;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_key_type = a_key_type;
        n->m_value_type = a_value_type;
        return (asr_t*)n;
    }

    struct Pointer_t // Constructor
    {
        const static ttypeType class_type = ttypeType::Pointer;
        typedef ttype_t parent_type;
        ttype_t base;
        ttype_t* m_type;
    };
    static inline asr_t* make_Pointer_t(Allocator &al, const Location &a_loc, ttype_t* a_type) {
        Pointer_t *n;
        n = al.make_new<Pointer_t>();
        n->base.type = ttypeType::Pointer;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct Allocatable_t // Constructor
    {
        const static ttypeType class_type = ttypeType::Allocatable;
        typedef ttype_t parent_type;
        ttype_t base;
        ttype_t* m_type;
    };
    static inline asr_t* make_Allocatable_t(Allocator &al, const Location &a_loc, ttype_t* a_type) {
        Allocatable_t *n;
        n = al.make_new<Allocatable_t>();
        n->base.type = ttypeType::Allocatable;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_type = a_type;
        return (asr_t*)n;
    }

    struct CPtr_t // Constructor
    {
        const static ttypeType class_type = ttypeType::CPtr;
        typedef ttype_t parent_type;
        ttype_t base;
    };
    static inline asr_t* make_CPtr_t(Allocator &al, const Location &a_loc) {
        CPtr_t *n;
        n = al.make_new<CPtr_t>();
        n->base.type = ttypeType::CPtr;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        return (asr_t*)n;
    }

    struct SymbolicExpression_t // Constructor
    {
        const static ttypeType class_type = ttypeType::SymbolicExpression;
        typedef ttype_t parent_type;
        ttype_t base;
    };
    static inline asr_t* make_SymbolicExpression_t(Allocator &al, const Location &a_loc) {
        SymbolicExpression_t *n;
        n = al.make_new<SymbolicExpression_t>();
        n->base.type = ttypeType::SymbolicExpression;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        return (asr_t*)n;
    }

    struct TypeParameter_t // Constructor
    {
        const static ttypeType class_type = ttypeType::TypeParameter;
        typedef ttype_t parent_type;
        ttype_t base;
        char* m_param;
    };
    static inline asr_t* make_TypeParameter_t(Allocator &al, const Location &a_loc, char* a_param) {
        TypeParameter_t *n;
        n = al.make_new<TypeParameter_t>();
        n->base.type = ttypeType::TypeParameter;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_param = a_param;
        return (asr_t*)n;
    }

    struct Array_t // Constructor
    {
        const static ttypeType class_type = ttypeType::Array;
        typedef ttype_t parent_type;
        ttype_t base;
        ttype_t* m_type;
        dimension_t* m_dims; size_t n_dims; // Sequence
        array_physical_typeType m_physical_type;
    };
    static inline asr_t* make_Array_t(Allocator &al, const Location &a_loc, ttype_t* a_type, dimension_t* a_dims, size_t n_dims, array_physical_typeType a_physical_type) {
        Array_t *n;
        n = al.make_new<Array_t>();
        n->base.type = ttypeType::Array;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_type = a_type;
        n->m_dims = a_dims;
        n->n_dims = n_dims;
        n->m_physical_type = a_physical_type;
        return (asr_t*)n;
    }

    struct FunctionType_t // Constructor
    {
        const static ttypeType class_type = ttypeType::FunctionType;
        typedef ttype_t parent_type;
        ttype_t base;
        ttype_t** m_arg_types; size_t n_arg_types; // Sequence
        ttype_t* m_return_var_type;
        abiType m_abi;
        deftypeType m_deftype;
        char* m_bindc_name;
        bool m_elemental;
        bool m_pure;
        bool m_module;
        bool m_inline;
        bool m_static;
        symbol_t** m_restrictions; size_t n_restrictions; // Sequence
        bool m_is_restriction;
    };
    static inline asr_t* make_FunctionType_t(Allocator &al, const Location &a_loc, ttype_t** a_arg_types, size_t n_arg_types, ttype_t* a_return_var_type, abiType a_abi, deftypeType a_deftype, char* a_bindc_name, bool a_elemental, bool a_pure, bool a_module, bool a_inline, bool a_static, symbol_t** a_restrictions, size_t n_restrictions, bool a_is_restriction) {
        FunctionType_t *n;
        n = al.make_new<FunctionType_t>();
        n->base.type = ttypeType::FunctionType;
        n->base.base.type = asrType::ttype;
        n->base.base.loc = a_loc;
        n->m_arg_types = a_arg_types;
        n->n_arg_types = n_arg_types;
        n->m_return_var_type = a_return_var_type;
        n->m_abi = a_abi;
        n->m_deftype = a_deftype;
        n->m_bindc_name = a_bindc_name;
        n->m_elemental = a_elemental;
        n->m_pure = a_pure;
        n->m_module = a_module;
        n->m_inline = a_inline;
        n->m_static = a_static;
        n->m_restrictions = a_restrictions;
        n->n_restrictions = n_restrictions;
        n->m_is_restriction = a_is_restriction;
        return (asr_t*)n;
    }



enum attributeType // Types
{
    Attribute
};

struct attribute_t // Sum
{
    const static asrType class_type = asrType::attribute;
    asr_t base;
    attributeType type;
};

    struct Attribute_t // Constructor
    {
        const static attributeType class_type = attributeType::Attribute;
        typedef attribute_t parent_type;
        attribute_t base;
        char* m_name;
        attribute_arg_t* m_args; size_t n_args; // Sequence
    };
    static inline asr_t* make_Attribute_t(Allocator &al, const Location &a_loc, char* a_name, attribute_arg_t* a_args, size_t n_args) {
        Attribute_t *n;
        n = al.make_new<Attribute_t>();
        n->base.type = attributeType::Attribute;
        n->base.base.type = asrType::attribute;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_args = a_args;
        n->n_args = n_args;
        return (asr_t*)n;
    }



enum tbindType // Types
{
    Bind
};

struct tbind_t // Sum
{
    const static asrType class_type = asrType::tbind;
    asr_t base;
    tbindType type;
};

    struct Bind_t // Constructor
    {
        const static tbindType class_type = tbindType::Bind;
        typedef tbind_t parent_type;
        tbind_t base;
        char* m_lang;
        char* m_name;
    };
    static inline asr_t* make_Bind_t(Allocator &al, const Location &a_loc, char* a_lang, char* a_name) {
        Bind_t *n;
        n = al.make_new<Bind_t>();
        n->base.type = tbindType::Bind;
        n->base.base.type = asrType::tbind;
        n->base.base.loc = a_loc;
        n->m_lang = a_lang;
        n->m_name = a_name;
        return (asr_t*)n;
    }



enum case_stmtType // Types
{
    CaseStmt, CaseStmt_Range
};

struct case_stmt_t // Sum
{
    const static asrType class_type = asrType::case_stmt;
    asr_t base;
    case_stmtType type;
};

    struct CaseStmt_t // Constructor
    {
        const static case_stmtType class_type = case_stmtType::CaseStmt;
        typedef case_stmt_t parent_type;
        case_stmt_t base;
        expr_t** m_test; size_t n_test; // Sequence
        stmt_t** m_body; size_t n_body; // Sequence
        bool m_fall_through;
    };
    static inline asr_t* make_CaseStmt_t(Allocator &al, const Location &a_loc, expr_t** a_test, size_t n_test, stmt_t** a_body, size_t n_body, bool a_fall_through) {
        CaseStmt_t *n;
        n = al.make_new<CaseStmt_t>();
        n->base.type = case_stmtType::CaseStmt;
        n->base.base.type = asrType::case_stmt;
        n->base.base.loc = a_loc;
        n->m_test = a_test;
        n->n_test = n_test;
        n->m_body = a_body;
        n->n_body = n_body;
        n->m_fall_through = a_fall_through;
        return (asr_t*)n;
    }

    struct CaseStmt_Range_t // Constructor
    {
        const static case_stmtType class_type = case_stmtType::CaseStmt_Range;
        typedef case_stmt_t parent_type;
        case_stmt_t base;
        expr_t* m_start;
        expr_t* m_end;
        stmt_t** m_body; size_t n_body; // Sequence
    };
    static inline asr_t* make_CaseStmt_Range_t(Allocator &al, const Location &a_loc, expr_t* a_start, expr_t* a_end, stmt_t** a_body, size_t n_body) {
        CaseStmt_Range_t *n;
        n = al.make_new<CaseStmt_Range_t>();
        n->base.type = case_stmtType::CaseStmt_Range;
        n->base.base.type = asrType::case_stmt;
        n->base.base.loc = a_loc;
        n->m_start = a_start;
        n->m_end = a_end;
        n->m_body = a_body;
        n->n_body = n_body;
        return (asr_t*)n;
    }



enum type_stmtType // Types
{
    TypeStmtName, ClassStmt, TypeStmtType
};

struct type_stmt_t // Sum
{
    const static asrType class_type = asrType::type_stmt;
    asr_t base;
    type_stmtType type;
};

    struct TypeStmtName_t // Constructor
    {
        const static type_stmtType class_type = type_stmtType::TypeStmtName;
        typedef type_stmt_t parent_type;
        type_stmt_t base;
        symbol_t* m_sym;
        stmt_t** m_body; size_t n_body; // Sequence
    };
    static inline asr_t* make_TypeStmtName_t(Allocator &al, const Location &a_loc, symbol_t* a_sym, stmt_t** a_body, size_t n_body) {
        TypeStmtName_t *n;
        n = al.make_new<TypeStmtName_t>();
        n->base.type = type_stmtType::TypeStmtName;
        n->base.base.type = asrType::type_stmt;
        n->base.base.loc = a_loc;
        n->m_sym = a_sym;
        n->m_body = a_body;
        n->n_body = n_body;
        return (asr_t*)n;
    }

    struct ClassStmt_t // Constructor
    {
        const static type_stmtType class_type = type_stmtType::ClassStmt;
        typedef type_stmt_t parent_type;
        type_stmt_t base;
        symbol_t* m_sym;
        stmt_t** m_body; size_t n_body; // Sequence
    };
    static inline asr_t* make_ClassStmt_t(Allocator &al, const Location &a_loc, symbol_t* a_sym, stmt_t** a_body, size_t n_body) {
        ClassStmt_t *n;
        n = al.make_new<ClassStmt_t>();
        n->base.type = type_stmtType::ClassStmt;
        n->base.base.type = asrType::type_stmt;
        n->base.base.loc = a_loc;
        n->m_sym = a_sym;
        n->m_body = a_body;
        n->n_body = n_body;
        return (asr_t*)n;
    }

    struct TypeStmtType_t // Constructor
    {
        const static type_stmtType class_type = type_stmtType::TypeStmtType;
        typedef type_stmt_t parent_type;
        type_stmt_t base;
        ttype_t* m_type;
        stmt_t** m_body; size_t n_body; // Sequence
    };
    static inline asr_t* make_TypeStmtType_t(Allocator &al, const Location &a_loc, ttype_t* a_type, stmt_t** a_body, size_t n_body) {
        TypeStmtType_t *n;
        n = al.make_new<TypeStmtType_t>();
        n->base.type = type_stmtType::TypeStmtType;
        n->base.base.type = asrType::type_stmt;
        n->base.base.loc = a_loc;
        n->m_type = a_type;
        n->m_body = a_body;
        n->n_body = n_body;
        return (asr_t*)n;
    }



enum require_instantiationType // Types
{
    Require
};

struct require_instantiation_t // Sum
{
    const static asrType class_type = asrType::require_instantiation;
    asr_t base;
    require_instantiationType type;
};

    struct Require_t // Constructor
    {
        const static require_instantiationType class_type = require_instantiationType::Require;
        typedef require_instantiation_t parent_type;
        require_instantiation_t base;
        char* m_name;
        char** m_args; size_t n_args; // Sequence
    };
    static inline asr_t* make_Require_t(Allocator &al, const Location &a_loc, char* a_name, char** a_args, size_t n_args) {
        Require_t *n;
        n = al.make_new<Require_t>();
        n->base.type = require_instantiationType::Require;
        n->base.base.type = asrType::require_instantiation;
        n->base.base.loc = a_loc;
        n->m_name = a_name;
        n->m_args = a_args;
        n->n_args = n_args;
        return (asr_t*)n;
    }





/******************************************************************************/
// Visitor functions

template <class Visitor>
static void visit_unit_t(const unit_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == asrType::unit)
    switch (x.type) {
        case unitType::TranslationUnit: { v.visit_TranslationUnit((const TranslationUnit_t &)x); return; }
    }
}

template <class Visitor>
static void visit_symbol_t(const symbol_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == asrType::symbol)
    switch (x.type) {
        case symbolType::Program: { v.visit_Program((const Program_t &)x); return; }
        case symbolType::Module: { v.visit_Module((const Module_t &)x); return; }
        case symbolType::Function: { v.visit_Function((const Function_t &)x); return; }
        case symbolType::GenericProcedure: { v.visit_GenericProcedure((const GenericProcedure_t &)x); return; }
        case symbolType::CustomOperator: { v.visit_CustomOperator((const CustomOperator_t &)x); return; }
        case symbolType::ExternalSymbol: { v.visit_ExternalSymbol((const ExternalSymbol_t &)x); return; }
        case symbolType::StructType: { v.visit_StructType((const StructType_t &)x); return; }
        case symbolType::EnumType: { v.visit_EnumType((const EnumType_t &)x); return; }
        case symbolType::UnionType: { v.visit_UnionType((const UnionType_t &)x); return; }
        case symbolType::Variable: { v.visit_Variable((const Variable_t &)x); return; }
        case symbolType::ClassType: { v.visit_ClassType((const ClassType_t &)x); return; }
        case symbolType::ClassProcedure: { v.visit_ClassProcedure((const ClassProcedure_t &)x); return; }
        case symbolType::AssociateBlock: { v.visit_AssociateBlock((const AssociateBlock_t &)x); return; }
        case symbolType::Block: { v.visit_Block((const Block_t &)x); return; }
        case symbolType::Requirement: { v.visit_Requirement((const Requirement_t &)x); return; }
        case symbolType::Template: { v.visit_Template((const Template_t &)x); return; }
    }
}

template <class Visitor>
static void visit_stmt_t(const stmt_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == asrType::stmt)
    switch (x.type) {
        case stmtType::Allocate: { v.visit_Allocate((const Allocate_t &)x); return; }
        case stmtType::ReAlloc: { v.visit_ReAlloc((const ReAlloc_t &)x); return; }
        case stmtType::Assign: { v.visit_Assign((const Assign_t &)x); return; }
        case stmtType::Assignment: { v.visit_Assignment((const Assignment_t &)x); return; }
        case stmtType::Associate: { v.visit_Associate((const Associate_t &)x); return; }
        case stmtType::Cycle: { v.visit_Cycle((const Cycle_t &)x); return; }
        case stmtType::ExplicitDeallocate: { v.visit_ExplicitDeallocate((const ExplicitDeallocate_t &)x); return; }
        case stmtType::ImplicitDeallocate: { v.visit_ImplicitDeallocate((const ImplicitDeallocate_t &)x); return; }
        case stmtType::DoConcurrentLoop: { v.visit_DoConcurrentLoop((const DoConcurrentLoop_t &)x); return; }
        case stmtType::DoLoop: { v.visit_DoLoop((const DoLoop_t &)x); return; }
        case stmtType::ErrorStop: { v.visit_ErrorStop((const ErrorStop_t &)x); return; }
        case stmtType::Exit: { v.visit_Exit((const Exit_t &)x); return; }
        case stmtType::ForAllSingle: { v.visit_ForAllSingle((const ForAllSingle_t &)x); return; }
        case stmtType::GoTo: { v.visit_GoTo((const GoTo_t &)x); return; }
        case stmtType::GoToTarget: { v.visit_GoToTarget((const GoToTarget_t &)x); return; }
        case stmtType::If: { v.visit_If((const If_t &)x); return; }
        case stmtType::IfArithmetic: { v.visit_IfArithmetic((const IfArithmetic_t &)x); return; }
        case stmtType::Print: { v.visit_Print((const Print_t &)x); return; }
        case stmtType::FileOpen: { v.visit_FileOpen((const FileOpen_t &)x); return; }
        case stmtType::FileClose: { v.visit_FileClose((const FileClose_t &)x); return; }
        case stmtType::FileRead: { v.visit_FileRead((const FileRead_t &)x); return; }
        case stmtType::FileBackspace: { v.visit_FileBackspace((const FileBackspace_t &)x); return; }
        case stmtType::FileRewind: { v.visit_FileRewind((const FileRewind_t &)x); return; }
        case stmtType::FileInquire: { v.visit_FileInquire((const FileInquire_t &)x); return; }
        case stmtType::FileWrite: { v.visit_FileWrite((const FileWrite_t &)x); return; }
        case stmtType::Return: { v.visit_Return((const Return_t &)x); return; }
        case stmtType::Select: { v.visit_Select((const Select_t &)x); return; }
        case stmtType::Stop: { v.visit_Stop((const Stop_t &)x); return; }
        case stmtType::Assert: { v.visit_Assert((const Assert_t &)x); return; }
        case stmtType::SubroutineCall: { v.visit_SubroutineCall((const SubroutineCall_t &)x); return; }
        case stmtType::IntrinsicImpureSubroutine: { v.visit_IntrinsicImpureSubroutine((const IntrinsicImpureSubroutine_t &)x); return; }
        case stmtType::Where: { v.visit_Where((const Where_t &)x); return; }
        case stmtType::WhileLoop: { v.visit_WhileLoop((const WhileLoop_t &)x); return; }
        case stmtType::Nullify: { v.visit_Nullify((const Nullify_t &)x); return; }
        case stmtType::Flush: { v.visit_Flush((const Flush_t &)x); return; }
        case stmtType::ListAppend: { v.visit_ListAppend((const ListAppend_t &)x); return; }
        case stmtType::AssociateBlockCall: { v.visit_AssociateBlockCall((const AssociateBlockCall_t &)x); return; }
        case stmtType::SelectType: { v.visit_SelectType((const SelectType_t &)x); return; }
        case stmtType::CPtrToPointer: { v.visit_CPtrToPointer((const CPtrToPointer_t &)x); return; }
        case stmtType::BlockCall: { v.visit_BlockCall((const BlockCall_t &)x); return; }
        case stmtType::SetInsert: { v.visit_SetInsert((const SetInsert_t &)x); return; }
        case stmtType::SetRemove: { v.visit_SetRemove((const SetRemove_t &)x); return; }
        case stmtType::ListInsert: { v.visit_ListInsert((const ListInsert_t &)x); return; }
        case stmtType::ListRemove: { v.visit_ListRemove((const ListRemove_t &)x); return; }
        case stmtType::ListClear: { v.visit_ListClear((const ListClear_t &)x); return; }
        case stmtType::DictInsert: { v.visit_DictInsert((const DictInsert_t &)x); return; }
        case stmtType::Expr: { v.visit_Expr((const Expr_t &)x); return; }
    }
}

template <class Visitor>
static void visit_expr_t(const expr_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == asrType::expr)
    switch (x.type) {
        case exprType::IfExp: { v.visit_IfExp((const IfExp_t &)x); return; }
        case exprType::ComplexConstructor: { v.visit_ComplexConstructor((const ComplexConstructor_t &)x); return; }
        case exprType::NamedExpr: { v.visit_NamedExpr((const NamedExpr_t &)x); return; }
        case exprType::FunctionCall: { v.visit_FunctionCall((const FunctionCall_t &)x); return; }
        case exprType::IntrinsicElementalFunction: { v.visit_IntrinsicElementalFunction((const IntrinsicElementalFunction_t &)x); return; }
        case exprType::IntrinsicArrayFunction: { v.visit_IntrinsicArrayFunction((const IntrinsicArrayFunction_t &)x); return; }
        case exprType::IntrinsicImpureFunction: { v.visit_IntrinsicImpureFunction((const IntrinsicImpureFunction_t &)x); return; }
        case exprType::TypeInquiry: { v.visit_TypeInquiry((const TypeInquiry_t &)x); return; }
        case exprType::StructTypeConstructor: { v.visit_StructTypeConstructor((const StructTypeConstructor_t &)x); return; }
        case exprType::EnumTypeConstructor: { v.visit_EnumTypeConstructor((const EnumTypeConstructor_t &)x); return; }
        case exprType::UnionTypeConstructor: { v.visit_UnionTypeConstructor((const UnionTypeConstructor_t &)x); return; }
        case exprType::ImpliedDoLoop: { v.visit_ImpliedDoLoop((const ImpliedDoLoop_t &)x); return; }
        case exprType::IntegerConstant: { v.visit_IntegerConstant((const IntegerConstant_t &)x); return; }
        case exprType::IntegerBOZ: { v.visit_IntegerBOZ((const IntegerBOZ_t &)x); return; }
        case exprType::IntegerBitNot: { v.visit_IntegerBitNot((const IntegerBitNot_t &)x); return; }
        case exprType::IntegerUnaryMinus: { v.visit_IntegerUnaryMinus((const IntegerUnaryMinus_t &)x); return; }
        case exprType::IntegerCompare: { v.visit_IntegerCompare((const IntegerCompare_t &)x); return; }
        case exprType::IntegerBinOp: { v.visit_IntegerBinOp((const IntegerBinOp_t &)x); return; }
        case exprType::UnsignedIntegerConstant: { v.visit_UnsignedIntegerConstant((const UnsignedIntegerConstant_t &)x); return; }
        case exprType::UnsignedIntegerUnaryMinus: { v.visit_UnsignedIntegerUnaryMinus((const UnsignedIntegerUnaryMinus_t &)x); return; }
        case exprType::UnsignedIntegerBitNot: { v.visit_UnsignedIntegerBitNot((const UnsignedIntegerBitNot_t &)x); return; }
        case exprType::UnsignedIntegerCompare: { v.visit_UnsignedIntegerCompare((const UnsignedIntegerCompare_t &)x); return; }
        case exprType::UnsignedIntegerBinOp: { v.visit_UnsignedIntegerBinOp((const UnsignedIntegerBinOp_t &)x); return; }
        case exprType::RealConstant: { v.visit_RealConstant((const RealConstant_t &)x); return; }
        case exprType::RealUnaryMinus: { v.visit_RealUnaryMinus((const RealUnaryMinus_t &)x); return; }
        case exprType::RealCompare: { v.visit_RealCompare((const RealCompare_t &)x); return; }
        case exprType::RealBinOp: { v.visit_RealBinOp((const RealBinOp_t &)x); return; }
        case exprType::RealCopySign: { v.visit_RealCopySign((const RealCopySign_t &)x); return; }
        case exprType::ComplexConstant: { v.visit_ComplexConstant((const ComplexConstant_t &)x); return; }
        case exprType::ComplexUnaryMinus: { v.visit_ComplexUnaryMinus((const ComplexUnaryMinus_t &)x); return; }
        case exprType::ComplexCompare: { v.visit_ComplexCompare((const ComplexCompare_t &)x); return; }
        case exprType::ComplexBinOp: { v.visit_ComplexBinOp((const ComplexBinOp_t &)x); return; }
        case exprType::LogicalConstant: { v.visit_LogicalConstant((const LogicalConstant_t &)x); return; }
        case exprType::LogicalNot: { v.visit_LogicalNot((const LogicalNot_t &)x); return; }
        case exprType::LogicalCompare: { v.visit_LogicalCompare((const LogicalCompare_t &)x); return; }
        case exprType::LogicalBinOp: { v.visit_LogicalBinOp((const LogicalBinOp_t &)x); return; }
        case exprType::ListConstant: { v.visit_ListConstant((const ListConstant_t &)x); return; }
        case exprType::ListLen: { v.visit_ListLen((const ListLen_t &)x); return; }
        case exprType::ListConcat: { v.visit_ListConcat((const ListConcat_t &)x); return; }
        case exprType::ListCompare: { v.visit_ListCompare((const ListCompare_t &)x); return; }
        case exprType::ListCount: { v.visit_ListCount((const ListCount_t &)x); return; }
        case exprType::SetConstant: { v.visit_SetConstant((const SetConstant_t &)x); return; }
        case exprType::SetLen: { v.visit_SetLen((const SetLen_t &)x); return; }
        case exprType::TupleConstant: { v.visit_TupleConstant((const TupleConstant_t &)x); return; }
        case exprType::TupleLen: { v.visit_TupleLen((const TupleLen_t &)x); return; }
        case exprType::TupleCompare: { v.visit_TupleCompare((const TupleCompare_t &)x); return; }
        case exprType::TupleConcat: { v.visit_TupleConcat((const TupleConcat_t &)x); return; }
        case exprType::StringConstant: { v.visit_StringConstant((const StringConstant_t &)x); return; }
        case exprType::StringConcat: { v.visit_StringConcat((const StringConcat_t &)x); return; }
        case exprType::StringRepeat: { v.visit_StringRepeat((const StringRepeat_t &)x); return; }
        case exprType::StringLen: { v.visit_StringLen((const StringLen_t &)x); return; }
        case exprType::StringItem: { v.visit_StringItem((const StringItem_t &)x); return; }
        case exprType::StringSection: { v.visit_StringSection((const StringSection_t &)x); return; }
        case exprType::StringCompare: { v.visit_StringCompare((const StringCompare_t &)x); return; }
        case exprType::StringOrd: { v.visit_StringOrd((const StringOrd_t &)x); return; }
        case exprType::StringChr: { v.visit_StringChr((const StringChr_t &)x); return; }
        case exprType::StringFormat: { v.visit_StringFormat((const StringFormat_t &)x); return; }
        case exprType::CPtrCompare: { v.visit_CPtrCompare((const CPtrCompare_t &)x); return; }
        case exprType::SymbolicCompare: { v.visit_SymbolicCompare((const SymbolicCompare_t &)x); return; }
        case exprType::DictConstant: { v.visit_DictConstant((const DictConstant_t &)x); return; }
        case exprType::DictLen: { v.visit_DictLen((const DictLen_t &)x); return; }
        case exprType::Var: { v.visit_Var((const Var_t &)x); return; }
        case exprType::FunctionParam: { v.visit_FunctionParam((const FunctionParam_t &)x); return; }
        case exprType::ArrayConstructor: { v.visit_ArrayConstructor((const ArrayConstructor_t &)x); return; }
        case exprType::ArrayConstant: { v.visit_ArrayConstant((const ArrayConstant_t &)x); return; }
        case exprType::ArrayItem: { v.visit_ArrayItem((const ArrayItem_t &)x); return; }
        case exprType::ArraySection: { v.visit_ArraySection((const ArraySection_t &)x); return; }
        case exprType::ArraySize: { v.visit_ArraySize((const ArraySize_t &)x); return; }
        case exprType::ArrayBound: { v.visit_ArrayBound((const ArrayBound_t &)x); return; }
        case exprType::ArrayTranspose: { v.visit_ArrayTranspose((const ArrayTranspose_t &)x); return; }
        case exprType::ArrayPack: { v.visit_ArrayPack((const ArrayPack_t &)x); return; }
        case exprType::ArrayReshape: { v.visit_ArrayReshape((const ArrayReshape_t &)x); return; }
        case exprType::ArrayBroadcast: { v.visit_ArrayBroadcast((const ArrayBroadcast_t &)x); return; }
        case exprType::BitCast: { v.visit_BitCast((const BitCast_t &)x); return; }
        case exprType::StructInstanceMember: { v.visit_StructInstanceMember((const StructInstanceMember_t &)x); return; }
        case exprType::StructStaticMember: { v.visit_StructStaticMember((const StructStaticMember_t &)x); return; }
        case exprType::EnumStaticMember: { v.visit_EnumStaticMember((const EnumStaticMember_t &)x); return; }
        case exprType::UnionInstanceMember: { v.visit_UnionInstanceMember((const UnionInstanceMember_t &)x); return; }
        case exprType::EnumName: { v.visit_EnumName((const EnumName_t &)x); return; }
        case exprType::EnumValue: { v.visit_EnumValue((const EnumValue_t &)x); return; }
        case exprType::OverloadedCompare: { v.visit_OverloadedCompare((const OverloadedCompare_t &)x); return; }
        case exprType::OverloadedBinOp: { v.visit_OverloadedBinOp((const OverloadedBinOp_t &)x); return; }
        case exprType::OverloadedUnaryMinus: { v.visit_OverloadedUnaryMinus((const OverloadedUnaryMinus_t &)x); return; }
        case exprType::OverloadedStringConcat: { v.visit_OverloadedStringConcat((const OverloadedStringConcat_t &)x); return; }
        case exprType::Cast: { v.visit_Cast((const Cast_t &)x); return; }
        case exprType::ArrayPhysicalCast: { v.visit_ArrayPhysicalCast((const ArrayPhysicalCast_t &)x); return; }
        case exprType::ComplexRe: { v.visit_ComplexRe((const ComplexRe_t &)x); return; }
        case exprType::ComplexIm: { v.visit_ComplexIm((const ComplexIm_t &)x); return; }
        case exprType::DictItem: { v.visit_DictItem((const DictItem_t &)x); return; }
        case exprType::CLoc: { v.visit_CLoc((const CLoc_t &)x); return; }
        case exprType::PointerToCPtr: { v.visit_PointerToCPtr((const PointerToCPtr_t &)x); return; }
        case exprType::GetPointer: { v.visit_GetPointer((const GetPointer_t &)x); return; }
        case exprType::ListItem: { v.visit_ListItem((const ListItem_t &)x); return; }
        case exprType::TupleItem: { v.visit_TupleItem((const TupleItem_t &)x); return; }
        case exprType::ListSection: { v.visit_ListSection((const ListSection_t &)x); return; }
        case exprType::ListRepeat: { v.visit_ListRepeat((const ListRepeat_t &)x); return; }
        case exprType::DictPop: { v.visit_DictPop((const DictPop_t &)x); return; }
        case exprType::SetPop: { v.visit_SetPop((const SetPop_t &)x); return; }
        case exprType::IntegerBitLen: { v.visit_IntegerBitLen((const IntegerBitLen_t &)x); return; }
        case exprType::Ichar: { v.visit_Ichar((const Ichar_t &)x); return; }
        case exprType::Iachar: { v.visit_Iachar((const Iachar_t &)x); return; }
        case exprType::SizeOfType: { v.visit_SizeOfType((const SizeOfType_t &)x); return; }
        case exprType::PointerNullConstant: { v.visit_PointerNullConstant((const PointerNullConstant_t &)x); return; }
        case exprType::PointerAssociated: { v.visit_PointerAssociated((const PointerAssociated_t &)x); return; }
        case exprType::RealSqrt: { v.visit_RealSqrt((const RealSqrt_t &)x); return; }
    }
}

template <class Visitor>
static void visit_ttype_t(const ttype_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == asrType::ttype)
    switch (x.type) {
        case ttypeType::Integer: { v.visit_Integer((const Integer_t &)x); return; }
        case ttypeType::UnsignedInteger: { v.visit_UnsignedInteger((const UnsignedInteger_t &)x); return; }
        case ttypeType::Real: { v.visit_Real((const Real_t &)x); return; }
        case ttypeType::Complex: { v.visit_Complex((const Complex_t &)x); return; }
        case ttypeType::Character: { v.visit_Character((const Character_t &)x); return; }
        case ttypeType::Logical: { v.visit_Logical((const Logical_t &)x); return; }
        case ttypeType::Set: { v.visit_Set((const Set_t &)x); return; }
        case ttypeType::List: { v.visit_List((const List_t &)x); return; }
        case ttypeType::Tuple: { v.visit_Tuple((const Tuple_t &)x); return; }
        case ttypeType::Struct: { v.visit_Struct((const Struct_t &)x); return; }
        case ttypeType::Enum: { v.visit_Enum((const Enum_t &)x); return; }
        case ttypeType::Union: { v.visit_Union((const Union_t &)x); return; }
        case ttypeType::Class: { v.visit_Class((const Class_t &)x); return; }
        case ttypeType::Dict: { v.visit_Dict((const Dict_t &)x); return; }
        case ttypeType::Pointer: { v.visit_Pointer((const Pointer_t &)x); return; }
        case ttypeType::Allocatable: { v.visit_Allocatable((const Allocatable_t &)x); return; }
        case ttypeType::CPtr: { v.visit_CPtr((const CPtr_t &)x); return; }
        case ttypeType::SymbolicExpression: { v.visit_SymbolicExpression((const SymbolicExpression_t &)x); return; }
        case ttypeType::TypeParameter: { v.visit_TypeParameter((const TypeParameter_t &)x); return; }
        case ttypeType::Array: { v.visit_Array((const Array_t &)x); return; }
        case ttypeType::FunctionType: { v.visit_FunctionType((const FunctionType_t &)x); return; }
    }
}

template <class Visitor>
static void visit_attribute_t(const attribute_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == asrType::attribute)
    switch (x.type) {
        case attributeType::Attribute: { v.visit_Attribute((const Attribute_t &)x); return; }
    }
}

template <class Visitor>
static void visit_tbind_t(const tbind_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == asrType::tbind)
    switch (x.type) {
        case tbindType::Bind: { v.visit_Bind((const Bind_t &)x); return; }
    }
}

template <class Visitor>
static void visit_case_stmt_t(const case_stmt_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == asrType::case_stmt)
    switch (x.type) {
        case case_stmtType::CaseStmt: { v.visit_CaseStmt((const CaseStmt_t &)x); return; }
        case case_stmtType::CaseStmt_Range: { v.visit_CaseStmt_Range((const CaseStmt_Range_t &)x); return; }
    }
}

template <class Visitor>
static void visit_type_stmt_t(const type_stmt_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == asrType::type_stmt)
    switch (x.type) {
        case type_stmtType::TypeStmtName: { v.visit_TypeStmtName((const TypeStmtName_t &)x); return; }
        case type_stmtType::ClassStmt: { v.visit_ClassStmt((const ClassStmt_t &)x); return; }
        case type_stmtType::TypeStmtType: { v.visit_TypeStmtType((const TypeStmtType_t &)x); return; }
    }
}

template <class Visitor>
static void visit_require_instantiation_t(const require_instantiation_t &x, Visitor &v) {
    LCOMPILERS_ASSERT(x.base.type == asrType::require_instantiation)
    switch (x.type) {
        case require_instantiationType::Require: { v.visit_Require((const Require_t &)x); return; }
    }
}



template <class Visitor>
static void visit_asr_t(const asr_t &x, Visitor &v) {
    switch (x.type) {
        case asrType::unit: { v.visit_unit((const unit_t &)x); return; }
        case asrType::symbol: { v.visit_symbol((const symbol_t &)x); return; }
        case asrType::stmt: { v.visit_stmt((const stmt_t &)x); return; }
        case asrType::expr: { v.visit_expr((const expr_t &)x); return; }
        case asrType::ttype: { v.visit_ttype((const ttype_t &)x); return; }
        case asrType::attribute: { v.visit_attribute((const attribute_t &)x); return; }
        case asrType::tbind: { v.visit_tbind((const tbind_t &)x); return; }
        case asrType::case_stmt: { v.visit_case_stmt((const case_stmt_t &)x); return; }
        case asrType::type_stmt: { v.visit_type_stmt((const type_stmt_t &)x); return; }
        case asrType::require_instantiation: { v.visit_require_instantiation((const require_instantiation_t &)x); return; }
    }
}



/******************************************************************************/
// Visitor base class

template <class Struct>
class BaseVisitor
{
private:
    Struct& self() { return static_cast<Struct&>(*this); }
public:
    void visit_asr(const asr_t &b) { visit_asr_t(b, self()); }
    void visit_unit(const unit_t &b) { visit_unit_t(b, self()); }
        void visit_TranslationUnit(const TranslationUnit_t & /* x */) { throw LCompilersException("visit_TranslationUnit() not implemented"); }
    void visit_symbol(const symbol_t &b) { visit_symbol_t(b, self()); }
        void visit_Program(const Program_t & /* x */) { throw LCompilersException("visit_Program() not implemented"); }
        void visit_Module(const Module_t & /* x */) { throw LCompilersException("visit_Module() not implemented"); }
        void visit_Function(const Function_t & /* x */) { throw LCompilersException("visit_Function() not implemented"); }
        void visit_GenericProcedure(const GenericProcedure_t & /* x */) { throw LCompilersException("visit_GenericProcedure() not implemented"); }
        void visit_CustomOperator(const CustomOperator_t & /* x */) { throw LCompilersException("visit_CustomOperator() not implemented"); }
        void visit_ExternalSymbol(const ExternalSymbol_t & /* x */) { throw LCompilersException("visit_ExternalSymbol() not implemented"); }
        void visit_StructType(const StructType_t & /* x */) { throw LCompilersException("visit_StructType() not implemented"); }
        void visit_EnumType(const EnumType_t & /* x */) { throw LCompilersException("visit_EnumType() not implemented"); }
        void visit_UnionType(const UnionType_t & /* x */) { throw LCompilersException("visit_UnionType() not implemented"); }
        void visit_Variable(const Variable_t & /* x */) { throw LCompilersException("visit_Variable() not implemented"); }
        void visit_ClassType(const ClassType_t & /* x */) { throw LCompilersException("visit_ClassType() not implemented"); }
        void visit_ClassProcedure(const ClassProcedure_t & /* x */) { throw LCompilersException("visit_ClassProcedure() not implemented"); }
        void visit_AssociateBlock(const AssociateBlock_t & /* x */) { throw LCompilersException("visit_AssociateBlock() not implemented"); }
        void visit_Block(const Block_t & /* x */) { throw LCompilersException("visit_Block() not implemented"); }
        void visit_Requirement(const Requirement_t & /* x */) { throw LCompilersException("visit_Requirement() not implemented"); }
        void visit_Template(const Template_t & /* x */) { throw LCompilersException("visit_Template() not implemented"); }
    void visit_stmt(const stmt_t &b) { visit_stmt_t(b, self()); }
        void visit_Allocate(const Allocate_t & /* x */) { throw LCompilersException("visit_Allocate() not implemented"); }
        void visit_ReAlloc(const ReAlloc_t & /* x */) { throw LCompilersException("visit_ReAlloc() not implemented"); }
        void visit_Assign(const Assign_t & /* x */) { throw LCompilersException("visit_Assign() not implemented"); }
        void visit_Assignment(const Assignment_t & /* x */) { throw LCompilersException("visit_Assignment() not implemented"); }
        void visit_Associate(const Associate_t & /* x */) { throw LCompilersException("visit_Associate() not implemented"); }
        void visit_Cycle(const Cycle_t & /* x */) { throw LCompilersException("visit_Cycle() not implemented"); }
        void visit_ExplicitDeallocate(const ExplicitDeallocate_t & /* x */) { throw LCompilersException("visit_ExplicitDeallocate() not implemented"); }
        void visit_ImplicitDeallocate(const ImplicitDeallocate_t & /* x */) { throw LCompilersException("visit_ImplicitDeallocate() not implemented"); }
        void visit_DoConcurrentLoop(const DoConcurrentLoop_t & /* x */) { throw LCompilersException("visit_DoConcurrentLoop() not implemented"); }
        void visit_DoLoop(const DoLoop_t & /* x */) { throw LCompilersException("visit_DoLoop() not implemented"); }
        void visit_ErrorStop(const ErrorStop_t & /* x */) { throw LCompilersException("visit_ErrorStop() not implemented"); }
        void visit_Exit(const Exit_t & /* x */) { throw LCompilersException("visit_Exit() not implemented"); }
        void visit_ForAllSingle(const ForAllSingle_t & /* x */) { throw LCompilersException("visit_ForAllSingle() not implemented"); }
        void visit_GoTo(const GoTo_t & /* x */) { throw LCompilersException("visit_GoTo() not implemented"); }
        void visit_GoToTarget(const GoToTarget_t & /* x */) { throw LCompilersException("visit_GoToTarget() not implemented"); }
        void visit_If(const If_t & /* x */) { throw LCompilersException("visit_If() not implemented"); }
        void visit_IfArithmetic(const IfArithmetic_t & /* x */) { throw LCompilersException("visit_IfArithmetic() not implemented"); }
        void visit_Print(const Print_t & /* x */) { throw LCompilersException("visit_Print() not implemented"); }
        void visit_FileOpen(const FileOpen_t & /* x */) { throw LCompilersException("visit_FileOpen() not implemented"); }
        void visit_FileClose(const FileClose_t & /* x */) { throw LCompilersException("visit_FileClose() not implemented"); }
        void visit_FileRead(const FileRead_t & /* x */) { throw LCompilersException("visit_FileRead() not implemented"); }
        void visit_FileBackspace(const FileBackspace_t & /* x */) { throw LCompilersException("visit_FileBackspace() not implemented"); }
        void visit_FileRewind(const FileRewind_t & /* x */) { throw LCompilersException("visit_FileRewind() not implemented"); }
        void visit_FileInquire(const FileInquire_t & /* x */) { throw LCompilersException("visit_FileInquire() not implemented"); }
        void visit_FileWrite(const FileWrite_t & /* x */) { throw LCompilersException("visit_FileWrite() not implemented"); }
        void visit_Return(const Return_t & /* x */) { throw LCompilersException("visit_Return() not implemented"); }
        void visit_Select(const Select_t & /* x */) { throw LCompilersException("visit_Select() not implemented"); }
        void visit_Stop(const Stop_t & /* x */) { throw LCompilersException("visit_Stop() not implemented"); }
        void visit_Assert(const Assert_t & /* x */) { throw LCompilersException("visit_Assert() not implemented"); }
        void visit_SubroutineCall(const SubroutineCall_t & /* x */) { throw LCompilersException("visit_SubroutineCall() not implemented"); }
        void visit_IntrinsicImpureSubroutine(const IntrinsicImpureSubroutine_t & /* x */) { throw LCompilersException("visit_IntrinsicImpureSubroutine() not implemented"); }
        void visit_Where(const Where_t & /* x */) { throw LCompilersException("visit_Where() not implemented"); }
        void visit_WhileLoop(const WhileLoop_t & /* x */) { throw LCompilersException("visit_WhileLoop() not implemented"); }
        void visit_Nullify(const Nullify_t & /* x */) { throw LCompilersException("visit_Nullify() not implemented"); }
        void visit_Flush(const Flush_t & /* x */) { throw LCompilersException("visit_Flush() not implemented"); }
        void visit_ListAppend(const ListAppend_t & /* x */) { throw LCompilersException("visit_ListAppend() not implemented"); }
        void visit_AssociateBlockCall(const AssociateBlockCall_t & /* x */) { throw LCompilersException("visit_AssociateBlockCall() not implemented"); }
        void visit_SelectType(const SelectType_t & /* x */) { throw LCompilersException("visit_SelectType() not implemented"); }
        void visit_CPtrToPointer(const CPtrToPointer_t & /* x */) { throw LCompilersException("visit_CPtrToPointer() not implemented"); }
        void visit_BlockCall(const BlockCall_t & /* x */) { throw LCompilersException("visit_BlockCall() not implemented"); }
        void visit_SetInsert(const SetInsert_t & /* x */) { throw LCompilersException("visit_SetInsert() not implemented"); }
        void visit_SetRemove(const SetRemove_t & /* x */) { throw LCompilersException("visit_SetRemove() not implemented"); }
        void visit_ListInsert(const ListInsert_t & /* x */) { throw LCompilersException("visit_ListInsert() not implemented"); }
        void visit_ListRemove(const ListRemove_t & /* x */) { throw LCompilersException("visit_ListRemove() not implemented"); }
        void visit_ListClear(const ListClear_t & /* x */) { throw LCompilersException("visit_ListClear() not implemented"); }
        void visit_DictInsert(const DictInsert_t & /* x */) { throw LCompilersException("visit_DictInsert() not implemented"); }
        void visit_Expr(const Expr_t & /* x */) { throw LCompilersException("visit_Expr() not implemented"); }
    void visit_expr(const expr_t &b) { visit_expr_t(b, self()); }
        void visit_IfExp(const IfExp_t & /* x */) { throw LCompilersException("visit_IfExp() not implemented"); }
        void visit_ComplexConstructor(const ComplexConstructor_t & /* x */) { throw LCompilersException("visit_ComplexConstructor() not implemented"); }
        void visit_NamedExpr(const NamedExpr_t & /* x */) { throw LCompilersException("visit_NamedExpr() not implemented"); }
        void visit_FunctionCall(const FunctionCall_t & /* x */) { throw LCompilersException("visit_FunctionCall() not implemented"); }
        void visit_IntrinsicElementalFunction(const IntrinsicElementalFunction_t & /* x */) { throw LCompilersException("visit_IntrinsicElementalFunction() not implemented"); }
        void visit_IntrinsicArrayFunction(const IntrinsicArrayFunction_t & /* x */) { throw LCompilersException("visit_IntrinsicArrayFunction() not implemented"); }
        void visit_IntrinsicImpureFunction(const IntrinsicImpureFunction_t & /* x */) { throw LCompilersException("visit_IntrinsicImpureFunction() not implemented"); }
        void visit_TypeInquiry(const TypeInquiry_t & /* x */) { throw LCompilersException("visit_TypeInquiry() not implemented"); }
        void visit_StructTypeConstructor(const StructTypeConstructor_t & /* x */) { throw LCompilersException("visit_StructTypeConstructor() not implemented"); }
        void visit_EnumTypeConstructor(const EnumTypeConstructor_t & /* x */) { throw LCompilersException("visit_EnumTypeConstructor() not implemented"); }
        void visit_UnionTypeConstructor(const UnionTypeConstructor_t & /* x */) { throw LCompilersException("visit_UnionTypeConstructor() not implemented"); }
        void visit_ImpliedDoLoop(const ImpliedDoLoop_t & /* x */) { throw LCompilersException("visit_ImpliedDoLoop() not implemented"); }
        void visit_IntegerConstant(const IntegerConstant_t & /* x */) { throw LCompilersException("visit_IntegerConstant() not implemented"); }
        void visit_IntegerBOZ(const IntegerBOZ_t & /* x */) { throw LCompilersException("visit_IntegerBOZ() not implemented"); }
        void visit_IntegerBitNot(const IntegerBitNot_t & /* x */) { throw LCompilersException("visit_IntegerBitNot() not implemented"); }
        void visit_IntegerUnaryMinus(const IntegerUnaryMinus_t & /* x */) { throw LCompilersException("visit_IntegerUnaryMinus() not implemented"); }
        void visit_IntegerCompare(const IntegerCompare_t & /* x */) { throw LCompilersException("visit_IntegerCompare() not implemented"); }
        void visit_IntegerBinOp(const IntegerBinOp_t & /* x */) { throw LCompilersException("visit_IntegerBinOp() not implemented"); }
        void visit_UnsignedIntegerConstant(const UnsignedIntegerConstant_t & /* x */) { throw LCompilersException("visit_UnsignedIntegerConstant() not implemented"); }
        void visit_UnsignedIntegerUnaryMinus(const UnsignedIntegerUnaryMinus_t & /* x */) { throw LCompilersException("visit_UnsignedIntegerUnaryMinus() not implemented"); }
        void visit_UnsignedIntegerBitNot(const UnsignedIntegerBitNot_t & /* x */) { throw LCompilersException("visit_UnsignedIntegerBitNot() not implemented"); }
        void visit_UnsignedIntegerCompare(const UnsignedIntegerCompare_t & /* x */) { throw LCompilersException("visit_UnsignedIntegerCompare() not implemented"); }
        void visit_UnsignedIntegerBinOp(const UnsignedIntegerBinOp_t & /* x */) { throw LCompilersException("visit_UnsignedIntegerBinOp() not implemented"); }
        void visit_RealConstant(const RealConstant_t & /* x */) { throw LCompilersException("visit_RealConstant() not implemented"); }
        void visit_RealUnaryMinus(const RealUnaryMinus_t & /* x */) { throw LCompilersException("visit_RealUnaryMinus() not implemented"); }
        void visit_RealCompare(const RealCompare_t & /* x */) { throw LCompilersException("visit_RealCompare() not implemented"); }
        void visit_RealBinOp(const RealBinOp_t & /* x */) { throw LCompilersException("visit_RealBinOp() not implemented"); }
        void visit_RealCopySign(const RealCopySign_t & /* x */) { throw LCompilersException("visit_RealCopySign() not implemented"); }
        void visit_ComplexConstant(const ComplexConstant_t & /* x */) { throw LCompilersException("visit_ComplexConstant() not implemented"); }
        void visit_ComplexUnaryMinus(const ComplexUnaryMinus_t & /* x */) { throw LCompilersException("visit_ComplexUnaryMinus() not implemented"); }
        void visit_ComplexCompare(const ComplexCompare_t & /* x */) { throw LCompilersException("visit_ComplexCompare() not implemented"); }
        void visit_ComplexBinOp(const ComplexBinOp_t & /* x */) { throw LCompilersException("visit_ComplexBinOp() not implemented"); }
        void visit_LogicalConstant(const LogicalConstant_t & /* x */) { throw LCompilersException("visit_LogicalConstant() not implemented"); }
        void visit_LogicalNot(const LogicalNot_t & /* x */) { throw LCompilersException("visit_LogicalNot() not implemented"); }
        void visit_LogicalCompare(const LogicalCompare_t & /* x */) { throw LCompilersException("visit_LogicalCompare() not implemented"); }
        void visit_LogicalBinOp(const LogicalBinOp_t & /* x */) { throw LCompilersException("visit_LogicalBinOp() not implemented"); }
        void visit_ListConstant(const ListConstant_t & /* x */) { throw LCompilersException("visit_ListConstant() not implemented"); }
        void visit_ListLen(const ListLen_t & /* x */) { throw LCompilersException("visit_ListLen() not implemented"); }
        void visit_ListConcat(const ListConcat_t & /* x */) { throw LCompilersException("visit_ListConcat() not implemented"); }
        void visit_ListCompare(const ListCompare_t & /* x */) { throw LCompilersException("visit_ListCompare() not implemented"); }
        void visit_ListCount(const ListCount_t & /* x */) { throw LCompilersException("visit_ListCount() not implemented"); }
        void visit_SetConstant(const SetConstant_t & /* x */) { throw LCompilersException("visit_SetConstant() not implemented"); }
        void visit_SetLen(const SetLen_t & /* x */) { throw LCompilersException("visit_SetLen() not implemented"); }
        void visit_TupleConstant(const TupleConstant_t & /* x */) { throw LCompilersException("visit_TupleConstant() not implemented"); }
        void visit_TupleLen(const TupleLen_t & /* x */) { throw LCompilersException("visit_TupleLen() not implemented"); }
        void visit_TupleCompare(const TupleCompare_t & /* x */) { throw LCompilersException("visit_TupleCompare() not implemented"); }
        void visit_TupleConcat(const TupleConcat_t & /* x */) { throw LCompilersException("visit_TupleConcat() not implemented"); }
        void visit_StringConstant(const StringConstant_t & /* x */) { throw LCompilersException("visit_StringConstant() not implemented"); }
        void visit_StringConcat(const StringConcat_t & /* x */) { throw LCompilersException("visit_StringConcat() not implemented"); }
        void visit_StringRepeat(const StringRepeat_t & /* x */) { throw LCompilersException("visit_StringRepeat() not implemented"); }
        void visit_StringLen(const StringLen_t & /* x */) { throw LCompilersException("visit_StringLen() not implemented"); }
        void visit_StringItem(const StringItem_t & /* x */) { throw LCompilersException("visit_StringItem() not implemented"); }
        void visit_StringSection(const StringSection_t & /* x */) { throw LCompilersException("visit_StringSection() not implemented"); }
        void visit_StringCompare(const StringCompare_t & /* x */) { throw LCompilersException("visit_StringCompare() not implemented"); }
        void visit_StringOrd(const StringOrd_t & /* x */) { throw LCompilersException("visit_StringOrd() not implemented"); }
        void visit_StringChr(const StringChr_t & /* x */) { throw LCompilersException("visit_StringChr() not implemented"); }
        void visit_StringFormat(const StringFormat_t & /* x */) { throw LCompilersException("visit_StringFormat() not implemented"); }
        void visit_CPtrCompare(const CPtrCompare_t & /* x */) { throw LCompilersException("visit_CPtrCompare() not implemented"); }
        void visit_SymbolicCompare(const SymbolicCompare_t & /* x */) { throw LCompilersException("visit_SymbolicCompare() not implemented"); }
        void visit_DictConstant(const DictConstant_t & /* x */) { throw LCompilersException("visit_DictConstant() not implemented"); }
        void visit_DictLen(const DictLen_t & /* x */) { throw LCompilersException("visit_DictLen() not implemented"); }
        void visit_Var(const Var_t & /* x */) { throw LCompilersException("visit_Var() not implemented"); }
        void visit_FunctionParam(const FunctionParam_t & /* x */) { throw LCompilersException("visit_FunctionParam() not implemented"); }
        void visit_ArrayConstructor(const ArrayConstructor_t & /* x */) { throw LCompilersException("visit_ArrayConstructor() not implemented"); }
        void visit_ArrayConstant(const ArrayConstant_t & /* x */) { throw LCompilersException("visit_ArrayConstant() not implemented"); }
        void visit_ArrayItem(const ArrayItem_t & /* x */) { throw LCompilersException("visit_ArrayItem() not implemented"); }
        void visit_ArraySection(const ArraySection_t & /* x */) { throw LCompilersException("visit_ArraySection() not implemented"); }
        void visit_ArraySize(const ArraySize_t & /* x */) { throw LCompilersException("visit_ArraySize() not implemented"); }
        void visit_ArrayBound(const ArrayBound_t & /* x */) { throw LCompilersException("visit_ArrayBound() not implemented"); }
        void visit_ArrayTranspose(const ArrayTranspose_t & /* x */) { throw LCompilersException("visit_ArrayTranspose() not implemented"); }
        void visit_ArrayPack(const ArrayPack_t & /* x */) { throw LCompilersException("visit_ArrayPack() not implemented"); }
        void visit_ArrayReshape(const ArrayReshape_t & /* x */) { throw LCompilersException("visit_ArrayReshape() not implemented"); }
        void visit_ArrayBroadcast(const ArrayBroadcast_t & /* x */) { throw LCompilersException("visit_ArrayBroadcast() not implemented"); }
        void visit_BitCast(const BitCast_t & /* x */) { throw LCompilersException("visit_BitCast() not implemented"); }
        void visit_StructInstanceMember(const StructInstanceMember_t & /* x */) { throw LCompilersException("visit_StructInstanceMember() not implemented"); }
        void visit_StructStaticMember(const StructStaticMember_t & /* x */) { throw LCompilersException("visit_StructStaticMember() not implemented"); }
        void visit_EnumStaticMember(const EnumStaticMember_t & /* x */) { throw LCompilersException("visit_EnumStaticMember() not implemented"); }
        void visit_UnionInstanceMember(const UnionInstanceMember_t & /* x */) { throw LCompilersException("visit_UnionInstanceMember() not implemented"); }
        void visit_EnumName(const EnumName_t & /* x */) { throw LCompilersException("visit_EnumName() not implemented"); }
        void visit_EnumValue(const EnumValue_t & /* x */) { throw LCompilersException("visit_EnumValue() not implemented"); }
        void visit_OverloadedCompare(const OverloadedCompare_t & /* x */) { throw LCompilersException("visit_OverloadedCompare() not implemented"); }
        void visit_OverloadedBinOp(const OverloadedBinOp_t & /* x */) { throw LCompilersException("visit_OverloadedBinOp() not implemented"); }
        void visit_OverloadedUnaryMinus(const OverloadedUnaryMinus_t & /* x */) { throw LCompilersException("visit_OverloadedUnaryMinus() not implemented"); }
        void visit_OverloadedStringConcat(const OverloadedStringConcat_t & /* x */) { throw LCompilersException("visit_OverloadedStringConcat() not implemented"); }
        void visit_Cast(const Cast_t & /* x */) { throw LCompilersException("visit_Cast() not implemented"); }
        void visit_ArrayPhysicalCast(const ArrayPhysicalCast_t & /* x */) { throw LCompilersException("visit_ArrayPhysicalCast() not implemented"); }
        void visit_ComplexRe(const ComplexRe_t & /* x */) { throw LCompilersException("visit_ComplexRe() not implemented"); }
        void visit_ComplexIm(const ComplexIm_t & /* x */) { throw LCompilersException("visit_ComplexIm() not implemented"); }
        void visit_DictItem(const DictItem_t & /* x */) { throw LCompilersException("visit_DictItem() not implemented"); }
        void visit_CLoc(const CLoc_t & /* x */) { throw LCompilersException("visit_CLoc() not implemented"); }
        void visit_PointerToCPtr(const PointerToCPtr_t & /* x */) { throw LCompilersException("visit_PointerToCPtr() not implemented"); }
        void visit_GetPointer(const GetPointer_t & /* x */) { throw LCompilersException("visit_GetPointer() not implemented"); }
        void visit_ListItem(const ListItem_t & /* x */) { throw LCompilersException("visit_ListItem() not implemented"); }
        void visit_TupleItem(const TupleItem_t & /* x */) { throw LCompilersException("visit_TupleItem() not implemented"); }
        void visit_ListSection(const ListSection_t & /* x */) { throw LCompilersException("visit_ListSection() not implemented"); }
        void visit_ListRepeat(const ListRepeat_t & /* x */) { throw LCompilersException("visit_ListRepeat() not implemented"); }
        void visit_DictPop(const DictPop_t & /* x */) { throw LCompilersException("visit_DictPop() not implemented"); }
        void visit_SetPop(const SetPop_t & /* x */) { throw LCompilersException("visit_SetPop() not implemented"); }
        void visit_IntegerBitLen(const IntegerBitLen_t & /* x */) { throw LCompilersException("visit_IntegerBitLen() not implemented"); }
        void visit_Ichar(const Ichar_t & /* x */) { throw LCompilersException("visit_Ichar() not implemented"); }
        void visit_Iachar(const Iachar_t & /* x */) { throw LCompilersException("visit_Iachar() not implemented"); }
        void visit_SizeOfType(const SizeOfType_t & /* x */) { throw LCompilersException("visit_SizeOfType() not implemented"); }
        void visit_PointerNullConstant(const PointerNullConstant_t & /* x */) { throw LCompilersException("visit_PointerNullConstant() not implemented"); }
        void visit_PointerAssociated(const PointerAssociated_t & /* x */) { throw LCompilersException("visit_PointerAssociated() not implemented"); }
        void visit_RealSqrt(const RealSqrt_t & /* x */) { throw LCompilersException("visit_RealSqrt() not implemented"); }
    void visit_ttype(const ttype_t &b) { visit_ttype_t(b, self()); }
        void visit_Integer(const Integer_t & /* x */) { throw LCompilersException("visit_Integer() not implemented"); }
        void visit_UnsignedInteger(const UnsignedInteger_t & /* x */) { throw LCompilersException("visit_UnsignedInteger() not implemented"); }
        void visit_Real(const Real_t & /* x */) { throw LCompilersException("visit_Real() not implemented"); }
        void visit_Complex(const Complex_t & /* x */) { throw LCompilersException("visit_Complex() not implemented"); }
        void visit_Character(const Character_t & /* x */) { throw LCompilersException("visit_Character() not implemented"); }
        void visit_Logical(const Logical_t & /* x */) { throw LCompilersException("visit_Logical() not implemented"); }
        void visit_Set(const Set_t & /* x */) { throw LCompilersException("visit_Set() not implemented"); }
        void visit_List(const List_t & /* x */) { throw LCompilersException("visit_List() not implemented"); }
        void visit_Tuple(const Tuple_t & /* x */) { throw LCompilersException("visit_Tuple() not implemented"); }
        void visit_Struct(const Struct_t & /* x */) { throw LCompilersException("visit_Struct() not implemented"); }
        void visit_Enum(const Enum_t & /* x */) { throw LCompilersException("visit_Enum() not implemented"); }
        void visit_Union(const Union_t & /* x */) { throw LCompilersException("visit_Union() not implemented"); }
        void visit_Class(const Class_t & /* x */) { throw LCompilersException("visit_Class() not implemented"); }
        void visit_Dict(const Dict_t & /* x */) { throw LCompilersException("visit_Dict() not implemented"); }
        void visit_Pointer(const Pointer_t & /* x */) { throw LCompilersException("visit_Pointer() not implemented"); }
        void visit_Allocatable(const Allocatable_t & /* x */) { throw LCompilersException("visit_Allocatable() not implemented"); }
        void visit_CPtr(const CPtr_t & /* x */) { throw LCompilersException("visit_CPtr() not implemented"); }
        void visit_SymbolicExpression(const SymbolicExpression_t & /* x */) { throw LCompilersException("visit_SymbolicExpression() not implemented"); }
        void visit_TypeParameter(const TypeParameter_t & /* x */) { throw LCompilersException("visit_TypeParameter() not implemented"); }
        void visit_Array(const Array_t & /* x */) { throw LCompilersException("visit_Array() not implemented"); }
        void visit_FunctionType(const FunctionType_t & /* x */) { throw LCompilersException("visit_FunctionType() not implemented"); }
    void visit_attribute(const attribute_t &b) { visit_attribute_t(b, self()); }
        void visit_Attribute(const Attribute_t & /* x */) { throw LCompilersException("visit_Attribute() not implemented"); }
    void visit_tbind(const tbind_t &b) { visit_tbind_t(b, self()); }
        void visit_Bind(const Bind_t & /* x */) { throw LCompilersException("visit_Bind() not implemented"); }
    void visit_case_stmt(const case_stmt_t &b) { visit_case_stmt_t(b, self()); }
        void visit_CaseStmt(const CaseStmt_t & /* x */) { throw LCompilersException("visit_CaseStmt() not implemented"); }
        void visit_CaseStmt_Range(const CaseStmt_Range_t & /* x */) { throw LCompilersException("visit_CaseStmt_Range() not implemented"); }
    void visit_type_stmt(const type_stmt_t &b) { visit_type_stmt_t(b, self()); }
        void visit_TypeStmtName(const TypeStmtName_t & /* x */) { throw LCompilersException("visit_TypeStmtName() not implemented"); }
        void visit_ClassStmt(const ClassStmt_t & /* x */) { throw LCompilersException("visit_ClassStmt() not implemented"); }
        void visit_TypeStmtType(const TypeStmtType_t & /* x */) { throw LCompilersException("visit_TypeStmtType() not implemented"); }
    void visit_require_instantiation(const require_instantiation_t &b) { visit_require_instantiation_t(b, self()); }
        void visit_Require(const Require_t & /* x */) { throw LCompilersException("visit_Require() not implemented"); }
};


/******************************************************************************/
// Walk Visitor base class

template <class Struct>
class BaseWalkVisitor : public BaseVisitor<Struct>
{
private:
    Struct& self() { return static_cast<Struct&>(*this); }
public:
    void visit_TranslationUnit(const TranslationUnit_t &x) {
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
    }
    void visit_Program(const Program_t &x) {
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_Module(const Module_t &x) {
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
    }
    void visit_Function(const Function_t &x) {
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
        self().visit_ttype(*x.m_function_signature);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        if (x.m_return_var)
            self().visit_expr(*x.m_return_var);
    }
    void visit_GenericProcedure(const GenericProcedure_t &x) {
        for (size_t i=0; i<x.n_procs; i++) {
        }
    }
    void visit_CustomOperator(const CustomOperator_t &x) {
        for (size_t i=0; i<x.n_procs; i++) {
        }
    }
    void visit_ExternalSymbol(const ExternalSymbol_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StructType(const StructType_t &x) {
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
        for (size_t i=0; i<x.n_initializers; i++) {
            self().visit_call_arg(x.m_initializers[i]);
        }
        if (x.m_alignment)
            self().visit_expr(*x.m_alignment);
    }
    void visit_EnumType(const EnumType_t &x) {
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
        self().visit_ttype(*x.m_type);
    }
    void visit_UnionType(const UnionType_t &x) {
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
        for (size_t i=0; i<x.n_initializers; i++) {
            self().visit_call_arg(x.m_initializers[i]);
        }
    }
    void visit_Variable(const Variable_t &x) {
        if (x.m_symbolic_value)
            self().visit_expr(*x.m_symbolic_value);
        if (x.m_value)
            self().visit_expr(*x.m_value);
        self().visit_ttype(*x.m_type);
    }
    void visit_ClassType(const ClassType_t &x) {
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
    }
    void visit_ClassProcedure(const ClassProcedure_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AssociateBlock(const AssociateBlock_t &x) {
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_Block(const Block_t &x) {
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_Requirement(const Requirement_t &x) {
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
        for (size_t i=0; i<x.n_requires; i++) {
            self().visit_require_instantiation(*x.m_requires[i]);
        }
    }
    void visit_Template(const Template_t &x) {
        for (auto &a : x.m_symtab->get_scope()) {
            this->visit_symbol(*a.second);
        }
        for (size_t i=0; i<x.n_requires; i++) {
            self().visit_require_instantiation(*x.m_requires[i]);
        }
    }
    void visit_Allocate(const Allocate_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_alloc_arg(x.m_args[i]);
        }
        if (x.m_stat)
            self().visit_expr(*x.m_stat);
        if (x.m_errmsg)
            self().visit_expr(*x.m_errmsg);
        if (x.m_source)
            self().visit_expr(*x.m_source);
    }
    void visit_ReAlloc(const ReAlloc_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_alloc_arg(x.m_args[i]);
        }
    }
    void visit_Assign(const Assign_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Assignment(const Assignment_t &x) {
        self().visit_expr(*x.m_target);
        self().visit_expr(*x.m_value);
        if (x.m_overloaded)
            self().visit_stmt(*x.m_overloaded);
    }
    void visit_Associate(const Associate_t &x) {
        self().visit_expr(*x.m_target);
        self().visit_expr(*x.m_value);
    }
    void visit_Cycle(const Cycle_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ExplicitDeallocate(const ExplicitDeallocate_t &x) {
        for (size_t i=0; i<x.n_vars; i++) {
            self().visit_expr(*x.m_vars[i]);
        }
    }
    void visit_ImplicitDeallocate(const ImplicitDeallocate_t &x) {
        for (size_t i=0; i<x.n_vars; i++) {
            self().visit_expr(*x.m_vars[i]);
        }
    }
    void visit_DoConcurrentLoop(const DoConcurrentLoop_t &x) {
        self().visit_do_loop_head(x.m_head);
        for (size_t i=0; i<x.n_shared; i++) {
            self().visit_expr(*x.m_shared[i]);
        }
        for (size_t i=0; i<x.n_local; i++) {
            self().visit_expr(*x.m_local[i]);
        }
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_DoLoop(const DoLoop_t &x) {
        self().visit_do_loop_head(x.m_head);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        for (size_t i=0; i<x.n_orelse; i++) {
            self().visit_stmt(*x.m_orelse[i]);
        }
    }
    void visit_ErrorStop(const ErrorStop_t &x) {
        if (x.m_code)
            self().visit_expr(*x.m_code);
    }
    void visit_Exit(const Exit_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ForAllSingle(const ForAllSingle_t &x) {
        self().visit_do_loop_head(x.m_head);
        self().visit_stmt(*x.m_assign_stmt);
    }
    void visit_GoTo(const GoTo_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_GoToTarget(const GoToTarget_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_If(const If_t &x) {
        self().visit_expr(*x.m_test);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        for (size_t i=0; i<x.n_orelse; i++) {
            self().visit_stmt(*x.m_orelse[i]);
        }
    }
    void visit_IfArithmetic(const IfArithmetic_t &x) {
        self().visit_expr(*x.m_test);
    }
    void visit_Print(const Print_t &x) {
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
        }
        if (x.m_separator)
            self().visit_expr(*x.m_separator);
        if (x.m_end)
            self().visit_expr(*x.m_end);
    }
    void visit_FileOpen(const FileOpen_t &x) {
        if (x.m_newunit)
            self().visit_expr(*x.m_newunit);
        if (x.m_filename)
            self().visit_expr(*x.m_filename);
        if (x.m_status)
            self().visit_expr(*x.m_status);
        if (x.m_form)
            self().visit_expr(*x.m_form);
    }
    void visit_FileClose(const FileClose_t &x) {
        if (x.m_unit)
            self().visit_expr(*x.m_unit);
        if (x.m_iostat)
            self().visit_expr(*x.m_iostat);
        if (x.m_iomsg)
            self().visit_expr(*x.m_iomsg);
        if (x.m_err)
            self().visit_expr(*x.m_err);
        if (x.m_status)
            self().visit_expr(*x.m_status);
    }
    void visit_FileRead(const FileRead_t &x) {
        if (x.m_unit)
            self().visit_expr(*x.m_unit);
        if (x.m_fmt)
            self().visit_expr(*x.m_fmt);
        if (x.m_iomsg)
            self().visit_expr(*x.m_iomsg);
        if (x.m_iostat)
            self().visit_expr(*x.m_iostat);
        if (x.m_size)
            self().visit_expr(*x.m_size);
        if (x.m_id)
            self().visit_expr(*x.m_id);
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
        }
        if (x.m_overloaded)
            self().visit_stmt(*x.m_overloaded);
    }
    void visit_FileBackspace(const FileBackspace_t &x) {
        if (x.m_unit)
            self().visit_expr(*x.m_unit);
        if (x.m_iostat)
            self().visit_expr(*x.m_iostat);
        if (x.m_err)
            self().visit_expr(*x.m_err);
    }
    void visit_FileRewind(const FileRewind_t &x) {
        if (x.m_unit)
            self().visit_expr(*x.m_unit);
        if (x.m_iostat)
            self().visit_expr(*x.m_iostat);
        if (x.m_err)
            self().visit_expr(*x.m_err);
    }
    void visit_FileInquire(const FileInquire_t &x) {
        if (x.m_unit)
            self().visit_expr(*x.m_unit);
        if (x.m_file)
            self().visit_expr(*x.m_file);
        if (x.m_iostat)
            self().visit_expr(*x.m_iostat);
        if (x.m_err)
            self().visit_expr(*x.m_err);
        if (x.m_exist)
            self().visit_expr(*x.m_exist);
        if (x.m_opened)
            self().visit_expr(*x.m_opened);
        if (x.m_number)
            self().visit_expr(*x.m_number);
        if (x.m_named)
            self().visit_expr(*x.m_named);
        if (x.m_name)
            self().visit_expr(*x.m_name);
        if (x.m_access)
            self().visit_expr(*x.m_access);
        if (x.m_sequential)
            self().visit_expr(*x.m_sequential);
        if (x.m_direct)
            self().visit_expr(*x.m_direct);
        if (x.m_form)
            self().visit_expr(*x.m_form);
        if (x.m_formatted)
            self().visit_expr(*x.m_formatted);
        if (x.m_unformatted)
            self().visit_expr(*x.m_unformatted);
        if (x.m_recl)
            self().visit_expr(*x.m_recl);
        if (x.m_nextrec)
            self().visit_expr(*x.m_nextrec);
        if (x.m_blank)
            self().visit_expr(*x.m_blank);
        if (x.m_position)
            self().visit_expr(*x.m_position);
        if (x.m_action)
            self().visit_expr(*x.m_action);
        if (x.m_read)
            self().visit_expr(*x.m_read);
        if (x.m_write)
            self().visit_expr(*x.m_write);
        if (x.m_readwrite)
            self().visit_expr(*x.m_readwrite);
        if (x.m_delim)
            self().visit_expr(*x.m_delim);
        if (x.m_pad)
            self().visit_expr(*x.m_pad);
        if (x.m_flen)
            self().visit_expr(*x.m_flen);
        if (x.m_blocksize)
            self().visit_expr(*x.m_blocksize);
        if (x.m_convert)
            self().visit_expr(*x.m_convert);
        if (x.m_carriagecontrol)
            self().visit_expr(*x.m_carriagecontrol);
        if (x.m_iolength)
            self().visit_expr(*x.m_iolength);
    }
    void visit_FileWrite(const FileWrite_t &x) {
        if (x.m_unit)
            self().visit_expr(*x.m_unit);
        if (x.m_iomsg)
            self().visit_expr(*x.m_iomsg);
        if (x.m_iostat)
            self().visit_expr(*x.m_iostat);
        if (x.m_id)
            self().visit_expr(*x.m_id);
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
        }
        if (x.m_separator)
            self().visit_expr(*x.m_separator);
        if (x.m_end)
            self().visit_expr(*x.m_end);
        if (x.m_overloaded)
            self().visit_stmt(*x.m_overloaded);
    }
    void visit_Return(const Return_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Select(const Select_t &x) {
        self().visit_expr(*x.m_test);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_case_stmt(*x.m_body[i]);
        }
        for (size_t i=0; i<x.n_default; i++) {
            self().visit_stmt(*x.m_default[i]);
        }
    }
    void visit_Stop(const Stop_t &x) {
        if (x.m_code)
            self().visit_expr(*x.m_code);
    }
    void visit_Assert(const Assert_t &x) {
        self().visit_expr(*x.m_test);
        if (x.m_msg)
            self().visit_expr(*x.m_msg);
    }
    void visit_SubroutineCall(const SubroutineCall_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_call_arg(x.m_args[i]);
        }
        if (x.m_dt)
            self().visit_expr(*x.m_dt);
    }
    void visit_IntrinsicImpureSubroutine(const IntrinsicImpureSubroutine_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
    }
    void visit_Where(const Where_t &x) {
        self().visit_expr(*x.m_test);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        for (size_t i=0; i<x.n_orelse; i++) {
            self().visit_stmt(*x.m_orelse[i]);
        }
    }
    void visit_WhileLoop(const WhileLoop_t &x) {
        self().visit_expr(*x.m_test);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
        for (size_t i=0; i<x.n_orelse; i++) {
            self().visit_stmt(*x.m_orelse[i]);
        }
    }
    void visit_Nullify(const Nullify_t &x) {
        for (size_t i=0; i<x.n_vars; i++) {
        }
    }
    void visit_Flush(const Flush_t &x) {
        self().visit_expr(*x.m_unit);
        if (x.m_err)
            self().visit_expr(*x.m_err);
        if (x.m_iomsg)
            self().visit_expr(*x.m_iomsg);
        if (x.m_iostat)
            self().visit_expr(*x.m_iostat);
    }
    void visit_ListAppend(const ListAppend_t &x) {
        self().visit_expr(*x.m_a);
        self().visit_expr(*x.m_ele);
    }
    void visit_AssociateBlockCall(const AssociateBlockCall_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SelectType(const SelectType_t &x) {
        self().visit_expr(*x.m_selector);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_type_stmt(*x.m_body[i]);
        }
        for (size_t i=0; i<x.n_default; i++) {
            self().visit_stmt(*x.m_default[i]);
        }
    }
    void visit_CPtrToPointer(const CPtrToPointer_t &x) {
        self().visit_expr(*x.m_cptr);
        self().visit_expr(*x.m_ptr);
        if (x.m_shape)
            self().visit_expr(*x.m_shape);
        if (x.m_lower_bounds)
            self().visit_expr(*x.m_lower_bounds);
    }
    void visit_BlockCall(const BlockCall_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SetInsert(const SetInsert_t &x) {
        self().visit_expr(*x.m_a);
        self().visit_expr(*x.m_ele);
    }
    void visit_SetRemove(const SetRemove_t &x) {
        self().visit_expr(*x.m_a);
        self().visit_expr(*x.m_ele);
    }
    void visit_ListInsert(const ListInsert_t &x) {
        self().visit_expr(*x.m_a);
        self().visit_expr(*x.m_pos);
        self().visit_expr(*x.m_ele);
    }
    void visit_ListRemove(const ListRemove_t &x) {
        self().visit_expr(*x.m_a);
        self().visit_expr(*x.m_ele);
    }
    void visit_ListClear(const ListClear_t &x) {
        self().visit_expr(*x.m_a);
    }
    void visit_DictInsert(const DictInsert_t &x) {
        self().visit_expr(*x.m_a);
        self().visit_expr(*x.m_key);
        self().visit_expr(*x.m_value);
    }
    void visit_Expr(const Expr_t &x) {
        self().visit_expr(*x.m_expression);
    }
    void visit_IfExp(const IfExp_t &x) {
        self().visit_expr(*x.m_test);
        self().visit_expr(*x.m_body);
        self().visit_expr(*x.m_orelse);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ComplexConstructor(const ComplexConstructor_t &x) {
        self().visit_expr(*x.m_re);
        self().visit_expr(*x.m_im);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_NamedExpr(const NamedExpr_t &x) {
        self().visit_expr(*x.m_target);
        self().visit_expr(*x.m_value);
        self().visit_ttype(*x.m_type);
    }
    void visit_FunctionCall(const FunctionCall_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_call_arg(x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
        if (x.m_dt)
            self().visit_expr(*x.m_dt);
    }
    void visit_IntrinsicElementalFunction(const IntrinsicElementalFunction_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        if (x.m_type)
            self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_IntrinsicArrayFunction(const IntrinsicArrayFunction_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        if (x.m_type)
            self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_IntrinsicImpureFunction(const IntrinsicImpureFunction_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        if (x.m_type)
            self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_TypeInquiry(const TypeInquiry_t &x) {
        self().visit_ttype(*x.m_arg_type);
        if (x.m_arg)
            self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        self().visit_expr(*x.m_value);
    }
    void visit_StructTypeConstructor(const StructTypeConstructor_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_call_arg(x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_EnumTypeConstructor(const EnumTypeConstructor_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_UnionTypeConstructor(const UnionTypeConstructor_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ImpliedDoLoop(const ImpliedDoLoop_t &x) {
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
        }
        self().visit_expr(*x.m_var);
        self().visit_expr(*x.m_start);
        self().visit_expr(*x.m_end);
        if (x.m_increment)
            self().visit_expr(*x.m_increment);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_IntegerConstant(const IntegerConstant_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_IntegerBOZ(const IntegerBOZ_t &x) {
        if (x.m_type)
            self().visit_ttype(*x.m_type);
    }
    void visit_IntegerBitNot(const IntegerBitNot_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_IntegerUnaryMinus(const IntegerUnaryMinus_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_IntegerCompare(const IntegerCompare_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_IntegerBinOp(const IntegerBinOp_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_UnsignedIntegerConstant(const UnsignedIntegerConstant_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_UnsignedIntegerUnaryMinus(const UnsignedIntegerUnaryMinus_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_UnsignedIntegerBitNot(const UnsignedIntegerBitNot_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_UnsignedIntegerCompare(const UnsignedIntegerCompare_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_UnsignedIntegerBinOp(const UnsignedIntegerBinOp_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_RealConstant(const RealConstant_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_RealUnaryMinus(const RealUnaryMinus_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_RealCompare(const RealCompare_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_RealBinOp(const RealBinOp_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_RealCopySign(const RealCopySign_t &x) {
        self().visit_expr(*x.m_target);
        self().visit_expr(*x.m_source);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ComplexConstant(const ComplexConstant_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_ComplexUnaryMinus(const ComplexUnaryMinus_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ComplexCompare(const ComplexCompare_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ComplexBinOp(const ComplexBinOp_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_LogicalConstant(const LogicalConstant_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_LogicalNot(const LogicalNot_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_LogicalCompare(const LogicalCompare_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_LogicalBinOp(const LogicalBinOp_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ListConstant(const ListConstant_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
    }
    void visit_ListLen(const ListLen_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ListConcat(const ListConcat_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ListCompare(const ListCompare_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ListCount(const ListCount_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_expr(*x.m_ele);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_SetConstant(const SetConstant_t &x) {
        for (size_t i=0; i<x.n_elements; i++) {
            self().visit_expr(*x.m_elements[i]);
        }
        self().visit_ttype(*x.m_type);
    }
    void visit_SetLen(const SetLen_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_TupleConstant(const TupleConstant_t &x) {
        for (size_t i=0; i<x.n_elements; i++) {
            self().visit_expr(*x.m_elements[i]);
        }
        self().visit_ttype(*x.m_type);
    }
    void visit_TupleLen(const TupleLen_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        self().visit_expr(*x.m_value);
    }
    void visit_TupleCompare(const TupleCompare_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_TupleConcat(const TupleConcat_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_StringConstant(const StringConstant_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_StringConcat(const StringConcat_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_StringRepeat(const StringRepeat_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_StringLen(const StringLen_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_StringItem(const StringItem_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_expr(*x.m_idx);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_StringSection(const StringSection_t &x) {
        self().visit_expr(*x.m_arg);
        if (x.m_start)
            self().visit_expr(*x.m_start);
        if (x.m_end)
            self().visit_expr(*x.m_end);
        if (x.m_step)
            self().visit_expr(*x.m_step);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_StringCompare(const StringCompare_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_StringOrd(const StringOrd_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_StringChr(const StringChr_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_StringFormat(const StringFormat_t &x) {
        self().visit_expr(*x.m_fmt);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_CPtrCompare(const CPtrCompare_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_SymbolicCompare(const SymbolicCompare_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_DictConstant(const DictConstant_t &x) {
        for (size_t i=0; i<x.n_keys; i++) {
            self().visit_expr(*x.m_keys[i]);
        }
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
        }
        self().visit_ttype(*x.m_type);
    }
    void visit_DictLen(const DictLen_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_Var(const Var_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_FunctionParam(const FunctionParam_t &x) {
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ArrayConstructor(const ArrayConstructor_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ArrayConstant(const ArrayConstant_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_ArrayItem(const ArrayItem_t &x) {
        self().visit_expr(*x.m_v);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_array_index(x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ArraySection(const ArraySection_t &x) {
        self().visit_expr(*x.m_v);
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_array_index(x.m_args[i]);
        }
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ArraySize(const ArraySize_t &x) {
        self().visit_expr(*x.m_v);
        if (x.m_dim)
            self().visit_expr(*x.m_dim);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ArrayBound(const ArrayBound_t &x) {
        self().visit_expr(*x.m_v);
        if (x.m_dim)
            self().visit_expr(*x.m_dim);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ArrayTranspose(const ArrayTranspose_t &x) {
        self().visit_expr(*x.m_matrix);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ArrayPack(const ArrayPack_t &x) {
        self().visit_expr(*x.m_array);
        self().visit_expr(*x.m_mask);
        if (x.m_vector)
            self().visit_expr(*x.m_vector);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ArrayReshape(const ArrayReshape_t &x) {
        self().visit_expr(*x.m_array);
        self().visit_expr(*x.m_shape);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ArrayBroadcast(const ArrayBroadcast_t &x) {
        self().visit_expr(*x.m_array);
        self().visit_expr(*x.m_shape);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_BitCast(const BitCast_t &x) {
        self().visit_expr(*x.m_source);
        self().visit_expr(*x.m_mold);
        if (x.m_size)
            self().visit_expr(*x.m_size);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_StructInstanceMember(const StructInstanceMember_t &x) {
        self().visit_expr(*x.m_v);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_StructStaticMember(const StructStaticMember_t &x) {
        self().visit_expr(*x.m_v);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_EnumStaticMember(const EnumStaticMember_t &x) {
        self().visit_expr(*x.m_v);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_UnionInstanceMember(const UnionInstanceMember_t &x) {
        self().visit_expr(*x.m_v);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_EnumName(const EnumName_t &x) {
        self().visit_expr(*x.m_v);
        self().visit_ttype(*x.m_enum_type);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_EnumValue(const EnumValue_t &x) {
        self().visit_expr(*x.m_v);
        self().visit_ttype(*x.m_enum_type);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_OverloadedCompare(const OverloadedCompare_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
        self().visit_expr(*x.m_overloaded);
    }
    void visit_OverloadedBinOp(const OverloadedBinOp_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
        self().visit_expr(*x.m_overloaded);
    }
    void visit_OverloadedUnaryMinus(const OverloadedUnaryMinus_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
        self().visit_expr(*x.m_overloaded);
    }
    void visit_OverloadedStringConcat(const OverloadedStringConcat_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
        self().visit_expr(*x.m_overloaded);
    }
    void visit_Cast(const Cast_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ArrayPhysicalCast(const ArrayPhysicalCast_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ComplexRe(const ComplexRe_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ComplexIm(const ComplexIm_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_DictItem(const DictItem_t &x) {
        self().visit_expr(*x.m_a);
        self().visit_expr(*x.m_key);
        if (x.m_default)
            self().visit_expr(*x.m_default);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_CLoc(const CLoc_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_PointerToCPtr(const PointerToCPtr_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_GetPointer(const GetPointer_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ListItem(const ListItem_t &x) {
        self().visit_expr(*x.m_a);
        self().visit_expr(*x.m_pos);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_TupleItem(const TupleItem_t &x) {
        self().visit_expr(*x.m_a);
        self().visit_expr(*x.m_pos);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ListSection(const ListSection_t &x) {
        self().visit_expr(*x.m_a);
        self().visit_array_index(x.m_section);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_ListRepeat(const ListRepeat_t &x) {
        self().visit_expr(*x.m_left);
        self().visit_expr(*x.m_right);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_DictPop(const DictPop_t &x) {
        self().visit_expr(*x.m_a);
        self().visit_expr(*x.m_key);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_SetPop(const SetPop_t &x) {
        self().visit_expr(*x.m_a);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_IntegerBitLen(const IntegerBitLen_t &x) {
        self().visit_expr(*x.m_a);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_Ichar(const Ichar_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_Iachar(const Iachar_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_SizeOfType(const SizeOfType_t &x) {
        self().visit_ttype(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_PointerNullConstant(const PointerNullConstant_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_PointerAssociated(const PointerAssociated_t &x) {
        self().visit_expr(*x.m_ptr);
        if (x.m_tgt)
            self().visit_expr(*x.m_tgt);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_RealSqrt(const RealSqrt_t &x) {
        self().visit_expr(*x.m_arg);
        self().visit_ttype(*x.m_type);
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_Integer(const Integer_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UnsignedInteger(const UnsignedInteger_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Real(const Real_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Complex(const Complex_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Character(const Character_t &x) {
        if (x.m_len_expr)
            self().visit_expr(*x.m_len_expr);
    }
    void visit_Logical(const Logical_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Set(const Set_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_List(const List_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_Tuple(const Tuple_t &x) {
        for (size_t i=0; i<x.n_type; i++) {
            self().visit_ttype(*x.m_type[i]);
        }
    }
    void visit_Struct(const Struct_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Enum(const Enum_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Union(const Union_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Class(const Class_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Dict(const Dict_t &x) {
        self().visit_ttype(*x.m_key_type);
        self().visit_ttype(*x.m_value_type);
    }
    void visit_Pointer(const Pointer_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_Allocatable(const Allocatable_t &x) {
        self().visit_ttype(*x.m_type);
    }
    void visit_CPtr(const CPtr_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SymbolicExpression(const SymbolicExpression_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_TypeParameter(const TypeParameter_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Array(const Array_t &x) {
        self().visit_ttype(*x.m_type);
        for (size_t i=0; i<x.n_dims; i++) {
            self().visit_dimension(x.m_dims[i]);
        }
    }
    void visit_FunctionType(const FunctionType_t &x) {
        for (size_t i=0; i<x.n_arg_types; i++) {
            self().visit_ttype(*x.m_arg_types[i]);
        }
        if (x.m_return_var_type)
            self().visit_ttype(*x.m_return_var_type);
        for (size_t i=0; i<x.n_restrictions; i++) {
        }
    }
    void visit_dimension(const dimension_t &x) {
        if (x.m_start)
            self().visit_expr(*x.m_start);
        if (x.m_length)
            self().visit_expr(*x.m_length);
    }
    void visit_alloc_arg(const alloc_arg_t &x) {
        self().visit_expr(*x.m_a);
        for (size_t i=0; i<x.n_dims; i++) {
            self().visit_dimension(x.m_dims[i]);
        }
        if (x.m_len_expr)
            self().visit_expr(*x.m_len_expr);
        if (x.m_type)
            self().visit_ttype(*x.m_type);
    }
    void visit_Attribute(const Attribute_t &x) {
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_attribute_arg(x.m_args[i]);
        }
    }
    void visit_attribute_arg(const attribute_arg_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_call_arg(const call_arg_t &x) {
        if (x.m_value)
            self().visit_expr(*x.m_value);
    }
    void visit_Bind(const Bind_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_array_index(const array_index_t &x) {
        if (x.m_left)
            self().visit_expr(*x.m_left);
        if (x.m_right)
            self().visit_expr(*x.m_right);
        if (x.m_step)
            self().visit_expr(*x.m_step);
    }
    void visit_do_loop_head(const do_loop_head_t &x) {
        if (x.m_v)
            self().visit_expr(*x.m_v);
        if (x.m_start)
            self().visit_expr(*x.m_start);
        if (x.m_end)
            self().visit_expr(*x.m_end);
        if (x.m_increment)
            self().visit_expr(*x.m_increment);
    }
    void visit_CaseStmt(const CaseStmt_t &x) {
        for (size_t i=0; i<x.n_test; i++) {
            self().visit_expr(*x.m_test[i]);
        }
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_CaseStmt_Range(const CaseStmt_Range_t &x) {
        if (x.m_start)
            self().visit_expr(*x.m_start);
        if (x.m_end)
            self().visit_expr(*x.m_end);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_TypeStmtName(const TypeStmtName_t &x) {
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_ClassStmt(const ClassStmt_t &x) {
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_TypeStmtType(const TypeStmtType_t &x) {
        self().visit_ttype(*x.m_type);
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
        }
    }
    void visit_Require(const Require_t &x) {
        if ((bool&)x) { } // Suppress unused warning
    }
};


/******************************************************************************/
// Tree Visitor base class

template <class Struct>
class TreeBaseVisitor : public BaseVisitor<Struct>
{
private:
    Struct& self() { return static_cast<Struct&>(*this); }
public:
    std::string s, indtd;
    bool use_colors;
    bool start_line = true;
    bool last, attached;
    int indent_level = 0, indent_spaces = 2, lvl = 0;
public:
    TreeBaseVisitor() : use_colors(false), last(true), attached(false) { s.reserve(100000); }
    void inc_indent() {
        indent_level++;
        indtd += "  ";
    }
    void inc_lindent() {
        indent_level++;
        indtd += "| ";
    }
    void dec_indent() {
        indent_level--;
        LCOMPILERS_ASSERT(indent_level >= 0);
        indtd = indtd.substr(0, indent_level*indent_spaces);
    }
    void visit_TranslationUnit(const TranslationUnit_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TranslationUnit");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-");
        inc_lindent();
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        s.append("\n" + indtd + "|-counter=");
        s.append(x.m_symtab->get_counter());
        size_t i = 0;
        s.append("\n" + indtd + "└-scope=↧");
        for (auto &a : x.m_symtab->get_scope()) {
            i++;
            inc_indent();
            last = i == x.m_symtab->get_scope().size();
            s.append("\n" + indtd + (last ? "└-" : "|-") + a.first + ": ");
            this->visit_symbol(*a.second);
            dec_indent();
        }
        dec_indent();
        s.append("\n" + indtd + "└-" + "items=↧");
        attached = false;
        for (size_t i=0; i<x.n_items; i++) {
            inc_indent();
            last = i == x.n_items-1;
            attached = false;
            self().visit_asr(*x.m_items[i]);
            dec_indent();
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Program(const Program_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Program");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-");
        inc_lindent();
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        s.append("\n" + indtd + "|-counter=");
        s.append(x.m_symtab->get_counter());
        size_t i = 0;
        s.append("\n" + indtd + "└-scope=↧");
        for (auto &a : x.m_symtab->get_scope()) {
            i++;
            inc_indent();
            last = i == x.m_symtab->get_scope().size();
            s.append("\n" + indtd + (last ? "└-" : "|-") + a.first + ": ");
            this->visit_symbol(*a.second);
            dec_indent();
        }
        dec_indent();
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "dependencies=");
        for (size_t i=0; i<x.n_dependencies; i++) {
            s.append(x.m_dependencies[i]);
            if (i < x.n_dependencies-1) s.append(" ");
        }
        s.append("\n" + indtd + "└-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_indent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_Module(const Module_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Module");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-");
        inc_lindent();
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        s.append("\n" + indtd + "|-counter=");
        s.append(x.m_symtab->get_counter());
        size_t i = 0;
        s.append("\n" + indtd + "└-scope=↧");
        for (auto &a : x.m_symtab->get_scope()) {
            i++;
            inc_indent();
            last = i == x.m_symtab->get_scope().size();
            s.append("\n" + indtd + (last ? "└-" : "|-") + a.first + ": ");
            this->visit_symbol(*a.second);
            dec_indent();
        }
        dec_indent();
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "dependencies=");
        for (size_t i=0; i<x.n_dependencies; i++) {
            s.append(x.m_dependencies[i]);
            if (i < x.n_dependencies-1) s.append(" ");
        }
        s.append("\n" + indtd + "|-" + "loaded_from_mod=");
        if (x.m_loaded_from_mod) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "└-" + "intrinsic=");
        if (x.m_intrinsic) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Function(const Function_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Function");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-");
        inc_lindent();
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        s.append("\n" + indtd + "|-counter=");
        s.append(x.m_symtab->get_counter());
        size_t i = 0;
        s.append("\n" + indtd + "└-scope=↧");
        for (auto &a : x.m_symtab->get_scope()) {
            i++;
            inc_indent();
            last = i == x.m_symtab->get_scope().size();
            s.append("\n" + indtd + (last ? "└-" : "|-") + a.first + ": ");
            this->visit_symbol(*a.second);
            dec_indent();
        }
        dec_indent();
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "function_signature=");
        attached = true;
        self().visit_ttype(*x.m_function_signature);
        s.append("\n" + indtd + "|-" + "dependencies=");
        for (size_t i=0; i<x.n_dependencies; i++) {
            s.append(x.m_dependencies[i]);
            if (i < x.n_dependencies-1) s.append(" ");
        }
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_expr(*x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "return_var=");
        if (x.m_return_var) {
            self().visit_expr(*x.m_return_var);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "accessType=");
        visit_accessType(x.m_access);
        s.append("\n" + indtd + "|-" + "deterministic=");
        if (x.m_deterministic) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "|-" + "side_effect_free=");
        if (x.m_side_effect_free) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "└-" + "module_file=");
        if (x.m_module_file) {
            s.append("\"" + std::string(x.m_module_file) + "\"");
        } else {
            s.append("()");
        }
        dec_indent();
    }
    void visit_GenericProcedure(const GenericProcedure_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("GenericProcedure");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "parent_symtab=");
        s.append(x.m_parent_symtab->get_counter());
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "procs=↧");
        for (size_t i=0; i<x.n_procs; i++) {
            inc_lindent();
            last = i == x.n_procs-1;
            attached = false;
            self().visit_symbol(*x.m_procs[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "accessType=");
        visit_accessType(x.m_access);
        dec_indent();
    }
    void visit_CustomOperator(const CustomOperator_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CustomOperator");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "parent_symtab=");
        s.append(x.m_parent_symtab->get_counter());
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "procs=↧");
        for (size_t i=0; i<x.n_procs; i++) {
            inc_lindent();
            last = i == x.n_procs-1;
            attached = false;
            self().visit_symbol(*x.m_procs[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "accessType=");
        visit_accessType(x.m_access);
        dec_indent();
    }
    void visit_ExternalSymbol(const ExternalSymbol_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ExternalSymbol");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "parent_symtab=");
        s.append(x.m_parent_symtab->get_counter());
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "external=");
        attached = true;
        self().visit_symbol(*x.m_external);
        s.append("\n" + indtd + "|-" + "module_name=");
        s.append(x.m_module_name);
        s.append("\n" + indtd + "|-" + "scope_names=");
        for (size_t i=0; i<x.n_scope_names; i++) {
            s.append(x.m_scope_names[i]);
            if (i < x.n_scope_names-1) s.append(" ");
        }
        s.append("\n" + indtd + "|-" + "original_name=");
        s.append(x.m_original_name);
        s.append("\n" + indtd + "└-" + "accessType=");
        visit_accessType(x.m_access);
        dec_indent();
    }
    void visit_StructType(const StructType_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StructType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-");
        inc_lindent();
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        s.append("\n" + indtd + "|-counter=");
        s.append(x.m_symtab->get_counter());
        size_t i = 0;
        s.append("\n" + indtd + "└-scope=↧");
        for (auto &a : x.m_symtab->get_scope()) {
            i++;
            inc_indent();
            last = i == x.m_symtab->get_scope().size();
            s.append("\n" + indtd + (last ? "└-" : "|-") + a.first + ": ");
            this->visit_symbol(*a.second);
            dec_indent();
        }
        dec_indent();
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "dependencies=");
        for (size_t i=0; i<x.n_dependencies; i++) {
            s.append(x.m_dependencies[i]);
            if (i < x.n_dependencies-1) s.append(" ");
        }
        s.append("\n" + indtd + "|-" + "members=");
        for (size_t i=0; i<x.n_members; i++) {
            s.append(x.m_members[i]);
            if (i < x.n_members-1) s.append(" ");
        }
        s.append("\n" + indtd + "|-" + "abiType=");
        visit_abiType(x.m_abi);
        s.append("\n" + indtd + "|-" + "accessType=");
        visit_accessType(x.m_access);
        s.append("\n" + indtd + "|-" + "is_packed=");
        if (x.m_is_packed) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "|-" + "is_abstract=");
        if (x.m_is_abstract) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "|-" + "initializers=↧");
        for (size_t i=0; i<x.n_initializers; i++) {
            inc_lindent();
            last = i == x.n_initializers-1;
            attached = false;
            self().visit_call_arg(x.m_initializers[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "alignment=");
        if (x.m_alignment) {
            self().visit_expr(*x.m_alignment);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "parent=");
        last = true;
        if (x.m_parent) {
            self().visit_symbol(*x.m_parent);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_EnumType(const EnumType_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("EnumType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-");
        inc_lindent();
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        s.append("\n" + indtd + "|-counter=");
        s.append(x.m_symtab->get_counter());
        size_t i = 0;
        s.append("\n" + indtd + "└-scope=↧");
        for (auto &a : x.m_symtab->get_scope()) {
            i++;
            inc_indent();
            last = i == x.m_symtab->get_scope().size();
            s.append("\n" + indtd + (last ? "└-" : "|-") + a.first + ": ");
            this->visit_symbol(*a.second);
            dec_indent();
        }
        dec_indent();
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "dependencies=");
        for (size_t i=0; i<x.n_dependencies; i++) {
            s.append(x.m_dependencies[i]);
            if (i < x.n_dependencies-1) s.append(" ");
        }
        s.append("\n" + indtd + "|-" + "members=");
        for (size_t i=0; i<x.n_members; i++) {
            s.append(x.m_members[i]);
            if (i < x.n_members-1) s.append(" ");
        }
        s.append("\n" + indtd + "|-" + "abiType=");
        visit_abiType(x.m_abi);
        s.append("\n" + indtd + "|-" + "accessType=");
        visit_accessType(x.m_access);
        s.append("\n" + indtd + "|-" + "enumtypeType=");
        visit_enumtypeType(x.m_enum_value_type);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "parent=");
        last = true;
        if (x.m_parent) {
            self().visit_symbol(*x.m_parent);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_UnionType(const UnionType_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnionType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-");
        inc_lindent();
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        s.append("\n" + indtd + "|-counter=");
        s.append(x.m_symtab->get_counter());
        size_t i = 0;
        s.append("\n" + indtd + "└-scope=↧");
        for (auto &a : x.m_symtab->get_scope()) {
            i++;
            inc_indent();
            last = i == x.m_symtab->get_scope().size();
            s.append("\n" + indtd + (last ? "└-" : "|-") + a.first + ": ");
            this->visit_symbol(*a.second);
            dec_indent();
        }
        dec_indent();
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "dependencies=");
        for (size_t i=0; i<x.n_dependencies; i++) {
            s.append(x.m_dependencies[i]);
            if (i < x.n_dependencies-1) s.append(" ");
        }
        s.append("\n" + indtd + "|-" + "members=");
        for (size_t i=0; i<x.n_members; i++) {
            s.append(x.m_members[i]);
            if (i < x.n_members-1) s.append(" ");
        }
        s.append("\n" + indtd + "|-" + "abiType=");
        visit_abiType(x.m_abi);
        s.append("\n" + indtd + "|-" + "accessType=");
        visit_accessType(x.m_access);
        s.append("\n" + indtd + "|-" + "initializers=↧");
        for (size_t i=0; i<x.n_initializers; i++) {
            inc_lindent();
            last = i == x.n_initializers-1;
            attached = false;
            self().visit_call_arg(x.m_initializers[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "parent=");
        last = true;
        if (x.m_parent) {
            self().visit_symbol(*x.m_parent);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Variable(const Variable_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Variable");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "parent_symtab=");
        s.append(x.m_parent_symtab->get_counter());
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "dependencies=");
        for (size_t i=0; i<x.n_dependencies; i++) {
            s.append(x.m_dependencies[i]);
            if (i < x.n_dependencies-1) s.append(" ");
        }
        s.append("\n" + indtd + "|-" + "intentType=");
        visit_intentType(x.m_intent);
        s.append("\n" + indtd + "|-" + "symbolic_value=");
        if (x.m_symbolic_value) {
            self().visit_expr(*x.m_symbolic_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "value=");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "storage_typeType=");
        visit_storage_typeType(x.m_storage);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "|-" + "type_declaration=");
        if (x.m_type_declaration) {
            self().visit_symbol(*x.m_type_declaration);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "abiType=");
        visit_abiType(x.m_abi);
        s.append("\n" + indtd + "|-" + "accessType=");
        visit_accessType(x.m_access);
        s.append("\n" + indtd + "|-" + "presenceType=");
        visit_presenceType(x.m_presence);
        s.append("\n" + indtd + "└-" + "value_attr=");
        if (x.m_value_attr) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        dec_indent();
    }
    void visit_ClassType(const ClassType_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ClassType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-");
        inc_lindent();
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        s.append("\n" + indtd + "|-counter=");
        s.append(x.m_symtab->get_counter());
        size_t i = 0;
        s.append("\n" + indtd + "└-scope=↧");
        for (auto &a : x.m_symtab->get_scope()) {
            i++;
            inc_indent();
            last = i == x.m_symtab->get_scope().size();
            s.append("\n" + indtd + (last ? "└-" : "|-") + a.first + ": ");
            this->visit_symbol(*a.second);
            dec_indent();
        }
        dec_indent();
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "abiType=");
        visit_abiType(x.m_abi);
        s.append("\n" + indtd + "└-" + "accessType=");
        visit_accessType(x.m_access);
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ClassProcedure(const ClassProcedure_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ClassProcedure");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "parent_symtab=");
        s.append(x.m_parent_symtab->get_counter());
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "self_argument=");
        if (x.m_self_argument) {
            s.append(x.m_self_argument);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "proc_name=");
        s.append(x.m_proc_name);
        s.append("\n" + indtd + "|-" + "proc=");
        attached = true;
        self().visit_symbol(*x.m_proc);
        s.append("\n" + indtd + "|-" + "abiType=");
        visit_abiType(x.m_abi);
        s.append("\n" + indtd + "|-" + "is_deferred=");
        if (x.m_is_deferred) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "└-" + "is_nopass=");
        if (x.m_is_nopass) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        dec_indent();
    }
    void visit_AssociateBlock(const AssociateBlock_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AssociateBlock");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-");
        inc_lindent();
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        s.append("\n" + indtd + "|-counter=");
        s.append(x.m_symtab->get_counter());
        size_t i = 0;
        s.append("\n" + indtd + "└-scope=↧");
        for (auto &a : x.m_symtab->get_scope()) {
            i++;
            inc_indent();
            last = i == x.m_symtab->get_scope().size();
            s.append("\n" + indtd + (last ? "└-" : "|-") + a.first + ": ");
            this->visit_symbol(*a.second);
            dec_indent();
        }
        dec_indent();
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "└-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_indent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_Block(const Block_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Block");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-");
        inc_lindent();
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        s.append("\n" + indtd + "|-counter=");
        s.append(x.m_symtab->get_counter());
        size_t i = 0;
        s.append("\n" + indtd + "└-scope=↧");
        for (auto &a : x.m_symtab->get_scope()) {
            i++;
            inc_indent();
            last = i == x.m_symtab->get_scope().size();
            s.append("\n" + indtd + (last ? "└-" : "|-") + a.first + ": ");
            this->visit_symbol(*a.second);
            dec_indent();
        }
        dec_indent();
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "└-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_indent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_Requirement(const Requirement_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Requirement");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-");
        inc_lindent();
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        s.append("\n" + indtd + "|-counter=");
        s.append(x.m_symtab->get_counter());
        size_t i = 0;
        s.append("\n" + indtd + "└-scope=↧");
        for (auto &a : x.m_symtab->get_scope()) {
            i++;
            inc_indent();
            last = i == x.m_symtab->get_scope().size();
            s.append("\n" + indtd + (last ? "└-" : "|-") + a.first + ": ");
            this->visit_symbol(*a.second);
            dec_indent();
        }
        dec_indent();
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "args=");
        for (size_t i=0; i<x.n_args; i++) {
            s.append(x.m_args[i]);
            if (i < x.n_args-1) s.append(" ");
        }
        s.append("\n" + indtd + "└-" + "requires=↧");
        for (size_t i=0; i<x.n_requires; i++) {
            inc_indent();
            last = i == x.n_requires-1;
            attached = false;
            self().visit_require_instantiation(*x.m_requires[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_Template(const Template_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Template");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-");
        inc_lindent();
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        s.append("\n" + indtd + "|-counter=");
        s.append(x.m_symtab->get_counter());
        size_t i = 0;
        s.append("\n" + indtd + "└-scope=↧");
        for (auto &a : x.m_symtab->get_scope()) {
            i++;
            inc_indent();
            last = i == x.m_symtab->get_scope().size();
            s.append("\n" + indtd + (last ? "└-" : "|-") + a.first + ": ");
            this->visit_symbol(*a.second);
            dec_indent();
        }
        dec_indent();
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "|-" + "args=");
        for (size_t i=0; i<x.n_args; i++) {
            s.append(x.m_args[i]);
            if (i < x.n_args-1) s.append(" ");
        }
        s.append("\n" + indtd + "└-" + "requires=↧");
        for (size_t i=0; i<x.n_requires; i++) {
            inc_indent();
            last = i == x.n_requires-1;
            attached = false;
            self().visit_require_instantiation(*x.m_requires[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_Allocate(const Allocate_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Allocate");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_alloc_arg(x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "stat=");
        if (x.m_stat) {
            self().visit_expr(*x.m_stat);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "errmsg=");
        if (x.m_errmsg) {
            self().visit_expr(*x.m_errmsg);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "source=");
        last = true;
        if (x.m_source) {
            self().visit_expr(*x.m_source);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ReAlloc(const ReAlloc_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ReAlloc");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_indent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_alloc_arg(x.m_args[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_Assign(const Assign_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Assign");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "└-" + "variable=");
        s.append(x.m_variable);
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Assignment(const Assignment_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Assignment");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "target=");
        attached = true;
        self().visit_expr(*x.m_target);
        s.append("\n" + indtd + "|-" + "value=");
        attached = true;
        self().visit_expr(*x.m_value);
        s.append("\n" + indtd + "└-" + "overloaded=");
        last = true;
        if (x.m_overloaded) {
            self().visit_stmt(*x.m_overloaded);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Associate(const Associate_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Associate");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "target=");
        attached = true;
        self().visit_expr(*x.m_target);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_value);
        dec_indent();
    }
    void visit_Cycle(const Cycle_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Cycle");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "stmt_name=");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ExplicitDeallocate(const ExplicitDeallocate_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ExplicitDeallocate");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "vars=↧");
        for (size_t i=0; i<x.n_vars; i++) {
            inc_indent();
            last = i == x.n_vars-1;
            attached = false;
            self().visit_expr(*x.m_vars[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_ImplicitDeallocate(const ImplicitDeallocate_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ImplicitDeallocate");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "vars=↧");
        for (size_t i=0; i<x.n_vars; i++) {
            inc_indent();
            last = i == x.n_vars-1;
            attached = false;
            self().visit_expr(*x.m_vars[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_DoConcurrentLoop(const DoConcurrentLoop_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DoConcurrentLoop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "head=");
        attached = true;
        self().visit_do_loop_head(x.m_head);
        s.append("\n" + indtd + "|-" + "shared=↧");
        for (size_t i=0; i<x.n_shared; i++) {
            inc_lindent();
            last = i == x.n_shared-1;
            attached = false;
            self().visit_expr(*x.m_shared[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "local=↧");
        for (size_t i=0; i<x.n_local; i++) {
            inc_lindent();
            last = i == x.n_local-1;
            attached = false;
            self().visit_expr(*x.m_local[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_indent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_DoLoop(const DoLoop_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DoLoop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "name=");
        if (x.m_name) {
            s.append(x.m_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "head=");
        attached = true;
        self().visit_do_loop_head(x.m_head);
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "orelse=↧");
        for (size_t i=0; i<x.n_orelse; i++) {
            inc_indent();
            last = i == x.n_orelse-1;
            attached = false;
            self().visit_stmt(*x.m_orelse[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_ErrorStop(const ErrorStop_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ErrorStop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "code=");
        last = true;
        if (x.m_code) {
            self().visit_expr(*x.m_code);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Exit(const Exit_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Exit");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "stmt_name=");
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ForAllSingle(const ForAllSingle_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ForAllSingle");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "head=");
        attached = true;
        self().visit_do_loop_head(x.m_head);
        s.append("\n" + indtd + "└-" + "assign_stmt=");
        last = true;
        attached = true;
        self().visit_stmt(*x.m_assign_stmt);
        dec_indent();
    }
    void visit_GoTo(const GoTo_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("GoTo");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "target_id=");
        s.append(std::to_string(x.m_target_id));
        s.append("\n" + indtd + "└-" + "name=");
        s.append(x.m_name);
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_GoToTarget(const GoToTarget_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("GoToTarget");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "id=");
        s.append(std::to_string(x.m_id));
        s.append("\n" + indtd + "└-" + "name=");
        s.append(x.m_name);
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_If(const If_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("If");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "test=");
        attached = true;
        self().visit_expr(*x.m_test);
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "orelse=↧");
        for (size_t i=0; i<x.n_orelse; i++) {
            inc_indent();
            last = i == x.n_orelse-1;
            attached = false;
            self().visit_stmt(*x.m_orelse[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_IfArithmetic(const IfArithmetic_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IfArithmetic");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "test=");
        attached = true;
        self().visit_expr(*x.m_test);
        s.append("\n" + indtd + "|-" + "lt_label=");
        s.append(std::to_string(x.m_lt_label));
        s.append("\n" + indtd + "|-" + "eq_label=");
        s.append(std::to_string(x.m_eq_label));
        s.append("\n" + indtd + "└-" + "gt_label=");
        s.append(std::to_string(x.m_gt_label));
        dec_indent();
    }
    void visit_Print(const Print_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Print");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "values=↧");
        for (size_t i=0; i<x.n_values; i++) {
            inc_lindent();
            last = i == x.n_values-1;
            attached = false;
            self().visit_expr(*x.m_values[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "separator=");
        if (x.m_separator) {
            self().visit_expr(*x.m_separator);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "end=");
        last = true;
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_FileOpen(const FileOpen_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FileOpen");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "newunit=");
        if (x.m_newunit) {
            self().visit_expr(*x.m_newunit);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "filename=");
        if (x.m_filename) {
            self().visit_expr(*x.m_filename);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "status=");
        if (x.m_status) {
            self().visit_expr(*x.m_status);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "form=");
        last = true;
        if (x.m_form) {
            self().visit_expr(*x.m_form);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_FileClose(const FileClose_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FileClose");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "unit=");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "iostat=");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "iomsg=");
        if (x.m_iomsg) {
            self().visit_expr(*x.m_iomsg);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "err=");
        if (x.m_err) {
            self().visit_expr(*x.m_err);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "status=");
        last = true;
        if (x.m_status) {
            self().visit_expr(*x.m_status);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_FileRead(const FileRead_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FileRead");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "unit=");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "fmt=");
        if (x.m_fmt) {
            self().visit_expr(*x.m_fmt);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "iomsg=");
        if (x.m_iomsg) {
            self().visit_expr(*x.m_iomsg);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "iostat=");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "size=");
        if (x.m_size) {
            self().visit_expr(*x.m_size);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "id=");
        if (x.m_id) {
            self().visit_expr(*x.m_id);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "values=↧");
        for (size_t i=0; i<x.n_values; i++) {
            inc_lindent();
            last = i == x.n_values-1;
            attached = false;
            self().visit_expr(*x.m_values[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "overloaded=");
        last = true;
        if (x.m_overloaded) {
            self().visit_stmt(*x.m_overloaded);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_FileBackspace(const FileBackspace_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FileBackspace");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "unit=");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "iostat=");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "err=");
        last = true;
        if (x.m_err) {
            self().visit_expr(*x.m_err);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_FileRewind(const FileRewind_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FileRewind");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "unit=");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "iostat=");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "err=");
        last = true;
        if (x.m_err) {
            self().visit_expr(*x.m_err);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_FileInquire(const FileInquire_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FileInquire");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "unit=");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "file=");
        if (x.m_file) {
            self().visit_expr(*x.m_file);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "iostat=");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "err=");
        if (x.m_err) {
            self().visit_expr(*x.m_err);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "exist=");
        if (x.m_exist) {
            self().visit_expr(*x.m_exist);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "opened=");
        if (x.m_opened) {
            self().visit_expr(*x.m_opened);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "number=");
        if (x.m_number) {
            self().visit_expr(*x.m_number);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "named=");
        if (x.m_named) {
            self().visit_expr(*x.m_named);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "name=");
        if (x.m_name) {
            self().visit_expr(*x.m_name);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "access=");
        if (x.m_access) {
            self().visit_expr(*x.m_access);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "sequential=");
        if (x.m_sequential) {
            self().visit_expr(*x.m_sequential);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "direct=");
        if (x.m_direct) {
            self().visit_expr(*x.m_direct);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "form=");
        if (x.m_form) {
            self().visit_expr(*x.m_form);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "formatted=");
        if (x.m_formatted) {
            self().visit_expr(*x.m_formatted);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "unformatted=");
        if (x.m_unformatted) {
            self().visit_expr(*x.m_unformatted);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "recl=");
        if (x.m_recl) {
            self().visit_expr(*x.m_recl);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "nextrec=");
        if (x.m_nextrec) {
            self().visit_expr(*x.m_nextrec);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "blank=");
        if (x.m_blank) {
            self().visit_expr(*x.m_blank);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "position=");
        if (x.m_position) {
            self().visit_expr(*x.m_position);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "action=");
        if (x.m_action) {
            self().visit_expr(*x.m_action);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "read=");
        if (x.m_read) {
            self().visit_expr(*x.m_read);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "write=");
        if (x.m_write) {
            self().visit_expr(*x.m_write);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "readwrite=");
        if (x.m_readwrite) {
            self().visit_expr(*x.m_readwrite);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "delim=");
        if (x.m_delim) {
            self().visit_expr(*x.m_delim);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "pad=");
        if (x.m_pad) {
            self().visit_expr(*x.m_pad);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "flen=");
        if (x.m_flen) {
            self().visit_expr(*x.m_flen);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "blocksize=");
        if (x.m_blocksize) {
            self().visit_expr(*x.m_blocksize);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "convert=");
        if (x.m_convert) {
            self().visit_expr(*x.m_convert);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "carriagecontrol=");
        if (x.m_carriagecontrol) {
            self().visit_expr(*x.m_carriagecontrol);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "iolength=");
        last = true;
        if (x.m_iolength) {
            self().visit_expr(*x.m_iolength);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_FileWrite(const FileWrite_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FileWrite");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "unit=");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "iomsg=");
        if (x.m_iomsg) {
            self().visit_expr(*x.m_iomsg);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "iostat=");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "id=");
        if (x.m_id) {
            self().visit_expr(*x.m_id);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "values=↧");
        for (size_t i=0; i<x.n_values; i++) {
            inc_lindent();
            last = i == x.n_values-1;
            attached = false;
            self().visit_expr(*x.m_values[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "separator=");
        if (x.m_separator) {
            self().visit_expr(*x.m_separator);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "end=");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "overloaded=");
        last = true;
        if (x.m_overloaded) {
            self().visit_stmt(*x.m_overloaded);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Return(const Return_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Return");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Select(const Select_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Select");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "test=");
        attached = true;
        self().visit_expr(*x.m_test);
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_case_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "default=↧");
        for (size_t i=0; i<x.n_default; i++) {
            inc_lindent();
            last = i == x.n_default-1;
            attached = false;
            self().visit_stmt(*x.m_default[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "enable_fall_through=");
        if (x.m_enable_fall_through) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        dec_indent();
    }
    void visit_Stop(const Stop_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Stop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "code=");
        last = true;
        if (x.m_code) {
            self().visit_expr(*x.m_code);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Assert(const Assert_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Assert");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "test=");
        attached = true;
        self().visit_expr(*x.m_test);
        s.append("\n" + indtd + "└-" + "msg=");
        last = true;
        if (x.m_msg) {
            self().visit_expr(*x.m_msg);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_SubroutineCall(const SubroutineCall_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SubroutineCall");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "name=");
        attached = true;
        self().visit_symbol(*x.m_name);
        s.append("\n" + indtd + "|-" + "original_name=");
        if (x.m_original_name) {
            self().visit_symbol(*x.m_original_name);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_call_arg(x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "dt=");
        last = true;
        if (x.m_dt) {
            self().visit_expr(*x.m_dt);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_IntrinsicImpureSubroutine(const IntrinsicImpureSubroutine_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntrinsicImpureSubroutine");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "intrinsic_id=");
        s.append(std::to_string(x.m_intrinsic_id));
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_expr(*x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "overload_id=");
        s.append(std::to_string(x.m_overload_id));
        dec_indent();
    }
    void visit_Where(const Where_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Where");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "test=");
        attached = true;
        self().visit_expr(*x.m_test);
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "orelse=↧");
        for (size_t i=0; i<x.n_orelse; i++) {
            inc_indent();
            last = i == x.n_orelse-1;
            attached = false;
            self().visit_stmt(*x.m_orelse[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_WhileLoop(const WhileLoop_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("WhileLoop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "name=");
        if (x.m_name) {
            s.append(x.m_name);
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "test=");
        attached = true;
        self().visit_expr(*x.m_test);
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "orelse=↧");
        for (size_t i=0; i<x.n_orelse; i++) {
            inc_indent();
            last = i == x.n_orelse-1;
            attached = false;
            self().visit_stmt(*x.m_orelse[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_Nullify(const Nullify_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Nullify");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "vars=↧");
        for (size_t i=0; i<x.n_vars; i++) {
            inc_indent();
            last = i == x.n_vars-1;
            attached = false;
            self().visit_symbol(*x.m_vars[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_Flush(const Flush_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Flush");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "|-" + "unit=");
        attached = true;
        self().visit_expr(*x.m_unit);
        s.append("\n" + indtd + "|-" + "err=");
        if (x.m_err) {
            self().visit_expr(*x.m_err);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "iomsg=");
        if (x.m_iomsg) {
            self().visit_expr(*x.m_iomsg);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "iostat=");
        last = true;
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ListAppend(const ListAppend_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListAppend");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "a=");
        attached = true;
        self().visit_expr(*x.m_a);
        s.append("\n" + indtd + "└-" + "ele=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_ele);
        dec_indent();
    }
    void visit_AssociateBlockCall(const AssociateBlockCall_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AssociateBlockCall");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "m=");
        last = true;
        attached = true;
        self().visit_symbol(*x.m_m);
        dec_indent();
    }
    void visit_SelectType(const SelectType_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SelectType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "selector=");
        attached = true;
        self().visit_expr(*x.m_selector);
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_type_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "default=↧");
        for (size_t i=0; i<x.n_default; i++) {
            inc_indent();
            last = i == x.n_default-1;
            attached = false;
            self().visit_stmt(*x.m_default[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_CPtrToPointer(const CPtrToPointer_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CPtrToPointer");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "cptr=");
        attached = true;
        self().visit_expr(*x.m_cptr);
        s.append("\n" + indtd + "|-" + "ptr=");
        attached = true;
        self().visit_expr(*x.m_ptr);
        s.append("\n" + indtd + "|-" + "shape=");
        if (x.m_shape) {
            self().visit_expr(*x.m_shape);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "lower_bounds=");
        last = true;
        if (x.m_lower_bounds) {
            self().visit_expr(*x.m_lower_bounds);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_BlockCall(const BlockCall_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("BlockCall");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "label=");
        s.append(std::to_string(x.m_label));
        s.append("\n" + indtd + "└-" + "m=");
        last = true;
        attached = true;
        self().visit_symbol(*x.m_m);
        dec_indent();
    }
    void visit_SetInsert(const SetInsert_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SetInsert");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "a=");
        attached = true;
        self().visit_expr(*x.m_a);
        s.append("\n" + indtd + "└-" + "ele=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_ele);
        dec_indent();
    }
    void visit_SetRemove(const SetRemove_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SetRemove");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "a=");
        attached = true;
        self().visit_expr(*x.m_a);
        s.append("\n" + indtd + "└-" + "ele=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_ele);
        dec_indent();
    }
    void visit_ListInsert(const ListInsert_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListInsert");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "a=");
        attached = true;
        self().visit_expr(*x.m_a);
        s.append("\n" + indtd + "|-" + "pos=");
        attached = true;
        self().visit_expr(*x.m_pos);
        s.append("\n" + indtd + "└-" + "ele=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_ele);
        dec_indent();
    }
    void visit_ListRemove(const ListRemove_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListRemove");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "a=");
        attached = true;
        self().visit_expr(*x.m_a);
        s.append("\n" + indtd + "└-" + "ele=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_ele);
        dec_indent();
    }
    void visit_ListClear(const ListClear_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListClear");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "a=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_a);
        dec_indent();
    }
    void visit_DictInsert(const DictInsert_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DictInsert");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "a=");
        attached = true;
        self().visit_expr(*x.m_a);
        s.append("\n" + indtd + "|-" + "key=");
        attached = true;
        self().visit_expr(*x.m_key);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_value);
        dec_indent();
    }
    void visit_Expr(const Expr_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Expr");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "expression=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_expression);
        dec_indent();
    }
    void visit_IfExp(const IfExp_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IfExp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "test=");
        attached = true;
        self().visit_expr(*x.m_test);
        s.append("\n" + indtd + "|-" + "body=");
        attached = true;
        self().visit_expr(*x.m_body);
        s.append("\n" + indtd + "|-" + "orelse=");
        attached = true;
        self().visit_expr(*x.m_orelse);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ComplexConstructor(const ComplexConstructor_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ComplexConstructor");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "re=");
        attached = true;
        self().visit_expr(*x.m_re);
        s.append("\n" + indtd + "|-" + "im=");
        attached = true;
        self().visit_expr(*x.m_im);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_NamedExpr(const NamedExpr_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("NamedExpr");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "target=");
        attached = true;
        self().visit_expr(*x.m_target);
        s.append("\n" + indtd + "|-" + "value=");
        attached = true;
        self().visit_expr(*x.m_value);
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_type);
        dec_indent();
    }
    void visit_FunctionCall(const FunctionCall_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FunctionCall");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "name=");
        attached = true;
        self().visit_symbol(*x.m_name);
        s.append("\n" + indtd + "|-" + "original_name=");
        if (x.m_original_name) {
            self().visit_symbol(*x.m_original_name);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_call_arg(x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "|-" + "value=");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "dt=");
        last = true;
        if (x.m_dt) {
            self().visit_expr(*x.m_dt);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_IntrinsicElementalFunction(const IntrinsicElementalFunction_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntrinsicElementalFunction");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "intrinsic_id=");
        s.append(std::to_string(x.m_intrinsic_id));
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_expr(*x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "overload_id=");
        s.append(std::to_string(x.m_overload_id));
        s.append("\n" + indtd + "|-" + "type=");
        if (x.m_type) {
            self().visit_ttype(*x.m_type);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_IntrinsicArrayFunction(const IntrinsicArrayFunction_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntrinsicArrayFunction");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arr_intrinsic_id=");
        s.append(std::to_string(x.m_arr_intrinsic_id));
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_expr(*x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "overload_id=");
        s.append(std::to_string(x.m_overload_id));
        s.append("\n" + indtd + "|-" + "type=");
        if (x.m_type) {
            self().visit_ttype(*x.m_type);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_IntrinsicImpureFunction(const IntrinsicImpureFunction_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntrinsicImpureFunction");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "impure_intrinsic_id=");
        s.append(std::to_string(x.m_impure_intrinsic_id));
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_expr(*x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "overload_id=");
        s.append(std::to_string(x.m_overload_id));
        s.append("\n" + indtd + "|-" + "type=");
        if (x.m_type) {
            self().visit_ttype(*x.m_type);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_TypeInquiry(const TypeInquiry_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TypeInquiry");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "inquiry_id=");
        s.append(std::to_string(x.m_inquiry_id));
        s.append("\n" + indtd + "|-" + "arg_type=");
        attached = true;
        self().visit_ttype(*x.m_arg_type);
        s.append("\n" + indtd + "|-" + "arg=");
        if (x.m_arg) {
            self().visit_expr(*x.m_arg);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_value);
        dec_indent();
    }
    void visit_StructTypeConstructor(const StructTypeConstructor_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StructTypeConstructor");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "dt_sym=");
        attached = true;
        self().visit_symbol(*x.m_dt_sym);
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_call_arg(x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_EnumTypeConstructor(const EnumTypeConstructor_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("EnumTypeConstructor");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "dt_sym=");
        attached = true;
        self().visit_symbol(*x.m_dt_sym);
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_expr(*x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_UnionTypeConstructor(const UnionTypeConstructor_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnionTypeConstructor");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "dt_sym=");
        attached = true;
        self().visit_symbol(*x.m_dt_sym);
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_expr(*x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ImpliedDoLoop(const ImpliedDoLoop_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ImpliedDoLoop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "values=↧");
        for (size_t i=0; i<x.n_values; i++) {
            inc_lindent();
            last = i == x.n_values-1;
            attached = false;
            self().visit_expr(*x.m_values[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "var=");
        attached = true;
        self().visit_expr(*x.m_var);
        s.append("\n" + indtd + "|-" + "start=");
        attached = true;
        self().visit_expr(*x.m_start);
        s.append("\n" + indtd + "|-" + "end=");
        attached = true;
        self().visit_expr(*x.m_end);
        s.append("\n" + indtd + "|-" + "increment=");
        if (x.m_increment) {
            self().visit_expr(*x.m_increment);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_IntegerConstant(const IntegerConstant_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntegerConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "n=");
        s.append(std::to_string(x.m_n));
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_type);
        dec_indent();
    }
    void visit_IntegerBOZ(const IntegerBOZ_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntegerBOZ");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "v=");
        s.append(std::to_string(x.m_v));
        s.append("\n" + indtd + "|-" + "integerbozType=");
        visit_integerbozType(x.m_intboz_type);
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        if (x.m_type) {
            self().visit_ttype(*x.m_type);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_IntegerBitNot(const IntegerBitNot_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntegerBitNot");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_IntegerUnaryMinus(const IntegerUnaryMinus_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntegerUnaryMinus");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_IntegerCompare(const IntegerCompare_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntegerCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "cmpopType=");
        visit_cmpopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_IntegerBinOp(const IntegerBinOp_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntegerBinOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "binopType=");
        visit_binopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_UnsignedIntegerConstant(const UnsignedIntegerConstant_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnsignedIntegerConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "n=");
        s.append(std::to_string(x.m_n));
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_type);
        dec_indent();
    }
    void visit_UnsignedIntegerUnaryMinus(const UnsignedIntegerUnaryMinus_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnsignedIntegerUnaryMinus");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_UnsignedIntegerBitNot(const UnsignedIntegerBitNot_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnsignedIntegerBitNot");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_UnsignedIntegerCompare(const UnsignedIntegerCompare_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnsignedIntegerCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "cmpopType=");
        visit_cmpopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_UnsignedIntegerBinOp(const UnsignedIntegerBinOp_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnsignedIntegerBinOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "binopType=");
        visit_binopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_RealConstant(const RealConstant_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RealConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "r=");
        s.append(std::to_string(x.m_r));
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_type);
        dec_indent();
    }
    void visit_RealUnaryMinus(const RealUnaryMinus_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RealUnaryMinus");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_RealCompare(const RealCompare_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RealCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "cmpopType=");
        visit_cmpopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_RealBinOp(const RealBinOp_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RealBinOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "binopType=");
        visit_binopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_RealCopySign(const RealCopySign_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RealCopySign");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "target=");
        attached = true;
        self().visit_expr(*x.m_target);
        s.append("\n" + indtd + "|-" + "source=");
        attached = true;
        self().visit_expr(*x.m_source);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ComplexConstant(const ComplexConstant_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ComplexConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "re=");
        s.append(std::to_string(x.m_re));
        s.append("\n" + indtd + "|-" + "im=");
        s.append(std::to_string(x.m_im));
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_type);
        dec_indent();
    }
    void visit_ComplexUnaryMinus(const ComplexUnaryMinus_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ComplexUnaryMinus");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ComplexCompare(const ComplexCompare_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ComplexCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "cmpopType=");
        visit_cmpopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ComplexBinOp(const ComplexBinOp_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ComplexBinOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "binopType=");
        visit_binopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_LogicalConstant(const LogicalConstant_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("LogicalConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "value=");
        if (x.m_value) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_type);
        dec_indent();
    }
    void visit_LogicalNot(const LogicalNot_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("LogicalNot");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_LogicalCompare(const LogicalCompare_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("LogicalCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "cmpopType=");
        visit_cmpopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_LogicalBinOp(const LogicalBinOp_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("LogicalBinOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "logicalbinopType=");
        visit_logicalbinopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ListConstant(const ListConstant_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_expr(*x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_type);
        dec_indent();
    }
    void visit_ListLen(const ListLen_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListLen");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ListConcat(const ListConcat_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListConcat");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ListCompare(const ListCompare_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "cmpopType=");
        visit_cmpopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ListCount(const ListCount_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListCount");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "ele=");
        attached = true;
        self().visit_expr(*x.m_ele);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_SetConstant(const SetConstant_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SetConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "elements=↧");
        for (size_t i=0; i<x.n_elements; i++) {
            inc_lindent();
            last = i == x.n_elements-1;
            attached = false;
            self().visit_expr(*x.m_elements[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_type);
        dec_indent();
    }
    void visit_SetLen(const SetLen_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SetLen");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_TupleConstant(const TupleConstant_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TupleConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "elements=↧");
        for (size_t i=0; i<x.n_elements; i++) {
            inc_lindent();
            last = i == x.n_elements-1;
            attached = false;
            self().visit_expr(*x.m_elements[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_type);
        dec_indent();
    }
    void visit_TupleLen(const TupleLen_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TupleLen");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_value);
        dec_indent();
    }
    void visit_TupleCompare(const TupleCompare_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TupleCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "cmpopType=");
        visit_cmpopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_TupleConcat(const TupleConcat_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TupleConcat");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_StringConstant(const StringConstant_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "s=");
        s.append("\"" + std::string(x.m_s) + "\"");
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_type);
        dec_indent();
    }
    void visit_StringConcat(const StringConcat_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringConcat");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_StringRepeat(const StringRepeat_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringRepeat");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_StringLen(const StringLen_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringLen");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_StringItem(const StringItem_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringItem");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "idx=");
        attached = true;
        self().visit_expr(*x.m_idx);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_StringSection(const StringSection_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringSection");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "start=");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "end=");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "step=");
        if (x.m_step) {
            self().visit_expr(*x.m_step);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_StringCompare(const StringCompare_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "cmpopType=");
        visit_cmpopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_StringOrd(const StringOrd_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringOrd");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_StringChr(const StringChr_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringChr");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_StringFormat(const StringFormat_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringFormat");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "fmt=");
        attached = true;
        self().visit_expr(*x.m_fmt);
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_expr(*x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "string_format_kindType=");
        visit_string_format_kindType(x.m_kind);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_CPtrCompare(const CPtrCompare_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CPtrCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "cmpopType=");
        visit_cmpopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_SymbolicCompare(const SymbolicCompare_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SymbolicCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "cmpopType=");
        visit_cmpopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_DictConstant(const DictConstant_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DictConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "keys=↧");
        for (size_t i=0; i<x.n_keys; i++) {
            inc_lindent();
            last = i == x.n_keys-1;
            attached = false;
            self().visit_expr(*x.m_keys[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "values=↧");
        for (size_t i=0; i<x.n_values; i++) {
            inc_lindent();
            last = i == x.n_values-1;
            attached = false;
            self().visit_expr(*x.m_values[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_type);
        dec_indent();
    }
    void visit_DictLen(const DictLen_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DictLen");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Var(const Var_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Var");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "v=");
        last = true;
        attached = true;
        self().visit_symbol(*x.m_v);
        dec_indent();
    }
    void visit_FunctionParam(const FunctionParam_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FunctionParam");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "param_number=");
        s.append(std::to_string(x.m_param_number));
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ArrayConstructor(const ArrayConstructor_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayConstructor");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_expr(*x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "|-" + "value=");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "arraystorageType=");
        visit_arraystorageType(x.m_storage_format);
        dec_indent();
    }
    void visit_ArrayConstant(const ArrayConstant_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "n_data=");
        s.append(std::to_string(x.m_n_data));
        s.append("Unimplementedvoid");
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "arraystorageType=");
        visit_arraystorageType(x.m_storage_format);
        dec_indent();
    }
    void visit_ArrayItem(const ArrayItem_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayItem");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "v=");
        attached = true;
        self().visit_expr(*x.m_v);
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_array_index(x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "|-" + "arraystorageType=");
        visit_arraystorageType(x.m_storage_format);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ArraySection(const ArraySection_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArraySection");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "v=");
        attached = true;
        self().visit_expr(*x.m_v);
        s.append("\n" + indtd + "|-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_lindent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_array_index(x.m_args[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ArraySize(const ArraySize_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArraySize");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "v=");
        attached = true;
        self().visit_expr(*x.m_v);
        s.append("\n" + indtd + "|-" + "dim=");
        if (x.m_dim) {
            self().visit_expr(*x.m_dim);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ArrayBound(const ArrayBound_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayBound");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "v=");
        attached = true;
        self().visit_expr(*x.m_v);
        s.append("\n" + indtd + "|-" + "dim=");
        if (x.m_dim) {
            self().visit_expr(*x.m_dim);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "|-" + "arrayboundType=");
        visit_arrayboundType(x.m_bound);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ArrayTranspose(const ArrayTranspose_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayTranspose");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "matrix=");
        attached = true;
        self().visit_expr(*x.m_matrix);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ArrayPack(const ArrayPack_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayPack");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "array=");
        attached = true;
        self().visit_expr(*x.m_array);
        s.append("\n" + indtd + "|-" + "mask=");
        attached = true;
        self().visit_expr(*x.m_mask);
        s.append("\n" + indtd + "|-" + "vector=");
        if (x.m_vector) {
            self().visit_expr(*x.m_vector);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ArrayReshape(const ArrayReshape_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayReshape");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "array=");
        attached = true;
        self().visit_expr(*x.m_array);
        s.append("\n" + indtd + "|-" + "shape=");
        attached = true;
        self().visit_expr(*x.m_shape);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ArrayBroadcast(const ArrayBroadcast_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayBroadcast");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "array=");
        attached = true;
        self().visit_expr(*x.m_array);
        s.append("\n" + indtd + "|-" + "shape=");
        attached = true;
        self().visit_expr(*x.m_shape);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_BitCast(const BitCast_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("BitCast");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "source=");
        attached = true;
        self().visit_expr(*x.m_source);
        s.append("\n" + indtd + "|-" + "mold=");
        attached = true;
        self().visit_expr(*x.m_mold);
        s.append("\n" + indtd + "|-" + "size=");
        if (x.m_size) {
            self().visit_expr(*x.m_size);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_StructInstanceMember(const StructInstanceMember_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StructInstanceMember");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "v=");
        attached = true;
        self().visit_expr(*x.m_v);
        s.append("\n" + indtd + "|-" + "m=");
        attached = true;
        self().visit_symbol(*x.m_m);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_StructStaticMember(const StructStaticMember_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StructStaticMember");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "v=");
        attached = true;
        self().visit_expr(*x.m_v);
        s.append("\n" + indtd + "|-" + "m=");
        attached = true;
        self().visit_symbol(*x.m_m);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_EnumStaticMember(const EnumStaticMember_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("EnumStaticMember");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "v=");
        attached = true;
        self().visit_expr(*x.m_v);
        s.append("\n" + indtd + "|-" + "m=");
        attached = true;
        self().visit_symbol(*x.m_m);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_UnionInstanceMember(const UnionInstanceMember_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnionInstanceMember");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "v=");
        attached = true;
        self().visit_expr(*x.m_v);
        s.append("\n" + indtd + "|-" + "m=");
        attached = true;
        self().visit_symbol(*x.m_m);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_EnumName(const EnumName_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("EnumName");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "v=");
        attached = true;
        self().visit_expr(*x.m_v);
        s.append("\n" + indtd + "|-" + "enum_type=");
        attached = true;
        self().visit_ttype(*x.m_enum_type);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_EnumValue(const EnumValue_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("EnumValue");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "v=");
        attached = true;
        self().visit_expr(*x.m_v);
        s.append("\n" + indtd + "|-" + "enum_type=");
        attached = true;
        self().visit_ttype(*x.m_enum_type);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_OverloadedCompare(const OverloadedCompare_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OverloadedCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "cmpopType=");
        visit_cmpopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "|-" + "value=");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "overloaded=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_overloaded);
        dec_indent();
    }
    void visit_OverloadedBinOp(const OverloadedBinOp_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OverloadedBinOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "binopType=");
        visit_binopType(x.m_op);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "|-" + "value=");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "overloaded=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_overloaded);
        dec_indent();
    }
    void visit_OverloadedUnaryMinus(const OverloadedUnaryMinus_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OverloadedUnaryMinus");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "|-" + "value=");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "overloaded=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_overloaded);
        dec_indent();
    }
    void visit_OverloadedStringConcat(const OverloadedStringConcat_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OverloadedStringConcat");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "|-" + "value=");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "overloaded=");
        last = true;
        attached = true;
        self().visit_expr(*x.m_overloaded);
        dec_indent();
    }
    void visit_Cast(const Cast_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Cast");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "cast_kindType=");
        visit_cast_kindType(x.m_kind);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ArrayPhysicalCast(const ArrayPhysicalCast_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayPhysicalCast");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "array_physical_typeType=");
        visit_array_physical_typeType(x.m_old);
        s.append("\n" + indtd + "|-" + "array_physical_typeType=");
        visit_array_physical_typeType(x.m_new);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ComplexRe(const ComplexRe_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ComplexRe");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ComplexIm(const ComplexIm_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ComplexIm");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_DictItem(const DictItem_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DictItem");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "a=");
        attached = true;
        self().visit_expr(*x.m_a);
        s.append("\n" + indtd + "|-" + "key=");
        attached = true;
        self().visit_expr(*x.m_key);
        s.append("\n" + indtd + "|-" + "default=");
        if (x.m_default) {
            self().visit_expr(*x.m_default);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_CLoc(const CLoc_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CLoc");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_PointerToCPtr(const PointerToCPtr_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("PointerToCPtr");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_GetPointer(const GetPointer_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("GetPointer");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ListItem(const ListItem_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListItem");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "a=");
        attached = true;
        self().visit_expr(*x.m_a);
        s.append("\n" + indtd + "|-" + "pos=");
        attached = true;
        self().visit_expr(*x.m_pos);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_TupleItem(const TupleItem_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TupleItem");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "a=");
        attached = true;
        self().visit_expr(*x.m_a);
        s.append("\n" + indtd + "|-" + "pos=");
        attached = true;
        self().visit_expr(*x.m_pos);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ListSection(const ListSection_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListSection");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "a=");
        attached = true;
        self().visit_expr(*x.m_a);
        s.append("\n" + indtd + "|-" + "section=");
        attached = true;
        self().visit_array_index(x.m_section);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_ListRepeat(const ListRepeat_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListRepeat");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "left=");
        attached = true;
        self().visit_expr(*x.m_left);
        s.append("\n" + indtd + "|-" + "right=");
        attached = true;
        self().visit_expr(*x.m_right);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_DictPop(const DictPop_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DictPop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "a=");
        attached = true;
        self().visit_expr(*x.m_a);
        s.append("\n" + indtd + "|-" + "key=");
        attached = true;
        self().visit_expr(*x.m_key);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_SetPop(const SetPop_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SetPop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "a=");
        attached = true;
        self().visit_expr(*x.m_a);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_IntegerBitLen(const IntegerBitLen_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntegerBitLen");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "a=");
        attached = true;
        self().visit_expr(*x.m_a);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Ichar(const Ichar_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Ichar");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Iachar(const Iachar_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Iachar");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_SizeOfType(const SizeOfType_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SizeOfType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_ttype(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_PointerNullConstant(const PointerNullConstant_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("PointerNullConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_type);
        dec_indent();
    }
    void visit_PointerAssociated(const PointerAssociated_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("PointerAssociated");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "ptr=");
        attached = true;
        self().visit_expr(*x.m_ptr);
        s.append("\n" + indtd + "|-" + "tgt=");
        if (x.m_tgt) {
            self().visit_expr(*x.m_tgt);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_RealSqrt(const RealSqrt_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RealSqrt");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg=");
        attached = true;
        self().visit_expr(*x.m_arg);
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Integer(const Integer_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Integer");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "kind=");
        s.append(std::to_string(x.m_kind));
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UnsignedInteger(const UnsignedInteger_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnsignedInteger");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "kind=");
        s.append(std::to_string(x.m_kind));
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Real(const Real_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Real");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "kind=");
        s.append(std::to_string(x.m_kind));
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Complex(const Complex_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Complex");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "kind=");
        s.append(std::to_string(x.m_kind));
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Character(const Character_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Character");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "kind=");
        s.append(std::to_string(x.m_kind));
        s.append("\n" + indtd + "|-" + "len=");
        s.append(std::to_string(x.m_len));
        s.append("\n" + indtd + "└-" + "len_expr=");
        last = true;
        if (x.m_len_expr) {
            self().visit_expr(*x.m_len_expr);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Logical(const Logical_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Logical");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "kind=");
        s.append(std::to_string(x.m_kind));
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Set(const Set_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Set");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_type);
        dec_indent();
    }
    void visit_List(const List_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("List");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_type);
        dec_indent();
    }
    void visit_Tuple(const Tuple_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Tuple");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "type=↧");
        for (size_t i=0; i<x.n_type; i++) {
            inc_indent();
            last = i == x.n_type-1;
            attached = false;
            self().visit_ttype(*x.m_type[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_Struct(const Struct_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Struct");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "derived_type=");
        last = true;
        attached = true;
        self().visit_symbol(*x.m_derived_type);
        dec_indent();
    }
    void visit_Enum(const Enum_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Enum");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "enum_type=");
        last = true;
        attached = true;
        self().visit_symbol(*x.m_enum_type);
        dec_indent();
    }
    void visit_Union(const Union_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Union");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "union_type=");
        last = true;
        attached = true;
        self().visit_symbol(*x.m_union_type);
        dec_indent();
    }
    void visit_Class(const Class_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Class");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "class_type=");
        last = true;
        attached = true;
        self().visit_symbol(*x.m_class_type);
        dec_indent();
    }
    void visit_Dict(const Dict_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Dict");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "key_type=");
        attached = true;
        self().visit_ttype(*x.m_key_type);
        s.append("\n" + indtd + "└-" + "value_type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_value_type);
        dec_indent();
    }
    void visit_Pointer(const Pointer_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Pointer");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_type);
        dec_indent();
    }
    void visit_Allocatable(const Allocatable_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Allocatable");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        attached = true;
        self().visit_ttype(*x.m_type);
        dec_indent();
    }
    void visit_CPtr(const CPtr_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CPtr");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SymbolicExpression(const SymbolicExpression_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SymbolicExpression");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_TypeParameter(const TypeParameter_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TypeParameter");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "└-" + "param=");
        s.append(x.m_param);
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Array(const Array_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Array");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "|-" + "dims=↧");
        for (size_t i=0; i<x.n_dims; i++) {
            inc_lindent();
            last = i == x.n_dims-1;
            attached = false;
            self().visit_dimension(x.m_dims[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "array_physical_typeType=");
        visit_array_physical_typeType(x.m_physical_type);
        dec_indent();
    }
    void visit_FunctionType(const FunctionType_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FunctionType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "arg_types=↧");
        for (size_t i=0; i<x.n_arg_types; i++) {
            inc_lindent();
            last = i == x.n_arg_types-1;
            attached = false;
            self().visit_ttype(*x.m_arg_types[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "return_var_type=");
        if (x.m_return_var_type) {
            self().visit_ttype(*x.m_return_var_type);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "abiType=");
        visit_abiType(x.m_abi);
        s.append("\n" + indtd + "|-" + "deftypeType=");
        visit_deftypeType(x.m_deftype);
        s.append("\n" + indtd + "|-" + "bindc_name=");
        if (x.m_bindc_name) {
            s.append("\"" + std::string(x.m_bindc_name) + "\"");
        } else {
            s.append("()");
        }
        s.append("\n" + indtd + "|-" + "elemental=");
        if (x.m_elemental) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "|-" + "pure=");
        if (x.m_pure) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "|-" + "module=");
        if (x.m_module) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "|-" + "inline=");
        if (x.m_inline) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "|-" + "static=");
        if (x.m_static) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        s.append("\n" + indtd + "|-" + "restrictions=↧");
        for (size_t i=0; i<x.n_restrictions; i++) {
            inc_lindent();
            last = i == x.n_restrictions-1;
            attached = false;
            self().visit_symbol(*x.m_restrictions[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "is_restriction=");
        if (x.m_is_restriction) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        dec_indent();
    }
    void visit_cast_kindType(const cast_kindType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (cast_kindType::RealToInteger) : {
                s.append("RealToInteger");
             break; }
            case (cast_kindType::IntegerToReal) : {
                s.append("IntegerToReal");
             break; }
            case (cast_kindType::LogicalToReal) : {
                s.append("LogicalToReal");
             break; }
            case (cast_kindType::RealToReal) : {
                s.append("RealToReal");
             break; }
            case (cast_kindType::IntegerToInteger) : {
                s.append("IntegerToInteger");
             break; }
            case (cast_kindType::RealToComplex) : {
                s.append("RealToComplex");
             break; }
            case (cast_kindType::IntegerToComplex) : {
                s.append("IntegerToComplex");
             break; }
            case (cast_kindType::IntegerToLogical) : {
                s.append("IntegerToLogical");
             break; }
            case (cast_kindType::RealToLogical) : {
                s.append("RealToLogical");
             break; }
            case (cast_kindType::CharacterToLogical) : {
                s.append("CharacterToLogical");
             break; }
            case (cast_kindType::CharacterToInteger) : {
                s.append("CharacterToInteger");
             break; }
            case (cast_kindType::CharacterToList) : {
                s.append("CharacterToList");
             break; }
            case (cast_kindType::ComplexToLogical) : {
                s.append("ComplexToLogical");
             break; }
            case (cast_kindType::ComplexToComplex) : {
                s.append("ComplexToComplex");
             break; }
            case (cast_kindType::ComplexToReal) : {
                s.append("ComplexToReal");
             break; }
            case (cast_kindType::ComplexToInteger) : {
                s.append("ComplexToInteger");
             break; }
            case (cast_kindType::LogicalToInteger) : {
                s.append("LogicalToInteger");
             break; }
            case (cast_kindType::RealToCharacter) : {
                s.append("RealToCharacter");
             break; }
            case (cast_kindType::IntegerToCharacter) : {
                s.append("IntegerToCharacter");
             break; }
            case (cast_kindType::LogicalToCharacter) : {
                s.append("LogicalToCharacter");
             break; }
            case (cast_kindType::UnsignedIntegerToInteger) : {
                s.append("UnsignedIntegerToInteger");
             break; }
            case (cast_kindType::UnsignedIntegerToUnsignedInteger) : {
                s.append("UnsignedIntegerToUnsignedInteger");
             break; }
            case (cast_kindType::UnsignedIntegerToReal) : {
                s.append("UnsignedIntegerToReal");
             break; }
            case (cast_kindType::UnsignedIntegerToLogical) : {
                s.append("UnsignedIntegerToLogical");
             break; }
            case (cast_kindType::IntegerToUnsignedInteger) : {
                s.append("IntegerToUnsignedInteger");
             break; }
            case (cast_kindType::RealToUnsignedInteger) : {
                s.append("RealToUnsignedInteger");
             break; }
            case (cast_kindType::CPtrToUnsignedInteger) : {
                s.append("CPtrToUnsignedInteger");
             break; }
            case (cast_kindType::UnsignedIntegerToCPtr) : {
                s.append("UnsignedIntegerToCPtr");
             break; }
            case (cast_kindType::IntegerToSymbolicExpression) : {
                s.append("IntegerToSymbolicExpression");
             break; }
            case (cast_kindType::ListToArray) : {
                s.append("ListToArray");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_storage_typeType(const storage_typeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (storage_typeType::Default) : {
                s.append("Default");
             break; }
            case (storage_typeType::Save) : {
                s.append("Save");
             break; }
            case (storage_typeType::Parameter) : {
                s.append("Parameter");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_accessType(const accessType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (accessType::Public) : {
                s.append("Public");
             break; }
            case (accessType::Private) : {
                s.append("Private");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_intentType(const intentType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (intentType::Local) : {
                s.append("Local");
             break; }
            case (intentType::In) : {
                s.append("In");
             break; }
            case (intentType::Out) : {
                s.append("Out");
             break; }
            case (intentType::InOut) : {
                s.append("InOut");
             break; }
            case (intentType::ReturnVar) : {
                s.append("ReturnVar");
             break; }
            case (intentType::Unspecified) : {
                s.append("Unspecified");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_deftypeType(const deftypeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (deftypeType::Implementation) : {
                s.append("Implementation");
             break; }
            case (deftypeType::Interface) : {
                s.append("Interface");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_presenceType(const presenceType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (presenceType::Required) : {
                s.append("Required");
             break; }
            case (presenceType::Optional) : {
                s.append("Optional");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_abiType(const abiType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (abiType::Source) : {
                s.append("Source");
             break; }
            case (abiType::LFortranModule) : {
                s.append("LFortranModule");
             break; }
            case (abiType::GFortranModule) : {
                s.append("GFortranModule");
             break; }
            case (abiType::BindC) : {
                s.append("BindC");
             break; }
            case (abiType::BindPython) : {
                s.append("BindPython");
             break; }
            case (abiType::BindJS) : {
                s.append("BindJS");
             break; }
            case (abiType::Interactive) : {
                s.append("Interactive");
             break; }
            case (abiType::Intrinsic) : {
                s.append("Intrinsic");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_dimension(const dimension_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        s.append("\n" + indtd + "|-" + "start=");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "length=");
        last = true;
        if (x.m_length) {
            self().visit_expr(*x.m_length);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_alloc_arg(const alloc_arg_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        s.append("\n" + indtd + "|-" + "a=");
        attached = true;
        self().visit_expr(*x.m_a);
        s.append("\n" + indtd + "|-" + "dims=↧");
        for (size_t i=0; i<x.n_dims; i++) {
            inc_lindent();
            last = i == x.n_dims-1;
            attached = false;
            self().visit_dimension(x.m_dims[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "len_expr=");
        if (x.m_len_expr) {
            self().visit_expr(*x.m_len_expr);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "type=");
        last = true;
        if (x.m_type) {
            self().visit_ttype(*x.m_type);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Attribute(const Attribute_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Attribute");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "└-" + "args=↧");
        for (size_t i=0; i<x.n_args; i++) {
            inc_indent();
            last = i == x.n_args-1;
            attached = false;
            self().visit_attribute_arg(x.m_args[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_attribute_arg(const attribute_arg_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        s.append("\n" + indtd + "└-" + "arg=");
        s.append(x.m_arg);
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_call_arg(const call_arg_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        s.append("\n" + indtd + "└-" + "value=");
        last = true;
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_Bind(const Bind_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Bind");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "lang=");
        s.append("\"" + std::string(x.m_lang) + "\"");
        s.append("\n" + indtd + "└-" + "name=");
        s.append("\"" + std::string(x.m_name) + "\"");
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_array_index(const array_index_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        s.append("\n" + indtd + "|-" + "left=");
        if (x.m_left) {
            self().visit_expr(*x.m_left);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "right=");
        if (x.m_right) {
            self().visit_expr(*x.m_right);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "step=");
        last = true;
        if (x.m_step) {
            self().visit_expr(*x.m_step);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_do_loop_head(const do_loop_head_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        s.append("\n" + indtd + "|-" + "v=");
        if (x.m_v) {
            self().visit_expr(*x.m_v);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "start=");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "end=");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "increment=");
        last = true;
        if (x.m_increment) {
            self().visit_expr(*x.m_increment);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        dec_indent();
    }
    void visit_CaseStmt(const CaseStmt_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CaseStmt");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "test=↧");
        for (size_t i=0; i<x.n_test; i++) {
            inc_lindent();
            last = i == x.n_test-1;
            attached = false;
            self().visit_expr(*x.m_test[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "|-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_lindent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        s.append("\n" + indtd + "└-" + "fall_through=");
        if (x.m_fall_through) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        dec_indent();
    }
    void visit_CaseStmt_Range(const CaseStmt_Range_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CaseStmt_Range");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "start=");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "|-" + "end=");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        last = false;
        attached = false;
        }
        s.append("\n" + indtd + "└-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_indent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_TypeStmtName(const TypeStmtName_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TypeStmtName");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "sym=");
        attached = true;
        self().visit_symbol(*x.m_sym);
        s.append("\n" + indtd + "└-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_indent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_ClassStmt(const ClassStmt_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ClassStmt");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "sym=");
        attached = true;
        self().visit_symbol(*x.m_sym);
        s.append("\n" + indtd + "└-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_indent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_TypeStmtType(const TypeStmtType_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TypeStmtType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "type=");
        attached = true;
        self().visit_ttype(*x.m_type);
        s.append("\n" + indtd + "└-" + "body=↧");
        for (size_t i=0; i<x.n_body; i++) {
            inc_indent();
            last = i == x.n_body-1;
            attached = false;
            self().visit_stmt(*x.m_body[i]);
            dec_indent();
        }
        dec_indent();
    }
    void visit_enumtypeType(const enumtypeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (enumtypeType::IntegerConsecutiveFromZero) : {
                s.append("IntegerConsecutiveFromZero");
             break; }
            case (enumtypeType::IntegerUnique) : {
                s.append("IntegerUnique");
             break; }
            case (enumtypeType::IntegerNotUnique) : {
                s.append("IntegerNotUnique");
             break; }
            case (enumtypeType::NonInteger) : {
                s.append("NonInteger");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_Require(const Require_t &x) {
        if(!attached) {
            if(start_line) {
                start_line = false;
                s.append(indtd);
            } else {
                s.append("\n"+indtd);
            }
            last ? s.append("└-") : s.append("|-");
        }
        last ? inc_indent() : inc_lindent();
        attached = true;
        last = false;
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Require");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append("\n" + indtd + "|-" + "name=");
        s.append(x.m_name);
        s.append("\n" + indtd + "└-" + "args=");
        for (size_t i=0; i<x.n_args; i++) {
            s.append(x.m_args[i]);
            if (i < x.n_args-1) s.append(" ");
        }
        dec_indent();
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_array_physical_typeType(const array_physical_typeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (array_physical_typeType::DescriptorArray) : {
                s.append("DescriptorArray");
             break; }
            case (array_physical_typeType::PointerToDataArray) : {
                s.append("PointerToDataArray");
             break; }
            case (array_physical_typeType::UnboundedPointerToDataArray) : {
                s.append("UnboundedPointerToDataArray");
             break; }
            case (array_physical_typeType::FixedSizeArray) : {
                s.append("FixedSizeArray");
             break; }
            case (array_physical_typeType::CharacterArraySinglePointer) : {
                s.append("CharacterArraySinglePointer");
             break; }
            case (array_physical_typeType::NumPyArray) : {
                s.append("NumPyArray");
             break; }
            case (array_physical_typeType::ISODescriptorArray) : {
                s.append("ISODescriptorArray");
             break; }
            case (array_physical_typeType::SIMDArray) : {
                s.append("SIMDArray");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_binopType(const binopType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (binopType::Add) : {
                s.append("Add");
             break; }
            case (binopType::Sub) : {
                s.append("Sub");
             break; }
            case (binopType::Mul) : {
                s.append("Mul");
             break; }
            case (binopType::Div) : {
                s.append("Div");
             break; }
            case (binopType::Pow) : {
                s.append("Pow");
             break; }
            case (binopType::BitAnd) : {
                s.append("BitAnd");
             break; }
            case (binopType::BitOr) : {
                s.append("BitOr");
             break; }
            case (binopType::BitXor) : {
                s.append("BitXor");
             break; }
            case (binopType::BitLShift) : {
                s.append("BitLShift");
             break; }
            case (binopType::BitRShift) : {
                s.append("BitRShift");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_logicalbinopType(const logicalbinopType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (logicalbinopType::And) : {
                s.append("And");
             break; }
            case (logicalbinopType::Or) : {
                s.append("Or");
             break; }
            case (logicalbinopType::Xor) : {
                s.append("Xor");
             break; }
            case (logicalbinopType::NEqv) : {
                s.append("NEqv");
             break; }
            case (logicalbinopType::Eqv) : {
                s.append("Eqv");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_cmpopType(const cmpopType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (cmpopType::Eq) : {
                s.append("Eq");
             break; }
            case (cmpopType::NotEq) : {
                s.append("NotEq");
             break; }
            case (cmpopType::Lt) : {
                s.append("Lt");
             break; }
            case (cmpopType::LtE) : {
                s.append("LtE");
             break; }
            case (cmpopType::Gt) : {
                s.append("Gt");
             break; }
            case (cmpopType::GtE) : {
                s.append("GtE");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_integerbozType(const integerbozType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (integerbozType::Binary) : {
                s.append("Binary");
             break; }
            case (integerbozType::Hex) : {
                s.append("Hex");
             break; }
            case (integerbozType::Octal) : {
                s.append("Octal");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_arrayboundType(const arrayboundType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (arrayboundType::LBound) : {
                s.append("LBound");
             break; }
            case (arrayboundType::UBound) : {
                s.append("UBound");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_arraystorageType(const arraystorageType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (arraystorageType::RowMajor) : {
                s.append("RowMajor");
             break; }
            case (arraystorageType::ColMajor) : {
                s.append("ColMajor");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_string_format_kindType(const string_format_kindType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (string_format_kindType::FormatFortran) : {
                s.append("FormatFortran");
             break; }
            case (string_format_kindType::FormatC) : {
                s.append("FormatC");
             break; }
            case (string_format_kindType::FormatPythonPercent) : {
                s.append("FormatPythonPercent");
             break; }
            case (string_format_kindType::FormatPythonFString) : {
                s.append("FormatPythonFString");
             break; }
            case (string_format_kindType::FormatPythonFormat) : {
                s.append("FormatPythonFormat");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
};


/******************************************************************************/
// Pickle Visitor base class

template <class Struct>
class PickleBaseVisitor : public BaseVisitor<Struct>
{
private:
    Struct& self() { return static_cast<Struct&>(*this); }
public:
    std::string s, indented = "";
    bool use_colors;
    bool indent;
    int indent_level = 0, indent_spaces = 4;
public:
    PickleBaseVisitor() : use_colors(false), indent(false) { s.reserve(100000); }
    void inc_indent() {
        indent_level++;
        indented = std::string(indent_level*indent_spaces, ' ');
    }
    void dec_indent() {
        indent_level--;
        LCOMPILERS_ASSERT(indent_level >= 0);
        indented = std::string(indent_level*indent_spaces, ' ');
    }
    void visit_TranslationUnit(const TranslationUnit_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TranslationUnit");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("(");
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("{");
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        }
        {
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append(a.first + ":");
                if(indent) {
                    inc_indent();
                    s.append("\n" + indented);
                } else {
                    s.append(" ");
                }
                this->visit_symbol(*a.second);
                if(indent) dec_indent();
                if (i < x.m_symtab->get_scope().size()-1) {
                    s.append(",");
                    if(indent) s.append("\n" + indented);
                    else s.append(" ");
                }
                i++;
            }
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append("})");
        if(indent) dec_indent();
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_items; i++) {
            self().visit_asr(*x.m_items[i]);
            if (i < x.n_items-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Program(const Program_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Program");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("(");
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("{");
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        }
        {
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append(a.first + ":");
                if(indent) {
                    inc_indent();
                    s.append("\n" + indented);
                } else {
                    s.append(" ");
                }
                this->visit_symbol(*a.second);
                if(indent) dec_indent();
                if (i < x.m_symtab->get_scope().size()-1) {
                    s.append(",");
                    if(indent) s.append("\n" + indented);
                    else s.append(" ");
                }
                i++;
            }
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append("})");
        if(indent) dec_indent();
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_dependencies; i++) {
            s.append(x.m_dependencies[i]);
            if (i < x.n_dependencies-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Module(const Module_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Module");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("(");
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("{");
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        }
        {
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append(a.first + ":");
                if(indent) {
                    inc_indent();
                    s.append("\n" + indented);
                } else {
                    s.append(" ");
                }
                this->visit_symbol(*a.second);
                if(indent) dec_indent();
                if (i < x.m_symtab->get_scope().size()-1) {
                    s.append(",");
                    if(indent) s.append("\n" + indented);
                    else s.append(" ");
                }
                i++;
            }
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append("})");
        if(indent) dec_indent();
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_dependencies; i++) {
            s.append(x.m_dependencies[i]);
            if (i < x.n_dependencies-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_loaded_from_mod) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_intrinsic) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Function(const Function_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Function");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("(");
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("{");
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        }
        {
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append(a.first + ":");
                if(indent) {
                    inc_indent();
                    s.append("\n" + indented);
                } else {
                    s.append(" ");
                }
                this->visit_symbol(*a.second);
                if(indent) dec_indent();
                if (i < x.m_symtab->get_scope().size()-1) {
                    s.append(",");
                    if(indent) s.append("\n" + indented);
                    else s.append(" ");
                }
                i++;
            }
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append("})");
        if(indent) dec_indent();
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_function_signature);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_dependencies; i++) {
            s.append(x.m_dependencies[i]);
            if (i < x.n_dependencies-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_return_var) {
            self().visit_expr(*x.m_return_var);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_accessType(x.m_access);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_deterministic) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_side_effect_free) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_module_file) {
            s.append("\"" + str_escape_c(x.m_module_file) + "\"");
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_GenericProcedure(const GenericProcedure_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("GenericProcedure");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_parent_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_procs; i++) {
            self().visit_symbol(*x.m_procs[i]);
            if (i < x.n_procs-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_accessType(x.m_access);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_CustomOperator(const CustomOperator_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CustomOperator");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_parent_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_procs; i++) {
            self().visit_symbol(*x.m_procs[i]);
            if (i < x.n_procs-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_accessType(x.m_access);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ExternalSymbol(const ExternalSymbol_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ExternalSymbol");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_parent_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_symbol(*x.m_external);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_module_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_scope_names; i++) {
            s.append(x.m_scope_names[i]);
            if (i < x.n_scope_names-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_original_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_accessType(x.m_access);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_StructType(const StructType_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StructType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("(");
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("{");
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        }
        {
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append(a.first + ":");
                if(indent) {
                    inc_indent();
                    s.append("\n" + indented);
                } else {
                    s.append(" ");
                }
                this->visit_symbol(*a.second);
                if(indent) dec_indent();
                if (i < x.m_symtab->get_scope().size()-1) {
                    s.append(",");
                    if(indent) s.append("\n" + indented);
                    else s.append(" ");
                }
                i++;
            }
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append("})");
        if(indent) dec_indent();
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_dependencies; i++) {
            s.append(x.m_dependencies[i]);
            if (i < x.n_dependencies-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_members; i++) {
            s.append(x.m_members[i]);
            if (i < x.n_members-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_abiType(x.m_abi);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_accessType(x.m_access);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_is_packed) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_is_abstract) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_initializers; i++) {
            self().visit_call_arg(x.m_initializers[i]);
            if (i < x.n_initializers-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_alignment) {
            self().visit_expr(*x.m_alignment);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_parent) {
            self().visit_symbol(*x.m_parent);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_EnumType(const EnumType_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("EnumType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("(");
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("{");
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        }
        {
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append(a.first + ":");
                if(indent) {
                    inc_indent();
                    s.append("\n" + indented);
                } else {
                    s.append(" ");
                }
                this->visit_symbol(*a.second);
                if(indent) dec_indent();
                if (i < x.m_symtab->get_scope().size()-1) {
                    s.append(",");
                    if(indent) s.append("\n" + indented);
                    else s.append(" ");
                }
                i++;
            }
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append("})");
        if(indent) dec_indent();
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_dependencies; i++) {
            s.append(x.m_dependencies[i]);
            if (i < x.n_dependencies-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_members; i++) {
            s.append(x.m_members[i]);
            if (i < x.n_members-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_abiType(x.m_abi);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_accessType(x.m_access);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_enumtypeType(x.m_enum_value_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_parent) {
            self().visit_symbol(*x.m_parent);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_UnionType(const UnionType_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnionType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("(");
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("{");
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        }
        {
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append(a.first + ":");
                if(indent) {
                    inc_indent();
                    s.append("\n" + indented);
                } else {
                    s.append(" ");
                }
                this->visit_symbol(*a.second);
                if(indent) dec_indent();
                if (i < x.m_symtab->get_scope().size()-1) {
                    s.append(",");
                    if(indent) s.append("\n" + indented);
                    else s.append(" ");
                }
                i++;
            }
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append("})");
        if(indent) dec_indent();
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_dependencies; i++) {
            s.append(x.m_dependencies[i]);
            if (i < x.n_dependencies-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_members; i++) {
            s.append(x.m_members[i]);
            if (i < x.n_members-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_abiType(x.m_abi);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_accessType(x.m_access);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_initializers; i++) {
            self().visit_call_arg(x.m_initializers[i]);
            if (i < x.n_initializers-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_parent) {
            self().visit_symbol(*x.m_parent);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Variable(const Variable_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Variable");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_parent_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_dependencies; i++) {
            s.append(x.m_dependencies[i]);
            if (i < x.n_dependencies-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_intentType(x.m_intent);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_symbolic_value) {
            self().visit_expr(*x.m_symbolic_value);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_storage_typeType(x.m_storage);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_type_declaration) {
            self().visit_symbol(*x.m_type_declaration);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_abiType(x.m_abi);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_accessType(x.m_access);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_presenceType(x.m_presence);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value_attr) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ClassType(const ClassType_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ClassType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("(");
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("{");
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        }
        {
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append(a.first + ":");
                if(indent) {
                    inc_indent();
                    s.append("\n" + indented);
                } else {
                    s.append(" ");
                }
                this->visit_symbol(*a.second);
                if(indent) dec_indent();
                if (i < x.m_symtab->get_scope().size()-1) {
                    s.append(",");
                    if(indent) s.append("\n" + indented);
                    else s.append(" ");
                }
                i++;
            }
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append("})");
        if(indent) dec_indent();
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_abiType(x.m_abi);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_accessType(x.m_access);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ClassProcedure(const ClassProcedure_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ClassProcedure");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_parent_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_self_argument) {
            s.append(x.m_self_argument);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_proc_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_symbol(*x.m_proc);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_abiType(x.m_abi);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_is_deferred) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_is_nopass) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_AssociateBlock(const AssociateBlock_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AssociateBlock");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("(");
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("{");
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        }
        {
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append(a.first + ":");
                if(indent) {
                    inc_indent();
                    s.append("\n" + indented);
                } else {
                    s.append(" ");
                }
                this->visit_symbol(*a.second);
                if(indent) dec_indent();
                if (i < x.m_symtab->get_scope().size()-1) {
                    s.append(",");
                    if(indent) s.append("\n" + indented);
                    else s.append(" ");
                }
                i++;
            }
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append("})");
        if(indent) dec_indent();
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Block(const Block_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Block");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("(");
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("{");
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        }
        {
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append(a.first + ":");
                if(indent) {
                    inc_indent();
                    s.append("\n" + indented);
                } else {
                    s.append(" ");
                }
                this->visit_symbol(*a.second);
                if(indent) dec_indent();
                if (i < x.m_symtab->get_scope().size()-1) {
                    s.append(",");
                    if(indent) s.append("\n" + indented);
                    else s.append(" ");
                }
                i++;
            }
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append("})");
        if(indent) dec_indent();
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Requirement(const Requirement_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Requirement");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("(");
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("{");
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        }
        {
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append(a.first + ":");
                if(indent) {
                    inc_indent();
                    s.append("\n" + indented);
                } else {
                    s.append(" ");
                }
                this->visit_symbol(*a.second);
                if(indent) dec_indent();
                if (i < x.m_symtab->get_scope().size()-1) {
                    s.append(",");
                    if(indent) s.append("\n" + indented);
                    else s.append(" ");
                }
                i++;
            }
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append("})");
        if(indent) dec_indent();
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            s.append(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_requires; i++) {
            self().visit_require_instantiation(*x.m_requires[i]);
            if (i < x.n_requires-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Template(const Template_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Template");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("(");
        if (use_colors) {
            s.append(color(fg::yellow));
        }
        s.append("SymbolTable");
        if (use_colors) {
            s.append(color(fg::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_symtab->get_counter());
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("{");
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        }
        {
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append(a.first + ":");
                if(indent) {
                    inc_indent();
                    s.append("\n" + indented);
                } else {
                    s.append(" ");
                }
                this->visit_symbol(*a.second);
                if(indent) dec_indent();
                if (i < x.m_symtab->get_scope().size()-1) {
                    s.append(",");
                    if(indent) s.append("\n" + indented);
                    else s.append(" ");
                }
                i++;
            }
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append("})");
        if(indent) dec_indent();
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            s.append(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_requires; i++) {
            self().visit_require_instantiation(*x.m_requires[i]);
            if (i < x.n_requires-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Allocate(const Allocate_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Allocate");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_alloc_arg(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_stat) {
            self().visit_expr(*x.m_stat);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_errmsg) {
            self().visit_expr(*x.m_errmsg);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_source) {
            self().visit_expr(*x.m_source);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ReAlloc(const ReAlloc_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ReAlloc");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_alloc_arg(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Assign(const Assign_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Assign");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_variable);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Assignment(const Assignment_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Assignment");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_target);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_value);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_overloaded) {
            self().visit_stmt(*x.m_overloaded);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Associate(const Associate_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Associate");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_target);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_value);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Cycle(const Cycle_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Cycle");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ExplicitDeallocate(const ExplicitDeallocate_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ExplicitDeallocate");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_vars; i++) {
            self().visit_expr(*x.m_vars[i]);
            if (i < x.n_vars-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ImplicitDeallocate(const ImplicitDeallocate_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ImplicitDeallocate");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_vars; i++) {
            self().visit_expr(*x.m_vars[i]);
            if (i < x.n_vars-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_DoConcurrentLoop(const DoConcurrentLoop_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DoConcurrentLoop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_do_loop_head(x.m_head);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_shared; i++) {
            self().visit_expr(*x.m_shared[i]);
            if (i < x.n_shared-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_local; i++) {
            self().visit_expr(*x.m_local[i]);
            if (i < x.n_local-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_DoLoop(const DoLoop_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DoLoop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_name) {
            s.append(x.m_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_do_loop_head(x.m_head);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_orelse; i++) {
            self().visit_stmt(*x.m_orelse[i]);
            if (i < x.n_orelse-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ErrorStop(const ErrorStop_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ErrorStop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_code) {
            self().visit_expr(*x.m_code);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Exit(const Exit_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Exit");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_stmt_name) {
            s.append(x.m_stmt_name);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ForAllSingle(const ForAllSingle_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ForAllSingle");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_do_loop_head(x.m_head);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_stmt(*x.m_assign_stmt);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_GoTo(const GoTo_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("GoTo");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_target_id));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_GoToTarget(const GoToTarget_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("GoToTarget");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_id));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(x.m_name);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_If(const If_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("If");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_test);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_orelse; i++) {
            self().visit_stmt(*x.m_orelse[i]);
            if (i < x.n_orelse-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_IfArithmetic(const IfArithmetic_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IfArithmetic");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_test);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(std::to_string(x.m_lt_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(std::to_string(x.m_eq_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(std::to_string(x.m_gt_label));
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Print(const Print_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Print");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
            if (i < x.n_values-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_separator) {
            self().visit_expr(*x.m_separator);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_FileOpen(const FileOpen_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FileOpen");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_newunit) {
            self().visit_expr(*x.m_newunit);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_filename) {
            self().visit_expr(*x.m_filename);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_status) {
            self().visit_expr(*x.m_status);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_form) {
            self().visit_expr(*x.m_form);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_FileClose(const FileClose_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FileClose");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_iomsg) {
            self().visit_expr(*x.m_iomsg);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_err) {
            self().visit_expr(*x.m_err);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_status) {
            self().visit_expr(*x.m_status);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_FileRead(const FileRead_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FileRead");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_fmt) {
            self().visit_expr(*x.m_fmt);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_iomsg) {
            self().visit_expr(*x.m_iomsg);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_size) {
            self().visit_expr(*x.m_size);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_id) {
            self().visit_expr(*x.m_id);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
            if (i < x.n_values-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_overloaded) {
            self().visit_stmt(*x.m_overloaded);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_FileBackspace(const FileBackspace_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FileBackspace");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_err) {
            self().visit_expr(*x.m_err);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_FileRewind(const FileRewind_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FileRewind");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_err) {
            self().visit_expr(*x.m_err);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_FileInquire(const FileInquire_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FileInquire");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_file) {
            self().visit_expr(*x.m_file);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_err) {
            self().visit_expr(*x.m_err);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_exist) {
            self().visit_expr(*x.m_exist);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_opened) {
            self().visit_expr(*x.m_opened);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_number) {
            self().visit_expr(*x.m_number);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_named) {
            self().visit_expr(*x.m_named);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_name) {
            self().visit_expr(*x.m_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_access) {
            self().visit_expr(*x.m_access);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_sequential) {
            self().visit_expr(*x.m_sequential);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_direct) {
            self().visit_expr(*x.m_direct);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_form) {
            self().visit_expr(*x.m_form);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_formatted) {
            self().visit_expr(*x.m_formatted);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_unformatted) {
            self().visit_expr(*x.m_unformatted);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_recl) {
            self().visit_expr(*x.m_recl);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_nextrec) {
            self().visit_expr(*x.m_nextrec);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_blank) {
            self().visit_expr(*x.m_blank);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_position) {
            self().visit_expr(*x.m_position);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_action) {
            self().visit_expr(*x.m_action);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_read) {
            self().visit_expr(*x.m_read);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_write) {
            self().visit_expr(*x.m_write);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_readwrite) {
            self().visit_expr(*x.m_readwrite);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_delim) {
            self().visit_expr(*x.m_delim);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_pad) {
            self().visit_expr(*x.m_pad);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_flen) {
            self().visit_expr(*x.m_flen);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_blocksize) {
            self().visit_expr(*x.m_blocksize);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_convert) {
            self().visit_expr(*x.m_convert);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_carriagecontrol) {
            self().visit_expr(*x.m_carriagecontrol);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_iolength) {
            self().visit_expr(*x.m_iolength);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_FileWrite(const FileWrite_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FileWrite");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_iomsg) {
            self().visit_expr(*x.m_iomsg);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_id) {
            self().visit_expr(*x.m_id);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
            if (i < x.n_values-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_separator) {
            self().visit_expr(*x.m_separator);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_overloaded) {
            self().visit_stmt(*x.m_overloaded);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Return(const Return_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Return");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Select(const Select_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Select");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_test);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_case_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_default; i++) {
            self().visit_stmt(*x.m_default[i]);
            if (i < x.n_default-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_enable_fall_through) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Stop(const Stop_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Stop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_code) {
            self().visit_expr(*x.m_code);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Assert(const Assert_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Assert");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_test);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_msg) {
            self().visit_expr(*x.m_msg);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_SubroutineCall(const SubroutineCall_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SubroutineCall");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_symbol(*x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_original_name) {
            self().visit_symbol(*x.m_original_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_call_arg(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_dt) {
            self().visit_expr(*x.m_dt);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_IntrinsicImpureSubroutine(const IntrinsicImpureSubroutine_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntrinsicImpureSubroutine");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(self().convert_intrinsic_id(x.m_intrinsic_id));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(std::to_string(x.m_overload_id));
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Where(const Where_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Where");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_test);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_orelse; i++) {
            self().visit_stmt(*x.m_orelse[i]);
            if (i < x.n_orelse-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_WhileLoop(const WhileLoop_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("WhileLoop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_name) {
            s.append(x.m_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_test);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_orelse; i++) {
            self().visit_stmt(*x.m_orelse[i]);
            if (i < x.n_orelse-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Nullify(const Nullify_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Nullify");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_vars; i++) {
            self().visit_symbol(*x.m_vars[i]);
            if (i < x.n_vars-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Flush(const Flush_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Flush");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_unit);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_err) {
            self().visit_expr(*x.m_err);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_iomsg) {
            self().visit_expr(*x.m_iomsg);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ListAppend(const ListAppend_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListAppend");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_a);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_ele);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_AssociateBlockCall(const AssociateBlockCall_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("AssociateBlockCall");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_symbol(*x.m_m);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_SelectType(const SelectType_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SelectType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_selector);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_type_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_default; i++) {
            self().visit_stmt(*x.m_default[i]);
            if (i < x.n_default-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_CPtrToPointer(const CPtrToPointer_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CPtrToPointer");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_cptr);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_ptr);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_shape) {
            self().visit_expr(*x.m_shape);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_lower_bounds) {
            self().visit_expr(*x.m_lower_bounds);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_BlockCall(const BlockCall_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("BlockCall");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_label));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_symbol(*x.m_m);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_SetInsert(const SetInsert_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SetInsert");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_a);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_ele);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_SetRemove(const SetRemove_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SetRemove");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_a);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_ele);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ListInsert(const ListInsert_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListInsert");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_a);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_pos);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_ele);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ListRemove(const ListRemove_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListRemove");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_a);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_ele);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ListClear(const ListClear_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListClear");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_a);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_DictInsert(const DictInsert_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DictInsert");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_a);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_key);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_value);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Expr(const Expr_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Expr");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_expression);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_IfExp(const IfExp_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IfExp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_test);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_body);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_orelse);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ComplexConstructor(const ComplexConstructor_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ComplexConstructor");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_re);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_im);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_NamedExpr(const NamedExpr_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("NamedExpr");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_target);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_value);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_FunctionCall(const FunctionCall_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FunctionCall");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_symbol(*x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_original_name) {
            self().visit_symbol(*x.m_original_name);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_call_arg(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_dt) {
            self().visit_expr(*x.m_dt);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_IntrinsicElementalFunction(const IntrinsicElementalFunction_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntrinsicElementalFunction");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(self().convert_intrinsic_id(x.m_intrinsic_id));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(std::to_string(x.m_overload_id));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_type) {
            self().visit_ttype(*x.m_type);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_IntrinsicArrayFunction(const IntrinsicArrayFunction_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntrinsicArrayFunction");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(self().convert_array_intrinsic_id(x.m_arr_intrinsic_id));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(std::to_string(x.m_overload_id));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_type) {
            self().visit_ttype(*x.m_type);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_IntrinsicImpureFunction(const IntrinsicImpureFunction_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntrinsicImpureFunction");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(self().convert_impure_intrinsic_id(x.m_impure_intrinsic_id));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(std::to_string(x.m_overload_id));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_type) {
            self().visit_ttype(*x.m_type);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_TypeInquiry(const TypeInquiry_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TypeInquiry");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(self().convert_intrinsic_id(x.m_inquiry_id));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_arg_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_arg) {
            self().visit_expr(*x.m_arg);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_value);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_StructTypeConstructor(const StructTypeConstructor_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StructTypeConstructor");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_symbol(*x.m_dt_sym);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_call_arg(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_EnumTypeConstructor(const EnumTypeConstructor_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("EnumTypeConstructor");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_symbol(*x.m_dt_sym);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_UnionTypeConstructor(const UnionTypeConstructor_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnionTypeConstructor");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_symbol(*x.m_dt_sym);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ImpliedDoLoop(const ImpliedDoLoop_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ImpliedDoLoop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
            if (i < x.n_values-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_var);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_start);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_end);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_increment) {
            self().visit_expr(*x.m_increment);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_IntegerConstant(const IntegerConstant_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntegerConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_n));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_IntegerBOZ(const IntegerBOZ_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntegerBOZ");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_v));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_integerbozType(x.m_intboz_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_type) {
            self().visit_ttype(*x.m_type);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_IntegerBitNot(const IntegerBitNot_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntegerBitNot");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_IntegerUnaryMinus(const IntegerUnaryMinus_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntegerUnaryMinus");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_IntegerCompare(const IntegerCompare_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntegerCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_cmpopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_IntegerBinOp(const IntegerBinOp_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntegerBinOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_binopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_UnsignedIntegerConstant(const UnsignedIntegerConstant_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnsignedIntegerConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_n));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_UnsignedIntegerUnaryMinus(const UnsignedIntegerUnaryMinus_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnsignedIntegerUnaryMinus");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_UnsignedIntegerBitNot(const UnsignedIntegerBitNot_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnsignedIntegerBitNot");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_UnsignedIntegerCompare(const UnsignedIntegerCompare_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnsignedIntegerCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_cmpopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_UnsignedIntegerBinOp(const UnsignedIntegerBinOp_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnsignedIntegerBinOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_binopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_RealConstant(const RealConstant_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RealConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_r));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_RealUnaryMinus(const RealUnaryMinus_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RealUnaryMinus");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_RealCompare(const RealCompare_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RealCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_cmpopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_RealBinOp(const RealBinOp_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RealBinOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_binopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_RealCopySign(const RealCopySign_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RealCopySign");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_target);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_source);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ComplexConstant(const ComplexConstant_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ComplexConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_re));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append(std::to_string(x.m_im));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ComplexUnaryMinus(const ComplexUnaryMinus_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ComplexUnaryMinus");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ComplexCompare(const ComplexCompare_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ComplexCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_cmpopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ComplexBinOp(const ComplexBinOp_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ComplexBinOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_binopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_LogicalConstant(const LogicalConstant_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("LogicalConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_value) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_LogicalNot(const LogicalNot_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("LogicalNot");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_LogicalCompare(const LogicalCompare_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("LogicalCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_cmpopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_LogicalBinOp(const LogicalBinOp_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("LogicalBinOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_logicalbinopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ListConstant(const ListConstant_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ListLen(const ListLen_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListLen");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ListConcat(const ListConcat_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListConcat");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ListCompare(const ListCompare_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_cmpopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ListCount(const ListCount_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListCount");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_ele);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_SetConstant(const SetConstant_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SetConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_elements; i++) {
            self().visit_expr(*x.m_elements[i]);
            if (i < x.n_elements-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_SetLen(const SetLen_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SetLen");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_TupleConstant(const TupleConstant_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TupleConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_elements; i++) {
            self().visit_expr(*x.m_elements[i]);
            if (i < x.n_elements-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_TupleLen(const TupleLen_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TupleLen");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_value);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_TupleCompare(const TupleCompare_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TupleCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_cmpopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_TupleConcat(const TupleConcat_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TupleConcat");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_StringConstant(const StringConstant_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("\"" + str_escape_c(x.m_s) + "\"");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_StringConcat(const StringConcat_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringConcat");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_StringRepeat(const StringRepeat_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringRepeat");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_StringLen(const StringLen_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringLen");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_StringItem(const StringItem_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringItem");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_idx);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_StringSection(const StringSection_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringSection");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_step) {
            self().visit_expr(*x.m_step);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_StringCompare(const StringCompare_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_cmpopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_StringOrd(const StringOrd_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringOrd");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_StringChr(const StringChr_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringChr");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_StringFormat(const StringFormat_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StringFormat");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_fmt);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_string_format_kindType(x.m_kind);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_CPtrCompare(const CPtrCompare_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CPtrCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_cmpopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_SymbolicCompare(const SymbolicCompare_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SymbolicCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_cmpopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_DictConstant(const DictConstant_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DictConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_keys; i++) {
            self().visit_expr(*x.m_keys[i]);
            if (i < x.n_keys-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_values; i++) {
            self().visit_expr(*x.m_values[i]);
            if (i < x.n_values-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_DictLen(const DictLen_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DictLen");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Var(const Var_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Var");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        self().visit_symbol(*x.m_v);
        s.append(")");
    }
    void visit_FunctionParam(const FunctionParam_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FunctionParam");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_param_number));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ArrayConstructor(const ArrayConstructor_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayConstructor");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_expr(*x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_arraystorageType(x.m_storage_format);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ArrayConstant(const ArrayConstant_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_n_data));
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_arraystorageType(x.m_storage_format);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ArrayItem(const ArrayItem_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayItem");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_v);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_array_index(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_arraystorageType(x.m_storage_format);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ArraySection(const ArraySection_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArraySection");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_v);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_array_index(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ArraySize(const ArraySize_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArraySize");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_v);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_dim) {
            self().visit_expr(*x.m_dim);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ArrayBound(const ArrayBound_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayBound");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_v);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_dim) {
            self().visit_expr(*x.m_dim);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_arrayboundType(x.m_bound);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ArrayTranspose(const ArrayTranspose_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayTranspose");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_matrix);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ArrayPack(const ArrayPack_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayPack");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_array);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_mask);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_vector) {
            self().visit_expr(*x.m_vector);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ArrayReshape(const ArrayReshape_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayReshape");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_array);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_shape);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ArrayBroadcast(const ArrayBroadcast_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayBroadcast");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_array);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_shape);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_BitCast(const BitCast_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("BitCast");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_source);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_mold);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_size) {
            self().visit_expr(*x.m_size);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_StructInstanceMember(const StructInstanceMember_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StructInstanceMember");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_v);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_symbol(*x.m_m);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_StructStaticMember(const StructStaticMember_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("StructStaticMember");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_v);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_symbol(*x.m_m);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_EnumStaticMember(const EnumStaticMember_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("EnumStaticMember");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_v);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_symbol(*x.m_m);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_UnionInstanceMember(const UnionInstanceMember_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnionInstanceMember");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_v);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_symbol(*x.m_m);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_EnumName(const EnumName_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("EnumName");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_v);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_enum_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_EnumValue(const EnumValue_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("EnumValue");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_v);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_enum_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_OverloadedCompare(const OverloadedCompare_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OverloadedCompare");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_cmpopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_overloaded);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_OverloadedBinOp(const OverloadedBinOp_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OverloadedBinOp");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_binopType(x.m_op);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_overloaded);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_OverloadedUnaryMinus(const OverloadedUnaryMinus_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OverloadedUnaryMinus");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_overloaded);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_OverloadedStringConcat(const OverloadedStringConcat_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("OverloadedStringConcat");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_overloaded);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Cast(const Cast_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Cast");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_cast_kindType(x.m_kind);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ArrayPhysicalCast(const ArrayPhysicalCast_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ArrayPhysicalCast");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_array_physical_typeType(x.m_old);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_array_physical_typeType(x.m_new);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ComplexRe(const ComplexRe_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ComplexRe");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ComplexIm(const ComplexIm_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ComplexIm");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_DictItem(const DictItem_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DictItem");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_a);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_key);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_default) {
            self().visit_expr(*x.m_default);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_CLoc(const CLoc_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CLoc");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_PointerToCPtr(const PointerToCPtr_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("PointerToCPtr");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_GetPointer(const GetPointer_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("GetPointer");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ListItem(const ListItem_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListItem");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_a);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_pos);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_TupleItem(const TupleItem_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TupleItem");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_a);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_pos);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ListSection(const ListSection_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListSection");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_a);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_array_index(x.m_section);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ListRepeat(const ListRepeat_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ListRepeat");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_left);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_right);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_DictPop(const DictPop_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("DictPop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_a);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_expr(*x.m_key);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_SetPop(const SetPop_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SetPop");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_a);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_IntegerBitLen(const IntegerBitLen_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("IntegerBitLen");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_a);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Ichar(const Ichar_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Ichar");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Iachar(const Iachar_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Iachar");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_SizeOfType(const SizeOfType_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SizeOfType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_ttype(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_PointerNullConstant(const PointerNullConstant_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("PointerNullConstant");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_ttype(*x.m_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_PointerAssociated(const PointerAssociated_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("PointerAssociated");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_ptr);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_tgt) {
            self().visit_expr(*x.m_tgt);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_RealSqrt(const RealSqrt_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("RealSqrt");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_expr(*x.m_arg);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Integer(const Integer_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Integer");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(std::to_string(x.m_kind));
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UnsignedInteger(const UnsignedInteger_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("UnsignedInteger");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(std::to_string(x.m_kind));
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Real(const Real_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Real");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(std::to_string(x.m_kind));
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Complex(const Complex_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Complex");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(std::to_string(x.m_kind));
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Character(const Character_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Character");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(std::to_string(x.m_kind));
        s.append(" ");
        s.append(std::to_string(x.m_len));
        s.append(" ");
        if (x.m_len_expr) {
            self().visit_expr(*x.m_len_expr);
        } else {
            s.append("()");
        }
        s.append(")");
    }
    void visit_Logical(const Logical_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Logical");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(" ");
        s.append(std::to_string(x.m_kind));
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Set(const Set_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Set");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_ttype(*x.m_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_List(const List_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("List");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_ttype(*x.m_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Tuple(const Tuple_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Tuple");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_type; i++) {
            self().visit_ttype(*x.m_type[i]);
            if (i < x.n_type-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Struct(const Struct_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Struct");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_symbol(*x.m_derived_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Enum(const Enum_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Enum");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_symbol(*x.m_enum_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Union(const Union_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Union");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_symbol(*x.m_union_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Class(const Class_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Class");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_symbol(*x.m_class_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Dict(const Dict_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Dict");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_ttype(*x.m_key_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        self().visit_ttype(*x.m_value_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Pointer(const Pointer_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Pointer");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_ttype(*x.m_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_Allocatable(const Allocatable_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Allocatable");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_ttype(*x.m_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_CPtr(const CPtr_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CPtr");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SymbolicExpression(const SymbolicExpression_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("SymbolicExpression");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_TypeParameter(const TypeParameter_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TypeParameter");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_param);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Array(const Array_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Array");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_dims; i++) {
            self().visit_dimension(x.m_dims[i]);
            if (i < x.n_dims-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_array_physical_typeType(x.m_physical_type);
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_FunctionType(const FunctionType_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("FunctionType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_arg_types; i++) {
            self().visit_ttype(*x.m_arg_types[i]);
            if (i < x.n_arg_types-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_return_var_type) {
            self().visit_ttype(*x.m_return_var_type);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_abiType(x.m_abi);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        visit_deftypeType(x.m_deftype);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_bindc_name) {
            s.append("\"" + str_escape_c(x.m_bindc_name) + "\"");
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_elemental) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_pure) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_module) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_inline) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_static) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_restrictions; i++) {
            self().visit_symbol(*x.m_restrictions[i]);
            if (i < x.n_restrictions-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_is_restriction) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_cast_kindType(const cast_kindType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (cast_kindType::RealToInteger) : {
                s.append("RealToInteger");
             break; }
            case (cast_kindType::IntegerToReal) : {
                s.append("IntegerToReal");
             break; }
            case (cast_kindType::LogicalToReal) : {
                s.append("LogicalToReal");
             break; }
            case (cast_kindType::RealToReal) : {
                s.append("RealToReal");
             break; }
            case (cast_kindType::IntegerToInteger) : {
                s.append("IntegerToInteger");
             break; }
            case (cast_kindType::RealToComplex) : {
                s.append("RealToComplex");
             break; }
            case (cast_kindType::IntegerToComplex) : {
                s.append("IntegerToComplex");
             break; }
            case (cast_kindType::IntegerToLogical) : {
                s.append("IntegerToLogical");
             break; }
            case (cast_kindType::RealToLogical) : {
                s.append("RealToLogical");
             break; }
            case (cast_kindType::CharacterToLogical) : {
                s.append("CharacterToLogical");
             break; }
            case (cast_kindType::CharacterToInteger) : {
                s.append("CharacterToInteger");
             break; }
            case (cast_kindType::CharacterToList) : {
                s.append("CharacterToList");
             break; }
            case (cast_kindType::ComplexToLogical) : {
                s.append("ComplexToLogical");
             break; }
            case (cast_kindType::ComplexToComplex) : {
                s.append("ComplexToComplex");
             break; }
            case (cast_kindType::ComplexToReal) : {
                s.append("ComplexToReal");
             break; }
            case (cast_kindType::ComplexToInteger) : {
                s.append("ComplexToInteger");
             break; }
            case (cast_kindType::LogicalToInteger) : {
                s.append("LogicalToInteger");
             break; }
            case (cast_kindType::RealToCharacter) : {
                s.append("RealToCharacter");
             break; }
            case (cast_kindType::IntegerToCharacter) : {
                s.append("IntegerToCharacter");
             break; }
            case (cast_kindType::LogicalToCharacter) : {
                s.append("LogicalToCharacter");
             break; }
            case (cast_kindType::UnsignedIntegerToInteger) : {
                s.append("UnsignedIntegerToInteger");
             break; }
            case (cast_kindType::UnsignedIntegerToUnsignedInteger) : {
                s.append("UnsignedIntegerToUnsignedInteger");
             break; }
            case (cast_kindType::UnsignedIntegerToReal) : {
                s.append("UnsignedIntegerToReal");
             break; }
            case (cast_kindType::UnsignedIntegerToLogical) : {
                s.append("UnsignedIntegerToLogical");
             break; }
            case (cast_kindType::IntegerToUnsignedInteger) : {
                s.append("IntegerToUnsignedInteger");
             break; }
            case (cast_kindType::RealToUnsignedInteger) : {
                s.append("RealToUnsignedInteger");
             break; }
            case (cast_kindType::CPtrToUnsignedInteger) : {
                s.append("CPtrToUnsignedInteger");
             break; }
            case (cast_kindType::UnsignedIntegerToCPtr) : {
                s.append("UnsignedIntegerToCPtr");
             break; }
            case (cast_kindType::IntegerToSymbolicExpression) : {
                s.append("IntegerToSymbolicExpression");
             break; }
            case (cast_kindType::ListToArray) : {
                s.append("ListToArray");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_storage_typeType(const storage_typeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (storage_typeType::Default) : {
                s.append("Default");
             break; }
            case (storage_typeType::Save) : {
                s.append("Save");
             break; }
            case (storage_typeType::Parameter) : {
                s.append("Parameter");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_accessType(const accessType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (accessType::Public) : {
                s.append("Public");
             break; }
            case (accessType::Private) : {
                s.append("Private");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_intentType(const intentType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (intentType::Local) : {
                s.append("Local");
             break; }
            case (intentType::In) : {
                s.append("In");
             break; }
            case (intentType::Out) : {
                s.append("Out");
             break; }
            case (intentType::InOut) : {
                s.append("InOut");
             break; }
            case (intentType::ReturnVar) : {
                s.append("ReturnVar");
             break; }
            case (intentType::Unspecified) : {
                s.append("Unspecified");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_deftypeType(const deftypeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (deftypeType::Implementation) : {
                s.append("Implementation");
             break; }
            case (deftypeType::Interface) : {
                s.append("Interface");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_presenceType(const presenceType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (presenceType::Required) : {
                s.append("Required");
             break; }
            case (presenceType::Optional) : {
                s.append("Optional");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_abiType(const abiType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (abiType::Source) : {
                s.append("Source");
             break; }
            case (abiType::LFortranModule) : {
                s.append("LFortranModule");
             break; }
            case (abiType::GFortranModule) : {
                s.append("GFortranModule");
             break; }
            case (abiType::BindC) : {
                s.append("BindC");
             break; }
            case (abiType::BindPython) : {
                s.append("BindPython");
             break; }
            case (abiType::BindJS) : {
                s.append("BindJS");
             break; }
            case (abiType::Interactive) : {
                s.append("Interactive");
             break; }
            case (abiType::Intrinsic) : {
                s.append("Intrinsic");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_dimension(const dimension_t &x) {
        s.append("(");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_length) {
            self().visit_expr(*x.m_length);
        } else {
            s.append("()");
        }
        s.append(")");
    }
    void visit_alloc_arg(const alloc_arg_t &x) {
        s.append("(");
        self().visit_expr(*x.m_a);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_dims; i++) {
            self().visit_dimension(x.m_dims[i]);
            if (i < x.n_dims-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_len_expr) {
            self().visit_expr(*x.m_len_expr);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_type) {
            self().visit_ttype(*x.m_type);
        } else {
            s.append("()");
        }
        s.append(")");
    }
    void visit_Attribute(const Attribute_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Attribute");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            self().visit_attribute_arg(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_attribute_arg(const attribute_arg_t &x) {
        s.append("(");
        s.append(x.m_arg);
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_call_arg(const call_arg_t &x) {
        s.append("(");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("()");
        }
        s.append(")");
    }
    void visit_Bind(const Bind_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Bind");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("\"" + str_escape_c(x.m_lang) + "\"");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("\"" + str_escape_c(x.m_name) + "\"");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_array_index(const array_index_t &x) {
        s.append("(");
        if (x.m_left) {
            self().visit_expr(*x.m_left);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_right) {
            self().visit_expr(*x.m_right);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_step) {
            self().visit_expr(*x.m_step);
        } else {
            s.append("()");
        }
        s.append(")");
    }
    void visit_do_loop_head(const do_loop_head_t &x) {
        s.append("(");
        if (x.m_v) {
            self().visit_expr(*x.m_v);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_increment) {
            self().visit_expr(*x.m_increment);
        } else {
            s.append("()");
        }
        s.append(")");
    }
    void visit_CaseStmt(const CaseStmt_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CaseStmt");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append("[");
        for (size_t i=0; i<x.n_test; i++) {
            self().visit_expr(*x.m_test[i]);
            if (i < x.n_test-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_fall_through) {
            s.append(".true.");
        } else {
            s.append(".false.");
        }
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_CaseStmt_Range(const CaseStmt_Range_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("CaseStmt_Range");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("()");
        }
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_TypeStmtName(const TypeStmtName_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TypeStmtName");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_symbol(*x.m_sym);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_ClassStmt(const ClassStmt_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("ClassStmt");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_symbol(*x.m_sym);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_TypeStmtType(const TypeStmtType_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("TypeStmtType");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        self().visit_ttype(*x.m_type);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_body; i++) {
            self().visit_stmt(*x.m_body[i]);
            if (i < x.n_body-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
    }
    void visit_enumtypeType(const enumtypeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (enumtypeType::IntegerConsecutiveFromZero) : {
                s.append("IntegerConsecutiveFromZero");
             break; }
            case (enumtypeType::IntegerUnique) : {
                s.append("IntegerUnique");
             break; }
            case (enumtypeType::IntegerNotUnique) : {
                s.append("IntegerNotUnique");
             break; }
            case (enumtypeType::NonInteger) : {
                s.append("NonInteger");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_Require(const Require_t &x) {
        s.append("(");
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::magenta));
        }
        s.append("Require");
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
        if(indent) {
            inc_indent();
            s.append("\n" + indented);
        } else {
            s.append(" ");
        }
        s.append(x.m_name);
        if(indent) s.append("\n" + indented);
        else s.append(" ");
        s.append("[");
        for (size_t i=0; i<x.n_args; i++) {
            s.append(x.m_args[i]);
            if (i < x.n_args-1) {
                if (indent) s.append("\n" + indented);
                else s.append(" ");
            };
        }
        s.append("]");
        if(indent) {
            dec_indent();
            s.append("\n" + indented);
        }
        s.append(")");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_array_physical_typeType(const array_physical_typeType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (array_physical_typeType::DescriptorArray) : {
                s.append("DescriptorArray");
             break; }
            case (array_physical_typeType::PointerToDataArray) : {
                s.append("PointerToDataArray");
             break; }
            case (array_physical_typeType::UnboundedPointerToDataArray) : {
                s.append("UnboundedPointerToDataArray");
             break; }
            case (array_physical_typeType::FixedSizeArray) : {
                s.append("FixedSizeArray");
             break; }
            case (array_physical_typeType::CharacterArraySinglePointer) : {
                s.append("CharacterArraySinglePointer");
             break; }
            case (array_physical_typeType::NumPyArray) : {
                s.append("NumPyArray");
             break; }
            case (array_physical_typeType::ISODescriptorArray) : {
                s.append("ISODescriptorArray");
             break; }
            case (array_physical_typeType::SIMDArray) : {
                s.append("SIMDArray");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_binopType(const binopType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (binopType::Add) : {
                s.append("Add");
             break; }
            case (binopType::Sub) : {
                s.append("Sub");
             break; }
            case (binopType::Mul) : {
                s.append("Mul");
             break; }
            case (binopType::Div) : {
                s.append("Div");
             break; }
            case (binopType::Pow) : {
                s.append("Pow");
             break; }
            case (binopType::BitAnd) : {
                s.append("BitAnd");
             break; }
            case (binopType::BitOr) : {
                s.append("BitOr");
             break; }
            case (binopType::BitXor) : {
                s.append("BitXor");
             break; }
            case (binopType::BitLShift) : {
                s.append("BitLShift");
             break; }
            case (binopType::BitRShift) : {
                s.append("BitRShift");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_logicalbinopType(const logicalbinopType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (logicalbinopType::And) : {
                s.append("And");
             break; }
            case (logicalbinopType::Or) : {
                s.append("Or");
             break; }
            case (logicalbinopType::Xor) : {
                s.append("Xor");
             break; }
            case (logicalbinopType::NEqv) : {
                s.append("NEqv");
             break; }
            case (logicalbinopType::Eqv) : {
                s.append("Eqv");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_cmpopType(const cmpopType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (cmpopType::Eq) : {
                s.append("Eq");
             break; }
            case (cmpopType::NotEq) : {
                s.append("NotEq");
             break; }
            case (cmpopType::Lt) : {
                s.append("Lt");
             break; }
            case (cmpopType::LtE) : {
                s.append("LtE");
             break; }
            case (cmpopType::Gt) : {
                s.append("Gt");
             break; }
            case (cmpopType::GtE) : {
                s.append("GtE");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_integerbozType(const integerbozType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (integerbozType::Binary) : {
                s.append("Binary");
             break; }
            case (integerbozType::Hex) : {
                s.append("Hex");
             break; }
            case (integerbozType::Octal) : {
                s.append("Octal");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_arrayboundType(const arrayboundType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (arrayboundType::LBound) : {
                s.append("LBound");
             break; }
            case (arrayboundType::UBound) : {
                s.append("UBound");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_arraystorageType(const arraystorageType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (arraystorageType::RowMajor) : {
                s.append("RowMajor");
             break; }
            case (arraystorageType::ColMajor) : {
                s.append("ColMajor");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
    void visit_string_format_kindType(const string_format_kindType &x) {
        if (use_colors) {
            s.append(color(style::bold));
            s.append(color(fg::green));
        }
        switch (x) {
            case (string_format_kindType::FormatFortran) : {
                s.append("FormatFortran");
             break; }
            case (string_format_kindType::FormatC) : {
                s.append("FormatC");
             break; }
            case (string_format_kindType::FormatPythonPercent) : {
                s.append("FormatPythonPercent");
             break; }
            case (string_format_kindType::FormatPythonFString) : {
                s.append("FormatPythonFString");
             break; }
            case (string_format_kindType::FormatPythonFormat) : {
                s.append("FormatPythonFormat");
             break; }
        }
        if (use_colors) {
            s.append(color(fg::reset));
            s.append(color(style::reset));
        }
    }
};


/******************************************************************************/
// Json Visitor base class

template <class Struct>
class JsonBaseVisitor : public BaseVisitor<Struct>
{
private:
    Struct& self() { return static_cast<Struct&>(*this); }
public:
    std::string s, indtd = "";
    bool no_loc = false;
    int indent_level = 0, indent_spaces = 4;
    LocationManager &lm;
public:
    JsonBaseVisitor(LocationManager &lmref) : lm(lmref) {
        s.reserve(100000);
    }
    void inc_indent() {
        indent_level++;
        indtd = std::string(indent_level*indent_spaces, ' ');
    }
    void dec_indent() {
        indent_level--;
        LCOMPILERS_ASSERT(indent_level >= 0);
        indtd = std::string(indent_level*indent_spaces, ' ');
    }
    void append_location(std::string &s, uint32_t first, uint32_t last) {
        if (no_loc) return;
        s.append(",\n" + indtd);
        s.append("\"loc\": {");
        inc_indent();
        s.append("\n" + indtd);
        s.append("\"first\": " + std::to_string(first));
        s.append(",\n" + indtd);
        s.append("\"last\": " + std::to_string(last));

        uint32_t first_line = 0, first_col = 0;
        std::string first_filename;
        uint32_t last_line = 0, last_col = 0;
        std::string last_filename;

        lm.pos_to_linecol(first, first_line, first_col, first_filename);
        lm.pos_to_linecol(last, last_line, last_col, last_filename);

        s.append(",\n" + indtd);
        s.append("\"first_filename\": \"" + first_filename + "\"");
        s.append(",\n" + indtd);
        s.append("\"first_line\": " + std::to_string(first_line));
        s.append(",\n" + indtd);
        s.append("\"first_column\": " + std::to_string(first_col));
        s.append(",\n" + indtd);
        s.append("\"last_filename\": \"" + last_filename + "\"");
        s.append(",\n" + indtd);
        s.append("\"last_line\": " + std::to_string(last_line));
        s.append(",\n" + indtd);
        s.append("\"last_column\": " + std::to_string(last_col));

        dec_indent();
        s.append("\n" + indtd);
        s.append("}");
    }
    void visit_TranslationUnit(const TranslationUnit_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"TranslationUnit\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"symtab\": ");
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SymbolTable" + x.m_symtab->get_counter() +"\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        if (x.m_symtab->get_scope().size() > 0) {
            inc_indent(); s.append("\n" + indtd);
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append("\"" + a.first + "\": ");
                this->visit_symbol(*a.second);
                if (i < x.m_symtab->get_scope().size()-1) { 
                        s.append(",\n" + indtd);
                }
                i++;
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("}");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        s.append(",\n" + indtd);
        s.append("\"items\": ");
        s.append("[");
        if (x.n_items > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_items; i++) {
                self().visit_asr(*x.m_items[i]);
                if (i < x.n_items-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Program(const Program_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Program\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"symtab\": ");
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SymbolTable" + x.m_symtab->get_counter() +"\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        if (x.m_symtab->get_scope().size() > 0) {
            inc_indent(); s.append("\n" + indtd);
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append("\"" + a.first + "\": ");
                this->visit_symbol(*a.second);
                if (i < x.m_symtab->get_scope().size()-1) { 
                        s.append(",\n" + indtd);
                }
                i++;
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("}");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"dependencies\": ");
        s.append("[");
        if (x.n_dependencies > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_dependencies; i++) {
                s.append("\"" + std::string(x.m_dependencies[i]) + "\"");
                if (i < x.n_dependencies-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Module(const Module_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Module\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"symtab\": ");
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SymbolTable" + x.m_symtab->get_counter() +"\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        if (x.m_symtab->get_scope().size() > 0) {
            inc_indent(); s.append("\n" + indtd);
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append("\"" + a.first + "\": ");
                this->visit_symbol(*a.second);
                if (i < x.m_symtab->get_scope().size()-1) { 
                        s.append(",\n" + indtd);
                }
                i++;
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("}");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"dependencies\": ");
        s.append("[");
        if (x.n_dependencies > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_dependencies; i++) {
                s.append("\"" + std::string(x.m_dependencies[i]) + "\"");
                if (i < x.n_dependencies-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"loaded_from_mod\": ");
        if (x.m_loaded_from_mod) {
            s.append("true");
        } else {
            s.append("false");
        }
        s.append(",\n" + indtd);
        s.append("\"intrinsic\": ");
        if (x.m_intrinsic) {
            s.append("true");
        } else {
            s.append("false");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Function(const Function_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Function\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"symtab\": ");
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SymbolTable" + x.m_symtab->get_counter() +"\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        if (x.m_symtab->get_scope().size() > 0) {
            inc_indent(); s.append("\n" + indtd);
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append("\"" + a.first + "\": ");
                this->visit_symbol(*a.second);
                if (i < x.m_symtab->get_scope().size()-1) { 
                        s.append(",\n" + indtd);
                }
                i++;
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("}");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"function_signature\": ");
        self().visit_ttype(*x.m_function_signature);
        s.append(",\n" + indtd);
        s.append("\"dependencies\": ");
        s.append("[");
        if (x.n_dependencies > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_dependencies; i++) {
                s.append("\"" + std::string(x.m_dependencies[i]) + "\"");
                if (i < x.n_dependencies-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_expr(*x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"return_var\": ");
        if (x.m_return_var) {
            self().visit_expr(*x.m_return_var);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"access\": ");
        visit_accessType(x.m_access);
        s.append(",\n" + indtd);
        s.append("\"deterministic\": ");
        if (x.m_deterministic) {
            s.append("true");
        } else {
            s.append("false");
        }
        s.append(",\n" + indtd);
        s.append("\"side_effect_free\": ");
        if (x.m_side_effect_free) {
            s.append("true");
        } else {
            s.append("false");
        }
        s.append(",\n" + indtd);
        s.append("\"module_file\": ");
        if (x.m_module_file) {
            s.append("\"" + str_escape_c(x.m_module_file) + "\"");
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_GenericProcedure(const GenericProcedure_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"GenericProcedure\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"parent_symtab\": ");
        s.append(x.m_parent_symtab->get_counter());
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"procs\": ");
        s.append("[");
        if (x.n_procs > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_procs; i++) {
                self().visit_symbol(*x.m_procs[i]);
                if (i < x.n_procs-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"access\": ");
        visit_accessType(x.m_access);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_CustomOperator(const CustomOperator_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"CustomOperator\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"parent_symtab\": ");
        s.append(x.m_parent_symtab->get_counter());
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"procs\": ");
        s.append("[");
        if (x.n_procs > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_procs; i++) {
                self().visit_symbol(*x.m_procs[i]);
                if (i < x.n_procs-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"access\": ");
        visit_accessType(x.m_access);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ExternalSymbol(const ExternalSymbol_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ExternalSymbol\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"parent_symtab\": ");
        s.append(x.m_parent_symtab->get_counter());
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"external\": ");
        self().visit_symbol(*x.m_external);
        s.append(",\n" + indtd);
        s.append("\"module_name\": ");
        s.append("\"" + std::string(x.m_module_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"scope_names\": ");
        s.append("[");
        if (x.n_scope_names > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_scope_names; i++) {
                s.append("\"" + std::string(x.m_scope_names[i]) + "\"");
                if (i < x.n_scope_names-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"original_name\": ");
        s.append("\"" + std::string(x.m_original_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"access\": ");
        visit_accessType(x.m_access);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StructType(const StructType_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"StructType\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"symtab\": ");
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SymbolTable" + x.m_symtab->get_counter() +"\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        if (x.m_symtab->get_scope().size() > 0) {
            inc_indent(); s.append("\n" + indtd);
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append("\"" + a.first + "\": ");
                this->visit_symbol(*a.second);
                if (i < x.m_symtab->get_scope().size()-1) { 
                        s.append(",\n" + indtd);
                }
                i++;
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("}");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"dependencies\": ");
        s.append("[");
        if (x.n_dependencies > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_dependencies; i++) {
                s.append("\"" + std::string(x.m_dependencies[i]) + "\"");
                if (i < x.n_dependencies-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"members\": ");
        s.append("[");
        if (x.n_members > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_members; i++) {
                s.append("\"" + std::string(x.m_members[i]) + "\"");
                if (i < x.n_members-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"abi\": ");
        visit_abiType(x.m_abi);
        s.append(",\n" + indtd);
        s.append("\"access\": ");
        visit_accessType(x.m_access);
        s.append(",\n" + indtd);
        s.append("\"is_packed\": ");
        if (x.m_is_packed) {
            s.append("true");
        } else {
            s.append("false");
        }
        s.append(",\n" + indtd);
        s.append("\"is_abstract\": ");
        if (x.m_is_abstract) {
            s.append("true");
        } else {
            s.append("false");
        }
        s.append(",\n" + indtd);
        s.append("\"initializers\": ");
        s.append("[");
        if (x.n_initializers > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_initializers; i++) {
                self().visit_call_arg(x.m_initializers[i]);
                if (i < x.n_initializers-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"alignment\": ");
        if (x.m_alignment) {
            self().visit_expr(*x.m_alignment);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"parent\": ");
        if (x.m_parent) {
            self().visit_symbol(*x.m_parent);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_EnumType(const EnumType_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"EnumType\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"symtab\": ");
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SymbolTable" + x.m_symtab->get_counter() +"\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        if (x.m_symtab->get_scope().size() > 0) {
            inc_indent(); s.append("\n" + indtd);
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append("\"" + a.first + "\": ");
                this->visit_symbol(*a.second);
                if (i < x.m_symtab->get_scope().size()-1) { 
                        s.append(",\n" + indtd);
                }
                i++;
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("}");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"dependencies\": ");
        s.append("[");
        if (x.n_dependencies > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_dependencies; i++) {
                s.append("\"" + std::string(x.m_dependencies[i]) + "\"");
                if (i < x.n_dependencies-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"members\": ");
        s.append("[");
        if (x.n_members > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_members; i++) {
                s.append("\"" + std::string(x.m_members[i]) + "\"");
                if (i < x.n_members-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"abi\": ");
        visit_abiType(x.m_abi);
        s.append(",\n" + indtd);
        s.append("\"access\": ");
        visit_accessType(x.m_access);
        s.append(",\n" + indtd);
        s.append("\"enum_value_type\": ");
        visit_enumtypeType(x.m_enum_value_type);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"parent\": ");
        if (x.m_parent) {
            self().visit_symbol(*x.m_parent);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UnionType(const UnionType_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"UnionType\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"symtab\": ");
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SymbolTable" + x.m_symtab->get_counter() +"\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        if (x.m_symtab->get_scope().size() > 0) {
            inc_indent(); s.append("\n" + indtd);
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append("\"" + a.first + "\": ");
                this->visit_symbol(*a.second);
                if (i < x.m_symtab->get_scope().size()-1) { 
                        s.append(",\n" + indtd);
                }
                i++;
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("}");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"dependencies\": ");
        s.append("[");
        if (x.n_dependencies > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_dependencies; i++) {
                s.append("\"" + std::string(x.m_dependencies[i]) + "\"");
                if (i < x.n_dependencies-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"members\": ");
        s.append("[");
        if (x.n_members > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_members; i++) {
                s.append("\"" + std::string(x.m_members[i]) + "\"");
                if (i < x.n_members-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"abi\": ");
        visit_abiType(x.m_abi);
        s.append(",\n" + indtd);
        s.append("\"access\": ");
        visit_accessType(x.m_access);
        s.append(",\n" + indtd);
        s.append("\"initializers\": ");
        s.append("[");
        if (x.n_initializers > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_initializers; i++) {
                self().visit_call_arg(x.m_initializers[i]);
                if (i < x.n_initializers-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"parent\": ");
        if (x.m_parent) {
            self().visit_symbol(*x.m_parent);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Variable(const Variable_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Variable\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"parent_symtab\": ");
        s.append(x.m_parent_symtab->get_counter());
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"dependencies\": ");
        s.append("[");
        if (x.n_dependencies > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_dependencies; i++) {
                s.append("\"" + std::string(x.m_dependencies[i]) + "\"");
                if (i < x.n_dependencies-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"intent\": ");
        visit_intentType(x.m_intent);
        s.append(",\n" + indtd);
        s.append("\"symbolic_value\": ");
        if (x.m_symbolic_value) {
            self().visit_expr(*x.m_symbolic_value);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"storage\": ");
        visit_storage_typeType(x.m_storage);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"type_declaration\": ");
        if (x.m_type_declaration) {
            self().visit_symbol(*x.m_type_declaration);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"abi\": ");
        visit_abiType(x.m_abi);
        s.append(",\n" + indtd);
        s.append("\"access\": ");
        visit_accessType(x.m_access);
        s.append(",\n" + indtd);
        s.append("\"presence\": ");
        visit_presenceType(x.m_presence);
        s.append(",\n" + indtd);
        s.append("\"value_attr\": ");
        if (x.m_value_attr) {
            s.append("true");
        } else {
            s.append("false");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ClassType(const ClassType_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ClassType\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"symtab\": ");
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SymbolTable" + x.m_symtab->get_counter() +"\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        if (x.m_symtab->get_scope().size() > 0) {
            inc_indent(); s.append("\n" + indtd);
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append("\"" + a.first + "\": ");
                this->visit_symbol(*a.second);
                if (i < x.m_symtab->get_scope().size()-1) { 
                        s.append(",\n" + indtd);
                }
                i++;
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("}");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"abi\": ");
        visit_abiType(x.m_abi);
        s.append(",\n" + indtd);
        s.append("\"access\": ");
        visit_accessType(x.m_access);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ClassProcedure(const ClassProcedure_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ClassProcedure\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"parent_symtab\": ");
        s.append(x.m_parent_symtab->get_counter());
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"self_argument\": ");
        if (x.m_self_argument) {
            s.append("\"" + std::string(x.m_self_argument) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"proc_name\": ");
        s.append("\"" + std::string(x.m_proc_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"proc\": ");
        self().visit_symbol(*x.m_proc);
        s.append(",\n" + indtd);
        s.append("\"abi\": ");
        visit_abiType(x.m_abi);
        s.append(",\n" + indtd);
        s.append("\"is_deferred\": ");
        if (x.m_is_deferred) {
            s.append("true");
        } else {
            s.append("false");
        }
        s.append(",\n" + indtd);
        s.append("\"is_nopass\": ");
        if (x.m_is_nopass) {
            s.append("true");
        } else {
            s.append("false");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AssociateBlock(const AssociateBlock_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"AssociateBlock\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"symtab\": ");
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SymbolTable" + x.m_symtab->get_counter() +"\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        if (x.m_symtab->get_scope().size() > 0) {
            inc_indent(); s.append("\n" + indtd);
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append("\"" + a.first + "\": ");
                this->visit_symbol(*a.second);
                if (i < x.m_symtab->get_scope().size()-1) { 
                        s.append(",\n" + indtd);
                }
                i++;
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("}");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Block(const Block_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Block\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"symtab\": ");
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SymbolTable" + x.m_symtab->get_counter() +"\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        if (x.m_symtab->get_scope().size() > 0) {
            inc_indent(); s.append("\n" + indtd);
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append("\"" + a.first + "\": ");
                this->visit_symbol(*a.second);
                if (i < x.m_symtab->get_scope().size()-1) { 
                        s.append(",\n" + indtd);
                }
                i++;
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("}");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Requirement(const Requirement_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Requirement\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"symtab\": ");
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SymbolTable" + x.m_symtab->get_counter() +"\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        if (x.m_symtab->get_scope().size() > 0) {
            inc_indent(); s.append("\n" + indtd);
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append("\"" + a.first + "\": ");
                this->visit_symbol(*a.second);
                if (i < x.m_symtab->get_scope().size()-1) { 
                        s.append(",\n" + indtd);
                }
                i++;
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("}");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                s.append("\"" + std::string(x.m_args[i]) + "\"");
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"requires\": ");
        s.append("[");
        if (x.n_requires > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_requires; i++) {
                self().visit_require_instantiation(*x.m_requires[i]);
                if (i < x.n_requires-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Template(const Template_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Template\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"symtab\": ");
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SymbolTable" + x.m_symtab->get_counter() +"\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        if (x.m_symtab->get_scope().size() > 0) {
            inc_indent(); s.append("\n" + indtd);
            size_t i = 0;
            for (auto &a : x.m_symtab->get_scope()) {
                s.append("\"" + a.first + "\": ");
                this->visit_symbol(*a.second);
                if (i < x.m_symtab->get_scope().size()-1) { 
                        s.append(",\n" + indtd);
                }
                i++;
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("}");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                s.append("\"" + std::string(x.m_args[i]) + "\"");
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"requires\": ");
        s.append("[");
        if (x.n_requires > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_requires; i++) {
                self().visit_require_instantiation(*x.m_requires[i]);
                if (i < x.n_requires-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Allocate(const Allocate_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Allocate\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_alloc_arg(x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"stat\": ");
        if (x.m_stat) {
            self().visit_expr(*x.m_stat);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"errmsg\": ");
        if (x.m_errmsg) {
            self().visit_expr(*x.m_errmsg);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"source\": ");
        if (x.m_source) {
            self().visit_expr(*x.m_source);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ReAlloc(const ReAlloc_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ReAlloc\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_alloc_arg(x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Assign(const Assign_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Assign\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"variable\": ");
        s.append("\"" + std::string(x.m_variable) + "\"");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Assignment(const Assignment_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Assignment\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"target\": ");
        self().visit_expr(*x.m_target);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        self().visit_expr(*x.m_value);
        s.append(",\n" + indtd);
        s.append("\"overloaded\": ");
        if (x.m_overloaded) {
            self().visit_stmt(*x.m_overloaded);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Associate(const Associate_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Associate\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"target\": ");
        self().visit_expr(*x.m_target);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        self().visit_expr(*x.m_value);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Cycle(const Cycle_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Cycle\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"stmt_name\": ");
        if (x.m_stmt_name) {
            s.append("\"" + std::string(x.m_stmt_name) + "\"");
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ExplicitDeallocate(const ExplicitDeallocate_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ExplicitDeallocate\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"vars\": ");
        s.append("[");
        if (x.n_vars > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_vars; i++) {
                self().visit_expr(*x.m_vars[i]);
                if (i < x.n_vars-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ImplicitDeallocate(const ImplicitDeallocate_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ImplicitDeallocate\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"vars\": ");
        s.append("[");
        if (x.n_vars > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_vars; i++) {
                self().visit_expr(*x.m_vars[i]);
                if (i < x.n_vars-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_DoConcurrentLoop(const DoConcurrentLoop_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"DoConcurrentLoop\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"head\": ");
        self().visit_do_loop_head(x.m_head);
        s.append(",\n" + indtd);
        s.append("\"shared\": ");
        s.append("[");
        if (x.n_shared > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_shared; i++) {
                self().visit_expr(*x.m_shared[i]);
                if (i < x.n_shared-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"local\": ");
        s.append("[");
        if (x.n_local > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_local; i++) {
                self().visit_expr(*x.m_local[i]);
                if (i < x.n_local-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_DoLoop(const DoLoop_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"DoLoop\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"name\": ");
        if (x.m_name) {
            s.append("\"" + std::string(x.m_name) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"head\": ");
        self().visit_do_loop_head(x.m_head);
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"orelse\": ");
        s.append("[");
        if (x.n_orelse > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_orelse; i++) {
                self().visit_stmt(*x.m_orelse[i]);
                if (i < x.n_orelse-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ErrorStop(const ErrorStop_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ErrorStop\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"code\": ");
        if (x.m_code) {
            self().visit_expr(*x.m_code);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Exit(const Exit_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Exit\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"stmt_name\": ");
        if (x.m_stmt_name) {
            s.append("\"" + std::string(x.m_stmt_name) + "\"");
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ForAllSingle(const ForAllSingle_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ForAllSingle\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"head\": ");
        self().visit_do_loop_head(x.m_head);
        s.append(",\n" + indtd);
        s.append("\"assign_stmt\": ");
        self().visit_stmt(*x.m_assign_stmt);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_GoTo(const GoTo_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"GoTo\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"target_id\": ");
        s.append(std::to_string(x.m_target_id));
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_GoToTarget(const GoToTarget_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"GoToTarget\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"id\": ");
        s.append(std::to_string(x.m_id));
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        s.append("\"" + std::string(x.m_name) + "\"");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_If(const If_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"If\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"test\": ");
        self().visit_expr(*x.m_test);
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"orelse\": ");
        s.append("[");
        if (x.n_orelse > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_orelse; i++) {
                self().visit_stmt(*x.m_orelse[i]);
                if (i < x.n_orelse-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_IfArithmetic(const IfArithmetic_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"IfArithmetic\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"test\": ");
        self().visit_expr(*x.m_test);
        s.append(",\n" + indtd);
        s.append("\"lt_label\": ");
        s.append(std::to_string(x.m_lt_label));
        s.append(",\n" + indtd);
        s.append("\"eq_label\": ");
        s.append(std::to_string(x.m_eq_label));
        s.append(",\n" + indtd);
        s.append("\"gt_label\": ");
        s.append(std::to_string(x.m_gt_label));
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Print(const Print_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Print\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"values\": ");
        s.append("[");
        if (x.n_values > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_values; i++) {
                self().visit_expr(*x.m_values[i]);
                if (i < x.n_values-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"separator\": ");
        if (x.m_separator) {
            self().visit_expr(*x.m_separator);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"end\": ");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_FileOpen(const FileOpen_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"FileOpen\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"newunit\": ");
        if (x.m_newunit) {
            self().visit_expr(*x.m_newunit);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"filename\": ");
        if (x.m_filename) {
            self().visit_expr(*x.m_filename);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"status\": ");
        if (x.m_status) {
            self().visit_expr(*x.m_status);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"form\": ");
        if (x.m_form) {
            self().visit_expr(*x.m_form);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_FileClose(const FileClose_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"FileClose\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"unit\": ");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"iostat\": ");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"iomsg\": ");
        if (x.m_iomsg) {
            self().visit_expr(*x.m_iomsg);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"err\": ");
        if (x.m_err) {
            self().visit_expr(*x.m_err);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"status\": ");
        if (x.m_status) {
            self().visit_expr(*x.m_status);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_FileRead(const FileRead_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"FileRead\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"unit\": ");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"fmt\": ");
        if (x.m_fmt) {
            self().visit_expr(*x.m_fmt);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"iomsg\": ");
        if (x.m_iomsg) {
            self().visit_expr(*x.m_iomsg);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"iostat\": ");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"size\": ");
        if (x.m_size) {
            self().visit_expr(*x.m_size);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"id\": ");
        if (x.m_id) {
            self().visit_expr(*x.m_id);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"values\": ");
        s.append("[");
        if (x.n_values > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_values; i++) {
                self().visit_expr(*x.m_values[i]);
                if (i < x.n_values-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"overloaded\": ");
        if (x.m_overloaded) {
            self().visit_stmt(*x.m_overloaded);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_FileBackspace(const FileBackspace_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"FileBackspace\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"unit\": ");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"iostat\": ");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"err\": ");
        if (x.m_err) {
            self().visit_expr(*x.m_err);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_FileRewind(const FileRewind_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"FileRewind\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"unit\": ");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"iostat\": ");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"err\": ");
        if (x.m_err) {
            self().visit_expr(*x.m_err);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_FileInquire(const FileInquire_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"FileInquire\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"unit\": ");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"file\": ");
        if (x.m_file) {
            self().visit_expr(*x.m_file);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"iostat\": ");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"err\": ");
        if (x.m_err) {
            self().visit_expr(*x.m_err);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"exist\": ");
        if (x.m_exist) {
            self().visit_expr(*x.m_exist);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"opened\": ");
        if (x.m_opened) {
            self().visit_expr(*x.m_opened);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"number\": ");
        if (x.m_number) {
            self().visit_expr(*x.m_number);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"named\": ");
        if (x.m_named) {
            self().visit_expr(*x.m_named);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"name\": ");
        if (x.m_name) {
            self().visit_expr(*x.m_name);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"access\": ");
        if (x.m_access) {
            self().visit_expr(*x.m_access);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"sequential\": ");
        if (x.m_sequential) {
            self().visit_expr(*x.m_sequential);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"direct\": ");
        if (x.m_direct) {
            self().visit_expr(*x.m_direct);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"form\": ");
        if (x.m_form) {
            self().visit_expr(*x.m_form);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"formatted\": ");
        if (x.m_formatted) {
            self().visit_expr(*x.m_formatted);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"unformatted\": ");
        if (x.m_unformatted) {
            self().visit_expr(*x.m_unformatted);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"recl\": ");
        if (x.m_recl) {
            self().visit_expr(*x.m_recl);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"nextrec\": ");
        if (x.m_nextrec) {
            self().visit_expr(*x.m_nextrec);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"blank\": ");
        if (x.m_blank) {
            self().visit_expr(*x.m_blank);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"position\": ");
        if (x.m_position) {
            self().visit_expr(*x.m_position);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"action\": ");
        if (x.m_action) {
            self().visit_expr(*x.m_action);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"read\": ");
        if (x.m_read) {
            self().visit_expr(*x.m_read);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"write\": ");
        if (x.m_write) {
            self().visit_expr(*x.m_write);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"readwrite\": ");
        if (x.m_readwrite) {
            self().visit_expr(*x.m_readwrite);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"delim\": ");
        if (x.m_delim) {
            self().visit_expr(*x.m_delim);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"pad\": ");
        if (x.m_pad) {
            self().visit_expr(*x.m_pad);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"flen\": ");
        if (x.m_flen) {
            self().visit_expr(*x.m_flen);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"blocksize\": ");
        if (x.m_blocksize) {
            self().visit_expr(*x.m_blocksize);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"convert\": ");
        if (x.m_convert) {
            self().visit_expr(*x.m_convert);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"carriagecontrol\": ");
        if (x.m_carriagecontrol) {
            self().visit_expr(*x.m_carriagecontrol);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"iolength\": ");
        if (x.m_iolength) {
            self().visit_expr(*x.m_iolength);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_FileWrite(const FileWrite_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"FileWrite\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"unit\": ");
        if (x.m_unit) {
            self().visit_expr(*x.m_unit);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"iomsg\": ");
        if (x.m_iomsg) {
            self().visit_expr(*x.m_iomsg);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"iostat\": ");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"id\": ");
        if (x.m_id) {
            self().visit_expr(*x.m_id);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"values\": ");
        s.append("[");
        if (x.n_values > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_values; i++) {
                self().visit_expr(*x.m_values[i]);
                if (i < x.n_values-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"separator\": ");
        if (x.m_separator) {
            self().visit_expr(*x.m_separator);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"end\": ");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"overloaded\": ");
        if (x.m_overloaded) {
            self().visit_stmt(*x.m_overloaded);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Return(const Return_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Return\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Select(const Select_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Select\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"test\": ");
        self().visit_expr(*x.m_test);
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_case_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"default\": ");
        s.append("[");
        if (x.n_default > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_default; i++) {
                self().visit_stmt(*x.m_default[i]);
                if (i < x.n_default-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"enable_fall_through\": ");
        if (x.m_enable_fall_through) {
            s.append("true");
        } else {
            s.append("false");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Stop(const Stop_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Stop\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"code\": ");
        if (x.m_code) {
            self().visit_expr(*x.m_code);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Assert(const Assert_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Assert\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"test\": ");
        self().visit_expr(*x.m_test);
        s.append(",\n" + indtd);
        s.append("\"msg\": ");
        if (x.m_msg) {
            self().visit_expr(*x.m_msg);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SubroutineCall(const SubroutineCall_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SubroutineCall\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"name\": ");
        self().visit_symbol(*x.m_name);
        s.append(",\n" + indtd);
        s.append("\"original_name\": ");
        if (x.m_original_name) {
            self().visit_symbol(*x.m_original_name);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_call_arg(x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"dt\": ");
        if (x.m_dt) {
            self().visit_expr(*x.m_dt);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_IntrinsicImpureSubroutine(const IntrinsicImpureSubroutine_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"IntrinsicImpureSubroutine\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"intrinsic_id\": ");
        s.append(std::to_string(x.m_intrinsic_id));
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_expr(*x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"overload_id\": ");
        s.append(std::to_string(x.m_overload_id));
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Where(const Where_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Where\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"test\": ");
        self().visit_expr(*x.m_test);
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"orelse\": ");
        s.append("[");
        if (x.n_orelse > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_orelse; i++) {
                self().visit_stmt(*x.m_orelse[i]);
                if (i < x.n_orelse-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_WhileLoop(const WhileLoop_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"WhileLoop\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"name\": ");
        if (x.m_name) {
            s.append("\"" + std::string(x.m_name) + "\"");
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"test\": ");
        self().visit_expr(*x.m_test);
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"orelse\": ");
        s.append("[");
        if (x.n_orelse > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_orelse; i++) {
                self().visit_stmt(*x.m_orelse[i]);
                if (i < x.n_orelse-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Nullify(const Nullify_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Nullify\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"vars\": ");
        s.append("[");
        if (x.n_vars > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_vars; i++) {
                self().visit_symbol(*x.m_vars[i]);
                if (i < x.n_vars-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Flush(const Flush_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Flush\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"unit\": ");
        self().visit_expr(*x.m_unit);
        s.append(",\n" + indtd);
        s.append("\"err\": ");
        if (x.m_err) {
            self().visit_expr(*x.m_err);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"iomsg\": ");
        if (x.m_iomsg) {
            self().visit_expr(*x.m_iomsg);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"iostat\": ");
        if (x.m_iostat) {
            self().visit_expr(*x.m_iostat);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ListAppend(const ListAppend_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ListAppend\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"a\": ");
        self().visit_expr(*x.m_a);
        s.append(",\n" + indtd);
        s.append("\"ele\": ");
        self().visit_expr(*x.m_ele);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_AssociateBlockCall(const AssociateBlockCall_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"AssociateBlockCall\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"m\": ");
        self().visit_symbol(*x.m_m);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SelectType(const SelectType_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SelectType\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"selector\": ");
        self().visit_expr(*x.m_selector);
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        s.append("[");
        if (x.n_body > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_body; i++) {
                self().visit_type_stmt(*x.m_body[i]);
                if (i < x.n_body-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"default\": ");
        s.append("[");
        if (x.n_default > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_default; i++) {
                self().visit_stmt(*x.m_default[i]);
                if (i < x.n_default-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_CPtrToPointer(const CPtrToPointer_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"CPtrToPointer\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"cptr\": ");
        self().visit_expr(*x.m_cptr);
        s.append(",\n" + indtd);
        s.append("\"ptr\": ");
        self().visit_expr(*x.m_ptr);
        s.append(",\n" + indtd);
        s.append("\"shape\": ");
        if (x.m_shape) {
            self().visit_expr(*x.m_shape);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"lower_bounds\": ");
        if (x.m_lower_bounds) {
            self().visit_expr(*x.m_lower_bounds);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_BlockCall(const BlockCall_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"BlockCall\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"label\": ");
        s.append(std::to_string(x.m_label));
        s.append(",\n" + indtd);
        s.append("\"m\": ");
        self().visit_symbol(*x.m_m);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SetInsert(const SetInsert_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SetInsert\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"a\": ");
        self().visit_expr(*x.m_a);
        s.append(",\n" + indtd);
        s.append("\"ele\": ");
        self().visit_expr(*x.m_ele);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SetRemove(const SetRemove_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SetRemove\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"a\": ");
        self().visit_expr(*x.m_a);
        s.append(",\n" + indtd);
        s.append("\"ele\": ");
        self().visit_expr(*x.m_ele);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ListInsert(const ListInsert_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ListInsert\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"a\": ");
        self().visit_expr(*x.m_a);
        s.append(",\n" + indtd);
        s.append("\"pos\": ");
        self().visit_expr(*x.m_pos);
        s.append(",\n" + indtd);
        s.append("\"ele\": ");
        self().visit_expr(*x.m_ele);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ListRemove(const ListRemove_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ListRemove\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"a\": ");
        self().visit_expr(*x.m_a);
        s.append(",\n" + indtd);
        s.append("\"ele\": ");
        self().visit_expr(*x.m_ele);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ListClear(const ListClear_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ListClear\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"a\": ");
        self().visit_expr(*x.m_a);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_DictInsert(const DictInsert_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"DictInsert\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"a\": ");
        self().visit_expr(*x.m_a);
        s.append(",\n" + indtd);
        s.append("\"key\": ");
        self().visit_expr(*x.m_key);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        self().visit_expr(*x.m_value);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Expr(const Expr_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Expr\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"expression\": ");
        self().visit_expr(*x.m_expression);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_IfExp(const IfExp_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"IfExp\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"test\": ");
        self().visit_expr(*x.m_test);
        s.append(",\n" + indtd);
        s.append("\"body\": ");
        self().visit_expr(*x.m_body);
        s.append(",\n" + indtd);
        s.append("\"orelse\": ");
        self().visit_expr(*x.m_orelse);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ComplexConstructor(const ComplexConstructor_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ComplexConstructor\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"re\": ");
        self().visit_expr(*x.m_re);
        s.append(",\n" + indtd);
        s.append("\"im\": ");
        self().visit_expr(*x.m_im);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_NamedExpr(const NamedExpr_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"NamedExpr\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"target\": ");
        self().visit_expr(*x.m_target);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        self().visit_expr(*x.m_value);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_FunctionCall(const FunctionCall_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"FunctionCall\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"name\": ");
        self().visit_symbol(*x.m_name);
        s.append(",\n" + indtd);
        s.append("\"original_name\": ");
        if (x.m_original_name) {
            self().visit_symbol(*x.m_original_name);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_call_arg(x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"dt\": ");
        if (x.m_dt) {
            self().visit_expr(*x.m_dt);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_IntrinsicElementalFunction(const IntrinsicElementalFunction_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"IntrinsicElementalFunction\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"intrinsic_id\": ");
        s.append(std::to_string(x.m_intrinsic_id));
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_expr(*x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"overload_id\": ");
        s.append(std::to_string(x.m_overload_id));
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        if (x.m_type) {
            self().visit_ttype(*x.m_type);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_IntrinsicArrayFunction(const IntrinsicArrayFunction_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"IntrinsicArrayFunction\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arr_intrinsic_id\": ");
        s.append(std::to_string(x.m_arr_intrinsic_id));
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_expr(*x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"overload_id\": ");
        s.append(std::to_string(x.m_overload_id));
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        if (x.m_type) {
            self().visit_ttype(*x.m_type);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_IntrinsicImpureFunction(const IntrinsicImpureFunction_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"IntrinsicImpureFunction\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"impure_intrinsic_id\": ");
        s.append(std::to_string(x.m_impure_intrinsic_id));
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_expr(*x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"overload_id\": ");
        s.append(std::to_string(x.m_overload_id));
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        if (x.m_type) {
            self().visit_ttype(*x.m_type);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_TypeInquiry(const TypeInquiry_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"TypeInquiry\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"inquiry_id\": ");
        s.append(std::to_string(x.m_inquiry_id));
        s.append(",\n" + indtd);
        s.append("\"arg_type\": ");
        self().visit_ttype(*x.m_arg_type);
        s.append(",\n" + indtd);
        s.append("\"arg\": ");
        if (x.m_arg) {
            self().visit_expr(*x.m_arg);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        self().visit_expr(*x.m_value);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StructTypeConstructor(const StructTypeConstructor_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"StructTypeConstructor\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"dt_sym\": ");
        self().visit_symbol(*x.m_dt_sym);
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_call_arg(x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_EnumTypeConstructor(const EnumTypeConstructor_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"EnumTypeConstructor\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"dt_sym\": ");
        self().visit_symbol(*x.m_dt_sym);
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_expr(*x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UnionTypeConstructor(const UnionTypeConstructor_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"UnionTypeConstructor\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"dt_sym\": ");
        self().visit_symbol(*x.m_dt_sym);
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_expr(*x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ImpliedDoLoop(const ImpliedDoLoop_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ImpliedDoLoop\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"values\": ");
        s.append("[");
        if (x.n_values > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_values; i++) {
                self().visit_expr(*x.m_values[i]);
                if (i < x.n_values-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"var\": ");
        self().visit_expr(*x.m_var);
        s.append(",\n" + indtd);
        s.append("\"start\": ");
        self().visit_expr(*x.m_start);
        s.append(",\n" + indtd);
        s.append("\"end\": ");
        self().visit_expr(*x.m_end);
        s.append(",\n" + indtd);
        s.append("\"increment\": ");
        if (x.m_increment) {
            self().visit_expr(*x.m_increment);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_IntegerConstant(const IntegerConstant_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"IntegerConstant\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"n\": ");
        s.append(std::to_string(x.m_n));
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_IntegerBOZ(const IntegerBOZ_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"IntegerBOZ\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"v\": ");
        s.append(std::to_string(x.m_v));
        s.append(",\n" + indtd);
        s.append("\"intboz_type\": ");
        visit_integerbozType(x.m_intboz_type);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        if (x.m_type) {
            self().visit_ttype(*x.m_type);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_IntegerBitNot(const IntegerBitNot_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"IntegerBitNot\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_IntegerUnaryMinus(const IntegerUnaryMinus_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"IntegerUnaryMinus\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_IntegerCompare(const IntegerCompare_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"IntegerCompare\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_cmpopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_IntegerBinOp(const IntegerBinOp_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"IntegerBinOp\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_binopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UnsignedIntegerConstant(const UnsignedIntegerConstant_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"UnsignedIntegerConstant\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"n\": ");
        s.append(std::to_string(x.m_n));
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UnsignedIntegerUnaryMinus(const UnsignedIntegerUnaryMinus_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"UnsignedIntegerUnaryMinus\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UnsignedIntegerBitNot(const UnsignedIntegerBitNot_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"UnsignedIntegerBitNot\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UnsignedIntegerCompare(const UnsignedIntegerCompare_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"UnsignedIntegerCompare\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_cmpopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UnsignedIntegerBinOp(const UnsignedIntegerBinOp_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"UnsignedIntegerBinOp\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_binopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_RealConstant(const RealConstant_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"RealConstant\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"r\": ");
        s.append(std::to_string(x.m_r));
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_RealUnaryMinus(const RealUnaryMinus_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"RealUnaryMinus\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_RealCompare(const RealCompare_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"RealCompare\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_cmpopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_RealBinOp(const RealBinOp_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"RealBinOp\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_binopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_RealCopySign(const RealCopySign_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"RealCopySign\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"target\": ");
        self().visit_expr(*x.m_target);
        s.append(",\n" + indtd);
        s.append("\"source\": ");
        self().visit_expr(*x.m_source);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ComplexConstant(const ComplexConstant_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ComplexConstant\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"re\": ");
        s.append(std::to_string(x.m_re));
        s.append(",\n" + indtd);
        s.append("\"im\": ");
        s.append(std::to_string(x.m_im));
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ComplexUnaryMinus(const ComplexUnaryMinus_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ComplexUnaryMinus\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ComplexCompare(const ComplexCompare_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ComplexCompare\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_cmpopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ComplexBinOp(const ComplexBinOp_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ComplexBinOp\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_binopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_LogicalConstant(const LogicalConstant_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"LogicalConstant\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            s.append("true");
        } else {
            s.append("false");
        }
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_LogicalNot(const LogicalNot_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"LogicalNot\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_LogicalCompare(const LogicalCompare_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"LogicalCompare\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_cmpopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_LogicalBinOp(const LogicalBinOp_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"LogicalBinOp\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_logicalbinopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ListConstant(const ListConstant_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ListConstant\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_expr(*x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ListLen(const ListLen_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ListLen\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ListConcat(const ListConcat_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ListConcat\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ListCompare(const ListCompare_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ListCompare\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_cmpopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ListCount(const ListCount_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ListCount\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"ele\": ");
        self().visit_expr(*x.m_ele);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SetConstant(const SetConstant_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SetConstant\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"elements\": ");
        s.append("[");
        if (x.n_elements > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_elements; i++) {
                self().visit_expr(*x.m_elements[i]);
                if (i < x.n_elements-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SetLen(const SetLen_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SetLen\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_TupleConstant(const TupleConstant_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"TupleConstant\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"elements\": ");
        s.append("[");
        if (x.n_elements > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_elements; i++) {
                self().visit_expr(*x.m_elements[i]);
                if (i < x.n_elements-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_TupleLen(const TupleLen_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"TupleLen\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        self().visit_expr(*x.m_value);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_TupleCompare(const TupleCompare_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"TupleCompare\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_cmpopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_TupleConcat(const TupleConcat_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"TupleConcat\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StringConstant(const StringConstant_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"StringConstant\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"s\": ");
        s.append("\"" + str_escape_c(x.m_s) + "\"");
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StringConcat(const StringConcat_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"StringConcat\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StringRepeat(const StringRepeat_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"StringRepeat\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StringLen(const StringLen_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"StringLen\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StringItem(const StringItem_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"StringItem\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"idx\": ");
        self().visit_expr(*x.m_idx);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StringSection(const StringSection_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"StringSection\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"start\": ");
        if (x.m_start) {
            self().visit_expr(*x.m_start);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"end\": ");
        if (x.m_end) {
            self().visit_expr(*x.m_end);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"step\": ");
        if (x.m_step) {
            self().visit_expr(*x.m_step);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StringCompare(const StringCompare_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"StringCompare\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_cmpopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StringOrd(const StringOrd_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"StringOrd\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StringChr(const StringChr_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"StringChr\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StringFormat(const StringFormat_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"StringFormat\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"fmt\": ");
        self().visit_expr(*x.m_fmt);
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_expr(*x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"kind\": ");
        visit_string_format_kindType(x.m_kind);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_CPtrCompare(const CPtrCompare_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"CPtrCompare\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_cmpopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_SymbolicCompare(const SymbolicCompare_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"SymbolicCompare\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_cmpopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_DictConstant(const DictConstant_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"DictConstant\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"keys\": ");
        s.append("[");
        if (x.n_keys > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_keys; i++) {
                self().visit_expr(*x.m_keys[i]);
                if (i < x.n_keys-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"values\": ");
        s.append("[");
        if (x.n_values > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_values; i++) {
                self().visit_expr(*x.m_values[i]);
                if (i < x.n_values-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_DictLen(const DictLen_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"DictLen\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"arg\": ");
        self().visit_expr(*x.m_arg);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_Var(const Var_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"Var\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"v\": ");
        self().visit_symbol(*x.m_v);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_FunctionParam(const FunctionParam_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"FunctionParam\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"param_number\": ");
        s.append(std::to_string(x.m_param_number));
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ArrayConstructor(const ArrayConstructor_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ArrayConstructor\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_expr(*x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"storage_format\": ");
        visit_arraystorageType(x.m_storage_format);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ArrayConstant(const ArrayConstant_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ArrayConstant\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"n_data\": ");
        s.append(std::to_string(x.m_n_data));
        s.append(",\n" + indtd);
        s.append("\"data\": ");
        s.append("\"Unimplementedvoid\"");
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"storage_format\": ");
        visit_arraystorageType(x.m_storage_format);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ArrayItem(const ArrayItem_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ArrayItem\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"v\": ");
        self().visit_expr(*x.m_v);
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_array_index(x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"storage_format\": ");
        visit_arraystorageType(x.m_storage_format);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ArraySection(const ArraySection_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ArraySection\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"v\": ");
        self().visit_expr(*x.m_v);
        s.append(",\n" + indtd);
        s.append("\"args\": ");
        s.append("[");
        if (x.n_args > 0) {
            inc_indent(); s.append("\n" + indtd);
            for (size_t i=0; i<x.n_args; i++) {
                self().visit_array_index(x.m_args[i]);
                if (i < x.n_args-1) {
                    s.append(",\n" + indtd);
                };
            }
            dec_indent(); s.append("\n" + indtd);
        }
        s.append("]");
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ArraySize(const ArraySize_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ArraySize\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"v\": ");
        self().visit_expr(*x.m_v);
        s.append(",\n" + indtd);
        s.append("\"dim\": ");
        if (x.m_dim) {
            self().visit_expr(*x.m_dim);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ArrayBound(const ArrayBound_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ArrayBound\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"v\": ");
        self().visit_expr(*x.m_v);
        s.append(",\n" + indtd);
        s.append("\"dim\": ");
        if (x.m_dim) {
            self().visit_expr(*x.m_dim);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"bound\": ");
        visit_arrayboundType(x.m_bound);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ArrayTranspose(const ArrayTranspose_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ArrayTranspose\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"matrix\": ");
        self().visit_expr(*x.m_matrix);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ArrayPack(const ArrayPack_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ArrayPack\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"array\": ");
        self().visit_expr(*x.m_array);
        s.append(",\n" + indtd);
        s.append("\"mask\": ");
        self().visit_expr(*x.m_mask);
        s.append(",\n" + indtd);
        s.append("\"vector\": ");
        if (x.m_vector) {
            self().visit_expr(*x.m_vector);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ArrayReshape(const ArrayReshape_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ArrayReshape\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"array\": ");
        self().visit_expr(*x.m_array);
        s.append(",\n" + indtd);
        s.append("\"shape\": ");
        self().visit_expr(*x.m_shape);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_ArrayBroadcast(const ArrayBroadcast_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"ArrayBroadcast\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"array\": ");
        self().visit_expr(*x.m_array);
        s.append(",\n" + indtd);
        s.append("\"shape\": ");
        self().visit_expr(*x.m_shape);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_BitCast(const BitCast_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"BitCast\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"source\": ");
        self().visit_expr(*x.m_source);
        s.append(",\n" + indtd);
        s.append("\"mold\": ");
        self().visit_expr(*x.m_mold);
        s.append(",\n" + indtd);
        s.append("\"size\": ");
        if (x.m_size) {
            self().visit_expr(*x.m_size);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StructInstanceMember(const StructInstanceMember_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"StructInstanceMember\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"v\": ");
        self().visit_expr(*x.m_v);
        s.append(",\n" + indtd);
        s.append("\"m\": ");
        self().visit_symbol(*x.m_m);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_StructStaticMember(const StructStaticMember_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"StructStaticMember\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"v\": ");
        self().visit_expr(*x.m_v);
        s.append(",\n" + indtd);
        s.append("\"m\": ");
        self().visit_symbol(*x.m_m);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_EnumStaticMember(const EnumStaticMember_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"EnumStaticMember\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"v\": ");
        self().visit_expr(*x.m_v);
        s.append(",\n" + indtd);
        s.append("\"m\": ");
        self().visit_symbol(*x.m_m);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_UnionInstanceMember(const UnionInstanceMember_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"UnionInstanceMember\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"v\": ");
        self().visit_expr(*x.m_v);
        s.append(",\n" + indtd);
        s.append("\"m\": ");
        self().visit_symbol(*x.m_m);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_EnumName(const EnumName_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"EnumName\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"v\": ");
        self().visit_expr(*x.m_v);
        s.append(",\n" + indtd);
        s.append("\"enum_type\": ");
        self().visit_ttype(*x.m_enum_type);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_EnumValue(const EnumValue_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"EnumValue\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"v\": ");
        self().visit_expr(*x.m_v);
        s.append(",\n" + indtd);
        s.append("\"enum_type\": ");
        self().visit_ttype(*x.m_enum_type);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_OverloadedCompare(const OverloadedCompare_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"OverloadedCompare\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_cmpopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
            s.append("[]");
        }
        s.append(",\n" + indtd);
        s.append("\"overloaded\": ");
        self().visit_expr(*x.m_overloaded);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        append_location(s, x.base.base.loc.first, x.base.base.loc.last);
        dec_indent(); s.append("\n" + indtd);
        s.append("}");
        if ((bool&)x) { } // Suppress unused warning
    }
    void visit_OverloadedBinOp(const OverloadedBinOp_t &x) {
        s.append("{");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"node\": \"OverloadedBinOp\"");
        s.append(",\n" + indtd);
        s.append("\"fields\": {");
        inc_indent(); s.append("\n" + indtd);
        s.append("\"left\": ");
        self().visit_expr(*x.m_left);
        s.append(",\n" + indtd);
        s.append("\"op\": ");
        visit_binopType(x.m_op);
        s.append(",\n" + indtd);
        s.append("\"right\": ");
        self().visit_expr(*x.m_right);
        s.append(",\n" + indtd);
        s.append("\"type\": ");
        self().visit_ttype(*x.m_type);
        s.append(",\n" + indtd);
        s.append("\"value\": ");
        if (x.m_value) {
            self().visit_expr(*x.m_value);
        } else {
