/* Generated by re2c 3.1 on Mon Apr 15 13:52:57 2024 */
#line 1 "parser/tokenizer.re"
#include <limits>

#include <lfortran/parser/parser_exception.h>
#include <lfortran/parser/tokenizer.h>
#include <lfortran/parser/parser.tab.hh>
#include <libasr/bigint.h>

namespace LCompilers::LFortran {

void Tokenizer::set_string(const std::string &str)
{
    // The input string must be NULL terminated, otherwise the tokenizer will
    // not detect the end of string. After C++11, the std::string is guaranteed
    // to end with \0, but we check this here just in case.
    LCOMPILERS_ASSERT(str[str.size()] == '\0');
    cur = (unsigned char *)(&str[0]);
    string_start = cur;
    cur_line = cur;
    line_num = 1;
}

template<int base>
bool adddgt(uint64_t &u, uint64_t d)
{
    if (u > (std::numeric_limits<uint64_t>::max() - d) / base) {
        return false;
    }
    u = u * base + d;
    return true;
}

bool lex_dec(const unsigned char *s, const unsigned char *e, uint64_t &u)
{
    for (u = 0; s < e; ++s) {
        if (!adddgt<10>(u, *s - 0x30u)) {
            return false;
        }
    }
    return true;
}

// Tokenizes integer of the kind 1234_ikind into `u` and `suffix`
// s ... the start of the integer
// e ... the character after the end
bool lex_int(const unsigned char *s, const unsigned char *e, uint64_t &u,
    Str &suffix)
{
    for (u = 0; s < e; ++s) {
        if (*s == '_') {
            s++;
            suffix.p = (char*) s;
            suffix.n = e-s;
            return true;
        } else if (!adddgt<10>(u, *s - 0x30u)) {
            return false;
        }
    }
    suffix.p = nullptr;
    suffix.n = 0;
    return true;
}

void lex_int_large(Allocator &al, const unsigned char *s,
    const unsigned char *e, BigInt::BigInt &u, Str &suffix)
{
    uint64_t ui;
    if (lex_int(s, e, ui, suffix)) {
        if (ui <= BigInt::MAX_SMALL_INT) {
            u.from_smallint(ui);
            return;
        }
    }
    const unsigned char *start = s;
    for (; s < e; ++s) {
        if (*s == '_') {
            s++;
            suffix.p = (char*) s;
            suffix.n = e-s;

            Str num;
            num.p = (char*)start;
            num.n = s-start-1;
            u.from_largeint(al, num);
            return;
        }
    }
    suffix.p = nullptr;
    suffix.n = 0;
    Str num;
    num.p = (char*)start;
    num.n = e-start;
    u.from_largeint(al, num);
}

uint64_t parse_int(const unsigned char *s)
{
    while (*s == ' ') s++;
    uint64_t u;
    for (u = 0; ; ++s) {
        if (*s >= '0' && *s <= '9') {
            if (!adddgt<10>(u, *s - 0x30u)) {
                return false;
            }
        } else {
            return u;
        }
    }
}

#define KW(x) token(yylval.string); RET(KW_##x);
#define RET(x) token_loc(loc); last_token=yytokentype::x; return yytokentype::x;
#define WARN_REL(x) add_rel_warning(diagnostics, fixed_form, yytokentype::TK_##x);

void Tokenizer::add_rel_warning(diag::Diagnostics &diagnostics, bool fixed_form, int rel_token) const {
    if (!fixed_form) {
        static const std::map<int, std::pair<std::string, std::string>> m = {
            {yytokentype::TK_EQ, {"==", ".eq."}},
            {yytokentype::TK_NE, {"/=", ".ne."}},
            {yytokentype::TK_LT, {"<",  ".lt."}},
            {yytokentype::TK_GT, {">",  ".gt."}},
            {yytokentype::TK_LE, {"<=", ".le."}},
            {yytokentype::TK_GE, {">=", ".ge."}},
        };
        const std::string rel_new = m.at(rel_token).first;
        const std::string rel_old = m.at(rel_token).second;
        Location loc;
        token_loc(loc);
        diagnostics.tokenizer_style_label(
            "Use '" + rel_new + "' instead of '" + rel_old + "'",
            {loc},
            "help: write this as '" + rel_new + "'");
    }
}

int Tokenizer::lex(Allocator &al, YYSTYPE &yylval, Location &loc, diag::Diagnostics &diagnostics)
{
    if (enddo_state == 1) {
        enddo_state = 2;
        KW(END_DO)
    } else if (enddo_state == 2) {
        enddo_insert_count--;
        if (enddo_insert_count > 0) {
            enddo_state = 1;
        } else {
            enddo_state = 0;
            token_loc(loc); line_num++; cur_line=cur;
            last_token = yytokentype::TK_NEWLINE;
        }
        return yytokentype::TK_NEWLINE;
    }
    for (;;) {
        tok = cur;

        /*
        Re2c has excellent documentation at:

        https://re2c.org/manual/manual_c.html

        The first paragraph there explains the basics:

        * If multiple rules match, the longest match takes precedence
        * If multiple rules match the same string, the earlier rule takes
          precedence
        * Default rule `*` should always be defined, it has the lowest priority
          regardless of its place and matches any code unit
        * We use the "Sentinel character" method for end of input:
            * The end of the input text is denoted with a null character \x00
            * Thus the null character cannot be part of the input otherwise
            * There is one rule to match \x00 to end the parser
            * No other rule is allowed to match \x00, otherwise the re2c block
              would parse past the end of the string and segfaults
            * A special case of the previous point are negated character
              ranges, such as [^"\x00], where one must include \x00 in it to
              ensure this rule does not match \x00 (all other rules simply do
              not mention \x00)
            * See the "Handling the end of input" section in the re2c
              documentation for more info

        The re2c block interacts with the rest of the code via just one pointer
        variable `cur`. On entering the re2c block, the `cur` variable must
        point to the first character of the token to be tokenized by the block.
        The re2c block below then executes on its own until a rule is matched:
        the action in {} is then executed. In that action `cur` points to the
        first character of the next token.

        Before the re2c block we save the current `cur` into `tok`, so that we
        can use `tok` and `cur` in the action in {} to extract the token that
        corresponds to the rule that got matched:

        * `tok` points to the first character of the token
        * `cur-1` points to the last character of the token
        * `cur` points to the first character of the next token
        * `cur-tok` is the length of the token

        In the action, we do one of:

        * call `continue` which executes another cycle in the for loop (which
          will parse the next token); we use this to skip a token
        * call `return` which returns from this function; we return a token
        * throw an exception (terminates the tokenizer)

        In the first two cases, `cur` points to first character of the next
        token, which becomes `tok` at the next iteration of the loop (either
        right away after `continue` or after the `lex` function is called again
        after `return`).

        See the manual for more details.
        */


        // These two variables are needed by the re2c block below internally,
        // initialization is not needed. One can think of them as local
        // variables of the re2c block.
        unsigned char *mar, *ctxmar;
        
#line 219 "parser/tokenizer.cpp"
{
	unsigned char yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		/* table 1 .. 8: 0 */
		  0,   2,   2,   2,   2,   2,   2,   2, 
		  2,   3,   3,   3,   2,   3,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  3,   2,   2,   2,   2,   2,   2,   0, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		242, 242, 210, 210, 210, 210, 210, 210, 
		146, 146,   2,   2,   2,   2,   2,   2, 
		  2, 150, 150, 150, 150, 150, 150,  22, 
		 22,  22,  22,  22,  22,  22,  22,  22, 
		 22,  22,  22,  22,  22,  22,  22,  22, 
		 22,  22,  22,   2,   2,   2,   2,  26, 
		  2, 150, 150, 150, 150, 150, 150,  22, 
		 22,  22,  22,  22,  22,  22,  22,  22, 
		 22,  22,  22,  22,  22,  22,  22,  22, 
		 22,  22,  22,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		  2,   2,   2,   2,   2,   2,   2,   2, 
		/* table 9 .. 13: 256 */
		  0, 192, 192, 192, 192, 192, 192, 192, 
		192, 200, 128, 200, 192, 200, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		200, 192,  64, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		240, 240, 240, 240, 240, 240, 240, 240, 
		240, 240, 192, 192, 192, 192, 192, 192, 
		192, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 192, 192, 192, 192, 192, 
		192, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 224, 224, 224, 224, 224, 
		224, 224, 224, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
		192, 192, 192, 192, 192, 192, 192, 192, 
	};
	yych = *cur;
	if (yybm[256+yych] & 8) {
		goto yy4;
	}
	switch (yych) {
		case 0x00: goto yy1;
		case '\t':
		case '\n': goto yy5;
		case ' ':
		case '!': goto yy6;
		case '"': goto yy7;
		case '#': goto yy8;
		case '%': goto yy9;
		case '&': goto yy10;
		case '\'': goto yy11;
		case '(': goto yy12;
		case ')': goto yy13;
		case '*': goto yy14;
		case '+': goto yy15;
		case ',': goto yy16;
		case '-': goto yy17;
		case '.': goto yy18;
		case '/': goto yy19;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy20;
		case ':': goto yy22;
		case ';': goto yy23;
		case '<': goto yy24;
		case '=': goto yy25;
		case '>': goto yy27;
		case 'A':
		case 'a': goto yy28;
		case 'B':
		case 'b': goto yy30;
		case 'C':
		case 'c': goto yy31;
		case 'D':
		case 'd': goto yy32;
		case 'E':
		case 'e': goto yy33;
		case 'F':
		case 'f': goto yy34;
		case 'G':
		case 'g': goto yy35;
		case 'H':
		case 'J':
		case 'X':
		case 'Y':
		case '_':
		case 'h':
		case 'j':
		case 'x':
		case 'y': goto yy36;
		case 'I':
		case 'i': goto yy38;
		case 'K':
		case 'k': goto yy39;
		case 'L':
		case 'l': goto yy40;
		case 'M':
		case 'm': goto yy41;
		case 'N':
		case 'n': goto yy42;
		case 'O':
		case 'o': goto yy43;
		case 'P':
		case 'p': goto yy44;
		case 'Q':
		case 'q': goto yy45;
		case 'R':
		case 'r': goto yy46;
		case 'S':
		case 's': goto yy47;
		case 'T':
		case 't': goto yy48;
		case 'U':
		case 'u': goto yy49;
		case 'V':
		case 'v': goto yy50;
		case 'W':
		case 'w': goto yy51;
		case 'Z':
		case 'z': goto yy52;
		case '[': goto yy53;
		case ']': goto yy55;
		case '{': goto yy56;
		case '|': goto yy57;
		case '}': goto yy58;
		default: goto yy2;
	}
yy1:
	++cur;
#line 250 "parser/tokenizer.re"
	{ RET(END_OF_FILE); }
#line 393 "parser/tokenizer.cpp"
yy2:
	++cur;
yy3:
#line 241 "parser/tokenizer.re"
	{ token_loc(loc);
                std::string t = token();
                throw parser_local::TokenizerError(diag::Diagnostic(
                    "Token '" + t + "' is not recognized",
                    diag::Level::Error, diag::Stage::Tokenizer, {
                        diag::Label("token not recognized", {loc})
                    })
                );
            }
#line 407 "parser/tokenizer.cpp"
yy4:
	yych = *++cur;
	if (yybm[256+yych] & 8) {
		goto yy4;
	}
#line 251 "parser/tokenizer.re"
	{ continue; }
#line 415 "parser/tokenizer.cpp"
yy5:
	++cur;
#line 507 "parser/tokenizer.re"
	{
                if (enddo_newline_process) {
                    enddo_newline_process = false;
                    enddo_state = 1;
                    return yytokentype::TK_NEWLINE;
                } else {
                    enddo_newline_process = false;
                    enddo_insert_count = 0;
                    token_loc(loc); line_num++; cur_line=cur;
                    last_token = yytokentype::TK_NEWLINE;
                    return yytokentype::TK_NEWLINE;
                }
            }
#line 432 "parser/tokenizer.cpp"
yy6:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy3;
	if (yych == 'L') goto yy63;
	goto yy60;
yy7:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy3;
	goto yy65;
yy8:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy3;
	goto yy70;
yy9:
	++cur;
#line 542 "parser/tokenizer.re"
	{ RET(TK_PERCENT) }
#line 453 "parser/tokenizer.cpp"
yy10:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy3;
		if (yych <= '\v') goto yy77;
		goto yy3;
	} else {
		if (yych <= '\r') goto yy77;
		if (yych <= 0x1F) goto yy3;
		if (yych <= '!') goto yy77;
		goto yy3;
	}
yy11:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy3;
	goto yy82;
yy12:
	yych = *++cur;
	if (yych == '/') {
		ctxmar = cur;
		goto yy84;
	}
#line 522 "parser/tokenizer.re"
	{ RET(TK_LPAREN) }
#line 480 "parser/tokenizer.cpp"
yy13:
	++cur;
#line 530 "parser/tokenizer.re"
	{ RET(TK_RPAREN) }
#line 485 "parser/tokenizer.cpp"
yy14:
	yych = *++cur;
	if (yych == '*') goto yy85;
#line 544 "parser/tokenizer.re"
	{ RET(TK_STAR) }
#line 491 "parser/tokenizer.cpp"
yy15:
	++cur;
#line 536 "parser/tokenizer.re"
	{ RET(TK_PLUS) }
#line 496 "parser/tokenizer.cpp"
yy16:
	++cur;
#line 543 "parser/tokenizer.re"
	{ RET(TK_COMMA) }
#line 501 "parser/tokenizer.cpp"
yy17:
	++cur;
#line 537 "parser/tokenizer.re"
	{ RET(TK_MINUS) }
#line 506 "parser/tokenizer.cpp"
yy18:
	yyaccept = 0;
	yych = *(mar = ++cur);
	switch (yych) {
		case '.': goto yy86;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy87;
		case 'A':
		case 'a': goto yy90;
		case 'B':
		case 'C':
		case 'D':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'M':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'U':
		case 'V':
		case 'W':
		case 'Y':
		case 'Z':
		case 'b':
		case 'c':
		case 'd':
		case 'h':
		case 'i':
		case 'j':
		case 'k':
		case 'm':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 'u':
		case 'v':
		case 'w':
		case 'y':
		case 'z': goto yy91;
		case 'E':
		case 'e': goto yy93;
		case 'F':
		case 'f': goto yy94;
		case 'G':
		case 'g': goto yy95;
		case 'L':
		case 'l': goto yy96;
		case 'N':
		case 'n': goto yy97;
		case 'O':
		case 'o': goto yy98;
		case 'T':
		case 't': goto yy99;
		case 'X':
		case 'x': goto yy100;
		default: goto yy3;
	}
yy19:
	yych = *++cur;
	if (yych <= '.') {
		if (yych == ')') goto yy101;
	} else {
		if (yych <= '/') goto yy102;
		if (yych == '=') goto yy103;
	}
#line 541 "parser/tokenizer.re"
	{ RET(TK_SLASH) }
#line 586 "parser/tokenizer.cpp"
yy20:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yybm[256+yych] & 16) {
		goto yy20;
	}
	if (yych <= ' ') {
		if (yych <= '\v') {
			if (yych == '\t') {
				ctxmar = cur;
				goto yy104;
			}
			if (yych >= '\v') {
				ctxmar = cur;
				goto yy104;
			}
		} else {
			if (yych == '\r') {
				ctxmar = cur;
				goto yy104;
			}
			if (yych >= ' ') {
				ctxmar = cur;
				goto yy104;
			}
		}
	} else {
		if (yych <= 'E') {
			if (yych == '.') {
				ctxmar = cur;
				goto yy105;
			}
			if (yych >= 'D') goto yy106;
		} else {
			if (yych <= '_') {
				if (yych >= '_') goto yy107;
			} else {
				if (yych <= 'c') goto yy21;
				if (yych <= 'e') goto yy106;
			}
		}
	}
yy21:
#line 629 "parser/tokenizer.re"
	{
                lex_int_large(al, tok, cur,
                    yylval.int_suffix.int_n,
                    yylval.int_suffix.int_kind);
                RET(TK_INTEGER)
            }
#line 637 "parser/tokenizer.cpp"
yy22:
	yych = *++cur;
	if (yych == ':') goto yy108;
#line 539 "parser/tokenizer.re"
	{ RET(TK_COLON) }
#line 643 "parser/tokenizer.cpp"
yy23:
	++cur;
#line 540 "parser/tokenizer.re"
	{ RET(TK_SEMICOLON) }
#line 648 "parser/tokenizer.cpp"
yy24:
	yych = *++cur;
	if (yych == '=') goto yy109;
#line 561 "parser/tokenizer.re"
	{ RET(TK_LT) }
#line 654 "parser/tokenizer.cpp"
yy25:
	yych = *++cur;
	if (yych <= '<') goto yy26;
	if (yych <= '=') goto yy110;
	if (yych <= '>') goto yy111;
yy26:
#line 538 "parser/tokenizer.re"
	{ RET(TK_EQUAL) }
#line 663 "parser/tokenizer.cpp"
yy27:
	yych = *++cur;
	if (yych == '=') goto yy112;
#line 567 "parser/tokenizer.re"
	{ RET(TK_GT) }
#line 669 "parser/tokenizer.cpp"
yy28:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych <= 'K') {
			if (yych == 'B') goto yy113;
			goto yy37;
		} else {
			if (yych <= 'L') goto yy114;
			if (yych <= 'R') goto yy37;
			goto yy115;
		}
	} else {
		if (yych <= 'k') {
			if (yych == 'b') goto yy113;
			goto yy37;
		} else {
			if (yych <= 'l') goto yy114;
			if (yych == 's') goto yy115;
			goto yy37;
		}
	}
yy29:
#line 721 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_NAME) }
#line 694 "parser/tokenizer.cpp"
yy30:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= 'I') {
		if (yych <= '\'') {
			if (yych == '"') goto yy117;
			if (yych <= '&') goto yy37;
			goto yy118;
		} else {
			if (yych == 'A') goto yy119;
			if (yych <= 'H') goto yy37;
			goto yy120;
		}
	} else {
		if (yych <= 'a') {
			if (yych == 'L') goto yy121;
			if (yych <= '`') goto yy37;
			goto yy119;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy37;
				goto yy120;
			} else {
				if (yych == 'l') goto yy121;
				goto yy37;
			}
		}
	}
yy31:
	yych = *++cur;
	switch (yych) {
		case 'A':
		case 'a': goto yy122;
		case 'H':
		case 'h': goto yy123;
		case 'L':
		case 'l': goto yy124;
		case 'O':
		case 'o': goto yy125;
		case 'R':
		case 'r': goto yy126;
		case 'Y':
		case 'y': goto yy127;
		default: goto yy37;
	}
yy32:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych <= 'E') {
			if (yych == 'A') goto yy128;
			if (yych <= 'D') goto yy37;
			goto yy129;
		} else {
			if (yych == 'I') goto yy130;
			if (yych <= 'N') goto yy37;
			goto yy131;
		}
	} else {
		if (yych <= 'e') {
			if (yych == 'a') goto yy128;
			if (yych <= 'd') goto yy37;
			goto yy129;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy37;
				goto yy130;
			} else {
				if (yych == 'o') goto yy131;
				goto yy37;
			}
		}
	}
yy33:
	yych = *++cur;
	switch (yych) {
		case 'L':
		case 'l': goto yy133;
		case 'N':
		case 'n': goto yy134;
		case 'Q':
		case 'q': goto yy135;
		case 'R':
		case 'r': goto yy136;
		case 'V':
		case 'v': goto yy137;
		case 'X':
		case 'x': goto yy138;
		default: goto yy37;
	}
yy34:
	yych = *++cur;
	switch (yych) {
		case 'I':
		case 'i': goto yy139;
		case 'L':
		case 'l': goto yy140;
		case 'O':
		case 'o': goto yy141;
		case 'U':
		case 'u': goto yy142;
		default: goto yy37;
	}
yy35:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'E') goto yy143;
		if (yych <= 'N') goto yy37;
		goto yy144;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy143;
		} else {
			if (yych == 'o') goto yy144;
			goto yy37;
		}
	}
yy36:
	yych = *++cur;
yy37:
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
	goto yy29;
yy38:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych <= 'L') {
			if (yych == 'F') goto yy146;
			goto yy37;
		} else {
			if (yych <= 'M') goto yy147;
			if (yych <= 'N') goto yy148;
			if (yych <= 'R') goto yy37;
			goto yy150;
		}
	} else {
		if (yych <= 'm') {
			if (yych == 'f') goto yy146;
			if (yych <= 'l') goto yy37;
			goto yy147;
		} else {
			if (yych <= 'n') goto yy148;
			if (yych == 's') goto yy150;
			goto yy37;
		}
	}
yy39:
	yych = *++cur;
	if (yych == 'I') goto yy151;
	if (yych == 'i') goto yy151;
	goto yy37;
yy40:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'E') goto yy152;
		if (yych <= 'N') goto yy37;
		goto yy153;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy152;
		} else {
			if (yych == 'o') goto yy153;
			goto yy37;
		}
	}
yy41:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'E') goto yy154;
		if (yych <= 'N') goto yy37;
		goto yy155;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy154;
		} else {
			if (yych == 'o') goto yy155;
			goto yy37;
		}
	}
yy42:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'E') {
			if (yych == 'A') goto yy156;
			if (yych <= 'D') goto yy37;
			goto yy157;
		} else {
			if (yych == 'O') goto yy158;
			if (yych <= 'T') goto yy37;
			goto yy159;
		}
	} else {
		if (yych <= 'e') {
			if (yych == 'a') goto yy156;
			if (yych <= 'd') goto yy37;
			goto yy157;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy37;
				goto yy158;
			} else {
				if (yych == 'u') goto yy159;
				goto yy37;
			}
		}
	}
yy43:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= 'P') {
		if (yych <= '\'') {
			if (yych == '"') goto yy160;
			if (yych <= '&') goto yy37;
			goto yy161;
		} else {
			if (yych == 'N') goto yy162;
			if (yych <= 'O') goto yy37;
			goto yy163;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'U') goto yy164;
			if (yych <= 'm') goto yy37;
			goto yy162;
		} else {
			if (yych <= 'p') {
				if (yych <= 'o') goto yy37;
				goto yy163;
			} else {
				if (yych == 'u') goto yy164;
				goto yy37;
			}
		}
	}
yy44:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'O') {
			if (yych == 'A') goto yy165;
			if (yych <= 'N') goto yy37;
			goto yy166;
		} else {
			if (yych == 'R') goto yy167;
			if (yych <= 'T') goto yy37;
			goto yy168;
		}
	} else {
		if (yych <= 'o') {
			if (yych == 'a') goto yy165;
			if (yych <= 'n') goto yy37;
			goto yy166;
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy37;
				goto yy167;
			} else {
				if (yych == 'u') goto yy168;
				goto yy37;
			}
		}
	}
yy45:
	yych = *++cur;
	if (yych == 'U') goto yy169;
	if (yych == 'u') goto yy169;
	goto yy37;
yy46:
	yych = *++cur;
	if (yych <= 'E') {
		if (yych == 'A') goto yy170;
		if (yych <= 'D') goto yy37;
		goto yy171;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy170;
		} else {
			if (yych == 'e') goto yy171;
			goto yy37;
		}
	}
yy47:
	yych = *++cur;
	switch (yych) {
		case 'A':
		case 'a': goto yy172;
		case 'E':
		case 'e': goto yy173;
		case 'H':
		case 'h': goto yy174;
		case 'O':
		case 'o': goto yy175;
		case 'T':
		case 't': goto yy176;
		case 'U':
		case 'u': goto yy177;
		case 'Y':
		case 'y': goto yy178;
		default: goto yy37;
	}
yy48:
	yych = *++cur;
	switch (yych) {
		case 'A':
		case 'a': goto yy179;
		case 'E':
		case 'e': goto yy180;
		case 'H':
		case 'h': goto yy181;
		case 'O':
		case 'o': goto yy182;
		case 'Y':
		case 'y': goto yy183;
		default: goto yy37;
	}
yy49:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych == 'N') goto yy184;
		if (yych <= 'R') goto yy37;
		goto yy185;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy37;
			goto yy184;
		} else {
			if (yych == 's') goto yy185;
			goto yy37;
		}
	}
yy50:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'A') goto yy186;
		if (yych <= 'N') goto yy37;
		goto yy187;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy186;
		} else {
			if (yych == 'o') goto yy187;
			goto yy37;
		}
	}
yy51:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych <= 'G') {
			if (yych == 'A') goto yy188;
			goto yy37;
		} else {
			if (yych <= 'H') goto yy189;
			if (yych <= 'Q') goto yy37;
			goto yy190;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'a') goto yy188;
			goto yy37;
		} else {
			if (yych <= 'h') goto yy189;
			if (yych == 'r') goto yy190;
			goto yy37;
		}
	}
yy52:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych == '"') goto yy191;
	if (yych == '\'') goto yy192;
	goto yy37;
yy53:
	++cur;
yy54:
#line 531 "parser/tokenizer.re"
	{ RET(TK_LBRACKET) }
#line 1076 "parser/tokenizer.cpp"
yy55:
	++cur;
#line 532 "parser/tokenizer.re"
	{ RET(TK_RBRACKET) }
#line 1081 "parser/tokenizer.cpp"
yy56:
	++cur;
#line 533 "parser/tokenizer.re"
	{ RET(TK_LBRACE) }
#line 1086 "parser/tokenizer.cpp"
yy57:
	++cur;
#line 545 "parser/tokenizer.re"
	{ RET(TK_VBAR) }
#line 1091 "parser/tokenizer.cpp"
yy58:
	++cur;
#line 534 "parser/tokenizer.re"
	{ RET(TK_RBRACE) }
#line 1096 "parser/tokenizer.cpp"
yy59:
	yych = *++cur;
yy60:
	if (yybm[256+yych] & 64) {
		goto yy59;
	}
	if (yych >= 0x01) goto yy62;
yy61:
	cur = mar;
	if (yyaccept <= 7) {
		if (yyaccept <= 3) {
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy3;
				} else {
					goto yy21;
				}
			} else {
				if (yyaccept == 2) {
					goto yy29;
				} else {
					goto yy66;
				}
			}
		} else {
			if (yyaccept <= 5) {
				if (yyaccept == 4) {
					goto yy79;
				} else {
					goto yy83;
				}
			} else {
				if (yyaccept == 6) {
					goto yy54;
				} else {
					goto yy89;
				}
			}
		}
	} else {
		if (yyaccept <= 11) {
			if (yyaccept <= 9) {
				if (yyaccept == 8) {
					goto yy132;
				} else {
					goto yy149;
				}
			} else {
				if (yyaccept == 10) {
					goto yy256;
				} else {
					goto yy673;
				}
			}
		} else {
			if (yyaccept <= 13) {
				if (yyaccept == 12) {
					goto yy806;
				} else {
					goto yy959;
				}
			} else {
				goto yy1029;
			}
		}
	}
yy62:
	++cur;
#line 659 "parser/tokenizer.re"
	{
                line_num++; cur_line=cur;
                token(yylval.string);
                yylval.string.n--;
                token_loc(loc);
                if (last_token == yytokentype::TK_NEWLINE) {
                    return yytokentype::TK_COMMENT;
                } else {
                    last_token=yytokentype::TK_NEWLINE;
                    return yytokentype::TK_EOLCOMMENT;
                }
            }
#line 1178 "parser/tokenizer.cpp"
yy63:
	yych = *++cur;
	if (yych == 'F') goto yy193;
	goto yy60;
yy64:
	yych = *++cur;
yy65:
	if (yybm[256+yych] & 128) {
		goto yy64;
	}
	if (yych <= 0x00) goto yy61;
	yyaccept = 3;
	yych = *(mar = ++cur);
	if (yych == '"') goto yy64;
yy66:
#line 717 "parser/tokenizer.re"
	{ token_str(al, yylval.string, '"'); RET(TK_STRING) }
#line 1196 "parser/tokenizer.cpp"
yy67:
	yych = *++cur;
yy68:
	if (yych <= 0x00) goto yy61;
	if (yych == '\n') goto yy71;
	goto yy67;
yy69:
	yych = *++cur;
yy70:
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy61;
			if (yych <= 0x08) goto yy67;
			if (yych <= '\t') goto yy69;
		} else {
			if (yych == '\f') goto yy67;
			if (yych <= '\r') goto yy69;
			goto yy67;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= ' ') goto yy69;
			if (yych <= 'c') goto yy67;
			if (yych <= 'd') goto yy72;
			goto yy73;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy67;
				goto yy74;
			} else {
				if (yych == 'l') goto yy75;
				goto yy67;
			}
		}
	}
yy71:
	++cur;
#line 709 "parser/tokenizer.re"
	{
                Location loc; token_loc(loc);
                diagnostics.tokenizer_warning_label(
                    "Unsupported macro", {loc},
                    "Ignored");
                line_num++; cur_line=cur; continue;
            }
#line 1242 "parser/tokenizer.cpp"
yy72:
	yych = *++cur;
	if (yych == 'e') goto yy194;
	goto yy68;
yy73:
	yych = *++cur;
	if (yych == 'l') goto yy195;
	if (yych == 'n') goto yy196;
	goto yy68;
yy74:
	yych = *++cur;
	if (yych == 'f') goto yy197;
	goto yy68;
yy75:
	yych = *++cur;
	if (yych == 'i') goto yy198;
	goto yy68;
yy76:
	yych = *++cur;
yy77:
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy61;
			goto yy76;
		} else {
			if (yych <= '\n') goto yy78;
			if (yych <= '\v') goto yy76;
			goto yy61;
		}
	} else {
		if (yych <= 0x1F) {
			if (yych <= '\r') goto yy76;
			goto yy61;
		} else {
			if (yych <= ' ') goto yy76;
			if (yych <= '!') goto yy80;
			goto yy61;
		}
	}
yy78:
	yyaccept = 4;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 1) {
		goto yy78;
	}
	if (yych <= 0x1F) goto yy79;
	if (yych <= '!') goto yy80;
	if (yych == '&') goto yy199;
yy79:
#line 643 "parser/tokenizer.re"
	{
                line_num++; cur_line=cur; continue;
            }
#line 1296 "parser/tokenizer.cpp"
yy80:
	yych = *++cur;
	if (yych <= 0x00) goto yy61;
	if (yych == '\n') goto yy78;
	goto yy80;
yy81:
	yych = *++cur;
yy82:
	if (yybm[0+yych] & 2) {
		goto yy81;
	}
	if (yych <= 0x00) goto yy61;
	yyaccept = 5;
	yych = *(mar = ++cur);
	if (yych == '\'') goto yy81;
yy83:
#line 718 "parser/tokenizer.re"
	{ token_str(al, yylval.string, '\''); RET(TK_STRING) }
#line 1315 "parser/tokenizer.cpp"
yy84:
	yyaccept = 6;
	yych = *(mar = ++cur);
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych == '\t') goto yy200;
			goto yy54;
		} else {
			if (yych == '\f') goto yy54;
			if (yych <= '\r') goto yy200;
			goto yy54;
		}
	} else {
		if (yych <= '.') {
			if (yych <= ' ') goto yy200;
			if (yych == ')') goto yy201;
			goto yy54;
		} else {
			if (yych <= '/') goto yy202;
			if (yych == '=') goto yy203;
			goto yy54;
		}
	}
yy85:
	++cur;
#line 550 "parser/tokenizer.re"
	{ RET(TK_POW) }
#line 1343 "parser/tokenizer.cpp"
yy86:
	++cur;
#line 548 "parser/tokenizer.re"
	{ RET(TK_DBL_DOT) }
#line 1348 "parser/tokenizer.cpp"
yy87:
	yyaccept = 7;
	yych = *(mar = ++cur);
yy88:
	if (yych <= 'E') {
		if (yych <= '/') goto yy89;
		if (yych <= '9') goto yy87;
		if (yych >= 'D') goto yy106;
	} else {
		if (yych <= '_') {
			if (yych >= '_') goto yy204;
		} else {
			if (yych <= 'c') goto yy89;
			if (yych <= 'e') goto yy106;
		}
	}
yy89:
#line 600 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_REAL) }
#line 1368 "parser/tokenizer.cpp"
yy90:
	yych = *++cur;
	if (yych == 'N') goto yy206;
	if (yych == 'n') goto yy206;
	goto yy92;
yy91:
	yych = *++cur;
yy92:
	if (yybm[0+yych] & 4) {
		goto yy91;
	}
	if (yych == '.') goto yy205;
	goto yy61;
yy93:
	yych = *++cur;
	if (yych == 'Q') goto yy207;
	if (yych == 'q') goto yy207;
	goto yy92;
yy94:
	yych = *++cur;
	if (yych == 'A') goto yy208;
	if (yych == 'a') goto yy208;
	goto yy92;
yy95:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych == 'E') goto yy209;
		if (yych <= 'S') goto yy92;
		goto yy210;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy92;
			goto yy209;
		} else {
			if (yych == 't') goto yy210;
			goto yy92;
		}
	}
yy96:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych == 'E') goto yy211;
		if (yych <= 'S') goto yy92;
		goto yy212;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy92;
			goto yy211;
		} else {
			if (yych == 't') goto yy212;
			goto yy92;
		}
	}
yy97:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'E') goto yy213;
		if (yych <= 'N') goto yy92;
		goto yy214;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy92;
			goto yy213;
		} else {
			if (yych == 'o') goto yy214;
			goto yy92;
		}
	}
yy98:
	yych = *++cur;
	if (yych == 'R') goto yy215;
	if (yych == 'r') goto yy215;
	goto yy92;
yy99:
	yych = *++cur;
	if (yych == 'R') goto yy216;
	if (yych == 'r') goto yy216;
	goto yy92;
yy100:
	yych = *++cur;
	if (yych == 'O') goto yy217;
	if (yych == 'o') goto yy217;
	goto yy92;
yy101:
	++cur;
#line 535 "parser/tokenizer.re"
	{ RET(TK_RBRACKET_OLD) }
#line 1456 "parser/tokenizer.cpp"
yy102:
	++cur;
#line 551 "parser/tokenizer.re"
	{ RET(TK_CONCAT) }
#line 1461 "parser/tokenizer.cpp"
yy103:
	++cur;
#line 558 "parser/tokenizer.re"
	{ RET(TK_NE) }
#line 1466 "parser/tokenizer.cpp"
yy104:
	yych = *++cur;
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych == '\t') goto yy104;
			goto yy61;
		} else {
			if (yych == '\f') goto yy61;
			if (yych <= '\r') goto yy104;
			goto yy61;
		}
	} else {
		if (yych <= '^') {
			if (yych <= ' ') goto yy104;
			if (yych <= '@') goto yy61;
			if (yych <= 'Z') goto yy218;
			goto yy61;
		} else {
			if (yych == '`') goto yy61;
			if (yych <= 'z') goto yy218;
			goto yy61;
		}
	}
yy105:
	yyaccept = 7;
	yych = *(mar = ++cur);
	if (yych <= 'Z') {
		if (yych <= '@') goto yy88;
		if (yych <= 'C') goto yy219;
		if (yych <= 'E') goto yy221;
		goto yy219;
	} else {
		if (yych <= 'c') {
			if (yych <= '`') goto yy88;
			goto yy219;
		} else {
			if (yych <= 'e') goto yy221;
			if (yych <= 'z') goto yy219;
			goto yy88;
		}
	}
yy106:
	yych = *++cur;
	if (yych <= ',') {
		if (yych == '+') goto yy222;
		goto yy61;
	} else {
		if (yych <= '-') goto yy222;
		if (yych <= '/') goto yy61;
		if (yych <= '9') goto yy223;
		goto yy61;
	}
yy107:
	yych = *++cur;
	if (yych <= '9') {
		if (yych <= '&') {
			if (yych == '"') goto yy64;
			goto yy61;
		} else {
			if (yych <= '\'') goto yy81;
			if (yych <= '/') goto yy61;
			goto yy224;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy61;
			if (yych <= 'Z') goto yy225;
			goto yy61;
		} else {
			if (yych == '`') goto yy61;
			if (yych <= 'z') goto yy225;
			goto yy61;
		}
	}
yy108:
	++cur;
#line 549 "parser/tokenizer.re"
	{ RET(TK_DBL_COLON) }
#line 1545 "parser/tokenizer.cpp"
yy109:
	++cur;
#line 564 "parser/tokenizer.re"
	{ RET(TK_LE) }
#line 1550 "parser/tokenizer.cpp"
yy110:
	++cur;
#line 555 "parser/tokenizer.re"
	{ RET(TK_EQ) }
#line 1555 "parser/tokenizer.cpp"
yy111:
	++cur;
#line 552 "parser/tokenizer.re"
	{ RET(TK_ARROW) }
#line 1560 "parser/tokenizer.cpp"
yy112:
	++cur;
#line 570 "parser/tokenizer.re"
	{ RET(TK_GE) }
#line 1565 "parser/tokenizer.cpp"
yy113:
	yych = *++cur;
	if (yych == 'S') goto yy226;
	if (yych == 's') goto yy226;
	goto yy37;
yy114:
	yych = *++cur;
	if (yych == 'L') goto yy227;
	if (yych == 'l') goto yy227;
	goto yy37;
yy115:
	yych = *++cur;
	if (yych <= 'Y') {
		if (yych == 'S') goto yy229;
		if (yych <= 'X') goto yy37;
		goto yy230;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy37;
			goto yy229;
		} else {
			if (yych == 'y') goto yy230;
			goto yy37;
		}
	}
yy116:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych <= '&') {
		if (yych == '"') goto yy64;
		goto yy29;
	} else {
		if (yych <= '\'') goto yy81;
		if (yych == '_') goto yy116;
		goto yy29;
	}
yy117:
	yych = *++cur;
	if (yybm[0+yych] & 32) {
		goto yy231;
	}
	goto yy61;
yy118:
	yych = *++cur;
	if (yych <= '/') goto yy61;
	if (yych <= '1') goto yy232;
	goto yy61;
yy119:
	yych = *++cur;
	if (yych == 'C') goto yy233;
	if (yych == 'c') goto yy233;
	goto yy37;
yy120:
	yych = *++cur;
	if (yych == 'N') goto yy234;
	if (yych == 'n') goto yy234;
	goto yy37;
yy121:
	yych = *++cur;
	if (yych == 'O') goto yy235;
	if (yych == 'o') goto yy235;
	goto yy37;
yy122:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych == 'L') goto yy236;
		if (yych <= 'R') goto yy37;
		goto yy237;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy37;
			goto yy236;
		} else {
			if (yych == 's') goto yy237;
			goto yy37;
		}
	}
yy123:
	yych = *++cur;
	if (yych == 'A') goto yy238;
	if (yych == 'a') goto yy238;
	goto yy37;
yy124:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'A') goto yy239;
		if (yych <= 'N') goto yy37;
		goto yy240;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy239;
		} else {
			if (yych == 'o') goto yy240;
			goto yy37;
		}
	}
yy125:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy37;
			goto yy241;
		} else {
			if (yych <= 'L') goto yy37;
			if (yych <= 'M') goto yy242;
			goto yy243;
		}
	} else {
		if (yych <= 'l') {
			if (yych == 'd') goto yy241;
			goto yy37;
		} else {
			if (yych <= 'm') goto yy242;
			if (yych <= 'n') goto yy243;
			goto yy37;
		}
	}
yy126:
	yych = *++cur;
	if (yych == 'I') goto yy244;
	if (yych == 'i') goto yy244;
	goto yy37;
yy127:
	yych = *++cur;
	if (yych == 'C') goto yy245;
	if (yych == 'c') goto yy245;
	goto yy37;
yy128:
	yych = *++cur;
	if (yych == 'T') goto yy246;
	if (yych == 't') goto yy246;
	goto yy37;
yy129:
	yych = *++cur;
	if (yych <= 'F') {
		if (yych == 'A') goto yy247;
		if (yych <= 'E') goto yy37;
		goto yy248;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy247;
		} else {
			if (yych == 'f') goto yy248;
			goto yy37;
		}
	}
yy130:
	yych = *++cur;
	if (yych == 'M') goto yy249;
	if (yych == 'm') goto yy249;
	goto yy37;
yy131:
	yyaccept = 8;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 8) {
		goto yy116;
	}
	if (yych <= '@') {
		if (yych <= '\f') {
			if (yych <= '\t') {
				if (yych >= '\t') {
					ctxmar = cur;
					goto yy250;
				}
			} else {
				if (yych == '\v') {
					ctxmar = cur;
					goto yy250;
				}
			}
		} else {
			if (yych <= ' ') {
				if (yych <= '\r') {
					ctxmar = cur;
					goto yy250;
				}
				if (yych >= ' ') {
					ctxmar = cur;
					goto yy250;
				}
			} else {
				if (yych <= '/') goto yy132;
				if (yych <= '9') goto yy36;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'V') {
				if (yych == 'U') goto yy251;
				goto yy36;
			} else {
				if (yych <= 'W') goto yy252;
				if (yych <= 'Z') goto yy36;
			}
		} else {
			if (yych <= 'v') {
				if (yych == 'u') goto yy251;
				goto yy36;
			} else {
				if (yych <= 'w') goto yy252;
				if (yych <= 'z') goto yy36;
			}
		}
	}
yy132:
#line 293 "parser/tokenizer.re"
	{ KW(DO) }
#line 1778 "parser/tokenizer.cpp"
yy133:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych == 'E') goto yy253;
		if (yych <= 'R') goto yy37;
		goto yy254;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy253;
		} else {
			if (yych == 's') goto yy254;
			goto yy37;
		}
	}
yy134:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy37;
			goto yy255;
		} else {
			if (yych <= 'S') goto yy37;
			if (yych <= 'T') goto yy257;
			goto yy258;
		}
	} else {
		if (yych <= 's') {
			if (yych == 'd') goto yy255;
			goto yy37;
		} else {
			if (yych <= 't') goto yy257;
			if (yych <= 'u') goto yy258;
			goto yy37;
		}
	}
yy135:
	yych = *++cur;
	if (yych == 'U') goto yy259;
	if (yych == 'u') goto yy259;
	goto yy37;
yy136:
	yych = *++cur;
	if (yych == 'R') goto yy260;
	if (yych == 'r') goto yy260;
	goto yy37;
yy137:
	yych = *++cur;
	if (yych == 'E') goto yy261;
	if (yych == 'e') goto yy261;
	goto yy37;
yy138:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych == 'I') goto yy262;
		if (yych <= 'S') goto yy37;
		goto yy263;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy37;
			goto yy262;
		} else {
			if (yych == 't') goto yy263;
			goto yy37;
		}
	}
yy139:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych == 'L') goto yy264;
		if (yych <= 'M') goto yy37;
		goto yy265;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy37;
			goto yy264;
		} else {
			if (yych == 'n') goto yy265;
			goto yy37;
		}
	}
yy140:
	yych = *++cur;
	if (yych == 'U') goto yy266;
	if (yych == 'u') goto yy266;
	goto yy37;
yy141:
	yych = *++cur;
	if (yych == 'R') goto yy267;
	if (yych == 'r') goto yy267;
	goto yy37;
yy142:
	yych = *++cur;
	if (yych == 'N') goto yy268;
	if (yych == 'n') goto yy268;
	goto yy37;
yy143:
	yych = *++cur;
	if (yych == 'N') goto yy269;
	if (yych == 'n') goto yy269;
	goto yy37;
yy144:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy116;
	}
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy145;
			if (yych <= 'S') goto yy36;
			goto yy270;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 't') goto yy270;
			if (yych <= 'z') goto yy36;
		}
	}
yy145:
#line 410 "parser/tokenizer.re"
	{ KW(GO) }
#line 1905 "parser/tokenizer.cpp"
yy146:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 412 "parser/tokenizer.re"
	{ KW(IF) }
#line 1914 "parser/tokenizer.cpp"
yy147:
	yych = *++cur;
	if (yych <= 'P') {
		if (yych == 'A') goto yy271;
		if (yych <= 'O') goto yy37;
		goto yy272;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy271;
		} else {
			if (yych == 'p') goto yy272;
			goto yy37;
		}
	}
yy148:
	yyaccept = 9;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 8) {
		goto yy116;
	}
	if (yych <= 'P') {
		if (yych <= ' ') {
			if (yych <= '\v') {
				if (yych == '\t') goto yy273;
				if (yych >= '\v') goto yy273;
			} else {
				if (yych == '\r') goto yy273;
				if (yych >= ' ') goto yy273;
			}
		} else {
			if (yych <= 'B') {
				if (yych <= '/') goto yy149;
				if (yych <= '9') goto yy36;
				if (yych >= 'A') goto yy36;
			} else {
				if (yych <= 'C') goto yy274;
				if (yych == 'O') goto yy275;
				goto yy36;
			}
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'T') {
				if (yych <= 'Q') goto yy276;
				if (yych <= 'R') goto yy36;
				if (yych <= 'S') goto yy277;
				goto yy278;
			} else {
				if (yych <= 'Z') goto yy36;
				if (yych <= '`') goto yy149;
				if (yych <= 'b') goto yy36;
				goto yy274;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy275;
				if (yych <= 'p') goto yy36;
				goto yy276;
			} else {
				if (yych <= 's') {
					if (yych <= 'r') goto yy36;
					goto yy277;
				} else {
					if (yych <= 't') goto yy278;
					if (yych <= 'z') goto yy36;
				}
			}
		}
	}
yy149:
#line 417 "parser/tokenizer.re"
	{ KW(IN) }
#line 1988 "parser/tokenizer.cpp"
yy150:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 427 "parser/tokenizer.re"
	{ KW(IS) }
#line 1997 "parser/tokenizer.cpp"
yy151:
	yych = *++cur;
	if (yych == 'N') goto yy279;
	if (yych == 'n') goto yy279;
	goto yy37;
yy152:
	yych = *++cur;
	if (yych == 'N') goto yy280;
	if (yych == 'n') goto yy280;
	goto yy37;
yy153:
	yych = *++cur;
	if (yych <= 'G') {
		if (yych == 'C') goto yy281;
		if (yych <= 'F') goto yy37;
		goto yy282;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy37;
			goto yy281;
		} else {
			if (yych == 'g') goto yy282;
			goto yy37;
		}
	}
yy154:
	yych = *++cur;
	if (yych == 'M') goto yy283;
	if (yych == 'm') goto yy283;
	goto yy37;
yy155:
	yych = *++cur;
	if (yych <= 'L') {
		if (yych == 'D') goto yy284;
		if (yych <= 'K') goto yy37;
		goto yy285;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy37;
			goto yy284;
		} else {
			if (yych == 'l') goto yy285;
			goto yy37;
		}
	}
yy156:
	yych = *++cur;
	if (yych == 'M') goto yy286;
	if (yych == 'm') goto yy286;
	goto yy37;
yy157:
	yych = *++cur;
	if (yych == 'W') goto yy287;
	if (yych == 'w') goto yy287;
	goto yy37;
yy158:
	yych = *++cur;
	if (yych <= 'P') {
		if (yych == 'N') goto yy288;
		if (yych <= 'O') goto yy37;
		goto yy289;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy37;
			goto yy288;
		} else {
			if (yych == 'p') goto yy289;
			goto yy37;
		}
	}
yy159:
	yych = *++cur;
	if (yych == 'L') goto yy290;
	if (yych == 'l') goto yy290;
	goto yy37;
yy160:
	yych = *++cur;
	if (yybm[0+yych] & 64) {
		goto yy291;
	}
	goto yy61;
yy161:
	yych = *++cur;
	if (yych <= '/') goto yy61;
	if (yych <= '7') goto yy292;
	goto yy61;
yy162:
	yych = *++cur;
	if (yych == 'L') goto yy293;
	if (yych == 'l') goto yy293;
	goto yy37;
yy163:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych == 'E') goto yy294;
		if (yych <= 'S') goto yy37;
		goto yy295;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy294;
		} else {
			if (yych == 't') goto yy295;
			goto yy37;
		}
	}
yy164:
	yych = *++cur;
	if (yych == 'T') goto yy296;
	if (yych == 't') goto yy296;
	goto yy37;
yy165:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych <= 'Q') goto yy37;
		if (yych <= 'R') goto yy297;
		goto yy298;
	} else {
		if (yych <= 'q') goto yy37;
		if (yych <= 'r') goto yy297;
		if (yych <= 's') goto yy298;
		goto yy37;
	}
yy166:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych == 'I') goto yy299;
		if (yych <= 'R') goto yy37;
		goto yy300;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy37;
			goto yy299;
		} else {
			if (yych == 's') goto yy300;
			goto yy37;
		}
	}
yy167:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'E') goto yy301;
			goto yy37;
		} else {
			if (yych <= 'I') goto yy302;
			if (yych <= 'N') goto yy37;
			goto yy303;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'e') goto yy301;
			goto yy37;
		} else {
			if (yych <= 'i') goto yy302;
			if (yych == 'o') goto yy303;
			goto yy37;
		}
	}
yy168:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'B') goto yy304;
		if (yych <= 'Q') goto yy37;
		goto yy305;
	} else {
		if (yych <= 'b') {
			if (yych <= 'a') goto yy37;
			goto yy304;
		} else {
			if (yych == 'r') goto yy305;
			goto yy37;
		}
	}
yy169:
	yych = *++cur;
	if (yych == 'I') goto yy306;
	if (yych == 'i') goto yy306;
	goto yy37;
yy170:
	yych = *++cur;
	if (yych == 'N') goto yy307;
	if (yych == 'n') goto yy307;
	goto yy37;
yy171:
	yych = *++cur;
	switch (yych) {
		case 'A':
		case 'a': goto yy308;
		case 'C':
		case 'c': goto yy309;
		case 'D':
		case 'd': goto yy310;
		case 'Q':
		case 'q': goto yy311;
		case 'S':
		case 's': goto yy312;
		case 'T':
		case 't': goto yy313;
		case 'W':
		case 'w': goto yy314;
		default: goto yy37;
	}
yy172:
	yych = *++cur;
	if (yych == 'V') goto yy315;
	if (yych == 'v') goto yy315;
	goto yy37;
yy173:
	yych = *++cur;
	if (yych <= 'Q') {
		if (yych == 'L') goto yy316;
		if (yych <= 'P') goto yy37;
		goto yy317;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy37;
			goto yy316;
		} else {
			if (yych == 'q') goto yy317;
			goto yy37;
		}
	}
yy174:
	yych = *++cur;
	if (yych == 'A') goto yy318;
	if (yych == 'a') goto yy318;
	goto yy37;
yy175:
	yych = *++cur;
	if (yych == 'U') goto yy319;
	if (yych == 'u') goto yy319;
	goto yy37;
yy176:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'A') goto yy320;
		if (yych <= 'N') goto yy37;
		goto yy321;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy320;
		} else {
			if (yych == 'o') goto yy321;
			goto yy37;
		}
	}
yy177:
	yych = *++cur;
	if (yych == 'B') goto yy322;
	if (yych == 'b') goto yy322;
	goto yy37;
yy178:
	yych = *++cur;
	if (yych == 'N') goto yy323;
	if (yych == 'n') goto yy323;
	goto yy37;
yy179:
	yych = *++cur;
	if (yych == 'R') goto yy324;
	if (yych == 'r') goto yy324;
	goto yy37;
yy180:
	yych = *++cur;
	if (yych <= 'M') {
		if (yych == 'A') goto yy325;
		if (yych <= 'L') goto yy37;
		goto yy326;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy325;
		} else {
			if (yych == 'm') goto yy326;
			goto yy37;
		}
	}
yy181:
	yych = *++cur;
	if (yych == 'E') goto yy327;
	if (yych == 'e') goto yy327;
	goto yy37;
yy182:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 495 "parser/tokenizer.re"
	{ KW(TO) }
#line 2289 "parser/tokenizer.cpp"
yy183:
	yych = *++cur;
	if (yych == 'P') goto yy328;
	if (yych == 'p') goto yy328;
	goto yy37;
yy184:
	yych = *++cur;
	if (yych == 'F') goto yy329;
	if (yych == 'f') goto yy329;
	goto yy37;
yy185:
	yych = *++cur;
	if (yych == 'E') goto yy330;
	if (yych == 'e') goto yy330;
	goto yy37;
yy186:
	yych = *++cur;
	if (yych == 'L') goto yy331;
	if (yych == 'l') goto yy331;
	goto yy37;
yy187:
	yych = *++cur;
	if (yych == 'L') goto yy332;
	if (yych == 'l') goto yy332;
	goto yy37;
yy188:
	yych = *++cur;
	if (yych == 'I') goto yy333;
	if (yych == 'i') goto yy333;
	goto yy37;
yy189:
	yych = *++cur;
	if (yych <= 'I') {
		if (yych == 'E') goto yy334;
		if (yych <= 'H') goto yy37;
		goto yy335;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy334;
		} else {
			if (yych == 'i') goto yy335;
			goto yy37;
		}
	}
yy190:
	yych = *++cur;
	if (yych == 'I') goto yy336;
	if (yych == 'i') goto yy336;
	goto yy37;
yy191:
	yych = *++cur;
	if (yych == '"') goto yy61;
	goto yy338;
yy192:
	yych = *++cur;
	if (yych == '\'') goto yy61;
	goto yy340;
yy193:
	yych = *++cur;
	if (yych == '$') goto yy341;
	goto yy60;
yy194:
	yych = *++cur;
	if (yych == 'f') goto yy342;
	goto yy68;
yy195:
	yych = *++cur;
	if (yych == 'i') goto yy343;
	if (yych == 's') goto yy344;
	goto yy68;
yy196:
	yych = *++cur;
	if (yych == 'd') goto yy345;
	goto yy68;
yy197:
	yych = *++cur;
	if (yych == 'd') goto yy346;
	goto yy68;
yy198:
	yych = *++cur;
	if (yych == 'n') goto yy347;
	goto yy68;
yy199:
	++cur;
	goto yy79;
yy200:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy61;
			goto yy200;
		} else {
			if (yych == '\v') goto yy200;
			goto yy61;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy200;
			if (yych <= 0x1F) goto yy61;
			goto yy200;
		} else {
			if (yych == ')') goto yy348;
			goto yy61;
		}
	}
yy201:
	++cur;
	cur -= 2;
#line 524 "parser/tokenizer.re"
	{ RET(TK_LPAREN) }
#line 2401 "parser/tokenizer.cpp"
yy202:
	yych = *++cur;
	if (yych == ')') goto yy351;
	goto yy350;
yy203:
	++cur;
	cur -= 2;
#line 523 "parser/tokenizer.re"
	{ RET(TK_LPAREN) }
#line 2411 "parser/tokenizer.cpp"
yy204:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy61;
		if (yych <= '9') goto yy352;
		if (yych <= '@') goto yy61;
		goto yy353;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy61;
			goto yy353;
		} else {
			if (yych <= '`') goto yy61;
			if (yych <= 'z') goto yy353;
			goto yy61;
		}
	}
yy205:
	++cur;
#line 720 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_DEF_OP) }
#line 2433 "parser/tokenizer.cpp"
yy206:
	yych = *++cur;
	if (yych == 'D') goto yy354;
	if (yych == 'd') goto yy354;
	goto yy92;
yy207:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych == '.') goto yy355;
		goto yy92;
	} else {
		if (yych <= 'V') goto yy356;
		if (yych == 'v') goto yy356;
		goto yy92;
	}
yy208:
	yych = *++cur;
	if (yych == 'L') goto yy357;
	if (yych == 'l') goto yy357;
	goto yy92;
yy209:
	yych = *++cur;
	if (yych == '.') goto yy358;
	goto yy92;
yy210:
	yych = *++cur;
	if (yych == '.') goto yy359;
	goto yy92;
yy211:
	yych = *++cur;
	if (yych == '.') goto yy360;
	goto yy92;
yy212:
	yych = *++cur;
	if (yych == '.') goto yy361;
	goto yy92;
yy213:
	yych = *++cur;
	if (yych <= 'P') {
		if (yych == '.') goto yy362;
		goto yy92;
	} else {
		if (yych <= 'Q') goto yy363;
		if (yych == 'q') goto yy363;
		goto yy92;
	}
yy214:
	yych = *++cur;
	if (yych == 'T') goto yy364;
	if (yych == 't') goto yy364;
	goto yy92;
yy215:
	yych = *++cur;
	if (yych == '.') goto yy365;
	goto yy92;
yy216:
	yych = *++cur;
	if (yych == 'U') goto yy366;
	if (yych == 'u') goto yy366;
	goto yy92;
yy217:
	yych = *++cur;
	if (yych == 'R') goto yy367;
	if (yych == 'r') goto yy367;
	goto yy92;
yy218:
	yych = *++cur;
	if (yybm[0+yych] & 16) {
		goto yy218;
	}
	cur = ctxmar;
#line 601 "parser/tokenizer.re"
	{
                if (last_token == yytokentype::TK_NEWLINE) {
                    uint64_t u;
                    if (lex_int(tok, cur, u, yylval.int_suffix.int_kind)) {
                            yylval.n = u;
                            if (enddo_label_stack[enddo_label_stack.size()-1] == u) {
                                while (enddo_label_stack[enddo_label_stack.size()-1] == u) {
                                    enddo_label_stack.pop_back();
                                    enddo_insert_count++;
                                }
                                enddo_newline_process = true;
                            } else {
                                enddo_newline_process = false;
                            }
                            RET(TK_LABEL)
                    } else {
                        token_loc(loc);
                        std::string t = token();
                        throw LFortran::parser_local::TokenizerError("Integer '" + t + "' too large",
                            loc);
                    }
                } else {
                    lex_int_large(al, tok, cur,
                        yylval.int_suffix.int_n,
                        yylval.int_suffix.int_kind);
                    RET(TK_INTEGER)
                }
            }
#line 2534 "parser/tokenizer.cpp"
yy219:
	yych = *++cur;
yy220:
	if (yych <= '@') {
		if (yych == '.') goto yy368;
		goto yy61;
	} else {
		if (yych <= 'Z') goto yy219;
		if (yych <= '`') goto yy61;
		if (yych <= 'z') goto yy219;
		goto yy61;
	}
yy221:
	yych = *++cur;
	if (yych <= ',') {
		if (yych != '+') goto yy220;
	} else {
		if (yych <= '-') goto yy222;
		if (yych <= '/') goto yy220;
		if (yych <= '9') goto yy223;
		goto yy220;
	}
yy222:
	yych = *++cur;
	if (yych <= '/') goto yy61;
	if (yych >= ':') goto yy61;
yy223:
	yyaccept = 7;
	yych = *(mar = ++cur);
	if (yych <= '/') goto yy89;
	if (yych <= '9') goto yy223;
	if (yych == '_') goto yy204;
	goto yy89;
yy224:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') {
				ctxmar = cur;
				goto yy104;
			}
			goto yy21;
		} else {
			if (yych == '\f') goto yy21;
			ctxmar = cur;
			goto yy104;
		}
	} else {
		if (yych <= '-') {
			if (yych == ' ') {
				ctxmar = cur;
				goto yy104;
			}
			goto yy21;
		} else {
			if (yych <= '.') {
				ctxmar = cur;
				goto yy369;
			}
			if (yych <= '/') goto yy21;
			if (yych <= '9') goto yy224;
			goto yy21;
		}
	}
yy225:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '-') {
		if (yych <= '\v') {
			if (yych == '\t') {
				ctxmar = cur;
				goto yy104;
			}
			if (yych <= '\n') goto yy21;
			ctxmar = cur;
			goto yy104;
		} else {
			if (yych <= '\r') {
				if (yych <= '\f') goto yy21;
				ctxmar = cur;
				goto yy104;
			} else {
				if (yych == ' ') {
					ctxmar = cur;
					goto yy104;
				}
				goto yy21;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych <= '.') {
					ctxmar = cur;
					goto yy369;
				}
				goto yy21;
			} else {
				if (yych <= '9') goto yy225;
				if (yych <= '@') goto yy21;
				goto yy225;
			}
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy21;
				goto yy225;
			} else {
				if (yych <= '`') goto yy21;
				if (yych <= 'z') goto yy225;
				goto yy21;
			}
		}
	}
yy226:
	yych = *++cur;
	if (yych == 'T') goto yy370;
	if (yych == 't') goto yy370;
	goto yy37;
yy227:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy116;
	}
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy228;
			if (yych <= 'N') goto yy36;
			goto yy371;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 'o') goto yy371;
			if (yych <= 'z') goto yy36;
		}
	}
yy228:
#line 255 "parser/tokenizer.re"
	{ KW(ALL) }
#line 2679 "parser/tokenizer.cpp"
yy229:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'I') goto yy372;
		if (yych <= 'N') goto yy37;
		goto yy373;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy37;
			goto yy372;
		} else {
			if (yych == 'o') goto yy373;
			goto yy37;
		}
	}
yy230:
	yych = *++cur;
	if (yych == 'N') goto yy374;
	if (yych == 'n') goto yy374;
	goto yy37;
yy231:
	yych = *++cur;
	if (yybm[0+yych] & 32) {
		goto yy231;
	}
	if (yych == '"') goto yy375;
	goto yy61;
yy232:
	yych = *++cur;
	if (yych == '\'') goto yy376;
	if (yych <= '/') goto yy61;
	if (yych <= '1') goto yy232;
	goto yy61;
yy233:
	yych = *++cur;
	if (yych == 'K') goto yy377;
	if (yych == 'k') goto yy377;
	goto yy37;
yy234:
	yych = *++cur;
	if (yych == 'D') goto yy378;
	if (yych == 'd') goto yy378;
	goto yy37;
yy235:
	yych = *++cur;
	if (yych == 'C') goto yy379;
	if (yych == 'c') goto yy379;
	goto yy37;
yy236:
	yych = *++cur;
	if (yych == 'L') goto yy380;
	if (yych == 'l') goto yy380;
	goto yy37;
yy237:
	yych = *++cur;
	if (yych == 'E') goto yy381;
	if (yych == 'e') goto yy381;
	goto yy37;
yy238:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'N') goto yy382;
		if (yych <= 'Q') goto yy37;
		goto yy383;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy37;
			goto yy382;
		} else {
			if (yych == 'r') goto yy383;
			goto yy37;
		}
	}
yy239:
	yych = *++cur;
	if (yych == 'S') goto yy384;
	if (yych == 's') goto yy384;
	goto yy37;
yy240:
	yych = *++cur;
	if (yych == 'S') goto yy385;
	if (yych == 's') goto yy385;
	goto yy37;
yy241:
	yych = *++cur;
	if (yych == 'I') goto yy386;
	if (yych == 'i') goto yy386;
	goto yy37;
yy242:
	yych = *++cur;
	if (yych <= 'P') {
		if (yych == 'M') goto yy387;
		if (yych <= 'O') goto yy37;
		goto yy388;
	} else {
		if (yych <= 'm') {
			if (yych <= 'l') goto yy37;
			goto yy387;
		} else {
			if (yych == 'p') goto yy388;
			goto yy37;
		}
	}
yy243:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych == 'C') goto yy389;
		if (yych <= 'S') goto yy37;
		goto yy390;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy37;
			goto yy389;
		} else {
			if (yych == 't') goto yy390;
			goto yy37;
		}
	}
yy244:
	yych = *++cur;
	if (yych == 'T') goto yy391;
	if (yych == 't') goto yy391;
	goto yy37;
yy245:
	yych = *++cur;
	if (yych == 'L') goto yy392;
	if (yych == 'l') goto yy392;
	goto yy37;
yy246:
	yych = *++cur;
	if (yych == 'A') goto yy393;
	if (yych == 'a') goto yy393;
	goto yy37;
yy247:
	yych = *++cur;
	if (yych == 'L') goto yy394;
	if (yych == 'l') goto yy394;
	goto yy37;
yy248:
	yych = *++cur;
	if (yych <= 'E') {
		if (yych == 'A') goto yy395;
		if (yych <= 'D') goto yy37;
		goto yy396;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy395;
		} else {
			if (yych == 'e') goto yy396;
			goto yy37;
		}
	}
yy249:
	yych = *++cur;
	if (yych == 'E') goto yy397;
	if (yych == 'e') goto yy397;
	goto yy37;
yy250:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy61;
			goto yy250;
		} else {
			if (yych == '\v') goto yy250;
			goto yy61;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy250;
			if (yych <= 0x1F) goto yy61;
			goto yy250;
		} else {
			if (yych <= '/') goto yy61;
			if (yych <= '9') goto yy398;
			goto yy61;
		}
	}
yy251:
	yych = *++cur;
	if (yych == 'B') goto yy400;
	if (yych == 'b') goto yy400;
	goto yy37;
yy252:
	yych = *++cur;
	if (yych == 'H') goto yy401;
	if (yych == 'h') goto yy401;
	goto yy37;
yy253:
	yych = *++cur;
	if (yych == 'M') goto yy402;
	if (yych == 'm') goto yy402;
	goto yy37;
yy254:
	yych = *++cur;
	if (yych == 'E') goto yy403;
	if (yych == 'e') goto yy403;
	goto yy37;
yy255:
	yyaccept = 10;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 8) {
		goto yy116;
	}
	switch (yych) {
		case '\t':
		case '\v':
		case '\r': goto yy405;
		case ' ': goto yy407;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'G':
		case 'H':
		case 'J':
		case 'K':
		case 'L':
		case 'N':
		case 'O':
		case 'Q':
		case 'R':
		case 'U':
		case 'V':
		case 'X':
		case 'Y':
		case 'Z':
		case 'g':
		case 'h':
		case 'j':
		case 'k':
		case 'l':
		case 'n':
		case 'o':
		case 'q':
		case 'r':
		case 'u':
		case 'v':
		case 'x':
		case 'y':
		case 'z': goto yy36;
		case 'A':
		case 'a': goto yy408;
		case 'B':
		case 'b': goto yy409;
		case 'C':
		case 'c': goto yy410;
		case 'D':
		case 'd': goto yy411;
		case 'E':
		case 'e': goto yy412;
		case 'F':
		case 'f': goto yy413;
		case 'I':
		case 'i': goto yy414;
		case 'M':
		case 'm': goto yy415;
		case 'P':
		case 'p': goto yy416;
		case 'S':
		case 's': goto yy417;
		case 'T':
		case 't': goto yy418;
		case 'W':
		case 'w': goto yy419;
		default: goto yy256;
	}
yy256:
#line 303 "parser/tokenizer.re"
	{ KW(END) }
#line 2957 "parser/tokenizer.cpp"
yy257:
	yych = *++cur;
	if (yych == 'R') goto yy420;
	if (yych == 'r') goto yy420;
	goto yy37;
yy258:
	yych = *++cur;
	if (yych == 'M') goto yy421;
	if (yych == 'm') goto yy421;
	goto yy37;
yy259:
	yych = *++cur;
	if (yych == 'I') goto yy423;
	if (yych == 'i') goto yy423;
	goto yy37;
yy260:
	yych = *++cur;
	if (yych <= 'O') {
		if (yych == 'M') goto yy424;
		if (yych <= 'N') goto yy37;
		goto yy425;
	} else {
		if (yych <= 'm') {
			if (yych <= 'l') goto yy37;
			goto yy424;
		} else {
			if (yych == 'o') goto yy425;
			goto yy37;
		}
	}
yy261:
	yych = *++cur;
	if (yych == 'N') goto yy426;
	if (yych == 'n') goto yy426;
	goto yy37;
yy262:
	yych = *++cur;
	if (yych == 'T') goto yy427;
	if (yych == 't') goto yy427;
	goto yy37;
yy263:
	yych = *++cur;
	if (yych == 'E') goto yy428;
	if (yych == 'e') goto yy428;
	goto yy37;
yy264:
	yych = *++cur;
	if (yych == 'E') goto yy429;
	if (yych == 'e') goto yy429;
	goto yy37;
yy265:
	yych = *++cur;
	if (yych == 'A') goto yy430;
	if (yych == 'a') goto yy430;
	goto yy37;
yy266:
	yych = *++cur;
	if (yych == 'S') goto yy431;
	if (yych == 's') goto yy431;
	goto yy37;
yy267:
	yych = *++cur;
	if (yych <= 'M') {
		if (yych == 'A') goto yy432;
		if (yych <= 'L') goto yy37;
		goto yy433;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy432;
		} else {
			if (yych == 'm') goto yy433;
			goto yy37;
		}
	}
yy268:
	yych = *++cur;
	if (yych == 'C') goto yy435;
	if (yych == 'c') goto yy435;
	goto yy37;
yy269:
	yych = *++cur;
	if (yych == 'E') goto yy436;
	if (yych == 'e') goto yy436;
	goto yy37;
yy270:
	yych = *++cur;
	if (yych == 'O') goto yy437;
	if (yych == 'o') goto yy437;
	goto yy37;
yy271:
	yych = *++cur;
	if (yych == 'G') goto yy438;
	if (yych == 'g') goto yy438;
	goto yy37;
yy272:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'N') {
			if (yych == 'L') goto yy439;
			goto yy37;
		} else {
			if (yych <= 'O') goto yy440;
			if (yych <= 'T') goto yy37;
			goto yy441;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'l') goto yy439;
			goto yy37;
		} else {
			if (yych <= 'o') goto yy440;
			if (yych == 'u') goto yy441;
			goto yy37;
		}
	}
yy273:
	yych = *++cur;
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy273;
			goto yy61;
		} else {
			if (yych == '\f') goto yy61;
			goto yy273;
		}
	} else {
		if (yych <= 'N') {
			if (yych == ' ') goto yy273;
			goto yy61;
		} else {
			if (yych <= 'O') goto yy442;
			if (yych == 'o') goto yy442;
			goto yy61;
		}
	}
yy274:
	yych = *++cur;
	if (yych == 'L') goto yy443;
	if (yych == 'l') goto yy443;
	goto yy37;
yy275:
	yych = *++cur;
	if (yych == 'U') goto yy444;
	if (yych == 'u') goto yy444;
	goto yy37;
yy276:
	yych = *++cur;
	if (yych == 'U') goto yy445;
	if (yych == 'u') goto yy445;
	goto yy37;
yy277:
	yych = *++cur;
	if (yych == 'T') goto yy446;
	if (yych == 't') goto yy446;
	goto yy37;
yy278:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'E') goto yy447;
		if (yych <= 'Q') goto yy37;
		goto yy448;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy447;
		} else {
			if (yych == 'r') goto yy448;
			goto yy37;
		}
	}
yy279:
	yych = *++cur;
	if (yych == 'D') goto yy449;
	if (yych == 'd') goto yy449;
	goto yy37;
yy280:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 429 "parser/tokenizer.re"
	{ KW(LEN) }
#line 3142 "parser/tokenizer.cpp"
yy281:
	yych = *++cur;
	if (yych == 'A') goto yy450;
	if (yych == 'a') goto yy450;
	goto yy37;
yy282:
	yych = *++cur;
	if (yych == 'I') goto yy451;
	if (yych == 'i') goto yy451;
	goto yy37;
yy283:
	yych = *++cur;
	if (yych == 'O') goto yy452;
	if (yych == 'o') goto yy452;
	goto yy37;
yy284:
	yych = *++cur;
	if (yych == 'U') goto yy453;
	if (yych == 'u') goto yy453;
	goto yy37;
yy285:
	yych = *++cur;
	if (yych == 'D') goto yy454;
	if (yych == 'd') goto yy454;
	goto yy37;
yy286:
	yych = *++cur;
	if (yych == 'E') goto yy455;
	if (yych == 'e') goto yy455;
	goto yy37;
yy287:
	yych = *++cur;
	if (yych == '_') goto yy457;
	goto yy37;
yy288:
	yych = *++cur;
	if (yych <= '^') {
		if (yych == 'E') goto yy458;
		goto yy37;
	} else {
		if (yych <= '_') goto yy459;
		if (yych == 'e') goto yy458;
		goto yy37;
	}
yy289:
	yych = *++cur;
	if (yych == 'A') goto yy460;
	if (yych == 'a') goto yy460;
	goto yy37;
yy290:
	yych = *++cur;
	if (yych == 'L') goto yy461;
	if (yych == 'l') goto yy461;
	goto yy37;
yy291:
	yych = *++cur;
	if (yybm[0+yych] & 64) {
		goto yy291;
	}
	if (yych == '"') goto yy462;
	goto yy61;
yy292:
	yych = *++cur;
	if (yych == '\'') goto yy463;
	if (yych <= '/') goto yy61;
	if (yych <= '7') goto yy292;
	goto yy61;
yy293:
	yych = *++cur;
	if (yych == 'Y') goto yy464;
	if (yych == 'y') goto yy464;
	goto yy37;
yy294:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'N') goto yy465;
		if (yych <= 'Q') goto yy37;
		goto yy466;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy37;
			goto yy465;
		} else {
			if (yych == 'r') goto yy466;
			goto yy37;
		}
	}
yy295:
	yych = *++cur;
	if (yych == 'I') goto yy467;
	if (yych == 'i') goto yy467;
	goto yy37;
yy296:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 449 "parser/tokenizer.re"
	{ KW(OUT) }
#line 3243 "parser/tokenizer.cpp"
yy297:
	yych = *++cur;
	if (yych == 'A') goto yy468;
	if (yych == 'a') goto yy468;
	goto yy37;
yy298:
	yych = *++cur;
	if (yych == 'S') goto yy469;
	if (yych == 's') goto yy469;
	goto yy37;
yy299:
	yych = *++cur;
	if (yych == 'N') goto yy470;
	if (yych == 'n') goto yy470;
	goto yy37;
yy300:
	yych = *++cur;
	if (yych == 'T') goto yy471;
	if (yych == 't') goto yy471;
	goto yy37;
yy301:
	yych = *++cur;
	if (yych == 'C') goto yy472;
	if (yych == 'c') goto yy472;
	goto yy37;
yy302:
	yych = *++cur;
	if (yych <= 'V') {
		if (yych == 'N') goto yy473;
		if (yych <= 'U') goto yy37;
		goto yy474;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy37;
			goto yy473;
		} else {
			if (yych == 'v') goto yy474;
			goto yy37;
		}
	}
yy303:
	yych = *++cur;
	if (yych <= 'T') {
		if (yych <= 'F') {
			if (yych == 'C') goto yy475;
			goto yy37;
		} else {
			if (yych <= 'G') goto yy476;
			if (yych <= 'S') goto yy37;
			goto yy477;
		}
	} else {
		if (yych <= 'f') {
			if (yych == 'c') goto yy475;
			goto yy37;
		} else {
			if (yych <= 'g') goto yy476;
			if (yych == 't') goto yy477;
			goto yy37;
		}
	}
yy304:
	yych = *++cur;
	if (yych == 'L') goto yy478;
	if (yych == 'l') goto yy478;
	goto yy37;
yy305:
	yych = *++cur;
	if (yych == 'E') goto yy479;
	if (yych == 'e') goto yy479;
	goto yy37;
yy306:
	yych = *++cur;
	if (yych == 'E') goto yy480;
	if (yych == 'e') goto yy480;
	goto yy37;
yy307:
	yych = *++cur;
	if (yych == 'K') goto yy481;
	if (yych == 'k') goto yy481;
	goto yy37;
yy308:
	yych = *++cur;
	if (yych <= 'L') {
		if (yych == 'D') goto yy482;
		if (yych <= 'K') goto yy37;
		goto yy483;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy37;
			goto yy482;
		} else {
			if (yych == 'l') goto yy483;
			goto yy37;
		}
	}
yy309:
	yych = *++cur;
	if (yych == 'U') goto yy484;
	if (yych == 'u') goto yy484;
	goto yy37;
yy310:
	yych = *++cur;
	if (yych == 'U') goto yy485;
	if (yych == 'u') goto yy485;
	goto yy37;
yy311:
	yych = *++cur;
	if (yych == 'U') goto yy486;
	if (yych == 'u') goto yy486;
	goto yy37;
yy312:
	yych = *++cur;
	if (yych == 'U') goto yy487;
	if (yych == 'u') goto yy487;
	goto yy37;
yy313:
	yych = *++cur;
	if (yych == 'U') goto yy488;
	if (yych == 'u') goto yy488;
	goto yy37;
yy314:
	yych = *++cur;
	if (yych == 'I') goto yy489;
	if (yych == 'i') goto yy489;
	goto yy37;
yy315:
	yych = *++cur;
	if (yych == 'E') goto yy490;
	if (yych == 'e') goto yy490;
	goto yy37;
yy316:
	yych = *++cur;
	if (yych == 'E') goto yy491;
	if (yych == 'e') goto yy491;
	goto yy37;
yy317:
	yych = *++cur;
	if (yych == 'U') goto yy492;
	if (yych == 'u') goto yy492;
	goto yy37;
yy318:
	yych = *++cur;
	if (yych == 'R') goto yy493;
	if (yych == 'r') goto yy493;
	goto yy37;
yy319:
	yych = *++cur;
	if (yych == 'R') goto yy494;
	if (yych == 'r') goto yy494;
	goto yy37;
yy320:
	yych = *++cur;
	if (yych == 'T') goto yy495;
	if (yych == 't') goto yy495;
	goto yy37;
yy321:
	yych = *++cur;
	if (yych == 'P') goto yy496;
	if (yych == 'p') goto yy496;
	goto yy37;
yy322:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'M') goto yy497;
		if (yych <= 'Q') goto yy37;
		goto yy498;
	} else {
		if (yych <= 'm') {
			if (yych <= 'l') goto yy37;
			goto yy497;
		} else {
			if (yych == 'r') goto yy498;
			goto yy37;
		}
	}
yy323:
	yych = *++cur;
	if (yych == 'C') goto yy499;
	if (yych == 'c') goto yy499;
	goto yy37;
yy324:
	yych = *++cur;
	if (yych == 'G') goto yy501;
	if (yych == 'g') goto yy501;
	goto yy37;
yy325:
	yych = *++cur;
	if (yych == 'M') goto yy502;
	if (yych == 'm') goto yy502;
	goto yy37;
yy326:
	yych = *++cur;
	if (yych == 'P') goto yy503;
	if (yych == 'p') goto yy503;
	goto yy37;
yy327:
	yych = *++cur;
	if (yych == 'N') goto yy504;
	if (yych == 'n') goto yy504;
	goto yy37;
yy328:
	yych = *++cur;
	if (yych == 'E') goto yy505;
	if (yych == 'e') goto yy505;
	goto yy37;
yy329:
	yych = *++cur;
	if (yych == 'O') goto yy506;
	if (yych == 'o') goto yy506;
	goto yy37;
yy330:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 498 "parser/tokenizer.re"
	{ KW(USE) }
#line 3463 "parser/tokenizer.cpp"
yy331:
	yych = *++cur;
	if (yych == 'U') goto yy507;
	if (yych == 'u') goto yy507;
	goto yy37;
yy332:
	yych = *++cur;
	if (yych == 'A') goto yy508;
	if (yych == 'a') goto yy508;
	goto yy37;
yy333:
	yych = *++cur;
	if (yych == 'T') goto yy509;
	if (yych == 't') goto yy509;
	goto yy37;
yy334:
	yych = *++cur;
	if (yych == 'R') goto yy510;
	if (yych == 'r') goto yy510;
	goto yy37;
yy335:
	yych = *++cur;
	if (yych == 'L') goto yy511;
	if (yych == 'l') goto yy511;
	goto yy37;
yy336:
	yych = *++cur;
	if (yych == 'T') goto yy512;
	if (yych == 't') goto yy512;
	goto yy37;
yy337:
	yych = *++cur;
yy338:
	if (yybm[0+yych] & 128) {
		goto yy337;
	}
	if (yych == '"') goto yy513;
	goto yy61;
yy339:
	yych = *++cur;
yy340:
	if (yych <= '9') {
		if (yych == '\'') goto yy514;
		if (yych <= '/') goto yy61;
		goto yy339;
	} else {
		if (yych <= 'F') {
			if (yych <= '@') goto yy61;
			goto yy339;
		} else {
			if (yych <= '`') goto yy61;
			if (yych <= 'f') goto yy339;
			goto yy61;
		}
	}
yy341:
	yych = *++cur;
	if (yych <= 0x00) goto yy61;
	if (yych == '\n') goto yy515;
	goto yy341;
yy342:
	yych = *++cur;
	if (yych == 'i') goto yy516;
	goto yy68;
yy343:
	yych = *++cur;
	if (yych == 'f') goto yy517;
	goto yy68;
yy344:
	yych = *++cur;
	if (yych == 'e') goto yy518;
	goto yy68;
yy345:
	yych = *++cur;
	if (yych == 'i') goto yy519;
	goto yy68;
yy346:
	yych = *++cur;
	if (yych == 'e') goto yy520;
	goto yy68;
yy347:
	yych = *++cur;
	if (yych == 'e') goto yy521;
	goto yy68;
yy348:
	++cur;
	cur = ctxmar;
#line 526 "parser/tokenizer.re"
	{ RET(TK_LPAREN) }
#line 3553 "parser/tokenizer.cpp"
yy349:
	yych = *++cur;
yy350:
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy61;
			goto yy349;
		} else {
			if (yych == '\v') goto yy349;
			goto yy61;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy349;
			if (yych <= 0x1F) goto yy61;
			goto yy349;
		} else {
			if (yych == ')') goto yy522;
			goto yy61;
		}
	}
yy351:
	++cur;
	cur -= 3;
#line 529 "parser/tokenizer.re"
	{ RET(TK_LPAREN) }
#line 3580 "parser/tokenizer.cpp"
yy352:
	yych = *++cur;
	if (yych <= '/') goto yy89;
	if (yych <= '9') goto yy352;
	goto yy89;
yy353:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy89;
		if (yych <= '9') goto yy353;
		if (yych <= '@') goto yy89;
		goto yy353;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy89;
			goto yy353;
		} else {
			if (yych <= '`') goto yy89;
			if (yych <= 'z') goto yy353;
			goto yy89;
		}
	}
yy354:
	yych = *++cur;
	if (yych == '.') goto yy523;
	goto yy92;
yy355:
	++cur;
#line 556 "parser/tokenizer.re"
	{ WARN_REL(EQ) RET(TK_EQ) }
#line 3611 "parser/tokenizer.cpp"
yy356:
	yych = *++cur;
	if (yych == '.') goto yy524;
	goto yy92;
yy357:
	yych = *++cur;
	if (yych == 'S') goto yy525;
	if (yych == 's') goto yy525;
	goto yy92;
yy358:
	++cur;
#line 571 "parser/tokenizer.re"
	{ WARN_REL(GE) RET(TK_GE) }
#line 3625 "parser/tokenizer.cpp"
yy359:
	++cur;
#line 568 "parser/tokenizer.re"
	{ WARN_REL(GT) RET(TK_GT) }
#line 3630 "parser/tokenizer.cpp"
yy360:
	++cur;
#line 565 "parser/tokenizer.re"
	{ WARN_REL(LE) RET(TK_LE) }
#line 3635 "parser/tokenizer.cpp"
yy361:
	++cur;
#line 562 "parser/tokenizer.re"
	{ WARN_REL(LT) RET(TK_LT) }
#line 3640 "parser/tokenizer.cpp"
yy362:
	++cur;
#line 559 "parser/tokenizer.re"
	{ WARN_REL(NE) RET(TK_NE) }
#line 3645 "parser/tokenizer.cpp"
yy363:
	yych = *++cur;
	if (yych == 'V') goto yy526;
	if (yych == 'v') goto yy526;
	goto yy92;
yy364:
	yych = *++cur;
	if (yych == '.') goto yy527;
	goto yy92;
yy365:
	++cur;
#line 577 "parser/tokenizer.re"
	{ RET(TK_OR) }
#line 3659 "parser/tokenizer.cpp"
yy366:
	yych = *++cur;
	if (yych == 'E') goto yy528;
	if (yych == 'e') goto yy528;
	goto yy92;
yy367:
	yych = *++cur;
	if (yych == '.') goto yy529;
	goto yy92;
yy368:
	++cur;
	cur = ctxmar;
#line 592 "parser/tokenizer.re"
	{
                lex_int_large(al, tok, cur,
                    yylval.int_suffix.int_n,
                    yylval.int_suffix.int_kind);
                RET(TK_INTEGER)
            }
#line 3679 "parser/tokenizer.cpp"
yy369:
	yych = *++cur;
	if (yych == '.') goto yy61;
	goto yy220;
yy370:
	yych = *++cur;
	if (yych == 'R') goto yy530;
	if (yych == 'r') goto yy530;
	goto yy37;
yy371:
	yych = *++cur;
	if (yych == 'C') goto yy531;
	if (yych == 'c') goto yy531;
	goto yy37;
yy372:
	yych = *++cur;
	if (yych == 'G') goto yy532;
	if (yych == 'g') goto yy532;
	goto yy37;
yy373:
	yych = *++cur;
	if (yych == 'C') goto yy533;
	if (yych == 'c') goto yy533;
	goto yy37;
yy374:
	yych = *++cur;
	if (yych == 'C') goto yy534;
	if (yych == 'c') goto yy534;
	goto yy37;
yy375:
	++cur;
#line 636 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_BOZ_CONSTANT) }
#line 3713 "parser/tokenizer.cpp"
yy376:
	++cur;
#line 637 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_BOZ_CONSTANT) }
#line 3718 "parser/tokenizer.cpp"
yy377:
	yych = *++cur;
	if (yych == 'S') goto yy535;
	if (yych == 's') goto yy535;
	goto yy37;
yy378:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 263 "parser/tokenizer.re"
	{ KW(BIND) }
#line 3732 "parser/tokenizer.cpp"
yy379:
	yych = *++cur;
	if (yych == 'K') goto yy536;
	if (yych == 'k') goto yy536;
	goto yy37;
yy380:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 265 "parser/tokenizer.re"
	{ KW(CALL) }
#line 3746 "parser/tokenizer.cpp"
yy381:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 266 "parser/tokenizer.re"
	{ KW(CASE) }
#line 3755 "parser/tokenizer.cpp"
yy382:
	yych = *++cur;
	if (yych == 'G') goto yy537;
	if (yych == 'g') goto yy537;
	goto yy37;
yy383:
	yych = *++cur;
	if (yych == 'A') goto yy538;
	if (yych == 'a') goto yy538;
	goto yy37;
yy384:
	yych = *++cur;
	if (yych == 'S') goto yy539;
	if (yych == 's') goto yy539;
	goto yy37;
yy385:
	yych = *++cur;
	if (yych == 'E') goto yy540;
	if (yych == 'e') goto yy540;
	goto yy37;
yy386:
	yych = *++cur;
	if (yych == 'M') goto yy541;
	if (yych == 'm') goto yy541;
	goto yy37;
yy387:
	yych = *++cur;
	if (yych == 'O') goto yy542;
	if (yych == 'o') goto yy542;
	goto yy37;
yy388:
	yych = *++cur;
	if (yych == 'L') goto yy543;
	if (yych == 'l') goto yy543;
	goto yy37;
yy389:
	yych = *++cur;
	if (yych == 'U') goto yy544;
	if (yych == 'u') goto yy544;
	goto yy37;
yy390:
	yych = *++cur;
	if (yych <= 'I') {
		if (yych == 'A') goto yy545;
		if (yych <= 'H') goto yy37;
		goto yy546;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy545;
		} else {
			if (yych == 'i') goto yy546;
			goto yy37;
		}
	}
yy391:
	yych = *++cur;
	if (yych == 'I') goto yy547;
	if (yych == 'i') goto yy547;
	goto yy37;
yy392:
	yych = *++cur;
	if (yych == 'E') goto yy548;
	if (yych == 'e') goto yy548;
	goto yy37;
yy393:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 281 "parser/tokenizer.re"
	{ KW(DATA) }
#line 3829 "parser/tokenizer.cpp"
yy394:
	yych = *++cur;
	if (yych == 'L') goto yy549;
	if (yych == 'l') goto yy549;
	goto yy37;
yy395:
	yych = *++cur;
	if (yych == 'U') goto yy550;
	if (yych == 'u') goto yy550;
	goto yy37;
yy396:
	yych = *++cur;
	if (yych == 'R') goto yy551;
	if (yych == 'r') goto yy551;
	goto yy37;
yy397:
	yych = *++cur;
	if (yych == 'N') goto yy552;
	if (yych == 'n') goto yy552;
	goto yy37;
yy398:
	yych = *++cur;
	if (yych <= '/') goto yy399;
	if (yych <= '9') goto yy398;
yy399:
	cur = ctxmar;
#line 286 "parser/tokenizer.re"
	{
                // This is a label do statement, we have to match the
                // corresponding continue base "end do".
                uint64_t n = parse_int(cur);
                enddo_label_stack.push_back(n);
                KW(DO);
            }
#line 3864 "parser/tokenizer.cpp"
yy400:
	yych = *++cur;
	if (yych == 'L') goto yy553;
	if (yych == 'l') goto yy553;
	goto yy37;
yy401:
	yych = *++cur;
	if (yych == 'I') goto yy554;
	if (yych == 'i') goto yy554;
	goto yy37;
yy402:
	yych = *++cur;
	if (yych == 'E') goto yy555;
	if (yych == 'e') goto yy555;
	goto yy37;
yy403:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy116;
	}
	if (yych <= 'W') {
		if (yych <= '@') {
			if (yych <= '/') goto yy404;
			if (yych <= '9') goto yy36;
		} else {
			if (yych == 'I') goto yy556;
			if (yych <= 'V') goto yy36;
			goto yy557;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy36;
			if (yych <= '`') goto yy404;
			if (yych <= 'h') goto yy36;
			goto yy556;
		} else {
			if (yych == 'w') goto yy557;
			if (yych <= 'z') goto yy36;
		}
	}
yy404:
#line 299 "parser/tokenizer.re"
	{ KW(ELSE) }
#line 3908 "parser/tokenizer.cpp"
yy405:
	yych = *++cur;
yy406:
	switch (yych) {
		case '\t':
		case '\v':
		case '\r':
		case ' ': goto yy405;
		case 'A':
		case 'a': goto yy558;
		case 'B':
		case 'b': goto yy559;
		case 'C':
		case 'c': goto yy560;
		case 'D':
		case 'd': goto yy561;
		case 'E':
		case 'e': goto yy562;
		case 'F':
		case 'f': goto yy563;
		case 'I':
		case 'i': goto yy564;
		case 'M':
		case 'm': goto yy565;
		case 'P':
		case 'p': goto yy566;
		case 'S':
		case 's': goto yy567;
		case 'T':
		case 't': goto yy568;
		case 'W':
		case 'w': goto yy569;
		default: goto yy61;
	}
yy407:
	yych = *++cur;
	if (yych == 'F') goto yy570;
	if (yych == 'f') goto yy570;
	goto yy406;
yy408:
	yych = *++cur;
	if (yych == 'S') goto yy571;
	if (yych == 's') goto yy571;
	goto yy37;
yy409:
	yych = *++cur;
	if (yych == 'L') goto yy572;
	if (yych == 'l') goto yy572;
	goto yy37;
yy410:
	yych = *++cur;
	if (yych == 'R') goto yy573;
	if (yych == 'r') goto yy573;
	goto yy37;
yy411:
	yych = *++cur;
	if (yych == 'O') goto yy574;
	if (yych == 'o') goto yy574;
	goto yy37;
yy412:
	yych = *++cur;
	if (yych == 'N') goto yy575;
	if (yych == 'n') goto yy575;
	goto yy37;
yy413:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'N') {
			if (yych == 'I') goto yy576;
			goto yy37;
		} else {
			if (yych <= 'O') goto yy577;
			if (yych <= 'T') goto yy37;
			goto yy578;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'i') goto yy576;
			goto yy37;
		} else {
			if (yych <= 'o') goto yy577;
			if (yych == 'u') goto yy578;
			goto yy37;
		}
	}
yy414:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych == 'F') goto yy579;
		if (yych <= 'M') goto yy37;
		goto yy580;
	} else {
		if (yych <= 'f') {
			if (yych <= 'e') goto yy37;
			goto yy579;
		} else {
			if (yych == 'n') goto yy580;
			goto yy37;
		}
	}
yy415:
	yych = *++cur;
	if (yych == 'O') goto yy581;
	if (yych == 'o') goto yy581;
	goto yy37;
yy416:
	yych = *++cur;
	if (yych == 'R') goto yy582;
	if (yych == 'r') goto yy582;
	goto yy37;
yy417:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych == 'E') goto yy583;
		if (yych <= 'T') goto yy37;
		goto yy584;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy583;
		} else {
			if (yych == 'u') goto yy584;
			goto yy37;
		}
	}
yy418:
	yych = *++cur;
	if (yych <= 'Y') {
		if (yych == 'E') goto yy585;
		if (yych <= 'X') goto yy37;
		goto yy586;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy37;
			goto yy585;
		} else {
			if (yych == 'y') goto yy586;
			goto yy37;
		}
	}
yy419:
	yych = *++cur;
	if (yych == 'H') goto yy587;
	if (yych == 'h') goto yy587;
	goto yy37;
yy420:
	yych = *++cur;
	if (yych == 'Y') goto yy588;
	if (yych == 'y') goto yy588;
	goto yy37;
yy421:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy116;
	}
	if (yych <= 'E') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy422;
			if (yych <= 'D') goto yy36;
			goto yy589;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 'e') goto yy589;
			if (yych <= 'z') goto yy36;
		}
	}
yy422:
#line 380 "parser/tokenizer.re"
	{ KW(ENUM) }
#line 4084 "parser/tokenizer.cpp"
yy423:
	yych = *++cur;
	if (yych == 'V') goto yy590;
	if (yych == 'v') goto yy590;
	goto yy37;
yy424:
	yych = *++cur;
	if (yych == 'S') goto yy591;
	if (yych == 's') goto yy591;
	goto yy37;
yy425:
	yych = *++cur;
	if (yych == 'R') goto yy592;
	if (yych == 'r') goto yy592;
	goto yy37;
yy426:
	yych = *++cur;
	if (yych == 'T') goto yy593;
	if (yych == 't') goto yy593;
	goto yy37;
yy427:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 386 "parser/tokenizer.re"
	{ KW(EXIT) }
#line 4113 "parser/tokenizer.cpp"
yy428:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'N') goto yy594;
		if (yych <= 'Q') goto yy37;
		goto yy595;
	} else {
		if (yych <= 'n') {
			if (yych <= 'm') goto yy37;
			goto yy594;
		} else {
			if (yych == 'r') goto yy595;
			goto yy37;
		}
	}
yy429:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 389 "parser/tokenizer.re"
	{ KW(FILE) }
#line 4137 "parser/tokenizer.cpp"
yy430:
	yych = *++cur;
	if (yych == 'L') goto yy596;
	if (yych == 'l') goto yy596;
	goto yy37;
yy431:
	yych = *++cur;
	if (yych == 'H') goto yy597;
	if (yych == 'h') goto yy597;
	goto yy37;
yy432:
	yych = *++cur;
	if (yych == 'L') goto yy598;
	if (yych == 'l') goto yy598;
	goto yy37;
yy433:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy116;
	}
	if (yych <= 'T') {
		if (yych <= '@') {
			if (yych <= '/') goto yy434;
			if (yych <= '9') goto yy36;
		} else {
			if (yych <= 'A') goto yy599;
			if (yych <= 'S') goto yy36;
			goto yy600;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy599;
		} else {
			if (yych == 't') goto yy600;
			if (yych <= 'z') goto yy36;
		}
	}
yy434:
#line 406 "parser/tokenizer.re"
	{ KW(FORM) }
#line 4179 "parser/tokenizer.cpp"
yy435:
	yych = *++cur;
	if (yych == 'T') goto yy601;
	if (yych == 't') goto yy601;
	goto yy37;
yy436:
	yych = *++cur;
	if (yych == 'R') goto yy602;
	if (yych == 'r') goto yy602;
	goto yy37;
yy437:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 411 "parser/tokenizer.re"
	{ KW(GOTO) }
#line 4198 "parser/tokenizer.cpp"
yy438:
	yych = *++cur;
	if (yych == 'E') goto yy603;
	if (yych == 'e') goto yy603;
	goto yy37;
yy439:
	yych = *++cur;
	if (yych == 'I') goto yy604;
	if (yych == 'i') goto yy604;
	goto yy37;
yy440:
	yych = *++cur;
	if (yych == 'R') goto yy605;
	if (yych == 'r') goto yy605;
	goto yy37;
yy441:
	yych = *++cur;
	if (yych == 'R') goto yy606;
	if (yych == 'r') goto yy606;
	goto yy37;
yy442:
	yych = *++cur;
	if (yych == 'U') goto yy607;
	if (yych == 'u') goto yy607;
	goto yy61;
yy443:
	yych = *++cur;
	if (yych == 'U') goto yy608;
	if (yych == 'u') goto yy608;
	goto yy37;
yy444:
	yych = *++cur;
	if (yych == 'T') goto yy609;
	if (yych == 't') goto yy609;
	goto yy37;
yy445:
	yych = *++cur;
	if (yych == 'I') goto yy610;
	if (yych == 'i') goto yy610;
	goto yy37;
yy446:
	yych = *++cur;
	if (yych == 'A') goto yy611;
	if (yych == 'a') goto yy611;
	goto yy37;
yy447:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych <= 'M') {
			if (yych == 'G') goto yy612;
			goto yy37;
		} else {
			if (yych <= 'N') goto yy613;
			if (yych <= 'Q') goto yy37;
			goto yy614;
		}
	} else {
		if (yych <= 'm') {
			if (yych == 'g') goto yy612;
			goto yy37;
		} else {
			if (yych <= 'n') goto yy613;
			if (yych == 'r') goto yy614;
			goto yy37;
		}
	}
yy448:
	yych = *++cur;
	if (yych == 'I') goto yy615;
	if (yych == 'i') goto yy615;
	goto yy37;
yy449:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 428 "parser/tokenizer.re"
	{ KW(KIND) }
#line 4278 "parser/tokenizer.cpp"
yy450:
	yych = *++cur;
	if (yych == 'L') goto yy616;
	if (yych == 'l') goto yy616;
	goto yy37;
yy451:
	yych = *++cur;
	if (yych == 'C') goto yy617;
	if (yych == 'c') goto yy617;
	goto yy37;
yy452:
	yych = *++cur;
	if (yych == 'R') goto yy618;
	if (yych == 'r') goto yy618;
	goto yy37;
yy453:
	yych = *++cur;
	if (yych == 'L') goto yy619;
	if (yych == 'l') goto yy619;
	goto yy37;
yy454:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 435 "parser/tokenizer.re"
	{ KW(MOLD) }
#line 4307 "parser/tokenizer.cpp"
yy455:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy116;
	}
	if (yych <= 'L') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy456;
			if (yych <= 'K') goto yy36;
			goto yy620;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 'l') goto yy620;
			if (yych <= 'z') goto yy36;
		}
	}
yy456:
#line 436 "parser/tokenizer.re"
	{ KW(NAME) }
#line 4333 "parser/tokenizer.cpp"
yy457:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= '\'') {
		if (yych == '"') goto yy64;
		if (yych <= '&') goto yy37;
		goto yy81;
	} else {
		if (yych <= 'I') {
			if (yych <= 'H') goto yy37;
			goto yy621;
		} else {
			if (yych == 'i') goto yy621;
			goto yy37;
		}
	}
yy458:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 443 "parser/tokenizer.re"
	{ KW(NONE) }
#line 4358 "parser/tokenizer.cpp"
yy459:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= 'O') {
		if (yych <= '\'') {
			if (yych == '"') goto yy64;
			if (yych <= '&') goto yy37;
			goto yy81;
		} else {
			if (yych == 'I') goto yy622;
			if (yych <= 'N') goto yy37;
			goto yy623;
		}
	} else {
		if (yych <= 'i') {
			if (yych == 'R') goto yy624;
			if (yych <= 'h') goto yy37;
			goto yy622;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy37;
				goto yy623;
			} else {
				if (yych == 'r') goto yy624;
				goto yy37;
			}
		}
	}
yy460:
	yych = *++cur;
	if (yych == 'S') goto yy625;
	if (yych == 's') goto yy625;
	goto yy37;
yy461:
	yych = *++cur;
	if (yych == 'I') goto yy626;
	if (yych == 'i') goto yy626;
	goto yy37;
yy462:
	++cur;
#line 638 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_BOZ_CONSTANT) }
#line 4401 "parser/tokenizer.cpp"
yy463:
	++cur;
#line 639 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_BOZ_CONSTANT) }
#line 4406 "parser/tokenizer.cpp"
yy464:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 445 "parser/tokenizer.re"
	{ KW(ONLY) }
#line 4415 "parser/tokenizer.cpp"
yy465:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 446 "parser/tokenizer.re"
	{ KW(OPEN) }
#line 4424 "parser/tokenizer.cpp"
yy466:
	yych = *++cur;
	if (yych == 'A') goto yy627;
	if (yych == 'a') goto yy627;
	goto yy37;
yy467:
	yych = *++cur;
	if (yych == 'O') goto yy628;
	if (yych == 'o') goto yy628;
	goto yy37;
yy468:
	yych = *++cur;
	if (yych == 'M') goto yy629;
	if (yych == 'm') goto yy629;
	goto yy37;
yy469:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 451 "parser/tokenizer.re"
	{ KW(PASS) }
#line 4448 "parser/tokenizer.cpp"
yy470:
	yych = *++cur;
	if (yych == 'T') goto yy630;
	if (yych == 't') goto yy630;
	goto yy37;
yy471:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 453 "parser/tokenizer.re"
	{ KW(POST) }
#line 4462 "parser/tokenizer.cpp"
yy472:
	yych = *++cur;
	if (yych == 'I') goto yy631;
	if (yych == 'i') goto yy631;
	goto yy37;
yy473:
	yych = *++cur;
	if (yych == 'T') goto yy632;
	if (yych == 't') goto yy632;
	goto yy37;
yy474:
	yych = *++cur;
	if (yych == 'A') goto yy633;
	if (yych == 'a') goto yy633;
	goto yy37;
yy475:
	yych = *++cur;
	if (yych == 'E') goto yy634;
	if (yych == 'e') goto yy634;
	goto yy37;
yy476:
	yych = *++cur;
	if (yych == 'R') goto yy635;
	if (yych == 'r') goto yy635;
	goto yy37;
yy477:
	yych = *++cur;
	if (yych == 'E') goto yy636;
	if (yych == 'e') goto yy636;
	goto yy37;
yy478:
	yych = *++cur;
	if (yych == 'I') goto yy637;
	if (yych == 'i') goto yy637;
	goto yy37;
yy479:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 461 "parser/tokenizer.re"
	{ KW(PURE) }
#line 4506 "parser/tokenizer.cpp"
yy480:
	yych = *++cur;
	if (yych == 'T') goto yy638;
	if (yych == 't') goto yy638;
	goto yy37;
yy481:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 463 "parser/tokenizer.re"
	{ KW(RANK) }
#line 4520 "parser/tokenizer.cpp"
yy482:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 464 "parser/tokenizer.re"
	{ KW(READ) }
#line 4529 "parser/tokenizer.cpp"
yy483:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 465 "parser/tokenizer.re"
	{KW(REAL) }
#line 4538 "parser/tokenizer.cpp"
yy484:
	yych = *++cur;
	if (yych == 'R') goto yy639;
	if (yych == 'r') goto yy639;
	goto yy37;
yy485:
	yych = *++cur;
	if (yych == 'C') goto yy640;
	if (yych == 'c') goto yy640;
	goto yy37;
yy486:
	yych = *++cur;
	if (yych == 'I') goto yy641;
	if (yych == 'i') goto yy641;
	goto yy37;
yy487:
	yych = *++cur;
	if (yych == 'L') goto yy642;
	if (yych == 'l') goto yy642;
	goto yy37;
yy488:
	yych = *++cur;
	if (yych == 'R') goto yy643;
	if (yych == 'r') goto yy643;
	goto yy37;
yy489:
	yych = *++cur;
	if (yych == 'N') goto yy644;
	if (yych == 'n') goto yy644;
	goto yy37;
yy490:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 473 "parser/tokenizer.re"
	{ KW(SAVE) }
#line 4577 "parser/tokenizer.cpp"
yy491:
	yych = *++cur;
	if (yych == 'C') goto yy645;
	if (yych == 'c') goto yy645;
	goto yy37;
yy492:
	yych = *++cur;
	if (yych == 'E') goto yy646;
	if (yych == 'e') goto yy646;
	goto yy37;
yy493:
	yych = *++cur;
	if (yych == 'E') goto yy647;
	if (yych == 'e') goto yy647;
	goto yy37;
yy494:
	yych = *++cur;
	if (yych == 'C') goto yy648;
	if (yych == 'c') goto yy648;
	goto yy37;
yy495:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 481 "parser/tokenizer.re"
	{ KW(STAT) }
#line 4606 "parser/tokenizer.cpp"
yy496:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 482 "parser/tokenizer.re"
	{ KW(STOP) }
#line 4615 "parser/tokenizer.cpp"
yy497:
	yych = *++cur;
	if (yych == 'O') goto yy649;
	if (yych == 'o') goto yy649;
	goto yy37;
yy498:
	yych = *++cur;
	if (yych == 'O') goto yy650;
	if (yych == 'o') goto yy650;
	goto yy37;
yy499:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy116;
	}
	if (yych <= 'T') {
		if (yych <= 'H') {
			if (yych <= '9') {
				if (yych >= '0') goto yy36;
			} else {
				if (yych <= '@') goto yy500;
				if (yych <= 'A') goto yy651;
				goto yy36;
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'I') goto yy652;
				goto yy36;
			} else {
				if (yych <= 'M') goto yy653;
				if (yych <= 'S') goto yy36;
				goto yy654;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy36;
			} else {
				if (yych <= 'a') goto yy651;
				if (yych <= 'h') goto yy36;
				goto yy652;
			}
		} else {
			if (yych <= 's') {
				if (yych == 'm') goto yy653;
				goto yy36;
			} else {
				if (yych <= 't') goto yy654;
				if (yych <= 'z') goto yy36;
			}
		}
	}
yy500:
#line 485 "parser/tokenizer.re"
	{ KW(SYNC) }
#line 4672 "parser/tokenizer.cpp"
yy501:
	yych = *++cur;
	if (yych == 'E') goto yy655;
	if (yych == 'e') goto yy655;
	goto yy37;
yy502:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy656;
#line 491 "parser/tokenizer.re"
	{ KW(TEAM) }
#line 4686 "parser/tokenizer.cpp"
yy503:
	yych = *++cur;
	if (yych == 'L') goto yy657;
	if (yych == 'l') goto yy657;
	goto yy37;
yy504:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 494 "parser/tokenizer.re"
	{ KW(THEN) }
#line 4700 "parser/tokenizer.cpp"
yy505:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 496 "parser/tokenizer.re"
	{ KW(TYPE) }
#line 4709 "parser/tokenizer.cpp"
yy506:
	yych = *++cur;
	if (yych == 'R') goto yy658;
	if (yych == 'r') goto yy658;
	goto yy37;
yy507:
	yych = *++cur;
	if (yych == 'E') goto yy659;
	if (yych == 'e') goto yy659;
	goto yy37;
yy508:
	yych = *++cur;
	if (yych == 'T') goto yy660;
	if (yych == 't') goto yy660;
	goto yy37;
yy509:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 501 "parser/tokenizer.re"
	{ KW(WAIT) }
#line 4733 "parser/tokenizer.cpp"
yy510:
	yych = *++cur;
	if (yych == 'E') goto yy661;
	if (yych == 'e') goto yy661;
	goto yy37;
yy511:
	yych = *++cur;
	if (yych == 'E') goto yy662;
	if (yych == 'e') goto yy662;
	goto yy37;
yy512:
	yych = *++cur;
	if (yych == 'E') goto yy663;
	if (yych == 'e') goto yy663;
	goto yy37;
yy513:
	++cur;
#line 640 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_BOZ_CONSTANT) }
#line 4753 "parser/tokenizer.cpp"
yy514:
	++cur;
#line 641 "parser/tokenizer.re"
	{ token(yylval.string); RET(TK_BOZ_CONSTANT) }
#line 4758 "parser/tokenizer.cpp"
yy515:
	++cur;
	cur -= 1;
#line 647 "parser/tokenizer.re"
	{
                line_num++; cur_line=cur;
                token(yylval.string);
                token_loc(loc);
                if (last_token == yytokentype::TK_NEWLINE) {
                    return yytokentype::TK_PRAGMA;
                } else {
                    last_token=yytokentype::TK_NEWLINE;
                    return yytokentype::TK_EOLCOMMENT;
                }
            }
#line 4774 "parser/tokenizer.cpp"
yy516:
	yych = *++cur;
	if (yych == 'n') goto yy664;
	goto yy68;
yy517:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych == '\t') goto yy665;
		if (yych <= '\n') goto yy68;
		goto yy665;
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy68;
			goto yy665;
		} else {
			if (yych == ' ') goto yy665;
			goto yy68;
		}
	}
yy518:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych <= 0x08) {
			if (yych <= 0x00) goto yy61;
			goto yy67;
		} else {
			if (yych == '\n') goto yy666;
			goto yy518;
		}
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy67;
			goto yy518;
		} else {
			if (yych == ' ') goto yy518;
			goto yy67;
		}
	}
yy519:
	yych = *++cur;
	if (yych == 'f') goto yy667;
	goto yy68;
yy520:
	yych = *++cur;
	if (yych == 'f') goto yy668;
	goto yy68;
yy521:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych == '\t') goto yy669;
		if (yych <= '\n') goto yy68;
		goto yy669;
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy68;
			goto yy669;
		} else {
			if (yych == ' ') goto yy669;
			goto yy68;
		}
	}
yy522:
	++cur;
	cur = ctxmar;
#line 528 "parser/tokenizer.re"
	{ RET(TK_LPAREN) }
#line 4841 "parser/tokenizer.cpp"
yy523:
	++cur;
#line 576 "parser/tokenizer.re"
	{ RET(TK_AND) }
#line 4846 "parser/tokenizer.cpp"
yy524:
	++cur;
#line 579 "parser/tokenizer.re"
	{ RET(TK_EQV) }
#line 4851 "parser/tokenizer.cpp"
yy525:
	yych = *++cur;
	if (yych == 'E') goto yy670;
	if (yych == 'e') goto yy670;
	goto yy92;
yy526:
	yych = *++cur;
	if (yych == '.') goto yy671;
	goto yy92;
yy527:
	++cur;
#line 575 "parser/tokenizer.re"
	{ RET(TK_NOT) }
#line 4865 "parser/tokenizer.cpp"
yy528:
	yych = *++cur;
	if (yych == '.') goto yy672;
	goto yy92;
yy529:
	++cur;
#line 578 "parser/tokenizer.re"
	{ RET(TK_XOR) }
#line 4874 "parser/tokenizer.cpp"
yy530:
	yych = *++cur;
	if (yych == 'A') goto yy674;
	if (yych == 'a') goto yy674;
	goto yy37;
yy531:
	yych = *++cur;
	if (yych == 'A') goto yy675;
	if (yych == 'a') goto yy675;
	goto yy37;
yy532:
	yych = *++cur;
	if (yych == 'N') goto yy676;
	if (yych == 'n') goto yy676;
	goto yy37;
yy533:
	yych = *++cur;
	if (yych == 'I') goto yy678;
	if (yych == 'i') goto yy678;
	goto yy37;
yy534:
	yych = *++cur;
	if (yych == 'H') goto yy679;
	if (yych == 'h') goto yy679;
	goto yy37;
yy535:
	yych = *++cur;
	if (yych == 'P') goto yy680;
	if (yych == 'p') goto yy680;
	goto yy37;
yy536:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 264 "parser/tokenizer.re"
	{ KW(BLOCK) }
#line 4913 "parser/tokenizer.cpp"
yy537:
	yych = *++cur;
	if (yych == 'E') goto yy681;
	if (yych == 'e') goto yy681;
	goto yy37;
yy538:
	yych = *++cur;
	if (yych == 'C') goto yy683;
	if (yych == 'c') goto yy683;
	goto yy37;
yy539:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 270 "parser/tokenizer.re"
	{ KW(CLASS) }
#line 4932 "parser/tokenizer.cpp"
yy540:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 271 "parser/tokenizer.re"
	{ KW(CLOSE) }
#line 4941 "parser/tokenizer.cpp"
yy541:
	yych = *++cur;
	if (yych == 'E') goto yy684;
	if (yych == 'e') goto yy684;
	goto yy37;
yy542:
	yych = *++cur;
	if (yych == 'N') goto yy685;
	if (yych == 'n') goto yy685;
	goto yy37;
yy543:
	yych = *++cur;
	if (yych == 'E') goto yy686;
	if (yych == 'e') goto yy686;
	goto yy37;
yy544:
	yych = *++cur;
	if (yych == 'R') goto yy687;
	if (yych == 'r') goto yy687;
	goto yy37;
yy545:
	yych = *++cur;
	if (yych == 'I') goto yy688;
	if (yych == 'i') goto yy688;
	goto yy37;
yy546:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych == 'G') goto yy689;
		if (yych <= 'M') goto yy37;
		goto yy690;
	} else {
		if (yych <= 'g') {
			if (yych <= 'f') goto yy37;
			goto yy689;
		} else {
			if (yych == 'n') goto yy690;
			goto yy37;
		}
	}
yy547:
	yych = *++cur;
	if (yych == 'C') goto yy691;
	if (yych == 'c') goto yy691;
	goto yy37;
yy548:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 280 "parser/tokenizer.re"
	{ KW(CYCLE) }
#line 4995 "parser/tokenizer.cpp"
yy549:
	yych = *++cur;
	if (yych == 'O') goto yy692;
	if (yych == 'o') goto yy692;
	goto yy37;
yy550:
	yych = *++cur;
	if (yych == 'L') goto yy693;
	if (yych == 'l') goto yy693;
	goto yy37;
yy551:
	yych = *++cur;
	if (yych == 'R') goto yy694;
	if (yych == 'r') goto yy694;
	goto yy37;
yy552:
	yych = *++cur;
	if (yych == 'S') goto yy695;
	if (yych == 's') goto yy695;
	goto yy37;
yy553:
	yych = *++cur;
	if (yych == 'E') goto yy696;
	if (yych == 'e') goto yy696;
	goto yy37;
yy554:
	yych = *++cur;
	if (yych == 'L') goto yy698;
	if (yych == 'l') goto yy698;
	goto yy37;
yy555:
	yych = *++cur;
	if (yych == 'N') goto yy699;
	if (yych == 'n') goto yy699;
	goto yy37;
yy556:
	yych = *++cur;
	if (yych == 'F') goto yy700;
	if (yych == 'f') goto yy700;
	goto yy37;
yy557:
	yych = *++cur;
	if (yych == 'H') goto yy701;
	if (yych == 'h') goto yy701;
	goto yy37;
yy558:
	yych = *++cur;
	if (yych == 'S') goto yy702;
	if (yych == 's') goto yy702;
	goto yy61;
yy559:
	yych = *++cur;
	if (yych == 'L') goto yy703;
	if (yych == 'l') goto yy703;
	goto yy61;
yy560:
	yych = *++cur;
	if (yych == 'R') goto yy704;
	if (yych == 'r') goto yy704;
	goto yy61;
yy561:
	yych = *++cur;
	if (yych == 'O') goto yy705;
	if (yych == 'o') goto yy705;
	goto yy61;
yy562:
	yych = *++cur;
	if (yych == 'N') goto yy706;
	if (yych == 'n') goto yy706;
	goto yy61;
yy563:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych == 'O') goto yy707;
		if (yych <= 'T') goto yy61;
		goto yy708;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy61;
			goto yy707;
		} else {
			if (yych == 'u') goto yy708;
			goto yy61;
		}
	}
yy564:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych == 'F') goto yy709;
		if (yych <= 'M') goto yy61;
		goto yy710;
	} else {
		if (yych <= 'f') {
			if (yych <= 'e') goto yy61;
			goto yy709;
		} else {
			if (yych == 'n') goto yy710;
			goto yy61;
		}
	}
yy565:
	yych = *++cur;
	if (yych == 'O') goto yy711;
	if (yych == 'o') goto yy711;
	goto yy61;
yy566:
	yych = *++cur;
	if (yych == 'R') goto yy712;
	if (yych == 'r') goto yy712;
	goto yy61;
yy567:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych == 'E') goto yy713;
		if (yych <= 'T') goto yy61;
		goto yy714;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy61;
			goto yy713;
		} else {
			if (yych == 'u') goto yy714;
			goto yy61;
		}
	}
yy568:
	yych = *++cur;
	if (yych <= 'Y') {
		if (yych == 'E') goto yy715;
		if (yych <= 'X') goto yy61;
		goto yy716;
	} else {
		if (yych <= 'e') {
			if (yych <= 'd') goto yy61;
			goto yy715;
		} else {
			if (yych == 'y') goto yy716;
			goto yy61;
		}
	}
yy569:
	yych = *++cur;
	if (yych == 'H') goto yy717;
	if (yych == 'h') goto yy717;
	goto yy61;
yy570:
	yych = *++cur;
	if (yych <= 'U') {
		if (yych <= 'N') {
			if (yych == 'I') goto yy718;
			goto yy61;
		} else {
			if (yych <= 'O') goto yy707;
			if (yych <= 'T') goto yy61;
			goto yy708;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'i') goto yy718;
			goto yy61;
		} else {
			if (yych <= 'o') goto yy707;
			if (yych == 'u') goto yy708;
			goto yy61;
		}
	}
yy571:
	yych = *++cur;
	if (yych == 'S') goto yy719;
	if (yych == 's') goto yy719;
	goto yy37;
yy572:
	yych = *++cur;
	if (yych == 'O') goto yy720;
	if (yych == 'o') goto yy720;
	goto yy37;
yy573:
	yych = *++cur;
	if (yych == 'I') goto yy721;
	if (yych == 'i') goto yy721;
	goto yy37;
yy574:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 365 "parser/tokenizer.re"
	{
                if (enddo_newline_process) {
                    KW(CONTINUE)
                } else {
                    KW(ENDDO)
                }
            }
#line 5191 "parser/tokenizer.cpp"
yy575:
	yych = *++cur;
	if (yych == 'U') goto yy722;
	if (yych == 'u') goto yy722;
	goto yy37;
yy576:
	yych = *++cur;
	if (yych == 'L') goto yy723;
	if (yych == 'l') goto yy723;
	goto yy37;
yy577:
	yych = *++cur;
	if (yych == 'R') goto yy724;
	if (yych == 'r') goto yy724;
	goto yy37;
yy578:
	yych = *++cur;
	if (yych == 'N') goto yy725;
	if (yych == 'n') goto yy725;
	goto yy37;
yy579:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 350 "parser/tokenizer.re"
	{ KW(ENDIF) }
#line 5220 "parser/tokenizer.cpp"
yy580:
	yych = *++cur;
	if (yych == 'T') goto yy726;
	if (yych == 't') goto yy726;
	goto yy37;
yy581:
	yych = *++cur;
	if (yych == 'D') goto yy727;
	if (yych == 'd') goto yy727;
	goto yy37;
yy582:
	yych = *++cur;
	if (yych == 'O') goto yy728;
	if (yych == 'o') goto yy728;
	goto yy37;
yy583:
	yych = *++cur;
	if (yych == 'L') goto yy729;
	if (yych == 'l') goto yy729;
	goto yy37;
yy584:
	yych = *++cur;
	if (yych == 'B') goto yy730;
	if (yych == 'b') goto yy730;
	goto yy37;
yy585:
	yych = *++cur;
	if (yych == 'A') goto yy731;
	if (yych == 'a') goto yy731;
	goto yy37;
yy586:
	yych = *++cur;
	if (yych == 'P') goto yy732;
	if (yych == 'p') goto yy732;
	goto yy37;
yy587:
	yych = *++cur;
	if (yych == 'E') goto yy733;
	if (yych == 'e') goto yy733;
	goto yy37;
yy588:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 379 "parser/tokenizer.re"
	{ KW(ENTRY) }
#line 5269 "parser/tokenizer.cpp"
yy589:
	yych = *++cur;
	if (yych == 'R') goto yy734;
	if (yych == 'r') goto yy734;
	goto yy37;
yy590:
	yych = *++cur;
	if (yych == 'A') goto yy735;
	if (yych == 'a') goto yy735;
	goto yy37;
yy591:
	yych = *++cur;
	if (yych == 'G') goto yy736;
	if (yych == 'g') goto yy736;
	goto yy37;
yy592:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 384 "parser/tokenizer.re"
	{ KW(ERROR) }
#line 5293 "parser/tokenizer.cpp"
yy593:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 385 "parser/tokenizer.re"
	{ KW(EVENT) }
#line 5302 "parser/tokenizer.cpp"
yy594:
	yych = *++cur;
	if (yych == 'D') goto yy737;
	if (yych == 'd') goto yy737;
	goto yy37;
yy595:
	yych = *++cur;
	if (yych == 'N') goto yy738;
	if (yych == 'n') goto yy738;
	goto yy37;
yy596:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 390 "parser/tokenizer.re"
	{ KW(FINAL) }
#line 5321 "parser/tokenizer.cpp"
yy597:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 391 "parser/tokenizer.re"
	{ KW(FLUSH) }
#line 5330 "parser/tokenizer.cpp"
yy598:
	yych = *++cur;
	if (yych == 'L') goto yy739;
	if (yych == 'l') goto yy739;
	goto yy37;
yy599:
	yych = *++cur;
	if (yych == 'T') goto yy740;
	if (yych == 't') goto yy740;
	goto yy37;
yy600:
	yych = *++cur;
	if (yych == 'E') goto yy742;
	if (yych == 'e') goto yy742;
	goto yy37;
yy601:
	yych = *++cur;
	if (yych == 'I') goto yy743;
	if (yych == 'i') goto yy743;
	goto yy37;
yy602:
	yych = *++cur;
	if (yych == 'I') goto yy744;
	if (yych == 'i') goto yy744;
	goto yy37;
yy603:
	yych = *++cur;
	if (yych == 'S') goto yy745;
	if (yych == 's') goto yy745;
	goto yy37;
yy604:
	yych = *++cur;
	if (yych == 'C') goto yy746;
	if (yych == 'c') goto yy746;
	goto yy37;
yy605:
	yych = *++cur;
	if (yych == 'T') goto yy747;
	if (yych == 't') goto yy747;
	goto yy37;
yy606:
	yych = *++cur;
	if (yych == 'E') goto yy748;
	if (yych == 'e') goto yy748;
	goto yy37;
yy607:
	yych = *++cur;
	if (yych == 'T') goto yy749;
	if (yych == 't') goto yy749;
	goto yy61;
yy608:
	yych = *++cur;
	if (yych == 'D') goto yy750;
	if (yych == 'd') goto yy750;
	goto yy37;
yy609:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 419 "parser/tokenizer.re"
	{ KW(INOUT) }
#line 5394 "parser/tokenizer.cpp"
yy610:
	yych = *++cur;
	if (yych == 'R') goto yy751;
	if (yych == 'r') goto yy751;
	goto yy37;
yy611:
	yych = *++cur;
	if (yych == 'N') goto yy752;
	if (yych == 'n') goto yy752;
	goto yy37;
yy612:
	yych = *++cur;
	if (yych == 'E') goto yy753;
	if (yych == 'e') goto yy753;
	goto yy37;
yy613:
	yych = *++cur;
	if (yych == 'T') goto yy754;
	if (yych == 't') goto yy754;
	goto yy37;
yy614:
	yych = *++cur;
	if (yych == 'F') goto yy755;
	if (yych == 'f') goto yy755;
	goto yy37;
yy615:
	yych = *++cur;
	if (yych == 'N') goto yy756;
	if (yych == 'n') goto yy756;
	goto yy37;
yy616:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy757;
#line 430 "parser/tokenizer.re"
	{ KW(LOCAL) }
#line 5433 "parser/tokenizer.cpp"
yy617:
	yych = *++cur;
	if (yych == 'A') goto yy758;
	if (yych == 'a') goto yy758;
	goto yy37;
yy618:
	yych = *++cur;
	if (yych == 'Y') goto yy759;
	if (yych == 'y') goto yy759;
	goto yy37;
yy619:
	yych = *++cur;
	if (yych == 'E') goto yy760;
	if (yych == 'e') goto yy760;
	goto yy37;
yy620:
	yych = *++cur;
	if (yych == 'I') goto yy761;
	if (yych == 'i') goto yy761;
	goto yy37;
yy621:
	yych = *++cur;
	if (yych == 'N') goto yy762;
	if (yych == 'n') goto yy762;
	goto yy37;
yy622:
	yych = *++cur;
	if (yych == 'N') goto yy763;
	if (yych == 'n') goto yy763;
	goto yy37;
yy623:
	yych = *++cur;
	if (yych == 'V') goto yy764;
	if (yych == 'v') goto yy764;
	goto yy37;
yy624:
	yych = *++cur;
	if (yych == 'E') goto yy765;
	if (yych == 'e') goto yy765;
	goto yy37;
yy625:
	yych = *++cur;
	if (yych == 'S') goto yy766;
	if (yych == 's') goto yy766;
	goto yy37;
yy626:
	yych = *++cur;
	if (yych == 'F') goto yy767;
	if (yych == 'f') goto yy767;
	goto yy37;
yy627:
	yych = *++cur;
	if (yych == 'T') goto yy768;
	if (yych == 't') goto yy768;
	goto yy37;
yy628:
	yych = *++cur;
	if (yych == 'N') goto yy769;
	if (yych == 'n') goto yy769;
	goto yy37;
yy629:
	yych = *++cur;
	if (yych == 'E') goto yy770;
	if (yych == 'e') goto yy770;
	goto yy37;
yy630:
	yych = *++cur;
	if (yych == 'E') goto yy771;
	if (yych == 'e') goto yy771;
	goto yy37;
yy631:
	yych = *++cur;
	if (yych == 'S') goto yy772;
	if (yych == 's') goto yy772;
	goto yy37;
yy632:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 455 "parser/tokenizer.re"
	{ KW(PRINT) }
#line 5517 "parser/tokenizer.cpp"
yy633:
	yych = *++cur;
	if (yych == 'T') goto yy773;
	if (yych == 't') goto yy773;
	goto yy37;
yy634:
	yych = *++cur;
	if (yych == 'D') goto yy774;
	if (yych == 'd') goto yy774;
	goto yy37;
yy635:
	yych = *++cur;
	if (yych == 'A') goto yy775;
	if (yych == 'a') goto yy775;
	goto yy37;
yy636:
	yych = *++cur;
	if (yych == 'C') goto yy776;
	if (yych == 'c') goto yy776;
	goto yy37;
yy637:
	yych = *++cur;
	if (yych == 'C') goto yy777;
	if (yych == 'c') goto yy777;
	goto yy37;
yy638:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 462 "parser/tokenizer.re"
	{ KW(QUIET) }
#line 5551 "parser/tokenizer.cpp"
yy639:
	yych = *++cur;
	if (yych == 'S') goto yy778;
	if (yych == 's') goto yy778;
	goto yy37;
yy640:
	yych = *++cur;
	if (yych == 'E') goto yy779;
	if (yych == 'e') goto yy779;
	goto yy37;
yy641:
	yych = *++cur;
	if (yych == 'R') goto yy780;
	if (yych == 'r') goto yy780;
	goto yy37;
yy642:
	yych = *++cur;
	if (yych == 'T') goto yy781;
	if (yych == 't') goto yy781;
	goto yy37;
yy643:
	yych = *++cur;
	if (yych == 'N') goto yy782;
	if (yych == 'n') goto yy782;
	goto yy37;
yy644:
	yych = *++cur;
	if (yych == 'D') goto yy783;
	if (yych == 'd') goto yy783;
	goto yy37;
yy645:
	yych = *++cur;
	if (yych == 'T') goto yy784;
	if (yych == 't') goto yy784;
	goto yy37;
yy646:
	yych = *++cur;
	if (yych == 'N') goto yy786;
	if (yych == 'n') goto yy786;
	goto yy37;
yy647:
	yych = *++cur;
	if (yych == 'D') goto yy787;
	if (yych == 'd') goto yy787;
	goto yy37;
yy648:
	yych = *++cur;
	if (yych == 'E') goto yy788;
	if (yych == 'e') goto yy788;
	goto yy37;
yy649:
	yych = *++cur;
	if (yych == 'D') goto yy789;
	if (yych == 'd') goto yy789;
	goto yy37;
yy650:
	yych = *++cur;
	if (yych == 'U') goto yy790;
	if (yych == 'u') goto yy790;
	goto yy37;
yy651:
	yych = *++cur;
	if (yych == 'L') goto yy791;
	if (yych == 'l') goto yy791;
	goto yy37;
yy652:
	yych = *++cur;
	if (yych == 'M') goto yy792;
	if (yych == 'm') goto yy792;
	goto yy37;
yy653:
	yych = *++cur;
	if (yych == 'E') goto yy793;
	if (yych == 'e') goto yy793;
	goto yy37;
yy654:
	yych = *++cur;
	if (yych == 'E') goto yy794;
	if (yych == 'e') goto yy794;
	goto yy37;
yy655:
	yych = *++cur;
	if (yych == 'T') goto yy795;
	if (yych == 't') goto yy795;
	goto yy37;
yy656:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= '\'') {
		if (yych == '"') goto yy64;
		if (yych <= '&') goto yy37;
		goto yy81;
	} else {
		if (yych <= 'N') {
			if (yych <= 'M') goto yy37;
			goto yy796;
		} else {
			if (yych == 'n') goto yy796;
			goto yy37;
		}
	}
yy657:
	yych = *++cur;
	if (yych == 'A') goto yy797;
	if (yych == 'a') goto yy797;
	goto yy37;
yy658:
	yych = *++cur;
	if (yych == 'M') goto yy798;
	if (yych == 'm') goto yy798;
	goto yy37;
yy659:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 499 "parser/tokenizer.re"
	{ KW(VALUE) }
#line 5671 "parser/tokenizer.cpp"
yy660:
	yych = *++cur;
	if (yych == 'I') goto yy799;
	if (yych == 'i') goto yy799;
	goto yy37;
yy661:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 502 "parser/tokenizer.re"
	{ KW(WHERE) }
#line 5685 "parser/tokenizer.cpp"
yy662:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 503 "parser/tokenizer.re"
	{ KW(WHILE) }
#line 5694 "parser/tokenizer.cpp"
yy663:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 504 "parser/tokenizer.re"
	{ KW(WRITE) }
#line 5703 "parser/tokenizer.cpp"
yy664:
	yych = *++cur;
	if (yych == 'e') goto yy800;
	goto yy68;
yy665:
	yych = *++cur;
	if (yych <= 0x00) goto yy61;
	if (yych == '\n') goto yy801;
	goto yy665;
yy666:
	++cur;
#line 687 "parser/tokenizer.re"
	{
                Location loc; token_loc(loc);
                diagnostics.tokenizer_warning_label(
                    "#else ignored", {loc},
                    "help: use the '--cpp' command line option to preprocess it");
                line_num++; cur_line=cur; continue;
            }
#line 5723 "parser/tokenizer.cpp"
yy667:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych <= 0x08) {
			if (yych <= 0x00) goto yy61;
			goto yy67;
		} else {
			if (yych == '\n') goto yy802;
			goto yy667;
		}
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy67;
			goto yy667;
		} else {
			if (yych == ' ') goto yy667;
			goto yy67;
		}
	}
yy668:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych == '\t') goto yy803;
		if (yych <= '\n') goto yy68;
		goto yy803;
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy68;
			goto yy803;
		} else {
			if (yych == ' ') goto yy803;
			goto yy68;
		}
	}
yy669:
	yych = *++cur;
	if (yych <= 0x00) goto yy61;
	if (yych == '\n') goto yy804;
	goto yy669;
yy670:
	yych = *++cur;
	if (yych == '.') goto yy805;
	goto yy92;
yy671:
	++cur;
#line 580 "parser/tokenizer.re"
	{ RET(TK_NEQV) }
#line 5771 "parser/tokenizer.cpp"
yy672:
	yyaccept = 11;
	yych = *(mar = ++cur);
	if (yych == '_') goto yy807;
yy673:
#line 584 "parser/tokenizer.re"
	{ RET(TK_TRUE) }
#line 5779 "parser/tokenizer.cpp"
yy674:
	yych = *++cur;
	if (yych == 'C') goto yy808;
	if (yych == 'c') goto yy808;
	goto yy37;
yy675:
	yych = *++cur;
	if (yych == 'T') goto yy809;
	if (yych == 't') goto yy809;
	goto yy37;
yy676:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy116;
	}
	if (yych <= 'M') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy677;
			if (yych <= 'L') goto yy36;
			goto yy810;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 'm') goto yy810;
			if (yych <= 'z') goto yy36;
		}
	}
yy677:
#line 258 "parser/tokenizer.re"
	{ KW(ASSIGN) }
#line 5815 "parser/tokenizer.cpp"
yy678:
	yych = *++cur;
	if (yych == 'A') goto yy811;
	if (yych == 'a') goto yy811;
	goto yy37;
yy679:
	yych = *++cur;
	if (yych == 'R') goto yy812;
	if (yych == 'r') goto yy812;
	goto yy37;
yy680:
	yych = *++cur;
	if (yych == 'A') goto yy813;
	if (yych == 'a') goto yy813;
	goto yy37;
yy681:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy116;
	}
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy682;
			if (yych <= 'S') goto yy36;
			goto yy814;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 't') goto yy814;
			if (yych <= 'z') goto yy36;
		}
	}
yy682:
#line 267 "parser/tokenizer.re"
	{ KW(CHANGE) }
#line 5856 "parser/tokenizer.cpp"
yy683:
	yych = *++cur;
	if (yych == 'T') goto yy815;
	if (yych == 't') goto yy815;
	goto yy37;
yy684:
	yych = *++cur;
	if (yych == 'N') goto yy816;
	if (yych == 'n') goto yy816;
	goto yy37;
yy685:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 273 "parser/tokenizer.re"
	{ KW(COMMON) }
#line 5875 "parser/tokenizer.cpp"
yy686:
	yych = *++cur;
	if (yych == 'X') goto yy817;
	if (yych == 'x') goto yy817;
	goto yy37;
yy687:
	yych = *++cur;
	if (yych == 'R') goto yy818;
	if (yych == 'r') goto yy818;
	goto yy37;
yy688:
	yych = *++cur;
	if (yych == 'N') goto yy819;
	if (yych == 'n') goto yy819;
	goto yy37;
yy689:
	yych = *++cur;
	if (yych == 'U') goto yy820;
	if (yych == 'u') goto yy820;
	goto yy37;
yy690:
	yych = *++cur;
	if (yych == 'U') goto yy821;
	if (yych == 'u') goto yy821;
	goto yy37;
yy691:
	yych = *++cur;
	if (yych == 'A') goto yy822;
	if (yych == 'a') goto yy822;
	goto yy37;
yy692:
	yych = *++cur;
	if (yych == 'C') goto yy823;
	if (yych == 'c') goto yy823;
	goto yy37;
yy693:
	yych = *++cur;
	if (yych == 'T') goto yy824;
	if (yych == 't') goto yy824;
	goto yy37;
yy694:
	yych = *++cur;
	if (yych == 'E') goto yy825;
	if (yych == 'e') goto yy825;
	goto yy37;
yy695:
	yych = *++cur;
	if (yych == 'I') goto yy826;
	if (yych == 'i') goto yy826;
	goto yy37;
yy696:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy116;
	}
	if (yych <= 'P') {
		if (yych <= '@') {
			if (yych <= '/') goto yy697;
			if (yych <= '9') goto yy36;
		} else {
			if (yych == 'C') goto yy827;
			if (yych <= 'O') goto yy36;
			goto yy828;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy36;
			if (yych <= '`') goto yy697;
			if (yych <= 'b') goto yy36;
			goto yy827;
		} else {
			if (yych == 'p') goto yy828;
			if (yych <= 'z') goto yy36;
		}
	}
yy697:
#line 295 "parser/tokenizer.re"
	{ KW(DOUBLE) }
#line 5954 "parser/tokenizer.cpp"
yy698:
	yych = *++cur;
	if (yych == 'E') goto yy829;
	if (yych == 'e') goto yy829;
	goto yy37;
yy699:
	yych = *++cur;
	if (yych == 'T') goto yy830;
	if (yych == 't') goto yy830;
	goto yy37;
yy700:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 300 "parser/tokenizer.re"
	{ KW(ELSEIF) }
#line 5973 "parser/tokenizer.cpp"
yy701:
	yych = *++cur;
	if (yych == 'E') goto yy831;
	if (yych == 'e') goto yy831;
	goto yy37;
yy702:
	yych = *++cur;
	if (yych == 'S') goto yy832;
	if (yych == 's') goto yy832;
	goto yy61;
yy703:
	yych = *++cur;
	if (yych == 'O') goto yy833;
	if (yych == 'o') goto yy833;
	goto yy61;
yy704:
	yych = *++cur;
	if (yych == 'I') goto yy834;
	if (yych == 'i') goto yy834;
	goto yy61;
yy705:
	++cur;
#line 358 "parser/tokenizer.re"
	{
                if (enddo_newline_process) {
                    KW(CONTINUE)
                } else {
                    KW(END_DO)
                }
            }
#line 6004 "parser/tokenizer.cpp"
yy706:
	yych = *++cur;
	if (yych == 'U') goto yy835;
	if (yych == 'u') goto yy835;
	goto yy61;
yy707:
	yych = *++cur;
	if (yych == 'R') goto yy836;
	if (yych == 'r') goto yy836;
	goto yy61;
yy708:
	yych = *++cur;
	if (yych == 'N') goto yy837;
	if (yych == 'n') goto yy837;
	goto yy61;
yy709:
	++cur;
#line 349 "parser/tokenizer.re"
	{ KW(END_IF) }
#line 6024 "parser/tokenizer.cpp"
yy710:
	yych = *++cur;
	if (yych == 'T') goto yy838;
	if (yych == 't') goto yy838;
	goto yy61;
yy711:
	yych = *++cur;
	if (yych == 'D') goto yy839;
	if (yych == 'd') goto yy839;
	goto yy61;
yy712:
	yych = *++cur;
	if (yych == 'O') goto yy840;
	if (yych == 'o') goto yy840;
	goto yy61;
yy713:
	yych = *++cur;
	if (yych == 'L') goto yy841;
	if (yych == 'l') goto yy841;
	goto yy61;
yy714:
	yych = *++cur;
	if (yych == 'B') goto yy842;
	if (yych == 'b') goto yy842;
	goto yy61;
yy715:
	yych = *++cur;
	if (yych == 'A') goto yy843;
	if (yych == 'a') goto yy843;
	goto yy61;
yy716:
	yych = *++cur;
	if (yych == 'P') goto yy844;
	if (yych == 'p') goto yy844;
	goto yy61;
yy717:
	yych = *++cur;
	if (yych == 'E') goto yy845;
	if (yych == 'e') goto yy845;
	goto yy61;
yy718:
	yych = *++cur;
	if (yych == 'L') goto yy846;
	if (yych == 'l') goto yy846;
	goto yy61;
yy719:
	yych = *++cur;
	if (yych == 'O') goto yy847;
	if (yych == 'o') goto yy847;
	goto yy37;
yy720:
	yych = *++cur;
	if (yych == 'C') goto yy848;
	if (yych == 'c') goto yy848;
	goto yy37;
yy721:
	yych = *++cur;
	if (yych == 'T') goto yy849;
	if (yych == 't') goto yy849;
	goto yy37;
yy722:
	yych = *++cur;
	if (yych == 'M') goto yy850;
	if (yych == 'm') goto yy850;
	goto yy37;
yy723:
	yych = *++cur;
	if (yych == 'E') goto yy851;
	if (yych == 'e') goto yy851;
	goto yy37;
yy724:
	yych = *++cur;
	if (yych == 'A') goto yy852;
	if (yych == 'a') goto yy852;
	goto yy37;
yy725:
	yych = *++cur;
	if (yych == 'C') goto yy853;
	if (yych == 'c') goto yy853;
	goto yy37;
yy726:
	yych = *++cur;
	if (yych == 'E') goto yy854;
	if (yych == 'e') goto yy854;
	goto yy37;
yy727:
	yych = *++cur;
	if (yych == 'U') goto yy855;
	if (yych == 'u') goto yy855;
	goto yy37;
yy728:
	yych = *++cur;
	if (yych <= 'G') {
		if (yych == 'C') goto yy856;
		if (yych <= 'F') goto yy37;
		goto yy857;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy37;
			goto yy856;
		} else {
			if (yych == 'g') goto yy857;
			goto yy37;
		}
	}
yy729:
	yych = *++cur;
	if (yych == 'E') goto yy858;
	if (yych == 'e') goto yy858;
	goto yy37;
yy730:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'M') goto yy859;
		if (yych <= 'Q') goto yy37;
		goto yy860;
	} else {
		if (yych <= 'm') {
			if (yych <= 'l') goto yy37;
			goto yy859;
		} else {
			if (yych == 'r') goto yy860;
			goto yy37;
		}
	}
yy731:
	yych = *++cur;
	if (yych == 'M') goto yy861;
	if (yych == 'm') goto yy861;
	goto yy37;
yy732:
	yych = *++cur;
	if (yych == 'E') goto yy862;
	if (yych == 'e') goto yy862;
	goto yy37;
yy733:
	yych = *++cur;
	if (yych == 'R') goto yy863;
	if (yych == 'r') goto yy863;
	goto yy37;
yy734:
	yych = *++cur;
	if (yych == 'A') goto yy864;
	if (yych == 'a') goto yy864;
	goto yy37;
yy735:
	yych = *++cur;
	if (yych == 'L') goto yy865;
	if (yych == 'l') goto yy865;
	goto yy37;
yy736:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 383 "parser/tokenizer.re"
	{ KW(ERRMSG) }
#line 6183 "parser/tokenizer.cpp"
yy737:
	yych = *++cur;
	if (yych == 'S') goto yy866;
	if (yych == 's') goto yy866;
	goto yy37;
yy738:
	yych = *++cur;
	if (yych == 'A') goto yy867;
	if (yych == 'a') goto yy867;
	goto yy37;
yy739:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 392 "parser/tokenizer.re"
	{ KW(FORALL) }
#line 6202 "parser/tokenizer.cpp"
yy740:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy116;
	}
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy741;
			if (yych <= 'S') goto yy36;
			goto yy868;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 't') goto yy868;
			if (yych <= 'z') goto yy36;
		}
	}
yy741:
#line 393 "parser/tokenizer.re"
	{
                if (last_token == yytokentype::TK_LABEL) {
                    unsigned char *start;
                    lex_format(cur, loc, start);
                    yylval.string.p = (char*) start;
                    yylval.string.n = cur-start-1;
                    RET(TK_FORMAT)
                } else {
                    token(yylval.string);
                    RET(TK_NAME)
                }
            }
#line 6239 "parser/tokenizer.cpp"
yy742:
	yych = *++cur;
	if (yych == 'A') goto yy869;
	if (yych == 'a') goto yy869;
	goto yy37;
yy743:
	yych = *++cur;
	if (yych == 'O') goto yy870;
	if (yych == 'o') goto yy870;
	goto yy37;
yy744:
	yych = *++cur;
	if (yych == 'C') goto yy871;
	if (yych == 'c') goto yy871;
	goto yy37;
yy745:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 413 "parser/tokenizer.re"
	{ KW(IMAGES) }
#line 6263 "parser/tokenizer.cpp"
yy746:
	yych = *++cur;
	if (yych == 'I') goto yy872;
	if (yych == 'i') goto yy872;
	goto yy37;
yy747:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 415 "parser/tokenizer.re"
	{ KW(IMPORT) }
#line 6277 "parser/tokenizer.cpp"
yy748:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 416 "parser/tokenizer.re"
	{ KW(IMPURE) }
#line 6286 "parser/tokenizer.cpp"
yy749:
	++cur;
#line 420 "parser/tokenizer.re"
	{ KW(IN_OUT) }
#line 6291 "parser/tokenizer.cpp"
yy750:
	yych = *++cur;
	if (yych == 'E') goto yy873;
	if (yych == 'e') goto yy873;
	goto yy37;
yy751:
	yych = *++cur;
	if (yych == 'E') goto yy874;
	if (yych == 'e') goto yy874;
	goto yy37;
yy752:
	yych = *++cur;
	if (yych == 'T') goto yy875;
	if (yych == 't') goto yy875;
	goto yy37;
yy753:
	yych = *++cur;
	if (yych == 'R') goto yy876;
	if (yych == 'r') goto yy876;
	goto yy37;
yy754:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 424 "parser/tokenizer.re"
	{ KW(INTENT) }
#line 6320 "parser/tokenizer.cpp"
yy755:
	yych = *++cur;
	if (yych == 'A') goto yy877;
	if (yych == 'a') goto yy877;
	goto yy37;
yy756:
	yych = *++cur;
	if (yych == 'S') goto yy878;
	if (yych == 's') goto yy878;
	goto yy37;
yy757:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych <= '\'') {
		if (yych == '"') goto yy64;
		if (yych <= '&') goto yy37;
		goto yy81;
	} else {
		if (yych <= 'I') {
			if (yych <= 'H') goto yy37;
			goto yy879;
		} else {
			if (yych == 'i') goto yy879;
			goto yy37;
		}
	}
yy758:
	yych = *++cur;
	if (yych == 'L') goto yy880;
	if (yych == 'l') goto yy880;
	goto yy37;
yy759:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 433 "parser/tokenizer.re"
	{ KW(MEMORY) }
#line 6360 "parser/tokenizer.cpp"
yy760:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 434 "parser/tokenizer.re"
	{ KW(MODULE) }
#line 6369 "parser/tokenizer.cpp"
yy761:
	yych = *++cur;
	if (yych == 'S') goto yy881;
	if (yych == 's') goto yy881;
	goto yy37;
yy762:
	yych = *++cur;
	if (yych == 'D') goto yy882;
	if (yych == 'd') goto yy882;
	goto yy37;
yy763:
	yych = *++cur;
	if (yych == 'T') goto yy883;
	if (yych == 't') goto yy883;
	goto yy37;
yy764:
	yych = *++cur;
	if (yych == 'E') goto yy884;
	if (yych == 'e') goto yy884;
	goto yy37;
yy765:
	yych = *++cur;
	if (yych == 'C') goto yy885;
	if (yych == 'c') goto yy885;
	goto yy37;
yy766:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 439 "parser/tokenizer.re"
	{ KW(NOPASS) }
#line 6403 "parser/tokenizer.cpp"
yy767:
	yych = *++cur;
	if (yych == 'Y') goto yy886;
	if (yych == 'y') goto yy886;
	goto yy37;
yy768:
	yych = *++cur;
	if (yych == 'O') goto yy887;
	if (yych == 'o') goto yy887;
	goto yy37;
yy769:
	yych = *++cur;
	if (yych == 'A') goto yy888;
	if (yych == 'a') goto yy888;
	goto yy37;
yy770:
	yych = *++cur;
	if (yych == 'T') goto yy889;
	if (yych == 't') goto yy889;
	goto yy37;
yy771:
	yych = *++cur;
	if (yych == 'R') goto yy890;
	if (yych == 'r') goto yy890;
	goto yy37;
yy772:
	yych = *++cur;
	if (yych == 'I') goto yy891;
	if (yych == 'i') goto yy891;
	goto yy37;
yy773:
	yych = *++cur;
	if (yych == 'E') goto yy892;
	if (yych == 'e') goto yy892;
	goto yy37;
yy774:
	yych = *++cur;
	if (yych == 'U') goto yy893;
	if (yych == 'u') goto yy893;
	goto yy37;
yy775:
	yych = *++cur;
	if (yych == 'M') goto yy894;
	if (yych == 'm') goto yy894;
	goto yy37;
yy776:
	yych = *++cur;
	if (yych == 'T') goto yy895;
	if (yych == 't') goto yy895;
	goto yy37;
yy777:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 460 "parser/tokenizer.re"
	{ KW(PUBLIC) }
#line 6462 "parser/tokenizer.cpp"
yy778:
	yych = *++cur;
	if (yych == 'I') goto yy896;
	if (yych == 'i') goto yy896;
	goto yy37;
yy779:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 467 "parser/tokenizer.re"
	{ KW(REDUCE) }
#line 6476 "parser/tokenizer.cpp"
yy780:
	yych = *++cur;
	if (yych == 'E') goto yy897;
	if (yych == 'e') goto yy897;
	goto yy37;
yy781:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 470 "parser/tokenizer.re"
	{ KW(RESULT) }
#line 6490 "parser/tokenizer.cpp"
yy782:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 471 "parser/tokenizer.re"
	{ KW(RETURN) }
#line 6499 "parser/tokenizer.cpp"
yy783:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 472 "parser/tokenizer.re"
	{ KW(REWIND) }
#line 6508 "parser/tokenizer.cpp"
yy784:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy116;
	}
	if (yych <= 'T') {
		if (yych <= 'B') {
			if (yych <= '/') goto yy785;
			if (yych <= '9') goto yy36;
			if (yych >= 'A') goto yy36;
		} else {
			if (yych <= 'Q') {
				if (yych <= 'C') goto yy899;
				goto yy36;
			} else {
				if (yych <= 'R') goto yy900;
				if (yych <= 'S') goto yy36;
				goto yy901;
			}
		}
	} else {
		if (yych <= 'q') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy36;
			} else {
				if (yych == 'c') goto yy899;
				goto yy36;
			}
		} else {
			if (yych <= 's') {
				if (yych <= 'r') goto yy900;
				goto yy36;
			} else {
				if (yych <= 't') goto yy901;
				if (yych <= 'z') goto yy36;
			}
		}
	}
yy785:
#line 474 "parser/tokenizer.re"
	{ KW(SELECT) }
#line 6550 "parser/tokenizer.cpp"
yy786:
	yych = *++cur;
	if (yych == 'C') goto yy902;
	if (yych == 'c') goto yy902;
	goto yy37;
yy787:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 479 "parser/tokenizer.re"
	{ KW(SHARED) }
#line 6564 "parser/tokenizer.cpp"
yy788:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 480 "parser/tokenizer.re"
	{ KW(SOURCE) }
#line 6573 "parser/tokenizer.cpp"
yy789:
	yych = *++cur;
	if (yych == 'U') goto yy903;
	if (yych == 'u') goto yy903;
	goto yy37;
yy790:
	yych = *++cur;
	if (yych == 'T') goto yy904;
	if (yych == 't') goto yy904;
	goto yy37;
yy791:
	yych = *++cur;
	if (yych == 'L') goto yy905;
	if (yych == 'l') goto yy905;
	goto yy37;
yy792:
	yych = *++cur;
	if (yych == 'A') goto yy906;
	if (yych == 'a') goto yy906;
	goto yy37;
yy793:
	yych = *++cur;
	if (yych == 'M') goto yy907;
	if (yych == 'm') goto yy907;
	goto yy37;
yy794:
	yych = *++cur;
	if (yych == 'A') goto yy908;
	if (yych == 'a') goto yy908;
	goto yy37;
yy795:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 490 "parser/tokenizer.re"
	{ KW(TARGET) }
#line 6612 "parser/tokenizer.cpp"
yy796:
	yych = *++cur;
	if (yych == 'U') goto yy909;
	if (yych == 'u') goto yy909;
	goto yy37;
yy797:
	yych = *++cur;
	if (yych == 'T') goto yy910;
	if (yych == 't') goto yy910;
	goto yy37;
yy798:
	yych = *++cur;
	if (yych == 'A') goto yy911;
	if (yych == 'a') goto yy911;
	goto yy37;
yy799:
	yych = *++cur;
	if (yych == 'L') goto yy912;
	if (yych == 'l') goto yy912;
	goto yy37;
yy800:
	yych = *++cur;
	if (yych <= '\v') {
		if (yych == '\t') goto yy913;
		if (yych <= '\n') goto yy68;
		goto yy913;
	} else {
		if (yych <= '\r') {
			if (yych <= '\f') goto yy68;
			goto yy913;
		} else {
			if (yych == ' ') goto yy913;
			goto yy68;
		}
	}
yy801:
	++cur;
#line 680 "parser/tokenizer.re"
	{
                Location loc; token_loc(loc);
                diagnostics.tokenizer_warning_label(
                    "#elif ignored", {loc},
                    "help: use the '--cpp' command line option to preprocess it");
                line_num++; cur_line=cur; continue;
            }
#line 6658 "parser/tokenizer.cpp"
yy802:
	++cur;
#line 694 "parser/tokenizer.re"
	{
                Location loc; token_loc(loc);
                diagnostics.tokenizer_warning_label(
                    "#endif ignored", {loc},
                    "help: use the '--cpp' command line option to preprocess it");
                line_num++; cur_line=cur; continue;
            }
#line 6669 "parser/tokenizer.cpp"
yy803:
	yych = *++cur;
	if (yych <= 0x00) goto yy61;
	if (yych == '\n') goto yy914;
	goto yy803;
yy804:
	++cur;
#line 672 "parser/tokenizer.re"
	{ line_num++; cur_line=cur; continue; }
#line 6679 "parser/tokenizer.cpp"
yy805:
	yyaccept = 12;
	yych = *(mar = ++cur);
	if (yych == '_') goto yy915;
yy806:
#line 585 "parser/tokenizer.re"
	{ RET(TK_FALSE) }
#line 6687 "parser/tokenizer.cpp"
yy807:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy61;
		if (yych <= '9') goto yy916;
		if (yych <= '@') goto yy61;
		goto yy917;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy61;
			goto yy917;
		} else {
			if (yych <= '`') goto yy61;
			if (yych <= 'z') goto yy917;
			goto yy61;
		}
	}
yy808:
	yych = *++cur;
	if (yych == 'T') goto yy918;
	if (yych == 't') goto yy918;
	goto yy37;
yy809:
	yych = *++cur;
	if (yych <= 'E') {
		if (yych == 'A') goto yy919;
		if (yych <= 'D') goto yy37;
		goto yy920;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy37;
			goto yy919;
		} else {
			if (yych == 'e') goto yy920;
			goto yy37;
		}
	}
yy810:
	yych = *++cur;
	if (yych == 'E') goto yy921;
	if (yych == 'e') goto yy921;
	goto yy37;
yy811:
	yych = *++cur;
	if (yych == 'T') goto yy922;
	if (yych == 't') goto yy922;
	goto yy37;
yy812:
	yych = *++cur;
	if (yych == 'O') goto yy923;
	if (yych == 'o') goto yy923;
	goto yy37;
yy813:
	yych = *++cur;
	if (yych == 'C') goto yy924;
	if (yych == 'c') goto yy924;
	goto yy37;
yy814:
	yych = *++cur;
	if (yych == 'E') goto yy925;
	if (yych == 'e') goto yy925;
	goto yy37;
yy815:
	yych = *++cur;
	if (yych == 'E') goto yy926;
	if (yych == 'e') goto yy926;
	goto yy37;
yy816:
	yych = *++cur;
	if (yych == 'S') goto yy927;
	if (yych == 's') goto yy927;
	goto yy37;
yy817:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 274 "parser/tokenizer.re"
	{ KW(COMPLEX) }
#line 6768 "parser/tokenizer.cpp"
yy818:
	yych = *++cur;
	if (yych == 'E') goto yy928;
	if (yych == 'e') goto yy928;
	goto yy37;
yy819:
	yych = *++cur;
	if (yych == 'S') goto yy929;
	if (yych == 's') goto yy929;
	goto yy37;
yy820:
	yych = *++cur;
	if (yych == 'O') goto yy930;
	if (yych == 'o') goto yy930;
	goto yy37;
yy821:
	yych = *++cur;
	if (yych == 'E') goto yy931;
	if (yych == 'e') goto yy931;
	goto yy37;
yy822:
	yych = *++cur;
	if (yych == 'L') goto yy932;
	if (yych == 'l') goto yy932;
	goto yy37;
yy823:
	yych = *++cur;
	if (yych == 'A') goto yy933;
	if (yych == 'a') goto yy933;
	goto yy37;
yy824:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 283 "parser/tokenizer.re"
	{ KW(DEFAULT) }
#line 6807 "parser/tokenizer.cpp"
yy825:
	yych = *++cur;
	if (yych == 'D') goto yy934;
	if (yych == 'd') goto yy934;
	goto yy37;
yy826:
	yych = *++cur;
	if (yych == 'O') goto yy935;
	if (yych == 'o') goto yy935;
	goto yy37;
yy827:
	yych = *++cur;
	if (yych == 'O') goto yy936;
	if (yych == 'o') goto yy936;
	goto yy37;
yy828:
	yych = *++cur;
	if (yych == 'R') goto yy937;
	if (yych == 'r') goto yy937;
	goto yy37;
yy829:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 294 "parser/tokenizer.re"
	{ KW(DOWHILE) }
#line 6836 "parser/tokenizer.cpp"
yy830:
	yych = *++cur;
	if (yych == 'A') goto yy938;
	if (yych == 'a') goto yy938;
	goto yy37;
yy831:
	yych = *++cur;
	if (yych == 'R') goto yy939;
	if (yych == 'r') goto yy939;
	goto yy37;
yy832:
	yych = *++cur;
	if (yych == 'O') goto yy940;
	if (yych == 'o') goto yy940;
	goto yy61;
yy833:
	yych = *++cur;
	if (yych == 'C') goto yy941;
	if (yych == 'c') goto yy941;
	goto yy61;
yy834:
	yych = *++cur;
	if (yych == 'T') goto yy942;
	if (yych == 't') goto yy942;
	goto yy61;
yy835:
	yych = *++cur;
	if (yych == 'M') goto yy943;
	if (yych == 'm') goto yy943;
	goto yy61;
yy836:
	yych = *++cur;
	if (yych == 'A') goto yy944;
	if (yych == 'a') goto yy944;
	goto yy61;
yy837:
	yych = *++cur;
	if (yych == 'C') goto yy945;
	if (yych == 'c') goto yy945;
	goto yy61;
yy838:
	yych = *++cur;
	if (yych == 'E') goto yy946;
	if (yych == 'e') goto yy946;
	goto yy61;
yy839:
	yych = *++cur;
	if (yych == 'U') goto yy947;
	if (yych == 'u') goto yy947;
	goto yy61;
yy840:
	yych = *++cur;
	if (yych <= 'G') {
		if (yych == 'C') goto yy948;
		if (yych <= 'F') goto yy61;
		goto yy949;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy61;
			goto yy948;
		} else {
			if (yych == 'g') goto yy949;
			goto yy61;
		}
	}
yy841:
	yych = *++cur;
	if (yych == 'E') goto yy950;
	if (yych == 'e') goto yy950;
	goto yy61;
yy842:
	yych = *++cur;
	if (yych <= 'R') {
		if (yych == 'M') goto yy951;
		if (yych <= 'Q') goto yy61;
		goto yy952;
	} else {
		if (yych <= 'm') {
			if (yych <= 'l') goto yy61;
			goto yy951;
		} else {
			if (yych == 'r') goto yy952;
			goto yy61;
		}
	}
yy843:
	yych = *++cur;
	if (yych == 'M') goto yy953;
	if (yych == 'm') goto yy953;
	goto yy61;
yy844:
	yych = *++cur;
	if (yych == 'E') goto yy954;
	if (yych == 'e') goto yy954;
	goto yy61;
yy845:
	yych = *++cur;
	if (yych == 'R') goto yy955;
	if (yych == 'r') goto yy955;
	goto yy61;
yy846:
	yych = *++cur;
	if (yych == 'E') goto yy956;
	if (yych == 'e') goto yy956;
	goto yy61;
yy847:
	yych = *++cur;
	if (yych == 'C') goto yy957;
	if (yych == 'c') goto yy957;
	goto yy37;
yy848:
	yych = *++cur;
	if (yych == 'K') goto yy958;
	if (yych == 'k') goto yy958;
	goto yy37;
yy849:
	yych = *++cur;
	if (yych == 'I') goto yy960;
	if (yych == 'i') goto yy960;
	goto yy37;
yy850:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 332 "parser/tokenizer.re"
	{ KW(ENDENUM) }
#line 6965 "parser/tokenizer.cpp"
yy851:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 377 "parser/tokenizer.re"
	{ KW(ENDFILE) }
#line 6974 "parser/tokenizer.cpp"
yy852:
	yych = *++cur;
	if (yych == 'L') goto yy961;
	if (yych == 'l') goto yy961;
	goto yy37;
yy853:
	yych = *++cur;
	if (yych == 'T') goto yy962;
	if (yych == 't') goto yy962;
	goto yy37;
yy854:
	yych = *++cur;
	if (yych == 'R') goto yy963;
	if (yych == 'r') goto yy963;
	goto yy37;
yy855:
	yych = *++cur;
	if (yych == 'L') goto yy964;
	if (yych == 'l') goto yy964;
	goto yy37;
yy856:
	yych = *++cur;
	if (yych == 'E') goto yy965;
	if (yych == 'e') goto yy965;
	goto yy37;
yy857:
	yych = *++cur;
	if (yych == 'R') goto yy966;
	if (yych == 'r') goto yy966;
	goto yy37;
yy858:
	yych = *++cur;
	if (yych == 'C') goto yy967;
	if (yych == 'c') goto yy967;
	goto yy37;
yy859:
	yych = *++cur;
	if (yych == 'O') goto yy968;
	if (yych == 'o') goto yy968;
	goto yy37;
yy860:
	yych = *++cur;
	if (yych == 'O') goto yy969;
	if (yych == 'o') goto yy969;
	goto yy37;
yy861:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 344 "parser/tokenizer.re"
	{ KW(ENDTEAM) }
#line 7028 "parser/tokenizer.cpp"
yy862:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 356 "parser/tokenizer.re"
	{ KW(ENDTYPE) }
#line 7037 "parser/tokenizer.cpp"
yy863:
	yych = *++cur;
	if (yych == 'E') goto yy970;
	if (yych == 'e') goto yy970;
	goto yy37;
yy864:
	yych = *++cur;
	if (yych == 'T') goto yy971;
	if (yych == 't') goto yy971;
	goto yy37;
yy865:
	yych = *++cur;
	if (yych == 'E') goto yy972;
	if (yych == 'e') goto yy972;
	goto yy37;
yy866:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 387 "parser/tokenizer.re"
	{ KW(EXTENDS) }
#line 7061 "parser/tokenizer.cpp"
yy867:
	yych = *++cur;
	if (yych == 'L') goto yy973;
	if (yych == 'l') goto yy973;
	goto yy37;
yy868:
	yych = *++cur;
	if (yych == 'E') goto yy974;
	if (yych == 'e') goto yy974;
	goto yy37;
yy869:
	yych = *++cur;
	if (yych == 'M') goto yy975;
	if (yych == 'm') goto yy975;
	goto yy37;
yy870:
	yych = *++cur;
	if (yych == 'N') goto yy976;
	if (yych == 'n') goto yy976;
	goto yy37;
yy871:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 409 "parser/tokenizer.re"
	{ KW(GENERIC) }
#line 7090 "parser/tokenizer.cpp"
yy872:
	yych = *++cur;
	if (yych == 'T') goto yy977;
	if (yych == 't') goto yy977;
	goto yy37;
yy873:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 418 "parser/tokenizer.re"
	{ KW(INCLUDE) }
#line 7104 "parser/tokenizer.cpp"
yy874:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 421 "parser/tokenizer.re"
	{ KW(INQUIRE) }
#line 7113 "parser/tokenizer.cpp"
yy875:
	yych = *++cur;
	if (yych == 'I') goto yy978;
	if (yych == 'i') goto yy978;
	goto yy37;
yy876:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 423 "parser/tokenizer.re"
	{ KW(INTEGER) }
#line 7127 "parser/tokenizer.cpp"
yy877:
	yych = *++cur;
	if (yych == 'C') goto yy979;
	if (yych == 'c') goto yy979;
	goto yy37;
yy878:
	yych = *++cur;
	if (yych == 'I') goto yy980;
	if (yych == 'i') goto yy980;
	goto yy37;
yy879:
	yych = *++cur;
	if (yych == 'N') goto yy981;
	if (yych == 'n') goto yy981;
	goto yy37;
yy880:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 432 "parser/tokenizer.re"
	{ KW(LOGICAL) }
#line 7151 "parser/tokenizer.cpp"
yy881:
	yych = *++cur;
	if (yych == 'T') goto yy982;
	if (yych == 't') goto yy982;
	goto yy37;
yy882:
	yych = *++cur;
	if (yych == 'E') goto yy983;
	if (yych == 'e') goto yy983;
	goto yy37;
yy883:
	yych = *++cur;
	if (yych == 'R') goto yy984;
	if (yych == 'r') goto yy984;
	goto yy37;
yy884:
	yych = *++cur;
	if (yych == 'R') goto yy985;
	if (yych == 'r') goto yy985;
	goto yy37;
yy885:
	yych = *++cur;
	if (yych == 'U') goto yy986;
	if (yych == 'u') goto yy986;
	goto yy37;
yy886:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 444 "parser/tokenizer.re"
	{ KW(NULLIFY) }
#line 7185 "parser/tokenizer.cpp"
yy887:
	yych = *++cur;
	if (yych == 'R') goto yy987;
	if (yych == 'r') goto yy987;
	goto yy37;
yy888:
	yych = *++cur;
	if (yych == 'L') goto yy988;
	if (yych == 'l') goto yy988;
	goto yy37;
yy889:
	yych = *++cur;
	if (yych == 'E') goto yy989;
	if (yych == 'e') goto yy989;
	goto yy37;
yy890:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 452 "parser/tokenizer.re"
	{ KW(POINTER) }
#line 7209 "parser/tokenizer.cpp"
yy891:
	yych = *++cur;
	if (yych == 'O') goto yy990;
	if (yych == 'o') goto yy990;
	goto yy37;
yy892:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 456 "parser/tokenizer.re"
	{ KW(PRIVATE) }
#line 7223 "parser/tokenizer.cpp"
yy893:
	yych = *++cur;
	if (yych == 'R') goto yy991;
	if (yych == 'r') goto yy991;
	goto yy37;
yy894:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 458 "parser/tokenizer.re"
	{ KW(PROGRAM) }
#line 7237 "parser/tokenizer.cpp"
yy895:
	yych = *++cur;
	if (yych == 'E') goto yy992;
	if (yych == 'e') goto yy992;
	goto yy37;
yy896:
	yych = *++cur;
	if (yych == 'V') goto yy993;
	if (yych == 'v') goto yy993;
	goto yy37;
yy897:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy116;
	}
	if (yych <= 'M') {
		if (yych <= '9') {
			if (yych >= '0') goto yy36;
		} else {
			if (yych <= '@') goto yy898;
			if (yych <= 'L') goto yy36;
			goto yy994;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy36;
			if (yych >= 'a') goto yy36;
		} else {
			if (yych <= 'm') goto yy994;
			if (yych <= 'z') goto yy36;
		}
	}
yy898:
#line 469 "parser/tokenizer.re"
	{ KW(REQUIRE) }
#line 7273 "parser/tokenizer.cpp"
yy899:
	yych = *++cur;
	if (yych == 'A') goto yy995;
	if (yych == 'a') goto yy995;
	goto yy37;
yy900:
	yych = *++cur;
	if (yych == 'A') goto yy996;
	if (yych == 'a') goto yy996;
	goto yy37;
yy901:
	yych = *++cur;
	if (yych == 'Y') goto yy997;
	if (yych == 'y') goto yy997;
	goto yy37;
yy902:
	yych = *++cur;
	if (yych == 'E') goto yy998;
	if (yych == 'e') goto yy998;
	goto yy37;
yy903:
	yych = *++cur;
	if (yych == 'L') goto yy999;
	if (yych == 'l') goto yy999;
	goto yy37;
yy904:
	yych = *++cur;
	if (yych == 'I') goto yy1000;
	if (yych == 'i') goto yy1000;
	goto yy37;
yy905:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 486 "parser/tokenizer.re"
	{ KW(SYNC_ALL) }
#line 7312 "parser/tokenizer.cpp"
yy906:
	yych = *++cur;
	if (yych == 'G') goto yy1001;
	if (yych == 'g') goto yy1001;
	goto yy37;
yy907:
	yych = *++cur;
	if (yych == 'O') goto yy1002;
	if (yych == 'o') goto yy1002;
	goto yy37;
yy908:
	yych = *++cur;
	if (yych == 'M') goto yy1003;
	if (yych == 'm') goto yy1003;
	goto yy37;
yy909:
	yych = *++cur;
	if (yych == 'M') goto yy1004;
	if (yych == 'm') goto yy1004;
	goto yy37;
yy910:
	yych = *++cur;
	if (yych == 'E') goto yy1005;
	if (yych == 'e') goto yy1005;
	goto yy37;
yy911:
	yych = *++cur;
	if (yych == 'T') goto yy1006;
	if (yych == 't') goto yy1006;
	goto yy37;
yy912:
	yych = *++cur;
	if (yych == 'E') goto yy1007;
	if (yych == 'e') goto yy1007;
	goto yy37;
yy913:
	yych = *++cur;
	if (yych <= 0x00) goto yy61;
	if (yych == '\n') goto yy1008;
	goto yy913;
yy914:
	++cur;
#line 673 "parser/tokenizer.re"
	{
                Location loc; token_loc(loc);
                diagnostics.tokenizer_warning_label(
                    "#ifdef ignored", {loc},
                    "help: use the '--cpp' command line option to preprocess it");
                line_num++; cur_line=cur; continue;
            }
#line 7363 "parser/tokenizer.cpp"
yy915:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy61;
		if (yych <= '9') goto yy1009;
		if (yych <= '@') goto yy61;
		goto yy1010;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy61;
			goto yy1010;
		} else {
			if (yych <= '`') goto yy61;
			if (yych <= 'z') goto yy1010;
			goto yy61;
		}
	}
yy916:
	yych = *++cur;
	if (yych <= '/') goto yy673;
	if (yych <= '9') goto yy916;
	goto yy673;
yy917:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy673;
		if (yych <= '9') goto yy917;
		if (yych <= '@') goto yy673;
		goto yy917;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy673;
			goto yy917;
		} else {
			if (yych <= '`') goto yy673;
			if (yych <= 'z') goto yy917;
			goto yy673;
		}
	}
yy918:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 254 "parser/tokenizer.re"
	{ KW(ABSTRACT) }
#line 7411 "parser/tokenizer.cpp"
yy919:
	yych = *++cur;
	if (yych == 'B') goto yy1011;
	if (yych == 'b') goto yy1011;
	goto yy37;
yy920:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 257 "parser/tokenizer.re"
	{ KW(ALLOCATE) }
#line 7425 "parser/tokenizer.cpp"
yy921:
	yych = *++cur;
	if (yych == 'N') goto yy1012;
	if (yych == 'n') goto yy1012;
	goto yy37;
yy922:
	yych = *++cur;
	if (yych == 'E') goto yy1013;
	if (yych == 'e') goto yy1013;
	goto yy37;
yy923:
	yych = *++cur;
	if (yych == 'N') goto yy1014;
	if (yych == 'n') goto yy1014;
	goto yy37;
yy924:
	yych = *++cur;
	if (yych == 'E') goto yy1015;
	if (yych == 'e') goto yy1015;
	goto yy37;
yy925:
	yych = *++cur;
	if (yych == 'A') goto yy1016;
	if (yych == 'a') goto yy1016;
	goto yy37;
yy926:
	yych = *++cur;
	if (yych == 'R') goto yy1017;
	if (yych == 'r') goto yy1017;
	goto yy37;
yy927:
	yych = *++cur;
	if (yych == 'I') goto yy1018;
	if (yych == 'i') goto yy1018;
	goto yy37;
yy928:
	yych = *++cur;
	if (yych == 'N') goto yy1019;
	if (yych == 'n') goto yy1019;
	goto yy37;
yy929:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 276 "parser/tokenizer.re"
	{ KW(CONTAINS) }
#line 7474 "parser/tokenizer.cpp"
yy930:
	yych = *++cur;
	if (yych == 'U') goto yy1020;
	if (yych == 'u') goto yy1020;
	goto yy37;
yy931:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 278 "parser/tokenizer.re"
	{ KW(CONTINUE) }
#line 7488 "parser/tokenizer.cpp"
yy932:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 279 "parser/tokenizer.re"
	{ KW(CRITICAL) }
#line 7497 "parser/tokenizer.cpp"
yy933:
	yych = *++cur;
	if (yych == 'T') goto yy1021;
	if (yych == 't') goto yy1021;
	goto yy37;
yy934:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 284 "parser/tokenizer.re"
	{ KW(DEFERRED) }
#line 7511 "parser/tokenizer.cpp"
yy935:
	yych = *++cur;
	if (yych == 'N') goto yy1022;
	if (yych == 'n') goto yy1022;
	goto yy37;
yy936:
	yych = *++cur;
	if (yych == 'M') goto yy1023;
	if (yych == 'm') goto yy1023;
	goto yy37;
yy937:
	yych = *++cur;
	if (yych == 'E') goto yy1024;
	if (yych == 'e') goto yy1024;
	goto yy37;
yy938:
	yych = *++cur;
	if (yych == 'L') goto yy1025;
	if (yych == 'l') goto yy1025;
	goto yy37;
yy939:
	yych = *++cur;
	if (yych == 'E') goto yy1026;
	if (yych == 'e') goto yy1026;
	goto yy37;
yy940:
	yych = *++cur;
	if (yych == 'C') goto yy1027;
	if (yych == 'c') goto yy1027;
	goto yy61;
yy941:
	yych = *++cur;
	if (yych == 'K') goto yy1028;
	if (yych == 'k') goto yy1028;
	goto yy61;
yy942:
	yych = *++cur;
	if (yych == 'I') goto yy1030;
	if (yych == 'i') goto yy1030;
	goto yy61;
yy943:
	++cur;
#line 331 "parser/tokenizer.re"
	{ KW(END_ENUM) }
#line 7556 "parser/tokenizer.cpp"
yy944:
	yych = *++cur;
	if (yych == 'L') goto yy1031;
	if (yych == 'l') goto yy1031;
	goto yy61;
yy945:
	yych = *++cur;
	if (yych == 'T') goto yy1032;
	if (yych == 't') goto yy1032;
	goto yy61;
yy946:
	yych = *++cur;
	if (yych == 'R') goto yy1033;
	if (yych == 'r') goto yy1033;
	goto yy61;
yy947:
	yych = *++cur;
	if (yych == 'L') goto yy1034;
	if (yych == 'l') goto yy1034;
	goto yy61;
yy948:
	yych = *++cur;
	if (yych == 'E') goto yy1035;
	if (yych == 'e') goto yy1035;
	goto yy61;
yy949:
	yych = *++cur;
	if (yych == 'R') goto yy1036;
	if (yych == 'r') goto yy1036;
	goto yy61;
yy950:
	yych = *++cur;
	if (yych == 'C') goto yy1037;
	if (yych == 'c') goto yy1037;
	goto yy61;
yy951:
	yych = *++cur;
	if (yych == 'O') goto yy1038;
	if (yych == 'o') goto yy1038;
	goto yy61;
yy952:
	yych = *++cur;
	if (yych == 'O') goto yy1039;
	if (yych == 'o') goto yy1039;
	goto yy61;
yy953:
	++cur;
#line 343 "parser/tokenizer.re"
	{ KW(END_TEAM) }
#line 7606 "parser/tokenizer.cpp"
yy954:
	++cur;
#line 355 "parser/tokenizer.re"
	{ KW(END_TYPE) }
#line 7611 "parser/tokenizer.cpp"
yy955:
	yych = *++cur;
	if (yych == 'E') goto yy1040;
	if (yych == 'e') goto yy1040;
	goto yy61;
yy956:
	++cur;
#line 376 "parser/tokenizer.re"
	{ KW(END_FILE) }
#line 7621 "parser/tokenizer.cpp"
yy957:
	yych = *++cur;
	if (yych == 'I') goto yy1041;
	if (yych == 'i') goto yy1041;
	goto yy37;
yy958:
	yyaccept = 13;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 8) {
		goto yy116;
	}
	if (yych <= '/') {
		if (yych <= '\v') {
			if (yych == '\t') goto yy1042;
			if (yych >= '\v') goto yy1042;
		} else {
			if (yych <= '\r') {
				if (yych >= '\r') goto yy1042;
			} else {
				if (yych == ' ') goto yy1042;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy36;
			} else {
				if (yych == 'D') goto yy1043;
				goto yy36;
			}
		} else {
			if (yych <= 'c') {
				if (yych >= 'a') goto yy36;
			} else {
				if (yych <= 'd') goto yy1043;
				if (yych <= 'z') goto yy36;
			}
		}
	}
yy959:
#line 315 "parser/tokenizer.re"
	{ KW(ENDBLOCK) }
#line 7664 "parser/tokenizer.cpp"
yy960:
	yych = *++cur;
	if (yych == 'C') goto yy1044;
	if (yych == 'c') goto yy1044;
	goto yy37;
yy961:
	yych = *++cur;
	if (yych == 'L') goto yy1045;
	if (yych == 'l') goto yy1045;
	goto yy37;
yy962:
	yych = *++cur;
	if (yych == 'I') goto yy1046;
	if (yych == 'i') goto yy1046;
	goto yy37;
yy963:
	yych = *++cur;
	if (yych == 'F') goto yy1047;
	if (yych == 'f') goto yy1047;
	goto yy37;
yy964:
	yych = *++cur;
	if (yych == 'E') goto yy1048;
	if (yych == 'e') goto yy1048;
	goto yy37;
yy965:
	yych = *++cur;
	if (yych == 'D') goto yy1049;
	if (yych == 'd') goto yy1049;
	goto yy37;
yy966:
	yych = *++cur;
	if (yych == 'A') goto yy1050;
	if (yych == 'a') goto yy1050;
	goto yy37;
yy967:
	yych = *++cur;
	if (yych == 'T') goto yy1051;
	if (yych == 't') goto yy1051;
	goto yy37;
yy968:
	yych = *++cur;
	if (yych == 'D') goto yy1052;
	if (yych == 'd') goto yy1052;
	goto yy37;
yy969:
	yych = *++cur;
	if (yych == 'U') goto yy1053;
	if (yych == 'u') goto yy1053;
	goto yy37;
yy970:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 374 "parser/tokenizer.re"
	{ KW(ENDWHERE) }
#line 7723 "parser/tokenizer.cpp"
yy971:
	yych = *++cur;
	if (yych == 'O') goto yy1054;
	if (yych == 'o') goto yy1054;
	goto yy37;
yy972:
	yych = *++cur;
	if (yych == 'N') goto yy1055;
	if (yych == 'n') goto yy1055;
	goto yy37;
yy973:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 388 "parser/tokenizer.re"
	{ KW(EXTERNAL) }
#line 7742 "parser/tokenizer.cpp"
yy974:
	yych = *++cur;
	if (yych == 'D') goto yy1056;
	if (yych == 'd') goto yy1056;
	goto yy37;
yy975:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 407 "parser/tokenizer.re"
	{ KW(FORM_TEAM) }
#line 7756 "parser/tokenizer.cpp"
yy976:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 408 "parser/tokenizer.re"
	{ KW(FUNCTION) }
#line 7765 "parser/tokenizer.cpp"
yy977:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 414 "parser/tokenizer.re"
	{ KW(IMPLICIT) }
#line 7774 "parser/tokenizer.cpp"
yy978:
	yych = *++cur;
	if (yych == 'A') goto yy1057;
	if (yych == 'a') goto yy1057;
	goto yy37;
yy979:
	yych = *++cur;
	if (yych == 'E') goto yy1058;
	if (yych == 'e') goto yy1058;
	goto yy37;
yy980:
	yych = *++cur;
	if (yych == 'C') goto yy1059;
	if (yych == 'c') goto yy1059;
	goto yy37;
yy981:
	yych = *++cur;
	if (yych == 'I') goto yy1060;
	if (yych == 'i') goto yy1060;
	goto yy37;
yy982:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 437 "parser/tokenizer.re"
	{ KW(NAMELIST) }
#line 7803 "parser/tokenizer.cpp"
yy983:
	yych = *++cur;
	if (yych == 'X') goto yy1061;
	if (yych == 'x') goto yy1061;
	goto yy37;
yy984:
	yych = *++cur;
	if (yych == 'I') goto yy1062;
	if (yych == 'i') goto yy1062;
	goto yy37;
yy985:
	yych = *++cur;
	if (yych == 'R') goto yy1063;
	if (yych == 'r') goto yy1063;
	goto yy37;
yy986:
	yych = *++cur;
	if (yych == 'R') goto yy1064;
	if (yych == 'r') goto yy1064;
	goto yy37;
yy987:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 447 "parser/tokenizer.re"
	{ KW(OPERATOR) }
#line 7832 "parser/tokenizer.cpp"
yy988:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 448 "parser/tokenizer.re"
	{ KW(OPTIONAL) }
#line 7841 "parser/tokenizer.cpp"
yy989:
	yych = *++cur;
	if (yych == 'R') goto yy1065;
	if (yych == 'r') goto yy1065;
	goto yy37;
yy990:
	yych = *++cur;
	if (yych == 'N') goto yy1066;
	if (yych == 'n') goto yy1066;
	goto yy37;
yy991:
	yych = *++cur;
	if (yych == 'E') goto yy1067;
	if (yych == 'e') goto yy1067;
	goto yy37;
yy992:
	yych = *++cur;
	if (yych == 'D') goto yy1068;
	if (yych == 'd') goto yy1068;
	goto yy37;
yy993:
	yych = *++cur;
	if (yych == 'E') goto yy1069;
	if (yych == 'e') goto yy1069;
	goto yy37;
yy994:
	yych = *++cur;
	if (yych == 'E') goto yy1070;
	if (yych == 'e') goto yy1070;
	goto yy37;
yy995:
	yych = *++cur;
	if (yych == 'S') goto yy1071;
	if (yych == 's') goto yy1071;
	goto yy37;
yy996:
	yych = *++cur;
	if (yych == 'N') goto yy1072;
	if (yych == 'n') goto yy1072;
	goto yy37;
yy997:
	yych = *++cur;
	if (yych == 'P') goto yy1073;
	if (yych == 'p') goto yy1073;
	goto yy37;
yy998:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 478 "parser/tokenizer.re"
	{ KW(SEQUENCE) }
#line 7895 "parser/tokenizer.cpp"
yy999:
	yych = *++cur;
	if (yych == 'E') goto yy1074;
	if (yych == 'e') goto yy1074;
	goto yy37;
yy1000:
	yych = *++cur;
	if (yych == 'N') goto yy1075;
	if (yych == 'n') goto yy1075;
	goto yy37;
yy1001:
	yych = *++cur;
	if (yych == 'E') goto yy1076;
	if (yych == 'e') goto yy1076;
	goto yy37;
yy1002:
	yych = *++cur;
	if (yych == 'R') goto yy1077;
	if (yych == 'r') goto yy1077;
	goto yy37;
yy1003:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 489 "parser/tokenizer.re"
	{ KW(SYNC_TEAM) }
#line 7924 "parser/tokenizer.cpp"
yy1004:
	yych = *++cur;
	if (yych == 'B') goto yy1078;
	if (yych == 'b') goto yy1078;
	goto yy37;
yy1005:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 493 "parser/tokenizer.re"
	{ KW(TEMPLATE) }
#line 7938 "parser/tokenizer.cpp"
yy1006:
	yych = *++cur;
	if (yych == 'T') goto yy1079;
	if (yych == 't') goto yy1079;
	goto yy37;
yy1007:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 500 "parser/tokenizer.re"
	{ KW(VOLATILE) }
#line 7952 "parser/tokenizer.cpp"
yy1008:
	++cur;
#line 701 "parser/tokenizer.re"
	{
                Location loc; token_loc(loc);
                diagnostics.tokenizer_warning_label(
                    "#define ignored", {loc},
                    "help: use the '--cpp' command line option to preprocess it");
                line_num++; cur_line=cur; continue;
            }
#line 7963 "parser/tokenizer.cpp"
yy1009:
	yych = *++cur;
	if (yych <= '/') goto yy806;
	if (yych <= '9') goto yy1009;
	goto yy806;
yy1010:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') goto yy806;
		if (yych <= '9') goto yy1010;
		if (yych <= '@') goto yy806;
		goto yy1010;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy806;
			goto yy1010;
		} else {
			if (yych <= '`') goto yy806;
			if (yych <= 'z') goto yy1010;
			goto yy806;
		}
	}
yy1011:
	yych = *++cur;
	if (yych == 'L') goto yy1080;
	if (yych == 'l') goto yy1080;
	goto yy37;
yy1012:
	yych = *++cur;
	if (yych == 'T') goto yy1081;
	if (yych == 't') goto yy1081;
	goto yy37;
yy1013:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 260 "parser/tokenizer.re"
	{ KW(ASSOCIATE) }
#line 8004 "parser/tokenizer.cpp"
yy1014:
	yych = *++cur;
	if (yych == 'O') goto yy1082;
	if (yych == 'o') goto yy1082;
	goto yy37;
yy1015:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 262 "parser/tokenizer.re"
	{ KW(BACKSPACE) }
#line 8018 "parser/tokenizer.cpp"
yy1016:
	yych = *++cur;
	if (yych == 'M') goto yy1083;
	if (yych == 'm') goto yy1083;
	goto yy37;
yy1017:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 269 "parser/tokenizer.re"
	{ KW(CHARACTER) }
#line 8032 "parser/tokenizer.cpp"
yy1018:
	yych = *++cur;
	if (yych == 'O') goto yy1084;
	if (yych == 'o') goto yy1084;
	goto yy37;
yy1019:
	yych = *++cur;
	if (yych == 'T') goto yy1085;
	if (yych == 't') goto yy1085;
	goto yy37;
yy1020:
	yych = *++cur;
	if (yych == 'S') goto yy1086;
	if (yych == 's') goto yy1086;
	goto yy37;
yy1021:
	yych = *++cur;
	if (yych == 'E') goto yy1087;
	if (yych == 'e') goto yy1087;
	goto yy37;
yy1022:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 285 "parser/tokenizer.re"
	{ KW(DIMENSION) }
#line 8061 "parser/tokenizer.cpp"
yy1023:
	yych = *++cur;
	if (yych == 'P') goto yy1088;
	if (yych == 'p') goto yy1088;
	goto yy37;
yy1024:
	yych = *++cur;
	if (yych == 'C') goto yy1089;
	if (yych == 'c') goto yy1089;
	goto yy37;
yy1025:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 298 "parser/tokenizer.re"
	{ KW(ELEMENTAL) }
#line 8080 "parser/tokenizer.cpp"
yy1026:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 301 "parser/tokenizer.re"
	{ KW(ELSEWHERE) }
#line 8089 "parser/tokenizer.cpp"
yy1027:
	yych = *++cur;
	if (yych == 'I') goto yy1090;
	if (yych == 'i') goto yy1090;
	goto yy61;
yy1028:
	yyaccept = 14;
	yych = *(mar = ++cur);
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1091;
		} else {
			if (yych != '\f') goto yy1091;
		}
	} else {
		if (yych <= 'C') {
			if (yych == ' ') goto yy1091;
		} else {
			if (yych <= 'D') goto yy1092;
			if (yych == 'd') goto yy1092;
		}
	}
yy1029:
#line 314 "parser/tokenizer.re"
	{ KW(END_BLOCK) }
#line 8115 "parser/tokenizer.cpp"
yy1030:
	yych = *++cur;
	if (yych == 'C') goto yy1093;
	if (yych == 'c') goto yy1093;
	goto yy61;
yy1031:
	yych = *++cur;
	if (yych == 'L') goto yy1094;
	if (yych == 'l') goto yy1094;
	goto yy61;
yy1032:
	yych = *++cur;
	if (yych == 'I') goto yy1095;
	if (yych == 'i') goto yy1095;
	goto yy61;
yy1033:
	yych = *++cur;
	if (yych == 'F') goto yy1096;
	if (yych == 'f') goto yy1096;
	goto yy61;
yy1034:
	yych = *++cur;
	if (yych == 'E') goto yy1097;
	if (yych == 'e') goto yy1097;
	goto yy61;
yy1035:
	yych = *++cur;
	if (yych == 'D') goto yy1098;
	if (yych == 'd') goto yy1098;
	goto yy61;
yy1036:
	yych = *++cur;
	if (yych == 'A') goto yy1099;
	if (yych == 'a') goto yy1099;
	goto yy61;
yy1037:
	yych = *++cur;
	if (yych == 'T') goto yy1100;
	if (yych == 't') goto yy1100;
	goto yy61;
yy1038:
	yych = *++cur;
	if (yych == 'D') goto yy1101;
	if (yych == 'd') goto yy1101;
	goto yy61;
yy1039:
	yych = *++cur;
	if (yych == 'U') goto yy1102;
	if (yych == 'u') goto yy1102;
	goto yy61;
yy1040:
	++cur;
#line 373 "parser/tokenizer.re"
	{ KW(END_WHERE) }
#line 8170 "parser/tokenizer.cpp"
yy1041:
	yych = *++cur;
	if (yych == 'A') goto yy1103;
	if (yych == 'a') goto yy1103;
	goto yy37;
yy1042:
	yych = *++cur;
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1042;
			goto yy61;
		} else {
			if (yych == '\f') goto yy61;
			goto yy1042;
		}
	} else {
		if (yych <= 'C') {
			if (yych == ' ') goto yy1042;
			goto yy61;
		} else {
			if (yych <= 'D') goto yy1104;
			if (yych == 'd') goto yy1104;
			goto yy61;
		}
	}
yy1043:
	yych = *++cur;
	if (yych == 'A') goto yy1105;
	if (yych == 'a') goto yy1105;
	goto yy37;
yy1044:
	yych = *++cur;
	if (yych == 'A') goto yy1106;
	if (yych == 'a') goto yy1106;
	goto yy37;
yy1045:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 347 "parser/tokenizer.re"
	{ KW(ENDFORALL) }
#line 8214 "parser/tokenizer.cpp"
yy1046:
	yych = *++cur;
	if (yych == 'O') goto yy1107;
	if (yych == 'o') goto yy1107;
	goto yy37;
yy1047:
	yych = *++cur;
	if (yych == 'A') goto yy1108;
	if (yych == 'a') goto yy1108;
	goto yy37;
yy1048:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 309 "parser/tokenizer.re"
	{ KW(ENDMODULE) }
#line 8233 "parser/tokenizer.cpp"
yy1049:
	yych = *++cur;
	if (yych == 'U') goto yy1109;
	if (yych == 'u') goto yy1109;
	goto yy37;
yy1050:
	yych = *++cur;
	if (yych == 'M') goto yy1110;
	if (yych == 'm') goto yy1110;
	goto yy37;
yy1051:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 335 "parser/tokenizer.re"
	{ KW(ENDSELECT) }
#line 8252 "parser/tokenizer.cpp"
yy1052:
	yych = *++cur;
	if (yych == 'U') goto yy1111;
	if (yych == 'u') goto yy1111;
	goto yy37;
yy1053:
	yych = *++cur;
	if (yych == 'T') goto yy1112;
	if (yych == 't') goto yy1112;
	goto yy37;
yy1054:
	yych = *++cur;
	if (yych == 'R') goto yy1113;
	if (yych == 'r') goto yy1113;
	goto yy37;
yy1055:
	yych = *++cur;
	if (yych == 'C') goto yy1114;
	if (yych == 'c') goto yy1114;
	goto yy37;
yy1056:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 405 "parser/tokenizer.re"
	{ KW(FORMATTED) }
#line 8281 "parser/tokenizer.cpp"
yy1057:
	yych = *++cur;
	if (yych == 'T') goto yy1115;
	if (yych == 't') goto yy1115;
	goto yy37;
yy1058:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 425 "parser/tokenizer.re"
	{ KW(INTERFACE) }
#line 8295 "parser/tokenizer.cpp"
yy1059:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 426 "parser/tokenizer.re"
	{ KW(INTRINSIC) }
#line 8304 "parser/tokenizer.cpp"
yy1060:
	yych = *++cur;
	if (yych == 'T') goto yy1116;
	if (yych == 't') goto yy1116;
	goto yy37;
yy1061:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 438 "parser/tokenizer.re"
	{ KW(NEW_INDEX) }
#line 8318 "parser/tokenizer.cpp"
yy1062:
	yych = *++cur;
	if (yych == 'N') goto yy1117;
	if (yych == 'n') goto yy1117;
	goto yy37;
yy1063:
	yych = *++cur;
	if (yych == 'I') goto yy1118;
	if (yych == 'i') goto yy1118;
	goto yy37;
yy1064:
	yych = *++cur;
	if (yych == 'S') goto yy1119;
	if (yych == 's') goto yy1119;
	goto yy37;
yy1065:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 450 "parser/tokenizer.re"
	{ KW(PARAMETER) }
#line 8342 "parser/tokenizer.cpp"
yy1066:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 454 "parser/tokenizer.re"
	{ KW(PRECISION) }
#line 8351 "parser/tokenizer.cpp"
yy1067:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 457 "parser/tokenizer.re"
	{ KW(PROCEDURE) }
#line 8360 "parser/tokenizer.cpp"
yy1068:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 459 "parser/tokenizer.re"
	{ KW(PROTECTED) }
#line 8369 "parser/tokenizer.cpp"
yy1069:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 466 "parser/tokenizer.re"
	{ KW(RECURSIVE) }
#line 8378 "parser/tokenizer.cpp"
yy1070:
	yych = *++cur;
	if (yych == 'N') goto yy1120;
	if (yych == 'n') goto yy1120;
	goto yy37;
yy1071:
	yych = *++cur;
	if (yych == 'E') goto yy1121;
	if (yych == 'e') goto yy1121;
	goto yy37;
yy1072:
	yych = *++cur;
	if (yych == 'K') goto yy1122;
	if (yych == 'k') goto yy1122;
	goto yy37;
yy1073:
	yych = *++cur;
	if (yych == 'E') goto yy1123;
	if (yych == 'e') goto yy1123;
	goto yy37;
yy1074:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 483 "parser/tokenizer.re"
	{ KW(SUBMODULE) }
#line 8407 "parser/tokenizer.cpp"
yy1075:
	yych = *++cur;
	if (yych == 'E') goto yy1124;
	if (yych == 'e') goto yy1124;
	goto yy37;
yy1076:
	yych = *++cur;
	if (yych == 'S') goto yy1125;
	if (yych == 's') goto yy1125;
	goto yy37;
yy1077:
	yych = *++cur;
	if (yych == 'Y') goto yy1126;
	if (yych == 'y') goto yy1126;
	goto yy37;
yy1078:
	yych = *++cur;
	if (yych == 'E') goto yy1127;
	if (yych == 'e') goto yy1127;
	goto yy37;
yy1079:
	yych = *++cur;
	if (yych == 'E') goto yy1128;
	if (yych == 'e') goto yy1128;
	goto yy37;
yy1080:
	yych = *++cur;
	if (yych == 'E') goto yy1129;
	if (yych == 'e') goto yy1129;
	goto yy37;
yy1081:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 259 "parser/tokenizer.re"
	{ KW(ASSIGNMENT) }
#line 8446 "parser/tokenizer.cpp"
yy1082:
	yych = *++cur;
	if (yych == 'U') goto yy1130;
	if (yych == 'u') goto yy1130;
	goto yy37;
yy1083:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 268 "parser/tokenizer.re"
	{ KW(CHANGE_TEAM) }
#line 8460 "parser/tokenizer.cpp"
yy1084:
	yych = *++cur;
	if (yych == 'N') goto yy1131;
	if (yych == 'n') goto yy1131;
	goto yy37;
yy1085:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 275 "parser/tokenizer.re"
	{ KW(CONCURRENT) }
#line 8474 "parser/tokenizer.cpp"
yy1086:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 277 "parser/tokenizer.re"
	{ KW(CONTIGUOUS) }
#line 8483 "parser/tokenizer.cpp"
yy1087:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 282 "parser/tokenizer.re"
	{ KW(DEALLOCATE) }
#line 8492 "parser/tokenizer.cpp"
yy1088:
	yych = *++cur;
	if (yych == 'L') goto yy1132;
	if (yych == 'l') goto yy1132;
	goto yy37;
yy1089:
	yych = *++cur;
	if (yych == 'I') goto yy1133;
	if (yych == 'i') goto yy1133;
	goto yy37;
yy1090:
	yych = *++cur;
	if (yych == 'A') goto yy1134;
	if (yych == 'a') goto yy1134;
	goto yy61;
yy1091:
	yych = *++cur;
	if (yych <= '\r') {
		if (yych <= '\n') {
			if (yych == '\t') goto yy1091;
			goto yy61;
		} else {
			if (yych == '\f') goto yy61;
			goto yy1091;
		}
	} else {
		if (yych <= 'C') {
			if (yych == ' ') goto yy1091;
			goto yy61;
		} else {
			if (yych <= 'D') goto yy1135;
			if (yych == 'd') goto yy1135;
			goto yy61;
		}
	}
yy1092:
	yych = *++cur;
	if (yych == 'A') goto yy1136;
	if (yych == 'a') goto yy1136;
	goto yy61;
yy1093:
	yych = *++cur;
	if (yych == 'A') goto yy1137;
	if (yych == 'a') goto yy1137;
	goto yy61;
yy1094:
	++cur;
#line 346 "parser/tokenizer.re"
	{ KW(END_FORALL) }
#line 8542 "parser/tokenizer.cpp"
yy1095:
	yych = *++cur;
	if (yych == 'O') goto yy1138;
	if (yych == 'o') goto yy1138;
	goto yy61;
yy1096:
	yych = *++cur;
	if (yych == 'A') goto yy1139;
	if (yych == 'a') goto yy1139;
	goto yy61;
yy1097:
	++cur;
#line 308 "parser/tokenizer.re"
	{ KW(END_MODULE) }
#line 8557 "parser/tokenizer.cpp"
yy1098:
	yych = *++cur;
	if (yych == 'U') goto yy1140;
	if (yych == 'u') goto yy1140;
	goto yy61;
yy1099:
	yych = *++cur;
	if (yych == 'M') goto yy1141;
	if (yych == 'm') goto yy1141;
	goto yy61;
yy1100:
	++cur;
#line 334 "parser/tokenizer.re"
	{ KW(END_SELECT) }
#line 8572 "parser/tokenizer.cpp"
yy1101:
	yych = *++cur;
	if (yych == 'U') goto yy1142;
	if (yych == 'u') goto yy1142;
	goto yy61;
yy1102:
	yych = *++cur;
	if (yych == 'T') goto yy1143;
	if (yych == 't') goto yy1143;
	goto yy61;
yy1103:
	yych = *++cur;
	if (yych == 'T') goto yy1144;
	if (yych == 't') goto yy1144;
	goto yy37;
yy1104:
	yych = *++cur;
	if (yych == 'A') goto yy1145;
	if (yych == 'a') goto yy1145;
	goto yy61;
yy1105:
	yych = *++cur;
	if (yych == 'T') goto yy1146;
	if (yych == 't') goto yy1146;
	goto yy37;
yy1106:
	yych = *++cur;
	if (yych == 'L') goto yy1147;
	if (yych == 'l') goto yy1147;
	goto yy37;
yy1107:
	yych = *++cur;
	if (yych == 'N') goto yy1148;
	if (yych == 'n') goto yy1148;
	goto yy37;
yy1108:
	yych = *++cur;
	if (yych == 'C') goto yy1149;
	if (yych == 'c') goto yy1149;
	goto yy37;
yy1109:
	yych = *++cur;
	if (yych == 'R') goto yy1150;
	if (yych == 'r') goto yy1150;
	goto yy37;
yy1110:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 306 "parser/tokenizer.re"
	{ KW(ENDPROGRAM) }
#line 8626 "parser/tokenizer.cpp"
yy1111:
	yych = *++cur;
	if (yych == 'L') goto yy1151;
	if (yych == 'l') goto yy1151;
	goto yy37;
yy1112:
	yych = *++cur;
	if (yych == 'I') goto yy1152;
	if (yych == 'i') goto yy1152;
	goto yy37;
yy1113:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 381 "parser/tokenizer.re"
	{ KW(ENUMERATOR) }
#line 8645 "parser/tokenizer.cpp"
yy1114:
	yych = *++cur;
	if (yych == 'E') goto yy1153;
	if (yych == 'e') goto yy1153;
	goto yy37;
yy1115:
	yych = *++cur;
	if (yych == 'E') goto yy1154;
	if (yych == 'e') goto yy1154;
	goto yy37;
yy1116:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 431 "parser/tokenizer.re"
	{ KW(LOCAL_INIT) }
#line 8664 "parser/tokenizer.cpp"
yy1117:
	yych = *++cur;
	if (yych == 'S') goto yy1155;
	if (yych == 's') goto yy1155;
	goto yy37;
yy1118:
	yych = *++cur;
	if (yych == 'D') goto yy1156;
	if (yych == 'd') goto yy1156;
	goto yy37;
yy1119:
	yych = *++cur;
	if (yych == 'I') goto yy1157;
	if (yych == 'i') goto yy1157;
	goto yy37;
yy1120:
	yych = *++cur;
	if (yych == 'T') goto yy1158;
	if (yych == 't') goto yy1158;
	goto yy37;
yy1121:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 475 "parser/tokenizer.re"
	{ KW(SELECT_CASE) }
#line 8693 "parser/tokenizer.cpp"
yy1122:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 476 "parser/tokenizer.re"
	{ KW(SELECT_RANK) }
#line 8702 "parser/tokenizer.cpp"
yy1123:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 477 "parser/tokenizer.re"
	{ KW(SELECT_TYPE) }
#line 8711 "parser/tokenizer.cpp"
yy1124:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 484 "parser/tokenizer.re"
	{ KW(SUBROUTINE) }
#line 8720 "parser/tokenizer.cpp"
yy1125:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 487 "parser/tokenizer.re"
	{ KW(SYNC_IMAGES) }
#line 8729 "parser/tokenizer.cpp"
yy1126:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 488 "parser/tokenizer.re"
	{ KW(SYNC_MEMORY) }
#line 8738 "parser/tokenizer.cpp"
yy1127:
	yych = *++cur;
	if (yych == 'R') goto yy1159;
	if (yych == 'r') goto yy1159;
	goto yy37;
yy1128:
	yych = *++cur;
	if (yych == 'D') goto yy1160;
	if (yych == 'd') goto yy1160;
	goto yy37;
yy1129:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 256 "parser/tokenizer.re"
	{ KW(ALLOCATABLE) }
#line 8757 "parser/tokenizer.cpp"
yy1130:
	yych = *++cur;
	if (yych == 'S') goto yy1161;
	if (yych == 's') goto yy1161;
	goto yy37;
yy1131:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 272 "parser/tokenizer.re"
	{ KW(CODIMENSION) }
#line 8771 "parser/tokenizer.cpp"
yy1132:
	yych = *++cur;
	if (yych == 'E') goto yy1162;
	if (yych == 'e') goto yy1162;
	goto yy37;
yy1133:
	yych = *++cur;
	if (yych == 'S') goto yy1163;
	if (yych == 's') goto yy1163;
	goto yy37;
yy1134:
	yych = *++cur;
	if (yych == 'T') goto yy1164;
	if (yych == 't') goto yy1164;
	goto yy61;
yy1135:
	yych = *++cur;
	if (yych == 'A') goto yy1165;
	if (yych == 'a') goto yy1165;
	goto yy61;
yy1136:
	yych = *++cur;
	if (yych == 'T') goto yy1166;
	if (yych == 't') goto yy1166;
	goto yy61;
yy1137:
	yych = *++cur;
	if (yych == 'L') goto yy1167;
	if (yych == 'l') goto yy1167;
	goto yy61;
yy1138:
	yych = *++cur;
	if (yych == 'N') goto yy1168;
	if (yych == 'n') goto yy1168;
	goto yy61;
yy1139:
	yych = *++cur;
	if (yych == 'C') goto yy1169;
	if (yych == 'c') goto yy1169;
	goto yy61;
yy1140:
	yych = *++cur;
	if (yych == 'R') goto yy1170;
	if (yych == 'r') goto yy1170;
	goto yy61;
yy1141:
	++cur;
#line 305 "parser/tokenizer.re"
	{ KW(END_PROGRAM) }
#line 8821 "parser/tokenizer.cpp"
yy1142:
	yych = *++cur;
	if (yych == 'L') goto yy1171;
	if (yych == 'l') goto yy1171;
	goto yy61;
yy1143:
	yych = *++cur;
	if (yych == 'I') goto yy1172;
	if (yych == 'i') goto yy1172;
	goto yy61;
yy1144:
	yych = *++cur;
	if (yych == 'E') goto yy1173;
	if (yych == 'e') goto yy1173;
	goto yy37;
yy1145:
	yych = *++cur;
	if (yych == 'T') goto yy1174;
	if (yych == 't') goto yy1174;
	goto yy61;
yy1146:
	yych = *++cur;
	if (yych == 'A') goto yy1175;
	if (yych == 'a') goto yy1175;
	goto yy37;
yy1147:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 341 "parser/tokenizer.re"
	{ KW(ENDCRITICAL) }
#line 8855 "parser/tokenizer.cpp"
yy1148:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 326 "parser/tokenizer.re"
	{ KW(ENDFUNCTION) }
#line 8864 "parser/tokenizer.cpp"
yy1149:
	yych = *++cur;
	if (yych == 'E') goto yy1176;
	if (yych == 'e') goto yy1176;
	goto yy37;
yy1150:
	yych = *++cur;
	if (yych == 'E') goto yy1177;
	if (yych == 'e') goto yy1177;
	goto yy37;
yy1151:
	yych = *++cur;
	if (yych == 'E') goto yy1178;
	if (yych == 'e') goto yy1178;
	goto yy37;
yy1152:
	yych = *++cur;
	if (yych == 'N') goto yy1179;
	if (yych == 'n') goto yy1179;
	goto yy37;
yy1153:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 382 "parser/tokenizer.re"
	{ KW(EQUIVALENCE) }
#line 8893 "parser/tokenizer.cpp"
yy1154:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 422 "parser/tokenizer.re"
	{ KW(INSTANTIATE) }
#line 8902 "parser/tokenizer.cpp"
yy1155:
	yych = *++cur;
	if (yych == 'I') goto yy1180;
	if (yych == 'i') goto yy1180;
	goto yy37;
yy1156:
	yych = *++cur;
	if (yych == 'A') goto yy1181;
	if (yych == 'a') goto yy1181;
	goto yy37;
yy1157:
	yych = *++cur;
	if (yych == 'V') goto yy1182;
	if (yych == 'v') goto yy1182;
	goto yy37;
yy1158:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 468 "parser/tokenizer.re"
	{ KW(REQUIREMENT) }
#line 8926 "parser/tokenizer.cpp"
yy1159:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 492 "parser/tokenizer.re"
	{ KW(TEAM_NUMBER) }
#line 8935 "parser/tokenizer.cpp"
yy1160:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 497 "parser/tokenizer.re"
	{ KW(UNFORMATTED) }
#line 8944 "parser/tokenizer.cpp"
yy1161:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 261 "parser/tokenizer.re"
	{ KW(ASYNCHRONOUS) }
#line 8953 "parser/tokenizer.cpp"
yy1162:
	yych = *++cur;
	if (yych == 'X') goto yy1183;
	if (yych == 'x') goto yy1183;
	goto yy37;
yy1163:
	yych = *++cur;
	if (yych == 'I') goto yy1184;
	if (yych == 'i') goto yy1184;
	goto yy37;
yy1164:
	yych = *++cur;
	if (yych == 'E') goto yy1185;
	if (yych == 'e') goto yy1185;
	goto yy61;
yy1165:
	yych = *++cur;
	if (yych == 'T') goto yy1186;
	if (yych == 't') goto yy1186;
	goto yy61;
yy1166:
	yych = *++cur;
	if (yych == 'A') goto yy1187;
	if (yych == 'a') goto yy1187;
	goto yy61;
yy1167:
	++cur;
#line 340 "parser/tokenizer.re"
	{ KW(END_CRITICAL) }
#line 8983 "parser/tokenizer.cpp"
yy1168:
	++cur;
#line 325 "parser/tokenizer.re"
	{ KW(END_FUNCTION) }
#line 8988 "parser/tokenizer.cpp"
yy1169:
	yych = *++cur;
	if (yych == 'E') goto yy1188;
	if (yych == 'e') goto yy1188;
	goto yy61;
yy1170:
	yych = *++cur;
	if (yych == 'E') goto yy1189;
	if (yych == 'e') goto yy1189;
	goto yy61;
yy1171:
	yych = *++cur;
	if (yych == 'E') goto yy1190;
	if (yych == 'e') goto yy1190;
	goto yy61;
yy1172:
	yych = *++cur;
	if (yych == 'N') goto yy1191;
	if (yych == 'n') goto yy1191;
	goto yy61;
yy1173:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 338 "parser/tokenizer.re"
	{ KW(ENDASSOCIATE) }
#line 9017 "parser/tokenizer.cpp"
yy1174:
	yych = *++cur;
	if (yych == 'A') goto yy1192;
	if (yych == 'a') goto yy1192;
	goto yy61;
yy1175:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 320 "parser/tokenizer.re"
	{ KW(ENDBLOCKDATA) }
#line 9031 "parser/tokenizer.cpp"
yy1176:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 353 "parser/tokenizer.re"
	{ KW(ENDINTERFACE) }
#line 9040 "parser/tokenizer.cpp"
yy1177:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 329 "parser/tokenizer.re"
	{ KW(ENDPROCEDURE) }
#line 9049 "parser/tokenizer.cpp"
yy1178:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 312 "parser/tokenizer.re"
	{ KW(ENDSUBMODULE) }
#line 9058 "parser/tokenizer.cpp"
yy1179:
	yych = *++cur;
	if (yych == 'E') goto yy1193;
	if (yych == 'e') goto yy1193;
	goto yy37;
yy1180:
	yych = *++cur;
	if (yych == 'C') goto yy1194;
	if (yych == 'c') goto yy1194;
	goto yy37;
yy1181:
	yych = *++cur;
	if (yych == 'B') goto yy1195;
	if (yych == 'b') goto yy1195;
	goto yy37;
yy1182:
	yych = *++cur;
	if (yych == 'E') goto yy1196;
	if (yych == 'e') goto yy1196;
	goto yy37;
yy1183:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 297 "parser/tokenizer.re"
	{ KW(DOUBLE_COMPLEX) }
#line 9087 "parser/tokenizer.cpp"
yy1184:
	yych = *++cur;
	if (yych == 'O') goto yy1197;
	if (yych == 'o') goto yy1197;
	goto yy37;
yy1185:
	++cur;
#line 337 "parser/tokenizer.re"
	{ KW(END_ASSOCIATE) }
#line 9097 "parser/tokenizer.cpp"
yy1186:
	yych = *++cur;
	if (yych == 'A') goto yy1198;
	if (yych == 'a') goto yy1198;
	goto yy61;
yy1187:
	++cur;
#line 319 "parser/tokenizer.re"
	{ KW(END_BLOCK_DATA) }
#line 9107 "parser/tokenizer.cpp"
yy1188:
	++cur;
#line 352 "parser/tokenizer.re"
	{ KW(END_INTERFACE) }
#line 9112 "parser/tokenizer.cpp"
yy1189:
	++cur;
#line 328 "parser/tokenizer.re"
	{ KW(END_PROCEDURE) }
#line 9117 "parser/tokenizer.cpp"
yy1190:
	++cur;
#line 311 "parser/tokenizer.re"
	{ KW(END_SUBMODULE) }
#line 9122 "parser/tokenizer.cpp"
yy1191:
	yych = *++cur;
	if (yych == 'E') goto yy1199;
	if (yych == 'e') goto yy1199;
	goto yy61;
yy1192:
	++cur;
#line 318 "parser/tokenizer.re"
	{ KW(END_BLOCK_DATA) }
#line 9132 "parser/tokenizer.cpp"
yy1193:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 323 "parser/tokenizer.re"
	{ KW(ENDSUBROUTINE) }
#line 9141 "parser/tokenizer.cpp"
yy1194:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 440 "parser/tokenizer.re"
	{ KW(NON_INTRINSIC) }
#line 9150 "parser/tokenizer.cpp"
yy1195:
	yych = *++cur;
	if (yych == 'L') goto yy1200;
	if (yych == 'l') goto yy1200;
	goto yy37;
yy1196:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 442 "parser/tokenizer.re"
	{ KW(NON_RECURSIVE) }
#line 9164 "parser/tokenizer.cpp"
yy1197:
	yych = *++cur;
	if (yych == 'N') goto yy1201;
	if (yych == 'n') goto yy1201;
	goto yy37;
yy1198:
	++cur;
#line 317 "parser/tokenizer.re"
	{ KW(END_BLOCK_DATA) }
#line 9174 "parser/tokenizer.cpp"
yy1199:
	++cur;
#line 322 "parser/tokenizer.re"
	{ KW(END_SUBROUTINE) }
#line 9179 "parser/tokenizer.cpp"
yy1200:
	yych = *++cur;
	if (yych == 'E') goto yy1202;
	if (yych == 'e') goto yy1202;
	goto yy37;
yy1201:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 296 "parser/tokenizer.re"
	{ KW(DOUBLE_PRECISION) }
#line 9193 "parser/tokenizer.cpp"
yy1202:
	yych = *++cur;
	if (yybm[256+yych] & 32) {
		goto yy36;
	}
	if (yych == '_') goto yy116;
#line 441 "parser/tokenizer.re"
	{ KW(NON_OVERRIDABLE) }
#line 9202 "parser/tokenizer.cpp"
}
#line 722 "parser/tokenizer.re"

    }
}

std::string token(unsigned char *tok, unsigned char* cur)
{
    return std::string((char *)tok, cur - tok);
}

void token_loc(Location &loc)
{
    loc.first = 1;
    loc.last = 1;
}

void lex_format(unsigned char *&cur, Location &loc,
        unsigned char *&start) {
    int num_paren = 0;
    for (;;) {
        unsigned char *tok = cur;
        unsigned char *mar;
        
#line 9227 "parser/tokenizer.cpp"
{
	unsigned char yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0, 208, 208, 208, 208, 208, 208, 208, 
		208, 244, 176, 244, 208, 244, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		244, 208, 192, 208, 208, 208, 208,  80, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		216, 216, 216, 216, 216, 216, 216, 216, 
		216, 216, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
		208, 208, 208, 208, 208, 208, 208, 208, 
	};
	yych = *cur;
	if (yybm[0+yych] & 4) {
		goto yy1207;
	}
	switch (yych) {
		case 0x00: goto yy1204;
		case '"': goto yy1208;
		case '&': goto yy1209;
		case '\'': goto yy1210;
		case '(': goto yy1211;
		case ')': goto yy1212;
		case '*': goto yy1213;
		case ',': goto yy1214;
		case '-': goto yy1215;
		case '/':
		case ':': goto yy1216;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy1218;
		case 'A':
		case 'a': goto yy1219;
		case 'B':
		case 'I':
		case 'O':
		case 'Z':
		case 'b':
		case 'i':
		case 'o':
		case 'z': goto yy1221;
		case 'D':
		case 'F':
		case 'd':
		case 'f': goto yy1222;
		case 'E':
		case 'e': goto yy1223;
		case 'G':
		case 'g': goto yy1224;
		case 'L':
		case 'l': goto yy1225;
		case 'P':
		case 'p': goto yy1226;
		case 'T':
		case 't': goto yy1227;
		case 'X':
		case 'x': goto yy1228;
		default: goto yy1205;
	}
yy1204:
	++cur;
#line 815 "parser/tokenizer.re"
	{
                token_loc(loc);
                std::string t = token(tok, cur);
                throw LFortran::parser_local::TokenizerError(
                    "End of file not expected in `format` statement '" + t + "'", loc);
            }
#line 9328 "parser/tokenizer.cpp"
yy1205:
	++cur;
yy1206:
#line 781 "parser/tokenizer.re"
	{
                token_loc(loc);
                std::string t = token(tok, cur);
                throw LFortran::parser_local::TokenizerError("Token '" + t
                    + "' is not recognized in `format` statement", loc);
            }
#line 9339 "parser/tokenizer.cpp"
yy1207:
	yych = *++cur;
	if (yybm[0+yych] & 4) {
		goto yy1207;
	}
#line 821 "parser/tokenizer.re"
	{ continue; }
#line 9347 "parser/tokenizer.cpp"
yy1208:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy1206;
	goto yy1230;
yy1209:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy1206;
		if (yych <= '\v') goto yy1235;
		goto yy1206;
	} else {
		if (yych <= '\r') goto yy1235;
		if (yych <= 0x1F) goto yy1206;
		if (yych <= '!') goto yy1235;
		goto yy1206;
	}
yy1210:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 0x00) goto yy1206;
	goto yy1240;
yy1211:
	++cur;
#line 787 "parser/tokenizer.re"
	{
                if (num_paren == 0) {
                    num_paren++;
                    start = cur;
                    continue;
                } else {
                    cur--;
                    unsigned char *tmp;
                    lex_format(cur, loc, tmp);
                    continue;
                }
            }
#line 9386 "parser/tokenizer.cpp"
yy1212:
	++cur;
#line 811 "parser/tokenizer.re"
	{
                LCOMPILERS_ASSERT(num_paren == 1);
                return;
            }
#line 9394 "parser/tokenizer.cpp"
yy1213:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1206;
			goto yy1242;
		} else {
			if (yych == '\v') goto yy1242;
			goto yy1206;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1242;
			if (yych <= 0x1F) goto yy1206;
			goto yy1242;
		} else {
			if (yych == '(') goto yy1243;
			goto yy1206;
		}
	}
yy1214:
	++cur;
#line 822 "parser/tokenizer.re"
	{ continue; }
#line 9420 "parser/tokenizer.cpp"
yy1215:
	++cur;
#line 826 "parser/tokenizer.re"
	{ continue; }
#line 9425 "parser/tokenizer.cpp"
yy1216:
	++cur;
yy1217:
#line 828 "parser/tokenizer.re"
	{ continue; }
#line 9431 "parser/tokenizer.cpp"
yy1218:
	yyaccept = 0;
	yych = *(mar = ++cur);
	switch (yych) {
		case '\t':
		case '\v':
		case '\r':
		case ' ':
		case '(':
		case '/':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case 'A':
		case 'B':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'I':
		case 'L':
		case 'O':
		case 'P':
		case 'X':
		case 'Z':
		case 'a':
		case 'b':
		case 'd':
		case 'e':
		case 'f':
		case 'g':
		case 'i':
		case 'l':
		case 'o':
		case 'p':
		case 'x':
		case 'z': goto yy1247;
		default: goto yy1206;
	}
yy1219:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy1219;
	}
yy1220:
#line 827 "parser/tokenizer.re"
	{ continue; }
#line 9486 "parser/tokenizer.cpp"
yy1221:
	yych = *++cur;
	if (yych <= '/') goto yy1206;
	if (yych <= '9') goto yy1253;
	goto yy1206;
yy1222:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= '/') goto yy1206;
	if (yych <= '9') goto yy1254;
	goto yy1206;
yy1223:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 'W') {
		if (yych <= 'M') {
			if (yych <= '/') goto yy1206;
			if (yych <= '9') goto yy1255;
			goto yy1206;
		} else {
			if (yych <= 'N') goto yy1256;
			if (yych == 'S') goto yy1256;
			goto yy1206;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'X') goto yy1256;
			if (yych == 'n') goto yy1256;
			goto yy1206;
		} else {
			if (yych <= 's') goto yy1256;
			if (yych == 'x') goto yy1256;
			goto yy1206;
		}
	}
yy1224:
	yych = *++cur;
	if (yych <= '/') goto yy1206;
	if (yych <= '9') goto yy1257;
	goto yy1206;
yy1225:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy1219;
	}
	goto yy1206;
yy1226:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= 'D') goto yy1220;
	if (yych <= 'F') goto yy1249;
	if (yych <= 'd') goto yy1220;
	if (yych <= 'f') goto yy1249;
	goto yy1220;
yy1227:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= 'Q') {
		if (yych <= '9') {
			if (yych <= '/') goto yy1206;
			goto yy1258;
		} else {
			if (yych == 'L') goto yy1259;
			goto yy1206;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'R') goto yy1259;
			if (yych <= 'k') goto yy1206;
			goto yy1259;
		} else {
			if (yych == 'r') goto yy1259;
			goto yy1206;
		}
	}
yy1228:
	++cur;
	goto yy1220;
yy1229:
	yych = *++cur;
yy1230:
	if (yybm[0+yych] & 16) {
		goto yy1229;
	}
	if (yych >= 0x01) goto yy1232;
yy1231:
	cur = mar;
	if (yyaccept <= 2) {
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy1206;
			} else {
				goto yy1220;
			}
		} else {
			goto yy1233;
		}
	} else {
		if (yyaccept == 3) {
			goto yy1237;
		} else {
			goto yy1241;
		}
	}
yy1232:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych == '"') goto yy1229;
yy1233:
#line 824 "parser/tokenizer.re"
	{ continue; }
#line 9598 "parser/tokenizer.cpp"
yy1234:
	yych = *++cur;
yy1235:
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1231;
			goto yy1234;
		} else {
			if (yych <= '\n') goto yy1236;
			if (yych <= '\v') goto yy1234;
			goto yy1231;
		}
	} else {
		if (yych <= 0x1F) {
			if (yych <= '\r') goto yy1234;
			goto yy1231;
		} else {
			if (yych <= ' ') goto yy1234;
			if (yych <= '!') goto yy1238;
			goto yy1231;
		}
	}
yy1236:
	yyaccept = 3;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 32) {
		goto yy1236;
	}
	if (yych <= 0x1F) goto yy1237;
	if (yych <= '!') goto yy1238;
	if (yych == '&') goto yy1260;
yy1237:
#line 823 "parser/tokenizer.re"
	{ continue; }
#line 9633 "parser/tokenizer.cpp"
yy1238:
	yych = *++cur;
	if (yybm[0+yych] & 64) {
		goto yy1238;
	}
	if (yych <= 0x00) goto yy1231;
	goto yy1236;
yy1239:
	yych = *++cur;
yy1240:
	if (yybm[0+yych] & 128) {
		goto yy1239;
	}
	if (yych <= 0x00) goto yy1231;
	yyaccept = 4;
	yych = *(mar = ++cur);
	if (yych == '\'') goto yy1239;
yy1241:
#line 825 "parser/tokenizer.re"
	{ continue; }
#line 9654 "parser/tokenizer.cpp"
yy1242:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1231;
			goto yy1242;
		} else {
			if (yych == '\v') goto yy1242;
			goto yy1231;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1242;
			if (yych <= 0x1F) goto yy1231;
			goto yy1242;
		} else {
			if (yych != '(') goto yy1231;
		}
	}
yy1243:
	++cur;
#line 805 "parser/tokenizer.re"
	{
                cur--;
                unsigned char *tmp;
                lex_format(cur, loc, tmp);
                continue;
            }
#line 9683 "parser/tokenizer.cpp"
yy1244:
	yych = *++cur;
	if (yych <= '\f') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy1231;
			goto yy1244;
		} else {
			if (yych == '\v') goto yy1244;
			goto yy1231;
		}
	} else {
		if (yych <= ' ') {
			if (yych <= '\r') goto yy1244;
			if (yych <= 0x1F) goto yy1231;
			goto yy1244;
		} else {
			if (yych != '(') goto yy1231;
		}
	}
yy1245:
	++cur;
#line 799 "parser/tokenizer.re"
	{
                cur--;
                unsigned char *tmp;
                lex_format(cur, loc, tmp);
                continue;
            }
#line 9712 "parser/tokenizer.cpp"
yy1246:
	yych = *++cur;
yy1247:
	switch (yych) {
		case '\t':
		case '\v':
		case '\r':
		case ' ': goto yy1244;
		case '(': goto yy1245;
		case '/': goto yy1216;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy1246;
		case 'A':
		case 'a': goto yy1219;
		case 'B':
		case 'I':
		case 'O':
		case 'Z':
		case 'b':
		case 'i':
		case 'o':
		case 'z': goto yy1248;
		case 'D':
		case 'F':
		case 'd':
		case 'f': goto yy1249;
		case 'E':
		case 'e': goto yy1250;
		case 'G':
		case 'g': goto yy1251;
		case 'L':
		case 'l': goto yy1252;
		case 'P':
		case 'p': goto yy1226;
		case 'X':
		case 'x': goto yy1228;
		default: goto yy1231;
	}
yy1248:
	yych = *++cur;
	if (yych <= '/') goto yy1231;
	if (yych <= '9') goto yy1253;
	goto yy1231;
yy1249:
	yych = *++cur;
	if (yych <= '/') goto yy1231;
	if (yych <= '9') goto yy1254;
	goto yy1231;
yy1250:
	yych = *++cur;
	if (yych <= 'W') {
		if (yych <= 'M') {
			if (yych <= '/') goto yy1231;
			if (yych <= '9') goto yy1255;
			goto yy1231;
		} else {
			if (yych <= 'N') goto yy1256;
			if (yych == 'S') goto yy1256;
			goto yy1231;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'X') goto yy1256;
			if (yych == 'n') goto yy1256;
			goto yy1231;
		} else {
			if (yych <= 's') goto yy1256;
			if (yych == 'x') goto yy1256;
			goto yy1231;
		}
	}
yy1251:
	yych = *++cur;
	if (yych <= '/') goto yy1231;
	if (yych <= '9') goto yy1257;
	goto yy1231;
yy1252:
	yych = *++cur;
	if (yybm[0+yych] & 8) {
		goto yy1219;
	}
	goto yy1231;
yy1253:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych == '.') goto yy1252;
	if (yych <= '/') goto yy1220;
	if (yych <= '9') goto yy1253;
	goto yy1220;
yy1254:
	yych = *++cur;
	if (yych == '.') goto yy1252;
	if (yych <= '/') goto yy1231;
	if (yych <= '9') goto yy1254;
	goto yy1231;
yy1255:
	yych = *++cur;
	if (yych == '.') goto yy1261;
	if (yych <= '/') goto yy1231;
	if (yych <= '9') goto yy1255;
	goto yy1231;
yy1256:
	yych = *++cur;
	if (yych <= '/') goto yy1231;
	if (yych <= '9') goto yy1255;
	goto yy1231;
yy1257:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych == '.') goto yy1261;
	if (yych <= '/') goto yy1220;
	if (yych <= '9') goto yy1257;
	goto yy1220;
yy1258:
	yych = *++cur;
	if (yych <= '/') goto yy1217;
	if (yych <= '9') goto yy1258;
	goto yy1217;
yy1259:
	yych = *++cur;
	if (yych <= '/') goto yy1231;
	if (yych <= '9') goto yy1258;
	goto yy1231;
yy1260:
	++cur;
	goto yy1237;
yy1261:
	yych = *++cur;
	if (yych <= '/') goto yy1231;
	if (yych >= ':') goto yy1231;
yy1262:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= 'D') {
		if (yych <= '/') goto yy1220;
		if (yych <= '9') goto yy1262;
		goto yy1220;
	} else {
		if (yych <= 'E') goto yy1252;
		if (yych == 'e') goto yy1252;
		goto yy1220;
	}
}
#line 829 "parser/tokenizer.re"

    }
}

} // namespace LCompilers::LFortran
