# -*- coding: utf-8 -*-
### BEGIN LICENSE
# Copyright (C) 2009 Jono Bacon <jono@ubuntu.com>
# Copyright (C) 2010 Michael Budde <mbudde@gmail.com>
#
#This program is free software: you can redistribute it and/or modify it
#under the terms of the GNU General Public License version 3, as published
#by the Free Software Foundation.
#
#This program is distributed in the hope that it will be useful, but
#WITHOUT ANY WARRANTY; without even the implied warranties of
#MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
#PURPOSE.  See the GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License along
#with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import os
import gtk

from lernid.lernidconfig import get_data_path
from lernid.CouchDBPreferences import Preferences

class PreferencesLernidDialog(gtk.Dialog):
    __gtype_name__ = "PreferencesLernidDialog"

    def __init__(self):
        """__init__ - This function is typically not called directly.
        Creation of a PreferencesLernidDialog requires redeading the associated ui
        file and parsing the ui definition extrenally,
        and then calling PreferencesLernidDialog.finish_initializing().

        Use the convenience function NewPreferencesLernidDialog to create
        NewAboutLernidDialog objects.
        """
        gtk.Dialog.__init__(self)

    def finish_initializing(self, builder):
        """finish_initalizing should be called after parsing the ui definition
        and creating a AboutLernidDialog object with it in order to finish
        initializing the start of the new AboutLernidDialog instance.
        """

        self._prefs = Preferences.get()

        #get a reference to the builder and set up the signals
        self.builder = builder
        self.show_appindicator = builder.get_object('show_appindicator')
        self.use_vertical_layout = builder.get_object('vertical_layout')
        self.show_irc_time = builder.get_object('show_irc_time')

        self._load_preferences()
        self.builder.connect_signals(self)

    def _load_preferences(self):
        self.show_appindicator.set_active(self._prefs.get('show_appindicator'))
        self.use_vertical_layout.set_active(self._prefs.get('vertical'))
        self.show_irc_time.set_active(self._prefs.get('show_irc_time'))

    def ok(self, widget, data=None):
        """ok - The user has elected to save the changes.
        Called before the dialog returns gtk.RESONSE_OK from run().
        """

        self._prefs['show_appindicator'] = self.show_appindicator.get_active()
        self._prefs['vertical'] = self.use_vertical_layout.get_active()
        self._prefs['show_irc_time'] = self.show_irc_time.get_active()

        Preferences.set(self._prefs)

    def cancel(self, widget, data=None):
        """cancel - The user has elected cancel changes.
        Called before the dialog returns gtk.RESPONSE_CANCEL for run()
        """

        #restore any changes to self.__preferences here
        pass

    def restart_required(self, widget):
        self.builder.get_object('restart_required_message').show()

def NewPreferencesLernidDialog():
    """NewPreferencesLernidDialog - returns a fully instantiated
    PreferencesLernidDialog object. Use this function rather than
    creating a PreferencesLernidDialog instance directly.
    """

    #look for the ui file that describes the ui
    ui_filename = get_data_path('ui', 'PreferencesLernidDialog.ui')
    builder = gtk.Builder()
    builder.add_from_file(ui_filename)
    dialog = builder.get_object("preferences_lernid_dialog")
    dialog.finish_initializing(builder)
    return dialog

if __name__ == "__main__":
    dialog = NewPreferencesLernidDialog()
    dialog.show()
    gtk.main()

