#!/usr/bin/env python
# -*- coding: utf-8 -*-
### BEGIN LICENSE
# Copyright (C) 2009 Jono Bacon <jono@ubuntu.com>
# Copyright (C) 2010 Michael Budde <mbudde@gmail.com>
#
#This program is free software: you can redistribute it and/or modify it
#under the terms of the GNU General Public License version 3, as published
#by the Free Software Foundation.
#
#This program is distributed in the hope that it will be useful, but
#WITHOUT ANY WARRANTY; without even the implied warranties of
#MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
#PURPOSE.  See the GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License along
#with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

###################### DO NOT TOUCH THIS (HEAD TO THE SECOND PART) ######################

try:
    import DistUtilsExtra.auto
except ImportError:
    import sys
    print >> sys.stderr, 'To build lernid you need https://launchpad.net/python-distutils-extra'
    sys.exit(1)

assert DistUtilsExtra.auto.__version__ >= '2.10', 'needs DistUtilsExtra.auto >= 2.10'
import os


def update_data_path(path, oldvalue=None):

    try:
        fin = file('lernid/lernidconfig.py', 'r')
        fout = file(fin.name + '.new', 'w')

        for line in fin:
            fields = line.split(' = ') # Separate variable from value
            if fields[0] == '__lernid_data_directory__':
                # update to prefix, store oldvalue
                if not oldvalue:
                    oldvalue = fields[1]
                    line = "%s = '%s'\n" % (fields[0], path)
                else: # restore oldvalue
                    line = "%s = %s" % (fields[0], oldvalue)
            fout.write(line)

        fout.flush()
        fout.close()
        fin.close()
        os.rename(fout.name, fin.name)
    except (OSError, IOError), e:
        print ("ERROR: Can't find lernid/lernidconfig.py")
        sys.exit(1)
    return oldvalue


class InstallAndUpdateDataDirectory(DistUtilsExtra.auto.install_auto):
    def run(self):
        if self.root or self.home:
            print "WARNING: You don't use a standard --prefix installation, take care that you eventually " \
            "need to update quickly/quicklyconfig.py file to adjust __quickly_data_directory__. You can " \
            "ignore this warning if you are packaging and uses --prefix."
        previous_value = update_data_path(os.path.join(self.prefix, 'share/lernid'))
        DistUtilsExtra.auto.install_auto.run(self)
        update_data_path(self.prefix, previous_value)



##################################################################################
###################### YOU SHOULD MODIFY ONLY WHAT IS BELOW ######################
##################################################################################

DistUtilsExtra.auto.setup(
    name='lernid',
    version='0.7',
    license='GPL-3',
    author='Michael Budde',
    author_email='mbudde@gmail.com',
    description='Connect to Ubuntu learning events.',
    long_description='Lernid provides an interface for joining in Ubuntu learning events such as Ubuntu Open Week and Ubuntu Developer Week.',
    url='https://launchpad.net/lernid',
    data_files = [
        ('share/icons/hicolor/64x64/apps', ['data/icons/64/lernid.svg']),
        ('share/icons/hicolor/48x48/apps', ['data/icons/48/lernid.svg']),
        ('share/icons/hicolor/24x24/apps', ['data/icons/24/lernid.png']),
        ('share/icons/hicolor/22x22/apps', ['data/icons/22/lernid.png']),
        ('share/icons/hicolor/16x16/apps', ['data/icons/16/lernid.png'])
    ],
    cmdclass={'install': InstallAndUpdateDataDirectory}
    )

