#include "lc_global.h"
#include "lc_colors.h"
#include "lc_math.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <zlib.h>
#include "minifig.h"
#include "opengl.h"
#include "pieceinf.h"
#include "project.h"
#include "system.h"
#include "lc_library.h"
#include "lc_application.h"

// =============================================================================
// Static variables

// Settings for the 2012.2 update (from holly-wood@holly-wood.it).
static const unsigned char sDefaultSettings[] = 
{
	0x78,0x9C,0xED,0x9D,0x7B,0x73,0xE3,0xC6,0xB1,0xE8,0xFF,0xBE,0xA9,0xF2,0x77,0x40,0x78,0xEB,0x78,0x9D,0x2A,0x51,0x4B,0x02,
	0xE0,0xCB,0xC9,0x71,0x5D,0x8A,0x7A,0xDA,0x7A,0xD0,0x24,0x77,0x65,0x27,0x4E,0x6D,0x81,0x24,0x24,0x22,0x02,0x01,0x06,0x00,
	0x57,0xAB,0xD4,0xFD,0xF0,0xB7,0x7B,0x66,0xF0,0x7E,0x4D,0x43,0x5A,0xC5,0x39,0x57,0x9B,0xD8,0xD6,0x52,0xC4,0xFC,0x66,0x06,
	0x33,0x3D,0xDD,0x3D,0x3D,0x3D,0x7F,0x56,0xAE,0x2E,0x27,0xC6,0xFA,0xD0,0x72,0xAC,0x6F,0xFE,0xF0,0x67,0xE5,0xA3,0xE9,0xF9,
	0x96,0xEB,0x28,0x6A,0xA7,0xAB,0xB6,0x3B,0x2A,0x7C,0x84,0x9F,0xAA,0x9D,0x8E,0xDE,0xEE,0xF4,0xDB,0x5D,0x55,0x39,0x77,0x6D,
	0xFB,0x49,0xB9,0x75,0xDD,0xB5,0x62,0xAC,0xD7,0xE6,0x5A,0xB9,0x3C,0xF6,0x8C,0x47,0x65,0x67,0x78,0x81,0xAF,0xEC,0x77,0x6B,
	0x23,0x30,0xC5,0xD7,0xD5,0xF8,0xC9,0x01,0x3C,0xAC,0x5C,0x1A,0xAB,0xCD,0xD6,0x70,0x1C,0xE5,0xCA,0x5A,0x6D,0x0C,0xD3,0x56,
	0xCC,0xB5,0x15,0x40,0x01,0xFE,0xCA,0x70,0x14,0xD7,0x5B,0x9B,0x9E,0xE2,0x9B,0xAB,0x00,0xE8,0xF1,0x83,0xA3,0x76,0x77,0x48,
	0x40,0x6A,0xD1,0x93,0xDD,0x2E,0x50,0x09,0x4F,0xEA,0xE2,0xC9,0x1E,0xB4,0xB1,0xAD,0x75,0x65,0x9F,0xEC,0xB5,0x3B,0x5D,0xF1,
	0x64,0xBF,0xDD,0x19,0xB6,0x3B,0x3D,0x65,0x6C,0xDB,0xA6,0xA3,0xCC,0xB7,0x56,0xB0,0x51,0xEE,0xAC,0x2F,0xF0,0xE8,0x67,0xC3,
	0xB3,0xDC,0xBD,0xAF,0x2C,0xF7,0xF7,0xBE,0xF8,0xF2,0x08,0xBA,0x07,0xBF,0x2C,0x89,0x19,0xC5,0x98,0x11,0xEB,0x94,0x3E,0xE1,
	0x49,0x35,0x7A,0xB2,0xDB,0x29,0xEC,0xCE,0xB0,0x7E,0x97,0xF3,0x27,0x07,0x2A,0xED,0xE3,0xBF,0x4D,0xDF,0xF2,0xCD,0xB8,0xB6,
	0xD0,0x29,0xEA,0x88,0xC0,0x14,0x2F,0x02,0x80,0x9D,0x6E,0x5B,0xD5,0x29,0x4C,0x65,0xE5,0x99,0x06,0x8E,0x8B,0xE5,0x93,0xF2,
	0xE3,0xE1,0xE4,0x50,0x59,0xC0,0x68,0x71,0xEE,0xE3,0x02,0x71,0x24,0x4A,0x56,0x85,0xF1,0xE3,0x27,0x07,0xB4,0x27,0x45,0xC7,
	0xE1,0x50,0xEA,0xD2,0x9E,0xD4,0xE2,0x27,0x61,0x58,0x14,0x74,0x5C,0xD3,0xE6,0xE3,0xA8,0x6E,0xAB,0xB2,0xE3,0x86,0xD5,0x5C,
	0x3C,0xA9,0xB2,0x46,0x68,0x84,0x27,0xD5,0xF8,0x49,0xE8,0x72,0xD9,0x29,0xC1,0x40,0xF1,0x93,0x50,0xDB,0x82,0x69,0x18,0x3C,
	0xBA,0x8A,0x63,0x3E,0x2A,0x2B,0x78,0xE6,0xDE,0xF5,0xAC,0xBA,0x66,0xAB,0x38,0xB7,0xBA,0x1D,0x42,0x15,0xA0,0xF2,0xF8,0xBF,
	0x3F,0x2B,0xFF,0xFD,0x82,0x7F,0xB0,0xBC,0xC5,0xC6,0xF2,0x61,0x5E,0xDB,0xA6,0x02,0xFF,0x85,0x3A,0xB3,0x1A,0x33,0x11,0xAA,
	0x7C,0xD4,0x0E,0x3B,0x1D,0x90,0x64,0xCA,0xC6,0xBA,0xDF,0x98,0xDE,0xD7,0xA0,0x5F,0x5A,0x0E,0xF4,0xD5,0xD2,0xBC,0xB7,0x1C,
	0xC7,0x72,0xEE,0x95,0x47,0x94,0x32,0x7F,0x56,0x0C,0xCF,0x54,0x56,0xEE,0x76,0x6B,0x3A,0xD0,0x0F,0x87,0x87,0x87,0xF8,0xD5,
	0x93,0xED,0x2E,0x78,0x52,0x6C,0xF6,0x00,0xFE,0xDE,0xBA,0x77,0x5C,0xCF,0x5C,0xF3,0x5E,0xB9,0xB8,0x5E,0xCC,0x6E,0x8E,0x3F,
	0x4C,0x16,0x17,0x37,0xD7,0xFC,0x93,0xC5,0xC6,0x8C,0x57,0x02,0xDE,0xC0,0xC0,0xB4,0x6D,0x9F,0x7F,0xF8,0xCE,0x57,0xB6,0xF0,
	0xF9,0x9D,0x75,0xAF,0xDC,0x9B,0x8E,0xE9,0x19,0x01,0x34,0xF3,0x71,0x03,0x82,0x5C,0x74,0x3E,0x12,0x8C,0xCF,0x86,0x65,0x1B,
	0x4B,0xDB,0x3C,0xC0,0x02,0x0D,0x5F,0x79,0x84,0x02,0xF0,0xBF,0x30,0xB6,0x2D,0x4F,0xD9,0xB9,0xBE,0x85,0xD2,0x5D,0x31,0x9C,
	0xB5,0xE2,0xB9,0x81,0x81,0x7F,0x39,0xE4,0x1D,0x7A,0x6F,0x7D,0x86,0x6A,0x3E,0xB9,0x7B,0xE5,0x6E,0x0F,0xCF,0xEC,0xDC,0x47,
	0x58,0x0D,0xDC,0xCF,0xF0,0x2F,0x78,0x16,0x4B,0xF3,0x4D,0x1B,0xD6,0x06,0x2C,0x5C,0x81,0x9F,0x58,0x43,0x0F,0x40,0xA0,0x06,
	0x8A,0x61,0xFB,0xAE,0xB2,0x35,0x0D,0x07,0x31,0x46,0x80,0xDF,0x57,0x60,0xE8,0x78,0x81,0xB2,0x41,0xB2,0x0B,0x9D,0x25,0x46,
	0xC6,0x5A,0x31,0xA1,0xC0,0x27,0x2C,0x2D,0xB0,0xB6,0xA6,0x18,0x3B,0x1E,0x14,0x67,0xE0,0xBC,0x33,0xD8,0x88,0x4C,0x0D,0xA5,
	0x95,0xEB,0x04,0x86,0xC5,0x3A,0x3A,0x6C,0x3D,0xFB,0xFD,0xA1,0xF2,0x2B,0xD4,0x14,0x97,0x2D,0x18,0x85,0xAC,0x3C,0x80,0xB2,
	0xF1,0xEC,0xAE,0x4D,0x1C,0x0F,0xD0,0x10,0x0F,0x6A,0x7C,0x77,0x80,0xA3,0xE1,0x1F,0x7B,0x3F,0x50,0xD6,0xEE,0xA3,0x63,0xBB,
	0x30,0x48,0xF0,0xAB,0x61,0x7D,0x58,0x2F,0xDF,0x79,0xEE,0x16,0xCB,0x78,0x7C,0x7C,0x3C,0xDC,0xE0,0xF8,0x6E,0x3F,0xC2,0xF8,
	0x3E,0xB4,0x82,0xF7,0x5B,0x7B,0x65,0xAC,0xDB,0xA6,0x73,0xB8,0x09,0xB6,0xF6,0xA1,0x72,0x0B,0xEF,0xDA,0x02,0xA4,0x72,0x07,
	0xA4,0xB5,0xF1,0x84,0x55,0x2E,0x18,0xFF,0xD0,0x6C,0x2C,0x6E,0x69,0xC2,0x2A,0x24,0x1A,0xC7,0xA9,0x8C,0xF6,0x68,0x41,0xF7,
	0xB2,0x2E,0xC1,0xBE,0xC1,0x07,0x0E,0xD9,0xAB,0x77,0xF6,0xDB,0x25,0x2C,0xFD,0x0A,0x00,0xC2,0xEF,0x3A,0x06,0x74,0x92,0x67,
	0xDE,0xF1,0x91,0x0C,0xDF,0x8E,0xAB,0x7E,0x10,0x17,0xE8,0x07,0xD6,0xEA,0x01,0x3B,0x9A,0x0D,0xBA,0xF1,0x7A,0xCD,0xDE,0xB1,
	0x81,0xF3,0x34,0xFA,0xCE,0xDA,0xBC,0x63,0xC3,0x10,0x3F,0xE0,0x0B,0xBD,0x7B,0xC7,0x96,0x7D,0x07,0x3B,0xC1,0xB5,0xD7,0x48,
	0x5E,0xEF,0x3D,0xEC,0x68,0xFC,0x8E,0x6D,0xEC,0x9D,0xD5,0x06,0xCB,0x83,0xEF,0xE1,0x07,0x3B,0xCF,0xBD,0xF7,0x8C,0x6D,0x66,
	0x4C,0xC1,0xA0,0x08,0x02,0x78,0x06,0xE6,0xA3,0xEB,0x85,0xDF,0xDB,0x41,0xE9,0x96,0x13,0xC0,0x10,0x65,0xAA,0x04,0x9F,0x21,
	0x5C,0xCC,0x1E,0x2A,0x7C,0xA8,0x5F,0x5D,0x5C,0x5F,0x9C,0x5E,0x9C,0x7D,0x98,0x9D,0x28,0x67,0x27,0xD7,0x27,0xB3,0xF1,0xE2,
	0x66,0xA6,0xCC,0x4F,0xD8,0x64,0xF8,0x3E,0x9A,0x0D,0x1E,0x9B,0xE1,0xAE,0x63,0x86,0x5A,0x89,0x82,0x45,0x87,0xE3,0x40,0x0C,
	0xC2,0xC3,0x70,0xEA,0x84,0xDF,0xC1,0x4E,0xE3,0xB3,0x01,0x54,0x9D,0x35,0x4E,0x93,0x27,0xA5,0xAD,0x58,0xAC,0x19,0x4F,0xFC,
	0x73,0xCB,0xF7,0xB1,0xA1,0x38,0x81,0x3C,0x17,0x7E,0xE0,0xC2,0x63,0x2F,0x96,0x5B,0x83,0xD7,0x1E,0x7A,0x10,0xBB,0xCD,0xD8,
	0xDB,0x01,0x7C,0xE0,0x07,0x20,0x68,0x0E,0xC4,0x84,0x83,0x5A,0xAD,0xAD,0x3B,0x78,0x2D,0xC0,0x67,0xA3,0x87,0x8F,0x79,0x18,
	0xAB,0xF8,0x01,0x56,0xFC,0x8F,0x6C,0xFE,0x83,0xBA,0xC5,0xA6,0x3F,0x9F,0x08,0xF8,0x2E,0x60,0x74,0xB9,0x8F,0xC8,0x86,0xFE,
	0xDA,0x1A,0xC1,0xF7,0xF8,0xB5,0xD6,0x5F,0x8E,0x2D,0x7F,0x67,0x1B,0x4F,0xAC,0xEA,0x3F,0xB4,0xF0,0x83,0xF1,0xE2,0xFD,0xE5,
	0xF1,0x8C,0xBF,0x3B,0xF1,0xE9,0x5F,0x4E,0x6D,0xE3,0xDE,0xFF,0x41,0xF9,0xCB,0x95,0x11,0x78,0xD6,0x17,0xF8,0xE1,0xE6,0xEE,
	0x0E,0xFA,0xFF,0x07,0x2C,0x23,0x5D,0x04,0x1F,0x4F,0x38,0x78,0xC4,0xDB,0x13,0x7D,0x85,0x6F,0xCD,0x0A,0x78,0xF5,0xD9,0xD7,
	0xE1,0xE5,0x8B,0xE1,0x26,0xBE,0x81,0x65,0x65,0xFE,0xD8,0x96,0x1F,0x70,0x44,0xAE,0x52,0x8C,0x13,0xFD,0x35,0x0B,0x83,0xEE,
	0x6D,0xB5,0xD8,0xC0,0xD8,0x58,0xB0,0x54,0x38,0x49,0x46,0xD8,0x18,0xC3,0x7E,0xC4,0x69,0xD4,0x81,0x51,0xEE,0x9B,0xDE,0x67,
	0x36,0x18,0x3D,0x90,0x40,0xC1,0x1E,0xDE,0x13,0xBC,0x10,0xF6,0xDD,0xB0,0xC1,0x46,0x24,0xB3,0xE0,0xD5,0xE2,0x47,0x8A,0xD1,
	0xED,0xC2,0x3F,0x2A,0xFC,0xA3,0xA1,0xD0,0x55,0x0C,0x4D,0x63,0x05,0xB8,0x3B,0x90,0x2F,0xF0,0xFE,0x8C,0xDD,0xCE,0x34,0x3C,
	0xC3,0x59,0x81,0x68,0x4C,0xB7,0xAD,0x03,0xEF,0xF6,0xDE,0x33,0xCD,0xB8,0x48,0x58,0xEB,0x6C,0xCE,0x13,0xFD,0xCA,0x5A,0xE7,
	0xB2,0x9F,0xA3,0x59,0x80,0x52,0x8D,0x4B,0x34,0xE8,0x37,0xE8,0xC1,0x95,0xF9,0xB5,0xD6,0x38,0xE8,0x8F,0x70,0x48,0xF3,0xD1,
	0x9C,0x5B,0xE9,0xBA,0x5F,0x75,0xA5,0xC3,0x12,0xE7,0x93,0xF1,0xB5,0x72,0x33,0x3B,0x3E,0x29,0x98,0x9C,0x20,0x03,0x0D,0xF6,
	0x96,0x70,0x6C,0x33,0x51,0x17,0x6C,0xDC,0xFD,0xFD,0x86,0xF5,0x8F,0xE5,0xAC,0xEC,0x3D,0x08,0xE2,0xBD,0x03,0xFD,0x67,0xAD,
	0x2C,0x7C,0x15,0xB0,0xE4,0xAC,0x40,0x0E,0x73,0x51,0xCB,0xE5,0x25,0xCC,0x33,0x97,0xB7,0xE7,0x80,0x49,0x09,0x77,0x1F,0x08,
	0x41,0x8E,0x02,0x13,0x16,0x15,0x78,0xC5,0xF0,0xF7,0x2D,0x17,0x21,0x01,0x7F,0x1D,0xBC,0x38,0x26,0x76,0x93,0x25,0xB1,0x5F,
	0xFF,0x36,0x1D,0xCF,0x16,0x73,0xC6,0xFA,0x6D,0x1A,0xCA,0xB5,0x43,0x05,0x46,0x2E,0x1B,0xA6,0x28,0xA6,0xF6,0x4E,0x34,0xE6,
	0x99,0xD9,0x83,0xE2,0x98,0x4B,0xEB,0xB0,0xD6,0xD1,0xEF,0x79,0xD1,0xB6,0xB5,0xF4,0x0C,0x90,0x21,0x58,0x68,0x1B,0x46,0xCD,
	0xCE,0x74,0xD6,0x4C,0x7A,0x08,0x39,0x0D,0x03,0x19,0x3E,0xF7,0x37,0xEE,0x23,0x8A,0x74,0xCB,0x09,0x57,0x23,0xFE,0x74,0x80,
	0x63,0x2C,0x59,0x04,0xFF,0x78,0xE7,0x99,0x9F,0x2D,0x58,0x44,0x40,0x16,0xC0,0xBA,0xC4,0x65,0x98,0xF1,0x00,0x2D,0x77,0x41,
	0x98,0x9B,0xE1,0x3A,0x8A,0x7A,0x8E,0xE8,0x65,0xF8,0xF1,0xFA,0x66,0xA1,0x98,0xFF,0xDC,0x43,0xE3,0xC5,0x4A,0xD0,0x3A,0xC5,
	0xA9,0xF7,0x83,0x32,0xC7,0x76,0x4C,0xB1,0xDC,0x16,0xD3,0x41,0x00,0xC3,0xE4,0x98,0xC3,0x56,0x1D,0x58,0x3F,0x40,0xEB,0xE0,
	0xCB,0x0E,0x16,0xE1,0x99,0x8F,0x1E,0x58,0x7D,0xAC,0x04,0xF6,0xD0,0xA1,0x0D,0xAB,0x23,0x76,0xCF,0xA1,0x72,0x83,0xDF,0x17,
	0x4B,0x5A,0xE0,0xBA,0xA0,0x7B,0x44,0xED,0x65,0x6B,0x81,0x53,0xF0,0x14,0xBC,0x25,0x7C,0xEB,0x50,0x73,0x28,0x7A,0xE5,0xDE,
	0x3B,0xA0,0x43,0x2B,0x28,0x27,0x60,0x70,0x5E,0x4D,0x8F,0x45,0xC7,0x27,0x16,0x72,0x7F,0xCF,0x57,0x96,0x96,0xF9,0x85,0x8B,
	0xD9,0x16,0xEF,0x94,0x3F,0x2A,0x91,0x28,0x0F,0xE0,0xEF,0x6D,0xE8,0x4D,0x98,0x76,0x7C,0xB8,0x87,0x8B,0xA6,0x0F,0xE2,0x13,
	0x5E,0x10,0xAE,0xE5,0xF9,0x57,0xC1,0x57,0x50,0x78,0x08,0xCB,0x09,0x17,0x35,0xEC,0x05,0x7F,0xBF,0x0C,0xFF,0xCA,0x27,0xAF,
	0x58,0xF9,0xF8,0xC2,0x8B,0xAA,0xBF,0xF1,0x05,0xBE,0xB4,0xDB,0xB9,0xF8,0x6E,0xB0,0x5A,0x0E,0x0E,0x83,0xF1,0x7C,0x72,0x71,
	0xD1,0x46,0x8D,0xE2,0x10,0x24,0x86,0x30,0xC4,0xA1,0x0B,0x4F,0xFE,0x18,0xA9,0xA1,0x16,0xAA,0x00,0x81,0xB9,0x85,0x27,0xF1,
	0x05,0xFB,0xAE,0xBD,0x67,0xC2,0x64,0xEF,0x04,0x96,0x18,0xA4,0x87,0xAE,0x77,0xCF,0x26,0x89,0x81,0xF2,0x66,0x8D,0x95,0x35,
	0x98,0x62,0x65,0xF0,0x81,0x17,0x3E,0x13,0x2E,0x2E,0xAC,0xA9,0x7C,0x19,0x85,0x15,0x9C,0x2F,0xDC,0xD8,0x3C,0x1F,0xFF,0xCD,
	0xD6,0x5A,0x18,0x9E,0xF1,0xF2,0x13,0xEA,0x8A,0x87,0x61,0x05,0xE7,0x01,0x1B,0x61,0x6C,0xCA,0xFC,0x0D,0x67,0xF0,0x27,0x36,
	0x83,0xFF,0xCE,0x06,0xD9,0x8D,0x63,0xF2,0x15,0x09,0x57,0xD2,0xB5,0x05,0x2F,0x8C,0xAD,0x8F,0xD0,0x2B,0xD8,0x25,0xD1,0x5A,
	0xCA,0x57,0x27,0xEC,0x7E,0x83,0x7F,0xDD,0xF2,0xBF,0x57,0x1C,0xE5,0xBF,0x95,0xBF,0xCC,0xCF,0x6F,0x6E,0xFF,0xEF,0xF9,0xC5,
	0xF1,0xC9,0x0F,0xCA,0xDF,0xFE,0x02,0x6F,0x79,0x7C,0x7B,0x7C,0x31,0xFB,0xE1,0xEF,0x7F,0x6B,0xFD,0x7D,0x6A,0x04,0x1B,0x5C,
	0x06,0xE0,0x47,0x56,0x0D,0xF8,0x22,0xCA,0x64,0xF6,0x07,0x34,0x27,0x68,0x94,0x58,0x74,0x12,0xB3,0x23,0x9C,0x8E,0xBE,0xB5,
	0x36,0xF9,0x78,0x8F,0xEB,0xC4,0x27,0x61,0x7E,0x41,0xC2,0x27,0xDB,0x89,0x19,0xF5,0x1E,0xC6,0x19,0xFB,0x2C,0x3D,0xA7,0xF0,
	0x41,0xAC,0x67,0xA6,0x0E,0x38,0x03,0xD8,0x5C,0x7D,0xB5,0x4A,0xC4,0xBD,0x04,0x55,0x51,0x1E,0xCC,0xA7,0x47,0x50,0xC0,0xB8,
	0x90,0x5C,0x5B,0x68,0x7E,0xA1,0x8E,0x08,0x4B,0xD0,0x67,0xAC,0x4F,0xB0,0xF1,0x41,0x98,0xB0,0x4A,0xC4,0xCA,0xB3,0xBF,0x33,
	0x57,0xA0,0xF2,0x98,0x6B,0xF6,0x52,0xA1,0xCC,0xFF,0xF5,0xBF,0xB0,0xF6,0x00,0x5F,0x3D,0x98,0xD0,0x80,0xBF,0x28,0x4C,0x07,
	0x08,0x5F,0x00,0x6B,0xB1,0x32,0xDF,0x2F,0x93,0xCD,0x60,0x8D,0xB3,0xD7,0x38,0xB1,0x97,0xA0,0x8F,0x32,0x14,0xCE,0x50,0x63,
	0xC9,0xC6,0x9F,0xF8,0x80,0x4B,0x40,0x31,0xDB,0xD3,0x7F,0xD6,0x1E,0xD6,0x10,0xCB,0x3F,0x54,0xAE,0xDD,0x40,0xC8,0x28,0x50,
	0xAB,0x50,0xD3,0x8E,0xB5,0x55,0x31,0xCF,0x7D,0xA8,0x34,0x2C,0x8E,0x3E,0x57,0x53,0x61,0x9C,0x42,0x55,0xF2,0x65,0x46,0x4F,
	0x6D,0x51,0x41,0x5F,0xE2,0x17,0x57,0xB6,0xEB,0x73,0x09,0xBC,0x76,0xF7,0x68,0x6B,0xFC,0x73,0x0F,0x30,0x90,0xE1,0xDF,0x85,
	0xF3,0x0D,0x84,0x03,0xA8,0x75,0x1E,0xD3,0x14,0xF2,0x45,0x1A,0x0E,0x58,0xA7,0xAC,0xEF,0xFD,0x50,0x16,0xF2,0x11,0xCC,0xE6,
	0x83,0x8D,0xDA,0x5E,0x48,0xF5,0xFF,0x24,0x66,0xCC,0x6F,0xD3,0x83,0xD4,0xCA,0x71,0x75,0x73,0x7C,0x72,0x39,0xCF,0xA8,0x90,
	0xFC,0xDD,0xE0,0xEF,0x99,0xA1,0xC5,0xF5,0x96,0x1D,0xAA,0x2D,0x30,0x09,0xC1,0xAC,0x71,0xB0,0x2F,0x40,0x08,0xB2,0x29,0x1D,
	0xBE,0xB0,0x43,0xE5,0x82,0x7D,0x08,0xD3,0x78,0x65,0xC3,0x73,0x28,0x90,0xA1,0x7D,0xB1,0x38,0x83,0x49,0x07,0x1F,0x42,0x47,
	0xDA,0x86,0x1F,0x44,0x53,0xF8,0x82,0x6B,0x1B,0xE1,0x58,0x49,0x8C,0x20,0xD4,0x87,0xB7,0x5B,0x2B,0x08,0x84,0x45,0xC1,0xDF,
	0x1A,0xD4,0xCB,0xF7,0xF7,0x5B,0xBE,0x68,0x42,0xB1,0x68,0x16,0x25,0xDF,0xEB,0xA1,0x28,0xF7,0xE4,0x8B,0xB1,0xDD,0xD9,0xE6,
	0xF7,0xE2,0xAF,0x49,0xE9,0x80,0x7F,0xEF,0xC2,0x04,0x67,0x53,0x66,0xCA,0x8C,0xFE,0xF0,0x6F,0x31,0xFE,0x43,0xB4,0x9C,0xFF,
	0xC6,0xBE,0xA2,0xC1,0x57,0xD8,0x3C,0x2F,0xFE,0x0A,0xCE,0x2E,0xFC,0x9A,0x9E,0xFF,0xDA,0xD5,0xD3,0xA7,0xE8,0xD7,0xBD,0xFC,
	0xAF,0x5B,0xE3,0x3D,0x74,0x14,0x5A,0x23,0xBF,0xDD,0xBA,0xDE,0x03,0x53,0xB6,0xD0,0x00,0x31,0x7D,0xBF,0x85,0x8F,0xF4,0xC3,
	0x47,0x8E,0xBF,0xFF,0xCD,0x77,0xA1,0xE1,0x96,0xC7,0xFE,0x0B,0x82,0x3E,0xF4,0x3A,0x5C,0xCE,0x7F,0xBD,0x5E,0x9C,0x2B,0xC7,
	0x27,0xA7,0x60,0x6B,0xA0,0xEA,0x32,0xE7,0x9F,0xCF,0xCC,0x7B,0x18,0x3C,0xB0,0x24,0xF9,0xA1,0x52,0x17,0xD9,0x43,0x01,0x5F,
	0x7A,0x02,0x6E,0xDC,0x86,0x5A,0x40,0xC2,0x1A,0x67,0x4A,0xFE,0x76,0x09,0x7D,0xEC,0x7E,0x89,0x14,0x07,0x1F,0x16,0x0D,0x85,
	0x0F,0x33,0x3F,0xE0,0xEA,0x0A,0xDA,0x88,0xF6,0x6E,0x63,0x2C,0x4D,0x58,0xCD,0x61,0xBD,0x66,0x84,0xC3,0x22,0xF9,0xCC,0x6B,
	0xC9,0x65,0xF3,0x7F,0x4D,0xC7,0x50,0x61,0x90,0xB1,0xEC,0xA5,0x72,0x05,0xFB,0x30,0xFE,0xA3,0x1C,0x27,0x6C,0xB8,0xF4,0xB4,
	0x85,0xB7,0xCE,0xED,0xAB,0x02,0xF5,0x3D,0xF7,0x87,0x2D,0x60,0xCA,0x77,0x28,0x08,0x99,0x14,0x61,0xAB,0x89,0x10,0x14,0x7F,
	0xFC,0x53,0x7E,0x05,0xE0,0x66,0x5E,0x64,0xFB,0x27,0x27,0x95,0xCF,0xD6,0x85,0xBF,0x2C,0x2E,0x16,0x97,0xB0,0x1E,0x40,0xCD,
	0x27,0x37,0x57,0x57,0xE3,0xEB,0x63,0x65,0xBE,0x98,0x5D,0x5C,0x9F,0xFD,0xC0,0x17,0x74,0xFC,0x6D,0xAA,0x21,0x91,0x75,0x92,
	0xB3,0x42,0xE2,0xDE,0x15,0xE0,0x16,0x98,0xB3,0xA1,0x8B,0x6E,0xC2,0xC9,0xAD,0xE2,0x46,0xAE,0x61,0xC8,0xB9,0xF7,0xAC,0x23,
	0xD3,0xB5,0x50,0x04,0x31,0xAC,0xB8,0x98,0x22,0xDC,0x0B,0xE6,0x86,0x46,0xEB,0x3F,0xA0,0x7D,0x87,0xCA,0x94,0x19,0xEB,0xDC,
	0xE4,0x86,0x5F,0x16,0x93,0x78,0x75,0x60,0x95,0x70,0x57,0x7B,0x1C,0x29,0xDC,0x7C,0x40,0xB3,0xC3,0x80,0x79,0x6E,0x72,0xF3,
	0xD7,0x47,0xA5,0xA8,0x6C,0xDE,0x89,0xB7,0x9E,0x7C,0xE9,0xAD,0xC9,0xF7,0xBF,0x4D,0xB9,0x8D,0xED,0xFF,0xC6,0x09,0xAC,0xA1,
	0x9D,0x2E,0xAC,0x07,0x27,0x97,0xA0,0x7D,0xCF,0x2E,0x26,0x9F,0xAE,0x7F,0x59,0x7C,0x9A,0x8C,0x8F,0xA0,0x3F,0xF3,0x7F,0x60,
	0x46,0xB0,0x11,0x7F,0x74,0x72,0x76,0x71,0x5D,0xF4,0x48,0xB7,0xCF,0x0A,0x54,0x93,0x05,0x4E,0x6F,0x6E,0x4F,0x66,0x9F,0x4E,
	0x3F,0x5C,0x33,0xED,0x7E,0x9E,0x2A,0xBC,0xA4,0xC0,0xE2,0x47,0x44,0xE1,0x5A,0xB2,0xF0,0xD9,0xE4,0x17,0x6A,0x6D,0xE3,0x47,
	0x44,0x81,0x3A,0x14,0x78,0x7A,0x71,0x04,0xC4,0x9B,0xE9,0xE2,0x62,0x32,0x97,0x2C,0xB0,0xE0,0x11,0x2C,0x50,0x98,0x35,0x1F,
	0xA6,0xD3,0x9B,0xD9,0x42,0xD8,0x32,0xA7,0xA6,0x69,0x83,0x11,0x0F,0x6A,0x3A,0x5A,0x1C,0x2E,0x68,0x56,0xB1,0xDF,0x84,0x3B,
	0xB8,0x2E,0x40,0xBC,0x3E,0x30,0xD7,0x18,0xEA,0x49,0xA0,0x1B,0x2A,0x30,0x76,0x0D,0x18,0x50,0xBB,0x27,0x1C,0xA7,0x56,0x20,
	0xBC,0x33,0x38,0xAC,0x70,0x8A,0xA0,0x5B,0x07,0x64,0x81,0x67,0x2D,0x71,0x86,0x5A,0xCC,0x22,0x72,0x99,0x66,0x0D,0x16,0x2D,
	0xAA,0xA4,0xDC,0x87,0x02,0x6B,0x34,0x96,0x05,0xC5,0xA0,0xF7,0x95,0x8F,0xB6,0xD8,0xFD,0xF4,0x7F,0x52,0x9E,0x28,0x2E,0x2E,
	0x80,0x09,0x4A,0x23,0xD7,0xA1,0x97,0xA9,0x11,0xBB,0x76,0xD9,0x32,0xE3,0xC7,0x05,0x62,0x69,0xB0,0x22,0xED,0x99,0xA7,0x23,
	0x61,0x87,0x31,0x9D,0xE7,0x40,0x38,0xED,0xD0,0xE4,0xF0,0xD1,0xBC,0xC0,0xC6,0x19,0xCC,0xE4,0x8E,0x3D,0x40,0xB0,0xEC,0x06,
	0xEC,0xEB,0x58,0x14,0xD7,0x75,0xB0,0xA2,0xCC,0xDF,0x81,0xAE,0xB2,0x48,0xBB,0x3D,0xE4,0x1D,0x39,0x9E,0xFC,0x74,0x7D,0x73,
	0x7B,0x79,0x72,0x7C,0x76,0x72,0x75,0x72,0xBD,0x98,0x47,0xB6,0xE2,0x17,0xEC,0x80,0xEF,0x0A,0x85,0xE2,0x9F,0xA2,0xAD,0xA8,
	0x73,0x13,0x34,0x14,0xDC,0x9C,0x3A,0x88,0x3E,0x0A,0xB7,0xAB,0x0E,0x92,0xFE,0x68,0x26,0x6A,0xC7,0xCE,0x1A,0xCC,0x18,0xE5,
	0x16,0x6A,0xE8,0x41,0x3D,0xF9,0x8B,0xFD,0xE6,0x0F,0x7F,0x3B,0x1F,0x2F,0xE6,0x30,0xAD,0x5A,0x13,0x63,0xD7,0xAA,0x15,0x84,
	0xC5,0x7F,0x5A,0xBA,0x3E,0xEC,0x1D,0x82,0xC5,0x98,0x28,0xA0,0x03,0xFF,0x74,0xE1,0xDF,0xF8,0xBF,0xF8,0xBF,0xFC,0x07,0x4E,
	0x53,0xC6,0x9F,0x2D,0xD4,0x13,0xA8,0xD4,0x96,0xD6,0xE9,0x0E,0xBA,0x69,0x5C,0x2D,0xCD,0x0F,0x60,0x90,0x9D,0x9B,0xF6,0xD6,
	0x14,0xE3,0x62,0x02,0x76,0x41,0xFB,0x6C,0x0F,0xEB,0x5A,0x35,0xBF,0xA5,0x0D,0x47,0x7D,0x6A,0xDB,0x72,0xB4,0x6B,0x73,0xF5,
	0xA0,0x80,0xAC,0x0A,0xD8,0x9A,0x51,0x4E,0x04,0x9A,0xAE,0x13,0x69,0xAE,0x03,0x6F,0x74,0xCF,0x1D,0x79,0x9C,0x29,0xDB,0xA3,
	0x40,0xD3,0x34,0x2A,0xCD,0x7D,0x78,0xE7,0x2B,0xE7,0x86,0x34,0x24,0x49,0x1B,0x0D,0x0F,0xD7,0xA9,0x27,0x6B,0x68,0xA7,0xB0,
	0xC8,0x12,0xDB,0x94,0x6C,0x1B,0xB1,0x27,0x13,0x34,0xFE,0xD6,0xD8,0x07,0x97,0xEE,0xBD,0xAB,0xCC,0x37,0x96,0x69,0xAF,0xD1,
	0x5C,0x40,0xF3,0x3B,0x5F,0x17,0x46,0xDB,0x75,0x52,0xA3,0xB2,0x8E,0xE6,0x82,0x6A,0x16,0xC0,0x5C,0x55,0xC8,0x33,0xAF,0x35,
	0x18,0x64,0xA7,0x1B,0x89,0xC6,0x5B,0x37,0xDF,0x82,0x60,0x04,0x61,0x08,0x0B,0xB2,0xF2,0xDD,0x1C,0x54,0xC7,0x60,0xB5,0x0F,
	0xFE,0x54,0xD0,0x36,0xA0,0xAD,0xD2,0x4D,0xAB,0xA3,0x9D,0x81,0xC6,0x1E,0x40,0xA7,0x79,0xEE,0xBE,0x66,0x7A,0xE5,0x69,0x6A,
	0x6F,0x38,0xA4,0xBD,0xB7,0x73,0xC3,0xF2,0x60,0x49,0x82,0xE6,0x08,0x93,0x65,0x6A,0xDD,0x83,0x41,0x65,0xFB,0xF5,0xE8,0x96,
	0xD6,0x57,0x89,0x92,0x8B,0xD1,0x2E,0x7C,0x1B,0x64,0xAA,0x49,0x94,0x5D,0xAD,0x7E,0xA7,0x11,0xED,0x0A,0x5A,0x46,0x97,0xCD,
	0x2D,0x6D,0x94,0x79,0x6B,0x72,0xB4,0x4B,0x34,0xF8,0xE6,0xB0,0x48,0xA0,0x3A,0x26,0x8D,0x6D,0xE9,0x1D,0x55,0x1B,0xA5,0xA7,
	0xB7,0x34,0x8D,0xCF,0x36,0x0F,0x4C,0xD9,0x8D,0x72,0x04,0xE0,0xDA,0x41,0xD3,0xEA,0x8D,0xB4,0xBE,0x46,0x5A,0x03,0x32,0xB4,
	0x73,0xD3,0x58,0x2F,0x51,0x35,0x96,0xEA,0xC9,0x4E,0xB7,0xAB,0xBF,0x04,0x8D,0xAD,0xC4,0xA7,0xA6,0x81,0x9A,0x8D,0x5F,0x32,
	0xEB,0x38,0x6D,0x92,0x7A,0x77,0xD2,0xB4,0x5B,0xE3,0xF3,0x13,0x69,0xA8,0xE0,0x7B,0xEB,0xD1,0x56,0x53,0x46,0x9B,0xBA,0xCE,
	0x13,0x4E,0x32,0xF2,0x0C,0x18,0x69,0x46,0x73,0x9A,0xD8,0x18,0xC3,0x96,0x1E,0x81,0x62,0x53,0x33,0xC3,0x5B,0x7D,0xB5,0x9F,
	0x5D,0xBC,0xA5,0x68,0x7B,0xDB,0x06,0x4B,0xE7,0xC8,0x58,0x3D,0x10,0x9A,0xD7,0x1A,0xA9,0x83,0x5E,0x03,0x1A,0x0C,0x82,0x3D,
	0x3A,0x5A,0x95,0x4B,0xD3,0xB9,0x07,0x13,0x46,0x92,0xA6,0xF7,0xB4,0x4E,0x83,0xD9,0x3D,0xDF,0x59,0x0F,0x4F,0xAC,0x07,0x29,
	0x6F,0xAE,0xD5,0xD3,0x46,0x43,0x95,0x3E,0xBB,0x39,0x8D,0x0D,0x73,0x4A,0x4F,0x22,0xAD,0x4B,0xA7,0xB1,0xC1,0xB1,0x78,0x74,
	0x95,0xA3,0xBD,0x23,0x21,0xFC,0x43,0x9A,0xD6,0xD1,0x3B,0x23,0xE2,0x7B,0x0B,0x94,0x23,0x6B,0xE5,0x7A,0x0E,0x59,0x2E,0xC3,
	0xFA,0xA6,0x92,0xD7,0xB7,0x88,0xC6,0x9B,0x78,0xF2,0x19,0x66,0xC2,0xFC,0x01,0x63,0x0E,0x50,0x9E,0x4C,0x3C,0xD7,0xF7,0x97,
	0x2E,0xFA,0x16,0xB2,0x0A,0x0A,0xA3,0x4D,0xD3,0x03,0xA5,0x9A,0x86,0xE6,0xC7,0x87,0x4C,0x4C,0x0A,0xAF,0x81,0xFB,0x68,0x53,
	0x17,0x3C,0xAC,0xC1,0xA8,0xD7,0x1F,0x50,0x65,0x67,0x48,0xE3,0xCD,0x9D,0xC1,0x5C,0x3C,0xB5,0x59,0x70,0x05,0xFB,0xFB,0xAF,
	0x26,0xEE,0x08,0x2B,0x13,0xD3,0x09,0x3C,0x33,0xDD,0x64,0x4E,0x9B,0xD2,0x64,0x67,0xA0,0x80,0x0E,0xCD,0xEC,0xAB,0xB1,0x6F,
	0x19,0x05,0xDA,0x5D,0x79,0xDB,0xB4,0x4E,0x8F,0x34,0x72,0x22,0xDE,0xE3,0xD2,0xA5,0xC9,0x69,0xC6,0x03,0x6D,0x65,0x44,0x1F,
	0x3B,0x9C,0x26,0xCC,0x1E,0xE3,0xB3,0x61,0x7B,0x4F,0x5C,0xAB,0x2D,0x55,0x67,0x63,0xDA,0xF4,0x96,0xA2,0xD3,0x66,0x69,0x73,
	0xCB,0xC6,0x68,0x18,0x74,0xDF,0xD5,0xC0,0x42,0x9A,0x4A,0xA5,0x79,0xEE,0x23,0xE1,0x8D,0x45,0xB4,0x41,0xB7,0xD3,0xED,0x91,
	0x47,0xE5,0xC5,0x76,0x67,0x7A,0xE8,0x11,0x60,0x86,0x23,0xC8,0x35,0xE3,0xC1,0x95,0x80,0xC3,0x2C,0xD4,0x69,0x7A,0x5F,0xE9,
	0x2C,0x3C,0x35,0xD7,0xAE,0x67,0xD0,0x47,0x4E,0xBF,0xDB,0xEB,0x90,0xD6,0xA6,0x88,0xF7,0xAF,0x26,0x5E,0x81,0xD6,0xB0,0x37,
	0x02,0x1B,0x45,0x4E,0x82,0xB7,0xBB,0x7A,0xD4,0xC3,0x3F,0x99,0x3B,0xAB,0x01,0x10,0x75,0x26,0x4D,0x96,0x17,0xBF,0xCF,0x9F,
	0x1C,0x2B,0xA0,0x9B,0x5F,0xB0,0xF6,0x76,0xB5,0xAC,0x71,0x29,0x41,0x9B,0x19,0xA4,0x35,0x37,0xA2,0xC1,0xE8,0x21,0x5A,0xE9,
	0x48,0x5B,0x78,0x8D,0x16,0x28,0xA4,0x11,0xED,0xE6,0x24,0x4D,0x18,0x60,0xB5,0x46,0x65,0x92,0x36,0x21,0xD9,0xCD,0x48,0xBB,
	0xC5,0x9D,0xB9,0x23,0xCF,0xDA,0xC2,0xBA,0x40,0xF0,0x44,0xE0,0x28,0xE9,0x0F,0x68,0xEF,0x0D,0x14,0xF7,0x35,0xEE,0xA1,0x80,
	0x36,0x88,0xE6,0x33,0x49,0x8B,0xE9,0x0D,0x3A,0xC4,0x51,0x12,0xD1,0xCE,0x5D,0x6F,0x2F,0xAF,0xC2,0x28,0x6C,0x2D,0x52,0x75,
	0xA2,0x16,0x93,0xA6,0x09,0xDD,0xE2,0xC9,0xAC,0x13,0xD5,0x11,0x6D,0xFA,0x73,0x87,0xB0,0xCE,0x46,0xB4,0x6B,0x13,0xA3,0xCD,
	0x16,0x4F,0x3B,0x53,0xE9,0x4A,0x35,0x91,0xBD,0xB7,0x61,0xC3,0xB6,0x25,0x68,0xAA,0x1C,0x6D,0xD4,0xD1,0xFB,0xEA,0xB3,0x68,
	0xAC,0x27,0x55,0xE5,0xD8,0xF0,0x1E,0x96,0xF6,0xDE,0x54,0xE6,0x8E,0xF1,0x50,0xA0,0x9D,0xC5,0xB4,0x67,0xF5,0x24,0xA3,0xC5,
	0xAC,0xC0,0xB3,0x76,0x25,0xB0,0x88,0x46,0xD1,0x8F,0x22,0xDA,0xFC,0x56,0xF9,0xAB,0xB1,0xF4,0x8C,0x07,0x1C,0x2F,0x32,0x0A,
	0x36,0x5A,0x44,0x7D,0xA2,0x6D,0x19,0xD1,0x16,0x7B,0x6F,0x49,0x9B,0x6F,0xE8,0x81,0x20,0xAE,0xE9,0x11,0xED,0xD6,0xF4,0xCC,
	0x47,0xD7,0xBE,0x23,0xF8,0x3B,0x54,0x3D,0x2B,0x96,0x6B,0x69,0xCC,0xB5,0x38,0xF6,0xB6,0x64,0xD5,0xAF,0x35,0x1C,0x8C,0x46,
	0xD4,0x19,0x10,0xD1,0xF8,0x08,0xB9,0xDD,0x60,0x08,0xD3,0x3C,0x30,0x9D,0x15,0x98,0x0F,0xCC,0x68,0x28,0x99,0xE9,0x9C,0xB6,
	0x23,0x69,0xD1,0x82,0x66,0x5B,0x78,0x8C,0x84,0x99,0x26,0xDC,0xA9,0x23,0x61,0xA5,0x83,0xAE,0x90,0x55,0x8F,0x9A,0x68,0x47,
	0xBC,0x06,0x4D,0xB6,0x31,0x5A,0xFD,0xCE,0x40,0x27,0xF5,0x6E,0x8A,0x27,0xBA,0xD7,0xAA,0x6D,0x69,0x8A,0x47,0x5D,0x87,0x04,
	0x8D,0x6D,0x2D,0xF0,0x19,0xEF,0x19,0xF7,0xAE,0xC3,0x35,0x60,0x65,0xE1,0x96,0x36,0x1B,0x74,0x3F,0x55,0x25,0xAE,0xE8,0x69,
	0xDA,0x61,0x8E,0xA5,0x1C,0xD9,0xC6,0xEA,0x21,0xF1,0x1B,0xB6,0xE2,0xB7,0x42,0xDA,0x8A,0xB6,0xA2,0xD7,0xD2,0xE0,0xB3,0x09,
	0x8C,0x54,0xDB,0x04,0x85,0xC2,0xE1,0x03,0xB9,0x15,0xB7,0x6D,0xD5,0x21,0x59,0x0D,0xF9,0x9E,0x3C,0x65,0x07,0x9E,0x4E,0x8D,
	0x95,0xA9,0x9C,0x79,0x96,0x5D,0xEA,0x6C,0x6D,0xE9,0xBD,0x0E,0x55,0x13,0x13,0x34,0xDB,0xF0,0x7D,0x6B,0x25,0x3C,0x14,0x18,
	0x10,0x8F,0xFB,0x4F,0x4A,0xE5,0xFE,0x13,0xEE,0x05,0xA9,0x44,0x5F,0x59,0x31,0x0D,0xDE,0x54,0x2D,0x8E,0xD1,0x96,0x4D,0x68,
	0xB0,0xF2,0x00,0xE6,0xA3,0x41,0x71,0x87,0xC3,0x8A,0xAE,0x91,0x57,0x74,0x46,0x8B,0x4C,0xB0,0xF1,0xA2,0x3D,0x5F,0x28,0x53,
	0xCB,0x76,0x6B,0x15,0xC0,0x56,0x6F,0x30,0xEA,0x74,0x9A,0xD0,0xAE,0xDC,0x75,0xB5,0x22,0x54,0x44,0x83,0x85,0x81,0xB8,0x63,
	0x18,0xD1,0x3C,0xCB,0xA5,0xD2,0xB4,0x4E,0x87,0x26,0xBB,0x42,0xDA,0x14,0x0F,0x4D,0x92,0x56,0x58,0x94,0xD5,0x43,0x75,0x48,
	0xD5,0x69,0x19,0x6D,0x6E,0x6C,0xF7,0x9E,0x41,0xB3,0xED,0xD8,0x4E,0x2F,0x75,0x45,0x4F,0xD2,0x84,0xF3,0x1D,0x85,0x46,0xBD,
	0x31,0xC2,0x69,0x2B,0xC2,0xAA,0x57,0xB5,0x0E,0xCD,0x57,0x18,0x99,0xBD,0xF0,0x5C,0x0C,0x4A,0x95,0xF5,0xE9,0xE2,0xAC,0x20,
	0xFB,0x93,0x04,0xEF,0x01,0xAA,0xB1,0x74,0x6B,0xF7,0xB3,0x53,0x3C,0xBD,0xAF,0x65,0x05,0x9A,0x64,0xFF,0x06,0xAE,0xB7,0x0D,
	0x48,0x8D,0xE3,0x7E,0xD6,0x46,0x23,0x35,0x49,0x13,0x8E,0xA5,0xE4,0x27,0xC5,0x9A,0x2E,0xA3,0x35,0xD1,0x61,0xF2,0xB4,0xC5,
	0xC5,0x49,0xFB,0x14,0x77,0xC3,0x10,0x86,0x02,0x27,0xEF,0x67,0x15,0x34,0x95,0x4E,0xBB,0x55,0x66,0xE6,0xD2,0xB4,0xE5,0x24,
	0x59,0x44,0xD3,0x06,0x8D,0xE4,0x59,0x9A,0xC6,0x5B,0x77,0x84,0x56,0x83,0xF8,0xB4,0xA4,0x27,0x81,0xB6,0xF3,0xB5,0x97,0x99,
	0x17,0x05,0x35,0x98,0x6C,0xCC,0xD5,0x83,0x89,0xA1,0x9E,0x25,0xFA,0xA8,0xA8,0x81,0x4E,0xA8,0x41,0x15,0x0F,0x1D,0xCA,0x15,
	0x0D,0x8E,0x78,0xCF,0x7D,0x9B,0x29,0x77,0x35,0x68,0x16,0xC5,0xED,0x0B,0x69,0x2F,0x23,0x77,0xF8,0x2B,0x65,0x3E,0x12,0x79,
	0x7D,0x14,0x24,0x5F,0x87,0xA8,0x81,0xA7,0x78,0xA8,0x5D,0x60,0x58,0xD1,0x8E,0xED,0x47,0x44,0xDE,0x99,0x0A,0x49,0xAB,0x0E,
	0x1A,0xC9,0x1D,0xB1,0x99,0xFA,0x05,0xF5,0x43,0xD0,0x01,0x40,0x37,0x3C,0x00,0xF1,0xEE,0x9B,0x55,0x0D,0xC5,0xD6,0xA9,0x8D,
	0x66,0x4B,0x29,0xED,0x40,0x39,0x73,0xED,0xB5,0xB0,0x76,0xD2,0xEF,0x94,0xD3,0x68,0x3B,0x10,0xB5,0x34,0xE1,0x47,0xCF,0xF3,
	0x42,0x1A,0x65,0xA4,0xBA,0x2E,0x35,0x26,0x23,0xD1,0x93,0xDA,0x90,0x68,0xCF,0xE3,0xA9,0xE7,0x2B,0x73,0x6D,0x99,0x9F,0xA1,
	0x4D,0x13,0xF7,0x51,0x7E,0xC3,0x18,0xB5,0xED,0x1E,0x49,0xFF,0x2D,0x9C,0x17,0x3F,0x9A,0x3E,0x74,0xD7,0x3B,0xBF,0x89,0x9F,
	0xB7,0xAF,0xF6,0x34,0x9A,0x9D,0x96,0xA4,0x85,0xE2,0x15,0x2D,0xA5,0x73,0xC3,0xBE,0xE3,0x93,0x83,0x59,0xE1,0x53,0x77,0x9B,
	0x33,0xBE,0x39,0x8D,0xB4,0x86,0x14,0xD1,0x40,0x98,0x47,0x30,0xF6,0x37,0x60,0x15,0xC8,0x9D,0x90,0x46,0x18,0xA7,0x79,0x1A,
	0x0A,0xD2,0x08,0x86,0x7F,0x29,0x66,0xC5,0x34,0xCA,0x1A,0xD2,0x9A,0xBA,0x36,0x1E,0xEC,0x6A,0x16,0x6B,0xD6,0x57,0x89,0x5E,
	0x6C,0xB4,0x33,0x9B,0xA0,0x18,0x6D,0x38,0x20,0xEE,0xE9,0xDE,0x5A,0xFF,0x02,0x55,0xAD,0x51,0x20,0x1D,0xD8,0xBC,0x1A,0x31,
	0xAE,0xA7,0xFD,0xC2,0x7F,0x62,0xBD,0xA7,0xA0,0xF2,0x35,0x75,0xB9,0x76,0xE9,0x9B,0xE6,0x8D,0x69,0x51,0x84,0xAB,0xFA,0xF7,
	0xD7,0x46,0x27,0x43,0x5C,0x61,0xB9,0xB8,0xBF,0xB7,0x2B,0x57,0xA9,0x34,0x0D,0x4D,0x11,0xD9,0x25,0x6B,0x28,0x68,0xA1,0x7F,
	0xC4,0x57,0x94,0xEF,0x3C,0x33,0xCC,0x5B,0xC0,0xD2,0x00,0xE0,0x21,0x67,0xD3,0x5C,0x9B,0xEB,0x42,0xE3,0x07,0xC3,0xD2,0x46,
	0xB2,0x82,0xB6,0xDD,0x57,0xDA,0xDD,0x21,0x00,0x8F,0x2D,0x5C,0x92,0xAE,0x0C,0x9F,0x12,0x23,0x13,0x35,0xAF,0x33,0xA2,0xAD,
	0xC8,0x51,0xCC,0x94,0x08,0xF0,0xA3,0xEC,0xD2,0xE3,0x1A,0x29,0xBB,0xF7,0xA9,0x1D,0x0E,0x35,0xA5,0x3B,0x38,0x1C,0xF4,0x8B,
	0xA0,0x42,0xA8,0xA2,0x40,0x5F,0x58,0xBB,0xAA,0x7D,0x12,0x0E,0x95,0x14,0xAF,0x29,0x68,0xC6,0x82,0x65,0xC6,0xAB,0xE4,0x0B,
	0x6D,0xF5,0x72,0xE1,0x01,0x12,0x2F,0x52,0x00,0x3F,0x5A,0x3E,0x39,0x16,0x1B,0x5D,0x1D,0x03,0x9A,0x28,0x4A,0xD2,0x94,0x0B,
	0x10,0xEF,0x53,0xDB,0x70,0xE4,0xC2,0x7B,0x41,0xF0,0x75,0xA9,0xE1,0x0F,0x49,0xDA,0x1C,0x8F,0xD7,0xC9,0xAB,0x1F,0xAA,0xA6,
	0x75,0x69,0xE6,0x2A,0xDF,0xF6,0x14,0xDE,0x4B,0xDA,0x24,0x6C,0x0D,0x07,0xFD,0xA1,0xAC,0xAA,0x81,0x19,0xAD,0x06,0x11,0xEF,
	0xD2,0xF0,0xEE,0x4D,0xF2,0x9C,0x07,0xDE,0x48,0xD6,0x91,0x93,0xE6,0xF1,0xB8,0x61,0x1A,0x8E,0xF3,0x64,0x55,0xFE,0x34,0x6F,
	0xE1,0x59,0x3B,0xDB,0x6C,0xD2,0x3E,0xD9,0x4D,0x3C,0xC1,0xE3,0x8B,0xC5,0xC9,0xF8,0x18,0xD7,0x8A,0x79,0xB0,0x5F,0x2B,0x73,
	0xD0,0x40,0xE8,0xCA,0x32,0x2A,0x1F,0xFD,0x31,0x69,0xE4,0xC4,0xB4,0xD0,0xBF,0x21,0x0E,0x6C,0x82,0xD5,0x98,0xB5,0x30,0x0A,
	0x69,0x24,0x83,0x83,0x50,0x7A,0x21,0xED,0x88,0x44,0x1B,0xAF,0x3F,0x9B,0x0E,0x1E,0xC8,0x07,0x41,0x7A,0xB5,0xDF,0x6E,0x9F,
	0xE4,0x89,0x82,0x36,0x26,0xA8,0xC4,0x4C,0xE5,0x9D,0xEF,0x9D,0x7B,0xF4,0x81,0x97,0x6D,0x83,0x56,0xD0,0x96,0xBB,0xC1,0x92,
	0x48,0xBB,0x05,0xC3,0xB7,0x3D,0xF6,0xD8,0x91,0x68,0x79,0x72,0x48,0x5B,0x11,0x68,0xD6,0x3D,0xEE,0xCF,0x83,0x41,0x38,0xD9,
	0xB3,0xC4,0x1F,0xF0,0x97,0xA5,0xE7,0x3E,0xC2,0x07,0x37,0x9E,0xE1,0x80,0x14,0xB8,0x72,0xF7,0xB8,0x52,0xE5,0xC9,0x61,0x4F,
	0xDE,0x10,0x68,0x6C,0xFB,0x25,0x46,0xCC,0xB7,0x96,0xF7,0x80,0x53,0x0F,0x37,0x4A,0x0E,0x94,0xE9,0x7E,0x67,0xD9,0x65,0xDB,
	0xCC,0x9C,0x36,0x94,0x57,0xF7,0x05,0x8D,0x85,0x71,0xB2,0x0C,0x4A,0x18,0x87,0x10,0xAF,0xB6,0x61,0x2D,0x4A,0x1C,0x28,0x8C,
	0x36,0x18,0x37,0xA1,0x1D,0x60,0xD9,0xF0,0xC6,0x36,0xD8,0xAD,0x08,0xBC,0xB4,0x76,0x2C,0x3B,0x50,0xD9,0xFB,0x0B,0x7B,0xB2,
	0x2F,0x4F,0xC3,0xBD,0x79,0x98,0x6B,0xE6,0x13,0x76,0x1D,0xEE,0x5D,0xF0,0x28,0x63,0x99,0x91,0x29,0x68,0xDA,0x88,0x60,0x38,
	0x15,0x18,0xC1,0xD0,0xC6,0x70,0x58,0xF2,0x36,0xDE,0x6F,0x02,0x26,0x46,0xE7,0xAB,0xBA,0xD0,0x3C,0x51,0x83,0x73,0x8A,0x7B,
	0xAA,0x25,0x22,0x54,0x4D,0xDB,0x0C,0xDC,0x70,0x3F,0x58,0x72,0x26,0x86,0xFD,0x3B,0x7C,0x5E,0x8B,0x93,0xE7,0x41,0xD0,0x32,
	0xC5,0xD7,0x2A,0x96,0xAE,0xCA,0xC1,0x14,0xD7,0xA0,0x43,0xA9,0x41,0xEB,0xD4,0x33,0x57,0x0F,0x00,0xBC,0xC6,0xB3,0xEA,0xD8,
	0xC7,0xF2,0x42,0x56,0x48,0x82,0xCE,0x40,0x7E,0x44,0x9D,0x25,0x5E,0x26,0xF7,0x28,0x5C,0xED,0x03,0xE8,0xEA,0xD5,0xC6,0xDD,
	0xD5,0x48,0x9E,0xB0,0x7F,0x09,0x12,0x9C,0x39,0xBB,0xA6,0x86,0xE5,0xF0,0x43,0xDB,0x73,0xD0,0xD8,0x02,0x2E,0x7D,0xE4,0xA4,
	0xDC,0xD1,0xB4,0xFF,0x81,0x48,0x9B,0xB9,0xCB,0x02,0x37,0x7B,0xDD,0x9F,0x90,0x26,0xEF,0x28,0x6E,0xC1,0xB4,0x34,0x1D,0x76,
	0xE8,0x84,0x6B,0xF7,0xC2,0x5B,0x5B,0x2A,0x48,0x0B,0x68,0xBF,0x52,0x69,0x6C,0x2C,0x86,0x2E,0x93,0xBA,0xD1,0x98,0xA1,0x1D,
	0xF5,0x9E,0x37,0x2F,0xA0,0x06,0xF7,0x98,0x9B,0xE1,0xCC,0x7D,0xB2,0xCD,0xF7,0xE7,0x86,0x07,0x3F,0x4F,0xDD,0x20,0x88,0xF7,
	0x51,0x94,0xEF,0xEE,0x3C,0xD7,0x29,0xD8,0x27,0x0B,0x25,0x01,0xAD,0x77,0x6B,0x69,0x9E,0x69,0x78,0x45,0xC7,0xCE,0x4A,0x68,
	0xED,0x2C,0xAE,0x9D,0x09,0x5A,0xB5,0xEF,0xDA,0x57,0x2E,0x48,0x9D,0xE4,0x1C,0x61,0xC2,0x57,0x72,0xDE,0x9F,0x13,0xD6,0x11,
	0x0C,0x20,0xC2,0x5C,0x57,0x37,0xB8,0x64,0x25,0x96,0xB0,0x6F,0xEB,0x5F,0x6B,0x38,0x7A,0xE4,0x25,0x7B,0x2B,0x36,0x97,0xC2,
	0xE3,0x6E,0xDC,0x01,0x27,0xB1,0x98,0x84,0x34,0xF9,0xD1,0x93,0xA4,0x5D,0x99,0xBE,0xFF,0x24,0x04,0x8D,0x0C,0x2E,0xA4,0x11,
	0xF4,0xB6,0x24,0xCD,0xDD,0xFB,0x81,0xB1,0xDA,0x70,0x39,0x5A,0x3F,0x3F,0x42,0x1A,0x41,0xA2,0x85,0xE7,0xF7,0x78,0x9B,0xDE,
	0x73,0x3F,0x29,0x0A,0xB8,0x30,0x0E,0xA4,0xBC,0x81,0xE1,0x8A,0xFC,0x53,0x63,0x1A,0x73,0x94,0xCA,0xC1,0x22,0xDA,0x8F,0xF2,
	0x34,0x6E,0x0F,0xB2,0x26,0xA1,0x77,0x86,0xAC,0x01,0x43,0x4F,0x7E,0x24,0xD0,0xCC,0xBB,0xE0,0x49,0x88,0x4B,0xBE,0xEC,0xED,
	0x97,0x78,0xA0,0x5F,0x82,0x1A,0x6A,0x89,0x84,0xF7,0xC6,0x07,0x22,0x1B,0x82,0x62,0x6C,0x20,0x68,0x55,0x27,0xA9,0x93,0x3D,
	0xD9,0x9C,0x16,0x8F,0x4B,0x79,0x1A,0x21,0xAC,0x33,0x41,0x13,0xB3,0x9B,0x6A,0x27,0xE9,0x8D,0x68,0x07,0xCA,0x91,0x89,0x7A,
	0x8A,0x74,0x87,0x86,0x6D,0x23,0xAC,0x03,0x49,0x5A,0xD4,0x8D,0x5C,0xDF,0xE6,0xF0,0xFA,0xF9,0x46,0xB0,0x25,0x2A,0x68,0x75,
	0x0D,0x0C,0x69,0xF2,0x92,0xAB,0x70,0x95,0xBD,0x72,0x1D,0x77,0x65,0x27,0x2D,0x98,0x84,0xD2,0x24,0xB1,0x2E,0x2C,0x77,0x4B,
	0x79,0x6D,0x30,0xE6,0x1D,0x30,0x7D,0xFE,0x80,0x34,0x5A,0x43,0x7D,0x50,0x96,0x87,0x59,0xDD,0x5A,0xDC,0x8E,0x57,0xDB,0x73,
	0x0B,0x53,0xC2,0xA8,0x4C,0x15,0x7C,0xDF,0x65,0xBD,0x5B,0xA6,0x3D,0x64,0x78,0x94,0x80,0xE7,0x2A,0x5A,0x89,0xF6,0x50,0x47,
	0xAB,0xD2,0x22,0x8A,0x79,0x4C,0x2D,0x3D,0x46,0x8F,0x30,0x17,0xAB,0xC5,0xED,0x0C,0x79,0x14,0x29,0x23,0x45,0x2B,0x6C,0x67,
	0x19,0xAD,0xB2,0x75,0x33,0xD0,0x8D,0x6E,0x4D,0xC3,0xB7,0x4D,0x82,0x27,0x26,0xC1,0x5B,0xEE,0x36,0x5A,0xE2,0xA4,0x4D,0x4D,
	0xEB,0x84,0x63,0x22,0x16,0x31,0x22,0x0C,0x79,0x6B,0xD5,0x0A,0xB8,0x70,0x7D,0x20,0x8C,0x94,0x29,0x66,0x30,0x5E,0xC7,0x0A,
	0x36,0x87,0x61,0xF2,0x83,0x0D,0xA6,0x02,0xAD,0xB5,0xC2,0x40,0xBF,0x26,0xBC,0xB9,0x59,0x12,0xC5,0xA7,0xF9,0x87,0x9D,0xFF,
	0x68,0xEE,0x82,0xD8,0xA9,0x50,0x25,0x67,0x96,0xBB,0xFE,0x1D,0xC1,0x6B,0x87,0x89,0xA0,0xF7,0x3E,0x1E,0x26,0xD8,0x11,0xD6,
	0x86,0x44,0xDB,0xCE,0x8F,0x08,0x34,0x18,0x8D,0xCB,0x3D,0xEE,0x26,0x61,0xE3,0x8E,0x31,0x1C,0xEA,0x29,0x21,0x53,0x78,0x6B,
	0xAB,0x65,0xE8,0xF5,0xCB,0xD1,0x98,0x66,0x5D,0x4D,0xFB,0x99,0x42,0xB3,0xC3,0xBD,0xAB,0x50,0x54,0xC2,0x3C,0xE3,0xA1,0xBF,
	0x92,0x36,0xDF,0x2F,0x64,0x5A,0x13,0x8B,0x36,0xA4,0x11,0xD6,0x3E,0xEE,0x6B,0xE1,0x87,0x6B,0x94,0xEF,0xCE,0x8D,0xDD,0xEE,
	0xE9,0x4F,0x92,0xD4,0xD6,0x50,0xD5,0x68,0xC7,0x59,0x5B,0xDC,0xA1,0xF2,0x2C,0x5D,0xF3,0x96,0xD0,0x36,0x26,0x34,0x98,0x3D,
	0x87,0xE2,0x71,0xE1,0xBA,0xB5,0x36,0x7A,0x86,0x36,0x24,0x78,0xED,0x18,0xED,0x20,0xEB,0x80,0x4C,0xC4,0x70,0x94,0x3B,0x40,
	0x43,0x1A,0x41,0x43,0x0A,0x69,0x29,0xA7,0x2B,0x8D,0x46,0xB0,0xED,0x98,0x2F,0x37,0x6C,0x1B,0x45,0xAF,0x8D,0xF5,0x05,0xCA,
	0x98,0x4C,0xD2,0x22,0x75,0xFA,0xCC,0x05,0x9D,0x49,0x76,0x0D,0x20,0x58,0x92,0x69,0xC7,0x9B,0x9C,0x09,0x99,0xA6,0x75,0x28,
	0x3D,0x99,0xA3,0x4D,0x5D,0x6E,0xDA,0xD5,0x76,0x6B,0x48,0xA3,0xF4,0x64,0x8E,0x26,0xBD,0xE1,0x10,0xD2,0x28,0x63,0x32,0x49,
	0x3B,0x48,0x8F,0xCA,0x2B,0x6B,0xE5,0xB9,0xBB,0x0D,0x66,0x9A,0xAF,0x18,0x93,0x1D,0xCA,0x7C,0x0B,0x69,0xB7,0xEE,0xD6,0xA0,
	0x6D,0x4B,0x85,0x34,0xD2,0x28,0x61,0x76,0xEA,0x41,0xC6,0xDB,0xC0,0x86,0xAA,0xA4,0xC6,0x4C,0x19,0x25,0xB7,0x22,0x78,0x8F,
	0xE7,0x2F,0x11,0x16,0xBA,0x10,0x2C,0xD5,0x6F,0x4E,0xD0,0xE6,0x94,0xB5,0xFB,0xB6,0x48,0x6A,0xA1,0x69,0x20,0xEB,0x65,0x9C,
	0x13,0x7C,0xD1,0x48,0xCB,0x4B,0xAD,0x3A,0xB3,0x2E,0x45,0x23,0xF8,0xC0,0xF2,0x34,0xAA,0x95,0x3C,0xA7,0x8C,0x92,0x5B,0x71,
	0xBC,0xE5,0xCA,0xD8,0x4B,0xEF,0x60,0xA4,0x69,0xCF,0xDC,0xC7,0x80,0x1A,0x88,0xAD,0x05,0xDE,0xAF,0xEC,0xF0,0x90,0x5C,0x0F,
	0x84,0x35,0x38,0xA6,0x58,0x92,0xC0,0x63,0xCE,0xD2,0x94,0x4F,0x80,0x24,0x3D,0xE7,0x14,0x09,0x73,0x9B,0x71,0xCD,0x7E,0x8B,
	0x07,0x7C,0xD0,0x54,0x96,0xA6,0x4D,0x9E,0xDD,0xBF,0xA1,0x1A,0x9F,0x58,0xEB,0xE1,0x67,0xD6,0xD1,0x32,0xFB,0x8E,0x73,0x79,
	0xFB,0x84,0xF3,0x52,0x47,0x43,0x04,0x93,0x47,0xA8,0x48,0xC9,0x9D,0xF9,0x09,0xA9,0x7F,0x43,0x15,0xAD,0x76,0x1B,0xB5,0x84,
	0x46,0x59,0x9D,0x6E,0x85,0xFC,0x64,0x02,0x80,0x34,0x4B,0x43,0x1A,0x4D,0xA6,0x2E,0xF6,0xFE,0x03,0x08,0xD5,0x99,0x61,0xAD,
	0xCB,0xCE,0x81,0x54,0xD2,0x16,0xF2,0xB4,0x85,0x91,0x11,0x70,0xA7,0x15,0x36,0x49,0x21,0xED,0x9C,0x20,0x77,0x16,0x9E,0xB5,
	0x34,0xEC,0xC4,0x9E,0x1B,0x99,0x36,0x96,0x9F,0x17,0xAD,0x8F,0x60,0xF8,0x58,0xD0,0x3E,0x3E,0x48,0x48,0x7B,0xD4,0x21,0x8D,
	0x30,0xE7,0x91,0x06,0xED,0xC2,0x8B,0xC4,0xC2,0x2D,0x9A,0x6F,0x25,0xD1,0xC2,0x6A,0x36,0x08,0xEB,0xC5,0x47,0xCB,0x59,0x61,
	0xBA,0xF1,0x89,0x67,0x2C,0x97,0xE6,0x7B,0x8A,0xF3,0x23,0xF4,0x76,0xF4,0xE4,0xBD,0x1D,0xF1,0x16,0x49,0xAC,0x2E,0x49,0xBA,
	0xE3,0x44,0x4F,0x5E,0x13,0xFC,0x0F,0xB7,0x96,0xF7,0x94,0x74,0x70,0x0A,0x8D,0x5A,0x46,0x68,0x8B,0xB6,0x69,0xA6,0x3C,0xAD,
	0x28,0x10,0xF8,0xDA,0x75,0xDA,0x51,0x72,0x79,0x74,0xB1,0xF8,0xAF,0x13,0x44,0x3C,0x76,0xF6,0x4B,0xCB,0xAF,0x3E,0x3F,0x5B,
	0xF6,0x56,0x31,0x75,0x85,0x6C,0x5C,0x9F,0xAA,0xE7,0x70,0x78,0x18,0x99,0x99,0x9F,0x61,0x84,0x4A,0x65,0xC2,0x05,0x81,0x93,
	0x74,0x77,0x0A,0xDC,0x09,0x21,0x0F,0x41,0xB6,0x75,0xBA,0x36,0x90,0x3E,0x4C,0x1F,0xE3,0xB8,0x5E,0xCA,0x77,0xA7,0x65,0xB6,
	0xF5,0xD3,0x38,0xC9,0x70,0x30,0x8E,0x2B,0x8E,0x4F,0x79,0x74,0xE9,0x61,0xC4,0xA2,0x0A,0x7D,0x7D,0x28,0x7D,0x78,0x29,0xAC,
	0x42,0xEB,0xCC,0x5D,0xDA,0x94,0x20,0xE2,0x54,0x9B,0xD5,0xAE,0x74,0xBE,0x38,0xD1,0xC5,0x57,0xA0,0x44,0xA2,0x84,0xC5,0xFD,
	0x62,0x71,0x64,0xCA,0xB6,0xE4,0x8E,0xA3,0xB4,0xB4,0x4E,0x2E,0xAC,0xB7,0x3C,0x92,0x58,0xAD,0xC0,0x45,0x09,0x5E,0x7C,0xDC,
	0x69,0x2D,0x09,0x4A,0xE1,0x38,0xC9,0x37,0x2A,0x87,0xAB,0x72,0x84,0x86,0x38,0xA9,0xB5,0x31,0xC4,0x99,0x98,0xD5,0x9A,0x25,
	0x6C,0x63,0x44,0x34,0x09,0x58,0xF4,0x3B,0x3A,0x0E,0xAB,0xE3,0x35,0xD9,0x59,0x3B,0xD9,0xC9,0x2F,0x70,0x98,0xB6,0xD9,0x5D,
	0xB9,0x76,0x7D,0xE9,0x45,0x38,0x7D,0x28,0x1B,0xE8,0x2E,0x86,0xCA,0x7C,0xE7,0x3A,0xF7,0xE6,0x91,0xBB,0xA4,0x0F,0xCE,0x56,
	0x4F,0x1F,0x0E,0x64,0x83,0x5E,0x87,0x69,0x9A,0x38,0x7E,0x86,0xFE,0x42,0x59,0x97,0x1A,0xA3,0x49,0x86,0xB8,0x0F,0xE3,0x30,
	0xD7,0x73,0x76,0xA1,0x1B,0xB5,0x75,0x7C,0x79,0x24,0x39,0x27,0x7F,0x75,0xD7,0x86,0x18,0x8E,0x22,0x5C,0x12,0x0C,0x60,0x49,
	0xE3,0x4D,0xEF,0x0E,0xA9,0x2F,0xEE,0xA5,0x0E,0xD7,0xBC,0xC4,0xFA,0xF8,0xEA,0x87,0x6C,0xBE,0xF9,0xC3,0xDF,0x8E,0x6E,0x8E,
	0x7F,0xFD,0x3B,0x8B,0xDA,0x36,0x1A,0x4A,0x56,0x58,0x2C,0xB3,0xC7,0x42,0x6B,0x5B,0xFA,0xBF,0xBB,0xA0,0xFE,0xAF,0x30,0x94,
	0x91,0x1A,0x2C,0xC6,0x68,0xD3,0xCC,0x5B,0xAE,0xA1,0xBD,0x9B,0xBF,0xE3,0xA9,0x13,0x99,0xD5,0xFA,0x5E,0x1C,0xB0,0x93,0x9B,
	0x2E,0x48,0x53,0xB5,0x46,0x34,0xB4,0x50,0xDF,0x57,0xEE,0xB9,0x14,0xD2,0x32,0x39,0x8B,0x6B,0x68,0x2A,0x3B,0xC6,0x8B,0x77,
	0x66,0x5D,0x9A,0x88,0xF0,0xC3,0x58,0x38,0xAE,0xE0,0x54,0x46,0x04,0x20,0x6D,0xFC,0x33,0x85,0xA6,0xB5,0xA7,0x96,0xB9,0xC2,
	0x50,0x6D,0x2B,0x38,0x08,0x37,0x05,0x37,0x96,0xB8,0x17,0x06,0x1B,0xBC,0xB0,0x4A,0x98,0x8C,0x76,0x7C,0x44,0xA1,0x8D,0xC1,
	0xA0,0x38,0x33,0xF6,0xF7,0xA6,0xF0,0xD0,0xE2,0x25,0x50,0xA4,0xF7,0x36,0x22,0xD2,0xD0,0x87,0x21,0x72,0xC7,0x23,0xF1,0xDD,
	0xF8,0x62,0xF6,0x0E,0x56,0xA9,0xF5,0x7D,0xCD,0x70,0xE1,0x63,0xB2,0xD7,0x9C,0x46,0xF3,0x51,0xB1,0x51,0xD2,0x27,0xD1,0x30,
	0xC6,0xD4,0x03,0xAB,0x23,0xB0,0xEE,0xA8,0xBB,0x59,0x48,0xEB,0xD0,0x7A,0xD2,0x5B,0x05,0xD6,0x0A,0x6F,0xCF,0x7B,0x30,0x94,
	0x71,0x97,0xB4,0xBF,0x84,0xB4,0xC1,0xB8,0x39,0x4D,0xA5,0xD3,0x68,0x63,0xD2,0x0F,0x3C,0xE2,0xFB,0x4A,0xD1,0xFA,0xA7,0x24,
	0xDA,0x3E,0x70,0x3D,0x17,0x2F,0x57,0x69,0x26,0x27,0xD5,0x01,0x85,0x76,0x84,0x26,0xE1,0x7D,0x62,0xAF,0x0E,0x2F,0xC0,0xB0,
	0x6B,0x62,0xDD,0x12,0xB4,0x9F,0x49,0x52,0x59,0xD0,0x0E,0x32,0xA8,0x08,0x7E,0x64,0xDA,0x65,0xB3,0x9D,0xD3,0x48,0x97,0x1B,
	0xF0,0x44,0x90,0xB8,0x9F,0x4B,0x3D,0x3C,0xC3,0x69,0x4B,0x95,0x44,0x63,0x42,0x7F,0x02,0x3A,0x93,0xE1,0x25,0x84,0x97,0x8C,
	0x85,0x86,0xB4,0x9D,0x1F,0xD0,0x69,0xC7,0x96,0xC8,0x41,0xF0,0x57,0x6B,0x27,0x2D,0x30,0x19,0xAD,0xB3,0x6C,0x40,0xDB,0x3B,
	0xF7,0x86,0x57,0xBB,0x13,0x58,0xD0,0x93,0x5D,0xD2,0xEC,0x0E,0x5D,0x4C,0xF6,0xCA,0x6D,0xF4,0xDE,0x74,0xD2,0xDA,0x2D,0x68,
	0x78,0x2B,0x2F,0x15,0xC7,0x67,0x37,0x49,0x96,0x30,0x5A,0x80,0xA4,0x0B,0x72,0x4C,0x0F,0xD2,0x7A,0xF4,0x31,0xC9,0x69,0x54,
	0x1C,0xA7,0xD1,0xE6,0x1B,0xEA,0x58,0x7C,0xCB,0xD1,0x09,0x84,0x8F,0xA2,0xDA,0xE7,0x92,0xA2,0xED,0x54,0x93,0x4C,0x13,0xC9,
	0xE1,0x8E,0xDC,0xB5,0x25,0x23,0xB2,0x92,0x6D,0xD3,0xAF,0xC9,0xB4,0x46,0x13,0x40,0xCC,0x00,0xE2,0x28,0x01,0x5A,0xA3,0x21,
	0x29,0xC6,0xE4,0x84,0x4E,0x63,0x79,0xDB,0xF1,0x46,0x72,0xD4,0xE7,0xD6,0x42,0xC5,0xAB,0xF5,0xBC,0xB2,0x15,0xE7,0x2C,0x95,
	0xCF,0x59,0x86,0x76,0xEE,0x7A,0xD6,0xBF,0xF0,0x36,0x4D,0x5B,0x76,0x84,0x84,0xB4,0x5D,0x77,0x4D,0x6E,0x5B,0x26,0x1B,0xF8,
	0x0D,0x5E,0x17,0x56,0xBF,0x0D,0xC1,0xDA,0xA6,0xCD,0x9E,0x4B,0x93,0x75,0xD0,0x31,0x1A,0x7D,0x4C,0xA2,0x11,0x27,0xDE,0x16,
	0x41,0x35,0xE1,0x9A,0xF9,0x31,0x99,0x16,0x2B,0xFE,0x73,0xE3,0xCE,0x0C,0x9E,0xE4,0xDE,0x1E,0xD7,0x95,0xCF,0xE8,0x34,0x56,
	0xF8,0x3A,0x9A,0x77,0x72,0xDE,0x4E,0x3E,0xDF,0xE8,0xEF,0xED,0x03,0x46,0xFE,0xFB,0xAC,0x81,0xE2,0xAC,0x11,0x98,0x54,0x4C,
	0x35,0xD9,0x57,0x4C,0x42,0x46,0xBB,0x25,0xD9,0x01,0x47,0x2E,0xBB,0xCA,0xF9,0x47,0x76,0xC3,0x6D,0xB4,0xA5,0x22,0x35,0xE1,
	0xB8,0xF6,0x4A,0xD3,0xB9,0x92,0xB4,0x03,0xA6,0x62,0x1D,0x48,0x42,0xB9,0xB5,0x48,0x6B,0x1B,0xDB,0xFE,0xFA,0x68,0xFA,0x00,
	0x19,0xFB,0x2B,0x37,0x10,0x31,0x06,0xA5,0x7A,0x5D,0x86,0xA6,0xD1,0xE4,0x64,0x82,0x76,0xB4,0x67,0xC7,0xFA,0x42,0x47,0x3F,
	0x5E,0x3C,0xE3,0x3E,0x06,0x65,0xA6,0xA9,0x78,0x6F,0x24,0x1B,0xE7,0x88,0x9D,0xDC,0xE3,0x9B,0x8A,0x37,0x78,0xD0,0x8E,0xA7,
	0xBD,0x91,0x30,0x16,0xC5,0x98,0x24,0xD9,0x01,0x13,0x10,0x1E,0x07,0xC2,0xEA,0xE6,0x2D,0x8C,0xD4,0xE4,0x53,0x77,0x59,0x1D,
	0x89,0xC2,0xDA,0x36,0xA4,0xD1,0xF8,0x42,0xEA,0x99,0xF0,0xC3,0x0E,0xEF,0x47,0x24,0xAE,0xA6,0xA4,0x31,0x99,0x5E,0xB6,0xD9,
	0xD5,0x28,0xB6,0x6B,0x48,0xB9,0x4C,0x38,0xED,0xBC,0x01,0x6D,0xB2,0x31,0x2C,0x67,0x8B,0x77,0x13,0x11,0xF6,0x9F,0x19,0x8D,
	0xA4,0x05,0x85,0x34,0x4C,0xDB,0x8C,0xE7,0x87,0xAC,0xB2,0x84,0xE2,0x65,0x34,0x92,0x86,0x27,0x68,0xE2,0x1C,0xCA,0xD8,0xDB,
	0xD6,0x06,0x27,0x64,0x68,0x24,0xA9,0x2C,0x68,0x33,0x73,0xFD,0xFE,0xCC,0x33,0x48,0x51,0xE9,0x9C,0x46,0xB2,0x4D,0x27,0x1B,
	0x93,0xEA,0xB9,0x48,0xD2,0x76,0x99,0x9C,0xBC,0x75,0x34,0x91,0x8B,0x97,0x25,0x1F,0x69,0xA0,0xE1,0x8D,0x68,0x33,0xC0,0xF5,
	0x7C,0x33,0xCE,0x72,0xB8,0xB6,0xFC,0x8D,0x08,0xC4,0xB8,0xC4,0xAB,0xC5,0xEB,0x7C,0x78,0x3B,0xFD,0x91,0x44,0x63,0x25,0x83,
	0x6A,0x87,0x07,0xDC,0x71,0xB1,0x7B,0x8F,0x99,0xDE,0xF6,0x5B,0xB6,0xEE,0xFD,0x0C,0x6A,0x0A,0xF3,0x22,0x96,0xFA,0xF0,0x76,
	0xFA,0x3F,0x08,0xB4,0xC2,0x7D,0x43,0x76,0xB2,0x5E,0x1C,0x31,0x40,0x69,0xC6,0xAD,0xD5,0xBD,0xB7,0x63,0x62,0xE0,0xB1,0xDC,
	0x87,0x28,0x6A,0xB0,0x1C,0x10,0x74,0x4C,0xE4,0x3D,0xF0,0x58,0xE7,0xBD,0xBF,0x0A,0x03,0xB2,0x64,0xDD,0x1B,0x8C,0xF7,0x4F,
	0xD2,0x2C,0x3C,0x7E,0xE0,0x1A,0x43,0xF2,0xAD,0x5E,0xF2,0x9C,0x44,0x75,0x6B,0x1F,0xEF,0xDF,0x2F,0x54,0x9A,0xF1,0x24,0x82,
	0xA0,0x0E,0x92,0x87,0xA1,0x85,0xC7,0xA3,0x9A,0x96,0x3E,0x39,0x51,0x4F,0xE3,0x59,0x72,0xCE,0xEB,0x8E,0x65,0x14,0xFC,0xE1,
	0x73,0x9E,0xB4,0xA2,0x9F,0x7C,0xD9,0xD9,0x60,0x1B,0xE0,0xD9,0x6B,0xAA,0x93,0x94,0xF5,0x64,0x8F,0xA4,0xAD,0x9C,0x7C,0x09,
	0x3C,0x13,0x33,0xD7,0x98,0xC6,0x36,0xD4,0xC7,0x24,0xB9,0x5C,0xA7,0x25,0xF9,0x35,0x4E,0x0D,0x30,0x78,0xFC,0x27,0xE5,0xC4,
	0x33,0x94,0x29,0xAC,0xB3,0x18,0x3C,0x37,0x73,0x77,0xA6,0x84,0x7A,0xC4,0x47,0xC9,0x67,0x12,0x4D,0x1C,0x4D,0xB4,0x3C,0xCA,
	0x62,0x1E,0xB7,0x4D,0x23,0xE9,0x0F,0x82,0x96,0xD8,0x1E,0x38,0x50,0x6E,0x76,0xF0,0x1A,0x45,0xAF,0xD6,0xEE,0x49,0x9C,0x90,
	0x68,0xD6,0x67,0xE8,0x35,0xA6,0x8E,0xF1,0xBB,0x5F,0xA3,0xA4,0xBF,0x72,0xEF,0x4D,0x25,0xCD,0x80,0xF8,0x4A,0x56,0x21,0xB4,
	0x7C,0xE9,0xFE,0xE4,0x33,0x80,0xE4,0xB7,0x8F,0x69,0x29,0x8F,0xA2,0xB4,0xE5,0xD3,0x23,0xAD,0x43,0x49,0x1A,0xFA,0x53,0xE4,
	0x61,0xA2,0x6D,0x24,0x0D,0x3A,0xA6,0x5D,0x19,0x1E,0x1E,0xFD,0x97,0xE7,0x71,0x1A,0x6D,0x4C,0xBA,0x7B,0x2F,0x1C,0x25,0xA8,
	0x47,0xF3,0xB0,0x5C,0x96,0x40,0xA2,0x6E,0x92,0xF3,0xD9,0x4D,0xDA,0x95,0x8B,0x34,0x73,0xA4,0x74,0x3B,0x1D,0xE5,0x98,0xB7,
	0xED,0xC8,0xB2,0xCB,0xB2,0xEF,0xA4,0x68,0xB7,0x24,0x59,0xC2,0x68,0x89,0xA3,0xF8,0x54,0x4D,0xAC,0x4F,0x9A,0x01,0x8C,0x76,
	0x89,0xF7,0x56,0x47,0xD6,0x1C,0xFC,0x8C,0x6A,0x20,0x9F,0xF0,0x42,0x85,0x28,0xAA,0x05,0x7F,0x6F,0x97,0x64,0x5A,0x6A,0x73,
	0x40,0x2C,0x6F,0x09,0x0B,0xBD,0x42,0x57,0x98,0x0E,0x48,0x6B,0x37,0xDB,0x20,0x8E,0x77,0x20,0xEA,0x56,0xD0,0x2C,0x6D,0xB7,
	0x24,0xCD,0x37,0xA1,0x27,0x34,0x71,0x5B,0xF2,0x9E,0x24,0xED,0xDD,0x72,0xDA,0x33,0xFC,0xF6,0x3F,0xD2,0x69,0xA1,0x47,0x88,
	0xA5,0x2F,0x12,0x3A,0xD0,0x9C,0xA5,0x9C,0xAE,0x9B,0x6F,0xDA,0x82,0x46,0x7B,0xBA,0xBB,0xB3,0x9C,0x35,0x18,0x3C,0x1F,0x1C,
	0xEB,0xCE,0xF5,0x8A,0x13,0xDA,0x96,0xB6,0xED,0x9C,0x34,0x03,0xCE,0xDD,0xFB,0x47,0x18,0xE3,0x3E,0x99,0x15,0xD2,0x48,0xA3,
	0x04,0x93,0x31,0xA3,0x0F,0xF6,0x11,0xFA,0x8F,0x8D,0x77,0x91,0xF8,0x82,0xED,0xEE,0xBC,0x07,0x8D,0xEC,0xD1,0xE7,0x2E,0x8E,
	0x7C,0x2D,0xD8,0x98,0x1C,0x50,0xF4,0xF5,0x56,0xE4,0xB0,0x9C,0xC3,0x0C,0xB0,0x68,0xF1,0xD9,0xEC,0xBD,0x7D,0x20,0xD1,0x3E,
	0x3F,0x29,0xC7,0xEC,0x2A,0xA7,0x66,0xFB,0x9B,0x47,0x24,0x0D,0x2F,0x72,0x7B,0x31,0x27,0x4D,0x6D,0xC4,0x42,0x8E,0x36,0xA0,
	0xF8,0x11,0x8B,0xD3,0x5A,0x87,0x35,0xE0,0x56,0x4E,0xE8,0xCC,0x39,0x72,0xF7,0xB0,0x2E,0x39,0xD0,0xDD,0xE5,0x55,0x61,0x35,
	0x98,0xA4,0x43,0x51,0x6A,0x2D,0x9F,0x90,0x97,0x30,0xB6,0x0E,0x84,0x43,0x13,0x65,0x6A,0x7B,0xB5,0xB1,0xCA,0xCC,0x6A,0xDE,
	0xBF,0xA4,0xDD,0xB3,0x90,0x36,0xB5,0x9C,0x87,0x50,0xEF,0x9B,0xE1,0xC8,0x74,0x9D,0x3A,0x5B,0x8B,0x8F,0xD4,0x4D,0x23,0x9A,
	0x9B,0x78,0xAB,0x07,0x5C,0x75,0xA9,0x79,0xA7,0xFC,0x6D,0x92,0xA4,0x67,0x48,0xC3,0x92,0xF9,0xE6,0x2A,0xC9,0xDF,0xB7,0x1B,
	0x90,0xF4,0xBE,0x90,0x96,0x52,0xA1,0x11,0x5B,0x6F,0xB2,0x72,0x0D,0x9A,0xA4,0x1B,0x09,0xB5,0x9C,0x65,0xF0,0x8B,0x9D,0xFA,
	0x53,0xCF,0xF2,0xDD,0xBA,0x4D,0x3B,0xDE,0x36,0xD2,0x6E,0xF5,0x8F,0xE8,0x75,0x4B,0x2E,0x0C,0xEF,0x54,0x6D,0xD0,0x1F,0xBE,
	0x93,0xD5,0xD7,0x07,0x3F,0x51,0x68,0x97,0xC6,0x1E,0xEF,0xA7,0x9F,0xB8,0xDB,0x2D,0x5B,0x84,0xC2,0xD8,0x9E,0x93,0x7F,0xEE,
	0xAD,0xDD,0xD6,0xAC,0x3A,0xB2,0xC4,0x77,0x98,0xFE,0x49,0xA2,0x89,0x35,0xAE,0xDE,0xD0,0x29,0x6E,0x9B,0x4A,0x7A,0x6F,0x19,
	0x1A,0x53,0xC7,0x24,0xC6,0x63,0xDC,0x93,0x14,0x59,0x5D,0x28,0xCF,0xD2,0x35,0x88,0xE6,0xE0,0xBB,0xE9,0xCD,0xE5,0xC5,0xE4,
	0xE4,0x1D,0xBB,0x8C,0xBD,0x72,0xE4,0x38,0x34,0x4F,0x4E,0x41,0x8B,0x59,0x56,0x44,0x85,0x79,0x20,0x2B,0x37,0x30,0xF8,0xBC,
	0x20,0x59,0x28,0x97,0xD6,0x1D,0x5E,0x0B,0x12,0xC4,0xA3,0xE6,0xE2,0x58,0x99,0x48,0xED,0xE3,0xF1,0xFE,0xA5,0xD0,0x8A,0xFB,
	0x17,0xD5,0x6C,0xA6,0x8B,0xBA,0xC2,0x28,0x83,0x36,0x9A,0xB6,0x8C,0xF3,0x85,0x6B,0x88,0x94,0x5D,0x06,0x16,0x13,0x7E,0x0F,
	0x53,0xC2,0x00,0x1D,0x1E,0x56,0x0A,0x60,0x6F,0x8D,0xDA,0x73,0xB5,0x29,0xDE,0x11,0x49,0xCA,0x5D,0xA1,0x24,0x60,0xA9,0xB2,
	0x9B,0xAD,0xFE,0xDD,0x39,0x8D,0x86,0x56,0x26,0xCB,0xE3,0x15,0x79,0x39,0x25,0x7B,0x93,0xF7,0x25,0x49,0xB3,0xB9,0x32,0x9E,
	0x8C,0x78,0xD5,0x3B,0x50,0xC4,0xD9,0x30,0x21,0xCA,0xBF,0x55,0xAE,0x8D,0xCF,0xA5,0x57,0xF7,0xB0,0x91,0x4A,0xDA,0xB5,0xBF,
	0x32,0xD7,0x86,0x6D,0xC3,0x0B,0x0B,0xF7,0xF4,0xC6,0xB8,0xF3,0xC5,0x53,0x58,0x84,0x3B,0x55,0x55,0x1E,0x55,0x8D,0xB4,0x8F,
	0xCE,0xEF,0x57,0x63,0xCE,0x96,0x3B,0xE1,0x6B,0x11,0xA9,0x2B,0xA4,0xE6,0xC5,0x6E,0x40,0xF2,0xFC,0x97,0xD1,0x24,0x22,0xFD,
	0x38,0x8D,0x24,0x53,0xAF,0x16,0x18,0x66,0x41,0x0F,0xCA,0x0C,0xDF,0x5B,0x9F,0x44,0xBB,0xB6,0x9C,0x7F,0x18,0x2C,0x15,0xB1,
	0x08,0x83,0x9B,0x6F,0xF6,0x9E,0x85,0xA7,0x23,0xBF,0x65,0xFB,0x37,0xFB,0x72,0xFD,0x9B,0xD1,0xAE,0x49,0xF3,0xAD,0x8A,0x76,
	0x6C,0xDC,0xDF,0x57,0x68,0xFB,0x9C,0x46,0x7A,0x6F,0x49,0x5A,0x78,0xA5,0xBC,0x24,0x8F,0xD3,0x48,0xBA,0xFD,0xCD,0x2A,0x80,
	0xF9,0x76,0x73,0x71,0xC9,0xD7,0x20,0xCA,0x16,0x11,0xF7,0xEF,0x90,0x2C,0x40,0x4E,0x6B,0x3E,0x4A,0x16,0x24,0xAF,0x04,0xEE,
	0x2F,0xDF,0x2C,0xAD,0xF6,0x2D,0x31,0xC1,0x42,0x48,0x9B,0x93,0x46,0x49,0xD2,0x53,0xCB,0x55,0x42,0x11,0x79,0xC1,0xB6,0x6A,
	0xEA,0x7D,0x57,0x1A,0xC9,0x53,0x36,0x35,0xEC,0x2D,0x08,0x47,0x6A,0x1C,0x55,0x44,0x53,0xCF,0x29,0xF1,0x46,0x53,0x9E,0x44,
	0x8E,0x12,0x49,0x9E,0xA6,0x91,0x7A,0x72,0xBA,0x31,0x3C,0xC3,0xDD,0x34,0xD9,0x48,0xE7,0x6B,0x00,0x69,0x94,0x08,0xE7,0xFE,
	0xC4,0xD8,0x05,0x65,0xC7,0xC4,0x2A,0x69,0x1A,0xAD,0x6D,0x9C,0xC6,0x6D,0x49,0x6E,0x57,0x26,0xCC,0x94,0xCA,0x4D,0x0C,0x4E,
	0x23,0xAD,0x6F,0x82,0x96,0x1B,0x9A,0x71,0xCC,0x47,0x0D,0x8D,0xA4,0xF7,0x85,0xDB,0x24,0x7C,0x47,0x32,0xDA,0xA1,0x14,0x41,
	0xF4,0x0B,0x00,0xB9,0x65,0xF3,0x9E,0xD3,0x48,0xFE,0x1D,0x41,0x9B,0xA1,0x40,0x5C,0x27,0xEC,0xAF,0x1A,0x89,0x1C,0xD3,0x48,
	0xBE,0x62,0x41,0xCB,0x58,0x75,0xCA,0x77,0x6C,0x23,0x78,0x02,0x03,0x75,0x5B,0x7E,0xD5,0x26,0xA3,0x35,0x19,0x93,0x39,0x1A,
	0x7A,0x8B,0xD9,0x8E,0x46,0x45,0xC6,0x41,0x46,0x23,0xF9,0x1F,0xAA,0x68,0xD5,0x4D,0x13,0x34,0xD2,0x1A,0xC0,0x4F,0x63,0xF2,
	0xF7,0xC5,0xAF,0x9A,0x21,0xC5,0x78,0x4F,0x07,0xA4,0x68,0x0B,0x6E,0x8D,0x9B,0x3C,0x9A,0xFC,0x5D,0xAF,0xA3,0x0D,0x3B,0x32,
	0x16,0x73,0x4C,0x23,0xE9,0xCA,0x62,0xE8,0xC3,0xEC,0x06,0x81,0xE9,0x1A,0x14,0x59,0xC9,0x74,0xAE,0x0D,0x29,0xA2,0x5C,0x1C,
	0x05,0x4B,0x18,0x75,0x8B,0x47,0x17,0x53,0xB1,0x4B,0x64,0xBE,0x61,0x76,0x00,0x29,0x02,0xA8,0x8A,0x36,0x2B,0xBD,0xCD,0x32,
	0x41,0x23,0xC5,0x65,0x62,0x89,0xFC,0xD6,0x76,0x1E,0x8C,0x66,0x06,0x1B,0xD7,0x5F,0xB9,0x32,0xB9,0x00,0xF9,0x8A,0x43,0xD2,
	0x82,0x62,0x5A,0xC3,0xD5,0x94,0xB4,0x76,0xCF,0x12,0xE1,0x98,0x4D,0x56,0xD3,0x2E,0x69,0x0D,0x40,0x5A,0xB3,0x30,0x68,0xA1,
	0x99,0x93,0x22,0x5C,0x59,0x8E,0xEE,0x46,0x81,0xC9,0xC2,0x6F,0x44,0xDA,0xC3,0x46,0x5A,0xB3,0xC0,0x64,0x21,0xB9,0x48,0xB3,
	0xBB,0x80,0x46,0xDA,0x2D,0xD1,0x48,0x9E,0x53,0xA4,0xA5,0x36,0xF0,0xB2,0x01,0xB6,0x35,0x11,0x2A,0x03,0x8A,0x54,0x2E,0xF4,
	0xA2,0x60,0x0D,0xD0,0x7F,0xE2,0xC2,0xC2,0xBD,0x15,0x89,0x59,0x2C,0x47,0xDA,0x4F,0xB6,0x7B,0x5C,0xD3,0xBC,0x54,0xB3,0xD4,
	0x3A,0xCE,0x76,0x9B,0x49,0xFD,0xAB,0x92,0xD6,0x58,0xA4,0x25,0x7A,0x93,0xD2,0x3C,0xBE,0xD7,0x4C,0xB2,0xEA,0x90,0xF6,0xB1,
	0x8D,0xEF,0x93,0xBF,0xCB,0x6A,0xE7,0x42,0x9E,0xD6,0xA5,0xD3,0x42,0xFD,0x4B,0x6E,0xB7,0x3E,0x45,0x1B,0x92,0x7B,0xF2,0xDB,
	0x84,0x2B,0x11,0xF7,0x16,0x02,0xD4,0x65,0xED,0xA7,0x83,0x1A,0x97,0x2E,0xD7,0xD7,0x49,0x31,0xBD,0xA8,0x95,0x4C,0x4D,0x03,
	0xEC,0x11,0xAA,0x3B,0x4A,0xF8,0xA3,0x48,0x3B,0xA4,0xB3,0x93,0x79,0xFB,0xE7,0x70,0x1F,0x28,0xD4,0x54,0x22,0x8F,0xB8,0x44,
	0xC4,0x3E,0x29,0x72,0x6B,0x66,0xAD,0x13,0x6B,0x6C,0x83,0x13,0x32,0xB4,0xF7,0xD6,0xE8,0xDA,0x91,0x98,0xD6,0x27,0x69,0x99,
	0x33,0xE8,0x3C,0x91,0xBC,0xCA,0x57,0x7E,0x24,0x35,0x8F,0x8F,0x12,0xD2,0x3E,0xFA,0xCC,0x7D,0x02,0x21,0xFD,0x93,0x83,0x9E,
	0x2F,0x9F,0x87,0x5D,0xB0,0xE8,0xBB,0x6F,0xF9,0x06,0x1E,0x8B,0x63,0xAE,0xB2,0x45,0x74,0xDA,0x3A,0x94,0xA3,0xB5,0x79,0xB2,
	0x8E,0xFA,0x81,0xC9,0x69,0xB4,0x35,0x76,0xBF,0x05,0x2D,0x73,0x1D,0x4E,0x36,0x15,0xD4,0xAF,0xCF,0x2E,0x3A,0x8A,0x7C,0x05,
	0xD3,0xE5,0xD5,0xDA,0x90,0x63,0x92,0xE5,0x33,0x37,0xEE,0x0C,0xCF,0x0A,0x61,0xE2,0x3E,0x48,0x53,0x64,0x98,0x3F,0x77,0x6D,
	0xBF,0x3C,0x66,0x8C,0xD3,0x48,0x92,0x2B,0x4D,0xC3,0x53,0x23,0xDF,0x32,0xED,0x92,0x9D,0x7A,0x75,0x8C,0xFA,0x18,0x38,0xD2,
	0x98,0x4C,0xD1,0xF8,0x0E,0x28,0xA8,0x64,0x52,0x44,0x4E,0x23,0xD9,0xFE,0xE1,0x2D,0x97,0x22,0x1A,0x14,0xA6,0x1F,0xCD,0xAF,
	0x71,0x4D,0xB2,0x8F,0x43,0x1A,0x62,0x0E,0x94,0xB9,0xE1,0x6F,0x64,0xCD,0x63,0x41,0x23,0x59,0x75,0x73,0x73,0xB5,0xF7,0xAC,
	0xE0,0x89,0xA8,0x17,0x45,0xB4,0x23,0x92,0x06,0x3D,0xDF,0xC0,0xE2,0xF2,0x1C,0x6F,0x33,0xAD,0x27,0x37,0xA0,0xF2,0xDD,0x35,
	0x0A,0xA3,0xE7,0x9A,0x02,0xA5,0x6D,0xC5,0x79,0x1B,0xC5,0xE4,0x4B,0x6F,0xD5,0x4B,0x6D,0x18,0x72,0x5D,0xF0,0x8A,0xB6,0x9F,
	0x25,0xFC,0xCE,0x4D,0x62,0xE3,0x78,0xFF,0x92,0xD6,0xA1,0xB9,0xF5,0x25,0x17,0x62,0x18,0xE5,0x79,0x90,0x88,0x11,0xE8,0xE8,
	0x14,0x5F,0x66,0x21,0x8D,0xBB,0xA8,0x64,0x6C,0x86,0x5D,0x87,0x64,0x59,0xCE,0xED,0x27,0xDC,0x79,0x05,0xB9,0x4C,0x0E,0x7A,
	0xE2,0x31,0x4F,0xB4,0x9E,0x74,0x57,0xAB,0x28,0x18,0xE1,0x5D,0xB7,0xF3,0x8E,0xBB,0x3D,0xFE,0x7A,0x71,0x3C,0xBE,0x3E,0xA9,
	0xF6,0x7B,0x30,0xDA,0x19,0x6D,0x5E,0xF0,0x53,0x1E,0x3C,0xA2,0xE3,0xE2,0x82,0x47,0x06,0x19,0x6B,0x4B,0x62,0x52,0xF2,0x51,
	0x42,0xF2,0x2E,0x66,0x69,0x13,0x8C,0xC1,0x21,0xE8,0x46,0x7D,0xDA,0xAA,0xB7,0xC3,0x8B,0xBB,0x70,0x33,0xD0,0xB9,0xB7,0x85,
	0xBF,0x43,0x32,0xAD,0x03,0x3F,0x37,0x73,0x47,0x1A,0x93,0xBB,0x27,0xCF,0xDA,0x37,0xF0,0x3E,0x84,0x6D,0xA3,0xAD,0x43,0x09,
	0x6F,0x4A,0x22,0xE1,0x01,0x77,0xC6,0x99,0x95,0x56,0x09,0xD7,0x69,0x89,0x34,0x58,0x85,0x30,0xD6,0xE0,0xAF,0xD6,0x6E,0x47,
	0x8B,0xF1,0xE0,0x3A,0x2D,0x6D,0x45,0xC7,0x28,0x49,0x1B,0x23,0xE3,0xE6,0x7B,0x27,0x70,0x2B,0x03,0x26,0x8B,0x68,0x2A,0xC9,
	0xB7,0x12,0x6E,0xF1,0x24,0xAC,0x56,0xA9,0xCD,0xE3,0x90,0xA6,0x91,0x2C,0x1F,0x4C,0x28,0x86,0x21,0x8D,0xA4,0x13,0x6A,0x09,
	0x9A,0x4E,0x91,0x5C,0xC5,0xEB,0x10,0xD4,0xC0,0x72,0x7D,0xE5,0xD8,0xF2,0xCC,0x55,0x40,0xAA,0x04,0xAB,0xC1,0x31,0x45,0xBE,
	0x20,0x2F,0x8A,0x38,0x97,0x09,0x36,0xCC,0xF3,0xBA,0xA4,0x5D,0xE5,0x14,0x8D,0xCD,0x06,0x6E,0x3A,0x4B,0x5B,0xCD,0x94,0x91,
	0x5A,0xDC,0xBF,0x7B,0x98,0x21,0xDB,0x70,0x8B,0x94,0xAB,0x6B,0xDE,0x83,0x92,0x3A,0x86,0x55,0x79,0xC2,0x8B,0x16,0x39,0x03,
	0x3C,0x7F,0x67,0x32,0x1F,0x48,0x14,0xD6,0x59,0x79,0xE0,0x37,0xDB,0xE2,0x31,0x4D,0x47,0x0C,0x33,0xB5,0x33,0xD7,0xC4,0xB7,
	0xA9,0x3C,0x58,0x32,0xFE,0xEA,0x39,0x6D,0xE5,0x65,0x34,0x00,0xF1,0xE9,0xF2,0x1D,0xDF,0x72,0x9B,0xE2,0x6E,0xA2,0x5F,0x73,
	0x49,0x08,0xA7,0x91,0x2C,0xF7,0x2C,0x4D,0xC8,0x01,0x19,0x1C,0xA7,0x91,0xAC,0x5B,0xA0,0x4D,0x0C,0x66,0xA2,0x90,0xF7,0x7F,
	0x39,0xED,0x96,0xB4,0x3A,0x21,0x6D,0xEB,0xEE,0xEF,0x6C,0xCC,0x72,0x34,0xDF,0xBA,0xD2,0x89,0xD9,0x04,0x8D,0xA2,0x7D,0x32,
	0x9A,0xED,0xFA,0x29,0xA9,0xCA,0xF7,0x2B,0x6B,0x8F,0x78,0x31,0xDA,0x8C,0xA6,0xC3,0xDC,0xF2,0x29,0x86,0x43,0x9F,0x62,0x90,
	0x45,0x6D,0xFB,0x85,0xD8,0x93,0x3C,0xC3,0xFE,0x47,0x83,0x96,0xC3,0x3B,0xA4,0xD1,0x6C,0xE9,0x34,0x8D,0x5F,0xB0,0x85,0x1B,
	0x36,0x92,0xB3,0x7B,0xFE,0x57,0x92,0xFF,0xB6,0x38,0xDF,0x3C,0x3B,0x1A,0x12,0xDA,0x2F,0xF8,0x02,0xA3,0x4B,0x8A,0x45,0xB2,
	0x81,0x2A,0xFB,0x7A,0x46,0x6D,0xEF,0x19,0x6E,0xAB,0xF0,0x23,0xBA,0xCC,0x21,0xF9,0x9E,0xFD,0x84,0xE9,0xCC,0x59,0x15,0x2A,
	0xA5,0xE7,0x74,0x46,0xD1,0x6B,0x38,0xEF,0xDC,0x65,0xAB,0x04,0x4F,0x6E,0x4F,0x3D,0x3F,0x34,0x27,0xED,0xBF,0x01,0x2D,0xDA,
	0x7C,0x90,0xDD,0xE4,0x48,0xD1,0x48,0xBB,0x0F,0x49,0xDA,0x7C,0xB3,0x67,0x09,0x67,0xA7,0x96,0x2D,0xE3,0x2F,0xE4,0x34,0xD2,
	0x6E,0x1F,0xD0,0x7E,0x34,0x1E,0x2B,0xBD,0x3B,0xD5,0x34,0xD2,0x3E,0x0E,0xD2,0xCC,0x35,0xF7,0x8C,0x88,0xFD,0x45,0xF4,0x8E,
	0x48,0x6B,0xA4,0x73,0x9A,0x4D,0x76,0xAB,0x5C,0x1A,0x4F,0xA6,0x17,0x3B,0xEC,0x24,0xA5,0x59,0x38,0x2A,0x9F,0xAF,0x55,0x54,
	0xD4,0xE0,0x80,0xDD,0x06,0x5D,0xEA,0xB0,0xE1,0x35,0xA0,0xF9,0x66,0x72,0xB4,0x5B,0xC3,0x82,0x85,0x51,0xA2,0x8F,0x79,0xEF,
	0x52,0x74,0xB6,0x70,0x1E,0x5E,0xBA,0x78,0x13,0x39,0x3F,0x12,0xC3,0x23,0x9B,0x41,0x67,0xC2,0x7C,0x00,0xFC,0x22,0x7A,0xD7,
	0x5E,0x97,0xDC,0x6A,0xC1,0x88,0xBF,0xBE,0x44,0x0F,0xE7,0x6A,0x50,0x83,0x4E,0xF5,0x30,0xAD,0x06,0xC8,0xBB,0x72,0xA1,0x53,
	0xF7,0x78,0x6C,0xD7,0xF0,0xB6,0x04,0xE1,0xC3,0x5B,0xFC,0x91,0xF8,0x46,0xB9,0x89,0xD8,0x8E,0xF7,0x94,0xCC,0xD5,0xC6,0x71,
	0xDB,0xD5,0x22,0x3C,0xA2,0xD1,0x6C,0x2A,0xA0,0xA5,0x92,0x50,0xD3,0x3C,0x26,0x3B,0xDF,0x23,0xAE,0xC8,0x33,0x0C,0x56,0x57,
	0xC6,0xED,0x5B,0x76,0x18,0x4C,0x4E,0xC6,0xC5,0x6D,0xA3,0x6A,0x1B,0x9C,0x16,0x66,0xF5,0x26,0x7A,0x83,0xE6,0x34,0x1F,0x46,
	0x48,0x23,0x34,0x2A,0x45,0x7B,0xF6,0x0E,0x72,0xA6,0x06,0xC9,0x39,0x29,0xB5,0x3F,0x3F,0xA3,0xD9,0x6F,0xB7,0x5C,0x85,0x63,
	0xA6,0x8C,0x5C,0x4E,0x80,0x34,0x8D,0x22,0xD7,0x63,0x5E,0xC2,0xB9,0x2E,0xB4,0x7E,0xB6,0xCD,0x8B,0xB9,0x50,0x4A,0xDD,0x0F,
	0x9C,0x47,0xB5,0x9E,0xD2,0x77,0xE9,0x50,0x35,0x55,0xCA,0x8E,0x56,0xD9,0xDB,0xCC,0xDE,0xE6,0x23,0xFB,0x3E,0x79,0x7B,0x69,
	0x35,0x60,0x3C,0x66,0x02,0x7C,0xC7,0x02,0x18,0xF9,0x39,0xF7,0x03,0xE5,0xDA,0x65,0x06,0x64,0xA5,0x51,0xC5,0x5B,0x4C,0x5D,
	0xB7,0xE6,0x81,0xEB,0x6D,0x83,0xA6,0xDA,0x1C,0xE9,0x7C,0x15,0xBB,0xCF,0x07,0x05,0x80,0x74,0x6A,0xAF,0x14,0x6D,0xE7,0x53,
	0xFC,0x8B,0x65,0x6F,0x93,0xC7,0x9F,0x26,0xCD,0xF0,0x6F,0x95,0xCB,0x40,0x39,0xB5,0x4D,0x78,0xAB,0x6C,0x10,0x57,0xEC,0xEB,
	0xCD,0x68,0xDE,0x24,0xE4,0x61,0x50,0x7B,0x7B,0xEC,0xB9,0x7B,0x5C,0x41,0xF6,0xF2,0xE2,0x8F,0xF7,0xEF,0xB3,0xF5,0x20,0x30,
	0x03,0xC0,0x16,0x70,0x77,0x4C,0xE7,0x59,0xB1,0x9B,0x78,0xC2,0xA4,0xDF,0x0F,0x35,0x6E,0x1E,0x56,0x83,0x9F,0x69,0xFB,0x38,
	0x09,0xDE,0x1C,0x43,0x8B,0x7D,0xE8,0x6A,0xCF,0x74,0x56,0x1B,0xBE,0x75,0x5A,0x1F,0x0F,0x3B,0x26,0x79,0x20,0x16,0xA6,0x6D,
	0x96,0x5F,0x51,0x58,0xDF,0xBF,0x43,0x92,0x2F,0x92,0x7B,0xC6,0x26,0x1B,0xF3,0x73,0xB3,0x8C,0xAF,0x5D,0x92,0xEF,0x7F,0xE1,
	0x59,0x6D,0x98,0xFE,0xEE,0x5E,0x68,0x95,0xB8,0xA9,0x1E,0xDF,0x8C,0xEA,0x59,0x15,0xBB,0x2A,0x6C,0xB6,0xE8,0xFE,0x73,0x69,
	0xFC,0x16,0x43,0xC9,0x08,0x13,0x52,0xDE,0xC4,0xC5,0xC7,0xD4,0x46,0xA6,0x2C,0x29,0x6A,0x5B,0x77,0xFB,0x1C,0x1A,0xBF,0x30,
	0x4D,0x7E,0x8D,0xEC,0x92,0xA4,0xDC,0x87,0xD3,0x1B,0x71,0x15,0xA4,0x88,0xA0,0x49,0x2C,0x92,0x32,0x1E,0xBF,0x1E,0x49,0x82,
	0xC7,0x34,0x78,0x83,0x80,0xDB,0x63,0xEA,0x90,0x0B,0xC7,0xB7,0xEE,0x1D,0xAB,0xC6,0xB6,0xE4,0xBB,0x28,0xA4,0x93,0x6A,0x31,
	0x4D,0x08,0x91,0x90,0x74,0xA0,0x68,0xDC,0x63,0x7B,0x54,0x16,0x88,0xCB,0x69,0x24,0x1D,0x3C,0xA6,0x4D,0x2C,0x6F,0xB5,0xB7,
	0x02,0xEF,0xE9,0x80,0xDF,0xE5,0x67,0x96,0x1E,0x88,0x4B,0xD1,0x6E,0xA9,0x34,0xF1,0x9A,0xA2,0x69,0x16,0x71,0x65,0x7A,0xF2,
	0x17,0x12,0xCD,0xB1,0x82,0x06,0xD1,0xA9,0x31,0x8D,0x36,0x4A,0xE6,0xCA,0xC4,0xF8,0x6C,0xD8,0xD0,0x90,0x33,0xD3,0x31,0x3D,
	0x43,0x3E,0x97,0x21,0xDF,0xCD,0x27,0x69,0x6D,0x09,0x1A,0xD1,0x69,0x23,0x68,0x24,0x5F,0x43,0x82,0x46,0xCD,0x43,0xC1,0x69,
	0xA4,0xBD,0xB6,0x8F,0x80,0x30,0xB7,0xAE,0x17,0x50,0x3D,0xA7,0xE1,0xDE,0x36,0x8D,0x66,0x7A,0x01,0xBB,0x06,0x29,0xDC,0x74,
	0x63,0x47,0x2F,0x6A,0x22,0xCF,0x13,0xB4,0x0E,0xA9,0x27,0x73,0x34,0x7E,0xF4,0x42,0xE6,0x02,0x14,0x4E,0x23,0x8D,0x12,0x66,
	0x57,0xF3,0xFD,0xD7,0xC4,0x49,0x2B,0xE9,0x7C,0xCE,0xD3,0x01,0xB1,0x27,0x51,0xED,0x4B,0x93,0x24,0x73,0x33,0x70,0x1A,0x69,
	0xBE,0x89,0x43,0x4E,0x36,0x58,0xD7,0xFE,0x06,0x8C,0xC0,0xBA,0x10,0xB5,0x2C,0x6D,0x4C,0x89,0x8D,0x2B,0xD4,0xFB,0x98,0xFF,
	0x09,0x8F,0x63,0xE4,0xAF,0x5E,0xC1,0x20,0x2F,0x68,0x75,0x75,0x04,0xDB,0xCF,0x34,0xCD,0x13,0x79,0xE5,0x31,0x71,0xD5,0x7F,
	0xF8,0x1E,0x34,0x6D,0x97,0xB4,0xA8,0xC5,0xD8,0x4C,0x3E,0x5C,0xF9,0x52,0x68,0x9B,0x3E,0x8F,0x1B,0x12,0xC9,0xA6,0xC6,0xDB,
	0xBD,0x5D,0xBC,0x09,0xCF,0xE5,0x00,0xC9,0x63,0x53,0x4C,0x8B,0x33,0x5B,0x95,0xC3,0x04,0x8D,0xA2,0xE7,0x86,0xBC,0x50,0x87,
	0x67,0x89,0x6F,0x0D,0x0F,0x66,0x29,0x8E,0xDA,0xBA,0x91,0xC5,0x79,0x34,0x3F,0x7F,0x59,0xFF,0x2A,0x95,0xB9,0x8C,0xE7,0x20,
	0x3E,0x1E,0x4C,0x2F,0x57,0x09,0xAC,0xC1,0x71,0x87,0x3A,0xA2,0x18,0xEF,0x19,0x37,0x55,0x18,0x14,0x9F,0x18,0xA7,0x31,0x0F,
	0xCA,0xB7,0x5C,0x4C,0xE0,0xF1,0x18,0xA9,0x2C,0x73,0x8C,0xB6,0xBE,0x97,0x6E,0x9D,0x12,0xE1,0xE2,0x39,0x49,0x0D,0x10,0x21,
	0x75,0x66,0x48,0x63,0x29,0xA1,0x13,0xC7,0x20,0x65,0x82,0x0C,0xB8,0x38,0x22,0x09,0xBF,0x5B,0xCB,0x59,0xFB,0x7B,0xEF,0x6E,
	0xE9,0x52,0xA3,0x22,0x85,0x28,0x20,0x05,0x06,0xDF,0xBA,0xF6,0xDD,0x4E,0xFE,0xDA,0xAC,0x1C,0x4D,0x27,0xB5,0x2D,0xCC,0x97,
	0x9A,0x98,0x05,0xE2,0x32,0x6D,0x98,0x83,0x65,0xC3,0x3F,0xA6,0x1D,0xD3,0x16,0x64,0x41,0x6B,0x72,0x92,0x89,0x2B,0x89,0xA4,
	0x80,0x6E,0x11,0xAB,0xD4,0x20,0x4B,0xB9,0x30,0x93,0x48,0x87,0x14,0xD3,0x91,0x51,0x89,0xA5,0x58,0xF2,0x90,0xC1,0x80,0x14,
	0x18,0x51,0x74,0xFD,0x5E,0xEA,0x6A,0xDB,0xC0,0xF5,0x7C,0xEB,0x55,0xAE,0xEE,0x2B,0x14,0xAE,0xD9,0x1B,0x2F,0xD9,0xD4,0x84,
	0x2A,0xB9,0x12,0xAE,0xB1,0x9E,0x36,0x1A,0xCA,0xDE,0x78,0xD9,0x1E,0x0A,0xE9,0x9A,0x00,0x4A,0x72,0x62,0x20,0x5E,0xB1,0x29,
	0x7B,0x1F,0xAB,0xCE,0xFB,0x3F,0x8B,0xE3,0x8A,0x1F,0xBF,0xF6,0x42,0x98,0x90,0xA5,0x63,0x8B,0xE1,0x24,0xAF,0x29,0xAF,0xC4,
	0x09,0x7B,0xBC,0x1A,0x18,0xE2,0xA4,0x2E,0xBD,0xAC,0xC4,0xE1,0x0E,0x7C,0x5D,0xE3,0x22,0x9C,0xD4,0xF5,0xA8,0x95,0x38,0x1D,
	0xAC,0xD7,0x35,0x28,0x1E,0x01,0xDE,0x15,0xCD,0xB2,0x55,0x4D,0x9E,0x40,0x01,0xC5,0x40,0xA7,0x98,0xDE,0xEA,0xE9,0xAA,0xF4,
	0xBB,0xEB,0x72,0xDC,0xFC,0xC1,0x04,0x55,0x06,0xEF,0x77,0x21,0x0E,0x14,0xC0,0xF5,0xD5,0x4C,0xD8,0x79,0xBD,0xB3,0x26,0x6E,
	0xD1,0x85,0x13,0x98,0xF7,0x68,0xAB,0x8E,0xBD,0xAD,0xCC,0xB5,0x9E,0xAD,0xCC,0x81,0x31,0x09,0xDA,0x4B,0x5D,0xE5,0xF9,0x02,
	0x72,0xE1,0xDF,0x76,0xA5,0xA7,0xFA,0xDC,0x3B,0x3D,0xB5,0x61,0xB7,0x47,0x7B,0xC9,0xF1,0xA5,0x6D,0x61,0xBC,0x1F,0x13,0x05,
	0x97,0xAE,0xE5,0xAC,0x6C,0x37,0xA8,0xDA,0x33,0x67,0x34,0xBC,0x3E,0x2E,0xA1,0xDC,0x91,0x68,0x42,0x0A,0x4C,0x8C,0x65,0xE5,
	0x2E,0x6E,0x92,0x96,0x76,0x92,0xC9,0xD0,0x6E,0xDA,0x11,0x4F,0xA6,0x51,0xE9,0xB6,0xA9,0xD4,0xB6,0xFD,0x12,0xD3,0x8E,0xCD,
	0x95,0x8B,0x99,0x0D,0x12,0xDC,0x72,0xC1,0xCA,0x68,0x5D,0x02,0x2D,0x3C,0xFA,0x44,0xDF,0xC0,0x11,0xB4,0x74,0x52,0xB5,0x1A,
	0xDA,0xA5,0xB1,0xC4,0xB6,0xB8,0xE8,0xD9,0xA1,0x04,0xE0,0x45,0xB4,0xE3,0x13,0x42,0xDB,0x52,0x79,0xF7,0xBF,0x63,0xE7,0x72,
	0x83,0xFD,0xBA,0x2E,0x6C,0x32,0xA6,0xED,0xF4,0x3B,0x42,0xDB,0x9E,0x93,0x35,0x81,0xD1,0x36,0x4B,0x42,0xDB,0x9E,0x73,0xEA,
	0x91,0xD1,0xFA,0x1A,0x81,0x16,0xC6,0x83,0xD3,0x06,0x48,0x4C,0xCB,0x38,0x6E,0x09,0x34,0x1E,0xD7,0x64,0x6F,0x31,0x43,0xB8,
	0xC4,0xFC,0x16,0xB4,0x8F,0x14,0x1A,0x8B,0xB7,0x5B,0x36,0x68,0x9A,0xE8,0x49,0xBF,0x47,0xE8,0xC9,0xA2,0x25,0x26,0xA5,0xB6,
	0x6E,0xAC,0x9D,0xFF,0x4A,0xCB,0xD3,0x39,0xA0,0x44,0x72,0xE6,0x7B,0x3C,0x7E,0xEC,0xCA,0x5F,0x1C,0x86,0x97,0x6D,0x0F,0x64,
	0x6F,0xB8,0x0F,0x67,0x23,0x40,0xC0,0x0C,0x69,0xB0,0x24,0xB5,0x72,0xAB,0x51,0x2D,0x2D,0xBC,0xDF,0x1E,0xA9,0x44,0x22,0xDE,
	0x6F,0xAF,0xC9,0x5E,0x24,0xAE,0x0F,0xB3,0x0A,0x1C,0x95,0xC8,0xF4,0xC5,0xBE,0x2C,0xAE,0x2F,0xCE,0x63,0xB1,0xC0,0x10,0x0F,
	0xAC,0x53,0xA5,0xDF,0x53,0xD4,0x2F,0xF0,0x3F,0x49,0x66,0x4B,0xEB,0x0F,0x86,0x46,0x1E,0xD7,0xCE,0xF2,0xDA,0xA9,0xF3,0x5F,
	0x79,0x1E,0xD7,0xE8,0x8E,0x1F,0xCE,0x9C,0xCA,0x24,0xCE,0x8C,0xB7,0x4C,0xDF,0x6B,0xF2,0x0C,0xDE,0xCF,0x7B,0xD3,0x74,0xDE,
	0xF9,0xE5,0x48,0xC6,0xDB,0xE9,0x9B,0xAC,0x04,0x68,0xC8,0x13,0xBE,0xBF,0x5D,0xA9,0xB5,0x1E,0xB6,0xEF,0xF1,0x65,0xDA,0x77,
	0x6B,0x05,0xAB,0x4D,0x6D,0xFB,0x8C,0x5D,0x27,0x6B,0xCD,0x54,0xF2,0x5E,0x48,0x17,0x7E,0x11,0xA9,0xF3,0xEA,0x4A,0x31,0x53,
	0x89,0xB5,0xBF,0xBF,0x36,0xBA,0x25,0x52,0x38,0xF2,0x93,0x00,0x8E,0x19,0xC5,0x1B,0x2D,0x0C,0xDF,0x37,0xAB,0x25,0x6D,0xAB,
	0xDF,0xED,0x8E,0x3A,0x2B,0x62,0x08,0x29,0x34,0xF5,0xFA,0x64,0xF2,0xD3,0xEB,0xB7,0xF4,0xF7,0x34,0xBC,0xC2,0xC4,0x99,0x78,
	0x64,0x85,0x2A,0xF8,0xD5,0xDE,0x30,0x6B,0x6F,0x4A,0xBE,0x63,0x7E,0x4A,0x9D,0x66,0x49,0x6B,0x9D,0x6E,0x66,0x0F,0x4A,0x96,
	0xB6,0x71,0xF7,0xF6,0xBA,0xD4,0x2D,0x59,0x4A,0xCB,0xDC,0x75,0xD3,0x74,0xFC,0x4E,0x0D,0xA0,0x83,0x3C,0xAC,0x52,0x9F,0xD9,
	0xF8,0x25,0xA5,0x01,0x7B,0xD5,0xD9,0xD2,0xC2,0x93,0xE6,0xCC,0xC7,0x8C,0x31,0x79,0x4C,0xAF,0xE4,0xA7,0x75,0xA4,0x94,0xF5,
	0x4E,0xB7,0x37,0x5C,0xE5,0x04,0x70,0x25,0x8D,0x25,0x61,0x68,0x32,0x21,0x91,0x96,0xC9,0x83,0x57,0x4B,0x33,0x51,0x8F,0xBC,
	0x74,0x9D,0x7B,0xE5,0xD4,0xF5,0x1E,0xA4,0x1A,0x15,0xD2,0xFA,0x9D,0x41,0x4F,0x56,0xF5,0xC9,0xD1,0xD8,0x02,0xC6,0x2F,0x64,
	0xC2,0x68,0xFC,0x5A,0x2D,0x08,0x69,0x3A,0x4D,0x89,0xC4,0xED,0x32,0xF4,0x2E,0x77,0x95,0x2F,0xF0,0x4F,0x9B,0xFF,0x57,0x72,
	0x27,0x42,0x57,0x75,0x5D,0x56,0xCF,0xE2,0xB4,0x89,0xB1,0x63,0x03,0xA3,0xDC,0xE2,0x2E,0xA7,0xF5,0x32,0x79,0x9C,0xAA,0x68,
	0x6D,0x95,0xE1,0x4E,0x76,0x06,0x6E,0x31,0x92,0xE5,0x96,0xC2,0x44,0x57,0x26,0x3B,0x69,0x3D,0x6E,0x6C,0x79,0x60,0x74,0x3C,
	0x50,0xD5,0x63,0x86,0xD3,0x86,0x99,0x4B,0xC1,0x24,0x70,0x9E,0xE7,0x3E,0x82,0xFE,0x06,0xE3,0x83,0x24,0xB9,0x10,0xA7,0xEB,
	0xA3,0x22,0x5C,0xA5,0xCE,0x13,0x4D,0x71,0x34,0xAF,0x70,0x9A,0x5B,0xCE,0xBD,0xAC,0x8E,0x0C,0xBD,0xA9,0xD3,0x16,0x02,0x1C,
	0x2A,0x4D,0x17,0x5C,0x9D,0x40,0x13,0x9D,0x39,0xC1,0xC4,0x74,0x16,0x66,0x84,0x3C,0x6E,0x1F,0x19,0xFE,0x43,0x8D,0x84,0xCC,
	0xE2,0x34,0x59,0x5C,0x97,0x1B,0x8A,0x86,0x85,0xE6,0x38,0x4C,0x74,0xFA,0x3C,0xE8,0x77,0xB5,0xEC,0x44,0xA8,0xE9,0x4A,0x9E,
	0x55,0x09,0x5E,0x1C,0x93,0x27,0xAA,0x82,0xE9,0x96,0xF9,0x8E,0xF1,0xB5,0xFB,0xAF,0x7F,0xD9,0x66,0xC5,0x80,0x05,0x89,0x22,
	0xDF,0xB6,0x88,0xD6,0x8E,0x69,0xE8,0x20,0x52,0x6E,0x1C,0xE5,0x14,0xD6,0xB7,0xDA,0x2E,0x6D,0xE9,0x03,0x4D,0x7A,0xD2,0x71,
	0x1A,0x5E,0x2A,0xF0,0xD9,0xF4,0xE5,0xDF,0x56,0x82,0xA6,0xF6,0xBB,0x34,0xCF,0x7B,0x71,0xC0,0x34,0xB4,0xB5,0xE9,0x40,0x1D,
	0xA9,0xBD,0x11,0x69,0x75,0x60,0x3C,0xDC,0x79,0xB7,0x95,0xEF,0xC0,0x80,0xF2,0xD8,0x89,0x22,0x5F,0xA8,0x2F,0xE5,0xF9,0x58,
	0x43,0x5E,0xBF,0x3B,0x92,0xB6,0x8C,0x79,0xFF,0x26,0x69,0xB6,0x79,0x47,0x80,0x95,0xD2,0xAA,0x0D,0xB9,0x95,0xB1,0x5C,0xE2,
	0x02,0x78,0x87,0xB9,0x81,0x31,0x93,0xE8,0xA3,0xEB,0xD5,0xAF,0x7C,0x8C,0x37,0x1C,0xAA,0xB4,0xDE,0x04,0xDA,0x7E,0x69,0xE0,
	0x2E,0x14,0xFD,0x0D,0x82,0x1E,0xD1,0x19,0xD1,0xF4,0xBF,0x8F,0xCD,0xC6,0x29,0xA7,0x0D,0x75,0xE2,0x2E,0x51,0x1C,0x3C,0x96,
	0xBA,0xA2,0x56,0x5C,0x27,0x54,0xBD,0x0F,0x8F,0xB4,0xE3,0x74,0xAC,0x1A,0x9D,0xF6,0xD1,0x72,0x31,0xBE,0xA7,0x1A,0x15,0xD3,
	0x7A,0x8D,0x68,0xE2,0xD2,0x37,0x1E,0x70,0xEE,0x23,0x36,0x8C,0xDD,0x2F,0x0B,0xB4,0xE1,0x34,0xC2,0xC5,0x4F,0x12,0xB4,0xC3,
	0xCB,0x80,0x1F,0x68,0xCE,0x42,0x05,0x6D,0xD0,0x88,0xC6,0x5D,0x25,0x57,0x86,0x1D,0x98,0xBE,0xB8,0xF5,0x5A,0xDC,0x0D,0x58,
	0xD2,0x3A,0x41,0x53,0x5F,0x98,0xF6,0xBE,0xB8,0x75,0x82,0xD6,0x6F,0x44,0x13,0x6F,0x69,0xE1,0x99,0x77,0xAE,0x65,0xFB,0xF1,
	0x85,0x2C,0x65,0xA3,0x45,0xD0,0xF4,0x97,0xA2,0x89,0x5B,0x8C,0x4B,0x78,0x82,0x36,0x94,0xA7,0x09,0x7F,0xC1,0xE5,0x78,0x76,
	0x85,0xFE,0x82,0x19,0x4A,0xE6,0xE6,0x9B,0x85,0xD2,0xBA,0xA0,0x50,0xCD,0x2C,0xD7,0xB1,0x56,0xFC,0x96,0x72,0x8C,0x2F,0xF7,
	0x8C,0x07,0x59,0xDB,0xB9,0xD5,0x1B,0xF4,0xA4,0x63,0x23,0x3A,0x59,0xDF,0x2C,0xF0,0xA8,0x36,0xBA,0x96,0xB9,0xAF,0x84,0x46,
	0x53,0xC2,0xBC,0x41,0x52,0x2B,0x42,0x6F,0xA4,0x4A,0x3B,0x9E,0x0B,0x69,0x5C,0xA2,0xD9,0x22,0xB0,0x6E,0xE6,0xB2,0xD4,0x86,
	0x25,0x7A,0x29,0x8B,0x32,0x29,0xB0,0xBE,0x42,0x12,0xFE,0x23,0xD6,0xBE,0x08,0x17,0x05,0x0E,0x50,0x3B,0x92,0x07,0x0E,0x48,
	0xEE,0x29,0xB7,0xFB,0xF8,0xD3,0x61,0xEF,0x77,0xE6,0x59,0xFA,0x77,0xEC,0xE6,0xCF,0xC4,0xFC,0xBC,0x04,0x5D,0xA6,0xF9,0x5A,
	0x9C,0x39,0xA6,0xF4,0x36,0x3F,0xDF,0xE6,0x67,0x1E,0x27,0x3F,0x3F,0xDF,0xA6,0x67,0xB4,0x7C,0x9E,0x8F,0xAF,0x8F,0xFF,0xCE,
	0x2C,0x64,0xA7,0xC9,0xC6,0x26,0x83,0x6B,0x43,0x95,0xA8,0x2B,0x9F,0xF3,0xA4,0xB5,0x6E,0x03,0x43,0xAE,0xA5,0xF6,0x32,0x17,
	0x5D,0x54,0xD1,0x0E,0xF5,0xDF,0x9D,0x7F,0xFF,0xDF,0x22,0x85,0xFF,0xC7,0xBC,0xE6,0x9C,0x31,0xFB,0xF6,0x9E,0xB3,0xD3,0x79,
	0xFC,0x75,0xF6,0xCF,0xFE,0x53,0xB6,0xCF,0x1C,0x6B,0x8B,0xE7,0xC5,0x1C,0xE3,0x81,0xBC,0x7D,0xA6,0x75,0xBA,0xDD,0x54,0x2C,
	0x0C,0xA3,0xC1,0xE0,0xEA,0x8F,0xF4,0x81,0x8A,0xCB,0x55,0xE7,0x10,0x9D,0x1E,0x18,0x33,0x11,0xFD,0x90,0xFA,0x7D,0x97,0x2F,
	0x66,0x6D,0x1D,0xFE,0x9F,0xA8,0x4C,0x60,0x78,0x77,0x96,0x4F,0x72,0xC2,0xB7,0x34,0xAD,0xAB,0xAA,0xB9,0xCA,0x44,0xE3,0x3F,
	0x5E,0x43,0x91,0xA7,0xF6,0x41,0xE9,0x64,0x3E,0x63,0x4C,0x11,0x65,0x7C,0x69,0xE2,0x81,0x07,0x13,0x6C,0x98,0xE6,0xA5,0x80,
	0xC5,0x2E,0x6A,0x0F,0x17,0xD2,0xCB,0x30,0x76,0xDA,0x58,0x9B,0x8A,0x76,0x29,0xC5,0x6E,0xF5,0xA1,0xCB,0x06,0xB9,0xF6,0x15,
	0xFB,0x8C,0x87,0x05,0xB4,0xC9,0xDE,0xFB,0xCC,0x8E,0x1F,0x22,0x54,0xAD,0x81,0xB6,0x86,0x83,0x81,0xFE,0x1C,0xDA,0xA9,0xB1,
	0x32,0x59,0x22,0xDA,0x9D,0xF5,0x60,0x2A,0xDD,0x6A,0x5C,0x6B,0x38,0xEC,0x8F,0xF2,0x03,0xA9,0x8E,0xD6,0x8D,0xDB,0x06,0x1A,
	0x16,0xC1,0x1F,0x3E,0x1C,0xA8,0x23,0x49,0x9A,0x1A,0xBF,0x38,0xC9,0x17,0x95,0x6F,0xDC,0x60,0x34,0xD2,0x25,0x71,0x7A,0x12,
	0x97,0xF4,0x7B,0x9C,0x38,0xD5,0xF9,0x98,0x32,0x38,0x0C,0x17,0x89,0x89,0x32,0x38,0xFD,0x52,0xE4,0x7F,0x9A,0x1B,0x4B,0xCF,
	0xE4,0xC3,0x44,0xA2,0xBD,0x4C,0x21,0x2F,0x6F,0x5D,0x3B,0x3D,0x0B,0xBA,0x6A,0xCC,0xC3,0x97,0x47,0x51,0xC6,0x05,0x6F,0xD0,
	0xED,0x0E,0x25,0x7B,0x33,0xF1,0xEE,0xF4,0x68,0xA8,0xE0,0x1A,0x5B,0xA6,0x81,0x17,0x75,0x66,0xBF,0x3B,0x2C,0x17,0x2A,0xED,
	0xCC,0xD0,0x8C,0x81,0x7D,0x81,0x5B,0x6C,0x30,0xE4,0x67,0x1E,0xB8,0x72,0xE3,0xB3,0xD5,0xD7,0x46,0x7D,0xFA,0x4C,0xE8,0x1F,
	0x86,0x3C,0x69,0x12,0xA3,0xE9,0x9D,0xEC,0xB4,0x93,0xA0,0x2D,0x61,0x5A,0xDF,0x5A,0x1E,0xC6,0x7A,0x13,0x58,0xCC,0xE0,0x18,
	0x74,0x3A,0xF9,0xE5,0x82,0xF7,0x62,0x42,0x50,0xB7,0x93,0x1B,0x5F,0x20,0xA1,0x0D,0x0C,0xF7,0x6E,0xB2,0x81,0xD2,0xEB,0x0D,
	0x3A,0x83,0x55,0xF6,0x0C,0x61,0xCA,0x92,0x4A,0xCC,0x74,0x8E,0xC3,0x50,0x84,0x3A,0xE9,0x58,0x82,0x1B,0x69,0xDD,0x7E,0xBE,
	0x7D,0x55,0x66,0x37,0xC2,0x7A,0x0D,0x61,0x6A,0x7F,0xD4,0xA5,0xC1,0x58,0x36,0x44,0x7E,0xA2,0xC4,0x43,0x0B,0x55,0x7E,0x9C,
	0x8C,0x7A,0xAA,0x9A,0x9F,0x06,0xC5,0xE3,0x24,0x9C,0xE3,0x39,0x9C,0x58,0xF4,0xF8,0xE7,0xF3,0x8D,0x55,0x91,0x65,0x0A,0x71,
	0x92,0x22,0x2C,0xC2,0x3D,0xF2,0xF2,0xD9,0xAE,0x33,0xCD,0xA7,0xA0,0xEB,0xA3,0x51,0x7E,0x16,0x44,0xF3,0xBB,0x1B,0x31,0x95,
	0x70,0x7F,0xF4,0xC8,0x73,0x5D,0xAA,0xBD,0x1D,0xD1,0x34,0x4D,0x95,0x56,0x1B,0xDA,0x03,0x1E,0xFF,0x79,0xB4,0xBF,0x97,0x16,
	0x5A,0x59,0xE0,0xA0,0xAB,0xE9,0x79,0xC5,0xA8,0x62,0xA4,0x4C,0x8C,0xAD,0xE9,0x19,0xCA,0x95,0xFB,0xD9,0x6A,0xA2,0x12,0x66,
	0xB5,0x22,0x29,0x18,0xE8,0x9F,0x3B,0x3C,0x67,0x4F,0x53,0xF9,0x3A,0x9D,0x61,0x7E,0x21,0x47,0x0D,0xB3,0x87,0x0A,0x67,0xBF,
	0xDF,0x51,0x7B,0xEC,0xAF,0xE2,0xC7,0x36,0xFE,0x22,0x74,0xA1,0xB4,0xF5,0xC3,0x4E,0x5F,0x55,0x54,0xF6,0xD1,0x30,0xAE,0x09,
	0x17,0xA3,0x78,0x0E,0x6B,0x2E,0xBD,0x34,0xC1,0x4B,0xCD,0xCE,0xFC,0x70,0x08,0xE5,0x3D,0x37,0x6D,0x55,0x07,0x81,0xDD,0x63,
	0x44,0x1F,0xE7,0xC2,0xA5,0xE1,0xAC,0xE8,0x1D,0x3D,0xD4,0x0B,0x06,0x6D,0x5A,0xDB,0x0D,0xD5,0x6B,0xB1,0xCC,0xB3,0x54,0x28,
	0x78,0x1A,0x9A,0xEB,0x80,0x73,0x43,0x7E,0x9E,0xE0,0x7B,0x2D,0x50,0x62,0xE2,0x85,0x10,0x94,0x7A,0x55,0x85,0xB5,0x12,0x3A,
	0x7B,0xD4,0xE9,0x6B,0x1D,0xAE,0xE8,0x87,0x3F,0x86,0xBF,0xC4,0x7A,0x61,0x77,0x0F,0x58,0x44,0x83,0xE5,0xF0,0xCE,0x7E,0xD7,
	0x7D,0xA7,0x9C,0xB9,0x01,0xAC,0x94,0xEC,0xAA,0xEF,0xFA,0x4A,0xB5,0x46,0xFD,0x51,0x27,0x5F,0x9B,0xD4,0xE4,0x89,0x5E,0xB3,
	0xCA,0xAC,0x8B,0x6E,0x27,0x8D,0x54,0x9B,0x20,0x0B,0x6C,0x1D,0x02,0xB2,0xD7,0x04,0xD9,0x7F,0x16,0x12,0xAF,0xD2,0xA0,0x30,
	0x19,0x32,0xAF,0xF6,0x53,0x91,0x73,0xC3,0xF1,0xDB,0x3E,0xDE,0x3E,0x53,0x8F,0x6D,0x0D,0x3A,0xBD,0x4E,0x37,0x77,0xD0,0x9F,
	0xF4,0x2E,0x1B,0x21,0x97,0xCF,0x41,0x6A,0x8D,0x90,0x25,0xAA,0x88,0x1C,0x52,0x6F,0x84,0xCC,0xDD,0x65,0x28,0x81,0xDC,0xEE,
	0x0C,0xBF,0x49,0x90,0x18,0xDA,0x71,0xA3,0x55,0xA7,0x9B,0x45,0x16,0x2F,0xDC,0x5A,0x69,0xC4,0xCA,0xC4,0xE5,0x0E,0xF4,0x53,
	0xDB,0xF0,0x89,0xAE,0xB0,0xD6,0x7E,0xD4,0x1D,0x4A,0xEA,0x60,0x6D,0x71,0x38,0x36,0x85,0xC3,0xBB,0x13,0x1C,0x7F,0x62,0x9B,
	0x20,0x26,0xB9,0x69,0x19,0x66,0x54,0x3B,0x32,0xFC,0x5C,0x87,0x73,0xDC,0x4A,0x52,0x53,0xE9,0x88,0x08,0x19,0xB6,0x77,0xBD,
	0x24,0x6A,0x29,0x02,0xA8,0x82,0x4A,0x2B,0xAB,0xB1,0x6B,0xBC,0x79,0x7B,0x8A,0x92,0x9E,0xA6,0x69,0xC3,0x22,0xCD,0xA8,0xA4,
	0x79,0x3D,0xB4,0x96,0x01,0x78,0x6C,0x39,0x8E,0xD9,0x30,0x20,0xBB,0xAF,0xF6,0xFA,0x05,0xEB,0xE8,0x21,0xD8,0x29,0x7A,0x47,
	0x67,0x2B,0x78,0xBC,0x96,0xEB,0xA3,0xCE,0xB0,0xAB,0xE3,0x32,0x33,0xEC,0x82,0x6D,0xC1,0x56,0x9C,0x2E,0x7C,0xD6,0x19,0xE1,
	0x6F,0xBB,0xFD,0x9E,0xAA,0x8B,0x35,0x1F,0x9E,0x82,0xB9,0x00,0xDF,0x55,0x06,0x4A,0x1B,0xEB,0x89,0xBE,0x9F,0xE3,0x27,0xC7,
	0xD8,0xB2,0xAC,0x1A,0xB8,0xC7,0xEE,0x2B,0x47,0x7B,0x69,0xCB,0x90,0x39,0x63,0xF2,0x6A,0x0E,0x43,0x25,0x35,0x8F,0x2E,0x5F,
	0x1A,0x13,0x9A,0x48,0x8F,0x6B,0x00,0x43,0xA5,0x3D,0x82,0x2A,0x9C,0x5A,0xF7,0x98,0x0B,0x79,0x62,0xEF,0x97,0xE4,0x77,0xD4,
	0xEA,0x77,0xFA,0x3D,0x49,0x37,0x06,0x1F,0x09,0xA7,0xAE,0xBB,0x56,0xC6,0xBB,0x5D,0x03,0x4D,0xB2,0xA5,0x69,0x9D,0x5E,0xDE,
	0xDC,0xC0,0x7E,0x1D,0x74,0xFB,0x03,0x6C,0x58,0x17,0x6F,0xA9,0xE6,0xED,0x0D,0x7F,0x8E,0x7E,0x1B,0xD6,0x04,0xDE,0x80,0x96,
	0xA8,0xCB,0x91,0xE1,0x34,0x88,0x92,0xC6,0xBA,0x0C,0x8B,0x96,0xE2,0x48,0x5B,0xCF,0x29,0x99,0x8C,0x36,0x31,0xC0,0x34,0x20,
	0x6F,0xAA,0xA2,0x5F,0x71,0x20,0xA9,0x3E,0xB7,0x7B,0x39,0x1C,0x26,0xD2,0xA4,0xBA,0x31,0x87,0x9A,0x1C,0x4E,0x98,0x3E,0x49,
	0x1A,0x37,0xB1,0x58,0xD8,0xDD,0x27,0x1E,0x0C,0x74,0x69,0x1A,0x9F,0x4B,0x23,0x28,0x79,0xE3,0x56,0x1D,0x55,0x42,0x7E,0x75,
	0xF3,0x6D,0x4B,0xC4,0x1C,0x55,0x62,0x32,0x34,0x19,0x69,0x99,0xA2,0x6D,0x4C,0xCF,0x7B,0x22,0xBF,0x38,0x50,0x39,0xFB,0xB2,
	0x2E,0xCC,0x6E,0x37,0x81,0xF3,0x5C,0xCB,0xF7,0x8D,0xFA,0x70,0xD0,0x5C,0xE3,0xD4,0x32,0x05,0x11,0x65,0x40,0x77,0xD4,0xED,
	0xA9,0x5C,0x06,0x0C,0xB4,0x1E,0xDA,0x75,0xD1,0x0F,0x4A,0xF4,0x6B,0x05,0x56,0x61,0x90,0x64,0x5C,0x38,0x60,0x65,0x4E,0x59,
	0xEA,0x55,0x78,0xA5,0xA6,0x41,0x09,0xEB,0xD7,0x73,0x26,0x9F,0x98,0x22,0x9D,0x43,0x75,0xA4,0x6A,0xE8,0x7C,0x3F,0x1C,0xF5,
	0x40,0x39,0xEF,0xC5,0x13,0x26,0xFC,0x20,0xFA,0x0A,0x7A,0xCD,0xE0,0x17,0xBD,0xB0,0x2E,0x78,0xAF,0xDE,0x04,0x2A,0xB2,0x85,
	0x45,0x51,0x7E,0xB7,0x84,0x75,0x8C,0xEC,0x92,0x9C,0x18,0xD1,0x53,0x77,0xE7,0x63,0x4C,0x02,0x51,0x01,0xD0,0x3A,0x6A,0xC1,
	0x36,0x40,0xD5,0x02,0xC9,0x68,0x73,0x63,0xEF,0x1B,0xF7,0x74,0x2B,0x4C,0xEB,0x0C,0x0A,0xD6,0x81,0x3A,0x51,0xB4,0xD8,0x7B,
	0x0F,0xE6,0x13,0x9E,0x1C,0x25,0xCA,0x86,0x4E,0xAF,0x48,0x3B,0xC7,0x15,0x90,0xAD,0x74,0xDD,0x81,0xCE,0x57,0xC1,0x81,0x2E,
	0x3E,0x14,0x0A,0xDE,0x88,0x59,0x9D,0xED,0x2E,0x56,0xC0,0x7B,0xDA,0x19,0xCD,0xF2,0x44,0x60,0x24,0x79,0xC1,0x96,0x47,0xB2,
	0x5B,0x23,0xE3,0x9A,0x01,0xB1,0xC1,0x67,0xEE,0xD2,0x26,0x44,0xAB,0xA7,0x78,0xAA,0xA6,0x6B,0xB2,0xFA,0x87,0xCA,0x3D,0x25,
	0x78,0xF7,0xEA,0xA9,0x6D,0x39,0x81,0xCD,0xD2,0x0D,0x58,0x7E,0xE0,0xCA,0x3A,0xBA,0x40,0xB9,0xEA,0x17,0xCC,0x9A,0x12,0x89,
	0x11,0xD1,0x2E,0x41,0x31,0xF4,0x68,0x24,0x46,0x43,0x47,0xBD,0xA4,0xA4,0x6F,0xEB,0xA5,0xCA,0x32,0xAB,0x01,0x1E,0xC6,0x61,
	0xF7,0x38,0x91,0x4E,0x5A,0xB4,0x7A,0x83,0x9C,0x7E,0x57,0xB3,0x11,0x22,0x80,0x57,0x7B,0xD2,0x09,0x84,0x08,0x08,0x1D,0xDC,
	0x2D,0x1A,0x3F,0x9D,0xC3,0x41,0x67,0x10,0xFE,0x5B,0xFC,0xB7,0x2D,0xFE,0x13,0x99,0x28,0xBD,0x43,0x30,0x58,0x34,0xED,0x70,
	0x10,0xF5,0x7C,0x78,0x81,0x70,0x03,0x27,0x55,0xD6,0x07,0x57,0x23,0x23,0x18,0xCD,0xBA,0x6B,0xE2,0x83,0x63,0x2E,0xB1,0x02,
	0xD5,0x49,0x29,0xF4,0x0D,0x0D,0x23,0xDC,0xDC,0xDC,0x5A,0xC6,0x3E,0x70,0xB7,0x46,0x80,0x19,0xC7,0x65,0x87,0x17,0x77,0x7A,
	0xE7,0xEC,0xE9,0xCA,0xDD,0x2D,0x86,0xBB,0xE5,0x09,0x01,0x88,0xE3,0xA8,0xD5,0x1B,0xAA,0xD2,0x1B,0x85,0x5A,0x8A,0xC6,0x52,
	0x38,0x0B,0x9A,0x72,0x3C,0x69,0x77,0x07,0xF5,0xFE,0x09,0x76,0xF0,0x4F,0xB2,0x71,0x5A,0x74,0x94,0x65,0xE9,0xED,0x69,0x9B,
	0xC9,0x82,0xA6,0x0D,0x7B,0xB2,0xAE,0x5A,0x15,0x86,0x65,0x98,0x99,0xAB,0x60,0x96,0xB2,0xC8,0x8E,0xD3,0x46,0x62,0xB7,0x35,
	0xD2,0x7A,0x3D,0x49,0x39,0xA1,0x8A,0x39,0xCA,0x70,0x0B,0x6F,0x0F,0x12,0xF0,0x3B,0xF6,0x56,0x57,0xFB,0xA0,0xFE,0x40,0x04,
	0xC7,0xA9,0xFA,0xA8,0x97,0x31,0xE2,0x4B,0x1C,0x8B,0x2A,0xF7,0x1A,0xF4,0x86,0x82,0xB8,0xDA,0xDF,0xDD,0x35,0xF0,0x1B,0xC0,
	0x4B,0xD5,0x87,0x52,0xD3,0x11,0x56,0x94,0x6E,0x1F,0xD4,0x5E,0xC6,0xF3,0x76,0x6E,0xE5,0x91,0xD4,0x72,0x5E,0x6F,0xA0,0xCB,
	0x2A,0x86,0x2A,0x9F,0x8F,0xE7,0x78,0x49,0x0E,0x3F,0x8C,0x94,0xF4,0x0F,0x07,0x1E,0xDE,0xBD,0x52,0x1E,0xD1,0xC7,0x69,0x43,
	0x4D,0x5A,0x0D,0x55,0xE5,0x68,0xF0,0xC1,0x76,0x67,0x5B,0x77,0x56,0xEE,0xA8,0x27,0x18,0x85,0x39,0xBF,0x70,0x0D,0x0D,0xB5,
	0xBA,0x71,0x93,0x00,0x08,0xE1,0x15,0x96,0x1C,0x9A,0x7C,0x75,0xC6,0x5C,0x81,0x1B,0x63,0xBB,0x25,0xCB,0x6C,0xA1,0xD9,0x15,
	0xD9,0xDC,0x9A,0xCA,0x55,0xE8,0x91,0xDE,0x67,0x8A,0xF6,0x88,0x99,0xFF,0x5A,0x67,0x84,0xBF,0xEB,0x72,0x75,0x16,0x3F,0x19,
	0xF5,0xF0,0x2F,0xDD,0x0E,0x9B,0xAD,0xCC,0xE9,0x0F,0xFF,0xEE,0xA2,0x4A,0xF4,0x93,0x63,0xDD,0x35,0xDD,0x5D,0xD1,0x32,0xEF,
	0xB6,0xA2,0x0B,0xB8,0xB0,0xBD,0x34,0xE4,0xF7,0x9F,0xB3,0x30,0x5D,0xCB,0xE1,0xCA,0xC5,0x5F,0x5F,0x1C,0x40,0x03,0x5B,0x90,
	0x70,0x14,0x32,0x89,0xC3,0xF0,0x57,0x59,0x0D,0x85,0x0F,0xA6,0x4B,0x77,0xBF,0xDE,0x18,0x96,0xDD,0xE4,0xFD,0x82,0xCD,0x22,
	0xEF,0x6C,0xE2,0x8D,0xBB,0x32,0x56,0x1B,0xCB,0x31,0x31,0x9F,0x8F,0xC8,0x4E,0xE2,0xED,0xB7,0xCA,0x95,0x71,0x6F,0xFC,0xCB,
	0xAA,0xB1,0x50,0xF8,0x3A,0x99,0x73,0x02,0xD7,0xE0,0xEE,0x61,0x29,0xBE,0x6D,0x12,0x13,0x08,0x42,0x4E,0xD5,0x25,0x5B,0x27,
	0x32,0xCC,0x18,0x9E,0xB1,0x32,0x9A,0xF9,0x61,0x47,0x9D,0x5E,0x87,0xB2,0x0B,0x57,0x9C,0xD0,0x92,0x57,0x20,0x69,0xE5,0x1F,
	0xB9,0x9E,0x54,0x1A,0x02,0x5E,0x81,0xA9,0x94,0xA5,0x1F,0xEA,0x95,0x57,0x66,0x60,0xD8,0xCA,0xB1,0x19,0xB0,0x2B,0x7A,0x69,
	0xB6,0xB7,0xAE,0x0F,0xA4,0x87,0x8E,0x5A,0xAE,0x4B,0x5F,0x59,0x2B,0xCF,0x65,0x97,0x91,0xD0,0xDF,0xEF,0xA8,0xA3,0x65,0x3D,
	0xB3,0x35,0xA1,0x14,0x31,0x8D,0x77,0x31,0xEB,0x00,0x1B,0x06,0x98,0x48,0x87,0x55,0xE1,0x39,0xE2,0x34,0xC9,0x1D,0xF2,0x28,
	0x5F,0xE8,0xBE,0x49,0x10,0x05,0xE7,0xA1,0xE5,0x29,0x1B,0xC3,0xD4,0x55,0x85,0x23,0x78,0xBA,0x81,0x11,0xE4,0x62,0x72,0x9B,
	0x79,0x60,0xDC,0xDD,0x89,0xC0,0x30,0x96,0xA1,0x00,0xE3,0x99,0xAA,0x2A,0x03,0x4A,0x8F,0x9A,0xD5,0xBD,0xCA,0x8D,0x23,0x2E,
	0x7B,0xA6,0xD6,0xCE,0x14,0x57,0xD5,0x90,0x7D,0x45,0xBA,0x56,0x64,0xD8,0x56,0x48,0xF1,0x29,0xA6,0xED,0xB9,0x83,0xB6,0x34,
	0x10,0xAB,0xBA,0x3E,0x2A,0x70,0x72,0x97,0x76,0x26,0xC3,0xB9,0xB8,0x23,0xB1,0x55,0xCE,0x0D,0x7B,0x69,0xD2,0x4E,0x65,0xA3,
	0xE4,0x91,0x35,0xA2,0x79,0xDB,0x66,0xC6,0xDA,0x12,0xF9,0x3B,0x99,0x65,0x49,0x08,0x99,0x6A,0x69,0xA3,0xBE,0xBA,0x2C,0x34,
	0x76,0xF2,0xB1,0x14,0xC2,0x86,0x4E,0xE0,0xB8,0x05,0x22,0xCF,0x63,0x38,0x83,0x88,0xB3,0xC2,0xCC,0x15,0x61,0xD6,0x77,0xE9,
	0xDE,0x64,0x51,0x91,0x45,0xEE,0x9E,0x22,0x3F,0x7F,0x6A,0x33,0xA0,0x2F,0xD6,0x48,0xB0,0x62,0x0B,0xAB,0x20,0x84,0x2C,0xCB,
	0x72,0x69,0x60,0xA8,0x1F,0xCB,0x0F,0xEF,0x19,0xCB,0x6C,0x8C,0x0C,0xAF,0x42,0x4E,0xB2,0x7E,0xAD,0x2A,0x5C,0x19,0x4E,0x60,
	0x28,0x33,0x23,0x79,0x7B,0x4A,0x58,0x85,0xDE,0xEB,0x54,0x61,0xBE,0x61,0xA7,0x82,0x53,0xDD,0x10,0x56,0x41,0x7B,0xA5,0x2A,
	0xFC,0x73,0x9F,0xBB,0xCF,0x31,0xAC,0x82,0xFE,0x3A,0x55,0x88,0x7E,0x99,0xA8,0x45,0x58,0x85,0xFE,0x2B,0x55,0x61,0xEF,0x05,
	0xD9,0x7C,0x8C,0xBC,0x0A,0xBB,0xEC,0x06,0x02,0xBD,0x0A,0xE8,0xAC,0x53,0x30,0xB9,0x0B,0xFC,0xEB,0xCC,0xDC,0xF2,0xF8,0xE1,
	0x40,0x26,0x95,0x0D,0x4B,0xCF,0x23,0xAB,0xA5,0x0E,0x45,0xD2,0x80,0xFD,0xCA,0x6C,0xE6,0x04,0x45,0x17,0x68,0x61,0xB0,0x58,
	0xDE,0x05,0xDA,0x8F,0x5C,0xA0,0x73,0xF3,0x4B,0x40,0xDD,0x4F,0x48,0xB6,0xAE,0x28,0xD4,0xA5,0xD0,0x7B,0xA4,0xF5,0x38,0x8F,
	0x5F,0xFE,0x15,0xE7,0xD1,0x88,0x52,0x5D,0xD4,0x7B,0x58,0x74,0xB0,0x1F,0xCB,0x78,0xE9,0xB8,0x57,0x25,0xD2,0xFA,0x0B,0x79,
	0x78,0xE3,0x62,0x3D,0x12,0x56,0xA7,0x61,0x76,0xCB,0xB7,0x19,0x0F,0x13,0x48,0xD9,0xB6,0x32,0x7F,0xD8,0xC3,0xBF,0xC3,0x64,
	0x02,0xB9,0x7B,0x76,0x38,0x6F,0xAA,0x77,0xB2,0x03,0x56,0x86,0xF7,0x99,0x10,0x33,0x19,0xB6,0x6F,0xA4,0x16,0x05,0xD2,0x17,
	0xF2,0x58,0x08,0x46,0x16,0x28,0xDE,0x5D,0x74,0x47,0x38,0xB4,0x06,0xDA,0x29,0xEE,0x77,0x2B,0xA8,0x0D,0x07,0xE6,0x54,0x43,
	0x59,0xA0,0x6B,0x51,0x6D,0x1B,0x4C,0xA2,0x56,0xB4,0x67,0x2F,0x0F,0x14,0x81,0x9B,0x5B,0x13,0xC3,0x44,0x31,0xE1,0xFA,0xDA,
	0x32,0x2A,0xAE,0x4A,0x60,0x40,0xBC,0xCF,0x2A,0xED,0xA1,0x22,0x03,0x8F,0x8C,0xC0,0x76,0x65,0xAE,0xB7,0xE0,0x40,0xFD,0xF4,
	0xD9,0x40,0x3C,0xD0,0x7F,0xEC,0xE1,0x98,0xAD,0xB9,0x1D,0x81,0x03,0x27,0xCF,0x06,0xE2,0x54,0x60,0x97,0x11,0xD4,0x5D,0xFE,
	0xC0,0x81,0x67,0x99,0x74,0x02,0x64,0x60,0x2A,0x93,0xC7,0xFB,0x2B,0x71,0xDB,0x95,0xF2,0xF3,0xDE,0xF0,0x00,0x9F,0x38,0xC0,
	0x20,0x80,0x3F,0x3E,0x17,0x78,0xFC,0xC0,0x0D,0x53,0xD1,0xAB,0xF0,0xFF,0xAB,0xF5,0xF1,0x03,0xBB,0x09,0xF4,0xFD,0x22,0x39,
	0x88,0x04,0xF0,0xA7,0xE7,0x02,0x71,0x4D,0xC4,0xED,0x6E,0x4B,0xEE,0x1D,0x9E,0x67,0x73,0x94,0x34,0x02,0x72,0x9C,0x48,0x76,
	0xC1,0xCF,0x83,0x94,0x76,0xE9,0xE5,0xB3,0x81,0xC9,0x0E,0xAD,0xBC,0x57,0x86,0x03,0x8F,0x9E,0x3B,0x4A,0x71,0xBE,0xDF,0xBB,
	0xCA,0x85,0x6F,0x1B,0xEC,0xAA,0x83,0x52,0x28,0x07,0x6A,0xD9,0xBC,0xF1,0x64,0xE0,0xCC,0x7D,0x02,0xB9,0xFA,0x93,0x83,0x9E,
	0x31,0xBF,0xEA,0x55,0x8A,0x16,0x1E,0x3F,0x17,0x28,0x0C,0xFA,0x9A,0xA5,0x29,0x06,0x9E,0x3F,0xF7,0x1D,0x86,0x40,0x3C,0xD4,
	0x27,0xF1,0x0E,0xCF,0xB3,0x19,0x59,0xE8,0xC0,0x70,0x7D,0xF2,0xC3,0x05,0xAA,0x2C,0xB6,0x9F,0x01,0xE7,0xCD,0xA6,0xC5,0x0C,
	0xAF,0xE0,0x25,0x6F,0xF6,0x0D,0x07,0xA5,0xCB,0x53,0x4E,0x81,0xEA,0xAA,0x39,0x1E,0xC6,0x05,0x52,0x0E,0x28,0xA1,0xD3,0x54,
	0x6E,0xBB,0x0F,0x23,0x02,0x4B,0x89,0xF2,0x23,0x87,0x13,0x71,0xD4,0x14,0xAC,0xF8,0xA5,0xC4,0xE2,0x5C,0x61,0xBC,0x16,0xF3,
	0x95,0x01,0xA6,0x27,0xAD,0xA3,0x99,0xC7,0xA6,0xAC,0xDD,0xD9,0x17,0x3B,0xE2,0xC1,0xA7,0x3C,0x5F,0x18,0x67,0xC6,0x77,0x9F,
	0x12,0xFA,0x5A,0x1B,0xEA,0x4D,0xDF,0x6D,0xE2,0xAE,0x55,0x69,0x6D,0x80,0xF1,0xF0,0x92,0x80,0x22,0x79,0x40,0xE5,0xD9,0x98,
	0x83,0xEE,0xD4,0xB0,0x57,0xE5,0x62,0x56,0xF0,0xB2,0x89,0xFB,0x9F,0xCF,0xE3,0xF7,0xBC,0x32,0x67,0x6E,0x6A,0x24,0x71,0x5E,
	0x36,0xBD,0xFD,0xF3,0x79,0xE1,0x9D,0x5B,0x19,0xA2,0xE0,0xF5,0x5F,0x86,0x57,0xAF,0x5C,0x09,0xDE,0xEA,0xC5,0x78,0xE1,0xBA,
	0x1C,0xB6,0x0F,0x9A,0x7C,0xEF,0xC5,0x42,0x4A,0xF0,0xEE,0x5F,0x82,0x57,0xA3,0x5A,0xB5,0x22,0x1E,0x6A,0x55,0x2F,0xCD,0x6B,
	0x17,0x27,0x65,0x63,0xBC,0x75,0x6E,0xAF,0xF8,0x79,0xBC,0x8A,0xB4,0x6C,0x82,0xF7,0x22,0xE3,0xB3,0x56,0x63,0x8C,0xFB,0xF3,
	0xA7,0x97,0xE0,0x9D,0xBA,0x9E,0xE9,0x07,0xDB,0x2A,0xC3,0x26,0x1C,0x2F,0xC3,0xE7,0xF2,0x0E,0x2B,0xB5,0xC6,0x43,0x56,0x83,
	0xC3,0x56,0xD4,0xBE,0xCB,0x97,0x68,0x9F,0x4C,0xA2,0x3B,0xF1,0xFE,0x5E,0x44,0x9E,0x55,0xA6,0xBA,0x33,0x9E,0xE2,0xF7,0xB7,
	0xEE,0xBC,0x88,0x7C,0x61,0x9D,0x89,0xB6,0x14,0xBF,0x90,0x54,0xF9,0x36,0x6C,0x5F,0x5E,0x7E,0x9A,0x2F,0xC1,0xBB,0x32,0x3C,
	0xD7,0x75,0xD8,0x45,0xC1,0x79,0x5D,0x3F,0x3D,0x5E,0xF6,0x2F,0xC1,0x43,0x10,0xBF,0x0B,0x31,0x76,0xF6,0x8A,0xA6,0x9E,0x7A,
	0xC6,0xD6,0x4C,0xB4,0x6F,0xF0,0x52,0x3C,0x9E,0xC4,0x8F,0x25,0x3D,0x31,0xED,0x6D,0x3E,0xA0,0x8C,0xF3,0x5E,0x46,0xBE,0xE0,
	0x24,0x98,0x9A,0xC6,0x6A,0x53,0xDE,0x9D,0x61,0xFB,0x82,0x17,0xE1,0x49,0x18,0x19,0x82,0xB7,0x7E,0x09,0x9E,0x4C,0x32,0x46,
	0x31,0x1F,0xB2,0x97,0x53,0x35,0xE3,0x49,0x5C,0xDA,0x29,0xDA,0xA7,0xBF,0x04,0x4F,0xCC,0xB6,0x50,0xA6,0x89,0x9B,0xEA,0x0B,
	0xD7,0xDB,0xCD,0x0B,0xF2,0x2A,0x13,0x40,0x8A,0xFE,0x7C,0xC9,0xF6,0x55,0xA6,0x80,0x14,0x3C,0xEA,0xFC,0x73,0x3F,0x9B,0x64,
	0xBF,0x65,0xD8,0x9F,0xF2,0xF1,0x26,0x21,0xCE,0xBA,0x47,0x8F,0xEC,0xB9,0x4B,0xBD,0xB0,0x80,0xED,0xE6,0x65,0xF3,0x03,0x24,
	0x71,0x89,0x3D,0x3D,0x85,0xC7,0xB7,0xB4,0xD5,0x2C,0x30,0xB5,0x36,0x58,0x1E,0xA6,0xB4,0x83,0x8E,0x14,0x97,0xE7,0xE6,0x34,
	0x0A,0x06,0xCC,0xEB,0x2F,0x75,0xC0,0x07,0x0B,0x2F,0x3A,0x6D,0x12,0xC3,0x83,0x71,0x11,0x5D,0xD9,0x7D,0x74,0xB1,0x57,0x01,
	0x93,0xCC,0x44,0x8B,0x8C,0x1D,0xAA,0x5A,0xB8,0x84,0x18,0x63,0x3C,0x1F,0xAD,0xC9,0x26,0x93,0xE8,0xA2,0x4D,0xC6,0x81,0x26,
	0xC5,0x06,0x4B,0x01,0x75,0x7D,0x24,0x3D,0x5E,0xC4,0xA1,0x64,0x86,0x0B,0x55,0x24,0xBC,0x0F,0x02,0x63,0xDD,0xD8,0x01,0xE5,
	0xFA,0xEB,0x04,0xF4,0xFC,0xF9,0xB4,0xF2,0xF6,0xE9,0x7A,0xCC,0xBB,0xDF,0x37,0xDA,0xFB,0xC1,0xF3,0xE6,0xD2,0x69,0x10,0x78,
	0xF8,0xE9,0x3C,0x30,0x82,0x7D,0xC3,0x14,0xFF,0xA3,0x8E,0x36,0x92,0xC6,0x71,0xDA,0xDE,0x0A,0x56,0x05,0xE7,0x14,0x65,0x68,
	0xBA,0x5E,0x14,0x7E,0x25,0x66,0x41,0xDA,0x7E,0x67,0x3F,0x23,0x0E,0x73,0x5F,0x2B,0x93,0x7D,0x60,0x93,0x0F,0x8C,0x62,0xBE,
	0x32,0xE9,0x83,0x8C,0x6A,0x82,0xC6,0xAE,0xDB,0xF3,0xF1,0x47,0x02,0xB0,0x95,0x3D,0x28,0x57,0x41,0x4B,0x36,0xED,0x27,0x23,
	0x30,0x1C,0x83,0x9D,0xB5,0x85,0x5F,0x7E,0x77,0xB3,0x0A,0x5C,0xBE,0xE1,0x74,0x06,0x3A,0xC4,0xBA,0x24,0xA2,0x96,0xDD,0xF3,
	0xA2,0xC9,0x05,0x29,0xF7,0x4B,0x60,0xAA,0xF2,0xDD,0xFC,0x9F,0xC0,0x30,0x2B,0x49,0x11,0x4C,0x2E,0x8C,0x2D,0x05,0xDB,0xB8,
	0x3B,0x93,0x1A,0x14,0x8D,0x3E,0x1E,0x62,0x56,0x28,0x4E,0x9B,0x19,0x3B,0x8B,0x1E,0xA6,0x8F,0x81,0xCF,0xB4,0x83,0x43,0x9C,
	0x36,0x37,0x96,0xE1,0x4A,0xC0,0x52,0x6F,0x4E,0xDD,0xED,0xB6,0x76,0x05,0x44,0x2F,0x9A,0x7C,0x56,0xA8,0x24,0x6D,0x65,0x6D,
	0xAD,0x80,0x28,0x32,0x51,0x74,0x0D,0xA5,0x0F,0xA7,0x25,0xBB,0x92,0x85,0xC8,0x90,0xC7,0x3F,0x28,0x0E,0xE4,0x85,0xFC,0x09,
	0xE3,0x8D,0x9B,0xC5,0x05,0x0F,0x07,0xA3,0x82,0xC4,0x1C,0x15,0xD3,0x6D,0x61,0x82,0x01,0xBE,0x72,0x9B,0x5C,0xA9,0xD1,0xEA,
	0xEB,0x7D,0x5D,0x3A,0x36,0xAD,0x2B,0x70,0x8E,0x63,0xF9,0x30,0x2C,0x57,0xE4,0x63,0x2C,0x38,0x07,0xBA,0xF9,0x0D,0xEB,0x62,
	0x1C,0x5F,0x03,0x70,0xD1,0x56,0x8E,0x2C,0xC7,0x65,0xD9,0x37,0x7C,0x85,0x2D,0xE9,0x72,0x54,0x4C,0xAF,0x55,0x90,0xE9,0xA2,
	0x48,0x43,0x69,0xF7,0xC2,0x55,0x20,0xCB,0x5B,0xB8,0x8F,0xB2,0xCB,0x1D,0x8A,0x93,0xEC,0x19,0xA8,0x2A,0xDE,0x61,0x3F,0x41,
	0x74,0xBF,0x34,0x08,0xBF,0x6B,0xF5,0x60,0x21,0x20,0x65,0x4D,0x62,0xB0,0x53,0xCB,0xDF,0x60,0xD8,0xCA,0xCC,0x25,0xCD,0x03,
	0xB5,0x9F,0x55,0xBF,0x64,0x60,0xE7,0x8D,0x22,0xD6,0xA1,0x65,0xAA,0x6C,0x56,0xBB,0x14,0xCC,0x59,0xD3,0x13,0x12,0xA2,0xAA,
	0x2E,0x9D,0xCA,0xAB,0x9B,0x78,0x6B,0xB9,0xC3,0x06,0x52,0xD1,0x77,0x2D,0x5D,0xED,0x76,0xF2,0x81,0x77,0x85,0x47,0x63,0x62,
	0x91,0xC2,0x80,0xC9,0x2C,0x73,0xE7,0x96,0x2D,0x39,0xFD,0x5A,0xBD,0x41,0x2E,0xD0,0xBE,0x5C,0x3C,0x77,0x8A,0x71,0x6D,0xBC,
	0xE9,0x45,0xEA,0x40,0x0C,0xE2,0xA4,0x33,0x59,0x94,0xE3,0x8E,0xF7,0xA0,0x2B,0x48,0x30,0x39,0x4E,0xA5,0xE3,0xAE,0x8C,0x7B,
	0xC7,0xBA,0x7B,0xC2,0x99,0x70,0x26,0xAF,0x84,0xB1,0xA0,0x22,0xE9,0x33,0xED,0x6A,0x12,0x67,0x37,0x38,0xCB,0x89,0x31,0x53,
	0x85,0xA7,0x91,0x0B,0xCD,0x56,0x71,0xE4,0x86,0xF1,0x6E,0x1A,0x59,0x22,0xA0,0x5B,0x16,0x9D,0x7E,0x4E,0x6F,0x42,0x45,0x0D,
	0xD4,0x13,0xDD,0x79,0x63,0xD9,0x2B,0x7A,0x58,0x18,0x9B,0xE8,0xF9,0x8B,0x64,0x8A,0xBB,0x33,0x31,0xF5,0xF0,0x8E,0x2A,0x0C,
	0x84,0xA6,0x49,0x4D,0x46,0xA3,0x2D,0xAE,0x08,0x9B,0x82,0xF1,0xDB,0x48,0xAC,0x64,0xCF,0x2E,0x56,0x88,0x95,0xC4,0x48,0x99,
	0xBA,0x8F,0x78,0xAA,0xCF,0xB3,0x6C,0xD2,0x99,0x58,0x6C,0x9B,0xAC,0x5A,0x94,0xE8,0xC9,0xF9,0xCA,0x33,0x1F,0xD7,0x1E,0xF1,
	0xA6,0x31,0x46,0x23,0x25,0x2B,0xE3,0xB0,0x1D,0xB3,0xC5,0xDF,0xD3,0xA0,0x2D,0xBD,0x93,0x4D,0xE6,0x14,0x4E,0x82,0xA2,0x50,
	0x65,0x3D,0xD1,0x95,0x7B,0x7F,0xB3,0x24,0x27,0x9C,0xC3,0x05,0xA1,0x8A,0xD7,0x4E,0x4F,0x3B,0x3D,0x04,0x7A,0xF4,0xE8,0xF9,
	0x10,0x38,0xCA,0x59,0x59,0x75,0xD6,0x31,0xC3,0x45,0xD1,0x82,0x67,0xD0,0xC8,0xDA,0x24,0x12,0x11,0x6E,0xD8,0x57,0x65,0xCF,
	0xB8,0x84,0xB8,0x0F,0x18,0x5F,0xF2,0x68,0xE0,0x79,0xD3,0xF9,0xCA,0x75,0x29,0xA7,0xA5,0xD9,0x75,0x4A,0x15,0xE9,0x85,0x93,
	0x0B,0x9E,0x8A,0x52,0x4C,0x05,0x0B,0x88,0x25,0x79,0xBB,0x35,0x8D,0x1D,0x73,0x1E,0x1A,0x6B,0x74,0x79,0xDB,0x94,0xAC,0x6B,
	0xC3,0xE1,0xB0,0x2B,0x99,0xE4,0x91,0xCF,0x3D,0x01,0x9B,0x78,0xA0,0x4D,0x9B,0x4E,0x10,0x66,0x7A,0x33,0x3D,0xCF,0xC0,0x6C,
	0xBC,0x62,0xA7,0x9B,0x27,0xEA,0xCD,0x54,0xA3,0x35,0x1A,0x16,0x9D,0x53,0x2E,0x87,0x15,0x46,0x10,0x84,0x15,0x48,0x26,0x1B,
	0x1E,0xC6,0x19,0x8F,0x45,0xD6,0xDE,0xC2,0x1E,0xC0,0x0A,0x64,0xDD,0x8D,0x65,0x15,0x08,0x63,0x18,0x42,0x1E,0x3B,0xF0,0x7A,
	0x6C,0xDC,0xDF,0x53,0x5E,0x29,0xF6,0xAE,0xE4,0x2A,0x58,0xDB,0xE0,0x85,0x67,0xAD,0x4D,0x6A,0xCA,0x10,0xB4,0x38,0x25,0x55,
	0xDF,0xF0,0xD4,0x52,0xEB,0x76,0x43,0x48,0x75,0x9C,0xE1,0xA9,0x7A,0xD6,0x7D,0x55,0x3E,0x65,0xF8,0x2A,0x8C,0x34,0xC5,0xC2,
	0x1C,0x07,0x78,0xCD,0x1A,0x26,0xE5,0xF0,0xAD,0x00,0x5D,0xF0,0xF5,0x5A,0x14,0xA3,0x95,0x1F,0x24,0x2E,0xA5,0x4D,0x5C,0xCB,
	0xA6,0x5C,0x61,0x2A,0x68,0x78,0x99,0x5B,0x51,0xFA,0x95,0x42,0xF1,0x2A,0x70,0xEC,0xE8,0x20,0xDD,0x77,0xA5,0xF0,0x03,0x51,
	0xD9,0x54,0x06,0xE5,0x56,0x20,0x9F,0x9B,0x7F,0x85,0xC6,0x5D,0x22,0x92,0x94,0x82,0x58,0xE0,0x3A,0xF2,0xCE,0x89,0x70,0x6E,
	0xC4,0x37,0x19,0xBC,0x65,0xB8,0x7F,0xD9,0x0C,0xF7,0xED,0x44,0x0A,0xFB,0x9A,0x0C,0xF7,0xE1,0xE6,0x81,0xAE,0xBC,0xE5,0xB7,
	0xAF,0xC6,0xBD,0xE5,0xB7,0x7F,0xCB,0x6F,0xFF,0x96,0xDF,0xFE,0x2D,0xBF,0x7D,0xD1,0x4C,0x78,0xCB,0x6F,0x5F,0x08,0x7C,0xCB,
	0x6F,0xFF,0x96,0xDF,0x5E,0xA2,0x75,0x6F,0xF9,0xED,0xD3,0x23,0xE5,0x2D,0xBF,0xFD,0x5B,0x7E,0xFB,0x1C,0xEE,0x2D,0xBF,0xFD,
	0x5B,0x7E,0x7B,0x59,0xE4,0x5B,0x7E,0xFB,0x62,0xE4,0x7F,0x42,0x7E,0xFB,0xFF,0x3F,0x33,0xCE,0xBF,0x66,0x4E,0xFF,0xB7,0xFC,
	0xF6,0xE5,0xC0,0xE2,0xFC,0xF6,0xED,0x38,0xC1,0x7D,0xBC,0xAC,0x87,0xE9,0xED,0xDB,0x89,0xFC,0xF6,0xED,0xFA,0x04,0xF7,0xED,
	0xB7,0x0C,0xF7,0x6F,0x19,0xEE,0xA9,0xB4,0xB7,0x0C,0xF7,0x8C,0x96,0x6F,0xDB,0x5B,0x86,0xFB,0x74,0xE3,0x7E,0xFF,0x19,0xEE,
	0x25,0x12,0xDC,0xC7,0x49,0xF0,0xD1,0x48,0x7A,0x4B,0x71,0x5F,0xD7,0xB6,0xDF,0x43,0x8A,0xFB,0x36,0x4F,0x67,0x5F,0x94,0xE2,
	0x3E,0x52,0xF2,0xDE,0x92,0xDC,0x4B,0xE1,0xDE,0x92,0xDC,0xD7,0xEC,0x86,0x7C,0xF3,0x96,0xE4,0x9E,0xDC,0xE8,0xB7,0x24,0xF7,
	0xF9,0xBE,0x7C,0x4B,0x72,0x2F,0x5F,0x8B,0xDF,0x6D,0x92,0xFB,0xF6,0xAB,0x67,0xB9,0x6F,0x7F,0xBD,0x34,0xF7,0xA5,0xCC,0xB7,
	0x4C,0xF7,0x35,0x9D,0xF9,0x3B,0xCA,0x74,0xDF,0xE6,0xA9,0xEE,0xF3,0x99,0xEE,0xDB,0xA9,0x54,0xF7,0x6D,0x91,0xEB,0xBE,0xFD,
	0x96,0xEC,0x5E,0x0A,0xF7,0x96,0xEC,0x3E,0x8B,0x7B,0x4B,0x76,0xFF,0x96,0xEC,0xBE,0xAC,0xC5,0x6F,0xC9,0xEE,0xDF,0x92,0xDD,
	0xCB,0xC1,0xDE,0x92,0xDD,0x47,0xEE,0x92,0x6F,0xFE,0x47,0x24,0xBB,0xE7,0xA6,0x41,0xEC,0xF2,0x6F,0xFF,0x1B,0xB2,0xDD,0x7F,
	0xA5,0x3A,0x90,0xD2,0xDD,0x7F,0xA5,0x3A,0x90,0xF2,0xDD,0x7F,0xAD,0x3A,0x50,0x12,0xDE,0x7F,0xA5,0x3A,0x90,0x32,0xDE,0x7F,
	0xAD,0x3A,0x50,0x52,0xDE,0x93,0xEB,0xF0,0x96,0xF3,0xBE,0xA2,0x75,0xBF,0x8F,0x9C,0xF7,0x05,0xA9,0x4F,0xBE,0x6A,0xCE,0x7B,
	0x22,0xEF,0xD9,0x39,0xEF,0xEB,0x79,0x2F,0x9B,0xF3,0x3E,0xC7,0xFB,0xCA,0x29,0xEF,0x25,0x78,0x2F,0x9A,0xF1,0x5E,0x8E,0xD7,
	0x24,0xE1,0xFD,0xEE,0xB1,0x28,0x0D,0x1E,0x85,0xF7,0x12,0xF9,0xEE,0x49,0x3C,0x52,0xBA,0xFB,0xE2,0xB4,0xAC,0x24,0xDE,0x0B,
	0x64,0xBB,0xA7,0xF0,0x5E,0x22,0xD9,0x3D,0x85,0xF7,0x12,0xB9,0xEE,0x29,0x3C,0x5A,0xAA,0xFB,0xDD,0xA6,0x28,0xA7,0x37,0x95,
	0xF7,0xDC,0x4C,0xF7,0x24,0x1E,0x29,0xD1,0xFD,0x4E,0x5F,0x3E,0x73,0x7C,0xBE,0x44,0x9E,0x7B,0x0A,0x8F,0x96,0xE6,0xBE,0x38,
	0x0D,0x25,0x85,0xF7,0x12,0x59,0xEE,0x9B,0xF0,0x9E,0x93,0xE4,0x9E,0xC4,0x23,0xE5,0xB8,0xDF,0xF9,0x8D,0xE6,0xC3,0x0B,0xA7,
	0xB8,0x2F,0x32,0x0C,0xBF,0x66,0x8A,0xFB,0x2C,0xEF,0xAB,0x67,0xB8,0x2F,0x07,0xBE,0x62,0x82,0xFB,0xDC,0x5B,0xFD,0xFA,0xF9,
	0xED,0x6B,0x5F,0xEC,0x0B,0xE7,0xB7,0xA7,0xF3,0x9E,0x97,0xDF,0xFE,0x79,0x3C,0x7A,0x7E,0xFB,0xE7,0xF1,0xE8,0xF9,0xED,0x1B,
	0xF0,0x9E,0x95,0xDF,0xBE,0x19,0xAF,0x79,0x7E,0x7B,0x32,0xEF,0x99,0xF9,0xED,0x9F,0xC7,0xA3,0xE7,0xB7,0x6F,0xCE,0x6B,0x96,
	0xDF,0x9E,0xCC,0x7B,0x66,0x7E,0x7B,0x32,0xEF,0x99,0xF9,0xED,0x49,0xBC,0x17,0xC8,0x6F,0x4F,0x6E,0xDF,0x33,0xF3,0xDB,0xBF,
	0x18,0x4F,0x32,0xBF,0x3D,0x99,0xF7,0xCC,0xFC,0xF6,0x64,0xDE,0x33,0xF3,0xDB,0x93,0x79,0xCF,0xCC,0x6F,0xDF,0x88,0xF7,0x8C,
	0xFC,0xF6,0x4D,0x78,0xCF,0xC9,0x6F,0x4F,0xE7,0x3D,0x2F,0xBF,0x3D,0x99,0xF7,0xCC,0xFC,0xF6,0x74,0xDE,0xF3,0xF2,0xDB,0x93,
	0x79,0xCF,0xCC,0x6F,0xDF,0x94,0xD7,0x34,0xBF,0xFD,0x4B,0xF0,0x28,0xF9,0xED,0xAB,0x78,0x6F,0xF9,0xED,0xDF,0xF2,0xDB,0xD7,
	0xD2,0xDE,0xF2,0xDB,0xD7,0x37,0xEF,0x2D,0xBF,0x7D,0xB8,0x09,0x22,0xDE,0xDD,0x5B,0x7E,0xFB,0x22,0xD8,0x5B,0x7E,0xFB,0x84,
	0xF8,0x7A,0xCB,0x6F,0x5F,0x48,0x7B,0xCB,0x6F,0x9F,0x9A,0x6E,0x6F,0xF9,0xED,0x4B,0x68,0x6F,0xF9,0xED,0xF3,0x63,0xE5,0x2D,
	0xBF,0x7D,0x01,0xEC,0x2D,0xBF,0x7D,0x42,0x3C,0x77,0x8A,0x71,0x6F,0xF9,0xED,0x05,0xEE,0x2D,0xBF,0x7D,0xDC,0xC0,0xB7,0xFC,
	0xF6,0x55,0xB0,0xB7,0xFC,0xF6,0xB9,0x9E,0x7C,0xCB,0x6F,0x5F,0x02,0x7C,0xCB,0x6F,0xCF,0x17,0xBC,0xF6,0x5B,0x82,0xFB,0xB7,
	0x04,0xF7,0x52,0x15,0x78,0x4B,0x70,0x5F,0x40,0x7B,0x4B,0x70,0x5F,0x84,0x6B,0x9A,0xE0,0xFE,0xF2,0xF2,0xE4,0x0C,0xD3,0xDB,
	0x4F,0x6D,0x03,0x5F,0x23,0x2D,0xDD,0x48,0x08,0x1F,0x76,0x33,0xEA,0x0D,0xC2,0xAB,0x16,0xCA,0xB1,0x1F,0x78,0xAE,0x54,0xBE,
	0xEA,0x62,0xDA,0xB4,0x7F,0x9A,0x89,0x0E,0xAB,0xA2,0x1D,0xED,0x83,0xC0,0x75,0xD8,0xE8,0x44,0x83,0x9E,0xC2,0xE5,0xB4,0xB1,
	0x46,0xA0,0x61,0x40,0x04,0x8F,0xFE,0x70,0x2D,0x67,0x65,0xBB,0x20,0xD6,0x64,0x81,0x9C,0xF6,0x73,0x36,0x72,0x51,0x8A,0xC6,
	0x36,0x67,0xD9,0xB6,0xBE,0x2C,0x56,0xD0,0xB2,0x13,0xB0,0x8A,0x26,0x62,0x5A,0x59,0xA6,0x50,0x8B,0xD4,0x91,0xE1,0x7B,0xBB,
	0x25,0xF4,0xE4,0x99,0x07,0x53,0x4F,0x99,0x3F,0x58,0x1E,0x0D,0x15,0xD2,0x76,0xDA,0x3F,0x48,0x34,0xDC,0x15,0xFA,0x09,0x4C,
	0x4E,0x7E,0x76,0xC5,0x35,0xE5,0x32,0xAA,0x47,0x34,0x23,0x1B,0x21,0x59,0x45,0x3B,0x77,0x6D,0x96,0xD3,0x02,0x51,0x47,0xA6,
	0x4D,0x69,0xA0,0x18,0x93,0x23,0x02,0xED,0xD2,0x58,0xBA,0xB0,0xC2,0xBB,0xDE,0x93,0x32,0xDF,0xBA,0xD5,0xBB,0xB2,0x85,0xB4,
	0xE3,0x13,0x0A,0xCD,0x34,0x82,0x0D,0x2A,0x51,0x81,0x67,0xEC,0x7C,0xE5,0x3B,0xBE,0xC9,0xBC,0x5F,0xFB,0x7F,0xAA,0xE5,0xF2,
	0x9E,0xD4,0xEF,0x08,0xB4,0x1B,0x4C,0xFF,0x6D,0x2A,0x13,0x63,0x99,0x3D,0x6A,0x24,0xD9,0xB6,0xFE,0x9E,0x40,0x9B,0xEE,0xBD,
	0x1D,0x70,0xD8,0x36,0xC3,0xCA,0x35,0xC8,0xEF,0x6D,0xB7,0xC9,0xC6,0x41,0x57,0xD1,0x66,0xEE,0xD2,0x25,0x8F,0xFD,0x54,0xDB,
	0x28,0x92,0x6B,0x6E,0xD8,0x5B,0xD4,0xCD,0x9A,0xF7,0xE4,0x47,0x0A,0x8D,0xC5,0x03,0x2F,0x69,0x63,0x3F,0x41,0xDB,0xF9,0x3D,
	0x1A,0x8D,0x6F,0xF3,0xC2,0x12,0x77,0x6F,0x39,0xF7,0xD2,0x73,0x3B,0x6C,0xDB,0x9C,0x22,0x95,0x8B,0xEE,0x60,0xB9,0x76,0x9D,
	0xB6,0x1F,0xA0,0xF7,0xCE,0x5B,0x2B,0xB6,0x79,0xEF,0xBF,0xD2,0xFD,0x2D,0xD0,0x60,0x90,0xA1,0xA6,0x6D,0x06,0xE4,0x44,0x28,
	0xAD,0xBE,0xDA,0x97,0x5C,0xD9,0x59,0xB2,0xD4,0x88,0x77,0xEB,0xBA,0xB0,0x4E,0xD0,0xB5,0x26,0xB5,0xA7,0xA9,0x34,0x4D,0xE2,
	0xCA,0x5C,0x6D,0x0C,0x9E,0x0E,0x96,0xAA,0xBC,0xB4,0x7A,0xDA,0x68,0xA8,0xE7,0xFC,0x32,0x65,0xAD,0xD3,0xC3,0xA4,0xBB,0x2F,
	0x72,0x23,0xCF,0x0B,0xBD,0xDC,0x73,0x6B,0xC7,0x23,0xA4,0xA0,0xF1,0xBE,0x38,0x12,0xDD,0xFE,0x41,0xC1,0x8F,0xBF,0xAF,0xF3,
	0xD1,0x36,0x1A,0x4A,0xBE,0x72,0x03,0x3A,0x86,0x24,0xE2,0x79,0xB4,0xF4,0xAB,0xF5,0x29,0xD0,0x06,0x34,0xA6,0x66,0xC0,0x62,
	0x35,0xB7,0xDD,0x9D,0x89,0x19,0x32,0x61,0x95,0xEC,0xF7,0xC0,0xB0,0xFB,0xC2,0xFF,0xF9,0x53,0x39,0xBF,0x01,0xED,0xF7,0x34,
	0x86,0x5E,0xFE,0x66,0xAB,0x0A,0x5A,0x78,0xAF,0xD6,0xCB,0x98,0x1D,0x83,0x57,0x35,0x3B,0x06,0xAF,0x6A,0x76,0x0C,0x5E,0xD5,
	0xEC,0x18,0xBC,0xAA,0xD9,0x31,0x78,0x55,0xB3,0x63,0xF0,0xAA,0x66,0xC7,0xE0,0x55,0xCD,0x8E,0xC1,0xAB,0x9A,0x1D,0x83,0x57,
	0x35,0x3B,0x06,0xAF,0x6A,0x76,0x0C,0x5E,0xD5,0xEC,0x18,0xBC,0xAA,0xD9,0x31,0x78,0x55,0xB3,0x63,0xF0,0xAA,0x66,0xC7,0x80,
	0x6C,0x76,0x3C,0xC7,0x10,0x18,0xFC,0x67,0x1B,0x02,0x2F,0xAC,0x98,0x17,0xEE,0x6F,0xA4,0x80,0x5F,0xDF,0xF2,0x88,0x0C,0x8F,
	0xD7,0x31,0x05,0xDE,0x2C,0x81,0x37,0x4B,0xE0,0xCD,0x12,0x78,0x81,0x7E,0x4E,0x6C,0x40,0x7C,0xA5,0x0B,0x76,0xFF,0x53,0xBA,
	0xFD,0xD4,0xB6,0x76,0xBB,0x06,0x59,0x30,0x15,0x26,0x98,0x47,0xA3,0x02,0x39,0xD9,0x39,0x1C,0x8D,0xF8,0xBD,0x01,0x9D,0xE1,
	0x40,0x50,0xDB,0xE1,0x5F,0xF8,0x2F,0x99,0x53,0x03,0xEF,0x19,0xE9,0xB2,0x31,0x6F,0x04,0xE6,0xD2,0xC5,0x15,0x29,0x71,0x3C,
	0xF7,0x76,0x63,0x9A,0xB6,0x5F,0xB3,0x97,0xD7,0xD2,0xD5,0x5E,0xB7,0x8B,0x1B,0x79,0x71,0x35,0x4A,0x1B,0x0C,0x3C,0x86,0x73,
	0xDC,0x47,0x7F,0xE3,0x36,0x0A,0x44,0xD7,0x3A,0x2A,0xC1,0x6B,0x13,0x37,0xD0,0x6A,0x38,0xB8,0x58,0x52,0xBC,0x8E,0xBC,0x17,
	0x2C,0x6C,0xE2,0x83,0xA5,0xF4,0x1B,0x5E,0x09,0x8B,0x19,0x31,0x47,0xE4,0x26,0x16,0x0D,0xCB,0x94,0xAE,0x61,0xAC,0x56,0xA6,
	0xEF,0xBB,0x9E,0x65,0x4A,0xA9,0x1C,0xCF,0x19,0xD2,0xEC,0x76,0x1F,0x45,0xFD,0xA2,0xA7,0x2F,0x17,0x36,0x3F,0x83,0x36,0xB0,
	0x66,0x87,0x38,0x4A,0xF7,0x54,0x5B,0xC3,0x61,0xA7,0xD3,0x91,0x6A,0x7D,0x98,0x76,0xB9,0x38,0x57,0xC1,0xDE,0xBB,0x53,0x8E,
	0xD8,0x90,0x46,0xB1,0xDD,0x3F,0xEC,0xC9,0xFB,0x97,0xF1,0x68,0xC5,0x20,0x5F,0x85,0x10,0xCF,0x66,0x13,0xAF,0x87,0x92,0x18,
	0x62,0x39,0x20,0x6F,0x3C,0x3B,0x1C,0x7D,0x6A,0x1B,0xDB,0x72,0xCB,0x8E,0x03,0xA7,0x1D,0x35,0x33,0x87,0x2A,0x81,0x91,0x23,
	0x65,0xFC,0xF7,0xB8,0xA4,0x37,0x41,0xFA,0x75,0x04,0x69,0x3B,0x29,0x49,0x33,0x82,0xF4,0x7F,0xBA,0x1C,0x7D,0x49,0x31,0x9A,
	0x8B,0x2E,0x29,0x07,0xBE,0x9E,0x14,0x7D,0x13,0xA2,0xAF,0x2C,0x44,0xF3,0x21,0x37,0x5F,0x59,0x88,0x96,0x02,0x99,0x10,0x9D,
	0x4F,0xC6,0xD7,0x9F,0x6E,0x66,0xC7,0x27,0x33,0x50,0x44,0xBB,0xCA,0x7F,0x2B,0xF3,0xF3,0x9B,0x5B,0xE5,0x2F,0x97,0xC7,0xB3,
	0xF1,0xED,0xF1,0xC5,0xEC,0x87,0xA9,0x01,0x06,0xC1,0x37,0x7F,0x50,0xE1,0x37,0xE7,0x17,0xC7,0x27,0xC9,0xDF,0x60,0xAF,0x69,
	0xF9,0x27,0x3E,0x38,0xEE,0xDD,0x9D,0xB5,0xB2,0x0C,0xFB,0xB7,0xCB,0xF9,0x93,0x13,0x6C,0xF0,0x7B,0x7A,0xE5,0xF7,0x04,0xE4,
	0xCF,0x4A,0x2F,0x8F,0x49,0x7E,0x0D,0xBF,0xD2,0xAF,0x2C,0xE9,0xDC,0xB4,0x41,0x0A,0xE2,0xF7,0x06,0x95,0xDF,0x9B,0xEC,0xFD,
	0xC0,0xDD,0x86,0x7A,0xF8,0xFC,0xD7,0xEB,0xC5,0x39,0xB4,0xFF,0xBF,0xA6,0xE3,0xC5,0x39,0x3C,0xD7,0x3A,0x36,0xEF,0x30,0x1A,
	0xC9,0x58,0xFA,0xAE,0xBD,0x87,0x51,0xB1,0x33,0xE0,0x3D,0x04,0xAE,0xC2,0x1B,0xD4,0xC2,0xF2,0xC7,0x5F,0x6C,0xF3,0x40,0x59,
	0x31,0xCF,0xCD,0x06,0x4F,0x0A,0xA0,0x01,0xEA,0xF3,0xFB,0x07,0x82,0xA7,0x1D,0xBC,0x2B,0xFE,0x65,0xE5,0x01,0x05,0x15,0x14,
	0xE5,0xEE,0x83,0xEF,0xBF,0xF9,0x43,0x07,0x5E,0x88,0xF2,0xF1,0x64,0x36,0xBF,0xB8,0xB9,0x56,0xB4,0xC3,0x6E,0xF9,0x20,0xFA,
	0xEF,0xE4,0xD7,0xE0,0xC1,0x2E,0x3C,0x78,0x34,0xBB,0x98,0xFC,0xF4,0x69,0x3C,0x9B,0x54,0x8D,0x3E,0x68,0x37,0xB6,0x47,0x39,
	0x3A,0x39,0xBB,0xB8,0x4E,0x3C,0xD2,0xED,0x43,0x29,0x2A,0x94,0x72,0x72,0x79,0x32,0x59,0xC0,0xC7,0x9F,0xAE,0x7F,0x59,0x7C,
	0x9A,0x8C,0x8F,0x2E,0x4F,0x6A,0x4B,0x29,0x78,0x84,0x15,0xA7,0x25,0x8B,0x9B,0xDE,0xDC,0x9E,0xCC,0x3E,0x9D,0x7E,0xB8,0x9E,
	0x2C,0xA0,0xDA,0xF3,0x54,0xD1,0x25,0xC5,0x15,0x3F,0xC2,0x8A,0xD6,0x6B,0x8B,0xFE,0x74,0x3E,0xBE,0x3C,0xA5,0x15,0xCD,0x1F,
	0x61,0xE5,0xF7,0x92,0xE5,0xCF,0x26,0xBF,0x50,0x7B,0x22,0x7E,0x84,0x15,0xD7,0x87,0xE2,0x4E,0x2F,0x8E,0x00,0x79,0x33,0x5D,
	0x5C,0x4C,0xE6,0x92,0xC5,0x15,0x3C,0xC2,0x8A,0x1B,0x14,0x16,0xF7,0xE9,0x16,0x27,0x07,0xA9,0x38,0xFE,0x08,0x2B,0x13,0xA6,
	0xBD,0x72,0x7E,0x33,0x3F,0xF9,0x74,0x7A,0x79,0xF2,0xCB,0x05,0xFE,0x8E,0x85,0x9F,0xD6,0x55,0xB1,0xE0,0x11,0x56,0xDC,0x28,
	0x57,0x5C,0x57,0x2D,0x2A,0xAD,0xB2,0x38,0x7C,0x04,0x4B,0xC3,0xEC,0x5B,0xD9,0x5F,0x8D,0xE8,0xA5,0x8D,0x44,0x69,0x38,0x59,
	0xAE,0x2E,0xAE,0x2F,0x4E,0x2F,0xCE,0x3E,0x4D,0xCE,0xC7,0x17,0xD7,0x9F,0xBA,0x7D,0x89,0xD2,0xF2,0x8F,0xB0,0xD2,0x70,0xD2,
	0xCC,0xE1,0xA5,0x5F,0x9F,0x7D,0x42,0x5E,0x51,0x39,0x45,0xA5,0x25,0x1F,0x61,0xE5,0x68,0x71,0x39,0xDD,0x6E,0x61,0x75,0xAA,
	0xCA,0xC1,0x47,0x58,0x31,0x7A,0x5C,0x8C,0x4A,0x2F,0x46,0x0D,0x8B,0xE9,0xC5,0xC5,0x68,0xF4,0x62,0xB4,0xB0,0x98,0x7E,0x5C,
	0x8C,0x4E,0x2F,0x46,0x0F,0x8B,0x19,0xC4,0xC5,0xDC,0x5E,0x2C,0xCE,0x3F,0x9D,0xCD,0x2E,0xA6,0xF3,0xA2,0xF6,0x15,0x16,0x93,
	0x79,0x84,0x95,0x88,0xC3,0x7D,0x71,0x32,0x39,0xBF,0x86,0xC9,0x3A,0xFE,0xE5,0x32,0x1E,0x26,0xD5,0x25,0x16,0x3F,0xC2,0x4A,
	0x1C,0x25,0x4A,0xC4,0xDF,0xB4,0xE7,0xBF,0xCE,0x17,0x27,0x57,0xF9,0xA9,0x5E,0x5C,0x62,0xFE,0x11,0x2C,0x15,0x43,0xE2,0x0B,
	0xBF,0x92,0x1B,0x6A,0xF5,0xA5,0x46,0x43,0x4D,0xED,0x26,0x0A,0x9D,0x5E,0x9F,0x7C,0xB8,0x1A,0x83,0x48,0x60,0xBF,0xFF,0x74,
	0x74,0xF2,0x11,0x84,0xD8,0x71,0x65,0xA1,0x25,0x8F,0xB0,0xA2,0xD5,0x44,0xD1,0xB3,0x8B,0xA3,0xA3,0x93,0xE3,0x92,0x59,0x51,
	0x5C,0x74,0xF2,0x11,0x2C,0xEF,0xCF,0x2C,0x6B,0xF6,0x81,0xC2,0xC2,0xA1,0x70,0x11,0x0D,0xF0,0x3E,0xC7,0xAA,0x35,0x54,0xC5,
	0x79,0x34,0xFB,0x70,0x84,0xA2,0xEE,0x68,0x7C,0x7D,0x9C,0x27,0x17,0xD7,0x20,0xF9,0x08,0x6B,0x89,0x9E,0x28,0xE7,0xE4,0x72,
	0x41,0x2D,0x07,0x1F,0xE1,0x2D,0x10,0xA3,0x90,0x52,0x99,0xE4,0x23,0xAC,0x32,0xBD,0x44,0xB7,0x72,0xF9,0x73,0x79,0x71,0xFD,
	0x53,0x6D,0x39,0x05,0x8F,0xB0,0xE2,0xFA,0x85,0xC5,0xF1,0x89,0xB2,0xB8,0xBD,0xF9,0x34,0x5F,0x7C,0x38,0x9E,0xCB,0x14,0x97,
	0x7D,0x84,0x95,0x3E,0xC8,0x95,0xBE,0x98,0x9D,0x8C,0x0B,0x1A,0x5F,0x55,0x3A,0x7F,0x84,0x95,0x37,0x2C,0x2E,0xEF,0x93,0x36,
	0xA4,0x96,0x87,0x8F,0xB0,0x22,0x93,0x93,0xB5,0xA4,0x72,0x55,0x45,0xC6,0x95,0xD3,0x3A,0xD9,0x92,0x3E,0x4D,0x40,0xA3,0xBC,
	0x3C,0x99,0x11,0x4A,0x8A,0x1E,0xE1,0x03,0x06,0xAF,0xD5,0xB6,0x4D,0xA6,0x59,0xA2,0xC3,0xBD,0x70,0x98,0xEB,0xC8,0x9D,0x5E,
	0x5E,0x7C,0xCA,0x2B,0x5F,0x9F,0xD4,0xCE,0xE4,0xAA,0x8C,0x5B,0xF5,0x08,0xD2,0xF5,0x6E,0x79,0xB9,0x5A,0x8F,0x5C,0x2E,0x7B,
	0x84,0x95,0xAB,0x96,0x97,0xDB,0xA3,0xD7,0xB7,0x17,0xD5,0x57,0xCB,0x96,0x8B,0xAA,0xD7,0xEC,0x66,0xF1,0x69,0x7E,0x72,0x3D,
	0xBF,0x99,0x49,0x95,0x9B,0x79,0x84,0x95,0xAB,0x17,0x95,0x7B,0x79,0x71,0x76,0x9E,0x2D,0xB9,0xA6,0xDC,0xD4,0x23,0xAC,0xE4,
	0x5E,0x51,0xC9,0xBC,0x59,0x5D,0x4D,0xB2,0x27,0x32,0x8F,0xB0,0x72,0xFB,0x15,0xE5,0x0E,0xE8,0xE5,0x0E,0xC2,0x72,0x07,0xE5,
	0xE5,0xAA,0xF4,0xFA,0xAA,0x51,0x7D,0x87,0xE5,0xE5,0xEA,0xB2,0x23,0x22,0xF3,0x08,0x2B,0x77,0x54,0x5E,0x6E,0x9F,0x5E,0x6E,
	0x3F,0x2C,0xB7,0x97,0x9B,0x71,0x89,0xCE,0x4A,0x55,0x58,0xAE,0x7F,0xA3,0x0A,0xF7,0x72,0x53,0x2E,0xFE,0x96,0xA6,0x0E,0xA9,
	0x05,0xF3,0x47,0x58,0xC1,0xE1,0x9C,0xCB,0x2B,0xE9,0x42,0x6E,0x8F,0x8F,0xE6,0x25,0x05,0x57,0x3E,0xC2,0x0A,0xD7,0xAA,0x0B,
	0xBF,0xF9,0xB0,0x10,0xE5,0x4B,0x17,0x1E,0x3D,0xC2,0xCA,0xD7,0x0B,0xCB,0x2F,0xB0,0x22,0xEA,0xCA,0x0F,0xAD,0x88,0x5E,0xAF,
	0xB8,0xC4,0xBC,0x25,0x51,0x5B,0xA2,0xB0,0x24,0x7A,0xE1,0x94,0xAB,0xB5,0x26,0xF2,0x25,0x16,0x5B,0x13,0xBD,0x70,0xB2,0xD5,
	0x5A,0x02,0xF9,0x12,0x33,0x96,0x40,0x6F,0x98,0x2E,0xAA,0xDC,0x1A,0x28,0x2D,0x2A,0xD4,0x96,0x7B,0xA3,0x74,0x51,0xE5,0x3A,
	0x78,0x69,0x51,0x05,0x3A,0x78,0xBF,0x93,0x2E,0xB5,0xDC,0x40,0x28,0x2D,0x35,0x34,0x10,0xFA,0xE1,0x14,0x2A,0xD4,0xCF,0x3F,
	0x0D,0xAA,0x8A,0x2A,0x7B,0x84,0x95,0xAB,0x56,0x96,0xDB,0xED,0x92,0xCB,0x85,0x47,0x58,0xC1,0x5A,0x75,0xC1,0x2A,0xBD,0x60,
	0x95,0x17,0xAC,0x57,0x17,0xAC,0xD3,0x0B,0xD6,0x79,0xC1,0xBD,0xEA,0x82,0xFB,0xF4,0x82,0xFB,0xBC,0xE0,0x7E,0x75,0xC1,0x23,
	0x7A,0xC1,0x23,0x5E,0xF0,0x20,0x53,0x70,0xA9,0xA2,0x57,0x5E,0x70,0xAC,0xE8,0xF5,0x87,0x45,0xA5,0x15,0x29,0x7B,0xE5,0xA5,
	0x25,0xD5,0xBC,0x05,0x86,0xC9,0x39,0x98,0xB0,0xD7,0x08,0xCC,0x2D,0xFC,0xF4,0xBD,0x72,0x71,0x3D,0xCF,0x79,0x70,0x12,0xE5,
	0xF1,0x5F,0x17,0x3E,0x09,0x92,0xB3,0xE8,0xD1,0xF0,0x49,0xF1,0xEB,0xC2,0x47,0x27,0xB3,0x9B,0xF9,0xBC,0xBC,0x4B,0xD8,0xAF,
	0xBF,0xF9,0xC3,0x47,0xCB,0xB7,0x96,0x96,0x6D,0x05,0x4F,0xC9,0x67,0x99,0x0B,0xB5,0xE4,0x41,0xFC,0x5D,0xD9,0x73,0xE7,0x15,
	0x75,0x3D,0x67,0x15,0x45,0x35,0x18,0x53,0x3C,0xB8,0x77,0xCA,0x9D,0x65,0x9B,0xDF,0xFC,0xE1,0xFF,0x01,0x2E,0x40,0x2D,0x96,
};

static int lcGetMinifigSettings(lcMemFile& File)
{
	const size_t CHUNK = 16384;
	int ret;
	unsigned have;
	z_stream strm;
	unsigned char in[CHUNK];
	unsigned char out[CHUNK];
	int pos;

	strm.zalloc = Z_NULL;
	strm.zfree = Z_NULL;
	strm.opaque = Z_NULL;
	strm.avail_in = 0;
	strm.next_in = Z_NULL;
	pos = 0;

	ret = inflateInit(&strm);
	if (ret != Z_OK)
		return ret;

	do
	{
		strm.avail_in = lcMin(sizeof(sDefaultSettings) - pos, CHUNK);
		strm.next_in = in;

		if (strm.avail_in == 0)
			break;

		memcpy(in, sDefaultSettings + pos, strm.avail_in);
		pos += strm.avail_in;

		do
		{
			strm.avail_out = CHUNK;
			strm.next_out = out;
			ret = inflate(&strm, Z_NO_FLUSH);

			switch (ret)
			{
			case Z_NEED_DICT:
				ret = Z_DATA_ERROR;
			case Z_DATA_ERROR:
			case Z_MEM_ERROR:
				(void)inflateEnd(&strm);
				return ret;
			}

			have = CHUNK - strm.avail_out;
			File.WriteBuffer(out, have);
		} while (strm.avail_out == 0);
	} while (ret != Z_STREAM_END);

	(void)inflateEnd(&strm);

	return ret == Z_STREAM_END ? Z_OK : Z_DATA_ERROR;
}

// =============================================================================
// MinifigWizard class

MinifigWizard::MinifigWizard(lcMinifig* Minifig)
{
	char Filename[LC_MAXPATH];
	strcpy(Filename, lcGetPiecesLibrary()->mLibraryPath);
	strcat(Filename, "mlcad.ini");

	lcDiskFile DiskSettings;
	if (DiskSettings.Open(Filename, "rt"))
	{
		ParseSettings(DiskSettings);
	}
	else
	{
		lcMemFile MemSettings;
		lcGetMinifigSettings(MemSettings);
		ParseSettings(MemSettings);
	}

	mMinifig = Minifig;

	m_RotateX = 75.0f;
	m_RotateZ = 180.0f;
	m_Distance = 10.0f;
	m_AutoZoom = true;
	m_Tracking = LC_TRACK_NONE;
}

void MinifigWizard::OnInitialUpdate()
{
	MakeCurrent();

	memset(mMinifig, 0, sizeof(lcMinifig));

	const int ColorCodes[LC_MFW_NUMITEMS] = { 4, 7, 14, 7, 1, 0, 7, 4, 4, 14, 14, 7, 7, 0, 0, 7, 7 };
	const char* Pieces[LC_MFW_NUMITEMS] = { "3624", "None", "3626BP01", "None", "973", "3815", "None", "3819", "3818", "3820", "3820", "None", "None", "3817", "3816", "None", "None" };

	for (int i = 0; i < LC_MFW_NUMITEMS; i++)
	{
		mMinifig->Colors[i] = lcGetColorIndex(ColorCodes[i]);

		PieceInfo* Info = lcGetPiecesLibrary()->FindPiece(Pieces[i], false);
		if (Info)
		{
			mMinifig->Parts[i] = Info;
			Info->AddRef();
		}
	}

	Calculate();
}

MinifigWizard::~MinifigWizard ()
{
	for (int i = 0; i < LC_MFW_NUMITEMS; i++)
		if (mMinifig->Parts[i])
			mMinifig->Parts[i]->Release();
}

void MinifigWizard::ParseSettings(lcFile& Settings)
{
	const char* SectionNames[LC_MFW_NUMITEMS] =
	{
		"[HATS]",   // LC_MFW_HATS
		"[HATS2]",  // LC_MFW_HATS2
		"[HEAD]",   // LC_MFW_HEAD
		"[NECK]",   // LC_MFW_NECK
		"[BODY]",   // LC_MFW_BODY
		"[BODY2]",  // LC_MFW_BODY2
		"[BODY3]",  // LC_MFW_BODY3
		"[RARM]",   // LC_MFW_RARM
		"[LARM]",   // LC_MFW_LARM
		"[RHAND]",  // LC_MFW_RHAND
		"[LHAND]",  // LC_MFW_LHAND
		"[RHANDA]", // LC_MFW_RHANDA
		"[LHANDA]", // LC_MFW_LHANDA
		"[RLEG]",   // LC_MFW_RLEG
		"[LLEG]",   // LC_MFW_LLEG
		"[RLEGA]",  // LC_MFW_RLEGA
		"[LLEGA]",  // LC_MFW_LLEGA
	};

	for (int SectionIndex = 0; SectionIndex < LC_MFW_NUMITEMS; SectionIndex++)
	{
		ObjArray<lcMinifigPieceInfo>& InfoArray = mSettings[SectionIndex];

		InfoArray.RemoveAll();
		Settings.Seek(0, SEEK_SET);

		char Line[1024];
		bool FoundSection = false;
		const char* SectionName = SectionNames[SectionIndex];
		int SectionNameLength = strlen(SectionName);

		// Find start of section
		while (Settings.ReadLine(Line, sizeof(Line)))
		{
			if (!strncmp(Line, SectionName, SectionNameLength))
			{
				FoundSection = true;
				break;
			}
		}

		if (!FoundSection)
		{

			lcMinifigPieceInfo MinifigInfo;
			strncpy(MinifigInfo.Description, "None", sizeof(MinifigInfo.Description));
			MinifigInfo.Description[sizeof(MinifigInfo.Description)-1] = 0;
			MinifigInfo.Offset = lcMatrix44Identity();
			MinifigInfo.Info = NULL;

			InfoArray.Add(MinifigInfo);
			continue;
		}

		// Parse section.
		while (Settings.ReadLine(Line, sizeof(Line)))
		{
			if (Line[0] == '[')
				break;

			char* DescriptionStart = strchr(Line, '"');
			if (!DescriptionStart)
				continue;
			DescriptionStart++;
			char* DescriptionEnd = strchr(DescriptionStart, '"');
			if (!DescriptionEnd)
				continue;
			*DescriptionEnd = 0;
			DescriptionEnd++;

			char* NameStart = strchr(DescriptionEnd, '"');
			if (!NameStart)
				continue;
			NameStart++;
			char* NameEnd = strchr(NameStart, '"');
			if (!NameEnd)
				continue;
			*NameEnd = 0;
			NameEnd++;

			strupr(NameStart);
			char* Ext = strrchr(NameStart, '.');
			if (Ext != NULL)
			{
				if (!strcmp(Ext, ".DAT"))
					*Ext = 0;
			}

			PieceInfo* Info = lcGetPiecesLibrary()->FindPiece(NameStart, false);
			if (!Info && *NameStart)
				continue;

			float Mat[12];
			int Flags;

			if (sscanf(NameEnd, "%d %g %g %g %g %g %g %g %g %g %g %g %g",
					   &Flags, &Mat[0], &Mat[1], &Mat[2], &Mat[3], &Mat[4], &Mat[5], &Mat[6], 
					   &Mat[7], &Mat[8], &Mat[9], &Mat[10], &Mat[11]) != 13)
				continue;

			lcMatrix44 Offset = lcMatrix44Identity();
			float* OffsetMatrix = &Offset[0][0];

			OffsetMatrix[0] =  Mat[0];
			OffsetMatrix[8] = -Mat[1];
			OffsetMatrix[4] =  Mat[2];
			OffsetMatrix[2] = -Mat[3];
			OffsetMatrix[10] = Mat[4];
			OffsetMatrix[6] = -Mat[5];
			OffsetMatrix[1] =  Mat[6];
			OffsetMatrix[9] = -Mat[7];
			OffsetMatrix[5] =  Mat[8];
			OffsetMatrix[12] =  Mat[9] / 25.0f;
			OffsetMatrix[14] = -Mat[10] / 25.0f;
			OffsetMatrix[13] =  Mat[11] / 25.0f;

			lcMinifigPieceInfo MinifigInfo;
			strncpy(MinifigInfo.Description, DescriptionStart, sizeof(MinifigInfo.Description));
			MinifigInfo.Description[sizeof(MinifigInfo.Description)-1] = 0;
			MinifigInfo.Offset = Offset;
			MinifigInfo.Info = Info;

			InfoArray.Add(MinifigInfo);
		}
	}
}

void MinifigWizard::OnDraw()
{
	float Aspect = (float)mWidth/(float)mHeight;
	glViewport(0, 0, mWidth, mHeight);

	float Box[6] = { 10000, 10000, 10000, -10000, -10000, -10000 };

	for (int InfoIdx = 0; InfoIdx < LC_MFW_NUMITEMS; InfoIdx++)
	{
		PieceInfo* Info = mMinifig->Parts[InfoIdx];

		if (!Info)
			continue;

		lcVector3 Points[8] =
		{
			lcVector3(Info->m_fDimensions[0], Info->m_fDimensions[1], Info->m_fDimensions[5]),
			lcVector3(Info->m_fDimensions[3], Info->m_fDimensions[1], Info->m_fDimensions[5]),
			lcVector3(Info->m_fDimensions[0], Info->m_fDimensions[1], Info->m_fDimensions[2]),
			lcVector3(Info->m_fDimensions[3], Info->m_fDimensions[4], Info->m_fDimensions[5]),
			lcVector3(Info->m_fDimensions[3], Info->m_fDimensions[4], Info->m_fDimensions[2]),
			lcVector3(Info->m_fDimensions[0], Info->m_fDimensions[4], Info->m_fDimensions[2]),
			lcVector3(Info->m_fDimensions[0], Info->m_fDimensions[4], Info->m_fDimensions[5]),
			lcVector3(Info->m_fDimensions[3], Info->m_fDimensions[1], Info->m_fDimensions[2])
		};

		for (int PointIdx = 0; PointIdx < 8; PointIdx++)
		{
			lcVector3 Point = lcMul31(Points[PointIdx], mMinifig->Matrices[InfoIdx]);

			if (Point[0] < Box[0]) Box[0] = Point[0];
			if (Point[1] < Box[1]) Box[1] = Point[1];
			if (Point[2] < Box[2]) Box[2] = Point[2];
			if (Point[0] > Box[3]) Box[3] = Point[0];
			if (Point[1] > Box[4]) Box[4] = Point[1];
			if (Point[2] > Box[5]) Box[5] = Point[2];
		}
	}

	lcVector3 Center((Box[0] + Box[3]) / 2, (Box[1] + Box[4]) / 2, (Box[2] + Box[5]) / 2);

	lcVector3 Eye(0.0f, 0.0f, 1.0f);

	Eye = lcMul30(Eye, lcMatrix44RotationX(-m_RotateX * LC_DTOR));
	Eye = lcMul30(Eye, lcMatrix44RotationZ(-m_RotateZ * LC_DTOR));

	lcMatrix44 Projection = lcMatrix44Perspective(30.0f, Aspect, 1.0f, 100.0f);
	glMatrixMode(GL_PROJECTION);
	glLoadMatrixf(Projection);

	if (m_AutoZoom)
	{
		lcVector3 Points[8] =
		{
			lcVector3(Box[0], Box[1], Box[5]),
			lcVector3(Box[3], Box[1], Box[5]),
			lcVector3(Box[0], Box[1], Box[2]),
			lcVector3(Box[3], Box[4], Box[5]),
			lcVector3(Box[3], Box[4], Box[2]),
			lcVector3(Box[0], Box[4], Box[2]),
			lcVector3(Box[0], Box[4], Box[5]),
			lcVector3(Box[3], Box[1], Box[2])
		};

		Eye += Center;

		lcMatrix44 ModelView = lcMatrix44LookAt(Eye, Center, lcVector3(0, 0, 1));
		Eye = lcZoomExtents(Eye, ModelView, Projection, Points, 8);

		glMatrixMode(GL_MODELVIEW);
		glLoadMatrixf(lcMatrix44LookAt(Eye, Center, lcVector3(0, 0, 1)));

		// Update the new camera distance.
		lcVector3 d = Eye - Center;
		m_Distance = d.Length();
	}
	else
	{
		glMatrixMode(GL_MODELVIEW);
		glLoadMatrixf(lcMatrix44LookAt(Eye * m_Distance, Center, lcVector3(0, 0, 1)));
	}

	glEnable(GL_DEPTH_TEST);
	glDepthFunc(GL_LEQUAL);
	glEnable(GL_POLYGON_OFFSET_FILL);
	glPolygonOffset(0.5f, 0.1f);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	float *bg = lcGetActiveProject()->GetBackgroundColor();
	glClearColor(bg[0], bg[1], bg[2], bg[3]);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	Calculate();

	for (int PieceIdx = 0; PieceIdx < LC_MFW_NUMITEMS; PieceIdx++)
	{
		if (!mMinifig->Parts[PieceIdx])
			continue;

		glPushMatrix();
		glMultMatrixf(mMinifig->Matrices[PieceIdx]);
		mMinifig->Parts[PieceIdx]->RenderPiece(mMinifig->Colors[PieceIdx]);
		glPopMatrix();
	}
}

void MinifigWizard::OnLeftButtonDown()
{
	if (m_Tracking == LC_TRACK_NONE)
	{
		m_DownX = mInputState.x;
		m_DownY = mInputState.y;
		m_Tracking = LC_TRACK_LEFT;
		CaptureMouse();
	}
}

void MinifigWizard::OnLeftButtonUp()
{
	if (m_Tracking == LC_TRACK_LEFT)
	{
		m_Tracking = LC_TRACK_NONE;
		ReleaseMouse();
	}
}

void MinifigWizard::OnLeftButtonDoubleClick()
{
	m_AutoZoom = true;
	Redraw();
}

void MinifigWizard::OnRightButtonDown()
{
	if (m_Tracking == LC_TRACK_NONE)
	{
		m_DownX = mInputState.x;
		m_DownY = mInputState.y;
		m_Tracking = LC_TRACK_RIGHT;
		CaptureMouse();
	}
}

void MinifigWizard::OnRightButtonUp()
{
	if (m_Tracking == LC_TRACK_RIGHT)
	{
		m_Tracking = LC_TRACK_NONE;
		ReleaseMouse();
	}
}

void MinifigWizard::OnMouseMove()
{
	if (m_Tracking == LC_TRACK_LEFT)
	{
		// Rotate.
		m_RotateZ += mInputState.x - m_DownX;
		m_RotateX += mInputState.y - m_DownY;

		if (m_RotateX > 179.5f)
			m_RotateX = 179.5f;
		else if (m_RotateX < 0.5f)
			m_RotateX = 0.5f;

		m_DownX = mInputState.x;
		m_DownY = mInputState.y;

		Redraw();
	}
	else if (m_Tracking == LC_TRACK_RIGHT)
	{
		// Zoom.
		m_Distance += (float)(m_DownY - mInputState.y) * 0.2f;
		m_AutoZoom = false;

		if (m_Distance < 0.5f)
			m_Distance = 0.5f;

		m_DownX = mInputState.x;
		m_DownY = mInputState.y;

		Redraw();
	}
}

void MinifigWizard::Calculate()
{
	float HeadOffset = 0.0f;
	lcMatrix44 Root, Mat, Mat2;

	PieceInfo** Parts = mMinifig->Parts;
	float* Angles = mMinifig->Angles;
	lcMatrix44* Matrices = mMinifig->Matrices;

	bool DroidTorso = Parts[LC_MFW_BODY] && !strcmp(Parts[LC_MFW_BODY]->m_strName, "30375");
	bool SkeletonTorso = Parts[LC_MFW_BODY] && !strcmp(Parts[LC_MFW_BODY]->m_strName, "6260");

	if (Parts[LC_MFW_BODY3])
		Root = lcMatrix44Translation(lcVector3(0, 0, 2.96f));
	else
		Root = lcMatrix44Translation(lcVector3(0, 0, 2.88f));
	Matrices[LC_MFW_BODY] = lcMul(mSettings[LC_MFW_BODY][GetSelectionIndex(LC_MFW_BODY)].Offset, Root);

	if (Parts[LC_MFW_NECK])
	{
		Matrices[LC_MFW_NECK] = lcMul(mSettings[LC_MFW_NECK][GetSelectionIndex(LC_MFW_NECK)].Offset, Root);
		HeadOffset = 0.08f;
	}

	if (Parts[LC_MFW_HEAD])
	{
		Mat = lcMatrix44RotationZ(-LC_DTOR * Angles[LC_MFW_HEAD]);
		Mat.SetTranslation(lcVector3(0.0f, 0.0f, 0.96f + HeadOffset));
		Mat = lcMul(mSettings[LC_MFW_HEAD][GetSelectionIndex(LC_MFW_HEAD)].Offset, Mat);
		Matrices[LC_MFW_HEAD] = lcMul(Mat, Root);
	}

	if (Parts[LC_MFW_HATS])
	{
		Mat = lcMatrix44RotationZ(-LC_DTOR * Angles[LC_MFW_HATS]);
		Mat = lcMul(mSettings[LC_MFW_HATS][GetSelectionIndex(LC_MFW_HATS)].Offset, Mat);
		Matrices[LC_MFW_HATS] = lcMul(Mat, Matrices[LC_MFW_HEAD]);
	}

	if (Parts[LC_MFW_HATS2])
	{
		Mat = lcMatrix44RotationX(-LC_DTOR * Angles[LC_MFW_HATS2]);
		Mat = lcMul(mSettings[LC_MFW_HATS2][GetSelectionIndex(LC_MFW_HATS2)].Offset, Mat);
		Matrices[LC_MFW_HATS2] = lcMul(Mat, Matrices[LC_MFW_HATS]);
	}

	if (Parts[LC_MFW_RARM])
	{
		Mat = lcMatrix44RotationX(-LC_DTOR * Angles[LC_MFW_RARM]);

		if (DroidTorso || SkeletonTorso)
			Mat2 = lcMatrix44Identity();
		else
			Mat2 = lcMatrix44RotationY(-LC_DTOR * 9.791f);
		Mat2.SetTranslation(lcVector3(0.62f, 0, -0.32f));

		Mat = lcMul(mSettings[LC_MFW_RARM][GetSelectionIndex(LC_MFW_RARM)].Offset, Mat);
		Mat = lcMul(Mat, Mat2);
		Matrices[LC_MFW_RARM] = lcMul(Mat, Root);
	}

	if (Parts[LC_MFW_RHAND])
	{
		Mat = lcMatrix44RotationY(-LC_DTOR * Angles[LC_MFW_RHAND]);
		Mat2 = lcMatrix44RotationX(LC_DTOR * 45);
		Mat = lcMul(mSettings[LC_MFW_RHAND][GetSelectionIndex(LC_MFW_RHAND)].Offset, Mat);
		Mat = lcMul(Mat, Mat2);
		Mat.SetTranslation(lcVector3(0.2f, -0.4f, -0.76f));
		Matrices[LC_MFW_RHAND] = lcMul(Mat, Matrices[LC_MFW_RARM]);
	}

	if (Parts[LC_MFW_RHANDA])
	{
		Mat = lcMatrix44RotationZ(LC_DTOR * Angles[LC_MFW_RHANDA]);
		Mat.SetTranslation(lcVector3(0, -0.4f, 0));
		Mat = lcMul(mSettings[LC_MFW_RHANDA][GetSelectionIndex(LC_MFW_RHANDA)].Offset, Mat);
		Matrices[LC_MFW_RHANDA] = lcMul(Mat, Matrices[LC_MFW_RHAND]);
	}

	if (Parts[LC_MFW_LARM])
	{
		Mat = lcMatrix44RotationX(-LC_DTOR * Angles[LC_MFW_LARM]);

		if (DroidTorso || SkeletonTorso)
			Mat2 = lcMatrix44Identity();
		else
			Mat2 = lcMatrix44RotationY(LC_DTOR * 9.791f);
		Mat2.SetTranslation(lcVector3(-0.62f, 0.0f, -0.32f));

		Mat = lcMul(mSettings[LC_MFW_LARM][GetSelectionIndex(LC_MFW_LARM)].Offset, Mat);
		Mat = lcMul(Mat, Mat2);
		Matrices[LC_MFW_LARM] = lcMul(Mat, Root);
	}

	if (Parts[LC_MFW_LHAND])
	{
		Mat = lcMatrix44RotationY(-LC_DTOR * Angles[LC_MFW_LHAND]);
		Mat2 = lcMatrix44RotationX(LC_DTOR * 45);
		Mat = lcMul(mSettings[LC_MFW_LHAND][GetSelectionIndex(LC_MFW_LHAND)].Offset, Mat);
		Mat = lcMul(Mat, Mat2);
		Mat.SetTranslation(lcVector3(-0.2f, -0.4f, -0.76f));
		Matrices[LC_MFW_LHAND] = lcMul(Mat, Matrices[LC_MFW_LARM]);
	}

	if (Parts[LC_MFW_LHANDA])
	{
		Mat = lcMatrix44RotationZ(LC_DTOR * Angles[LC_MFW_LHANDA]);
		Mat.SetTranslation(lcVector3(0, -0.4f, 0));
		Mat = lcMul(mSettings[LC_MFW_LHANDA][GetSelectionIndex(LC_MFW_LHANDA)].Offset, Mat);
		Matrices[LC_MFW_LHANDA] = lcMul(Mat, Matrices[LC_MFW_LHAND]);
	}

	if (Parts[LC_MFW_BODY2])
	{
		Mat = lcMatrix44Identity();
		Mat.SetTranslation(lcVector3(0, 0, -1.28f));
		Mat = lcMul(mSettings[LC_MFW_BODY2][GetSelectionIndex(LC_MFW_BODY2)].Offset, Mat);
		Matrices[LC_MFW_BODY2] = lcMul(Mat, Root);
	}

	if (Parts[LC_MFW_BODY3])
	{
		Mat = lcMatrix44Identity();
		Mat.SetTranslation(lcVector3(0, 0, -1.28f));
		Mat = lcMul(mSettings[LC_MFW_BODY3][GetSelectionIndex(LC_MFW_BODY3)].Offset, Mat);
		Matrices[LC_MFW_BODY3] = lcMul(Mat, Root);
	}

	if (Parts[LC_MFW_RLEG])
	{
		Mat = lcMatrix44RotationX(-LC_DTOR * Angles[LC_MFW_RLEG]);
		Mat.SetTranslation(lcVector3(0, 0, -1.76f));
		Mat = lcMul(mSettings[LC_MFW_RLEG][GetSelectionIndex(LC_MFW_RLEG)].Offset, Mat);
		Matrices[LC_MFW_RLEG] = lcMul(Mat, Root);
	}

	if (Parts[LC_MFW_RLEGA])
	{
		lcVector3 Center(-0.4f, -0.04f, -1.12f);
		Mat = lcMatrix44RotationZ(LC_DTOR * Angles[LC_MFW_RLEGA]);
		Mat2 = mSettings[LC_MFW_RLEGA][GetSelectionIndex(LC_MFW_RLEGA)].Offset;
		Mat2.SetTranslation(lcMul31(-Center, Mat2));
		Mat = lcMul(Mat2, Mat);
		Mat.SetTranslation(lcMul31(Center, Mat2));
		Matrices[LC_MFW_RLEGA] = lcMul(Mat, Matrices[LC_MFW_RLEG]);
	}

	if (Parts[LC_MFW_LLEG])
	{
		Mat = lcMatrix44RotationX(-LC_DTOR * Angles[LC_MFW_LLEG]);
		Mat.SetTranslation(lcVector3(0, 0, -1.76f));
		Mat = lcMul(mSettings[LC_MFW_LLEG][GetSelectionIndex(LC_MFW_LLEG)].Offset, Mat);
		Matrices[LC_MFW_LLEG] = lcMul(Mat, Root);
	}

	if (Parts[LC_MFW_LLEGA])
	{
		lcVector3 Center(0.4f, -0.04f, -1.12f);
		Mat = lcMatrix44RotationZ(LC_DTOR * Angles[LC_MFW_LLEGA]);
		Mat2 = mSettings[LC_MFW_LLEGA][GetSelectionIndex(LC_MFW_LLEGA)].Offset;
		Mat2.SetTranslation(lcMul31(-Center, Mat2));
		Mat = lcMul(Mat2, Mat);
		Mat.SetTranslation(lcMul31(Center, Mat2));
		Matrices[LC_MFW_LLEGA] = lcMul(Mat, Matrices[LC_MFW_LLEG]);
	}
}

int MinifigWizard::GetSelectionIndex(int Type) const
{
	const ObjArray<lcMinifigPieceInfo>& InfoArray = mSettings[Type];

	for (int Index = 0; Index < InfoArray.GetSize(); Index++)
		if (InfoArray[Index].Info == mMinifig->Parts[Type])
			return Index;

	return 0;
}

void MinifigWizard::SetSelectionIndex(int Type, int Index)
{
	if (mMinifig->Parts[Type])
		mMinifig->Parts[Type]->Release();

	mMinifig->Parts[Type] = mSettings[Type][Index].Info;

	if (mMinifig->Parts[Type])
		mMinifig->Parts[Type]->AddRef();

	Calculate();
}

void MinifigWizard::SetColor(int Type, int Color)
{
	mMinifig->Colors[Type] = Color;
}

void MinifigWizard::SetAngle(int Type, float Angle)
{
	mMinifig->Angles[Type] = Angle;
}
