#=====================================================================
# LedgerSMB Small Medium Business Accounting
# http://www.ledgersmb.org/
#
# Copyright (C) 2006
# This work contains copyrighted information from a number of sources all used
# with permission.
#
# This file contains source code included with or based on SQL-Ledger which
# is Copyright Dieter Simader and DWS Systems Inc. 2000-2005 and licensed
# under the GNU General Public License version 2 or, at your option, any later
# version.  For a full list including contact information of contributors,
# maintainers, and copyright holders, see the CONTRIBUTORS file.
#
# Original Copyright Notice from SQL-Ledger 2.6.17 (before the fork):
# Copyright (c) 2005
#
#  Author: DWS Systems Inc.
#     Web: http://www.sql-ledger.org
#
#  Contributors:
#
#
#  Author: DWS Systems Inc.
#     Web: http://www.ledgersmb.org/
#
#  Contributors:
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# AR / AP
#
#======================================================================

use LedgerSMB::Tax;

# any custom scripts for this one
if ( -f "bin/custom/aa.pl" ) {
    eval { require "bin/custom/aa.pl"; };
}
if ( -f "bin/custom/$form->{login}_aa.pl" ) {
    eval { require "bin/custom/$form->{login}_aa.pl"; };
}

my $is_update;

1;


# end of main

# this is for our long dates
# $locale->text('January')
# $locale->text('February')
# $locale->text('March')
# $locale->text('April')
# $locale->text('May ')
# $locale->text('June')
# $locale->text('July')
# $locale->text('August')
# $locale->text('September')
# $locale->text('October')
# $locale->text('November')
# $locale->text('December')

# this is for our short month
# $locale->text('Jan')
# $locale->text('Feb')
# $locale->text('Mar')
# $locale->text('Apr')
# $locale->text('May')
# $locale->text('Jun')
# $locale->text('Jul')
# $locale->text('Aug')
# $locale->text('Sep')
# $locale->text('Oct')
# $locale->text('Nov')
# $locale->text('Dec')

sub copy_to_new{
    delete $form->{id};
    delete $form->{invnumber};
    $form->{paidaccounts} = 1;
    if ($form->{paid_1}){
        delete $form->{paid_1};
    }
    update();
}

sub new_screen {
    use LedgerSMB::Form;
    my @reqprops = qw(ARAP vc dbh stylesheet batch_id script);
    $oldform = $form;
    $form = {};
    bless $form, Form;
    for (@reqprops){
        $form->{$_} = $oldform->{$_};
    }
    &add();
}

sub add {
    $form->{title} = "Add";
	
    $form->{callback} =
"$form->{script}?action=add&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}"
      unless $form->{callback};
    if ($form->{type} eq "credit_note"){
        $form->{reverse} = 1;
        $form->{subtype} = 'credit_note';
        $form->{type} = 'transaction';
    } elsif ($form->{type} eq 'debit_note'){
        $form->{reverse} = 1;
        $form->{subtype} = 'debit_note';
        $form->{type} = 'transaction';
    }
    else {
        $form->{reverse} = 0;
    }

    &create_links;

    $form->{focus} = "amount_1";
    &display_form;
    return 1;
}

sub edit {

    &create_links;
    $form->{title} = $locale->text("Edit");
    if ($form->{reverse}){
        if ($form->{ARAP} eq 'AR'){
            $form->{subtype} = 'credit_note';
            $form->{type} = 'transaction';
        } elsif ($form->{ARAP} eq 'AP'){
            $form->{subtype} = 'debit_note';
            $form->{type} = 'transaction';
        } else {
            $form->error("Unknown AR/AP selection value: $form->{ARAP}");
        }

    }
    &display_form;

}

sub display_form {
    $form->close_form;
    $form->open_form;
    $form->{dbh}->commit;
    AA->get_files($form, $locale);
    &form_header;
    &form_footer;

}

sub create_links {

    if ( $form->{script} eq 'ap.pl' ) {
        $form->{ARAP} = 'AP';
        $form->{vc}   = 'vendor';	
    }
    elsif ( $form->{script} eq 'ar.pl' ) {
        $form->{ARAP} = 'AR';
        $form->{vc}   = 'customer';
    }

    $form->create_links( module => $form->{ARAP},
			 myconfig => \%myconfig,
			 vc => $form->{vc},
			 billing => $form->{vc} eq 'customer'
			            && $form->{type} eq 'invoice');

    $duedate     = $form->{duedate};
    $crdate	 = $form->{crdate};

    $form->{formname} = "transaction";
    $form->{format}   = "postscript" if $myconfig{printer};
    $form->{media}    = $myconfig{printer};

    $form->{selectformname} =
      qq|<option value="transaction">| . $locale->text('Transaction');

    # currencies
    if (!$form->{currencies}){
        $form->error($locale->text(
           'No currencies defined.  Please set these up under System/Defaults.'
        ));
    }
    @curr = split /:/, $form->{currencies};
    $form->{defaultcurrency} = $curr[0];
    chomp $form->{defaultcurrency};

    for (@curr) { $form->{selectcurrency} .= "<option>$_\n"  
                     unless  $form->{selectcurrency} =~ /<option[^>]*>$_/
    }

    my $vc = $form->{vc};

    AA->get_name( \%myconfig, \%$form ) 
            unless $form->{"old$vc"} eq $form->{$vc} 
                    or $form->{"old$vc"} =~ /^\Q$form->{$vc}\E--/;

    $form->{currency} =~ s/ //g;
    $form->{duedate}     = $duedate     if $duedate;
    $form->{crdate}      = $crdate      if $crdate;

    $form->{"old$form->{vc}"} =
      qq|$form->{$form->{vc}}--$form->{"$form->{vc}_id"}|;
    $form->{oldtransdate} = $form->{transdate};

    # customers/vendors
    $form->{"select$form->{vc}"} = "";
    if ( @{ $form->{"all_$form->{vc}"} } ) {
        $form->{ $form->{vc} } =
          qq|$form->{$form->{vc}}--$form->{"$form->{vc}_id"}|
          unless $form->{ $form->{vc} } =~ /--$form->{"$form->{vc}_id"}$/;
        for ( @{ $form->{"all_$form->{vc}"} } ) {
            $form->{"select$form->{vc}"} .=
              qq|<option value="$_->{name}--$_->{id}">$_->{name}\n|;
        }
    }

    # departments
    if ( @{ $form->{all_department} } ) {
        $form->{selectdepartment} = "<option>\n";
        $form->{department} = "$form->{department}--$form->{department_id}"
          if $form->{department_id};

        for ( @{ $form->{all_department} } ) {
            $form->{selectdepartment} .=
qq|<option value="$_->{description}--$_->{id}">$_->{description}\n|;
        }
    }

    $form->{employee} = "$form->{employee}--$form->{employee_id}";

    # sales staff
    if ( @{ $form->{all_employee} } ) {
        $form->{selectemployee} = "";
        for ( @{ $form->{all_employee} } ) {
            $form->{selectemployee} .=
              qq|<option value="$_->{name}--$_->{id}">$_->{name}\n|;
        }
    }

    # projects
    if ( @{ $form->{all_project} } ) {
        $form->{selectprojectnumber} = "<option>\n";
        for ( @{ $form->{all_project} } ) {
            $form->{selectprojectnumber} .=
qq|<option value="$_->{projectnumber}--$_->{id}">$_->{projectnumber}\n|;
        }
    }

    if ( @{ $form->{all_language} } ) {
        $form->{selectlanguage} = "<option>\n";
        for ( @{ $form->{all_language} } ) {
            $form->{selectlanguage} .=
              qq|<option value="$_->{code}">$_->{description}\n|;
        }
    }

    # forex
    $form->{forex} = $form->{exchangerate};
    $exchangerate = ( $form->{exchangerate} ) ? $form->{exchangerate} : 1;

    $netamount = 0;
    $tax       = 0;
    $taxrate   = 0;
    #$ml        = ( $form->{ARAP} eq 'AR' ) ? 1 : -1;
    $ml        = new Math::BigFloat( ( $form->{ARAP} eq 'AR' ) ? 1 : -1);

    foreach $key ( keys %{ $form->{"$form->{ARAP}_links"} } ) {


        $form->{"select$key"} = "";
        foreach $ref ( @{ $form->{"$form->{ARAP}_links"}{$key} } ) {
            $form->{"select$key"} .=
              "<option>$ref->{accno}--$ref->{description}\n";
        }

        # if there is a value we have an old entry
        for $i ( 1 .. scalar @{ $form->{acc_trans}{$key} } ) {


            if ( $key eq "$form->{ARAP}_paid" ) {

                $form->{"$form->{ARAP}_paid_$i"} =
"$form->{acc_trans}{$key}->[$i-1]->{accno}--$form->{acc_trans}{$key}->[$i-1]->{description}";
                $form->{"paid_$i"} =
                  $form->{acc_trans}{$key}->[ $i - 1 ]->{amount} * -1 * $ml;
                $form->{"datepaid_$i"} =
                  $form->{acc_trans}{$key}->[ $i - 1 ]->{transdate};
                $form->{"source_$i"} =
                  $form->{acc_trans}{$key}->[ $i - 1 ]->{source};
                $form->{"memo_$i"} =
                  $form->{acc_trans}{$key}->[ $i - 1 ]->{memo};

                $form->{"forex_$i"} = $form->{"exchangerate_$i"} =
                  $form->{acc_trans}{$key}->[ $i - 1 ]->{exchangerate};

                $form->{paidaccounts}++;
            }
            else {

                $akey = $key;
                $akey =~ s/$form->{ARAP}_//;

                if ( $key eq "$form->{ARAP}_tax" ) {
                    $form->{"${key}_$form->{acc_trans}{$key}->[$i-1]->{accno}"}
                      = "$form->{acc_trans}{$key}->[$i-1]->{accno}--$form->{acc_trans}{$key}->[$i-1]->{description}";
                    $form->{"${akey}_$form->{acc_trans}{$key}->[$i-1]->{accno}"}
                      = $form->{acc_trans}{$key}->[ $i - 1 ]->{amount} * $ml;

                    $tax +=
                      $form->{
                        "${akey}_$form->{acc_trans}{$key}->[$i-1]->{accno}"};
                    $taxrate +=
                      $form->{"$form->{acc_trans}{$key}->[$i-1]->{accno}_rate"};

                }
                else {



                    $form->{"${akey}_$i"} =
                      $form->{acc_trans}{$key}->[ $i - 1 ]->{amount} * $ml;

                    if ( $akey eq 'amount' ) {
                        $form->{"description_$i"} =
                          $form->{acc_trans}{$key}->[ $i - 1 ]->{memo};

 			$form->{"entry_id_$i"} =
                          $form->{acc_trans}{$key}->[ $i - 1 ]->{entry_id};

			$form->{"taxformcheck_$i"}=1 if(AA->get_taxcheck($form->{"entry_id_$i"},$form->{dbh}));

                       $form->{rowcount}++;
                        $netamount += $form->{"${akey}_$i"};

                        $form->{"projectnumber_$i"} =
"$form->{acc_trans}{$key}->[$i-1]->{projectnumber}--$form->{acc_trans}{$key}->[$i-1]->{project_id}"
                          if $form->{acc_trans}{$key}->[ $i - 1 ]->{project_id};
                    }
                    else {
                        $form->{invtotal} =
                          $form->{acc_trans}{$key}->[ $i - 1 ]->{amount} * -1 * $ml;
                    }
                    $form->{"${key}_$i"} =
"$form->{acc_trans}{$key}->[$i-1]->{accno}--$form->{acc_trans}{$key}->[$i-1]->{description}";



                }
            }
        }
    }

    $form->{paidaccounts} = 1 if not defined $form->{paidaccounts};


    # check if calculated is equal to stored
    # taxincluded can't be calculated
    # this works only if all taxes are checked

    @taxaccounts = Tax::init_taxes( $form, $form->{taxaccounts} );

    if ( !$form->{id} ) {
        for (@taxaccounts) { $form->{ "calctax_" . $_->account } = 1 }
    }

    $form->{rowcount}++ if ( $form->{id} || !$form->{rowcount} );

    $form->{ $form->{ARAP} } = $form->{"$form->{ARAP}_1"};
    $form->{rowcount} = 1 unless $form->{"$form->{ARAP}_amount_1"};

    $form->{locked} =
      ( $form->{revtrans} )
      ? '1'
      : ( $form->datetonum( \%myconfig, $form->{transdate} ) <=
          $form->datetonum( \%myconfig, $form->{closedto} ) );

    # readonly
    if ( !$form->{readonly} ) {
        $form->{readonly} = 1
          if $myconfig{acs} =~ /$form->{ARAP}--Add Transaction/;
    }

}

sub form_header {

    $title = $form->{title};

    if($form->{batch_id})
    {
		$form->{batch_control_code}=$form->get_batch_control_code($form->{dbh},$form->{batch_id});
		$form->{batch_description}=$form->get_batch_description($form->{dbh},$form->{batch_id});
    }
    # 	$locale->text('Add AR Transaction');
    # 	$locale->text('Add AP Transaction');
    #   $locale->text('Edit AR Transaction');
    #   $locale->text('Edit AP Transaction');
    if ($form->{ARAP} eq 'AP'){
        $vcscript = 'vendor.pl';
    } elsif ($form->{ARAP} eq 'AR'){
        $vcscript = 'customer.pl';
    }
    my $title_msgid="$title $form->{ARAP} Transaction";
    if ($form->{reverse} == 0){
       #$form->{title} = $locale->text("[_1] [_2] Transaction", $title, $form->{ARAP});
       $form->{title} = $locale->text($title_msgid);
    }
    elsif($form->{reverse} == 1) {
       if ($form->{subtype} eq 'credit_note'){
           $title_msgid="$title Credit Note";$form->{title}=$locale->text($title_msgid);
           #$form->{title} = $locale->text("[_1] Credit Note", $title);
       } elsif ($form->{subtype} eq 'debit_note'){
           $title_msgid="$title Debit Note";$form->{title}=$locale->text($title_msgid);
           #$form->{title} = $locale->text("[_1] Debit Note", $title);
       } else {
           $form->error("Unknown subtype $form->{subtype} in $form->{ARAP} "
              . "transaction.");
       }
    }
    else {
       $form->error('Reverse flag not true or false on AR/AP transaction');
    }

    $form->{taxincluded} = ( $form->{taxincluded} ) ? "checked" : "";

    # $locale->text('Add Debit Note')
    # $locale->text('Edit Debit Note')
    # $locale->text('Add Credit Note')
    # $locale->text('Edit Credit Note')
    # $locale->text('Add AP Transaction')
    # $locale->text('Edit AP Transaction')

    # set option selected
    for ( "$form->{ARAP}", "currency" ) {
        $form->{"select$_"} =~ s/ selected//;
        $form->{"select$_"} =~
          s/<option>\Q$form->{$_}\E/<option selected>$form->{$_}/;
    }

    for ( "$form->{vc}", "department", "employee", "formname" ) {
        $form->{"select$_"} = $form->unescape( $form->{"select$_"} );
        $form->{"select$_"} =~ s/ selected//;
        $form->{"select$_"} =~ s/(<option value="\Q$form->{$_}\E")/$1 selected/;
    }

    $form->{selectprojectnumber} =
      $form->unescape( $form->{selectprojectnumber} );

    # format amounts
    $form->{exchangerate} =
      $form->format_amount( \%myconfig, $form->{exchangerate} );

    $exchangerate = qq|<tr>|;
    $exchangerate .= qq|
                <th align=right nowrap>| . $locale->text('Currency') . qq|</th>
		<td><select name=currency>$form->{selectcurrency}</select></td> |
      if $form->{defaultcurrency};
    $exchangerate .= qq|
                <input type=hidden name=selectcurrency value="$form->{selectcurrency}">
		<input type=hidden name=defaultcurrency value=$form->{defaultcurrency}>
|;

    if (   $form->{defaultcurrency}
        && $form->{currency} ne $form->{defaultcurrency} )
    {
        if ( $form->{forex} ) {
            $exchangerate .= qq|
	<th align=right>| . $locale->text('Exchange Rate') . qq|</th>
	<td><input type=hidden name=exchangerate value=$form->{exchangerate}>$form->{exchangerate}</td>
|;
        }
        else {
            $exchangerate .= qq|
        <th align=right>| . $locale->text('Exchange Rate') . qq|</th>
        <td><input name=exchangerate size=10 value=$form->{exchangerate}></td>
|;
        }
    }
    $exchangerate .= qq|
<input type=hidden name=forex value=$form->{forex}>
</tr>
|;

    if ( ( $rows = $form->numtextrows( $form->{notes}, 50 ) - 1 ) < 2 ) {
        $rows = 2;
    }
    $notes =
qq|<textarea name=notes rows=$rows cols=50 wrap=soft>$form->{notes}</textarea>|;
    $intnotes =
qq|<textarea name=intnotes rows=$rows cols=35 wrap=soft>$form->{intnotes}</textarea>|;

    $department = qq|
	      <tr>
		<th align="right" nowrap>| . $locale->text('Department') . qq|</th>
		<td colspan=3><select name=department>$form->{selectdepartment}</select>
		<input type=hidden name=selectdepartment value="|
      . $form->escape( $form->{selectdepartment}, 1 ) . qq|">
		</td>
	      </tr>
| if $form->{selectdepartment};

    $n = ( $form->{creditremaining} < 0 ) ? "0" : "1";

    $name =
      ( $form->{"select$form->{vc}"} )
      ? qq|<select name="$form->{vc}">$form->{"select$form->{vc}"}</select>|
      : qq|<input name="$form->{vc}" value="$form->{$form->{vc}}" size=35> 
                 <a href="$vcscript?action=add" target="new" id="new-contact">[|
                 .  $locale->text('New') . qq|]</a>|;

    $employee = qq|
                <input type=hidden name=employee value="$form->{employee}">
|;

    if ( $form->{selectemployee} ) {
        $label =
          ( $form->{ARAP} eq 'AR' )
          ? $locale->text('Salesperson')
          : $locale->text('Employee');

        $employee = qq|
	      <tr>
		<th align=right nowrap>$label</th>
		<td><select name=employee>$form->{selectemployee}</select></td>
		<input type=hidden name=selectemployee value="|
          . $form->escape( $form->{selectemployee}, 1 ) . qq|">
	      </tr>
|;
    }

    $focus = ( $form->{focus} ) ? $form->{focus} : "amount_$form->{rowcount}";

    $form->header;

 print qq|
<body onload="document.forms[0].${focus}.focus()" /> | .
$form->open_status_div . qq|
<form method=post action=$form->{script}>
<input type=hidden name=type value="$form->{formname}">
<input type=hidden name=title value="$title">

|;
    if (!defined $form->{approved}){
        $form->{approved} = 1;
    }
    $form->hide_form(
        qw(batch_id approved id printed emailed sort closedto locked 
           oldtransdate audittrail recurring checktax reverse batch_id subtype
           entity_control_code tax_id meta_number default_reportable address city)
    );

    if ( $form->{vc} eq 'customer' ) {
        $label = $locale->text('Customer');
    }
    else {
        $label = $locale->text('Vendor');
    }

    $form->hide_form(
        "old$form->{vc}",  "$form->{vc}_id",
        "terms",           "creditlimit",
        "creditremaining", "selectcurrency",
        "defaultcurrency", "select$form->{ARAP}_amount",
        "rowcount"
    );

    print qq|

<table width=100%>
  <tr class=listtop>
    <th class=listtop>$form->{title}</th>
  </tr>
  <tr height="5"></tr>
  <tr valign=top>
    <td>
      <table width=100%>
        <tr valign=top>
	  <td>
	    <table>
	      <tr>
		<th align="right" nowrap>$label</th>
		<td colspan=3>$name 
                </td>
		<input type=hidden name="select$form->{vc}" value="|
      . $form->escape( $form->{"select$form->{vc}"}, 1 ) . qq|">
	      </tr>
	      <tr>
		<td colspan=3>
		  <table width=100%>
		    <tr>
		      <th align=left nowrap>| . $locale->text('Credit Limit') . qq|</th>
		      <td>$form->{creditlimit}</td>
		      <th align=left nowrap>| . $locale->text('Remaining') . qq|</th>
		      <td class="plus$n">|
      . $form->format_amount( \%myconfig, $form->{creditremaining}, 0, "0" )
      . qq|</td>
		    </tr>
		  </table>
		</td>
	      </tr>
|;
		if($form->{batch_id})
		{
		print qq|	<tr>
		<th align="right" nowrap>| . 
			$locale->text('Batch Control Code') . qq|</th>
		<td>$form->{batch_control_code}</td>
	      </tr>
		<tr>
		<th align="right" nowrap>| . 
			$locale->text('Batch Name') . qq|</th>
		<td>$form->{batch_description}</td>
	      </tr>

|;

		}



		if ($form->{entity_control_code}){
			print qq|
	        <tr>
		<th align="right" nowrap>| . 
			$locale->text('Entity Control Code') . qq|</th>
		<td colspan=3>$form->{entity_control_code}</td>
	      </tr>
	        <tr>
		<th align="right" nowrap>| . 
			$locale->text('Tax ID') . qq|</th>
		<td colspan=3>$form->{tax_id}</td>
	      </tr>
	        <tr>
		<th align="right" nowrap>| . 
			$locale->text('Account') . qq|</th>
		<td colspan=3>$form->{meta_number}</td>
	      </tr>
              <tr class="address_row">
                <th align="right" nowrap>| .
                        $locale->text('Address'). qq|</th>
                <td colspan=3>$form->{address}, $form->{city}</td>
              </tr>
		|;
	       }
	print qq|
	      $exchangerate
	      $department
	    </table>
	  </td>
	  <td align=right>
	    <table>
	      $employee
	      <tr>
		<th align=right nowrap>| . $locale->text('Invoice Number') . qq|</th>
		<td><input name=invnumber size=20 value="$form->{invnumber}"></td>
	      </tr>
	      <tr>
		<th align=right nowrap>| . $locale->text('Order Number') . qq|</th>
		<td><input name=ordnumber size=20 value="$form->{ordnumber}"></td>
	      </tr>
              <tr>
                <th align=right nowrap>| . $locale->text('Invoice Created') . qq|</th>
                <td><input name=crdate size=11 title="($myconfig{'dateformat'})" value=$form->{crdate}></td>
              </tr>
	      <tr>
		<th align=right nowrap>| . $locale->text('Invoice Date') . qq|</th>
		<td><input name=transdate size=11 title="($myconfig{'dateformat'})" value=$form->{transdate}></td>
	      </tr>
	      <tr>
		<th align=right nowrap>| . $locale->text('Due Date') . qq|</th>
		<td><input name=duedate size=11 title="$myconfig{'dateformat'}" value=$form->{duedate}></td>
	      </tr>
	      <tr>
		<th align=right nowrap>| . $locale->text('PO Number') . qq|</th>
		<td><input name=ponumber size=20 value="$form->{ponumber}"></td>
	      </tr>
	    </table>
	  </td>
	</tr>
      </table>
    </td>
  </tr>
  <input type=hidden name=selectprojectnumber value="|
      . $form->escape( $form->{selectprojectnumber}, 1 ) . qq|">
  <tr>
    <td>
      <table>
|;

    $project = qq|
	  <th>| . $locale->text('Project') . qq|</th>
| if $form->{selectprojectnumber};

    print qq|
	<tr>
	  <th>| . $locale->text('Amount') . qq|</th>
	  <th></th>
	  <th>| . $locale->text('Account') . qq|</th>
	  <th>| . $locale->text('Description') . qq|</th>
	  <th>| . $locale->text('Tax Form Applied') . qq|</th>
	  $project
	</tr>
|;

    for $i ( 1 .. $form->{rowcount} ) {

        $selectamount = $form->{"select$form->{ARAP}_amount"};
        $selectamount =~
s/option>\Q$form->{"$form->{ARAP}_amount_$i"}\E/option selected>$form->{"$form->{ARAP}_amount_$i"}/;

        $selectprojectnumber = $form->{selectprojectnumber};
        $selectprojectnumber =~
          s/(<option value="\Q$form->{"projectnumber_$i"}\E")/$1 selected/;

        # format amounts
        $form->{"amount_$i"} =
          $form->format_amount( \%myconfig,$form->{"amount_$i"}, 2 );

        $project = qq|
	  <td align=right><select name="projectnumber_$i">$selectprojectnumber</select></td>
| if $form->{selectprojectnumber};

        if ( ( $rows = $form->numtextrows( $form->{"description_$i"}, 40 ) ) >
            1 )
        {
            $description =
qq|<td><textarea name="description_$i" rows=$rows cols=40>$form->{"description_$i"}</textarea></td>|;
        }
        else {
            $description =
qq|<td><input name="description_$i" size=40 value="$form->{"description_$i"}"></td>|;
        }

	$taxchecked="";
	if($form->{"taxformcheck_$i"} or ($form->{default_reportable} and ($i == $form->{rowcount})))
	{
		$taxchecked=qq|CHECKED="CHECKED"|;

	}

	$taxformcheck=qq|<td><input type="checkbox" name="taxformcheck_$i" value="1" $taxchecked></td>|;
        print qq|
	<tr valign=top>
	  <td><input name="amount_$i" size=10 value="$form->{"amount_$i"}" accesskey="$i"></td>
	  <td></td>
	  <td><select name="$form->{ARAP}_amount_$i">$selectamount</select></td>
	  $description
          $taxformcheck
	  $project
	</tr>
|;

    $form->hide_form( "entry_id_$i"); #New block of code to pass entry_id

    }
    foreach $item ( split / /, $form->{taxaccounts} ) {

	if($form->{"calctax_$item"} && $is_update){
             $form->{invtotal} += $form->{"tax_$item"};
	}
        $form->{"calctax_$item"} =
          ( $form->{"calctax_$item"} ) ? "checked" : "";
         
        $form->{"tax_$item"} =
          $form->format_amount( \%myconfig, $form->{"tax_$item"}, 2 );
	# CT:  This should probably be moved to a hidden field and a text label.
        print qq|
        <tr>
	  <td><input name="tax_$item" size=10 value=$form->{"tax_$item"}></td>
	  <td align=right><input name="calctax_$item" class=checkbox type=checkbox value=1 $form->{"calctax_$item"}></td>
 	  <td><select name="$form->{ARAP}_tax_$item">
 	<option value="$form->{ARAP}_tax_$item">$item--$form->{"${item}_description"}</option></select></td>
	</tr>
|;

        $form->hide_form(
            "${item}_rate",      "${item}_description",
            "${item}_taxnumber", "select$form->{ARAP}_tax_$item"
        );
    }

    $form->{invtotal} =
      $form->format_amount( \%myconfig, $form->{invtotal}, 2 );

    $form->hide_form( "oldinvtotal", "oldtotalpaid", "taxaccounts",
        "select$form->{ARAP}" );

    print qq|
        <tr>
	  <th align=left>$form->{invtotal}</th>
	  <td></td>
	  <td><select name=$form->{ARAP}>$form->{"select$form->{ARAP}"}</select></td>
        </tr>
        <tr>
           <td>&nbsp;</td>
           <td>&nbsp;</td>
           <th align=left>| . $locale->text('Notes') . qq|</th>
           <th align=left>| . $locale->text('Internal Notes') . qq|</th>
        </tr>
	<tr>
           <td>&nbsp;</td>
           <td>&nbsp;</td>
	  <td>$notes</td>
          <td>$intnotes</td>
	</tr>
      </table>
    </td>
  </tr>

  <tr class=listheading id="transaction-payments-label">
    <th class=listheading>| . $locale->text('Payments') . qq|</th>
  </tr>

  <tr id="invoice-payments-table">
    <td>
      <table width=100%>
|;

    if ( $form->{currency} eq $form->{defaultcurrency} ) {
        @column_index = qw(datepaid source memo paid ARAP_paid);
    }
    else {
        @column_index = qw(datepaid source memo paid exchangerate ARAP_paid);
    }

    $column_data{datepaid}     = "<th>" . $locale->text('Date') . "</th>";
    $column_data{paid}         = "<th>" . $locale->text('Amount') . "</th>";
    $column_data{exchangerate} = "<th>" . $locale->text('Exch') . "</th>";
    $column_data{ARAP_paid}    = "<th>" . $locale->text('Account') . "</th>";
    $column_data{source}       = "<th>" . $locale->text('Source') . "</th>";
    $column_data{memo}         = "<th>" . $locale->text('Memo') . "</th>";

    print "
        <tr>
";

    for (@column_index) { print "$column_data{$_}\n" }

    print "
        </tr>
";

    $form->{paidaccounts}++ if ( $form->{"paid_$form->{paidaccounts}"} );
    $form->{"select$form->{ARAP}_paid"} =~ /($form->{cash_accno}--[^<]*)/;
    $form->{"$form->{ARAP}_paid_$form->{paidaccounts}"} = $1;
    for $i ( 1 .. $form->{paidaccounts} ) {

        $form->hide_form("cleared_$i");

        print "
        <tr>
";

        $form->{"select$form->{ARAP}_paid_$i"} =
          $form->{"select$form->{ARAP}_paid"};
        $form->{"select$form->{ARAP}_paid_$i"} =~
s/option>\Q$form->{"$form->{ARAP}_paid_$i"}\E/option selected>$form->{"$form->{ARAP}_paid_$i"}/;

        # format amounts
        $form->{"paid_$i"} =
          $form->format_amount( \%myconfig, $form->{"paid_$i"}, 2 );
        $form->{"exchangerate_$i"} =
          $form->format_amount( \%myconfig, $form->{"exchangerate_$i"} );

        $exchangerate = qq|&nbsp;|;
        if ( $form->{currency} ne $form->{defaultcurrency} ) {
            if ( $form->{"forex_$i"} ) {
                $form->hide_form("exchangerate_$i");
                $exchangerate = qq|$form->{"exchangerate_$i"}|;
            }
            else {
                $exchangerate =
qq|<input name="exchangerate_$i" size=10 value=$form->{"exchangerate_$i"}>|;
            }
        }

        $form->hide_form("forex_$i");

        $column_data{paid} =
qq|<td align=center><input name="paid_$i" size=11 value=$form->{"paid_$i"}></td>|;
        $column_data{ARAP_paid} =
qq|<td align=center><select name="$form->{ARAP}_paid_$i">$form->{"select$form->{ARAP}_paid_$i"}</select></td>|;
        $column_data{exchangerate} = qq|<td align=center>$exchangerate</td>|;
        $column_data{datepaid} =
qq|<td align=center><input class="date" name="datepaid_$i" size=11 value=$form->{"datepaid_$i"}></td>|;
        $column_data{source} =
qq|<td align=center><input name="source_$i" size=11 value="$form->{"source_$i"}"></td>|;
        $column_data{memo} =
qq|<td align=center><input name="memo_$i" size=11 value="$form->{"memo_$i"}"></td>|;

        for (@column_index) { print qq|$column_data{$_}\n| }

        print "
        </tr>
";
    }

    $form->hide_form( "paidaccounts", "select$form->{ARAP}_paid", 'cash_accno' );

    print qq|
      </table>
    </td>
  </tr>
  <tr>
    <td><hr size=3 noshade></td>
  </tr>
</table>
|;

}

sub form_footer {
    $form->hide_form(qw(callback path login sessionid form_id));

    $transdate = $form->datetonum( \%myconfig, $form->{transdate} );
    $closedto  = $form->datetonum( \%myconfig, $form->{closedto} );

    # type=submit $locale->text('Update')
    # type=submit $locale->text('Print')
    # type=submit $locale->text('Post')
    # type=submit $locale->text('Schedule')
    # type=submit $locale->text('Ship to')
    # type=submit $locale->text('Post as new')
    # type=submit $locale->text('Delete')

    if ( !$form->{readonly} ) {

        &print_options;

        print "<br>";
        my $hold_text;

        if ($form->{on_hold}) {
            $hold_text = $locale->text('Off Hold');
        } else {
            $hold_text = $locale->text('On Hold');
        }
            

        %button = (
            'update' =>
              { ndx => 1, key => 'U', value => $locale->text('Update') },
            'copy_to_new' => # Shares an index with copy because one or the other
                             # must be deleted.  One can only either copy or 
                             # update, not both. --CT
              { ndx => 1, key => 'C', value => $locale->text('Copy to New') },
            'print' =>
              { ndx => 2, key => 'P', value => $locale->text('Print') },
            'post' => { ndx => 3, key => 'O', value => $locale->text('Post') },
            'schedule' =>
              { ndx => 7, key => 'H', value => $locale->text('Schedule') },
            'delete' =>
              { ndx => 8, key => 'D', value => $locale->text('Delete') },
            'on_hold' => 
              { ndx => 9, key => 'O', value => $hold_text },
            'save_info' => 
              { ndx => 10, key => 'I', value => $locale->text('Save Info') },
            'new_screen' => # Create a blank ar/ap invoice.
             { ndx => 12, key=> 'N', value => $locale->text('New') }
        );
        my $is_draft = 0;
        if (!$form->{approved} && !$form->{batch_id}){
           $is_draft = 1;
           $button{approve} = { 
                   ndx   => 3, 
                   key   => 'O', 
                   value => $locale->text('Post as Saved') };
           if (grep /^lsmb_$form->{company}__draft_edit$/, @{$form->{_roles}}){
               $button{edit_and_approve} = { 
                   ndx   => 4, 
                   key   => 'O', 
                   value => $locale->text('Post as Shown') };
          }
           delete $button{post_as_new};
           delete $button{post};
        }

        if ($form->{separate_duties} || $form->{batch_id}){
            $button{post}->{value} = $locale->text('Save');
            $button{post_as_new}->{value} = $locale->text('Save as New');
            $form->hide_form('separate_duties');
        }
        if ( $form->{id} && ($form->{approved} || !$form->{batch_id})) {
            if ( $form->{locked} || ( $transdate && $transdate <= $closedto ) )
            {
                for ( "post","delete" ) {
                    delete $button{$_};
                }
            }
        }
        elsif (!$form->{id}) {

            for ( "post_as_new","delete","save_info",
                  "print", 'copy_to_new', 'new_screen', 'on_hold') {
                delete $button{$_};
            }

            if ( $transdate && ($transdate <= $closedto) ) {
                for ( "post","save_info") { 
                    delete $button{$_};
                }
            }
        }
        if ($form->{id}){
            for ( "post_as_new"){
               delete $button{$_};
            }
            delete $button{'update'} unless $is_draft;
        }

        for ( sort { $button{$a}->{ndx} <=> $button{$b}->{ndx} } keys %button )
        {
            $form->print_button( \%button, $_ );
        }

    }
    if ($form->{id}){
        print qq|
<table width="100%">
<tr class="listtop">
<th colspan="4">| . $locale->text('Attached and Linked Files') . qq|</th>
<tr class="listheading">
<th>| . $locale->text('File name') . qq|</th>
<th>| . $locale->text('File type') . qq|</th>
<th>| . $locale->text('Attached at') . qq|</th>
<th>| . $locale->text('Attached by') . qq|</th>
</tr> |;
        foreach my $file (@{$form->{files}}){
              print qq|
<tr>
<td><a href="file.pl?action=get&file_class=1&ref_key=$form->{id}&id=$file->{id}"
            >$file->{file_name}</a></td> 
<td>$file->{mime_type}</td> 
<td>$file->{uploaded_at}</td> 
<td>$file->{uploaded_by_name}</td> 
</tr>
              |;
        }
        print qq|
<table width="100%">
<tr class="listheading">
<th>| . $locale->text('File name') . qq|</th>
<th>| . $locale->text('File type') . qq|</th>
<th>| . $locale->text('Attached To Type') . qq|</th>
<th>| . $locale->text('Attached To') . qq|</th>
<th>| . $locale->text('Attached at') . qq|</th>
<th>| . $locale->text('Attached by') . qq|</th>
</tr>|;
       foreach my $link (@{$form->{file_links}}){
            $aclass="&nbsp;";
            if ($link.src_class == 1){
                $aclass="Transaction";
            } elsif ($link.src_class == 2){
                $aclass="Order";
            }
            print qq|
<tr>
<td> $file->{file_name} </td> 
<td> $file->{mime_type} </td> 
<td> $aclass </td> 
<td> $file->{reference} </td> 
<td> $file->{attached_at} </td> 
<td> $file->{attached_by} </td> 
</tr>|;
       }
       print qq|
</table>|;
       $callback = $form->escape(
               lc($form->{ARAP}) . ".pl?action=edit&id=".$form->{id}
       );
       print qq|
<a href="file.pl?action=show_attachment_screen&ref_key=$form->{id}&file_class=1&callback=$callback"
   >[| . $locale->text('Attach') . qq|]</a>|;
    }
    if ( $form->{lynx} ) {
        require "bin/menu.pl";
        &menubar;
    }

    print qq|
</form>
| . $form->close_status_div . qq|
</body>
</html>
|;
}

sub on_hold {
    use LedgerSMB::IS;
    use LedgerSMB::IR; # TODO: refactor this over time
    
    if ($form->{id}) {
        if ($form->{ARAP} eq 'AR'){
            my $toggled = IS->toggle_on_hold($form);
        } else {
            my $toggled = IR->toggle_on_hold($form);
        }
        &edit(); 
    }    
}


sub edit_and_approve {
    use LedgerSMB::DBObject::Draft;
    use LedgerSMB;
    my $lsmb = LedgerSMB->new();
    $lsmb->merge($form);
    my $draft = LedgerSMB::DBObject::Draft->new({base => $lsmb});
    $draft->delete();
    delete $form->{id};
    AA->post_transaction( \%myconfig, \%$form );
    approve();
}

sub approve {
    use LedgerSMB::DBObject::Draft;
    use LedgerSMB;
    my $lsmb = LedgerSMB->new();
    $lsmb->merge($form);

    my $draft = LedgerSMB::DBObject::Draft->new({base => $lsmb});

    $draft->approve();

    if ($form->{callback}){
        print "Location: $form->{callback}\n";
        print "Status: 302 Found\n\n";
        print "<html><body>";
        my $url = $form->{callback};
        print qq|If you are not redirected automatically, click <a href="$url">|
                . qq|here</a>.</body></html>|;

    } else {
        $form->info($locale->text('Draft Posted'));
    }
}

sub update {
    my $display = shift;
    $is_update = 1;
    #&create_links;#tshvr4 In r5799 statement &create_links was added to bin/aa.pl  'sub update' But this makes that AA->get_name is called again from create_links and already user-filled in fields like $form->{AP_amount_1}     $form->{amount_1}     $form->{AP} are overridden again in get_name
    if ( !$display ) {

        $form->{invtotal} = 0;

        $form->{exchangerate} =
          $form->parse_amount( \%myconfig, $form->{exchangerate} );

        @flds =
          ( "amount", "$form->{ARAP}_amount", "projectnumber", "description","taxformcheck" );
        $count = 0;
        @a     = ();
        for $i ( 1 .. $form->{rowcount} ) {
            $form->{"amount_$i"} =
              $form->parse_amount( \%myconfig, $form->{"amount_$i"} );
            if ( $form->{"amount_$i"} ) {
                push @a, {};
                $j = $#a;

                for (@flds) { $a[$j]->{$_} = $form->{"${_}_$i"} }
                $count++;
            }
        }

        $form->redo_rows( \@flds, \@a, $count, $form->{rowcount} );
        $form->{rowcount} = $count + 1;

        for ( 1 .. $form->{rowcount} ) {
            $form->{invtotal} += $form->{"amount_$_"};
        }

        $form->{exchangerate} = $exchangerate
          if (
            $form->{forex} = (
                $exchangerate = $form->check_exchangerate(
                    \%myconfig, $form->{currency}, $form->{transdate},
                    ( $form->{ARAP} eq 'AR' ) ? 'buy' : 'sell'
                )
            )
          );

        if ( $newname = &check_name( $form->{vc} ) ) {
            $form->{notes} = $form->{intnotes} unless $form->{id};
            &rebuild_vc( $form->{vc}, $form->{ARAP}, $form->{transdate} );
        }
        if ( $form->{transdate} ne $form->{oldtransdate} ) {
            $form->{duedate} =
              $form->current_date( \%myconfig, $form->{transdate},
                $form->{terms} * 1 );
            $form->{oldtransdate} = $form->{transdate};
            $newproj =
              &rebuild_vc( $form->{vc}, $form->{ARAP}, $form->{transdate} )
              if !$newname;
            $form->all_projects( \%myconfig, undef, $form->{transdate} )
              if !$newproj;

            $form->{selectemployee} = "";
            if ( @{ $form->{all_employee} } ) {
                for ( @{ $form->{all_employee} } ) {
                    $form->{selectemployee} .=
                      qq|<option value="$_->{name}--$_->{id}">$_->{name}\n|;
                }
            }
        }
    }#!$display
    @taxaccounts = split / /, $form->{taxaccounts};

    for (@taxaccounts) {
        $form->{"tax_$_"} =
          $form->parse_amount( \%myconfig, $form->{"tax_$_"} );
    }

    @taxaccounts = Tax::init_taxes( $form, $form->{taxaccounts} );

    $j = 1;
    for $i ( 1 .. $form->{paidaccounts} ) {
        if ( $form->{"paid_$i"} ) {
            for (qw(datepaid source memo cleared)) {
                $form->{"${_}_$j"} = $form->{"${_}_$i"};
            }
            for (qw(paid exchangerate)) {
                $form->{"${_}_$j"} =
                  $form->parse_amount( \%myconfig, $form->{"${_}_$i"} );
            }

            $totalpaid += $form->{"paid_$j"};

            $form->{"exchangerate_$j"} = $exchangerate
              if (
                $form->{"forex_$j"} = (
                    $exchangerate = $form->check_exchangerate(
                        \%myconfig, $form->{currency},
                        $form->{"datepaid_$j"},
                        ( $form->{ARAP} eq 'AR' ) ? 'buy' : 'sell'
                    )
                )
              );

            if ( $j++ != $i ) {
                for (qw(datepaid source memo paid exchangerate forex cleared)) {
                    delete $form->{"${_}_$i"};
                }
            }
        }
        else {
            for (qw(datepaid source memo paid exchangerate forex cleared)) {
                delete $form->{"${_}_$i"};
            }
        }
    }
    $form->{paidaccounts} = $j;

    $form->{creditremaining} -=
      ( $form->parse_amount(\%myconfig, $form->{invtotal}) 
        - $form->parse_amount(\%myconfig, $totalpaid) 
        + $form->parse_amount(\%myconfig, $form->{oldtotalpaid}) 
        - $form->parse_amount(\%myconfig, $form->{oldinvtotal}) );
    $form->{oldinvtotal}  = $form->{invtotal};
    $form->{oldtotalpaid} = $totalpaid;

    # This must be done after check_name()
    # otherwise it will operate on the old vendor/customer id
    # rather than the newly selected one in the form
    # check_name() sets $form->{vendor_id} or $form->{customer_id}
    # and updates $form->{oldvendor} or $form->{oldcustomer}
    &create_links;

    &display_form;

}

sub post {
    if (!$form->close_form){
       $form->info(
          $locale->text('Data not saved.  Please try again.')
       );
       &update;
       $form->finalize_request();
    }
    if (!$form->{duedate}){
          $form->{duedate} = $form->{transdate};
    }
    $label =
      ( $form->{vc} eq 'customer' )
      ? $locale->text('Customer missing!')
      : $locale->text('Vendor missing!');

    # check if there is an invoice number, invoice and due date
    $form->isblank( "transdate", $locale->text('Invoice Date missing!') );
    $form->isblank( "duedate",   $locale->text('Due Date missing!') );
    # $form->isblank( "crdate",    $locale->text('Invoice Created Date missing!') );
    # pongraczi: we silently fill crdate with transdate if the user left empty to do not break existing workflow
    if (!$form->{crdate}){
          $form->{crdate} = $form->{transdate};
    }

    $form->isblank( $form->{vc}, $label );

    $closedto  = $form->datetonum( \%myconfig, $form->{closedto} );
    $transdate = $form->datetonum( \%myconfig, $form->{transdate} );

    $form->error(
        $locale->text('Cannot post transaction for a closed period!') )
      if ( $transdate <= $closedto );

    $form->isblank( "exchangerate", $locale->text('Exchange rate missing!') )
      if ( $form->{currency} ne $form->{defaultcurrency} );

    for $i ( 1 .. $form->{paidaccounts} ) {
        if ( $form->{"paid_$i"} ) {
            $datepaid = $form->datetonum( \%myconfig, $form->{"datepaid_$i"} );

            $form->isblank( "datepaid_$i",
                $locale->text('Payment date missing!') );

            $form->error(
                $locale->text('Cannot post payment for a closed period!') )
              if ( $datepaid <= $closedto );

            if ( $form->{currency} ne $form->{defaultcurrency} ) {
                $form->{"exchangerate_$i"} = $form->{exchangerate}
                  if ( $transdate == $datepaid );
                $form->isblank( "exchangerate_$i",
                    $locale->text('Exchange rate for payment missing!') );
            }
        }
    }

    # if oldname ne name redo form
    ($name, $id) = split /--/, $form->{ $form->{vc} };
    if (( $form->{"old$form->{vc}"} ne qq|$name--$form->{"$form->{vc}_id"}|) 
        and ($form->{"old$form->{vc}"} !~ /$name--$id--/ )) {
        &update;
        $form->finalize_request();
    }

    if ( !$form->{repost} ) {
        if ( $form->{id} ) {
            &repost;
            $form->finalize_request();
        }
    }

    
    
    if ( AA->post_transaction( \%myconfig, \%$form ) ) {
	  
       $form->update_status( \%myconfig );
       if ( $form->{printandpost} ) {
           &{"print_$form->{formname}"}( $old_form, 1 );
        }

        if(defined($form->{batch_id}) and $form->{batch_id} 
           and ($form->{callback} !~ /vouchers/))
	{
        	$form->{callback}.= qq|&batch_id=$form->{batch_id}|;
	}
        if ($form->{separate_duties}){
            $form->{rowcount} = 0;
            edit();
        }
        else {$form->redirect( $locale->text('Transaction posted!') );}
    }
    else {
        $form->error( $locale->text('Cannot post transaction!') );
    }

}#post end

# New Function Body starts Here



sub save_info {

	    my $taxformfound=0;

	    $taxformfound=AA->taxform_exist($form,$form->{"$form->{vc}_id"});
            $form->{arap} = lc($form->{ARAP});
            AA->save_intnotes($form);
	    
	    foreach my $i(1..($form->{rowcount}))
	    {
		
		if($form->{"taxformcheck_$i"} and $taxformfound)
		{
			
		  AA->update_ac_tax_form($form,$form->{dbh},$form->{"entry_id_$i"},"true") if($form->{"entry_id_$i"});

		}
		else
		{

		    AA->update_ac_tax_form($form,$form->{dbh},$form->{"entry_id_$i"},"false") if($form->{"entry_id_$i"});

		}
		
	    }    

	    if ($form->{callback}){
		print "Location: $form->{callback}\n";
		print "Status: 302 Found\n\n";
		print "<html><body>";
		my $url = $form->{callback};
		print qq|If you are not redirected automatically, click <a href="$url">|
			. qq|here</a>.</body></html>|;

	    } else {
		$form->info($locale->text('Draft Posted'));
	    }

}


#New function starts Here


sub delete {

    $form->{title} = $locale->text('Confirm!');

    $form->header;

    print qq|
<body>

<form method=post action=$form->{script}>
|;

    $form->{action} = "yes";
    $form->hide_form;

    print qq|
<h2 class=confirm>$form->{title}</h2>

<h4>|
      . $locale->text('Are you sure you want to delete Transaction')
      . qq| $form->{invnumber}</h4>

<button name="action" class="submit" type="submit" value="yes">|
      . $locale->text('Yes')
      . qq|</button>
</form>

</body>
</html>
|;

}

sub yes {

    if (
        AA->delete_transaction(
            \%myconfig, \%$form, ${LedgerSMB::Sysconfig::spool}
        )
      )
    {
        $form->redirect( $locale->text('Transaction deleted!') );
    }
    else {
        $form->error( $locale->text('Cannot delete transaction!') );
    }

}

sub search {

    $form->create_links( module => $form->{ARAP},
			 myconfig => \%myconfig,
			 vc => $form->{vc},
			 billing => 0);

    $form->{"select$form->{ARAP}"} = "<option>\n";
    for ( @{ $form->{"$form->{ARAP}_links"}{ $form->{ARAP} } } ) {
        $form->{"select$form->{ARAP}"} .=
          "<option>$_->{accno}--$_->{description}\n";
    }

    if ( @{ $form->{"all_$form->{vc}"} } ) {
        $selectname = "";
        for ( @{ $form->{"all_$form->{vc}"} } ) {
            $selectname .=
              qq|<option value="$_->{name}--$_->{id}">$_->{name}\n|;
        }
        $selectname =
          qq|<select name="$form->{vc}"><option>\n$selectname</select>|;
    }
    else {
        $selectname = qq|<input name=$form->{vc} size=35>|;
    }

    # departments
    if ( @{ $form->{all_department} } ) {
        $form->{selectdepartment} = "<option>\n";

        for ( @{ $form->{all_department} } ) {
            $form->{selectdepartment} .=
qq|<option value="$_->{description}--$_->{id}">$_->{description}\n|;
        }

        $l_department =
          qq|<input name="l_department" class=checkbox type=checkbox value=Y> |
          . $locale->text('Department');

        $department = qq| 
        <tr> 
	  <th align=right nowrap>| . $locale->text('Department') . qq|</th>
	  <td colspan=3><select name=department>$form->{selectdepartment}</select></td>
	</tr>
|;
    }

    if ( @{ $form->{all_employee} } ) {
        $form->{selectemployee} = "<option>\n";
        for ( @{ $form->{all_employee} } ) {
            $form->{selectemployee} .=
              qq|<option value="$_->{name}--$_->{id}">$_->{name}\n|;
        }

        $employeelabel =
          ( $form->{ARAP} eq 'AR' )
          ? $locale->text('Salesperson')
          : $locale->text('Employee');

        $employee = qq|
        <tr>
	  <th align=right nowrap>$employeelabel</th>
	  <td colspan=3><select name=employee>$form->{selectemployee}</select></td>
	</tr>
|;

        $l_employee =
qq|<input name="l_employee" class=checkbox type=checkbox value=Y> $employeelabel|;

        $l_manager =
          qq|<input name="l_manager" class=checkbox type=checkbox value=Y> |
          . $locale->text('Manager');
    }

    $form->{title} =
      ( $form->{ARAP} eq 'AR' )
      ? $locale->text('AR Transactions')
      : $locale->text('AP Transactions');

    $invnumber = qq|
	<tr>
	  <th align=right nowrap>| . $locale->text('Invoice Number') . qq|</th>
	  <td colspan=3><input name=invnumber size=20></td>
	</tr>
	<tr>
	  <th align=right nowrap>| . $locale->text('Order Number') . qq|</th>
	  <td colspan=3><input name=ordnumber size=20></td>
	</tr>
	<tr>
	  <th align=right nowrap>| . $locale->text('PO Number') . qq|</th>
	  <td colspan=3><input name=ponumber size=20></td>
	</tr>
	<tr>
	  <th align=right nowrap>| . $locale->text('Source') . qq|</th>
	  <td colspan=3><input name=source size=40></td>
	</tr>
	<tr>
	  <th align=right nowrap>| . $locale->text('Description') . qq|</th>
	  <td colspan=3><input name=description size=40></td>
	</tr>
	<tr>
	  <th align=right nowrap>| . $locale->text('Notes') . qq|</th>
	  <td colspan=3><input name=notes size=40></td>
	</tr>
|;

    $openclosed = qq|
	      <tr>
		<td nowrap><input name=open class=checkbox type=checkbox value=Y checked> |
      . $locale->text('Open')
      . qq|</td>
		<td nowrap><input name=closed class=checkbox type=checkbox value=Y> |
      . $locale->text('Closed')
      . qq|</td>
	      </tr>
|;

    if ( $form->{outstanding} ) {
        $form->{title} =
          ( $form->{ARAP} eq 'AR' )
          ? $locale->text('AR Outstanding')
          : $locale->text('AP Outstanding');
        $invnumber  = "";
        $openclosed = "";
        $summary    = "";
    }
    $summary = qq|
              <tr>
		<td><input name=summary type=radio class=radio value=1 checked> |
      . $locale->text('Summary')
      . qq|</td>
		<td><input name=summary type=radio class=radio value=0> |
      . $locale->text('Detail') . qq|
		</td>
	      </tr>
|;


    if ( @{ $form->{all_years} } ) {

        # accounting years
        $form->{selectaccountingyear} = "<option>\n";
        for ( @{ $form->{all_years} } ) {
            $form->{selectaccountingyear} .= qq|<option>$_\n|;
        }
        $form->{selectaccountingmonth} = "<option>\n";
        for ( sort keys %{ $form->{all_month} } ) {
            $form->{selectaccountingmonth} .=
              qq|<option value=$_>|
              . $locale->text( $form->{all_month}{$_} ) . qq|\n|;
        }

        $selectfrom = qq|
        <tr>
	<th align=right>| . $locale->text('Period') . qq|</th>
	<td colspan=3>
	<select name=month>$form->{selectaccountingmonth}</select>
	<select name=year>$form->{selectaccountingyear}</select>
	<input name=interval class=radio type=radio value=0 checked>&nbsp;|
          . $locale->text('Current') . qq|
	<input name=interval class=radio type=radio value=1>&nbsp;|
          . $locale->text('Month') . qq|
	<input name=interval class=radio type=radio value=3>&nbsp;|
          . $locale->text('Quarter') . qq|
	<input name=interval class=radio type=radio value=12>&nbsp;|
          . $locale->text('Year') . qq|
	</td>
      </tr>
|;
    }

    $name = $locale->text('Customer');
    my $vc_number=$locale->text("Customer Number");
    $l_name =
qq|<input name="l_name" class=checkbox type=checkbox value=Y checked> $name|;
    $l_till =
      qq|<input name="l_till" class=checkbox type=checkbox value=Y> |
      . $locale->text('Till');

    if ( $form->{vc} eq 'vendor' ) {
        $name   = $locale->text('Vendor');
        $vc_number=$locale->text("Vendor Number");
        $l_till = "";
        $l_name =
qq|<input name="l_name" class=checkbox type=checkbox value=Y checked> $name|;
    }

    @a = ();
    push @a,
      qq|<input name="l_runningnumber" class=checkbox type=checkbox value=Y> |
      . $locale->text('No.');
    push @a, qq|<input name="l_id" class=checkbox type=checkbox value=Y> |
      . $locale->text('ID');
    push @a,
qq|<input name="l_invnumber" class=checkbox type=checkbox value=Y checked> |
      . $locale->text('Invoice Number');
    push @a,
      qq|<input name="l_ordnumber" class=checkbox type=checkbox value=Y> |
      . $locale->text('Order Number');
    push @a, qq|<input name="l_ponumber" class=checkbox type=checkbox value=Y> |
      . $locale->text('PO Number');
    push @a, qq|<input name="l_transdate" class=checkbox type=checkbox value=Y checked> |
      . $locale->text('Invoice Date');
    if (!$form->{outstanding}){
        push @a,
qq|<input name="l_projectnumber" class=checkbox type=checkbox value=Y checked> |
      . $locale->text('Project Numbers');
    }
    push @a, $l_name;
    push @a, $l_employee if $l_employee;
    push @a, $l_manager if $l_employee;
    push @a, $l_department if $l_department;
    push @a,
      qq|<input name="l_netamount" class=checkbox type=checkbox value=Y> |
      . $locale->text('Amount');
    push @a, qq|<input name="l_tax" class=checkbox type=checkbox value=Y> |
      . $locale->text('Tax');
    push @a,
      qq|<input name="l_amount" class=checkbox type=checkbox value=Y checked> |
      . $locale->text('Total');
    push @a, qq|<input name="l_curr" class=checkbox type=checkbox value=Y> |
      . $locale->text('Currency');
    push @a, qq|<input name="l_datepaid" class=checkbox type=checkbox value=Y> |
      . $locale->text('Date Paid');
    push @a,
      qq|<input name="l_paid" class=checkbox type=checkbox value=Y checked> |
      . $locale->text('Paid');
    push @a, qq|<input name="l_crdate" class=checkbox type=checkbox value=Y> |
      . $locale->text('Invoice Created');
    push @a, qq|<input name="l_duedate" class=checkbox type=checkbox value=Y> |
      . $locale->text('Due Date');
    push @a, qq|<input name="l_due" class=checkbox type=checkbox value=Y> |
      . $locale->text('Amount Due');
    push @a, qq|<input name="l_notes" class=checkbox type=checkbox value=Y> |
      . $locale->text('Notes');
    push @a, $l_till if $l_till;
    push @a,
      qq|<input name="l_shippingpoint" class=checkbox type=checkbox value=Y> |
      . $locale->text('Shipping Point');
    push @a, qq|<input name="l_shipvia" class=checkbox type=checkbox value=Y> |
      . $locale->text('Ship via');

    $form->header;

    print qq|
<body>

<form method=post action=$form->{script}>

<table width=100%>
  <tr><th class=listtop>$form->{title}</th></tr>
  <tr height="5"></tr>
  <tr>
    <td>
      <table>
        <tr>
	  <th align=right>| . $locale->text('Account') . qq|</th>
	  <td colspan=3><select name=$form->{ARAP}>$form->{"select$form->{ARAP}"}</select></td>
	</tr>
	<tr>
	  <th align=right>$name</th>
	  <td colspan=3>$selectname</td>
	</tr>
	<tr><th align="right">|.$vc_number.qq|</th>
	    <td colspan="3"><input name="meta_number" size="36">
        </tr>
	$employee
	$department
	$invnumber
	<tr>
	  <th align=right>| . $locale->text('Ship via') . qq|</th>
	  <td colspan=3><input name=shipvia size=40></td>
	</tr>
	<tr>
	  <th align=right nowrap>| . $locale->text('From') . qq|</th>
	  <td><input class="date" name=transdatefrom size=11 title="$myconfig{dateformat}"></td>
	  <th align=right>| . $locale->text('Date to') . qq|</th>
	  <td><input class="date" name=transdateto size=11 title="$myconfig{dateformat}"></td>
	</tr>
	$selectfrom
      </table>
    </td>
  </tr>
  
  <tr>
    <td>        
        |.$locale->text('All Invoices').qq|: <input type="radio" name="invoice_type" checked value="1"> 
        |.$locale->text('Active').qq|: <input type="radio" name="invoice_type" value="2">  
        |.$locale->text('On Hold').qq|: <input type="radio" name="invoice_type" value="3"> 
        <br/>    
    </td>
  </tr>
  
  <tr>
    <td>
      <table>
	<tr>
	  <th align=right nowrap>| . $locale->text('Include in Report') . qq|</th>
	  <td>
	    <table width=100%>
	      $openclosed
	      $summary
|;

    $form->{sort} = "transdate";
    $form->hide_form(qw(title outstanding sort));

    while (@a) {
        for ( 1 .. 5 ) {
            print qq|<td nowrap>| . shift @a;
            print qq|</td>\n|;
        }
        print qq|</tr>\n|;
    }

    print qq|
	      <tr>
		<td nowrap><input name="l_subtotal" class=checkbox type=checkbox value=Y> |
      . $locale->text('Subtotal')
      . qq|</td>
	      </tr>
	    </table>
	  </td>
	</tr>
      </table>
    </td>
  </tr>
  <tr>
    <td><hr size=3 noshade></td>
  </tr>
</table>

<br>
<input type="hidden" name="action" value="continue">
<button class="submit" type="submit" name="action" value="continue">|
      . $locale->text('Continue')
      . qq|</button>|;

    $form->hide_form(qw(nextsub path login sessionid));

    print qq|
</form>
|;

    if ( $form->{lynx} ) {
        require "bin/menu.pl";
        &menubar;
    }

    print qq|
 
</body>
</html>
|;

}

sub transactions {
    # it shouldn't be putting it into vendor_id or customer_id, but into 
    # entity_id, conforming to the new entity tables.
    my $total_due = 0;
    if ( $form->{ $form->{vc} } ) {
        $form->{ $form->{vc} } = $form->unescape( $form->{ $form->{vc} } );
        ( $form->{ $form->{vc} }, $form->{"$form->{vc}_id"} ) =
          split( /--/, $form->{ $form->{vc} } );
    }
    if ($form->{vc} eq 'customer'){
        $form->{entity_class} = 2;
    } elsif ($form->{vc} eq 'vendor'){
        $form->{entity_class} = 1;
    } else {
        $form->{entity_class} = "0";
    }
    @column_index;
    AA->transactions( \%myconfig, \%$form );

    $href = "$form->{script}?action=transactions";
    for (qw(direction oldsort till outstanding path login sessionid summary)) {
        $href .= qq|&$_=$form->{$_}|;
    }
    $href .= "&title=" . $form->escape( $form->{title} );

    $form->sort_order();

    $callback = "$form->{script}?action=transactions";
    for (qw(direction oldsort till outstanding path login sessionid summary)) {
        $callback .= qq|&$_=$form->{$_}|;
    }
    $callback .= "&title=" . $form->escape( $form->{title}, 1 );

    if ( $form->{ $form->{ARAP} } ) {
        $callback .=
          "&$form->{ARAP}=" . $form->escape( $form->{ $form->{ARAP} }, 1 );
        $href .= "&$form->{ARAP}=" . $form->escape( $form->{ $form->{ARAP} } );
        $form->{ $form->{ARAP} } =~ s/--/ /;
        $option = $locale->text('Account') . " : $form->{$form->{ARAP}}";
    }

    if ( $form->{ $form->{vc} } ) {
        $callback .=
            "&$form->{vc}="
          . $form->escape( $form->{ $form->{vc} }, 1 )
          . qq|--$form->{"$form->{vc}_id"}|;
        $href .=
            "&$form->{vc}="
          . $form->escape( $form->{ $form->{vc} } )
          . qq|--$form->{"$form->{vc}_id"}|;
        $option .= "\n<br>" if ($option);
        $name =
          ( $form->{vc} eq 'customer' )
          ? $locale->text('Customer')
          : $locale->text('Vendor');
        $option .= "$name : $form->{$form->{vc}}";
    }
    if ( $form->{department} ) {
        $callback .= "&department=" . $form->escape( $form->{department}, 1 );
        $href .= "&department=" . $form->escape( $form->{department} );
        ($department) = split /--/, $form->{department};
        $option .= "\n<br>" if ($option);
        $option .= $locale->text('Department') . " : $department";
    }
    if ( $form->{employee} ) {
        $callback .= "&employee=" . $form->escape( $form->{employee}, 1 );
        $href .= "&employee=" . $form->escape( $form->{employee} );
        ($employee) = split /--/, $form->{employee};
        $option .= "\n<br>" if ($option);
        if ( $form->{ARAP} eq 'AR' ) {
            $option .= $locale->text('Salesperson');
        }
        else {
            $option .= $locale->text('Employee');
        }
        $option .= " : $employee";
    }

    if ( $form->{invnumber} ) {
        $callback .= "&invnumber=" . $form->escape( $form->{invnumber}, 1 );
        $href   .= "&invnumber=" . $form->escape( $form->{invnumber} );
        $option .= "\n<br>" if ($option);
        $option .= $locale->text('Invoice Number') . " : $form->{invnumber}";
    }
    if ( $form->{ordnumber} ) {
        $callback .= "&ordnumber=" . $form->escape( $form->{ordnumber}, 1 );
        $href   .= "&ordnumber=" . $form->escape( $form->{ordnumber} );
        $option .= "\n<br>" if ($option);
        $option .= $locale->text('Order Number') . " : $form->{ordnumber}";
    }
    if ( $form->{ponumber} ) {
        $callback .= "&ponumber=" . $form->escape( $form->{ponumber}, 1 );
        $href   .= "&ponumber=" . $form->escape( $form->{ponumber} );
        $option .= "\n<br>" if ($option);
        $option .= $locale->text('PO Number') . " : $form->{ponumber}";
    }
    if ( $form->{source} ) {
        $callback .= "&source=" . $form->escape( $form->{source}, 1 );
        $href   .= "&source=" . $form->escape( $form->{source} );
        $option .= "\n<br>" if $option;
        $option .= $locale->text('Source') . " : $form->{source}";
    }
    if ( $form->{description} ) {
        $callback .= "&description=" . $form->escape( $form->{description}, 1 );
        $href   .= "&description=" . $form->escape( $form->{description} );
        $option .= "\n<br>" if $option;
        $option .= $locale->text('Description') . " : $form->{description}";
    }
    if ( $form->{notes} ) {
        $callback .= "&notes=" . $form->escape( $form->{notes}, 1 );
        $href   .= "&notes=" . $form->escape( $form->{notes} );
        $option .= "\n<br>" if $option;
        $option .= $locale->text('Notes') . " : $form->{notes}";
    }
    if ( $form->{shipvia} ) {
        $callback .= "&shipvia=" . $form->escape( $form->{shipvia}, 1 );
        $href   .= "&shipvia=" . $form->escape( $form->{shipvia} );
        $option .= "\n<br>" if $option;
        $option .= $locale->text('Ship via') . " : $form->{shipvia}";
    }
    if ( $form->{transdatefrom} ) {
        $callback .= "&transdatefrom=$form->{transdatefrom}";
        $href     .= "&transdatefrom=$form->{transdatefrom}";
        $option   .= "\n<br>" if ($option);
        $option .=
            $locale->text('From') . "&nbsp;"
          . $locale->date( \%myconfig, $form->{transdatefrom}, 1 );
    }
    if ( $form->{transdateto} ) {
        $callback .= "&transdateto=$form->{transdateto}";
        $href     .= "&transdateto=$form->{transdateto}";
        $option   .= "\n<br>" if ($option);
        $option .=
          $locale->text( 'To [_1]',
            $locale->date( \%myconfig, $form->{transdateto}, 1 ) );
    }
    if ( $form->{open} ) {
        $callback .= "&open=$form->{open}";
        $href     .= "&open=$form->{open}";
        $option   .= "\n<br>" if ($option);
        $option   .= $locale->text('Open');
    }
    if ( $form->{closed} ) {
        $callback .= "&closed=$form->{closed}";
        $href     .= "&closed=$form->{closed}";
        $option   .= "\n<br>" if ($option);
        $option   .= $locale->text('Closed');
    }

    @columns =
      $form->sort_columns(
        qw(transdate id invnumber ordnumber ponumber name netamount tax amount paid due curr datepaid crdate duedate notes till employee manager shippingpoint shipvia department)
      );
    pop @columns if $form->{department};
    unshift @columns, "runningnumber";

    foreach $item (@columns) {
        if ( $form->{"l_$item"} eq "Y" ) {
            push @column_index, $item;

            if ( $form->{l_curr} && $item =~ /(amount|tax|paid|due)/ ) {
                push @column_index, "fx_$item";
            }

            # add column to href and callback
            $callback .= "&l_$item=Y";
            $href     .= "&l_$item=Y";
        }
    }
    if ( !$form->{summary} and !$form->{outstanding}) {
        foreach $item (qw(source debit credit accno description projectnumber))
        {
            push @column_index, $item;
        }
    } elsif ($form->{l_projectnumber} eq 'Y'){
        push @column_index, 'projectnumber';
    }

    if ( $form->{l_subtotal} eq 'Y' ) {
        $callback .= "&l_subtotal=Y";
        $href     .= "&l_subtotal=Y";
    }

    $employee =
      ( $form->{ARAP} eq 'AR' )
      ? $locale->text('Salesperson')
      : $locale->text('Employee');
    $name =
      ( $form->{vc} eq 'customer' )
      ? $locale->text('Customer')
      : $locale->text('Vendor');

    $column_header{runningnumber} = qq|<th class=listheading>&nbsp;</th>|;
    $column_header{id} =
        "<th><a class=listheading href=$href&sort=id>"
      . $locale->text('ID')
      . "</a></th>";
    $column_header{transdate} =
        "<th><a class=listheading href=$href&sort=transdate>"
      . $locale->text('Date')
      . "</a></th>";
    $column_header{crdate} =
        "<th><a class=listheading href=$href&sort=crdate>"
      . $locale->text('Invoice Created')
      . "</a></th>";
    $column_header{duedate} =
        "<th><a class=listheading href=$href&sort=duedate>"
      . $locale->text('Due Date')
      . "</a></th>";
    $column_header{invnumber} =
        "<th><a class=listheading href=$href&sort=invnumber>"
      . $locale->text('Invoice')
      . "</a></th>";
    if ($form->{summary}){
        $column_header{invnumber} =
            "<th><a class=listheading href=$href&sort=invnumber>"
            . $locale->text('Invoices')
            . "</a></th>";

    }
    $column_header{ordnumber} =
        "<th><a class=listheading href=$href&sort=ordnumber>"
      . $locale->text('Order')
      . "</a></th>";
    $column_header{ponumber} =
        "<th><a class=listheading href=$href&sort=ponumber>"
      . $locale->text('PO Number')
      . "</a></th>";
    $column_header{name} =
      "<th>".$locale->text('Account')."</th><th><a class=listheading href=$href&sort=name>$name</a></th>";
    $column_header{netamount} =
      "<th class=listheading>" . $locale->text('Amount') . "</th>";
    $column_header{tax} =
      "<th class=listheading>" . $locale->text('Tax') . "</th>";
    $column_header{amount} =
      "<th class=listheading>" . $locale->text('Total') . "</th>";
    $column_header{paid} =
      "<th class=listheading>" . $locale->text('Paid') . "</th>";
    $column_header{datepaid} =
        "<th><a class=listheading href=$href&sort=datepaid>"
      . $locale->text('Date Paid')
      . "</a></th>";
    $column_header{due} =
      "<th class=listheading>" . $locale->text('Amount Due') . "</th>";
    $column_header{notes} =
      "<th class=listheading>" . $locale->text('Notes') . "</th>";
    $column_header{employee} =
      "<th><a class=listheading href=$href&sort=employee>$employee</th>";
    $column_header{manager} =
      "<th><a class=listheading href=$href&sort=manager>"
      . $locale->text('Manager') . "</th>";
    $column_header{till} =
      "<th class=listheading><a class=listheading href=$href&sort=till>"
      . $locale->text('Till') . "</th>";

    $column_header{shippingpoint} =
        "<th><a class=listheading href=$href&sort=shippingpoint>"
      . $locale->text('Shipping Point')
      . "</a></th>";
    $column_header{shipvia} =
        "<th><a class=listheading href=$href&sort=shipvia>"
      . $locale->text('Ship via')
      . "</a></th>";

    $column_header{curr} =
        "<th><a class=listheading href=$href&sort=curr>"
      . $locale->text('Curr')
      . "</a></th>";
    for (qw(amount tax netamount paid due)) {
        $column_header{"fx_$_"} = "<th>&nbsp;</th>";
    }

    $column_header{department} =
        "<th><a class=listheading href=$href&sort=department>"
      . $locale->text('Department')
      . "</a></th>";

    $column_header{accno} =
        "<th><a class=listheading href=$href&sort=accno>"
      . $locale->text('Account')
      . "</a></th>";
    $column_header{source} =
        "<th><a class=listheading href=$href&sort=source>"
      . $locale->text('Source')
      . "</a></th>";
    $column_header{debit} =
      "<th class=listheading>" . $locale->text('Debit') . "</th>";
    $column_header{credit} =
      "<th class=listheading>" . $locale->text('Credit') . "</th>";
    $column_header{projectnumber} =
        "<th><a class=listheading href=$href&sort=projectnumber>"
      . $locale->text('Project')
      . "</a></th>";
    $column_header{description} =
        "<th><a class=listheading href=$href&sort=linedescription>"
      . $locale->text('Description')
      . "</a></th>";

    $form->{title} =
      ( $form->{title} ) ? $form->{title} : $locale->text('AR Transactions');

    $form->header;

    print qq|
<body>

<table width=100%>
  <tr>
    <th class=listtop>$form->{title}</th>
  </tr>
  <tr height="5"></tr>
  <tr>
    <td>$option</td>
  </tr>
  <tr>
    <td>
      <table width=100%>
	<tr class=listheading>
|;

    for (@column_index) { print "\n$column_header{$_}" }

    print qq|
	</tr>
|;

    # add sort and escape callback, this one we use for the add sub
    $form->{callback} = $callback .= "&sort=$form->{sort}";

    # escape callback for href
    $callback = $form->escape($callback);

    # flip direction
    $direction = ( $form->{direction} eq 'ASC' ) ? "ASC" : "DESC";
    $href =~ s/&direction=(\w+)&/&direction=$direction&/;

    if ( @{ $form->{transactions} } ) {
        $sameitem = $form->{transactions}->[0]->{ $form->{sort} };
    }

    # sums and tax on reports by Antonio Gallardo
    #
    $i = 0;

    foreach $ref ( @{ $form->{transactions} } ) {

        $i++;
        #print STDERR localtime()." aa.pl sub transactions row=".Data::Dumper::Dumper($ref)."\n";
        #print STDERR localtime()." aa.pl sub transactions invnumber=$ref->{invnumber} projectnumber=$ref->{projectnumber}\n";
        if ($form->{l_projectnumber} eq 'Y' and ref($ref->{ac_projects}) eq 'ARRAY' and ref($ref->{inv_projects}) eq 'ARRAY'){
            #HV $ref->{projectnumber} in this case is not filled by AA-->transactions
            my @projects;
            my %projects_hash;
            foreach $acprjct(@{$ref->{ac_projects}})
            {
             if($acprjct)
             {
              if(! exists $projects_hash{$acprjct})
              {
               #print STDERR localtime()." aa.pl sub transactions acprjct=$acprjct\n";
               $projects_hash{$acprjct}=1;
               push @projects, $acprjct;
              }
             }
            }
            foreach $invprjct(@{$ref->{inv_projects}})
            {
             if($invprjct)
             {
              if(! exists $projects_hash{$invprjct})
              {
               #print STDERR localtime()." aa.pl sub transactions invprjct=$invprjct\n";
               $projects_hash{$invprjct}=1;
               push @projects, $invprjct;
              }
             }
            }
            #push @projects, @{$ref->{ac_projects}};
            #push @projects, @{$ref->{inv_projects}};
            $ref->{projectnumber} = join '<br />', @projects;
            $ref->{projectnumber} =~ s/(<br \/>)+/<br \/>/;
        } elsif ($form->{l_projectnumber} eq 'Y') { $form->error($locale->text('Invalid Project Data:'). 
                              ref($ref->{ac_projects}) . $ref->{ac_projects} .  ref($ref->{inv_projects}) . $ref->{inv_projects}
                             )
        }
        if ( $form->{l_subtotal} eq 'Y' ) {
            if ( $sameitem ne $ref->{ $form->{sort} } ) {
                &subtotal;
                $sameitem = $ref->{ $form->{sort} };
            }
        }

        if ( $form->{l_curr} ) {
            for (qw(netamount amount paid)) {
                $ref->{"fx_$_"} = $ref->{$_} / $ref->{exchangerate};
            }

            for (qw(netamount amount paid)) {
                $column_data{"fx_$_"} = "<td align=right>"
                  . $form->format_amount( \%myconfig, $ref->{"fx_$_"}, 2,
                    "&nbsp;" )
                  . "</td>";
            }

            $column_data{fx_tax} = "<td align=right>"
              . $form->format_amount( \%myconfig,
                $ref->{fx_amount} - $ref->{fx_netamount},
                2, "&nbsp;" )
              . "</td>";
            $column_data{fx_due} = "<td align=right>"
              . $form->format_amount( \%myconfig,
                $ref->{fx_amount} - $ref->{fx_paid},
                2, "&nbsp;" )
              . "</td>";

            $subtotalfxnetamount += $ref->{fx_netamount};
            $subtotalfxamount    += $ref->{fx_amount};
            $subtotalfxpaid      += $ref->{fx_paid};

            $totalfxnetamount += $ref->{fx_netamount};
            $totalfxamount    += $ref->{fx_amount};
            $totalfxpaid      += $ref->{fx_paid};

        }

        $column_data{runningnumber} = "<td align=right>$i</td>";

        for (qw(netamount amount paid debit credit)) {
            $column_data{$_} =
                "<td align=right>"
              . $form->format_amount( \%myconfig, $ref->{$_}, 2, "&nbsp;" )
              . "</td>";
        }

        $column_data{tax} = "<td align=right>"
          . $form->format_amount( \%myconfig,
            $ref->{amount} - $ref->{netamount},
            2, "&nbsp;" )
          . "</td>";
        $total_due += $ref->{amount} - $ref->{paid};
        $column_data{due} = "<td align=right>"
          . $form->format_amount( \%myconfig, $ref->{amount} - $ref->{paid},
            2, "&nbsp;" )
          . "</td>";

        $subtotalnetamount += $ref->{netamount};
        $subtotalamount    += $ref->{amount};
        $subtotalpaid      += $ref->{paid};
        $subtotaldebit     += $ref->{debit};
        $subtotalcredit    += $ref->{credit};

        $totalnetamount += $ref->{netamount};
        $totalamount    += $ref->{amount};
        $totalpaid      += $ref->{paid};
        $totaldebit     += $ref->{debit};
        $totalcredit    += $ref->{credit};

        $module =
            ( $ref->{invoice} )
          ? ( $form->{ARAP} eq 'AR' ) ? "is.pl" : "ir.pl"
          :   $form->{script};
        $module = ( $ref->{till} ) ? "ps.pl" : $module;
        if ($form->{outstanding} and $form->{summary}){
            $column_data{invnumber} = "<td>$ref->{invnumber}</td>";
	} else {
            $column_data{invnumber} =
"<td><a href=$module?action=edit&id=$ref->{id}&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&callback=$callback>$ref->{invnumber}&nbsp;</a></td>";
        }
        for (qw(notes description)) { $ref->{$_} =~ s/\r?\n/<br>/g }
        for (
            qw(transdate datepaid crdate duedate department ordnumber ponumber notes shippingpoint shipvia employee manager till source description projectnumber)
          )
        {
            $column_data{$_} = "<td>$ref->{$_}&nbsp;</td>";
        }
        for (qw(id curr)) { $column_data{$_} = "<td>$ref->{$_}</td>" }

        $column_data{accno} =
qq|<td><a href=gl.pl?path=$form->{path}&action=generate_report&accno=$ref->{accno}&fromdate=$form->{transdatefrom}&todate=$form->{transdateto}&sort=transdate&l_transdate=Y&l_reference=Y&l_description=Y&l_source=Y&l_debit=Y&l_credit=Y&l_accno=Y&category=X>$ref->{accno}</a></td>|;

        $column_data{name} =
qq|<td>$ref->{meta_number}</td><td><a href=$form->{vc}.pl?path=$form->{path}&action=edit&entity_id=$ref->{entity_id}&meta_number=$ref->{meta_number}&db=$form->{vc}&callback=$callback>$ref->{name}</a></td>|;

        if ( $ref->{id} != $sameid or $form->{summary}) {
            $j++;
            $j %= 2;
        }

        print "
        <tr class=listrow$j>
";

        for (@column_index) { print "\n$column_data{$_}" }

        print qq|
        </tr>
|;

        $sameid = $ref->{id};

    }

    if ( $form->{l_subtotal} eq 'Y' ) {
        &subtotal;
        $sameitem = $ref->{ $form->{sort} };
    }

    # print totals
    print qq|
        <tr class=listtotal>
        <td>&nbsp</td>|;
    my $total_data;
    for (@column_index){ $total_data->{$_} = "&nbsp;"; }
    $total_data->{due} = $form->format_amount(\%myconfig, $total_due, $LedgerSMB::Sysconfig::decimal_places);
    $total_data->{netamount} = $form->format_amount(\%myconfig, $totalnetamount, $LedgerSMB::Sysconfig::decimal_places);
    $total_data->{amount} = $form->format_amount(\%myconfig, $totalamount, $LedgerSMB::Sysconfig::decimal_places);
    $total_data->{paid} = $form->format_amount(\%myconfig, $totalpaid, $LedgerSMB::Sysconfig::decimal_places);
    $total_data->{debit} = $form->format_amount(\%myconfig, $totaldebit, $LedgerSMB::Sysconfig::decimal_places);
    $total_data->{credit} = $form->format_amount(\%myconfig, $totalcredit, $LedgerSMB::Sysconfig::decimal_places);
    for (@column_index){
        print "<td>$total_data->{$_}</td>";
    }
    print qq|
        </tr>
|;

    for (@column_index) { $column_data{$_} = "<td>&nbsp;</td>" }
    # See setting of $column_header{name} - it has two columns
    $column_data{name} = "<td>&nbsp;</td><td>&nbsp;</td>";

    $column_data{netamount} =
        "<th class=listtotal align=right>"
      . $form->format_amount( \%myconfig, $totalnetamount, 2, "&nbsp;" )
      . "</th>";
    $column_data{tax} = "<th class=listtotal align=right>"
      . $form->format_amount( \%myconfig, $totalamount - $totalnetamount,
        2, "&nbsp;" )
      . "</th>";
    $column_data{amount} =
      "<th class=listtotal align=right>"
      . $form->format_amount( \%myconfig, $totalamount, 2, "&nbsp;" ) . "</th>";
    $column_data{paid} =
      "<th class=listtotal align=right>"
      . $form->format_amount( \%myconfig, $totalpaid, 2, "&nbsp;" ) . "</th>";
    $column_data{due} =
      "<th class=listtotal align=right>"
      . $form->format_amount( \%myconfig, $totalamount - $totalpaid, 2,
        "&nbsp;" )
      . "</th>";
    $column_data{debit} =
      "<th class=listtotal align=right>"
      . $form->format_amount( \%myconfig, $totaldebit, 2, "&nbsp;" ) . "</th>";
    $column_data{credit} =
      "<th class=listtotal align=right>"
      . $form->format_amount( \%myconfig, $totalcredit, 2, "&nbsp;" ) . "</th>";

    if ( $form->{l_curr} && $form->{sort} eq 'curr' && $form->{l_subtotal} ) {
        $column_data{fx_netamount} =
            "<th class=listtotal align=right>"
          . $form->format_amount( \%myconfig, $totalfxnetamount, 2, "&nbsp;" )
          . "</th>";
        $column_data{fx_tax} = "<th class=listtotal align=right>"
          . $form->format_amount( \%myconfig,
            $totalfxamount - $totalfxnetamount,
            2, "&nbsp;" )
          . "</th>";
        $column_data{fx_amount} =
            "<th class=listtotal align=right>"
          . $form->format_amount( \%myconfig, $totalfxamount, 2, "&nbsp;" )
          . "</th>";
        $column_data{fx_paid} =
            "<th class=listtotal align=right>"
          . $form->format_amount( \%myconfig, $totalfxpaid, 2, "&nbsp;" )
          . "</th>";
        $column_data{fx_due} = "<th class=listtotal align=right>"
          . $form->format_amount( \%myconfig, $totalfxamount - $totalfxpaid,
            2, "&nbsp;" )
          . "</th>";
    }

    #for (@column_index) { print STDERR qq|______ $_ => $column_data{$_} ______________|; print "\n$column_data{$_}" }

    if ( $myconfig{acs} !~ /$form->{ARAP}--$form->{ARAP}/ ) {
        $i = 1;
        if ( $form->{ARAP} eq 'AR' ) {
            $button{'AR--Add Transaction'}{code} =
qq|<a href="ar.pl?action=add">[|
              . $locale->text('AR Transaction')
              . qq|]</a> |;
            $button{'AR--Add Transaction'}{order} = $i++;
            $button{'AR--Sales Invoice'}{code} =
qq|<a href="is.pl?action=add">[|
              . $locale->text('Sales Invoice')
              . qq|]</a> |;
            $button{'AR--Sales Invoice'}{order} = $i++;
        }
        else {
            $button{'AP--Add Transaction'}{code} =
qq|<a href="ap.pl?action=add">[|
              . $locale->text('AP Transaction')
              . qq|]</a> |;
            $button{'AP--Add Transaction'}{order} = $i++;
            $button{'AP--Vendor Invoice'}{code} =
qq|<a href="ir.pl?action=add">[|
              . $locale->text('Vendor Invoice')
              . qq|]</a> |;
            $button{'AP--Vendor Invoice'}{order} = $i++;
        }

        foreach $item ( split /;/, $myconfig{acs} ) {
            delete $button{$item};
        }
    }

    print qq|
	</tr>
      </table>
    </td>
  </tr>
  <tr>
    <td><hr size=3 noshade></td>
  </tr>
</table>

<br>
<form method=post action=$form->{script}>
|;

    $form->hide_form(
        "callback",    "path", "login", "sessionid",
    );

    if ( !$form->{till} ) {
        foreach $item ( sort { $a->{order} <=> $b->{order} } %button ) {
          
            print $item->{code};
        }
    }

    if ( $form->{lynx} ) {
        require "bin/menu.pl";
        &menubar;
    }

    print qq|
</form>

</body>
</html>
|;

}

sub subtotal {

    for (@column_index) { $column_data{$_} = "<td test=$_>&nbsp;</td>" }

    $column_data{tax} = "<th class=listsubtotal align=right>"
      . $form->format_amount( \%myconfig, $subtotalamount - $subtotalnetamount,
        2, "&nbsp;" )
      . "</th>";
    $column_data{amount} =
        "<th class=listsubtotal align=right>"
      . $form->format_amount( \%myconfig, $subtotalamount, 2, "&nbsp;" )
      . "</th>";
    $column_data{paid} =
        "<th class=listsubtotal align=right>"
      . $form->format_amount( \%myconfig, $subtotalpaid, 2, "&nbsp;" )
      . "</th>";
    $column_data{due} = "<th class=listsubtotal align=right>"
      . $form->format_amount( \%myconfig, $subtotalamount - $subtotalpaid,
        2, "&nbsp;" )
      . "</th>";
    $column_data{debit} =
        "<th class=listsubtotal align=right>"
      . $form->format_amount( \%myconfig, $subtotaldebit, 2, "&nbsp;" )
      . "</th>";
    $column_data{credit} =
        "<th class=listsubtotal align=right>"
      . $form->format_amount( \%myconfig, $subtotalcredit, 2, "&nbsp;" )
      . "</th>";

    if ( $form->{l_curr} && $form->{sort} eq 'curr' && $form->{l_subtotal} ) {
        $column_data{fx_tax} = "<th class=listsubtotal align=right>"
          . $form->format_amount( \%myconfig,
            $subtotalfxamount - $subtotalfxnetamount,
            2, "&nbsp;" )
          . "</th>";
        $column_data{fx_amount} =
            "<th class=listsubtotal align=right>"
          . $form->format_amount( \%myconfig, $subtotalfxamount, 2, "&nbsp;" )
          . "</th>";
        $column_data{fx_paid} =
            "<th class=listsubtotal align=right>"
          . $form->format_amount( \%myconfig, $subtotalfxpaid, 2, "&nbsp;" )
          . "</th>";
        $column_data{fx_due} = "<th class=listsubtotal align=right>"
          . $form->format_amount( \%myconfig,
            $subtotalfxmount - $subtotalfxpaid,
            2, "&nbsp;" )
          . "</th>";
    }

    $subtotalnetamount = 0;
    $subtotalamount    = 0;
    $subtotalpaid      = 0;
    $subtotaldebit     = 0;
    $subtotalcredit    = 0;

    $subtotalfxnetamount = 0;
    $subtotalfxamount    = 0;
    $subtotalfxpaid      = 0;

    print "<tr class=listsubtotal>";

    for (@column_index) { print "\n$column_data{$_}" }

    print "
</tr>
";

}

