/*
 *  Copyright 1994-2020 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include "plugins.h"

/* Number of plugins to skip when using page up/down */
#define SKIP 10


void
Plugins_command(Plugins_t *plugins, const enum Command cmd)
{
  switch (cmd) {
  case CMD_PLG_NEXT:
#ifdef DEBUG_COMMANDS
    printf(">>> CMD_PLG_NEXT\n");
#endif
    Plugins_next();
    break;

  case CMD_PLG_PREVIOUS:
#ifdef DEBUG_COMMANDS
    printf(">>> CMD_PLG_PREVIOUS\n");
#endif
    Plugins_prev();
    break;

#if 0
  case CMD_PLG_RELOAD_SELECTED:
#ifdef DEBUG_COMMANDS
    printf(">>> CMD_PLG_RELOAD_SELECTED\n");
#endif
    Plugins_reload_selected(plugins);
    break;
#endif

  case CMD_PLG_SCROLL_DOWN:
#ifdef DEBUG_COMMANDS
    printf(">>> CMD_PLG_SCROLL_DOWN\n");
#endif
    Plugins_next_n(SKIP);
    break;

  case CMD_PLG_SCROLL_UP:
#ifdef DEBUG_COMMANDS
    printf(">>> CMD_PLG_SCROLL_UP\n");
#endif
    Plugins_prev_n(SKIP);
    break;

  default:
    xerror("Unhandled plugins command %d\n", cmd);
    break;
  }
}
