/*
 *  Copyright 1994-2020 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include "commands_key.h"

/*
 * Automagically generated from commands.c.in
 * DO NOT EDIT !!!
 */

void
on_key(Context_t *ctx, const BKey_t *k)
{

  /* =============== Application =============== */

  /* [Alt-Shift-r] - Random 3D rotations */
  if (BALTSHIFT(k, SDLK_r)) {
    Context_process_command(ctx, CMD_APP_RANDOMIZE_3D_ROTATIONS);
    return;
  }

  /* [Alt-b] - Next 3D boundary */
  if (BALT(k, SDLK_b)) {
    Context_process_command(ctx, CMD_APP_NEXT_3D_BOUNDARY);
    return;
  }

  /* [Alt-r] - Toggle 3D rotations */
  if (BALT(k, SDLK_r)) {
    Context_process_command(ctx, CMD_APP_TOGGLE_3D_ROTATIONS);
    return;
  }

  /* [Alt-c] - Display current colormap */
  if (BALT(k, SDLK_c)) {
    Context_process_command(ctx, CMD_APP_DISPLAY_COLORMAP);
    return;
  }

  /* [Ctrl-f] - Toggle full-screen on/off */
  if (BCTRL(k, SDLK_f)) {
    Context_process_command(ctx, CMD_APP_SWITCH_FULLSCREEN);
    return;
  }

  /* [Alt-m] - Show/hide mouse cursor */
  if (BALT(k, SDLK_m)) {
    Context_process_command(ctx, CMD_APP_SWITCH_CURSOR);
    return;
  }

  /* [Shift-q] - Quit */
  if (BSHIFT(k, SDLK_q)) {
    Context_process_command(ctx, CMD_APP_QUIT);
    return;
  }

  /* [Shift-x] - Save the current sequence then quit */
  if (BSHIFT(k, SDLK_x)) {
    Context_process_command(ctx, CMD_APP_SAVE_QUIT);
    return;
  }

  /* [Shift-n] - Fill current frame with random pixels */
  if (BSHIFT(k, SDLK_n)) {
    Context_process_command(ctx, CMD_APP_RANDOMIZE_SCREEN);
    return;
  }

  /* [n] - Clear the current frame */
  if (BKEY(k, SDLK_n)) {
    Context_process_command(ctx, CMD_APP_CLEAR_SCREEN);
    return;
  }

  /* [ESCAPE] - Turn off all auto changes */
  if (BKEY(k, SDLK_ESCAPE)) {
    Context_process_command(ctx, CMD_APP_STOP_AUTO_MODES);
    return;
  }

  /* [RETURN] - Toggle selected plugin on/off */
  if (BKEY(k, SDLK_RETURN)) {
    Context_process_command(ctx, CMD_APP_TOGGLE_SELECTED_PLUGIN);
    return;
  }

  /* [Shift-LEFT] - Use previous sequence */
  if (BSHIFT(k, SDLK_LEFT)) {
    Context_process_command(ctx, CMD_APP_PREVIOUS_SEQUENCE);
    return;
  }

  /* [Shift-RIGHT] - Use next sequence */
  if (BSHIFT(k, SDLK_RIGHT)) {
    Context_process_command(ctx, CMD_APP_NEXT_SEQUENCE);
    return;
  }

  /* [Shift-PRINTSCREEN] - Take a screenshot */
  if (BSHIFT(k, SDLK_PRINTSCREEN)) {
    Context_process_command(ctx, CMD_APP_SCREENSHOT);
    return;
  }

  /* [Ctrl-BACKSPACE] - Make a sequence from system schemes */
  if (BCTRL(k, SDLK_BACKSPACE)) {
    Context_process_command(ctx, CMD_APP_RANDOM_SCHEME);
    return;
  }

  /* [BACKSPACE] - Select a random user sequence */
  if (BKEY(k, SDLK_BACKSPACE)) {
    Context_process_command(ctx, CMD_APP_RANDOM_SEQUENCE);
    return;
  }

  /* [m] - Next random mode */
  if (BKEY(k, SDLK_m)) {
    Context_process_command(ctx, CMD_APP_NEXT_RANDOM_MODE);
    return;
  }

  /* [Shift-m] - Previous random mode */
  if (BSHIFT(k, SDLK_m)) {
    Context_process_command(ctx, CMD_APP_PREVIOUS_RANDOM_MODE);
    return;
  }

  /* [Ctrl-t] - Auto colormaps on/off */
  if (BCTRL(k, SDLK_t)) {
    Context_process_command(ctx, CMD_APP_TOGGLE_AUTO_COLORMAPS);
    return;
  }

  /* [Ctrl-i] - Auto images on/off */
  if (BCTRL(k, SDLK_i)) {
    Context_process_command(ctx, CMD_APP_TOGGLE_AUTO_IMAGES);
    return;
  }

  /* [Ctrl-p] - Use the most recent sequence */
  if (BCTRL(k, SDLK_p)) {
    Context_process_command(ctx, CMD_APP_LATEST_SEQUENCE);
    return;
  }

  /* [SPACE] - Bypass webcams on/off */
  if (BKEY(k, SDLK_SPACE)) {
    Context_process_command(ctx, CMD_APP_SWITCH_BYPASS);
    return;
  }

  /* [Ctrl-SPACE] - Set webcam reference image */
  if (BCTRL(k, SDLK_SPACE)) {
    Context_process_command(ctx, CMD_APP_SET_WEBCAM_REFERENCE);
    return;
  }

  /* [TAB] - Select next webcam */
  if (BKEY(k, SDLK_TAB)) {
    Context_process_command(ctx, CMD_APP_NEXT_WEBCAM);
    return;
  }

  /* [Ctrl-l] - Lock selected plugin */
  if (BCTRL(k, SDLK_l)) {
    Context_process_command(ctx, CMD_APP_LOCK_SELECTED_PLUGIN);
    return;
  }

  /* [Ctrl-TAB] - Freeze input on/off */
  if (BCTRL(k, SDLK_TAB)) {
    Context_process_command(ctx, CMD_APP_FREEZE_INPUT);
    return;
  }

  /* [Shift-v] - Scale volume up */
  if (BSHIFT(k, SDLK_v)) {
    Context_process_command(ctx, CMD_APP_VOLUME_SCALE_UP);
    return;
  }

  /* [Alt-v] - Scale volume down */
  if (BALT(k, SDLK_v)) {
    Context_process_command(ctx, CMD_APP_VOLUME_SCALE_DOWN);
    return;
  }

  /* =============== Plugins =============== */

  /* [UP] - Select previous plugin */
  if (BKEY(k, SDLK_UP)) {
    Context_process_command(ctx, CMD_PLG_PREVIOUS);
    return;
  }

  /* [DOWN] - Select next plugin */
  if (BKEY(k, SDLK_DOWN)) {
    Context_process_command(ctx, CMD_PLG_NEXT);
    return;
  }

  /* [PAGEUP] - Scroll up in the plugins list */
  if (BKEY(k, SDLK_PAGEUP)) {
    Context_process_command(ctx, CMD_PLG_SCROLL_UP);
    return;
  }

  /* [PAGEDOWN] - Scroll down in the plugins list */
  if (BKEY(k, SDLK_PAGEDOWN)) {
    Context_process_command(ctx, CMD_PLG_SCROLL_DOWN);
    return;
  }

  /* =============== Sequences =============== */

  /* [Shift-z] - Reset the current sequence */
  if (BSHIFT(k, SDLK_z)) {
    Context_process_command(ctx, CMD_SEQ_RESET);
    return;
  }

  /* [Shift-l] - Toggle selected plugin as a lens on/off */
  if (BSHIFT(k, SDLK_l)) {
    Context_process_command(ctx, CMD_SEQ_TOGGLE_LENS);
    return;
  }

  /* [Shift-UP] - Select previous plugin in the sequence */
  if (BSHIFT(k, SDLK_UP)) {
    Context_process_command(ctx, CMD_SEQ_SELECT_PREVIOUS);
    return;
  }

  /* [Shift-DOWN] - Select next plugin in the sequence */
  if (BSHIFT(k, SDLK_DOWN)) {
    Context_process_command(ctx, CMD_SEQ_SELECT_NEXT);
    return;
  }

  /* [Ctrl-UP] - Move selected plugin up in the sequence */
  if (BCTRL(k, SDLK_UP)) {
    Context_process_command(ctx, CMD_SEQ_MOVE_UP);
    return;
  }

  /* [Ctrl-DOWN] - Move selected plugin down in the sequence */
  if (BCTRL(k, SDLK_DOWN)) {
    Context_process_command(ctx, CMD_SEQ_MOVE_DOWN);
    return;
  }

  /* [Alt-y] - Select default layer mode for the current plugin */
  if (BALT(k, SDLK_y)) {
    Context_process_command(ctx, CMD_SEQ_LAYER_DEFAULT);
    return;
  }

  /* [Shift-y] - Select next layer mode */
  if (BSHIFT(k, SDLK_y)) {
    Context_process_command(ctx, CMD_SEQ_LAYER_NEXT);
    return;
  }

  /* [Ctrl-s] - Save current sequence as new (full) */
  if (BCTRL(k, SDLK_s)) {
    Context_process_command(ctx, CMD_SEQ_SAVE_FULL);
    return;
  }

  /* [Ctrl-u] - Update current full sequence */
  if (BCTRL(k, SDLK_u)) {
    Context_process_command(ctx, CMD_SEQ_UPDATE_FULL);
    return;
  }

  /* [Ctrl-Shift-s] - Save current sequence as new (bare) */
  if (BCTRLSHIFT(k, SDLK_s)) {
    Context_process_command(ctx, CMD_SEQ_SAVE_BARE);
    return;
  }

  /* [Ctrl-Shift-u] - Update current bare sequence */
  if (BCTRLSHIFT(k, SDLK_u)) {
    Context_process_command(ctx, CMD_SEQ_UPDATE_BARE);
    return;
  }

  /* [Alt-UP] - Select previous plugin parameter */
  if (BALT(k, SDLK_UP)) {
    Context_process_command(ctx, CMD_SEQ_PARAM_PREVIOUS);
    return;
  }

  /* [Alt-DOWN] - Select next plugin parameter */
  if (BALT(k, SDLK_DOWN)) {
    Context_process_command(ctx, CMD_SEQ_PARAM_NEXT);
    return;
  }

  /* [Alt-LEFT] - Decrease plugin parameter value */
  if (BALT(k, SDLK_LEFT)) {
    Context_process_command(ctx, CMD_SEQ_PARAM_DEC);
    return;
  }

  /* [Alt-RIGHT] - Increase plugin parameter value */
  if (BALT(k, SDLK_RIGHT)) {
    Context_process_command(ctx, CMD_SEQ_PARAM_INC);
    return;
  }

  /* [Alt-Shift-LEFT] - Decrease plugin parameter value quickly */
  if (BALTSHIFT(k, SDLK_LEFT)) {
    Context_process_command(ctx, CMD_SEQ_PARAM_DEC_FAST);
    return;
  }

  /* [Alt-Shift-RIGHT] - Increase plugin parameter value quickly */
  if (BALTSHIFT(k, SDLK_RIGHT)) {
    Context_process_command(ctx, CMD_SEQ_PARAM_INC_FAST);
    return;
  }

  /* =============== Colormaps =============== */

  /* [e] - Select previous colormap */
  if (BKEY(k, SDLK_e)) {
    Context_process_command(ctx, CMD_COL_PREVIOUS);
    return;
  }

  /* [r] - Select next colormap */
  if (BKEY(k, SDLK_r)) {
    Context_process_command(ctx, CMD_COL_NEXT);
    return;
  }

  /* [t] - Select random colormap */
  if (BKEY(k, SDLK_t)) {
    Context_process_command(ctx, CMD_COL_RANDOM);
    return;
  }

  /* =============== Colormap =============== */

  /* [Shift-1] - Use colormap in shortcut 1 */
  if (BSHIFT(k, SDLK_1)) {
    Context_process_command(ctx, CMD_COL_USE_SHORTCUT_1);
    return;
  }

  /* [Shift-2] - Use colormap in shortcut 2 */
  if (BSHIFT(k, SDLK_2)) {
    Context_process_command(ctx, CMD_COL_USE_SHORTCUT_2);
    return;
  }

  /* [Shift-3] - Use colormap in shortcut 3 */
  if (BSHIFT(k, SDLK_3)) {
    Context_process_command(ctx, CMD_COL_USE_SHORTCUT_3);
    return;
  }

  /* [Shift-4] - Use colormap in shortcut 4 */
  if (BSHIFT(k, SDLK_4)) {
    Context_process_command(ctx, CMD_COL_USE_SHORTCUT_4);
    return;
  }

  /* [Shift-5] - Use colormap in shortcut 5 */
  if (BSHIFT(k, SDLK_5)) {
    Context_process_command(ctx, CMD_COL_USE_SHORTCUT_5);
    return;
  }

  /* [Shift-6] - Use colormap in shortcut 6 */
  if (BSHIFT(k, SDLK_6)) {
    Context_process_command(ctx, CMD_COL_USE_SHORTCUT_6);
    return;
  }

  /* [Shift-7] - Use colormap in shortcut 7 */
  if (BSHIFT(k, SDLK_7)) {
    Context_process_command(ctx, CMD_COL_USE_SHORTCUT_7);
    return;
  }

  /* [Shift-8] - Use colormap in shortcut 8 */
  if (BSHIFT(k, SDLK_8)) {
    Context_process_command(ctx, CMD_COL_USE_SHORTCUT_8);
    return;
  }

  /* [Shift-9] - Use colormap in shortcut 9 */
  if (BSHIFT(k, SDLK_9)) {
    Context_process_command(ctx, CMD_COL_USE_SHORTCUT_9);
    return;
  }

  /* [Shift-0] - Use colormap in shortcut 10 */
  if (BSHIFT(k, SDLK_0)) {
    Context_process_command(ctx, CMD_COL_USE_SHORTCUT_10);
    return;
  }

  /* [Ctrl-Shift-1] - Assign current colormap to shortcut 1 */
  if (BCTRLSHIFT(k, SDLK_1)) {
    Context_process_command(ctx, CMD_COL_STORE_SHORTCUT_1);
    return;
  }

  /* [Ctrl-Shift-2] - Assign current colormap to shortcut 2 */
  if (BCTRLSHIFT(k, SDLK_2)) {
    Context_process_command(ctx, CMD_COL_STORE_SHORTCUT_2);
    return;
  }

  /* [Ctrl-Shift-3] - Assign current colormap to shortcut 3 */
  if (BCTRLSHIFT(k, SDLK_3)) {
    Context_process_command(ctx, CMD_COL_STORE_SHORTCUT_3);
    return;
  }

  /* [Ctrl-Shift-4] - Assign current colormap to shortcut 4 */
  if (BCTRLSHIFT(k, SDLK_4)) {
    Context_process_command(ctx, CMD_COL_STORE_SHORTCUT_4);
    return;
  }

  /* [Ctrl-Shift-5] - Assign current colormap to shortcut 5 */
  if (BCTRLSHIFT(k, SDLK_5)) {
    Context_process_command(ctx, CMD_COL_STORE_SHORTCUT_5);
    return;
  }

  /* [Ctrl-Shift-6] - Assign current colormap to shortcut 6 */
  if (BCTRLSHIFT(k, SDLK_6)) {
    Context_process_command(ctx, CMD_COL_STORE_SHORTCUT_6);
    return;
  }

  /* [Ctrl-Shift-7] - Assign current colormap to shortcut 7 */
  if (BCTRLSHIFT(k, SDLK_7)) {
    Context_process_command(ctx, CMD_COL_STORE_SHORTCUT_7);
    return;
  }

  /* [Ctrl-Shift-8] - Assign current colormap to shortcut 8 */
  if (BCTRLSHIFT(k, SDLK_8)) {
    Context_process_command(ctx, CMD_COL_STORE_SHORTCUT_8);
    return;
  }

  /* [Ctrl-Shift-9] - Assign current colormap to shortcut 9 */
  if (BCTRLSHIFT(k, SDLK_9)) {
    Context_process_command(ctx, CMD_COL_STORE_SHORTCUT_9);
    return;
  }

  /* [Ctrl-Shift-0] - Assign current colormap to shortcut 10 */
  if (BCTRLSHIFT(k, SDLK_0)) {
    Context_process_command(ctx, CMD_COL_STORE_SHORTCUT_10);
    return;
  }

  /* =============== Images =============== */

  /* [y] - Select previous image */
  if (BKEY(k, SDLK_y)) {
    Context_process_command(ctx, CMD_IMG_PREVIOUS);
    return;
  }

  /* [u] - Select next image */
  if (BKEY(k, SDLK_u)) {
    Context_process_command(ctx, CMD_IMG_NEXT);
    return;
  }

  /* [i] - Select random image */
  if (BKEY(k, SDLK_i)) {
    Context_process_command(ctx, CMD_IMG_RANDOM);
    return;
  }

  /* =============== Image =============== */

  /* [Alt-1] - Use image in shortcut 1 */
  if (BALT(k, SDLK_1)) {
    Context_process_command(ctx, CMD_IMG_USE_SHORTCUT_1);
    return;
  }

  /* [Alt-2] - Use image in shortcut 2 */
  if (BALT(k, SDLK_2)) {
    Context_process_command(ctx, CMD_IMG_USE_SHORTCUT_2);
    return;
  }

  /* [Alt-3] - Use image in shortcut 3 */
  if (BALT(k, SDLK_3)) {
    Context_process_command(ctx, CMD_IMG_USE_SHORTCUT_3);
    return;
  }

  /* [Alt-4] - Use image in shortcut 4 */
  if (BALT(k, SDLK_4)) {
    Context_process_command(ctx, CMD_IMG_USE_SHORTCUT_4);
    return;
  }

  /* [Alt-5] - Use image in shortcut 5 */
  if (BALT(k, SDLK_5)) {
    Context_process_command(ctx, CMD_IMG_USE_SHORTCUT_5);
    return;
  }

  /* [Alt-6] - Use image in shortcut 6 */
  if (BALT(k, SDLK_6)) {
    Context_process_command(ctx, CMD_IMG_USE_SHORTCUT_6);
    return;
  }

  /* [Alt-7] - Use image in shortcut 7 */
  if (BALT(k, SDLK_7)) {
    Context_process_command(ctx, CMD_IMG_USE_SHORTCUT_7);
    return;
  }

  /* [Alt-8] - Use image in shortcut 8 */
  if (BALT(k, SDLK_8)) {
    Context_process_command(ctx, CMD_IMG_USE_SHORTCUT_8);
    return;
  }

  /* [Alt-9] - Use image in shortcut 9 */
  if (BALT(k, SDLK_9)) {
    Context_process_command(ctx, CMD_IMG_USE_SHORTCUT_9);
    return;
  }

  /* [Alt-0] - Use image in shortcut 10 */
  if (BALT(k, SDLK_0)) {
    Context_process_command(ctx, CMD_IMG_USE_SHORTCUT_10);
    return;
  }

  /* [Ctrl-Alt-1] - Assign current image to shortcut 1 */
  if (BCTRLALT(k, SDLK_1)) {
    Context_process_command(ctx, CMD_IMG_STORE_SHORTCUT_1);
    return;
  }

  /* [Ctrl-Alt-2] - Assign current image to shortcut 2 */
  if (BCTRLALT(k, SDLK_2)) {
    Context_process_command(ctx, CMD_IMG_STORE_SHORTCUT_2);
    return;
  }

  /* [Ctrl-Alt-3] - Assign current image to shortcut 3 */
  if (BCTRLALT(k, SDLK_3)) {
    Context_process_command(ctx, CMD_IMG_STORE_SHORTCUT_3);
    return;
  }

  /* [Ctrl-Alt-4] - Assign current image to shortcut 4 */
  if (BCTRLALT(k, SDLK_4)) {
    Context_process_command(ctx, CMD_IMG_STORE_SHORTCUT_4);
    return;
  }

  /* [Ctrl-Alt-5] - Assign current image to shortcut 5 */
  if (BCTRLALT(k, SDLK_5)) {
    Context_process_command(ctx, CMD_IMG_STORE_SHORTCUT_5);
    return;
  }

  /* [Ctrl-Alt-6] - Assign current image to shortcut 6 */
  if (BCTRLALT(k, SDLK_6)) {
    Context_process_command(ctx, CMD_IMG_STORE_SHORTCUT_6);
    return;
  }

  /* [Ctrl-Alt-7] - Assign current image to shortcut 7 */
  if (BCTRLALT(k, SDLK_7)) {
    Context_process_command(ctx, CMD_IMG_STORE_SHORTCUT_7);
    return;
  }

  /* [Ctrl-Alt-8] - Assign current image to shortcut 8 */
  if (BCTRLALT(k, SDLK_8)) {
    Context_process_command(ctx, CMD_IMG_STORE_SHORTCUT_8);
    return;
  }

  /* [Ctrl-Alt-9] - Assign current image to shortcut 9 */
  if (BCTRLALT(k, SDLK_9)) {
    Context_process_command(ctx, CMD_IMG_STORE_SHORTCUT_9);
    return;
  }

  /* [Ctrl-Alt-0] - Assign current image to shortcut 10 */
  if (BCTRLALT(k, SDLK_0)) {
    Context_process_command(ctx, CMD_IMG_STORE_SHORTCUT_10);
    return;
  }

  /* =============== Banks =============== */

  /* [Ctrl-Shift-F1] - Clear bank 1 */
  if (BCTRLSHIFT(k, SDLK_F1)) {
    Context_process_command(ctx, CMD_APP_CLEAR_BANK_1);
    return;
  }

  /* [Ctrl-Shift-F2] - Clear bank 2 */
  if (BCTRLSHIFT(k, SDLK_F2)) {
    Context_process_command(ctx, CMD_APP_CLEAR_BANK_2);
    return;
  }

  /* [Ctrl-Shift-F3] - Clear bank 3 */
  if (BCTRLSHIFT(k, SDLK_F3)) {
    Context_process_command(ctx, CMD_APP_CLEAR_BANK_3);
    return;
  }

  /* [Ctrl-Shift-F4] - Clear bank 4 */
  if (BCTRLSHIFT(k, SDLK_F4)) {
    Context_process_command(ctx, CMD_APP_CLEAR_BANK_4);
    return;
  }

  /* [Ctrl-Shift-F5] - Clear bank 5 */
  if (BCTRLSHIFT(k, SDLK_F5)) {
    Context_process_command(ctx, CMD_APP_CLEAR_BANK_5);
    return;
  }

  /* [Ctrl-Shift-F6] - Clear bank 6 */
  if (BCTRLSHIFT(k, SDLK_F6)) {
    Context_process_command(ctx, CMD_APP_CLEAR_BANK_6);
    return;
  }

  /* [Ctrl-Shift-F7] - Clear bank 7 */
  if (BCTRLSHIFT(k, SDLK_F7)) {
    Context_process_command(ctx, CMD_APP_CLEAR_BANK_7);
    return;
  }

  /* [Ctrl-Shift-F8] - Clear bank 8 */
  if (BCTRLSHIFT(k, SDLK_F8)) {
    Context_process_command(ctx, CMD_APP_CLEAR_BANK_8);
    return;
  }

  /* [Ctrl-Shift-F9] - Clear bank 9 */
  if (BCTRLSHIFT(k, SDLK_F9)) {
    Context_process_command(ctx, CMD_APP_CLEAR_BANK_9);
    return;
  }

  /* [Ctrl-Shift-F10] - Clear bank 10 */
  if (BCTRLSHIFT(k, SDLK_F10)) {
    Context_process_command(ctx, CMD_APP_CLEAR_BANK_10);
    return;
  }

  /* [Ctrl-Shift-F11] - Clear bank 11 */
  if (BCTRLSHIFT(k, SDLK_F11)) {
    Context_process_command(ctx, CMD_APP_CLEAR_BANK_11);
    return;
  }

  /* [Ctrl-Shift-F12] - Clear bank 12 */
  if (BCTRLSHIFT(k, SDLK_F12)) {
    Context_process_command(ctx, CMD_APP_CLEAR_BANK_12);
    return;
  }

  /* [Shift-F1] - Assign current sequence to bank 1 */
  if (BSHIFT(k, SDLK_F1)) {
    Context_process_command(ctx, CMD_APP_STORE_BANK_1);
    return;
  }

  /* [Shift-F2] - Assign current sequence to bank 2 */
  if (BSHIFT(k, SDLK_F2)) {
    Context_process_command(ctx, CMD_APP_STORE_BANK_2);
    return;
  }

  /* [Shift-F3] - Assign current sequence to bank 3 */
  if (BSHIFT(k, SDLK_F3)) {
    Context_process_command(ctx, CMD_APP_STORE_BANK_3);
    return;
  }

  /* [Shift-F4] - Assign current sequence to bank 4 */
  if (BSHIFT(k, SDLK_F4)) {
    Context_process_command(ctx, CMD_APP_STORE_BANK_4);
    return;
  }

  /* [Shift-F5] - Assign current sequence to bank 5 */
  if (BSHIFT(k, SDLK_F5)) {
    Context_process_command(ctx, CMD_APP_STORE_BANK_5);
    return;
  }

  /* [Shift-F6] - Assign current sequence to bank 6 */
  if (BSHIFT(k, SDLK_F6)) {
    Context_process_command(ctx, CMD_APP_STORE_BANK_6);
    return;
  }

  /* [Shift-F7] - Assign current sequence to bank 7 */
  if (BSHIFT(k, SDLK_F7)) {
    Context_process_command(ctx, CMD_APP_STORE_BANK_7);
    return;
  }

  /* [Shift-F8] - Assign current sequence to bank 8 */
  if (BSHIFT(k, SDLK_F8)) {
    Context_process_command(ctx, CMD_APP_STORE_BANK_8);
    return;
  }

  /* [Shift-F9] - Assign current sequence to bank 9 */
  if (BSHIFT(k, SDLK_F9)) {
    Context_process_command(ctx, CMD_APP_STORE_BANK_9);
    return;
  }

  /* [Shift-F10] - Assign current sequence to bank 10 */
  if (BSHIFT(k, SDLK_F10)) {
    Context_process_command(ctx, CMD_APP_STORE_BANK_10);
    return;
  }

  /* [Shift-F11] - Assign current sequence to bank 11 */
  if (BSHIFT(k, SDLK_F11)) {
    Context_process_command(ctx, CMD_APP_STORE_BANK_11);
    return;
  }

  /* [Shift-F12] - Assign current sequence to bank 12 */
  if (BSHIFT(k, SDLK_F12)) {
    Context_process_command(ctx, CMD_APP_STORE_BANK_12);
    return;
  }

  /* [Alt-Shift-F1] - Use sequence in bank 1 */
  if (BALTSHIFT(k, SDLK_F1)) {
    Context_process_command(ctx, CMD_APP_USE_BANK_1);
    return;
  }

  /* [Alt-Shift-F2] - Use sequence in bank 2 */
  if (BALTSHIFT(k, SDLK_F2)) {
    Context_process_command(ctx, CMD_APP_USE_BANK_2);
    return;
  }

  /* [Alt-Shift-F3] - Use sequence in bank 3 */
  if (BALTSHIFT(k, SDLK_F3)) {
    Context_process_command(ctx, CMD_APP_USE_BANK_3);
    return;
  }

  /* [Alt-Shift-F4] - Use sequence in bank 4 */
  if (BALTSHIFT(k, SDLK_F4)) {
    Context_process_command(ctx, CMD_APP_USE_BANK_4);
    return;
  }

  /* [Alt-Shift-F5] - Use sequence in bank 5 */
  if (BALTSHIFT(k, SDLK_F5)) {
    Context_process_command(ctx, CMD_APP_USE_BANK_5);
    return;
  }

  /* [Alt-Shift-F6] - Use sequence in bank 6 */
  if (BALTSHIFT(k, SDLK_F6)) {
    Context_process_command(ctx, CMD_APP_USE_BANK_6);
    return;
  }

  /* [Alt-Shift-F7] - Use sequence in bank 7 */
  if (BALTSHIFT(k, SDLK_F7)) {
    Context_process_command(ctx, CMD_APP_USE_BANK_7);
    return;
  }

  /* [Alt-Shift-F8] - Use sequence in bank 8 */
  if (BALTSHIFT(k, SDLK_F8)) {
    Context_process_command(ctx, CMD_APP_USE_BANK_8);
    return;
  }

  /* [Alt-Shift-F9] - Use sequence in bank 9 */
  if (BALTSHIFT(k, SDLK_F9)) {
    Context_process_command(ctx, CMD_APP_USE_BANK_9);
    return;
  }

  /* [Alt-Shift-F10] - Use sequence in bank 10 */
  if (BALTSHIFT(k, SDLK_F10)) {
    Context_process_command(ctx, CMD_APP_USE_BANK_10);
    return;
  }

  /* [Alt-Shift-F11] - Use sequence in bank 11 */
  if (BALTSHIFT(k, SDLK_F11)) {
    Context_process_command(ctx, CMD_APP_USE_BANK_11);
    return;
  }

  /* [Alt-Shift-F12] - Use sequence in bank 12 */
  if (BALTSHIFT(k, SDLK_F12)) {
    Context_process_command(ctx, CMD_APP_USE_BANK_12);
    return;
  }

  /* [Ctrl-Alt-Shift-F1] - Use bank set 1 */
  if (BCTRLALTSHIFT(k, SDLK_F1)) {
    Context_process_command(ctx, CMD_APP_USE_BANK_SET_1);
    return;
  }

  /* [Ctrl-Alt-Shift-F2] - Use bank set 2 */
  if (BCTRLALTSHIFT(k, SDLK_F2)) {
    Context_process_command(ctx, CMD_APP_USE_BANK_SET_2);
    return;
  }

  /* [Ctrl-Alt-Shift-F3] - Use bank set 3 */
  if (BCTRLALTSHIFT(k, SDLK_F3)) {
    Context_process_command(ctx, CMD_APP_USE_BANK_SET_3);
    return;
  }

  /* [Ctrl-Alt-Shift-F4] - Use bank set 4 */
  if (BCTRLALTSHIFT(k, SDLK_F4)) {
    Context_process_command(ctx, CMD_APP_USE_BANK_SET_4);
    return;
  }

  /* [Ctrl-Alt-Shift-F5] - Use bank set 5 */
  if (BCTRLALTSHIFT(k, SDLK_F5)) {
    Context_process_command(ctx, CMD_APP_USE_BANK_SET_5);
    return;
  }

  /* [Ctrl-Alt-Shift-F6] - Use bank set 6 */
  if (BCTRLALTSHIFT(k, SDLK_F6)) {
    Context_process_command(ctx, CMD_APP_USE_BANK_SET_6);
    return;
  }

  /* [Ctrl-Alt-Shift-F7] - Use bank set 7 */
  if (BCTRLALTSHIFT(k, SDLK_F7)) {
    Context_process_command(ctx, CMD_APP_USE_BANK_SET_7);
    return;
  }

  /* [Ctrl-Alt-Shift-F8] - Use bank set 8 */
  if (BCTRLALTSHIFT(k, SDLK_F8)) {
    Context_process_command(ctx, CMD_APP_USE_BANK_SET_8);
    return;
  }

  /* [Ctrl-Alt-Shift-F9] - Use bank set 9 */
  if (BCTRLALTSHIFT(k, SDLK_F9)) {
    Context_process_command(ctx, CMD_APP_USE_BANK_SET_9);
    return;
  }

  /* [Ctrl-Alt-Shift-F10] - Use bank set 10 */
  if (BCTRLALTSHIFT(k, SDLK_F10)) {
    Context_process_command(ctx, CMD_APP_USE_BANK_SET_10);
    return;
  }

  /* [Ctrl-Alt-Shift-F11] - Use bank set 11 */
  if (BCTRLALTSHIFT(k, SDLK_F11)) {
    Context_process_command(ctx, CMD_APP_USE_BANK_SET_11);
    return;
  }

  /* [Ctrl-Alt-Shift-F12] - Use bank set 12 */
  if (BCTRLALTSHIFT(k, SDLK_F12)) {
    Context_process_command(ctx, CMD_APP_USE_BANK_SET_12);
    return;
  }
}
