/*
 *  Copyright 1994-2019 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __SPECTRUM_H
#define __SPECTRUM_H


static inline u_short
float_to_ushort(float x, u_short minval, u_short maxval)
{
  u_short n;
  x = floor(x); /* rounded to lower int */
  if (x < minval) {
    n = minval;
  } else if (x > maxval) {
    n = maxval;
  } else {
    n = (ushort)x;
  }
  return n;
}


static inline u_short
float_to_nearest_ushort(float x, u_short minval, u_short maxval)
{
  return float_to_ushort(x + 0.5 /* will be rounded to nearest int */, minval, maxval);
}


#endif /* __SPECTRUM_H */

