/*
 *  Copyright 1994-2018 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __BINIOU_INPUT_H
#define __BINIOU_INPUT_H

#include <fftw3.h>

#include "utils.h"

/* A_STEREO is only used in calls to Input_set() */
enum Channel { A_MONO=0, A_LEFT=1, A_RIGHT=2, A_STEREO };


typedef struct Input_s {
  /* mutex */
  pthread_mutex_t mutex;

  /* FFTW stuff */
  fftw_plan plan_fft[3];
  
  /* input buffer size */
  u_short size;
  /* to get Mytho Random Numbers(c)(r)(tm) */
  u_short roulette;
  /* you can also mute the input  */
  u_char  mute;

  /* Write raw input data here then call Input_set(...) */
  /* the input data, [-1..1] */
  double *data[3];

  /*
   * these should be seen as Read-Only
   */
  /* the input data, [0..1] */
  double *data_u[3];

  /* spectrum info */
  u_short spectrum_size;

  /* used to compute FFT */
  double *out[3];

  double *spectrum[3];
  double *spectrum_norme[3];
  double *spectrum_log[3];
  double *spectrum_log_norme[3];

  double max_spectrum[3];
  double max_spectrum_norme[3];
  double max_spectrum_log[3];
  double max_spectrum_log_norme[3];
} Input_t;


Input_t *Input_new(const u_short);

void Input_delete(Input_t *);
void Input_set(Input_t *, u_char);
/* void Input_reset_max_spectrum(Input_t *); */

/* MRNG stuff */
/* random float [-1.0 .. 1.0] */
float  Input_random_s_u_float(Input_t *);
/* random float [0.0 .. 1.0] */
float  Input_random_u_u_float(Input_t *);
/* random u_char [0 .. 255] */
u_char Input_random_u_char(Input_t *);
/* random float [min .. max] */
float  Input_random_float_range(Input_t *, const float, const float);
/* random short [min .. max] */
short  Input_random_short_range(Input_t *, const short, const short);

float  Input_get_volume(Input_t *);

#endif /* INPUT_H */
