/*
 *  Copyright 1994-2018 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include <libswscale/swscale.h>
#include <SDL/SDL_ttf.h>
#include "biniou.h"


typedef struct {
  SDL_Surface *sc;
  u_char must_lock_screen;
} SDL_state;


SDL_state drv;

#define lock_screen(st)				\
  do {						\
    if (st.must_lock_screen)			\
      SDL_LockSurface(st.sc);			\
  } while(0)

#define unlock_screen(st)			\
  do {						\
    if (st.must_lock_screen)			\
      SDL_UnlockSurface(st.sc);			\
    else					\
      (void)SDL_Flip(st.sc);			\
  } while(0)

