/*
 *  Copyright 1994-2018 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include "context.h"


u_long id = 1329763807;
u_long options = BE_GFX|BEQ_PICTURE|BEQ_BYPASS;
char desc[] = "DiffTV";
u_long mode = OVERLAY;

extern int webcams;

#if 0
// #define PALETTE 1
#ifdef PALETTE
#define MaxColor 120
#endif
#define Decay 15
#define MAGIC_THRESHOLD 50

static Buffer8_t *buffer = NULL, *diff = NULL;
#ifdef PALETTE
static Cmap8_t *palette = NULL;
#endif


/*
 * fastrand - fast fake random number generator
 * Warning: The low-order bits of numbers generated by fastrand()
 *          are bad as random numbers. For example, fastrand()%4
 *          generates 1,2,3,0,1,2,3,0...
 *          You should use high-order bits.
 */
static unsigned int fastrand_val;

static unsigned int
fastrand()
{
  return (fastrand_val = fastrand_val * 1103515245 + 12345);
}

static void
fastsrand(unsigned int seed)
{
  fastrand_val = seed;
}


#ifdef PALETTE
static void
HSItoRGB(double h, double s, double i, int *r, int *g, int *b)
{
  double t, rv, gv, bv;
  
  rv = 1 + s * sin(h - 2 * M_PI / 3);
  gv = 1 + s * sin(h);
  bv = 1 + s * sin(h + 2 * M_PI / 3);
  t = 255.999 * i / 2;
  *r = trunc(rv * t);
  *g = trunc(gv * t);
  *b = trunc(bv * t);
}


static void
make_palette(Cmap8_t *palette)
{
  int i, r, g, b;
  
  for (i = 0; i < MaxColor; i++) {
    HSItoRGB(4.6 - 1.5 * i / MaxColor, (double)i / MaxColor, (double)i / MaxColor, &r, &g, &b);
    palette->colors[i].col.r = r;
    palette->colors[i].col.g = g;
    palette->colors[i].col.b = b;
  }

  for (i = MaxColor; i < 256; i++) {
    if (r < 255) r++;
    if (r < 255) r++;
    if (r < 255) r++;
    if (g < 255) g++;
    if (g < 255) g++;
    if (b < 255) b++;
    if (b < 255) b++;
    palette->colors[i].col.r = r;
    palette->colors[i].col.g = g;
    palette->colors[i].col.b = b;
  }
}
#endif
#endif /* 0liv3 */


void
create(Context_t *ctx)
{
  if (!webcams)
    options |= BEQ_DISABLED;
  /*
  else {
    buffer = Buffer8_new();
    diff = Buffer8_new();
    fastsrand(time(NULL));
  }
  */
}


void
on_switch_on(Context_t *ctx)
{
  ctx->ref_taken[ctx->cam] = 0;
}


void
delete(Context_t *ctx)
{
  /*
  Buffer8_delete(buffer);
  Buffer8_delete(diff);
  */
}


void
run(Context_t *ctx)
{
  Pixel_t *src1, *start, *src2, *dst;

  if (!webcams)
    return;

  dst = start = passive_buffer(ctx)->buffer;

  pthread_mutex_lock(&ctx->cam_mtx[ctx->cam]);
  src1 = ctx->cam_save[ctx->cam][0]->buffer;
  src2 = ctx->cam_ref[ctx->cam]->buffer;
  for (; dst < start+BUFFSIZE*sizeof(Pixel_t); src1++, src2++, dst++)
    *dst = abs(*src1 - *src2);
  pthread_mutex_unlock(&ctx->cam_mtx[ctx->cam]);
}
