/*
 *  Copyright 1994-2011 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include "webcam.h"


u_long id = 1172430309;
u_long options = BE_GFX|BEQ_PICTURE|BEQ_BYPASS;
char desc[] = "Webcam plugin";


void
create(Context_t *ctx)
{
  if ((WIDTH != 640) || (HEIGHT != 480))
    if ((WIDTH != 320) || (HEIGHT != 240))
      if ((WIDTH != 160) || (HEIGHT != 120)) {
	printf("[!] Webcam disabled: only 640x480, 320x240 and 160x120 modes are supported\n");
	options |= BEQ_DISABLED;
	return;
      }

  cap = Buffer8_new();
  pthread_mutex_init(&mtx, NULL);

  parse_options();
  open_device();

  if (!(options & BEQ_DISABLED)) {
    int res = init_device();

    if (!res) {
      if (!(options & BEQ_DISABLED)) {
	enumerate_cids();
	start_capturing();
      }
    } else options |= BEQ_DISABLED;
  }
}


void
destroy(__attribute__ ((unused)) Context_t *ctx)
{
  if (!(options & BEQ_DISABLED)) {
    pthread_join(thr, NULL);
    stop_capturing();
    uninit_device();
    close_device();
    Buffer8_delete(cap);
  }

  free(dev_name);
}


void
run(Context_t *ctx)
{
  static int started = 0;

  if (!(options & BEQ_DISABLED)) {
    if (!started) {
      /* FIXME passer dans le create() */
      pthread_create(&thr, NULL, loop, (void *)ctx);
      started = 1;
    }
    else {
      pthread_mutex_lock(&mtx);
      Buffer8_copy(cap, passive_buffer(ctx));
      pthread_mutex_unlock(&mtx);
    }
  }
}
