/*
 *  Copyright 1994-2011 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __BINIOU_PICTURE_8BITS_H
#define __BINIOU_PICTURE_8BITS_H

#include "buffer_8bits.h"

typedef struct Picture8_s {
  long      id;
  char      *name; 
  char      *dname;
  Buffer8_t *buff;
} Picture8_t;

Picture8_t *Picture8_new(void);
void Picture8_delete(Picture8_t *);
int Picture8_load(Picture8_t *, const long, const char *, const char *);
void Picture8_copy(const Picture8_t *, Picture8_t *);

#endif /* __BINIOU_PICTURE_8BITS_H */
