/*
 *  Copyright 1994-2011 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __WEBCAM_H
#define __WEBCAM_H

#include "context.h"
#if HAVE_LINUX_VIDEODEV2_H
#include <linux/videodev2.h>
#endif

//#define CAP_WIDTH  640
//#define CAP_HEIGHT 480
#define CAP_WIDTH  WIDTH
#define CAP_HEIGHT HEIGHT
//#define CAP_WIDTH  320
//#define CAP_HEIGHT 240
//#define CAP_WIDTH  160
//#define CAP_HEIGHT 120

#define CLEAR(x) memset(&(x), 0, sizeof(x))

typedef enum {
  IO_METHOD_READ,
  IO_METHOD_MMAP,
  IO_METHOD_USERPTR,
} io_method;

struct buffer {
  void *start;
  size_t length;
};


#define DEFAULT_VIDEO_DEVICE "/dev/video0"

/* options */
char *dev_name;
int hflip;

int fd;
static io_method io = IO_METHOD_MMAP;
unsigned int n_buffers;
struct buffer *buffers;


void parse_options();

void open_device();
void init_device();
void enumerate_cids();
void start_capturing();

void loop(Context_t *);

void stop_capturing();
void uninit_device();
void close_device();


static int
xioctl(int fd, int request, void *arg)
{
  int r;

  do
    r = ioctl(fd, request, arg);
  while ((-1 == r) && (EINTR == errno));

  return r;
}

#endif /* __WEBCAM_H */
