/*
 *  Copyright 1994-2011 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include "webcam.h"

/* TODO: disable if WxH != 640x480, 320x240 or 160x120 */

u_long id = 1172430309;
u_long options = BE_GFX|BEQ_PICTURE;
char desc[] = "Webcam plugin";


void
create(__attribute__ ((unused)) Context_t *ctx)
{
  parse_options();
  open_device();

  if (!(options & BEQ_DISABLED)) {
    init_device();

    if (!(options & BEQ_DISABLED)) {
      enumerate_cids();
      start_capturing();
    }
  }
}


void
destroy(__attribute__ ((unused)) Context_t *ctx)
{
  if (!(options & BEQ_DISABLED)) {
    stop_capturing();
    uninit_device();
    close_device();
  }

  free(dev_name);
}


void
run(Context_t *ctx)
{
  if (!(options & BEQ_DISABLED))
    loop(ctx);
}
