/*
 *  Copyright 1994-2011 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include "webcam.h"


static void
process_token(const char *tok)
{
  gchar **varval = NULL, **vv;

  // printf(">>>>>>>>> token: '%s' <<<<<<<<<<<<<\n", tok);
  varval = g_strsplit(tok, "=", 0);

  vv = varval;

  if (!strcmp((const char *)*vv, "device")) {
    vv++;
    assert(NULL != *vv);
    printf("[i] webcam: device set to %s\n", *vv);
    free(dev_name);
    dev_name = strdup(*vv);
  } else if (!strcmp((const char *)*vv, "hflip")) {
    printf("[i] webcam: set hflip\n");
    hflip = 1;
  }

  g_strfreev(varval);
}


static void
process_options(const char *options)
{
  gchar **tokens  = NULL, **tok;

  tokens = g_strsplit(options, " ", 0);

  for (tok = tokens ; *tok != NULL; tok++)
    process_token(*tok);

  g_strfreev(tokens);
}


void
parse_options()
{
  char *options = NULL;

  dev_name = strdup(DEFAULT_VIDEO_DEVICE);
  hflip = 0;

  options = getenv("BINIOU_WEBCAM");

  if (NULL != options)
    process_options(options);
}
