#############################################################################
#
#  Linux Desktop Testing Project http://ldtp.freedesktop.org
# 
#  Author:
#     A. Nagappan <nagappan@gmail.com>
# 
#  Copyright 2004 - 2006 Novell, Inc.
#  Copyright 2007 - 2008 Nagappan Alagappan
# 
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Library General Public
#  License as published by the Free Software Foundation; either
#  version 2 of the License, or (at your option) any later version.
# 
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
# 
#  You should have received a copy of the GNU Library General Public
#  License along with this library; if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA 02110, USA.
#
#############################################################################

import socket, os, struct, time, warnings
import threading, re, thread, select

# Let us not register our application under at-spi application list
os.environ ['GTK_MODULES'] = ''

try:
    import pyatspi as atspi, Accessibility
except ImportError:
    import atspi
    import Accessibility

from ldtpgui import *
from ldtplibutils import *
from ldtpcommon import *

class clienthandler:
    def __init__ (self, appmap, registry):
        self.command = None
        self.locale  = None
        self.logger  = None
        self.xmlhdlr = None
        self.appmap  = appmap
        self.registry   = registry
        self.guiTimeOut = 0
        self.objTimeOut = 0
        self.guiHandler = LdtpGui (self.registry)

    def hasState (self, accessible, argsList):
        if accessible is None or argsList is None or \
               type (accessible) is not type (Accessibility.Accessible) or \
               type (argsList) is not type (list):
            return LdtpErrorCode.INVALID_STATE
        _stateSet = accessible.getState ()
        if _stateSet is None:
            return LdtpErrorCode.INVALID_STATE
        for i in argsList:
            if _stateSet.contains (int (i)) == False:
                _stateSet.unref ()
                return LdtpErrorCode.INVALID_STATE
        _stateSet.unref ()
        return LdtpErrorCode.SUCCESS

    def addItem2List (items):
        if items is None:
            return ""
        itemList = ""
        for item in items:
            itemList += "<OBJECT>%s</OBJECT>" % saxutils.escape (item)
        return itemList

    def handleRequest (self, pckt):
        if pckt is None:
            return LdtpErrorCode.ARGUMENT_NULL
        parseRequest = Request ()
        _requestId, self.command, _context, _component, _argsList = parseRequest.parsexml (pckt)

        if self.command == 0 or self.command >= command.LASTCOMMAND:
            self.locale = _context
            return LdtpErrorCode.SUCCESS
        elif self.command == command.SETLOCALE:
            return LdtpErrorCode.COMMAND_NOT_IMPLEMENTED
        elif self.command == command.LAUNCHAPP:
            if _context is None or type (_context) != type (str) or _context == "":
                return LdtpErrorCode.UNABLE_TO_LAUNCH_APP
            if _component is not None and _component == "1":
                os.putenv ('GTK_MODULES', 'gail:atkbridge')
                os.putenv ('GNOME_ACCESSIBILITY', '1')
            pid = os.fork ()
            if pid == 0:
                if self.locale is not None:
                    os.putenv ("LANG", self.locale)
                commands.getstatusoutput (_context)
                os._exit (os.EX_OK)
            # Let us wait so that the application launches
            time.sleep (5)
        elif self.command == command.SETAPPMAP or self.command == command.INITAPPMAP:
            warnings.warn ('Use dynamic object finding', DeprecationWarning)
            return LdtpErrorCode.COMMAND_NOT_IMPLEMENTED
        elif self.command == command.LOG:
            priority = ""
            if _component is not None and (type (_component) == type (str) or type (_component) == type (unicode)):
                priority = _component
            internalLog (_context, priority, self.logger)
            return LdtpErrorCode.SUCCESS
        elif self.command == command.STARTLDTPLOG:
            _overWrite = 1
            if _component is not None:
                try:
                    _overWrite = int (_component)
                except ValueError:
                    pass
                self.logger, self.xmlhdlr = startInternalLog (logFileName, fileOverWrite, 'XML')
                if logger is not None:
                    return LdtpErrorCode.SUCCESS
                else:
                    return LdtpErrorCode.OPENING_LOG_FILE
        elif self.command == command.STOPLDTPLOG:
            internalStopLog (handler, xmlhdlr, self.logger)
            return LdtpErrorCode.SUCCESS
        elif self.command == command.STOPSCRIPTENGINE:
            return LdtpErrorCode.STOP_SCRIPT_ENGINE
        elif self.command == command.GENERATEMOUSEEVENT:
            x = y = 0
            eventName = "b1c"
            if _context is not None:
                try:
                    x = int (_context)
                except ValueError:
                    pass
            if _component is not None:
                try:
                    y = int (_component)
                except ValueError:
                    pass
            if _argsList is not None and type (_argsList) == type (list) and len (_argsList) > 0:
                eventName = _argsList [0]
            device = self.registry.getDeviceEventController ()
            if device is not None:
                device.generateMouseEvent (x, y, eventName)
                return LdtpErrorCode.SUCCESS
            else:
                return LdtpErrorCode.UNABLE_TO_GET_DEVICE
        elif self.command == command.GENERATEKEYEVENT:
            return LdtpErrorCode.COMMAND_NOT_IMPLEMENTED
        elif self.command == command.SETCONTEXT:
            return LdtpErrorCode.COMMAND_NOT_IMPLEMENTED
        elif self.command == command.RELEASECONTEXT:
            return LdtpErrorCode.COMMAND_NOT_IMPLEMENTED
        elif self.command == command.REINITLDTP:
            return LdtpErrorCode.COMMAND_NOT_IMPLEMENTED
        elif self.command == command.GUITIMEOUT:
            if _context is not None:
                try:
                    self.guiTimeOut = int (_context)
                except ValueError:
                    pass
            return LdtpErrorCode.SUCCESS
        elif self.command == command.OBJTIMEOUT:
            if _context is not None:
                try:
                    self.objTimeOut = int (_context)
                except ValueError:
                    pass
            return LdtpErrorCode.SUCCESS
        elif self.command == command.WAITTILLGUIEXIST:
            return LdtpErrorCode.COMMAND_NOT_IMPLEMENTED
        elif self.command == command.WAITTILLGUINOTEXIST:
            return LdtpErrorCode.COMMAND_NOT_IMPLEMENTED
        elif self.command == command.DOESMENUITEMEXIST or self.command == command.MENUCHECK or \
                 self.command == command.MENUUNCHECK or self.command == command.VERIFYMENUCHECK or \
                 self.command == command.VERIFYMENUUNCHECK or self.command == command.SELECTMENUITEM:
            if re.search (';', _component) is not None:
                _argsList = []
                _argsList.append (re.split (';', _component, 1)[1])
                _component = re.split (';', _component, 1)[0]
        elif self.command == command.ONWINDOWCREATE:
            return LdtpErrorCode.COMMAND_NOT_IMPLEMENTED
        elif self.command == command.REMOVECALLBACK:
            return LdtpErrorCode.COMMAND_NOT_IMPLEMENTED
        elif self.command == command.REMAP:
            if _component is None:
                return LdtpErrorCode.COMMAND_NOT_IMPLEMENTED
            else:
                return LdtpErrorCode.COMMAND_NOT_IMPLEMENTED
        elif self.command == command.BINDTEXT:
            return LdtpErrorCode.COMMAND_NOT_IMPLEMENTED
        elif self.command == command.GETAPPLIST:
            windowList = self.guiHandler.getWindowList ()
            if windowList is None:
                return LdtpErrorCode.UNABLE_TO_GET_APPLICATION_LIST
            pckt.resp.data = XmlTags.XML_HEADER + "<OBJECTLIST>" + self.addItem2List (windowList) + "</OBJECTLIST>"
            return LdtpErrorCode.SUCCESS
        elif self.command == command.GETWINDOWLIST:
            if self.appmap.applicationmap is None:
                return LdtpErrorCode.APPMAP_NOT_INITIALIZED
            pckt.resp.data = XmlTags.XML_HEADER + "<OBJECTLIST>" + self.addItem2List (self.appmap.applicationmap.keys ()) + "</OBJECTLIST>"
            return LdtpErrorCode.SUCCESS
        elif self.command == command.GETOBJECTLIST:
            if _context is None:
                return LdtpErrorCode.ARGUMENT_NULL
            if self.appmap.applicationmap is None:
                # FIXME - Do Remap
                pass
            ht = self.appmap.getObjectDef (self.appmap.applicationmap, _context, True)
            if ht is None:
                # FIXME - Do Remap
                pass
                # if ht is None:
                #     return LdtpErrorCode.UNABLE_TO_GET_CONTEXT_HANDLE
            pckt.resp.data = XmlTags.XML_HEADER + "<OBJECTLIST>" + self.addItem2List (ht.keys ()) + "</OBJECTLIST>"
            return LdtpErrorCode.SUCCESS
        elif self.command == command.GETOBJECTINFO:
            if _context is None or _component is None:
                return LdtpErrorCode.ARGUMENT_NULL
            if self.appmap.applicationmap is None:
                # FIXME - Do Remap
                self.appmap.doRemap (event.source, _name)
            contextHt = self.appmap.getObjectDef (self.appmap.applicationmap, _context, True)
            if contextHt is None:
                # FIXME - Do Remap
                pass
                # if contextHt is None:
                #     return LdtpErrorCode.UNABLE_TO_GET_CONTEXT_HANDLE
            componentHt = self.appmap.getObjectDef (contextHt, _component, True)
            if componentHt is None:
                # FIXME - Do Remap
                pass
                # if componentHt is None:
                #     return LdtpErrorCode.UNABLE_TO_GET_COMPONENT_HANDLE
            pckt.resp.data = XmlTags.XML_HEADER + "<OBJECTLIST>" + self.addItem2List (componentHt.keys ()) + "</OBJECTLIST>"
            return LdtpErrorCode.SUCCESS
        elif self.command == command.GETOBJECTPROPERTY:
            if _context is None or _component is None or _argsList is None:
                return LdtpErrorCode.ARGUMENT_NULL
            if self.appmap.applicationmap is None:
                # FIXME - Do Remap
                pass
            contextHt = self.appmap.getObjectDef (self.appmap.applicationmap, _context, True)
            if contextHt is None:
                # FIXME - Do Remap
                pass
                # if contextHt is None:
                #     return LdtpErrorCode.UNABLE_TO_GET_CONTEXT_HANDLE
            componentHt = self.appmap.getObjectDef (contextHt, _component, True)
            if componentHt is None:
                # FIXME - Do Remap
                pass
                # if componentHt is None:
                #     return LdtpErrorCode.UNABLE_TO_GET_COMPONENT_HANDLE
            _property = getProperty (componentHt, _argsList [0])
            if _property is None:
                return LdtpErrorCode.UNABLE_TO_GET_PROPERTY
            pckt.resp.data = _property
            return LdtpErrorCode.SUCCESS
        ################################################################################
        # 1)  Get the Accessible object corresponding to "component-name".             #
        # 2)  Get the class-id and                                                     #
        # 3)  Call the corresponding component main function with necessary arguments. #
        ################################################################################
