#!/bin/sh
#
# this tries to install ldapdns in a sane manner
if [ "X$1" != "X" ]; then
	prefix=$1
fi
if [ "X$prefix" = "X" ]; then
	if [ "X$TRUEPREFIX" = "X" ]; then
		prefix=$TRUEPREFIX
	else
		prefix="/usr/local"
	fi
fi

if [ "X$bin" = "X" ]; then
	bin=bin
fi

if [ "X$builddir" = "X" ]; then
	builddir=`dirname $0`
fi
mkdir -p $DESTDIR$prefix/$bin

cp $builddir/ldapdns $DESTDIR$prefix/$bin/.
chmod 0555 $DESTDIR$prefix/$bin/ldapdns

tcpservers_ok=0

savepath=$PATH
PATH=$DESTDIR$prefix/bin:$DESTDIR$prefix/sbin:/sbin:/bin:/usr/sbin:/usr/bin:$PATH
export PATH
if which tcpserver >/dev/null 2>&1; then
	# ucspi ok...
	tcpservers_ok=1
fi
if which svc >/dev/null 2>&1; then
	# daemontools ok...
	daemontools_ok=1
fi

PATH=$savepath
export PATH

if [ -x $DESTDIR/command/svc ]; then
	daemontools_ok=1;
fi
if [ -x $DESTDIR/command/tcpserver ]; then
	tcpservers_ok=1;
fi

# if we're using daemontools...
if [ "X$NO_DAEMONTOOLS" != 'X' ]; then
	daemontools_ok=0
elif [ "X$DAEMONTOOLS" != 'X' ]; then
	daemontools_ok=1
fi

if [ "X$NO_TCPSERVERS" != 'X' ]; then
	tcpservers_ok=0
elif [ "X$TCPSERVERS" != 'X' ]; then
	tcpservers_ok=1
fi

if [ "X$INITRC" != "X" ]; then
	if [ "X$RUN_USER" != "X" ]; then
		RUN_UID=`id -u $RUN_USER`
		RUN_GID=`id -g $RUN_USER`
	fi
	if [ "X$RUN_UID" = "X" ]; then
		echo '$RUN_UID not set'
		exit 1
	fi
	if [ "X$RUN_GID" = "X" ]; then
		echo '$RUN_GID not set'
		exit 1
	fi
	if echo $RUN_UID | egrep '[^0-9]' >/dev/null 2>&1; then
		echo '$RUN_UID must be numeric (or use $RUN_USER)'
		exit 1
	fi
	if echo $RUN_GID | egrep '[^0-9]' >/dev/null 2>&1; then
		echo '$RUN_GID must be numeric (or use $RUN_USER)'
		exit 1
	fi

	if [ "X$FORCE_INITRC" != "X" ]; then
		mkdir -p $DESTDIR/etc/init.d
		cp $builddir/sysvinit/ldapaxfr $DESTDIR/etc/init.d/ldapaxfr
		cp $builddir/sysvinit/ldapdns $DESTDIR/etc/init.d/ldapdns
	elif [ -d /etc/init.d -o -d $DESTDIR/etc/init.d ]; then
		mkdir -p $DESTDIR/etc/init.d
		cp $builddir/sysvinit/ldapaxfr $DESTDIR/etc/init.d/ldapaxfr
		cp $builddir/sysvinit/ldapdns $DESTDIR/etc/init.d/ldapdns
	else
		echo 'initrc cannot be installed without an /etc/init.d'
		exit 1
	fi

	# make other parts
	mkdir -p $DESTDIR/var/lib/ldapdns
	chmod 0700 $DESTDIR/var/lib/ldapdns
	chown $RUN_UID:$RUN_GID $DESTDIR/var/lib/ldapdns

	cp $builddir/ldapdns $DESTDIR$prefix/$bin/ldapdns
	chmod 0555 $DESTDIR$prefix/$bin/ldapdns

	cp $builddir/ldapaxfr $DESTDIR$prefix/$bin/ldapaxfr
	chmod 0555 $DESTDIR$prefix/$bin/ldapaxfr

	cfile=$DESTDIR/etc/ldapdns.conf
	if [ -d "/etc/sysconfig" -o -d "$DESTDIR/etc/sysconfig" ]; then
		mkdir -p $DESTDIR/etc/sysconfig
		cfile=$DESTDIR/etc/sysconfig/ldapdns
	fi

	# copy the configuration file (and add running uid/gid)
	cp $builddir/sample/ldapdns.conf $cfile
	echo "RUN_UID=$RUN_UID" >> $cfile
	echo "RUN_GID=$RUN_GID" >> $cfile

	# copy the default axfr rules
	cp $builddir/sample/axfr $DESTDIR/var/lib/ldapdns/axfr
fi

if [ "X$tcpservers_ok" = "X1" ]; then
	# ldapaxfr
	cp $builddir/ldapaxfr $DESTDIR$prefix/$bin/.
	chmod 0555 $DESTDIR$prefix/$bin/ldapaxfr
elif [ "X$NO_TCPSERVERS" = 'X' ]; then
	echo 'tcpservers (ucspi-tcp) is not installed.'
	echo 'cannot install ldapaxfr without it'
	echo '(set $TCPSERVERS=1 to force)'
fi

if [ "X$daemontools_ok" = "X1" ]; then
	# confs
	cp $builddir/ldapdns-conf $DESTDIR$prefix/bin/.
	chmod 0555 $DESTDIR$prefix/bin/ldapdns-conf
	if [ "X$tcpservers_ok" = "X1" ]; then
		cp $builddir/ldapaxfr-conf $DESTDIR$prefix/bin/.
		chmod 0555 $DESTDIR$prefix/bin/ldapaxfr-conf
	fi
	if [ "X$no_domainname_sh" != "X1" ]; then
		cp $builddir/domainname.sh $DESTDIR$prefix/bin/domainname.sh
		chmod 0755 $DESTDIR$prefix/bin/domainname.sh
	fi
elif [ "X$NO_DAEMONTOOLS" = 'X' ]; then
	echo 'daemontools is not installed.'
	echo '(skipping install of config tools)'
	echo '(set $DAEMONTOOLS=1 to force)'
fi

