/* this is the brisby fancy hashtable */
#ifndef __ht_h
#define __ht_h

typedef struct {
	void *key;
	unsigned klen;
	unsigned long hash;
	void *data;
	int free_data;
	int idata;

	void *next;
} htbucket;
typedef struct {
	unsigned s;
	htbucket **b;
	unsigned long (*hash)(const void *,unsigned);
	int (*ondel)(void *);

	/* useful for to-disk journaling */
	void (*onwrite)(const void *key, unsigned klen, const void *data);
	int (*onfail)(const void *key, unsigned klen);
} ht;

enum {	HT_RESTART,
	HT_FAILNOW, HT_SUCCESSNOW,
	HT_TRIPSUCCESS, HT_TRIPFAIL,
	HT_WILLSUCCESS, HT_WILLFAIL,
	HT_NEXT, HT_AGAIN,
};

int ht_init(ht *x, unsigned tab, unsigned long (*hash)(const void *, unsigned));
int ht_die(ht *x);
int ht_walk(ht *x, int (*fn)(ht *, void *, unsigned, void *));
int ht_store(ht *x, const void *, unsigned, void *);
int ht_storeint(ht *x, const void *, unsigned, int i);
int ht_storecopy(ht *x, const void *, unsigned, void *, unsigned);
void *ht_fetch(ht *x, const void *, unsigned);
int ht_fetchint(ht *x, const void *, unsigned);
int ht_delete(ht *x, const void *, unsigned);

int ht_ondelete(ht *x, int (*fn)(void *data));
int ht_onwrite(ht *x, void (*fn)(const void *,unsigned,const void *));
int ht_onfail(ht *x, int (*fn)(const void *, unsigned));

#endif
