<?php
/*
	$Id: adminMain.php,v 1.14 2008-01-01 13:05:31 roland Exp $

	This code is part of LDAP Account Manager Pro (http://www.sourceforge.net/projects/lam)
	Copyright (C) 2006 - 2007  Roland Gruber
*/

/**
* Configuration page for self service.
*
* @package selfService
*
* @author Roland Gruber
*/

/** Access to self service profiles */
include_once('../../lib/selfService.inc');
/** Access config options */
include_once('../../lib/config.inc');

// start session
session_save_path("../../sess");
@session_start();

setlanguage();

// check password
$conf = new LAMCfgMain();
if (!$conf->checkPassword($_SESSION['selfService_password'])) die();

// read self service profile
$scope = $_SESSION['selfService_scope'];
$name = $_SESSION['selfService_name'];
if (!isset($_SESSION['selfService_profile'])) $_SESSION['selfService_profile'] = loadSelfServiceProfile($name, $scope);
$profile = &$_SESSION['selfService_profile'];
$errors = array();

// check if user pushed ok/cancel buttons
if (isset($_POST['submit']) || isset($_POST['cancel'])) {
	if (isset($_POST['cancel'])) {
		metaRefresh('adminLogin.php');
		die();
	}
	else {
		// remove double slashes if magic quotes are on
		if (get_magic_quotes_gpc() == 1) {
			$postKeys = array_keys($_POST);
			for ($i = 0; $i < sizeof($postKeys); $i++) {
				if (is_string($_POST[$postKeys[$i]])) $_POST[$postKeys[$i]] = stripslashes($_POST[$postKeys[$i]]);
			}
		}
		// save settings
		// server URL
		$serverURL = $_POST['serverurl'];
		if (eregi("^[0-9a-z\\.:/ _-]+$", $serverURL)) {
			$profile->serverURL = $serverURL;
		}
		else {
			$errors[] = array("ERROR", _("Server address is invalid!"));
		}
		// LDAP suffix
		$profile->LDAPSuffix = $_POST['suffix'];
		// LDAP user+password
		$profile->LDAPUser = $_POST['ldapUser'];
		$profile->LDAPPassword = $_POST['ldapPassword'];
		// search attribute
		$profile->searchAttribute = $_POST['searchAttribute'];
		// login caption
		$profile->loginCaption = $_POST['loginCaption'];
		// login attribute
		$profile->loginAttributeText = $_POST['loginAttributeLabel'];
		// main page caption
		$profile->mainPageText = $_POST['mainPageCaption'];
		// check module options
		// create option array to check and save
		$options = array();
		$opt_keys = array_keys($_SESSION['conf_types']);
		for ($i = 0; $i < sizeof($opt_keys); $i++) {
			$element = $opt_keys[$i];
			// text fields
			if ($_SESSION['conf_types'][$element] == "text") {
				$options[$element] = array($_POST[$element]);
			}
			// checkboxes
			elseif ($_SESSION['conf_types'][$element] == "checkbox") {
				if ($_POST[$element] == "on") $options[$element] = array('true');
				else $options[$element] = array('false');
			}
			// dropdownbox
			elseif ($_SESSION['conf_types'][$element] == "select") {
				$options[$element] = array($_POST[$element]);
			}
			// multiselect
			elseif ($_SESSION['conf_types'][$element] == "multiselect") {
				$options[$element] = $_POST[$element];  // value is already an array
			}
		}
		// check options
		$errors = array_merge($errors, checkSelfServiceSettings($scope, $options));
		// end of checks	
		if (sizeof($errors) < 1) {
			$profile->moduleSettings = $options;
			$success = saveSelfServiceProfile($name, $scope, $profile);
			if ($success) {
				echo $_SESSION['header'];
				echo "<title>" . _("LDAP Account Manager Configuration") . "</title>\n";
				echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"../../style/layout.css\">\n";
				echo "<link rel=\"shortcut icon\" type=\"image/x-icon\" href=\"../../graphics/favicon.ico\">\n";
				echo "</head><body>\n";
				echo ("<p align=\"center\"><a href=\"http://lam.sourceforge.net\" target=\"new_window\">".
					"<img src=\"../../graphics/banner.jpg\" border=1 alt=\"LDAP Account Manager\"></a></p><hr><br><br>");
				StatusMessage("INFO", _("Your settings were successfully saved."), $name . "." . $scope);
				echo ("<br><br><br><br><br><a href=\"../login.php\" target=\"_top\">" . _("Back to Login") . "</a>");
				echo("</body></html>");
				// remove settings from session
				$sessionKeys = array_keys($_SESSION);
				for ($i = 0; $i < sizeof($sessionKeys); $i++) {
					if (substr($sessionKeys[$i], 0, 5) == "selfService_") unset($_SESSION[$sessionKeys[$i]]);
				}
				die();
			}
			else {
				$errors[] = array("ERROR", _("Unable to save profile!"), $name . "." . $scope);
			}
		}
	}
}

// check if user changed input fields
$inputFieldsButtonPressed = false;
$postKeys = array_keys($_POST);
for ($i = 0; $i < sizeof($postKeys); $i++) {
	if (substr($postKeys[$i], 0, 3) === "if_") {
		$inputFieldsButtonPressed = true;
		break;
	}
}
if ($inputFieldsButtonPressed) {
	// new group
	if (isset($_POST['if_new_group'])) {
		$profile->inputFields[] = array('name' => $_POST['new_groupName'], 'fields' => array());
	}
	// new input field
	elseif (isset($_POST['if_add_inputField'])) {
		$profile->inputFields[$_POST['add_inputField_group']]['fields'][] = $_POST['add_inputField'];
	}
	// change group name
	else {
		for ($i = 0; $i < sizeof($profile->inputFields); $i++) {
			if (isset($_POST['if_edit_' . $i])) {
				$profile->inputFields[$i]['name'] = $_POST["group_" . $i];
				break;
			}
		}
	}
}
// check if user wants to move up a group
elseif (isset($_GET['if_up'])) {
	$pos = $_GET['if_up_val'];
	if ($pos != 0) {
		$temp = $profile->inputFields[$pos - 1];
		$profile->inputFields[$pos - 1] = $profile->inputFields[$pos];
		$profile->inputFields[$pos] = $temp;
	}
}
// check if user wants to move down a group
elseif (isset($_GET['if_down'])) {
	$pos = $_GET['if_down_val'];
	if ($pos < sizeof($profile->inputFields) - 1) {
		$temp = $profile->inputFields[$pos + 1];
		$profile->inputFields[$pos + 1] = $profile->inputFields[$pos];
		$profile->inputFields[$pos] = $temp;
	}
}
// check if user wants to delete a group
elseif (isset($_GET['if_del'])) {
	$pos = $_GET['if_del_val'];
	unset($profile->inputFields[$pos]);
	$profile->inputFields = array_values($profile->inputFields);
}
// check if user wants to move up a field
elseif (isset($_GET['if_field_up'])) {
	$pos = $_GET['if_up_val'];
	$group = $_GET['if_group_val'];
	if ($pos != 0) {
		$temp = $profile->inputFields[$group]['fields'][$pos - 1];
		$profile->inputFields[$group]['fields'][$pos - 1] = $profile->inputFields[$group]['fields'][$pos];
		$profile->inputFields[$group]['fields'][$pos] = $temp;
	}
}
// check if user wants to move down a group
elseif (isset($_GET['if_field_down'])) {
	$pos = $_GET['if_down_val'];
	$group = $_GET['if_group_val'];
	if ($pos < sizeof($profile->inputFields[$group]['fields']) - 1) {
		$temp = $profile->inputFields[$group]['fields'][$pos + 1];
		$profile->inputFields[$group]['fields'][$pos + 1] = $profile->inputFields[$group]['fields'][$pos];
		$profile->inputFields[$group]['fields'][$pos] = $temp;
	}
}
// check if user wants to delete a group
elseif (isset($_GET['if_field_del'])) {
	$pos = $_GET['if_del_val'];
	$group = $_GET['if_group_val'];
	unset($profile->inputFields[$group]['fields'][$pos]);
	$profile->inputFields[$group]['fields'] = array_values($profile->inputFields[$group]['fields']);
}

$selfServiceFields = getSelfServiceFieldSettings($scope);
$selfServiceFieldNames = array();
$temp = array_values($selfServiceFields);
for ($i = 0; $i < sizeof($temp); $i++) {
	if (isset($temp[$i]) && is_array($temp[$i])) {
		$selfServiceFieldNames = array_merge($selfServiceFieldNames, $temp[$i]);
	}
}


echo $_SESSION['header'];

?>
	<title>
		<?php
			echo _("Self service configuration");
		?>
	</title>
	<link rel="stylesheet" type="text/css" href="../../style/layout.css">
	<link rel="shortcut icon" type="image/x-icon" href="../../graphics/favicon.ico">
</head>
<body>
	<p align="center"><a href="http://lam.sourceforge.net" target="_blank">
		<img src="../../graphics/banner.jpg" border=1 alt="LDAP Account Manager"></a>
	</p>
	<hr>
	<H1 align="center">
		<?php
			echo _("Self service configuration editor");
		?>
	</H1>

<!-- display formular -->
<form enctype="multipart/form-data" action="adminMain.php" method="post">

<?PHP
if (sizeof($errors) > 0) {
	for ($i = 0; $i < sizeof($errors); $i++) {
		call_user_func_array('StatusMessage', $errors[$i]);
	}
	echo "<br>";
}

echo "<br>";
echo "<big><b>" . _("Link to login page for this self service profile") . ":</b> ";
echo "<A href=\"selfServiceLogin.php?name=" . $name . "&amp;scope=" . $scope . "\">" . _("Login") . "</A></big>\n";
echo "<br>";
echo "<br>";
echo "<br>";
echo "<br>";

$tabindex = 0;
$tabindexLink = 10000;

echo ("<fieldset><legend><b>" . _("Server settings") . "</b></legend><br>\n");
echo ("<table border=0>\n");
// serverURL
echo ("<tr><td align=\"right\"><b>" . _("Server address") . " *: </b></td>".
	"<td align=\"left\">".
	"<input tabindex=\"$tabindex\" size=50 type=\"text\" name=\"serverurl\" value=\"" . $profile->serverURL . "\">".
	"</td>\n");
echo "<td>";
echo "<a href=\"../help.php?HelpNumber=201\" target=\"lamhelp\">";
echo "<img src=\"../../graphics/help.png\" alt=\"" . _('Help') . "\" title=\"" . _('Help') . "\">";
echo "</a>\n";
echo "</td></tr>\n";
$tabindex++;

// new line
echo ("<tr><td colspan=3>&nbsp;</td></tr>");

// LDAP suffix
echo ("<tr><td align=\"right\"><b>".
	_("LDAP suffix") . " *: </b></td>".
	"<td><input tabindex=\"$tabindex\" size=50 type=\"text\" name=\"suffix\" value=\"" . $profile->LDAPSuffix . "\"></td>\n");
echo "<td>";
echo "<a href=\"../help.php?HelpNumber=501\" target=\"lamhelp\">";
echo "<img src=\"../../graphics/help.png\" alt=\"" . _('Help') . "\" title=\"" . _('Help') . "\">";
echo "</a>\n";
echo "</td></tr>\n";
$tabindex++;

// new line
echo ("<tr><td colspan=3>&nbsp;</td></tr>");

// LDAP user
echo ("<tr><td align=\"right\"><b>".
	_("LDAP user") . ": </b></td>".
	"<td><input tabindex=\"$tabindex\" size=50 type=\"text\" name=\"ldapUser\" value=\"" . $profile->LDAPUser . "\"></td>\n");
echo "<td>";
echo "<a href=\"../help.php?HelpNumber=502\" target=\"lamhelp\">";
echo "<img src=\"../../graphics/help.png\" alt=\"" . _('Help') . "\" title=\"" . _('Help') . "\">";
echo "</a>\n";
echo "</td></tr>\n";
$tabindex++;

// new line
echo ("<tr><td colspan=3>&nbsp;</td></tr>");

// LDAP password
echo ("<tr><td align=\"right\"><b>".
	_("LDAP password") . ": </b></td>".
	"<td><input tabindex=\"$tabindex\" size=50 type=\"password\" name=\"ldapPassword\" value=\"" . $profile->LDAPPassword . "\"></td>\n");
echo "<td>";
echo "<a href=\"../help.php?HelpNumber=502\" target=\"lamhelp\">";
echo "<img src=\"../../graphics/help.png\" alt=\"" . _('Help') . "\" title=\"" . _('Help') . "\">";
echo "</a>\n";
echo "</td></tr>\n";
$tabindex++;

// new line
echo ("<tr><td colspan=3>&nbsp;</td></tr>");

// search attribute
echo "<tr><td align=\"right\"><b>" . _("LDAP search attribute") . " *: </b></td>\n";
echo "<td><select tabindex=\"$tabindex\" size=1 name=\"searchAttribute\">\n";
	$attributes = getSelfServiceSearchAttributes($scope);
	for ($i = 0; $i < sizeof($attributes); $i++) {
		if ($attributes[$i] === $profile->searchAttribute) {
			echo "<option selected>" . $attributes[$i] . "</option>\n";
		}
		else {
			echo "<option>" . $attributes[$i] . "</option>\n";
		}
	}
echo "</select></td>\n";
echo "<td>";
echo "<a href=\"../help.php?HelpNumber=503\" target=\"lamhelp\">";
echo "<img src=\"../../graphics/help.png\" alt=\"" . _('Help') . "\" title=\"" . _('Help') . "\">";
echo "</a>\n";
echo "</td></tr>\n";
$tabindex++;

echo ("</table>");
echo ("</fieldset>");

echo "<br>";

echo ("<fieldset><legend><b>" . _("Captions and labels") . "</b></legend><br>\n");
echo ("<table border=0>\n");

// login attribute label
echo "<tr><td align=\"right\"><b>" . _("Login attribute label") . " *: </b></td>\n";
echo "<td><input type=\"text\" name=\"loginAttributeLabel\" value=\"";
	echo htmlspecialchars($profile->loginAttributeText);
echo "\"></td>\n";
echo "<td>";
echo "<a href=\"../help.php?HelpNumber=504\" target=\"lamhelp\">";
echo "<img src=\"../../graphics/help.png\" alt=\"" . _('Help') . "\" title=\"" . _('Help') . "\">";
echo "</a>\n";
echo "</td></tr>\n";
$tabindex++;

// new line
echo ("<tr><td colspan=3>&nbsp;</td></tr>");

// login caption
echo "<tr><td align=\"right\"><b>" . _("Login caption") . " *: </b></td>\n";
echo "<td><textarea name=\"loginCaption\" cols=\"80\" rows=\"7\">";
	echo htmlspecialchars($profile->loginCaption);
echo "</textarea></td>\n";
echo "<td>";
echo "<a href=\"../help.php?HelpNumber=505\" target=\"lamhelp\">";
echo "<img src=\"../../graphics/help.png\" alt=\"" . _('Help') . "\" title=\"" . _('Help') . "\">";
echo "</a>\n";
echo "</td></tr>\n";
$tabindex++;

// new line
echo ("<tr><td colspan=3>&nbsp;</td></tr>");

// main text
echo "<tr><td align=\"right\"><b>" . _("Main page caption") . " *: </b></td>\n";
echo "<td><textarea name=\"mainPageCaption\" cols=\"80\" rows=\"7\">";
	echo htmlspecialchars($profile->mainPageText);
echo "</textarea></td>\n";
echo "<td>";
echo "<a href=\"../help.php?HelpNumber=506\" target=\"lamhelp\">";
echo "<img src=\"../../graphics/help.png\" alt=\"" . _('Help') . "\" title=\"" . _('Help') . "\">";
echo "</a>\n";
echo "</td></tr>\n";
$tabindex++;


echo ("</table>");
echo ("</fieldset>");

echo "<br>";

// select input fields
echo ("<fieldset><legend><b>" . _("Input fields") . "</b></legend><br>\n");
echo ("<table border=0>\n");

$usedFieldNames = array();

for ($i = 0; $i < sizeof($profile->inputFields); $i++) {
	echo "<tr>";
		echo "<td colspan=2>";
			echo "<input type=\"text\" name=\"group_" . $i ."\" value=\"" . $profile->inputFields[$i]['name'] . "\">";
			echo "<input type=\"submit\" name=\"if_edit_" . $i . "\" value=\"" . _('Change') . "\">";
		echo "</td>\n";
		echo "<td>";
			echo "<a href=\"adminMain.php?name=" . $name . "&amp;scope=" . $scope . "&amp;if_up_val=" . $i . "&amp;if_up=1\">";
			echo "<img src=\"../../graphics/up.gif\" border=0 alt=\"up\">";
			echo "</a>";
		echo "</td>\n";
		echo "<td>";
			echo "<a href=\"adminMain.php?name=" . $name . "&amp;scope=" . $scope . "&amp;if_down_val=" . $i . "&amp;if_down=1\">";
			echo "<img src=\"../../graphics/down.gif\" border=0 alt=\"up\">";
			echo "</a>";
		echo "</td>\n";
		echo "<td>";
			echo "<a href=\"adminMain.php?name=" . $name . "&amp;scope=" . $scope . "&amp;if_del_val=" . $i . "&amp;if_del=1\">";
			echo "<img src=\"../../graphics/delete.gif\" border=0 alt=\"up\">";
			echo "</a>";
		echo "</td>\n";
	echo "</tr>\n";
	for ($f = 0; $f < sizeof($profile->inputFields[$i]['fields']); $f++) {
		echo "<tr>";
			echo "<td width=20></td>\n";
			echo "<td>";
				$field = $profile->inputFields[$i]['fields'][$f];
				$usedFieldNames[] = $field;
				$parts = split("_", $field);
				if (sizeof($parts) != 2) continue;
				echo getModuleAlias($parts[0], $scope);
				echo ": ";
				echo $selfServiceFieldNames[$parts[1]];
			echo "</td>\n";
			echo "<td>";
				echo "<a href=\"adminMain.php?name=" . $name . "&amp;scope=" . $scope . "&amp;if_up_val=" . $f . "&amp;if_field_up=1&amp;if_group_val=" . $i . "\">";
				echo "<img src=\"../../graphics/up.gif\" border=0 alt=\"up\">";
				echo "</a>";
			echo "</td>\n";
			echo "<td>";
				echo "<a href=\"adminMain.php?name=" . $name . "&amp;scope=" . $scope . "&amp;if_down_val=" . $f . "&amp;if_field_down=1&amp;if_group_val=" . $i . "\">";
				echo "<img src=\"../../graphics/down.gif\" border=0 alt=\"up\">";
				echo "</a>";
			echo "</td>\n";
			echo "<td>";
				echo "<a href=\"adminMain.php?name=" . $name . "&amp;scope=" . $scope . "&amp;if_del_val=" . $f . "&amp;if_field_del=1&amp;if_group_val=" . $i . "\">";
				echo "<img src=\"../../graphics/delete.gif\" border=0 alt=\"up\">";
				echo "</a>";
			echo "</td>\n";
		echo "</tr>\n";
	}
}

echo ("</table>");

echo "<br><hr><br>";

echo ("<table border=0>\n");
	// new group
	echo "<tr>";
		echo "<td>";
			echo _("Add new group");
		echo "</td>\n";
		echo "<td>";
			echo "<input type=\"text\" name=\"new_groupName\"> ";
			echo "<input type=\"submit\" name=\"if_new_group\" value=\"" . _("Ok") . "\"> ";
			echo "<a href=\"../help.php?HelpNumber=507\" target=\"lamhelp\">";
			echo "<img src=\"../../graphics/help.png\" alt=\"" . _('Help') . "\" title=\"" . _('Help') . "\">";
			echo "</a>\n";
		echo "</td>\n";
	echo "</tr>\n";

	echo "<tr><td colspan=4>&nbsp;</td></tr>\n";

if (sizeof($profile->inputFields) > 0) {
	// add input field
	echo "<tr>";
		echo "<td>";
			echo _("Add input field");
		echo "</td>\n";
		echo "<td>";
			echo "<select size=\"1\" name=\"add_inputField\">\n";
				$modules = array_keys($selfServiceFields);
				for ($i = 0; $i < sizeof($modules); $i++) {
					$module = $selfServiceFields[$modules[$i]];
					$fieldNames = array_keys($module);
					for ($f = 0; $f < sizeof($fieldNames); $f++) {
						if (in_array($modules[$i] . "_" . $fieldNames[$f], $usedFieldNames)) continue;
						echo "<option value=\"" . $modules[$i] . "_" . $fieldNames[$f] . "\">";
						echo getModuleAlias($modules[$i], $scope) . ": " . $module[$fieldNames[$f]] . "</option>\n";
					}
				}
			echo "</select> \n";
			echo _("Group") . " \n";
			echo "<select size=\"1\" name=\"add_inputField_group\">\n";
				for ($i = 0; $i < sizeof($profile->inputFields); $i++) {
					echo "<option value=\"" . $i . "\">" . $profile->inputFields[$i]['name'] . "</option>\n";
				}
			echo "</select>\n";
			echo " <input type=\"submit\" name=\"if_add_inputField\" value=\"" . _("Ok") . "\">";
			echo " <a href=\"../help.php?HelpNumber=508\" target=\"lamhelp\">";
			echo "<img src=\"../../graphics/help.png\" alt=\"" . _('Help') . "\" title=\"" . _('Help') . "\">";
			echo "</a>\n";
		echo "</td>\n";
	echo "</tr>\n";
}

echo ("</table>");


echo ("</fieldset>");

echo ("<br>");

// get module options
$options = getSelfServiceSettings($scope);
// get current settings
$old_options = $profile->moduleSettings;

// display module boxes
$modules = getAvailableModules($scope);
$_SESSION['conf_types'] = array();
for ($i = 0; $i < sizeof($modules); $i++) {
	if (sizeof($options[$modules[$i]]) < 1) continue;
	echo "<fieldset>\n";
	echo "<legend><b>" . getModuleAlias($modules[$i], $scope) . "</b></legend><br>\n";
	$configTypes = parseHtml($modules[$i], $options[$modules[$i]], $old_options, true, $tabindex, $tabindexLink, $scope);
	$_SESSION['conf_types'] = array_merge($configTypes, $_SESSION['conf_types']);
	echo "</fieldset>\n";
	echo "<br>";
}



// buttons
echo ("<table border=0>\n");

echo "<tr>";
echo "<td align=\"left\"><pre>";
	echo "<input tabindex=\"$tabindex\" type=\"submit\" name=\"submit\" value=\"" . _("Ok") . "\">";
	$tabindex++;
	echo "&nbsp;";
	echo "<input tabindex=\"$tabindex\" type=\"submit\" name=\"cancel\" value=\"" . _("Cancel") . "\"\n";
	$tabindex++;

echo ("></pre></td></tr>\n");

echo ("</table>\n");

echo ("<p>* = ". _("required") . "</p>");
?>

</FORM>
</BODY>
</HTML>