/* SPDX-License-Identifier: GPL-2.0-only OR GPL-3.0-only */
/* Copyright (c) 2020-2023 Brett Sheffield <bacs@librecast.net> */

#ifndef _GLOBALS_H
#define _GLOBALS_H 1

#include <sodium.h>
#include <stdint.h>

#define THREAD_MAX 128
#define PASSWORD_MAX 1024

#ifndef EKEYREJECTED
# define    EKEYREJECTED    129
#endif

extern int (*action)(int *argc, char *argv[]);
extern int batchmode;
extern size_t bpslimit;
extern char *bwlimit;
extern int dryrun;
extern int g_archive;
extern int g_perms;
extern int hex;
extern char *iface;
extern unsigned int ifx;
extern char *keyfile;
extern int loopback;
extern char *password;
extern char *progname;
extern unsigned char secretkey[crypto_pwhash_STRBYTES];
extern int quiet;
extern int verbose;
extern int version;

/* default action is to do nothing, successfully */
int succeed(int *argc, char *argv[]);
#endif /* _GLOBALS_h */
