/*
 * Copyright (c) 2009-~ Niu Tao
 *
 * This source code is released for free distribution under the terms of the
 * GNU General Public License
 *
 * Author:       Niu Tao<niutao0602@gmail.com>
 * Created Time: Sat 22 Jan 2011 04:18:02 PM CST
 *
 *
 * Description:  
 */

#ifndef __LCRT_IQCONNECT_H__
#define __LCRT_IQCONNECT_H__

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "mkconfig.h"
#include "imenubar.h"

#define LCRT_IQCONNECT_TABLE "iqconnect"

enum {
    LCRT_Q_CONNECT,
    LCRT_Q_LB_PROTOCOL,
    LCRT_Q_LB_HOSTNAME,
    LCRT_Q_LB_USERNAME,
    LCRT_Q_LB_FIREWALL,
    LCRT_Q_LB_PORT,
    LCRT_Q_LB_FRAME,
    LCRT_Q_CB_PASSWD,
    LCRT_Q_CB_PUBLICKEY,
    LCRT_Q_CB_KEYBOARD,
    LCRT_Q_CB_GSSAPI,
    LCRT_Q_CB_RSA,
    LCRT_Q_CB_TIS,
    LCRT_Q_BT_PROPERTIES,
    LCRT_Q_CB_SHOW_QCONNECT,
    LCRT_Q_CB_SAVE_SESSION,
    LCRT_Q_CB_OPEN_IN_A_TAB,
    LCRT_Q_BT_CONNECT,
    LCRT_Q_BT_CANCEL,
    LCRT_Q_ERR_MSG,
    LCRT_Q_NUMBER
};
#define LCRT_Q_NAME \
    "q_connect", \
    "q_lb_protocol", \
    "q_lb_hostname", \
    "q_lb_username", \
    "q_lb_firewall", \
    "q_lb_port", \
    "q_lb_frame", \
    "q_cb_passwd", \
    "q_cb_publickey", \
    "q_cb_keyboard", \
    "q_cb_gssapi", \
    "q_cb_rsa", \
    "q_cb_tis", \
    "q_bt_properties", \
    "q_cb_show_qconnect", \
    "q_cb_save_session", \
    "q_cb_open_in_a_tab", \
    "q_bt_connect", \
    "q_bt_cancel", \
    "q_err_msg"

#define LCRT_Q_VALUE \
    "Quick connect", \
    "  Protocol:", \
    "  Hostname:", \
    "  Username:", \
    "  Firewall:", \
    "  Port: ", \
    "Authentication", \
    "Password", \
    "PublicKey", \
    "KeyBoard Interactive", \
    "GSSAPI", \
    "RSA", \
    "TIS", \
    "Properties...", \
    "Show Quick connect on startup", \
    "Save Session", \
    "Open in a tab", \
    "Connect", \
    "Cancel", \
    "There is no memory to create window"

#define LCRT_Q_SHORTCUT \
    {0, 0}

struct lcrtc_qconnect {
    struct lcrt_config db;
    const char *name[LCRT_Q_NUMBER];
    char value[LCRT_Q_NUMBER][LCRT_CONFIG_VALUE_LEN];
    int   shortcut[LCRT_Q_NUMBER][2];
};
struct lcrt_qconnect {
    struct lcrt_window *parent;
    gboolean tab;

    GtkWidget *q_connect;
   
    GtkWidget *q_cb_protocol;
    GtkWidget *q_et_hostname;
    GtkWidget *q_et_username;
    GtkWidget *q_cb_firewall;
    GtkWidget *q_et_port;

    GtkWidget *q_ssh_frame;
    GtkWidget *q_vbox_frame;
    GtkWidget *q_cb_passwd;
    /*SSH2*/
    GtkWidget *q_cb_publickey;
    GtkWidget *q_cb_keyboard;
    GtkWidget *q_cb_gssapi;
    /*SSH1*/
    GtkWidget *q_cb_rsa;
    GtkWidget *q_cb_tis;

    GtkWidget *q_bt_properties;
    GtkWidget *q_cb_show_qconnect;
    GtkWidget *q_cb_save_session;
    GtkWidget *q_cb_open_in_a_tab;
    GtkWidget *q_bt_connect;
    GtkWidget *q_bt_cancel;

    struct lcrtc_qconnect config;
    const char *(*get_db)(struct lcrt_qconnect *lqconnect);
    const char *(*get_tb)(struct lcrt_qconnect *lqconnect);
};

int lcrt_create_qconnect(struct lcrt_window *parent, GtkWindow *window, gboolean tab);
void lcrt_destroy_qconnect(struct lcrt_qconnect *lqconnect);
int lcrt_qconnect_create_ssh1(struct lcrt_qconnect *lqconnect);
int lcrt_qconnect_create_ssh2(struct lcrt_qconnect *lqconnect);
int lcrt_qconnect_destroy_ssh1(struct lcrt_qconnect *lqconnect);
int lcrt_qconnect_destroy_ssh2(struct lcrt_qconnect *lqconnect);

#endif
