/*
 * Copyright (C) 2005-2010 by CERN
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)$RCSfile: dlilogit.c,v $ $Revision: 4292 $ $Date: 2011-04-26 15:06:44 +0200 (Tue, 26 Apr 2011) $ CERN Jean-Philippe Baud";
#endif /* not lint */

#include <errno.h>
#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <sys/types.h>
#include <time.h>
#include <stdarg.h>
#include "Cglobals.h"
#include "dli_server.h"
extern int jid;
extern char logfile[];

dlilogit(char *func, char *msg, ...)
{
	va_list args;
	char prtbuf[LOGBUFSZ];
	int save_errno;
	int Tid = 0;
	struct tm *tm;
#if defined(_REENTRANT) || defined(_THREAD_SAFE)
	struct tm tmstruc;
#endif
	struct timeval tv;
	int fd_log;

	save_errno = errno;
	va_start (args, msg);
	(void) gettimeofday (&tv, NULL);
#if (defined(_REENTRANT) || defined(_THREAD_SAFE)) && !defined(_WIN32)
	(void) localtime_r (&tv.tv_sec, &tmstruc);
	tm = &tmstruc;
#else
	tm = localtime (&tv.tv_sec);
#endif
	Cglobals_getTid (&Tid);
	if (Tid < 0)	/* main thread */
		sprintf (prtbuf, "%02d/%02d %02d:%02d:%02d.%03d %5d %s: ",
		    tm->tm_mon+1, tm->tm_mday, tm->tm_hour, tm->tm_min, tm->tm_sec,
		    tv.tv_usec / 1000, jid, func);
	else
		sprintf (prtbuf, "%02d/%02d %02d:%02d:%02d.%03d %5d,%d %s: ",
		    tm->tm_mon+1, tm->tm_mday, tm->tm_hour, tm->tm_min, tm->tm_sec,
		    tv.tv_usec / 1000, jid, Tid, func);
	vsprintf (prtbuf+strlen(prtbuf), msg, args);
	va_end (args);
#ifdef O_LARGEFILE
	fd_log = open (logfile, O_WRONLY | O_CREAT | O_APPEND | O_LARGEFILE, 0664);
#else
	fd_log = open (logfile, O_WRONLY | O_CREAT | O_APPEND, 0664);
#endif
	write (fd_log, prtbuf, strlen(prtbuf));
	close (fd_log);
	errno = save_errno;
	return (0);
}
