#! /bin/sh

### BEGIN INIT INFO
# Provides:          lcd4linux
# Required-Start:    $remote_fs
# Required-Stop:     $remote_fs
# Should-Start:      $syslog
# Should-Stop:       $syslog
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: daemon for driving LCD based displays
# Description:       LCD4Linux is a small program that grabs information from
#                    the kernel and some subsystems and displays it on an
#                    external liquid crystal display.
### END INIT INFO

PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
DAEMON=/usr/sbin/lcd4linux
NAME=lcd4linux
DESC=lcd4linux

test -x $DAEMON || exit 0
test -f /etc/lcd4linux.conf || exit 0

test -f /etc/default/lcd4linux && . /etc/default/lcd4linux
DAEMON_OPTS="$ARGS"

set -e

case "$1" in
  start)
	echo -n "Starting $DESC: "
	chmod 600 /etc/lcd4linux.conf
	start-stop-daemon --start --quiet --pidfile /var/run/$NAME.pid \
		--exec $DAEMON -- $DAEMON_OPTS
	echo "$NAME."
	;;
  stop)
	echo -n "Stopping $DESC: "
	start-stop-daemon --stop --quiet --pidfile /var/run/$NAME.pid \
		--exec $DAEMON || true
	echo "$NAME."
	;;
  restart|force-reload)
	echo -n "Restarting $DESC: "
	start-stop-daemon --stop --quiet --pidfile \
		/var/run/$NAME.pid --exec $DAEMON
	sleep 1
	start-stop-daemon --start --quiet --pidfile \
		/var/run/$NAME.pid --exec $DAEMON -- $DAEMON_OPTS
	echo "$NAME."
	;;
  *)
	N=/etc/init.d/$NAME
	# echo "Usage: $N {start|stop|restart|reload|force-reload}" >&2
	echo "Usage: $N {start|stop|restart|force-reload}" >&2
	exit 1
	;;
esac

exit 0
