/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2009-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl> 
 *
 *  2007-2009
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 *  2003-2007
 *     Martijn Steenbakkers <martijn@nikhef.nl>
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 */


#ifndef LLGT_LCMAPS_H
#define LLGT_LCMAPS_H

#include <stdio.h>
#include <gssapi.h>

#include "llgt_config.h"

/*************************************************************************/
/* LCMAPS DEFAULTS							 */
/*************************************************************************/

/* Default db file is set in configure */

#ifndef LCMAPS_LOG_FILE
#define LCMAPS_LOG_FILE "/var/log/glexec/lcas_lcmaps.log"
#endif

#ifndef LCMAPS_DEBUG_LEVEL
#define LCMAPS_DEBUG_LEVEL   "4"
#endif

/* LCMAPS_LIBDIR is used to search the liblcmaps*.so files, when set to "", the
 * system default search path is used (ld.so.conf etc.) */
#ifndef LCMAPS_LIBDIR
#define LCMAPS_LIBDIR	""
#endif

#ifndef LCMAPS_POLICY_NAME
#define LCMAPS_POLICY_NAME  ""
#endif

/* Prototypes */

void llgt_setup_lcmaps_environment(void);
int llgt_run_lcmaps (gss_cred_id_t, char *, FILE *, char **);

#endif /* LLGT_LCMAPS_H */

