#!/bin/bash

names="test1 test2"

oneTimeSetUp() {
    set -u
    cp debian/tests/test*.f90 $AUTOPKGTEST_TMP
}

testSO() {
    cwd=$(pwd)
    cd $AUTOPKGTEST_TMP
    for name in $names
    do
        echo "Building."
        set -x
        gfortran -O3 -march=native -llbfgsb -o $name $name.f90
        ret=$?
        set +x
        assertEquals 0 $ret
        
        echo "Running."
        set -x
        ./$name
        ret=$?
        set +x
        assertEquals 0 $ret
    done
    cd $cwd
}

testStatic() {
    cwd=$(pwd)
    cd $AUTOPKGTEST_TMP
    for name in $names
    do
        echo "Building."
        set -x
        gfortran $name.f90 -O3 -march=native -static -llbfgsb -lblas -pthread -o $name-static
        ret=$?
        set +x
        assertEquals 0 $ret
        
        echo "Running."
        set -x
        ./$name-static
        ret=$?
        set +x
        assertEquals 0 $ret
    done
    cd $cwd
}

. shunit2
