#!/usr/bin/env python

import sys

from lazygal import pyexiv2api as pyexiv2

fn = sys.argv[1]

im = pyexiv2.ImageMetadata(fn.decode(sys.getfilesystemencoding()))
im.read()

tags = (
    'Exif.Photo.UserComment',
    'Exif.Image.ImageDescription',
    'Iptc.Application2.ObjectName',
    'Exif.Photo.DateTimeDigitized',
    'Exif.Photo.DateTimeOriginal',
    'Exif.Image.DateTime',
)

for tag in tags:
    try:
        val = im[tag].value
    except KeyError:
        val  = 'unset'
        pass
    print '%s: %s' % (tag, val)
