/* utils.c generated by valac 0.31.1.17-440e, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <latexila.h>
#include <gtk/gtk.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))



gchar* utils_str_middle_truncate (const gchar* str, guint max_length);
gboolean utils_char_is_escaped (const gchar* text, glong char_index);
const gchar* utils_get_string_from_resource (const gchar* resource_path);
gchar* utils_uri_get_dirname (const gchar* uri);
gchar* utils_get_dirname_for_display (GFile* location);
void utils_delete_file (GFile* file);
gboolean utils_save_file (GFile* file, const gchar* contents, gboolean make_backup);
gchar* utils_load_file (GFile* file);
gchar* utils_get_relative_path (GFile* origin, GFile* target, GFile* common_dir);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
gboolean utils_tree_model_iter_prev (GtkTreeModel* model, GtkTreeIter* iter);
gint utils_get_selected_row (GtkTreeView* view, GtkTreeIter* iter);
GtkWindow* utils_get_toplevel_window (GtkWidget* widget);
void utils_flush_queue (void);


/*************************************************************************/
static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


gchar* utils_str_middle_truncate (const gchar* str, guint max_length) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint _tmp3_ = 0U;
	guint half_length = 0U;
	guint _tmp6_ = 0U;
	gint l = 0;
	const gchar* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	const gchar* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	guint _tmp18_ = 0U;
	gint _tmp19_ = 0;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = str;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = max_length;
	if (((guint) _tmp2_) <= _tmp3_) {
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp4_ = str;
		_tmp5_ = g_strdup (_tmp4_);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = max_length;
	half_length = (_tmp6_ - 4) / 2;
	_tmp7_ = str;
	_tmp8_ = strlen (_tmp7_);
	_tmp9_ = _tmp8_;
	l = _tmp9_;
	_tmp10_ = str;
	_tmp11_ = half_length;
	_tmp12_ = string_slice (_tmp10_, (glong) 0, (glong) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp13_, "...", NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = str;
	_tmp17_ = l;
	_tmp18_ = half_length;
	_tmp19_ = l;
	_tmp20_ = string_slice (_tmp16_, (glong) (_tmp17_ - _tmp18_), (glong) _tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strconcat (_tmp15_, _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	_g_free0 (_tmp21_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	result = _tmp23_;
	return result;
}


static gboolean string_get_prev_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	if (0 < _tmp0_) {
		gint _tmp1_ = 0;
		gchar* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gunichar _tmp4_ = 0U;
		_tmp1_ = *index;
		_tmp2_ = g_utf8_prev_char (((gchar*) self) + _tmp1_);
		*index = (gint) (_tmp2_ - ((gchar*) self));
		_tmp3_ = *index;
		_tmp4_ = g_utf8_get_char (((gchar*) self) + _tmp3_);
		_vala_c = _tmp4_;
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		_vala_c = (gunichar) 0;
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


gboolean utils_char_is_escaped (const gchar* text, glong char_index) {
	gboolean result = FALSE;
	glong _tmp0_ = 0L;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean escaped = FALSE;
	gint index = 0;
	glong _tmp4_ = 0L;
	gunichar cur_char = 0U;
	g_return_val_if_fail (text != NULL, FALSE);
	_tmp0_ = char_index;
	_tmp1_ = text;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	g_return_val_if_fail (_tmp0_ < ((glong) _tmp3_), FALSE);
	escaped = FALSE;
	_tmp4_ = char_index;
	index = (gint) _tmp4_;
	while (TRUE) {
		const gchar* _tmp5_ = NULL;
		gunichar _tmp6_ = 0U;
		gboolean _tmp7_ = FALSE;
		gunichar _tmp8_ = 0U;
		gboolean _tmp9_ = FALSE;
		_tmp5_ = text;
		_tmp7_ = string_get_prev_char (_tmp5_, &index, &_tmp6_);
		cur_char = _tmp6_;
		if (!_tmp7_) {
			break;
		}
		_tmp8_ = cur_char;
		if (_tmp8_ != ((gunichar) '\\')) {
			break;
		}
		_tmp9_ = escaped;
		escaped = !_tmp9_;
	}
	result = escaped;
	return result;
}


const gchar* utils_get_string_from_resource (const gchar* resource_path) {
	const gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (resource_path != NULL, NULL);
	{
		GBytes* bytes = NULL;
		const gchar* _tmp0_ = NULL;
		GBytes* _tmp1_ = NULL;
		gsize _tmp2_;
		guint8* _tmp3_ = NULL;
		_tmp0_ = resource_path;
		_tmp1_ = g_resources_lookup_data (_tmp0_, 0, &_inner_error_);
		bytes = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch48_g_error;
		}
		_tmp3_ = g_bytes_get_data (bytes, &_tmp2_);
		result = (const gchar*) _tmp3_;
		_g_bytes_unref0 (bytes);
		return result;
	}
	goto __finally48;
	__catch48_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = resource_path;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("utils.vala:64: Failed to load data from resource '%s': %s", _tmp4_, _tmp6_);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally48:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


/*************************************************************************/
gchar* utils_uri_get_dirname (const gchar* uri) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* dir = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = uri;
	g_return_val_if_fail (_tmp0_ != NULL, NULL);
	_tmp1_ = uri;
	_tmp2_ = g_path_get_dirname (_tmp1_);
	dir = _tmp2_;
	_tmp3_ = dir;
	if (g_strcmp0 (_tmp3_, ".") == 0) {
		result = NULL;
		_g_free0 (dir);
		return result;
	}
	_tmp4_ = dir;
	_tmp5_ = latexila_utils_replace_home_dir_with_tilde (_tmp4_);
	result = _tmp5_;
	_g_free0 (dir);
	return result;
}


gchar* utils_get_dirname_for_display (GFile* location) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (location != NULL, NULL);
	{
		GMount* mount = NULL;
		GFile* _tmp0_ = NULL;
		GMount* _tmp1_ = NULL;
		gchar* mount_name = NULL;
		GMount* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* dirname = NULL;
		gchar* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		_tmp0_ = location;
		_tmp1_ = g_file_find_enclosing_mount (_tmp0_, NULL, &_inner_error_);
		mount = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch49_g_error;
		}
		_tmp2_ = mount;
		_tmp3_ = g_mount_get_name (_tmp2_);
		mount_name = _tmp3_;
		_tmp5_ = location;
		_tmp6_ = g_file_get_path (_tmp5_);
		_tmp4_ = _tmp6_;
		if (_tmp4_ == NULL) {
			GFile* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			_tmp7_ = location;
			_tmp8_ = g_file_get_uri (_tmp7_);
			_g_free0 (_tmp4_);
			_tmp4_ = _tmp8_;
		}
		_tmp9_ = utils_uri_get_dirname (_tmp4_);
		dirname = _tmp9_;
		_tmp11_ = dirname;
		if (_tmp11_ == NULL) {
			_tmp10_ = TRUE;
		} else {
			const gchar* _tmp12_ = NULL;
			_tmp12_ = dirname;
			_tmp10_ = g_strcmp0 (_tmp12_, ".") == 0;
		}
		if (_tmp10_) {
			result = mount_name;
			_g_free0 (dirname);
			_g_free0 (_tmp4_);
			_g_object_unref0 (mount);
			return result;
		}
		_tmp13_ = mount_name;
		_tmp14_ = g_strconcat (_tmp13_, " ", NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = dirname;
		_tmp17_ = g_strconcat (_tmp15_, _tmp16_, NULL);
		_tmp18_ = _tmp17_;
		_g_free0 (_tmp15_);
		result = _tmp18_;
		_g_free0 (dirname);
		_g_free0 (_tmp4_);
		_g_free0 (mount_name);
		_g_object_unref0 (mount);
		return result;
	}
	goto __finally49;
	__catch49_g_error:
	{
		GError* e = NULL;
		gchar* _tmp19_ = NULL;
		GFile* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp24_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp20_ = location;
		_tmp21_ = g_file_get_path (_tmp20_);
		_tmp19_ = _tmp21_;
		if (_tmp19_ == NULL) {
			GFile* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			_tmp22_ = location;
			_tmp23_ = g_file_get_uri (_tmp22_);
			_g_free0 (_tmp19_);
			_tmp19_ = _tmp23_;
		}
		_tmp24_ = utils_uri_get_dirname (_tmp19_);
		result = _tmp24_;
		_g_free0 (_tmp19_);
		_g_error_free0 (e);
		return result;
	}
	__finally49:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


void utils_delete_file (GFile* file) {
	GFile* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (file != NULL);
	_tmp0_ = file;
	_tmp1_ = g_file_query_exists (_tmp0_, NULL);
	if (!_tmp1_) {
		return;
	}
	{
		GFile* _tmp2_ = NULL;
		_tmp2_ = file;
		g_file_delete (_tmp2_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch50_g_error;
		}
	}
	goto __finally50;
	__catch50_g_error:
	{
		GError* e = NULL;
		GFile* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = file;
		_tmp4_ = g_file_get_parse_name (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("utils.vala:120: Delete file '%s' failed: %s", _tmp5_, _tmp7_);
		_g_free0 (_tmp5_);
		_g_error_free0 (e);
	}
	__finally50:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


gboolean utils_save_file (GFile* file, const gchar* contents, gboolean make_backup) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, FALSE);
	g_return_val_if_fail (contents != NULL, FALSE);
	{
		GFile* _tmp0_ = NULL;
		GFile* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		guint8* _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		guint8* _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		gboolean _tmp5_ = FALSE;
		_tmp0_ = file;
		latexila_utils_create_parent_directories (_tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch51_g_error;
		}
		_tmp1_ = file;
		_tmp2_ = contents;
		_tmp3_ = string_get_data (_tmp2_, &_tmp3__length1);
		_tmp4_ = _tmp3_;
		_tmp4__length1 = _tmp3__length1;
		_tmp5_ = make_backup;
		g_file_replace_contents (_tmp1_, _tmp4_, (gsize) _tmp4__length1, NULL, _tmp5_, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch51_g_error;
		}
	}
	goto __finally51;
	__catch51_g_error:
	{
		GError* e = NULL;
		GFile* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = file;
		_tmp7_ = g_file_get_parse_name (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("utils.vala:135: Failed to save the file '%s': %s", _tmp8_, _tmp10_);
		_g_free0 (_tmp8_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally51:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


gchar* utils_load_file (GFile* file) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	{
		guint8* chars = NULL;
		gint chars_length1 = 0;
		gint _chars_size_ = 0;
		GFile* _tmp0_ = NULL;
		guint8* _tmp1_ = NULL;
		gsize _tmp2_;
		guint8* _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		_tmp0_ = file;
		g_file_load_contents (_tmp0_, NULL, &_tmp1_, &_tmp2_, NULL, &_inner_error_);
		chars = (g_free (chars), NULL);
		chars = _tmp1_;
		chars_length1 = _tmp2_;
		_chars_size_ = chars_length1;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			chars = (g_free (chars), NULL);
			goto __catch52_g_error;
		}
		_tmp3_ = chars;
		_tmp3__length1 = chars_length1;
		chars = NULL;
		chars_length1 = 0;
		result = (gchar*) _tmp3_;
		chars = (g_free (chars), NULL);
		return result;
	}
	goto __finally52;
	__catch52_g_error:
	{
		GError* e = NULL;
		GFile* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = file;
		_tmp5_ = g_file_get_parse_name (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("utils.vala:154: Failed to load the file '%s': %s", _tmp6_, _tmp8_);
		_g_free0 (_tmp6_);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally52:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


gchar* utils_get_relative_path (GFile* origin, GFile* target, GFile* common_dir) {
	gchar* result = NULL;
	GFile* origin_dir = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GFile* target_parent = NULL;
	GFile* _tmp7_ = NULL;
	GFile* _tmp8_ = NULL;
	GFile* _tmp9_ = NULL;
	GFile* _tmp10_ = NULL;
	GFile* _tmp11_ = NULL;
	GFile* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	GList* target_dirs = NULL;
	GList* origin_dirs = NULL;
	guint dir_index = 0U;
	guint nb_common_dirs = 0U;
	guint _tmp53_ = 0U;
	gchar* relative_path = NULL;
	gchar* _tmp54_ = NULL;
	guint nb_remaining_origin_dirs = 0U;
	GList* _tmp55_ = NULL;
	guint _tmp56_ = 0U;
	guint _tmp57_ = 0U;
	const gchar* _tmp81_ = NULL;
	GFile* _tmp82_ = NULL;
	gchar* _tmp83_ = NULL;
	gchar* _tmp84_ = NULL;
	gchar* _tmp85_ = NULL;
	g_return_val_if_fail (origin != NULL, NULL);
	g_return_val_if_fail (target != NULL, NULL);
	g_return_val_if_fail (common_dir != NULL, NULL);
	_tmp0_ = origin;
	_tmp1_ = common_dir;
	_tmp2_ = g_file_equal (_tmp0_, _tmp1_);
	if (_tmp2_) {
		GFile* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		_tmp3_ = origin;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (origin_dir);
		origin_dir = _tmp4_;
	} else {
		GFile* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		_tmp5_ = origin;
		_tmp6_ = g_file_get_parent (_tmp5_);
		_g_object_unref0 (origin_dir);
		origin_dir = _tmp6_;
	}
	_tmp7_ = target;
	_tmp8_ = g_file_get_parent (_tmp7_);
	target_parent = _tmp8_;
	_tmp9_ = origin_dir;
	g_return_val_if_fail (_tmp9_ != NULL, NULL);
	_tmp10_ = target_parent;
	g_return_val_if_fail (_tmp10_ != NULL, NULL);
	_tmp11_ = target_parent;
	_tmp12_ = origin_dir;
	_tmp13_ = g_file_equal (_tmp11_, _tmp12_);
	if (_tmp13_) {
		GFile* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		_tmp14_ = target;
		_tmp15_ = g_file_get_basename (_tmp14_);
		result = _tmp15_;
		_g_object_unref0 (target_parent);
		_g_object_unref0 (origin_dir);
		return result;
	}
	target_dirs = NULL;
	origin_dirs = NULL;
	while (TRUE) {
		gboolean _tmp16_ = FALSE;
		GFile* _tmp17_ = NULL;
		GFile* _tmp21_ = NULL;
		GFile* _tmp22_ = NULL;
		GFile* _tmp23_ = NULL;
		GFile* _tmp24_ = NULL;
		_tmp17_ = target_parent;
		if (_tmp17_ != NULL) {
			GFile* _tmp18_ = NULL;
			GFile* _tmp19_ = NULL;
			gboolean _tmp20_ = FALSE;
			_tmp18_ = target_parent;
			_tmp19_ = common_dir;
			_tmp20_ = g_file_equal (_tmp18_, _tmp19_);
			_tmp16_ = !_tmp20_;
		} else {
			_tmp16_ = FALSE;
		}
		if (!_tmp16_) {
			break;
		}
		_tmp21_ = target_parent;
		_tmp22_ = _g_object_ref0 (_tmp21_);
		target_dirs = g_list_prepend (target_dirs, _tmp22_);
		_tmp23_ = target_parent;
		_tmp24_ = g_file_get_parent (_tmp23_);
		_g_object_unref0 (target_parent);
		target_parent = _tmp24_;
	}
	while (TRUE) {
		gboolean _tmp25_ = FALSE;
		GFile* _tmp26_ = NULL;
		GFile* _tmp30_ = NULL;
		GFile* _tmp31_ = NULL;
		GFile* _tmp32_ = NULL;
		GFile* _tmp33_ = NULL;
		_tmp26_ = origin_dir;
		if (_tmp26_ != NULL) {
			GFile* _tmp27_ = NULL;
			GFile* _tmp28_ = NULL;
			gboolean _tmp29_ = FALSE;
			_tmp27_ = origin_dir;
			_tmp28_ = common_dir;
			_tmp29_ = g_file_equal (_tmp27_, _tmp28_);
			_tmp25_ = !_tmp29_;
		} else {
			_tmp25_ = FALSE;
		}
		if (!_tmp25_) {
			break;
		}
		_tmp30_ = origin_dir;
		_tmp31_ = _g_object_ref0 (_tmp30_);
		origin_dirs = g_list_prepend (origin_dirs, _tmp31_);
		_tmp32_ = origin_dir;
		_tmp33_ = g_file_get_parent (_tmp32_);
		_g_object_unref0 (origin_dir);
		origin_dir = _tmp33_;
	}
	dir_index = (guint) 0;
	while (TRUE) {
		gboolean _tmp34_ = FALSE;
		guint _tmp35_ = 0U;
		GList* _tmp36_ = NULL;
		guint _tmp37_ = 0U;
		GFile* cur_target_dir = NULL;
		GList* _tmp41_ = NULL;
		guint _tmp42_ = 0U;
		gconstpointer _tmp43_ = NULL;
		GFile* _tmp44_ = NULL;
		GFile* cur_origin_dir = NULL;
		GList* _tmp45_ = NULL;
		guint _tmp46_ = 0U;
		gconstpointer _tmp47_ = NULL;
		GFile* _tmp48_ = NULL;
		GFile* _tmp49_ = NULL;
		GFile* _tmp50_ = NULL;
		gboolean _tmp51_ = FALSE;
		guint _tmp52_ = 0U;
		_tmp35_ = dir_index;
		_tmp36_ = target_dirs;
		_tmp37_ = g_list_length (_tmp36_);
		if (_tmp35_ < _tmp37_) {
			guint _tmp38_ = 0U;
			GList* _tmp39_ = NULL;
			guint _tmp40_ = 0U;
			_tmp38_ = dir_index;
			_tmp39_ = origin_dirs;
			_tmp40_ = g_list_length (_tmp39_);
			_tmp34_ = _tmp38_ < _tmp40_;
		} else {
			_tmp34_ = FALSE;
		}
		if (!_tmp34_) {
			break;
		}
		_tmp41_ = target_dirs;
		_tmp42_ = dir_index;
		_tmp43_ = g_list_nth_data (_tmp41_, _tmp42_);
		_tmp44_ = _g_object_ref0 ((GFile*) _tmp43_);
		cur_target_dir = _tmp44_;
		_tmp45_ = origin_dirs;
		_tmp46_ = dir_index;
		_tmp47_ = g_list_nth_data (_tmp45_, _tmp46_);
		_tmp48_ = _g_object_ref0 ((GFile*) _tmp47_);
		cur_origin_dir = _tmp48_;
		_tmp49_ = cur_target_dir;
		_tmp50_ = cur_origin_dir;
		_tmp51_ = g_file_equal (_tmp49_, _tmp50_);
		if (!_tmp51_) {
			_g_object_unref0 (cur_origin_dir);
			_g_object_unref0 (cur_target_dir);
			break;
		}
		_tmp52_ = dir_index;
		dir_index = _tmp52_ + 1;
		_g_object_unref0 (cur_origin_dir);
		_g_object_unref0 (cur_target_dir);
	}
	_tmp53_ = dir_index;
	nb_common_dirs = _tmp53_;
	_tmp54_ = g_strdup ("");
	relative_path = _tmp54_;
	_tmp55_ = origin_dirs;
	_tmp56_ = g_list_length (_tmp55_);
	_tmp57_ = nb_common_dirs;
	nb_remaining_origin_dirs = _tmp56_ - _tmp57_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp58_ = FALSE;
			_tmp58_ = TRUE;
			while (TRUE) {
				guint _tmp60_ = 0U;
				guint _tmp61_ = 0U;
				const gchar* _tmp62_ = NULL;
				gchar* _tmp63_ = NULL;
				if (!_tmp58_) {
					guint _tmp59_ = 0U;
					_tmp59_ = i;
					i = _tmp59_ + 1;
				}
				_tmp58_ = FALSE;
				_tmp60_ = i;
				_tmp61_ = nb_remaining_origin_dirs;
				if (!(_tmp60_ < _tmp61_)) {
					break;
				}
				_tmp62_ = relative_path;
				_tmp63_ = g_strconcat (_tmp62_, "../", NULL);
				_g_free0 (relative_path);
				relative_path = _tmp63_;
			}
		}
	}
	{
		guint i = 0U;
		guint _tmp64_ = 0U;
		_tmp64_ = nb_common_dirs;
		i = _tmp64_;
		{
			gboolean _tmp65_ = FALSE;
			_tmp65_ = TRUE;
			while (TRUE) {
				guint _tmp67_ = 0U;
				GList* _tmp68_ = NULL;
				guint _tmp69_ = 0U;
				GFile* cur_target_dir = NULL;
				GList* _tmp70_ = NULL;
				guint _tmp71_ = 0U;
				gconstpointer _tmp72_ = NULL;
				GFile* _tmp73_ = NULL;
				const gchar* _tmp74_ = NULL;
				GFile* _tmp75_ = NULL;
				gchar* _tmp76_ = NULL;
				gchar* _tmp77_ = NULL;
				gchar* _tmp78_ = NULL;
				gchar* _tmp79_ = NULL;
				gchar* _tmp80_ = NULL;
				if (!_tmp65_) {
					guint _tmp66_ = 0U;
					_tmp66_ = i;
					i = _tmp66_ + 1;
				}
				_tmp65_ = FALSE;
				_tmp67_ = i;
				_tmp68_ = target_dirs;
				_tmp69_ = g_list_length (_tmp68_);
				if (!(_tmp67_ < _tmp69_)) {
					break;
				}
				_tmp70_ = target_dirs;
				_tmp71_ = i;
				_tmp72_ = g_list_nth_data (_tmp70_, _tmp71_);
				_tmp73_ = _g_object_ref0 ((GFile*) _tmp72_);
				cur_target_dir = _tmp73_;
				_tmp74_ = relative_path;
				_tmp75_ = cur_target_dir;
				_tmp76_ = g_file_get_basename (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = g_strconcat (_tmp77_, "/", NULL);
				_tmp79_ = _tmp78_;
				_tmp80_ = g_strconcat (_tmp74_, _tmp79_, NULL);
				_g_free0 (relative_path);
				relative_path = _tmp80_;
				_g_free0 (_tmp79_);
				_g_free0 (_tmp77_);
				_g_object_unref0 (cur_target_dir);
			}
		}
	}
	_tmp81_ = relative_path;
	_tmp82_ = target;
	_tmp83_ = g_file_get_basename (_tmp82_);
	_tmp84_ = _tmp83_;
	_tmp85_ = g_strconcat (_tmp81_, _tmp84_, NULL);
	_g_free0 (relative_path);
	relative_path = _tmp85_;
	_g_free0 (_tmp84_);
	result = relative_path;
	__g_list_free__g_object_unref0_0 (origin_dirs);
	__g_list_free__g_object_unref0_0 (target_dirs);
	_g_object_unref0 (target_parent);
	_g_object_unref0 (origin_dir);
	return result;
}


/*************************************************************************/
GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child) {
	GtkScrolledWindow* result = NULL;
	GtkScrolledWindow* sw = NULL;
	GtkScrolledWindow* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	g_return_val_if_fail (child != NULL, NULL);
	_tmp0_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	sw = _tmp0_;
	_tmp1_ = child;
	gtk_container_add ((GtkContainer*) sw, _tmp1_);
	result = sw;
	return result;
}


gboolean utils_tree_model_iter_prev (GtkTreeModel* model, GtkTreeIter* iter) {
	gboolean result = FALSE;
	GtkTreePath* path = NULL;
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	GtkTreePath* _tmp2_ = NULL;
	GtkTreePath* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = model;
	_tmp1_ = *iter;
	_tmp2_ = gtk_tree_model_get_path (_tmp0_, &_tmp1_);
	path = _tmp2_;
	_tmp3_ = path;
	_tmp4_ = gtk_tree_path_prev (_tmp3_);
	if (_tmp4_) {
		gboolean ret = FALSE;
		GtkTreeModel* _tmp5_ = NULL;
		GtkTreePath* _tmp6_ = NULL;
		GtkTreeIter _tmp7_ = {0};
		gboolean _tmp8_ = FALSE;
		_tmp5_ = model;
		_tmp6_ = path;
		_tmp8_ = gtk_tree_model_get_iter (_tmp5_, &_tmp7_, _tmp6_);
		*iter = _tmp7_;
		ret = _tmp8_;
		result = ret;
		_gtk_tree_path_free0 (path);
		return result;
	}
	result = FALSE;
	_gtk_tree_path_free0 (path);
	return result;
}


gint utils_get_selected_row (GtkTreeView* view, GtkTreeIter* iter) {
	GtkTreeIter _vala_iter = {0};
	gint result = 0;
	GtkTreeSelection* select = NULL;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_ = NULL;
	GtkTreeSelection* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (view != NULL, 0);
	_tmp0_ = view;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	select = _tmp2_;
	_tmp3_ = select;
	_tmp5_ = gtk_tree_selection_get_selected (_tmp3_, NULL, &_tmp4_);
	_vala_iter = _tmp4_;
	if (_tmp5_) {
		GtkTreeModel* model = NULL;
		GtkTreeView* _tmp6_ = NULL;
		GtkTreeModel* _tmp7_ = NULL;
		GtkTreeModel* _tmp8_ = NULL;
		GtkTreePath* path = NULL;
		GtkTreeModel* _tmp9_ = NULL;
		GtkTreeIter _tmp10_ = {0};
		GtkTreePath* _tmp11_ = NULL;
		GtkTreePath* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		_tmp6_ = view;
		_tmp7_ = gtk_tree_view_get_model (_tmp6_);
		_tmp8_ = _g_object_ref0 (_tmp7_);
		model = _tmp8_;
		_tmp9_ = model;
		_tmp10_ = _vala_iter;
		_tmp11_ = gtk_tree_model_get_path (_tmp9_, &_tmp10_);
		path = _tmp11_;
		_tmp12_ = path;
		_tmp14_ = gtk_tree_path_get_indices_with_depth (_tmp12_, &_tmp13_);
		_tmp15_ = _tmp14_[0];
		result = _tmp15_;
		_gtk_tree_path_free0 (path);
		_g_object_unref0 (model);
		_g_object_unref0 (select);
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	result = -1;
	_g_object_unref0 (select);
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}


GtkWindow* utils_get_toplevel_window (GtkWidget* widget) {
	GtkWindow* result = NULL;
	GtkWidget* toplevel = NULL;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	g_return_val_if_fail (widget != NULL, NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_widget_get_toplevel (_tmp0_);
	toplevel = _tmp1_;
	_tmp2_ = toplevel;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_window_get_type ())) {
		GtkWidget* _tmp3_ = NULL;
		_tmp3_ = toplevel;
		result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp3_) : NULL;
		return result;
	}
	result = NULL;
	return result;
}


/*************************************************************************/
void utils_flush_queue (void) {
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		_tmp0_ = gtk_events_pending ();
		if (!_tmp0_) {
			break;
		}
		gtk_main_iteration ();
	}
}



