/* latex_post_processor.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from latex_post_processor.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gstdio.h>


#define TYPE_POST_PROCESSOR (post_processor_get_type ())
#define POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_POST_PROCESSOR, PostProcessor))
#define POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_POST_PROCESSOR, PostProcessorClass))
#define IS_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_POST_PROCESSOR))
#define IS_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_POST_PROCESSOR))
#define POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_POST_PROCESSOR, PostProcessorClass))

typedef struct _PostProcessor PostProcessor;
typedef struct _PostProcessorClass PostProcessorClass;
typedef struct _PostProcessorPrivate PostProcessorPrivate;

#define TYPE_BUILD_MSG (build_msg_get_type ())

#define TYPE_BUILD_MSG_TYPE (build_msg_type_get_type ())
typedef struct _BuildMsg BuildMsg;

#define TYPE_LATEX_POST_PROCESSOR (latex_post_processor_get_type ())
#define LATEX_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEX_POST_PROCESSOR, LatexPostProcessor))
#define LATEX_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEX_POST_PROCESSOR, LatexPostProcessorClass))
#define IS_LATEX_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEX_POST_PROCESSOR))
#define IS_LATEX_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEX_POST_PROCESSOR))
#define LATEX_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEX_POST_PROCESSOR, LatexPostProcessorClass))

typedef struct _LatexPostProcessor LatexPostProcessor;
typedef struct _LatexPostProcessorClass LatexPostProcessorClass;
typedef struct _LatexPostProcessorPrivate LatexPostProcessorPrivate;

#define LATEX_POST_PROCESSOR_TYPE_FILTER_STATUS (latex_post_processor_filter_status_get_type ())

#define LATEX_POST_PROCESSOR_TYPE_FILE_IN_STACK (latex_post_processor_file_in_stack_get_type ())
typedef struct _LatexPostProcessorFileInStack LatexPostProcessorFileInStack;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_slist_free__latex_post_processor_file_in_stack_free0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__latex_post_processor_file_in_stack_free0_ (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))

typedef enum  {
	BUILD_MSG_TYPE_TITLE,
	BUILD_MSG_TYPE_JOB_TITLE,
	BUILD_MSG_TYPE_JOB_SUB_COMMAND,
	BUILD_MSG_TYPE_ERROR,
	BUILD_MSG_TYPE_WARNING,
	BUILD_MSG_TYPE_BADBOX,
	BUILD_MSG_TYPE_INFO
} BuildMsgType;

struct _BuildMsg {
	BuildMsgType type;
	gchar* text;
	gchar* filename;
	gint start_line;
	gint end_line;
	gboolean expand;
	GeeList* children;
};

struct _PostProcessor {
	GObject parent_instance;
	PostProcessorPrivate * priv;
	GeeList* _all_messages;
	gboolean _has_details;
	GeeList* _messages_without_details;
};

struct _PostProcessorClass {
	GObjectClass parent_class;
	void (*process) (PostProcessor* self, GFile* file, const gchar* output);
};

struct _LatexPostProcessor {
	PostProcessor parent_instance;
	LatexPostProcessorPrivate * priv;
};

struct _LatexPostProcessorClass {
	PostProcessorClass parent_class;
};

typedef enum  {
	LATEX_POST_PROCESSOR_FILTER_STATUS_START,
	LATEX_POST_PROCESSOR_FILTER_STATUS_BADBOX,
	LATEX_POST_PROCESSOR_FILTER_STATUS_WARNING,
	LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR,
	LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR_SEARCH_LINE,
	LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME,
	LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME_HEURISTIC
} LatexPostProcessorFilterStatus;

struct _LatexPostProcessorFileInStack {
	gchar* filename;
	gboolean reliable;
	gboolean exists;
};

struct _LatexPostProcessorPrivate {
	BuildMsg msg;
	LatexPostProcessorFilterStatus status;
	gchar* line_buf;
	gint nb_lines;
	gchar* filename_buf;
	GSList* stack_files;
	gchar* directory_path;
	gint nb_badboxes;
	gint nb_warnings;
	gint nb_errors;
};


static gpointer latex_post_processor_parent_class = NULL;
static GRegex* latex_post_processor_reg_badbox;
static GRegex* latex_post_processor_reg_badbox = NULL;
static GRegex* latex_post_processor_reg_badbox_lines;
static GRegex* latex_post_processor_reg_badbox_lines = NULL;
static GRegex* latex_post_processor_reg_badbox_line;
static GRegex* latex_post_processor_reg_badbox_line = NULL;
static GRegex* latex_post_processor_reg_badbox_output;
static GRegex* latex_post_processor_reg_badbox_output = NULL;
static GRegex* latex_post_processor_reg_warning;
static GRegex* latex_post_processor_reg_warning = NULL;
static GRegex* latex_post_processor_reg_warning_no_file;
static GRegex* latex_post_processor_reg_warning_no_file = NULL;
static GRegex* latex_post_processor_reg_warning_line;
static GRegex* latex_post_processor_reg_warning_line = NULL;
static GRegex* latex_post_processor_reg_warning_international_line;
static GRegex* latex_post_processor_reg_warning_international_line = NULL;
static GRegex* latex_post_processor_reg_latex_error;
static GRegex* latex_post_processor_reg_latex_error = NULL;
static GRegex* latex_post_processor_reg_pdflatex_error;
static GRegex* latex_post_processor_reg_pdflatex_error = NULL;
static GRegex* latex_post_processor_reg_tex_error;
static GRegex* latex_post_processor_reg_tex_error = NULL;
static GRegex* latex_post_processor_reg_error_line;
static GRegex* latex_post_processor_reg_error_line = NULL;
static GRegex* latex_post_processor_reg_file_pop;
static GRegex* latex_post_processor_reg_file_pop = NULL;
static GRegex* latex_post_processor_reg_other_bytes;
static GRegex* latex_post_processor_reg_other_bytes = NULL;
static GRegex* latex_post_processor_reg_spaces;
static GRegex* latex_post_processor_reg_spaces = NULL;

GType post_processor_get_type (void) G_GNUC_CONST;
GType build_msg_get_type (void) G_GNUC_CONST;
GType build_msg_type_get_type (void) G_GNUC_CONST;
BuildMsg* build_msg_dup (const BuildMsg* self);
void build_msg_free (BuildMsg* self);
void build_msg_copy (const BuildMsg* self, BuildMsg* dest);
void build_msg_destroy (BuildMsg* self);
GType latex_post_processor_get_type (void) G_GNUC_CONST;
static GType latex_post_processor_filter_status_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType latex_post_processor_file_in_stack_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static LatexPostProcessorFileInStack* latex_post_processor_file_in_stack_dup (const LatexPostProcessorFileInStack* self);
static void latex_post_processor_file_in_stack_free (LatexPostProcessorFileInStack* self);
static void latex_post_processor_file_in_stack_copy (const LatexPostProcessorFileInStack* self, LatexPostProcessorFileInStack* dest);
static void latex_post_processor_file_in_stack_destroy (LatexPostProcessorFileInStack* self);
#define LATEX_POST_PROCESSOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LATEX_POST_PROCESSOR, LatexPostProcessorPrivate))
enum  {
	LATEX_POST_PROCESSOR_DUMMY_PROPERTY
};
static void _latex_post_processor_file_in_stack_free0_ (gpointer var);
static void _g_slist_free__latex_post_processor_file_in_stack_free0_ (GSList* self);
#define LATEX_POST_PROCESSOR_NO_LINE (-1)
LatexPostProcessor* latex_post_processor_new (void);
LatexPostProcessor* latex_post_processor_construct (GType object_type);
PostProcessor* post_processor_construct (GType object_type);
void build_msg_init (BuildMsg *self);
static void latex_post_processor_real_process (PostProcessor* base, GFile* file, const gchar* output);
static void latex_post_processor_latex_output_filter (LatexPostProcessor* self, const gchar* line);
static void latex_post_processor_add_msg (LatexPostProcessor* self, gboolean set_filename);
static gboolean latex_post_processor_detect_badbox (LatexPostProcessor* self, const gchar* line);
static gboolean latex_post_processor_detect_warning (LatexPostProcessor* self, const gchar* line);
static gboolean latex_post_processor_detect_error (LatexPostProcessor* self, const gchar* line);
static gboolean latex_post_processor_detect_other (LatexPostProcessor* self, const gchar* line);
static void latex_post_processor_update_stack_file (LatexPostProcessor* self, const gchar* line);
static gboolean latex_post_processor_detect_badbox_line (LatexPostProcessor* self, const gchar* badbox, gboolean current_line_is_empty);
static gboolean latex_post_processor_detect_warning_line (LatexPostProcessor* self, const gchar* warning, gboolean current_line_is_empty);
static void latex_post_processor_pop_file_from_stack (LatexPostProcessor* self);
static void latex_post_processor_update_stack_file_heuristic (LatexPostProcessor* self, const gchar* line);
static void latex_post_processor_push_file_on_stack (LatexPostProcessor* self, const gchar* filename, gboolean reliable);
static gboolean latex_post_processor_file_exists (LatexPostProcessor* self, const gchar* filename);
static gboolean latex_post_processor_top_file_on_stack_is_reliable (LatexPostProcessor* self);
static gchar* latex_post_processor_get_path_if_file_exists (LatexPostProcessor* self, const gchar* filename);
static gchar* latex_post_processor_get_current_filename (LatexPostProcessor* self);
static void latex_post_processor_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static GType latex_post_processor_filter_status_get_type (void) {
	static volatile gsize latex_post_processor_filter_status_type_id__volatile = 0;
	if (g_once_init_enter (&latex_post_processor_filter_status_type_id__volatile)) {
		static const GEnumValue values[] = {{LATEX_POST_PROCESSOR_FILTER_STATUS_START, "LATEX_POST_PROCESSOR_FILTER_STATUS_START", "start"}, {LATEX_POST_PROCESSOR_FILTER_STATUS_BADBOX, "LATEX_POST_PROCESSOR_FILTER_STATUS_BADBOX", "badbox"}, {LATEX_POST_PROCESSOR_FILTER_STATUS_WARNING, "LATEX_POST_PROCESSOR_FILTER_STATUS_WARNING", "warning"}, {LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR, "LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR", "error"}, {LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR_SEARCH_LINE, "LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR_SEARCH_LINE", "error-search-line"}, {LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME, "LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME", "filename"}, {LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME_HEURISTIC, "LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME_HEURISTIC", "filename-heuristic"}, {0, NULL, NULL}};
		GType latex_post_processor_filter_status_type_id;
		latex_post_processor_filter_status_type_id = g_enum_register_static ("LatexPostProcessorFilterStatus", values);
		g_once_init_leave (&latex_post_processor_filter_status_type_id__volatile, latex_post_processor_filter_status_type_id);
	}
	return latex_post_processor_filter_status_type_id__volatile;
}


static void _latex_post_processor_file_in_stack_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (latex_post_processor_file_in_stack_free (var), NULL));
}


static void _g_slist_free__latex_post_processor_file_in_stack_free0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _latex_post_processor_file_in_stack_free0_, NULL);
	g_slist_free (self);
}


LatexPostProcessor* latex_post_processor_construct (GType object_type) {
	LatexPostProcessor * self = NULL;
	GRegex* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	self = (LatexPostProcessor*) post_processor_construct (object_type);
	build_msg_destroy (&self->priv->msg);
	build_msg_init (&self->priv->msg);
	_tmp0_ = latex_post_processor_reg_badbox;
	if (_tmp0_ != NULL) {
		return self;
	}
	{
		GRegex* _tmp1_ = NULL;
		GRegex* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		GRegex* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		GRegex* _tmp7_ = NULL;
		GRegex* _tmp8_ = NULL;
		GRegex* _tmp9_ = NULL;
		GRegex* _tmp10_ = NULL;
		GRegex* _tmp11_ = NULL;
		GRegex* _tmp12_ = NULL;
		gchar* warning_str = NULL;
		gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		GRegex* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		GRegex* _tmp18_ = NULL;
		GRegex* _tmp19_ = NULL;
		GRegex* _tmp20_ = NULL;
		GRegex* _tmp21_ = NULL;
		GRegex* _tmp22_ = NULL;
		GRegex* _tmp23_ = NULL;
		GRegex* _tmp24_ = NULL;
		GRegex* _tmp25_ = NULL;
		GRegex* _tmp26_ = NULL;
		GRegex* _tmp27_ = NULL;
		GRegex* _tmp28_ = NULL;
		GRegex* _tmp29_ = NULL;
		GRegex* _tmp30_ = NULL;
		GRegex* _tmp31_ = NULL;
		GRegex* _tmp32_ = NULL;
		GRegex* _tmp33_ = NULL;
		GRegex* _tmp34_ = NULL;
		GRegex* _tmp35_ = NULL;
		GRegex* _tmp36_ = NULL;
		GRegex* _tmp37_ = NULL;
		GRegex* _tmp38_ = NULL;
		GRegex* _tmp39_ = NULL;
		GRegex* _tmp40_ = NULL;
		GRegex* _tmp41_ = NULL;
		GRegex* _tmp42_ = NULL;
		GRegex* _tmp43_ = NULL;
		GRegex* _tmp44_ = NULL;
		GRegex* _tmp45_ = NULL;
		GRegex* _tmp46_ = NULL;
		GRegex* _tmp47_ = NULL;
		GRegex* _tmp48_ = NULL;
		GRegex* _tmp49_ = NULL;
		_tmp2_ = g_regex_new ("^(Over|Under)full \\\\[hv]box", 0, 0, &_inner_error_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch34_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_regex_unref0 (latex_post_processor_reg_badbox);
		latex_post_processor_reg_badbox = _tmp3_;
		_tmp5_ = g_regex_new ("(.*) at lines (\\d+)--(\\d+)", 0, 0, &_inner_error_);
		_tmp4_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (_tmp1_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch34_g_regex_error;
			}
			_g_regex_unref0 (_tmp1_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = _tmp4_;
		_tmp4_ = NULL;
		_g_regex_unref0 (latex_post_processor_reg_badbox_lines);
		latex_post_processor_reg_badbox_lines = _tmp6_;
		_tmp8_ = g_regex_new ("(.*) at line (\\d+)", 0, 0, &_inner_error_);
		_tmp7_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (_tmp4_);
			_g_regex_unref0 (_tmp1_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch34_g_regex_error;
			}
			_g_regex_unref0 (_tmp4_);
			_g_regex_unref0 (_tmp1_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp7_;
		_tmp7_ = NULL;
		_g_regex_unref0 (latex_post_processor_reg_badbox_line);
		latex_post_processor_reg_badbox_line = _tmp9_;
		_tmp11_ = g_regex_new ("(.*)has occurred while \\\\output is active", 0, 0, &_inner_error_);
		_tmp10_ = _tmp11_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (_tmp7_);
			_g_regex_unref0 (_tmp4_);
			_g_regex_unref0 (_tmp1_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch34_g_regex_error;
			}
			_g_regex_unref0 (_tmp7_);
			_g_regex_unref0 (_tmp4_);
			_g_regex_unref0 (_tmp1_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = _tmp10_;
		_tmp10_ = NULL;
		_g_regex_unref0 (latex_post_processor_reg_badbox_output);
		latex_post_processor_reg_badbox_output = _tmp12_;
		_tmp13_ = g_strdup ("^(((! )?(La|pdf)TeX)|Package|Class)");
		warning_str = _tmp13_;
		_tmp14_ = warning_str;
		_tmp15_ = g_strconcat (_tmp14_, "(?P<name>.*) Warning[^:]*:\\s*(?P<contents>.*)", NULL);
		_g_free0 (warning_str);
		warning_str = _tmp15_;
		_tmp17_ = warning_str;
		_tmp18_ = g_regex_new (_tmp17_, G_REGEX_CASELESS | G_REGEX_OPTIMIZE, 0, &_inner_error_);
		_tmp16_ = _tmp18_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (warning_str);
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp7_);
			_g_regex_unref0 (_tmp4_);
			_g_regex_unref0 (_tmp1_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch34_g_regex_error;
			}
			_g_free0 (warning_str);
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp7_);
			_g_regex_unref0 (_tmp4_);
			_g_regex_unref0 (_tmp1_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp19_ = _tmp16_;
		_tmp16_ = NULL;
		_g_regex_unref0 (latex_post_processor_reg_warning);
		latex_post_processor_reg_warning = _tmp19_;
		_tmp21_ = g_regex_new ("(No file .*)", 0, 0, &_inner_error_);
		_tmp20_ = _tmp21_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (_tmp16_);
			_g_free0 (warning_str);
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp7_);
			_g_regex_unref0 (_tmp4_);
			_g_regex_unref0 (_tmp1_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch34_g_regex_error;
			}
			_g_regex_unref0 (_tmp16_);
			_g_free0 (warning_str);
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp7_);
			_g_regex_unref0 (_tmp4_);
			_g_regex_unref0 (_tmp1_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp22_ = _tmp20_;
		_tmp20_ = NULL;
		_g_regex_unref0 (latex_post_processor_reg_warning_no_file);
		latex_post_processor_reg_warning_no_file = _tmp22_;
		_tmp24_ = g_regex_new ("(.*) on input line (\\d+)\\.$", 0, 0, &_inner_error_);
		_tmp23_ = _tmp24_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (_tmp20_);
			_g_regex_unref0 (_tmp16_);
			_g_free0 (warning_str);
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp7_);
			_g_regex_unref0 (_tmp4_);
			_g_regex_unref0 (_tmp1_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch34_g_regex_error;
			}
			_g_regex_unref0 (_tmp20_);
			_g_regex_unref0 (_tmp16_);
			_g_free0 (warning_str);
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp7_);
			_g_regex_unref0 (_tmp4_);
			_g_regex_unref0 (_tmp1_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp25_ = _tmp23_;
		_tmp23_ = NULL;
		_g_regex_unref0 (latex_post_processor_reg_warning_line);
		latex_post_processor_reg_warning_line = _tmp25_;
		_tmp27_ = g_regex_new ("(.*)(\\d+)\\.$", 0, 0, &_inner_error_);
		_tmp26_ = _tmp27_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (_tmp23_);
			_g_regex_unref0 (_tmp20_);
			_g_regex_unref0 (_tmp16_);
			_g_free0 (warning_str);
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp7_);
			_g_regex_unref0 (_tmp4_);
			_g_regex_unref0 (_tmp1_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch34_g_regex_error;
			}
			_g_regex_unref0 (_tmp23_);
			_g_regex_unref0 (_tmp20_);
			_g_regex_unref0 (_tmp16_);
			_g_free0 (warning_str);
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp7_);
			_g_regex_unref0 (_tmp4_);
			_g_regex_unref0 (_tmp1_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp28_ = _tmp26_;
		_tmp26_ = NULL;
		_g_regex_unref0 (latex_post_processor_reg_warning_international_line);
		latex_post_processor_reg_warning_international_line = _tmp28_;
		_tmp30_ = g_regex_new ("^! LaTeX Error: (.*)$", 0, 0, &_inner_error_);
		_tmp29_ = _tmp30_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (_tmp26_);
			_g_regex_unref0 (_tmp23_);
			_g_regex_unref0 (_tmp20_);
			_g_regex_unref0 (_tmp16_);
			_g_free0 (warning_str);
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp7_);
			_g_regex_unref0 (_tmp4_);
			_g_regex_unref0 (_tmp1_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch34_g_regex_error;
			}
			_g_regex_unref0 (_tmp26_);
			_g_regex_unref0 (_tmp23_);
			_g_regex_unref0 (_tmp20_);
			_g_regex_unref0 (_tmp16_);
			_g_free0 (warning_str);
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp7_);
			_g_regex_unref0 (_tmp4_);
			_g_regex_unref0 (_tmp1_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp31_ = _tmp29_;
		_tmp29_ = NULL;
		_g_regex_unref0 (latex_post_processor_reg_latex_error);
		latex_post_processor_reg_latex_error = _tmp31_;
		_tmp33_ = g_regex_new ("^Error: pdflatex (.*)$", 0, 0, &_inner_error_);
		_tmp32_ = _tmp33_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (_tmp29_);
			_g_regex_unref0 (_tmp26_);
			_g_regex_unref0 (_tmp23_);
			_g_regex_unref0 (_tmp20_);
			_g_regex_unref0 (_tmp16_);
			_g_free0 (warning_str);
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp7_);
			_g_regex_unref0 (_tmp4_);
			_g_regex_unref0 (_tmp1_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch34_g_regex_error;
			}
			_g_regex_unref0 (_tmp29_);
			_g_regex_unref0 (_tmp26_);
			_g_regex_unref0 (_tmp23_);
			_g_regex_unref0 (_tmp20_);
			_g_regex_unref0 (_tmp16_);
			_g_free0 (warning_str);
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp7_);
			_g_regex_unref0 (_tmp4_);
			_g_regex_unref0 (_tmp1_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp34_ = _tmp32_;
		_tmp32_ = NULL;
		_g_regex_unref0 (latex_post_processor_reg_pdflatex_error);
		latex_post_processor_reg_pdflatex_error = _tmp34_;
		_tmp36_ = g_regex_new ("^! (.*)\\.$", 0, 0, &_inner_error_);
		_tmp35_ = _tmp36_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (_tmp32_);
			_g_regex_unref0 (_tmp29_);
			_g_regex_unref0 (_tmp26_);
			_g_regex_unref0 (_tmp23_);
			_g_regex_unref0 (_tmp20_);
			_g_regex_unref0 (_tmp16_);
			_g_free0 (warning_str);
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp7_);
			_g_regex_unref0 (_tmp4_);
			_g_regex_unref0 (_tmp1_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch34_g_regex_error;
			}
			_g_regex_unref0 (_tmp32_);
			_g_regex_unref0 (_tmp29_);
			_g_regex_unref0 (_tmp26_);
			_g_regex_unref0 (_tmp23_);
			_g_regex_unref0 (_tmp20_);
			_g_regex_unref0 (_tmp16_);
			_g_free0 (warning_str);
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp7_);
			_g_regex_unref0 (_tmp4_);
			_g_regex_unref0 (_tmp1_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp37_ = _tmp35_;
		_tmp35_ = NULL;
		_g_regex_unref0 (latex_post_processor_reg_tex_error);
		latex_post_processor_reg_tex_error = _tmp37_;
		_tmp39_ = g_regex_new ("^l\\.(\\d+)(.*)", 0, 0, &_inner_error_);
		_tmp38_ = _tmp39_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (_tmp35_);
			_g_regex_unref0 (_tmp32_);
			_g_regex_unref0 (_tmp29_);
			_g_regex_unref0 (_tmp26_);
			_g_regex_unref0 (_tmp23_);
			_g_regex_unref0 (_tmp20_);
			_g_regex_unref0 (_tmp16_);
			_g_free0 (warning_str);
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp7_);
			_g_regex_unref0 (_tmp4_);
			_g_regex_unref0 (_tmp1_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch34_g_regex_error;
			}
			_g_regex_unref0 (_tmp35_);
			_g_regex_unref0 (_tmp32_);
			_g_regex_unref0 (_tmp29_);
			_g_regex_unref0 (_tmp26_);
			_g_regex_unref0 (_tmp23_);
			_g_regex_unref0 (_tmp20_);
			_g_regex_unref0 (_tmp16_);
			_g_free0 (warning_str);
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp7_);
			_g_regex_unref0 (_tmp4_);
			_g_regex_unref0 (_tmp1_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp40_ = _tmp38_;
		_tmp38_ = NULL;
		_g_regex_unref0 (latex_post_processor_reg_error_line);
		latex_post_processor_reg_error_line = _tmp40_;
		_tmp42_ = g_regex_new ("(\\) )?:<-$", 0, 0, &_inner_error_);
		_tmp41_ = _tmp42_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (_tmp38_);
			_g_regex_unref0 (_tmp35_);
			_g_regex_unref0 (_tmp32_);
			_g_regex_unref0 (_tmp29_);
			_g_regex_unref0 (_tmp26_);
			_g_regex_unref0 (_tmp23_);
			_g_regex_unref0 (_tmp20_);
			_g_regex_unref0 (_tmp16_);
			_g_free0 (warning_str);
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp7_);
			_g_regex_unref0 (_tmp4_);
			_g_regex_unref0 (_tmp1_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch34_g_regex_error;
			}
			_g_regex_unref0 (_tmp38_);
			_g_regex_unref0 (_tmp35_);
			_g_regex_unref0 (_tmp32_);
			_g_regex_unref0 (_tmp29_);
			_g_regex_unref0 (_tmp26_);
			_g_regex_unref0 (_tmp23_);
			_g_regex_unref0 (_tmp20_);
			_g_regex_unref0 (_tmp16_);
			_g_free0 (warning_str);
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp7_);
			_g_regex_unref0 (_tmp4_);
			_g_regex_unref0 (_tmp1_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp43_ = _tmp41_;
		_tmp41_ = NULL;
		_g_regex_unref0 (latex_post_processor_reg_file_pop);
		latex_post_processor_reg_file_pop = _tmp43_;
		_tmp45_ = g_regex_new ("(?P<nb>\\d+) bytes", 0, 0, &_inner_error_);
		_tmp44_ = _tmp45_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (_tmp41_);
			_g_regex_unref0 (_tmp38_);
			_g_regex_unref0 (_tmp35_);
			_g_regex_unref0 (_tmp32_);
			_g_regex_unref0 (_tmp29_);
			_g_regex_unref0 (_tmp26_);
			_g_regex_unref0 (_tmp23_);
			_g_regex_unref0 (_tmp20_);
			_g_regex_unref0 (_tmp16_);
			_g_free0 (warning_str);
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp7_);
			_g_regex_unref0 (_tmp4_);
			_g_regex_unref0 (_tmp1_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch34_g_regex_error;
			}
			_g_regex_unref0 (_tmp41_);
			_g_regex_unref0 (_tmp38_);
			_g_regex_unref0 (_tmp35_);
			_g_regex_unref0 (_tmp32_);
			_g_regex_unref0 (_tmp29_);
			_g_regex_unref0 (_tmp26_);
			_g_regex_unref0 (_tmp23_);
			_g_regex_unref0 (_tmp20_);
			_g_regex_unref0 (_tmp16_);
			_g_free0 (warning_str);
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp7_);
			_g_regex_unref0 (_tmp4_);
			_g_regex_unref0 (_tmp1_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp46_ = _tmp44_;
		_tmp44_ = NULL;
		_g_regex_unref0 (latex_post_processor_reg_other_bytes);
		latex_post_processor_reg_other_bytes = _tmp46_;
		_tmp48_ = g_regex_new ("\\s{2,}", 0, 0, &_inner_error_);
		_tmp47_ = _tmp48_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (_tmp44_);
			_g_regex_unref0 (_tmp41_);
			_g_regex_unref0 (_tmp38_);
			_g_regex_unref0 (_tmp35_);
			_g_regex_unref0 (_tmp32_);
			_g_regex_unref0 (_tmp29_);
			_g_regex_unref0 (_tmp26_);
			_g_regex_unref0 (_tmp23_);
			_g_regex_unref0 (_tmp20_);
			_g_regex_unref0 (_tmp16_);
			_g_free0 (warning_str);
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp7_);
			_g_regex_unref0 (_tmp4_);
			_g_regex_unref0 (_tmp1_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch34_g_regex_error;
			}
			_g_regex_unref0 (_tmp44_);
			_g_regex_unref0 (_tmp41_);
			_g_regex_unref0 (_tmp38_);
			_g_regex_unref0 (_tmp35_);
			_g_regex_unref0 (_tmp32_);
			_g_regex_unref0 (_tmp29_);
			_g_regex_unref0 (_tmp26_);
			_g_regex_unref0 (_tmp23_);
			_g_regex_unref0 (_tmp20_);
			_g_regex_unref0 (_tmp16_);
			_g_free0 (warning_str);
			_g_regex_unref0 (_tmp10_);
			_g_regex_unref0 (_tmp7_);
			_g_regex_unref0 (_tmp4_);
			_g_regex_unref0 (_tmp1_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp49_ = _tmp47_;
		_tmp47_ = NULL;
		_g_regex_unref0 (latex_post_processor_reg_spaces);
		latex_post_processor_reg_spaces = _tmp49_;
		_g_regex_unref0 (_tmp47_);
		_g_regex_unref0 (_tmp44_);
		_g_regex_unref0 (_tmp41_);
		_g_regex_unref0 (_tmp38_);
		_g_regex_unref0 (_tmp35_);
		_g_regex_unref0 (_tmp32_);
		_g_regex_unref0 (_tmp29_);
		_g_regex_unref0 (_tmp26_);
		_g_regex_unref0 (_tmp23_);
		_g_regex_unref0 (_tmp20_);
		_g_regex_unref0 (_tmp16_);
		_g_free0 (warning_str);
		_g_regex_unref0 (_tmp10_);
		_g_regex_unref0 (_tmp7_);
		_g_regex_unref0 (_tmp4_);
		_g_regex_unref0 (_tmp1_);
	}
	goto __finally34;
	__catch34_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp50_ = NULL;
		const gchar* _tmp51_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp50_ = e;
		_tmp51_ = _tmp50_->message;
		g_warning ("latex_post_processor.vala:128: LatexPostProcessor: %s", _tmp51_);
		_g_error_free0 (e);
	}
	__finally34:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


LatexPostProcessor* latex_post_processor_new (void) {
	return latex_post_processor_construct (TYPE_LATEX_POST_PROCESSOR);
}


static void latex_post_processor_real_process (PostProcessor* base, GFile* file, const gchar* output) {
	LatexPostProcessor * self;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar** lines = NULL;
	const gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint lines_length1 = 0;
	gint _lines_size_ = 0;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	const gchar* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	const gchar* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	const gchar* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gchar* _tmp19_ = NULL;
	self = (LatexPostProcessor*) base;
	g_return_if_fail (file != NULL);
	g_return_if_fail (output != NULL);
	_tmp0_ = file;
	_tmp1_ = g_file_get_parent (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_get_parse_name (_tmp2_);
	_g_free0 (self->priv->directory_path);
	self->priv->directory_path = _tmp3_;
	_g_object_unref0 (_tmp2_);
	_tmp4_ = output;
	_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, "\n", 0);
	lines = _tmp6_;
	lines_length1 = _vala_array_length (_tmp5_);
	_lines_size_ = lines_length1;
	_tmp7_ = lines;
	_tmp7__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp7_;
		line_collection_length1 = _tmp7__length1;
		for (line_it = 0; line_it < _tmp7__length1; line_it = line_it + 1) {
			gchar* _tmp8_ = NULL;
			gchar* line = NULL;
			_tmp8_ = g_strdup (line_collection[line_it]);
			line = _tmp8_;
			{
				const gchar* _tmp9_ = NULL;
				_tmp9_ = line;
				latex_post_processor_latex_output_filter (self, _tmp9_);
				_g_free0 (line);
			}
		}
	}
	_tmp11_ = self->priv->nb_errors;
	if (_tmp11_ == 1) {
		_tmp10_ = "error";
	} else {
		_tmp10_ = "errors";
	}
	_tmp13_ = self->priv->nb_warnings;
	if (_tmp13_ == 1) {
		_tmp12_ = "warning";
	} else {
		_tmp12_ = "warnings";
	}
	_tmp15_ = self->priv->nb_badboxes;
	if (_tmp15_ == 1) {
		_tmp14_ = "badbox";
	} else {
		_tmp14_ = "badboxes";
	}
	_tmp16_ = self->priv->nb_errors;
	_tmp17_ = self->priv->nb_warnings;
	_tmp18_ = self->priv->nb_badboxes;
	_tmp19_ = g_strdup_printf ("%d %s, %d %s, %d %s", _tmp16_, _tmp10_, _tmp17_, _tmp12_, _tmp18_, _tmp14_);
	_g_free0 (self->priv->msg.text);
	self->priv->msg.text = _tmp19_;
	self->priv->msg.type = BUILD_MSG_TYPE_INFO;
	latex_post_processor_add_msg (self, FALSE);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
}


static void latex_post_processor_latex_output_filter (LatexPostProcessor* self, const gchar* line) {
	LatexPostProcessorFilterStatus _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	_tmp0_ = self->priv->status;
	switch (_tmp0_) {
		case LATEX_POST_PROCESSOR_FILTER_STATUS_START:
		{
			const gchar* _tmp1_ = NULL;
			gint _tmp2_ = 0;
			gint _tmp3_ = 0;
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_ = FALSE;
			const gchar* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
			_tmp1_ = line;
			_tmp2_ = strlen (_tmp1_);
			_tmp3_ = _tmp2_;
			if (_tmp3_ == 0) {
				return;
			}
			_tmp7_ = line;
			_tmp8_ = latex_post_processor_detect_badbox (self, _tmp7_);
			if (_tmp8_) {
				_tmp6_ = TRUE;
			} else {
				const gchar* _tmp9_ = NULL;
				gboolean _tmp10_ = FALSE;
				_tmp9_ = line;
				_tmp10_ = latex_post_processor_detect_warning (self, _tmp9_);
				_tmp6_ = _tmp10_;
			}
			if (_tmp6_) {
				_tmp5_ = TRUE;
			} else {
				const gchar* _tmp11_ = NULL;
				gboolean _tmp12_ = FALSE;
				_tmp11_ = line;
				_tmp12_ = latex_post_processor_detect_error (self, _tmp11_);
				_tmp5_ = _tmp12_;
			}
			if (_tmp5_) {
				_tmp4_ = TRUE;
			} else {
				const gchar* _tmp13_ = NULL;
				gboolean _tmp14_ = FALSE;
				_tmp13_ = line;
				_tmp14_ = latex_post_processor_detect_other (self, _tmp13_);
				_tmp4_ = _tmp14_;
			}
			if (!_tmp4_) {
				const gchar* _tmp15_ = NULL;
				_tmp15_ = line;
				latex_post_processor_update_stack_file (self, _tmp15_);
			}
			break;
		}
		case LATEX_POST_PROCESSOR_FILTER_STATUS_BADBOX:
		{
			const gchar* _tmp16_ = NULL;
			_tmp16_ = line;
			latex_post_processor_detect_badbox (self, _tmp16_);
			break;
		}
		case LATEX_POST_PROCESSOR_FILTER_STATUS_WARNING:
		{
			const gchar* _tmp17_ = NULL;
			_tmp17_ = line;
			latex_post_processor_detect_warning (self, _tmp17_);
			break;
		}
		case LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR:
		case LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR_SEARCH_LINE:
		{
			const gchar* _tmp18_ = NULL;
			_tmp18_ = line;
			latex_post_processor_detect_error (self, _tmp18_);
			break;
		}
		case LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME:
		case LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME_HEURISTIC:
		{
			const gchar* _tmp19_ = NULL;
			_tmp19_ = line;
			latex_post_processor_update_stack_file (self, _tmp19_);
			break;
		}
		default:
		{
			self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
			break;
		}
	}
}


static gboolean latex_post_processor_detect_badbox (LatexPostProcessor* self, const gchar* line) {
	gboolean result = FALSE;
	LatexPostProcessorFilterStatus _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_tmp0_ = self->priv->status;
	switch (_tmp0_) {
		case LATEX_POST_PROCESSOR_FILTER_STATUS_START:
		{
			GRegex* _tmp1_ = NULL;
			const gchar* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			const gchar* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
			_tmp1_ = latex_post_processor_reg_badbox;
			_tmp2_ = line;
			_tmp3_ = g_regex_match (_tmp1_, _tmp2_, 0, NULL);
			if (!_tmp3_) {
				result = FALSE;
				return result;
			}
			self->priv->msg.type = BUILD_MSG_TYPE_BADBOX;
			_tmp4_ = line;
			_tmp5_ = latex_post_processor_detect_badbox_line (self, _tmp4_, FALSE);
			if (_tmp5_) {
				latex_post_processor_add_msg (self, TRUE);
			} else {
				const gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				_tmp6_ = line;
				_tmp7_ = g_strdup (_tmp6_);
				_g_free0 (self->priv->line_buf);
				self->priv->line_buf = _tmp7_;
				_tmp8_ = self->priv->nb_lines;
				self->priv->nb_lines = _tmp8_ + 1;
			}
			result = TRUE;
			return result;
		}
		case LATEX_POST_PROCESSOR_FILTER_STATUS_BADBOX:
		{
			const gchar* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			gboolean _tmp17_ = FALSE;
			_tmp9_ = self->priv->line_buf;
			_tmp10_ = line;
			_tmp11_ = g_strconcat (_tmp9_, _tmp10_, NULL);
			_g_free0 (self->priv->line_buf);
			self->priv->line_buf = _tmp11_;
			_tmp12_ = self->priv->nb_lines;
			self->priv->nb_lines = _tmp12_ + 1;
			_tmp13_ = self->priv->line_buf;
			_tmp14_ = line;
			_tmp15_ = strlen (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = latex_post_processor_detect_badbox_line (self, _tmp13_, _tmp16_ == 0);
			if (_tmp17_) {
				latex_post_processor_add_msg (self, TRUE);
				self->priv->nb_lines = 0;
			}
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static gboolean latex_post_processor_detect_badbox_line (LatexPostProcessor* self, const gchar* badbox, gboolean current_line_is_empty) {
	gboolean result = FALSE;
	GRegex* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (badbox != NULL, FALSE);
	_tmp0_ = latex_post_processor_reg_badbox_lines;
	_tmp1_ = badbox;
	_tmp2_ = g_regex_match (_tmp0_, _tmp1_, 0, NULL);
	if (_tmp2_) {
		gchar** strings = NULL;
		GRegex* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar** _tmp5_ = NULL;
		gchar** _tmp6_ = NULL;
		gint strings_length1 = 0;
		gint _strings_size_ = 0;
		gchar** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gint n1 = 0;
		gchar** _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
		const gchar* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint n2 = 0;
		gchar** _tmp13_ = NULL;
		gint _tmp13__length1 = 0;
		const gchar* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
		_tmp3_ = latex_post_processor_reg_badbox_lines;
		_tmp4_ = badbox;
		_tmp6_ = _tmp5_ = g_regex_split (_tmp3_, _tmp4_, 0);
		strings = _tmp6_;
		strings_length1 = _vala_array_length (_tmp5_);
		_strings_size_ = strings_length1;
		_tmp7_ = strings;
		_tmp7__length1 = strings_length1;
		_tmp8_ = _tmp7_[1];
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (self->priv->msg.text);
		self->priv->msg.text = _tmp9_;
		_tmp10_ = strings;
		_tmp10__length1 = strings_length1;
		_tmp11_ = _tmp10_[2];
		_tmp12_ = atoi (_tmp11_);
		n1 = _tmp12_;
		_tmp13_ = strings;
		_tmp13__length1 = strings_length1;
		_tmp14_ = _tmp13_[3];
		_tmp15_ = atoi (_tmp14_);
		n2 = _tmp15_;
		_tmp16_ = n1;
		_tmp17_ = n2;
		if (_tmp16_ <= _tmp17_) {
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			_tmp18_ = n1;
			self->priv->msg.start_line = _tmp18_;
			_tmp19_ = n2;
			self->priv->msg.end_line = _tmp19_;
		} else {
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			_tmp20_ = n2;
			self->priv->msg.start_line = _tmp20_;
			_tmp21_ = n1;
			self->priv->msg.end_line = _tmp21_;
		}
		result = TRUE;
		strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
		return result;
	} else {
		GRegex* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gboolean _tmp24_ = FALSE;
		_tmp22_ = latex_post_processor_reg_badbox_line;
		_tmp23_ = badbox;
		_tmp24_ = g_regex_match (_tmp22_, _tmp23_, 0, NULL);
		if (_tmp24_) {
			gchar** strings = NULL;
			GRegex* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
			gchar** _tmp27_ = NULL;
			gchar** _tmp28_ = NULL;
			gint strings_length1 = 0;
			gint _strings_size_ = 0;
			gchar** _tmp29_ = NULL;
			gint _tmp29__length1 = 0;
			const gchar* _tmp30_ = NULL;
			gchar* _tmp31_ = NULL;
			gchar** _tmp32_ = NULL;
			gint _tmp32__length1 = 0;
			const gchar* _tmp33_ = NULL;
			gint _tmp34_ = 0;
			self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
			_tmp25_ = latex_post_processor_reg_badbox_line;
			_tmp26_ = badbox;
			_tmp28_ = _tmp27_ = g_regex_split (_tmp25_, _tmp26_, 0);
			strings = _tmp28_;
			strings_length1 = _vala_array_length (_tmp27_);
			_strings_size_ = strings_length1;
			_tmp29_ = strings;
			_tmp29__length1 = strings_length1;
			_tmp30_ = _tmp29_[1];
			_tmp31_ = g_strdup (_tmp30_);
			_g_free0 (self->priv->msg.text);
			self->priv->msg.text = _tmp31_;
			_tmp32_ = strings;
			_tmp32__length1 = strings_length1;
			_tmp33_ = _tmp32_[2];
			_tmp34_ = atoi (_tmp33_);
			self->priv->msg.start_line = _tmp34_;
			result = TRUE;
			strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
			return result;
		} else {
			GRegex* _tmp35_ = NULL;
			const gchar* _tmp36_ = NULL;
			gboolean _tmp37_ = FALSE;
			_tmp35_ = latex_post_processor_reg_badbox_output;
			_tmp36_ = badbox;
			_tmp37_ = g_regex_match (_tmp35_, _tmp36_, 0, NULL);
			if (_tmp37_) {
				gchar** strings = NULL;
				GRegex* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
				gchar** _tmp40_ = NULL;
				gchar** _tmp41_ = NULL;
				gint strings_length1 = 0;
				gint _strings_size_ = 0;
				gchar** _tmp42_ = NULL;
				gint _tmp42__length1 = 0;
				const gchar* _tmp43_ = NULL;
				gchar* _tmp44_ = NULL;
				self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
				_tmp38_ = latex_post_processor_reg_badbox_output;
				_tmp39_ = badbox;
				_tmp41_ = _tmp40_ = g_regex_split (_tmp38_, _tmp39_, 0);
				strings = _tmp41_;
				strings_length1 = _vala_array_length (_tmp40_);
				_strings_size_ = strings_length1;
				_tmp42_ = strings;
				_tmp42__length1 = strings_length1;
				_tmp43_ = _tmp42_[1];
				_tmp44_ = g_strdup (_tmp43_);
				_g_free0 (self->priv->msg.text);
				self->priv->msg.text = _tmp44_;
				self->priv->msg.start_line = LATEX_POST_PROCESSOR_NO_LINE;
				result = TRUE;
				strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
				return result;
			} else {
				gboolean _tmp45_ = FALSE;
				gint _tmp46_ = 0;
				_tmp46_ = self->priv->nb_lines;
				if (_tmp46_ > 4) {
					_tmp45_ = TRUE;
				} else {
					gboolean _tmp47_ = FALSE;
					_tmp47_ = current_line_is_empty;
					_tmp45_ = _tmp47_;
				}
				if (_tmp45_) {
					const gchar* _tmp48_ = NULL;
					gchar* _tmp49_ = NULL;
					self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
					_tmp48_ = badbox;
					_tmp49_ = g_strdup (_tmp48_);
					_g_free0 (self->priv->msg.text);
					self->priv->msg.text = _tmp49_;
					self->priv->msg.start_line = LATEX_POST_PROCESSOR_NO_LINE;
					result = TRUE;
					return result;
				}
			}
		}
	}
	self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_BADBOX;
	result = FALSE;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gboolean latex_post_processor_detect_warning (LatexPostProcessor* self, const gchar* line) {
	gboolean result = FALSE;
	LatexPostProcessorFilterStatus _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_tmp0_ = self->priv->status;
	switch (_tmp0_) {
		case LATEX_POST_PROCESSOR_FILTER_STATUS_START:
		{
			GMatchInfo* match_info = NULL;
			GRegex* _tmp1_ = NULL;
			const gchar* _tmp2_ = NULL;
			GMatchInfo* _tmp3_ = NULL;
			gboolean _tmp4_ = FALSE;
			_tmp1_ = latex_post_processor_reg_warning;
			_tmp2_ = line;
			_tmp4_ = g_regex_match (_tmp1_, _tmp2_, 0, &_tmp3_);
			_g_match_info_unref0 (match_info);
			match_info = _tmp3_;
			if (_tmp4_) {
				gchar* contents = NULL;
				GMatchInfo* _tmp5_ = NULL;
				gchar* _tmp6_ = NULL;
				gchar* name = NULL;
				GMatchInfo* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_ = NULL;
				gchar* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				const gchar* _tmp18_ = NULL;
				gboolean _tmp19_ = FALSE;
				self->priv->msg.type = BUILD_MSG_TYPE_WARNING;
				_tmp5_ = match_info;
				_tmp6_ = g_match_info_fetch_named (_tmp5_, "contents");
				contents = _tmp6_;
				_tmp7_ = match_info;
				_tmp8_ = g_match_info_fetch_named (_tmp7_, "name");
				_tmp9_ = _tmp8_;
				_tmp10_ = string_strip (_tmp9_);
				_tmp11_ = _tmp10_;
				_g_free0 (_tmp9_);
				name = _tmp11_;
				_tmp12_ = name;
				if (g_strcmp0 (_tmp12_, "") != 0) {
					const gchar* _tmp13_ = NULL;
					const gchar* _tmp14_ = NULL;
					const gchar* _tmp15_ = NULL;
					const gchar* _tmp16_ = NULL;
					gchar* _tmp17_ = NULL;
					_tmp13_ = name;
					_tmp14_ = string_to_string (_tmp13_);
					_tmp15_ = contents;
					_tmp16_ = string_to_string (_tmp15_);
					_tmp17_ = g_strconcat (_tmp14_, ": ", _tmp16_, NULL);
					_g_free0 (contents);
					contents = _tmp17_;
				}
				_tmp18_ = contents;
				_tmp19_ = latex_post_processor_detect_warning_line (self, _tmp18_, FALSE);
				if (_tmp19_) {
					latex_post_processor_add_msg (self, TRUE);
				} else {
					const gchar* _tmp20_ = NULL;
					gchar* _tmp21_ = NULL;
					gint _tmp22_ = 0;
					_tmp20_ = contents;
					_tmp21_ = g_strdup (_tmp20_);
					_g_free0 (self->priv->line_buf);
					self->priv->line_buf = _tmp21_;
					_tmp22_ = self->priv->nb_lines;
					self->priv->nb_lines = _tmp22_ + 1;
				}
				result = TRUE;
				_g_free0 (name);
				_g_free0 (contents);
				_g_match_info_unref0 (match_info);
				return result;
			} else {
				GRegex* _tmp23_ = NULL;
				const gchar* _tmp24_ = NULL;
				gboolean _tmp25_ = FALSE;
				_tmp23_ = latex_post_processor_reg_warning_no_file;
				_tmp24_ = line;
				_tmp25_ = g_regex_match (_tmp23_, _tmp24_, 0, NULL);
				if (_tmp25_) {
					gchar** strings = NULL;
					GRegex* _tmp26_ = NULL;
					const gchar* _tmp27_ = NULL;
					gchar** _tmp28_ = NULL;
					gchar** _tmp29_ = NULL;
					gint strings_length1 = 0;
					gint _strings_size_ = 0;
					gchar** _tmp30_ = NULL;
					gint _tmp30__length1 = 0;
					const gchar* _tmp31_ = NULL;
					gchar* _tmp32_ = NULL;
					self->priv->msg.type = BUILD_MSG_TYPE_WARNING;
					_tmp26_ = latex_post_processor_reg_warning_no_file;
					_tmp27_ = line;
					_tmp29_ = _tmp28_ = g_regex_split (_tmp26_, _tmp27_, 0);
					strings = _tmp29_;
					strings_length1 = _vala_array_length (_tmp28_);
					_strings_size_ = strings_length1;
					_tmp30_ = strings;
					_tmp30__length1 = strings_length1;
					_tmp31_ = _tmp30_[1];
					_tmp32_ = g_strdup (_tmp31_);
					_g_free0 (self->priv->msg.text);
					self->priv->msg.text = _tmp32_;
					self->priv->msg.start_line = LATEX_POST_PROCESSOR_NO_LINE;
					latex_post_processor_add_msg (self, TRUE);
					result = TRUE;
					strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
					_g_match_info_unref0 (match_info);
					return result;
				}
			}
			result = FALSE;
			_g_match_info_unref0 (match_info);
			return result;
		}
		case LATEX_POST_PROCESSOR_FILTER_STATUS_WARNING:
		{
			const gchar* _tmp33_ = NULL;
			const gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			gint _tmp36_ = 0;
			const gchar* _tmp37_ = NULL;
			const gchar* _tmp38_ = NULL;
			gint _tmp39_ = 0;
			gint _tmp40_ = 0;
			gboolean _tmp41_ = FALSE;
			_tmp33_ = self->priv->line_buf;
			_tmp34_ = line;
			_tmp35_ = g_strconcat (_tmp33_, _tmp34_, NULL);
			_g_free0 (self->priv->line_buf);
			self->priv->line_buf = _tmp35_;
			_tmp36_ = self->priv->nb_lines;
			self->priv->nb_lines = _tmp36_ + 1;
			_tmp37_ = self->priv->line_buf;
			_tmp38_ = line;
			_tmp39_ = strlen (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = latex_post_processor_detect_warning_line (self, _tmp37_, _tmp40_ == 0);
			if (_tmp41_) {
				latex_post_processor_add_msg (self, TRUE);
				self->priv->nb_lines = 0;
			}
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean latex_post_processor_detect_warning_line (LatexPostProcessor* self, const gchar* warning, gboolean current_line_is_empty) {
	gboolean result = FALSE;
	GRegex* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (warning != NULL, FALSE);
	_tmp0_ = latex_post_processor_reg_warning_line;
	_tmp1_ = warning;
	_tmp2_ = g_regex_match (_tmp0_, _tmp1_, 0, NULL);
	if (_tmp2_) {
		gchar** strings = NULL;
		GRegex* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar** _tmp5_ = NULL;
		gchar** _tmp6_ = NULL;
		gint strings_length1 = 0;
		gint _strings_size_ = 0;
		gchar** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar** _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
		const gchar* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
		_tmp3_ = latex_post_processor_reg_warning_line;
		_tmp4_ = warning;
		_tmp6_ = _tmp5_ = g_regex_split (_tmp3_, _tmp4_, 0);
		strings = _tmp6_;
		strings_length1 = _vala_array_length (_tmp5_);
		_strings_size_ = strings_length1;
		_tmp7_ = strings;
		_tmp7__length1 = strings_length1;
		_tmp8_ = _tmp7_[1];
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (self->priv->msg.text);
		self->priv->msg.text = _tmp9_;
		_tmp10_ = strings;
		_tmp10__length1 = strings_length1;
		_tmp11_ = _tmp10_[2];
		_tmp12_ = atoi (_tmp11_);
		self->priv->msg.start_line = _tmp12_;
		result = TRUE;
		strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
		return result;
	} else {
		GRegex* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		_tmp13_ = latex_post_processor_reg_warning_international_line;
		_tmp14_ = warning;
		_tmp15_ = g_regex_match (_tmp13_, _tmp14_, 0, NULL);
		if (_tmp15_) {
			gchar** strings = NULL;
			GRegex* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			gchar** _tmp18_ = NULL;
			gchar** _tmp19_ = NULL;
			gint strings_length1 = 0;
			gint _strings_size_ = 0;
			gchar** _tmp20_ = NULL;
			gint _tmp20__length1 = 0;
			const gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			gchar** _tmp23_ = NULL;
			gint _tmp23__length1 = 0;
			const gchar* _tmp24_ = NULL;
			gint _tmp25_ = 0;
			self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
			_tmp16_ = latex_post_processor_reg_warning_international_line;
			_tmp17_ = warning;
			_tmp19_ = _tmp18_ = g_regex_split (_tmp16_, _tmp17_, 0);
			strings = _tmp19_;
			strings_length1 = _vala_array_length (_tmp18_);
			_strings_size_ = strings_length1;
			_tmp20_ = strings;
			_tmp20__length1 = strings_length1;
			_tmp21_ = _tmp20_[1];
			_tmp22_ = g_strdup (_tmp21_);
			_g_free0 (self->priv->msg.text);
			self->priv->msg.text = _tmp22_;
			_tmp23_ = strings;
			_tmp23__length1 = strings_length1;
			_tmp24_ = _tmp23_[2];
			_tmp25_ = atoi (_tmp24_);
			self->priv->msg.start_line = _tmp25_;
			result = TRUE;
			strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
			return result;
		} else {
			const gchar* _tmp26_ = NULL;
			const gchar* _tmp27_ = NULL;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			gchar _tmp30_ = '\0';
			_tmp26_ = warning;
			_tmp27_ = warning;
			_tmp28_ = strlen (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = string_get (_tmp26_, (glong) (_tmp29_ - 1));
			if (_tmp30_ == '.') {
				const gchar* _tmp31_ = NULL;
				gchar* _tmp32_ = NULL;
				self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
				_tmp31_ = warning;
				_tmp32_ = g_strdup (_tmp31_);
				_g_free0 (self->priv->msg.text);
				self->priv->msg.text = _tmp32_;
				self->priv->msg.start_line = LATEX_POST_PROCESSOR_NO_LINE;
				result = TRUE;
				return result;
			} else {
				gboolean _tmp33_ = FALSE;
				gint _tmp34_ = 0;
				_tmp34_ = self->priv->nb_lines;
				if (_tmp34_ > 5) {
					_tmp33_ = TRUE;
				} else {
					gboolean _tmp35_ = FALSE;
					_tmp35_ = current_line_is_empty;
					_tmp33_ = _tmp35_;
				}
				if (_tmp33_) {
					const gchar* _tmp36_ = NULL;
					gchar* _tmp37_ = NULL;
					self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
					_tmp36_ = warning;
					_tmp37_ = g_strdup (_tmp36_);
					_g_free0 (self->priv->msg.text);
					self->priv->msg.text = _tmp37_;
					self->priv->msg.start_line = LATEX_POST_PROCESSOR_NO_LINE;
					result = TRUE;
					return result;
				}
			}
		}
	}
	self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_WARNING;
	result = FALSE;
	return result;
}


static gboolean latex_post_processor_detect_error (LatexPostProcessor* self, const gchar* line) {
	gboolean result = FALSE;
	LatexPostProcessorFilterStatus _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_tmp0_ = self->priv->status;
	switch (_tmp0_) {
		case LATEX_POST_PROCESSOR_FILTER_STATUS_START:
		{
			gboolean found = FALSE;
			gchar* tmp = NULL;
			GRegex* _tmp1_ = NULL;
			const gchar* _tmp2_ = NULL;
			gboolean _tmp3_ = FALSE;
			gboolean _tmp31_ = FALSE;
			found = TRUE;
			tmp = NULL;
			_tmp1_ = latex_post_processor_reg_latex_error;
			_tmp2_ = line;
			_tmp3_ = g_regex_match (_tmp1_, _tmp2_, 0, NULL);
			if (_tmp3_) {
				gchar** strings = NULL;
				GRegex* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				gchar** _tmp6_ = NULL;
				gchar** _tmp7_ = NULL;
				gint strings_length1 = 0;
				gint _strings_size_ = 0;
				gchar** _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				const gchar* _tmp9_ = NULL;
				gchar* _tmp10_ = NULL;
				_tmp4_ = latex_post_processor_reg_latex_error;
				_tmp5_ = line;
				_tmp7_ = _tmp6_ = g_regex_split (_tmp4_, _tmp5_, 0);
				strings = _tmp7_;
				strings_length1 = _vala_array_length (_tmp6_);
				_strings_size_ = strings_length1;
				_tmp8_ = strings;
				_tmp8__length1 = strings_length1;
				_tmp9_ = _tmp8_[1];
				_tmp10_ = g_strdup (_tmp9_);
				_g_free0 (tmp);
				tmp = _tmp10_;
				strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
			} else {
				GRegex* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				gboolean _tmp13_ = FALSE;
				_tmp11_ = latex_post_processor_reg_pdflatex_error;
				_tmp12_ = line;
				_tmp13_ = g_regex_match (_tmp11_, _tmp12_, 0, NULL);
				if (_tmp13_) {
					gchar** strings = NULL;
					GRegex* _tmp14_ = NULL;
					const gchar* _tmp15_ = NULL;
					gchar** _tmp16_ = NULL;
					gchar** _tmp17_ = NULL;
					gint strings_length1 = 0;
					gint _strings_size_ = 0;
					gchar** _tmp18_ = NULL;
					gint _tmp18__length1 = 0;
					const gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
					_tmp14_ = latex_post_processor_reg_pdflatex_error;
					_tmp15_ = line;
					_tmp17_ = _tmp16_ = g_regex_split (_tmp14_, _tmp15_, 0);
					strings = _tmp17_;
					strings_length1 = _vala_array_length (_tmp16_);
					_strings_size_ = strings_length1;
					_tmp18_ = strings;
					_tmp18__length1 = strings_length1;
					_tmp19_ = _tmp18_[1];
					_tmp20_ = g_strdup (_tmp19_);
					_g_free0 (tmp);
					tmp = _tmp20_;
					strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
				} else {
					GRegex* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					gboolean _tmp23_ = FALSE;
					_tmp21_ = latex_post_processor_reg_tex_error;
					_tmp22_ = line;
					_tmp23_ = g_regex_match (_tmp21_, _tmp22_, 0, NULL);
					if (_tmp23_) {
						gchar** strings = NULL;
						GRegex* _tmp24_ = NULL;
						const gchar* _tmp25_ = NULL;
						gchar** _tmp26_ = NULL;
						gchar** _tmp27_ = NULL;
						gint strings_length1 = 0;
						gint _strings_size_ = 0;
						gchar** _tmp28_ = NULL;
						gint _tmp28__length1 = 0;
						const gchar* _tmp29_ = NULL;
						gchar* _tmp30_ = NULL;
						_tmp24_ = latex_post_processor_reg_tex_error;
						_tmp25_ = line;
						_tmp27_ = _tmp26_ = g_regex_split (_tmp24_, _tmp25_, 0);
						strings = _tmp27_;
						strings_length1 = _vala_array_length (_tmp26_);
						_strings_size_ = strings_length1;
						_tmp28_ = strings;
						_tmp28__length1 = strings_length1;
						_tmp29_ = _tmp28_[1];
						_tmp30_ = g_strdup (_tmp29_);
						_g_free0 (tmp);
						tmp = _tmp30_;
						strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
					} else {
						found = FALSE;
					}
				}
			}
			_tmp31_ = found;
			if (_tmp31_) {
				gint _tmp32_ = 0;
				const gchar* _tmp33_ = NULL;
				const gchar* _tmp34_ = NULL;
				gint _tmp35_ = 0;
				gint _tmp36_ = 0;
				gchar _tmp37_ = '\0';
				_tmp32_ = self->priv->nb_lines;
				self->priv->nb_lines = _tmp32_ + 1;
				self->priv->msg.type = BUILD_MSG_TYPE_ERROR;
				_tmp33_ = line;
				_tmp34_ = line;
				_tmp35_ = strlen (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = string_get (_tmp33_, (glong) (_tmp36_ - 1));
				if (_tmp37_ == '.') {
					const gchar* _tmp38_ = NULL;
					gchar* _tmp39_ = NULL;
					_tmp38_ = tmp;
					_tmp39_ = g_strdup (_tmp38_);
					_g_free0 (self->priv->msg.text);
					self->priv->msg.text = _tmp39_;
					self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR_SEARCH_LINE;
				} else {
					const gchar* _tmp40_ = NULL;
					gchar* _tmp41_ = NULL;
					_tmp40_ = tmp;
					_tmp41_ = g_strdup (_tmp40_);
					_g_free0 (self->priv->line_buf);
					self->priv->line_buf = _tmp41_;
					self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR;
				}
				result = TRUE;
				_g_free0 (tmp);
				return result;
			}
			result = FALSE;
			_g_free0 (tmp);
			return result;
		}
		case LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR:
		{
			const gchar* _tmp42_ = NULL;
			const gchar* _tmp43_ = NULL;
			gchar* _tmp44_ = NULL;
			gint _tmp45_ = 0;
			const gchar* _tmp46_ = NULL;
			const gchar* _tmp47_ = NULL;
			gint _tmp48_ = 0;
			gint _tmp49_ = 0;
			gchar _tmp50_ = '\0';
			_tmp42_ = self->priv->line_buf;
			_tmp43_ = line;
			_tmp44_ = g_strconcat (_tmp42_, _tmp43_, NULL);
			_g_free0 (self->priv->line_buf);
			self->priv->line_buf = _tmp44_;
			_tmp45_ = self->priv->nb_lines;
			self->priv->nb_lines = _tmp45_ + 1;
			_tmp46_ = line;
			_tmp47_ = line;
			_tmp48_ = strlen (_tmp47_);
			_tmp49_ = _tmp48_;
			_tmp50_ = string_get (_tmp46_, (glong) (_tmp49_ - 1));
			if (_tmp50_ == '.') {
				const gchar* _tmp51_ = NULL;
				gchar* _tmp52_ = NULL;
				_tmp51_ = self->priv->line_buf;
				_tmp52_ = g_strdup (_tmp51_);
				_g_free0 (self->priv->msg.text);
				self->priv->msg.text = _tmp52_;
				self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR_SEARCH_LINE;
			} else {
				gint _tmp53_ = 0;
				_tmp53_ = self->priv->nb_lines;
				if (_tmp53_ > 4) {
					const gchar* _tmp54_ = NULL;
					gchar* _tmp55_ = NULL;
					_tmp54_ = self->priv->line_buf;
					_tmp55_ = g_strdup (_tmp54_);
					_g_free0 (self->priv->msg.text);
					self->priv->msg.text = _tmp55_;
					self->priv->msg.start_line = LATEX_POST_PROCESSOR_NO_LINE;
					latex_post_processor_add_msg (self, TRUE);
					self->priv->nb_lines = 0;
					self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
				}
			}
			result = TRUE;
			return result;
		}
		case LATEX_POST_PROCESSOR_FILTER_STATUS_ERROR_SEARCH_LINE:
		{
			gint _tmp56_ = 0;
			GRegex* _tmp57_ = NULL;
			const gchar* _tmp58_ = NULL;
			gboolean _tmp59_ = FALSE;
			_tmp56_ = self->priv->nb_lines;
			self->priv->nb_lines = _tmp56_ + 1;
			_tmp57_ = latex_post_processor_reg_error_line;
			_tmp58_ = line;
			_tmp59_ = g_regex_match (_tmp57_, _tmp58_, 0, NULL);
			if (_tmp59_) {
				gchar** strings = NULL;
				GRegex* _tmp60_ = NULL;
				const gchar* _tmp61_ = NULL;
				gchar** _tmp62_ = NULL;
				gchar** _tmp63_ = NULL;
				gint strings_length1 = 0;
				gint _strings_size_ = 0;
				gchar** _tmp64_ = NULL;
				gint _tmp64__length1 = 0;
				const gchar* _tmp65_ = NULL;
				gint _tmp66_ = 0;
				_tmp60_ = latex_post_processor_reg_error_line;
				_tmp61_ = line;
				_tmp63_ = _tmp62_ = g_regex_split (_tmp60_, _tmp61_, 0);
				strings = _tmp63_;
				strings_length1 = _vala_array_length (_tmp62_);
				_strings_size_ = strings_length1;
				_tmp64_ = strings;
				_tmp64__length1 = strings_length1;
				_tmp65_ = _tmp64_[1];
				_tmp66_ = atoi (_tmp65_);
				self->priv->msg.start_line = _tmp66_;
				latex_post_processor_add_msg (self, TRUE);
				self->priv->nb_lines = 0;
				self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
				result = TRUE;
				strings = (_vala_array_free (strings, strings_length1, (GDestroyNotify) g_free), NULL);
				return result;
			} else {
				gint _tmp67_ = 0;
				_tmp67_ = self->priv->nb_lines;
				if (_tmp67_ > 11) {
					self->priv->msg.start_line = LATEX_POST_PROCESSOR_NO_LINE;
					latex_post_processor_add_msg (self, TRUE);
					self->priv->nb_lines = 0;
					self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
					result = TRUE;
					return result;
				}
			}
			break;
		}
		default:
		{
			break;
		}
	}
	result = FALSE;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	const gchar* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoll (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static gboolean latex_post_processor_detect_other (LatexPostProcessor* self, const gchar* line) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GMatchInfo* match_info = NULL;
	GRegex* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GMatchInfo* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gchar* nb_bytes_str = NULL;
	GMatchInfo* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gint64 nb_bytes = 0LL;
	const gchar* _tmp11_ = NULL;
	gint64 _tmp12_ = 0LL;
	gchar* human_size = NULL;
	gint64 _tmp13_ = 0LL;
	gchar* _tmp14_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_tmp0_ = line;
	_tmp1_ = string_contains (_tmp0_, "Output written on");
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	self->priv->msg.start_line = LATEX_POST_PROCESSOR_NO_LINE;
	self->priv->msg.type = BUILD_MSG_TYPE_INFO;
	_tmp2_ = latex_post_processor_reg_other_bytes;
	_tmp3_ = line;
	_tmp5_ = g_regex_match (_tmp2_, _tmp3_, 0, &_tmp4_);
	_g_match_info_unref0 (match_info);
	match_info = _tmp4_;
	if (!_tmp5_) {
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp6_ = line;
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (self->priv->msg.text);
		self->priv->msg.text = _tmp7_;
		latex_post_processor_add_msg (self, FALSE);
		result = TRUE;
		_g_match_info_unref0 (match_info);
		return result;
	}
	_tmp8_ = match_info;
	_tmp9_ = g_match_info_fetch_named (_tmp8_, "nb");
	nb_bytes_str = _tmp9_;
	_tmp10_ = nb_bytes_str;
	g_return_val_if_fail (_tmp10_ != NULL, FALSE);
	_tmp11_ = nb_bytes_str;
	_tmp12_ = int64_parse (_tmp11_);
	nb_bytes = _tmp12_;
	_tmp13_ = nb_bytes;
	_tmp14_ = g_format_size_full ((guint64) _tmp13_, G_FORMAT_SIZE_DEFAULT);
	human_size = _tmp14_;
	{
		gchar* new_line = NULL;
		GRegex* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		_tmp15_ = latex_post_processor_reg_other_bytes;
		_tmp16_ = line;
		_tmp17_ = human_size;
		_tmp18_ = g_regex_replace_literal (_tmp15_, _tmp16_, (gssize) (-1), 0, _tmp17_, 0, &_inner_error_);
		new_line = _tmp18_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch35_g_regex_error;
			}
			_g_free0 (human_size);
			_g_free0 (nb_bytes_str);
			_g_match_info_unref0 (match_info);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp19_ = new_line;
		_tmp20_ = g_strdup (_tmp19_);
		_g_free0 (self->priv->msg.text);
		self->priv->msg.text = _tmp20_;
		_g_free0 (new_line);
	}
	goto __finally35;
	__catch35_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp21_ = e;
		_tmp22_ = _tmp21_->message;
		g_warning ("latex_post_processor.vala:511: LaTeX post processor: %s", _tmp22_);
		_tmp23_ = line;
		_tmp24_ = g_strdup (_tmp23_);
		_g_free0 (self->priv->msg.text);
		self->priv->msg.text = _tmp24_;
		_g_error_free0 (e);
	}
	__finally35:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (human_size);
		_g_free0 (nb_bytes_str);
		_g_match_info_unref0 (match_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	latex_post_processor_add_msg (self, FALSE);
	result = TRUE;
	_g_free0 (human_size);
	_g_free0 (nb_bytes_str);
	_g_match_info_unref0 (match_info);
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static void latex_post_processor_update_stack_file (LatexPostProcessor* self, const gchar* line) {
	LatexPostProcessorFilterStatus _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	_tmp0_ = self->priv->status;
	switch (_tmp0_) {
		case LATEX_POST_PROCESSOR_FILTER_STATUS_START:
		case LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME_HEURISTIC:
		{
			const gchar* _tmp1_ = NULL;
			gboolean _tmp2_ = FALSE;
			_tmp1_ = line;
			_tmp2_ = g_str_has_prefix (_tmp1_, ":<+ ");
			if (_tmp2_) {
				const gchar* _tmp3_ = NULL;
				gchar* _tmp4_ = NULL;
				gchar* _tmp5_ = NULL;
				gchar* _tmp6_ = NULL;
				_tmp3_ = line;
				_tmp4_ = string_substring (_tmp3_, (glong) 4, (glong) (-1));
				_tmp5_ = _tmp4_;
				_tmp6_ = string_strip (_tmp5_);
				_g_free0 (self->priv->filename_buf);
				self->priv->filename_buf = _tmp6_;
				_g_free0 (_tmp5_);
				self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME;
			} else {
				gboolean _tmp7_ = FALSE;
				GRegex* _tmp8_ = NULL;
				const gchar* _tmp9_ = NULL;
				gboolean _tmp10_ = FALSE;
				_tmp8_ = latex_post_processor_reg_file_pop;
				_tmp9_ = line;
				_tmp10_ = g_regex_match (_tmp8_, _tmp9_, 0, NULL);
				if (_tmp10_) {
					_tmp7_ = TRUE;
				} else {
					const gchar* _tmp11_ = NULL;
					gboolean _tmp12_ = FALSE;
					_tmp11_ = line;
					_tmp12_ = g_str_has_prefix (_tmp11_, ":<-");
					_tmp7_ = _tmp12_;
				}
				if (_tmp7_) {
					latex_post_processor_pop_file_from_stack (self);
				} else {
					const gchar* _tmp13_ = NULL;
					_tmp13_ = line;
					latex_post_processor_update_stack_file_heuristic (self, _tmp13_);
				}
			}
			break;
		}
		case LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME:
		{
			gboolean _tmp14_ = FALSE;
			const gchar* _tmp15_ = NULL;
			gchar _tmp16_ = '\0';
			_tmp15_ = line;
			_tmp16_ = string_get (_tmp15_, (glong) 0);
			if (_tmp16_ == '(') {
				_tmp14_ = TRUE;
			} else {
				const gchar* _tmp17_ = NULL;
				gboolean _tmp18_ = FALSE;
				_tmp17_ = line;
				_tmp18_ = g_str_has_prefix (_tmp17_, "\\openout");
				_tmp14_ = _tmp18_;
			}
			if (_tmp14_) {
				const gchar* _tmp19_ = NULL;
				_tmp19_ = self->priv->filename_buf;
				latex_post_processor_push_file_on_stack (self, _tmp19_, TRUE);
				self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
			} else {
				const gchar* _tmp20_ = NULL;
				gchar _tmp21_ = '\0';
				_tmp20_ = line;
				_tmp21_ = string_get (_tmp20_, (glong) 0);
				if (_tmp21_ == '!') {
					const gchar* _tmp22_ = NULL;
					self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
					_tmp22_ = line;
					latex_post_processor_detect_error (self, _tmp22_);
				} else {
					const gchar* _tmp23_ = NULL;
					gboolean _tmp24_ = FALSE;
					_tmp23_ = line;
					_tmp24_ = g_str_has_prefix (_tmp23_, "No file");
					if (_tmp24_) {
						const gchar* _tmp25_ = NULL;
						self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
						_tmp25_ = line;
						latex_post_processor_detect_warning (self, _tmp25_);
					} else {
						const gchar* _tmp26_ = NULL;
						const gchar* _tmp27_ = NULL;
						gchar* _tmp28_ = NULL;
						gchar* _tmp29_ = NULL;
						gchar* _tmp30_ = NULL;
						_tmp26_ = self->priv->filename_buf;
						_tmp27_ = line;
						_tmp28_ = string_strip (_tmp27_);
						_tmp29_ = _tmp28_;
						_tmp30_ = g_strconcat (_tmp26_, _tmp29_, NULL);
						_g_free0 (self->priv->filename_buf);
						self->priv->filename_buf = _tmp30_;
						_g_free0 (_tmp29_);
					}
				}
			}
			break;
		}
		default:
		{
			break;
		}
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static void latex_post_processor_update_stack_file_heuristic (LatexPostProcessor* self, const gchar* line) {
	gboolean expect_filename = FALSE;
	LatexPostProcessorFilterStatus _tmp0_ = 0;
	gint index = 0;
	glong length = 0L;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	_tmp0_ = self->priv->status;
	expect_filename = _tmp0_ == LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME_HEURISTIC;
	index = 0;
	_tmp1_ = line;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	length = (glong) _tmp3_;
	_tmp6_ = expect_filename;
	if (_tmp6_) {
		glong _tmp7_ = 0L;
		_tmp7_ = length;
		_tmp5_ = _tmp7_ > ((glong) 0);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		const gchar* _tmp8_ = NULL;
		gchar _tmp9_ = '\0';
		_tmp8_ = line;
		_tmp9_ = string_get (_tmp8_, (glong) 0);
		_tmp4_ = _tmp9_ == ')';
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		const gchar* _tmp10_ = NULL;
		_tmp10_ = self->priv->filename_buf;
		latex_post_processor_push_file_on_stack (self, _tmp10_, FALSE);
		expect_filename = FALSE;
		self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gint _tmp13_ = 0;
				glong _tmp14_ = 0L;
				gboolean is_last_char = FALSE;
				gboolean next_is_terminator = FALSE;
				gboolean _tmp15_ = FALSE;
				gboolean _tmp28_ = FALSE;
				gboolean _tmp29_ = FALSE;
				if (!_tmp11_) {
					gint _tmp12_ = 0;
					_tmp12_ = i;
					i = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp13_ = i;
				_tmp14_ = length;
				if (!(((glong) _tmp13_) < _tmp14_)) {
					break;
				}
				is_last_char = FALSE;
				next_is_terminator = FALSE;
				_tmp15_ = expect_filename;
				if (_tmp15_) {
					gint _tmp16_ = 0;
					glong _tmp17_ = 0L;
					gboolean _tmp18_ = FALSE;
					gboolean _tmp19_ = FALSE;
					_tmp16_ = i;
					_tmp17_ = length;
					is_last_char = ((glong) (_tmp16_ + 1)) == _tmp17_;
					_tmp19_ = is_last_char;
					if (_tmp19_) {
						_tmp18_ = FALSE;
					} else {
						gboolean _tmp20_ = FALSE;
						const gchar* _tmp21_ = NULL;
						gint _tmp22_ = 0;
						gchar _tmp23_ = '\0';
						gboolean _tmp24_ = FALSE;
						_tmp21_ = line;
						_tmp22_ = i;
						_tmp23_ = string_get (_tmp21_, (glong) (_tmp22_ + 1));
						_tmp24_ = g_ascii_isspace (_tmp23_);
						if (_tmp24_) {
							_tmp20_ = TRUE;
						} else {
							const gchar* _tmp25_ = NULL;
							gint _tmp26_ = 0;
							gchar _tmp27_ = '\0';
							_tmp25_ = line;
							_tmp26_ = i;
							_tmp27_ = string_get (_tmp25_, (glong) (_tmp26_ + 1));
							_tmp20_ = _tmp27_ == ')';
						}
						_tmp18_ = _tmp20_;
					}
					next_is_terminator = _tmp18_;
				}
				_tmp29_ = is_last_char;
				if (_tmp29_) {
					_tmp28_ = TRUE;
				} else {
					gboolean _tmp30_ = FALSE;
					_tmp30_ = next_is_terminator;
					_tmp28_ = _tmp30_;
				}
				if (_tmp28_) {
					const gchar* _tmp31_ = NULL;
					const gchar* _tmp32_ = NULL;
					gint _tmp33_ = 0;
					gint _tmp34_ = 0;
					gchar* _tmp35_ = NULL;
					gchar* _tmp36_ = NULL;
					gchar* _tmp37_ = NULL;
					const gchar* _tmp38_ = NULL;
					gint _tmp39_ = 0;
					gint _tmp40_ = 0;
					gboolean _tmp41_ = FALSE;
					gboolean _tmp42_ = FALSE;
					gboolean _tmp43_ = FALSE;
					gboolean _tmp44_ = FALSE;
					_tmp31_ = self->priv->filename_buf;
					_tmp32_ = line;
					_tmp33_ = index;
					_tmp34_ = i;
					_tmp35_ = string_slice (_tmp32_, (glong) _tmp33_, (glong) (_tmp34_ + 1));
					_tmp36_ = _tmp35_;
					_tmp37_ = g_strconcat (_tmp31_, _tmp36_, NULL);
					_g_free0 (self->priv->filename_buf);
					self->priv->filename_buf = _tmp37_;
					_g_free0 (_tmp36_);
					_tmp38_ = self->priv->filename_buf;
					_tmp39_ = strlen (_tmp38_);
					_tmp40_ = _tmp39_;
					if (_tmp40_ == 0) {
						continue;
					}
					_tmp44_ = is_last_char;
					if (_tmp44_) {
						gint _tmp45_ = 0;
						_tmp45_ = i;
						_tmp43_ = _tmp45_ < 78;
					} else {
						_tmp43_ = FALSE;
					}
					if (_tmp43_) {
						_tmp42_ = TRUE;
					} else {
						gboolean _tmp46_ = FALSE;
						_tmp46_ = next_is_terminator;
						_tmp42_ = _tmp46_;
					}
					if (_tmp42_) {
						_tmp41_ = TRUE;
					} else {
						const gchar* _tmp47_ = NULL;
						gboolean _tmp48_ = FALSE;
						_tmp47_ = self->priv->filename_buf;
						_tmp48_ = latex_post_processor_file_exists (self, _tmp47_);
						_tmp41_ = _tmp48_;
					}
					if (_tmp41_) {
						const gchar* _tmp49_ = NULL;
						_tmp49_ = self->priv->filename_buf;
						latex_post_processor_push_file_on_stack (self, _tmp49_, FALSE);
						expect_filename = FALSE;
						self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
					} else {
						gboolean _tmp50_ = FALSE;
						_tmp50_ = is_last_char;
						if (_tmp50_) {
							const gchar* _tmp51_ = NULL;
							gboolean _tmp52_ = FALSE;
							_tmp51_ = self->priv->filename_buf;
							_tmp52_ = latex_post_processor_file_exists (self, _tmp51_);
							if (_tmp52_) {
								const gchar* _tmp53_ = NULL;
								_tmp53_ = self->priv->filename_buf;
								latex_post_processor_push_file_on_stack (self, _tmp53_, FALSE);
								expect_filename = FALSE;
								self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
							} else {
								self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_FILENAME_HEURISTIC;
							}
						} else {
							gchar* _tmp54_ = NULL;
							self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
							_tmp54_ = g_strdup ("");
							_g_free0 (self->priv->filename_buf);
							self->priv->filename_buf = _tmp54_;
							expect_filename = FALSE;
						}
					}
				} else {
					const gchar* _tmp55_ = NULL;
					gint _tmp56_ = 0;
					gchar _tmp57_ = '\0';
					_tmp55_ = line;
					_tmp56_ = i;
					_tmp57_ = string_get (_tmp55_, (glong) _tmp56_);
					if (_tmp57_ == '(') {
						gchar* _tmp58_ = NULL;
						gint _tmp59_ = 0;
						self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
						_tmp58_ = g_strdup ("");
						_g_free0 (self->priv->filename_buf);
						self->priv->filename_buf = _tmp58_;
						expect_filename = TRUE;
						_tmp59_ = i;
						index = _tmp59_ + 1;
					} else {
						gboolean _tmp60_ = FALSE;
						gboolean _tmp61_ = FALSE;
						const gchar* _tmp62_ = NULL;
						gint _tmp63_ = 0;
						gchar _tmp64_ = '\0';
						_tmp62_ = line;
						_tmp63_ = i;
						_tmp64_ = string_get (_tmp62_, (glong) _tmp63_);
						if (_tmp64_ == ')') {
							GSList* _tmp65_ = NULL;
							guint _tmp66_ = 0U;
							_tmp65_ = self->priv->stack_files;
							_tmp66_ = g_slist_length (_tmp65_);
							_tmp61_ = _tmp66_ > ((guint) 0);
						} else {
							_tmp61_ = FALSE;
						}
						if (_tmp61_) {
							gboolean _tmp67_ = FALSE;
							_tmp67_ = latex_post_processor_top_file_on_stack_is_reliable (self);
							_tmp60_ = !_tmp67_;
						} else {
							_tmp60_ = FALSE;
						}
						if (_tmp60_) {
							latex_post_processor_pop_file_from_stack (self);
						}
					}
				}
			}
		}
	}
}


static gboolean latex_post_processor_file_exists (LatexPostProcessor* self, const gchar* filename) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	_tmp0_ = filename;
	_tmp1_ = latex_post_processor_get_path_if_file_exists (self, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_free0 (_tmp2_);
	result = _tmp3_;
	return result;
}


static gchar* latex_post_processor_get_path_if_file_exists (LatexPostProcessor* self, const gchar* filename) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* full_path = NULL;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	gchar** extensions = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar** _tmp23_ = NULL;
	gint extensions_length1 = 0;
	gint _extensions_size_ = 0;
	gchar** _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = filename;
	_tmp1_ = g_path_is_absolute (_tmp0_);
	if (_tmp1_) {
		const gchar* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = filename;
		_tmp3_ = g_file_test (_tmp2_, G_FILE_TEST_IS_REGULAR);
		if (_tmp3_) {
			const gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			_tmp4_ = filename;
			_tmp5_ = g_strdup (_tmp4_);
			result = _tmp5_;
			return result;
		} else {
			result = NULL;
			return result;
		}
	}
	_tmp6_ = filename;
	_tmp7_ = g_str_has_prefix (_tmp6_, "./");
	if (_tmp7_) {
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		_tmp8_ = self->priv->directory_path;
		_tmp9_ = filename;
		_tmp10_ = string_substring (_tmp9_, (glong) 2, (glong) (-1));
		_tmp11_ = _tmp10_;
		_tmp12_ = g_build_filename (_tmp8_, _tmp11_, NULL, NULL);
		_g_free0 (full_path);
		full_path = _tmp12_;
		_g_free0 (_tmp11_);
	} else {
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		_tmp13_ = self->priv->directory_path;
		_tmp14_ = filename;
		_tmp15_ = g_build_filename (_tmp13_, _tmp14_, NULL, NULL);
		_g_free0 (full_path);
		full_path = _tmp15_;
	}
	_tmp16_ = full_path;
	_tmp17_ = g_file_test (_tmp16_, G_FILE_TEST_IS_REGULAR);
	if (_tmp17_) {
		result = full_path;
		return result;
	}
	_tmp18_ = g_strdup (".tex");
	_tmp19_ = g_strdup (".ltx");
	_tmp20_ = g_strdup (".latex");
	_tmp21_ = g_strdup (".dtx");
	_tmp22_ = g_strdup (".ins");
	_tmp23_ = g_new0 (gchar*, 5 + 1);
	_tmp23_[0] = _tmp18_;
	_tmp23_[1] = _tmp19_;
	_tmp23_[2] = _tmp20_;
	_tmp23_[3] = _tmp21_;
	_tmp23_[4] = _tmp22_;
	extensions = _tmp23_;
	extensions_length1 = 5;
	_extensions_size_ = extensions_length1;
	_tmp24_ = extensions;
	_tmp24__length1 = extensions_length1;
	{
		gchar** ext_collection = NULL;
		gint ext_collection_length1 = 0;
		gint _ext_collection_size_ = 0;
		gint ext_it = 0;
		ext_collection = _tmp24_;
		ext_collection_length1 = _tmp24__length1;
		for (ext_it = 0; ext_it < _tmp24__length1; ext_it = ext_it + 1) {
			gchar* _tmp25_ = NULL;
			gchar* ext = NULL;
			_tmp25_ = g_strdup (ext_collection[ext_it]);
			ext = _tmp25_;
			{
				gchar* path_with_ext = NULL;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_ = NULL;
				gchar* _tmp28_ = NULL;
				const gchar* _tmp29_ = NULL;
				gboolean _tmp30_ = FALSE;
				_tmp26_ = full_path;
				_tmp27_ = ext;
				_tmp28_ = g_strconcat (_tmp26_, _tmp27_, NULL);
				path_with_ext = _tmp28_;
				_tmp29_ = path_with_ext;
				_tmp30_ = g_file_test (_tmp29_, G_FILE_TEST_IS_REGULAR);
				if (_tmp30_) {
					result = path_with_ext;
					_g_free0 (ext);
					extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (full_path);
					return result;
				}
				_g_free0 (path_with_ext);
				_g_free0 (ext);
			}
		}
	}
	result = NULL;
	extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (full_path);
	return result;
}


static gchar* latex_post_processor_get_current_filename (LatexPostProcessor* self) {
	gchar* result = NULL;
	GSList* stack_file = NULL;
	GSList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->stack_files;
	stack_file = _tmp0_;
	while (TRUE) {
		GSList* _tmp1_ = NULL;
		LatexPostProcessorFileInStack file = {0};
		GSList* _tmp2_ = NULL;
		gconstpointer _tmp3_ = NULL;
		LatexPostProcessorFileInStack _tmp4_ = {0};
		LatexPostProcessorFileInStack _tmp5_ = {0};
		gboolean _tmp6_ = FALSE;
		GSList* _tmp10_ = NULL;
		GSList* _tmp11_ = NULL;
		_tmp1_ = stack_file;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = stack_file;
		_tmp3_ = _tmp2_->data;
		latex_post_processor_file_in_stack_copy ((LatexPostProcessorFileInStack*) _tmp3_, &_tmp4_);
		file = _tmp4_;
		_tmp5_ = file;
		_tmp6_ = _tmp5_.exists;
		if (_tmp6_) {
			LatexPostProcessorFileInStack _tmp7_ = {0};
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			_tmp7_ = file;
			_tmp8_ = _tmp7_.filename;
			_tmp9_ = g_strdup (_tmp8_);
			result = _tmp9_;
			latex_post_processor_file_in_stack_destroy (&file);
			return result;
		}
		_tmp10_ = stack_file;
		_tmp11_ = _tmp10_->next;
		stack_file = _tmp11_;
		latex_post_processor_file_in_stack_destroy (&file);
	}
	result = NULL;
	return result;
}


static gpointer _latex_post_processor_file_in_stack_dup0 (gpointer self) {
	return self ? latex_post_processor_file_in_stack_dup (self) : NULL;
}


static void latex_post_processor_push_file_on_stack (LatexPostProcessor* self, const gchar* filename, gboolean reliable) {
	LatexPostProcessorFileInStack file = {0};
	gboolean _tmp0_ = FALSE;
	gchar* clean_filename = NULL;
	gchar* bad_suffix = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gchar* path = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	LatexPostProcessorFileInStack _tmp19_ = {0};
	LatexPostProcessorFileInStack _tmp20_ = {0};
	LatexPostProcessorFileInStack* _tmp21_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	memset (&file, 0, sizeof (LatexPostProcessorFileInStack));
	_tmp0_ = reliable;
	file.reliable = _tmp0_;
	_tmp1_ = g_strdup ("pdfTeX");
	bad_suffix = _tmp1_;
	_tmp2_ = filename;
	_tmp3_ = bad_suffix;
	_tmp4_ = g_str_has_suffix (_tmp2_, _tmp3_);
	if (_tmp4_) {
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gchar* _tmp9_ = NULL;
		_tmp5_ = filename;
		_tmp6_ = bad_suffix;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = string_slice (_tmp5_, (glong) 0, (glong) (-_tmp8_));
		_g_free0 (clean_filename);
		clean_filename = _tmp9_;
	} else {
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp10_ = filename;
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (clean_filename);
		clean_filename = _tmp11_;
	}
	_tmp12_ = clean_filename;
	_tmp13_ = latex_post_processor_get_path_if_file_exists (self, _tmp12_);
	path = _tmp13_;
	_tmp14_ = path;
	if (_tmp14_ != NULL) {
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		_tmp15_ = path;
		_tmp16_ = g_strdup (_tmp15_);
		_g_free0 (file.filename);
		file.filename = _tmp16_;
		file.exists = TRUE;
	} else {
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		_tmp17_ = clean_filename;
		_tmp18_ = g_strdup (_tmp17_);
		_g_free0 (file.filename);
		file.filename = _tmp18_;
		file.exists = FALSE;
	}
	_tmp19_ = file;
	_tmp20_ = _tmp19_;
	_tmp21_ = _latex_post_processor_file_in_stack_dup0 (&_tmp20_);
	self->priv->stack_files = g_slist_prepend (self->priv->stack_files, _tmp21_);
	_g_free0 (path);
	_g_free0 (bad_suffix);
	_g_free0 (clean_filename);
	latex_post_processor_file_in_stack_destroy (&file);
}


static void latex_post_processor_pop_file_from_stack (LatexPostProcessor* self) {
	GSList* _tmp0_ = NULL;
	GSList* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack_files;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->stack_files;
	_tmp2_ = _tmp1_->data;
	self->priv->stack_files = g_slist_remove (self->priv->stack_files, (LatexPostProcessorFileInStack*) _tmp2_);
}


static gboolean latex_post_processor_top_file_on_stack_is_reliable (LatexPostProcessor* self) {
	gboolean result = FALSE;
	GSList* _tmp0_ = NULL;
	GSList* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->stack_files;
	g_return_val_if_fail (_tmp0_ != NULL, TRUE);
	_tmp1_ = self->priv->stack_files;
	_tmp2_ = _tmp1_->data;
	_tmp3_ = (*((LatexPostProcessorFileInStack*) _tmp2_)).reliable;
	result = _tmp3_;
	return result;
}


static void latex_post_processor_add_msg (LatexPostProcessor* self, gboolean set_filename) {
	gboolean _tmp0_ = FALSE;
	BuildMsg _tmp1_ = {0};
	BuildMsgType _tmp2_ = 0;
	gboolean _tmp5_ = FALSE;
	BuildMsg _tmp15_ = {0};
	BuildMsgType _tmp16_ = 0;
	GeeList* _tmp20_ = NULL;
	BuildMsg _tmp21_ = {0};
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->msg;
	_tmp2_ = _tmp1_.type;
	if (_tmp2_ == BUILD_MSG_TYPE_WARNING) {
		BuildMsg _tmp3_ = {0};
		const gchar* _tmp4_ = NULL;
		_tmp3_ = self->priv->msg;
		_tmp4_ = _tmp3_.text;
		_tmp0_ = g_strcmp0 (_tmp4_, "There were undefined references.") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		build_msg_destroy (&self->priv->msg);
		build_msg_init (&self->priv->msg);
		return;
	}
	_tmp5_ = set_filename;
	if (_tmp5_) {
		gchar* _tmp6_ = NULL;
		_tmp6_ = latex_post_processor_get_current_filename (self);
		_g_free0 (self->priv->msg.filename);
		self->priv->msg.filename = _tmp6_;
	}
	{
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_ = NULL;
		BuildMsg _tmp9_ = {0};
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		_tmp8_ = latex_post_processor_reg_spaces;
		_tmp9_ = self->priv->msg;
		_tmp10_ = _tmp9_.text;
		_tmp11_ = g_regex_replace (_tmp8_, _tmp10_, (gssize) (-1), 0, " ", 0, &_inner_error_);
		_tmp7_ = _tmp11_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch36_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp12_ = _tmp7_;
		_tmp7_ = NULL;
		_g_free0 (self->priv->msg.text);
		self->priv->msg.text = _tmp12_;
		_g_free0 (_tmp7_);
	}
	goto __finally36;
	__catch36_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("latex_post_processor.vala:809: Latex post processor: %s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally36:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp15_ = self->priv->msg;
	_tmp16_ = _tmp15_.type;
	switch (_tmp16_) {
		case BUILD_MSG_TYPE_BADBOX:
		{
			gint _tmp17_ = 0;
			_tmp17_ = self->priv->nb_badboxes;
			self->priv->nb_badboxes = _tmp17_ + 1;
			break;
		}
		case BUILD_MSG_TYPE_WARNING:
		{
			gint _tmp18_ = 0;
			_tmp18_ = self->priv->nb_warnings;
			self->priv->nb_warnings = _tmp18_ + 1;
			break;
		}
		case BUILD_MSG_TYPE_ERROR:
		{
			gint _tmp19_ = 0;
			_tmp19_ = self->priv->nb_errors;
			self->priv->nb_errors = _tmp19_ + 1;
			break;
		}
		default:
		break;
	}
	_tmp20_ = ((PostProcessor*) self)->_all_messages;
	_tmp21_ = self->priv->msg;
	gee_collection_add ((GeeCollection*) _tmp20_, &_tmp21_);
	build_msg_destroy (&self->priv->msg);
	build_msg_init (&self->priv->msg);
}


static void latex_post_processor_file_in_stack_copy (const LatexPostProcessorFileInStack* self, LatexPostProcessorFileInStack* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	_tmp0_ = (*self).filename;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).filename);
	(*dest).filename = _tmp1_;
	_tmp2_ = (*self).reliable;
	(*dest).reliable = _tmp2_;
	_tmp3_ = (*self).exists;
	(*dest).exists = _tmp3_;
}


static void latex_post_processor_file_in_stack_destroy (LatexPostProcessorFileInStack* self) {
	_g_free0 ((*self).filename);
}


static LatexPostProcessorFileInStack* latex_post_processor_file_in_stack_dup (const LatexPostProcessorFileInStack* self) {
	LatexPostProcessorFileInStack* dup;
	dup = g_new0 (LatexPostProcessorFileInStack, 1);
	latex_post_processor_file_in_stack_copy (self, dup);
	return dup;
}


static void latex_post_processor_file_in_stack_free (LatexPostProcessorFileInStack* self) {
	latex_post_processor_file_in_stack_destroy (self);
	g_free (self);
}


static GType latex_post_processor_file_in_stack_get_type (void) {
	static volatile gsize latex_post_processor_file_in_stack_type_id__volatile = 0;
	if (g_once_init_enter (&latex_post_processor_file_in_stack_type_id__volatile)) {
		GType latex_post_processor_file_in_stack_type_id;
		latex_post_processor_file_in_stack_type_id = g_boxed_type_register_static ("LatexPostProcessorFileInStack", (GBoxedCopyFunc) latex_post_processor_file_in_stack_dup, (GBoxedFreeFunc) latex_post_processor_file_in_stack_free);
		g_once_init_leave (&latex_post_processor_file_in_stack_type_id__volatile, latex_post_processor_file_in_stack_type_id);
	}
	return latex_post_processor_file_in_stack_type_id__volatile;
}


static void latex_post_processor_class_init (LatexPostProcessorClass * klass) {
	latex_post_processor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (LatexPostProcessorPrivate));
	((PostProcessorClass *) klass)->process = latex_post_processor_real_process;
	G_OBJECT_CLASS (klass)->finalize = latex_post_processor_finalize;
}


static void latex_post_processor_instance_init (LatexPostProcessor * self) {
	self->priv = LATEX_POST_PROCESSOR_GET_PRIVATE (self);
	self->priv->status = LATEX_POST_PROCESSOR_FILTER_STATUS_START;
	self->priv->nb_lines = 0;
	self->priv->stack_files = NULL;
	self->priv->directory_path = NULL;
	self->priv->nb_badboxes = 0;
	self->priv->nb_warnings = 0;
	self->priv->nb_errors = 0;
}


static void latex_post_processor_finalize (GObject* obj) {
	LatexPostProcessor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LATEX_POST_PROCESSOR, LatexPostProcessor);
	build_msg_destroy (&self->priv->msg);
	_g_free0 (self->priv->line_buf);
	_g_free0 (self->priv->filename_buf);
	__g_slist_free__latex_post_processor_file_in_stack_free0_0 (self->priv->stack_files);
	_g_free0 (self->priv->directory_path);
	G_OBJECT_CLASS (latex_post_processor_parent_class)->finalize (obj);
}


GType latex_post_processor_get_type (void) {
	static volatile gsize latex_post_processor_type_id__volatile = 0;
	if (g_once_init_enter (&latex_post_processor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LatexPostProcessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) latex_post_processor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LatexPostProcessor), 0, (GInstanceInitFunc) latex_post_processor_instance_init, NULL };
		GType latex_post_processor_type_id;
		latex_post_processor_type_id = g_type_register_static (TYPE_POST_PROCESSOR, "LatexPostProcessor", &g_define_type_info, 0);
		g_once_init_leave (&latex_post_processor_type_id__volatile, latex_post_processor_type_id);
	}
	return latex_post_processor_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



