/* document_structure.c generated by valac 0.26.0.92-9bcc61c, the Vala compiler
 * generated from document_structure.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2011-2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtksourceview/gtksource.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>


#define TYPE_DOCUMENT_STRUCTURE (document_structure_get_type ())
#define DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructure))
#define DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))
#define IS_DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_STRUCTURE))
#define IS_DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_STRUCTURE))
#define DOCUMENT_STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))

typedef struct _DocumentStructure DocumentStructure;
typedef struct _DocumentStructureClass DocumentStructureClass;
typedef struct _DocumentStructurePrivate DocumentStructurePrivate;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_STRUCTURE_MODEL (structure_model_get_type ())
#define STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STRUCTURE_MODEL, StructureModel))
#define STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STRUCTURE_MODEL, StructureModelClass))
#define IS_STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STRUCTURE_MODEL))
#define IS_STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STRUCTURE_MODEL))
#define STRUCTURE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STRUCTURE_MODEL, StructureModelClass))

typedef struct _StructureModel StructureModel;
typedef struct _StructureModelClass StructureModelClass;

#define DOCUMENT_STRUCTURE_TYPE_ENV_DATA (document_structure_env_data_get_type ())

#define TYPE_STRUCT_TYPE (struct_type_get_type ())
typedef struct _DocumentStructureEnvData DocumentStructureEnvData;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _document_structure_env_data_free0(var) ((var == NULL) ? NULL : (var = (document_structure_env_data_free (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

#define TYPE_STRUCT_DATA (struct_data_get_type ())
typedef struct _StructData StructData;

#define TYPE_STRUCT_ACTION (struct_action_get_type ())

#define TYPE_STRUCT_COLUMN (struct_column_get_type ())

struct _DocumentStructure {
	GObject parent_instance;
	DocumentStructurePrivate * priv;
};

struct _DocumentStructureClass {
	GObjectClass parent_class;
};

typedef enum  {
	STRUCT_TYPE_BEGIN_COMMON_TYPES,
	STRUCT_TYPE_PART,
	STRUCT_TYPE_CHAPTER,
	STRUCT_TYPE_SECTION,
	STRUCT_TYPE_SUBSECTION,
	STRUCT_TYPE_SUBSUBSECTION,
	STRUCT_TYPE_PARAGRAPH,
	STRUCT_TYPE_SUBPARAGRAPH,
	STRUCT_TYPE_LABEL,
	STRUCT_TYPE_INCLUDE,
	STRUCT_TYPE_IMAGE,
	STRUCT_TYPE_TODO,
	STRUCT_TYPE_FIXME,
	STRUCT_TYPE_END_COMMON_TYPES,
	STRUCT_TYPE_BEGIN_LOW_LEVEL_TYPES,
	STRUCT_TYPE_BEGIN_FIGURE,
	STRUCT_TYPE_END_FIGURE,
	STRUCT_TYPE_BEGIN_TABLE,
	STRUCT_TYPE_END_TABLE,
	STRUCT_TYPE_BEGIN_VERBATIM,
	STRUCT_TYPE_END_VERBATIM,
	STRUCT_TYPE_END_DOCUMENT,
	STRUCT_TYPE_CAPTION,
	STRUCT_TYPE_END_LOW_LEVEL_TYPES,
	STRUCT_TYPE_BEGIN_HIGH_LEVEL_TYPES,
	STRUCT_TYPE_TABLE,
	STRUCT_TYPE_FIGURE,
	STRUCT_TYPE_END_HIGH_LEVEL_TYPES,
	STRUCT_TYPE_NB_TYPES
} StructType;

struct _DocumentStructureEnvData {
	GtkTreePath* path;
	StructType type;
	gchar* first_caption;
};

struct _DocumentStructurePrivate {
	Document* _doc;
	gint _nb_marks;
	GtkTextMark* _end_document_mark;
	StructureModel* _model;
	gboolean _in_verbatim_env;
	DocumentStructureEnvData* _last_env_data;
	gint _start_parsing_line;
	GTimer* _timer;
	gboolean _parsing_done;
};

struct _StructData {
	StructType type;
	gchar* text;
	GtkTextMark* start_mark;
	GtkTextMark* end_mark;
};

typedef enum  {
	STRUCT_ACTION_CUT,
	STRUCT_ACTION_COPY,
	STRUCT_ACTION_DELETE,
	STRUCT_ACTION_SELECT,
	STRUCT_ACTION_COMMENT,
	STRUCT_ACTION_SHIFT_LEFT,
	STRUCT_ACTION_SHIFT_RIGHT,
	STRUCT_ACTION_OPEN_FILE,
	STRUCT_ACTION_NB_ACTIONS
} StructAction;

typedef enum  {
	STRUCT_ERROR_GENERAL,
	STRUCT_ERROR_DATA_OUTDATED
} StructError;
#define STRUCT_ERROR struct_error_quark ()
typedef enum  {
	STRUCT_COLUMN_PIXBUF,
	STRUCT_COLUMN_TEXT,
	STRUCT_COLUMN_TOOLTIP,
	STRUCT_COLUMN_START_MARK,
	STRUCT_COLUMN_END_MARK,
	STRUCT_COLUMN_TYPE,
	STRUCT_COLUMN_N_COLUMNS
} StructColumn;


static gpointer document_structure_parent_class = NULL;
static GRegex* document_structure__chars_regex;
static GRegex* document_structure__chars_regex = NULL;
static GRegex* document_structure__comment_regex;
static GRegex* document_structure__comment_regex = NULL;
static GRegex* document_structure__command_name_regex;
static GRegex* document_structure__command_name_regex = NULL;
static gchar** document_structure__section_names;
static gint document_structure__section_names_length1;
static gchar** document_structure__section_names = NULL;
static gint document_structure__section_names_length1 = 0;
static gint _document_structure__section_names_size_ = 0;

GType document_structure_get_type (void) G_GNUC_CONST;
GType document_get_type (void) G_GNUC_CONST;
GType structure_model_get_type (void) G_GNUC_CONST;
static GType document_structure_env_data_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType struct_type_get_type (void) G_GNUC_CONST;
static DocumentStructureEnvData* document_structure_env_data_dup (const DocumentStructureEnvData* self);
static void document_structure_env_data_free (DocumentStructureEnvData* self);
static void document_structure_env_data_copy (const DocumentStructureEnvData* self, DocumentStructureEnvData* dest);
static void document_structure_env_data_destroy (DocumentStructureEnvData* self);
#define DOCUMENT_STRUCTURE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DOCUMENT_STRUCTURE, DocumentStructurePrivate))
enum  {
	DOCUMENT_STRUCTURE_DUMMY_PROPERTY,
	DOCUMENT_STRUCTURE_PARSING_DONE
};
#define DOCUMENT_STRUCTURE_MARK_NAME_PREFIX "struct_item_"
#define DOCUMENT_STRUCTURE_ITEM_MAX_LENGTH 60
#define DOCUMENT_STRUCTURE_MAX_NB_LINES_TO_PARSE 2000
#define DOCUMENT_STRUCTURE__measure_parsing_time FALSE
DocumentStructure* document_structure_new (Document* doc);
DocumentStructure* document_structure_construct (GType object_type, Document* doc);
void document_structure_parse (DocumentStructure* self);
static void document_structure_set_parsing_done (DocumentStructure* self, gboolean value);
StructureModel* structure_model_new (void);
StructureModel* structure_model_construct (GType object_type);
static void document_structure_clear_all_structure_marks (DocumentStructure* self);
static gboolean __lambda6_ (DocumentStructure* self);
static gboolean document_structure_parse_impl (DocumentStructure* self);
static gboolean ___lambda6__gsource_func (gpointer self);
StructureModel* document_structure_get_model (DocumentStructure* self);
static gchar* document_structure_get_line_contents_at_iter (DocumentStructure* self, GtkTextIter* iter);
static gboolean document_structure_search_low_level_item (DocumentStructure* self, const gchar* line, gint start_index, StructType** type, gchar** contents, gint** start_match_index, gint** end_match_index);
static void document_structure_handle_item (DocumentStructure* self, StructType type, const gchar* contents, GtkTextIter* iter);
static gint* _int_dup (gint* self);
gboolean utils_char_is_escaped (const gchar* text, glong char_index);
static gboolean document_structure_search_markup (DocumentStructure* self, const gchar* line, gint after_backslash_index, StructType** type, gchar** contents, gint** end_match_index);
static gboolean document_structure_search_comment (DocumentStructure* self, const gchar* line, gint after_percent_index, StructType** type, gchar** contents, gint** end_match_index);
static gchar* document_structure_get_markup_name (DocumentStructure* self, const gchar* line, gint after_backslash_index, gint** begin_contents_index);
static gboolean document_structure_search_env (DocumentStructure* self, const gchar* line, gint begin_contents_index, gboolean is_begin_env, StructType** type, gint** end_match_index);
static StructType* document_structure_get_markup_type (DocumentStructure* self, const gchar* markup_name);
static gchar* document_structure_get_markup_contents (DocumentStructure* self, const gchar* line, gint begin_contents_index, gint** end_match_index);
static StructType* _struct_type_dup (StructType* self);
static gboolean document_structure_search_firt_non_optional_arg (DocumentStructure* self, const gchar* line, gint start_index, gint* begin_contents_index);
static gchar* document_structure_truncate (DocumentStructure* self, const gchar* text);
static GtkTreeIter* document_structure_add_item (DocumentStructure* self, StructType type, const gchar* text, GtkTextIter* start_iter);
gboolean structure_is_common_type (StructType type);
static void document_structure_create_new_environment (DocumentStructure* self, StructType type, GtkTextIter* start_iter);
static gboolean document_structure_verify_end_environment_type (DocumentStructure* self, StructType type);
static GtkTextMark* document_structure_create_text_mark_from_iter (DocumentStructure* self, GtkTextIter* iter);
void structure_model_modify_data (StructureModel* self, GtkTreePath* path, const gchar* text, GtkTextMark* end_mark);
GType struct_data_get_type (void) G_GNUC_CONST;
StructData* struct_data_dup (const StructData* self);
void struct_data_free (StructData* self);
void struct_data_copy (const StructData* self, StructData* dest);
void struct_data_destroy (StructData* self);
static GtkTreeIter* document_structure_add_item_data (DocumentStructure* self, StructData* data);
GtkTreeIter* structure_model_add_item_at_end (StructureModel* self, StructData* item);
GType struct_action_get_type (void) G_GNUC_CONST;
GQuark struct_error_quark (void);
void document_structure_do_action (DocumentStructure* self, StructAction action_type, GtkTreeIter* tree_iter, gboolean* refresh_simple_list, GError** error);
static gboolean document_structure_comment_item (DocumentStructure* self, GtkTreeIter* tree_iter);
void structure_model_delete (StructureModel* self, GtkTreeIter* iter);
gboolean structure_model_item_contains_subparagraph (StructureModel* self, GtkTreeIter* iter);
static gboolean document_structure_shift_item (DocumentStructure* self, GtkTreeIter* tree_iter, gboolean shift_right, gboolean* doc_modified);
void structure_model_shift_right (StructureModel* self, GtkTreeIter* iter);
void structure_model_shift_left (StructureModel* self, GtkTreeIter* iter);
static gboolean document_structure_get_exact_item_bounds (DocumentStructure* self, GtkTreeIter* tree_iter, GtkTextIter* start_iter, GtkTextIter* end_iter);
static void document_structure_backward_indentation (DocumentStructure* self, GtkTextIter* iter);
GType struct_column_get_type (void) G_GNUC_CONST;
gboolean structure_is_section (StructType type);
void document_comment_between (Document* self, GtkTextIter* start_iter, GtkTextIter* end_iter, gboolean end_iter_set);
GtkTreeIter* structure_model_get_next_sibling_or_parent (StructureModel* self, GtkTreeIter* section_iter, GError** error);
static void document_structure_get_end_document_iter (DocumentStructure* self, gboolean* end_of_file, GtkTextIter* result);
static gboolean document_structure_get_low_level_item_bounds (DocumentStructure* self, StructType item_type, const gchar* item_contents, GtkTextIter* start_match_iter, gboolean is_start, GtkTextIter* end_match_iter);
static gboolean _int_equal (const gint* s1, const gint* s2);
static gboolean document_structure_same_items (DocumentStructure* self, StructType item_type, const gchar* item_contents, StructType item_found_type, const gchar* item_found_contents, gboolean start);
static gchar* document_structure_get_section_name_from_type (DocumentStructure* self, StructType type);
void document_insert (Document* self, GtkTextIter* iter, const gchar* text, gint len);
gboolean document_structure_get_parsing_done (DocumentStructure* self);
static void document_structure_finalize (GObject* obj);
static void _vala_document_structure_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_document_structure_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


DocumentStructure* document_structure_construct (GType object_type, Document* doc) {
	DocumentStructure * self = NULL;
	Document* _tmp0_ = NULL;
	GRegex* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (doc != NULL, NULL);
	self = (DocumentStructure*) g_object_new (object_type, NULL);
	_tmp0_ = doc;
	self->priv->_doc = _tmp0_;
	_tmp1_ = document_structure__chars_regex;
	if (_tmp1_ != NULL) {
		return self;
	}
	{
		GRegex* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		GRegex* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		GRegex* _tmp7_ = NULL;
		GRegex* _tmp8_ = NULL;
		GRegex* _tmp9_ = NULL;
		GRegex* _tmp10_ = NULL;
		_tmp3_ = g_regex_new ("\\\\|%", 0, 0, &_inner_error_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch13_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp4_ = _tmp2_;
		_tmp2_ = NULL;
		_g_regex_unref0 (document_structure__chars_regex);
		document_structure__chars_regex = _tmp4_;
		_tmp6_ = g_regex_new ("^(?P<type>TODO|FIXME)\\s+:?\\s*(?P<text>.*)$", G_REGEX_OPTIMIZE, 0, &_inner_error_);
		_tmp5_ = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (_tmp2_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch13_g_regex_error;
			}
			_g_regex_unref0 (_tmp2_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp7_ = _tmp5_;
		_tmp5_ = NULL;
		_g_regex_unref0 (document_structure__comment_regex);
		document_structure__comment_regex = _tmp7_;
		_tmp9_ = g_regex_new ("^(?P<name>[a-z]+\\*?)\\s*(\\[|{)", G_REGEX_OPTIMIZE, 0, &_inner_error_);
		_tmp8_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (_tmp5_);
			_g_regex_unref0 (_tmp2_);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch13_g_regex_error;
			}
			_g_regex_unref0 (_tmp5_);
			_g_regex_unref0 (_tmp2_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp8_;
		_tmp8_ = NULL;
		_g_regex_unref0 (document_structure__command_name_regex);
		document_structure__command_name_regex = _tmp10_;
		_g_regex_unref0 (_tmp8_);
		_g_regex_unref0 (_tmp5_);
		_g_regex_unref0 (_tmp2_);
	}
	goto __finally13;
	__catch13_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("document_structure.vala:86: Structure: %s", _tmp12_);
		_g_error_free0 (e);
	}
	__finally13:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


DocumentStructure* document_structure_new (Document* doc) {
	return document_structure_construct (TYPE_DOCUMENT_STRUCTURE, doc);
}


static gboolean __lambda6_ (DocumentStructure* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	_tmp0_ = document_structure_parse_impl (self);
	result = _tmp0_;
	return result;
}


static gboolean ___lambda6__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda6_ ((DocumentStructure*) self);
	return result;
}


void document_structure_parse (DocumentStructure* self) {
	StructureModel* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	document_structure_set_parsing_done (self, FALSE);
	_tmp0_ = structure_model_new ();
	_g_object_unref0 (self->priv->_model);
	self->priv->_model = _tmp0_;
	_document_structure_env_data_free0 (self->priv->_last_env_data);
	self->priv->_last_env_data = NULL;
	self->priv->_start_parsing_line = 0;
	_g_object_unref0 (self->priv->_end_document_mark);
	self->priv->_end_document_mark = NULL;
	document_structure_clear_all_structure_marks (self);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda6__gsource_func, g_object_ref (self), g_object_unref);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


StructureModel* document_structure_get_model (DocumentStructure* self) {
	StructureModel* result = NULL;
	StructureModel* _tmp0_ = NULL;
	StructureModel* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_model;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/*************************************************************************/
static gboolean document_structure_parse_impl (DocumentStructure* self) {
	gboolean result = FALSE;
	GtkTextIter line_iter = {0};
	Document* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GtkTextIter _tmp5_ = {0};
	gint nb_lines_parsed = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	if (DOCUMENT_STRUCTURE__measure_parsing_time) {
		GTimer* _tmp0_ = NULL;
		_tmp0_ = self->priv->_timer;
		if (_tmp0_ == NULL) {
			GTimer* _tmp1_ = NULL;
			_tmp1_ = g_timer_new ();
			_g_timer_destroy0 (self->priv->_timer);
			self->priv->_timer = _tmp1_;
		} else {
			GTimer* _tmp2_ = NULL;
			_tmp2_ = self->priv->_timer;
			g_timer_continue (_tmp2_);
		}
	}
	_tmp3_ = self->priv->_doc;
	_tmp4_ = self->priv->_start_parsing_line;
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) _tmp3_, &_tmp5_, _tmp4_);
	line_iter = _tmp5_;
	nb_lines_parsed = 0;
	{
		gboolean _tmp6_ = FALSE;
		_tmp6_ = TRUE;
		while (TRUE) {
			gint _tmp8_ = 0;
			gchar* line_text = NULL;
			GtkTextIter _tmp11_ = {0};
			gchar* _tmp12_ = NULL;
			gint start_index = 0;
			gint line_length = 0;
			const gchar* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			gint _tmp32_ = 0;
			if (!_tmp6_) {
				gboolean _tmp7_ = FALSE;
				_tmp7_ = gtk_text_iter_forward_line (&line_iter);
				if (!_tmp7_) {
					break;
				}
			}
			_tmp6_ = FALSE;
			_tmp8_ = nb_lines_parsed;
			if (_tmp8_ == DOCUMENT_STRUCTURE_MAX_NB_LINES_TO_PARSE) {
				gint _tmp9_ = 0;
				_tmp9_ = self->priv->_start_parsing_line;
				self->priv->_start_parsing_line = _tmp9_ + DOCUMENT_STRUCTURE_MAX_NB_LINES_TO_PARSE;
				if (DOCUMENT_STRUCTURE__measure_parsing_time) {
					GTimer* _tmp10_ = NULL;
					_tmp10_ = self->priv->_timer;
					g_timer_stop (_tmp10_);
				}
				result = TRUE;
				return result;
			}
			_tmp11_ = line_iter;
			_tmp12_ = document_structure_get_line_contents_at_iter (self, &_tmp11_);
			line_text = _tmp12_;
			start_index = 0;
			_tmp13_ = line_text;
			_tmp14_ = strlen (_tmp13_);
			_tmp15_ = _tmp14_;
			line_length = _tmp15_;
			while (TRUE) {
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				StructType* type = NULL;
				gchar* contents = NULL;
				gint* start_match_index = NULL;
				gint* end_match_index = NULL;
				gboolean item_found = FALSE;
				const gchar* _tmp18_ = NULL;
				gint _tmp19_ = 0;
				StructType* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				gint* _tmp22_ = NULL;
				gint* _tmp23_ = NULL;
				gboolean _tmp24_ = FALSE;
				gboolean _tmp25_ = FALSE;
				GtkTextIter iter = {0};
				GtkTextIter _tmp26_ = {0};
				gint* _tmp27_ = NULL;
				StructType* _tmp28_ = NULL;
				const gchar* _tmp29_ = NULL;
				GtkTextIter _tmp30_ = {0};
				gint* _tmp31_ = NULL;
				_tmp16_ = start_index;
				_tmp17_ = line_length;
				if (!(_tmp16_ < _tmp17_)) {
					break;
				}
				_tmp18_ = line_text;
				_tmp19_ = start_index;
				_tmp24_ = document_structure_search_low_level_item (self, _tmp18_, _tmp19_, &_tmp20_, &_tmp21_, &_tmp22_, &_tmp23_);
				_g_free0 (type);
				type = _tmp20_;
				_g_free0 (contents);
				contents = _tmp21_;
				_g_free0 (start_match_index);
				start_match_index = _tmp22_;
				_g_free0 (end_match_index);
				end_match_index = _tmp23_;
				item_found = _tmp24_;
				_tmp25_ = item_found;
				if (!_tmp25_) {
					_g_free0 (end_match_index);
					_g_free0 (start_match_index);
					_g_free0 (contents);
					_g_free0 (type);
					break;
				}
				_tmp26_ = line_iter;
				iter = _tmp26_;
				_tmp27_ = start_match_index;
				gtk_text_iter_set_line_index (&iter, *_tmp27_);
				_tmp28_ = type;
				_tmp29_ = contents;
				_tmp30_ = iter;
				document_structure_handle_item (self, *_tmp28_, _tmp29_, &_tmp30_);
				_tmp31_ = end_match_index;
				start_index = *_tmp31_;
				_g_free0 (end_match_index);
				_g_free0 (start_match_index);
				_g_free0 (contents);
				_g_free0 (type);
			}
			_tmp32_ = nb_lines_parsed;
			nb_lines_parsed = _tmp32_ + 1;
			_g_free0 (line_text);
		}
	}
	if (DOCUMENT_STRUCTURE__measure_parsing_time) {
		GTimer* _tmp33_ = NULL;
		GTimer* _tmp34_ = NULL;
		gdouble _tmp35_ = 0.0;
		GTimer* _tmp36_ = NULL;
		_tmp33_ = self->priv->_timer;
		g_timer_stop (_tmp33_);
		_tmp34_ = self->priv->_timer;
		_tmp35_ = g_timer_elapsed (_tmp34_, NULL);
		g_message ("document_structure.vala:179: Structure parsing took %f seconds", _tmp35_);
		_tmp36_ = self->priv->_timer;
		g_timer_reset (_tmp36_);
	}
	document_structure_set_parsing_done (self, TRUE);
	result = FALSE;
	return result;
}


static gint* _int_dup (gint* self) {
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}


static gpointer __int_dup0 (gpointer self) {
	return self ? _int_dup (self) : NULL;
}


static gboolean document_structure_search_low_level_item (DocumentStructure* self, const gchar* line, gint start_index, StructType** type, gchar** contents, gint** start_match_index, gint** end_match_index) {
	StructType* _vala_type = NULL;
	gchar* _vala_contents = NULL;
	gint* _vala_start_match_index = NULL;
	gint* _vala_end_match_index = NULL;
	gboolean result = FALSE;
	GMatchInfo* match_info = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_g_free0 (_vala_type);
	_vala_type = NULL;
	_g_free0 (_vala_contents);
	_vala_contents = NULL;
	_g_free0 (_vala_start_match_index);
	_vala_start_match_index = NULL;
	_g_free0 (_vala_end_match_index);
	_vala_end_match_index = NULL;
	{
		GRegex* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		GMatchInfo* _tmp3_ = NULL;
		_tmp0_ = document_structure__chars_regex;
		_tmp1_ = line;
		_tmp2_ = start_index;
		g_regex_match_full (_tmp0_, _tmp1_, (gssize) (-1), _tmp2_, 0, &_tmp3_, &_inner_error_);
		_g_match_info_unref0 (match_info);
		match_info = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch14_g_error;
		}
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("document_structure.vala:211: Structure parsing: chars regex: %s", _tmp5_);
		result = FALSE;
		_g_error_free0 (e);
		_g_match_info_unref0 (match_info);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (contents) {
			*contents = _vala_contents;
		} else {
			_g_free0 (_vala_contents);
		}
		if (start_match_index) {
			*start_match_index = _vala_start_match_index;
		} else {
			_g_free0 (_vala_start_match_index);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	__finally14:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_match_info_unref0 (match_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	while (TRUE) {
		GMatchInfo* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		gint after_char_index = 0;
		GMatchInfo* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gboolean _tmp11_ = FALSE;
		gint _tmp12_ = 0;
		gint* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gint* _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
		_tmp6_ = match_info;
		_tmp7_ = g_match_info_matches (_tmp6_);
		if (!_tmp7_) {
			break;
		}
		_tmp8_ = match_info;
		_tmp11_ = g_match_info_fetch_pos (_tmp8_, 0, &_tmp9_, &_tmp10_);
		_g_free0 (_vala_start_match_index);
		_tmp12_ = _tmp9_;
		_tmp13_ = __int_dup0 (&_tmp12_);
		_vala_start_match_index = _tmp13_;
		after_char_index = _tmp10_;
		if (!_tmp11_) {
			g_warning ("document_structure.vala:220: Structure parsing: position can not be fe" \
"tched");
			result = FALSE;
			_g_match_info_unref0 (match_info);
			if (type) {
				*type = _vala_type;
			} else {
				_g_free0 (_vala_type);
			}
			if (contents) {
				*contents = _vala_contents;
			} else {
				_g_free0 (_vala_contents);
			}
			if (start_match_index) {
				*start_match_index = _vala_start_match_index;
			} else {
				_g_free0 (_vala_start_match_index);
			}
			if (end_match_index) {
				*end_match_index = _vala_end_match_index;
			} else {
				_g_free0 (_vala_end_match_index);
			}
			return result;
		}
		_tmp14_ = line;
		_tmp15_ = _vala_start_match_index;
		_tmp16_ = utils_char_is_escaped (_tmp14_, *_tmp15_);
		if (!_tmp16_) {
			gchar* char_matched = NULL;
			GMatchInfo* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			_tmp17_ = match_info;
			_tmp18_ = g_match_info_fetch (_tmp17_, 0);
			char_matched = _tmp18_;
			_tmp19_ = char_matched;
			if (g_strcmp0 (_tmp19_, "\\") == 0) {
				gboolean markup_found = FALSE;
				const gchar* _tmp20_ = NULL;
				gint _tmp21_ = 0;
				StructType* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
				gint* _tmp24_ = NULL;
				gboolean _tmp25_ = FALSE;
				gboolean _tmp26_ = FALSE;
				_tmp20_ = line;
				_tmp21_ = after_char_index;
				_tmp25_ = document_structure_search_markup (self, _tmp20_, _tmp21_, &_tmp22_, &_tmp23_, &_tmp24_);
				_g_free0 (_vala_type);
				_vala_type = _tmp22_;
				_g_free0 (_vala_contents);
				_vala_contents = _tmp23_;
				_g_free0 (_vala_end_match_index);
				_vala_end_match_index = _tmp24_;
				markup_found = _tmp25_;
				_tmp26_ = markup_found;
				if (_tmp26_) {
					result = TRUE;
					_g_free0 (char_matched);
					_g_match_info_unref0 (match_info);
					if (type) {
						*type = _vala_type;
					} else {
						_g_free0 (_vala_type);
					}
					if (contents) {
						*contents = _vala_contents;
					} else {
						_g_free0 (_vala_contents);
					}
					if (start_match_index) {
						*start_match_index = _vala_start_match_index;
					} else {
						_g_free0 (_vala_start_match_index);
					}
					if (end_match_index) {
						*end_match_index = _vala_end_match_index;
					} else {
						_g_free0 (_vala_end_match_index);
					}
					return result;
				}
			} else {
				const gchar* _tmp27_ = NULL;
				gint _tmp28_ = 0;
				StructType* _tmp29_ = NULL;
				gchar* _tmp30_ = NULL;
				gint* _tmp31_ = NULL;
				gboolean _tmp32_ = FALSE;
				_tmp27_ = line;
				_tmp28_ = after_char_index;
				_tmp32_ = document_structure_search_comment (self, _tmp27_, _tmp28_, &_tmp29_, &_tmp30_, &_tmp31_);
				_g_free0 (_vala_type);
				_vala_type = _tmp29_;
				_g_free0 (_vala_contents);
				_vala_contents = _tmp30_;
				_g_free0 (_vala_end_match_index);
				_vala_end_match_index = _tmp31_;
				result = _tmp32_;
				_g_free0 (char_matched);
				_g_match_info_unref0 (match_info);
				if (type) {
					*type = _vala_type;
				} else {
					_g_free0 (_vala_type);
				}
				if (contents) {
					*contents = _vala_contents;
				} else {
					_g_free0 (_vala_contents);
				}
				if (start_match_index) {
					*start_match_index = _vala_start_match_index;
				} else {
					_g_free0 (_vala_start_match_index);
				}
				if (end_match_index) {
					*end_match_index = _vala_end_match_index;
				} else {
					_g_free0 (_vala_end_match_index);
				}
				return result;
			}
			_g_free0 (char_matched);
		}
		{
			GMatchInfo* _tmp33_ = NULL;
			_tmp33_ = match_info;
			g_match_info_next (_tmp33_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch15_g_regex_error;
				}
				_g_match_info_unref0 (match_info);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		goto __finally15;
		__catch15_g_regex_error:
		{
			GError* e = NULL;
			GError* _tmp34_ = NULL;
			const gchar* _tmp35_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp34_ = e;
			_tmp35_ = _tmp34_->message;
			g_warning ("document_structure.vala:256: Structure parsing: %s", _tmp35_);
			_g_error_free0 (e);
			break;
		}
		__finally15:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_match_info_unref0 (match_info);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = FALSE;
	_g_match_info_unref0 (match_info);
	if (type) {
		*type = _vala_type;
	} else {
		_g_free0 (_vala_type);
	}
	if (contents) {
		*contents = _vala_contents;
	} else {
		_g_free0 (_vala_contents);
	}
	if (start_match_index) {
		*start_match_index = _vala_start_match_index;
	} else {
		_g_free0 (_vala_start_match_index);
	}
	if (end_match_index) {
		*end_match_index = _vala_end_match_index;
	} else {
		_g_free0 (_vala_end_match_index);
	}
	return result;
}


static gboolean document_structure_search_markup (DocumentStructure* self, const gchar* line, gint after_backslash_index, StructType** type, gchar** contents, gint** end_match_index) {
	StructType* _vala_type = NULL;
	gchar* _vala_contents = NULL;
	gint* _vala_end_match_index = NULL;
	gboolean result = FALSE;
	gint* begin_contents_index = NULL;
	gchar* name = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean is_begin_env = FALSE;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp15_ = NULL;
	StructType* _tmp16_ = NULL;
	StructType* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gint* _tmp19_ = NULL;
	gint* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_g_free0 (_vala_type);
	_vala_type = NULL;
	_g_free0 (_vala_contents);
	_vala_contents = NULL;
	_g_free0 (_vala_end_match_index);
	_vala_end_match_index = NULL;
	_tmp0_ = line;
	_tmp1_ = after_backslash_index;
	_tmp3_ = document_structure_get_markup_name (self, _tmp0_, _tmp1_, &_tmp2_);
	_g_free0 (begin_contents_index);
	begin_contents_index = _tmp2_;
	name = _tmp3_;
	_tmp4_ = name;
	if (_tmp4_ == NULL) {
		result = FALSE;
		_g_free0 (name);
		_g_free0 (begin_contents_index);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (contents) {
			*contents = _vala_contents;
		} else {
			_g_free0 (_vala_contents);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp5_ = name;
	is_begin_env = g_strcmp0 (_tmp5_, "begin") == 0;
	_tmp7_ = is_begin_env;
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp8_ = NULL;
		_tmp8_ = name;
		_tmp6_ = g_strcmp0 (_tmp8_, "end") == 0;
	}
	if (_tmp6_) {
		const gchar* _tmp9_ = NULL;
		gint* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		StructType* _tmp12_ = NULL;
		gint* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		_g_free0 (_vala_contents);
		_vala_contents = NULL;
		_tmp9_ = line;
		_tmp10_ = begin_contents_index;
		_tmp11_ = is_begin_env;
		_tmp14_ = document_structure_search_env (self, _tmp9_, *_tmp10_, _tmp11_, &_tmp12_, &_tmp13_);
		_g_free0 (_vala_type);
		_vala_type = _tmp12_;
		_g_free0 (_vala_end_match_index);
		_vala_end_match_index = _tmp13_;
		result = _tmp14_;
		_g_free0 (name);
		_g_free0 (begin_contents_index);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (contents) {
			*contents = _vala_contents;
		} else {
			_g_free0 (_vala_contents);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp15_ = name;
	_tmp16_ = document_structure_get_markup_type (self, _tmp15_);
	_g_free0 (_vala_type);
	_vala_type = _tmp16_;
	_tmp17_ = _vala_type;
	if (_tmp17_ == NULL) {
		result = FALSE;
		_g_free0 (name);
		_g_free0 (begin_contents_index);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (contents) {
			*contents = _vala_contents;
		} else {
			_g_free0 (_vala_contents);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp18_ = line;
	_tmp19_ = begin_contents_index;
	_tmp21_ = document_structure_get_markup_contents (self, _tmp18_, *_tmp19_, &_tmp20_);
	_g_free0 (_vala_end_match_index);
	_vala_end_match_index = _tmp20_;
	_g_free0 (_vala_contents);
	_vala_contents = _tmp21_;
	_tmp22_ = _vala_contents;
	result = _tmp22_ != NULL;
	_g_free0 (name);
	_g_free0 (begin_contents_index);
	if (type) {
		*type = _vala_type;
	} else {
		_g_free0 (_vala_type);
	}
	if (contents) {
		*contents = _vala_contents;
	} else {
		_g_free0 (_vala_contents);
	}
	if (end_match_index) {
		*end_match_index = _vala_end_match_index;
	} else {
		_g_free0 (_vala_end_match_index);
	}
	return result;
}


static StructType* _struct_type_dup (StructType* self) {
	StructType* dup;
	dup = g_new0 (StructType, 1);
	memcpy (dup, self, sizeof (StructType));
	return dup;
}


static gpointer __struct_type_dup0 (gpointer self) {
	return self ? _struct_type_dup (self) : NULL;
}


static gboolean document_structure_search_env (DocumentStructure* self, const gchar* line, gint begin_contents_index, gboolean is_begin_env, StructType** type, gint** end_match_index) {
	StructType* _vala_type = NULL;
	gint* _vala_end_match_index = NULL;
	gboolean result = FALSE;
	gchar* contents = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp15_ = NULL;
	gboolean _tmp19_ = FALSE;
	const gchar* _tmp20_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_g_free0 (_vala_type);
	_vala_type = NULL;
	_tmp0_ = line;
	_tmp1_ = begin_contents_index;
	_tmp3_ = document_structure_get_markup_contents (self, _tmp0_, _tmp1_, &_tmp2_);
	_g_free0 (_vala_end_match_index);
	_vala_end_match_index = _tmp2_;
	contents = _tmp3_;
	_tmp4_ = contents;
	if (_tmp4_ == NULL) {
		result = FALSE;
		_g_free0 (contents);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp6_ = contents;
	if (g_strcmp0 (_tmp6_, "verbatim") == 0) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp7_ = NULL;
		_tmp7_ = contents;
		_tmp5_ = g_strcmp0 (_tmp7_, "verbatim*") == 0;
	}
	if (_tmp5_) {
		StructType _tmp8_ = 0;
		gboolean _tmp9_ = FALSE;
		StructType* _tmp10_ = NULL;
		_tmp9_ = is_begin_env;
		if (_tmp9_) {
			_tmp8_ = STRUCT_TYPE_BEGIN_VERBATIM;
		} else {
			_tmp8_ = STRUCT_TYPE_END_VERBATIM;
		}
		_tmp10_ = __struct_type_dup0 (&_tmp8_);
		_g_free0 (_vala_type);
		_vala_type = _tmp10_;
		result = TRUE;
		_g_free0 (contents);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp11_ = contents;
	if (g_strcmp0 (_tmp11_, "figure") == 0) {
		StructType _tmp12_ = 0;
		gboolean _tmp13_ = FALSE;
		StructType* _tmp14_ = NULL;
		_tmp13_ = is_begin_env;
		if (_tmp13_) {
			_tmp12_ = STRUCT_TYPE_BEGIN_FIGURE;
		} else {
			_tmp12_ = STRUCT_TYPE_END_FIGURE;
		}
		_tmp14_ = __struct_type_dup0 (&_tmp12_);
		_g_free0 (_vala_type);
		_vala_type = _tmp14_;
		result = TRUE;
		_g_free0 (contents);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp15_ = contents;
	if (g_strcmp0 (_tmp15_, "table") == 0) {
		StructType _tmp16_ = 0;
		gboolean _tmp17_ = FALSE;
		StructType* _tmp18_ = NULL;
		_tmp17_ = is_begin_env;
		if (_tmp17_) {
			_tmp16_ = STRUCT_TYPE_BEGIN_TABLE;
		} else {
			_tmp16_ = STRUCT_TYPE_END_TABLE;
		}
		_tmp18_ = __struct_type_dup0 (&_tmp16_);
		_g_free0 (_vala_type);
		_vala_type = _tmp18_;
		result = TRUE;
		_g_free0 (contents);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp20_ = contents;
	if (g_strcmp0 (_tmp20_, "document") == 0) {
		gboolean _tmp21_ = FALSE;
		_tmp21_ = is_begin_env;
		_tmp19_ = !_tmp21_;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		StructType _tmp22_ = 0;
		StructType* _tmp23_ = NULL;
		_tmp22_ = STRUCT_TYPE_END_DOCUMENT;
		_tmp23_ = __struct_type_dup0 (&_tmp22_);
		_g_free0 (_vala_type);
		_vala_type = _tmp23_;
		result = TRUE;
		_g_free0 (contents);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	result = FALSE;
	_g_free0 (contents);
	if (type) {
		*type = _vala_type;
	} else {
		_g_free0 (_vala_type);
	}
	if (end_match_index) {
		*end_match_index = _vala_end_match_index;
	} else {
		_g_free0 (_vala_end_match_index);
	}
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar* document_structure_get_markup_name (DocumentStructure* self, const gchar* line, gint after_backslash_index, gint** begin_contents_index) {
	gint* _vala_begin_contents_index = NULL;
	gchar* result = NULL;
	gchar* after_backslash_text = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	GMatchInfo* match_info = NULL;
	GRegex* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GMatchInfo* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gint pos = 0;
	GMatchInfo* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint begin_first_arg_index = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gchar* markup_name = NULL;
	GMatchInfo* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gboolean _tmp16_ = FALSE;
	gint _tmp17_ = 0;
	gint* _tmp18_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	_g_free0 (_vala_begin_contents_index);
	_vala_begin_contents_index = NULL;
	_tmp0_ = line;
	_tmp1_ = after_backslash_index;
	_tmp2_ = string_substring (_tmp0_, (glong) _tmp1_, (glong) (-1));
	after_backslash_text = _tmp2_;
	_tmp3_ = document_structure__command_name_regex;
	_tmp4_ = after_backslash_text;
	_tmp6_ = g_regex_match (_tmp3_, _tmp4_, 0, &_tmp5_);
	_g_match_info_unref0 (match_info);
	match_info = _tmp5_;
	if (!_tmp6_) {
		result = NULL;
		_g_match_info_unref0 (match_info);
		_g_free0 (after_backslash_text);
		if (begin_contents_index) {
			*begin_contents_index = _vala_begin_contents_index;
		} else {
			_g_free0 (_vala_begin_contents_index);
		}
		return result;
	}
	_tmp7_ = match_info;
	g_match_info_fetch_pos (_tmp7_, 0, NULL, &_tmp8_);
	pos = _tmp8_;
	_tmp9_ = after_backslash_index;
	_tmp10_ = pos;
	begin_first_arg_index = _tmp9_ + _tmp10_;
	_tmp11_ = match_info;
	_tmp12_ = g_match_info_fetch_named (_tmp11_, "name");
	markup_name = _tmp12_;
	_tmp13_ = line;
	_tmp14_ = begin_first_arg_index;
	_tmp16_ = document_structure_search_firt_non_optional_arg (self, _tmp13_, _tmp14_ - 1, &_tmp15_);
	_g_free0 (_vala_begin_contents_index);
	_tmp17_ = _tmp15_;
	_tmp18_ = __int_dup0 (&_tmp17_);
	_vala_begin_contents_index = _tmp18_;
	if (_tmp16_) {
		result = markup_name;
		_g_match_info_unref0 (match_info);
		_g_free0 (after_backslash_text);
		if (begin_contents_index) {
			*begin_contents_index = _vala_begin_contents_index;
		} else {
			_g_free0 (_vala_begin_contents_index);
		}
		return result;
	}
	result = NULL;
	_g_free0 (markup_name);
	_g_match_info_unref0 (match_info);
	_g_free0 (after_backslash_text);
	if (begin_contents_index) {
		*begin_contents_index = _vala_begin_contents_index;
	} else {
		_g_free0 (_vala_begin_contents_index);
	}
	return result;
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	_vala_c = _tmp1_;
	_tmp2_ = _vala_c;
	if (_tmp2_ != ((gunichar) 0)) {
		gint _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
		_tmp3_ = *index;
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
		*index = (gint) (_tmp4_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


static gboolean document_structure_search_firt_non_optional_arg (DocumentStructure* self, const gchar* line, gint start_index, gint* begin_contents_index) {
	gint _vala_begin_contents_index = 0;
	gboolean result = FALSE;
	gint cur_index = 0;
	gint _tmp0_ = 0;
	gboolean in_optional_arg = FALSE;
	gint additional_bracket_level = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_vala_begin_contents_index = 0;
	_tmp0_ = start_index;
	cur_index = _tmp0_;
	in_optional_arg = FALSE;
	additional_bracket_level = 0;
	while (TRUE) {
		gint next_index = 0;
		gint _tmp1_ = 0;
		gunichar cur_char = 0U;
		gboolean end = FALSE;
		const gchar* _tmp2_ = NULL;
		gunichar _tmp3_ = 0U;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp18_ = FALSE;
		gint _tmp19_ = 0;
		_tmp1_ = cur_index;
		next_index = _tmp1_;
		_tmp2_ = line;
		_tmp4_ = string_get_next_char (_tmp2_, &next_index, &_tmp3_);
		cur_char = _tmp3_;
		end = !_tmp4_;
		_tmp5_ = in_optional_arg;
		if (_tmp5_) {
			gunichar _tmp6_ = 0U;
			_tmp6_ = cur_char;
			switch (_tmp6_) {
				case ']':
				{
					const gchar* _tmp7_ = NULL;
					gint _tmp8_ = 0;
					gboolean _tmp9_ = FALSE;
					_tmp7_ = line;
					_tmp8_ = cur_index;
					_tmp9_ = utils_char_is_escaped (_tmp7_, (glong) _tmp8_);
					if (!_tmp9_) {
						gint _tmp10_ = 0;
						_tmp10_ = additional_bracket_level;
						if (0 < _tmp10_) {
							gint _tmp11_ = 0;
							_tmp11_ = additional_bracket_level;
							additional_bracket_level = _tmp11_ - 1;
						} else {
							in_optional_arg = FALSE;
						}
					}
					break;
				}
				case '[':
				{
					const gchar* _tmp12_ = NULL;
					gint _tmp13_ = 0;
					gboolean _tmp14_ = FALSE;
					_tmp12_ = line;
					_tmp13_ = cur_index;
					_tmp14_ = utils_char_is_escaped (_tmp12_, (glong) _tmp13_);
					if (!_tmp14_) {
						gint _tmp15_ = 0;
						_tmp15_ = additional_bracket_level;
						additional_bracket_level = _tmp15_ + 1;
					}
					break;
				}
				default:
				break;
			}
		} else {
			gunichar _tmp16_ = 0U;
			_tmp16_ = cur_char;
			switch (_tmp16_) {
				case '{':
				{
					gint _tmp17_ = 0;
					_tmp17_ = next_index;
					_vala_begin_contents_index = _tmp17_;
					result = TRUE;
					if (begin_contents_index) {
						*begin_contents_index = _vala_begin_contents_index;
					}
					return result;
				}
				case '[':
				{
					in_optional_arg = TRUE;
					break;
				}
				case ' ':
				case '\t':
				{
					break;
				}
				default:
				{
					result = FALSE;
					if (begin_contents_index) {
						*begin_contents_index = _vala_begin_contents_index;
					}
					return result;
				}
			}
		}
		_tmp18_ = end;
		if (_tmp18_) {
			result = FALSE;
			if (begin_contents_index) {
				*begin_contents_index = _vala_begin_contents_index;
			}
			return result;
		}
		_tmp19_ = next_index;
		cur_index = _tmp19_;
	}
	if (begin_contents_index) {
		*begin_contents_index = _vala_begin_contents_index;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static gchar* document_structure_get_markup_contents (DocumentStructure* self, const gchar* line, gint begin_contents_index, gint** end_match_index) {
	gint* _vala_end_match_index = NULL;
	gchar* result = NULL;
	gint brace_level = 0;
	gint cur_index = 0;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	_g_free0 (_vala_end_match_index);
	_vala_end_match_index = NULL;
	brace_level = 0;
	_tmp0_ = begin_contents_index;
	cur_index = _tmp0_;
	while (TRUE) {
		gint next_index = 0;
		gint _tmp1_ = 0;
		gunichar cur_char = 0U;
		gboolean end = FALSE;
		const gchar* _tmp2_ = NULL;
		gunichar _tmp3_ = 0U;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gunichar _tmp6_ = 0U;
		gboolean _tmp25_ = FALSE;
		gint _tmp26_ = 0;
		_tmp1_ = cur_index;
		next_index = _tmp1_;
		_tmp2_ = line;
		_tmp4_ = string_get_next_char (_tmp2_, &next_index, &_tmp3_);
		cur_char = _tmp3_;
		end = !_tmp4_;
		_tmp6_ = cur_char;
		if (_tmp6_ == ((gunichar) '{')) {
			const gchar* _tmp7_ = NULL;
			gint _tmp8_ = 0;
			gboolean _tmp9_ = FALSE;
			_tmp7_ = line;
			_tmp8_ = cur_index;
			_tmp9_ = utils_char_is_escaped (_tmp7_, (glong) _tmp8_);
			_tmp5_ = !_tmp9_;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			gint _tmp10_ = 0;
			_tmp10_ = brace_level;
			brace_level = _tmp10_ + 1;
		} else {
			gboolean _tmp11_ = FALSE;
			gunichar _tmp12_ = 0U;
			_tmp12_ = cur_char;
			if (_tmp12_ == ((gunichar) '}')) {
				const gchar* _tmp13_ = NULL;
				gint _tmp14_ = 0;
				gboolean _tmp15_ = FALSE;
				_tmp13_ = line;
				_tmp14_ = cur_index;
				_tmp15_ = utils_char_is_escaped (_tmp13_, (glong) _tmp14_);
				_tmp11_ = !_tmp15_;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				gint _tmp16_ = 0;
				_tmp16_ = brace_level;
				if (_tmp16_ > 0) {
					gint _tmp17_ = 0;
					_tmp17_ = brace_level;
					brace_level = _tmp17_ - 1;
				} else {
					gchar* contents = NULL;
					const gchar* _tmp18_ = NULL;
					gint _tmp19_ = 0;
					gint _tmp20_ = 0;
					gchar* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					gint _tmp23_ = 0;
					gint* _tmp24_ = NULL;
					_tmp18_ = line;
					_tmp19_ = begin_contents_index;
					_tmp20_ = cur_index;
					_tmp21_ = string_slice (_tmp18_, (glong) _tmp19_, (glong) _tmp20_);
					contents = _tmp21_;
					_tmp22_ = contents;
					if (g_strcmp0 (_tmp22_, "") == 0) {
						result = NULL;
						_g_free0 (contents);
						if (end_match_index) {
							*end_match_index = _vala_end_match_index;
						} else {
							_g_free0 (_vala_end_match_index);
						}
						return result;
					}
					_tmp23_ = next_index;
					_tmp24_ = __int_dup0 (&_tmp23_);
					_g_free0 (_vala_end_match_index);
					_vala_end_match_index = _tmp24_;
					result = contents;
					if (end_match_index) {
						*end_match_index = _vala_end_match_index;
					} else {
						_g_free0 (_vala_end_match_index);
					}
					return result;
				}
			}
		}
		_tmp25_ = end;
		if (_tmp25_) {
			result = NULL;
			if (end_match_index) {
				*end_match_index = _vala_end_match_index;
			} else {
				_g_free0 (_vala_end_match_index);
			}
			return result;
		}
		_tmp26_ = next_index;
		cur_index = _tmp26_;
	}
	if (end_match_index) {
		*end_match_index = _vala_end_match_index;
	} else {
		_g_free0 (_vala_end_match_index);
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gboolean document_structure_search_comment (DocumentStructure* self, const gchar* line, gint after_percent_index, StructType** type, gchar** contents, gint** end_match_index) {
	StructType* _vala_type = NULL;
	gchar* _vala_contents = NULL;
	gint* _vala_end_match_index = NULL;
	gboolean result = FALSE;
	gchar* text_after = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GMatchInfo* match_info = NULL;
	GRegex* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GMatchInfo* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	gchar* type_str = NULL;
	GMatchInfo* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	StructType _tmp12_ = 0;
	const gchar* _tmp13_ = NULL;
	StructType* _tmp14_ = NULL;
	GMatchInfo* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint* _tmp20_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_g_free0 (_vala_type);
	_vala_type = NULL;
	_g_free0 (_vala_contents);
	_vala_contents = NULL;
	_g_free0 (_vala_end_match_index);
	_vala_end_match_index = NULL;
	_tmp0_ = line;
	_tmp1_ = after_percent_index;
	_tmp2_ = string_substring (_tmp0_, (glong) _tmp1_, (glong) (-1));
	_tmp3_ = _tmp2_;
	_tmp4_ = string_strip (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	text_after = _tmp5_;
	_tmp6_ = document_structure__comment_regex;
	_tmp7_ = text_after;
	_tmp9_ = g_regex_match (_tmp6_, _tmp7_, 0, &_tmp8_);
	_g_match_info_unref0 (match_info);
	match_info = _tmp8_;
	if (!_tmp9_) {
		result = FALSE;
		_g_match_info_unref0 (match_info);
		_g_free0 (text_after);
		if (type) {
			*type = _vala_type;
		} else {
			_g_free0 (_vala_type);
		}
		if (contents) {
			*contents = _vala_contents;
		} else {
			_g_free0 (_vala_contents);
		}
		if (end_match_index) {
			*end_match_index = _vala_end_match_index;
		} else {
			_g_free0 (_vala_end_match_index);
		}
		return result;
	}
	_tmp10_ = match_info;
	_tmp11_ = g_match_info_fetch_named (_tmp10_, "type");
	type_str = _tmp11_;
	_tmp13_ = type_str;
	if (g_strcmp0 (_tmp13_, "TODO") == 0) {
		_tmp12_ = STRUCT_TYPE_TODO;
	} else {
		_tmp12_ = STRUCT_TYPE_FIXME;
	}
	_tmp14_ = __struct_type_dup0 (&_tmp12_);
	_g_free0 (_vala_type);
	_vala_type = _tmp14_;
	_tmp15_ = match_info;
	_tmp16_ = g_match_info_fetch_named (_tmp15_, "text");
	_g_free0 (_vala_contents);
	_vala_contents = _tmp16_;
	_tmp17_ = line;
	_tmp18_ = strlen (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = __int_dup0 (&_tmp19_);
	_g_free0 (_vala_end_match_index);
	_vala_end_match_index = _tmp20_;
	result = TRUE;
	_g_free0 (type_str);
	_g_match_info_unref0 (match_info);
	_g_free0 (text_after);
	if (type) {
		*type = _vala_type;
	} else {
		_g_free0 (_vala_type);
	}
	if (contents) {
		*contents = _vala_contents;
	} else {
		_g_free0 (_vala_contents);
	}
	if (end_match_index) {
		*end_match_index = _vala_end_match_index;
	} else {
		_g_free0 (_vala_end_match_index);
	}
	return result;
}


static void document_structure_handle_item (DocumentStructure* self, StructType type, const gchar* contents, GtkTextIter* iter) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
	StructType _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = self->priv->_in_verbatim_env;
	if (_tmp0_) {
		StructType _tmp1_ = 0;
		_tmp1_ = type;
		if (_tmp1_ == STRUCT_TYPE_END_VERBATIM) {
			self->priv->_in_verbatim_env = FALSE;
		}
		return;
	}
	_tmp3_ = type;
	if (_tmp3_ == STRUCT_TYPE_TODO) {
		_tmp2_ = TRUE;
	} else {
		StructType _tmp4_ = 0;
		_tmp4_ = type;
		_tmp2_ = _tmp4_ == STRUCT_TYPE_FIXME;
	}
	if (_tmp2_) {
		gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		StructType _tmp10_ = 0;
		GtkTextIter _tmp11_ = {0};
		GtkTreeIter* _tmp12_ = NULL;
		GtkTreeIter* _tmp13_ = NULL;
		_tmp6_ = contents;
		_tmp7_ = document_structure_truncate (self, _tmp6_);
		_tmp5_ = _tmp7_;
		if (_tmp5_ == NULL) {
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			_tmp8_ = contents;
			_tmp9_ = g_strdup (_tmp8_);
			_g_free0 (_tmp5_);
			_tmp5_ = _tmp9_;
		}
		_tmp10_ = type;
		_tmp11_ = *iter;
		_tmp12_ = document_structure_add_item (self, _tmp10_, _tmp5_, &_tmp11_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp13_);
		_g_free0 (_tmp5_);
	} else {
		StructType _tmp14_ = 0;
		gboolean _tmp15_ = FALSE;
		_tmp14_ = type;
		_tmp15_ = structure_is_common_type (_tmp14_);
		if (_tmp15_) {
			StructType _tmp16_ = 0;
			const gchar* _tmp17_ = NULL;
			GtkTextIter _tmp18_ = {0};
			GtkTreeIter* _tmp19_ = NULL;
			GtkTreeIter* _tmp20_ = NULL;
			_tmp16_ = type;
			_tmp17_ = contents;
			_tmp18_ = *iter;
			_tmp19_ = document_structure_add_item (self, _tmp16_, _tmp17_, &_tmp18_);
			_tmp20_ = _tmp19_;
			_g_free0 (_tmp20_);
		} else {
			StructType _tmp21_ = 0;
			_tmp21_ = type;
			if (_tmp21_ == STRUCT_TYPE_BEGIN_VERBATIM) {
				self->priv->_in_verbatim_env = TRUE;
			} else {
				gboolean _tmp22_ = FALSE;
				StructType _tmp23_ = 0;
				_tmp23_ = type;
				if (_tmp23_ == STRUCT_TYPE_BEGIN_FIGURE) {
					_tmp22_ = TRUE;
				} else {
					StructType _tmp24_ = 0;
					_tmp24_ = type;
					_tmp22_ = _tmp24_ == STRUCT_TYPE_BEGIN_TABLE;
				}
				if (_tmp22_) {
					StructType _tmp25_ = 0;
					GtkTextIter _tmp26_ = {0};
					_tmp25_ = type;
					_tmp26_ = *iter;
					document_structure_create_new_environment (self, _tmp25_, &_tmp26_);
				} else {
					gboolean _tmp27_ = FALSE;
					gboolean _tmp28_ = FALSE;
					StructType _tmp29_ = 0;
					_tmp29_ = type;
					if (_tmp29_ == STRUCT_TYPE_CAPTION) {
						DocumentStructureEnvData* _tmp30_ = NULL;
						_tmp30_ = self->priv->_last_env_data;
						_tmp28_ = _tmp30_ != NULL;
					} else {
						_tmp28_ = FALSE;
					}
					if (_tmp28_) {
						DocumentStructureEnvData* _tmp31_ = NULL;
						const gchar* _tmp32_ = NULL;
						_tmp31_ = self->priv->_last_env_data;
						_tmp32_ = (*_tmp31_).first_caption;
						_tmp27_ = _tmp32_ == NULL;
					} else {
						_tmp27_ = FALSE;
					}
					if (_tmp27_) {
						gchar* _tmp33_ = NULL;
						const gchar* _tmp34_ = NULL;
						gchar* _tmp35_ = NULL;
						DocumentStructureEnvData* _tmp38_ = NULL;
						gchar* _tmp39_ = NULL;
						_tmp34_ = contents;
						_tmp35_ = document_structure_truncate (self, _tmp34_);
						_tmp33_ = _tmp35_;
						if (_tmp33_ == NULL) {
							const gchar* _tmp36_ = NULL;
							gchar* _tmp37_ = NULL;
							_tmp36_ = contents;
							_tmp37_ = g_strdup (_tmp36_);
							_g_free0 (_tmp33_);
							_tmp33_ = _tmp37_;
						}
						_tmp38_ = self->priv->_last_env_data;
						_tmp39_ = _tmp33_;
						_tmp33_ = NULL;
						_g_free0 ((*_tmp38_).first_caption);
						(*_tmp38_).first_caption = _tmp39_;
						_g_free0 (_tmp33_);
					} else {
						StructType _tmp40_ = 0;
						gboolean _tmp41_ = FALSE;
						_tmp40_ = type;
						_tmp41_ = document_structure_verify_end_environment_type (self, _tmp40_);
						if (_tmp41_) {
							GtkTextMark* end_mark = NULL;
							GtkTextIter _tmp42_ = {0};
							GtkTextMark* _tmp43_ = NULL;
							StructureModel* _tmp44_ = NULL;
							DocumentStructureEnvData* _tmp45_ = NULL;
							GtkTreePath* _tmp46_ = NULL;
							DocumentStructureEnvData* _tmp47_ = NULL;
							const gchar* _tmp48_ = NULL;
							GtkTextMark* _tmp49_ = NULL;
							_tmp42_ = *iter;
							_tmp43_ = document_structure_create_text_mark_from_iter (self, &_tmp42_);
							end_mark = _tmp43_;
							_tmp44_ = self->priv->_model;
							_tmp45_ = self->priv->_last_env_data;
							_tmp46_ = (*_tmp45_).path;
							_tmp47_ = self->priv->_last_env_data;
							_tmp48_ = (*_tmp47_).first_caption;
							_tmp49_ = end_mark;
							structure_model_modify_data (_tmp44_, _tmp46_, _tmp48_, _tmp49_);
							_document_structure_env_data_free0 (self->priv->_last_env_data);
							self->priv->_last_env_data = NULL;
							_g_object_unref0 (end_mark);
						} else {
							StructType _tmp50_ = 0;
							_tmp50_ = type;
							if (_tmp50_ == STRUCT_TYPE_END_DOCUMENT) {
								GtkTextIter _tmp51_ = {0};
								GtkTextMark* _tmp52_ = NULL;
								_tmp51_ = *iter;
								_tmp52_ = document_structure_create_text_mark_from_iter (self, &_tmp51_);
								_g_object_unref0 (self->priv->_end_document_mark);
								self->priv->_end_document_mark = _tmp52_;
							}
						}
					}
				}
			}
		}
	}
}


static gpointer _document_structure_env_data_dup0 (gpointer self) {
	return self ? document_structure_env_data_dup (self) : NULL;
}


static void document_structure_create_new_environment (DocumentStructure* self, StructType type, GtkTextIter* start_iter) {
	gboolean _tmp0_ = FALSE;
	StructType _tmp1_ = 0;
	DocumentStructureEnvData _tmp3_ = {0};
	DocumentStructureEnvData _tmp4_ = {0};
	DocumentStructureEnvData* _tmp5_ = NULL;
	DocumentStructureEnvData* _tmp6_ = NULL;
	StructType _tmp7_ = 0;
	GtkTreeIter tree_iter = {0};
	DocumentStructureEnvData* _tmp10_ = NULL;
	StructType _tmp11_ = 0;
	GtkTextIter _tmp12_ = {0};
	GtkTreeIter* _tmp13_ = NULL;
	GtkTreeIter* _tmp14_ = NULL;
	GtkTreeIter _tmp15_ = {0};
	DocumentStructureEnvData* _tmp16_ = NULL;
	StructureModel* _tmp17_ = NULL;
	GtkTreeIter _tmp18_ = {0};
	GtkTreePath* _tmp19_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (start_iter != NULL);
	_tmp1_ = type;
	if (_tmp1_ == STRUCT_TYPE_BEGIN_FIGURE) {
		_tmp0_ = TRUE;
	} else {
		StructType _tmp2_ = 0;
		_tmp2_ = type;
		_tmp0_ = _tmp2_ == STRUCT_TYPE_BEGIN_TABLE;
	}
	g_return_if_fail (_tmp0_);
	memset (&_tmp3_, 0, sizeof (DocumentStructureEnvData));
	_tmp4_ = _tmp3_;
	_tmp5_ = _document_structure_env_data_dup0 (&_tmp4_);
	_document_structure_env_data_free0 (self->priv->_last_env_data);
	self->priv->_last_env_data = _tmp5_;
	document_structure_env_data_destroy (&_tmp4_);
	_tmp6_ = self->priv->_last_env_data;
	_g_free0 ((*_tmp6_).first_caption);
	(*_tmp6_).first_caption = NULL;
	_tmp7_ = type;
	if (_tmp7_ == STRUCT_TYPE_BEGIN_TABLE) {
		DocumentStructureEnvData* _tmp8_ = NULL;
		_tmp8_ = self->priv->_last_env_data;
		(*_tmp8_).type = STRUCT_TYPE_TABLE;
	} else {
		DocumentStructureEnvData* _tmp9_ = NULL;
		_tmp9_ = self->priv->_last_env_data;
		(*_tmp9_).type = STRUCT_TYPE_FIGURE;
	}
	_tmp10_ = self->priv->_last_env_data;
	_tmp11_ = (*_tmp10_).type;
	_tmp12_ = *start_iter;
	_tmp13_ = document_structure_add_item (self, _tmp11_, NULL, &_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = *_tmp14_;
	_g_free0 (_tmp14_);
	tree_iter = _tmp15_;
	_tmp16_ = self->priv->_last_env_data;
	_tmp17_ = self->priv->_model;
	_tmp18_ = tree_iter;
	_tmp19_ = gtk_tree_model_get_path ((GtkTreeModel*) _tmp17_, &_tmp18_);
	_gtk_tree_path_free0 ((*_tmp16_).path);
	(*_tmp16_).path = _tmp19_;
}


static gboolean document_structure_verify_end_environment_type (DocumentStructure* self, StructType type) {
	gboolean result = FALSE;
	DocumentStructureEnvData* _tmp0_ = NULL;
	StructType _tmp1_ = 0;
	StructType _tmp4_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_last_env_data;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = type;
	if (_tmp1_ == STRUCT_TYPE_END_TABLE) {
		DocumentStructureEnvData* _tmp2_ = NULL;
		StructType _tmp3_ = 0;
		_tmp2_ = self->priv->_last_env_data;
		_tmp3_ = (*_tmp2_).type;
		result = _tmp3_ == STRUCT_TYPE_TABLE;
		return result;
	}
	_tmp4_ = type;
	if (_tmp4_ == STRUCT_TYPE_END_FIGURE) {
		DocumentStructureEnvData* _tmp5_ = NULL;
		StructType _tmp6_ = 0;
		_tmp5_ = self->priv->_last_env_data;
		_tmp6_ = (*_tmp5_).type;
		result = _tmp6_ == STRUCT_TYPE_FIGURE;
		return result;
	}
	result = FALSE;
	return result;
}


static GtkTreeIter* document_structure_add_item (DocumentStructure* self, StructType type, const gchar* text, GtkTextIter* start_iter) {
	GtkTreeIter* result = NULL;
	StructData data = {0};
	StructData _tmp0_ = {0};
	StructType _tmp1_ = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GtkTextIter _tmp4_ = {0};
	GtkTextMark* _tmp5_ = NULL;
	StructData _tmp6_ = {0};
	GtkTreeIter* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (start_iter != NULL, NULL);
	data = _tmp0_;
	_tmp1_ = type;
	data.type = _tmp1_;
	_tmp2_ = text;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (data.text);
	data.text = _tmp3_;
	_tmp4_ = *start_iter;
	_tmp5_ = document_structure_create_text_mark_from_iter (self, &_tmp4_);
	_g_object_unref0 (data.start_mark);
	data.start_mark = _tmp5_;
	_g_object_unref0 (data.end_mark);
	data.end_mark = NULL;
	_tmp6_ = data;
	_tmp7_ = document_structure_add_item_data (self, &_tmp6_);
	result = _tmp7_;
	struct_data_destroy (&data);
	return result;
}


static GtkTreeIter* document_structure_add_item_data (DocumentStructure* self, StructData* data) {
	GtkTreeIter* result = NULL;
	StructData _tmp0_ = {0};
	const gchar* _tmp1_ = NULL;
	StructureModel* _tmp3_ = NULL;
	StructData _tmp4_ = {0};
	GtkTreeIter* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.text;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_ = NULL;
		_tmp2_ = g_strdup ("");
		_g_free0 ((*data).text);
		(*data).text = _tmp2_;
	}
	_tmp3_ = self->priv->_model;
	_tmp4_ = *data;
	_tmp5_ = structure_model_add_item_at_end (_tmp3_, &_tmp4_);
	result = _tmp5_;
	return result;
}


static GtkTextMark* document_structure_create_text_mark_from_iter (DocumentStructure* self, GtkTextIter* iter) {
	GtkTextMark* result = NULL;
	GtkTextBuffer* doc = NULL;
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	gchar* name = NULL;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GtkTextMark* mark = NULL;
	GtkTextIter _tmp7_ = {0};
	GtkTextMark* _tmp8_ = NULL;
	GtkTextMark* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = gtk_text_iter_get_buffer (iter);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	doc = _tmp1_;
	_tmp2_ = self->priv->_nb_marks;
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (DOCUMENT_STRUCTURE_MARK_NAME_PREFIX, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	name = _tmp6_;
	_tmp7_ = *iter;
	_tmp8_ = gtk_text_buffer_create_mark (doc, name, &_tmp7_, FALSE);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	mark = _tmp9_;
	_tmp10_ = self->priv->_nb_marks;
	self->priv->_nb_marks = _tmp10_ + 1;
	result = mark;
	_g_free0 (name);
	_g_object_unref0 (doc);
	return result;
}


static void document_structure_clear_all_structure_marks (DocumentStructure* self) {
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
				gchar* mark_name = NULL;
				gint _tmp4_ = 0;
				gchar* _tmp5_ = NULL;
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
				GtkTextMark* mark = NULL;
				Document* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				GtkTextMark* _tmp11_ = NULL;
				GtkTextMark* _tmp12_ = NULL;
				GtkTextMark* _tmp13_ = NULL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->_nb_marks;
				if (!(_tmp2_ < _tmp3_)) {
					break;
				}
				_tmp4_ = i;
				_tmp5_ = g_strdup_printf ("%i", _tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_strconcat (DOCUMENT_STRUCTURE_MARK_NAME_PREFIX, _tmp6_, NULL);
				_tmp8_ = _tmp7_;
				_g_free0 (_tmp6_);
				mark_name = _tmp8_;
				_tmp9_ = self->priv->_doc;
				_tmp10_ = mark_name;
				_tmp11_ = gtk_text_buffer_get_mark ((GtkTextBuffer*) _tmp9_, _tmp10_);
				_tmp12_ = _g_object_ref0 (_tmp11_);
				mark = _tmp12_;
				_tmp13_ = mark;
				if (_tmp13_ != NULL) {
					Document* _tmp14_ = NULL;
					GtkTextMark* _tmp15_ = NULL;
					_tmp14_ = self->priv->_doc;
					_tmp15_ = mark;
					gtk_text_buffer_delete_mark ((GtkTextBuffer*) _tmp14_, _tmp15_);
				}
				_g_object_unref0 (mark);
				_g_free0 (mark_name);
			}
		}
	}
	self->priv->_nb_marks = 0;
}


static gint string_index_of_nth_char (const gchar* self, glong c) {
	gint result = 0;
	glong _tmp0_ = 0L;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = c;
	_tmp1_ = g_utf8_offset_to_pointer (self, _tmp0_);
	result = (gint) (_tmp1_ - ((gchar*) self));
	return result;
}


static gchar* document_structure_truncate (DocumentStructure* self, const gchar* text) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint index = 0;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = text;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = text;
	_tmp2_ = g_utf8_strlen (_tmp1_, (gssize) (-1));
	if (_tmp2_ <= DOCUMENT_STRUCTURE_ITEM_MAX_LENGTH) {
		result = NULL;
		return result;
	}
	_tmp3_ = text;
	_tmp4_ = string_index_of_nth_char (_tmp3_, (glong) DOCUMENT_STRUCTURE_ITEM_MAX_LENGTH);
	index = _tmp4_;
	_tmp5_ = text;
	_tmp6_ = index;
	_tmp7_ = string_substring (_tmp5_, (glong) 0, (glong) _tmp6_);
	result = _tmp7_;
	return result;
}


static StructType* document_structure_get_markup_type (DocumentStructure* self, const gchar* markup_name) {
	StructType* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	static GQuark _tmp2_label8 = 0;
	static GQuark _tmp2_label9 = 0;
	static GQuark _tmp2_label10 = 0;
	static GQuark _tmp2_label11 = 0;
	static GQuark _tmp2_label12 = 0;
	static GQuark _tmp2_label13 = 0;
	static GQuark _tmp2_label14 = 0;
	static GQuark _tmp2_label15 = 0;
	static GQuark _tmp2_label16 = 0;
	static GQuark _tmp2_label17 = 0;
	static GQuark _tmp2_label18 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (markup_name != NULL, NULL);
	_tmp0_ = markup_name;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if ((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("part")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("part*"))))) {
		switch (0) {
			default:
			{
				StructType _tmp4_ = 0;
				StructType* _tmp5_ = NULL;
				_tmp4_ = STRUCT_TYPE_PART;
				_tmp5_ = __struct_type_dup0 (&_tmp4_);
				result = _tmp5_;
				return result;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("chapter")))) || (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("chapter*"))))) {
		switch (0) {
			default:
			{
				StructType _tmp6_ = 0;
				StructType* _tmp7_ = NULL;
				_tmp6_ = STRUCT_TYPE_CHAPTER;
				_tmp7_ = __struct_type_dup0 (&_tmp6_);
				result = _tmp7_;
				return result;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("section")))) || (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("section*"))))) {
		switch (0) {
			default:
			{
				StructType _tmp8_ = 0;
				StructType* _tmp9_ = NULL;
				_tmp8_ = STRUCT_TYPE_SECTION;
				_tmp9_ = __struct_type_dup0 (&_tmp8_);
				result = _tmp9_;
				return result;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("subsection")))) || (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("subsection*"))))) {
		switch (0) {
			default:
			{
				StructType _tmp10_ = 0;
				StructType* _tmp11_ = NULL;
				_tmp10_ = STRUCT_TYPE_SUBSECTION;
				_tmp11_ = __struct_type_dup0 (&_tmp10_);
				result = _tmp11_;
				return result;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("subsubsection")))) || (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string ("subsubsection*"))))) {
		switch (0) {
			default:
			{
				StructType _tmp12_ = 0;
				StructType* _tmp13_ = NULL;
				_tmp12_ = STRUCT_TYPE_SUBSUBSECTION;
				_tmp13_ = __struct_type_dup0 (&_tmp12_);
				result = _tmp13_;
				return result;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label10) ? _tmp2_label10 : (_tmp2_label10 = g_quark_from_static_string ("paragraph")))) || (_tmp3_ == ((0 != _tmp2_label11) ? _tmp2_label11 : (_tmp2_label11 = g_quark_from_static_string ("paragraph*"))))) {
		switch (0) {
			default:
			{
				StructType _tmp14_ = 0;
				StructType* _tmp15_ = NULL;
				_tmp14_ = STRUCT_TYPE_PARAGRAPH;
				_tmp15_ = __struct_type_dup0 (&_tmp14_);
				result = _tmp15_;
				return result;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label12) ? _tmp2_label12 : (_tmp2_label12 = g_quark_from_static_string ("subparagraph")))) || (_tmp3_ == ((0 != _tmp2_label13) ? _tmp2_label13 : (_tmp2_label13 = g_quark_from_static_string ("subparagraph*"))))) {
		switch (0) {
			default:
			{
				StructType _tmp16_ = 0;
				StructType* _tmp17_ = NULL;
				_tmp16_ = STRUCT_TYPE_SUBPARAGRAPH;
				_tmp17_ = __struct_type_dup0 (&_tmp16_);
				result = _tmp17_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label14) ? _tmp2_label14 : (_tmp2_label14 = g_quark_from_static_string ("label")))) {
		switch (0) {
			default:
			{
				StructType _tmp18_ = 0;
				StructType* _tmp19_ = NULL;
				_tmp18_ = STRUCT_TYPE_LABEL;
				_tmp19_ = __struct_type_dup0 (&_tmp18_);
				result = _tmp19_;
				return result;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label15) ? _tmp2_label15 : (_tmp2_label15 = g_quark_from_static_string ("input")))) || (_tmp3_ == ((0 != _tmp2_label16) ? _tmp2_label16 : (_tmp2_label16 = g_quark_from_static_string ("include"))))) {
		switch (0) {
			default:
			{
				StructType _tmp20_ = 0;
				StructType* _tmp21_ = NULL;
				_tmp20_ = STRUCT_TYPE_INCLUDE;
				_tmp21_ = __struct_type_dup0 (&_tmp20_);
				result = _tmp21_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label17) ? _tmp2_label17 : (_tmp2_label17 = g_quark_from_static_string ("includegraphics")))) {
		switch (0) {
			default:
			{
				StructType _tmp22_ = 0;
				StructType* _tmp23_ = NULL;
				_tmp22_ = STRUCT_TYPE_IMAGE;
				_tmp23_ = __struct_type_dup0 (&_tmp22_);
				result = _tmp23_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label18) ? _tmp2_label18 : (_tmp2_label18 = g_quark_from_static_string ("caption")))) {
		switch (0) {
			default:
			{
				StructType _tmp24_ = 0;
				StructType* _tmp25_ = NULL;
				_tmp24_ = STRUCT_TYPE_CAPTION;
				_tmp25_ = __struct_type_dup0 (&_tmp24_);
				result = _tmp25_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = NULL;
				return result;
			}
		}
	}
}


static gchar* document_structure_get_line_contents_at_iter (DocumentStructure* self, GtkTextIter* iter) {
	gchar* result = NULL;
	GtkTextIter begin_line = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter end_line = {0};
	GtkTextIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GtkTextBuffer* buffer = NULL;
	GtkTextBuffer* _tmp3_ = NULL;
	GtkTextBuffer* _tmp4_ = NULL;
	GtkTextIter _tmp5_ = {0};
	GtkTextIter _tmp6_ = {0};
	gchar* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = *iter;
	begin_line = _tmp0_;
	gtk_text_iter_set_line_offset (&begin_line, 0);
	_tmp1_ = *iter;
	end_line = _tmp1_;
	_tmp2_ = gtk_text_iter_ends_line (iter);
	if (!_tmp2_) {
		gtk_text_iter_forward_to_line_end (&end_line);
	}
	_tmp3_ = gtk_text_iter_get_buffer (iter);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	buffer = _tmp4_;
	_tmp5_ = begin_line;
	_tmp6_ = end_line;
	_tmp7_ = gtk_text_buffer_get_text (buffer, &_tmp5_, &_tmp6_, FALSE);
	result = _tmp7_;
	_g_object_unref0 (buffer);
	return result;
}


/*************************************************************************/
void document_structure_do_action (DocumentStructure* self, StructAction action_type, GtkTreeIter* tree_iter, gboolean* refresh_simple_list, GError** error) {
	gboolean _vala_refresh_simple_list = FALSE;
	StructAction _tmp0_ = 0;
	gboolean shift_right = FALSE;
	StructAction _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	gboolean found = FALSE;
	GtkTreeIter _tmp32_ = {0};
	GtkTextIter _tmp33_ = {0};
	GtkTextIter _tmp34_ = {0};
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	StructAction _tmp40_ = 0;
	gboolean _tmp44_ = FALSE;
	StructAction _tmp45_ = 0;
	gboolean _tmp55_ = FALSE;
	StructAction _tmp56_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tree_iter != NULL);
	_vala_refresh_simple_list = FALSE;
	_tmp0_ = action_type;
	if (_tmp0_ == STRUCT_ACTION_COMMENT) {
		GtkTreeIter _tmp1_ = {0};
		gboolean _tmp2_ = FALSE;
		StructureModel* _tmp4_ = NULL;
		GtkTreeIter _tmp5_ = {0};
		_tmp1_ = *tree_iter;
		_tmp2_ = document_structure_comment_item (self, &_tmp1_);
		if (!_tmp2_) {
			GError* _tmp3_ = NULL;
			_tmp3_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_DATA_OUTDATED, "");
			_inner_error_ = _tmp3_;
			if (_inner_error_->domain == STRUCT_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp4_ = self->priv->_model;
		_tmp5_ = *tree_iter;
		structure_model_delete (_tmp4_, &_tmp5_);
		_vala_refresh_simple_list = TRUE;
		if (refresh_simple_list) {
			*refresh_simple_list = _vala_refresh_simple_list;
		}
		return;
	}
	_tmp6_ = action_type;
	shift_right = _tmp6_ == STRUCT_ACTION_SHIFT_RIGHT;
	_tmp8_ = shift_right;
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		StructAction _tmp9_ = 0;
		_tmp9_ = action_type;
		_tmp7_ = _tmp9_ == STRUCT_ACTION_SHIFT_LEFT;
	}
	if (_tmp7_) {
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		Document* _tmp17_ = NULL;
		gboolean doc_modified = FALSE;
		gboolean success = FALSE;
		GtkTreeIter _tmp18_ = {0};
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_ = FALSE;
		Document* _tmp22_ = NULL;
		gboolean _tmp23_ = FALSE;
		gboolean _tmp27_ = FALSE;
		_tmp11_ = shift_right;
		if (_tmp11_) {
			StructureModel* _tmp12_ = NULL;
			GtkTreeIter _tmp13_ = {0};
			gboolean _tmp14_ = FALSE;
			_tmp12_ = self->priv->_model;
			_tmp13_ = *tree_iter;
			_tmp14_ = structure_model_item_contains_subparagraph (_tmp12_, &_tmp13_);
			_tmp10_ = _tmp14_;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			const gchar* _tmp15_ = NULL;
			GError* _tmp16_ = NULL;
			_tmp15_ = _ ("The structure item already contains a sub-paragraph.");
			_tmp16_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_GENERAL, _tmp15_);
			_inner_error_ = _tmp16_;
			if (_inner_error_->domain == STRUCT_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp17_ = self->priv->_doc;
		gtk_text_buffer_begin_user_action ((GtkTextBuffer*) _tmp17_);
		_tmp18_ = *tree_iter;
		_tmp19_ = shift_right;
		_tmp21_ = document_structure_shift_item (self, &_tmp18_, _tmp19_, &_tmp20_);
		doc_modified = _tmp20_;
		success = _tmp21_;
		_tmp22_ = self->priv->_doc;
		gtk_text_buffer_end_user_action ((GtkTextBuffer*) _tmp22_);
		_tmp23_ = success;
		if (!_tmp23_) {
			gboolean _tmp24_ = FALSE;
			GError* _tmp26_ = NULL;
			_tmp24_ = doc_modified;
			if (_tmp24_) {
				Document* _tmp25_ = NULL;
				_tmp25_ = self->priv->_doc;
				gtk_source_buffer_undo ((GtkSourceBuffer*) _tmp25_);
			}
			_tmp26_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_DATA_OUTDATED, "");
			_inner_error_ = _tmp26_;
			if (_inner_error_->domain == STRUCT_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp27_ = shift_right;
		if (_tmp27_) {
			StructureModel* _tmp28_ = NULL;
			GtkTreeIter _tmp29_ = {0};
			_tmp28_ = self->priv->_model;
			_tmp29_ = *tree_iter;
			structure_model_shift_right (_tmp28_, &_tmp29_);
		} else {
			StructureModel* _tmp30_ = NULL;
			GtkTreeIter _tmp31_ = {0};
			_tmp30_ = self->priv->_model;
			_tmp31_ = *tree_iter;
			structure_model_shift_left (_tmp30_, &_tmp31_);
		}
		if (refresh_simple_list) {
			*refresh_simple_list = _vala_refresh_simple_list;
		}
		return;
	}
	_tmp32_ = *tree_iter;
	_tmp35_ = document_structure_get_exact_item_bounds (self, &_tmp32_, &_tmp33_, &_tmp34_);
	start_iter = _tmp33_;
	end_iter = _tmp34_;
	found = _tmp35_;
	_tmp36_ = found;
	if (!_tmp36_) {
		GError* _tmp37_ = NULL;
		_tmp37_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_DATA_OUTDATED, "");
		_inner_error_ = _tmp37_;
		if (_inner_error_->domain == STRUCT_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp38_ = gtk_text_iter_get_line (&start_iter);
	_tmp39_ = gtk_text_iter_get_line (&end_iter);
	if (_tmp38_ != _tmp39_) {
		document_structure_backward_indentation (self, &start_iter);
		document_structure_backward_indentation (self, &end_iter);
	}
	_tmp40_ = action_type;
	if (_tmp40_ == STRUCT_ACTION_SELECT) {
		Document* _tmp41_ = NULL;
		GtkTextIter _tmp42_ = {0};
		GtkTextIter _tmp43_ = {0};
		_tmp41_ = self->priv->_doc;
		_tmp42_ = start_iter;
		_tmp43_ = end_iter;
		gtk_text_buffer_select_range ((GtkTextBuffer*) _tmp41_, &_tmp42_, &_tmp43_);
		if (refresh_simple_list) {
			*refresh_simple_list = _vala_refresh_simple_list;
		}
		return;
	}
	_tmp45_ = action_type;
	if (_tmp45_ == STRUCT_ACTION_COPY) {
		_tmp44_ = TRUE;
	} else {
		StructAction _tmp46_ = 0;
		_tmp46_ = action_type;
		_tmp44_ = _tmp46_ == STRUCT_ACTION_CUT;
	}
	if (_tmp44_) {
		gchar* data = NULL;
		Document* _tmp47_ = NULL;
		GtkTextIter _tmp48_ = {0};
		GtkTextIter _tmp49_ = {0};
		gchar* _tmp50_ = NULL;
		GtkClipboard* clipboard = NULL;
		GtkClipboard* _tmp51_ = NULL;
		GtkClipboard* _tmp52_ = NULL;
		GtkClipboard* _tmp53_ = NULL;
		const gchar* _tmp54_ = NULL;
		_tmp47_ = self->priv->_doc;
		_tmp48_ = start_iter;
		_tmp49_ = end_iter;
		_tmp50_ = gtk_text_buffer_get_text ((GtkTextBuffer*) _tmp47_, &_tmp48_, &_tmp49_, FALSE);
		data = _tmp50_;
		_tmp51_ = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
		_tmp52_ = _g_object_ref0 (_tmp51_);
		clipboard = _tmp52_;
		_tmp53_ = clipboard;
		_tmp54_ = data;
		gtk_clipboard_set_text (_tmp53_, _tmp54_, -1);
		_g_object_unref0 (clipboard);
		_g_free0 (data);
	}
	_tmp56_ = action_type;
	if (_tmp56_ == STRUCT_ACTION_DELETE) {
		_tmp55_ = TRUE;
	} else {
		StructAction _tmp57_ = 0;
		_tmp57_ = action_type;
		_tmp55_ = _tmp57_ == STRUCT_ACTION_CUT;
	}
	if (_tmp55_) {
		Document* _tmp58_ = NULL;
		Document* _tmp59_ = NULL;
		Document* _tmp60_ = NULL;
		StructureModel* _tmp61_ = NULL;
		GtkTreeIter _tmp62_ = {0};
		_tmp58_ = self->priv->_doc;
		gtk_text_buffer_begin_user_action ((GtkTextBuffer*) _tmp58_);
		_tmp59_ = self->priv->_doc;
		gtk_text_buffer_delete ((GtkTextBuffer*) _tmp59_, &start_iter, &end_iter);
		_tmp60_ = self->priv->_doc;
		gtk_text_buffer_end_user_action ((GtkTextBuffer*) _tmp60_);
		_tmp61_ = self->priv->_model;
		_tmp62_ = *tree_iter;
		structure_model_delete (_tmp61_, &_tmp62_);
		_vala_refresh_simple_list = TRUE;
	}
	if (refresh_simple_list) {
		*refresh_simple_list = _vala_refresh_simple_list;
	}
}


static gboolean document_structure_comment_item (DocumentStructure* self, GtkTreeIter* tree_iter) {
	gboolean result = FALSE;
	StructType type = 0;
	GtkTextMark* start_mark = NULL;
	GtkTextMark* end_mark = NULL;
	StructureModel* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	GtkTextIter _tmp2_ = {0};
	gboolean end_iter_set = FALSE;
	Document* _tmp3_ = NULL;
	GtkTextMark* _tmp4_ = NULL;
	GtkTextIter _tmp5_ = {0};
	GtkTextMark* _tmp6_ = NULL;
	StructType _tmp10_ = 0;
	gboolean _tmp11_ = FALSE;
	GtkTreeIter* next_section_iter = NULL;
	gboolean go_one_line_backward = FALSE;
	GtkTreeIter* _tmp23_ = NULL;
	gboolean _tmp33_ = FALSE;
	Document* _tmp35_ = NULL;
	GtkTextIter _tmp36_ = {0};
	GtkTextIter _tmp37_ = {0};
	gboolean _tmp38_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tree_iter != NULL, FALSE);
	start_mark = NULL;
	end_mark = NULL;
	_tmp0_ = self->priv->_model;
	_tmp1_ = *tree_iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, STRUCT_COLUMN_TYPE, &type, STRUCT_COLUMN_START_MARK, &start_mark, STRUCT_COLUMN_END_MARK, &end_mark, -1, -1);
	end_iter = _tmp2_;
	end_iter_set = FALSE;
	_tmp3_ = self->priv->_doc;
	_tmp4_ = start_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp3_, &_tmp5_, _tmp4_);
	start_iter = _tmp5_;
	_tmp6_ = end_mark;
	if (_tmp6_ != NULL) {
		Document* _tmp7_ = NULL;
		GtkTextMark* _tmp8_ = NULL;
		GtkTextIter _tmp9_ = {0};
		_tmp7_ = self->priv->_doc;
		_tmp8_ = end_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp7_, &_tmp9_, _tmp8_);
		end_iter = _tmp9_;
		end_iter_set = TRUE;
	}
	_tmp10_ = type;
	_tmp11_ = structure_is_section (_tmp10_);
	if (!_tmp11_) {
		Document* _tmp12_ = NULL;
		GtkTextIter _tmp13_ = {0};
		GtkTextIter _tmp14_ = {0};
		gboolean _tmp15_ = FALSE;
		_tmp12_ = self->priv->_doc;
		_tmp13_ = start_iter;
		_tmp14_ = end_iter;
		_tmp15_ = end_iter_set;
		document_comment_between (_tmp12_, &_tmp13_, &_tmp14_, _tmp15_);
		result = TRUE;
		_g_object_unref0 (end_mark);
		_g_object_unref0 (start_mark);
		return result;
	}
	next_section_iter = NULL;
	{
		GtkTreeIter* _tmp16_ = NULL;
		StructureModel* _tmp17_ = NULL;
		GtkTreeIter _tmp18_ = {0};
		GtkTreeIter* _tmp19_ = NULL;
		GtkTreeIter* _tmp20_ = NULL;
		_tmp17_ = self->priv->_model;
		_tmp18_ = *tree_iter;
		_tmp19_ = structure_model_get_next_sibling_or_parent (_tmp17_, &_tmp18_, &_inner_error_);
		_tmp16_ = _tmp19_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == STRUCT_ERROR) {
				goto __catch16_struct_error;
			}
			_g_free0 (next_section_iter);
			_g_object_unref0 (end_mark);
			_g_object_unref0 (start_mark);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp20_ = _tmp16_;
		_tmp16_ = NULL;
		_g_free0 (next_section_iter);
		next_section_iter = _tmp20_;
		_g_free0 (_tmp16_);
	}
	goto __finally16;
	__catch16_struct_error:
	{
		GError* e = NULL;
		GError* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp21_ = e;
		_tmp22_ = _tmp21_->message;
		g_warning ("document_structure.vala:823: Structure: get next sibling or parent: %s", _tmp22_);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (next_section_iter);
		_g_object_unref0 (end_mark);
		_g_object_unref0 (start_mark);
		return result;
	}
	__finally16:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (next_section_iter);
		_g_object_unref0 (end_mark);
		_g_object_unref0 (start_mark);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	go_one_line_backward = TRUE;
	_tmp23_ = next_section_iter;
	if (_tmp23_ == NULL) {
		gboolean end_of_file = FALSE;
		gboolean _tmp24_ = FALSE;
		GtkTextIter _tmp25_ = {0};
		gboolean _tmp26_ = FALSE;
		document_structure_get_end_document_iter (self, &_tmp24_, &_tmp25_);
		end_of_file = _tmp24_;
		end_iter = _tmp25_;
		end_iter_set = TRUE;
		_tmp26_ = end_of_file;
		go_one_line_backward = !_tmp26_;
	} else {
		StructureModel* _tmp27_ = NULL;
		GtkTreeIter* _tmp28_ = NULL;
		GtkTreeIter _tmp29_ = {0};
		Document* _tmp30_ = NULL;
		GtkTextMark* _tmp31_ = NULL;
		GtkTextIter _tmp32_ = {0};
		_tmp27_ = self->priv->_model;
		_tmp28_ = next_section_iter;
		_tmp29_ = *_tmp28_;
		gtk_tree_model_get ((GtkTreeModel*) _tmp27_, &_tmp29_, STRUCT_COLUMN_START_MARK, &end_mark, -1, -1);
		_tmp30_ = self->priv->_doc;
		_tmp31_ = end_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp30_, &_tmp32_, _tmp31_);
		end_iter = _tmp32_;
		end_iter_set = TRUE;
	}
	_tmp33_ = go_one_line_backward;
	if (_tmp33_) {
		gboolean _tmp34_ = FALSE;
		_tmp34_ = gtk_text_iter_backward_line (&end_iter);
		if (!_tmp34_) {
			end_iter_set = FALSE;
		}
	}
	_tmp35_ = self->priv->_doc;
	_tmp36_ = start_iter;
	_tmp37_ = end_iter;
	_tmp38_ = end_iter_set;
	document_comment_between (_tmp35_, &_tmp36_, &_tmp37_, _tmp38_);
	result = TRUE;
	_g_free0 (next_section_iter);
	_g_object_unref0 (end_mark);
	_g_object_unref0 (start_mark);
	return result;
}


static gboolean document_structure_get_exact_item_bounds (DocumentStructure* self, GtkTreeIter* tree_iter, GtkTextIter* start_iter, GtkTextIter* end_iter) {
	GtkTextIter _vala_start_iter = {0};
	GtkTextIter _vala_end_iter = {0};
	gboolean result = FALSE;
	StructType item_type = 0;
	GtkTextMark* start_mark = NULL;
	GtkTextMark* end_mark = NULL;
	gchar* item_contents = NULL;
	StructureModel* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	Document* _tmp2_ = NULL;
	GtkTextMark* _tmp3_ = NULL;
	GtkTextIter _tmp4_ = {0};
	gboolean found = FALSE;
	StructType _tmp5_ = 0;
	const gchar* _tmp6_ = NULL;
	GtkTextIter _tmp7_ = {0};
	GtkTextIter _tmp8_ = {0};
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	StructType _tmp11_ = 0;
	gboolean _tmp12_ = FALSE;
	GtkTextMark* _tmp34_ = NULL;
	GtkTextIter end_env_iter = {0};
	Document* _tmp35_ = NULL;
	GtkTextMark* _tmp36_ = NULL;
	GtkTextIter _tmp37_ = {0};
	StructType _tmp38_ = 0;
	const gchar* _tmp39_ = NULL;
	GtkTextIter _tmp40_ = {0};
	GtkTextIter _tmp41_ = {0};
	gboolean _tmp42_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tree_iter != NULL, FALSE);
	start_mark = NULL;
	end_mark = NULL;
	item_contents = NULL;
	_tmp0_ = self->priv->_model;
	_tmp1_ = *tree_iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, STRUCT_COLUMN_TYPE, &item_type, STRUCT_COLUMN_START_MARK, &start_mark, STRUCT_COLUMN_END_MARK, &end_mark, STRUCT_COLUMN_TEXT, &item_contents, -1, -1);
	_tmp2_ = self->priv->_doc;
	_tmp3_ = start_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp2_, &_tmp4_, _tmp3_);
	_vala_start_iter = _tmp4_;
	_tmp5_ = item_type;
	_tmp6_ = item_contents;
	_tmp7_ = _vala_start_iter;
	_tmp9_ = document_structure_get_low_level_item_bounds (self, _tmp5_, _tmp6_, &_tmp7_, TRUE, &_tmp8_);
	_vala_end_iter = _tmp8_;
	found = _tmp9_;
	_tmp10_ = found;
	if (!_tmp10_) {
		result = FALSE;
		_g_free0 (item_contents);
		_g_object_unref0 (end_mark);
		_g_object_unref0 (start_mark);
		if (start_iter) {
			*start_iter = _vala_start_iter;
		}
		if (end_iter) {
			*end_iter = _vala_end_iter;
		}
		return result;
	}
	_tmp11_ = item_type;
	_tmp12_ = structure_is_section (_tmp11_);
	if (_tmp12_) {
		GtkTreeIter* next_section_iter = NULL;
		GtkTreeIter* _tmp20_ = NULL;
		StructureModel* _tmp22_ = NULL;
		GtkTreeIter* _tmp23_ = NULL;
		GtkTreeIter _tmp24_ = {0};
		Document* _tmp25_ = NULL;
		GtkTextMark* _tmp26_ = NULL;
		GtkTextIter _tmp27_ = {0};
		StructType _tmp28_ = 0;
		const gchar* _tmp29_ = NULL;
		GtkTextIter _tmp30_ = {0};
		gboolean _tmp31_ = FALSE;
		next_section_iter = NULL;
		{
			GtkTreeIter* _tmp13_ = NULL;
			StructureModel* _tmp14_ = NULL;
			GtkTreeIter _tmp15_ = {0};
			GtkTreeIter* _tmp16_ = NULL;
			GtkTreeIter* _tmp17_ = NULL;
			_tmp14_ = self->priv->_model;
			_tmp15_ = *tree_iter;
			_tmp16_ = structure_model_get_next_sibling_or_parent (_tmp14_, &_tmp15_, &_inner_error_);
			_tmp13_ = _tmp16_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == STRUCT_ERROR) {
					goto __catch17_struct_error;
				}
				_g_free0 (next_section_iter);
				_g_free0 (item_contents);
				_g_object_unref0 (end_mark);
				_g_object_unref0 (start_mark);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			_tmp17_ = _tmp13_;
			_tmp13_ = NULL;
			_g_free0 (next_section_iter);
			next_section_iter = _tmp17_;
			_g_free0 (_tmp13_);
		}
		goto __finally17;
		__catch17_struct_error:
		{
			GError* e = NULL;
			GError* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp18_ = e;
			_tmp19_ = _tmp18_->message;
			g_warning ("document_structure.vala:898: Structure: get next sibling or parent: %s", _tmp19_);
			result = FALSE;
			_g_error_free0 (e);
			_g_free0 (next_section_iter);
			_g_free0 (item_contents);
			_g_object_unref0 (end_mark);
			_g_object_unref0 (start_mark);
			if (start_iter) {
				*start_iter = _vala_start_iter;
			}
			if (end_iter) {
				*end_iter = _vala_end_iter;
			}
			return result;
		}
		__finally17:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (next_section_iter);
			_g_free0 (item_contents);
			_g_object_unref0 (end_mark);
			_g_object_unref0 (start_mark);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp20_ = next_section_iter;
		if (_tmp20_ == NULL) {
			GtkTextIter _tmp21_ = {0};
			document_structure_get_end_document_iter (self, NULL, &_tmp21_);
			_vala_end_iter = _tmp21_;
			result = TRUE;
			_g_free0 (next_section_iter);
			_g_free0 (item_contents);
			_g_object_unref0 (end_mark);
			_g_object_unref0 (start_mark);
			if (start_iter) {
				*start_iter = _vala_start_iter;
			}
			if (end_iter) {
				*end_iter = _vala_end_iter;
			}
			return result;
		}
		_tmp22_ = self->priv->_model;
		_tmp23_ = next_section_iter;
		_tmp24_ = *_tmp23_;
		gtk_tree_model_get ((GtkTreeModel*) _tmp22_, &_tmp24_, STRUCT_COLUMN_TYPE, &item_type, STRUCT_COLUMN_START_MARK, &start_mark, STRUCT_COLUMN_TEXT, &item_contents, -1, -1);
		_tmp25_ = self->priv->_doc;
		_tmp26_ = start_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp25_, &_tmp27_, _tmp26_);
		_vala_end_iter = _tmp27_;
		_tmp28_ = item_type;
		_tmp29_ = item_contents;
		_tmp30_ = _vala_end_iter;
		_tmp31_ = document_structure_get_low_level_item_bounds (self, _tmp28_, _tmp29_, &_tmp30_, TRUE, NULL);
		result = _tmp31_;
		_g_free0 (next_section_iter);
		_g_free0 (item_contents);
		_g_object_unref0 (end_mark);
		_g_object_unref0 (start_mark);
		if (start_iter) {
			*start_iter = _vala_start_iter;
		}
		if (end_iter) {
			*end_iter = _vala_end_iter;
		}
		return result;
	} else {
		StructType _tmp32_ = 0;
		gboolean _tmp33_ = FALSE;
		_tmp32_ = item_type;
		_tmp33_ = structure_is_common_type (_tmp32_);
		if (_tmp33_) {
			result = TRUE;
			_g_free0 (item_contents);
			_g_object_unref0 (end_mark);
			_g_object_unref0 (start_mark);
			if (start_iter) {
				*start_iter = _vala_start_iter;
			}
			if (end_iter) {
				*end_iter = _vala_end_iter;
			}
			return result;
		}
	}
	_tmp34_ = end_mark;
	if (_tmp34_ == NULL) {
		result = FALSE;
		_g_free0 (item_contents);
		_g_object_unref0 (end_mark);
		_g_object_unref0 (start_mark);
		if (start_iter) {
			*start_iter = _vala_start_iter;
		}
		if (end_iter) {
			*end_iter = _vala_end_iter;
		}
		return result;
	}
	_tmp35_ = self->priv->_doc;
	_tmp36_ = end_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp35_, &_tmp37_, _tmp36_);
	end_env_iter = _tmp37_;
	_tmp38_ = item_type;
	_tmp39_ = item_contents;
	_tmp40_ = end_env_iter;
	_tmp42_ = document_structure_get_low_level_item_bounds (self, _tmp38_, _tmp39_, &_tmp40_, FALSE, &_tmp41_);
	_vala_end_iter = _tmp41_;
	result = _tmp42_;
	_g_free0 (item_contents);
	_g_object_unref0 (end_mark);
	_g_object_unref0 (start_mark);
	if (start_iter) {
		*start_iter = _vala_start_iter;
	}
	if (end_iter) {
		*end_iter = _vala_end_iter;
	}
	return result;
}


static gboolean _int_equal (const gint* s1, const gint* s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}


static gboolean document_structure_get_low_level_item_bounds (DocumentStructure* self, StructType item_type, const gchar* item_contents, GtkTextIter* start_match_iter, gboolean is_start, GtkTextIter* end_match_iter) {
	GtkTextIter _vala_end_match_iter = {0};
	gboolean result = FALSE;
	GtkTextIter _tmp0_ = {0};
	gchar* line = NULL;
	GtkTextIter _tmp1_ = {0};
	gchar* _tmp2_ = NULL;
	gint start_index = 0;
	gint _tmp3_ = 0;
	StructType* low_level_type = NULL;
	gchar* contents = NULL;
	gint* start_match_index = NULL;
	gint* end_match_index = NULL;
	gboolean found = FALSE;
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	StructType* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gint* _tmp8_ = NULL;
	gint* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp15_ = NULL;
	StructType _tmp17_ = 0;
	const gchar* _tmp18_ = NULL;
	StructType* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item_contents != NULL, FALSE);
	g_return_val_if_fail (start_match_iter != NULL, FALSE);
	_vala_end_match_iter = _tmp0_;
	_tmp1_ = *start_match_iter;
	_tmp2_ = document_structure_get_line_contents_at_iter (self, &_tmp1_);
	line = _tmp2_;
	_tmp3_ = gtk_text_iter_get_line_index (start_match_iter);
	start_index = _tmp3_;
	_tmp4_ = line;
	_tmp5_ = start_index;
	_tmp10_ = document_structure_search_low_level_item (self, _tmp4_, _tmp5_, &_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_);
	_g_free0 (low_level_type);
	low_level_type = _tmp6_;
	_g_free0 (contents);
	contents = _tmp7_;
	_g_free0 (start_match_index);
	start_match_index = _tmp8_;
	_g_free0 (end_match_index);
	end_match_index = _tmp9_;
	found = _tmp10_;
	_tmp12_ = found;
	if (!_tmp12_) {
		_tmp11_ = TRUE;
	} else {
		gint _tmp13_ = 0;
		gint* _tmp14_ = NULL;
		_tmp13_ = start_index;
		_tmp14_ = start_match_index;
		_tmp11_ = _int_equal (&_tmp13_, _tmp14_) != TRUE;
	}
	if (_tmp11_) {
		result = FALSE;
		_g_free0 (end_match_index);
		_g_free0 (start_match_index);
		_g_free0 (contents);
		_g_free0 (low_level_type);
		_g_free0 (line);
		if (end_match_iter) {
			*end_match_iter = _vala_end_match_iter;
		}
		return result;
	}
	_tmp15_ = contents;
	if (_tmp15_ == NULL) {
		gchar* _tmp16_ = NULL;
		_tmp16_ = g_strdup ("");
		_g_free0 (contents);
		contents = _tmp16_;
	}
	_tmp17_ = item_type;
	_tmp18_ = item_contents;
	_tmp19_ = low_level_type;
	_tmp20_ = contents;
	_tmp21_ = is_start;
	_tmp22_ = document_structure_same_items (self, _tmp17_, _tmp18_, *_tmp19_, _tmp20_, _tmp21_);
	if (_tmp22_) {
		GtkTextIter _tmp23_ = {0};
		gint* _tmp24_ = NULL;
		_tmp23_ = *start_match_iter;
		_vala_end_match_iter = _tmp23_;
		_tmp24_ = end_match_index;
		gtk_text_iter_set_line_index (&_vala_end_match_iter, *_tmp24_);
		result = TRUE;
		_g_free0 (end_match_index);
		_g_free0 (start_match_index);
		_g_free0 (contents);
		_g_free0 (low_level_type);
		_g_free0 (line);
		if (end_match_iter) {
			*end_match_iter = _vala_end_match_iter;
		}
		return result;
	}
	result = FALSE;
	_g_free0 (end_match_index);
	_g_free0 (start_match_index);
	_g_free0 (contents);
	_g_free0 (low_level_type);
	_g_free0 (line);
	if (end_match_iter) {
		*end_match_iter = _vala_end_match_iter;
	}
	return result;
}


static gboolean document_structure_same_items (DocumentStructure* self, StructType item_type, const gchar* item_contents, StructType item_found_type, const gchar* item_found_contents, gboolean start) {
	gboolean result = FALSE;
	StructType _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	StructType _tmp9_ = 0;
	StructType _tmp13_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item_contents != NULL, FALSE);
	g_return_val_if_fail (item_found_contents != NULL, FALSE);
	_tmp0_ = item_found_type;
	_tmp1_ = structure_is_common_type (_tmp0_);
	if (_tmp1_) {
		gboolean same_type = FALSE;
		StructType _tmp2_ = 0;
		StructType _tmp3_ = 0;
		gboolean same_contents = FALSE;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		_tmp2_ = item_type;
		_tmp3_ = item_found_type;
		same_type = _tmp2_ == _tmp3_;
		_tmp4_ = item_contents;
		_tmp5_ = item_found_contents;
		same_contents = g_strcmp0 (_tmp4_, _tmp5_) == 0;
		_tmp7_ = same_type;
		if (_tmp7_) {
			gboolean _tmp8_ = FALSE;
			_tmp8_ = same_contents;
			_tmp6_ = _tmp8_;
		} else {
			_tmp6_ = FALSE;
		}
		result = _tmp6_;
		return result;
	}
	_tmp9_ = item_type;
	if (_tmp9_ == STRUCT_TYPE_FIGURE) {
		gboolean _tmp10_ = FALSE;
		_tmp10_ = start;
		if (_tmp10_) {
			StructType _tmp11_ = 0;
			_tmp11_ = item_found_type;
			result = _tmp11_ == STRUCT_TYPE_BEGIN_FIGURE;
			return result;
		} else {
			StructType _tmp12_ = 0;
			_tmp12_ = item_found_type;
			result = _tmp12_ == STRUCT_TYPE_END_FIGURE;
			return result;
		}
	}
	_tmp13_ = item_type;
	if (_tmp13_ == STRUCT_TYPE_TABLE) {
		gboolean _tmp14_ = FALSE;
		_tmp14_ = start;
		if (_tmp14_) {
			StructType _tmp15_ = 0;
			_tmp15_ = item_found_type;
			result = _tmp15_ == STRUCT_TYPE_BEGIN_TABLE;
			return result;
		} else {
			StructType _tmp16_ = 0;
			_tmp16_ = item_found_type;
			result = _tmp16_ == STRUCT_TYPE_END_TABLE;
			return result;
		}
	}
	result = FALSE;
	return result;
}


static void document_structure_get_end_document_iter (DocumentStructure* self, gboolean* end_of_file, GtkTextIter* result) {
	gboolean _vala_end_of_file = FALSE;
	GtkTextMark* _tmp0_ = NULL;
	GtkTextIter eof_iter = {0};
	Document* _tmp4_ = NULL;
	GtkTextIter _tmp5_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_end_document_mark;
	if (_tmp0_ != NULL) {
		GtkTextIter end_document_iter = {0};
		Document* _tmp1_ = NULL;
		GtkTextMark* _tmp2_ = NULL;
		GtkTextIter _tmp3_ = {0};
		_vala_end_of_file = FALSE;
		_tmp1_ = self->priv->_doc;
		_tmp2_ = self->priv->_end_document_mark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp1_, &_tmp3_, _tmp2_);
		end_document_iter = _tmp3_;
		*result = end_document_iter;
		if (end_of_file) {
			*end_of_file = _vala_end_of_file;
		}
		return;
	}
	_vala_end_of_file = TRUE;
	_tmp4_ = self->priv->_doc;
	gtk_text_buffer_get_end_iter ((GtkTextBuffer*) _tmp4_, &_tmp5_);
	eof_iter = _tmp5_;
	*result = eof_iter;
	if (end_of_file) {
		*end_of_file = _vala_end_of_file;
	}
	return;
}


static void document_structure_backward_indentation (DocumentStructure* self, GtkTextIter* iter) {
	gboolean _tmp0_ = FALSE;
	gint line_num = 0;
	gint _tmp1_ = 0;
	GtkTextIter begin_line_iter = {0};
	Document* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GtkTextIter _tmp4_ = {0};
	gchar* text_between = NULL;
	Document* _tmp5_ = NULL;
	GtkTextIter _tmp6_ = {0};
	GtkTextIter _tmp7_ = {0};
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = gtk_text_iter_starts_line (iter);
	if (_tmp0_) {
		return;
	}
	_tmp1_ = gtk_text_iter_get_line (iter);
	line_num = _tmp1_;
	_tmp2_ = self->priv->_doc;
	_tmp3_ = line_num;
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) _tmp2_, &_tmp4_, _tmp3_);
	begin_line_iter = _tmp4_;
	_tmp5_ = self->priv->_doc;
	_tmp6_ = begin_line_iter;
	_tmp7_ = *iter;
	_tmp8_ = gtk_text_buffer_get_text ((GtkTextBuffer*) _tmp5_, &_tmp6_, &_tmp7_, FALSE);
	text_between = _tmp8_;
	_tmp9_ = text_between;
	_tmp10_ = string_strip (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strcmp0 (_tmp11_, "") == 0;
	_g_free0 (_tmp11_);
	if (_tmp12_) {
		GtkTextIter _tmp13_ = {0};
		_tmp13_ = begin_line_iter;
		*iter = _tmp13_;
	}
	_g_free0 (text_between);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean document_structure_shift_item (DocumentStructure* self, GtkTreeIter* tree_iter, gboolean shift_right, gboolean* doc_modified) {
	gboolean _vala_doc_modified = FALSE;
	gboolean result = FALSE;
	StructType type = 0;
	GtkTextMark* mark = NULL;
	StructureModel* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	StructType _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	GtkTextIter text_iter = {0};
	Document* _tmp7_ = NULL;
	GtkTextMark* _tmp8_ = NULL;
	GtkTextIter _tmp9_ = {0};
	gchar* line = NULL;
	GtkTextIter _tmp10_ = {0};
	gchar* _tmp11_ = NULL;
	gint backslash_index = 0;
	gint _tmp12_ = 0;
	const gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gchar _tmp15_ = '\0';
	gint after_backslash_index = 0;
	gint _tmp16_ = 0;
	gchar* markup_name = NULL;
	const gchar* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	StructType* markup_type = NULL;
	const gchar* _tmp21_ = NULL;
	StructType* _tmp22_ = NULL;
	StructType* _tmp23_ = NULL;
	StructType markup_type_hack = 0;
	StructType* _tmp24_ = NULL;
	StructType _tmp25_ = 0;
	StructType _tmp26_ = 0;
	gboolean with_star = FALSE;
	const gchar* _tmp27_ = NULL;
	gboolean _tmp28_ = FALSE;
	StructType new_type = 0;
	gboolean _tmp29_ = FALSE;
	gchar* new_markup_name = NULL;
	StructType _tmp32_ = 0;
	gchar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	gboolean _tmp35_ = FALSE;
	GtkTextIter begin_markup_name_iter = {0};
	GtkTextIter _tmp38_ = {0};
	gint _tmp39_ = 0;
	GtkTextIter end_markup_name_iter = {0};
	GtkTextIter _tmp40_ = {0};
	gint _tmp41_ = 0;
	const gchar* _tmp42_ = NULL;
	gint _tmp43_ = 0;
	gint _tmp44_ = 0;
	Document* _tmp45_ = NULL;
	Document* _tmp46_ = NULL;
	const gchar* _tmp47_ = NULL;
	gint nb_children = 0;
	StructureModel* _tmp48_ = NULL;
	GtkTreeIter _tmp49_ = {0};
	gint _tmp50_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tree_iter != NULL, FALSE);
	_vala_doc_modified = FALSE;
	_tmp0_ = self->priv->_model;
	_tmp1_ = *tree_iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, STRUCT_COLUMN_TYPE, &type, STRUCT_COLUMN_START_MARK, &mark, -1);
	_tmp2_ = shift_right;
	if (_tmp2_) {
		StructType _tmp3_ = 0;
		_tmp3_ = type;
		g_return_val_if_fail (_tmp3_ != STRUCT_TYPE_SUBPARAGRAPH, FALSE);
	} else {
		StructType _tmp4_ = 0;
		_tmp4_ = type;
		g_return_val_if_fail (_tmp4_ != STRUCT_TYPE_PART, FALSE);
	}
	_tmp5_ = type;
	_tmp6_ = structure_is_section (_tmp5_);
	if (!_tmp6_) {
		result = TRUE;
		_g_object_unref0 (mark);
		if (doc_modified) {
			*doc_modified = _vala_doc_modified;
		}
		return result;
	}
	_tmp7_ = self->priv->_doc;
	_tmp8_ = mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp7_, &_tmp9_, _tmp8_);
	text_iter = _tmp9_;
	_tmp10_ = text_iter;
	_tmp11_ = document_structure_get_line_contents_at_iter (self, &_tmp10_);
	line = _tmp11_;
	_tmp12_ = gtk_text_iter_get_line_index (&text_iter);
	backslash_index = _tmp12_;
	_tmp13_ = line;
	_tmp14_ = backslash_index;
	_tmp15_ = string_get (_tmp13_, (glong) _tmp14_);
	if (_tmp15_ != '\\') {
		result = FALSE;
		_g_free0 (line);
		_g_object_unref0 (mark);
		if (doc_modified) {
			*doc_modified = _vala_doc_modified;
		}
		return result;
	}
	_tmp16_ = backslash_index;
	after_backslash_index = _tmp16_ + 1;
	_tmp17_ = line;
	_tmp18_ = after_backslash_index;
	_tmp19_ = document_structure_get_markup_name (self, _tmp17_, _tmp18_, NULL);
	markup_name = _tmp19_;
	_tmp20_ = markup_name;
	if (_tmp20_ == NULL) {
		result = FALSE;
		_g_free0 (markup_name);
		_g_free0 (line);
		_g_object_unref0 (mark);
		if (doc_modified) {
			*doc_modified = _vala_doc_modified;
		}
		return result;
	}
	_tmp21_ = markup_name;
	_tmp22_ = document_structure_get_markup_type (self, _tmp21_);
	markup_type = _tmp22_;
	_tmp23_ = markup_type;
	if (_tmp23_ == NULL) {
		result = FALSE;
		_g_free0 (markup_type);
		_g_free0 (markup_name);
		_g_free0 (line);
		_g_object_unref0 (mark);
		if (doc_modified) {
			*doc_modified = _vala_doc_modified;
		}
		return result;
	}
	_tmp24_ = markup_type;
	markup_type_hack = *_tmp24_;
	_tmp25_ = type;
	_tmp26_ = markup_type_hack;
	if (((gint) _tmp25_) != ((gint) _tmp26_)) {
		result = FALSE;
		_g_free0 (markup_type);
		_g_free0 (markup_name);
		_g_free0 (line);
		_g_object_unref0 (mark);
		if (doc_modified) {
			*doc_modified = _vala_doc_modified;
		}
		return result;
	}
	_tmp27_ = markup_name;
	_tmp28_ = g_str_has_suffix (_tmp27_, "*");
	with_star = _tmp28_;
	_tmp29_ = shift_right;
	if (_tmp29_) {
		StructType _tmp30_ = 0;
		_tmp30_ = type;
		new_type = _tmp30_ + 1;
	} else {
		StructType _tmp31_ = 0;
		_tmp31_ = type;
		new_type = _tmp31_ - 1;
	}
	_tmp32_ = new_type;
	_tmp33_ = document_structure_get_section_name_from_type (self, _tmp32_);
	new_markup_name = _tmp33_;
	_tmp34_ = new_markup_name;
	g_return_val_if_fail (_tmp34_ != NULL, FALSE);
	_tmp35_ = with_star;
	if (_tmp35_) {
		const gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		_tmp36_ = new_markup_name;
		_tmp37_ = g_strconcat (_tmp36_, "*", NULL);
		_g_free0 (new_markup_name);
		new_markup_name = _tmp37_;
	}
	_tmp38_ = text_iter;
	begin_markup_name_iter = _tmp38_;
	_tmp39_ = after_backslash_index;
	gtk_text_iter_set_line_index (&begin_markup_name_iter, _tmp39_);
	_tmp40_ = text_iter;
	end_markup_name_iter = _tmp40_;
	_tmp41_ = after_backslash_index;
	_tmp42_ = markup_name;
	_tmp43_ = strlen (_tmp42_);
	_tmp44_ = _tmp43_;
	gtk_text_iter_set_line_index (&end_markup_name_iter, _tmp41_ + _tmp44_);
	_tmp45_ = self->priv->_doc;
	gtk_text_buffer_delete ((GtkTextBuffer*) _tmp45_, &begin_markup_name_iter, &end_markup_name_iter);
	_tmp46_ = self->priv->_doc;
	_tmp47_ = new_markup_name;
	document_insert (_tmp46_, &begin_markup_name_iter, _tmp47_, -1);
	_vala_doc_modified = TRUE;
	_tmp48_ = self->priv->_model;
	_tmp49_ = *tree_iter;
	_tmp50_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp48_, &_tmp49_);
	nb_children = _tmp50_;
	{
		gint child_num = 0;
		child_num = 0;
		{
			gboolean _tmp51_ = FALSE;
			_tmp51_ = TRUE;
			while (TRUE) {
				gint _tmp53_ = 0;
				gint _tmp54_ = 0;
				GtkTreeIter child_iter = {0};
				gboolean child_iter_set = FALSE;
				StructureModel* _tmp55_ = NULL;
				GtkTreeIter _tmp56_ = {0};
				gint _tmp57_ = 0;
				GtkTreeIter _tmp58_ = {0};
				gboolean _tmp59_ = FALSE;
				gboolean _tmp60_ = FALSE;
				GtkTreeIter _tmp61_ = {0};
				gboolean _tmp62_ = FALSE;
				gboolean _tmp63_ = FALSE;
				if (!_tmp51_) {
					gint _tmp52_ = 0;
					_tmp52_ = child_num;
					child_num = _tmp52_ + 1;
				}
				_tmp51_ = FALSE;
				_tmp53_ = child_num;
				_tmp54_ = nb_children;
				if (!(_tmp53_ < _tmp54_)) {
					break;
				}
				_tmp55_ = self->priv->_model;
				_tmp56_ = *tree_iter;
				_tmp57_ = child_num;
				_tmp59_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp55_, &_tmp58_, &_tmp56_, _tmp57_);
				child_iter = _tmp58_;
				child_iter_set = _tmp59_;
				_tmp60_ = child_iter_set;
				g_return_val_if_fail (_tmp60_, FALSE);
				_tmp61_ = child_iter;
				_tmp62_ = shift_right;
				_tmp63_ = document_structure_shift_item (self, &_tmp61_, _tmp62_, NULL);
				if (!_tmp63_) {
					result = FALSE;
					_g_free0 (new_markup_name);
					_g_free0 (markup_type);
					_g_free0 (markup_name);
					_g_free0 (line);
					_g_object_unref0 (mark);
					if (doc_modified) {
						*doc_modified = _vala_doc_modified;
					}
					return result;
				}
			}
		}
	}
	result = TRUE;
	_g_free0 (new_markup_name);
	_g_free0 (markup_type);
	_g_free0 (markup_name);
	_g_free0 (line);
	_g_object_unref0 (mark);
	if (doc_modified) {
		*doc_modified = _vala_doc_modified;
	}
	return result;
}


static gchar* document_structure_get_section_name_from_type (DocumentStructure* self, StructType type) {
	gchar* result = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	StructType _tmp23_ = 0;
	gboolean _tmp24_ = FALSE;
	gchar** _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	StructType _tmp26_ = 0;
	const gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = document_structure__section_names;
	_tmp0__length1 = document_structure__section_names_length1;
	if (_tmp0_ == NULL) {
		gchar** _tmp1_ = NULL;
		gchar** _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar** _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar** _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar** _tmp20_ = NULL;
		gint _tmp20__length1 = 0;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		_tmp1_ = g_new0 (gchar*, 7 + 1);
		document_structure__section_names = (_vala_array_free (document_structure__section_names, document_structure__section_names_length1, (GDestroyNotify) g_free), NULL);
		document_structure__section_names = _tmp1_;
		document_structure__section_names_length1 = 7;
		_document_structure__section_names_size_ = document_structure__section_names_length1;
		_tmp2_ = document_structure__section_names;
		_tmp2__length1 = document_structure__section_names_length1;
		_tmp3_ = g_strdup ("part");
		_g_free0 (_tmp2_[STRUCT_TYPE_PART]);
		_tmp2_[STRUCT_TYPE_PART] = _tmp3_;
		_tmp4_ = _tmp2_[STRUCT_TYPE_PART];
		_tmp5_ = document_structure__section_names;
		_tmp5__length1 = document_structure__section_names_length1;
		_tmp6_ = g_strdup ("chapter");
		_g_free0 (_tmp5_[STRUCT_TYPE_CHAPTER]);
		_tmp5_[STRUCT_TYPE_CHAPTER] = _tmp6_;
		_tmp7_ = _tmp5_[STRUCT_TYPE_CHAPTER];
		_tmp8_ = document_structure__section_names;
		_tmp8__length1 = document_structure__section_names_length1;
		_tmp9_ = g_strdup ("section");
		_g_free0 (_tmp8_[STRUCT_TYPE_SECTION]);
		_tmp8_[STRUCT_TYPE_SECTION] = _tmp9_;
		_tmp10_ = _tmp8_[STRUCT_TYPE_SECTION];
		_tmp11_ = document_structure__section_names;
		_tmp11__length1 = document_structure__section_names_length1;
		_tmp12_ = g_strdup ("subsection");
		_g_free0 (_tmp11_[STRUCT_TYPE_SUBSECTION]);
		_tmp11_[STRUCT_TYPE_SUBSECTION] = _tmp12_;
		_tmp13_ = _tmp11_[STRUCT_TYPE_SUBSECTION];
		_tmp14_ = document_structure__section_names;
		_tmp14__length1 = document_structure__section_names_length1;
		_tmp15_ = g_strdup ("subsubsection");
		_g_free0 (_tmp14_[STRUCT_TYPE_SUBSUBSECTION]);
		_tmp14_[STRUCT_TYPE_SUBSUBSECTION] = _tmp15_;
		_tmp16_ = _tmp14_[STRUCT_TYPE_SUBSUBSECTION];
		_tmp17_ = document_structure__section_names;
		_tmp17__length1 = document_structure__section_names_length1;
		_tmp18_ = g_strdup ("paragraph");
		_g_free0 (_tmp17_[STRUCT_TYPE_PARAGRAPH]);
		_tmp17_[STRUCT_TYPE_PARAGRAPH] = _tmp18_;
		_tmp19_ = _tmp17_[STRUCT_TYPE_PARAGRAPH];
		_tmp20_ = document_structure__section_names;
		_tmp20__length1 = document_structure__section_names_length1;
		_tmp21_ = g_strdup ("subparagraph");
		_g_free0 (_tmp20_[STRUCT_TYPE_SUBPARAGRAPH]);
		_tmp20_[STRUCT_TYPE_SUBPARAGRAPH] = _tmp21_;
		_tmp22_ = _tmp20_[STRUCT_TYPE_SUBPARAGRAPH];
	}
	_tmp23_ = type;
	_tmp24_ = structure_is_section (_tmp23_);
	g_return_val_if_fail (_tmp24_, NULL);
	_tmp25_ = document_structure__section_names;
	_tmp25__length1 = document_structure__section_names_length1;
	_tmp26_ = type;
	_tmp27_ = _tmp25_[_tmp26_];
	_tmp28_ = g_strdup (_tmp27_);
	result = _tmp28_;
	return result;
}


gboolean document_structure_get_parsing_done (DocumentStructure* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_parsing_done;
	result = _tmp0_;
	return result;
}


static void document_structure_set_parsing_done (DocumentStructure* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_parsing_done = _tmp0_;
	g_object_notify ((GObject *) self, "parsing-done");
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


static void document_structure_env_data_copy (const DocumentStructureEnvData* self, DocumentStructureEnvData* dest) {
	GtkTreePath* _tmp0_ = NULL;
	GtkTreePath* _tmp1_ = NULL;
	StructType _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	_tmp0_ = (*self).path;
	_tmp1_ = _gtk_tree_path_copy0 (_tmp0_);
	_gtk_tree_path_free0 ((*dest).path);
	(*dest).path = _tmp1_;
	_tmp2_ = (*self).type;
	(*dest).type = _tmp2_;
	_tmp3_ = (*self).first_caption;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 ((*dest).first_caption);
	(*dest).first_caption = _tmp4_;
}


static void document_structure_env_data_destroy (DocumentStructureEnvData* self) {
	_gtk_tree_path_free0 ((*self).path);
	_g_free0 ((*self).first_caption);
}


static DocumentStructureEnvData* document_structure_env_data_dup (const DocumentStructureEnvData* self) {
	DocumentStructureEnvData* dup;
	dup = g_new0 (DocumentStructureEnvData, 1);
	document_structure_env_data_copy (self, dup);
	return dup;
}


static void document_structure_env_data_free (DocumentStructureEnvData* self) {
	document_structure_env_data_destroy (self);
	g_free (self);
}


static GType document_structure_env_data_get_type (void) {
	static volatile gsize document_structure_env_data_type_id__volatile = 0;
	if (g_once_init_enter (&document_structure_env_data_type_id__volatile)) {
		GType document_structure_env_data_type_id;
		document_structure_env_data_type_id = g_boxed_type_register_static ("DocumentStructureEnvData", (GBoxedCopyFunc) document_structure_env_data_dup, (GBoxedFreeFunc) document_structure_env_data_free);
		g_once_init_leave (&document_structure_env_data_type_id__volatile, document_structure_env_data_type_id);
	}
	return document_structure_env_data_type_id__volatile;
}


static void document_structure_class_init (DocumentStructureClass * klass) {
	document_structure_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DocumentStructurePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_document_structure_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_document_structure_set_property;
	G_OBJECT_CLASS (klass)->finalize = document_structure_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_STRUCTURE_PARSING_DONE, g_param_spec_boolean ("parsing-done", "parsing-done", "parsing-done", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void document_structure_instance_init (DocumentStructure * self) {
	self->priv = DOCUMENT_STRUCTURE_GET_PRIVATE (self);
	self->priv->_nb_marks = 0;
	self->priv->_end_document_mark = NULL;
	self->priv->_model = NULL;
	self->priv->_in_verbatim_env = FALSE;
	self->priv->_last_env_data = NULL;
	self->priv->_start_parsing_line = 0;
	self->priv->_timer = NULL;
	self->priv->_parsing_done = FALSE;
}


static void document_structure_finalize (GObject* obj) {
	DocumentStructure * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DOCUMENT_STRUCTURE, DocumentStructure);
	_g_object_unref0 (self->priv->_end_document_mark);
	_g_object_unref0 (self->priv->_model);
	_document_structure_env_data_free0 (self->priv->_last_env_data);
	_g_timer_destroy0 (self->priv->_timer);
	G_OBJECT_CLASS (document_structure_parent_class)->finalize (obj);
}


GType document_structure_get_type (void) {
	static volatile gsize document_structure_type_id__volatile = 0;
	if (g_once_init_enter (&document_structure_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DocumentStructureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) document_structure_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DocumentStructure), 0, (GInstanceInitFunc) document_structure_instance_init, NULL };
		GType document_structure_type_id;
		document_structure_type_id = g_type_register_static (G_TYPE_OBJECT, "DocumentStructure", &g_define_type_info, 0);
		g_once_init_leave (&document_structure_type_id__volatile, document_structure_type_id);
	}
	return document_structure_type_id__volatile;
}


static void _vala_document_structure_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DocumentStructure * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT_STRUCTURE, DocumentStructure);
	switch (property_id) {
		case DOCUMENT_STRUCTURE_PARSING_DONE:
		g_value_set_boolean (value, document_structure_get_parsing_done (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_document_structure_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DocumentStructure * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT_STRUCTURE, DocumentStructure);
	switch (property_id) {
		case DOCUMENT_STRUCTURE_PARSING_DONE:
		document_structure_set_parsing_done (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



