/* document.c generated by valac 0.21.1.31-3473e, the Vala compiler
 * generated from document.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtksourceview/gtksource.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <glib/gstdio.h>
#include <pango/pango.h>


#define TYPE_SELECTION_TYPE (selection_type_get_type ())

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT_STRUCTURE (document_structure_get_type ())
#define DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructure))
#define DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))
#define IS_DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_STRUCTURE))
#define IS_DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_STRUCTURE))
#define DOCUMENT_STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))

typedef struct _DocumentStructure DocumentStructure;
typedef struct _DocumentStructureClass DocumentStructureClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block15Data Block15Data;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

#define TYPE_TAB_INFO_BAR (tab_info_bar_get_type ())
#define TAB_INFO_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAB_INFO_BAR, TabInfoBar))
#define TAB_INFO_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAB_INFO_BAR, TabInfoBarClass))
#define IS_TAB_INFO_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAB_INFO_BAR))
#define IS_TAB_INFO_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAB_INFO_BAR))
#define TAB_INFO_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAB_INFO_BAR, TabInfoBarClass))

typedef struct _TabInfoBar TabInfoBar;
typedef struct _TabInfoBarClass TabInfoBarClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block16Data Block16Data;

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))

#define TYPE_LATEXILA (latexila_get_type ())
#define LATEXILA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEXILA, Latexila))
#define LATEXILA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEXILA, LatexilaClass))
#define IS_LATEXILA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEXILA))
#define IS_LATEXILA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEXILA))
#define LATEXILA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEXILA, LatexilaClass))

typedef struct _Latexila Latexila;
typedef struct _LatexilaClass LatexilaClass;
typedef struct _Block17Data Block17Data;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

typedef enum  {
	SELECTION_TYPE_NO_SELECTION,
	SELECTION_TYPE_ONE_LINE,
	SELECTION_TYPE_MULTIPLE_LINES
} SelectionType;

struct _Document {
	GtkSourceBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
	guint _unsaved_doc_num;
};

struct _DocumentClass {
	GtkSourceBufferClass parent_class;
};

struct _DocumentPrivate {
	GFile* _location;
	gboolean _readonly;
	gint _project_id;
	gboolean backup_made;
	gchar* _etag;
	gchar* encoding;
	gboolean new_file;
	DocumentStructure* _structure;
	GtkTextTag* found_tag;
	GtkTextTag* found_tag_selected;
	gchar* search_text;
	guint search_nb_matches;
	guint search_num_match;
	gboolean search_case_sensitive;
	gboolean search_entire_word;
	gboolean stop_cursor_moved_emission;
};

struct _Block15Data {
	int _ref_count_;
	Document * self;
	GtkSourceCompletion* completion;
};

struct _Block16Data {
	int _ref_count_;
	Document * self;
	TabInfoBar* infobar;
};

struct _Project {
	GFile* directory;
	GFile* main_file;
};

struct _Block17Data {
	int _ref_count_;
	Document * self;
	TabInfoBar* infobar;
};


static gpointer document_parent_class = NULL;

GType selection_type_get_type (void) G_GNUC_CONST;
GType document_get_type (void) G_GNUC_CONST;
GType document_tab_get_type (void) G_GNUC_CONST;
GType document_structure_get_type (void) G_GNUC_CONST;
#define DOCUMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DOCUMENT, DocumentPrivate))
enum  {
	DOCUMENT_DUMMY_PROPERTY,
	DOCUMENT_LOCATION,
	DOCUMENT_READONLY,
	DOCUMENT_PROJECT_ID
};
Document* document_new (void);
Document* document_construct (GType object_type);
static void __lambda86_ (Document* self);
static void document_update_syntax_highlighting (Document* self);
static void document_update_project_id (Document* self);
static void ___lambda86__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda87_ (Document* self, GtkTextIter* location, GtkTextMark* mark);
static void document_emit_cursor_moved (Document* self);
static void ___lambda87__gtk_text_buffer_mark_set (GtkTextBuffer* _sender, GtkTextIter* location, GtkTextMark* mark, gpointer self);
static void __lambda88_ (Document* self);
static void ___lambda88__gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self);
static void document_sync_found_tags (Document* self);
static void _document_sync_found_tags_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
gboolean document_get_modified (Document* self);
void document_insert (Document* self, GtkTextIter* iter, const gchar* text, gint len);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
GType document_view_get_type (void) G_GNUC_CONST;
DocumentView* document_tab_get_view (DocumentTab* self);
static gboolean __lambda18_ (Block15Data* _data15_);
static gboolean ___lambda18__gsource_func (gpointer self);
void document_load (Document* self, GFile* location);
void document_set_location (Document* self, GFile* value);
void document_set_contents (Document* self, const gchar* contents);
static gchar* document_to_utf8 (Document* self, const gchar* text, GError** error);
GType tab_info_bar_get_type (void) G_GNUC_CONST;
TabInfoBar* document_tab_add_message (DocumentTab* self, const gchar* primary_msg, const gchar* secondary_msg, GtkMessageType msg_type);
void document_save (Document* self, gboolean check_file_changed_on_disk, gboolean force);
GFile* document_get_location (Document* self);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
void tab_info_bar_add_stock_button_with_text (TabInfoBar* self, const gchar* text, const gchar* stock_id, gint response_id);
static void ____lambda15_ (Block16Data* _data16_, gint response_id);
static void _____lambda15__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self);
void tab_info_bar_add_ok_button (TabInfoBar* self);
GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self, Project* dest);
void project_destroy (Project* self);
gpointer projects_ref (gpointer instance);
void projects_unref (gpointer instance);
GParamSpec* param_spec_projects (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_projects (GValue* value, gpointer v_object);
void value_take_projects (GValue* value, gpointer v_object);
gpointer value_get_projects (const GValue* value);
GType projects_get_type (void) G_GNUC_CONST;
Projects* projects_get_default (void);
GeeIterator* projects_iterator (Projects* self);
void document_set_project_id (Document* self, gint value);
gchar* document_get_uri_for_display (Document* self);
static gchar* document_get_unsaved_document_name (Document* self);
gchar* utils_replace_home_dir_with_tilde (const gchar* uri);
gchar* document_get_short_name_for_display (Document* self);
static guint document_get_unsaved_document_num (Document* self);
GType latexila_get_type (void) G_GNUC_CONST;
Latexila* latexila_get_instance (void);
GeeList* latexila_get_documents (Latexila* self);
static void _vala_array_add14 (guint** array, int* length, int* size, guint value);
static gboolean _vala_uint_array_contains (guint* stack, int stack_length, guint needle);
gboolean document_is_local (Document* self);
gboolean document_is_externally_modified (Document* self);
void document_set_style_scheme_from_string (Document* self, const gchar* scheme_id);
void document_comment_selected_lines (Document* self);
void document_comment_between (Document* self, GtkTextIter* start_iter, GtkTextIter* end_iter, gboolean end_iter_set);
void document_uncomment_selected_lines (Document* self);
void document_select_lines (Document* self, gint start, gint end);
void document_view_scroll_to_cursor (DocumentView* self, gdouble margin);
SelectionType document_get_selection_type (Document* self);
gboolean document_goto_line (Document* self, gint line);
Project* document_get_project (Document* self);
gint document_get_project_id (Document* self);
Project* projects_get (Projects* self, gint id);
GFile* document_get_main_file (Document* self);
gboolean document_is_main_file_a_tex_file (Document* self);
gchar* document_get_current_indentation (Document* self, GtkTextIter* iter);
DocumentStructure* document_get_structure (Document* self);
DocumentStructure* document_structure_new (Document* doc);
DocumentStructure* document_structure_construct (GType object_type, Document* doc);
void document_structure_parse (DocumentStructure* self);
gboolean document_set_tmp_location (Document* self);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static void __lambda76_ (Block17Data* _data17_, gint response_id);
GType main_window_get_type (void) G_GNUC_CONST;
GtkWindow* utils_get_toplevel_window (GtkWidget* widget);
gboolean main_window_save_document (MainWindow* self, Document* doc, gboolean force_save_as);
static void ___lambda76__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self);
void document_set_search_text (Document* self, const gchar* text, gboolean case_sensitive, gboolean entire_word, guint* nb_matches, guint* num_match, gboolean select);
static void document_search_cursor_moved_handler (Document* self);
static void _document_search_cursor_moved_handler_document_cursor_moved (Document* _sender, gpointer self);
static void document_search_delete_range_before_handler (Document* self, GtkTextIter* start, GtkTextIter* end);
static void _document_search_delete_range_before_handler_gtk_text_buffer_delete_range (GtkTextBuffer* _sender, GtkTextIter* start, GtkTextIter* end, gpointer self);
static void document_search_delete_range_after_handler (Document* self, GtkTextIter* location);
static void _document_search_delete_range_after_handler_gtk_text_buffer_delete_range (GtkTextBuffer* _sender, GtkTextIter* start, GtkTextIter* end, gpointer self);
static void document_search_insert_text_before_handler (Document* self, GtkTextIter* location);
static void _document_search_insert_text_before_handler_gtk_text_buffer_insert_text (GtkTextBuffer* _sender, GtkTextIter* pos, const gchar* new_text, gint new_text_length, gpointer self);
static void document_search_insert_text_after_handler (Document* self, GtkTextIter* location, const gchar* text, gint len);
static void _document_search_insert_text_after_handler_gtk_text_buffer_insert_text (GtkTextBuffer* _sender, GtkTextIter* pos, const gchar* new_text, gint new_text_length, gpointer self);
static void document_invalidate_search_selected_marks (Document* self);
void document_clear_search (Document* self, gboolean disconnect_signals);
static gboolean document_iter_forward_search (Document* self, GtkTextIter* start, GtkTextIter* end, GtkTextIter* match_start, GtkTextIter* match_end);
static void document_move_search_marks (Document* self, GtkTextIter* start, GtkTextIter* end, gboolean move_cursor);
static void document_clear_search_tags (Document* self);
void document_select_current_match (Document* self);
void document_search_forward (Document* self);
static void document_replace_found_tag_selected (Document* self);
static void document_find_num_match (Document* self);
void document_search_backward (Document* self);
static gboolean document_iter_backward_search (Document* self, GtkTextIter* start, GtkTextIter* end, GtkTextIter* match_start, GtkTextIter* match_end);
static GtkTextSearchFlags document_get_search_flags (Document* self);
static void document_search_matches_between (Document* self, GtkTextIter* start_search, GtkTextIter* stop_search);
static void document_set_search_match_colors (Document* self, GtkTextTag* text_tag);
void document_replace (Document* self, const gchar* text);
gboolean document_get_readonly (Document* self);
void document_replace_all (Document* self, const gchar* text);
void document_set_readonly (Document* self, gboolean value);
static void g_cclosure_user_marshal_VOID__BOOLEAN_UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void document_finalize (GObject* obj);
static void _vala_document_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_document_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

extern const gchar* ENCODINGS_CHARSETS[60];

GType selection_type_get_type (void) {
	static volatile gsize selection_type_type_id__volatile = 0;
	if (g_once_init_enter (&selection_type_type_id__volatile)) {
		static const GEnumValue values[] = {{SELECTION_TYPE_NO_SELECTION, "SELECTION_TYPE_NO_SELECTION", "no-selection"}, {SELECTION_TYPE_ONE_LINE, "SELECTION_TYPE_ONE_LINE", "one-line"}, {SELECTION_TYPE_MULTIPLE_LINES, "SELECTION_TYPE_MULTIPLE_LINES", "multiple-lines"}, {0, NULL, NULL}};
		GType selection_type_type_id;
		selection_type_type_id = g_enum_register_static ("SelectionType", values);
		g_once_init_leave (&selection_type_type_id__volatile, selection_type_type_id);
	}
	return selection_type_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda86_ (Document* self) {
	document_update_syntax_highlighting (self);
	document_update_project_id (self);
}


static void ___lambda86__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda86_ (self);
}


static void __lambda87_ (Document* self, GtkTextIter* location, GtkTextMark* mark) {
	GtkTextMark* _tmp0_ = NULL;
	GtkTextMark* _tmp1_ = NULL;
	g_return_if_fail (location != NULL);
	g_return_if_fail (mark != NULL);
	_tmp0_ = mark;
	_tmp1_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
	if (_tmp0_ == _tmp1_) {
		document_emit_cursor_moved (self);
	}
}


static void ___lambda87__gtk_text_buffer_mark_set (GtkTextBuffer* _sender, GtkTextIter* location, GtkTextMark* mark, gpointer self) {
	__lambda87_ (self, location, mark);
}


static void __lambda88_ (Document* self) {
	self->priv->new_file = FALSE;
	document_emit_cursor_moved (self);
}


static void ___lambda88__gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self) {
	__lambda88_ (self);
}


static void _document_sync_found_tags_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	document_sync_found_tags (self);
}


Document* document_construct (GType object_type) {
	Document * self = NULL;
	GtkSourceLanguageManager* lm = NULL;
	GtkSourceLanguageManager* _tmp0_ = NULL;
	GtkSourceLanguageManager* _tmp1_ = NULL;
	GtkSourceLanguage* _tmp2_ = NULL;
	GtkTextTag* _tmp3_ = NULL;
	GtkTextTag* _tmp4_ = NULL;
	GtkTextTagTable* tag_table = NULL;
	GtkTextTagTable* _tmp5_ = NULL;
	GtkTextTagTable* _tmp6_ = NULL;
	GtkTextTag* _tmp7_ = NULL;
	GtkTextTag* _tmp8_ = NULL;
	GtkTextIter iter = {0};
	GtkTextIter _tmp9_ = {0};
	GtkTextIter _tmp10_ = {0};
	GtkTextIter _tmp11_ = {0};
	self = (Document*) g_object_new (object_type, NULL);
	_tmp0_ = gtk_source_language_manager_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	lm = _tmp1_;
	_tmp2_ = gtk_source_language_manager_get_language (lm, "latex");
	gtk_source_buffer_set_language ((GtkSourceBuffer*) self, _tmp2_);
	g_signal_connect_object ((GObject*) self, "notify::location", (GCallback) ___lambda86__g_object_notify, self, 0);
	g_signal_connect_object ((GtkTextBuffer*) self, "mark-set", (GCallback) ___lambda87__gtk_text_buffer_mark_set, self, 0);
	g_signal_connect_object ((GtkTextBuffer*) self, "changed", (GCallback) ___lambda88__gtk_text_buffer_changed, self, 0);
	_tmp3_ = gtk_text_tag_new ("found");
	_g_object_unref0 (self->priv->found_tag);
	self->priv->found_tag = _tmp3_;
	_tmp4_ = gtk_text_tag_new ("found_selected");
	_g_object_unref0 (self->priv->found_tag_selected);
	self->priv->found_tag_selected = _tmp4_;
	document_sync_found_tags (self);
	_tmp5_ = gtk_text_buffer_get_tag_table ((GtkTextBuffer*) self);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	tag_table = _tmp6_;
	_tmp7_ = self->priv->found_tag;
	gtk_text_tag_table_add (tag_table, _tmp7_);
	_tmp8_ = self->priv->found_tag_selected;
	gtk_text_tag_table_add (tag_table, _tmp8_);
	g_signal_connect_object ((GObject*) self, "notify::style-scheme", (GCallback) _document_sync_found_tags_g_object_notify, self, 0);
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp9_, 0);
	iter = _tmp9_;
	_tmp10_ = iter;
	gtk_text_buffer_create_mark ((GtkTextBuffer*) self, "search_selected_start", &_tmp10_, TRUE);
	_tmp11_ = iter;
	gtk_text_buffer_create_mark ((GtkTextBuffer*) self, "search_selected_end", &_tmp11_, TRUE);
	_g_object_unref0 (tag_table);
	_g_object_unref0 (lm);
	return self;
}


Document* document_new (void) {
	return document_construct (TYPE_DOCUMENT);
}


gboolean document_get_modified (Document* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->new_file;
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = gtk_text_buffer_get_modified ((GtkTextBuffer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_buffer_get_type (), GtkSourceBuffer));
	result = _tmp1_;
	return result;
}


static Block15Data* block15_data_ref (Block15Data* _data15_) {
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}


static void block15_data_unref (void * _userdata_) {
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		Document * self;
		self = _data15_->self;
		_g_object_unref0 (_data15_->completion);
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}


static gboolean __lambda18_ (Block15Data* _data15_) {
	Document * self;
	gboolean result = FALSE;
	self = _data15_->self;
	gtk_source_completion_unblock_interactive (_data15_->completion);
	result = FALSE;
	return result;
}


static gboolean ___lambda18__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda18_ (self);
	return result;
}


void document_insert (Document* self, GtkTextIter* iter, const gchar* text, gint len) {
	Block15Data* _data15_;
	DocumentTab* _tmp0_ = NULL;
	DocumentView* _tmp1_ = NULL;
	DocumentView* _tmp2_ = NULL;
	GtkSourceCompletion* _tmp3_ = NULL;
	GtkSourceCompletion* _tmp4_ = NULL;
	GtkSourceCompletion* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	g_return_if_fail (text != NULL);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = g_object_ref (self);
	_tmp0_ = self->tab;
	_tmp1_ = document_tab_get_view (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_source_view_get_completion ((GtkSourceView*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_data15_->completion = _tmp5_;
	gtk_source_completion_block_interactive (_data15_->completion);
	_tmp6_ = text;
	_tmp7_ = len;
	gtk_text_buffer_insert ((GtkTextBuffer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_buffer_get_type (), GtkSourceBuffer), iter, _tmp6_, _tmp7_);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ___lambda18__gsource_func, block15_data_ref (_data15_), block15_data_unref);
	block15_data_unref (_data15_);
	_data15_ = NULL;
}


void document_load (Document* self, GFile* location) {
	GFile* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_tmp0_ = location;
	document_set_location (self, _tmp0_);
	{
		guint8* chars = NULL;
		gint chars_length1 = 0;
		gint _chars_size_ = 0;
		GFile* _tmp1_ = NULL;
		guint8* _tmp2_ = NULL;
		gsize _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* text = NULL;
		guint8* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		const gchar* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		GtkRecentManager* _tmp12_ = NULL;
		GFile* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		_tmp1_ = location;
		g_file_load_contents (_tmp1_, NULL, &_tmp2_, &_tmp3_, &_tmp4_, &_inner_error_);
		chars = (g_free (chars), NULL);
		chars = _tmp2_;
		chars_length1 = _tmp3_;
		_chars_size_ = chars_length1;
		_g_free0 (self->priv->_etag);
		self->priv->_etag = _tmp4_;
		if (_inner_error_ != NULL) {
			chars = (g_free (chars), NULL);
			goto __catch18_g_error;
		}
		_tmp5_ = chars;
		_tmp5__length1 = chars_length1;
		chars = NULL;
		text = (gchar*) _tmp5_;
		_tmp6_ = text;
		_tmp7_ = g_utf8_validate (_tmp6_, (gssize) (-1), NULL);
		if (_tmp7_) {
			const gchar* _tmp8_ = NULL;
			_tmp8_ = text;
			document_set_contents (self, _tmp8_);
		} else {
			gchar* utf8_text = NULL;
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			_tmp9_ = text;
			_tmp10_ = document_to_utf8 (self, _tmp9_, &_inner_error_);
			utf8_text = _tmp10_;
			if (_inner_error_ != NULL) {
				_g_free0 (text);
				chars = (g_free (chars), NULL);
				goto __catch18_g_error;
			}
			_tmp11_ = utf8_text;
			document_set_contents (self, _tmp11_);
			_g_free0 (utf8_text);
		}
		document_update_syntax_highlighting (self);
		_tmp12_ = gtk_recent_manager_get_default ();
		_tmp13_ = location;
		_tmp14_ = g_file_get_uri (_tmp13_);
		_tmp15_ = _tmp14_;
		gtk_recent_manager_add_item (_tmp12_, _tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (text);
		chars = (g_free (chars), NULL);
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		gchar* primary_msg = NULL;
		const gchar* _tmp18_ = NULL;
		GFile* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		DocumentTab* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		GError* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		TabInfoBar* _tmp28_ = NULL;
		TabInfoBar* _tmp29_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_warning ("document.vala:142: %s", _tmp17_);
		_tmp18_ = _ ("Impossible to load the file '%s'.");
		_tmp19_ = location;
		_tmp20_ = g_file_get_parse_name (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strdup_printf (_tmp18_, _tmp21_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp21_);
		primary_msg = _tmp23_;
		_tmp24_ = self->tab;
		_tmp25_ = primary_msg;
		_tmp26_ = e;
		_tmp27_ = _tmp26_->message;
		_tmp28_ = document_tab_add_message (_tmp24_, _tmp25_, _tmp27_, GTK_MESSAGE_ERROR);
		_tmp29_ = _tmp28_;
		_g_object_unref0 (_tmp29_);
		_g_free0 (primary_msg);
		_g_error_free0 (e);
	}
	__finally18:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_ = 0L;
	gboolean _tmp17_ = FALSE;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


void document_set_contents (Document* self, const gchar* contents) {
	gchar* contents2 = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gchar _tmp4_ = '\0';
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp13_ = NULL;
	GtkTextIter iter = {0};
	GtkTextIter _tmp14_ = {0};
	GtkTextIter _tmp15_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (contents != NULL);
	contents2 = NULL;
	_tmp0_ = contents;
	_tmp1_ = contents;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_get (_tmp0_, (glong) (_tmp3_ - 1));
	if (_tmp4_ == '\n') {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = contents;
		_tmp6_ = string_slice (_tmp5_, (glong) 0, (glong) (-1));
		_g_free0 (contents2);
		contents2 = _tmp6_;
	}
	gtk_source_buffer_begin_not_undoable_action ((GtkSourceBuffer*) self);
	_tmp8_ = contents2;
	_tmp9_ = g_strdup (_tmp8_);
	_tmp7_ = _tmp9_;
	_tmp10_ = _tmp7_;
	if (_tmp10_ == NULL) {
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		_tmp11_ = contents;
		_tmp12_ = g_strdup (_tmp11_);
		_g_free0 (_tmp7_);
		_tmp7_ = _tmp12_;
	}
	_tmp13_ = _tmp7_;
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, _tmp13_, -1);
	self->priv->new_file = TRUE;
	gtk_text_buffer_set_modified ((GtkTextBuffer*) self, FALSE);
	gtk_source_buffer_end_not_undoable_action ((GtkSourceBuffer*) self);
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) self, &_tmp14_);
	iter = _tmp14_;
	_tmp15_ = iter;
	gtk_text_buffer_place_cursor ((GtkTextBuffer*) self, &_tmp15_);
	_g_free0 (_tmp7_);
	_g_free0 (contents2);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static Block16Data* block16_data_ref (Block16Data* _data16_) {
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}


static void block16_data_unref (void * _userdata_) {
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		Document * self;
		self = _data16_->self;
		_g_object_unref0 (_data16_->infobar);
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}


static void ____lambda15_ (Block16Data* _data16_, gint response_id) {
	Document * self;
	gint _tmp0_ = 0;
	TabInfoBar* _tmp1_ = NULL;
	self = _data16_->self;
	_tmp0_ = response_id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_YES)) {
		document_save (self, FALSE, FALSE);
	}
	_tmp1_ = _data16_->infobar;
	gtk_widget_destroy ((GtkWidget*) _tmp1_);
}


static void _____lambda15__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self) {
	____lambda15_ (self, response_id);
}


void document_save (Document* self, gboolean check_file_changed_on_disk, gboolean force) {
	GFile* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp8_ = {0};
	GtkTextIter _tmp9_ = {0};
	gchar* text = NULL;
	GtkTextIter _tmp10_ = {0};
	GtkTextIter _tmp11_ = {0};
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gchar _tmp17_ = '\0';
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_location;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp3_ = force;
	if (!_tmp3_) {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = self->priv->new_file;
		_tmp2_ = !_tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp5_ = _tmp2_;
	if (_tmp5_) {
		gboolean _tmp6_ = FALSE;
		_tmp6_ = document_get_modified (self);
		_tmp1_ = !_tmp6_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp7_ = _tmp1_;
	if (_tmp7_) {
		return;
	}
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) self, &_tmp8_, &_tmp9_);
	start = _tmp8_;
	end = _tmp9_;
	_tmp10_ = start;
	_tmp11_ = end;
	_tmp12_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &_tmp10_, &_tmp11_, FALSE);
	text = _tmp12_;
	_tmp13_ = text;
	_tmp14_ = text;
	_tmp15_ = strlen (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = string_get (_tmp13_, (glong) (_tmp16_ - 1));
	if (_tmp17_ != '\n') {
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		_tmp18_ = text;
		_tmp19_ = string_to_string (_tmp18_);
		_tmp20_ = g_strconcat (_tmp19_, "\n", NULL);
		_g_free0 (text);
		text = _tmp20_;
	}
	{
		GSettings* settings = NULL;
		GSettings* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
		gboolean _tmp23_ = FALSE;
		gboolean make_backup = FALSE;
		gboolean _tmp26_ = FALSE;
		const gchar* _tmp27_ = NULL;
		gboolean _tmp28_ = FALSE;
		gchar* etag = NULL;
		const gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		GFile* parent = NULL;
		GFile* _tmp46_ = NULL;
		GFile* _tmp47_ = NULL;
		gboolean _tmp48_ = FALSE;
		GFile* _tmp49_ = NULL;
		gboolean _tmp52_ = FALSE;
		GFile* _tmp54_ = NULL;
		const gchar* _tmp55_ = NULL;
		guint8* _tmp56_ = NULL;
		gint _tmp56__length1 = 0;
		guint8* _tmp57_ = NULL;
		gint _tmp57__length1 = 0;
		const gchar* _tmp58_ = NULL;
		gboolean _tmp59_ = FALSE;
		gchar* _tmp60_ = NULL;
		GtkRecentManager* _tmp61_ = NULL;
		GFile* _tmp62_ = NULL;
		gchar* _tmp63_ = NULL;
		gchar* _tmp64_ = NULL;
		_tmp21_ = g_settings_new ("org.gnome.latexila.preferences.editor");
		settings = _tmp21_;
		_tmp23_ = self->priv->backup_made;
		if (!_tmp23_) {
			GSettings* _tmp24_ = NULL;
			gboolean _tmp25_ = FALSE;
			_tmp24_ = settings;
			_tmp25_ = g_settings_get_boolean (_tmp24_, "create-backup-copy");
			_tmp22_ = _tmp25_;
		} else {
			_tmp22_ = FALSE;
		}
		_tmp26_ = _tmp22_;
		make_backup = _tmp26_;
		_tmp28_ = check_file_changed_on_disk;
		if (_tmp28_) {
			const gchar* _tmp29_ = NULL;
			_tmp29_ = self->priv->_etag;
			_tmp27_ = _tmp29_;
		} else {
			_tmp27_ = NULL;
		}
		_tmp30_ = _tmp27_;
		_tmp31_ = g_strdup (_tmp30_);
		etag = _tmp31_;
		_tmp32_ = self->priv->encoding;
		if (_tmp32_ != NULL) {
			gchar* _tmp33_ = NULL;
			const gchar* _tmp34_ = NULL;
			const gchar* _tmp35_ = NULL;
			gint _tmp36_ = 0;
			gint _tmp37_ = 0;
			const gchar* _tmp38_ = NULL;
			gchar* _tmp39_ = NULL;
			_tmp34_ = text;
			_tmp35_ = text;
			_tmp36_ = strlen (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = self->priv->encoding;
			_tmp39_ = g_convert (_tmp34_, (gssize) _tmp37_, _tmp38_, "UTF-8", NULL, NULL, &_inner_error_);
			_tmp33_ = _tmp39_;
			if (_inner_error_ != NULL) {
				_g_free0 (etag);
				_g_object_unref0 (settings);
				goto __catch19_g_error;
			}
			_g_free0 (text);
			text = _tmp33_;
		} else {
			gchar* _tmp40_ = NULL;
			const gchar* _tmp41_ = NULL;
			const gchar* _tmp42_ = NULL;
			gint _tmp43_ = 0;
			gint _tmp44_ = 0;
			gchar* _tmp45_ = NULL;
			_tmp41_ = text;
			_tmp42_ = text;
			_tmp43_ = strlen (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = g_filename_from_utf8 (_tmp41_, (gssize) _tmp44_, NULL, NULL, &_inner_error_);
			_tmp40_ = _tmp45_;
			if (_inner_error_ != NULL) {
				_g_free0 (etag);
				_g_object_unref0 (settings);
				goto __catch19_g_error;
			}
			_g_free0 (text);
			text = _tmp40_;
		}
		_tmp46_ = self->priv->_location;
		_tmp47_ = g_file_get_parent (_tmp46_);
		parent = _tmp47_;
		_tmp49_ = parent;
		if (_tmp49_ != NULL) {
			GFile* _tmp50_ = NULL;
			gboolean _tmp51_ = FALSE;
			_tmp50_ = parent;
			_tmp51_ = g_file_query_exists (_tmp50_, NULL);
			_tmp48_ = !_tmp51_;
		} else {
			_tmp48_ = FALSE;
		}
		_tmp52_ = _tmp48_;
		if (_tmp52_) {
			GFile* _tmp53_ = NULL;
			_tmp53_ = parent;
			g_file_make_directory_with_parents (_tmp53_, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (parent);
				_g_free0 (etag);
				_g_object_unref0 (settings);
				goto __catch19_g_error;
			}
		}
		_tmp54_ = self->priv->_location;
		_tmp55_ = text;
		_tmp56_ = string_get_data (_tmp55_, &_tmp56__length1);
		_tmp57_ = _tmp56_;
		_tmp57__length1 = _tmp56__length1;
		_tmp58_ = etag;
		_tmp59_ = make_backup;
		g_file_replace_contents (_tmp54_, _tmp57_, (gsize) _tmp57__length1, _tmp58_, _tmp59_, G_FILE_CREATE_NONE, &_tmp60_, NULL, &_inner_error_);
		_g_free0 (self->priv->_etag);
		self->priv->_etag = _tmp60_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parent);
			_g_free0 (etag);
			_g_object_unref0 (settings);
			goto __catch19_g_error;
		}
		gtk_text_buffer_set_modified ((GtkTextBuffer*) self, FALSE);
		_tmp61_ = gtk_recent_manager_get_default ();
		_tmp62_ = self->priv->_location;
		_tmp63_ = g_file_get_uri (_tmp62_);
		_tmp64_ = _tmp63_;
		gtk_recent_manager_add_item (_tmp61_, _tmp64_);
		_g_free0 (_tmp64_);
		self->priv->backup_made = TRUE;
		_g_object_unref0 (parent);
		_g_free0 (etag);
		_g_object_unref0 (settings);
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError* e = NULL;
		GError* _tmp65_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp65_ = e;
		if (g_error_matches (_tmp65_, G_IO_ERROR, G_IO_ERROR_WRONG_ETAG)) {
			Block16Data* _data16_;
			gchar* primary_msg = NULL;
			const gchar* _tmp66_ = NULL;
			GFile* _tmp67_ = NULL;
			gchar* _tmp68_ = NULL;
			gchar* _tmp69_ = NULL;
			gchar* _tmp70_ = NULL;
			gchar* _tmp71_ = NULL;
			gchar* secondary_msg = NULL;
			const gchar* _tmp72_ = NULL;
			gchar* _tmp73_ = NULL;
			DocumentTab* _tmp74_ = NULL;
			const gchar* _tmp75_ = NULL;
			const gchar* _tmp76_ = NULL;
			TabInfoBar* _tmp77_ = NULL;
			TabInfoBar* _tmp78_ = NULL;
			const gchar* _tmp79_ = NULL;
			TabInfoBar* _tmp80_ = NULL;
			const gchar* _tmp81_ = NULL;
			TabInfoBar* _tmp82_ = NULL;
			_data16_ = g_slice_new0 (Block16Data);
			_data16_->_ref_count_ = 1;
			_data16_->self = g_object_ref (self);
			_tmp66_ = _ ("The file %s has been modified since reading it.");
			_tmp67_ = self->priv->_location;
			_tmp68_ = g_file_get_parse_name (_tmp67_);
			_tmp69_ = _tmp68_;
			_tmp70_ = g_strdup_printf (_tmp66_, _tmp69_);
			_tmp71_ = _tmp70_;
			_g_free0 (_tmp69_);
			primary_msg = _tmp71_;
			_tmp72_ = _ ("If you save it, all the external changes could be lost. Save it anyway" \
"?");
			_tmp73_ = g_strdup (_tmp72_);
			secondary_msg = _tmp73_;
			_tmp74_ = self->tab;
			_tmp75_ = primary_msg;
			_tmp76_ = secondary_msg;
			_tmp77_ = document_tab_add_message (_tmp74_, _tmp75_, _tmp76_, GTK_MESSAGE_WARNING);
			_data16_->infobar = _tmp77_;
			_tmp78_ = _data16_->infobar;
			_tmp79_ = _ ("Save Anyway");
			tab_info_bar_add_stock_button_with_text (_tmp78_, _tmp79_, GTK_STOCK_SAVE, (gint) GTK_RESPONSE_YES);
			_tmp80_ = _data16_->infobar;
			_tmp81_ = _ ("Don't Save");
			gtk_info_bar_add_button ((GtkInfoBar*) _tmp80_, _tmp81_, (gint) GTK_RESPONSE_CANCEL);
			_tmp82_ = _data16_->infobar;
			g_signal_connect_data ((GtkInfoBar*) _tmp82_, "response", (GCallback) _____lambda15__gtk_info_bar_response, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
			_g_free0 (secondary_msg);
			_g_free0 (primary_msg);
			block16_data_unref (_data16_);
			_data16_ = NULL;
		} else {
			GError* _tmp83_ = NULL;
			const gchar* _tmp84_ = NULL;
			gchar* primary_msg = NULL;
			const gchar* _tmp85_ = NULL;
			gchar* _tmp86_ = NULL;
			TabInfoBar* infobar = NULL;
			DocumentTab* _tmp87_ = NULL;
			const gchar* _tmp88_ = NULL;
			GError* _tmp89_ = NULL;
			const gchar* _tmp90_ = NULL;
			TabInfoBar* _tmp91_ = NULL;
			TabInfoBar* _tmp92_ = NULL;
			_tmp83_ = e;
			_tmp84_ = _tmp83_->message;
			g_warning ("document.vala:238: %s", _tmp84_);
			_tmp85_ = _ ("Impossible to save the file.");
			_tmp86_ = g_strdup (_tmp85_);
			primary_msg = _tmp86_;
			_tmp87_ = self->tab;
			_tmp88_ = primary_msg;
			_tmp89_ = e;
			_tmp90_ = _tmp89_->message;
			_tmp91_ = document_tab_add_message (_tmp87_, _tmp88_, _tmp90_, GTK_MESSAGE_ERROR);
			infobar = _tmp91_;
			_tmp92_ = infobar;
			tab_info_bar_add_ok_button (_tmp92_);
			_g_object_unref0 (infobar);
			_g_free0 (primary_msg);
		}
		_g_error_free0 (e);
	}
	__finally19:
	if (_inner_error_ != NULL) {
		_g_free0 (text);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (text);
}


static gchar* document_to_utf8 (Document* self, const gchar* text, GError** error) {
	gchar* result = NULL;
	const gchar* _tmp9_ = NULL;
	GError* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	{
		const gchar** charset_collection = NULL;
		gint charset_collection_length1 = 0;
		gint _charset_collection_size_ = 0;
		gint charset_it = 0;
		charset_collection = ENCODINGS_CHARSETS;
		charset_collection_length1 = G_N_ELEMENTS (ENCODINGS_CHARSETS);
		for (charset_it = 0; charset_it < G_N_ELEMENTS (ENCODINGS_CHARSETS); charset_it = charset_it + 1) {
			gchar* _tmp0_ = NULL;
			gchar* charset = NULL;
			_tmp0_ = g_strdup (charset_collection[charset_it]);
			charset = _tmp0_;
			{
				{
					gchar* utf8_text = NULL;
					const gchar* _tmp1_ = NULL;
					const gchar* _tmp2_ = NULL;
					gint _tmp3_ = 0;
					gint _tmp4_ = 0;
					const gchar* _tmp5_ = NULL;
					gchar* _tmp6_ = NULL;
					const gchar* _tmp7_ = NULL;
					gchar* _tmp8_ = NULL;
					_tmp1_ = text;
					_tmp2_ = text;
					_tmp3_ = strlen (_tmp2_);
					_tmp4_ = _tmp3_;
					_tmp5_ = charset;
					_tmp6_ = g_convert (_tmp1_, (gssize) _tmp4_, "UTF-8", _tmp5_, NULL, NULL, &_inner_error_);
					utf8_text = _tmp6_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == G_CONVERT_ERROR) {
							goto __catch20_g_convert_error;
						}
						_g_free0 (charset);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_tmp7_ = charset;
					_tmp8_ = g_strdup (_tmp7_);
					_g_free0 (self->priv->encoding);
					self->priv->encoding = _tmp8_;
					result = utf8_text;
					_g_free0 (charset);
					return result;
				}
				goto __finally20;
				__catch20_g_convert_error:
				{
					GError* e = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (e);
					_g_free0 (charset);
					continue;
				}
				__finally20:
				if (_inner_error_->domain == G_CONVERT_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (charset);
					return NULL;
				} else {
					_g_free0 (charset);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_free0 (charset);
			}
		}
	}
	_tmp9_ = _ ("Error trying to convert the document to UTF-8");
	_tmp10_ = g_error_new_literal (G_CONVERT_ERROR, G_CONVERT_ERROR_FAILED, _tmp9_);
	_inner_error_ = _tmp10_;
	if (_inner_error_->domain == G_CONVERT_ERROR) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void document_update_syntax_highlighting (Document* self) {
	GtkSourceLanguageManager* lm = NULL;
	GtkSourceLanguageManager* _tmp0_ = NULL;
	GtkSourceLanguageManager* _tmp1_ = NULL;
	gchar* content_type = NULL;
	GtkSourceLanguage* lang = NULL;
	GFile* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GtkSourceLanguage* _tmp10_ = NULL;
	GtkSourceLanguage* _tmp11_ = NULL;
	GtkSourceLanguage* _tmp12_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_source_language_manager_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	lm = _tmp1_;
	content_type = NULL;
	{
		GFileInfo* info = NULL;
		GFile* _tmp2_ = NULL;
		GFileInfo* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp2_ = self->priv->_location;
		_tmp3_ = g_file_query_info (_tmp2_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
		info = _tmp3_;
		if (_inner_error_ != NULL) {
			goto __catch21_g_error;
		}
		_tmp4_ = g_file_info_get_content_type (info);
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (content_type);
		content_type = _tmp5_;
		_g_object_unref0 (info);
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally21:
	if (_inner_error_ != NULL) {
		_g_free0 (content_type);
		_g_object_unref0 (lm);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = self->priv->_location;
	_tmp7_ = g_file_get_parse_name (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = content_type;
	_tmp10_ = gtk_source_language_manager_guess_language (lm, _tmp8_, _tmp9_);
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp8_);
	lang = _tmp12_;
	gtk_source_buffer_set_language ((GtkSourceBuffer*) self, lang);
	_g_object_unref0 (lang);
	_g_free0 (content_type);
	_g_object_unref0 (lm);
}


static void document_update_project_id (Document* self) {
	gint i = 0;
	g_return_if_fail (self != NULL);
	i = 0;
	{
		GeeIterator* _project_it = NULL;
		Projects* _tmp0_ = NULL;
		Projects* _tmp1_ = NULL;
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _tmp3_ = NULL;
		_tmp0_ = projects_get_default ();
		_tmp1_ = _tmp0_;
		_tmp2_ = projects_iterator (_tmp1_);
		_tmp3_ = _tmp2_;
		_projects_unref0 (_tmp1_);
		_project_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
			Project project = {0};
			GeeIterator* _tmp6_ = NULL;
			gpointer _tmp7_ = NULL;
			Project* _tmp8_ = NULL;
			Project _tmp9_ = {0};
			Project _tmp10_ = {0};
			GFile* _tmp11_ = NULL;
			Project _tmp12_ = {0};
			GFile* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			gint _tmp16_ = 0;
			_tmp4_ = _project_it;
			_tmp5_ = gee_iterator_next (_tmp4_);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = _project_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			_tmp8_ = (Project*) _tmp7_;
			project_copy (_tmp8_, &_tmp9_);
			_tmp10_ = _tmp9_;
			_project_free0 (_tmp8_);
			project = _tmp10_;
			_tmp11_ = self->priv->_location;
			_tmp12_ = project;
			_tmp13_ = _tmp12_.directory;
			_tmp14_ = g_file_has_prefix (_tmp11_, _tmp13_);
			if (_tmp14_) {
				gint _tmp15_ = 0;
				_tmp15_ = i;
				document_set_project_id (self, _tmp15_);
				project_destroy (&project);
				_g_object_unref0 (_project_it);
				return;
			}
			_tmp16_ = i;
			i = _tmp16_ + 1;
			project_destroy (&project);
		}
		_g_object_unref0 (_project_it);
	}
	document_set_project_id (self, -1);
}


gchar* document_get_uri_for_display (Document* self) {
	gchar* result = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_ = NULL;
		_tmp1_ = document_get_unsaved_document_name (self);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->priv->_location;
	_tmp3_ = g_file_get_parse_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = utils_replace_home_dir_with_tilde (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	result = _tmp6_;
	return result;
}


gchar* document_get_short_name_for_display (Document* self) {
	gchar* result = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_ = NULL;
		_tmp1_ = document_get_unsaved_document_name (self);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->priv->_location;
	_tmp3_ = g_file_get_basename (_tmp2_);
	result = _tmp3_;
	return result;
}


static gchar* document_get_unsaved_document_name (Document* self) {
	gchar* result = NULL;
	guint num = 0U;
	guint _tmp0_ = 0U;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = document_get_unsaved_document_num (self);
	num = _tmp0_;
	_tmp1_ = _ ("Unsaved Document");
	_tmp2_ = g_strdup_printf ("%u", num);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (" ", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp1_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	result = _tmp7_;
	return result;
}


static void _vala_array_add14 (guint** array, int* length, int* size, guint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static gboolean _vala_uint_array_contains (guint* stack, int stack_length, guint needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}


static guint document_get_unsaved_document_num (Document* self) {
	guint result = 0U;
	GFile* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint* all_nums = NULL;
	guint* _tmp3_ = NULL;
	gint all_nums_length1 = 0;
	gint _all_nums_size_ = 0;
	guint num = 0U;
	guint _tmp28_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_location;
	g_return_val_if_fail (_tmp0_ == NULL, 0);
	_tmp1_ = self->_unsaved_doc_num;
	if (_tmp1_ > ((guint) 0)) {
		guint _tmp2_ = 0U;
		_tmp2_ = self->_unsaved_doc_num;
		result = _tmp2_;
		return result;
	}
	_tmp3_ = g_new0 (guint, 0);
	all_nums = _tmp3_;
	all_nums_length1 = 0;
	_all_nums_size_ = all_nums_length1;
	{
		GeeList* _doc_list = NULL;
		Latexila* _tmp4_ = NULL;
		Latexila* _tmp5_ = NULL;
		GeeList* _tmp6_ = NULL;
		GeeList* _tmp7_ = NULL;
		gint _doc_size = 0;
		GeeList* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _doc_index = 0;
		_tmp4_ = latexila_get_instance ();
		_tmp5_ = _tmp4_;
		_tmp6_ = latexila_get_documents (_tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_doc_list = _tmp7_;
		_tmp8_ = _doc_list;
		_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_doc_size = _tmp10_;
		_doc_index = -1;
		while (TRUE) {
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			Document* doc = NULL;
			GeeList* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			gpointer _tmp16_ = NULL;
			Document* _tmp17_ = NULL;
			Document* _tmp18_ = NULL;
			GFile* _tmp19_ = NULL;
			_tmp11_ = _doc_index;
			_doc_index = _tmp11_ + 1;
			_tmp12_ = _doc_index;
			_tmp13_ = _doc_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _doc_list;
			_tmp15_ = _doc_index;
			_tmp16_ = gee_list_get (_tmp14_, _tmp15_);
			doc = (Document*) _tmp16_;
			_tmp17_ = doc;
			if (_tmp17_ == self) {
				_g_object_unref0 (doc);
				continue;
			}
			_tmp18_ = doc;
			_tmp19_ = _tmp18_->priv->_location;
			if (_tmp19_ == NULL) {
				guint* _tmp20_ = NULL;
				gint _tmp20__length1 = 0;
				Document* _tmp21_ = NULL;
				guint _tmp22_ = 0U;
				_tmp20_ = all_nums;
				_tmp20__length1 = all_nums_length1;
				_tmp21_ = doc;
				_tmp22_ = document_get_unsaved_document_num (_tmp21_);
				_vala_array_add14 (&all_nums, &all_nums_length1, &_all_nums_size_, _tmp22_);
			}
			_g_object_unref0 (doc);
		}
		_g_object_unref0 (_doc_list);
	}
	{
		gboolean _tmp23_ = FALSE;
		num = (guint) 1;
		_tmp23_ = TRUE;
		while (TRUE) {
			gboolean _tmp24_ = FALSE;
			guint _tmp26_ = 0U;
			guint* _tmp27_ = NULL;
			gint _tmp27__length1 = 0;
			_tmp24_ = _tmp23_;
			if (!_tmp24_) {
				guint _tmp25_ = 0U;
				_tmp25_ = num;
				num = _tmp25_ + 1;
			}
			_tmp23_ = FALSE;
			_tmp26_ = num;
			_tmp27_ = all_nums;
			_tmp27__length1 = all_nums_length1;
			if (!_vala_uint_array_contains (_tmp27_, _tmp27__length1, _tmp26_)) {
				break;
			}
		}
	}
	_tmp28_ = num;
	self->_unsaved_doc_num = _tmp28_;
	result = num;
	all_nums = (g_free (all_nums), NULL);
	return result;
}


gboolean document_is_local (Document* self) {
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_location;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->_location;
	_tmp2_ = g_file_has_uri_scheme (_tmp1_, "file");
	result = _tmp2_;
	return result;
}


gboolean document_is_externally_modified (Document* self) {
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	gchar* current_etag = NULL;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp10_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_location;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	current_etag = NULL;
	{
		GFileInfo* file_info = NULL;
		GFile* _tmp1_ = NULL;
		GFileInfo* _tmp2_ = NULL;
		GFileInfo* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp1_ = self->priv->_location;
		_tmp2_ = g_file_query_info (_tmp1_, G_FILE_ATTRIBUTE_ETAG_VALUE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
		file_info = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch22_g_error;
		}
		_tmp3_ = file_info;
		_tmp4_ = g_file_info_get_etag (_tmp3_);
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (current_etag);
		current_etag = _tmp5_;
		_g_object_unref0 (file_info);
	}
	goto __finally22;
	__catch22_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (current_etag);
		return result;
	}
	__finally22:
	if (_inner_error_ != NULL) {
		_g_free0 (current_etag);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp7_ = current_etag;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		_tmp8_ = current_etag;
		_tmp9_ = self->priv->_etag;
		_tmp6_ = g_strcmp0 (_tmp8_, _tmp9_) != 0;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp10_ = _tmp6_;
	result = _tmp10_;
	_g_free0 (current_etag);
	return result;
}


void document_set_style_scheme_from_string (Document* self, const gchar* scheme_id) {
	GtkSourceStyleSchemeManager* manager = NULL;
	GtkSourceStyleSchemeManager* _tmp0_ = NULL;
	GtkSourceStyleSchemeManager* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkSourceStyleScheme* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scheme_id != NULL);
	_tmp0_ = gtk_source_style_scheme_manager_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	manager = _tmp1_;
	_tmp2_ = scheme_id;
	_tmp3_ = gtk_source_style_scheme_manager_get_scheme (manager, _tmp2_);
	gtk_source_buffer_set_style_scheme ((GtkSourceBuffer*) self, _tmp3_);
	_g_object_unref0 (manager);
}


static void document_emit_cursor_moved (Document* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stop_cursor_moved_emission;
	if (!_tmp0_) {
		g_signal_emit_by_name (self, "cursor-moved");
	}
}


void document_comment_selected_lines (Document* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	GtkTextIter _tmp2_ = {0};
	GtkTextIter _tmp3_ = {0};
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self, &_tmp0_, &_tmp1_);
	start = _tmp0_;
	end = _tmp1_;
	_tmp2_ = start;
	_tmp3_ = end;
	document_comment_between (self, &_tmp2_, &_tmp3_, TRUE);
}


void document_comment_between (Document* self, GtkTextIter* start_iter, GtkTextIter* end_iter, gboolean end_iter_set) {
	gint start_line = 0;
	gint _tmp0_ = 0;
	gint end_line = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	GtkTextIter cur_iter = {0};
	gint _tmp4_ = 0;
	GtkTextIter _tmp5_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (start_iter != NULL);
	g_return_if_fail (end_iter != NULL);
	_tmp0_ = gtk_text_iter_get_line (start_iter);
	start_line = _tmp0_;
	_tmp1_ = start_line;
	end_line = _tmp1_;
	_tmp2_ = end_iter_set;
	if (_tmp2_) {
		gint _tmp3_ = 0;
		_tmp3_ = gtk_text_iter_get_line (end_iter);
		end_line = _tmp3_;
	}
	_tmp4_ = start_line;
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp5_, _tmp4_);
	cur_iter = _tmp5_;
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*) self);
	{
		gint line_num = 0;
		gint _tmp6_ = 0;
		_tmp6_ = start_line;
		line_num = _tmp6_;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_ = FALSE;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					gint _tmp9_ = 0;
					_tmp9_ = line_num;
					line_num = _tmp9_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp10_ = line_num;
				_tmp11_ = end_line;
				if (!(_tmp10_ <= _tmp11_)) {
					break;
				}
				document_insert (self, &cur_iter, "% ", -1);
				gtk_text_iter_forward_line (&cur_iter);
			}
		}
	}
	gtk_text_buffer_end_user_action ((GtkTextBuffer*) self);
}


void document_uncomment_selected_lines (Document* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	gint start_line = 0;
	gint _tmp2_ = 0;
	gint end_line = 0;
	gint _tmp3_ = 0;
	gint line_count = 0;
	gint _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self, &_tmp0_, &_tmp1_);
	start = _tmp0_;
	end = _tmp1_;
	_tmp2_ = gtk_text_iter_get_line (&start);
	start_line = _tmp2_;
	_tmp3_ = gtk_text_iter_get_line (&end);
	end_line = _tmp3_;
	_tmp4_ = gtk_text_buffer_get_line_count ((GtkTextBuffer*) self);
	line_count = _tmp4_;
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*) self);
	{
		gint i = 0;
		gint _tmp5_ = 0;
		_tmp5_ = start_line;
		i = _tmp5_;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gboolean _tmp7_ = FALSE;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				GtkTextIter _tmp12_ = {0};
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gchar* line = NULL;
				GtkTextIter _tmp18_ = {0};
				GtkTextIter _tmp19_ = {0};
				gchar* _tmp20_ = NULL;
				gint j = 0;
				gint start_delete = 0;
				gint stop_delete = 0;
				gint _tmp42_ = 0;
				gint _tmp43_ = 0;
				gint _tmp44_ = 0;
				GtkTextIter _tmp45_ = {0};
				gint _tmp46_ = 0;
				gint _tmp47_ = 0;
				GtkTextIter _tmp48_ = {0};
				_tmp7_ = _tmp6_;
				if (!_tmp7_) {
					gint _tmp8_ = 0;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp9_ = i;
				_tmp10_ = end_line;
				if (!(_tmp9_ <= _tmp10_)) {
					break;
				}
				_tmp11_ = i;
				gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp12_, _tmp11_);
				start = _tmp12_;
				_tmp13_ = i;
				_tmp14_ = line_count;
				if (_tmp13_ == (_tmp14_ - 1)) {
					GtkTextIter _tmp15_ = {0};
					gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self, &_tmp15_);
					end = _tmp15_;
				} else {
					gint _tmp16_ = 0;
					GtkTextIter _tmp17_ = {0};
					_tmp16_ = i;
					gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp17_, _tmp16_ + 1);
					end = _tmp17_;
				}
				_tmp18_ = start;
				_tmp19_ = end;
				_tmp20_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &_tmp18_, &_tmp19_, FALSE);
				line = _tmp20_;
				j = 0;
				start_delete = -1;
				stop_delete = -1;
				while (TRUE) {
					const gchar* _tmp21_ = NULL;
					gint _tmp22_ = 0;
					gchar _tmp23_ = '\0';
					const gchar* _tmp24_ = NULL;
					gint _tmp25_ = 0;
					gchar _tmp26_ = '\0';
					gint _tmp41_ = 0;
					_tmp21_ = line;
					_tmp22_ = j;
					_tmp23_ = string_get (_tmp21_, (glong) _tmp22_);
					if (!(_tmp23_ != '\0')) {
						break;
					}
					_tmp24_ = line;
					_tmp25_ = j;
					_tmp26_ = string_get (_tmp24_, (glong) _tmp25_);
					if (_tmp26_ == '%') {
						gint _tmp27_ = 0;
						gint _tmp28_ = 0;
						const gchar* _tmp29_ = NULL;
						gint _tmp30_ = 0;
						gchar _tmp31_ = '\0';
						_tmp27_ = j;
						start_delete = _tmp27_;
						_tmp28_ = j;
						stop_delete = _tmp28_ + 1;
						_tmp29_ = line;
						_tmp30_ = j;
						_tmp31_ = string_get (_tmp29_, (glong) (_tmp30_ + 1));
						if (_tmp31_ == ' ') {
							gint _tmp32_ = 0;
							_tmp32_ = stop_delete;
							stop_delete = _tmp32_ + 1;
						}
						break;
					} else {
						gboolean _tmp33_ = FALSE;
						const gchar* _tmp34_ = NULL;
						gint _tmp35_ = 0;
						gchar _tmp36_ = '\0';
						gboolean _tmp40_ = FALSE;
						_tmp34_ = line;
						_tmp35_ = j;
						_tmp36_ = string_get (_tmp34_, (glong) _tmp35_);
						if (_tmp36_ != ' ') {
							const gchar* _tmp37_ = NULL;
							gint _tmp38_ = 0;
							gchar _tmp39_ = '\0';
							_tmp37_ = line;
							_tmp38_ = j;
							_tmp39_ = string_get (_tmp37_, (glong) _tmp38_);
							_tmp33_ = _tmp39_ != '\t';
						} else {
							_tmp33_ = FALSE;
						}
						_tmp40_ = _tmp33_;
						if (_tmp40_) {
							break;
						}
					}
					_tmp41_ = j;
					j = _tmp41_ + 1;
				}
				_tmp42_ = start_delete;
				if (_tmp42_ == (-1)) {
					_g_free0 (line);
					continue;
				}
				_tmp43_ = i;
				_tmp44_ = start_delete;
				gtk_text_buffer_get_iter_at_line_offset ((GtkTextBuffer*) self, &_tmp45_, _tmp43_, _tmp44_);
				start = _tmp45_;
				_tmp46_ = i;
				_tmp47_ = stop_delete;
				gtk_text_buffer_get_iter_at_line_offset ((GtkTextBuffer*) self, &_tmp48_, _tmp46_, _tmp47_);
				end = _tmp48_;
				gtk_text_buffer_delete ((GtkTextBuffer*) self, &start, &end);
				_g_free0 (line);
			}
		}
	}
	gtk_text_buffer_end_user_action ((GtkTextBuffer*) self);
}


void document_select_lines (Document* self, gint start, gint end) {
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	gint _tmp0_ = 0;
	GtkTextIter _tmp1_ = {0};
	gint _tmp2_ = 0;
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_ = {0};
	GtkTextIter _tmp5_ = {0};
	DocumentTab* _tmp6_ = NULL;
	DocumentView* _tmp7_ = NULL;
	DocumentView* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = start;
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp1_, _tmp0_);
	start_iter = _tmp1_;
	_tmp2_ = end;
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp3_, _tmp2_);
	end_iter = _tmp3_;
	_tmp4_ = start_iter;
	_tmp5_ = end_iter;
	gtk_text_buffer_select_range ((GtkTextBuffer*) self, &_tmp4_, &_tmp5_);
	_tmp6_ = self->tab;
	_tmp7_ = document_tab_get_view (_tmp6_);
	_tmp8_ = _tmp7_;
	document_view_scroll_to_cursor (_tmp8_, 0.25);
}


SelectionType document_get_selection_type (Document* self) {
	SelectionType result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp2_ = {0};
	GtkTextIter _tmp3_ = {0};
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		result = SELECTION_TYPE_NO_SELECTION;
		return result;
	}
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self, &_tmp2_, &_tmp3_);
	start = _tmp2_;
	end = _tmp3_;
	_tmp4_ = gtk_text_iter_get_line (&start);
	_tmp5_ = gtk_text_iter_get_line (&end);
	if (_tmp4_ == _tmp5_) {
		result = SELECTION_TYPE_ONE_LINE;
		return result;
	}
	result = SELECTION_TYPE_MULTIPLE_LINES;
	return result;
}


gboolean document_goto_line (Document* self, gint line) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gboolean ret = FALSE;
	GtkTextIter iter = {0};
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GtkTextIter _tmp6_ = {0};
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = line;
	g_return_val_if_fail (_tmp0_ >= (-1), FALSE);
	ret = TRUE;
	_tmp1_ = line;
	_tmp2_ = gtk_text_buffer_get_line_count ((GtkTextBuffer*) self);
	if (_tmp1_ >= _tmp2_) {
		GtkTextIter _tmp3_ = {0};
		ret = FALSE;
		gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self, &_tmp3_);
		iter = _tmp3_;
	} else {
		gint _tmp4_ = 0;
		GtkTextIter _tmp5_ = {0};
		_tmp4_ = line;
		gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp5_, _tmp4_);
		iter = _tmp5_;
	}
	_tmp6_ = iter;
	gtk_text_buffer_place_cursor ((GtkTextBuffer*) self, &_tmp6_);
	result = ret;
	return result;
}


Project* document_get_project (Document* self) {
	Project* result = NULL;
	gint _tmp0_ = 0;
	Projects* _tmp1_ = NULL;
	Projects* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	Project* _tmp4_ = NULL;
	Project* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_project_id;
	if (_tmp0_ == (-1)) {
		result = NULL;
		return result;
	}
	_tmp1_ = projects_get_default ();
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_project_id;
	_tmp4_ = projects_get (_tmp2_, _tmp3_);
	_tmp5_ = _tmp4_;
	_projects_unref0 (_tmp2_);
	result = _tmp5_;
	return result;
}


GFile* document_get_main_file (Document* self) {
	GFile* result = NULL;
	GFile* _tmp0_ = NULL;
	Project* project = NULL;
	Project* _tmp1_ = NULL;
	Project* _tmp2_ = NULL;
	Project* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	GFile* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = document_get_project (self);
	project = _tmp1_;
	_tmp2_ = project;
	if (_tmp2_ == NULL) {
		GFile* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		_tmp3_ = self->priv->_location;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		result = _tmp4_;
		_project_free0 (project);
		return result;
	}
	_tmp5_ = project;
	_tmp6_ = (*_tmp5_).main_file;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	result = _tmp7_;
	_project_free0 (project);
	return result;
}


gboolean document_is_main_file_a_tex_file (Document* self) {
	gboolean result = FALSE;
	GFile* main_file = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gchar* path = NULL;
	GFile* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = document_get_main_file (self);
	main_file = _tmp0_;
	_tmp1_ = main_file;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (main_file);
		return result;
	}
	_tmp2_ = main_file;
	_tmp3_ = g_file_get_parse_name (_tmp2_);
	path = _tmp3_;
	_tmp4_ = path;
	_tmp5_ = g_str_has_suffix (_tmp4_, ".tex");
	result = _tmp5_;
	_g_free0 (path);
	_g_object_unref0 (main_file);
	return result;
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	_vala_c = _tmp1_;
	_tmp2_ = _vala_c;
	if (_tmp2_ != ((gunichar) 0)) {
		gint _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
		_tmp3_ = *index;
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
		*index = (gint) (_tmp4_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


gchar* document_get_current_indentation (Document* self, GtkTextIter* iter) {
	gchar* result = NULL;
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	gint line = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GtkTextIter _tmp2_ = {0};
	gint _tmp3_ = 0;
	GtkTextIter _tmp4_ = {0};
	gchar* text = NULL;
	GtkTextIter _tmp5_ = {0};
	GtkTextIter _tmp6_ = {0};
	gchar* _tmp7_ = NULL;
	gchar* current_indent = NULL;
	gchar* _tmp8_ = NULL;
	gint index = 0;
	gunichar cur_char = 0U;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = gtk_text_iter_get_line (iter);
	line = _tmp0_;
	_tmp1_ = line;
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp2_, _tmp1_);
	start_iter = _tmp2_;
	_tmp3_ = line;
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp4_, _tmp3_ + 1);
	end_iter = _tmp4_;
	_tmp5_ = start_iter;
	_tmp6_ = end_iter;
	_tmp7_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &_tmp5_, &_tmp6_, FALSE);
	text = _tmp7_;
	_tmp8_ = g_strdup ("");
	current_indent = _tmp8_;
	index = 0;
	while (TRUE) {
		const gchar* _tmp9_ = NULL;
		gunichar _tmp10_ = 0U;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gunichar _tmp13_ = 0U;
		gboolean _tmp15_ = FALSE;
		_tmp9_ = text;
		_tmp11_ = string_get_next_char (_tmp9_, &index, &_tmp10_);
		cur_char = _tmp10_;
		if (!_tmp11_) {
			break;
		}
		_tmp13_ = cur_char;
		if (_tmp13_ == ((gunichar) ' ')) {
			_tmp12_ = TRUE;
		} else {
			gunichar _tmp14_ = 0U;
			_tmp14_ = cur_char;
			_tmp12_ = _tmp14_ == ((gunichar) '\t');
		}
		_tmp15_ = _tmp12_;
		if (_tmp15_) {
			const gchar* _tmp16_ = NULL;
			gunichar _tmp17_ = 0U;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			_tmp16_ = current_indent;
			_tmp17_ = cur_char;
			_tmp18_ = g_unichar_to_string (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strconcat (_tmp16_, _tmp19_, NULL);
			_g_free0 (current_indent);
			current_indent = _tmp20_;
			_g_free0 (_tmp19_);
		} else {
			break;
		}
	}
	result = current_indent;
	_g_free0 (text);
	return result;
}


DocumentStructure* document_get_structure (Document* self) {
	DocumentStructure* result = NULL;
	DocumentStructure* _tmp0_ = NULL;
	DocumentStructure* _tmp3_ = NULL;
	DocumentStructure* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_structure;
	if (_tmp0_ == NULL) {
		DocumentStructure* _tmp1_ = NULL;
		DocumentStructure* _tmp2_ = NULL;
		_tmp1_ = document_structure_new (self);
		_g_object_unref0 (self->priv->_structure);
		self->priv->_structure = _tmp1_;
		_tmp2_ = self->priv->_structure;
		document_structure_parse (_tmp2_);
	}
	_tmp3_ = self->priv->_structure;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	result = _tmp4_;
	return result;
}


static Block17Data* block17_data_ref (Block17Data* _data17_) {
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}


static void block17_data_unref (void * _userdata_) {
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		Document * self;
		self = _data17_->self;
		_g_object_unref0 (_data17_->infobar);
		_g_object_unref0 (self);
		g_slice_free (Block17Data, _data17_);
	}
}


static void __lambda76_ (Block17Data* _data17_, gint response_id) {
	Document * self;
	gint _tmp0_ = 0;
	TabInfoBar* _tmp5_ = NULL;
	self = _data17_->self;
	_tmp0_ = response_id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_YES)) {
		MainWindow* main_window = NULL;
		DocumentTab* _tmp1_ = NULL;
		GtkWindow* _tmp2_ = NULL;
		MainWindow* _tmp3_ = NULL;
		_tmp1_ = self->tab;
		_tmp2_ = utils_get_toplevel_window ((GtkWidget*) _tmp1_);
		main_window = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, TYPE_MAIN_WINDOW) ? ((MainWindow*) _tmp2_) : NULL;
		_tmp3_ = main_window;
		if (_tmp3_ != NULL) {
			MainWindow* _tmp4_ = NULL;
			_tmp4_ = main_window;
			main_window_save_document (_tmp4_, self, TRUE);
		}
	}
	_tmp5_ = _data17_->infobar;
	gtk_widget_destroy ((GtkWidget*) _tmp5_);
}


static void ___lambda76__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self) {
	__lambda76_ (self, response_id);
}


gboolean document_set_tmp_location (Document* self) {
	gboolean result = FALSE;
	Block17Data* _data17_;
	gchar* template = NULL;
	gchar* _tmp0_ = NULL;
	gchar* tmp_dir = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GFile* _tmp9_ = NULL;
	GFile* _tmp10_ = NULL;
	DocumentTab* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	TabInfoBar* _tmp14_ = NULL;
	TabInfoBar* _tmp15_ = NULL;
	TabInfoBar* _tmp16_ = NULL;
	TabInfoBar* _tmp17_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_data17_ = g_slice_new0 (Block17Data);
	_data17_->_ref_count_ = 1;
	_data17_->self = g_object_ref (self);
	_tmp0_ = g_strdup ("latexila-XXXXXX");
	template = _tmp0_;
	{
		gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp2_ = template;
		_tmp3_ = g_dir_make_tmp (_tmp2_, &_inner_error_);
		_tmp1_ = _tmp3_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch23_g_file_error;
			}
			_g_free0 (tmp_dir);
			_g_free0 (template);
			block17_data_unref (_data17_);
			_data17_ = NULL;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_g_free0 (tmp_dir);
		tmp_dir = _tmp1_;
	}
	goto __finally23;
	__catch23_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("document.vala:594: Impossible to create temporary directory: %s", _tmp5_);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (tmp_dir);
		_g_free0 (template);
		block17_data_unref (_data17_);
		_data17_ = NULL;
		return result;
	}
	__finally23:
	if (_inner_error_ != NULL) {
		_g_free0 (tmp_dir);
		_g_free0 (template);
		block17_data_unref (_data17_);
		_data17_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp6_ = tmp_dir;
	_tmp7_ = g_build_filename (_tmp6_, "tmp.tex", NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_file_new_for_path (_tmp8_);
	_tmp10_ = _tmp9_;
	document_set_location (self, _tmp10_);
	_g_object_unref0 (_tmp10_);
	_g_free0 (_tmp8_);
	_tmp11_ = self->tab;
	_tmp12_ = _ ("The file has a temporary location. The data can be lost after rebootin" \
"g your computer.");
	_tmp13_ = _ ("Do you want to save the file in a safer place?");
	_tmp14_ = document_tab_add_message (_tmp11_, _tmp12_, _tmp13_, GTK_MESSAGE_WARNING);
	_data17_->infobar = _tmp14_;
	_tmp15_ = _data17_->infobar;
	gtk_info_bar_add_button ((GtkInfoBar*) _tmp15_, GTK_STOCK_SAVE_AS, (gint) GTK_RESPONSE_YES);
	_tmp16_ = _data17_->infobar;
	gtk_info_bar_add_button ((GtkInfoBar*) _tmp16_, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_NO);
	_tmp17_ = _data17_->infobar;
	g_signal_connect_data ((GtkInfoBar*) _tmp17_, "response", (GCallback) ___lambda76__gtk_info_bar_response, block17_data_ref (_data17_), (GClosureNotify) block17_data_unref, 0);
	result = TRUE;
	_g_free0 (tmp_dir);
	_g_free0 (template);
	block17_data_unref (_data17_);
	_data17_ = NULL;
	return result;
}


/***************
     *    SEARCH
     ***************/
static void _document_search_cursor_moved_handler_document_cursor_moved (Document* _sender, gpointer self) {
	document_search_cursor_moved_handler (self);
}


static void _document_search_delete_range_before_handler_gtk_text_buffer_delete_range (GtkTextBuffer* _sender, GtkTextIter* start, GtkTextIter* end, gpointer self) {
	document_search_delete_range_before_handler (self, start, end);
}


static void _document_search_delete_range_after_handler_gtk_text_buffer_delete_range (GtkTextBuffer* _sender, GtkTextIter* start, GtkTextIter* end, gpointer self) {
	document_search_delete_range_after_handler (self, start);
}


static void _document_search_insert_text_before_handler_gtk_text_buffer_insert_text (GtkTextBuffer* _sender, GtkTextIter* pos, const gchar* new_text, gint new_text_length, gpointer self) {
	document_search_insert_text_before_handler (self, pos);
}


static void _document_search_insert_text_after_handler_gtk_text_buffer_insert_text (GtkTextBuffer* _sender, GtkTextIter* pos, const gchar* new_text, gint new_text_length, gpointer self) {
	document_search_insert_text_after_handler (self, pos, new_text, new_text_length);
}


void document_set_search_text (Document* self, const gchar* text, gboolean case_sensitive, gboolean entire_word, guint* nb_matches, guint* num_match, gboolean select) {
	guint _vala_nb_matches = 0U;
	guint _vala_num_match = 0U;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	GtkTextIter start = {0};
	GtkTextIter _tmp17_ = {0};
	GtkTextIter match_start = {0};
	GtkTextIter _tmp18_ = {0};
	GtkTextIter match_end = {0};
	GtkTextIter _tmp19_ = {0};
	GtkTextIter insert = {0};
	GtkTextIter _tmp20_ = {0};
	GtkTextIter try_match_start = {0};
	GtkTextIter _tmp21_ = {0};
	GtkTextIter try_match_end = {0};
	GtkTextIter _tmp22_ = {0};
	GtkTextIter _tmp23_ = {0};
	GtkTextMark* _tmp24_ = NULL;
	GtkTextIter _tmp25_ = {0};
	gboolean next_match_after_cursor_found = FALSE;
	gboolean _tmp26_ = FALSE;
	guint i = 0U;
	gboolean _tmp47_ = FALSE;
	gboolean _tmp48_ = FALSE;
	gboolean _tmp50_ = FALSE;
	guint _tmp55_ = 0U;
	guint _tmp56_ = 0U;
	guint _tmp57_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_vala_num_match = (guint) 0;
	_tmp0_ = self->priv->search_text;
	if (_tmp0_ == NULL) {
		g_signal_connect_object (self, "cursor-moved", (GCallback) _document_search_cursor_moved_handler_document_cursor_moved, self, 0);
		g_signal_connect_object ((GtkTextBuffer*) self, "delete-range", (GCallback) _document_search_delete_range_before_handler_gtk_text_buffer_delete_range, self, 0);
		g_signal_connect_object ((GtkTextBuffer*) self, "delete-range", (GCallback) _document_search_delete_range_after_handler_gtk_text_buffer_delete_range, self, G_CONNECT_AFTER);
		g_signal_connect_object ((GtkTextBuffer*) self, "insert-text", (GCallback) _document_search_insert_text_before_handler_gtk_text_buffer_insert_text, self, 0);
		g_signal_connect_object ((GtkTextBuffer*) self, "insert-text", (GCallback) _document_search_insert_text_after_handler_gtk_text_buffer_insert_text, self, G_CONNECT_AFTER);
	}
	_tmp3_ = self->priv->search_text;
	_tmp4_ = text;
	if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		_tmp5_ = self->priv->search_case_sensitive;
		_tmp6_ = case_sensitive;
		_tmp2_ = _tmp5_ == _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		_tmp8_ = self->priv->search_entire_word;
		_tmp9_ = entire_word;
		_tmp1_ = _tmp8_ == _tmp9_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp10_ = _tmp1_;
	if (_tmp10_) {
		guint _tmp11_ = 0U;
		guint _tmp12_ = 0U;
		_tmp11_ = self->priv->search_nb_matches;
		_vala_nb_matches = _tmp11_;
		_tmp12_ = self->priv->search_num_match;
		_vala_num_match = _tmp12_;
		if (nb_matches) {
			*nb_matches = _vala_nb_matches;
		}
		if (num_match) {
			*num_match = _vala_num_match;
		}
		return;
	}
	document_invalidate_search_selected_marks (self);
	document_clear_search (self, FALSE);
	_tmp13_ = text;
	_tmp14_ = g_strdup (_tmp13_);
	_g_free0 (self->priv->search_text);
	self->priv->search_text = _tmp14_;
	_tmp15_ = case_sensitive;
	self->priv->search_case_sensitive = _tmp15_;
	_tmp16_ = entire_word;
	self->priv->search_entire_word = _tmp16_;
	start = _tmp17_;
	match_start = _tmp18_;
	match_end = _tmp19_;
	insert = _tmp20_;
	try_match_start = _tmp21_;
	try_match_end = _tmp22_;
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) self, &_tmp23_);
	start = _tmp23_;
	_tmp24_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp25_, _tmp24_);
	insert = _tmp25_;
	_tmp26_ = select;
	next_match_after_cursor_found = !_tmp26_;
	i = (guint) 0;
	while (TRUE) {
		GtkTextIter _tmp27_ = {0};
		GtkTextIter _tmp28_ = {0};
		GtkTextIter _tmp29_ = {0};
		gboolean _tmp30_ = FALSE;
		GtkTextIter _tmp31_ = {0};
		GtkTextIter _tmp32_ = {0};
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_ = FALSE;
		gboolean _tmp37_ = FALSE;
		GtkTextIter _tmp45_ = {0};
		guint _tmp46_ = 0U;
		_tmp27_ = start;
		_tmp30_ = document_iter_forward_search (self, &_tmp27_, NULL, &_tmp28_, &_tmp29_);
		try_match_start = _tmp28_;
		try_match_end = _tmp29_;
		if (!_tmp30_) {
			break;
		}
		_tmp31_ = try_match_start;
		match_start = _tmp31_;
		_tmp32_ = try_match_end;
		match_end = _tmp32_;
		_tmp34_ = next_match_after_cursor_found;
		if (!_tmp34_) {
			GtkTextIter _tmp35_ = {0};
			gint _tmp36_ = 0;
			_tmp35_ = match_end;
			_tmp36_ = gtk_text_iter_compare (&insert, &_tmp35_);
			_tmp33_ = _tmp36_ <= 0;
		} else {
			_tmp33_ = FALSE;
		}
		_tmp37_ = _tmp33_;
		if (_tmp37_) {
			guint _tmp38_ = 0U;
			guint _tmp39_ = 0U;
			GtkTextIter _tmp40_ = {0};
			GtkTextIter _tmp41_ = {0};
			next_match_after_cursor_found = TRUE;
			_tmp38_ = i;
			_vala_num_match = _tmp38_;
			_tmp39_ = _vala_num_match;
			self->priv->search_num_match = _tmp39_;
			_tmp40_ = match_start;
			_tmp41_ = match_end;
			document_move_search_marks (self, &_tmp40_, &_tmp41_, TRUE);
		} else {
			GtkTextTag* _tmp42_ = NULL;
			GtkTextIter _tmp43_ = {0};
			GtkTextIter _tmp44_ = {0};
			_tmp42_ = self->priv->found_tag;
			_tmp43_ = match_start;
			_tmp44_ = match_end;
			gtk_text_buffer_apply_tag ((GtkTextBuffer*) self, _tmp42_, &_tmp43_, &_tmp44_);
		}
		_tmp45_ = match_end;
		start = _tmp45_;
		_tmp46_ = i;
		i = _tmp46_ + 1;
	}
	_tmp48_ = next_match_after_cursor_found;
	if (!_tmp48_) {
		guint _tmp49_ = 0U;
		_tmp49_ = i;
		_tmp47_ = _tmp49_ > ((guint) 0);
	} else {
		_tmp47_ = FALSE;
	}
	_tmp50_ = _tmp47_;
	if (_tmp50_) {
		guint _tmp51_ = 0U;
		guint _tmp52_ = 0U;
		GtkTextIter _tmp53_ = {0};
		GtkTextIter _tmp54_ = {0};
		_tmp51_ = i;
		_vala_num_match = _tmp51_;
		_tmp52_ = _vala_num_match;
		self->priv->search_num_match = _tmp52_;
		_tmp53_ = match_start;
		_tmp54_ = match_end;
		document_move_search_marks (self, &_tmp53_, &_tmp54_, TRUE);
	}
	_tmp55_ = i;
	_vala_nb_matches = _tmp55_;
	_tmp56_ = _vala_nb_matches;
	self->priv->search_nb_matches = _tmp56_;
	_tmp57_ = self->priv->search_nb_matches;
	if (_tmp57_ == ((guint) 0)) {
		document_clear_search_tags (self);
	}
	if (nb_matches) {
		*nb_matches = _vala_nb_matches;
	}
	if (num_match) {
		*num_match = _vala_num_match;
	}
}


void document_select_current_match (Document* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextMark* _tmp0_ = NULL;
	GtkTextIter _tmp1_ = {0};
	GtkTextMark* _tmp2_ = NULL;
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_ = {0};
	GtkTextMark* _tmp5_ = NULL;
	GtkTextIter _tmp6_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_buffer_get_mark ((GtkTextBuffer*) self, "search_selected_start");
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp1_, _tmp0_);
	start = _tmp1_;
	_tmp2_ = gtk_text_buffer_get_mark ((GtkTextBuffer*) self, "search_selected_end");
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp3_, _tmp2_);
	end = _tmp3_;
	_tmp4_ = start;
	gtk_text_buffer_place_cursor ((GtkTextBuffer*) self, &_tmp4_);
	_tmp5_ = gtk_text_buffer_get_mark ((GtkTextBuffer*) self, "selection_bound");
	_tmp6_ = end;
	gtk_text_buffer_move_mark ((GtkTextBuffer*) self, _tmp5_, &_tmp6_);
}


void document_search_forward (Document* self) {
	const gchar* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GtkTextIter start_search = {0};
	GtkTextIter start = {0};
	GtkTextIter match_start = {0};
	GtkTextIter match_end = {0};
	GtkTextMark* _tmp2_ = NULL;
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_ = {0};
	gboolean increment = FALSE;
	GtkTextTag* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GtkTextIter _tmp9_ = {0};
	GtkTextIter _tmp10_ = {0};
	GtkTextIter _tmp11_ = {0};
	gboolean _tmp12_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search_text;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->search_nb_matches;
	if (_tmp1_ == ((guint) 0)) {
		return;
	}
	_tmp2_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp3_, _tmp2_);
	start_search = _tmp3_;
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) self, &_tmp4_);
	start = _tmp4_;
	increment = FALSE;
	_tmp5_ = self->priv->found_tag_selected;
	_tmp6_ = gtk_text_iter_has_tag (&start_search, _tmp5_);
	if (_tmp6_) {
		GtkTextMark* _tmp7_ = NULL;
		GtkTextIter _tmp8_ = {0};
		_tmp7_ = gtk_text_buffer_get_mark ((GtkTextBuffer*) self, "search_selected_end");
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp8_, _tmp7_);
		start_search = _tmp8_;
		increment = TRUE;
	}
	document_replace_found_tag_selected (self);
	_tmp9_ = start_search;
	_tmp12_ = document_iter_forward_search (self, &_tmp9_, NULL, &_tmp10_, &_tmp11_);
	match_start = _tmp10_;
	match_end = _tmp11_;
	if (_tmp12_) {
		GtkTextIter _tmp13_ = {0};
		GtkTextIter _tmp14_ = {0};
		gboolean _tmp15_ = FALSE;
		_tmp13_ = match_start;
		_tmp14_ = match_end;
		document_move_search_marks (self, &_tmp13_, &_tmp14_, TRUE);
		_tmp15_ = increment;
		if (_tmp15_) {
			guint _tmp16_ = 0U;
			guint _tmp17_ = 0U;
			guint _tmp18_ = 0U;
			_tmp16_ = self->priv->search_num_match;
			self->priv->search_num_match = _tmp16_ + 1;
			_tmp17_ = self->priv->search_nb_matches;
			_tmp18_ = self->priv->search_num_match;
			g_signal_emit_by_name (self, "search-info-updated", TRUE, _tmp17_, _tmp18_);
			return;
		}
	} else {
		GtkTextIter _tmp19_ = {0};
		GtkTextIter _tmp20_ = {0};
		GtkTextIter _tmp21_ = {0};
		gboolean _tmp22_ = FALSE;
		_tmp19_ = start;
		_tmp22_ = document_iter_forward_search (self, &_tmp19_, NULL, &_tmp20_, &_tmp21_);
		match_start = _tmp20_;
		match_end = _tmp21_;
		if (_tmp22_) {
			GtkTextIter _tmp23_ = {0};
			GtkTextIter _tmp24_ = {0};
			guint _tmp25_ = 0U;
			guint _tmp26_ = 0U;
			_tmp23_ = match_start;
			_tmp24_ = match_end;
			document_move_search_marks (self, &_tmp23_, &_tmp24_, TRUE);
			self->priv->search_num_match = (guint) 1;
			_tmp25_ = self->priv->search_nb_matches;
			_tmp26_ = self->priv->search_num_match;
			g_signal_emit_by_name (self, "search-info-updated", TRUE, _tmp25_, _tmp26_);
			return;
		}
	}
	document_find_num_match (self);
}


void document_search_backward (Document* self) {
	const gchar* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GtkTextIter start_search = {0};
	GtkTextIter end = {0};
	GtkTextIter match_start = {0};
	GtkTextIter match_end = {0};
	GtkTextMark* _tmp2_ = NULL;
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_ = {0};
	gboolean decrement = FALSE;
	gboolean move_cursor = FALSE;
	GtkTextIter start_prev = {0};
	GtkTextIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
	GtkTextTag* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp11_ = FALSE;
	GtkTextIter _tmp21_ = {0};
	GtkTextIter _tmp22_ = {0};
	GtkTextIter _tmp23_ = {0};
	gboolean _tmp24_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search_text;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->search_nb_matches;
	if (_tmp1_ == ((guint) 0)) {
		return;
	}
	_tmp2_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp3_, _tmp2_);
	start_search = _tmp3_;
	gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self, &_tmp4_);
	end = _tmp4_;
	decrement = FALSE;
	move_cursor = TRUE;
	_tmp5_ = start_search;
	start_prev = _tmp5_;
	gtk_text_iter_backward_char (&start_prev);
	_tmp7_ = self->priv->found_tag_selected;
	_tmp8_ = gtk_text_iter_has_tag (&start_search, _tmp7_);
	if (_tmp8_) {
		_tmp6_ = TRUE;
	} else {
		GtkTextTag* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		_tmp9_ = self->priv->found_tag_selected;
		_tmp10_ = gtk_text_iter_has_tag (&start_prev, _tmp9_);
		_tmp6_ = _tmp10_;
	}
	_tmp11_ = _tmp6_;
	if (_tmp11_) {
		GtkTextMark* _tmp12_ = NULL;
		GtkTextIter _tmp13_ = {0};
		_tmp12_ = gtk_text_buffer_get_mark ((GtkTextBuffer*) self, "search_selected_start");
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp13_, _tmp12_);
		start_search = _tmp13_;
		decrement = TRUE;
	} else {
		GtkTextTag* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		_tmp14_ = self->priv->found_tag;
		_tmp15_ = gtk_text_iter_has_tag (&start_search, _tmp14_);
		if (_tmp15_) {
			const gchar* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			move_cursor = FALSE;
			_tmp16_ = self->priv->search_text;
			_tmp17_ = strlen (_tmp16_);
			_tmp18_ = _tmp17_;
			gtk_text_iter_forward_chars (&start_search, (gint) _tmp18_);
		} else {
			GtkTextTag* _tmp19_ = NULL;
			gboolean _tmp20_ = FALSE;
			_tmp19_ = self->priv->found_tag;
			_tmp20_ = gtk_text_iter_has_tag (&start_prev, _tmp19_);
			if (_tmp20_) {
				move_cursor = FALSE;
			}
		}
	}
	document_replace_found_tag_selected (self);
	_tmp21_ = start_search;
	_tmp24_ = document_iter_backward_search (self, &_tmp21_, NULL, &_tmp22_, &_tmp23_);
	match_start = _tmp22_;
	match_end = _tmp23_;
	if (_tmp24_) {
		GtkTextIter _tmp25_ = {0};
		GtkTextIter _tmp26_ = {0};
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		_tmp25_ = match_start;
		_tmp26_ = match_end;
		_tmp27_ = move_cursor;
		document_move_search_marks (self, &_tmp25_, &_tmp26_, _tmp27_);
		_tmp28_ = decrement;
		if (_tmp28_) {
			guint _tmp29_ = 0U;
			guint _tmp30_ = 0U;
			guint _tmp31_ = 0U;
			_tmp29_ = self->priv->search_num_match;
			self->priv->search_num_match = _tmp29_ - 1;
			_tmp30_ = self->priv->search_nb_matches;
			_tmp31_ = self->priv->search_num_match;
			g_signal_emit_by_name (self, "search-info-updated", TRUE, _tmp30_, _tmp31_);
			return;
		}
	} else {
		GtkTextIter _tmp32_ = {0};
		GtkTextIter _tmp33_ = {0};
		GtkTextIter _tmp34_ = {0};
		gboolean _tmp35_ = FALSE;
		_tmp32_ = end;
		_tmp35_ = document_iter_backward_search (self, &_tmp32_, NULL, &_tmp33_, &_tmp34_);
		match_start = _tmp33_;
		match_end = _tmp34_;
		if (_tmp35_) {
			GtkTextIter _tmp36_ = {0};
			GtkTextIter _tmp37_ = {0};
			guint _tmp38_ = 0U;
			guint _tmp39_ = 0U;
			guint _tmp40_ = 0U;
			_tmp36_ = match_start;
			_tmp37_ = match_end;
			document_move_search_marks (self, &_tmp36_, &_tmp37_, TRUE);
			_tmp38_ = self->priv->search_nb_matches;
			self->priv->search_num_match = _tmp38_;
			_tmp39_ = self->priv->search_nb_matches;
			_tmp40_ = self->priv->search_num_match;
			g_signal_emit_by_name (self, "search-info-updated", TRUE, _tmp39_, _tmp40_);
			return;
		}
	}
	document_find_num_match (self);
}


static gboolean document_iter_forward_search (Document* self, GtkTextIter* start, GtkTextIter* end, GtkTextIter* match_start, GtkTextIter* match_end) {
	GtkTextIter _vala_match_start = {0};
	GtkTextIter _vala_match_end = {0};
	gboolean result = FALSE;
	gboolean found = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (start != NULL, FALSE);
	memset (&_vala_match_start, 0, sizeof (GtkTextIter));
	memset (&_vala_match_end, 0, sizeof (GtkTextIter));
	found = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		const gchar* _tmp1_ = NULL;
		GtkTextSearchFlags _tmp2_ = 0;
		GtkTextIter* _tmp3_ = NULL;
		GtkTextIter _tmp4_ = {0};
		GtkTextIter _tmp5_ = {0};
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp10_ = FALSE;
		_tmp0_ = found;
		if (!(!_tmp0_)) {
			break;
		}
		_tmp1_ = self->priv->search_text;
		_tmp2_ = document_get_search_flags (self);
		_tmp3_ = end;
		_tmp6_ = gtk_text_iter_forward_search (start, _tmp1_, _tmp2_, &_tmp4_, &_tmp5_, _tmp3_);
		_vala_match_start = _tmp4_;
		_vala_match_end = _tmp5_;
		found = _tmp6_;
		_tmp8_ = found;
		if (_tmp8_) {
			gboolean _tmp9_ = FALSE;
			_tmp9_ = self->priv->search_entire_word;
			_tmp7_ = _tmp9_;
		} else {
			_tmp7_ = FALSE;
		}
		_tmp10_ = _tmp7_;
		if (_tmp10_) {
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_ = FALSE;
			_tmp12_ = gtk_text_iter_starts_word (&_vala_match_start);
			if (_tmp12_) {
				gboolean _tmp13_ = FALSE;
				_tmp13_ = gtk_text_iter_ends_word (&_vala_match_end);
				_tmp11_ = _tmp13_;
			} else {
				_tmp11_ = FALSE;
			}
			_tmp14_ = _tmp11_;
			found = _tmp14_;
			_tmp15_ = found;
			if (!_tmp15_) {
				GtkTextIter _tmp16_ = {0};
				_tmp16_ = _vala_match_end;
				*start = _tmp16_;
			}
		} else {
			break;
		}
	}
	result = found;
	if (match_start) {
		*match_start = _vala_match_start;
	}
	if (match_end) {
		*match_end = _vala_match_end;
	}
	return result;
}


static gboolean document_iter_backward_search (Document* self, GtkTextIter* start, GtkTextIter* end, GtkTextIter* match_start, GtkTextIter* match_end) {
	GtkTextIter _vala_match_start = {0};
	GtkTextIter _vala_match_end = {0};
	gboolean result = FALSE;
	gboolean found = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (start != NULL, FALSE);
	memset (&_vala_match_start, 0, sizeof (GtkTextIter));
	memset (&_vala_match_end, 0, sizeof (GtkTextIter));
	found = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		const gchar* _tmp1_ = NULL;
		GtkTextSearchFlags _tmp2_ = 0;
		GtkTextIter* _tmp3_ = NULL;
		GtkTextIter _tmp4_ = {0};
		GtkTextIter _tmp5_ = {0};
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp10_ = FALSE;
		_tmp0_ = found;
		if (!(!_tmp0_)) {
			break;
		}
		_tmp1_ = self->priv->search_text;
		_tmp2_ = document_get_search_flags (self);
		_tmp3_ = end;
		_tmp6_ = gtk_text_iter_backward_search (start, _tmp1_, _tmp2_, &_tmp4_, &_tmp5_, _tmp3_);
		_vala_match_start = _tmp4_;
		_vala_match_end = _tmp5_;
		found = _tmp6_;
		_tmp8_ = found;
		if (_tmp8_) {
			gboolean _tmp9_ = FALSE;
			_tmp9_ = self->priv->search_entire_word;
			_tmp7_ = _tmp9_;
		} else {
			_tmp7_ = FALSE;
		}
		_tmp10_ = _tmp7_;
		if (_tmp10_) {
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_ = FALSE;
			_tmp12_ = gtk_text_iter_starts_word (&_vala_match_start);
			if (_tmp12_) {
				gboolean _tmp13_ = FALSE;
				_tmp13_ = gtk_text_iter_ends_word (&_vala_match_end);
				_tmp11_ = _tmp13_;
			} else {
				_tmp11_ = FALSE;
			}
			_tmp14_ = _tmp11_;
			found = _tmp14_;
			_tmp15_ = found;
			if (!_tmp15_) {
				GtkTextIter _tmp16_ = {0};
				_tmp16_ = _vala_match_start;
				*start = _tmp16_;
			}
		} else {
			break;
		}
	}
	result = found;
	if (match_start) {
		*match_start = _vala_match_start;
	}
	if (match_end) {
		*match_end = _vala_match_end;
	}
	return result;
}


void document_clear_search (Document* self, gboolean disconnect_signals) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	document_clear_search_tags (self);
	_g_free0 (self->priv->search_text);
	self->priv->search_text = NULL;
	_tmp0_ = disconnect_signals;
	if (_tmp0_) {
		guint _tmp1_ = 0U;
		guint _tmp2_ = 0U;
		guint _tmp3_ = 0U;
		guint _tmp4_ = 0U;
		guint _tmp5_ = 0U;
		g_signal_parse_name ("cursor-moved", TYPE_DOCUMENT, &_tmp1_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _document_search_cursor_moved_handler_document_cursor_moved, self);
		g_signal_parse_name ("delete-range", GTK_TYPE_TEXT_BUFFER, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkTextBuffer*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _document_search_delete_range_before_handler_gtk_text_buffer_delete_range, self);
		g_signal_parse_name ("delete-range", GTK_TYPE_TEXT_BUFFER, &_tmp3_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkTextBuffer*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _document_search_delete_range_after_handler_gtk_text_buffer_delete_range, self);
		g_signal_parse_name ("insert-text", GTK_TYPE_TEXT_BUFFER, &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkTextBuffer*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _document_search_insert_text_before_handler_gtk_text_buffer_insert_text, self);
		g_signal_parse_name ("insert-text", GTK_TYPE_TEXT_BUFFER, &_tmp5_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkTextBuffer*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _document_search_insert_text_after_handler_gtk_text_buffer_insert_text, self);
	}
}


static void document_clear_search_tags (Document* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	GtkTextTag* _tmp2_ = NULL;
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_ = {0};
	GtkTextTag* _tmp5_ = NULL;
	GtkTextIter _tmp6_ = {0};
	GtkTextIter _tmp7_ = {0};
	g_return_if_fail (self != NULL);
	document_invalidate_search_selected_marks (self);
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) self, &_tmp0_, &_tmp1_);
	start = _tmp0_;
	end = _tmp1_;
	_tmp2_ = self->priv->found_tag;
	_tmp3_ = start;
	_tmp4_ = end;
	gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, _tmp2_, &_tmp3_, &_tmp4_);
	_tmp5_ = self->priv->found_tag_selected;
	_tmp6_ = start;
	_tmp7_ = end;
	gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, _tmp5_, &_tmp6_, &_tmp7_);
}


static void document_search_cursor_moved_handler (Document* self) {
	GtkTextIter insert = {0};
	GtkTextIter insert_previous = {0};
	GtkTextMark* _tmp0_ = NULL;
	GtkTextIter _tmp1_ = {0};
	GtkTextIter _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	GtkTextTag* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	GtkTextTag* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp14_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp1_, _tmp0_);
	insert = _tmp1_;
	_tmp2_ = insert;
	insert_previous = _tmp2_;
	gtk_text_iter_backward_char (&insert_previous);
	_tmp4_ = self->priv->found_tag_selected;
	_tmp5_ = gtk_text_iter_has_tag (&insert, _tmp4_);
	if (_tmp5_) {
		_tmp3_ = TRUE;
	} else {
		GtkTextTag* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp6_ = self->priv->found_tag_selected;
		_tmp7_ = gtk_text_iter_has_tag (&insert_previous, _tmp6_);
		_tmp3_ = _tmp7_;
	}
	_tmp8_ = _tmp3_;
	if (_tmp8_) {
		return;
	}
	document_replace_found_tag_selected (self);
	document_invalidate_search_selected_marks (self);
	_tmp10_ = self->priv->found_tag;
	_tmp11_ = gtk_text_iter_has_tag (&insert, _tmp10_);
	if (_tmp11_) {
		_tmp9_ = TRUE;
	} else {
		GtkTextTag* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		_tmp12_ = self->priv->found_tag;
		_tmp13_ = gtk_text_iter_has_tag (&insert_previous, _tmp12_);
		_tmp9_ = _tmp13_;
	}
	_tmp14_ = _tmp9_;
	if (_tmp14_) {
		document_search_backward (self);
	} else {
		guint _tmp15_ = 0U;
		_tmp15_ = self->priv->search_nb_matches;
		g_signal_emit_by_name (self, "search-info-updated", FALSE, _tmp15_, (guint) 0);
	}
}


static void document_search_delete_range_before_handler (Document* self, GtkTextIter* start, GtkTextIter* end) {
	GtkTextIter start_search = {0};
	GtkTextIter stop_search = {0};
	GtkTextIter match_start = {0};
	GtkTextIter match_end = {0};
	GtkTextIter _tmp0_ = {0};
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GtkTextIter _tmp4_ = {0};
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (start != NULL);
	g_return_if_fail (end != NULL);
	_tmp0_ = *start;
	start_search = _tmp0_;
	_tmp1_ = self->priv->search_text;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_text_iter_backward_chars (&start_search, ((gint) _tmp3_) - 1);
	_tmp4_ = *end;
	stop_search = _tmp4_;
	_tmp5_ = self->priv->search_text;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	gtk_text_iter_forward_chars (&stop_search, ((gint) _tmp7_) - 1);
	document_replace_found_tag_selected (self);
	document_invalidate_search_selected_marks (self);
	while (TRUE) {
		GtkTextIter _tmp8_ = {0};
		GtkTextIter _tmp9_ = {0};
		GtkTextIter _tmp10_ = {0};
		GtkTextIter _tmp11_ = {0};
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		GtkTextIter _tmp14_ = {0};
		gint _tmp15_ = 0;
		gboolean _tmp18_ = FALSE;
		guint _tmp25_ = 0U;
		GtkTextIter _tmp26_ = {0};
		_tmp8_ = start_search;
		_tmp9_ = stop_search;
		_tmp12_ = document_iter_forward_search (self, &_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_);
		match_start = _tmp10_;
		match_end = _tmp11_;
		if (!_tmp12_) {
			break;
		}
		_tmp14_ = *start;
		_tmp15_ = gtk_text_iter_compare (&match_start, &_tmp14_);
		if (_tmp15_ < 0) {
			_tmp13_ = TRUE;
		} else {
			GtkTextIter _tmp16_ = {0};
			gint _tmp17_ = 0;
			_tmp16_ = *end;
			_tmp17_ = gtk_text_iter_compare (&match_end, &_tmp16_);
			_tmp13_ = _tmp17_ > 0;
		}
		_tmp18_ = _tmp13_;
		if (_tmp18_) {
			GtkTextTag* _tmp19_ = NULL;
			GtkTextIter _tmp20_ = {0};
			GtkTextIter _tmp21_ = {0};
			GtkTextTag* _tmp22_ = NULL;
			GtkTextIter _tmp23_ = {0};
			GtkTextIter _tmp24_ = {0};
			_tmp19_ = self->priv->found_tag;
			_tmp20_ = match_start;
			_tmp21_ = match_end;
			gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, _tmp19_, &_tmp20_, &_tmp21_);
			_tmp22_ = self->priv->found_tag_selected;
			_tmp23_ = match_start;
			_tmp24_ = match_end;
			gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, _tmp22_, &_tmp23_, &_tmp24_);
		}
		_tmp25_ = self->priv->search_nb_matches;
		self->priv->search_nb_matches = _tmp25_ - 1;
		_tmp26_ = match_end;
		start_search = _tmp26_;
	}
}


static void document_search_delete_range_after_handler (Document* self, GtkTextIter* location) {
	GtkTextIter start_search = {0};
	GtkTextIter stop_search = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	GtkTextIter _tmp8_ = {0};
	GtkTextIter _tmp9_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_tmp0_ = *location;
	stop_search = _tmp0_;
	_tmp1_ = stop_search;
	start_search = _tmp1_;
	_tmp2_ = self->priv->search_text;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	gtk_text_iter_backward_chars (&start_search, ((gint) _tmp4_) - 1);
	_tmp5_ = self->priv->search_text;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	gtk_text_iter_forward_chars (&stop_search, ((gint) _tmp7_) - 1);
	_tmp8_ = start_search;
	_tmp9_ = stop_search;
	document_search_matches_between (self, &_tmp8_, &_tmp9_);
}


static void document_search_insert_text_before_handler (Document* self, GtkTextIter* location) {
	gboolean _tmp0_ = FALSE;
	GtkTextTag* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_tmp1_ = self->priv->found_tag;
	_tmp2_ = gtk_text_iter_has_tag (location, _tmp1_);
	if (_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		GtkTextTag* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = self->priv->found_tag_selected;
		_tmp4_ = gtk_text_iter_has_tag (location, _tmp3_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		GtkTextIter start_search = {0};
		GtkTextIter match_start = {0};
		GtkTextIter match_end = {0};
		GtkTextIter _tmp6_ = {0};
		const gchar* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		GtkTextIter _tmp10_ = {0};
		GtkTextIter _tmp11_ = {0};
		GtkTextIter _tmp12_ = {0};
		gboolean _tmp13_ = FALSE;
		document_replace_found_tag_selected (self);
		document_invalidate_search_selected_marks (self);
		_tmp6_ = *location;
		start_search = _tmp6_;
		_tmp7_ = self->priv->search_text;
		_tmp8_ = strlen (_tmp7_);
		_tmp9_ = _tmp8_;
		gtk_text_iter_forward_chars (&start_search, ((gint) _tmp9_) - 1);
		_tmp10_ = start_search;
		_tmp13_ = document_iter_backward_search (self, &_tmp10_, NULL, &_tmp11_, &_tmp12_);
		match_start = _tmp11_;
		match_end = _tmp12_;
		if (_tmp13_) {
			GtkTextIter _tmp14_ = {0};
			gint _tmp15_ = 0;
			_tmp14_ = match_end;
			_tmp15_ = gtk_text_iter_compare (location, &_tmp14_);
			if (_tmp15_ < 0) {
				GtkTextTag* _tmp16_ = NULL;
				GtkTextIter _tmp17_ = {0};
				GtkTextIter _tmp18_ = {0};
				GtkTextTag* _tmp19_ = NULL;
				GtkTextIter _tmp20_ = {0};
				GtkTextIter _tmp21_ = {0};
				guint _tmp22_ = 0U;
				_tmp16_ = self->priv->found_tag;
				_tmp17_ = match_start;
				_tmp18_ = match_end;
				gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, _tmp16_, &_tmp17_, &_tmp18_);
				_tmp19_ = self->priv->found_tag_selected;
				_tmp20_ = match_start;
				_tmp21_ = match_end;
				gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, _tmp19_, &_tmp20_, &_tmp21_);
				_tmp22_ = self->priv->search_nb_matches;
				self->priv->search_nb_matches = _tmp22_ - 1;
			}
		}
	}
}


static void document_search_insert_text_after_handler (Document* self, GtkTextIter* location, const gchar* text, gint len) {
	GtkTextIter left_text = {0};
	GtkTextIter _tmp0_ = {0};
	gint _tmp1_ = 0;
	GtkTextTag* _tmp2_ = NULL;
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_ = {0};
	GtkTextTag* _tmp5_ = NULL;
	GtkTextIter _tmp6_ = {0};
	GtkTextIter _tmp7_ = {0};
	GtkTextIter start_search = {0};
	GtkTextIter stop_search = {0};
	GtkTextIter _tmp8_ = {0};
	GtkTextIter _tmp9_ = {0};
	gint _tmp10_ = 0;
	const gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	const gchar* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	GtkTextIter _tmp17_ = {0};
	GtkTextIter _tmp18_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = *location;
	left_text = _tmp0_;
	_tmp1_ = len;
	gtk_text_iter_backward_chars (&left_text, _tmp1_);
	_tmp2_ = self->priv->found_tag;
	_tmp3_ = left_text;
	_tmp4_ = *location;
	gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, _tmp2_, &_tmp3_, &_tmp4_);
	_tmp5_ = self->priv->found_tag_selected;
	_tmp6_ = left_text;
	_tmp7_ = *location;
	gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, _tmp5_, &_tmp6_, &_tmp7_);
	_tmp8_ = *location;
	stop_search = _tmp8_;
	_tmp9_ = stop_search;
	start_search = _tmp9_;
	_tmp10_ = len;
	_tmp11_ = self->priv->search_text;
	_tmp12_ = strlen (_tmp11_);
	_tmp13_ = _tmp12_;
	gtk_text_iter_backward_chars (&start_search, (_tmp10_ + ((gint) _tmp13_)) - 1);
	_tmp14_ = self->priv->search_text;
	_tmp15_ = strlen (_tmp14_);
	_tmp16_ = _tmp15_;
	gtk_text_iter_forward_chars (&stop_search, ((gint) _tmp16_) - 1);
	_tmp17_ = start_search;
	_tmp18_ = stop_search;
	document_search_matches_between (self, &_tmp17_, &_tmp18_);
}


static void document_search_matches_between (Document* self, GtkTextIter* start_search, GtkTextIter* stop_search) {
	GtkTextIter match_start = {0};
	GtkTextIter match_end = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (start_search != NULL);
	g_return_if_fail (stop_search != NULL);
	while (TRUE) {
		GtkTextIter _tmp0_ = {0};
		GtkTextIter _tmp1_ = {0};
		GtkTextIter _tmp2_ = {0};
		GtkTextIter _tmp3_ = {0};
		gboolean _tmp4_ = FALSE;
		GtkTextTag* _tmp5_ = NULL;
		GtkTextIter _tmp6_ = {0};
		GtkTextIter _tmp7_ = {0};
		guint _tmp8_ = 0U;
		GtkTextIter _tmp9_ = {0};
		_tmp0_ = *start_search;
		_tmp1_ = *stop_search;
		_tmp4_ = document_iter_forward_search (self, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
		match_start = _tmp2_;
		match_end = _tmp3_;
		if (!_tmp4_) {
			break;
		}
		_tmp5_ = self->priv->found_tag;
		_tmp6_ = match_start;
		_tmp7_ = match_end;
		gtk_text_buffer_apply_tag ((GtkTextBuffer*) self, _tmp5_, &_tmp6_, &_tmp7_);
		_tmp8_ = self->priv->search_nb_matches;
		self->priv->search_nb_matches = _tmp8_ + 1;
		_tmp9_ = match_end;
		*start_search = _tmp9_;
	}
	document_replace_found_tag_selected (self);
	document_invalidate_search_selected_marks (self);
	document_search_cursor_moved_handler (self);
}


static GtkTextSearchFlags document_get_search_flags (Document* self) {
	GtkTextSearchFlags result = 0;
	GtkTextSearchFlags flags = 0;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	flags = GTK_TEXT_SEARCH_TEXT_ONLY | GTK_TEXT_SEARCH_VISIBLE_ONLY;
	_tmp0_ = self->priv->search_case_sensitive;
	if (!_tmp0_) {
		GtkTextSearchFlags _tmp1_ = 0;
		_tmp1_ = flags;
		flags = _tmp1_ | GTK_TEXT_SEARCH_CASE_INSENSITIVE;
	}
	result = flags;
	return result;
}


static void document_move_search_marks (Document* self, GtkTextIter* start, GtkTextIter* end, gboolean move_cursor) {
	GtkTextTag* _tmp0_ = NULL;
	GtkTextIter _tmp1_ = {0};
	GtkTextIter _tmp2_ = {0};
	GtkTextTag* _tmp3_ = NULL;
	GtkTextIter _tmp4_ = {0};
	GtkTextIter _tmp5_ = {0};
	GtkTextIter _tmp6_ = {0};
	GtkTextIter _tmp7_ = {0};
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (start != NULL);
	g_return_if_fail (end != NULL);
	_tmp0_ = self->priv->found_tag;
	_tmp1_ = *start;
	_tmp2_ = *end;
	gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, _tmp0_, &_tmp1_, &_tmp2_);
	_tmp3_ = self->priv->found_tag_selected;
	_tmp4_ = *start;
	_tmp5_ = *end;
	gtk_text_buffer_apply_tag ((GtkTextBuffer*) self, _tmp3_, &_tmp4_, &_tmp5_);
	_tmp6_ = *start;
	gtk_text_buffer_move_mark_by_name ((GtkTextBuffer*) self, "search_selected_start", &_tmp6_);
	_tmp7_ = *end;
	gtk_text_buffer_move_mark_by_name ((GtkTextBuffer*) self, "search_selected_end", &_tmp7_);
	_tmp8_ = move_cursor;
	if (_tmp8_) {
		GtkTextIter _tmp9_ = {0};
		DocumentTab* _tmp10_ = NULL;
		DocumentView* _tmp11_ = NULL;
		DocumentView* _tmp12_ = NULL;
		_tmp9_ = *start;
		gtk_text_buffer_place_cursor ((GtkTextBuffer*) self, &_tmp9_);
		_tmp10_ = self->tab;
		_tmp11_ = document_tab_get_view (_tmp10_);
		_tmp12_ = _tmp11_;
		document_view_scroll_to_cursor (_tmp12_, 0.25);
	}
}


static void document_replace_found_tag_selected (Document* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextMark* _tmp0_ = NULL;
	GtkTextIter _tmp1_ = {0};
	GtkTextMark* _tmp2_ = NULL;
	GtkTextIter _tmp3_ = {0};
	GtkTextTag* _tmp4_ = NULL;
	GtkTextIter _tmp5_ = {0};
	GtkTextIter _tmp6_ = {0};
	GtkTextTag* _tmp7_ = NULL;
	GtkTextIter _tmp8_ = {0};
	GtkTextIter _tmp9_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_buffer_get_mark ((GtkTextBuffer*) self, "search_selected_start");
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp1_, _tmp0_);
	start = _tmp1_;
	_tmp2_ = gtk_text_buffer_get_mark ((GtkTextBuffer*) self, "search_selected_end");
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp3_, _tmp2_);
	end = _tmp3_;
	_tmp4_ = self->priv->found_tag_selected;
	_tmp5_ = start;
	_tmp6_ = end;
	gtk_text_buffer_remove_tag ((GtkTextBuffer*) self, _tmp4_, &_tmp5_, &_tmp6_);
	_tmp7_ = self->priv->found_tag;
	_tmp8_ = start;
	_tmp9_ = end;
	gtk_text_buffer_apply_tag ((GtkTextBuffer*) self, _tmp7_, &_tmp8_, &_tmp9_);
}


static void document_find_num_match (Document* self) {
	GtkTextIter start = {0};
	GtkTextIter stop = {0};
	GtkTextIter match_end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextMark* _tmp1_ = NULL;
	GtkTextIter _tmp2_ = {0};
	guint i = 0U;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
	guint _tmp11_ = 0U;
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) self, &_tmp0_);
	start = _tmp0_;
	_tmp1_ = gtk_text_buffer_get_mark ((GtkTextBuffer*) self, "search_selected_start");
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp2_, _tmp1_);
	stop = _tmp2_;
	i = (guint) 0;
	while (TRUE) {
		GtkTextIter _tmp3_ = {0};
		GtkTextIter _tmp4_ = {0};
		GtkTextIter _tmp5_ = {0};
		gboolean _tmp6_ = FALSE;
		guint _tmp7_ = 0U;
		GtkTextIter _tmp8_ = {0};
		_tmp3_ = start;
		_tmp4_ = stop;
		_tmp6_ = document_iter_forward_search (self, &_tmp3_, &_tmp4_, NULL, &_tmp5_);
		match_end = _tmp5_;
		if (!_tmp6_) {
			break;
		}
		_tmp7_ = i;
		i = _tmp7_ + 1;
		_tmp8_ = match_end;
		start = _tmp8_;
	}
	_tmp9_ = i;
	self->priv->search_num_match = _tmp9_ + 1;
	_tmp10_ = self->priv->search_nb_matches;
	_tmp11_ = self->priv->search_num_match;
	g_signal_emit_by_name (self, "search-info-updated", TRUE, _tmp10_, _tmp11_);
}


static void document_invalidate_search_selected_marks (Document* self) {
	GtkTextIter iter = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	GtkTextIter _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) self, &_tmp0_);
	iter = _tmp0_;
	_tmp1_ = iter;
	gtk_text_buffer_move_mark_by_name ((GtkTextBuffer*) self, "search_selected_start", &_tmp1_);
	_tmp2_ = iter;
	gtk_text_buffer_move_mark_by_name ((GtkTextBuffer*) self, "search_selected_end", &_tmp2_);
}


static void document_set_search_match_colors (Document* self, GtkTextTag* text_tag) {
	GtkSourceStyleScheme* style_scheme = NULL;
	GtkSourceStyleScheme* _tmp0_ = NULL;
	GtkSourceStyleScheme* _tmp1_ = NULL;
	GtkSourceStyle* style = NULL;
	GtkSourceStyleScheme* _tmp2_ = NULL;
	gboolean _tmp6_ = FALSE;
	GtkSourceStyleScheme* _tmp7_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp11_ = FALSE;
	GtkSourceStyle* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp26_ = FALSE;
	GtkSourceStyle* _tmp27_ = NULL;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp41_ = FALSE;
	GtkSourceStyle* _tmp42_ = NULL;
	gboolean _tmp43_ = FALSE;
	gboolean _tmp44_ = FALSE;
	gboolean _tmp49_ = FALSE;
	PangoWeight _tmp56_ = 0;
	gboolean _tmp57_ = FALSE;
	GtkSourceStyle* _tmp58_ = NULL;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp64_ = FALSE;
	GtkTextTag* _tmp65_ = NULL;
	PangoWeight _tmp66_ = 0;
	PangoStyle _tmp67_ = 0;
	gboolean _tmp68_ = FALSE;
	GtkSourceStyle* _tmp69_ = NULL;
	gboolean _tmp70_ = FALSE;
	gboolean _tmp71_ = FALSE;
	gboolean _tmp75_ = FALSE;
	GtkTextTag* _tmp76_ = NULL;
	PangoStyle _tmp77_ = 0;
	PangoUnderline _tmp78_ = 0;
	gboolean _tmp79_ = FALSE;
	GtkSourceStyle* _tmp80_ = NULL;
	gboolean _tmp81_ = FALSE;
	gboolean _tmp82_ = FALSE;
	gboolean _tmp86_ = FALSE;
	GtkTextTag* _tmp87_ = NULL;
	PangoUnderline _tmp88_ = 0;
	gboolean _tmp89_ = FALSE;
	GtkSourceStyle* _tmp90_ = NULL;
	gboolean _tmp91_ = FALSE;
	gboolean _tmp92_ = FALSE;
	GtkTextTag* _tmp96_ = NULL;
	gboolean _tmp97_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text_tag != NULL);
	_tmp0_ = gtk_source_buffer_get_style_scheme ((GtkSourceBuffer*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	style_scheme = _tmp1_;
	style = NULL;
	_tmp2_ = style_scheme;
	if (_tmp2_ != NULL) {
		GtkSourceStyleScheme* _tmp3_ = NULL;
		GtkSourceStyle* _tmp4_ = NULL;
		GtkSourceStyle* _tmp5_ = NULL;
		_tmp3_ = style_scheme;
		_tmp4_ = gtk_source_style_scheme_get_style (_tmp3_, "search-match");
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_g_object_unref0 (style);
		style = _tmp5_;
	}
	_tmp7_ = style_scheme;
	if (_tmp7_ == NULL) {
		_tmp6_ = TRUE;
	} else {
		GtkSourceStyle* _tmp8_ = NULL;
		_tmp8_ = style;
		_tmp6_ = _tmp8_ == NULL;
	}
	_tmp9_ = _tmp6_;
	if (_tmp9_) {
		GtkTextTag* _tmp10_ = NULL;
		_tmp10_ = text_tag;
		g_object_set (_tmp10_, "background", "#FFFF78", NULL);
		_g_object_unref0 (style);
		_g_object_unref0 (style_scheme);
		return;
	}
	_tmp12_ = style;
	g_object_get (_tmp12_, "foreground-set", &_tmp13_, NULL);
	_tmp14_ = _tmp13_;
	if (_tmp14_) {
		GtkSourceStyle* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		_tmp15_ = style;
		g_object_get (_tmp15_, "foreground", &_tmp16_, NULL);
		_tmp17_ = _tmp16_;
		_tmp18_ = _tmp17_;
		_tmp11_ = _tmp18_ != NULL;
		_g_free0 (_tmp18_);
	} else {
		_tmp11_ = FALSE;
	}
	_tmp19_ = _tmp11_;
	if (_tmp19_) {
		GtkTextTag* _tmp20_ = NULL;
		GtkSourceStyle* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		_tmp20_ = text_tag;
		_tmp21_ = style;
		g_object_get (_tmp21_, "foreground", &_tmp22_, NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = _tmp23_;
		g_object_set (_tmp20_, "foreground", _tmp24_, NULL);
		_g_free0 (_tmp24_);
	} else {
		GtkTextTag* _tmp25_ = NULL;
		_tmp25_ = text_tag;
		g_object_set (_tmp25_, "foreground", NULL, NULL);
	}
	_tmp27_ = style;
	g_object_get (_tmp27_, "background-set", &_tmp28_, NULL);
	_tmp29_ = _tmp28_;
	if (_tmp29_) {
		GtkSourceStyle* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		_tmp30_ = style;
		g_object_get (_tmp30_, "background", &_tmp31_, NULL);
		_tmp32_ = _tmp31_;
		_tmp33_ = _tmp32_;
		_tmp26_ = _tmp33_ != NULL;
		_g_free0 (_tmp33_);
	} else {
		_tmp26_ = FALSE;
	}
	_tmp34_ = _tmp26_;
	if (_tmp34_) {
		GtkTextTag* _tmp35_ = NULL;
		GtkSourceStyle* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		_tmp35_ = text_tag;
		_tmp36_ = style;
		g_object_get (_tmp36_, "background", &_tmp37_, NULL);
		_tmp38_ = _tmp37_;
		_tmp39_ = _tmp38_;
		g_object_set (_tmp35_, "background", _tmp39_, NULL);
		_g_free0 (_tmp39_);
	} else {
		GtkTextTag* _tmp40_ = NULL;
		_tmp40_ = text_tag;
		g_object_set (_tmp40_, "background", NULL, NULL);
	}
	_tmp42_ = style;
	g_object_get (_tmp42_, "line-background-set", &_tmp43_, NULL);
	_tmp44_ = _tmp43_;
	if (_tmp44_) {
		GtkSourceStyle* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		gchar* _tmp47_ = NULL;
		gchar* _tmp48_ = NULL;
		_tmp45_ = style;
		g_object_get (_tmp45_, "line-background", &_tmp46_, NULL);
		_tmp47_ = _tmp46_;
		_tmp48_ = _tmp47_;
		_tmp41_ = _tmp48_ != NULL;
		_g_free0 (_tmp48_);
	} else {
		_tmp41_ = FALSE;
	}
	_tmp49_ = _tmp41_;
	if (_tmp49_) {
		GtkTextTag* _tmp50_ = NULL;
		GtkSourceStyle* _tmp51_ = NULL;
		gchar* _tmp52_ = NULL;
		gchar* _tmp53_ = NULL;
		gchar* _tmp54_ = NULL;
		_tmp50_ = text_tag;
		_tmp51_ = style;
		g_object_get (_tmp51_, "line-background", &_tmp52_, NULL);
		_tmp53_ = _tmp52_;
		_tmp54_ = _tmp53_;
		g_object_set (_tmp50_, "paragraph-background", _tmp54_, NULL);
		_g_free0 (_tmp54_);
	} else {
		GtkTextTag* _tmp55_ = NULL;
		_tmp55_ = text_tag;
		g_object_set (_tmp55_, "paragraph-background", NULL, NULL);
	}
	_tmp58_ = style;
	g_object_get (_tmp58_, "bold-set", &_tmp59_, NULL);
	_tmp60_ = _tmp59_;
	if (_tmp60_) {
		GtkSourceStyle* _tmp61_ = NULL;
		gboolean _tmp62_ = FALSE;
		gboolean _tmp63_ = FALSE;
		_tmp61_ = style;
		g_object_get (_tmp61_, "bold", &_tmp62_, NULL);
		_tmp63_ = _tmp62_;
		_tmp57_ = _tmp63_;
	} else {
		_tmp57_ = FALSE;
	}
	_tmp64_ = _tmp57_;
	if (_tmp64_) {
		_tmp56_ = PANGO_WEIGHT_BOLD;
	} else {
		_tmp56_ = PANGO_WEIGHT_NORMAL;
	}
	_tmp65_ = text_tag;
	_tmp66_ = _tmp56_;
	g_object_set (_tmp65_, "weight", (gint) _tmp66_, NULL);
	_tmp69_ = style;
	g_object_get (_tmp69_, "italic-set", &_tmp70_, NULL);
	_tmp71_ = _tmp70_;
	if (_tmp71_) {
		GtkSourceStyle* _tmp72_ = NULL;
		gboolean _tmp73_ = FALSE;
		gboolean _tmp74_ = FALSE;
		_tmp72_ = style;
		g_object_get (_tmp72_, "italic", &_tmp73_, NULL);
		_tmp74_ = _tmp73_;
		_tmp68_ = _tmp74_;
	} else {
		_tmp68_ = FALSE;
	}
	_tmp75_ = _tmp68_;
	if (_tmp75_) {
		_tmp67_ = PANGO_STYLE_ITALIC;
	} else {
		_tmp67_ = PANGO_STYLE_NORMAL;
	}
	_tmp76_ = text_tag;
	_tmp77_ = _tmp67_;
	g_object_set (_tmp76_, "style", _tmp77_, NULL);
	_tmp80_ = style;
	g_object_get (_tmp80_, "underline-set", &_tmp81_, NULL);
	_tmp82_ = _tmp81_;
	if (_tmp82_) {
		GtkSourceStyle* _tmp83_ = NULL;
		gboolean _tmp84_ = FALSE;
		gboolean _tmp85_ = FALSE;
		_tmp83_ = style;
		g_object_get (_tmp83_, "underline", &_tmp84_, NULL);
		_tmp85_ = _tmp84_;
		_tmp79_ = _tmp85_;
	} else {
		_tmp79_ = FALSE;
	}
	_tmp86_ = _tmp79_;
	if (_tmp86_) {
		_tmp78_ = PANGO_UNDERLINE_SINGLE;
	} else {
		_tmp78_ = PANGO_UNDERLINE_NONE;
	}
	_tmp87_ = text_tag;
	_tmp88_ = _tmp78_;
	g_object_set (_tmp87_, "underline", _tmp88_, NULL);
	_tmp90_ = style;
	g_object_get (_tmp90_, "strikethrough-set", &_tmp91_, NULL);
	_tmp92_ = _tmp91_;
	if (_tmp92_) {
		GtkSourceStyle* _tmp93_ = NULL;
		gboolean _tmp94_ = FALSE;
		gboolean _tmp95_ = FALSE;
		_tmp93_ = style;
		g_object_get (_tmp93_, "strikethrough", &_tmp94_, NULL);
		_tmp95_ = _tmp94_;
		_tmp89_ = _tmp95_;
	} else {
		_tmp89_ = FALSE;
	}
	_tmp96_ = text_tag;
	_tmp97_ = _tmp89_;
	g_object_set (_tmp96_, "strikethrough", _tmp97_, NULL);
	_g_object_unref0 (style);
	_g_object_unref0 (style_scheme);
}


static void document_sync_found_tags (Document* self) {
	GtkTextTag* _tmp0_ = NULL;
	GtkTextTag* _tmp1_ = NULL;
	GtkTextTag* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->found_tag;
	document_set_search_match_colors (self, _tmp0_);
	_tmp1_ = self->priv->found_tag_selected;
	document_set_search_match_colors (self, _tmp1_);
	_tmp2_ = self->priv->found_tag_selected;
	g_object_set (_tmp2_, "background", "#FF8C00", NULL);
}


/****************
     *    REPLACE
     ****************/
void document_replace (Document* self, const gchar* text) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GtkTextIter insert = {0};
	GtkTextIter insert_prev = {0};
	GtkTextMark* _tmp2_ = NULL;
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	GtkTextTag* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp10_ = FALSE;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextMark* _tmp11_ = NULL;
	GtkTextIter _tmp12_ = {0};
	GtkTextMark* _tmp13_ = NULL;
	GtkTextIter _tmp14_ = {0};
	const gchar* _tmp15_ = NULL;
	GtkTextTag* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = self->priv->search_text;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->_readonly;
	g_return_if_fail (!_tmp1_);
	_tmp2_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp3_, _tmp2_);
	insert = _tmp3_;
	_tmp4_ = insert;
	insert_prev = _tmp4_;
	gtk_text_iter_backward_char (&insert_prev);
	_tmp6_ = self->priv->found_tag_selected;
	_tmp7_ = gtk_text_iter_has_tag (&insert, _tmp6_);
	if (!_tmp7_) {
		GtkTextTag* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		_tmp8_ = self->priv->found_tag_selected;
		_tmp9_ = gtk_text_iter_has_tag (&insert_prev, _tmp8_);
		_tmp5_ = !_tmp9_;
	} else {
		_tmp5_ = FALSE;
	}
	_tmp10_ = _tmp5_;
	if (_tmp10_) {
		document_search_forward (self);
		return;
	}
	_tmp11_ = gtk_text_buffer_get_mark ((GtkTextBuffer*) self, "search_selected_start");
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp12_, _tmp11_);
	start = _tmp12_;
	_tmp13_ = gtk_text_buffer_get_mark ((GtkTextBuffer*) self, "search_selected_end");
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) self, &_tmp14_, _tmp13_);
	end = _tmp14_;
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*) self);
	gtk_text_buffer_delete ((GtkTextBuffer*) self, &start, &end);
	_tmp15_ = text;
	document_insert (self, &start, _tmp15_, -1);
	gtk_text_buffer_end_user_action ((GtkTextBuffer*) self);
	_tmp16_ = self->priv->found_tag_selected;
	_tmp17_ = gtk_text_iter_has_tag (&start, _tmp16_);
	if (!_tmp17_) {
		document_search_forward (self);
	}
}


void document_replace_all (Document* self, const gchar* text) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GtkTextIter start = {0};
	GtkTextIter match_start = {0};
	GtkTextIter match_end = {0};
	GtkTextIter _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = self->priv->search_text;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->_readonly;
	g_return_if_fail (!_tmp1_);
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) self, &_tmp2_);
	start = _tmp2_;
	self->priv->stop_cursor_moved_emission = TRUE;
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*) self);
	while (TRUE) {
		GtkTextIter _tmp3_ = {0};
		GtkTextIter _tmp4_ = {0};
		GtkTextIter _tmp5_ = {0};
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp7_ = NULL;
		GtkTextIter _tmp8_ = {0};
		_tmp3_ = start;
		_tmp6_ = document_iter_forward_search (self, &_tmp3_, NULL, &_tmp4_, &_tmp5_);
		match_start = _tmp4_;
		match_end = _tmp5_;
		if (!_tmp6_) {
			break;
		}
		gtk_text_buffer_delete ((GtkTextBuffer*) self, &match_start, &match_end);
		_tmp7_ = text;
		document_insert (self, &match_start, _tmp7_, -1);
		_tmp8_ = match_start;
		start = _tmp8_;
	}
	gtk_text_buffer_end_user_action ((GtkTextBuffer*) self);
	self->priv->stop_cursor_moved_emission = FALSE;
	document_emit_cursor_moved (self);
}


GFile* document_get_location (Document* self) {
	GFile* result;
	GFile* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	result = _tmp0_;
	return result;
}


void document_set_location (Document* self, GFile* value) {
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_location);
	self->priv->_location = _tmp1_;
	g_object_notify ((GObject *) self, "location");
}


gboolean document_get_readonly (Document* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_readonly;
	result = _tmp0_;
	return result;
}


void document_set_readonly (Document* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_readonly = _tmp0_;
	g_object_notify ((GObject *) self, "readonly");
}


gint document_get_project_id (Document* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_project_id;
	result = _tmp0_;
	return result;
}


void document_set_project_id (Document* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_project_id = _tmp0_;
	g_object_notify ((GObject *) self, "project-id");
}


static void g_cclosure_user_marshal_VOID__BOOLEAN_UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOOLEAN_UINT_UINT) (gpointer data1, gboolean arg_1, guint arg_2, guint arg_3, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOOLEAN_UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_uint (param_values + 3), data2);
}


static void document_class_init (DocumentClass * klass) {
	document_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DocumentPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_document_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_document_set_property;
	G_OBJECT_CLASS (klass)->finalize = document_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_LOCATION, g_param_spec_object ("location", "location", "location", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_READONLY, g_param_spec_boolean ("readonly", "readonly", "readonly", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_PROJECT_ID, g_param_spec_int ("project-id", "project-id", "project-id", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("search_info_updated", TYPE_DOCUMENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_UINT_UINT, G_TYPE_NONE, 3, G_TYPE_BOOLEAN, G_TYPE_UINT, G_TYPE_UINT);
	g_signal_new ("cursor_moved", TYPE_DOCUMENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void document_instance_init (Document * self) {
	self->priv = DOCUMENT_GET_PRIVATE (self);
	self->priv->_readonly = FALSE;
	self->_unsaved_doc_num = (guint) 0;
	self->priv->_project_id = -1;
	self->priv->backup_made = FALSE;
	self->priv->encoding = NULL;
	self->priv->new_file = TRUE;
	self->priv->_structure = NULL;
	self->priv->stop_cursor_moved_emission = FALSE;
}


static void document_finalize (GObject* obj) {
	Document * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DOCUMENT, Document);
	_g_object_unref0 (self->priv->_location);
	_g_object_unref0 (self->tab);
	_g_free0 (self->priv->_etag);
	_g_free0 (self->priv->encoding);
	_g_object_unref0 (self->priv->_structure);
	_g_object_unref0 (self->priv->found_tag);
	_g_object_unref0 (self->priv->found_tag_selected);
	_g_free0 (self->priv->search_text);
	G_OBJECT_CLASS (document_parent_class)->finalize (obj);
}


GType document_get_type (void) {
	static volatile gsize document_type_id__volatile = 0;
	if (g_once_init_enter (&document_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DocumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) document_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Document), 0, (GInstanceInitFunc) document_instance_init, NULL };
		GType document_type_id;
		document_type_id = g_type_register_static (gtk_source_buffer_get_type (), "Document", &g_define_type_info, 0);
		g_once_init_leave (&document_type_id__volatile, document_type_id);
	}
	return document_type_id__volatile;
}


static void _vala_document_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Document * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT, Document);
	switch (property_id) {
		case DOCUMENT_LOCATION:
		g_value_set_object (value, document_get_location (self));
		break;
		case DOCUMENT_READONLY:
		g_value_set_boolean (value, document_get_readonly (self));
		break;
		case DOCUMENT_PROJECT_ID:
		g_value_set_int (value, document_get_project_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_document_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Document * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT, Document);
	switch (property_id) {
		case DOCUMENT_LOCATION:
		document_set_location (self, g_value_get_object (value));
		break;
		case DOCUMENT_READONLY:
		document_set_readonly (self, g_value_get_boolean (value));
		break;
		case DOCUMENT_PROJECT_ID:
		document_set_project_id (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



