/* build_tool_runner.c generated by valac 0.16.0, the Vala compiler
 * generated from build_tool_runner.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gee.h>
#include <unistd.h>
#include <signal.h>
#include <glib/gi18n-lib.h>


#define TYPE_BUILD_TOOL_RUNNER (build_tool_runner_get_type ())
#define BUILD_TOOL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOL_RUNNER, BuildToolRunner))
#define BUILD_TOOL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOL_RUNNER, BuildToolRunnerClass))
#define IS_BUILD_TOOL_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOL_RUNNER))
#define IS_BUILD_TOOL_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOL_RUNNER))
#define BUILD_TOOL_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOL_RUNNER, BuildToolRunnerClass))

typedef struct _BuildToolRunner BuildToolRunner;
typedef struct _BuildToolRunnerClass BuildToolRunnerClass;
typedef struct _BuildToolRunnerPrivate BuildToolRunnerPrivate;

#define TYPE_BUILD_VIEW (build_view_get_type ())
#define BUILD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_VIEW, BuildView))
#define BUILD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_VIEW, BuildViewClass))
#define IS_BUILD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_VIEW))
#define IS_BUILD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_VIEW))
#define BUILD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_VIEW, BuildViewClass))

typedef struct _BuildView BuildView;
typedef struct _BuildViewClass BuildViewClass;

#define TYPE_BUILD_JOB (build_job_get_type ())

#define TYPE_POST_PROCESSOR_TYPE (post_processor_type_get_type ())
typedef struct _BuildJob BuildJob;
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_BUILD_TOOL (build_tool_get_type ())
typedef struct _BuildTool BuildTool;

#define TYPE_PARTITION_STATE (partition_state_get_type ())
#define _build_job_free0(var) ((var == NULL) ? NULL : (var = (build_job_free (var), NULL)))

#define TYPE_BUILD_MSG (build_msg_get_type ())

#define TYPE_BUILD_MSG_TYPE (build_msg_type_get_type ())
typedef struct _BuildMsg BuildMsg;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_POST_PROCESSOR (post_processor_get_type ())
#define POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_POST_PROCESSOR, PostProcessor))
#define POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_POST_PROCESSOR, PostProcessorClass))
#define IS_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_POST_PROCESSOR))
#define IS_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_POST_PROCESSOR))
#define POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_POST_PROCESSOR, PostProcessorClass))

typedef struct _PostProcessor PostProcessor;
typedef struct _PostProcessorClass PostProcessorClass;

#define TYPE_ALL_OUTPUT_POST_PROCESSOR (all_output_post_processor_get_type ())
#define ALL_OUTPUT_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALL_OUTPUT_POST_PROCESSOR, AllOutputPostProcessor))
#define ALL_OUTPUT_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALL_OUTPUT_POST_PROCESSOR, AllOutputPostProcessorClass))
#define IS_ALL_OUTPUT_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALL_OUTPUT_POST_PROCESSOR))
#define IS_ALL_OUTPUT_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALL_OUTPUT_POST_PROCESSOR))
#define ALL_OUTPUT_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALL_OUTPUT_POST_PROCESSOR, AllOutputPostProcessorClass))

typedef struct _AllOutputPostProcessor AllOutputPostProcessor;
typedef struct _AllOutputPostProcessorClass AllOutputPostProcessorClass;

#define TYPE_LATEX_POST_PROCESSOR (latex_post_processor_get_type ())
#define LATEX_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEX_POST_PROCESSOR, LatexPostProcessor))
#define LATEX_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEX_POST_PROCESSOR, LatexPostProcessorClass))
#define IS_LATEX_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEX_POST_PROCESSOR))
#define IS_LATEX_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEX_POST_PROCESSOR))
#define LATEX_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEX_POST_PROCESSOR, LatexPostProcessorClass))

typedef struct _LatexPostProcessor LatexPostProcessor;
typedef struct _LatexPostProcessorClass LatexPostProcessorClass;

#define TYPE_LATEXMK_POST_PROCESSOR (latexmk_post_processor_get_type ())
#define LATEXMK_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEXMK_POST_PROCESSOR, LatexmkPostProcessor))
#define LATEXMK_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEXMK_POST_PROCESSOR, LatexmkPostProcessorClass))
#define IS_LATEXMK_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEXMK_POST_PROCESSOR))
#define IS_LATEXMK_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEXMK_POST_PROCESSOR))
#define LATEXMK_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEXMK_POST_PROCESSOR, LatexmkPostProcessorClass))

typedef struct _LatexmkPostProcessor LatexmkPostProcessor;
typedef struct _LatexmkPostProcessorClass LatexmkPostProcessorClass;

#define TYPE_NO_OUTPUT_POST_PROCESSOR (no_output_post_processor_get_type ())
#define NO_OUTPUT_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NO_OUTPUT_POST_PROCESSOR, NoOutputPostProcessor))
#define NO_OUTPUT_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NO_OUTPUT_POST_PROCESSOR, NoOutputPostProcessorClass))
#define IS_NO_OUTPUT_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NO_OUTPUT_POST_PROCESSOR))
#define IS_NO_OUTPUT_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NO_OUTPUT_POST_PROCESSOR))
#define NO_OUTPUT_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NO_OUTPUT_POST_PROCESSOR, NoOutputPostProcessorClass))

typedef struct _NoOutputPostProcessor NoOutputPostProcessor;
typedef struct _NoOutputPostProcessorClass NoOutputPostProcessorClass;

#define TYPE_RUBBER_POST_PROCESSOR (rubber_post_processor_get_type ())
#define RUBBER_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RUBBER_POST_PROCESSOR, RubberPostProcessor))
#define RUBBER_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RUBBER_POST_PROCESSOR, RubberPostProcessorClass))
#define IS_RUBBER_POST_PROCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RUBBER_POST_PROCESSOR))
#define IS_RUBBER_POST_PROCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RUBBER_POST_PROCESSOR))
#define RUBBER_POST_PROCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RUBBER_POST_PROCESSOR, RubberPostProcessorClass))

typedef struct _RubberPostProcessor RubberPostProcessor;
typedef struct _RubberPostProcessorClass RubberPostProcessorClass;
#define __g_node_destroy__build_msg_free0_0(var) ((var == NULL) ? NULL : (var = (_g_node_destroy__build_msg_free0_ (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _BuildToolRunner {
	GObject parent_instance;
	BuildToolRunnerPrivate * priv;
};

struct _BuildToolRunnerClass {
	GObjectClass parent_class;
};

typedef enum  {
	POST_PROCESSOR_TYPE_ALL_OUTPUT = 0,
	POST_PROCESSOR_TYPE_LATEX,
	POST_PROCESSOR_TYPE_LATEXMK,
	POST_PROCESSOR_TYPE_NO_OUTPUT,
	POST_PROCESSOR_TYPE_RUBBER,
	POST_PROCESSOR_TYPE_N_POST_PROCESSORS
} PostProcessorType;

struct _BuildJob {
	gboolean must_succeed;
	PostProcessorType post_processor;
	gchar* command;
};

struct _BuildToolRunnerPrivate {
	GPid* child_pid;
	guint* handlers;
	gint handlers_length1;
	gint _handlers_size_;
	GIOChannel* out_channel;
	gboolean read_output;
	gchar* output;
	BuildView* view;
	gboolean compilation;
	gchar* document_view_program;
	gboolean latexmk_show_all;
	GtkAction* action_stop_exec;
	GFile* file;
	gchar* filename;
	gchar* shortname;
	gchar* directory;
	GeeArrayList* jobs;
	gint job_num;
	BuildJob current_job;
	GtkTreeIter root_partition;
	GtkTreeIter* job_partitions;
	gint job_partitions_length1;
	gint _job_partitions_size_;
};

struct _BuildTool {
	gchar* description;
	gchar* extensions;
	gchar* label;
	gchar* icon;
	gboolean show;
	gboolean compilation;
	GeeArrayList* jobs;
};

typedef enum  {
	PARTITION_STATE_RUNNING,
	PARTITION_STATE_SUCCEEDED,
	PARTITION_STATE_FAILED,
	PARTITION_STATE_ABORTED
} PartitionState;

typedef enum  {
	BUILD_MSG_TYPE_ERROR,
	BUILD_MSG_TYPE_WARNING,
	BUILD_MSG_TYPE_BADBOX,
	BUILD_MSG_TYPE_OTHER
} BuildMsgType;

struct _BuildMsg {
	gchar* text;
	BuildMsgType type;
	gchar* filename;
	gboolean lines_set;
	gint start_line;
	gint end_line;
	gboolean expand;
};


static gpointer build_tool_runner_parent_class = NULL;

GType build_tool_runner_get_type (void) G_GNUC_CONST;
GType build_view_get_type (void) G_GNUC_CONST;
GType build_job_get_type (void) G_GNUC_CONST;
GType post_processor_type_get_type (void) G_GNUC_CONST;
BuildJob* build_job_dup (const BuildJob* self);
void build_job_free (BuildJob* self);
void build_job_copy (const BuildJob* self, BuildJob* dest);
void build_job_destroy (BuildJob* self);
#define BUILD_TOOL_RUNNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BUILD_TOOL_RUNNER, BuildToolRunnerPrivate))
enum  {
	BUILD_TOOL_RUNNER_DUMMY_PROPERTY
};
#define BUILD_TOOL_RUNNER_POLL_INTERVAL 250
GType build_tool_get_type (void) G_GNUC_CONST;
BuildTool* build_tool_dup (const BuildTool* self);
void build_tool_free (BuildTool* self);
void build_tool_copy (const BuildTool* self, BuildTool* dest);
void build_tool_destroy (BuildTool* self);
BuildToolRunner* build_tool_runner_new (GFile* file, BuildTool* tool, BuildView* view, GtkAction* action_stop_exec);
BuildToolRunner* build_tool_runner_construct (GType object_type, GFile* file, BuildTool* tool, BuildView* view, GtkAction* action_stop_exec);
gchar* utils_get_shortname (const gchar* path);
gchar* utils_get_extension (const gchar* path);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
void build_view_clear (BuildView* self);
GType partition_state_get_type (void) G_GNUC_CONST;
void build_view_add_partition (BuildView* self, const gchar* msg, PartitionState state, GtkTreeIter* parent, gboolean bold, GtkTreeIter* result);
static gboolean build_tool_runner_add_job_partitions (BuildToolRunner* self);
static void build_tool_runner_proceed (BuildToolRunner* self);
static gchar** build_tool_runner_get_command_args (BuildToolRunner* self, const gchar* command_line, gboolean for_printing, int* result_length1, GError** error);
GType build_msg_get_type (void) G_GNUC_CONST;
GType build_msg_type_get_type (void) G_GNUC_CONST;
BuildMsg* build_msg_dup (const BuildMsg* self);
void build_msg_free (BuildMsg* self);
void build_msg_copy (const BuildMsg* self, BuildMsg* dest);
void build_msg_destroy (BuildMsg* self);
void build_view_append_single_message (BuildView* self, GtkTreeIter* partition_id, BuildMsg* message, GtkTreeIter* result);
static void build_tool_runner_failed (BuildToolRunner* self);
static void _vala_array_add2 (GtkTreeIter** array, int* length, int* size, const GtkTreeIter* value);
static void build_tool_runner_execute (BuildToolRunner* self, gchar** command, int command_length1, const gchar* working_directory, GError** error);
static void ___lambda39_ (BuildToolRunner* self);
static void ____lambda39__gspawn_child_setup_func (gpointer self);
static GPid* _g_pid_dup (GPid* self);
static void build_tool_runner_on_exit (BuildToolRunner* self, GPid pid, gint status);
static void _build_tool_runner_on_exit_gchild_watch_func (GPid pid, gint status, gpointer self);
static void _vala_array_add3 (guint** array, int* length, int* size, guint value);
static gboolean build_tool_runner_on_output (BuildToolRunner* self);
static gboolean _build_tool_runner_on_output_gsource_func (gpointer self);
static void _vala_array_add4 (guint** array, int* length, int* size, guint value);
static void build_tool_runner_execute_without_output (BuildToolRunner* self, gchar** command, int command_length1, const gchar* working_directory, GError** error);
static void _vala_array_add5 (guint** array, int* length, int* size, guint value);
void build_tool_runner_abort (BuildToolRunner* self);
void build_view_set_partition_state (BuildView* self, GtkTreeIter* partition_id, PartitionState state);
GType post_processor_get_type (void) G_GNUC_CONST;
AllOutputPostProcessor* all_output_post_processor_new (void);
AllOutputPostProcessor* all_output_post_processor_construct (GType object_type);
GType all_output_post_processor_get_type (void) G_GNUC_CONST;
LatexPostProcessor* latex_post_processor_new (void);
LatexPostProcessor* latex_post_processor_construct (GType object_type);
GType latex_post_processor_get_type (void) G_GNUC_CONST;
LatexmkPostProcessor* latexmk_post_processor_new (gboolean force_show_all);
LatexmkPostProcessor* latexmk_post_processor_construct (GType object_type, gboolean force_show_all);
GType latexmk_post_processor_get_type (void) G_GNUC_CONST;
NoOutputPostProcessor* no_output_post_processor_new (void);
NoOutputPostProcessor* no_output_post_processor_construct (GType object_type);
GType no_output_post_processor_get_type (void) G_GNUC_CONST;
RubberPostProcessor* rubber_post_processor_new (void);
RubberPostProcessor* rubber_post_processor_construct (GType object_type);
GType rubber_post_processor_get_type (void) G_GNUC_CONST;
void post_processor_set_status (PostProcessor* self, gint status);
void post_processor_process (PostProcessor* self, GFile* file, const gchar* output);
void build_view_append_messages (BuildView* self, GtkTreeIter* parent, GNode* messages, gboolean parent_is_partition);
GNode* post_processor_get_messages (PostProcessor* self);
static void _build_msg_free0_ (gpointer var);
static void _g_node_destroy__build_msg_free0_ (GNode* self);
static void _g_node_destroy__build_msg_free0_ (GNode* self);
gboolean post_processor_get_successful (PostProcessor* self);
static void build_tool_runner_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


BuildToolRunner* build_tool_runner_construct (GType object_type, GFile* file, BuildTool* tool, BuildView* view, GtkAction* action_stop_exec) {
	BuildToolRunner * self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	BuildTool _tmp2_;
	gboolean _tmp3_;
	GtkAction* _tmp4_;
	GtkAction* _tmp5_;
	GFile* _tmp6_;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	GFile* _tmp10_;
	GFile* _tmp11_ = NULL;
	GFile* _tmp12_;
	gchar* _tmp13_ = NULL;
	GSettings* _tmp14_;
	GSettings* settings;
	GSettings* _tmp15_;
	gchar* _tmp16_ = NULL;
	GSettings* _tmp17_;
	gboolean _tmp18_ = FALSE;
	BuildTool _tmp19_;
	const gchar* _tmp20_;
	gchar** _tmp21_;
	gchar** _tmp22_ = NULL;
	gchar** extensions;
	gint extensions_length1;
	gint _extensions_size_;
	gboolean _tmp23_ = FALSE;
	BuildTool _tmp24_;
	const gchar* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	gboolean _tmp32_;
	BuildTool _tmp33_;
	GeeArrayList* _tmp34_;
	BuildView* _tmp35_;
	BuildView* _tmp36_;
	BuildView* _tmp37_;
	BuildView* _tmp38_;
	BuildTool _tmp39_;
	const gchar* _tmp40_;
	GtkTreeIter _tmp41_ = {0};
	gboolean _tmp42_ = FALSE;
	GtkAction* _tmp43_;
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (tool != NULL, NULL);
	g_return_val_if_fail (view != NULL, NULL);
	g_return_val_if_fail (action_stop_exec != NULL, NULL);
	self = (BuildToolRunner*) g_object_new (object_type, NULL);
	_tmp0_ = file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp1_;
	_tmp2_ = *tool;
	_tmp3_ = _tmp2_.compilation;
	self->priv->compilation = _tmp3_;
	_tmp4_ = action_stop_exec;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->action_stop_exec);
	self->priv->action_stop_exec = _tmp5_;
	_tmp6_ = file;
	_tmp7_ = g_file_get_parse_name (_tmp6_);
	_g_free0 (self->priv->filename);
	self->priv->filename = _tmp7_;
	_tmp8_ = self->priv->filename;
	_tmp9_ = utils_get_shortname (_tmp8_);
	_g_free0 (self->priv->shortname);
	self->priv->shortname = _tmp9_;
	_tmp10_ = file;
	_tmp11_ = g_file_get_parent (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_file_get_parse_name (_tmp12_);
	_g_free0 (self->priv->directory);
	self->priv->directory = _tmp13_;
	_g_object_unref0 (_tmp12_);
	_tmp14_ = g_settings_new ("org.gnome.latexila.preferences.latex");
	settings = _tmp14_;
	_tmp15_ = settings;
	_tmp16_ = g_settings_get_string (_tmp15_, "document-view-program");
	_g_free0 (self->priv->document_view_program);
	self->priv->document_view_program = _tmp16_;
	_tmp17_ = settings;
	_tmp18_ = g_settings_get_boolean (_tmp17_, "latexmk-always-show-all");
	self->priv->latexmk_show_all = _tmp18_;
	_tmp19_ = *tool;
	_tmp20_ = _tmp19_.extensions;
	_tmp22_ = _tmp21_ = g_strsplit (_tmp20_, " ", 0);
	extensions = _tmp22_;
	extensions_length1 = _vala_array_length (_tmp21_);
	_extensions_size_ = extensions_length1;
	_tmp24_ = *tool;
	_tmp25_ = _tmp24_.extensions;
	_tmp26_ = strlen (_tmp25_);
	_tmp27_ = _tmp26_;
	if (0 < _tmp27_) {
		const gchar* _tmp28_;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
		gchar** _tmp31_;
		gint _tmp31__length1;
		_tmp28_ = self->priv->filename;
		_tmp29_ = utils_get_extension (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = extensions;
		_tmp31__length1 = extensions_length1;
		_tmp23_ = !_vala_string_array_contains (_tmp31_, _tmp31__length1, _tmp30_);
		_g_free0 (_tmp30_);
	} else {
		_tmp23_ = FALSE;
	}
	_tmp32_ = _tmp23_;
	if (_tmp32_) {
		g_warning ("build_tool_runner.vala:72: Bad file extension");
		extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (settings);
		return self;
	}
	_tmp33_ = *tool;
	_tmp34_ = _tmp33_.jobs;
	self->priv->jobs = _tmp34_;
	_tmp35_ = view;
	_tmp36_ = _g_object_ref0 (_tmp35_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp36_;
	_tmp37_ = view;
	build_view_clear (_tmp37_);
	_tmp38_ = view;
	_tmp39_ = *tool;
	_tmp40_ = _tmp39_.label;
	build_view_add_partition (_tmp38_, _tmp40_, PARTITION_STATE_RUNNING, NULL, TRUE, &_tmp41_);
	self->priv->root_partition = _tmp41_;
	_tmp42_ = build_tool_runner_add_job_partitions (self);
	if (!_tmp42_) {
		extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (settings);
		return self;
	}
	_tmp43_ = action_stop_exec;
	gtk_action_set_sensitive (_tmp43_, TRUE);
	build_tool_runner_proceed (self);
	extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (settings);
	return self;
}


BuildToolRunner* build_tool_runner_new (GFile* file, BuildTool* tool, BuildView* view, GtkAction* action_stop_exec) {
	return build_tool_runner_construct (TYPE_BUILD_TOOL_RUNNER, file, tool, view, action_stop_exec);
}


static void _vala_array_add2 (GtkTreeIter** array, int* length, int* size, const GtkTreeIter* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkTreeIter, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static gboolean build_tool_runner_add_job_partitions (BuildToolRunner* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->job_num = 0;
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _job_list;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _job_size;
		gint _job_index;
		_tmp0_ = self->priv->jobs;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_job_list = _tmp1_;
		_tmp2_ = _job_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_job_size = _tmp4_;
		_job_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			BuildJob* _tmp11_;
			BuildJob _tmp12_ = {0};
			BuildJob _tmp13_;
			BuildJob job;
			gchar** command = NULL;
			gint command_length1 = 0;
			gint _command_size_ = 0;
			GtkTreeIter* _tmp36_;
			gint _tmp36__length1;
			BuildView* _tmp37_;
			gchar** _tmp38_;
			gint _tmp38__length1;
			gchar* _tmp39_ = NULL;
			gchar* _tmp40_;
			GtkTreeIter _tmp41_;
			GtkTreeIter _tmp42_ = {0};
			gint _tmp43_;
			_tmp5_ = _job_index;
			_job_index = _tmp5_ + 1;
			_tmp6_ = _job_index;
			_tmp7_ = _job_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _job_list;
			_tmp9_ = _job_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			_tmp11_ = (BuildJob*) _tmp10_;
			build_job_copy (_tmp11_, &_tmp12_);
			_tmp13_ = _tmp12_;
			_build_job_free0 (_tmp11_);
			job = _tmp13_;
			{
				BuildJob _tmp14_;
				const gchar* _tmp15_;
				gint _tmp16_ = 0;
				gchar** _tmp17_ = NULL;
				gchar** _tmp18_;
				gint _tmp18__length1;
				gint __tmp18__size_;
				_tmp14_ = job;
				_tmp15_ = _tmp14_.command;
				_tmp17_ = build_tool_runner_get_command_args (self, _tmp15_, TRUE, &_tmp16_, &_inner_error_);
				_tmp18_ = _tmp17_;
				_tmp18__length1 = _tmp16_;
				__tmp18__size_ = _tmp18__length1;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_SHELL_ERROR) {
						goto __catch6_g_shell_error;
					}
					command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
					build_job_destroy (&job);
					_g_object_unref0 (_job_list);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
				command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
				command = _tmp18_;
				command_length1 = _tmp18__length1;
				_command_size_ = command_length1;
			}
			goto __finally6;
			__catch6_g_shell_error:
			{
				GError* e = NULL;
				BuildView* _tmp19_;
				BuildJob _tmp20_;
				const gchar* _tmp21_;
				GtkTreeIter _tmp22_;
				GtkTreeIter _tmp23_ = {0};
				GtkTreeIter job_partition;
				BuildMsg message = {0};
				gchar* _tmp24_;
				BuildView* _tmp25_;
				GtkTreeIter _tmp26_;
				BuildMsg _tmp27_;
				GtkTreeIter _tmp28_ = {0};
				GError* _tmp29_;
				const gchar* _tmp30_;
				gchar* _tmp31_;
				BuildView* _tmp32_;
				GtkTreeIter _tmp33_;
				BuildMsg _tmp34_;
				GtkTreeIter _tmp35_ = {0};
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp19_ = self->priv->view;
				_tmp20_ = job;
				_tmp21_ = _tmp20_.command;
				_tmp22_ = self->priv->root_partition;
				build_view_add_partition (_tmp19_, _tmp21_, PARTITION_STATE_FAILED, &_tmp22_, FALSE, &_tmp23_);
				job_partition = _tmp23_;
				memset (&message, 0, sizeof (BuildMsg));
				_tmp24_ = g_strdup ("Failed to parse command line:");
				_g_free0 (message.text);
				message.text = _tmp24_;
				message.type = BUILD_MSG_TYPE_ERROR;
				message.lines_set = FALSE;
				_tmp25_ = self->priv->view;
				_tmp26_ = job_partition;
				_tmp27_ = message;
				build_view_append_single_message (_tmp25_, &_tmp26_, &_tmp27_, &_tmp28_);
				_tmp29_ = e;
				_tmp30_ = _tmp29_->message;
				_tmp31_ = g_strdup (_tmp30_);
				_g_free0 (message.text);
				message.text = _tmp31_;
				message.type = BUILD_MSG_TYPE_OTHER;
				_tmp32_ = self->priv->view;
				_tmp33_ = job_partition;
				_tmp34_ = message;
				build_view_append_single_message (_tmp32_, &_tmp33_, &_tmp34_, &_tmp35_);
				build_tool_runner_failed (self);
				result = FALSE;
				build_msg_destroy (&message);
				_g_error_free0 (e);
				command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
				build_job_destroy (&job);
				_g_object_unref0 (_job_list);
				return result;
			}
			__finally6:
			if (_inner_error_ != NULL) {
				command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
				build_job_destroy (&job);
				_g_object_unref0 (_job_list);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
			_tmp36_ = self->priv->job_partitions;
			_tmp36__length1 = self->priv->job_partitions_length1;
			_tmp37_ = self->priv->view;
			_tmp38_ = command;
			_tmp38__length1 = command_length1;
			_tmp39_ = g_strjoinv (" ", _tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = self->priv->root_partition;
			build_view_add_partition (_tmp37_, _tmp40_, PARTITION_STATE_RUNNING, &_tmp41_, FALSE, &_tmp42_);
			_vala_array_add2 (&self->priv->job_partitions, &self->priv->job_partitions_length1, &self->priv->_job_partitions_size_, &_tmp42_);
			_g_free0 (_tmp40_);
			_tmp43_ = self->priv->job_num;
			self->priv->job_num = _tmp43_ + 1;
			command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
			build_job_destroy (&job);
		}
		_g_object_unref0 (_job_list);
	}
	self->priv->job_num = 0;
	result = TRUE;
	return result;
}


static void ___lambda39_ (BuildToolRunner* self) {
	dup2 (STDOUT_FILENO, STDERR_FILENO);
}


static void ____lambda39__gspawn_child_setup_func (gpointer self) {
	___lambda39_ (self);
}


static GPid* _g_pid_dup (GPid* self) {
	GPid* dup;
	dup = g_new0 (GPid, 1);
	memcpy (dup, self, sizeof (GPid));
	return dup;
}


static gpointer __g_pid_dup0 (gpointer self) {
	return self ? _g_pid_dup (self) : NULL;
}


static void _build_tool_runner_on_exit_gchild_watch_func (GPid pid, gint status, gpointer self) {
	build_tool_runner_on_exit (self, pid, status);
}


static void _vala_array_add3 (guint** array, int* length, int* size, guint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static gboolean _build_tool_runner_on_output_gsource_func (gpointer self) {
	gboolean result;
	result = build_tool_runner_on_output (self);
	return result;
}


static void _vala_array_add4 (guint** array, int* length, int* size, guint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void build_tool_runner_execute (BuildToolRunner* self, gchar** command, int command_length1, const gchar* working_directory, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gint std_out = 0;
		const gchar* _tmp0_;
		gchar** _tmp1_;
		gint _tmp1__length1;
		GPid _tmp2_ = 0;
		gint _tmp3_ = 0;
		GPid _tmp4_;
		GPid* _tmp5_;
		guint* _tmp6_;
		gint _tmp6__length1;
		GPid* _tmp7_;
		guint _tmp8_ = 0U;
		gint _tmp9_;
		GIOChannel* _tmp10_;
		GIOChannel* _tmp11_;
		GIOChannel* _tmp12_;
		guint* _tmp13_;
		gint _tmp13__length1;
		guint _tmp14_ = 0U;
		_tmp0_ = working_directory;
		_tmp1_ = command;
		_tmp1__length1 = command_length1;
		g_spawn_async_with_pipes (_tmp0_, _tmp1_, NULL, G_SPAWN_DO_NOT_REAP_CHILD | G_SPAWN_SEARCH_PATH, ____lambda39__gspawn_child_setup_func, self, &_tmp2_, NULL, &_tmp3_, NULL, &_inner_error_);
		_g_free0 (self->priv->child_pid);
		_tmp4_ = _tmp2_;
		_tmp5_ = __g_pid_dup0 (&_tmp4_);
		self->priv->child_pid = _tmp5_;
		std_out = _tmp3_;
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		_tmp6_ = self->priv->handlers;
		_tmp6__length1 = self->priv->handlers_length1;
		_tmp7_ = self->priv->child_pid;
		_tmp8_ = g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, *_tmp7_, _build_tool_runner_on_exit_gchild_watch_func, g_object_ref (self), g_object_unref);
		_vala_array_add3 (&self->priv->handlers, &self->priv->handlers_length1, &self->priv->_handlers_size_, _tmp8_);
		_tmp9_ = std_out;
		_tmp10_ = g_io_channel_unix_new (_tmp9_);
		_g_io_channel_unref0 (self->priv->out_channel);
		self->priv->out_channel = _tmp10_;
		_tmp11_ = self->priv->out_channel;
		g_io_channel_set_flags (_tmp11_, G_IO_FLAG_NONBLOCK, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		_tmp12_ = self->priv->out_channel;
		g_io_channel_set_encoding (_tmp12_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		_tmp13_ = self->priv->handlers;
		_tmp13__length1 = self->priv->handlers_length1;
		_tmp14_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) BUILD_TOOL_RUNNER_POLL_INTERVAL, _build_tool_runner_on_output_gsource_func, g_object_ref (self), g_object_unref);
		_vala_array_add4 (&self->priv->handlers, &self->priv->handlers_length1, &self->priv->_handlers_size_, _tmp14_);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		GError* _tmp15_;
		GError* _tmp16_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = e;
		_tmp16_ = _g_error_copy0 (_tmp15_);
		_inner_error_ = _tmp16_;
		_g_error_free0 (e);
		goto __finally7;
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static void _vala_array_add5 (guint** array, int* length, int* size, guint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void build_tool_runner_execute_without_output (BuildToolRunner* self, gchar** command, int command_length1, const gchar* working_directory, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->read_output = FALSE;
	{
		const gchar* _tmp0_;
		gchar** _tmp1_;
		gint _tmp1__length1;
		GPid _tmp2_ = 0;
		GPid _tmp3_;
		GPid* _tmp4_;
		guint* _tmp5_;
		gint _tmp5__length1;
		GPid* _tmp6_;
		guint _tmp7_ = 0U;
		_tmp0_ = working_directory;
		_tmp1_ = command;
		_tmp1__length1 = command_length1;
		g_spawn_async (_tmp0_, _tmp1_, NULL, G_SPAWN_DO_NOT_REAP_CHILD | G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp2_, &_inner_error_);
		_g_free0 (self->priv->child_pid);
		_tmp3_ = _tmp2_;
		_tmp4_ = __g_pid_dup0 (&_tmp3_);
		self->priv->child_pid = _tmp4_;
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
		_tmp5_ = self->priv->handlers;
		_tmp5__length1 = self->priv->handlers_length1;
		_tmp6_ = self->priv->child_pid;
		_tmp7_ = g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, *_tmp6_, _build_tool_runner_on_exit_gchild_watch_func, g_object_ref (self), g_object_unref);
		_vala_array_add5 (&self->priv->handlers, &self->priv->handlers_length1, &self->priv->_handlers_size_, _tmp7_);
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		GError* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _g_error_copy0 (_tmp8_);
		_inner_error_ = _tmp9_;
		_g_error_free0 (e);
		goto __finally8;
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


void build_tool_runner_abort (BuildToolRunner* self) {
	GPid* _tmp0_;
	guint* _tmp1_;
	gint _tmp1__length1;
	GPid* _tmp3_;
	GtkAction* _tmp4_;
	BuildView* _tmp5_;
	GtkTreeIter _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->child_pid;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->handlers;
	_tmp1__length1 = self->priv->handlers_length1;
	{
		guint* handler_collection = NULL;
		gint handler_collection_length1 = 0;
		gint _handler_collection_size_ = 0;
		gint handler_it = 0;
		handler_collection = _tmp1_;
		handler_collection_length1 = _tmp1__length1;
		for (handler_it = 0; handler_it < _tmp1__length1; handler_it = handler_it + 1) {
			guint handler = 0U;
			handler = handler_collection[handler_it];
			{
				guint _tmp2_;
				_tmp2_ = handler;
				g_source_remove (_tmp2_);
			}
		}
	}
	_tmp3_ = self->priv->child_pid;
	kill (*_tmp3_, SIGTERM);
	_tmp4_ = self->priv->action_stop_exec;
	gtk_action_set_sensitive (_tmp4_, FALSE);
	_tmp5_ = self->priv->view;
	_tmp6_ = self->priv->root_partition;
	build_view_set_partition_state (_tmp5_, &_tmp6_, PARTITION_STATE_ABORTED);
	{
		gint _tmp7_;
		gint i;
		_tmp7_ = self->priv->job_num;
		i = _tmp7_;
		{
			gboolean _tmp8_;
			_tmp8_ = TRUE;
			while (TRUE) {
				gboolean _tmp9_;
				gint _tmp11_;
				GtkTreeIter* _tmp12_;
				gint _tmp12__length1;
				BuildView* _tmp13_;
				GtkTreeIter* _tmp14_;
				gint _tmp14__length1;
				gint _tmp15_;
				GtkTreeIter _tmp16_;
				_tmp9_ = _tmp8_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp11_ = i;
				_tmp12_ = self->priv->job_partitions;
				_tmp12__length1 = self->priv->job_partitions_length1;
				if (!(_tmp11_ < _tmp12__length1)) {
					break;
				}
				_tmp13_ = self->priv->view;
				_tmp14_ = self->priv->job_partitions;
				_tmp14__length1 = self->priv->job_partitions_length1;
				_tmp15_ = i;
				_tmp16_ = _tmp14_[_tmp15_];
				build_view_set_partition_state (_tmp13_, &_tmp16_, PARTITION_STATE_ABORTED);
			}
		}
	}
}


static gboolean build_tool_runner_on_output (BuildToolRunner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gchar* text;
	gsize length = 0UL;
	gsize _tmp8_;
	const gchar* _tmp9_;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp14_;
	gchar** _tmp15_;
	gchar** _tmp16_ = NULL;
	gchar** lines;
	gint lines_length1;
	gint _lines_size_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->read_output;
	g_return_val_if_fail (_tmp0_, FALSE);
	text = NULL;
	{
		GIOChannel* _tmp1_;
		gchar* _tmp2_ = NULL;
		gsize _tmp3_ = 0UL;
		_tmp1_ = self->priv->out_channel;
		g_io_channel_read_to_end (_tmp1_, &_tmp2_, &_tmp3_, &_inner_error_);
		_g_free0 (text);
		text = _tmp2_;
		length = _tmp3_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_CONVERT_ERROR) {
				goto __catch9_g_convert_error;
			}
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch9_g_io_channel_error;
			}
			_g_free0 (text);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	goto __finally9;
	__catch9_g_convert_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("build_tool_runner.vala:214: Read output: convert error: %s", _tmp5_);
		_g_error_free0 (e);
	}
	goto __finally9;
	__catch9_g_io_channel_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("build_tool_runner.vala:218: Read output: IO channel error: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		_g_free0 (text);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp8_ = length;
	if (_tmp8_ <= ((gsize) 0)) {
		result = TRUE;
		_g_free0 (text);
		return result;
	}
	_tmp9_ = text;
	_tmp10_ = g_utf8_validate (_tmp9_, (gssize) (-1), NULL);
	if (_tmp10_) {
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp11_ = self->priv->output;
		_tmp12_ = text;
		_tmp13_ = g_strconcat (_tmp11_, _tmp12_, NULL);
		_g_free0 (self->priv->output);
		self->priv->output = _tmp13_;
		result = TRUE;
		_g_free0 (text);
		return result;
	}
	_tmp14_ = text;
	_tmp16_ = _tmp15_ = g_strsplit (_tmp14_, "\n", 0);
	lines = _tmp16_;
	lines_length1 = _vala_array_length (_tmp15_);
	_lines_size_ = lines_length1;
	_tmp17_ = lines;
	_tmp17__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp17_;
		line_collection_length1 = _tmp17__length1;
		for (line_it = 0; line_it < _tmp17__length1; line_it = line_it + 1) {
			gchar* _tmp18_;
			gchar* line = NULL;
			_tmp18_ = g_strdup (line_collection[line_it]);
			line = _tmp18_;
			{
				const gchar* _tmp19_;
				gchar* _tmp20_ = NULL;
				gchar* line_utf8;
				const gchar* _tmp21_;
				gboolean _tmp25_ = FALSE;
				const gchar* _tmp26_;
				gboolean _tmp29_;
				_tmp19_ = line;
				_tmp20_ = g_locale_to_utf8 (_tmp19_, (gssize) (-1), NULL, NULL, NULL);
				line_utf8 = _tmp20_;
				_tmp21_ = line_utf8;
				if (_tmp21_ == NULL) {
					{
						const gchar* _tmp22_;
						gchar* _tmp23_ = NULL;
						gchar* _tmp24_;
						_tmp22_ = line;
						_tmp23_ = g_convert (_tmp22_, (gssize) (-1), "UTF-8", "ISO-8859-1", NULL, NULL, &_inner_error_);
						_tmp24_ = _tmp23_;
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == G_CONVERT_ERROR) {
								goto __catch10_g_convert_error;
							}
							_g_free0 (line_utf8);
							_g_free0 (line);
							lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (text);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return FALSE;
						}
						_g_free0 (line_utf8);
						line_utf8 = _tmp24_;
					}
					goto __finally10;
					__catch10_g_convert_error:
					{
						GError* e = NULL;
						e = _inner_error_;
						_inner_error_ = NULL;
						_g_error_free0 (e);
					}
					__finally10:
					if (_inner_error_ != NULL) {
						_g_free0 (line_utf8);
						_g_free0 (line);
						lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (text);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return FALSE;
					}
				}
				_tmp26_ = line_utf8;
				if (_tmp26_ != NULL) {
					const gchar* _tmp27_;
					gboolean _tmp28_ = FALSE;
					_tmp27_ = line_utf8;
					_tmp28_ = g_utf8_validate (_tmp27_, (gssize) (-1), NULL);
					_tmp25_ = _tmp28_;
				} else {
					_tmp25_ = FALSE;
				}
				_tmp29_ = _tmp25_;
				if (_tmp29_) {
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					gchar* _tmp34_;
					_tmp30_ = self->priv->output;
					_tmp31_ = line_utf8;
					_tmp32_ = g_strconcat (_tmp31_, "\n", NULL);
					_tmp33_ = _tmp32_;
					_tmp34_ = g_strconcat (_tmp30_, _tmp33_, NULL);
					_g_free0 (self->priv->output);
					self->priv->output = _tmp34_;
					_g_free0 (_tmp33_);
				} else {
					const gchar* _tmp35_;
					_tmp35_ = line;
					g_warning ("build_tool_runner.vala:251: Read output failed: %s", _tmp35_);
				}
				_g_free0 (line_utf8);
				_g_free0 (line);
			}
		}
	}
	result = TRUE;
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (text);
	return result;
}


static void _build_msg_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (build_msg_free (var), NULL));
}


static gboolean _g_node_destroy__build_msg_free0__node (GNode* node, gpointer unused) {
	_build_msg_free0_ (node->data);
	return FALSE;
}


static void _g_node_destroy__build_msg_free0_ (GNode* self) {
	g_node_traverse (self, G_POST_ORDER, G_TRAVERSE_ALL, -1, _g_node_destroy__build_msg_free0__node, NULL);
	g_node_destroy (self);
}


static void build_tool_runner_on_exit (BuildToolRunner* self, GPid pid, gint status) {
	guint* _tmp0_;
	gint _tmp0__length1;
	gboolean _tmp2_;
	PostProcessor* post_processor = NULL;
	BuildJob _tmp3_;
	PostProcessorType _tmp4_;
	PostProcessor* _tmp12_;
	gint _tmp13_;
	PostProcessor* _tmp14_;
	GFile* _tmp15_;
	const gchar* _tmp16_;
	BuildView* _tmp17_;
	GtkTreeIter* _tmp18_;
	gint _tmp18__length1;
	gint _tmp19_;
	GtkTreeIter _tmp20_;
	PostProcessor* _tmp21_;
	GNode* _tmp22_ = NULL;
	GNode* _tmp23_;
	PostProcessor* _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->handlers;
	_tmp0__length1 = self->priv->handlers_length1;
	{
		guint* handler_collection = NULL;
		gint handler_collection_length1 = 0;
		gint _handler_collection_size_ = 0;
		gint handler_it = 0;
		handler_collection = _tmp0_;
		handler_collection_length1 = _tmp0__length1;
		for (handler_it = 0; handler_it < _tmp0__length1; handler_it = handler_it + 1) {
			guint handler = 0U;
			handler = handler_collection[handler_it];
			{
				guint _tmp1_;
				_tmp1_ = handler;
				g_source_remove (_tmp1_);
			}
		}
	}
	_tmp2_ = self->priv->read_output;
	if (_tmp2_) {
		build_tool_runner_on_output (self);
	}
	_tmp3_ = self->priv->current_job;
	_tmp4_ = _tmp3_.post_processor;
	switch (_tmp4_) {
		case POST_PROCESSOR_TYPE_ALL_OUTPUT:
		{
			AllOutputPostProcessor* _tmp5_;
			_tmp5_ = all_output_post_processor_new ();
			_g_object_unref0 (post_processor);
			post_processor = (PostProcessor*) _tmp5_;
			break;
		}
		case POST_PROCESSOR_TYPE_LATEX:
		{
			LatexPostProcessor* _tmp6_;
			_tmp6_ = latex_post_processor_new ();
			_g_object_unref0 (post_processor);
			post_processor = (PostProcessor*) _tmp6_;
			break;
		}
		case POST_PROCESSOR_TYPE_LATEXMK:
		{
			gboolean _tmp7_;
			LatexmkPostProcessor* _tmp8_;
			_tmp7_ = self->priv->latexmk_show_all;
			_tmp8_ = latexmk_post_processor_new (_tmp7_);
			_g_object_unref0 (post_processor);
			post_processor = (PostProcessor*) _tmp8_;
			break;
		}
		case POST_PROCESSOR_TYPE_NO_OUTPUT:
		{
			NoOutputPostProcessor* _tmp9_;
			_tmp9_ = no_output_post_processor_new ();
			_g_object_unref0 (post_processor);
			post_processor = (PostProcessor*) _tmp9_;
			break;
		}
		case POST_PROCESSOR_TYPE_RUBBER:
		{
			RubberPostProcessor* _tmp10_;
			_tmp10_ = rubber_post_processor_new ();
			_g_object_unref0 (post_processor);
			post_processor = (PostProcessor*) _tmp10_;
			break;
		}
		default:
		{
			NoOutputPostProcessor* _tmp11_;
			g_warning ("build_tool_runner.vala:286: Unknown post processor. Use no-output.");
			_tmp11_ = no_output_post_processor_new ();
			_g_object_unref0 (post_processor);
			post_processor = (PostProcessor*) _tmp11_;
			break;
		}
	}
	_tmp12_ = post_processor;
	_tmp13_ = status;
	post_processor_set_status (_tmp12_, _tmp13_);
	_tmp14_ = post_processor;
	_tmp15_ = self->priv->file;
	_tmp16_ = self->priv->output;
	post_processor_process (_tmp14_, _tmp15_, _tmp16_);
	_tmp17_ = self->priv->view;
	_tmp18_ = self->priv->job_partitions;
	_tmp18__length1 = self->priv->job_partitions_length1;
	_tmp19_ = self->priv->job_num;
	_tmp20_ = _tmp18_[_tmp19_];
	_tmp21_ = post_processor;
	_tmp22_ = post_processor_get_messages (_tmp21_);
	_tmp23_ = _tmp22_;
	build_view_append_messages (_tmp17_, &_tmp20_, _tmp23_, TRUE);
	__g_node_destroy__build_msg_free0_0 (_tmp23_);
	_tmp24_ = post_processor;
	_tmp25_ = post_processor_get_successful (_tmp24_);
	_tmp26_ = _tmp25_;
	if (_tmp26_) {
		BuildView* _tmp27_;
		GtkTreeIter* _tmp28_;
		gint _tmp28__length1;
		gint _tmp29_;
		GtkTreeIter _tmp30_;
		gint _tmp31_;
		_tmp27_ = self->priv->view;
		_tmp28_ = self->priv->job_partitions;
		_tmp28__length1 = self->priv->job_partitions_length1;
		_tmp29_ = self->priv->job_num;
		_tmp30_ = _tmp28_[_tmp29_];
		build_view_set_partition_state (_tmp27_, &_tmp30_, PARTITION_STATE_SUCCEEDED);
		_tmp31_ = self->priv->job_num;
		self->priv->job_num = _tmp31_ + 1;
		build_tool_runner_proceed (self);
	} else {
		BuildView* _tmp32_;
		GtkTreeIter* _tmp33_;
		gint _tmp33__length1;
		gint _tmp34_;
		GtkTreeIter _tmp35_;
		BuildJob _tmp36_;
		gboolean _tmp37_;
		_tmp32_ = self->priv->view;
		_tmp33_ = self->priv->job_partitions;
		_tmp33__length1 = self->priv->job_partitions_length1;
		_tmp34_ = self->priv->job_num;
		_tmp35_ = _tmp33_[_tmp34_];
		build_view_set_partition_state (_tmp32_, &_tmp35_, PARTITION_STATE_FAILED);
		_tmp36_ = self->priv->current_job;
		_tmp37_ = _tmp36_.must_succeed;
		if (_tmp37_) {
			build_tool_runner_failed (self);
		} else {
			gint _tmp38_;
			_tmp38_ = self->priv->job_num;
			self->priv->job_num = _tmp38_ + 1;
			build_tool_runner_proceed (self);
		}
	}
	_g_object_unref0 (post_processor);
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static void build_tool_runner_proceed (BuildToolRunner* self) {
	gint _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp7_;
	GeeArrayList* _tmp8_;
	gint _tmp9_;
	gpointer _tmp10_ = NULL;
	BuildJob* _tmp11_;
	BuildJob _tmp12_ = {0};
	gchar** command = NULL;
	gint command_length1 = 0;
	gint _command_size_ = 0;
	gboolean _tmp18_ = FALSE;
	BuildJob _tmp19_;
	PostProcessorType _tmp20_;
	gboolean _tmp23_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->job_num;
	_tmp1_ = self->priv->jobs;
	_tmp2_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp0_ >= _tmp3_) {
		BuildView* _tmp4_;
		GtkTreeIter _tmp5_;
		GtkAction* _tmp6_;
		_tmp4_ = self->priv->view;
		_tmp5_ = self->priv->root_partition;
		build_view_set_partition_state (_tmp4_, &_tmp5_, PARTITION_STATE_SUCCEEDED);
		_tmp6_ = self->priv->action_stop_exec;
		gtk_action_set_sensitive (_tmp6_, FALSE);
		g_signal_emit_by_name (self, "finished");
		return;
	}
	_tmp7_ = g_strdup ("");
	_g_free0 (self->priv->output);
	self->priv->output = _tmp7_;
	_tmp8_ = self->priv->jobs;
	_tmp9_ = self->priv->job_num;
	_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
	_tmp11_ = (BuildJob*) _tmp10_;
	build_job_copy (_tmp11_, &_tmp12_);
	build_job_destroy (&self->priv->current_job);
	self->priv->current_job = _tmp12_;
	_build_job_free0 (_tmp11_);
	{
		BuildJob _tmp13_;
		const gchar* _tmp14_;
		gint _tmp15_ = 0;
		gchar** _tmp16_ = NULL;
		gchar** _tmp17_;
		gint _tmp17__length1;
		gint __tmp17__size_;
		_tmp13_ = self->priv->current_job;
		_tmp14_ = _tmp13_.command;
		_tmp16_ = build_tool_runner_get_command_args (self, _tmp14_, FALSE, &_tmp15_, &_inner_error_);
		_tmp17_ = _tmp16_;
		_tmp17__length1 = _tmp15_;
		__tmp17__size_ = _tmp17__length1;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SHELL_ERROR) {
				goto __catch11_g_shell_error;
			}
			command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
		command = _tmp17_;
		command_length1 = _tmp17__length1;
		_command_size_ = command_length1;
	}
	goto __finally11;
	__catch11_g_shell_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("build_tool_runner.vala:340: Separate command arguments worked the firs" \
"t time…");
		build_tool_runner_failed (self);
		_g_error_free0 (e);
		command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	__finally11:
	if (_inner_error_ != NULL) {
		command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp19_ = self->priv->current_job;
	_tmp20_ = _tmp19_.post_processor;
	if (_tmp20_ == POST_PROCESSOR_TYPE_RUBBER) {
		const gchar* _tmp21_;
		gboolean _tmp22_ = FALSE;
		_tmp21_ = self->priv->filename;
		_tmp22_ = string_contains (_tmp21_, " ");
		_tmp18_ = _tmp22_;
	} else {
		_tmp18_ = FALSE;
	}
	_tmp23_ = _tmp18_;
	if (_tmp23_) {
		BuildMsg message = {0};
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		BuildView* _tmp28_;
		GtkTreeIter* _tmp29_;
		gint _tmp29__length1;
		gint _tmp30_;
		GtkTreeIter _tmp31_;
		BuildMsg _tmp32_;
		GtkTreeIter _tmp33_ = {0};
		memset (&message, 0, sizeof (BuildMsg));
		_tmp24_ = _ ("Rubber may not support filenames with spaces (even in a directory)");
		_tmp25_ = g_strdup (_tmp24_);
		_g_free0 (message.text);
		message.text = _tmp25_;
		message.type = BUILD_MSG_TYPE_WARNING;
		_tmp26_ = self->priv->filename;
		_tmp27_ = g_strdup (_tmp26_);
		_g_free0 (message.filename);
		message.filename = _tmp27_;
		message.lines_set = FALSE;
		_tmp28_ = self->priv->view;
		_tmp29_ = self->priv->job_partitions;
		_tmp29__length1 = self->priv->job_partitions_length1;
		_tmp30_ = self->priv->job_num;
		_tmp31_ = _tmp29_[_tmp30_];
		_tmp32_ = message;
		build_view_append_single_message (_tmp28_, &_tmp31_, &_tmp32_, &_tmp33_);
		build_msg_destroy (&message);
	}
	{
		BuildJob _tmp34_;
		PostProcessorType _tmp35_;
		_tmp34_ = self->priv->current_job;
		_tmp35_ = _tmp34_.post_processor;
		if (_tmp35_ == POST_PROCESSOR_TYPE_NO_OUTPUT) {
			gchar** _tmp36_;
			gint _tmp36__length1;
			const gchar* _tmp37_;
			_tmp36_ = command;
			_tmp36__length1 = command_length1;
			_tmp37_ = self->priv->directory;
			build_tool_runner_execute_without_output (self, _tmp36_, _tmp36__length1, _tmp37_, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch12_g_error;
			}
		} else {
			gchar** _tmp38_;
			gint _tmp38__length1;
			const gchar* _tmp39_;
			_tmp38_ = command;
			_tmp38__length1 = command_length1;
			_tmp39_ = self->priv->directory;
			build_tool_runner_execute (self, _tmp38_, _tmp38__length1, _tmp39_, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch12_g_error;
			}
		}
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		BuildView* _tmp40_;
		GtkTreeIter* _tmp41_;
		gint _tmp41__length1;
		gint _tmp42_;
		GtkTreeIter _tmp43_;
		BuildMsg error_msg = {0};
		GError* _tmp44_;
		const gchar* _tmp45_;
		gchar* _tmp46_;
		BuildView* _tmp47_;
		GtkTreeIter* _tmp48_;
		gint _tmp48__length1;
		gint _tmp49_;
		GtkTreeIter _tmp50_;
		BuildMsg _tmp51_;
		GtkTreeIter _tmp52_ = {0};
		GError* _tmp53_;
		BuildJob _tmp64_;
		gboolean _tmp65_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp40_ = self->priv->view;
		_tmp41_ = self->priv->job_partitions;
		_tmp41__length1 = self->priv->job_partitions_length1;
		_tmp42_ = self->priv->job_num;
		_tmp43_ = _tmp41_[_tmp42_];
		build_view_set_partition_state (_tmp40_, &_tmp43_, PARTITION_STATE_FAILED);
		memset (&error_msg, 0, sizeof (BuildMsg));
		_tmp44_ = e;
		_tmp45_ = _tmp44_->message;
		_tmp46_ = g_strdup (_tmp45_);
		_g_free0 (error_msg.text);
		error_msg.text = _tmp46_;
		error_msg.type = BUILD_MSG_TYPE_ERROR;
		error_msg.lines_set = FALSE;
		_tmp47_ = self->priv->view;
		_tmp48_ = self->priv->job_partitions;
		_tmp48__length1 = self->priv->job_partitions_length1;
		_tmp49_ = self->priv->job_num;
		_tmp50_ = _tmp48_[_tmp49_];
		_tmp51_ = error_msg;
		build_view_append_single_message (_tmp47_, &_tmp50_, &_tmp51_, &_tmp52_);
		_tmp53_ = e;
		if (g_error_matches (_tmp53_, G_SPAWN_ERROR, G_SPAWN_ERROR_NOENT)) {
			BuildMsg info_msg = {0};
			const gchar* _tmp54_ = NULL;
			gchar** _tmp55_;
			gint _tmp55__length1;
			const gchar* _tmp56_;
			gchar* _tmp57_ = NULL;
			BuildView* _tmp58_;
			GtkTreeIter* _tmp59_;
			gint _tmp59__length1;
			gint _tmp60_;
			GtkTreeIter _tmp61_;
			BuildMsg _tmp62_;
			GtkTreeIter _tmp63_ = {0};
			memset (&info_msg, 0, sizeof (BuildMsg));
			_tmp54_ = _ ("%s doesn't seem to be installed.");
			_tmp55_ = command;
			_tmp55__length1 = command_length1;
			_tmp56_ = _tmp55_[0];
			_tmp57_ = g_strdup_printf (_tmp54_, _tmp56_);
			_g_free0 (info_msg.text);
			info_msg.text = _tmp57_;
			info_msg.type = BUILD_MSG_TYPE_OTHER;
			info_msg.lines_set = FALSE;
			_tmp58_ = self->priv->view;
			_tmp59_ = self->priv->job_partitions;
			_tmp59__length1 = self->priv->job_partitions_length1;
			_tmp60_ = self->priv->job_num;
			_tmp61_ = _tmp59_[_tmp60_];
			_tmp62_ = info_msg;
			build_view_append_single_message (_tmp58_, &_tmp61_, &_tmp62_, &_tmp63_);
			build_msg_destroy (&info_msg);
		}
		_tmp64_ = self->priv->current_job;
		_tmp65_ = _tmp64_.must_succeed;
		if (_tmp65_) {
			build_tool_runner_failed (self);
		} else {
			gint _tmp66_;
			_tmp66_ = self->priv->job_num;
			self->priv->job_num = _tmp66_ + 1;
			build_tool_runner_proceed (self);
		}
		build_msg_destroy (&error_msg);
		_g_error_free0 (e);
	}
	__finally12:
	if (_inner_error_ != NULL) {
		command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch14_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch14_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally14;
	__catch14_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally14:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gchar** build_tool_runner_get_command_args (BuildToolRunner* self, const gchar* command_line, gboolean for_printing, int* result_length1, GError** error) {
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gchar** command;
	gint command_length1;
	gint _command_size_;
	gboolean _tmp8_;
	GFile* _tmp27_;
	gchar* _tmp28_ = NULL;
	gchar* base_filename;
	const gchar* _tmp29_;
	gchar* _tmp30_ = NULL;
	gchar* base_shortname;
	gchar** _tmp72_;
	gint _tmp72__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (command_line != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	command = _tmp0_;
	command_length1 = 0;
	_command_size_ = command_length1;
	{
		const gchar* _tmp1_;
		gchar** _tmp2_ = NULL;
		gint _tmp3_ = 0;
		_tmp1_ = command_line;
		g_shell_parse_argv (_tmp1_, &_tmp3_, &_tmp2_, &_inner_error_);
		command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
		command = _tmp2_;
		command_length1 = _tmp3_;
		_command_size_ = command_length1;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SHELL_ERROR) {
				goto __catch13_g_shell_error;
			}
			command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	goto __finally13;
	__catch13_g_shell_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		GError* _tmp6_;
		GError* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("build_tool_runner.vala:410: Separate command arguments: %s", _tmp5_);
		_tmp6_ = e;
		_tmp7_ = _g_error_copy0 (_tmp6_);
		_inner_error_ = _tmp7_;
		_g_error_free0 (e);
		goto __finally13;
	}
	__finally13:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_SHELL_ERROR) {
			g_propagate_error (error, _inner_error_);
			command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		} else {
			command = (_vala_array_free (command, command_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp8_ = for_printing;
	if (_tmp8_) {
		{
			gint cmd_num;
			cmd_num = 0;
			{
				gboolean _tmp9_;
				_tmp9_ = TRUE;
				while (TRUE) {
					gboolean _tmp10_;
					gint _tmp12_;
					gchar** _tmp13_;
					gint _tmp13__length1;
					gchar** _tmp14_;
					gint _tmp14__length1;
					gint _tmp15_;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* cur_cmd;
					const gchar* _tmp18_;
					gboolean _tmp19_ = FALSE;
					_tmp10_ = _tmp9_;
					if (!_tmp10_) {
						gint _tmp11_;
						_tmp11_ = cmd_num;
						cmd_num = _tmp11_ + 1;
					}
					_tmp9_ = FALSE;
					_tmp12_ = cmd_num;
					_tmp13_ = command;
					_tmp13__length1 = command_length1;
					if (!(_tmp12_ < _tmp13__length1)) {
						break;
					}
					_tmp14_ = command;
					_tmp14__length1 = command_length1;
					_tmp15_ = cmd_num;
					_tmp16_ = _tmp14_[_tmp15_];
					_tmp17_ = g_strdup (_tmp16_);
					cur_cmd = _tmp17_;
					_tmp18_ = cur_cmd;
					_tmp19_ = string_contains (_tmp18_, " ");
					if (_tmp19_) {
						gchar** _tmp20_;
						gint _tmp20__length1;
						gint _tmp21_;
						const gchar* _tmp22_;
						gchar* _tmp23_;
						gchar* _tmp24_;
						gchar* _tmp25_;
						gchar* _tmp26_;
						_tmp20_ = command;
						_tmp20__length1 = command_length1;
						_tmp21_ = cmd_num;
						_tmp22_ = cur_cmd;
						_tmp23_ = g_strconcat ("\"", _tmp22_, NULL);
						_tmp24_ = _tmp23_;
						_tmp25_ = g_strconcat (_tmp24_, "\"", NULL);
						_g_free0 (_tmp20_[_tmp21_]);
						_tmp20_[_tmp21_] = _tmp25_;
						_tmp26_ = _tmp20_[_tmp21_];
						_g_free0 (_tmp24_);
					}
					_g_free0 (cur_cmd);
				}
			}
		}
	}
	_tmp27_ = self->priv->file;
	_tmp28_ = g_file_get_basename (_tmp27_);
	base_filename = _tmp28_;
	_tmp29_ = base_filename;
	_tmp30_ = utils_get_shortname (_tmp29_);
	base_shortname = _tmp30_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp31_;
			_tmp31_ = TRUE;
			while (TRUE) {
				gboolean _tmp32_;
				gint _tmp34_;
				gchar** _tmp35_;
				gint _tmp35__length1;
				gchar** _tmp36_;
				gint _tmp36__length1;
				gint _tmp37_;
				const gchar* _tmp38_;
				gboolean _tmp39_ = FALSE;
				gchar** _tmp48_;
				gint _tmp48__length1;
				gint _tmp49_;
				const gchar* _tmp50_;
				gboolean _tmp51_ = FALSE;
				gchar** _tmp60_;
				gint _tmp60__length1;
				gint _tmp61_;
				const gchar* _tmp62_;
				gboolean _tmp63_ = FALSE;
				_tmp32_ = _tmp31_;
				if (!_tmp32_) {
					gint _tmp33_;
					_tmp33_ = i;
					i = _tmp33_ + 1;
				}
				_tmp31_ = FALSE;
				_tmp34_ = i;
				_tmp35_ = command;
				_tmp35__length1 = command_length1;
				if (!(_tmp34_ < _tmp35__length1)) {
					break;
				}
				_tmp36_ = command;
				_tmp36__length1 = command_length1;
				_tmp37_ = i;
				_tmp38_ = _tmp36_[_tmp37_];
				_tmp39_ = string_contains (_tmp38_, "$view");
				if (_tmp39_) {
					gchar** _tmp40_;
					gint _tmp40__length1;
					gint _tmp41_;
					gchar** _tmp42_;
					gint _tmp42__length1;
					gint _tmp43_;
					const gchar* _tmp44_;
					const gchar* _tmp45_;
					gchar* _tmp46_ = NULL;
					gchar* _tmp47_;
					_tmp40_ = command;
					_tmp40__length1 = command_length1;
					_tmp41_ = i;
					_tmp42_ = command;
					_tmp42__length1 = command_length1;
					_tmp43_ = i;
					_tmp44_ = _tmp42_[_tmp43_];
					_tmp45_ = self->priv->document_view_program;
					_tmp46_ = string_replace (_tmp44_, "$view", _tmp45_);
					_g_free0 (_tmp40_[_tmp41_]);
					_tmp40_[_tmp41_] = _tmp46_;
					_tmp47_ = _tmp40_[_tmp41_];
					continue;
				}
				_tmp48_ = command;
				_tmp48__length1 = command_length1;
				_tmp49_ = i;
				_tmp50_ = _tmp48_[_tmp49_];
				_tmp51_ = string_contains (_tmp50_, "$filename");
				if (_tmp51_) {
					gchar** _tmp52_;
					gint _tmp52__length1;
					gint _tmp53_;
					gchar** _tmp54_;
					gint _tmp54__length1;
					gint _tmp55_;
					const gchar* _tmp56_;
					const gchar* _tmp57_;
					gchar* _tmp58_ = NULL;
					gchar* _tmp59_;
					_tmp52_ = command;
					_tmp52__length1 = command_length1;
					_tmp53_ = i;
					_tmp54_ = command;
					_tmp54__length1 = command_length1;
					_tmp55_ = i;
					_tmp56_ = _tmp54_[_tmp55_];
					_tmp57_ = base_filename;
					_tmp58_ = string_replace (_tmp56_, "$filename", _tmp57_);
					_g_free0 (_tmp52_[_tmp53_]);
					_tmp52_[_tmp53_] = _tmp58_;
					_tmp59_ = _tmp52_[_tmp53_];
					continue;
				}
				_tmp60_ = command;
				_tmp60__length1 = command_length1;
				_tmp61_ = i;
				_tmp62_ = _tmp60_[_tmp61_];
				_tmp63_ = string_contains (_tmp62_, "$shortname");
				if (_tmp63_) {
					gchar** _tmp64_;
					gint _tmp64__length1;
					gint _tmp65_;
					gchar** _tmp66_;
					gint _tmp66__length1;
					gint _tmp67_;
					const gchar* _tmp68_;
					const gchar* _tmp69_;
					gchar* _tmp70_ = NULL;
					gchar* _tmp71_;
					_tmp64_ = command;
					_tmp64__length1 = command_length1;
					_tmp65_ = i;
					_tmp66_ = command;
					_tmp66__length1 = command_length1;
					_tmp67_ = i;
					_tmp68_ = _tmp66_[_tmp67_];
					_tmp69_ = base_shortname;
					_tmp70_ = string_replace (_tmp68_, "$shortname", _tmp69_);
					_g_free0 (_tmp64_[_tmp65_]);
					_tmp64_[_tmp65_] = _tmp70_;
					_tmp71_ = _tmp64_[_tmp65_];
					continue;
				}
			}
		}
	}
	_tmp72_ = command;
	_tmp72__length1 = command_length1;
	if (result_length1) {
		*result_length1 = _tmp72__length1;
	}
	result = _tmp72_;
	_g_free0 (base_shortname);
	_g_free0 (base_filename);
	return result;
}


static void build_tool_runner_failed (BuildToolRunner* self) {
	BuildView* _tmp0_;
	GtkTreeIter _tmp1_;
	GtkAction* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->view;
	_tmp1_ = self->priv->root_partition;
	build_view_set_partition_state (_tmp0_, &_tmp1_, PARTITION_STATE_FAILED);
	{
		gint _tmp2_;
		gint i;
		_tmp2_ = self->priv->job_num;
		i = _tmp2_ + 1;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gint _tmp6_;
				GtkTreeIter* _tmp7_;
				gint _tmp7__length1;
				BuildView* _tmp8_;
				GtkTreeIter* _tmp9_;
				gint _tmp9__length1;
				gint _tmp10_;
				GtkTreeIter _tmp11_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = self->priv->job_partitions;
				_tmp7__length1 = self->priv->job_partitions_length1;
				if (!(_tmp6_ < _tmp7__length1)) {
					break;
				}
				_tmp8_ = self->priv->view;
				_tmp9_ = self->priv->job_partitions;
				_tmp9__length1 = self->priv->job_partitions_length1;
				_tmp10_ = i;
				_tmp11_ = _tmp9_[_tmp10_];
				build_view_set_partition_state (_tmp8_, &_tmp11_, PARTITION_STATE_ABORTED);
			}
		}
	}
	_tmp12_ = self->priv->action_stop_exec;
	gtk_action_set_sensitive (_tmp12_, FALSE);
}


static void build_tool_runner_class_init (BuildToolRunnerClass * klass) {
	build_tool_runner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BuildToolRunnerPrivate));
	G_OBJECT_CLASS (klass)->finalize = build_tool_runner_finalize;
	g_signal_new ("finished", TYPE_BUILD_TOOL_RUNNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void build_tool_runner_instance_init (BuildToolRunner * self) {
	guint* _tmp0_ = NULL;
	gchar* _tmp1_;
	self->priv = BUILD_TOOL_RUNNER_GET_PRIVATE (self);
	self->priv->child_pid = NULL;
	_tmp0_ = g_new0 (guint, 0);
	self->priv->handlers = _tmp0_;
	self->priv->handlers_length1 = 0;
	self->priv->_handlers_size_ = self->priv->handlers_length1;
	self->priv->read_output = TRUE;
	_tmp1_ = g_strdup ("");
	self->priv->output = _tmp1_;
	self->priv->job_num = 0;
}


static void build_tool_runner_finalize (GObject* obj) {
	BuildToolRunner * self;
	self = BUILD_TOOL_RUNNER (obj);
	_g_free0 (self->priv->child_pid);
	self->priv->handlers = (g_free (self->priv->handlers), NULL);
	_g_io_channel_unref0 (self->priv->out_channel);
	_g_free0 (self->priv->output);
	_g_object_unref0 (self->priv->view);
	_g_free0 (self->priv->document_view_program);
	_g_object_unref0 (self->priv->action_stop_exec);
	_g_object_unref0 (self->priv->file);
	_g_free0 (self->priv->filename);
	_g_free0 (self->priv->shortname);
	_g_free0 (self->priv->directory);
	build_job_destroy (&self->priv->current_job);
	self->priv->job_partitions = (g_free (self->priv->job_partitions), NULL);
	G_OBJECT_CLASS (build_tool_runner_parent_class)->finalize (obj);
}


GType build_tool_runner_get_type (void) {
	static volatile gsize build_tool_runner_type_id__volatile = 0;
	if (g_once_init_enter (&build_tool_runner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BuildToolRunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) build_tool_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuildToolRunner), 0, (GInstanceInitFunc) build_tool_runner_instance_init, NULL };
		GType build_tool_runner_type_id;
		build_tool_runner_type_id = g_type_register_static (G_TYPE_OBJECT, "BuildToolRunner", &g_define_type_info, 0);
		g_once_init_leave (&build_tool_runner_type_id__volatile, build_tool_runner_type_id);
	}
	return build_tool_runner_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



