/* most_used_symbols.c generated by valac 0.12.1, the Vala compiler
 * generated from most_used_symbols.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>


#define TYPE_MOST_USED_SYMBOL (most_used_symbol_get_type ())
typedef struct _MostUsedSymbol MostUsedSymbol;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_MOST_USED_SYMBOLS (most_used_symbols_get_type ())
#define MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbols))
#define MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))
#define IS_MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOST_USED_SYMBOLS))
#define IS_MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOST_USED_SYMBOLS))
#define MOST_USED_SYMBOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))

typedef struct _MostUsedSymbols MostUsedSymbols;
typedef struct _MostUsedSymbolsClass MostUsedSymbolsClass;
typedef struct _MostUsedSymbolsPrivate MostUsedSymbolsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_markup_parse_context_free0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _most_used_symbol_free0(var) ((var == NULL) ? NULL : (var = (most_used_symbol_free (var), NULL)))

struct _MostUsedSymbol {
	gchar* id;
	gchar* latex_command;
	gchar* package_required;
	guint num;
};

struct _MostUsedSymbols {
	GObject parent_instance;
	MostUsedSymbolsPrivate * priv;
};

struct _MostUsedSymbolsClass {
	GObjectClass parent_class;
};

struct _MostUsedSymbolsPrivate {
	GeeLinkedList* most_used_symbols;
	gboolean modified;
	GSettings* settings;
};


static gpointer most_used_symbols_parent_class = NULL;
static MostUsedSymbols* most_used_symbols_instance;
static MostUsedSymbols* most_used_symbols_instance = NULL;

GType most_used_symbol_get_type (void) G_GNUC_CONST;
MostUsedSymbol* most_used_symbol_dup (const MostUsedSymbol* self);
void most_used_symbol_free (MostUsedSymbol* self);
void most_used_symbol_copy (const MostUsedSymbol* self, MostUsedSymbol* dest);
void most_used_symbol_destroy (MostUsedSymbol* self);
GType most_used_symbols_get_type (void) G_GNUC_CONST;
#define MOST_USED_SYMBOLS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsPrivate))
enum  {
	MOST_USED_SYMBOLS_DUMMY_PROPERTY
};
static MostUsedSymbols* most_used_symbols_new (void);
static MostUsedSymbols* most_used_symbols_construct (GType object_type);
static GFile* most_used_symbols_get_xml_file (MostUsedSymbols* self);
static void most_used_symbols_parser_start (MostUsedSymbols* self, GMarkupParseContext* context, const gchar* name, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error);
static void _most_used_symbols_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error);
MostUsedSymbols* most_used_symbols_get_default (void);
GeeIterator* most_used_symbols_iterator (MostUsedSymbols* self);
void most_used_symbols_clear (MostUsedSymbols* self);
void most_used_symbols_add_symbol (MostUsedSymbols* self, const gchar* id, const gchar* command, const gchar* package);
static gint most_used_symbols_sort (MostUsedSymbols* self, gint index, MostUsedSymbol* mus);
void symbols_remove_most_used_symbol (gint index);
void symbols_insert_most_used_symbol (gint index, MostUsedSymbol* symbol);
void symbols_swap_most_used_symbol (gint current_index, gint new_index);
void most_used_symbols_save (MostUsedSymbols* self);
void utils_delete_file (GFile* file);
static void most_used_symbols_finalize (GObject* obj);
static gint _vala_array_length (gpointer array);


void most_used_symbol_copy (const MostUsedSymbol* self, MostUsedSymbol* dest) {
	dest->id = g_strdup (self->id);
	dest->latex_command = g_strdup (self->latex_command);
	dest->package_required = g_strdup (self->package_required);
	dest->num = self->num;
}


void most_used_symbol_destroy (MostUsedSymbol* self) {
	_g_free0 ((*self).id);
	_g_free0 ((*self).latex_command);
	_g_free0 ((*self).package_required);
}


MostUsedSymbol* most_used_symbol_dup (const MostUsedSymbol* self) {
	MostUsedSymbol* dup;
	dup = g_new0 (MostUsedSymbol, 1);
	most_used_symbol_copy (self, dup);
	return dup;
}


void most_used_symbol_free (MostUsedSymbol* self) {
	most_used_symbol_destroy (self);
	g_free (self);
}


GType most_used_symbol_get_type (void) {
	static volatile gsize most_used_symbol_type_id__volatile = 0;
	if (g_once_init_enter (&most_used_symbol_type_id__volatile)) {
		GType most_used_symbol_type_id;
		most_used_symbol_type_id = g_boxed_type_register_static ("MostUsedSymbol", (GBoxedCopyFunc) most_used_symbol_dup, (GBoxedFreeFunc) most_used_symbol_free);
		g_once_init_leave (&most_used_symbol_type_id__volatile, most_used_symbol_type_id);
	}
	return most_used_symbol_type_id__volatile;
}


static void _most_used_symbols_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error) {
	most_used_symbols_parser_start (self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
}


static MostUsedSymbols* most_used_symbols_construct (GType object_type) {
	MostUsedSymbols * self = NULL;
	GeeLinkedList* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* file;
	gboolean _tmp3_;
	gchar* contents = NULL;
	gchar* _tmp4_ = NULL;
	GMarkupParser _tmp5_ = {0};
	GMarkupParser parser;
	GMarkupParseContext* _tmp6_ = NULL;
	GMarkupParseContext* context;
	GError * _inner_error_ = NULL;
	self = (MostUsedSymbols*) g_object_new (object_type, NULL);
	_tmp0_ = gee_linked_list_new (TYPE_MOST_USED_SYMBOL, (GBoxedCopyFunc) most_used_symbol_dup, most_used_symbol_free, NULL);
	_g_object_unref0 (self->priv->most_used_symbols);
	self->priv->most_used_symbols = _tmp0_;
	_tmp1_ = g_settings_new ("org.gnome.latexila.preferences.editor");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	_tmp2_ = most_used_symbols_get_xml_file (self);
	file = _tmp2_;
	_tmp3_ = g_file_query_exists (file, NULL);
	if (!_tmp3_) {
		_g_object_unref0 (file);
		return self;
	}
	g_file_load_contents (file, NULL, &_tmp4_, NULL, NULL, &_inner_error_);
	_g_free0 (contents);
	contents = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_free0 (contents);
		goto __catch49_g_error;
	}
	_tmp5_.start_element = _most_used_symbols_parser_start_gmarkup_parser_start_element_func;
	_tmp5_.end_element = NULL;
	_tmp5_.text = NULL;
	_tmp5_.passthrough = NULL;
	_tmp5_.error = NULL;
	parser = _tmp5_;
	_tmp6_ = g_markup_parse_context_new (&parser, 0, self, NULL);
	context = _tmp6_;
	g_markup_parse_context_parse (context, contents, (gssize) (-1), &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_markup_parse_context_free0 (context);
		_g_free0 (contents);
		goto __catch49_g_error;
	}
	_g_markup_parse_context_free0 (context);
	_g_free0 (contents);
	goto __finally49;
	__catch49_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("most_used_symbols.vala:59: Impossible to load the most used symbols: %" \
"s", e->message);
		_g_error_free0 (e);
	}
	__finally49:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (file);
	return self;
}


static MostUsedSymbols* most_used_symbols_new (void) {
	return most_used_symbols_construct (TYPE_MOST_USED_SYMBOLS);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


MostUsedSymbols* most_used_symbols_get_default (void) {
	MostUsedSymbols* result = NULL;
	MostUsedSymbols* _tmp1_;
	if (most_used_symbols_instance == NULL) {
		MostUsedSymbols* _tmp0_ = NULL;
		_tmp0_ = most_used_symbols_new ();
		_g_object_unref0 (most_used_symbols_instance);
		most_used_symbols_instance = _tmp0_;
	}
	_tmp1_ = _g_object_ref0 (most_used_symbols_instance);
	result = _tmp1_;
	return result;
}


GeeIterator* most_used_symbols_iterator (MostUsedSymbols* self) {
	GeeIterator* result = NULL;
	guint max = 0U;
	gint _tmp0_;
	gint _tmp1_;
	gint slice_max;
	GeeList* _tmp2_ = NULL;
	GeeList* slice;
	GeeIterator* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_settings_get (self->priv->settings, "nb-most-used-symbols", "u", &max);
	_tmp0_ = gee_collection_get_size ((GeeCollection*) self->priv->most_used_symbols);
	_tmp1_ = MIN ((gint) max, _tmp0_);
	slice_max = _tmp1_;
	_tmp2_ = gee_abstract_list_slice ((GeeAbstractList*) self->priv->most_used_symbols, 0, slice_max);
	slice = _tmp2_;
	_tmp3_ = gee_iterable_iterator ((GeeIterable*) slice);
	result = GEE_ITERATOR (_tmp3_);
	_g_object_unref0 (slice);
	return result;
}


void most_used_symbols_clear (MostUsedSymbols* self) {
	g_return_if_fail (self != NULL);
	self->priv->modified = TRUE;
	gee_abstract_collection_clear ((GeeAbstractCollection*) self->priv->most_used_symbols);
}


void most_used_symbols_add_symbol (MostUsedSymbols* self, const gchar* id, const gchar* command, const gchar* package) {
	guint max = 0U;
	gint i;
	MostUsedSymbol new_symbol = {0};
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gint _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (command != NULL);
	self->priv->modified = TRUE;
	g_settings_get (self->priv->settings, "nb-most-used-symbols", "u", &max);
	i = 0;
	{
		GeeLinkedList* _tmp0_;
		GeeLinkedList* _mus_list;
		gint _tmp1_;
		gint _mus_size;
		gint _mus_index;
		_tmp0_ = _g_object_ref0 (self->priv->most_used_symbols);
		_mus_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _mus_list);
		_mus_size = _tmp1_;
		_mus_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			MostUsedSymbol* _tmp3_;
			MostUsedSymbol _tmp4_;
			MostUsedSymbol _tmp5_ = {0};
			MostUsedSymbol _tmp6_;
			MostUsedSymbol mus;
			_mus_index = _mus_index + 1;
			if (!(_mus_index < _mus_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _mus_list, _mus_index);
			_tmp3_ = (MostUsedSymbol*) _tmp2_;
			most_used_symbol_copy (_tmp3_, &_tmp5_);
			_tmp4_ = _tmp5_;
			_tmp6_ = _tmp4_;
			_most_used_symbol_free0 (_tmp3_);
			mus = _tmp6_;
			if (g_strcmp0 (mus.id, id) == 0) {
				gint _tmp7_;
				gint new_i;
				gboolean _tmp8_ = FALSE;
				mus.num++;
				_tmp7_ = most_used_symbols_sort (self, i, &mus);
				new_i = _tmp7_;
				if (new_i != i) {
					_tmp8_ = new_i < max;
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					if (i >= max) {
						symbols_remove_most_used_symbol (((gint) max) - 1);
						symbols_insert_most_used_symbol (new_i, &mus);
					} else {
						symbols_swap_most_used_symbol (i, new_i);
					}
				}
				most_used_symbol_destroy (&mus);
				_g_object_unref0 (_mus_list);
				return;
			}
			i++;
			most_used_symbol_destroy (&mus);
		}
		_g_object_unref0 (_mus_list);
	}
	memset (&new_symbol, 0, sizeof (MostUsedSymbol));
	_tmp9_ = g_strdup (id);
	_g_free0 (new_symbol.id);
	new_symbol.id = _tmp9_;
	_tmp10_ = g_strdup (command);
	_g_free0 (new_symbol.latex_command);
	new_symbol.latex_command = _tmp10_;
	_tmp11_ = g_strdup (package);
	_g_free0 (new_symbol.package_required);
	new_symbol.package_required = _tmp11_;
	new_symbol.num = (guint) 1;
	gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->most_used_symbols, &new_symbol);
	_tmp12_ = gee_collection_get_size ((GeeCollection*) self->priv->most_used_symbols);
	if (_tmp12_ <= max) {
		gint _tmp13_;
		_tmp13_ = gee_collection_get_size ((GeeCollection*) self->priv->most_used_symbols);
		symbols_insert_most_used_symbol (_tmp13_ - 1, &new_symbol);
	}
	most_used_symbol_destroy (&new_symbol);
}


static gint most_used_symbols_sort (MostUsedSymbols* self, gint index, MostUsedSymbol* mus) {
	gint result = 0;
	gint new_index = 0;
	g_return_val_if_fail (self != NULL, 0);
	if (index == 0) {
		gee_abstract_list_set ((GeeAbstractList*) self->priv->most_used_symbols, index, mus);
		result = 0;
		return result;
	}
	{
		gboolean _tmp0_;
		new_index = index - 1;
		_tmp0_ = TRUE;
		while (TRUE) {
			gpointer _tmp1_ = NULL;
			MostUsedSymbol* _tmp2_;
			MostUsedSymbol _tmp3_;
			MostUsedSymbol _tmp4_ = {0};
			MostUsedSymbol _tmp5_;
			MostUsedSymbol symbol;
			if (!_tmp0_) {
				new_index--;
			}
			_tmp0_ = FALSE;
			if (!(new_index >= 0)) {
				break;
			}
			_tmp1_ = gee_abstract_list_get ((GeeAbstractList*) self->priv->most_used_symbols, new_index);
			_tmp2_ = (MostUsedSymbol*) _tmp1_;
			most_used_symbol_copy (_tmp2_, &_tmp4_);
			_tmp3_ = _tmp4_;
			_tmp5_ = _tmp3_;
			_most_used_symbol_free0 (_tmp2_);
			symbol = _tmp5_;
			if (symbol.num >= (*mus).num) {
				new_index++;
				most_used_symbol_destroy (&symbol);
				break;
			}
			most_used_symbol_destroy (&symbol);
		}
	}
	if (new_index < 0) {
		new_index = 0;
	}
	if (new_index < index) {
		gpointer _tmp6_ = NULL;
		MostUsedSymbol* _tmp7_;
		_tmp6_ = gee_abstract_list_remove_at ((GeeAbstractList*) self->priv->most_used_symbols, index);
		_tmp7_ = (MostUsedSymbol*) _tmp6_;
		_most_used_symbol_free0 (_tmp7_);
		gee_abstract_list_insert ((GeeAbstractList*) self->priv->most_used_symbols, new_index, mus);
	} else {
		gee_abstract_list_set ((GeeAbstractList*) self->priv->most_used_symbols, index, mus);
	}
	result = new_index;
	return result;
}


static void most_used_symbols_parser_start (MostUsedSymbols* self, GMarkupParseContext* context, const gchar* name, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error) {
	const gchar* _tmp0_;
	GQuark _tmp1_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("symbols")))) {
		switch (0) {
			default:
			{
				return;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("symbol")))) {
		switch (0) {
			default:
			{
				MostUsedSymbol symbol = {0};
				memset (&symbol, 0, sizeof (MostUsedSymbol));
				{
					gint i;
					i = 0;
					{
						gboolean _tmp2_;
						_tmp2_ = TRUE;
						while (TRUE) {
							const gchar* _tmp3_;
							GQuark _tmp4_;
							static GQuark _tmp4__label0 = 0;
							static GQuark _tmp4__label1 = 0;
							static GQuark _tmp4__label2 = 0;
							static GQuark _tmp4__label3 = 0;
							if (!_tmp2_) {
								i++;
							}
							_tmp2_ = FALSE;
							if (!(i < attr_names_length1)) {
								break;
							}
							_tmp3_ = attr_names[i];
							_tmp4_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
							if (_tmp4_ == ((0 != _tmp4__label0) ? _tmp4__label0 : (_tmp4__label0 = g_quark_from_static_string ("id")))) {
								switch (0) {
									default:
									{
										gchar* _tmp5_;
										_tmp5_ = g_strdup (attr_values[i]);
										_g_free0 (symbol.id);
										symbol.id = _tmp5_;
										break;
									}
								}
							} else if (_tmp4_ == ((0 != _tmp4__label1) ? _tmp4__label1 : (_tmp4__label1 = g_quark_from_static_string ("command")))) {
								switch (0) {
									default:
									{
										gchar* _tmp6_;
										_tmp6_ = g_strdup (attr_values[i]);
										_g_free0 (symbol.latex_command);
										symbol.latex_command = _tmp6_;
										break;
									}
								}
							} else if (_tmp4_ == ((0 != _tmp4__label2) ? _tmp4__label2 : (_tmp4__label2 = g_quark_from_static_string ("package")))) {
								switch (0) {
									default:
									{
										const gchar* _tmp7_ = NULL;
										gchar* _tmp8_;
										if (g_strcmp0 (attr_values[i], "") != 0) {
											_tmp7_ = attr_values[i];
										} else {
											_tmp7_ = NULL;
										}
										_tmp8_ = g_strdup (_tmp7_);
										_g_free0 (symbol.package_required);
										symbol.package_required = _tmp8_;
										break;
									}
								}
							} else if (_tmp4_ == ((0 != _tmp4__label3) ? _tmp4__label3 : (_tmp4__label3 = g_quark_from_static_string ("num")))) {
								switch (0) {
									default:
									{
										gint _tmp9_;
										_tmp9_ = atoi (attr_values[i]);
										symbol.num = (guint) _tmp9_;
										break;
									}
								}
							} else {
								switch (0) {
									default:
									{
										gchar* _tmp10_;
										gchar* _tmp11_;
										gchar* _tmp12_;
										gchar* _tmp13_;
										GError* _tmp14_ = NULL;
										GError* _tmp15_;
										_tmp10_ = g_strconcat ("unknown attribute \"", attr_names[i], NULL);
										_tmp11_ = _tmp10_;
										_tmp12_ = g_strconcat (_tmp11_, "\"", NULL);
										_tmp13_ = _tmp12_;
										_tmp14_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp13_);
										_tmp15_ = _tmp14_;
										_g_free0 (_tmp13_);
										_g_free0 (_tmp11_);
										_inner_error_ = _tmp15_;
										if (_inner_error_->domain == G_MARKUP_ERROR) {
											g_propagate_error (error, _inner_error_);
											most_used_symbol_destroy (&symbol);
											return;
										} else {
											most_used_symbol_destroy (&symbol);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
											g_clear_error (&_inner_error_);
											return;
										}
									}
								}
							}
						}
					}
				}
				gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->most_used_symbols, &symbol);
				most_used_symbol_destroy (&symbol);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				GError* _tmp20_ = NULL;
				GError* _tmp21_;
				_tmp16_ = g_strconcat ("unknown element \"", name, NULL);
				_tmp17_ = _tmp16_;
				_tmp18_ = g_strconcat (_tmp17_, "\"", NULL);
				_tmp19_ = _tmp18_;
				_tmp20_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ELEMENT, _tmp19_);
				_tmp21_ = _tmp20_;
				_g_free0 (_tmp19_);
				_g_free0 (_tmp17_);
				_inner_error_ = _tmp21_;
				if (_inner_error_->domain == G_MARKUP_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static GFile* most_used_symbols_get_xml_file (MostUsedSymbols* self) {
	GFile* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* path;
	GFile* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "latexila", "most_used_symbols.xml", NULL, NULL);
	path = _tmp1_;
	_tmp2_ = g_file_new_for_path (path);
	result = _tmp2_;
	_g_free0 (path);
	return result;
}


void most_used_symbols_save (MostUsedSymbols* self) {
	GFile* _tmp0_ = NULL;
	GFile* file;
	gint _tmp1_;
	gchar* _tmp2_;
	gchar* content;
	gchar* _tmp16_;
	GFile* _tmp17_ = NULL;
	GFile* parent;
	gboolean _tmp18_ = FALSE;
	gint _tmp20_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (!self->priv->modified) {
		return;
	}
	_tmp0_ = most_used_symbols_get_xml_file (self);
	file = _tmp0_;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) self->priv->most_used_symbols);
	if (_tmp1_ == 0) {
		utils_delete_file (file);
		_g_object_unref0 (file);
		return;
	}
	_tmp2_ = g_strdup ("<symbols>\n");
	content = _tmp2_;
	{
		GeeLinkedList* _tmp3_;
		GeeLinkedList* _symbol_list;
		gint _tmp4_;
		gint _symbol_size;
		gint _symbol_index;
		_tmp3_ = _g_object_ref0 (self->priv->most_used_symbols);
		_symbol_list = _tmp3_;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _symbol_list);
		_symbol_size = _tmp4_;
		_symbol_index = -1;
		while (TRUE) {
			gpointer _tmp5_ = NULL;
			MostUsedSymbol* _tmp6_;
			MostUsedSymbol _tmp7_;
			MostUsedSymbol _tmp8_ = {0};
			MostUsedSymbol _tmp9_;
			MostUsedSymbol symbol;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_symbol_index = _symbol_index + 1;
			if (!(_symbol_index < _symbol_size)) {
				break;
			}
			_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) _symbol_list, _symbol_index);
			_tmp6_ = (MostUsedSymbol*) _tmp5_;
			most_used_symbol_copy (_tmp6_, &_tmp8_);
			_tmp7_ = _tmp8_;
			_tmp9_ = _tmp7_;
			_most_used_symbol_free0 (_tmp6_);
			symbol = _tmp9_;
			_tmp10_ = g_strdup (symbol.package_required);
			_tmp11_ = _tmp10_;
			if (_tmp11_ == NULL) {
				gchar* _tmp12_;
				_tmp12_ = g_strdup ("");
				_g_free0 (_tmp11_);
				_tmp11_ = _tmp12_;
			}
			_tmp13_ = g_strdup_printf ("  <symbol id=\"%s\" command=\"%s\" package=\"%s\" num=\"%u\" />\n", symbol.id, symbol.latex_command, _tmp11_, symbol.num);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strconcat (content, _tmp14_, NULL);
			_g_free0 (content);
			content = _tmp15_;
			_g_free0 (_tmp14_);
			_g_free0 (_tmp11_);
			most_used_symbol_destroy (&symbol);
		}
		_g_object_unref0 (_symbol_list);
	}
	_tmp16_ = g_strconcat (content, "</symbols>\n", NULL);
	_g_free0 (content);
	content = _tmp16_;
	_tmp17_ = g_file_get_parent (file);
	parent = _tmp17_;
	if (parent != NULL) {
		gboolean _tmp19_;
		_tmp19_ = g_file_query_exists (parent, NULL);
		_tmp18_ = !_tmp19_;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		g_file_make_directory_with_parents (parent, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parent);
			goto __catch50_g_error;
		}
	}
	_tmp20_ = strlen (content);
	g_file_replace_contents (file, content, (gsize) _tmp20_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (parent);
		goto __catch50_g_error;
	}
	_g_object_unref0 (parent);
	goto __finally50;
	__catch50_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("most_used_symbols.vala:256: Impossible to save the most used symbols: " \
"%s", e->message);
		_g_error_free0 (e);
	}
	__finally50:
	if (_inner_error_ != NULL) {
		_g_free0 (content);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (content);
	_g_object_unref0 (file);
}


static void most_used_symbols_class_init (MostUsedSymbolsClass * klass) {
	most_used_symbols_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MostUsedSymbolsPrivate));
	G_OBJECT_CLASS (klass)->finalize = most_used_symbols_finalize;
}


static void most_used_symbols_instance_init (MostUsedSymbols * self) {
	self->priv = MOST_USED_SYMBOLS_GET_PRIVATE (self);
	self->priv->modified = FALSE;
}


static void most_used_symbols_finalize (GObject* obj) {
	MostUsedSymbols * self;
	self = MOST_USED_SYMBOLS (obj);
	_g_object_unref0 (self->priv->most_used_symbols);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (most_used_symbols_parent_class)->finalize (obj);
}


GType most_used_symbols_get_type (void) {
	static volatile gsize most_used_symbols_type_id__volatile = 0;
	if (g_once_init_enter (&most_used_symbols_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MostUsedSymbolsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) most_used_symbols_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MostUsedSymbols), 0, (GInstanceInitFunc) most_used_symbols_instance_init, NULL };
		GType most_used_symbols_type_id;
		most_used_symbols_type_id = g_type_register_static (G_TYPE_OBJECT, "MostUsedSymbols", &g_define_type_info, 0);
		g_once_init_leave (&most_used_symbols_type_id__volatile, most_used_symbols_type_id);
	}
	return most_used_symbols_type_id__volatile;
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



