/* build_view.c generated by valac 0.12.1, the Vala compiler
 * generated from build_view.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gtksourceview/gtksourceview.h>


#define TYPE_PARTITION_STATE (partition_state_get_type ())

#define TYPE_BUILD_MESSAGE_TYPE (build_message_type_get_type ())

#define TYPE_BUILD_ISSUE (build_issue_get_type ())
typedef struct _BuildIssue BuildIssue;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_BUILD_VIEW (build_view_get_type ())
#define BUILD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_VIEW, BuildView))
#define BUILD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_VIEW, BuildViewClass))
#define IS_BUILD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_VIEW))
#define IS_BUILD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_VIEW))
#define BUILD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_VIEW, BuildViewClass))

typedef struct _BuildView BuildView;
typedef struct _BuildViewClass BuildViewClass;
typedef struct _BuildViewPrivate BuildViewPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define BUILD_VIEW_TYPE_BUILD_INFO (build_view_build_info_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

typedef enum  {
	PARTITION_STATE_RUNNING,
	PARTITION_STATE_SUCCEEDED,
	PARTITION_STATE_FAILED,
	PARTITION_STATE_ABORTED
} PartitionState;

typedef enum  {
	BUILD_MESSAGE_TYPE_ERROR,
	BUILD_MESSAGE_TYPE_WARNING,
	BUILD_MESSAGE_TYPE_BADBOX,
	BUILD_MESSAGE_TYPE_OTHER
} BuildMessageType;

struct _BuildIssue {
	gchar* message;
	BuildMessageType message_type;
	gchar* filename;
	gint start_line;
	gint end_line;
};

struct _BuildView {
	GtkHBox parent_instance;
	BuildViewPrivate * priv;
};

struct _BuildViewClass {
	GtkHBoxClass parent_class;
};

struct _BuildViewPrivate {
	MainWindow* main_window;
	GtkTreeStore* store;
	GtkTreeView* view;
	GtkToggleAction* action_view_bottom_panel;
};

typedef enum  {
	BUILD_VIEW_BUILD_INFO_ICON,
	BUILD_VIEW_BUILD_INFO_MESSAGE,
	BUILD_VIEW_BUILD_INFO_MESSAGE_TYPE,
	BUILD_VIEW_BUILD_INFO_WEIGHT,
	BUILD_VIEW_BUILD_INFO_BASENAME,
	BUILD_VIEW_BUILD_INFO_FILENAME,
	BUILD_VIEW_BUILD_INFO_START_LINE,
	BUILD_VIEW_BUILD_INFO_END_LINE,
	BUILD_VIEW_BUILD_INFO_LINE,
	BUILD_VIEW_BUILD_INFO_N_COLUMNS
} BuildViewBuildInfo;


static gpointer build_view_parent_class = NULL;

GType partition_state_get_type (void) G_GNUC_CONST;
GType build_message_type_get_type (void) G_GNUC_CONST;
GType build_issue_get_type (void) G_GNUC_CONST;
BuildIssue* build_issue_dup (const BuildIssue* self);
void build_issue_free (BuildIssue* self);
void build_issue_copy (const BuildIssue* self, BuildIssue* dest);
void build_issue_destroy (BuildIssue* self);
GType build_view_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
#define BUILD_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BUILD_VIEW, BuildViewPrivate))
enum  {
	BUILD_VIEW_DUMMY_PROPERTY
};
static GType build_view_build_info_get_type (void) G_GNUC_UNUSED;
BuildView* build_view_new (MainWindow* main_window, GtkToolbar* toolbar, GtkToggleAction* view_bottom_panel);
BuildView* build_view_construct (GType object_type, MainWindow* main_window, GtkToolbar* toolbar, GtkToggleAction* view_bottom_panel);
static gboolean build_view_on_row_selection (BuildView* self, GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected);
static gboolean _build_view_on_row_selection_gtk_tree_selection_func (GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected, gpointer self);
static void _lambda46_ (BuildView* self);
static void __lambda46__gtk_button_clicked (GtkButton* _sender, gpointer self);
GtkWidget* utils_add_scrollbar (GtkWidget* child);
static void build_view_jump_to_file (BuildView* self, const gchar* filename, gint start_line, gint end_line);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_open_document (MainWindow* self, GFile* location);
GType document_get_type (void) G_GNUC_CONST;
Document* document_tab_get_document (DocumentTab* self);
void document_select_lines (Document* self, gint start, gint end);
void build_view_clear (BuildView* self);
void build_view_add_partition (BuildView* self, const gchar* msg, PartitionState state, GtkTreeIter* parent, gboolean bold, GtkTreeIter* result);
static gchar* build_view_get_icon_from_state (BuildView* self, PartitionState state);
void build_view_set_partition_state (BuildView* self, GtkTreeIter* partition_id, PartitionState state);
void build_view_append_issues (BuildView* self, GtkTreeIter* partition_id, BuildIssue* issues, int issues_length1);
static gchar* build_view_get_icon_from_msg_type (BuildView* self, BuildMessageType type);
void build_view_show (BuildView* self);
static void build_view_finalize (GObject* obj);


GType partition_state_get_type (void) {
	static volatile gsize partition_state_type_id__volatile = 0;
	if (g_once_init_enter (&partition_state_type_id__volatile)) {
		static const GEnumValue values[] = {{PARTITION_STATE_RUNNING, "PARTITION_STATE_RUNNING", "running"}, {PARTITION_STATE_SUCCEEDED, "PARTITION_STATE_SUCCEEDED", "succeeded"}, {PARTITION_STATE_FAILED, "PARTITION_STATE_FAILED", "failed"}, {PARTITION_STATE_ABORTED, "PARTITION_STATE_ABORTED", "aborted"}, {0, NULL, NULL}};
		GType partition_state_type_id;
		partition_state_type_id = g_enum_register_static ("PartitionState", values);
		g_once_init_leave (&partition_state_type_id__volatile, partition_state_type_id);
	}
	return partition_state_type_id__volatile;
}


GType build_message_type_get_type (void) {
	static volatile gsize build_message_type_type_id__volatile = 0;
	if (g_once_init_enter (&build_message_type_type_id__volatile)) {
		static const GEnumValue values[] = {{BUILD_MESSAGE_TYPE_ERROR, "BUILD_MESSAGE_TYPE_ERROR", "error"}, {BUILD_MESSAGE_TYPE_WARNING, "BUILD_MESSAGE_TYPE_WARNING", "warning"}, {BUILD_MESSAGE_TYPE_BADBOX, "BUILD_MESSAGE_TYPE_BADBOX", "badbox"}, {BUILD_MESSAGE_TYPE_OTHER, "BUILD_MESSAGE_TYPE_OTHER", "other"}, {0, NULL, NULL}};
		GType build_message_type_type_id;
		build_message_type_type_id = g_enum_register_static ("BuildMessageType", values);
		g_once_init_leave (&build_message_type_type_id__volatile, build_message_type_type_id);
	}
	return build_message_type_type_id__volatile;
}


void build_issue_copy (const BuildIssue* self, BuildIssue* dest) {
	dest->message = g_strdup (self->message);
	dest->message_type = self->message_type;
	dest->filename = g_strdup (self->filename);
	dest->start_line = self->start_line;
	dest->end_line = self->end_line;
}


void build_issue_destroy (BuildIssue* self) {
	_g_free0 ((*self).message);
	_g_free0 ((*self).filename);
}


BuildIssue* build_issue_dup (const BuildIssue* self) {
	BuildIssue* dup;
	dup = g_new0 (BuildIssue, 1);
	build_issue_copy (self, dup);
	return dup;
}


void build_issue_free (BuildIssue* self) {
	build_issue_destroy (self);
	g_free (self);
}


GType build_issue_get_type (void) {
	static volatile gsize build_issue_type_id__volatile = 0;
	if (g_once_init_enter (&build_issue_type_id__volatile)) {
		GType build_issue_type_id;
		build_issue_type_id = g_boxed_type_register_static ("BuildIssue", (GBoxedCopyFunc) build_issue_dup, (GBoxedFreeFunc) build_issue_free);
		g_once_init_leave (&build_issue_type_id__volatile, build_issue_type_id);
	}
	return build_issue_type_id__volatile;
}


static GType build_view_build_info_get_type (void) {
	static volatile gsize build_view_build_info_type_id__volatile = 0;
	if (g_once_init_enter (&build_view_build_info_type_id__volatile)) {
		static const GEnumValue values[] = {{BUILD_VIEW_BUILD_INFO_ICON, "BUILD_VIEW_BUILD_INFO_ICON", "icon"}, {BUILD_VIEW_BUILD_INFO_MESSAGE, "BUILD_VIEW_BUILD_INFO_MESSAGE", "message"}, {BUILD_VIEW_BUILD_INFO_MESSAGE_TYPE, "BUILD_VIEW_BUILD_INFO_MESSAGE_TYPE", "message-type"}, {BUILD_VIEW_BUILD_INFO_WEIGHT, "BUILD_VIEW_BUILD_INFO_WEIGHT", "weight"}, {BUILD_VIEW_BUILD_INFO_BASENAME, "BUILD_VIEW_BUILD_INFO_BASENAME", "basename"}, {BUILD_VIEW_BUILD_INFO_FILENAME, "BUILD_VIEW_BUILD_INFO_FILENAME", "filename"}, {BUILD_VIEW_BUILD_INFO_START_LINE, "BUILD_VIEW_BUILD_INFO_START_LINE", "start-line"}, {BUILD_VIEW_BUILD_INFO_END_LINE, "BUILD_VIEW_BUILD_INFO_END_LINE", "end-line"}, {BUILD_VIEW_BUILD_INFO_LINE, "BUILD_VIEW_BUILD_INFO_LINE", "line"}, {BUILD_VIEW_BUILD_INFO_N_COLUMNS, "BUILD_VIEW_BUILD_INFO_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType build_view_build_info_type_id;
		build_view_build_info_type_id = g_enum_register_static ("BuildViewBuildInfo", values);
		g_once_init_leave (&build_view_build_info_type_id__volatile, build_view_build_info_type_id);
	}
	return build_view_build_info_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _build_view_on_row_selection_gtk_tree_selection_func (GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected, gpointer self) {
	gboolean result;
	result = build_view_on_row_selection (self, selection, model, path, path_currently_selected);
	return result;
}


static void _lambda46_ (BuildView* self) {
	gtk_widget_hide ((GtkWidget*) self);
	gtk_toggle_action_set_active (self->priv->action_view_bottom_panel, FALSE);
}


static void __lambda46__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda46_ (self);
}


BuildView* build_view_construct (GType object_type, MainWindow* main_window, GtkToolbar* toolbar, GtkToggleAction* view_bottom_panel) {
	BuildView * self = NULL;
	GtkTreeStore* _tmp0_ = NULL;
	GtkTreeView* _tmp1_ = NULL;
	GtkTreeViewColumn* _tmp2_ = NULL;
	GtkTreeViewColumn* column_job;
	const gchar* _tmp3_ = NULL;
	GtkCellRendererPixbuf* _tmp4_ = NULL;
	GtkCellRendererPixbuf* renderer_pixbuf;
	GtkCellRendererText* _tmp5_ = NULL;
	GtkCellRendererText* renderer_text;
	const gchar* _tmp6_ = NULL;
	GtkCellRendererText* _tmp7_ = NULL;
	GtkCellRendererText* _tmp8_;
	const gchar* _tmp9_ = NULL;
	GtkCellRendererText* _tmp10_ = NULL;
	GtkCellRendererText* _tmp11_;
	GtkTreeSelection* _tmp12_ = NULL;
	GtkTreeSelection* _tmp13_;
	GtkTreeSelection* select;
	GtkButton* _tmp14_ = NULL;
	GtkButton* close_button;
	const gchar* _tmp15_ = NULL;
	GtkImage* _tmp16_ = NULL;
	GtkImage* _tmp17_;
	GtkWidget* _tmp18_ = NULL;
	GtkWidget* sw;
	GtkVBox* _tmp19_ = NULL;
	GtkVBox* vbox;
	g_return_val_if_fail (main_window != NULL, NULL);
	g_return_val_if_fail (toolbar != NULL, NULL);
	g_return_val_if_fail (view_bottom_panel != NULL, NULL);
	self = (BuildView*) g_object_new (object_type, NULL);
	self->priv->main_window = main_window;
	self->priv->action_view_bottom_panel = view_bottom_panel;
	_tmp0_ = gtk_tree_store_new ((gint) BUILD_VIEW_BUILD_INFO_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, TYPE_BUILD_MESSAGE_TYPE, G_TYPE_INT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INT, G_TYPE_INT, G_TYPE_STRING);
	_g_object_unref0 (self->priv->store);
	self->priv->store = _tmp0_;
	_tmp1_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) self->priv->store);
	_g_object_unref0 (self->priv->view);
	self->priv->view = g_object_ref_sink (_tmp1_);
	_tmp2_ = gtk_tree_view_column_new ();
	column_job = g_object_ref_sink (_tmp2_);
	_tmp3_ = _ ("Job");
	gtk_tree_view_column_set_title (column_job, _tmp3_);
	_tmp4_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	renderer_pixbuf = g_object_ref_sink (_tmp4_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) column_job, (GtkCellRenderer*) renderer_pixbuf, FALSE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column_job, (GtkCellRenderer*) renderer_pixbuf, "stock-id", (gint) BUILD_VIEW_BUILD_INFO_ICON);
	_tmp5_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	renderer_text = g_object_ref_sink (_tmp5_);
	g_object_set (renderer_text, "weight-set", TRUE, NULL);
	gtk_cell_layout_pack_start ((GtkCellLayout*) column_job, (GtkCellRenderer*) renderer_text, TRUE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column_job, (GtkCellRenderer*) renderer_text, "text", (gint) BUILD_VIEW_BUILD_INFO_MESSAGE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column_job, (GtkCellRenderer*) renderer_text, "weight", (gint) BUILD_VIEW_BUILD_INFO_WEIGHT);
	gtk_tree_view_append_column (self->priv->view, column_job);
	_tmp6_ = _ ("File");
	_tmp7_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp8_ = g_object_ref_sink (_tmp7_);
	gtk_tree_view_insert_column_with_attributes (self->priv->view, -1, _tmp6_, (GtkCellRenderer*) _tmp8_, "text", BUILD_VIEW_BUILD_INFO_BASENAME, NULL);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = _ ("Line");
	_tmp10_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp11_ = g_object_ref_sink (_tmp10_);
	gtk_tree_view_insert_column_with_attributes (self->priv->view, -1, _tmp9_, (GtkCellRenderer*) _tmp11_, "text", BUILD_VIEW_BUILD_INFO_LINE, NULL);
	_g_object_unref0 (_tmp11_);
	gtk_tree_view_set_tooltip_column (self->priv->view, (gint) BUILD_VIEW_BUILD_INFO_FILENAME);
	_tmp12_ = gtk_tree_view_get_selection (self->priv->view);
	_tmp13_ = _g_object_ref0 (_tmp12_);
	select = _tmp13_;
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	gtk_tree_selection_set_select_function (select, _build_view_on_row_selection_gtk_tree_selection_func, g_object_ref (self), g_object_unref);
	_tmp14_ = (GtkButton*) gtk_button_new ();
	close_button = g_object_ref_sink (_tmp14_);
	gtk_button_set_relief (close_button, GTK_RELIEF_NONE);
	gtk_button_set_focus_on_click (close_button, FALSE);
	_tmp15_ = _ ("Hide panel");
	gtk_widget_set_tooltip_text ((GtkWidget*) close_button, _tmp15_);
	_tmp16_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_CLOSE, GTK_ICON_SIZE_MENU);
	_tmp17_ = g_object_ref_sink (_tmp16_);
	gtk_container_add ((GtkContainer*) close_button, (GtkWidget*) _tmp17_);
	_g_object_unref0 (_tmp17_);
	g_signal_connect_object (close_button, "clicked", (GCallback) __lambda46__gtk_button_clicked, self, 0);
	_tmp18_ = utils_add_scrollbar ((GtkWidget*) self->priv->view);
	sw = _tmp18_;
	gtk_box_pack_start ((GtkBox*) self, sw, TRUE, TRUE, (guint) 0);
	_tmp19_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
	vbox = g_object_ref_sink (_tmp19_);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) close_button, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) vbox, (GtkWidget*) toolbar, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) vbox, FALSE, FALSE, (guint) 0);
	_g_object_unref0 (vbox);
	_g_object_unref0 (sw);
	_g_object_unref0 (close_button);
	_g_object_unref0 (select);
	_g_object_unref0 (renderer_text);
	_g_object_unref0 (renderer_pixbuf);
	_g_object_unref0 (column_job);
	return self;
}


BuildView* build_view_new (MainWindow* main_window, GtkToolbar* toolbar, GtkToggleAction* view_bottom_panel) {
	return build_view_construct (TYPE_BUILD_VIEW, main_window, toolbar, view_bottom_panel);
}


static gboolean build_view_on_row_selection (BuildView* self, GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected) {
	gboolean result = FALSE;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (selection != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp1_ = gtk_tree_model_get_iter (model, &_tmp0_, path);
	iter = _tmp0_;
	if (_tmp1_) {
		BuildMessageType msg_type = 0;
		gchar* filename = NULL;
		gint start_line = 0;
		gint end_line = 0;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gtk_tree_model_get (model, &iter, BUILD_VIEW_BUILD_INFO_MESSAGE_TYPE, &msg_type, BUILD_VIEW_BUILD_INFO_FILENAME, &filename, BUILD_VIEW_BUILD_INFO_START_LINE, &start_line, BUILD_VIEW_BUILD_INFO_END_LINE, &end_line, -1, -1);
		if (msg_type != BUILD_MESSAGE_TYPE_OTHER) {
			_tmp3_ = filename != NULL;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			gint _tmp4_;
			_tmp4_ = strlen (filename);
			_tmp2_ = _tmp4_ > 0;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			build_view_jump_to_file (self, filename, start_line, end_line);
			result = TRUE;
			_g_free0 (filename);
			return result;
		} else {
			if (msg_type == BUILD_MESSAGE_TYPE_OTHER) {
				gboolean _tmp5_;
				_tmp5_ = gtk_tree_model_iter_has_child (model, &iter);
				if (_tmp5_) {
					gboolean _tmp6_;
					_tmp6_ = gtk_tree_view_row_expanded (self->priv->view, path);
					if (_tmp6_) {
						gtk_tree_view_collapse_row (self->priv->view, path);
					} else {
						gtk_tree_view_expand_to_path (self->priv->view, path);
					}
				}
			}
		}
		_g_free0 (filename);
	}
	result = FALSE;
	return result;
}


static void build_view_jump_to_file (BuildView* self, const gchar* filename, gint start_line, gint end_line) {
	GFile* _tmp0_ = NULL;
	GFile* file;
	DocumentTab* _tmp1_ = NULL;
	DocumentTab* tab;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_tmp0_ = g_file_new_for_path (filename);
	file = _tmp0_;
	_tmp1_ = main_window_open_document (self->priv->main_window, file);
	tab = _tmp1_;
	if (start_line != (-1)) {
		gint _tmp2_ = 0;
		gint end;
		Document* _tmp3_ = NULL;
		if (end_line != (-1)) {
			_tmp2_ = end_line - 1;
		} else {
			_tmp2_ = start_line;
		}
		end = _tmp2_;
		_tmp3_ = document_tab_get_document (tab);
		document_select_lines (_tmp3_, start_line - 1, end);
	}
	_g_object_unref0 (tab);
	_g_object_unref0 (file);
}


void build_view_clear (BuildView* self) {
	g_return_if_fail (self != NULL);
	gtk_tree_store_clear (self->priv->store);
	gtk_tree_view_columns_autosize (self->priv->view);
}


void build_view_add_partition (BuildView* self, const gchar* msg, PartitionState state, GtkTreeIter* parent, gboolean bold, GtkTreeIter* result) {
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	gtk_tree_store_append (self->priv->store, &_tmp0_, parent);
	iter = _tmp0_;
	if (bold) {
		_tmp1_ = 800;
	} else {
		_tmp1_ = 400;
	}
	_tmp2_ = build_view_get_icon_from_state (self, state);
	_tmp3_ = _tmp2_;
	gtk_tree_store_set (self->priv->store, &iter, BUILD_VIEW_BUILD_INFO_ICON, _tmp3_, BUILD_VIEW_BUILD_INFO_MESSAGE, msg, BUILD_VIEW_BUILD_INFO_MESSAGE_TYPE, BUILD_MESSAGE_TYPE_OTHER, BUILD_VIEW_BUILD_INFO_WEIGHT, _tmp1_, -1, -1);
	_g_free0 (_tmp3_);
	gtk_tree_view_expand_all (self->priv->view);
	*result = iter;
	return;
}


void build_view_set_partition_state (BuildView* self, GtkTreeIter* partition_id, PartitionState state) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = build_view_get_icon_from_state (self, state);
	_tmp1_ = _tmp0_;
	gtk_tree_store_set (self->priv->store, partition_id, BUILD_VIEW_BUILD_INFO_ICON, _tmp1_, -1, -1);
	_g_free0 (_tmp1_);
}


void build_view_append_issues (BuildView* self, GtkTreeIter* partition_id, BuildIssue* issues, int issues_length1) {
	g_return_if_fail (self != NULL);
	{
		BuildIssue* issue_collection;
		int issue_collection_length1;
		int issue_it;
		issue_collection = issues;
		issue_collection_length1 = issues_length1;
		for (issue_it = 0; issue_it < issues_length1; issue_it = issue_it + 1) {
			BuildIssue _tmp0_;
			BuildIssue _tmp1_ = {0};
			BuildIssue issue;
			build_issue_copy (&issue_collection[issue_it], &_tmp1_);
			_tmp0_ = _tmp1_;
			issue = _tmp0_;
			{
				GtkTreeIter iter = {0};
				GtkTreeIter _tmp2_ = {0};
				gchar* _tmp3_ = NULL;
				gchar* _tmp5_ = NULL;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				gtk_tree_store_append (self->priv->store, &_tmp2_, partition_id);
				iter = _tmp2_;
				if (issue.filename != NULL) {
					gchar* _tmp4_ = NULL;
					_tmp4_ = g_path_get_basename (issue.filename);
					_g_free0 (_tmp3_);
					_tmp3_ = _tmp4_;
				} else {
					_g_free0 (_tmp3_);
					_tmp3_ = NULL;
				}
				if (issue.start_line != (-1)) {
					gchar* _tmp6_ = NULL;
					_tmp6_ = g_strdup_printf ("%i", issue.start_line);
					_g_free0 (_tmp5_);
					_tmp5_ = _tmp6_;
				} else {
					_g_free0 (_tmp5_);
					_tmp5_ = NULL;
				}
				_tmp7_ = build_view_get_icon_from_msg_type (self, issue.message_type);
				_tmp8_ = _tmp7_;
				gtk_tree_store_set (self->priv->store, &iter, BUILD_VIEW_BUILD_INFO_ICON, _tmp8_, BUILD_VIEW_BUILD_INFO_MESSAGE, issue.message, BUILD_VIEW_BUILD_INFO_MESSAGE_TYPE, issue.message_type, BUILD_VIEW_BUILD_INFO_WEIGHT, 400, BUILD_VIEW_BUILD_INFO_BASENAME, _tmp3_, BUILD_VIEW_BUILD_INFO_FILENAME, issue.filename, BUILD_VIEW_BUILD_INFO_START_LINE, issue.start_line, BUILD_VIEW_BUILD_INFO_END_LINE, issue.end_line, BUILD_VIEW_BUILD_INFO_LINE, _tmp5_, -1, -1);
				_g_free0 (_tmp8_);
				_g_free0 (_tmp5_);
				_g_free0 (_tmp3_);
				build_issue_destroy (&issue);
			}
		}
	}
	gtk_tree_view_expand_all (self->priv->view);
}


static gchar* build_view_get_icon_from_state (BuildView* self, PartitionState state) {
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	switch (state) {
		case PARTITION_STATE_RUNNING:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (GTK_STOCK_EXECUTE);
			result = _tmp0_;
			return result;
		}
		case PARTITION_STATE_SUCCEEDED:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (GTK_STOCK_APPLY);
			result = _tmp1_;
			return result;
		}
		case PARTITION_STATE_FAILED:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (GTK_STOCK_DIALOG_ERROR);
			result = _tmp2_;
			return result;
		}
		case PARTITION_STATE_ABORTED:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (GTK_STOCK_STOP);
			result = _tmp3_;
			return result;
		}
		default:
		{
			g_return_val_if_reached (NULL);
		}
	}
}


static gchar* build_view_get_icon_from_msg_type (BuildView* self, BuildMessageType type) {
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	switch (type) {
		case BUILD_MESSAGE_TYPE_ERROR:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (GTK_STOCK_DIALOG_ERROR);
			result = _tmp0_;
			return result;
		}
		case BUILD_MESSAGE_TYPE_WARNING:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (GTK_STOCK_DIALOG_WARNING);
			result = _tmp1_;
			return result;
		}
		case BUILD_MESSAGE_TYPE_BADBOX:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("badbox");
			result = _tmp2_;
			return result;
		}
		case BUILD_MESSAGE_TYPE_OTHER:
		{
			result = NULL;
			return result;
		}
		default:
		{
			g_return_val_if_reached (NULL);
		}
	}
}


void build_view_show (BuildView* self) {
	g_return_if_fail (self != NULL);
	GTK_WIDGET_CLASS (build_view_parent_class)->show ((GtkWidget*) GTK_HBOX (self));
	gtk_toggle_action_set_active (self->priv->action_view_bottom_panel, TRUE);
}


static void build_view_class_init (BuildViewClass * klass) {
	build_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BuildViewPrivate));
	G_OBJECT_CLASS (klass)->finalize = build_view_finalize;
}


static void build_view_instance_init (BuildView * self) {
	self->priv = BUILD_VIEW_GET_PRIVATE (self);
}


static void build_view_finalize (GObject* obj) {
	BuildView * self;
	self = BUILD_VIEW (obj);
	_g_object_unref0 (self->priv->store);
	_g_object_unref0 (self->priv->view);
	G_OBJECT_CLASS (build_view_parent_class)->finalize (obj);
}


GType build_view_get_type (void) {
	static volatile gsize build_view_type_id__volatile = 0;
	if (g_once_init_enter (&build_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BuildViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) build_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuildView), 0, (GInstanceInitFunc) build_view_instance_init, NULL };
		GType build_view_type_id;
		build_view_type_id = g_type_register_static (GTK_TYPE_HBOX, "BuildView", &g_define_type_info, 0);
		g_once_init_leave (&build_view_type_id__volatile, build_view_type_id);
	}
	return build_view_type_id__volatile;
}



