package junit.test;

import junit.framework.TestCase;
import latexDraw.parsers.ParserCmdMessage;

import org.junit.Test;


/** 
 * This class contains tests for the ParserCmdMessage class.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 10/10/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
@SuppressWarnings("nls")
public class TestParserCmdMessage extends TestCase
{
	public static final String COMMAND 	= "command";
	
	public static final Exception EX 	= new IllegalArgumentException("Test exception");
	
	public static final int LINE 		= 10;
	
	public static final ParserCmdMessage MSG = new ParserCmdMessage(LINE, EX, COMMAND);
	

	@Test
	public void testToString()
	{
		ParserCmdMessage m = new ParserCmdMessage(-1, null, null);
		
		m.toString();
		MSG.toString();
	}
	
	
	@Test
	public void testGetLine()
	{
		assertEquals(LINE, MSG.getNLine());
	}
	
	
	@Test
	public void testGetException()
	{
		assertEquals(EX, MSG.getException());
	}
	
	
	@Test
	public void testGetCommand()
	{
		assertEquals(COMMAND, MSG.getCommand());
	}
}
