package latexDraw.ui.codeEditorPane;

import static latexDraw.ui.CodePanel.TOKEN_HORI_CENTER_END;
import static latexDraw.ui.CodePanel.TOKEN_HORI_CENTER_START;

import java.util.Calendar;

import latexDraw.ui.CodePanel;
import latexDraw.ui.LaTeXDrawFrame;
import latexDraw.util.LaTeXDrawPoint2D;
import latexDraw.util.LaTeXDrawResources;

/** 
 * Defines the model of a code editor pane used which display PSTricks code.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 06/03/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class PSTricksEditorPane extends AbstractCodeEditorPane
{
	private static final long serialVersionUID = 1L;

	/** The line code which include the package pstricks */
	public static final String PACKAGE_PSTRICKS = "% \\usepackage[usenames,dvipsnames]{pstricks}\n% \\usepackage{epsfig}\n% \\usepackage{pst-grad} % For gradients\n% \\usepackage{pst-plot} % For axes\n"; //$NON-NLS-1$
	
	
	
	/**
	 * The constructor.
	 * @param codePanel The associated codePanel.
	 */
	public PSTricksEditorPane(CodePanel codePanel)
	{
		super(codePanel);
	}
	
	
	

	@Override
	public void updateText()
	{
		String seol = System.getProperty("line.separator");//$NON-NLS-1$ 
		
		if(body==null || body=="") //$NON-NLS-1$
			setText(codePanel.getComments());
		else
		{
			boolean addEntete;
			StringBuffer entete = new StringBuffer();
			StringBuffer end    = new StringBuffer();
			
			if(!codePanel.getCaption().equals("") || !codePanel.getLabel().equals("") || //$NON-NLS-1$ //$NON-NLS-2$
			   !codePanel.getPositionVertToken().equals("")) //$NON-NLS-1$
			{
				 addEntete = true;
				 entete.append("\\begin{figure}"); //$NON-NLS-1$
				 
				 if(!codePanel.getPositionVertToken().equals("")) //$NON-NLS-1$
					 entete.append("[").append(codePanel.getPositionVertToken()).append("]"); //$NON-NLS-1$ //$NON-NLS-2$
				 
				 entete.append(seol);
			}
			else
				addEntete = false;
			
			if(addEntete)
			{
				if(!codePanel.getLabel().equals("")) //$NON-NLS-1$
				{
					String lab = codePanel.getLabel().replaceAll("%", ""); //$NON-NLS-1$ //$NON-NLS-2$
					lab = lab.replaceAll("\\\\", ""); //$NON-NLS-1$ //$NON-NLS-2$
					end.append("\\label{").append(lab).append("}").append(seol); //$NON-NLS-1$ //$NON-NLS-2$
				}
				
				if(!codePanel.getCaption().equals("")) //$NON-NLS-1$
					end.append("\\caption{").append(codePanel.getCaption()).append("}").append(seol);//$NON-NLS-1$//$NON-NLS-2$
				
				end.append("\\end{figure}").append(seol); //$NON-NLS-1$
			}
			
			if(codePanel.getPositionHoriToken().equals(TOKEN_HORI_CENTER_START))
				end.insert(0, TOKEN_HORI_CENTER_END);
			
			StringBuffer madeBy = new StringBuffer();
			
			madeBy.append("% Generated with "); //$NON-NLS-1$
			madeBy.append(LaTeXDrawResources.LABEL_APP);
			madeBy.append(" "); //$NON-NLS-1$
			madeBy.append(LaTeXDrawFrame.VERSION);
			madeBy.append(seol);
			madeBy.append("% "); //$NON-NLS-1$
			madeBy.append(Calendar.getInstance().getTime().toString());
			madeBy.append(seol);
			
			StringBuffer stringBuffer = new StringBuffer();
			stringBuffer.append(body);
			stringBuffer.append(endCodeTag);
			stringBuffer.append("}\n"); //$NON-NLS-1$
			stringBuffer.append(end);
			String text = stringBuffer.toString();
			
			// We despecialise all the "%".
			text = text.replaceAll("%", "\\\\%");     //$NON-NLS-1$ //$NON-NLS-2$
			text = text.replaceAll(seol+"\\\\%", seol+"\\%"); //$NON-NLS-1$ //$NON-NLS-2$
			
			stringBuffer = new StringBuffer();
			stringBuffer.append(madeBy);
			stringBuffer.append(codePanel.getComments());
			stringBuffer.append(PACKAGE_PSTRICKS);
			stringBuffer.append(entete);
			stringBuffer.append(codePanel.getPositionHoriToken());
			stringBuffer.append(begin);
			stringBuffer.append(text);
			
			setText(stringBuffer.toString());
		}
	}



	@Override
	protected void setBeginCodeTag()
	{
		beginCodeTag = "\\begin{pspicture}"; //$NON-NLS-1$
	}



	@Override
	protected void setEndCodeTag()
	{
		endCodeTag = "\\end{pspicture} \n"; //$NON-NLS-1$
	}



	@Override
	public void setStart(LaTeXDrawPoint2D SW, LaTeXDrawPoint2D NE, float pixPerCm, LaTeXDrawPoint2D origin)
	{
		StringBuffer stringBuffer = new StringBuffer();
		
		stringBuffer.append("\\scalebox{1} % Change this value to rescale the drawing.\n{\n"); //$NON-NLS-1$
		stringBuffer.append(beginCodeTag);
		stringBuffer.append("("); //$NON-NLS-1$
		stringBuffer.append(0);
		stringBuffer.append(","); //$NON-NLS-1$
		stringBuffer.append((float)((origin.y-SW.y)/pixPerCm));
		stringBuffer.append(")"); //$NON-NLS-1$
		stringBuffer.append("("); //$NON-NLS-1$
		stringBuffer.append((float)((NE.x-origin.x)/pixPerCm));
		stringBuffer.append(",");  //$NON-NLS-1$ 
		stringBuffer.append((float)((origin.y-NE.y)/pixPerCm));
		stringBuffer.append(")\n"); //$NON-NLS-1$
		begin = stringBuffer.toString(); 

		updateText();
	}
}
